import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement, Operator } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [notifications-contacts](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsusernotificationscontacts.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class NotificationsContacts extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to activate the email contact associated with the given ARN if the provided code is valid
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/notifications/latest/userguide/resource-level-permissions.html
     */
    toActivateEmailContact(): this;
    /**
     * Grants permission to create an email contact
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/notifications/latest/userguide/resource-level-permissions.html
     */
    toCreateEmailContact(): this;
    /**
     * Grants permission to delete an email contact associated with the given ARN
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/notifications/latest/userguide/resource-level-permissions.html
     */
    toDeleteEmailContact(): this;
    /**
     * Grants permission to get an email contact associated with the given ARN
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/notifications/latest/userguide/resource-level-permissions.html
     */
    toGetEmailContact(): this;
    /**
     * Grants permission to list email contacts
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/notifications/latest/userguide/resource-level-permissions.html
     */
    toListEmailContacts(): this;
    /**
     * Grants permission to get tags for a resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/notifications/latest/userguide/resource-level-permissions.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to send an activation link to the email associated with the given ARN
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/notifications/latest/userguide/resource-level-permissions.html
     */
    toSendActivationCode(): this;
    /**
     * Grants permission to tag a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/notifications/latest/userguide/resource-level-permissions.html
     */
    toTagResource(): this;
    /**
     * Grants permission to remove tags from a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/notifications/latest/userguide/resource-level-permissions.html
     */
    toUntagResource(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type EmailContactResource to the statement
     *
     * https://docs.aws.amazon.com/notifications/latest/userguide/resource-level-permissions.html
     *
     * @param emailContactId - Identifier for the emailContactId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onEmailContactResource(emailContactId: string, account?: string, partition?: string): this;
    /**
     * Filters access by the tags that are passed in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-requesttag
     *
     * Applies to actions:
     * - .toCreateEmailContact()
     * - .toTagResource()
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsRequestTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the tags associated with the resource
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-resourcetag
     *
     * Applies to resource types:
     * - EmailContactResource
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsResourceTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the tag keys that are passed in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-tagkeys
     *
     * Applies to actions:
     * - .toCreateEmailContact()
     * - .toTagResource()
     * - .toUntagResource()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsTagKeys(value: string | string[], operator?: Operator | string): this;
    /**
     * Statement provider for service [notifications-contacts](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsusernotificationscontacts.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
