import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [user-subscriptions](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsusersubscriptions.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class UserSubscriptions extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to create a User subscription Claim
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifCreateForSelf()
     *
     * https://docs.aws.amazon.com/amazonq/latest/qdeveloper-ug/security_iam_permissions.html
     */
    toCreateClaim(): this;
    /**
     * Grants permission to delete a User subscription Claim
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amazonq/latest/qdeveloper-ug/security_iam_permissions.html
     */
    toDeleteClaim(): this;
    /**
     * Grants permission to list all User subscription Claims for Application
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/amazonq/latest/qdeveloper-ug/security_iam_permissions.html
     */
    toListApplicationClaims(): this;
    /**
     * Grants permission to list all User subscription Claims
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/amazonq/latest/qdeveloper-ug/security_iam_permissions.html
     */
    toListClaims(): this;
    /**
     * Grants permission to list all User subscriptions
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/amazonq/latest/qdeveloper-ug/security_iam_permissions.html
     */
    toListUserSubscriptions(): this;
    /**
     * Grants permission to update a User subscription Claim
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amazonq/latest/qdeveloper-ug/security_iam_permissions.html
     */
    toUpdateClaim(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Filters access by only allowing creation of User subscription Claims for the caller
     *
     * https://docs.aws.amazon.com/amazonq/latest/qdeveloper-ug/security-iam-service-with-iam.html#security_iam_service-with-iam-id-based-policies-conditionkeys
     *
     * Applies to actions:
     * - .toCreateClaim()
     *
     * @param value `true` or `false`. **Default:** `true`
     */
    ifCreateForSelf(value?: boolean): this;
    /**
     * Statement provider for service [user-subscriptions](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsusersubscriptions.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
