import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [verified-access](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsverifiedaccess.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class VerifiedAccess extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to create Verified Access Instance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/verified-access/latest/ug/security_iam_id-based-policy-examples.html#security_iam_id-based-policy-examples-create-instance
     */
    toAllowVerifiedAccess(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Statement provider for service [verified-access](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsverifiedaccess.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
