import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement, Operator } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [thinclient](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonworkspacesthinclient.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Thinclient extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to create environments
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     *
     * Dependent actions:
     * - appstream:DescribeStacks
     * - iam:CreateServiceLinkedRole
     * - workspaces-web:GetPortal
     * - workspaces-web:GetUserSettings
     * - workspaces:DescribeWorkspaceDirectories
     *
     * https://docs.aws.amazon.com/workspaces-thin-client/latest/api/API_CreateEnvironment.html
     */
    toCreateEnvironment(): this;
    /**
     * Grants permission to delete devices
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/workspaces-thin-client/latest/api/API_DeleteDevice.html
     */
    toDeleteDevice(): this;
    /**
     * Grants permission to delete environments
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/workspaces-thin-client/latest/api/API_DeleteEnvironment.html
     */
    toDeleteEnvironment(): this;
    /**
     * Grants permission to deregister devices
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/workspaces-thin-client/latest/api/API_DeregisterDevice.html
     */
    toDeregisterDevice(): this;
    /**
     * Grants permission to get devices
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/workspaces-thin-client/latest/api/API_GetDevice.html
     */
    toGetDevice(): this;
    /**
     * Grants permission to get details of devices
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    toGetDeviceDetails(): this;
    /**
     * Grants permission to get details of environments
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/workspaces-thin-client/latest/api/API_GetEnvironment.html
     */
    toGetEnvironment(): this;
    /**
     * Grants permission to get details of software sets
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/workspaces-thin-client/latest/api/API_GetSoftwareSet.html
     */
    toGetSoftwareSet(): this;
    /**
     * Grants permission to list device sessions
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    toListDeviceSessions(): this;
    /**
     * Grants permission to list devices
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workspaces-thin-client/latest/api/API_ListDevices.html
     */
    toListDevices(): this;
    /**
     * Grants permission to list environments
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workspaces-thin-client/latest/api/API_ListEnvironments.html
     */
    toListEnvironments(): this;
    /**
     * Grants permission to list software sets
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workspaces-thin-client/latest/api/API_ListSoftwareSets.html
     */
    toListSoftwareSets(): this;
    /**
     * Grants permission to list tags for a resource
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/workspaces-thin-client/latest/api/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to add one or more tags to a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/workspaces-thin-client/latest/api/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to remove one or more tags from a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/workspaces-thin-client/latest/api/API_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to update devices
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/workspaces-thin-client/latest/api/API_UpdateDevice.html
     */
    toUpdateDevice(): this;
    /**
     * Grants permission to update environments
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * Dependent actions:
     * - appstream:DescribeStacks
     * - workspaces-web:GetPortal
     * - workspaces-web:GetUserSettings
     * - workspaces:DescribeWorkspaceDirectories
     *
     * https://docs.aws.amazon.com/workspaces-thin-client/latest/api/API_UpdateEnvironment.html
     */
    toUpdateEnvironment(): this;
    /**
     * Grants permission to update software set
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/workspaces-thin-client/latest/api/API_UpdateSoftwareSet.html
     */
    toUpdateSoftwareSet(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type environment to the statement
     *
     * https://docs.aws.amazon.com/workspaces-thin-client/latest/api/API_Environment.html
     *
     * @param environmentId - Identifier for the environmentId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onEnvironment(environmentId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type device to the statement
     *
     * https://docs.aws.amazon.com/workspaces-thin-client/latest/api/API_Device.html
     *
     * @param deviceId - Identifier for the deviceId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onDevice(deviceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type softwareset to the statement
     *
     * https://docs.aws.amazon.com/workspaces-thin-client/latest/api/API_SoftwareSet.html
     *
     * @param softwareSetId - Identifier for the softwareSetId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onSoftwareset(softwareSetId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Filters access by the tags that are passed in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-requesttag
     *
     * Applies to actions:
     * - .toCreateEnvironment()
     * - .toTagResource()
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsRequestTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the tags associated with the resource
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-resourcetag
     *
     * Applies to actions:
     * - .toCreateEnvironment()
     * - .toDeleteDevice()
     * - .toDeleteEnvironment()
     * - .toDeregisterDevice()
     * - .toGetDevice()
     * - .toGetDeviceDetails()
     * - .toGetEnvironment()
     * - .toGetSoftwareSet()
     * - .toListDeviceSessions()
     * - .toListTagsForResource()
     * - .toTagResource()
     * - .toUntagResource()
     * - .toUpdateDevice()
     * - .toUpdateEnvironment()
     * - .toUpdateSoftwareSet()
     *
     * Applies to resource types:
     * - environment
     * - device
     * - softwareset
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsResourceTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the tag keys that are passed in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-tagkeys
     *
     * Applies to actions:
     * - .toCreateEnvironment()
     * - .toTagResource()
     * - .toUntagResource()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsTagKeys(value: string | string[], operator?: Operator | string): this;
    /**
     * Statement provider for service [thinclient](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonworkspacesthinclient.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
