ER_APPERROR_BASE						= 0x40000000	# use this mask to check for an application error defined by the McRobot framework
ER_APPERROR_CUSTOMER					= 0x80000000	# use this mask to check for an application error defined by customer code
ER_MASK_APPERROR						= 0xF0FFFFFF	# use this mask to get the application error value (without the RplId)
ER_MASK_APPERROR_TYPE					= 0xF0000000	# use this mask to check for an application error defined by the McRobot framework
ER_MASK_APPLICATION_RPL_ID				= 0x0F000000	# use this mask to extract the reply id (e.g. ok, skip, error, etc.) from the application error
ER_MASK_APPLICATION_RPL_ID_OFFSET		= 24	# use this offset to shift the RplId to the right when read from an application error, like this: uRplId = (uError & ER_MASK_APPLICATION_RPL_ID) >> ER_MASK_APPLICATION_RPL_ID_OFFSET;
ER_INCO_NO_ERROR						= 0x00000000	# ok
ER_INCO_DEPRECATED						= 0x00010000	# deprecated function or functionality
ER_INCO_REGISTRY						= 0x00010001	# error in local registry
ER_INCO_SERVER_REGISTRY					= 0x00010002	# error in server registry
ER_INCO_TARGET							= 0x00010003	# target not available
ER_INCO_MASTER_NAME						= 0x00010004	# master name not available
ER_INCO_TIMEOUT							= 0x00010005	# no answer from target
ER_INCO_TIMEOUT_SEMAPHORE				= 0x00010006	# could not reserve semaphore
ER_INCO_RESET_SEMAPHORE					= 0x00010007	# could not reset semaphore
ER_INCO_PASSWORD_REQUIRED				= 0x00010008	# password needs to be set
ER_INCO_STRING_TOO_LONG					= 0x00010009	# string too long for buffer
ER_INCO_NO_FUNCTION						= 0x00010010	# function not defined
ER_INCO_MEM_DRIVER						= 0x00010011	# server could not load memdriver
ER_INCO_TIMOUT_FRAME					= 0x00010012	# timeout while waiting for incoframe
ER_INCO_DPR_WRITE						= 0x00010013	# write error in dual-port or no target
ER_INCO_BOOT_CODE						= 0x00010014	# boot code for target not found
ER_INCO_ONLY_NUMBERS					= 0x00010016	# only numbers supported (no names)
ER_INCO_NO_PPC_AT_ADDRESS				= 0x00010017	# no PPC found at given address
ER_INCO_PLX_OPEN_FAILED					= 0x00010018	# The Plx api wasn't able to open the device at specified bus/slot
ER_INCO_SERVER_TOO_OLD					= 0x00010020	# IncoServer too old for this functionality
ER_INCO_TIMEOUT_FRAME_TCP				= 0x00010021	# timeout while waiting for incoframe in libinco_32 using Tcp/Ip
ER_INCO_TIMEOUT_TARGET_SERIALIZER			= 0x00010022	# Timeout while waiting to get exclusive access to the target communication port (within INCOServer)
ER_INCO_TARGET_COUNT_EXCEEDED			= 0x00010030	# Maximum count of target-subtarget reached. The amount of subtargets is limited.
ER_INCO_TARGET_PORT_INVALID				= 0x00010031	# Invalid target name passed to inco function
ER_INCO_TARGET_NAME_INVALID				= 0x00010032	# Invalid target name passed to inco function
ER_INCO_TARGET_ALREADY_EXISTS			= 0x00010033	# a target with this name already exists.
ER_INCO_TARGETALIAS_NAME				= 0x00010034	# No target alias with that name exists.
ER_INCO_TARGETALIAS_ALREADY_EXISTS		= 0x00010035	# a target alias with this name already exists.
ER_INCO_FRAGMENTATION_UNSUPPORTED		= 0x00010036	# Fragmented INCO frames are not supported by this target/server
ER_INCO_SERVER4_NOT_RUNNING				= 0x00010040	# incoserver 4.x is not running. Connection failed.
ER_INCO_FRAME_BUFFER_FULL				= 0x00010050	# the frame buffer is full - therfore the frame couldn't be processed.
ER_INCO_FRAME_CONVERSION_BUFFER			= 0x00010051	# The inco frame conversion failed because the frame buffer of the classic frame is too small.
ER_INCO_FRAME_DATA_SIZE_TOO_SMALL		= 0x00010052	# The data size of the inco frame is not big enough to perform the operation
ER_INCO_FRAME_FRAGMENTED_SIZE_TOO_SMALL	= 0x00010053	# The data size exceeds the maximum possible data size of fragmented frames.
ER_INCO_FRAME_FRAGMENTED_DOESNT_MATCH	= 0x00010054	# The two frames are not from the same fragmented INCO frame.
ER_INCO_FRAME_FRAGMENTED_MAX_SIZE		= 0x00010055	# The receiving target can't handle that big fragmented frames.
ER_INCO_CTL_UNKNOWN_REQUEST				= 0x00010100	# Unknown request to ::IncoControl.
ER_INCO_CTL_BAD_PARAM					= 0x00010101	# ::IncoControl was called with an invalid parameter.
ER_INCO_CTL_BAD_DATALENGTH				= 0x00010102	# ::IncoControl was called with an invalid data length.
ER_TARGET_SIO_PORT_RANGE				= 0x00020000	# the comport is out of range
ER_TARGET_SIO_PORT_IN_USE				= 0x00020001	# the comport is already used by an other target
ER_TARGET_SIO_SEND_FAILED				= 0x00020002	# the data couldn't be written to the sio port
ER_TARGET_SIO_DISABLED					= 0x00020003	# the sio port is currently disabled
ER_TARGET_SIO_OPEN_FAILED				= 0x00020004	# opening the comport failed
ER_TARGET_NET_SEND_FAILED				= 0x00020010	# sending the UDP frame to the target failed.
ER_TARGET_NET_MALFORMED_IP				= 0x00020011	# the target ip address is malformed.
ER_TARGET_NET_IP_ALREADY_IN_USE			= 0x00020012	# the target ip address is already in use by another network target.
ER_TARGET_NET_NO_NETWORK_FOR_TARGET		= 0x00020013	# no network card could be found with a suitable IP range to reach the target.
ER_TARGET_NET_BIND_FAILED				= 0x00020014	# binding the udp socket to the specific ip/port failed (bind returned an error).
ER_TARGET_NET_RECV_FAILED				= 0x00020015	# receiving the UDP frame from the target failed.
ER_TARGET_NET_PORT_UNREACHABLE			= 0x00020016	# target UDP port unreachable (nobody listening on port 1964?)
ER_TARGET_REMOTE_NO_SOCKET						= 0x00020020	# socket for remote target couldn't be found
ER_TARGET_REMOTE_SEND_FAILED					= 0x00020021	# sending data to remote server failed.
ER_TARGET_RECEIVE_FAILED						= 0x00020022	# receiving data from remote server failed.
ER_TARGET_REMOTE_CONNECTED_SRV_GONE				= 0X00020023	# a remote server that was connected to this server has gone
ER_TARGET_REMOTE_SRV_NOT_FOUND					= 0x00020024	# the remote server name or IP could not be resolved
ER_TARGET_REMOTE_SRV_CONNECTING_FAILED			= 0x00020025	# connecting to the remote server failed. Maybe server not running?
ER_TARGET_REMOTE_SRV_CONNECTING_TIMEDOUT		= 0x00020026	# Connecting to the remote server failed: Time out. Maybe server not running?
ER_TARGET_REMOTE_SRV_CONNECTING_SOCKOPT_FAILED	= 0x00020027	# Connecting to the remote server failed: getsockopt returned an error. Maybe server not running?
ER_TARGET_REMOTE_SRV_CONNECTING_WRONG_SELECT	= 0x00020028	# Connecting to the remote server failed. select returned wrong set. Maybe server not running?
ER_TARGET_REMOTE_SRV_CONNECTING_NOBLOCK			= 0x00020029	# Connecting to the remote server failed. connect didn't return 'wouldblock'. Maybe server not running?
ER_TARGET_REMOTE_SRV_CONNECTING_CONNECT_FAILED	= 0x0002002A	# Connecting to the remote server failed. connect returned error. Maybe server not running?
ER_TARGET_REMOTE_CONNECTION_SHUTDOWN			= 0X0002002B	# the Tcp/Ip connection was gracefully shutdown by the remote peer
ER_TARGET_REMOTE_SELECT_FAILED					= 0X0002002C	# The Tcp/Ip connection could not be established, select() returned an invalid result
ER_TARGET_REMOTE_CONNECT_FAILED					= 0X0002002D	# The Tcp/Ip connection could not be established, connect() returned an error
ER_TARGET_REMOTE_CONNECT_NOT_EINPROGRESS		= 0X0002002E	# The Tcp/Ip connection could not be established, connect() didn't return EINPROGRESS
ER_TARGET_PCI_DPR_VERIFY				= 0x00020030	# Writing to the DPR failed: Verifying the value was wrong.
ER_TARGET_PCI_NO_BOARD_AT_BUS_SLOT		= 0x00020031	# No board could be found at configured bus/slot pair
ER_TARGET_PCI_BOARD_ALREADY_USED		= 0x00020032	# The configured board at configured bus/slot is already in use.
ER_TARGET_PCI_PLXBARMAP_FAILED			= 0x00020033	# PlxBarMap returned an error. The PCI board can't be opened
ER_TARGET_PCI_READ_EEPROM_FAILED		= 0x00020034	# Reading the EEPROM of the PCI board failed.
ER_TARGET_PCI_BUFFER_TOO_SMALL			= 0x00020035	# The data length in the DPR is longer than the buffer available by the INOCServer. Very strange.
ER_TARGET_PCI_BOOTCODE_READ_FAILED		= 0x00020036	# Reading the bootcode failed (fread() returned error)
ER_TARGET_PCI_GINPCIE_RESET_FAILED		= 0x00020037	# The GIN-PCIe reset failed
ER_TARGET_PCI_1ST_STAGE_UBOOT_NOT_RUN	= 0x00020038	# The GIN-PCIe 1st stage u-boot seems to be not running
ER_TARGET_PCI_INOS_BOOTLOADER_NOT_RUN	= 0x00020039	# The GIN-PCIe INOS bootloader seems to be not running
ER_TARGET_PCI_NOT_YET_OPENED			= 0x0002003A	# The PCMaster has not yet been opened
ER_TARGET_PCI_IRQ_UNSUPPORTED			= 0x0002003B	# The PCMaster does not support interrupts (e.g. "ISA compatibility" flag set)
ER_TARGET_PCI_VERSION_MISMATCH			= 0x0002003C	# The PCMaster is not compatible to the device driver. Maybe outdated GIN-PCIe driver?
ER_TARGET_PCI_WRONG_BOARD_TYPE			= 0x0002003D	# The Indel PCI board is of the wrong type (e.g. GIN-PCIe instead of PCI2)
ER_TARGET_PLX_NTFY_WAIT_HANDLE			= 0x00020040	# PlxPci_NotificationWait return 'invalid handle' error.
ER_TARGET_PLX_NTFY_WAIT_TIMEOUT			= 0x00020041	# PlxPci_NotificationWait return 'timeout' error.
ER_TARGET_PLX_NTFY_WAIT_CANCELED		= 0x00020042	# PlxPci_NotificationWait return 'canceled' error.
ER_TARGET_PLX_NTFY_WAIT_GENERIC			= 0x00020043	# PlxPci_NotificationWait return a not further specified error.
ER_TARGET_PLX_NTFY_REG_GENERIC			= 0x00020044	# PlxPci_NotificationRegisterFor return a not further specified error.
ER_TARGET_PCI_DC_APP_ERROR				= 0x00020050	# PCI datachannel received an application error
ER_TARGET_PCI_DC_BUF_TO_SMALL			= 0x00020051	# PCI datachannel receive data failed because the buffer is too small
ER_TARGET_PCI_DC_SPURIOUS_IRQ			= 0x00020052	# PCI datachannel received interrupt but not valid data were available
ER_TARGET_PCI_DC_RECEIVER_WRONG_ID		= 0x00020053	# PCI datachannel sending data failed because the receiver read wrong data (wrong unique id)
ER_TARGET_PCI_DC_CHECKUSM_FAILURE		= 0x00020054	# PCI datachannel received data with wrong checksum
ER_TARGET_AUTOSCAN_TARGET_NAME_EXISTS	= 0x000200F0	# a target with the same name as the autoscanned target already exists.
ER_TARGET_AUTOSCAN_SOCKET_OPEN_FAILED	= 0x000200F1	# creating a socket failed.
ER_TARGET_AUTOSCAN_SOCKET_BIND_FAILED	= 0x000200F2	# binding the socket failed.
ER_TARGET_AUTOSCAN_NET_SENDTO_FAILED	= 0x000200F3	# sendto function returned failure
ER_TARGET_URL_MISSING_URL				= 0x00021000	# no target URL specified
ER_TARGET_URL_MALFORMED_URL				= 0x00021001	# the target URL is malformed
ER_TARGET_URL_MISSING_PROTOCOL			= 0x00021002	# the target URL contains no protocol part
ER_TARGET_URL_UNSUPPORTED_PROTOCOL		= 0x00021003	# the target URL contains an unsupported protocol
ER_TARGET_URL_MISSING_HOSTNAME			= 0x00021004	# the target URL contains no hostname part
ER_TARGET_URL_RESOLVE_SYSCALL_FAILED	= 0x00021005	# a system call for resolving target hostname failed
ER_TARGET_URL_HOST_NOT_FOUND			= 0x00021006	# the target host was not found
ER_TARGET_URL_MALFORMED_IP				= 0x00021011	# the target ip address is malformed.
ER_TARGET_URL_SETSOCKOPT_FAILED			= 0x00021012	# a setsockopt system call has failed.
ER_TARGET_URL_LL_WITHOUT_SCOPEID_NOT_SUPPORTED	= 0x00021013	# link-local IPv6 address without Scope ID not supported.
ER_TARGET_URL_INVALID_SCOPEID			= 0x00021014	# the scope id is invalid
ER_REMOTE_PROC_DIED						= 0x00030010	# remote process has died
ER_TIMEOUT_LOCK							= 0x00030011	# timeout while waiting for global (os wide) mutex or semaphore
ER_UNKNOWN_COMM_THREAD					= 0x00030012	# inco_32 does not have an IPC channel to INCOServer for the calling thread
ER_SHMEM_OPEN_FAILED					= 0x00030020	# opening the shared memory connection failed
ER_SHMEM_CONN_CLOSED					= 0x00030021	# the connection to the remote part of the shared memory channel is not opened.
ER_TCPSOCKET_NO_SOCKET					= 0x00030030	# the socket() function returned no valid socket handle
ER_TCPSOCKET_FIONBIO_FAILED				= 0x00030031	# setting the socket to asynchronous failed: ioctlsocket() returned error
ER_TCPSOCKET_BIND_FAILED				= 0x00030032	# binding the socket failed: bind() returned error
ER_TCPSOCKET_LISTEN_FAILED				= 0x00030033	# listening on the socket failed: listen() returned error
ER_TCPSOCKET_SEND_BUF_FULL				= 0x00030034	# the sending buffer of the tcp socket is full. Maybe the remote server does not read from socket anymore.
ER_TCPSOCKET_REMOTE_GONE				= 0x00030035	# the remote part of the connection has gone
ER_TCPSOCKET_REFUSE_RECONNECT			= 0x00030036	# the socket is not going to reconnect because the socket has been created with a valid socket file handle during construction. Therefore, we assume that a remote host has connected to this server and thus reconnecting wouldn't make sense
ER_TCPSOCKET_ADDR_ALREADY_USED			= 0x00030037	# the same address is already used by another target. It is not allowed to use the same address multiple times. Create a target alias insted.
ER_TCPSOCKET_RECV_GENERIC				= 0x00030038	# the recv function returned a not further specified error during the attempt of reading data from Tcp socket
ER_TCPSOCKET_CONNECT_FAILED				= 0x00030039	# connecting to the server failed: connect() returned error
ER_INCO_COM_INIT						= 0x00040001	# error in initialisation of com-port
ER_INCO_COM_CLOSE						= 0x00040002	# error in closing of com-port
ER_INCO_COM_PURGE						= 0x00040003	# error in flushing of com-buffer
ER_INCO_PROTOCOL_READ					= 0x00040004	# error in protocol while reading
ER_INCO_CHECKSUM_READ					= 0x00040005	# error in checksum while reading
ER_INCO_PROTOCOL_WRITE					= 0x00040006	# error in protocol while writing
ER_INCO_DEVICE_OFFLINE					= 0x000500F8	# The device is offline
ER_INCO_EME_DISP_NOT_ALLOWED			= 0x000500F9	# The emergency dispatcher is not allowed to perform that type of inco calls (incodispatcher task is on trap/assert)
ER_INCO_NAK_FRAME						= 0x000500FA	# The target returned a NAK frame. This means that the frame content checksum was incorrect. Most probably a transfer error occurred
ER_INCO_DEVICE_UNKNOWN					= 0x000500FB	# The target/device is unknown (i.e. not configured)
ER_INCO_TOO_MANY_SUBDEVICES				= 0x000500FC	# There are too many (sub)devices in the target path. (obsolete, used by INCOServer 3 only)
ER_INCO_SUBDEVICE_UNKNOWN				= 0x000500FD	# The subtarget can't be reached (e.g. because we're transing)
ER_INCO_DEVICE_BUSY						= 0x000500FE	# Device on frame route is busy (e.g. the device frame queue is full)
ER_INCO_UNKNOWN_FRAME					= 0x000500FF	# Target doesn't support this INCO frame type
ER_INCO_BLK_ADDRESS						= 0x00050101	# block invalid address
ER_INCO_BLK_ALIGNMENT					= 0x00050102	# block alignment error
ER_INCO_BLK_RANGE						= 0x00050103	# block invalid address range
ER_INCO_BLK_SECTOR_ERASE				= 0x00050104	# sector erase error (writing to flash)
ER_INCO_BLK_WRITE						= 0x00050105	# writing error (writing to flash)
ER_INCO_BLK_P08_NOT_ALLOWED				= 0x00050110	# putblock8 to address not allowed
ER_INCO_BLK_G08_NOT_ALLOWED				= 0x00050111	# getblock8 to address not allowed
ER_INCO_BLK_P16_NOT_ALLOWED				= 0x00050112	# putblock16 to address not allowed
ER_INCO_BLK_G16_NOT_ALLOWED				= 0x00050113	# getblock16 to address not allowed
ER_INCO_BLK_P32_NOT_ALLOWED				= 0x00050114	# putblock32 to address not allowed
ER_INCO_BLK_G32_NOT_ALLOWED				= 0x00050115	# getblock32 to address not allowed
ER_INCO_BLK_P64_NOT_ALLOWED				= 0x00050116	# putblock64 to address not allowed
ER_INCO_BLK_G64_NOT_ALLOWED				= 0x00050117	# getblock64 to address not allowed
ER_INCO_BLK_SIZE_TOO_BIG				= 0x00050118	# GetBlock or PutBlock has been requested using a too big block size
ER_INCO_BLK_UNKNOWN						= 0x000501FF	# block unknown function call
ER_INCO_VAR_NOT_FOUND					= 0x00050201	# variable not found
ER_INCO_VAR_READ_ONLY					= 0x00050202	# variable is read only
ER_INCO_VAR_MINIMUM						= 0x00050203	# variable minimum reached
ER_INCO_VAR_MAXIMUM						= 0x00050204	# variable maximum reached
ER_INCO_VAR_STRING_LENGTH				= 0x00050205	# variable string length error
ER_INCO_VAR_ARRAY_INDEX					= 0x00050206	# variable array index out of bound
ER_INCO_VAR_KEY_LEVEL					= 0x00050207	# variable keylevel not enough
ER_INCO_VAR_PROP_NOT_FOUND				= 0x00050208	# variable property not found
ER_INCO_VAR_BIT_NUMBER					= 0x00050209	# variable bit number not allowed
ER_INCO_VAR_BUFFER_SIZE					= 0x0005020A	# variable Buffer to small
ER_INCO_VAR_MULTIDISPATCH				= 0x0005020B	# multidispatch failed. INIX specific error code
ER_INCO_VAR_VARTRIGGERTWICE				= 0x0005020C	# a trigger with the same action and of the same type is already registered. INIX specific error code
ER_INCO_VAR_EME_NOT_ALLOWED				= 0x0005020D	# variable read/write not allowed for emergency incodispatcher.
ER_INCO_VAR_ASYNC_RESULT_LOST			= 0x0005020E	# asynchronous variable getter did not return a result, or result was already purged from ring buffer
ER_INCO_VAR_TRIGGERSYNTAX				= 0x0005020F	# the trigger command has wrong syntax
ER_INCO_VAR_UNSUPPORTED_TYPE			= 0x00050210	# the type is unsupported. Depending whether a GetVariable or PutVariable was performed, this means that either INOS or the inco_32.dll should be updated.
ER_INCO_VAR_NOT_A_STRING				= 0x00050211	# GetVariable was called to read a string, but the variable is not of type string.
ER_INCO_VAR_NOT_A_NUMBER				= 0x00050212	# GetVariable was called to read a number, but the variable is not of type number.
ER_INCO_VAR_NAME_LENGTH					= 0x00050213	# The variable name length is too long (i.e. does not fit into the maximum possible frame length)
ER_INCO_VAR_PUT_BUFFER_SIZE				= 0x00050214	# The communication buffer is too small to put the variable. Variable name/path and or variable value exceeds maximum length.
ER_INCO_VAR_TYPE_MISMATCH				= 0x00050215	# put/getvariableex type mismatch detected
ER_INCO_VAR_SIZE_MISMATCH				= 0x00050216	# put/getvariableex size mismatch detected
ER_INCO_VAR_NOT_SUPPORTED				= 0x00050217	# put/getvariableex not supported
ER_INCO_VAR_VALUE_TOO_BIG				= 0x00050218	# value too big to be represented in a double, use GetVariableEx instead
ER_INCO_VAR_USER_ERROR					= 0x00050280	# Variable user error
ER_INCO_VAR_ASYNC						= 0x000502FE	# Variable access is async. This is a 'virtual' error only used for communication between the target and the INCOServer. If you get this error, you need to update your INCOServer version.
ER_INCO_VAR_UNKNOWN						= 0x000502FF	# Target doesn't support this 'variable' frame sub type
ER_INCO_DB_TABLE_UNKNOWN				= 0x00050301	# unknown database table
ER_INCO_DB_RECORD_UNKNOWN				= 0x00050302	# unknown record number/name in database table
ER_INCO_DB_NOT_ENOUGH_MEMORY			= 0x00050303	# not enough memory to create database table
ER_INCO_DB_UNKNOWN						= 0x000503FF	# database unknown function call
ER_INCO_RPC_NOT_FOUND					= 0x00050401	# rpc procedure not found
ER_INCO_RPC_NO_PROCEDURE				= 0x00050402	# rpc item is not a procedure object
ER_INCO_RPC_PARAM_COUNT					= 0x00050403	# rpc wrong number of parameters
ER_INCO_RPC_PARAM_TYPE					= 0x00050404	# rpc wrong type of parameters
ER_INCO_RPC_NOT_EXECUTABLE				= 0x00050405	# rpc call not executable at the moment
ER_INCO_RPC_IN_PROGRESS					= 0x00050406	# rpc call in progress
ER_INCO_RPC_NO_FLOAT_SUPPORT			= 0x00050407	# rpc returnvalue as floating not supported. INOS error code.
ER_INCO_RPC_VALUE_RANGE					= 0x00050408	# rpc value out of range
ER_INCO_RPC_ARG_TO_LONG					= 0x00050409	# rpc argument too long
ER_INCO_RPC_MULTIDISPATCH				= 0x0005040A	# failure with multidispatch: at least one callprocedure failed
ER_INCO_RPC_ARG_FORMAT					= 0x0005040B	# error in argument formatting ('\', \", :l...)
ER_INCO_RPC_NO_RETURN_VALUE				= 0x0005040C	# The function didn't return any result
ER_INCO_RPC_NOT_A_TICKET				= 0x0005040D	# the passed value (id) was not a ticket! Most probably the number was not negative
ER_INCO_RPC_UNKNOWN_TICKET				= 0x0005040E	# Ticket is either invalid, the results have already been got or it's result has already been purged from ring buffer
ER_INCO_RPC_INVALID_RESULT_TYPE			= 0x0005040F	# the result type differ from the passed data type
ER_INCO_RPC_UNKNOWN_FLAGS				= 0x00050410	# the caller passed unknown flags for getting the callprocedure results
ER_INCO_RPC_NOT_CONVERTIBLE_TO_DOUBLE	= 0x00050411	# the CallProcedure result is not castable into a double (e.g. the result type is uint64, char*, etc.)
ER_INCO_RPC_RESULT_BUFFER_TO_SMALL		= 0x00050412	# the CallProcedure result cannot be written to the buffer passed by the application because the buffer is to small.
ER_INCO_RPC_WAIT_TIMEOUT				= 0x00050413	# waiting for the asynchronous part of the callprocedure timed out
ER_INCO_RPC_ASYNC_RESULT_PARSE_ERROR	= 0x00050414	# parsing the asynchronous result failed. Either there was a transfer error or the target software (i.e. INOS) supports a newer format than the inco_32. Updating the latter may solve the issue.
ER_INCO_RPC_EXPECTED_A_DOUBLE			= 0x00050415	# getting the async procedure result by 'DF_INCO_TYPE_NUMBER_VALUE' expects a double pointer being passed.
ER_INCO_RPC_INTERRUPTED					= 0x00050416	# asynchronous procedure was interrupted by target reset
ER_INCO_RPC_KEY_LEVEL					= 0x00050417	# RPC keylevel not enough
ER_INCO_RPC_WAIT_EXCLUSIVE				= 0x00050418	# only one thread at a time is allowed to wait for a CallProcedure per ticket.
ER_INCO_RPC_WAIT_DISALLOWED				= 0x00050419	# only the thread that obtained a ticket is allowed to wait for it.
ER_INCO_RPC_CREATOR_THREAD_GONE			= 0x0005041A	# the thread that obtained the ticket is gone
ER_INCO_RPC_USER_ERROR					= 0x00050480	# rpc call user error
ER_INCO_RPC_ASYNC						= 0x000504FE	# Procedure execution is async. This is a 'virtual' error only used for communication between the target and the INCOServer. If you get this error, you need to update your INCOServer version.
ER_INCO_RPC_UNKNOWN						= 0x000504FF	# rpc unknown function call
ER_INCO_LITE_CALL_NOT_SUPPORTED			= 0x00050501	# INCO Lite: call type not supported
ER_INCO_LITE_DEVICE_NOT_SUPPORTED		= 0x00050502	# INCO Lite: device type not supported
ER_INCO_LITE_SUBTARGET_NOT_SUPPORTED	= 0x00050503	# INCO Lite: subtarget not supported
ER_INCO_LITE_SERVER_RESOLVE_FAILED		= 0x00050504	# INCO Lite: INCOServer failed to resolve target name
ER_INCO_LITE_ASYNC_NOT_SUPPORTED		= 0x00050505	# INCO Lite: AsyncResult not supported
ER_INCO_DBG_ID_INVALID					= 0x00050601	# task id not valid
ER_INCO_DBG_NAME_INVALID				= 0x00050602	# task name not valid
ER_INCO_DBG_NO_FLOATING					= 0x00050603	# task has no floating point support
ER_INCO_DBG_BRK_PT_INVALID				= 0x00050604	# task breakpoint not valid
ER_INCO_DBG_BRK_PT_ALREADY				= 0x00050605	# task breakpoint already set
ER_INCO_DBG_WRONG_LENGTH				= 0x00050606	# task data wrong length for requested data
ER_INCO_DBG_UNKNOWN_DATA				= 0x00050607	# task data unknown data request
ER_INCO_DBG_PUT_FORBIDDEN				= 0x00050608	# task data put not allowed
ER_INCO_DBG_BRK_PT_MEMORY				= 0x00050609	# not enough memory to set breakpoint
ER_INCO_DBG_NO_HARD_RESET				= 0x0005060A	# hard reset not supported
ER_INCO_DBG_NO_DEVICE					= 0x0005060B	# no load device found to handle request
ER_INCO_DBG_NO_SOFT_RESET				= 0x0005060C	# soft reset not allowed
ER_INCO_DBG_BUFFER_TO_SMALL				= 0x0005060D	# The buffer is to small to store all data. Data has been truncated
ER_INCO_DBG_INVALID_ARG					= 0x0005060E	# Invalid argument passed (i.e. null pointer)
ER_INCO_DBG_NO_WATCHPOINTS_EXCEEDED		= 0x0005060F	# Number of watchpoints exceeded
ER_INCO_DBG_WATCHPOINT_CLR_ADDRESS		= 0x00050610	# Trying to clear a watchpoint which was not set before
ER_INCO_DBG_TASK_NOT_DEBUG_SUSPENDED	= 0x00050611	# Operation refused because task is not in 'debug suspended' state
ER_INCO_DBG_BUFFER_EXCEEDED				= 0x00050612	# The buffer is to small to store all data. No data has been returned
ER_INCO_DBG_EMPTY_CACHE					= 0x00050613	# No cached information available. E.g. the target doesn't support that feature or another call has been performed in the meantime
ER_INCO_DBG_INVALID_COOKIE				= 0x00050614	# No task register information in INCOFrame
ER_INCO_DBG_UNKNOWN						= 0x000506FF	# task unknown function call
ER_INCO_BIT_INVALID						= 0x00050701	# invalid bit number/name
ER_INCO_BIT_UNKNOWN						= 0x000507FF	# unknown function call
ER_INCO_PARSING_NOT_FINISHED			= 0x00050800	# Parsing of data stream started but was not finished
ER_INCO_PARSING_DEST_PATH_LENGTH		= 0x00050802	# Length of destination path mismatch (missing '\0' ?)
ER_INCO_PARSING_SRC_PATH_LENGTH			= 0x00050803	# Length of source path mismatch (missing '\0' ?)
ER_INCO_PARSING_CHECKSUM_HEADER			= 0x00050804	# Checksum of header was wrong
ER_INCO_PARSING_CHECKSUM_CONTENT		= 0x00050805	# Chechsum of content was wrong
ER_INCO_PARSING_TO_MUCH_DATA			= 0x00050806	# amount of data is to big (see DF_MAX_DATA_LENGTH)
ER_INCO_PARSING_VERSION_MISMATCH		= 0x00050807	# The version of the incoframe mismatched (frame was put to the wrong parser/device)
ER_INCO_PARSING_MISC_ERROR				= 0x00050808	# Miscellanieous frame parsing error
ER_INCO_PARSING_SECOND_SOH_DETECTED		= 0x00050809	# The frame-parser has detected a SOH within the data stream (in fact this is not an error)
ER_INCO_PARSING_MORE_DATA_FIRST_OK		= 0x0005080A	# The given datastream contains more than one SOH. The first incoframe has been parsed successfully!
ER_INCO_PARSING_MORE_DATA				= 0x0005080B	# The given datastream contains more than one SOH. But the first incoframe has produced a parsing error.
ER_INCO_PARSING_SOH_RECEIVED			= 0x0005080C	# Received SOH classic frame but this is not supported.
ER_VB_ERROR								= 0x00060000	# reserved for VB-errors (look Err.Number)
ER_INCO_COM_INIT_SIO					= 0x00070001	# error initialising COM
ER_INCO_COM_WRITE						= 0x00070002	# error writing to COM
ER_INCO_COM_READ						= 0x00070003	# error reading from COM
ER_INCO_COM_TIMEOUT						= 0x00070004	# timeout reading from COM
ER_INCO_DT_CONTROL_UNKNOWN				= 0x00080000	# Data transfer error: DTControl called with unknown request
ER_INCO_DT_NOCONNECTION					= 0x00080001	# Data transfer error: No connection
ER_INCO_DT_TIMEOUT						= 0x00080002	# Data transfer error: Timeout transmitting data
ER_INCO_DT_TRANSMISSION_FAILURE			= 0x00080003	# Data transfer error: Transmission failure
ER_INCO_DT_ALREADY_CONNECTED			= 0x00080004	# Data transfer error: The remote partner already has a connection established
ER_INCO_DT_DEVICE_UNSUPPORTED			= 0x00080005	# Data transfer error: This device type is not support
ER_INCO_DT_METHOD_UNKONWN				= 0x00080006	# Data transfer error: This transfer method is unkown. Updating libinco_32 may fix the issue
ER_INCO_DT_CONNECTING_REFUSED			= 0x00080007	# Data transfer error: Remote refused to connect
ER_INCO_DT_TOO_MUCH_DATA					= 0x00080008	# Data transfer error: The remote cannot handle that much data
ER_INCO_DT_BUFFER_TO_SMALL				= 0x00080009	# Data transfer error: The provided buffer size is to small. It must at least provide as much memory as defined by the datachannel
ER_INCO_DT_LOCK_FAILED					= 0x0008000A	# Data transfer error: Failed to initialize lock
ER_INCO_DT_LOCK_TIMEOUT					= 0x0008000B	# Data transfer error: Timeout while waiting for lock
ER_SOCKET_OS_BASE                       = 0x00090000	# socket OS error base
ER_SOCKET_APP_BASE                      = 0x00098000	# socket application error base
ER_SOCKET_UNMAPPABLE_OS_ERROR           = 0x00098001	# unmappable OS error
ER_SOCKET_CLOSED                        = 0x00098002	# socket is closed
ER_SOCKET_TIMEOUT                       = 0x00098003	# socket timeout
ER_SOCKET_TIMEOUT_RECV                  = 0x00098004	# socket receive timeout
ER_SOCKET_TIMEOUT_SEND                  = 0x00098005	# socket send timeout
ER_SOCKET_BUFFER_TOO_SMALL              = 0x00098006	# socket buffer too small
ER_SOCKET_INCOMPLETE_SEND               = 0x00098007	# socket incomplete send
ER_SOCKET_INCOMPLETE_RECV               = 0x00098008	# socket incomplete receive
ER_SOCKET_FAMILY_MISMATCH               = 0x00098009	# socket family mismatch
ER_SOCKET_ADDR_INVALID                  = 0x0009800A	# socket address invalid
ER_SOCKET_NO_BUFFER_SPACE               = 0x0009800B	# socket no buffer space available
ER_SOCKET_WOULDBLOCK                    = 0x0009800C	# socket operation would block
ER_SOCKET_WOULDBLOCK_RECV               = 0x0009800D	# socket receive would block
ER_SOCKET_WOULDBLOCK_SEND               = 0x0009800E	# socket receive would block
ER_SOCKET_INTERRUPTED                   = 0x0009800F	# socket operation interrupted
ER_SOCKET_GAI_FAILED                    = 0x00098400	# getaddrinfo failed
ER_SOCKET_HOST_NOT_FOUND                = 0x00098404	# host not found
DF_ER_INIX_PLUGIN_STATE_NOT_POSSIBLE	= 0x10001001
DF_ER_INIX_PLUGIN_STATE_UNKNOWN			= 0x10001002
ER_INCO_DISP_EXISTS						= 0x10002001
ER_INCO_DISP_NOT_EXISTS					= 0x10002002
DF_ER_INIX_LOGGER_ALREADY_INITIALIZED	= 0x20000001
DF_ER_INIX_LOGGER_NOT_INITIALIZED		= 0x20000002
DF_ER_INIX_LOGGER_LEVEL_IS_ACTIVE		= 0x20000003
DF_ER_INIX_LOGGER_LEVEL_IS_NOT_ACTIVE	= 0x20000004
DF_ER_INIX_LOGGER_NO_MESSAGES			= 0x20000005
DF_ER_INIX_LOGGER_BUFFER_TO_SMALL		= 0x20000006
DF_ER_INIX_LOGGER_MISC					= 0x20000007
DF_ER_INIX_LOGGER_LEVEL_ALREADY_EXISTS	= 0x20000008
DF_ER_INIX_LOGGER_LEVEL_NO_FREE			= 0x20000009
DF_ER_INIX_LOGGER_LEVEL_RESERVED		= 0x2000000A
DF_ER_INIX_LOGGER_LEVEL_RANGE			= 0x2000000B
DF_ER_INIX_LOGGER_CALLBACK_INSTALLED	= 0x2000000C
