/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ApiManagementApiConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/api_management_api#api_management_name ApiManagementApi#api_management_name}
    */
    readonly apiManagementName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/api_management_api#api_type ApiManagementApi#api_type}
    */
    readonly apiType?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/api_management_api#description ApiManagementApi#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/api_management_api#display_name ApiManagementApi#display_name}
    */
    readonly displayName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/api_management_api#id ApiManagementApi#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/api_management_api#name ApiManagementApi#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/api_management_api#path ApiManagementApi#path}
    */
    readonly path?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/api_management_api#protocols ApiManagementApi#protocols}
    */
    readonly protocols?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/api_management_api#resource_group_name ApiManagementApi#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/api_management_api#revision ApiManagementApi#revision}
    */
    readonly revision: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/api_management_api#revision_description ApiManagementApi#revision_description}
    */
    readonly revisionDescription?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/api_management_api#service_url ApiManagementApi#service_url}
    */
    readonly serviceUrl?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/api_management_api#soap_pass_through ApiManagementApi#soap_pass_through}
    */
    readonly soapPassThrough?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/api_management_api#source_api_id ApiManagementApi#source_api_id}
    */
    readonly sourceApiId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/api_management_api#subscription_required ApiManagementApi#subscription_required}
    */
    readonly subscriptionRequired?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/api_management_api#terms_of_service_url ApiManagementApi#terms_of_service_url}
    */
    readonly termsOfServiceUrl?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/api_management_api#version ApiManagementApi#version}
    */
    readonly version?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/api_management_api#version_description ApiManagementApi#version_description}
    */
    readonly versionDescription?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/api_management_api#version_set_id ApiManagementApi#version_set_id}
    */
    readonly versionSetId?: string;
    /**
    * contact block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/api_management_api#contact ApiManagementApi#contact}
    */
    readonly contact?: ApiManagementApiContact;
    /**
    * import block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/api_management_api#import ApiManagementApi#import}
    */
    readonly import?: ApiManagementApiImport;
    /**
    * license block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/api_management_api#license ApiManagementApi#license}
    */
    readonly license?: ApiManagementApiLicense;
    /**
    * oauth2_authorization block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/api_management_api#oauth2_authorization ApiManagementApi#oauth2_authorization}
    */
    readonly oauth2Authorization?: ApiManagementApiOauth2Authorization;
    /**
    * openid_authentication block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/api_management_api#openid_authentication ApiManagementApi#openid_authentication}
    */
    readonly openidAuthentication?: ApiManagementApiOpenidAuthentication;
    /**
    * subscription_key_parameter_names block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/api_management_api#subscription_key_parameter_names ApiManagementApi#subscription_key_parameter_names}
    */
    readonly subscriptionKeyParameterNames?: ApiManagementApiSubscriptionKeyParameterNames;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/api_management_api#timeouts ApiManagementApi#timeouts}
    */
    readonly timeouts?: ApiManagementApiTimeouts;
}
export interface ApiManagementApiContact {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/api_management_api#email ApiManagementApi#email}
    */
    readonly email?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/api_management_api#name ApiManagementApi#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/api_management_api#url ApiManagementApi#url}
    */
    readonly url?: string;
}
export declare function apiManagementApiContactToTerraform(struct?: ApiManagementApiContactOutputReference | ApiManagementApiContact): any;
export declare class ApiManagementApiContactOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApiManagementApiContact | undefined;
    set internalValue(value: ApiManagementApiContact | undefined);
    private _email?;
    get email(): string;
    set email(value: string);
    resetEmail(): void;
    get emailInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _url?;
    get url(): string;
    set url(value: string);
    resetUrl(): void;
    get urlInput(): string | undefined;
}
export interface ApiManagementApiImportWsdlSelector {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/api_management_api#endpoint_name ApiManagementApi#endpoint_name}
    */
    readonly endpointName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/api_management_api#service_name ApiManagementApi#service_name}
    */
    readonly serviceName: string;
}
export declare function apiManagementApiImportWsdlSelectorToTerraform(struct?: ApiManagementApiImportWsdlSelectorOutputReference | ApiManagementApiImportWsdlSelector): any;
export declare class ApiManagementApiImportWsdlSelectorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApiManagementApiImportWsdlSelector | undefined;
    set internalValue(value: ApiManagementApiImportWsdlSelector | undefined);
    private _endpointName?;
    get endpointName(): string;
    set endpointName(value: string);
    get endpointNameInput(): string | undefined;
    private _serviceName?;
    get serviceName(): string;
    set serviceName(value: string);
    get serviceNameInput(): string | undefined;
}
export interface ApiManagementApiImport {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/api_management_api#content_format ApiManagementApi#content_format}
    */
    readonly contentFormat: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/api_management_api#content_value ApiManagementApi#content_value}
    */
    readonly contentValue: string;
    /**
    * wsdl_selector block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/api_management_api#wsdl_selector ApiManagementApi#wsdl_selector}
    */
    readonly wsdlSelector?: ApiManagementApiImportWsdlSelector;
}
export declare function apiManagementApiImportToTerraform(struct?: ApiManagementApiImportOutputReference | ApiManagementApiImport): any;
export declare class ApiManagementApiImportOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApiManagementApiImport | undefined;
    set internalValue(value: ApiManagementApiImport | undefined);
    private _contentFormat?;
    get contentFormat(): string;
    set contentFormat(value: string);
    get contentFormatInput(): string | undefined;
    private _contentValue?;
    get contentValue(): string;
    set contentValue(value: string);
    get contentValueInput(): string | undefined;
    private _wsdlSelector;
    get wsdlSelector(): ApiManagementApiImportWsdlSelectorOutputReference;
    putWsdlSelector(value: ApiManagementApiImportWsdlSelector): void;
    resetWsdlSelector(): void;
    get wsdlSelectorInput(): ApiManagementApiImportWsdlSelector | undefined;
}
export interface ApiManagementApiLicense {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/api_management_api#name ApiManagementApi#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/api_management_api#url ApiManagementApi#url}
    */
    readonly url?: string;
}
export declare function apiManagementApiLicenseToTerraform(struct?: ApiManagementApiLicenseOutputReference | ApiManagementApiLicense): any;
export declare class ApiManagementApiLicenseOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApiManagementApiLicense | undefined;
    set internalValue(value: ApiManagementApiLicense | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _url?;
    get url(): string;
    set url(value: string);
    resetUrl(): void;
    get urlInput(): string | undefined;
}
export interface ApiManagementApiOauth2Authorization {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/api_management_api#authorization_server_name ApiManagementApi#authorization_server_name}
    */
    readonly authorizationServerName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/api_management_api#scope ApiManagementApi#scope}
    */
    readonly scope?: string;
}
export declare function apiManagementApiOauth2AuthorizationToTerraform(struct?: ApiManagementApiOauth2AuthorizationOutputReference | ApiManagementApiOauth2Authorization): any;
export declare class ApiManagementApiOauth2AuthorizationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApiManagementApiOauth2Authorization | undefined;
    set internalValue(value: ApiManagementApiOauth2Authorization | undefined);
    private _authorizationServerName?;
    get authorizationServerName(): string;
    set authorizationServerName(value: string);
    get authorizationServerNameInput(): string | undefined;
    private _scope?;
    get scope(): string;
    set scope(value: string);
    resetScope(): void;
    get scopeInput(): string | undefined;
}
export interface ApiManagementApiOpenidAuthentication {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/api_management_api#bearer_token_sending_methods ApiManagementApi#bearer_token_sending_methods}
    */
    readonly bearerTokenSendingMethods?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/api_management_api#openid_provider_name ApiManagementApi#openid_provider_name}
    */
    readonly openidProviderName: string;
}
export declare function apiManagementApiOpenidAuthenticationToTerraform(struct?: ApiManagementApiOpenidAuthenticationOutputReference | ApiManagementApiOpenidAuthentication): any;
export declare class ApiManagementApiOpenidAuthenticationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApiManagementApiOpenidAuthentication | undefined;
    set internalValue(value: ApiManagementApiOpenidAuthentication | undefined);
    private _bearerTokenSendingMethods?;
    get bearerTokenSendingMethods(): string[];
    set bearerTokenSendingMethods(value: string[]);
    resetBearerTokenSendingMethods(): void;
    get bearerTokenSendingMethodsInput(): string[] | undefined;
    private _openidProviderName?;
    get openidProviderName(): string;
    set openidProviderName(value: string);
    get openidProviderNameInput(): string | undefined;
}
export interface ApiManagementApiSubscriptionKeyParameterNames {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/api_management_api#header ApiManagementApi#header}
    */
    readonly header: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/api_management_api#query ApiManagementApi#query}
    */
    readonly query: string;
}
export declare function apiManagementApiSubscriptionKeyParameterNamesToTerraform(struct?: ApiManagementApiSubscriptionKeyParameterNamesOutputReference | ApiManagementApiSubscriptionKeyParameterNames): any;
export declare class ApiManagementApiSubscriptionKeyParameterNamesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApiManagementApiSubscriptionKeyParameterNames | undefined;
    set internalValue(value: ApiManagementApiSubscriptionKeyParameterNames | undefined);
    private _header?;
    get header(): string;
    set header(value: string);
    get headerInput(): string | undefined;
    private _query?;
    get query(): string;
    set query(value: string);
    get queryInput(): string | undefined;
}
export interface ApiManagementApiTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/api_management_api#create ApiManagementApi#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/api_management_api#delete ApiManagementApi#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/api_management_api#read ApiManagementApi#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/api_management_api#update ApiManagementApi#update}
    */
    readonly update?: string;
}
export declare function apiManagementApiTimeoutsToTerraform(struct?: ApiManagementApiTimeouts | cdktf.IResolvable): any;
export declare class ApiManagementApiTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApiManagementApiTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ApiManagementApiTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/api_management_api azurerm_api_management_api}
*/
export declare class ApiManagementApi extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_api_management_api";
    /**
    * Generates CDKTF code for importing a ApiManagementApi resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the ApiManagementApi to import
    * @param importFromId The id of the existing ApiManagementApi that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/api_management_api#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the ApiManagementApi to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/api_management_api azurerm_api_management_api} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ApiManagementApiConfig
    */
    constructor(scope: Construct, id: string, config: ApiManagementApiConfig);
    private _apiManagementName?;
    get apiManagementName(): string;
    set apiManagementName(value: string);
    get apiManagementNameInput(): string | undefined;
    private _apiType?;
    get apiType(): string;
    set apiType(value: string);
    resetApiType(): void;
    get apiTypeInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get isCurrent(): cdktf.IResolvable;
    get isOnline(): cdktf.IResolvable;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _protocols?;
    get protocols(): string[];
    set protocols(value: string[]);
    resetProtocols(): void;
    get protocolsInput(): string[] | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _revision?;
    get revision(): string;
    set revision(value: string);
    get revisionInput(): string | undefined;
    private _revisionDescription?;
    get revisionDescription(): string;
    set revisionDescription(value: string);
    resetRevisionDescription(): void;
    get revisionDescriptionInput(): string | undefined;
    private _serviceUrl?;
    get serviceUrl(): string;
    set serviceUrl(value: string);
    resetServiceUrl(): void;
    get serviceUrlInput(): string | undefined;
    private _soapPassThrough?;
    get soapPassThrough(): boolean | cdktf.IResolvable;
    set soapPassThrough(value: boolean | cdktf.IResolvable);
    resetSoapPassThrough(): void;
    get soapPassThroughInput(): boolean | cdktf.IResolvable | undefined;
    private _sourceApiId?;
    get sourceApiId(): string;
    set sourceApiId(value: string);
    resetSourceApiId(): void;
    get sourceApiIdInput(): string | undefined;
    private _subscriptionRequired?;
    get subscriptionRequired(): boolean | cdktf.IResolvable;
    set subscriptionRequired(value: boolean | cdktf.IResolvable);
    resetSubscriptionRequired(): void;
    get subscriptionRequiredInput(): boolean | cdktf.IResolvable | undefined;
    private _termsOfServiceUrl?;
    get termsOfServiceUrl(): string;
    set termsOfServiceUrl(value: string);
    resetTermsOfServiceUrl(): void;
    get termsOfServiceUrlInput(): string | undefined;
    private _version?;
    get version(): string;
    set version(value: string);
    resetVersion(): void;
    get versionInput(): string | undefined;
    private _versionDescription?;
    get versionDescription(): string;
    set versionDescription(value: string);
    resetVersionDescription(): void;
    get versionDescriptionInput(): string | undefined;
    private _versionSetId?;
    get versionSetId(): string;
    set versionSetId(value: string);
    resetVersionSetId(): void;
    get versionSetIdInput(): string | undefined;
    private _contact;
    get contact(): ApiManagementApiContactOutputReference;
    putContact(value: ApiManagementApiContact): void;
    resetContact(): void;
    get contactInput(): ApiManagementApiContact | undefined;
    private _import;
    get import(): ApiManagementApiImportOutputReference;
    putImport(value: ApiManagementApiImport): void;
    resetImport(): void;
    get importInput(): ApiManagementApiImport | undefined;
    private _license;
    get license(): ApiManagementApiLicenseOutputReference;
    putLicense(value: ApiManagementApiLicense): void;
    resetLicense(): void;
    get licenseInput(): ApiManagementApiLicense | undefined;
    private _oauth2Authorization;
    get oauth2Authorization(): ApiManagementApiOauth2AuthorizationOutputReference;
    putOauth2Authorization(value: ApiManagementApiOauth2Authorization): void;
    resetOauth2Authorization(): void;
    get oauth2AuthorizationInput(): ApiManagementApiOauth2Authorization | undefined;
    private _openidAuthentication;
    get openidAuthentication(): ApiManagementApiOpenidAuthenticationOutputReference;
    putOpenidAuthentication(value: ApiManagementApiOpenidAuthentication): void;
    resetOpenidAuthentication(): void;
    get openidAuthenticationInput(): ApiManagementApiOpenidAuthentication | undefined;
    private _subscriptionKeyParameterNames;
    get subscriptionKeyParameterNames(): ApiManagementApiSubscriptionKeyParameterNamesOutputReference;
    putSubscriptionKeyParameterNames(value: ApiManagementApiSubscriptionKeyParameterNames): void;
    resetSubscriptionKeyParameterNames(): void;
    get subscriptionKeyParameterNamesInput(): ApiManagementApiSubscriptionKeyParameterNames | undefined;
    private _timeouts;
    get timeouts(): ApiManagementApiTimeoutsOutputReference;
    putTimeouts(value: ApiManagementApiTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ApiManagementApiTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
