/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ApplicationGatewayConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#enable_http2 ApplicationGateway#enable_http2}
    */
    readonly enableHttp2?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#fips_enabled ApplicationGateway#fips_enabled}
    */
    readonly fipsEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#firewall_policy_id ApplicationGateway#firewall_policy_id}
    */
    readonly firewallPolicyId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#force_firewall_policy_association ApplicationGateway#force_firewall_policy_association}
    */
    readonly forceFirewallPolicyAssociation?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#id ApplicationGateway#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#location ApplicationGateway#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#name ApplicationGateway#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#resource_group_name ApplicationGateway#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#tags ApplicationGateway#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#zones ApplicationGateway#zones}
    */
    readonly zones?: string[];
    /**
    * authentication_certificate block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#authentication_certificate ApplicationGateway#authentication_certificate}
    */
    readonly authenticationCertificate?: ApplicationGatewayAuthenticationCertificate[] | cdktf.IResolvable;
    /**
    * autoscale_configuration block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#autoscale_configuration ApplicationGateway#autoscale_configuration}
    */
    readonly autoscaleConfiguration?: ApplicationGatewayAutoscaleConfiguration;
    /**
    * backend_address_pool block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#backend_address_pool ApplicationGateway#backend_address_pool}
    */
    readonly backendAddressPool: ApplicationGatewayBackendAddressPool[] | cdktf.IResolvable;
    /**
    * backend_http_settings block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#backend_http_settings ApplicationGateway#backend_http_settings}
    */
    readonly backendHttpSettings: ApplicationGatewayBackendHttpSettings[] | cdktf.IResolvable;
    /**
    * custom_error_configuration block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#custom_error_configuration ApplicationGateway#custom_error_configuration}
    */
    readonly customErrorConfiguration?: ApplicationGatewayCustomErrorConfiguration[] | cdktf.IResolvable;
    /**
    * frontend_ip_configuration block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#frontend_ip_configuration ApplicationGateway#frontend_ip_configuration}
    */
    readonly frontendIpConfiguration: ApplicationGatewayFrontendIpConfiguration[] | cdktf.IResolvable;
    /**
    * frontend_port block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#frontend_port ApplicationGateway#frontend_port}
    */
    readonly frontendPort: ApplicationGatewayFrontendPort[] | cdktf.IResolvable;
    /**
    * gateway_ip_configuration block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#gateway_ip_configuration ApplicationGateway#gateway_ip_configuration}
    */
    readonly gatewayIpConfiguration: ApplicationGatewayGatewayIpConfiguration[] | cdktf.IResolvable;
    /**
    * global block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#global ApplicationGateway#global}
    */
    readonly global?: ApplicationGatewayGlobal;
    /**
    * http_listener block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#http_listener ApplicationGateway#http_listener}
    */
    readonly httpListener: ApplicationGatewayHttpListener[] | cdktf.IResolvable;
    /**
    * identity block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#identity ApplicationGateway#identity}
    */
    readonly identity?: ApplicationGatewayIdentity;
    /**
    * private_link_configuration block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#private_link_configuration ApplicationGateway#private_link_configuration}
    */
    readonly privateLinkConfiguration?: ApplicationGatewayPrivateLinkConfiguration[] | cdktf.IResolvable;
    /**
    * probe block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#probe ApplicationGateway#probe}
    */
    readonly probe?: ApplicationGatewayProbe[] | cdktf.IResolvable;
    /**
    * redirect_configuration block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#redirect_configuration ApplicationGateway#redirect_configuration}
    */
    readonly redirectConfiguration?: ApplicationGatewayRedirectConfiguration[] | cdktf.IResolvable;
    /**
    * request_routing_rule block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#request_routing_rule ApplicationGateway#request_routing_rule}
    */
    readonly requestRoutingRule: ApplicationGatewayRequestRoutingRule[] | cdktf.IResolvable;
    /**
    * rewrite_rule_set block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#rewrite_rule_set ApplicationGateway#rewrite_rule_set}
    */
    readonly rewriteRuleSet?: ApplicationGatewayRewriteRuleSet[] | cdktf.IResolvable;
    /**
    * sku block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#sku ApplicationGateway#sku}
    */
    readonly sku: ApplicationGatewaySku;
    /**
    * ssl_certificate block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#ssl_certificate ApplicationGateway#ssl_certificate}
    */
    readonly sslCertificate?: ApplicationGatewaySslCertificate[] | cdktf.IResolvable;
    /**
    * ssl_policy block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#ssl_policy ApplicationGateway#ssl_policy}
    */
    readonly sslPolicy?: ApplicationGatewaySslPolicy;
    /**
    * ssl_profile block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#ssl_profile ApplicationGateway#ssl_profile}
    */
    readonly sslProfile?: ApplicationGatewaySslProfile[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#timeouts ApplicationGateway#timeouts}
    */
    readonly timeouts?: ApplicationGatewayTimeouts;
    /**
    * trusted_client_certificate block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#trusted_client_certificate ApplicationGateway#trusted_client_certificate}
    */
    readonly trustedClientCertificate?: ApplicationGatewayTrustedClientCertificate[] | cdktf.IResolvable;
    /**
    * trusted_root_certificate block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#trusted_root_certificate ApplicationGateway#trusted_root_certificate}
    */
    readonly trustedRootCertificate?: ApplicationGatewayTrustedRootCertificate[] | cdktf.IResolvable;
    /**
    * url_path_map block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#url_path_map ApplicationGateway#url_path_map}
    */
    readonly urlPathMap?: ApplicationGatewayUrlPathMap[] | cdktf.IResolvable;
    /**
    * waf_configuration block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#waf_configuration ApplicationGateway#waf_configuration}
    */
    readonly wafConfiguration?: ApplicationGatewayWafConfiguration;
}
export interface ApplicationGatewayPrivateEndpointConnection {
}
export declare function applicationGatewayPrivateEndpointConnectionToTerraform(struct?: ApplicationGatewayPrivateEndpointConnection): any;
export declare class ApplicationGatewayPrivateEndpointConnectionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApplicationGatewayPrivateEndpointConnection | undefined;
    set internalValue(value: ApplicationGatewayPrivateEndpointConnection | undefined);
    get id(): string;
    get name(): string;
}
export declare class ApplicationGatewayPrivateEndpointConnectionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApplicationGatewayPrivateEndpointConnectionOutputReference;
}
export interface ApplicationGatewayAuthenticationCertificate {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#data ApplicationGateway#data}
    */
    readonly data: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#name ApplicationGateway#name}
    */
    readonly name: string;
}
export declare function applicationGatewayAuthenticationCertificateToTerraform(struct?: ApplicationGatewayAuthenticationCertificate | cdktf.IResolvable): any;
export declare class ApplicationGatewayAuthenticationCertificateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApplicationGatewayAuthenticationCertificate | cdktf.IResolvable | undefined;
    set internalValue(value: ApplicationGatewayAuthenticationCertificate | cdktf.IResolvable | undefined);
    private _data?;
    get data(): string;
    set data(value: string);
    get dataInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
export declare class ApplicationGatewayAuthenticationCertificateList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ApplicationGatewayAuthenticationCertificate[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApplicationGatewayAuthenticationCertificateOutputReference;
}
export interface ApplicationGatewayAutoscaleConfiguration {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#max_capacity ApplicationGateway#max_capacity}
    */
    readonly maxCapacity?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#min_capacity ApplicationGateway#min_capacity}
    */
    readonly minCapacity: number;
}
export declare function applicationGatewayAutoscaleConfigurationToTerraform(struct?: ApplicationGatewayAutoscaleConfigurationOutputReference | ApplicationGatewayAutoscaleConfiguration): any;
export declare class ApplicationGatewayAutoscaleConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApplicationGatewayAutoscaleConfiguration | undefined;
    set internalValue(value: ApplicationGatewayAutoscaleConfiguration | undefined);
    private _maxCapacity?;
    get maxCapacity(): number;
    set maxCapacity(value: number);
    resetMaxCapacity(): void;
    get maxCapacityInput(): number | undefined;
    private _minCapacity?;
    get minCapacity(): number;
    set minCapacity(value: number);
    get minCapacityInput(): number | undefined;
}
export interface ApplicationGatewayBackendAddressPool {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#fqdns ApplicationGateway#fqdns}
    */
    readonly fqdns?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#ip_addresses ApplicationGateway#ip_addresses}
    */
    readonly ipAddresses?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#name ApplicationGateway#name}
    */
    readonly name: string;
}
export declare function applicationGatewayBackendAddressPoolToTerraform(struct?: ApplicationGatewayBackendAddressPool | cdktf.IResolvable): any;
export declare class ApplicationGatewayBackendAddressPoolOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApplicationGatewayBackendAddressPool | cdktf.IResolvable | undefined;
    set internalValue(value: ApplicationGatewayBackendAddressPool | cdktf.IResolvable | undefined);
    private _fqdns?;
    get fqdns(): string[];
    set fqdns(value: string[]);
    resetFqdns(): void;
    get fqdnsInput(): string[] | undefined;
    get id(): string;
    private _ipAddresses?;
    get ipAddresses(): string[];
    set ipAddresses(value: string[]);
    resetIpAddresses(): void;
    get ipAddressesInput(): string[] | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
export declare class ApplicationGatewayBackendAddressPoolList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ApplicationGatewayBackendAddressPool[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApplicationGatewayBackendAddressPoolOutputReference;
}
export interface ApplicationGatewayBackendHttpSettingsAuthenticationCertificate {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#name ApplicationGateway#name}
    */
    readonly name: string;
}
export declare function applicationGatewayBackendHttpSettingsAuthenticationCertificateToTerraform(struct?: ApplicationGatewayBackendHttpSettingsAuthenticationCertificate | cdktf.IResolvable): any;
export declare class ApplicationGatewayBackendHttpSettingsAuthenticationCertificateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApplicationGatewayBackendHttpSettingsAuthenticationCertificate | cdktf.IResolvable | undefined;
    set internalValue(value: ApplicationGatewayBackendHttpSettingsAuthenticationCertificate | cdktf.IResolvable | undefined);
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
export declare class ApplicationGatewayBackendHttpSettingsAuthenticationCertificateList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ApplicationGatewayBackendHttpSettingsAuthenticationCertificate[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApplicationGatewayBackendHttpSettingsAuthenticationCertificateOutputReference;
}
export interface ApplicationGatewayBackendHttpSettingsConnectionDraining {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#drain_timeout_sec ApplicationGateway#drain_timeout_sec}
    */
    readonly drainTimeoutSec: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#enabled ApplicationGateway#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
}
export declare function applicationGatewayBackendHttpSettingsConnectionDrainingToTerraform(struct?: ApplicationGatewayBackendHttpSettingsConnectionDrainingOutputReference | ApplicationGatewayBackendHttpSettingsConnectionDraining): any;
export declare class ApplicationGatewayBackendHttpSettingsConnectionDrainingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApplicationGatewayBackendHttpSettingsConnectionDraining | undefined;
    set internalValue(value: ApplicationGatewayBackendHttpSettingsConnectionDraining | undefined);
    private _drainTimeoutSec?;
    get drainTimeoutSec(): number;
    set drainTimeoutSec(value: number);
    get drainTimeoutSecInput(): number | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface ApplicationGatewayBackendHttpSettings {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#affinity_cookie_name ApplicationGateway#affinity_cookie_name}
    */
    readonly affinityCookieName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#cookie_based_affinity ApplicationGateway#cookie_based_affinity}
    */
    readonly cookieBasedAffinity: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#host_name ApplicationGateway#host_name}
    */
    readonly hostName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#name ApplicationGateway#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#path ApplicationGateway#path}
    */
    readonly path?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#pick_host_name_from_backend_address ApplicationGateway#pick_host_name_from_backend_address}
    */
    readonly pickHostNameFromBackendAddress?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#port ApplicationGateway#port}
    */
    readonly port: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#probe_name ApplicationGateway#probe_name}
    */
    readonly probeName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#protocol ApplicationGateway#protocol}
    */
    readonly protocol: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#request_timeout ApplicationGateway#request_timeout}
    */
    readonly requestTimeout?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#trusted_root_certificate_names ApplicationGateway#trusted_root_certificate_names}
    */
    readonly trustedRootCertificateNames?: string[];
    /**
    * authentication_certificate block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#authentication_certificate ApplicationGateway#authentication_certificate}
    */
    readonly authenticationCertificate?: ApplicationGatewayBackendHttpSettingsAuthenticationCertificate[] | cdktf.IResolvable;
    /**
    * connection_draining block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#connection_draining ApplicationGateway#connection_draining}
    */
    readonly connectionDraining?: ApplicationGatewayBackendHttpSettingsConnectionDraining;
}
export declare function applicationGatewayBackendHttpSettingsToTerraform(struct?: ApplicationGatewayBackendHttpSettings | cdktf.IResolvable): any;
export declare class ApplicationGatewayBackendHttpSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApplicationGatewayBackendHttpSettings | cdktf.IResolvable | undefined;
    set internalValue(value: ApplicationGatewayBackendHttpSettings | cdktf.IResolvable | undefined);
    private _affinityCookieName?;
    get affinityCookieName(): string;
    set affinityCookieName(value: string);
    resetAffinityCookieName(): void;
    get affinityCookieNameInput(): string | undefined;
    private _cookieBasedAffinity?;
    get cookieBasedAffinity(): string;
    set cookieBasedAffinity(value: string);
    get cookieBasedAffinityInput(): string | undefined;
    private _hostName?;
    get hostName(): string;
    set hostName(value: string);
    resetHostName(): void;
    get hostNameInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _pickHostNameFromBackendAddress?;
    get pickHostNameFromBackendAddress(): boolean | cdktf.IResolvable;
    set pickHostNameFromBackendAddress(value: boolean | cdktf.IResolvable);
    resetPickHostNameFromBackendAddress(): void;
    get pickHostNameFromBackendAddressInput(): boolean | cdktf.IResolvable | undefined;
    private _port?;
    get port(): number;
    set port(value: number);
    get portInput(): number | undefined;
    get probeId(): string;
    private _probeName?;
    get probeName(): string;
    set probeName(value: string);
    resetProbeName(): void;
    get probeNameInput(): string | undefined;
    private _protocol?;
    get protocol(): string;
    set protocol(value: string);
    get protocolInput(): string | undefined;
    private _requestTimeout?;
    get requestTimeout(): number;
    set requestTimeout(value: number);
    resetRequestTimeout(): void;
    get requestTimeoutInput(): number | undefined;
    private _trustedRootCertificateNames?;
    get trustedRootCertificateNames(): string[];
    set trustedRootCertificateNames(value: string[]);
    resetTrustedRootCertificateNames(): void;
    get trustedRootCertificateNamesInput(): string[] | undefined;
    private _authenticationCertificate;
    get authenticationCertificate(): ApplicationGatewayBackendHttpSettingsAuthenticationCertificateList;
    putAuthenticationCertificate(value: ApplicationGatewayBackendHttpSettingsAuthenticationCertificate[] | cdktf.IResolvable): void;
    resetAuthenticationCertificate(): void;
    get authenticationCertificateInput(): cdktf.IResolvable | ApplicationGatewayBackendHttpSettingsAuthenticationCertificate[] | undefined;
    private _connectionDraining;
    get connectionDraining(): ApplicationGatewayBackendHttpSettingsConnectionDrainingOutputReference;
    putConnectionDraining(value: ApplicationGatewayBackendHttpSettingsConnectionDraining): void;
    resetConnectionDraining(): void;
    get connectionDrainingInput(): ApplicationGatewayBackendHttpSettingsConnectionDraining | undefined;
}
export declare class ApplicationGatewayBackendHttpSettingsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ApplicationGatewayBackendHttpSettings[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApplicationGatewayBackendHttpSettingsOutputReference;
}
export interface ApplicationGatewayCustomErrorConfiguration {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#custom_error_page_url ApplicationGateway#custom_error_page_url}
    */
    readonly customErrorPageUrl: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#status_code ApplicationGateway#status_code}
    */
    readonly statusCode: string;
}
export declare function applicationGatewayCustomErrorConfigurationToTerraform(struct?: ApplicationGatewayCustomErrorConfiguration | cdktf.IResolvable): any;
export declare class ApplicationGatewayCustomErrorConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApplicationGatewayCustomErrorConfiguration | cdktf.IResolvable | undefined;
    set internalValue(value: ApplicationGatewayCustomErrorConfiguration | cdktf.IResolvable | undefined);
    private _customErrorPageUrl?;
    get customErrorPageUrl(): string;
    set customErrorPageUrl(value: string);
    get customErrorPageUrlInput(): string | undefined;
    get id(): string;
    private _statusCode?;
    get statusCode(): string;
    set statusCode(value: string);
    get statusCodeInput(): string | undefined;
}
export declare class ApplicationGatewayCustomErrorConfigurationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ApplicationGatewayCustomErrorConfiguration[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApplicationGatewayCustomErrorConfigurationOutputReference;
}
export interface ApplicationGatewayFrontendIpConfiguration {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#name ApplicationGateway#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#private_ip_address ApplicationGateway#private_ip_address}
    */
    readonly privateIpAddress?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#private_ip_address_allocation ApplicationGateway#private_ip_address_allocation}
    */
    readonly privateIpAddressAllocation?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#private_link_configuration_name ApplicationGateway#private_link_configuration_name}
    */
    readonly privateLinkConfigurationName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#public_ip_address_id ApplicationGateway#public_ip_address_id}
    */
    readonly publicIpAddressId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#subnet_id ApplicationGateway#subnet_id}
    */
    readonly subnetId?: string;
}
export declare function applicationGatewayFrontendIpConfigurationToTerraform(struct?: ApplicationGatewayFrontendIpConfiguration | cdktf.IResolvable): any;
export declare class ApplicationGatewayFrontendIpConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApplicationGatewayFrontendIpConfiguration | cdktf.IResolvable | undefined;
    set internalValue(value: ApplicationGatewayFrontendIpConfiguration | cdktf.IResolvable | undefined);
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _privateIpAddress?;
    get privateIpAddress(): string;
    set privateIpAddress(value: string);
    resetPrivateIpAddress(): void;
    get privateIpAddressInput(): string | undefined;
    private _privateIpAddressAllocation?;
    get privateIpAddressAllocation(): string;
    set privateIpAddressAllocation(value: string);
    resetPrivateIpAddressAllocation(): void;
    get privateIpAddressAllocationInput(): string | undefined;
    get privateLinkConfigurationId(): string;
    private _privateLinkConfigurationName?;
    get privateLinkConfigurationName(): string;
    set privateLinkConfigurationName(value: string);
    resetPrivateLinkConfigurationName(): void;
    get privateLinkConfigurationNameInput(): string | undefined;
    private _publicIpAddressId?;
    get publicIpAddressId(): string;
    set publicIpAddressId(value: string);
    resetPublicIpAddressId(): void;
    get publicIpAddressIdInput(): string | undefined;
    private _subnetId?;
    get subnetId(): string;
    set subnetId(value: string);
    resetSubnetId(): void;
    get subnetIdInput(): string | undefined;
}
export declare class ApplicationGatewayFrontendIpConfigurationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ApplicationGatewayFrontendIpConfiguration[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApplicationGatewayFrontendIpConfigurationOutputReference;
}
export interface ApplicationGatewayFrontendPort {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#name ApplicationGateway#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#port ApplicationGateway#port}
    */
    readonly port: number;
}
export declare function applicationGatewayFrontendPortToTerraform(struct?: ApplicationGatewayFrontendPort | cdktf.IResolvable): any;
export declare class ApplicationGatewayFrontendPortOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApplicationGatewayFrontendPort | cdktf.IResolvable | undefined;
    set internalValue(value: ApplicationGatewayFrontendPort | cdktf.IResolvable | undefined);
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _port?;
    get port(): number;
    set port(value: number);
    get portInput(): number | undefined;
}
export declare class ApplicationGatewayFrontendPortList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ApplicationGatewayFrontendPort[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApplicationGatewayFrontendPortOutputReference;
}
export interface ApplicationGatewayGatewayIpConfiguration {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#name ApplicationGateway#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#subnet_id ApplicationGateway#subnet_id}
    */
    readonly subnetId: string;
}
export declare function applicationGatewayGatewayIpConfigurationToTerraform(struct?: ApplicationGatewayGatewayIpConfiguration | cdktf.IResolvable): any;
export declare class ApplicationGatewayGatewayIpConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApplicationGatewayGatewayIpConfiguration | cdktf.IResolvable | undefined;
    set internalValue(value: ApplicationGatewayGatewayIpConfiguration | cdktf.IResolvable | undefined);
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _subnetId?;
    get subnetId(): string;
    set subnetId(value: string);
    get subnetIdInput(): string | undefined;
}
export declare class ApplicationGatewayGatewayIpConfigurationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ApplicationGatewayGatewayIpConfiguration[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApplicationGatewayGatewayIpConfigurationOutputReference;
}
export interface ApplicationGatewayGlobal {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#request_buffering_enabled ApplicationGateway#request_buffering_enabled}
    */
    readonly requestBufferingEnabled: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#response_buffering_enabled ApplicationGateway#response_buffering_enabled}
    */
    readonly responseBufferingEnabled: boolean | cdktf.IResolvable;
}
export declare function applicationGatewayGlobalToTerraform(struct?: ApplicationGatewayGlobalOutputReference | ApplicationGatewayGlobal): any;
export declare class ApplicationGatewayGlobalOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApplicationGatewayGlobal | undefined;
    set internalValue(value: ApplicationGatewayGlobal | undefined);
    private _requestBufferingEnabled?;
    get requestBufferingEnabled(): boolean | cdktf.IResolvable;
    set requestBufferingEnabled(value: boolean | cdktf.IResolvable);
    get requestBufferingEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _responseBufferingEnabled?;
    get responseBufferingEnabled(): boolean | cdktf.IResolvable;
    set responseBufferingEnabled(value: boolean | cdktf.IResolvable);
    get responseBufferingEnabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface ApplicationGatewayHttpListenerCustomErrorConfiguration {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#custom_error_page_url ApplicationGateway#custom_error_page_url}
    */
    readonly customErrorPageUrl: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#status_code ApplicationGateway#status_code}
    */
    readonly statusCode: string;
}
export declare function applicationGatewayHttpListenerCustomErrorConfigurationToTerraform(struct?: ApplicationGatewayHttpListenerCustomErrorConfiguration | cdktf.IResolvable): any;
export declare class ApplicationGatewayHttpListenerCustomErrorConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApplicationGatewayHttpListenerCustomErrorConfiguration | cdktf.IResolvable | undefined;
    set internalValue(value: ApplicationGatewayHttpListenerCustomErrorConfiguration | cdktf.IResolvable | undefined);
    private _customErrorPageUrl?;
    get customErrorPageUrl(): string;
    set customErrorPageUrl(value: string);
    get customErrorPageUrlInput(): string | undefined;
    get id(): string;
    private _statusCode?;
    get statusCode(): string;
    set statusCode(value: string);
    get statusCodeInput(): string | undefined;
}
export declare class ApplicationGatewayHttpListenerCustomErrorConfigurationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ApplicationGatewayHttpListenerCustomErrorConfiguration[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApplicationGatewayHttpListenerCustomErrorConfigurationOutputReference;
}
export interface ApplicationGatewayHttpListener {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#firewall_policy_id ApplicationGateway#firewall_policy_id}
    */
    readonly firewallPolicyId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#frontend_ip_configuration_name ApplicationGateway#frontend_ip_configuration_name}
    */
    readonly frontendIpConfigurationName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#frontend_port_name ApplicationGateway#frontend_port_name}
    */
    readonly frontendPortName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#host_name ApplicationGateway#host_name}
    */
    readonly hostName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#host_names ApplicationGateway#host_names}
    */
    readonly hostNames?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#name ApplicationGateway#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#protocol ApplicationGateway#protocol}
    */
    readonly protocol: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#require_sni ApplicationGateway#require_sni}
    */
    readonly requireSni?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#ssl_certificate_name ApplicationGateway#ssl_certificate_name}
    */
    readonly sslCertificateName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#ssl_profile_name ApplicationGateway#ssl_profile_name}
    */
    readonly sslProfileName?: string;
    /**
    * custom_error_configuration block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#custom_error_configuration ApplicationGateway#custom_error_configuration}
    */
    readonly customErrorConfiguration?: ApplicationGatewayHttpListenerCustomErrorConfiguration[] | cdktf.IResolvable;
}
export declare function applicationGatewayHttpListenerToTerraform(struct?: ApplicationGatewayHttpListener | cdktf.IResolvable): any;
export declare class ApplicationGatewayHttpListenerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApplicationGatewayHttpListener | cdktf.IResolvable | undefined;
    set internalValue(value: ApplicationGatewayHttpListener | cdktf.IResolvable | undefined);
    private _firewallPolicyId?;
    get firewallPolicyId(): string;
    set firewallPolicyId(value: string);
    resetFirewallPolicyId(): void;
    get firewallPolicyIdInput(): string | undefined;
    get frontendIpConfigurationId(): string;
    private _frontendIpConfigurationName?;
    get frontendIpConfigurationName(): string;
    set frontendIpConfigurationName(value: string);
    get frontendIpConfigurationNameInput(): string | undefined;
    get frontendPortId(): string;
    private _frontendPortName?;
    get frontendPortName(): string;
    set frontendPortName(value: string);
    get frontendPortNameInput(): string | undefined;
    private _hostName?;
    get hostName(): string;
    set hostName(value: string);
    resetHostName(): void;
    get hostNameInput(): string | undefined;
    private _hostNames?;
    get hostNames(): string[];
    set hostNames(value: string[]);
    resetHostNames(): void;
    get hostNamesInput(): string[] | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _protocol?;
    get protocol(): string;
    set protocol(value: string);
    get protocolInput(): string | undefined;
    private _requireSni?;
    get requireSni(): boolean | cdktf.IResolvable;
    set requireSni(value: boolean | cdktf.IResolvable);
    resetRequireSni(): void;
    get requireSniInput(): boolean | cdktf.IResolvable | undefined;
    get sslCertificateId(): string;
    private _sslCertificateName?;
    get sslCertificateName(): string;
    set sslCertificateName(value: string);
    resetSslCertificateName(): void;
    get sslCertificateNameInput(): string | undefined;
    get sslProfileId(): string;
    private _sslProfileName?;
    get sslProfileName(): string;
    set sslProfileName(value: string);
    resetSslProfileName(): void;
    get sslProfileNameInput(): string | undefined;
    private _customErrorConfiguration;
    get customErrorConfiguration(): ApplicationGatewayHttpListenerCustomErrorConfigurationList;
    putCustomErrorConfiguration(value: ApplicationGatewayHttpListenerCustomErrorConfiguration[] | cdktf.IResolvable): void;
    resetCustomErrorConfiguration(): void;
    get customErrorConfigurationInput(): cdktf.IResolvable | ApplicationGatewayHttpListenerCustomErrorConfiguration[] | undefined;
}
export declare class ApplicationGatewayHttpListenerList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ApplicationGatewayHttpListener[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApplicationGatewayHttpListenerOutputReference;
}
export interface ApplicationGatewayIdentity {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#identity_ids ApplicationGateway#identity_ids}
    */
    readonly identityIds: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#type ApplicationGateway#type}
    */
    readonly type: string;
}
export declare function applicationGatewayIdentityToTerraform(struct?: ApplicationGatewayIdentityOutputReference | ApplicationGatewayIdentity): any;
export declare class ApplicationGatewayIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApplicationGatewayIdentity | undefined;
    set internalValue(value: ApplicationGatewayIdentity | undefined);
    private _identityIds?;
    get identityIds(): string[];
    set identityIds(value: string[]);
    get identityIdsInput(): string[] | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface ApplicationGatewayPrivateLinkConfigurationIpConfiguration {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#name ApplicationGateway#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#primary ApplicationGateway#primary}
    */
    readonly primary: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#private_ip_address ApplicationGateway#private_ip_address}
    */
    readonly privateIpAddress?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#private_ip_address_allocation ApplicationGateway#private_ip_address_allocation}
    */
    readonly privateIpAddressAllocation: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#subnet_id ApplicationGateway#subnet_id}
    */
    readonly subnetId: string;
}
export declare function applicationGatewayPrivateLinkConfigurationIpConfigurationToTerraform(struct?: ApplicationGatewayPrivateLinkConfigurationIpConfiguration | cdktf.IResolvable): any;
export declare class ApplicationGatewayPrivateLinkConfigurationIpConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApplicationGatewayPrivateLinkConfigurationIpConfiguration | cdktf.IResolvable | undefined;
    set internalValue(value: ApplicationGatewayPrivateLinkConfigurationIpConfiguration | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _primary?;
    get primary(): boolean | cdktf.IResolvable;
    set primary(value: boolean | cdktf.IResolvable);
    get primaryInput(): boolean | cdktf.IResolvable | undefined;
    private _privateIpAddress?;
    get privateIpAddress(): string;
    set privateIpAddress(value: string);
    resetPrivateIpAddress(): void;
    get privateIpAddressInput(): string | undefined;
    private _privateIpAddressAllocation?;
    get privateIpAddressAllocation(): string;
    set privateIpAddressAllocation(value: string);
    get privateIpAddressAllocationInput(): string | undefined;
    private _subnetId?;
    get subnetId(): string;
    set subnetId(value: string);
    get subnetIdInput(): string | undefined;
}
export declare class ApplicationGatewayPrivateLinkConfigurationIpConfigurationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ApplicationGatewayPrivateLinkConfigurationIpConfiguration[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApplicationGatewayPrivateLinkConfigurationIpConfigurationOutputReference;
}
export interface ApplicationGatewayPrivateLinkConfiguration {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#name ApplicationGateway#name}
    */
    readonly name: string;
    /**
    * ip_configuration block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#ip_configuration ApplicationGateway#ip_configuration}
    */
    readonly ipConfiguration: ApplicationGatewayPrivateLinkConfigurationIpConfiguration[] | cdktf.IResolvable;
}
export declare function applicationGatewayPrivateLinkConfigurationToTerraform(struct?: ApplicationGatewayPrivateLinkConfiguration | cdktf.IResolvable): any;
export declare class ApplicationGatewayPrivateLinkConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApplicationGatewayPrivateLinkConfiguration | cdktf.IResolvable | undefined;
    set internalValue(value: ApplicationGatewayPrivateLinkConfiguration | cdktf.IResolvable | undefined);
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _ipConfiguration;
    get ipConfiguration(): ApplicationGatewayPrivateLinkConfigurationIpConfigurationList;
    putIpConfiguration(value: ApplicationGatewayPrivateLinkConfigurationIpConfiguration[] | cdktf.IResolvable): void;
    get ipConfigurationInput(): cdktf.IResolvable | ApplicationGatewayPrivateLinkConfigurationIpConfiguration[] | undefined;
}
export declare class ApplicationGatewayPrivateLinkConfigurationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ApplicationGatewayPrivateLinkConfiguration[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApplicationGatewayPrivateLinkConfigurationOutputReference;
}
export interface ApplicationGatewayProbeMatch {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#body ApplicationGateway#body}
    */
    readonly body?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#status_code ApplicationGateway#status_code}
    */
    readonly statusCode: string[];
}
export declare function applicationGatewayProbeMatchToTerraform(struct?: ApplicationGatewayProbeMatchOutputReference | ApplicationGatewayProbeMatch): any;
export declare class ApplicationGatewayProbeMatchOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApplicationGatewayProbeMatch | undefined;
    set internalValue(value: ApplicationGatewayProbeMatch | undefined);
    private _body?;
    get body(): string;
    set body(value: string);
    resetBody(): void;
    get bodyInput(): string | undefined;
    private _statusCode?;
    get statusCode(): string[];
    set statusCode(value: string[]);
    get statusCodeInput(): string[] | undefined;
}
export interface ApplicationGatewayProbe {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#host ApplicationGateway#host}
    */
    readonly host?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#interval ApplicationGateway#interval}
    */
    readonly interval: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#minimum_servers ApplicationGateway#minimum_servers}
    */
    readonly minimumServers?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#name ApplicationGateway#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#path ApplicationGateway#path}
    */
    readonly path: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#pick_host_name_from_backend_http_settings ApplicationGateway#pick_host_name_from_backend_http_settings}
    */
    readonly pickHostNameFromBackendHttpSettings?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#port ApplicationGateway#port}
    */
    readonly port?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#protocol ApplicationGateway#protocol}
    */
    readonly protocol: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#timeout ApplicationGateway#timeout}
    */
    readonly timeout: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#unhealthy_threshold ApplicationGateway#unhealthy_threshold}
    */
    readonly unhealthyThreshold: number;
    /**
    * match block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#match ApplicationGateway#match}
    */
    readonly match?: ApplicationGatewayProbeMatch;
}
export declare function applicationGatewayProbeToTerraform(struct?: ApplicationGatewayProbe | cdktf.IResolvable): any;
export declare class ApplicationGatewayProbeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApplicationGatewayProbe | cdktf.IResolvable | undefined;
    set internalValue(value: ApplicationGatewayProbe | cdktf.IResolvable | undefined);
    private _host?;
    get host(): string;
    set host(value: string);
    resetHost(): void;
    get hostInput(): string | undefined;
    get id(): string;
    private _interval?;
    get interval(): number;
    set interval(value: number);
    get intervalInput(): number | undefined;
    private _minimumServers?;
    get minimumServers(): number;
    set minimumServers(value: number);
    resetMinimumServers(): void;
    get minimumServersInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
    private _pickHostNameFromBackendHttpSettings?;
    get pickHostNameFromBackendHttpSettings(): boolean | cdktf.IResolvable;
    set pickHostNameFromBackendHttpSettings(value: boolean | cdktf.IResolvable);
    resetPickHostNameFromBackendHttpSettings(): void;
    get pickHostNameFromBackendHttpSettingsInput(): boolean | cdktf.IResolvable | undefined;
    private _port?;
    get port(): number;
    set port(value: number);
    resetPort(): void;
    get portInput(): number | undefined;
    private _protocol?;
    get protocol(): string;
    set protocol(value: string);
    get protocolInput(): string | undefined;
    private _timeout?;
    get timeout(): number;
    set timeout(value: number);
    get timeoutInput(): number | undefined;
    private _unhealthyThreshold?;
    get unhealthyThreshold(): number;
    set unhealthyThreshold(value: number);
    get unhealthyThresholdInput(): number | undefined;
    private _match;
    get match(): ApplicationGatewayProbeMatchOutputReference;
    putMatch(value: ApplicationGatewayProbeMatch): void;
    resetMatch(): void;
    get matchInput(): ApplicationGatewayProbeMatch | undefined;
}
export declare class ApplicationGatewayProbeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ApplicationGatewayProbe[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApplicationGatewayProbeOutputReference;
}
export interface ApplicationGatewayRedirectConfiguration {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#include_path ApplicationGateway#include_path}
    */
    readonly includePath?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#include_query_string ApplicationGateway#include_query_string}
    */
    readonly includeQueryString?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#name ApplicationGateway#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#redirect_type ApplicationGateway#redirect_type}
    */
    readonly redirectType: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#target_listener_name ApplicationGateway#target_listener_name}
    */
    readonly targetListenerName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#target_url ApplicationGateway#target_url}
    */
    readonly targetUrl?: string;
}
export declare function applicationGatewayRedirectConfigurationToTerraform(struct?: ApplicationGatewayRedirectConfiguration | cdktf.IResolvable): any;
export declare class ApplicationGatewayRedirectConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApplicationGatewayRedirectConfiguration | cdktf.IResolvable | undefined;
    set internalValue(value: ApplicationGatewayRedirectConfiguration | cdktf.IResolvable | undefined);
    get id(): string;
    private _includePath?;
    get includePath(): boolean | cdktf.IResolvable;
    set includePath(value: boolean | cdktf.IResolvable);
    resetIncludePath(): void;
    get includePathInput(): boolean | cdktf.IResolvable | undefined;
    private _includeQueryString?;
    get includeQueryString(): boolean | cdktf.IResolvable;
    set includeQueryString(value: boolean | cdktf.IResolvable);
    resetIncludeQueryString(): void;
    get includeQueryStringInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _redirectType?;
    get redirectType(): string;
    set redirectType(value: string);
    get redirectTypeInput(): string | undefined;
    get targetListenerId(): string;
    private _targetListenerName?;
    get targetListenerName(): string;
    set targetListenerName(value: string);
    resetTargetListenerName(): void;
    get targetListenerNameInput(): string | undefined;
    private _targetUrl?;
    get targetUrl(): string;
    set targetUrl(value: string);
    resetTargetUrl(): void;
    get targetUrlInput(): string | undefined;
}
export declare class ApplicationGatewayRedirectConfigurationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ApplicationGatewayRedirectConfiguration[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApplicationGatewayRedirectConfigurationOutputReference;
}
export interface ApplicationGatewayRequestRoutingRule {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#backend_address_pool_name ApplicationGateway#backend_address_pool_name}
    */
    readonly backendAddressPoolName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#backend_http_settings_name ApplicationGateway#backend_http_settings_name}
    */
    readonly backendHttpSettingsName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#http_listener_name ApplicationGateway#http_listener_name}
    */
    readonly httpListenerName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#name ApplicationGateway#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#priority ApplicationGateway#priority}
    */
    readonly priority?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#redirect_configuration_name ApplicationGateway#redirect_configuration_name}
    */
    readonly redirectConfigurationName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#rewrite_rule_set_name ApplicationGateway#rewrite_rule_set_name}
    */
    readonly rewriteRuleSetName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#rule_type ApplicationGateway#rule_type}
    */
    readonly ruleType: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#url_path_map_name ApplicationGateway#url_path_map_name}
    */
    readonly urlPathMapName?: string;
}
export declare function applicationGatewayRequestRoutingRuleToTerraform(struct?: ApplicationGatewayRequestRoutingRule | cdktf.IResolvable): any;
export declare class ApplicationGatewayRequestRoutingRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApplicationGatewayRequestRoutingRule | cdktf.IResolvable | undefined;
    set internalValue(value: ApplicationGatewayRequestRoutingRule | cdktf.IResolvable | undefined);
    get backendAddressPoolId(): string;
    private _backendAddressPoolName?;
    get backendAddressPoolName(): string;
    set backendAddressPoolName(value: string);
    resetBackendAddressPoolName(): void;
    get backendAddressPoolNameInput(): string | undefined;
    get backendHttpSettingsId(): string;
    private _backendHttpSettingsName?;
    get backendHttpSettingsName(): string;
    set backendHttpSettingsName(value: string);
    resetBackendHttpSettingsName(): void;
    get backendHttpSettingsNameInput(): string | undefined;
    get httpListenerId(): string;
    private _httpListenerName?;
    get httpListenerName(): string;
    set httpListenerName(value: string);
    get httpListenerNameInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _priority?;
    get priority(): number;
    set priority(value: number);
    resetPriority(): void;
    get priorityInput(): number | undefined;
    get redirectConfigurationId(): string;
    private _redirectConfigurationName?;
    get redirectConfigurationName(): string;
    set redirectConfigurationName(value: string);
    resetRedirectConfigurationName(): void;
    get redirectConfigurationNameInput(): string | undefined;
    get rewriteRuleSetId(): string;
    private _rewriteRuleSetName?;
    get rewriteRuleSetName(): string;
    set rewriteRuleSetName(value: string);
    resetRewriteRuleSetName(): void;
    get rewriteRuleSetNameInput(): string | undefined;
    private _ruleType?;
    get ruleType(): string;
    set ruleType(value: string);
    get ruleTypeInput(): string | undefined;
    get urlPathMapId(): string;
    private _urlPathMapName?;
    get urlPathMapName(): string;
    set urlPathMapName(value: string);
    resetUrlPathMapName(): void;
    get urlPathMapNameInput(): string | undefined;
}
export declare class ApplicationGatewayRequestRoutingRuleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ApplicationGatewayRequestRoutingRule[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApplicationGatewayRequestRoutingRuleOutputReference;
}
export interface ApplicationGatewayRewriteRuleSetRewriteRuleCondition {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#ignore_case ApplicationGateway#ignore_case}
    */
    readonly ignoreCase?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#negate ApplicationGateway#negate}
    */
    readonly negate?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#pattern ApplicationGateway#pattern}
    */
    readonly pattern: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#variable ApplicationGateway#variable}
    */
    readonly variable: string;
}
export declare function applicationGatewayRewriteRuleSetRewriteRuleConditionToTerraform(struct?: ApplicationGatewayRewriteRuleSetRewriteRuleCondition | cdktf.IResolvable): any;
export declare class ApplicationGatewayRewriteRuleSetRewriteRuleConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApplicationGatewayRewriteRuleSetRewriteRuleCondition | cdktf.IResolvable | undefined;
    set internalValue(value: ApplicationGatewayRewriteRuleSetRewriteRuleCondition | cdktf.IResolvable | undefined);
    private _ignoreCase?;
    get ignoreCase(): boolean | cdktf.IResolvable;
    set ignoreCase(value: boolean | cdktf.IResolvable);
    resetIgnoreCase(): void;
    get ignoreCaseInput(): boolean | cdktf.IResolvable | undefined;
    private _negate?;
    get negate(): boolean | cdktf.IResolvable;
    set negate(value: boolean | cdktf.IResolvable);
    resetNegate(): void;
    get negateInput(): boolean | cdktf.IResolvable | undefined;
    private _pattern?;
    get pattern(): string;
    set pattern(value: string);
    get patternInput(): string | undefined;
    private _variable?;
    get variable(): string;
    set variable(value: string);
    get variableInput(): string | undefined;
}
export declare class ApplicationGatewayRewriteRuleSetRewriteRuleConditionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ApplicationGatewayRewriteRuleSetRewriteRuleCondition[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApplicationGatewayRewriteRuleSetRewriteRuleConditionOutputReference;
}
export interface ApplicationGatewayRewriteRuleSetRewriteRuleRequestHeaderConfiguration {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#header_name ApplicationGateway#header_name}
    */
    readonly headerName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#header_value ApplicationGateway#header_value}
    */
    readonly headerValue: string;
}
export declare function applicationGatewayRewriteRuleSetRewriteRuleRequestHeaderConfigurationToTerraform(struct?: ApplicationGatewayRewriteRuleSetRewriteRuleRequestHeaderConfiguration | cdktf.IResolvable): any;
export declare class ApplicationGatewayRewriteRuleSetRewriteRuleRequestHeaderConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApplicationGatewayRewriteRuleSetRewriteRuleRequestHeaderConfiguration | cdktf.IResolvable | undefined;
    set internalValue(value: ApplicationGatewayRewriteRuleSetRewriteRuleRequestHeaderConfiguration | cdktf.IResolvable | undefined);
    private _headerName?;
    get headerName(): string;
    set headerName(value: string);
    get headerNameInput(): string | undefined;
    private _headerValue?;
    get headerValue(): string;
    set headerValue(value: string);
    get headerValueInput(): string | undefined;
}
export declare class ApplicationGatewayRewriteRuleSetRewriteRuleRequestHeaderConfigurationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ApplicationGatewayRewriteRuleSetRewriteRuleRequestHeaderConfiguration[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApplicationGatewayRewriteRuleSetRewriteRuleRequestHeaderConfigurationOutputReference;
}
export interface ApplicationGatewayRewriteRuleSetRewriteRuleResponseHeaderConfiguration {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#header_name ApplicationGateway#header_name}
    */
    readonly headerName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#header_value ApplicationGateway#header_value}
    */
    readonly headerValue: string;
}
export declare function applicationGatewayRewriteRuleSetRewriteRuleResponseHeaderConfigurationToTerraform(struct?: ApplicationGatewayRewriteRuleSetRewriteRuleResponseHeaderConfiguration | cdktf.IResolvable): any;
export declare class ApplicationGatewayRewriteRuleSetRewriteRuleResponseHeaderConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApplicationGatewayRewriteRuleSetRewriteRuleResponseHeaderConfiguration | cdktf.IResolvable | undefined;
    set internalValue(value: ApplicationGatewayRewriteRuleSetRewriteRuleResponseHeaderConfiguration | cdktf.IResolvable | undefined);
    private _headerName?;
    get headerName(): string;
    set headerName(value: string);
    get headerNameInput(): string | undefined;
    private _headerValue?;
    get headerValue(): string;
    set headerValue(value: string);
    get headerValueInput(): string | undefined;
}
export declare class ApplicationGatewayRewriteRuleSetRewriteRuleResponseHeaderConfigurationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ApplicationGatewayRewriteRuleSetRewriteRuleResponseHeaderConfiguration[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApplicationGatewayRewriteRuleSetRewriteRuleResponseHeaderConfigurationOutputReference;
}
export interface ApplicationGatewayRewriteRuleSetRewriteRuleUrl {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#components ApplicationGateway#components}
    */
    readonly components?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#path ApplicationGateway#path}
    */
    readonly path?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#query_string ApplicationGateway#query_string}
    */
    readonly queryString?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#reroute ApplicationGateway#reroute}
    */
    readonly reroute?: boolean | cdktf.IResolvable;
}
export declare function applicationGatewayRewriteRuleSetRewriteRuleUrlToTerraform(struct?: ApplicationGatewayRewriteRuleSetRewriteRuleUrlOutputReference | ApplicationGatewayRewriteRuleSetRewriteRuleUrl): any;
export declare class ApplicationGatewayRewriteRuleSetRewriteRuleUrlOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApplicationGatewayRewriteRuleSetRewriteRuleUrl | undefined;
    set internalValue(value: ApplicationGatewayRewriteRuleSetRewriteRuleUrl | undefined);
    private _components?;
    get components(): string;
    set components(value: string);
    resetComponents(): void;
    get componentsInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _queryString?;
    get queryString(): string;
    set queryString(value: string);
    resetQueryString(): void;
    get queryStringInput(): string | undefined;
    private _reroute?;
    get reroute(): boolean | cdktf.IResolvable;
    set reroute(value: boolean | cdktf.IResolvable);
    resetReroute(): void;
    get rerouteInput(): boolean | cdktf.IResolvable | undefined;
}
export interface ApplicationGatewayRewriteRuleSetRewriteRule {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#name ApplicationGateway#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#rule_sequence ApplicationGateway#rule_sequence}
    */
    readonly ruleSequence: number;
    /**
    * condition block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#condition ApplicationGateway#condition}
    */
    readonly condition?: ApplicationGatewayRewriteRuleSetRewriteRuleCondition[] | cdktf.IResolvable;
    /**
    * request_header_configuration block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#request_header_configuration ApplicationGateway#request_header_configuration}
    */
    readonly requestHeaderConfiguration?: ApplicationGatewayRewriteRuleSetRewriteRuleRequestHeaderConfiguration[] | cdktf.IResolvable;
    /**
    * response_header_configuration block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#response_header_configuration ApplicationGateway#response_header_configuration}
    */
    readonly responseHeaderConfiguration?: ApplicationGatewayRewriteRuleSetRewriteRuleResponseHeaderConfiguration[] | cdktf.IResolvable;
    /**
    * url block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#url ApplicationGateway#url}
    */
    readonly url?: ApplicationGatewayRewriteRuleSetRewriteRuleUrl;
}
export declare function applicationGatewayRewriteRuleSetRewriteRuleToTerraform(struct?: ApplicationGatewayRewriteRuleSetRewriteRule | cdktf.IResolvable): any;
export declare class ApplicationGatewayRewriteRuleSetRewriteRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApplicationGatewayRewriteRuleSetRewriteRule | cdktf.IResolvable | undefined;
    set internalValue(value: ApplicationGatewayRewriteRuleSetRewriteRule | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _ruleSequence?;
    get ruleSequence(): number;
    set ruleSequence(value: number);
    get ruleSequenceInput(): number | undefined;
    private _condition;
    get condition(): ApplicationGatewayRewriteRuleSetRewriteRuleConditionList;
    putCondition(value: ApplicationGatewayRewriteRuleSetRewriteRuleCondition[] | cdktf.IResolvable): void;
    resetCondition(): void;
    get conditionInput(): cdktf.IResolvable | ApplicationGatewayRewriteRuleSetRewriteRuleCondition[] | undefined;
    private _requestHeaderConfiguration;
    get requestHeaderConfiguration(): ApplicationGatewayRewriteRuleSetRewriteRuleRequestHeaderConfigurationList;
    putRequestHeaderConfiguration(value: ApplicationGatewayRewriteRuleSetRewriteRuleRequestHeaderConfiguration[] | cdktf.IResolvable): void;
    resetRequestHeaderConfiguration(): void;
    get requestHeaderConfigurationInput(): cdktf.IResolvable | ApplicationGatewayRewriteRuleSetRewriteRuleRequestHeaderConfiguration[] | undefined;
    private _responseHeaderConfiguration;
    get responseHeaderConfiguration(): ApplicationGatewayRewriteRuleSetRewriteRuleResponseHeaderConfigurationList;
    putResponseHeaderConfiguration(value: ApplicationGatewayRewriteRuleSetRewriteRuleResponseHeaderConfiguration[] | cdktf.IResolvable): void;
    resetResponseHeaderConfiguration(): void;
    get responseHeaderConfigurationInput(): cdktf.IResolvable | ApplicationGatewayRewriteRuleSetRewriteRuleResponseHeaderConfiguration[] | undefined;
    private _url;
    get url(): ApplicationGatewayRewriteRuleSetRewriteRuleUrlOutputReference;
    putUrl(value: ApplicationGatewayRewriteRuleSetRewriteRuleUrl): void;
    resetUrl(): void;
    get urlInput(): ApplicationGatewayRewriteRuleSetRewriteRuleUrl | undefined;
}
export declare class ApplicationGatewayRewriteRuleSetRewriteRuleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ApplicationGatewayRewriteRuleSetRewriteRule[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApplicationGatewayRewriteRuleSetRewriteRuleOutputReference;
}
export interface ApplicationGatewayRewriteRuleSet {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#name ApplicationGateway#name}
    */
    readonly name: string;
    /**
    * rewrite_rule block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#rewrite_rule ApplicationGateway#rewrite_rule}
    */
    readonly rewriteRule?: ApplicationGatewayRewriteRuleSetRewriteRule[] | cdktf.IResolvable;
}
export declare function applicationGatewayRewriteRuleSetToTerraform(struct?: ApplicationGatewayRewriteRuleSet | cdktf.IResolvable): any;
export declare class ApplicationGatewayRewriteRuleSetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApplicationGatewayRewriteRuleSet | cdktf.IResolvable | undefined;
    set internalValue(value: ApplicationGatewayRewriteRuleSet | cdktf.IResolvable | undefined);
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _rewriteRule;
    get rewriteRule(): ApplicationGatewayRewriteRuleSetRewriteRuleList;
    putRewriteRule(value: ApplicationGatewayRewriteRuleSetRewriteRule[] | cdktf.IResolvable): void;
    resetRewriteRule(): void;
    get rewriteRuleInput(): cdktf.IResolvable | ApplicationGatewayRewriteRuleSetRewriteRule[] | undefined;
}
export declare class ApplicationGatewayRewriteRuleSetList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ApplicationGatewayRewriteRuleSet[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApplicationGatewayRewriteRuleSetOutputReference;
}
export interface ApplicationGatewaySku {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#capacity ApplicationGateway#capacity}
    */
    readonly capacity?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#name ApplicationGateway#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#tier ApplicationGateway#tier}
    */
    readonly tier: string;
}
export declare function applicationGatewaySkuToTerraform(struct?: ApplicationGatewaySkuOutputReference | ApplicationGatewaySku): any;
export declare class ApplicationGatewaySkuOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApplicationGatewaySku | undefined;
    set internalValue(value: ApplicationGatewaySku | undefined);
    private _capacity?;
    get capacity(): number;
    set capacity(value: number);
    resetCapacity(): void;
    get capacityInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _tier?;
    get tier(): string;
    set tier(value: string);
    get tierInput(): string | undefined;
}
export interface ApplicationGatewaySslCertificate {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#data ApplicationGateway#data}
    */
    readonly data?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#key_vault_secret_id ApplicationGateway#key_vault_secret_id}
    */
    readonly keyVaultSecretId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#name ApplicationGateway#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#password ApplicationGateway#password}
    */
    readonly password?: string;
}
export declare function applicationGatewaySslCertificateToTerraform(struct?: ApplicationGatewaySslCertificate | cdktf.IResolvable): any;
export declare class ApplicationGatewaySslCertificateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApplicationGatewaySslCertificate | cdktf.IResolvable | undefined;
    set internalValue(value: ApplicationGatewaySslCertificate | cdktf.IResolvable | undefined);
    private _data?;
    get data(): string;
    set data(value: string);
    resetData(): void;
    get dataInput(): string | undefined;
    get id(): string;
    private _keyVaultSecretId?;
    get keyVaultSecretId(): string;
    set keyVaultSecretId(value: string);
    resetKeyVaultSecretId(): void;
    get keyVaultSecretIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    get publicCertData(): string;
}
export declare class ApplicationGatewaySslCertificateList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ApplicationGatewaySslCertificate[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApplicationGatewaySslCertificateOutputReference;
}
export interface ApplicationGatewaySslPolicy {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#cipher_suites ApplicationGateway#cipher_suites}
    */
    readonly cipherSuites?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#disabled_protocols ApplicationGateway#disabled_protocols}
    */
    readonly disabledProtocols?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#min_protocol_version ApplicationGateway#min_protocol_version}
    */
    readonly minProtocolVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#policy_name ApplicationGateway#policy_name}
    */
    readonly policyName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#policy_type ApplicationGateway#policy_type}
    */
    readonly policyType?: string;
}
export declare function applicationGatewaySslPolicyToTerraform(struct?: ApplicationGatewaySslPolicyOutputReference | ApplicationGatewaySslPolicy): any;
export declare class ApplicationGatewaySslPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApplicationGatewaySslPolicy | undefined;
    set internalValue(value: ApplicationGatewaySslPolicy | undefined);
    private _cipherSuites?;
    get cipherSuites(): string[];
    set cipherSuites(value: string[]);
    resetCipherSuites(): void;
    get cipherSuitesInput(): string[] | undefined;
    private _disabledProtocols?;
    get disabledProtocols(): string[];
    set disabledProtocols(value: string[]);
    resetDisabledProtocols(): void;
    get disabledProtocolsInput(): string[] | undefined;
    private _minProtocolVersion?;
    get minProtocolVersion(): string;
    set minProtocolVersion(value: string);
    resetMinProtocolVersion(): void;
    get minProtocolVersionInput(): string | undefined;
    private _policyName?;
    get policyName(): string;
    set policyName(value: string);
    resetPolicyName(): void;
    get policyNameInput(): string | undefined;
    private _policyType?;
    get policyType(): string;
    set policyType(value: string);
    resetPolicyType(): void;
    get policyTypeInput(): string | undefined;
}
export interface ApplicationGatewaySslProfileSslPolicy {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#cipher_suites ApplicationGateway#cipher_suites}
    */
    readonly cipherSuites?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#disabled_protocols ApplicationGateway#disabled_protocols}
    */
    readonly disabledProtocols?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#min_protocol_version ApplicationGateway#min_protocol_version}
    */
    readonly minProtocolVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#policy_name ApplicationGateway#policy_name}
    */
    readonly policyName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#policy_type ApplicationGateway#policy_type}
    */
    readonly policyType?: string;
}
export declare function applicationGatewaySslProfileSslPolicyToTerraform(struct?: ApplicationGatewaySslProfileSslPolicyOutputReference | ApplicationGatewaySslProfileSslPolicy): any;
export declare class ApplicationGatewaySslProfileSslPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApplicationGatewaySslProfileSslPolicy | undefined;
    set internalValue(value: ApplicationGatewaySslProfileSslPolicy | undefined);
    private _cipherSuites?;
    get cipherSuites(): string[];
    set cipherSuites(value: string[]);
    resetCipherSuites(): void;
    get cipherSuitesInput(): string[] | undefined;
    private _disabledProtocols?;
    get disabledProtocols(): string[];
    set disabledProtocols(value: string[]);
    resetDisabledProtocols(): void;
    get disabledProtocolsInput(): string[] | undefined;
    private _minProtocolVersion?;
    get minProtocolVersion(): string;
    set minProtocolVersion(value: string);
    resetMinProtocolVersion(): void;
    get minProtocolVersionInput(): string | undefined;
    private _policyName?;
    get policyName(): string;
    set policyName(value: string);
    resetPolicyName(): void;
    get policyNameInput(): string | undefined;
    private _policyType?;
    get policyType(): string;
    set policyType(value: string);
    resetPolicyType(): void;
    get policyTypeInput(): string | undefined;
}
export interface ApplicationGatewaySslProfile {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#name ApplicationGateway#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#trusted_client_certificate_names ApplicationGateway#trusted_client_certificate_names}
    */
    readonly trustedClientCertificateNames?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#verify_client_cert_issuer_dn ApplicationGateway#verify_client_cert_issuer_dn}
    */
    readonly verifyClientCertIssuerDn?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#verify_client_certificate_revocation ApplicationGateway#verify_client_certificate_revocation}
    */
    readonly verifyClientCertificateRevocation?: string;
    /**
    * ssl_policy block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#ssl_policy ApplicationGateway#ssl_policy}
    */
    readonly sslPolicy?: ApplicationGatewaySslProfileSslPolicy;
}
export declare function applicationGatewaySslProfileToTerraform(struct?: ApplicationGatewaySslProfile | cdktf.IResolvable): any;
export declare class ApplicationGatewaySslProfileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApplicationGatewaySslProfile | cdktf.IResolvable | undefined;
    set internalValue(value: ApplicationGatewaySslProfile | cdktf.IResolvable | undefined);
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _trustedClientCertificateNames?;
    get trustedClientCertificateNames(): string[];
    set trustedClientCertificateNames(value: string[]);
    resetTrustedClientCertificateNames(): void;
    get trustedClientCertificateNamesInput(): string[] | undefined;
    private _verifyClientCertIssuerDn?;
    get verifyClientCertIssuerDn(): boolean | cdktf.IResolvable;
    set verifyClientCertIssuerDn(value: boolean | cdktf.IResolvable);
    resetVerifyClientCertIssuerDn(): void;
    get verifyClientCertIssuerDnInput(): boolean | cdktf.IResolvable | undefined;
    private _verifyClientCertificateRevocation?;
    get verifyClientCertificateRevocation(): string;
    set verifyClientCertificateRevocation(value: string);
    resetVerifyClientCertificateRevocation(): void;
    get verifyClientCertificateRevocationInput(): string | undefined;
    private _sslPolicy;
    get sslPolicy(): ApplicationGatewaySslProfileSslPolicyOutputReference;
    putSslPolicy(value: ApplicationGatewaySslProfileSslPolicy): void;
    resetSslPolicy(): void;
    get sslPolicyInput(): ApplicationGatewaySslProfileSslPolicy | undefined;
}
export declare class ApplicationGatewaySslProfileList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ApplicationGatewaySslProfile[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApplicationGatewaySslProfileOutputReference;
}
export interface ApplicationGatewayTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#create ApplicationGateway#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#delete ApplicationGateway#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#read ApplicationGateway#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#update ApplicationGateway#update}
    */
    readonly update?: string;
}
export declare function applicationGatewayTimeoutsToTerraform(struct?: ApplicationGatewayTimeouts | cdktf.IResolvable): any;
export declare class ApplicationGatewayTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApplicationGatewayTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ApplicationGatewayTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface ApplicationGatewayTrustedClientCertificate {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#data ApplicationGateway#data}
    */
    readonly data: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#name ApplicationGateway#name}
    */
    readonly name: string;
}
export declare function applicationGatewayTrustedClientCertificateToTerraform(struct?: ApplicationGatewayTrustedClientCertificate | cdktf.IResolvable): any;
export declare class ApplicationGatewayTrustedClientCertificateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApplicationGatewayTrustedClientCertificate | cdktf.IResolvable | undefined;
    set internalValue(value: ApplicationGatewayTrustedClientCertificate | cdktf.IResolvable | undefined);
    private _data?;
    get data(): string;
    set data(value: string);
    get dataInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
export declare class ApplicationGatewayTrustedClientCertificateList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ApplicationGatewayTrustedClientCertificate[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApplicationGatewayTrustedClientCertificateOutputReference;
}
export interface ApplicationGatewayTrustedRootCertificate {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#data ApplicationGateway#data}
    */
    readonly data?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#key_vault_secret_id ApplicationGateway#key_vault_secret_id}
    */
    readonly keyVaultSecretId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#name ApplicationGateway#name}
    */
    readonly name: string;
}
export declare function applicationGatewayTrustedRootCertificateToTerraform(struct?: ApplicationGatewayTrustedRootCertificate | cdktf.IResolvable): any;
export declare class ApplicationGatewayTrustedRootCertificateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApplicationGatewayTrustedRootCertificate | cdktf.IResolvable | undefined;
    set internalValue(value: ApplicationGatewayTrustedRootCertificate | cdktf.IResolvable | undefined);
    private _data?;
    get data(): string;
    set data(value: string);
    resetData(): void;
    get dataInput(): string | undefined;
    get id(): string;
    private _keyVaultSecretId?;
    get keyVaultSecretId(): string;
    set keyVaultSecretId(value: string);
    resetKeyVaultSecretId(): void;
    get keyVaultSecretIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
export declare class ApplicationGatewayTrustedRootCertificateList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ApplicationGatewayTrustedRootCertificate[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApplicationGatewayTrustedRootCertificateOutputReference;
}
export interface ApplicationGatewayUrlPathMapPathRule {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#backend_address_pool_name ApplicationGateway#backend_address_pool_name}
    */
    readonly backendAddressPoolName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#backend_http_settings_name ApplicationGateway#backend_http_settings_name}
    */
    readonly backendHttpSettingsName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#firewall_policy_id ApplicationGateway#firewall_policy_id}
    */
    readonly firewallPolicyId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#name ApplicationGateway#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#paths ApplicationGateway#paths}
    */
    readonly paths: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#redirect_configuration_name ApplicationGateway#redirect_configuration_name}
    */
    readonly redirectConfigurationName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#rewrite_rule_set_name ApplicationGateway#rewrite_rule_set_name}
    */
    readonly rewriteRuleSetName?: string;
}
export declare function applicationGatewayUrlPathMapPathRuleToTerraform(struct?: ApplicationGatewayUrlPathMapPathRule | cdktf.IResolvable): any;
export declare class ApplicationGatewayUrlPathMapPathRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApplicationGatewayUrlPathMapPathRule | cdktf.IResolvable | undefined;
    set internalValue(value: ApplicationGatewayUrlPathMapPathRule | cdktf.IResolvable | undefined);
    get backendAddressPoolId(): string;
    private _backendAddressPoolName?;
    get backendAddressPoolName(): string;
    set backendAddressPoolName(value: string);
    resetBackendAddressPoolName(): void;
    get backendAddressPoolNameInput(): string | undefined;
    get backendHttpSettingsId(): string;
    private _backendHttpSettingsName?;
    get backendHttpSettingsName(): string;
    set backendHttpSettingsName(value: string);
    resetBackendHttpSettingsName(): void;
    get backendHttpSettingsNameInput(): string | undefined;
    private _firewallPolicyId?;
    get firewallPolicyId(): string;
    set firewallPolicyId(value: string);
    resetFirewallPolicyId(): void;
    get firewallPolicyIdInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _paths?;
    get paths(): string[];
    set paths(value: string[]);
    get pathsInput(): string[] | undefined;
    get redirectConfigurationId(): string;
    private _redirectConfigurationName?;
    get redirectConfigurationName(): string;
    set redirectConfigurationName(value: string);
    resetRedirectConfigurationName(): void;
    get redirectConfigurationNameInput(): string | undefined;
    get rewriteRuleSetId(): string;
    private _rewriteRuleSetName?;
    get rewriteRuleSetName(): string;
    set rewriteRuleSetName(value: string);
    resetRewriteRuleSetName(): void;
    get rewriteRuleSetNameInput(): string | undefined;
}
export declare class ApplicationGatewayUrlPathMapPathRuleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ApplicationGatewayUrlPathMapPathRule[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApplicationGatewayUrlPathMapPathRuleOutputReference;
}
export interface ApplicationGatewayUrlPathMap {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#default_backend_address_pool_name ApplicationGateway#default_backend_address_pool_name}
    */
    readonly defaultBackendAddressPoolName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#default_backend_http_settings_name ApplicationGateway#default_backend_http_settings_name}
    */
    readonly defaultBackendHttpSettingsName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#default_redirect_configuration_name ApplicationGateway#default_redirect_configuration_name}
    */
    readonly defaultRedirectConfigurationName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#default_rewrite_rule_set_name ApplicationGateway#default_rewrite_rule_set_name}
    */
    readonly defaultRewriteRuleSetName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#name ApplicationGateway#name}
    */
    readonly name: string;
    /**
    * path_rule block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#path_rule ApplicationGateway#path_rule}
    */
    readonly pathRule: ApplicationGatewayUrlPathMapPathRule[] | cdktf.IResolvable;
}
export declare function applicationGatewayUrlPathMapToTerraform(struct?: ApplicationGatewayUrlPathMap | cdktf.IResolvable): any;
export declare class ApplicationGatewayUrlPathMapOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApplicationGatewayUrlPathMap | cdktf.IResolvable | undefined;
    set internalValue(value: ApplicationGatewayUrlPathMap | cdktf.IResolvable | undefined);
    get defaultBackendAddressPoolId(): string;
    private _defaultBackendAddressPoolName?;
    get defaultBackendAddressPoolName(): string;
    set defaultBackendAddressPoolName(value: string);
    resetDefaultBackendAddressPoolName(): void;
    get defaultBackendAddressPoolNameInput(): string | undefined;
    get defaultBackendHttpSettingsId(): string;
    private _defaultBackendHttpSettingsName?;
    get defaultBackendHttpSettingsName(): string;
    set defaultBackendHttpSettingsName(value: string);
    resetDefaultBackendHttpSettingsName(): void;
    get defaultBackendHttpSettingsNameInput(): string | undefined;
    get defaultRedirectConfigurationId(): string;
    private _defaultRedirectConfigurationName?;
    get defaultRedirectConfigurationName(): string;
    set defaultRedirectConfigurationName(value: string);
    resetDefaultRedirectConfigurationName(): void;
    get defaultRedirectConfigurationNameInput(): string | undefined;
    get defaultRewriteRuleSetId(): string;
    private _defaultRewriteRuleSetName?;
    get defaultRewriteRuleSetName(): string;
    set defaultRewriteRuleSetName(value: string);
    resetDefaultRewriteRuleSetName(): void;
    get defaultRewriteRuleSetNameInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _pathRule;
    get pathRule(): ApplicationGatewayUrlPathMapPathRuleList;
    putPathRule(value: ApplicationGatewayUrlPathMapPathRule[] | cdktf.IResolvable): void;
    get pathRuleInput(): cdktf.IResolvable | ApplicationGatewayUrlPathMapPathRule[] | undefined;
}
export declare class ApplicationGatewayUrlPathMapList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ApplicationGatewayUrlPathMap[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApplicationGatewayUrlPathMapOutputReference;
}
export interface ApplicationGatewayWafConfigurationDisabledRuleGroup {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#rule_group_name ApplicationGateway#rule_group_name}
    */
    readonly ruleGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#rules ApplicationGateway#rules}
    */
    readonly rules?: number[];
}
export declare function applicationGatewayWafConfigurationDisabledRuleGroupToTerraform(struct?: ApplicationGatewayWafConfigurationDisabledRuleGroup | cdktf.IResolvable): any;
export declare class ApplicationGatewayWafConfigurationDisabledRuleGroupOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApplicationGatewayWafConfigurationDisabledRuleGroup | cdktf.IResolvable | undefined;
    set internalValue(value: ApplicationGatewayWafConfigurationDisabledRuleGroup | cdktf.IResolvable | undefined);
    private _ruleGroupName?;
    get ruleGroupName(): string;
    set ruleGroupName(value: string);
    get ruleGroupNameInput(): string | undefined;
    private _rules?;
    get rules(): number[];
    set rules(value: number[]);
    resetRules(): void;
    get rulesInput(): number[] | undefined;
}
export declare class ApplicationGatewayWafConfigurationDisabledRuleGroupList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ApplicationGatewayWafConfigurationDisabledRuleGroup[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApplicationGatewayWafConfigurationDisabledRuleGroupOutputReference;
}
export interface ApplicationGatewayWafConfigurationExclusion {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#match_variable ApplicationGateway#match_variable}
    */
    readonly matchVariable: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#selector ApplicationGateway#selector}
    */
    readonly selector?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#selector_match_operator ApplicationGateway#selector_match_operator}
    */
    readonly selectorMatchOperator?: string;
}
export declare function applicationGatewayWafConfigurationExclusionToTerraform(struct?: ApplicationGatewayWafConfigurationExclusion | cdktf.IResolvable): any;
export declare class ApplicationGatewayWafConfigurationExclusionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApplicationGatewayWafConfigurationExclusion | cdktf.IResolvable | undefined;
    set internalValue(value: ApplicationGatewayWafConfigurationExclusion | cdktf.IResolvable | undefined);
    private _matchVariable?;
    get matchVariable(): string;
    set matchVariable(value: string);
    get matchVariableInput(): string | undefined;
    private _selector?;
    get selector(): string;
    set selector(value: string);
    resetSelector(): void;
    get selectorInput(): string | undefined;
    private _selectorMatchOperator?;
    get selectorMatchOperator(): string;
    set selectorMatchOperator(value: string);
    resetSelectorMatchOperator(): void;
    get selectorMatchOperatorInput(): string | undefined;
}
export declare class ApplicationGatewayWafConfigurationExclusionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ApplicationGatewayWafConfigurationExclusion[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApplicationGatewayWafConfigurationExclusionOutputReference;
}
export interface ApplicationGatewayWafConfiguration {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#enabled ApplicationGateway#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#file_upload_limit_mb ApplicationGateway#file_upload_limit_mb}
    */
    readonly fileUploadLimitMb?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#firewall_mode ApplicationGateway#firewall_mode}
    */
    readonly firewallMode: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#max_request_body_size_kb ApplicationGateway#max_request_body_size_kb}
    */
    readonly maxRequestBodySizeKb?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#request_body_check ApplicationGateway#request_body_check}
    */
    readonly requestBodyCheck?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#rule_set_type ApplicationGateway#rule_set_type}
    */
    readonly ruleSetType?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#rule_set_version ApplicationGateway#rule_set_version}
    */
    readonly ruleSetVersion: string;
    /**
    * disabled_rule_group block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#disabled_rule_group ApplicationGateway#disabled_rule_group}
    */
    readonly disabledRuleGroup?: ApplicationGatewayWafConfigurationDisabledRuleGroup[] | cdktf.IResolvable;
    /**
    * exclusion block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#exclusion ApplicationGateway#exclusion}
    */
    readonly exclusion?: ApplicationGatewayWafConfigurationExclusion[] | cdktf.IResolvable;
}
export declare function applicationGatewayWafConfigurationToTerraform(struct?: ApplicationGatewayWafConfigurationOutputReference | ApplicationGatewayWafConfiguration): any;
export declare class ApplicationGatewayWafConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApplicationGatewayWafConfiguration | undefined;
    set internalValue(value: ApplicationGatewayWafConfiguration | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _fileUploadLimitMb?;
    get fileUploadLimitMb(): number;
    set fileUploadLimitMb(value: number);
    resetFileUploadLimitMb(): void;
    get fileUploadLimitMbInput(): number | undefined;
    private _firewallMode?;
    get firewallMode(): string;
    set firewallMode(value: string);
    get firewallModeInput(): string | undefined;
    private _maxRequestBodySizeKb?;
    get maxRequestBodySizeKb(): number;
    set maxRequestBodySizeKb(value: number);
    resetMaxRequestBodySizeKb(): void;
    get maxRequestBodySizeKbInput(): number | undefined;
    private _requestBodyCheck?;
    get requestBodyCheck(): boolean | cdktf.IResolvable;
    set requestBodyCheck(value: boolean | cdktf.IResolvable);
    resetRequestBodyCheck(): void;
    get requestBodyCheckInput(): boolean | cdktf.IResolvable | undefined;
    private _ruleSetType?;
    get ruleSetType(): string;
    set ruleSetType(value: string);
    resetRuleSetType(): void;
    get ruleSetTypeInput(): string | undefined;
    private _ruleSetVersion?;
    get ruleSetVersion(): string;
    set ruleSetVersion(value: string);
    get ruleSetVersionInput(): string | undefined;
    private _disabledRuleGroup;
    get disabledRuleGroup(): ApplicationGatewayWafConfigurationDisabledRuleGroupList;
    putDisabledRuleGroup(value: ApplicationGatewayWafConfigurationDisabledRuleGroup[] | cdktf.IResolvable): void;
    resetDisabledRuleGroup(): void;
    get disabledRuleGroupInput(): cdktf.IResolvable | ApplicationGatewayWafConfigurationDisabledRuleGroup[] | undefined;
    private _exclusion;
    get exclusion(): ApplicationGatewayWafConfigurationExclusionList;
    putExclusion(value: ApplicationGatewayWafConfigurationExclusion[] | cdktf.IResolvable): void;
    resetExclusion(): void;
    get exclusionInput(): cdktf.IResolvable | ApplicationGatewayWafConfigurationExclusion[] | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway azurerm_application_gateway}
*/
export declare class ApplicationGateway extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_application_gateway";
    /**
    * Generates CDKTF code for importing a ApplicationGateway resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the ApplicationGateway to import
    * @param importFromId The id of the existing ApplicationGateway that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the ApplicationGateway to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/application_gateway azurerm_application_gateway} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ApplicationGatewayConfig
    */
    constructor(scope: Construct, id: string, config: ApplicationGatewayConfig);
    private _enableHttp2?;
    get enableHttp2(): boolean | cdktf.IResolvable;
    set enableHttp2(value: boolean | cdktf.IResolvable);
    resetEnableHttp2(): void;
    get enableHttp2Input(): boolean | cdktf.IResolvable | undefined;
    private _fipsEnabled?;
    get fipsEnabled(): boolean | cdktf.IResolvable;
    set fipsEnabled(value: boolean | cdktf.IResolvable);
    resetFipsEnabled(): void;
    get fipsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _firewallPolicyId?;
    get firewallPolicyId(): string;
    set firewallPolicyId(value: string);
    resetFirewallPolicyId(): void;
    get firewallPolicyIdInput(): string | undefined;
    private _forceFirewallPolicyAssociation?;
    get forceFirewallPolicyAssociation(): boolean | cdktf.IResolvable;
    set forceFirewallPolicyAssociation(value: boolean | cdktf.IResolvable);
    resetForceFirewallPolicyAssociation(): void;
    get forceFirewallPolicyAssociationInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _privateEndpointConnection;
    get privateEndpointConnection(): ApplicationGatewayPrivateEndpointConnectionList;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _zones?;
    get zones(): string[];
    set zones(value: string[]);
    resetZones(): void;
    get zonesInput(): string[] | undefined;
    private _authenticationCertificate;
    get authenticationCertificate(): ApplicationGatewayAuthenticationCertificateList;
    putAuthenticationCertificate(value: ApplicationGatewayAuthenticationCertificate[] | cdktf.IResolvable): void;
    resetAuthenticationCertificate(): void;
    get authenticationCertificateInput(): cdktf.IResolvable | ApplicationGatewayAuthenticationCertificate[] | undefined;
    private _autoscaleConfiguration;
    get autoscaleConfiguration(): ApplicationGatewayAutoscaleConfigurationOutputReference;
    putAutoscaleConfiguration(value: ApplicationGatewayAutoscaleConfiguration): void;
    resetAutoscaleConfiguration(): void;
    get autoscaleConfigurationInput(): ApplicationGatewayAutoscaleConfiguration | undefined;
    private _backendAddressPool;
    get backendAddressPool(): ApplicationGatewayBackendAddressPoolList;
    putBackendAddressPool(value: ApplicationGatewayBackendAddressPool[] | cdktf.IResolvable): void;
    get backendAddressPoolInput(): cdktf.IResolvable | ApplicationGatewayBackendAddressPool[] | undefined;
    private _backendHttpSettings;
    get backendHttpSettings(): ApplicationGatewayBackendHttpSettingsList;
    putBackendHttpSettings(value: ApplicationGatewayBackendHttpSettings[] | cdktf.IResolvable): void;
    get backendHttpSettingsInput(): cdktf.IResolvable | ApplicationGatewayBackendHttpSettings[] | undefined;
    private _customErrorConfiguration;
    get customErrorConfiguration(): ApplicationGatewayCustomErrorConfigurationList;
    putCustomErrorConfiguration(value: ApplicationGatewayCustomErrorConfiguration[] | cdktf.IResolvable): void;
    resetCustomErrorConfiguration(): void;
    get customErrorConfigurationInput(): cdktf.IResolvable | ApplicationGatewayCustomErrorConfiguration[] | undefined;
    private _frontendIpConfiguration;
    get frontendIpConfiguration(): ApplicationGatewayFrontendIpConfigurationList;
    putFrontendIpConfiguration(value: ApplicationGatewayFrontendIpConfiguration[] | cdktf.IResolvable): void;
    get frontendIpConfigurationInput(): cdktf.IResolvable | ApplicationGatewayFrontendIpConfiguration[] | undefined;
    private _frontendPort;
    get frontendPort(): ApplicationGatewayFrontendPortList;
    putFrontendPort(value: ApplicationGatewayFrontendPort[] | cdktf.IResolvable): void;
    get frontendPortInput(): cdktf.IResolvable | ApplicationGatewayFrontendPort[] | undefined;
    private _gatewayIpConfiguration;
    get gatewayIpConfiguration(): ApplicationGatewayGatewayIpConfigurationList;
    putGatewayIpConfiguration(value: ApplicationGatewayGatewayIpConfiguration[] | cdktf.IResolvable): void;
    get gatewayIpConfigurationInput(): cdktf.IResolvable | ApplicationGatewayGatewayIpConfiguration[] | undefined;
    private _global;
    get global(): ApplicationGatewayGlobalOutputReference;
    putGlobal(value: ApplicationGatewayGlobal): void;
    resetGlobal(): void;
    get globalInput(): ApplicationGatewayGlobal | undefined;
    private _httpListener;
    get httpListener(): ApplicationGatewayHttpListenerList;
    putHttpListener(value: ApplicationGatewayHttpListener[] | cdktf.IResolvable): void;
    get httpListenerInput(): cdktf.IResolvable | ApplicationGatewayHttpListener[] | undefined;
    private _identity;
    get identity(): ApplicationGatewayIdentityOutputReference;
    putIdentity(value: ApplicationGatewayIdentity): void;
    resetIdentity(): void;
    get identityInput(): ApplicationGatewayIdentity | undefined;
    private _privateLinkConfiguration;
    get privateLinkConfiguration(): ApplicationGatewayPrivateLinkConfigurationList;
    putPrivateLinkConfiguration(value: ApplicationGatewayPrivateLinkConfiguration[] | cdktf.IResolvable): void;
    resetPrivateLinkConfiguration(): void;
    get privateLinkConfigurationInput(): cdktf.IResolvable | ApplicationGatewayPrivateLinkConfiguration[] | undefined;
    private _probe;
    get probe(): ApplicationGatewayProbeList;
    putProbe(value: ApplicationGatewayProbe[] | cdktf.IResolvable): void;
    resetProbe(): void;
    get probeInput(): cdktf.IResolvable | ApplicationGatewayProbe[] | undefined;
    private _redirectConfiguration;
    get redirectConfiguration(): ApplicationGatewayRedirectConfigurationList;
    putRedirectConfiguration(value: ApplicationGatewayRedirectConfiguration[] | cdktf.IResolvable): void;
    resetRedirectConfiguration(): void;
    get redirectConfigurationInput(): cdktf.IResolvable | ApplicationGatewayRedirectConfiguration[] | undefined;
    private _requestRoutingRule;
    get requestRoutingRule(): ApplicationGatewayRequestRoutingRuleList;
    putRequestRoutingRule(value: ApplicationGatewayRequestRoutingRule[] | cdktf.IResolvable): void;
    get requestRoutingRuleInput(): cdktf.IResolvable | ApplicationGatewayRequestRoutingRule[] | undefined;
    private _rewriteRuleSet;
    get rewriteRuleSet(): ApplicationGatewayRewriteRuleSetList;
    putRewriteRuleSet(value: ApplicationGatewayRewriteRuleSet[] | cdktf.IResolvable): void;
    resetRewriteRuleSet(): void;
    get rewriteRuleSetInput(): cdktf.IResolvable | ApplicationGatewayRewriteRuleSet[] | undefined;
    private _sku;
    get sku(): ApplicationGatewaySkuOutputReference;
    putSku(value: ApplicationGatewaySku): void;
    get skuInput(): ApplicationGatewaySku | undefined;
    private _sslCertificate;
    get sslCertificate(): ApplicationGatewaySslCertificateList;
    putSslCertificate(value: ApplicationGatewaySslCertificate[] | cdktf.IResolvable): void;
    resetSslCertificate(): void;
    get sslCertificateInput(): cdktf.IResolvable | ApplicationGatewaySslCertificate[] | undefined;
    private _sslPolicy;
    get sslPolicy(): ApplicationGatewaySslPolicyOutputReference;
    putSslPolicy(value: ApplicationGatewaySslPolicy): void;
    resetSslPolicy(): void;
    get sslPolicyInput(): ApplicationGatewaySslPolicy | undefined;
    private _sslProfile;
    get sslProfile(): ApplicationGatewaySslProfileList;
    putSslProfile(value: ApplicationGatewaySslProfile[] | cdktf.IResolvable): void;
    resetSslProfile(): void;
    get sslProfileInput(): cdktf.IResolvable | ApplicationGatewaySslProfile[] | undefined;
    private _timeouts;
    get timeouts(): ApplicationGatewayTimeoutsOutputReference;
    putTimeouts(value: ApplicationGatewayTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ApplicationGatewayTimeouts | undefined;
    private _trustedClientCertificate;
    get trustedClientCertificate(): ApplicationGatewayTrustedClientCertificateList;
    putTrustedClientCertificate(value: ApplicationGatewayTrustedClientCertificate[] | cdktf.IResolvable): void;
    resetTrustedClientCertificate(): void;
    get trustedClientCertificateInput(): cdktf.IResolvable | ApplicationGatewayTrustedClientCertificate[] | undefined;
    private _trustedRootCertificate;
    get trustedRootCertificate(): ApplicationGatewayTrustedRootCertificateList;
    putTrustedRootCertificate(value: ApplicationGatewayTrustedRootCertificate[] | cdktf.IResolvable): void;
    resetTrustedRootCertificate(): void;
    get trustedRootCertificateInput(): cdktf.IResolvable | ApplicationGatewayTrustedRootCertificate[] | undefined;
    private _urlPathMap;
    get urlPathMap(): ApplicationGatewayUrlPathMapList;
    putUrlPathMap(value: ApplicationGatewayUrlPathMap[] | cdktf.IResolvable): void;
    resetUrlPathMap(): void;
    get urlPathMapInput(): cdktf.IResolvable | ApplicationGatewayUrlPathMap[] | undefined;
    private _wafConfiguration;
    get wafConfiguration(): ApplicationGatewayWafConfigurationOutputReference;
    putWafConfiguration(value: ApplicationGatewayWafConfiguration): void;
    resetWafConfiguration(): void;
    get wafConfigurationInput(): ApplicationGatewayWafConfiguration | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
