/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface BatchPoolConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#account_name BatchPool#account_name}
    */
    readonly accountName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#display_name BatchPool#display_name}
    */
    readonly displayName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#id BatchPool#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#inter_node_communication BatchPool#inter_node_communication}
    */
    readonly interNodeCommunication?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#license_type BatchPool#license_type}
    */
    readonly licenseType?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#max_tasks_per_node BatchPool#max_tasks_per_node}
    */
    readonly maxTasksPerNode?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#metadata BatchPool#metadata}
    */
    readonly metadata?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#name BatchPool#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#node_agent_sku_id BatchPool#node_agent_sku_id}
    */
    readonly nodeAgentSkuId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#os_disk_placement BatchPool#os_disk_placement}
    */
    readonly osDiskPlacement?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#resource_group_name BatchPool#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#stop_pending_resize_operation BatchPool#stop_pending_resize_operation}
    */
    readonly stopPendingResizeOperation?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#target_node_communication_mode BatchPool#target_node_communication_mode}
    */
    readonly targetNodeCommunicationMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#vm_size BatchPool#vm_size}
    */
    readonly vmSize: string;
    /**
    * auto_scale block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#auto_scale BatchPool#auto_scale}
    */
    readonly autoScale?: BatchPoolAutoScale;
    /**
    * certificate block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#certificate BatchPool#certificate}
    */
    readonly certificate?: BatchPoolCertificate[] | cdktf.IResolvable;
    /**
    * container_configuration block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#container_configuration BatchPool#container_configuration}
    */
    readonly containerConfiguration?: BatchPoolContainerConfiguration;
    /**
    * data_disks block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#data_disks BatchPool#data_disks}
    */
    readonly dataDisks?: BatchPoolDataDisks[] | cdktf.IResolvable;
    /**
    * disk_encryption block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#disk_encryption BatchPool#disk_encryption}
    */
    readonly diskEncryption?: BatchPoolDiskEncryption[] | cdktf.IResolvable;
    /**
    * extensions block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#extensions BatchPool#extensions}
    */
    readonly extensions?: BatchPoolExtensions[] | cdktf.IResolvable;
    /**
    * fixed_scale block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#fixed_scale BatchPool#fixed_scale}
    */
    readonly fixedScale?: BatchPoolFixedScale;
    /**
    * identity block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#identity BatchPool#identity}
    */
    readonly identity?: BatchPoolIdentity;
    /**
    * mount block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#mount BatchPool#mount}
    */
    readonly mount?: BatchPoolMount[] | cdktf.IResolvable;
    /**
    * network_configuration block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#network_configuration BatchPool#network_configuration}
    */
    readonly networkConfiguration?: BatchPoolNetworkConfiguration;
    /**
    * node_placement block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#node_placement BatchPool#node_placement}
    */
    readonly nodePlacement?: BatchPoolNodePlacement[] | cdktf.IResolvable;
    /**
    * start_task block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#start_task BatchPool#start_task}
    */
    readonly startTask?: BatchPoolStartTask;
    /**
    * storage_image_reference block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#storage_image_reference BatchPool#storage_image_reference}
    */
    readonly storageImageReference: BatchPoolStorageImageReference;
    /**
    * task_scheduling_policy block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#task_scheduling_policy BatchPool#task_scheduling_policy}
    */
    readonly taskSchedulingPolicy?: BatchPoolTaskSchedulingPolicy[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#timeouts BatchPool#timeouts}
    */
    readonly timeouts?: BatchPoolTimeouts;
    /**
    * user_accounts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#user_accounts BatchPool#user_accounts}
    */
    readonly userAccounts?: BatchPoolUserAccounts[] | cdktf.IResolvable;
    /**
    * windows block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#windows BatchPool#windows}
    */
    readonly windows?: BatchPoolWindows[] | cdktf.IResolvable;
}
export interface BatchPoolAutoScale {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#evaluation_interval BatchPool#evaluation_interval}
    */
    readonly evaluationInterval?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#formula BatchPool#formula}
    */
    readonly formula: string;
}
export declare function batchPoolAutoScaleToTerraform(struct?: BatchPoolAutoScaleOutputReference | BatchPoolAutoScale): any;
export declare class BatchPoolAutoScaleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): BatchPoolAutoScale | undefined;
    set internalValue(value: BatchPoolAutoScale | undefined);
    private _evaluationInterval?;
    get evaluationInterval(): string;
    set evaluationInterval(value: string);
    resetEvaluationInterval(): void;
    get evaluationIntervalInput(): string | undefined;
    private _formula?;
    get formula(): string;
    set formula(value: string);
    get formulaInput(): string | undefined;
}
export interface BatchPoolCertificate {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#id BatchPool#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#store_location BatchPool#store_location}
    */
    readonly storeLocation: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#store_name BatchPool#store_name}
    */
    readonly storeName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#visibility BatchPool#visibility}
    */
    readonly visibility?: string[];
}
export declare function batchPoolCertificateToTerraform(struct?: BatchPoolCertificate | cdktf.IResolvable): any;
export declare class BatchPoolCertificateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): BatchPoolCertificate | cdktf.IResolvable | undefined;
    set internalValue(value: BatchPoolCertificate | cdktf.IResolvable | undefined);
    private _id?;
    get id(): string;
    set id(value: string);
    get idInput(): string | undefined;
    private _storeLocation?;
    get storeLocation(): string;
    set storeLocation(value: string);
    get storeLocationInput(): string | undefined;
    private _storeName?;
    get storeName(): string;
    set storeName(value: string);
    resetStoreName(): void;
    get storeNameInput(): string | undefined;
    private _visibility?;
    get visibility(): string[];
    set visibility(value: string[]);
    resetVisibility(): void;
    get visibilityInput(): string[] | undefined;
}
export declare class BatchPoolCertificateList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: BatchPoolCertificate[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): BatchPoolCertificateOutputReference;
}
export interface BatchPoolContainerConfigurationContainerRegistries {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#password BatchPool#password}
    */
    readonly password?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#registry_server BatchPool#registry_server}
    */
    readonly registryServer?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#user_assigned_identity_id BatchPool#user_assigned_identity_id}
    */
    readonly userAssignedIdentityId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#user_name BatchPool#user_name}
    */
    readonly userName?: string;
}
export declare function batchPoolContainerConfigurationContainerRegistriesToTerraform(struct?: BatchPoolContainerConfigurationContainerRegistries | cdktf.IResolvable): any;
export declare class BatchPoolContainerConfigurationContainerRegistriesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): BatchPoolContainerConfigurationContainerRegistries | cdktf.IResolvable | undefined;
    set internalValue(value: BatchPoolContainerConfigurationContainerRegistries | cdktf.IResolvable | undefined);
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    private _registryServer?;
    get registryServer(): string;
    set registryServer(value: string);
    resetRegistryServer(): void;
    get registryServerInput(): string | undefined;
    private _userAssignedIdentityId?;
    get userAssignedIdentityId(): string;
    set userAssignedIdentityId(value: string);
    resetUserAssignedIdentityId(): void;
    get userAssignedIdentityIdInput(): string | undefined;
    private _userName?;
    get userName(): string;
    set userName(value: string);
    resetUserName(): void;
    get userNameInput(): string | undefined;
}
export declare class BatchPoolContainerConfigurationContainerRegistriesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: BatchPoolContainerConfigurationContainerRegistries[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): BatchPoolContainerConfigurationContainerRegistriesOutputReference;
}
export interface BatchPoolContainerConfiguration {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#container_image_names BatchPool#container_image_names}
    */
    readonly containerImageNames?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#container_registries BatchPool#container_registries}
    */
    readonly containerRegistries?: BatchPoolContainerConfigurationContainerRegistries[] | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#type BatchPool#type}
    */
    readonly type?: string;
}
export declare function batchPoolContainerConfigurationToTerraform(struct?: BatchPoolContainerConfigurationOutputReference | BatchPoolContainerConfiguration): any;
export declare class BatchPoolContainerConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): BatchPoolContainerConfiguration | undefined;
    set internalValue(value: BatchPoolContainerConfiguration | undefined);
    private _containerImageNames?;
    get containerImageNames(): string[];
    set containerImageNames(value: string[]);
    resetContainerImageNames(): void;
    get containerImageNamesInput(): string[] | undefined;
    private _containerRegistries;
    get containerRegistries(): BatchPoolContainerConfigurationContainerRegistriesList;
    putContainerRegistries(value: BatchPoolContainerConfigurationContainerRegistries[] | cdktf.IResolvable): void;
    resetContainerRegistries(): void;
    get containerRegistriesInput(): cdktf.IResolvable | BatchPoolContainerConfigurationContainerRegistries[] | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
}
export interface BatchPoolDataDisks {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#caching BatchPool#caching}
    */
    readonly caching?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#disk_size_gb BatchPool#disk_size_gb}
    */
    readonly diskSizeGb: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#lun BatchPool#lun}
    */
    readonly lun: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#storage_account_type BatchPool#storage_account_type}
    */
    readonly storageAccountType?: string;
}
export declare function batchPoolDataDisksToTerraform(struct?: BatchPoolDataDisks | cdktf.IResolvable): any;
export declare class BatchPoolDataDisksOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): BatchPoolDataDisks | cdktf.IResolvable | undefined;
    set internalValue(value: BatchPoolDataDisks | cdktf.IResolvable | undefined);
    private _caching?;
    get caching(): string;
    set caching(value: string);
    resetCaching(): void;
    get cachingInput(): string | undefined;
    private _diskSizeGb?;
    get diskSizeGb(): number;
    set diskSizeGb(value: number);
    get diskSizeGbInput(): number | undefined;
    private _lun?;
    get lun(): number;
    set lun(value: number);
    get lunInput(): number | undefined;
    private _storageAccountType?;
    get storageAccountType(): string;
    set storageAccountType(value: string);
    resetStorageAccountType(): void;
    get storageAccountTypeInput(): string | undefined;
}
export declare class BatchPoolDataDisksList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: BatchPoolDataDisks[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): BatchPoolDataDisksOutputReference;
}
export interface BatchPoolDiskEncryption {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#disk_encryption_target BatchPool#disk_encryption_target}
    */
    readonly diskEncryptionTarget: string;
}
export declare function batchPoolDiskEncryptionToTerraform(struct?: BatchPoolDiskEncryption | cdktf.IResolvable): any;
export declare class BatchPoolDiskEncryptionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): BatchPoolDiskEncryption | cdktf.IResolvable | undefined;
    set internalValue(value: BatchPoolDiskEncryption | cdktf.IResolvable | undefined);
    private _diskEncryptionTarget?;
    get diskEncryptionTarget(): string;
    set diskEncryptionTarget(value: string);
    get diskEncryptionTargetInput(): string | undefined;
}
export declare class BatchPoolDiskEncryptionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: BatchPoolDiskEncryption[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): BatchPoolDiskEncryptionOutputReference;
}
export interface BatchPoolExtensions {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#auto_upgrade_minor_version BatchPool#auto_upgrade_minor_version}
    */
    readonly autoUpgradeMinorVersion?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#automatic_upgrade_enabled BatchPool#automatic_upgrade_enabled}
    */
    readonly automaticUpgradeEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#name BatchPool#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#protected_settings BatchPool#protected_settings}
    */
    readonly protectedSettings?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#provision_after_extensions BatchPool#provision_after_extensions}
    */
    readonly provisionAfterExtensions?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#publisher BatchPool#publisher}
    */
    readonly publisher: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#settings_json BatchPool#settings_json}
    */
    readonly settingsJson?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#type BatchPool#type}
    */
    readonly type: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#type_handler_version BatchPool#type_handler_version}
    */
    readonly typeHandlerVersion?: string;
}
export declare function batchPoolExtensionsToTerraform(struct?: BatchPoolExtensions | cdktf.IResolvable): any;
export declare class BatchPoolExtensionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): BatchPoolExtensions | cdktf.IResolvable | undefined;
    set internalValue(value: BatchPoolExtensions | cdktf.IResolvable | undefined);
    private _autoUpgradeMinorVersion?;
    get autoUpgradeMinorVersion(): boolean | cdktf.IResolvable;
    set autoUpgradeMinorVersion(value: boolean | cdktf.IResolvable);
    resetAutoUpgradeMinorVersion(): void;
    get autoUpgradeMinorVersionInput(): boolean | cdktf.IResolvable | undefined;
    private _automaticUpgradeEnabled?;
    get automaticUpgradeEnabled(): boolean | cdktf.IResolvable;
    set automaticUpgradeEnabled(value: boolean | cdktf.IResolvable);
    resetAutomaticUpgradeEnabled(): void;
    get automaticUpgradeEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _protectedSettings?;
    get protectedSettings(): string;
    set protectedSettings(value: string);
    resetProtectedSettings(): void;
    get protectedSettingsInput(): string | undefined;
    private _provisionAfterExtensions?;
    get provisionAfterExtensions(): string[];
    set provisionAfterExtensions(value: string[]);
    resetProvisionAfterExtensions(): void;
    get provisionAfterExtensionsInput(): string[] | undefined;
    private _publisher?;
    get publisher(): string;
    set publisher(value: string);
    get publisherInput(): string | undefined;
    private _settingsJson?;
    get settingsJson(): string;
    set settingsJson(value: string);
    resetSettingsJson(): void;
    get settingsJsonInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _typeHandlerVersion?;
    get typeHandlerVersion(): string;
    set typeHandlerVersion(value: string);
    resetTypeHandlerVersion(): void;
    get typeHandlerVersionInput(): string | undefined;
}
export declare class BatchPoolExtensionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: BatchPoolExtensions[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): BatchPoolExtensionsOutputReference;
}
export interface BatchPoolFixedScale {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#node_deallocation_method BatchPool#node_deallocation_method}
    */
    readonly nodeDeallocationMethod?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#resize_timeout BatchPool#resize_timeout}
    */
    readonly resizeTimeout?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#target_dedicated_nodes BatchPool#target_dedicated_nodes}
    */
    readonly targetDedicatedNodes?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#target_low_priority_nodes BatchPool#target_low_priority_nodes}
    */
    readonly targetLowPriorityNodes?: number;
}
export declare function batchPoolFixedScaleToTerraform(struct?: BatchPoolFixedScaleOutputReference | BatchPoolFixedScale): any;
export declare class BatchPoolFixedScaleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): BatchPoolFixedScale | undefined;
    set internalValue(value: BatchPoolFixedScale | undefined);
    private _nodeDeallocationMethod?;
    get nodeDeallocationMethod(): string;
    set nodeDeallocationMethod(value: string);
    resetNodeDeallocationMethod(): void;
    get nodeDeallocationMethodInput(): string | undefined;
    private _resizeTimeout?;
    get resizeTimeout(): string;
    set resizeTimeout(value: string);
    resetResizeTimeout(): void;
    get resizeTimeoutInput(): string | undefined;
    private _targetDedicatedNodes?;
    get targetDedicatedNodes(): number;
    set targetDedicatedNodes(value: number);
    resetTargetDedicatedNodes(): void;
    get targetDedicatedNodesInput(): number | undefined;
    private _targetLowPriorityNodes?;
    get targetLowPriorityNodes(): number;
    set targetLowPriorityNodes(value: number);
    resetTargetLowPriorityNodes(): void;
    get targetLowPriorityNodesInput(): number | undefined;
}
export interface BatchPoolIdentity {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#identity_ids BatchPool#identity_ids}
    */
    readonly identityIds: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#type BatchPool#type}
    */
    readonly type: string;
}
export declare function batchPoolIdentityToTerraform(struct?: BatchPoolIdentityOutputReference | BatchPoolIdentity): any;
export declare class BatchPoolIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): BatchPoolIdentity | undefined;
    set internalValue(value: BatchPoolIdentity | undefined);
    private _identityIds?;
    get identityIds(): string[];
    set identityIds(value: string[]);
    get identityIdsInput(): string[] | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface BatchPoolMountAzureBlobFileSystem {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#account_key BatchPool#account_key}
    */
    readonly accountKey?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#account_name BatchPool#account_name}
    */
    readonly accountName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#blobfuse_options BatchPool#blobfuse_options}
    */
    readonly blobfuseOptions?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#container_name BatchPool#container_name}
    */
    readonly containerName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#identity_id BatchPool#identity_id}
    */
    readonly identityId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#relative_mount_path BatchPool#relative_mount_path}
    */
    readonly relativeMountPath: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#sas_key BatchPool#sas_key}
    */
    readonly sasKey?: string;
}
export declare function batchPoolMountAzureBlobFileSystemToTerraform(struct?: BatchPoolMountAzureBlobFileSystemOutputReference | BatchPoolMountAzureBlobFileSystem): any;
export declare class BatchPoolMountAzureBlobFileSystemOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): BatchPoolMountAzureBlobFileSystem | undefined;
    set internalValue(value: BatchPoolMountAzureBlobFileSystem | undefined);
    private _accountKey?;
    get accountKey(): string;
    set accountKey(value: string);
    resetAccountKey(): void;
    get accountKeyInput(): string | undefined;
    private _accountName?;
    get accountName(): string;
    set accountName(value: string);
    get accountNameInput(): string | undefined;
    private _blobfuseOptions?;
    get blobfuseOptions(): string;
    set blobfuseOptions(value: string);
    resetBlobfuseOptions(): void;
    get blobfuseOptionsInput(): string | undefined;
    private _containerName?;
    get containerName(): string;
    set containerName(value: string);
    get containerNameInput(): string | undefined;
    private _identityId?;
    get identityId(): string;
    set identityId(value: string);
    resetIdentityId(): void;
    get identityIdInput(): string | undefined;
    private _relativeMountPath?;
    get relativeMountPath(): string;
    set relativeMountPath(value: string);
    get relativeMountPathInput(): string | undefined;
    private _sasKey?;
    get sasKey(): string;
    set sasKey(value: string);
    resetSasKey(): void;
    get sasKeyInput(): string | undefined;
}
export interface BatchPoolMountAzureFileShare {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#account_key BatchPool#account_key}
    */
    readonly accountKey: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#account_name BatchPool#account_name}
    */
    readonly accountName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#azure_file_url BatchPool#azure_file_url}
    */
    readonly azureFileUrl: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#mount_options BatchPool#mount_options}
    */
    readonly mountOptions?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#relative_mount_path BatchPool#relative_mount_path}
    */
    readonly relativeMountPath: string;
}
export declare function batchPoolMountAzureFileShareToTerraform(struct?: BatchPoolMountAzureFileShare | cdktf.IResolvable): any;
export declare class BatchPoolMountAzureFileShareOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): BatchPoolMountAzureFileShare | cdktf.IResolvable | undefined;
    set internalValue(value: BatchPoolMountAzureFileShare | cdktf.IResolvable | undefined);
    private _accountKey?;
    get accountKey(): string;
    set accountKey(value: string);
    get accountKeyInput(): string | undefined;
    private _accountName?;
    get accountName(): string;
    set accountName(value: string);
    get accountNameInput(): string | undefined;
    private _azureFileUrl?;
    get azureFileUrl(): string;
    set azureFileUrl(value: string);
    get azureFileUrlInput(): string | undefined;
    private _mountOptions?;
    get mountOptions(): string;
    set mountOptions(value: string);
    resetMountOptions(): void;
    get mountOptionsInput(): string | undefined;
    private _relativeMountPath?;
    get relativeMountPath(): string;
    set relativeMountPath(value: string);
    get relativeMountPathInput(): string | undefined;
}
export declare class BatchPoolMountAzureFileShareList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: BatchPoolMountAzureFileShare[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): BatchPoolMountAzureFileShareOutputReference;
}
export interface BatchPoolMountCifsMount {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#mount_options BatchPool#mount_options}
    */
    readonly mountOptions?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#password BatchPool#password}
    */
    readonly password: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#relative_mount_path BatchPool#relative_mount_path}
    */
    readonly relativeMountPath: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#source BatchPool#source}
    */
    readonly source: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#user_name BatchPool#user_name}
    */
    readonly userName: string;
}
export declare function batchPoolMountCifsMountToTerraform(struct?: BatchPoolMountCifsMount | cdktf.IResolvable): any;
export declare class BatchPoolMountCifsMountOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): BatchPoolMountCifsMount | cdktf.IResolvable | undefined;
    set internalValue(value: BatchPoolMountCifsMount | cdktf.IResolvable | undefined);
    private _mountOptions?;
    get mountOptions(): string;
    set mountOptions(value: string);
    resetMountOptions(): void;
    get mountOptionsInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    get passwordInput(): string | undefined;
    private _relativeMountPath?;
    get relativeMountPath(): string;
    set relativeMountPath(value: string);
    get relativeMountPathInput(): string | undefined;
    private _source?;
    get source(): string;
    set source(value: string);
    get sourceInput(): string | undefined;
    private _userName?;
    get userName(): string;
    set userName(value: string);
    get userNameInput(): string | undefined;
}
export declare class BatchPoolMountCifsMountList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: BatchPoolMountCifsMount[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): BatchPoolMountCifsMountOutputReference;
}
export interface BatchPoolMountNfsMount {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#mount_options BatchPool#mount_options}
    */
    readonly mountOptions?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#relative_mount_path BatchPool#relative_mount_path}
    */
    readonly relativeMountPath: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#source BatchPool#source}
    */
    readonly source: string;
}
export declare function batchPoolMountNfsMountToTerraform(struct?: BatchPoolMountNfsMount | cdktf.IResolvable): any;
export declare class BatchPoolMountNfsMountOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): BatchPoolMountNfsMount | cdktf.IResolvable | undefined;
    set internalValue(value: BatchPoolMountNfsMount | cdktf.IResolvable | undefined);
    private _mountOptions?;
    get mountOptions(): string;
    set mountOptions(value: string);
    resetMountOptions(): void;
    get mountOptionsInput(): string | undefined;
    private _relativeMountPath?;
    get relativeMountPath(): string;
    set relativeMountPath(value: string);
    get relativeMountPathInput(): string | undefined;
    private _source?;
    get source(): string;
    set source(value: string);
    get sourceInput(): string | undefined;
}
export declare class BatchPoolMountNfsMountList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: BatchPoolMountNfsMount[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): BatchPoolMountNfsMountOutputReference;
}
export interface BatchPoolMount {
    /**
    * azure_blob_file_system block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#azure_blob_file_system BatchPool#azure_blob_file_system}
    */
    readonly azureBlobFileSystem?: BatchPoolMountAzureBlobFileSystem;
    /**
    * azure_file_share block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#azure_file_share BatchPool#azure_file_share}
    */
    readonly azureFileShare?: BatchPoolMountAzureFileShare[] | cdktf.IResolvable;
    /**
    * cifs_mount block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#cifs_mount BatchPool#cifs_mount}
    */
    readonly cifsMount?: BatchPoolMountCifsMount[] | cdktf.IResolvable;
    /**
    * nfs_mount block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#nfs_mount BatchPool#nfs_mount}
    */
    readonly nfsMount?: BatchPoolMountNfsMount[] | cdktf.IResolvable;
}
export declare function batchPoolMountToTerraform(struct?: BatchPoolMount | cdktf.IResolvable): any;
export declare class BatchPoolMountOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): BatchPoolMount | cdktf.IResolvable | undefined;
    set internalValue(value: BatchPoolMount | cdktf.IResolvable | undefined);
    private _azureBlobFileSystem;
    get azureBlobFileSystem(): BatchPoolMountAzureBlobFileSystemOutputReference;
    putAzureBlobFileSystem(value: BatchPoolMountAzureBlobFileSystem): void;
    resetAzureBlobFileSystem(): void;
    get azureBlobFileSystemInput(): BatchPoolMountAzureBlobFileSystem | undefined;
    private _azureFileShare;
    get azureFileShare(): BatchPoolMountAzureFileShareList;
    putAzureFileShare(value: BatchPoolMountAzureFileShare[] | cdktf.IResolvable): void;
    resetAzureFileShare(): void;
    get azureFileShareInput(): cdktf.IResolvable | BatchPoolMountAzureFileShare[] | undefined;
    private _cifsMount;
    get cifsMount(): BatchPoolMountCifsMountList;
    putCifsMount(value: BatchPoolMountCifsMount[] | cdktf.IResolvable): void;
    resetCifsMount(): void;
    get cifsMountInput(): cdktf.IResolvable | BatchPoolMountCifsMount[] | undefined;
    private _nfsMount;
    get nfsMount(): BatchPoolMountNfsMountList;
    putNfsMount(value: BatchPoolMountNfsMount[] | cdktf.IResolvable): void;
    resetNfsMount(): void;
    get nfsMountInput(): cdktf.IResolvable | BatchPoolMountNfsMount[] | undefined;
}
export declare class BatchPoolMountList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: BatchPoolMount[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): BatchPoolMountOutputReference;
}
export interface BatchPoolNetworkConfigurationEndpointConfigurationNetworkSecurityGroupRules {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#access BatchPool#access}
    */
    readonly access: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#priority BatchPool#priority}
    */
    readonly priority: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#source_address_prefix BatchPool#source_address_prefix}
    */
    readonly sourceAddressPrefix: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#source_port_ranges BatchPool#source_port_ranges}
    */
    readonly sourcePortRanges?: string[];
}
export declare function batchPoolNetworkConfigurationEndpointConfigurationNetworkSecurityGroupRulesToTerraform(struct?: BatchPoolNetworkConfigurationEndpointConfigurationNetworkSecurityGroupRules | cdktf.IResolvable): any;
export declare class BatchPoolNetworkConfigurationEndpointConfigurationNetworkSecurityGroupRulesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): BatchPoolNetworkConfigurationEndpointConfigurationNetworkSecurityGroupRules | cdktf.IResolvable | undefined;
    set internalValue(value: BatchPoolNetworkConfigurationEndpointConfigurationNetworkSecurityGroupRules | cdktf.IResolvable | undefined);
    private _access?;
    get access(): string;
    set access(value: string);
    get accessInput(): string | undefined;
    private _priority?;
    get priority(): number;
    set priority(value: number);
    get priorityInput(): number | undefined;
    private _sourceAddressPrefix?;
    get sourceAddressPrefix(): string;
    set sourceAddressPrefix(value: string);
    get sourceAddressPrefixInput(): string | undefined;
    private _sourcePortRanges?;
    get sourcePortRanges(): string[];
    set sourcePortRanges(value: string[]);
    resetSourcePortRanges(): void;
    get sourcePortRangesInput(): string[] | undefined;
}
export declare class BatchPoolNetworkConfigurationEndpointConfigurationNetworkSecurityGroupRulesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: BatchPoolNetworkConfigurationEndpointConfigurationNetworkSecurityGroupRules[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): BatchPoolNetworkConfigurationEndpointConfigurationNetworkSecurityGroupRulesOutputReference;
}
export interface BatchPoolNetworkConfigurationEndpointConfiguration {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#backend_port BatchPool#backend_port}
    */
    readonly backendPort: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#frontend_port_range BatchPool#frontend_port_range}
    */
    readonly frontendPortRange: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#name BatchPool#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#protocol BatchPool#protocol}
    */
    readonly protocol: string;
    /**
    * network_security_group_rules block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#network_security_group_rules BatchPool#network_security_group_rules}
    */
    readonly networkSecurityGroupRules?: BatchPoolNetworkConfigurationEndpointConfigurationNetworkSecurityGroupRules[] | cdktf.IResolvable;
}
export declare function batchPoolNetworkConfigurationEndpointConfigurationToTerraform(struct?: BatchPoolNetworkConfigurationEndpointConfiguration | cdktf.IResolvable): any;
export declare class BatchPoolNetworkConfigurationEndpointConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): BatchPoolNetworkConfigurationEndpointConfiguration | cdktf.IResolvable | undefined;
    set internalValue(value: BatchPoolNetworkConfigurationEndpointConfiguration | cdktf.IResolvable | undefined);
    private _backendPort?;
    get backendPort(): number;
    set backendPort(value: number);
    get backendPortInput(): number | undefined;
    private _frontendPortRange?;
    get frontendPortRange(): string;
    set frontendPortRange(value: string);
    get frontendPortRangeInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _protocol?;
    get protocol(): string;
    set protocol(value: string);
    get protocolInput(): string | undefined;
    private _networkSecurityGroupRules;
    get networkSecurityGroupRules(): BatchPoolNetworkConfigurationEndpointConfigurationNetworkSecurityGroupRulesList;
    putNetworkSecurityGroupRules(value: BatchPoolNetworkConfigurationEndpointConfigurationNetworkSecurityGroupRules[] | cdktf.IResolvable): void;
    resetNetworkSecurityGroupRules(): void;
    get networkSecurityGroupRulesInput(): cdktf.IResolvable | BatchPoolNetworkConfigurationEndpointConfigurationNetworkSecurityGroupRules[] | undefined;
}
export declare class BatchPoolNetworkConfigurationEndpointConfigurationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: BatchPoolNetworkConfigurationEndpointConfiguration[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): BatchPoolNetworkConfigurationEndpointConfigurationOutputReference;
}
export interface BatchPoolNetworkConfiguration {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#accelerated_networking_enabled BatchPool#accelerated_networking_enabled}
    */
    readonly acceleratedNetworkingEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#dynamic_vnet_assignment_scope BatchPool#dynamic_vnet_assignment_scope}
    */
    readonly dynamicVnetAssignmentScope?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#public_address_provisioning_type BatchPool#public_address_provisioning_type}
    */
    readonly publicAddressProvisioningType?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#public_ips BatchPool#public_ips}
    */
    readonly publicIps?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#subnet_id BatchPool#subnet_id}
    */
    readonly subnetId?: string;
    /**
    * endpoint_configuration block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#endpoint_configuration BatchPool#endpoint_configuration}
    */
    readonly endpointConfiguration?: BatchPoolNetworkConfigurationEndpointConfiguration[] | cdktf.IResolvable;
}
export declare function batchPoolNetworkConfigurationToTerraform(struct?: BatchPoolNetworkConfigurationOutputReference | BatchPoolNetworkConfiguration): any;
export declare class BatchPoolNetworkConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): BatchPoolNetworkConfiguration | undefined;
    set internalValue(value: BatchPoolNetworkConfiguration | undefined);
    private _acceleratedNetworkingEnabled?;
    get acceleratedNetworkingEnabled(): boolean | cdktf.IResolvable;
    set acceleratedNetworkingEnabled(value: boolean | cdktf.IResolvable);
    resetAcceleratedNetworkingEnabled(): void;
    get acceleratedNetworkingEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _dynamicVnetAssignmentScope?;
    get dynamicVnetAssignmentScope(): string;
    set dynamicVnetAssignmentScope(value: string);
    resetDynamicVnetAssignmentScope(): void;
    get dynamicVnetAssignmentScopeInput(): string | undefined;
    private _publicAddressProvisioningType?;
    get publicAddressProvisioningType(): string;
    set publicAddressProvisioningType(value: string);
    resetPublicAddressProvisioningType(): void;
    get publicAddressProvisioningTypeInput(): string | undefined;
    private _publicIps?;
    get publicIps(): string[];
    set publicIps(value: string[]);
    resetPublicIps(): void;
    get publicIpsInput(): string[] | undefined;
    private _subnetId?;
    get subnetId(): string;
    set subnetId(value: string);
    resetSubnetId(): void;
    get subnetIdInput(): string | undefined;
    private _endpointConfiguration;
    get endpointConfiguration(): BatchPoolNetworkConfigurationEndpointConfigurationList;
    putEndpointConfiguration(value: BatchPoolNetworkConfigurationEndpointConfiguration[] | cdktf.IResolvable): void;
    resetEndpointConfiguration(): void;
    get endpointConfigurationInput(): cdktf.IResolvable | BatchPoolNetworkConfigurationEndpointConfiguration[] | undefined;
}
export interface BatchPoolNodePlacement {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#policy BatchPool#policy}
    */
    readonly policy?: string;
}
export declare function batchPoolNodePlacementToTerraform(struct?: BatchPoolNodePlacement | cdktf.IResolvable): any;
export declare class BatchPoolNodePlacementOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): BatchPoolNodePlacement | cdktf.IResolvable | undefined;
    set internalValue(value: BatchPoolNodePlacement | cdktf.IResolvable | undefined);
    private _policy?;
    get policy(): string;
    set policy(value: string);
    resetPolicy(): void;
    get policyInput(): string | undefined;
}
export declare class BatchPoolNodePlacementList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: BatchPoolNodePlacement[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): BatchPoolNodePlacementOutputReference;
}
export interface BatchPoolStartTaskContainerRegistry {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#password BatchPool#password}
    */
    readonly password?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#registry_server BatchPool#registry_server}
    */
    readonly registryServer: string;
    /**
    * The User Assigned Identity to use for Container Registry access.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#user_assigned_identity_id BatchPool#user_assigned_identity_id}
    */
    readonly userAssignedIdentityId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#user_name BatchPool#user_name}
    */
    readonly userName?: string;
}
export declare function batchPoolStartTaskContainerRegistryToTerraform(struct?: BatchPoolStartTaskContainerRegistry | cdktf.IResolvable): any;
export declare class BatchPoolStartTaskContainerRegistryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): BatchPoolStartTaskContainerRegistry | cdktf.IResolvable | undefined;
    set internalValue(value: BatchPoolStartTaskContainerRegistry | cdktf.IResolvable | undefined);
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    private _registryServer?;
    get registryServer(): string;
    set registryServer(value: string);
    get registryServerInput(): string | undefined;
    private _userAssignedIdentityId?;
    get userAssignedIdentityId(): string;
    set userAssignedIdentityId(value: string);
    resetUserAssignedIdentityId(): void;
    get userAssignedIdentityIdInput(): string | undefined;
    private _userName?;
    get userName(): string;
    set userName(value: string);
    resetUserName(): void;
    get userNameInput(): string | undefined;
}
export declare class BatchPoolStartTaskContainerRegistryList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: BatchPoolStartTaskContainerRegistry[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): BatchPoolStartTaskContainerRegistryOutputReference;
}
export interface BatchPoolStartTaskContainer {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#image_name BatchPool#image_name}
    */
    readonly imageName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#run_options BatchPool#run_options}
    */
    readonly runOptions?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#working_directory BatchPool#working_directory}
    */
    readonly workingDirectory?: string;
    /**
    * registry block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#registry BatchPool#registry}
    */
    readonly registry?: BatchPoolStartTaskContainerRegistry[] | cdktf.IResolvable;
}
export declare function batchPoolStartTaskContainerToTerraform(struct?: BatchPoolStartTaskContainer | cdktf.IResolvable): any;
export declare class BatchPoolStartTaskContainerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): BatchPoolStartTaskContainer | cdktf.IResolvable | undefined;
    set internalValue(value: BatchPoolStartTaskContainer | cdktf.IResolvable | undefined);
    private _imageName?;
    get imageName(): string;
    set imageName(value: string);
    get imageNameInput(): string | undefined;
    private _runOptions?;
    get runOptions(): string;
    set runOptions(value: string);
    resetRunOptions(): void;
    get runOptionsInput(): string | undefined;
    private _workingDirectory?;
    get workingDirectory(): string;
    set workingDirectory(value: string);
    resetWorkingDirectory(): void;
    get workingDirectoryInput(): string | undefined;
    private _registry;
    get registry(): BatchPoolStartTaskContainerRegistryList;
    putRegistry(value: BatchPoolStartTaskContainerRegistry[] | cdktf.IResolvable): void;
    resetRegistry(): void;
    get registryInput(): cdktf.IResolvable | BatchPoolStartTaskContainerRegistry[] | undefined;
}
export declare class BatchPoolStartTaskContainerList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: BatchPoolStartTaskContainer[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): BatchPoolStartTaskContainerOutputReference;
}
export interface BatchPoolStartTaskResourceFile {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#auto_storage_container_name BatchPool#auto_storage_container_name}
    */
    readonly autoStorageContainerName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#blob_prefix BatchPool#blob_prefix}
    */
    readonly blobPrefix?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#file_mode BatchPool#file_mode}
    */
    readonly fileMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#file_path BatchPool#file_path}
    */
    readonly filePath?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#http_url BatchPool#http_url}
    */
    readonly httpUrl?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#storage_container_url BatchPool#storage_container_url}
    */
    readonly storageContainerUrl?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#user_assigned_identity_id BatchPool#user_assigned_identity_id}
    */
    readonly userAssignedIdentityId?: string;
}
export declare function batchPoolStartTaskResourceFileToTerraform(struct?: BatchPoolStartTaskResourceFile | cdktf.IResolvable): any;
export declare class BatchPoolStartTaskResourceFileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): BatchPoolStartTaskResourceFile | cdktf.IResolvable | undefined;
    set internalValue(value: BatchPoolStartTaskResourceFile | cdktf.IResolvable | undefined);
    private _autoStorageContainerName?;
    get autoStorageContainerName(): string;
    set autoStorageContainerName(value: string);
    resetAutoStorageContainerName(): void;
    get autoStorageContainerNameInput(): string | undefined;
    private _blobPrefix?;
    get blobPrefix(): string;
    set blobPrefix(value: string);
    resetBlobPrefix(): void;
    get blobPrefixInput(): string | undefined;
    private _fileMode?;
    get fileMode(): string;
    set fileMode(value: string);
    resetFileMode(): void;
    get fileModeInput(): string | undefined;
    private _filePath?;
    get filePath(): string;
    set filePath(value: string);
    resetFilePath(): void;
    get filePathInput(): string | undefined;
    private _httpUrl?;
    get httpUrl(): string;
    set httpUrl(value: string);
    resetHttpUrl(): void;
    get httpUrlInput(): string | undefined;
    private _storageContainerUrl?;
    get storageContainerUrl(): string;
    set storageContainerUrl(value: string);
    resetStorageContainerUrl(): void;
    get storageContainerUrlInput(): string | undefined;
    private _userAssignedIdentityId?;
    get userAssignedIdentityId(): string;
    set userAssignedIdentityId(value: string);
    resetUserAssignedIdentityId(): void;
    get userAssignedIdentityIdInput(): string | undefined;
}
export declare class BatchPoolStartTaskResourceFileList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: BatchPoolStartTaskResourceFile[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): BatchPoolStartTaskResourceFileOutputReference;
}
export interface BatchPoolStartTaskUserIdentityAutoUser {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#elevation_level BatchPool#elevation_level}
    */
    readonly elevationLevel?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#scope BatchPool#scope}
    */
    readonly scope?: string;
}
export declare function batchPoolStartTaskUserIdentityAutoUserToTerraform(struct?: BatchPoolStartTaskUserIdentityAutoUserOutputReference | BatchPoolStartTaskUserIdentityAutoUser): any;
export declare class BatchPoolStartTaskUserIdentityAutoUserOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): BatchPoolStartTaskUserIdentityAutoUser | undefined;
    set internalValue(value: BatchPoolStartTaskUserIdentityAutoUser | undefined);
    private _elevationLevel?;
    get elevationLevel(): string;
    set elevationLevel(value: string);
    resetElevationLevel(): void;
    get elevationLevelInput(): string | undefined;
    private _scope?;
    get scope(): string;
    set scope(value: string);
    resetScope(): void;
    get scopeInput(): string | undefined;
}
export interface BatchPoolStartTaskUserIdentity {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#user_name BatchPool#user_name}
    */
    readonly userName?: string;
    /**
    * auto_user block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#auto_user BatchPool#auto_user}
    */
    readonly autoUser?: BatchPoolStartTaskUserIdentityAutoUser;
}
export declare function batchPoolStartTaskUserIdentityToTerraform(struct?: BatchPoolStartTaskUserIdentityOutputReference | BatchPoolStartTaskUserIdentity): any;
export declare class BatchPoolStartTaskUserIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): BatchPoolStartTaskUserIdentity | undefined;
    set internalValue(value: BatchPoolStartTaskUserIdentity | undefined);
    private _userName?;
    get userName(): string;
    set userName(value: string);
    resetUserName(): void;
    get userNameInput(): string | undefined;
    private _autoUser;
    get autoUser(): BatchPoolStartTaskUserIdentityAutoUserOutputReference;
    putAutoUser(value: BatchPoolStartTaskUserIdentityAutoUser): void;
    resetAutoUser(): void;
    get autoUserInput(): BatchPoolStartTaskUserIdentityAutoUser | undefined;
}
export interface BatchPoolStartTask {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#command_line BatchPool#command_line}
    */
    readonly commandLine: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#common_environment_properties BatchPool#common_environment_properties}
    */
    readonly commonEnvironmentProperties?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#task_retry_maximum BatchPool#task_retry_maximum}
    */
    readonly taskRetryMaximum?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#wait_for_success BatchPool#wait_for_success}
    */
    readonly waitForSuccess?: boolean | cdktf.IResolvable;
    /**
    * container block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#container BatchPool#container}
    */
    readonly container?: BatchPoolStartTaskContainer[] | cdktf.IResolvable;
    /**
    * resource_file block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#resource_file BatchPool#resource_file}
    */
    readonly resourceFile?: BatchPoolStartTaskResourceFile[] | cdktf.IResolvable;
    /**
    * user_identity block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#user_identity BatchPool#user_identity}
    */
    readonly userIdentity: BatchPoolStartTaskUserIdentity;
}
export declare function batchPoolStartTaskToTerraform(struct?: BatchPoolStartTaskOutputReference | BatchPoolStartTask): any;
export declare class BatchPoolStartTaskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): BatchPoolStartTask | undefined;
    set internalValue(value: BatchPoolStartTask | undefined);
    private _commandLine?;
    get commandLine(): string;
    set commandLine(value: string);
    get commandLineInput(): string | undefined;
    private _commonEnvironmentProperties?;
    get commonEnvironmentProperties(): {
        [key: string]: string;
    };
    set commonEnvironmentProperties(value: {
        [key: string]: string;
    });
    resetCommonEnvironmentProperties(): void;
    get commonEnvironmentPropertiesInput(): {
        [key: string]: string;
    } | undefined;
    private _taskRetryMaximum?;
    get taskRetryMaximum(): number;
    set taskRetryMaximum(value: number);
    resetTaskRetryMaximum(): void;
    get taskRetryMaximumInput(): number | undefined;
    private _waitForSuccess?;
    get waitForSuccess(): boolean | cdktf.IResolvable;
    set waitForSuccess(value: boolean | cdktf.IResolvable);
    resetWaitForSuccess(): void;
    get waitForSuccessInput(): boolean | cdktf.IResolvable | undefined;
    private _container;
    get container(): BatchPoolStartTaskContainerList;
    putContainer(value: BatchPoolStartTaskContainer[] | cdktf.IResolvable): void;
    resetContainer(): void;
    get containerInput(): cdktf.IResolvable | BatchPoolStartTaskContainer[] | undefined;
    private _resourceFile;
    get resourceFile(): BatchPoolStartTaskResourceFileList;
    putResourceFile(value: BatchPoolStartTaskResourceFile[] | cdktf.IResolvable): void;
    resetResourceFile(): void;
    get resourceFileInput(): cdktf.IResolvable | BatchPoolStartTaskResourceFile[] | undefined;
    private _userIdentity;
    get userIdentity(): BatchPoolStartTaskUserIdentityOutputReference;
    putUserIdentity(value: BatchPoolStartTaskUserIdentity): void;
    get userIdentityInput(): BatchPoolStartTaskUserIdentity | undefined;
}
export interface BatchPoolStorageImageReference {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#id BatchPool#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#offer BatchPool#offer}
    */
    readonly offer?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#publisher BatchPool#publisher}
    */
    readonly publisher?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#sku BatchPool#sku}
    */
    readonly sku?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#version BatchPool#version}
    */
    readonly version?: string;
}
export declare function batchPoolStorageImageReferenceToTerraform(struct?: BatchPoolStorageImageReferenceOutputReference | BatchPoolStorageImageReference): any;
export declare class BatchPoolStorageImageReferenceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): BatchPoolStorageImageReference | undefined;
    set internalValue(value: BatchPoolStorageImageReference | undefined);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _offer?;
    get offer(): string;
    set offer(value: string);
    resetOffer(): void;
    get offerInput(): string | undefined;
    private _publisher?;
    get publisher(): string;
    set publisher(value: string);
    resetPublisher(): void;
    get publisherInput(): string | undefined;
    private _sku?;
    get sku(): string;
    set sku(value: string);
    resetSku(): void;
    get skuInput(): string | undefined;
    private _version?;
    get version(): string;
    set version(value: string);
    resetVersion(): void;
    get versionInput(): string | undefined;
}
export interface BatchPoolTaskSchedulingPolicy {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#node_fill_type BatchPool#node_fill_type}
    */
    readonly nodeFillType?: string;
}
export declare function batchPoolTaskSchedulingPolicyToTerraform(struct?: BatchPoolTaskSchedulingPolicy | cdktf.IResolvable): any;
export declare class BatchPoolTaskSchedulingPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): BatchPoolTaskSchedulingPolicy | cdktf.IResolvable | undefined;
    set internalValue(value: BatchPoolTaskSchedulingPolicy | cdktf.IResolvable | undefined);
    private _nodeFillType?;
    get nodeFillType(): string;
    set nodeFillType(value: string);
    resetNodeFillType(): void;
    get nodeFillTypeInput(): string | undefined;
}
export declare class BatchPoolTaskSchedulingPolicyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: BatchPoolTaskSchedulingPolicy[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): BatchPoolTaskSchedulingPolicyOutputReference;
}
export interface BatchPoolTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#create BatchPool#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#delete BatchPool#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#read BatchPool#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#update BatchPool#update}
    */
    readonly update?: string;
}
export declare function batchPoolTimeoutsToTerraform(struct?: BatchPoolTimeouts | cdktf.IResolvable): any;
export declare class BatchPoolTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): BatchPoolTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: BatchPoolTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface BatchPoolUserAccountsLinuxUserConfiguration {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#gid BatchPool#gid}
    */
    readonly gid?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#ssh_private_key BatchPool#ssh_private_key}
    */
    readonly sshPrivateKey?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#uid BatchPool#uid}
    */
    readonly uid?: number;
}
export declare function batchPoolUserAccountsLinuxUserConfigurationToTerraform(struct?: BatchPoolUserAccountsLinuxUserConfiguration | cdktf.IResolvable): any;
export declare class BatchPoolUserAccountsLinuxUserConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): BatchPoolUserAccountsLinuxUserConfiguration | cdktf.IResolvable | undefined;
    set internalValue(value: BatchPoolUserAccountsLinuxUserConfiguration | cdktf.IResolvable | undefined);
    private _gid?;
    get gid(): number;
    set gid(value: number);
    resetGid(): void;
    get gidInput(): number | undefined;
    private _sshPrivateKey?;
    get sshPrivateKey(): string;
    set sshPrivateKey(value: string);
    resetSshPrivateKey(): void;
    get sshPrivateKeyInput(): string | undefined;
    private _uid?;
    get uid(): number;
    set uid(value: number);
    resetUid(): void;
    get uidInput(): number | undefined;
}
export declare class BatchPoolUserAccountsLinuxUserConfigurationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: BatchPoolUserAccountsLinuxUserConfiguration[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): BatchPoolUserAccountsLinuxUserConfigurationOutputReference;
}
export interface BatchPoolUserAccountsWindowsUserConfiguration {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#login_mode BatchPool#login_mode}
    */
    readonly loginMode: string;
}
export declare function batchPoolUserAccountsWindowsUserConfigurationToTerraform(struct?: BatchPoolUserAccountsWindowsUserConfiguration | cdktf.IResolvable): any;
export declare class BatchPoolUserAccountsWindowsUserConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): BatchPoolUserAccountsWindowsUserConfiguration | cdktf.IResolvable | undefined;
    set internalValue(value: BatchPoolUserAccountsWindowsUserConfiguration | cdktf.IResolvable | undefined);
    private _loginMode?;
    get loginMode(): string;
    set loginMode(value: string);
    get loginModeInput(): string | undefined;
}
export declare class BatchPoolUserAccountsWindowsUserConfigurationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: BatchPoolUserAccountsWindowsUserConfiguration[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): BatchPoolUserAccountsWindowsUserConfigurationOutputReference;
}
export interface BatchPoolUserAccounts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#elevation_level BatchPool#elevation_level}
    */
    readonly elevationLevel: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#name BatchPool#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#password BatchPool#password}
    */
    readonly password: string;
    /**
    * linux_user_configuration block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#linux_user_configuration BatchPool#linux_user_configuration}
    */
    readonly linuxUserConfiguration?: BatchPoolUserAccountsLinuxUserConfiguration[] | cdktf.IResolvable;
    /**
    * windows_user_configuration block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#windows_user_configuration BatchPool#windows_user_configuration}
    */
    readonly windowsUserConfiguration?: BatchPoolUserAccountsWindowsUserConfiguration[] | cdktf.IResolvable;
}
export declare function batchPoolUserAccountsToTerraform(struct?: BatchPoolUserAccounts | cdktf.IResolvable): any;
export declare class BatchPoolUserAccountsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): BatchPoolUserAccounts | cdktf.IResolvable | undefined;
    set internalValue(value: BatchPoolUserAccounts | cdktf.IResolvable | undefined);
    private _elevationLevel?;
    get elevationLevel(): string;
    set elevationLevel(value: string);
    get elevationLevelInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    get passwordInput(): string | undefined;
    private _linuxUserConfiguration;
    get linuxUserConfiguration(): BatchPoolUserAccountsLinuxUserConfigurationList;
    putLinuxUserConfiguration(value: BatchPoolUserAccountsLinuxUserConfiguration[] | cdktf.IResolvable): void;
    resetLinuxUserConfiguration(): void;
    get linuxUserConfigurationInput(): cdktf.IResolvable | BatchPoolUserAccountsLinuxUserConfiguration[] | undefined;
    private _windowsUserConfiguration;
    get windowsUserConfiguration(): BatchPoolUserAccountsWindowsUserConfigurationList;
    putWindowsUserConfiguration(value: BatchPoolUserAccountsWindowsUserConfiguration[] | cdktf.IResolvable): void;
    resetWindowsUserConfiguration(): void;
    get windowsUserConfigurationInput(): cdktf.IResolvable | BatchPoolUserAccountsWindowsUserConfiguration[] | undefined;
}
export declare class BatchPoolUserAccountsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: BatchPoolUserAccounts[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): BatchPoolUserAccountsOutputReference;
}
export interface BatchPoolWindows {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#enable_automatic_updates BatchPool#enable_automatic_updates}
    */
    readonly enableAutomaticUpdates?: boolean | cdktf.IResolvable;
}
export declare function batchPoolWindowsToTerraform(struct?: BatchPoolWindows | cdktf.IResolvable): any;
export declare class BatchPoolWindowsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): BatchPoolWindows | cdktf.IResolvable | undefined;
    set internalValue(value: BatchPoolWindows | cdktf.IResolvable | undefined);
    private _enableAutomaticUpdates?;
    get enableAutomaticUpdates(): boolean | cdktf.IResolvable;
    set enableAutomaticUpdates(value: boolean | cdktf.IResolvable);
    resetEnableAutomaticUpdates(): void;
    get enableAutomaticUpdatesInput(): boolean | cdktf.IResolvable | undefined;
}
export declare class BatchPoolWindowsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: BatchPoolWindows[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): BatchPoolWindowsOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool azurerm_batch_pool}
*/
export declare class BatchPool extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_batch_pool";
    /**
    * Generates CDKTF code for importing a BatchPool resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the BatchPool to import
    * @param importFromId The id of the existing BatchPool that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the BatchPool to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/batch_pool azurerm_batch_pool} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options BatchPoolConfig
    */
    constructor(scope: Construct, id: string, config: BatchPoolConfig);
    private _accountName?;
    get accountName(): string;
    set accountName(value: string);
    get accountNameInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _interNodeCommunication?;
    get interNodeCommunication(): string;
    set interNodeCommunication(value: string);
    resetInterNodeCommunication(): void;
    get interNodeCommunicationInput(): string | undefined;
    private _licenseType?;
    get licenseType(): string;
    set licenseType(value: string);
    resetLicenseType(): void;
    get licenseTypeInput(): string | undefined;
    private _maxTasksPerNode?;
    get maxTasksPerNode(): number;
    set maxTasksPerNode(value: number);
    resetMaxTasksPerNode(): void;
    get maxTasksPerNodeInput(): number | undefined;
    private _metadata?;
    get metadata(): {
        [key: string]: string;
    };
    set metadata(value: {
        [key: string]: string;
    });
    resetMetadata(): void;
    get metadataInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _nodeAgentSkuId?;
    get nodeAgentSkuId(): string;
    set nodeAgentSkuId(value: string);
    get nodeAgentSkuIdInput(): string | undefined;
    private _osDiskPlacement?;
    get osDiskPlacement(): string;
    set osDiskPlacement(value: string);
    resetOsDiskPlacement(): void;
    get osDiskPlacementInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _stopPendingResizeOperation?;
    get stopPendingResizeOperation(): boolean | cdktf.IResolvable;
    set stopPendingResizeOperation(value: boolean | cdktf.IResolvable);
    resetStopPendingResizeOperation(): void;
    get stopPendingResizeOperationInput(): boolean | cdktf.IResolvable | undefined;
    private _targetNodeCommunicationMode?;
    get targetNodeCommunicationMode(): string;
    set targetNodeCommunicationMode(value: string);
    resetTargetNodeCommunicationMode(): void;
    get targetNodeCommunicationModeInput(): string | undefined;
    private _vmSize?;
    get vmSize(): string;
    set vmSize(value: string);
    get vmSizeInput(): string | undefined;
    private _autoScale;
    get autoScale(): BatchPoolAutoScaleOutputReference;
    putAutoScale(value: BatchPoolAutoScale): void;
    resetAutoScale(): void;
    get autoScaleInput(): BatchPoolAutoScale | undefined;
    private _certificate;
    get certificate(): BatchPoolCertificateList;
    putCertificate(value: BatchPoolCertificate[] | cdktf.IResolvable): void;
    resetCertificate(): void;
    get certificateInput(): cdktf.IResolvable | BatchPoolCertificate[] | undefined;
    private _containerConfiguration;
    get containerConfiguration(): BatchPoolContainerConfigurationOutputReference;
    putContainerConfiguration(value: BatchPoolContainerConfiguration): void;
    resetContainerConfiguration(): void;
    get containerConfigurationInput(): BatchPoolContainerConfiguration | undefined;
    private _dataDisks;
    get dataDisks(): BatchPoolDataDisksList;
    putDataDisks(value: BatchPoolDataDisks[] | cdktf.IResolvable): void;
    resetDataDisks(): void;
    get dataDisksInput(): cdktf.IResolvable | BatchPoolDataDisks[] | undefined;
    private _diskEncryption;
    get diskEncryption(): BatchPoolDiskEncryptionList;
    putDiskEncryption(value: BatchPoolDiskEncryption[] | cdktf.IResolvable): void;
    resetDiskEncryption(): void;
    get diskEncryptionInput(): cdktf.IResolvable | BatchPoolDiskEncryption[] | undefined;
    private _extensions;
    get extensions(): BatchPoolExtensionsList;
    putExtensions(value: BatchPoolExtensions[] | cdktf.IResolvable): void;
    resetExtensions(): void;
    get extensionsInput(): cdktf.IResolvable | BatchPoolExtensions[] | undefined;
    private _fixedScale;
    get fixedScale(): BatchPoolFixedScaleOutputReference;
    putFixedScale(value: BatchPoolFixedScale): void;
    resetFixedScale(): void;
    get fixedScaleInput(): BatchPoolFixedScale | undefined;
    private _identity;
    get identity(): BatchPoolIdentityOutputReference;
    putIdentity(value: BatchPoolIdentity): void;
    resetIdentity(): void;
    get identityInput(): BatchPoolIdentity | undefined;
    private _mount;
    get mount(): BatchPoolMountList;
    putMount(value: BatchPoolMount[] | cdktf.IResolvable): void;
    resetMount(): void;
    get mountInput(): cdktf.IResolvable | BatchPoolMount[] | undefined;
    private _networkConfiguration;
    get networkConfiguration(): BatchPoolNetworkConfigurationOutputReference;
    putNetworkConfiguration(value: BatchPoolNetworkConfiguration): void;
    resetNetworkConfiguration(): void;
    get networkConfigurationInput(): BatchPoolNetworkConfiguration | undefined;
    private _nodePlacement;
    get nodePlacement(): BatchPoolNodePlacementList;
    putNodePlacement(value: BatchPoolNodePlacement[] | cdktf.IResolvable): void;
    resetNodePlacement(): void;
    get nodePlacementInput(): cdktf.IResolvable | BatchPoolNodePlacement[] | undefined;
    private _startTask;
    get startTask(): BatchPoolStartTaskOutputReference;
    putStartTask(value: BatchPoolStartTask): void;
    resetStartTask(): void;
    get startTaskInput(): BatchPoolStartTask | undefined;
    private _storageImageReference;
    get storageImageReference(): BatchPoolStorageImageReferenceOutputReference;
    putStorageImageReference(value: BatchPoolStorageImageReference): void;
    get storageImageReferenceInput(): BatchPoolStorageImageReference | undefined;
    private _taskSchedulingPolicy;
    get taskSchedulingPolicy(): BatchPoolTaskSchedulingPolicyList;
    putTaskSchedulingPolicy(value: BatchPoolTaskSchedulingPolicy[] | cdktf.IResolvable): void;
    resetTaskSchedulingPolicy(): void;
    get taskSchedulingPolicyInput(): cdktf.IResolvable | BatchPoolTaskSchedulingPolicy[] | undefined;
    private _timeouts;
    get timeouts(): BatchPoolTimeoutsOutputReference;
    putTimeouts(value: BatchPoolTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | BatchPoolTimeouts | undefined;
    private _userAccounts;
    get userAccounts(): BatchPoolUserAccountsList;
    putUserAccounts(value: BatchPoolUserAccounts[] | cdktf.IResolvable): void;
    resetUserAccounts(): void;
    get userAccountsInput(): cdktf.IResolvable | BatchPoolUserAccounts[] | undefined;
    private _windows;
    get windows(): BatchPoolWindowsList;
    putWindows(value: BatchPoolWindows[] | cdktf.IResolvable): void;
    resetWindows(): void;
    get windowsInput(): cdktf.IResolvable | BatchPoolWindows[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
