/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermConsumptionBudgetSubscriptionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/data-sources/consumption_budget_subscription#id DataAzurermConsumptionBudgetSubscription#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/data-sources/consumption_budget_subscription#name DataAzurermConsumptionBudgetSubscription#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/data-sources/consumption_budget_subscription#subscription_id DataAzurermConsumptionBudgetSubscription#subscription_id}
    */
    readonly subscriptionId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/data-sources/consumption_budget_subscription#timeouts DataAzurermConsumptionBudgetSubscription#timeouts}
    */
    readonly timeouts?: DataAzurermConsumptionBudgetSubscriptionTimeouts;
}
export interface DataAzurermConsumptionBudgetSubscriptionFilterDimension {
}
export declare function dataAzurermConsumptionBudgetSubscriptionFilterDimensionToTerraform(struct?: DataAzurermConsumptionBudgetSubscriptionFilterDimension): any;
export declare class DataAzurermConsumptionBudgetSubscriptionFilterDimensionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermConsumptionBudgetSubscriptionFilterDimension | undefined;
    set internalValue(value: DataAzurermConsumptionBudgetSubscriptionFilterDimension | undefined);
    get name(): string;
    get operator(): string;
    get values(): string[];
}
export declare class DataAzurermConsumptionBudgetSubscriptionFilterDimensionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermConsumptionBudgetSubscriptionFilterDimensionOutputReference;
}
export interface DataAzurermConsumptionBudgetSubscriptionFilterNotDimension {
}
export declare function dataAzurermConsumptionBudgetSubscriptionFilterNotDimensionToTerraform(struct?: DataAzurermConsumptionBudgetSubscriptionFilterNotDimension): any;
export declare class DataAzurermConsumptionBudgetSubscriptionFilterNotDimensionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermConsumptionBudgetSubscriptionFilterNotDimension | undefined;
    set internalValue(value: DataAzurermConsumptionBudgetSubscriptionFilterNotDimension | undefined);
    get name(): string;
    get operator(): string;
    get values(): string[];
}
export declare class DataAzurermConsumptionBudgetSubscriptionFilterNotDimensionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermConsumptionBudgetSubscriptionFilterNotDimensionOutputReference;
}
export interface DataAzurermConsumptionBudgetSubscriptionFilterNotTag {
}
export declare function dataAzurermConsumptionBudgetSubscriptionFilterNotTagToTerraform(struct?: DataAzurermConsumptionBudgetSubscriptionFilterNotTag): any;
export declare class DataAzurermConsumptionBudgetSubscriptionFilterNotTagOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermConsumptionBudgetSubscriptionFilterNotTag | undefined;
    set internalValue(value: DataAzurermConsumptionBudgetSubscriptionFilterNotTag | undefined);
    get name(): string;
    get operator(): string;
    get values(): string[];
}
export declare class DataAzurermConsumptionBudgetSubscriptionFilterNotTagList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermConsumptionBudgetSubscriptionFilterNotTagOutputReference;
}
export interface DataAzurermConsumptionBudgetSubscriptionFilterNot {
}
export declare function dataAzurermConsumptionBudgetSubscriptionFilterNotToTerraform(struct?: DataAzurermConsumptionBudgetSubscriptionFilterNot): any;
export declare class DataAzurermConsumptionBudgetSubscriptionFilterNotOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermConsumptionBudgetSubscriptionFilterNot | undefined;
    set internalValue(value: DataAzurermConsumptionBudgetSubscriptionFilterNot | undefined);
    private _dimension;
    get dimension(): DataAzurermConsumptionBudgetSubscriptionFilterNotDimensionList;
    private _tag;
    get tag(): DataAzurermConsumptionBudgetSubscriptionFilterNotTagList;
}
export declare class DataAzurermConsumptionBudgetSubscriptionFilterNotList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermConsumptionBudgetSubscriptionFilterNotOutputReference;
}
export interface DataAzurermConsumptionBudgetSubscriptionFilterTag {
}
export declare function dataAzurermConsumptionBudgetSubscriptionFilterTagToTerraform(struct?: DataAzurermConsumptionBudgetSubscriptionFilterTag): any;
export declare class DataAzurermConsumptionBudgetSubscriptionFilterTagOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermConsumptionBudgetSubscriptionFilterTag | undefined;
    set internalValue(value: DataAzurermConsumptionBudgetSubscriptionFilterTag | undefined);
    get name(): string;
    get operator(): string;
    get values(): string[];
}
export declare class DataAzurermConsumptionBudgetSubscriptionFilterTagList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermConsumptionBudgetSubscriptionFilterTagOutputReference;
}
export interface DataAzurermConsumptionBudgetSubscriptionFilter {
}
export declare function dataAzurermConsumptionBudgetSubscriptionFilterToTerraform(struct?: DataAzurermConsumptionBudgetSubscriptionFilter): any;
export declare class DataAzurermConsumptionBudgetSubscriptionFilterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermConsumptionBudgetSubscriptionFilter | undefined;
    set internalValue(value: DataAzurermConsumptionBudgetSubscriptionFilter | undefined);
    private _dimension;
    get dimension(): DataAzurermConsumptionBudgetSubscriptionFilterDimensionList;
    private _not;
    get not(): DataAzurermConsumptionBudgetSubscriptionFilterNotList;
    private _tag;
    get tag(): DataAzurermConsumptionBudgetSubscriptionFilterTagList;
}
export declare class DataAzurermConsumptionBudgetSubscriptionFilterList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermConsumptionBudgetSubscriptionFilterOutputReference;
}
export interface DataAzurermConsumptionBudgetSubscriptionNotification {
}
export declare function dataAzurermConsumptionBudgetSubscriptionNotificationToTerraform(struct?: DataAzurermConsumptionBudgetSubscriptionNotification): any;
export declare class DataAzurermConsumptionBudgetSubscriptionNotificationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermConsumptionBudgetSubscriptionNotification | undefined;
    set internalValue(value: DataAzurermConsumptionBudgetSubscriptionNotification | undefined);
    get contactEmails(): string[];
    get contactGroups(): string[];
    get contactRoles(): string[];
    get enabled(): cdktf.IResolvable;
    get operator(): string;
    get threshold(): number;
    get thresholdType(): string;
}
export declare class DataAzurermConsumptionBudgetSubscriptionNotificationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermConsumptionBudgetSubscriptionNotificationOutputReference;
}
export interface DataAzurermConsumptionBudgetSubscriptionTimePeriod {
}
export declare function dataAzurermConsumptionBudgetSubscriptionTimePeriodToTerraform(struct?: DataAzurermConsumptionBudgetSubscriptionTimePeriod): any;
export declare class DataAzurermConsumptionBudgetSubscriptionTimePeriodOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermConsumptionBudgetSubscriptionTimePeriod | undefined;
    set internalValue(value: DataAzurermConsumptionBudgetSubscriptionTimePeriod | undefined);
    get endDate(): string;
    get startDate(): string;
}
export declare class DataAzurermConsumptionBudgetSubscriptionTimePeriodList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermConsumptionBudgetSubscriptionTimePeriodOutputReference;
}
export interface DataAzurermConsumptionBudgetSubscriptionTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/data-sources/consumption_budget_subscription#read DataAzurermConsumptionBudgetSubscription#read}
    */
    readonly read?: string;
}
export declare function dataAzurermConsumptionBudgetSubscriptionTimeoutsToTerraform(struct?: DataAzurermConsumptionBudgetSubscriptionTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermConsumptionBudgetSubscriptionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermConsumptionBudgetSubscriptionTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermConsumptionBudgetSubscriptionTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/data-sources/consumption_budget_subscription azurerm_consumption_budget_subscription}
*/
export declare class DataAzurermConsumptionBudgetSubscription extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_consumption_budget_subscription";
    /**
    * Generates CDKTF code for importing a DataAzurermConsumptionBudgetSubscription resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermConsumptionBudgetSubscription to import
    * @param importFromId The id of the existing DataAzurermConsumptionBudgetSubscription that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/data-sources/consumption_budget_subscription#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermConsumptionBudgetSubscription to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/data-sources/consumption_budget_subscription azurerm_consumption_budget_subscription} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermConsumptionBudgetSubscriptionConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermConsumptionBudgetSubscriptionConfig);
    get amount(): number;
    private _filter;
    get filter(): DataAzurermConsumptionBudgetSubscriptionFilterList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _notification;
    get notification(): DataAzurermConsumptionBudgetSubscriptionNotificationList;
    private _subscriptionId?;
    get subscriptionId(): string;
    set subscriptionId(value: string);
    get subscriptionIdInput(): string | undefined;
    get timeGrain(): string;
    private _timePeriod;
    get timePeriod(): DataAzurermConsumptionBudgetSubscriptionTimePeriodList;
    private _timeouts;
    get timeouts(): DataAzurermConsumptionBudgetSubscriptionTimeoutsOutputReference;
    putTimeouts(value: DataAzurermConsumptionBudgetSubscriptionTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermConsumptionBudgetSubscriptionTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
