/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermExtendedLocationsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/data-sources/extended_locations#id DataAzurermExtendedLocations#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/data-sources/extended_locations#location DataAzurermExtendedLocations#location}
    */
    readonly location: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/data-sources/extended_locations#timeouts DataAzurermExtendedLocations#timeouts}
    */
    readonly timeouts?: DataAzurermExtendedLocationsTimeouts;
}
export interface DataAzurermExtendedLocationsTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/data-sources/extended_locations#read DataAzurermExtendedLocations#read}
    */
    readonly read?: string;
}
export declare function dataAzurermExtendedLocationsTimeoutsToTerraform(struct?: DataAzurermExtendedLocationsTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermExtendedLocationsTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermExtendedLocationsTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermExtendedLocationsTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/data-sources/extended_locations azurerm_extended_locations}
*/
export declare class DataAzurermExtendedLocations extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_extended_locations";
    /**
    * Generates CDKTF code for importing a DataAzurermExtendedLocations resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermExtendedLocations to import
    * @param importFromId The id of the existing DataAzurermExtendedLocations that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/data-sources/extended_locations#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermExtendedLocations to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/data-sources/extended_locations azurerm_extended_locations} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermExtendedLocationsConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermExtendedLocationsConfig);
    get extendedLocations(): string[];
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _timeouts;
    get timeouts(): DataAzurermExtendedLocationsTimeoutsOutputReference;
    putTimeouts(value: DataAzurermExtendedLocationsTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermExtendedLocationsTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
