/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermFunctionAppConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/data-sources/function_app#id DataAzurermFunctionApp#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/data-sources/function_app#name DataAzurermFunctionApp#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/data-sources/function_app#resource_group_name DataAzurermFunctionApp#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/data-sources/function_app#tags DataAzurermFunctionApp#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/data-sources/function_app#timeouts DataAzurermFunctionApp#timeouts}
    */
    readonly timeouts?: DataAzurermFunctionAppTimeouts;
}
export interface DataAzurermFunctionAppConnectionString {
}
export declare function dataAzurermFunctionAppConnectionStringToTerraform(struct?: DataAzurermFunctionAppConnectionString): any;
export declare class DataAzurermFunctionAppConnectionStringOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermFunctionAppConnectionString | undefined;
    set internalValue(value: DataAzurermFunctionAppConnectionString | undefined);
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class DataAzurermFunctionAppConnectionStringList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermFunctionAppConnectionStringOutputReference;
}
export interface DataAzurermFunctionAppIdentity {
}
export declare function dataAzurermFunctionAppIdentityToTerraform(struct?: DataAzurermFunctionAppIdentity): any;
export declare class DataAzurermFunctionAppIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermFunctionAppIdentity | undefined;
    set internalValue(value: DataAzurermFunctionAppIdentity | undefined);
    get identityIds(): string[];
    get principalId(): string;
    get tenantId(): string;
    get type(): string;
}
export declare class DataAzurermFunctionAppIdentityList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermFunctionAppIdentityOutputReference;
}
export interface DataAzurermFunctionAppSiteConfigCors {
}
export declare function dataAzurermFunctionAppSiteConfigCorsToTerraform(struct?: DataAzurermFunctionAppSiteConfigCors): any;
export declare class DataAzurermFunctionAppSiteConfigCorsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermFunctionAppSiteConfigCors | undefined;
    set internalValue(value: DataAzurermFunctionAppSiteConfigCors | undefined);
    get allowedOrigins(): string[];
    get supportCredentials(): cdktf.IResolvable;
}
export declare class DataAzurermFunctionAppSiteConfigCorsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermFunctionAppSiteConfigCorsOutputReference;
}
export interface DataAzurermFunctionAppSiteConfigIpRestrictionHeaders {
}
export declare function dataAzurermFunctionAppSiteConfigIpRestrictionHeadersToTerraform(struct?: DataAzurermFunctionAppSiteConfigIpRestrictionHeaders): any;
export declare class DataAzurermFunctionAppSiteConfigIpRestrictionHeadersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermFunctionAppSiteConfigIpRestrictionHeaders | undefined;
    set internalValue(value: DataAzurermFunctionAppSiteConfigIpRestrictionHeaders | undefined);
    get xAzureFdid(): string[];
    get xFdHealthProbe(): string[];
    get xForwardedFor(): string[];
    get xForwardedHost(): string[];
}
export declare class DataAzurermFunctionAppSiteConfigIpRestrictionHeadersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermFunctionAppSiteConfigIpRestrictionHeadersOutputReference;
}
export interface DataAzurermFunctionAppSiteConfigIpRestriction {
}
export declare function dataAzurermFunctionAppSiteConfigIpRestrictionToTerraform(struct?: DataAzurermFunctionAppSiteConfigIpRestriction): any;
export declare class DataAzurermFunctionAppSiteConfigIpRestrictionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermFunctionAppSiteConfigIpRestriction | undefined;
    set internalValue(value: DataAzurermFunctionAppSiteConfigIpRestriction | undefined);
    get action(): string;
    private _headers;
    get headers(): DataAzurermFunctionAppSiteConfigIpRestrictionHeadersList;
    get ipAddress(): string;
    get name(): string;
    get priority(): number;
    get serviceTag(): string;
    get virtualNetworkSubnetId(): string;
}
export declare class DataAzurermFunctionAppSiteConfigIpRestrictionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermFunctionAppSiteConfigIpRestrictionOutputReference;
}
export interface DataAzurermFunctionAppSiteConfigScmIpRestrictionHeaders {
}
export declare function dataAzurermFunctionAppSiteConfigScmIpRestrictionHeadersToTerraform(struct?: DataAzurermFunctionAppSiteConfigScmIpRestrictionHeaders): any;
export declare class DataAzurermFunctionAppSiteConfigScmIpRestrictionHeadersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermFunctionAppSiteConfigScmIpRestrictionHeaders | undefined;
    set internalValue(value: DataAzurermFunctionAppSiteConfigScmIpRestrictionHeaders | undefined);
    get xAzureFdid(): string[];
    get xFdHealthProbe(): string[];
    get xForwardedFor(): string[];
    get xForwardedHost(): string[];
}
export declare class DataAzurermFunctionAppSiteConfigScmIpRestrictionHeadersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermFunctionAppSiteConfigScmIpRestrictionHeadersOutputReference;
}
export interface DataAzurermFunctionAppSiteConfigScmIpRestriction {
}
export declare function dataAzurermFunctionAppSiteConfigScmIpRestrictionToTerraform(struct?: DataAzurermFunctionAppSiteConfigScmIpRestriction): any;
export declare class DataAzurermFunctionAppSiteConfigScmIpRestrictionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermFunctionAppSiteConfigScmIpRestriction | undefined;
    set internalValue(value: DataAzurermFunctionAppSiteConfigScmIpRestriction | undefined);
    get action(): string;
    private _headers;
    get headers(): DataAzurermFunctionAppSiteConfigScmIpRestrictionHeadersList;
    get ipAddress(): string;
    get name(): string;
    get priority(): number;
    get serviceTag(): string;
    get virtualNetworkSubnetId(): string;
}
export declare class DataAzurermFunctionAppSiteConfigScmIpRestrictionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermFunctionAppSiteConfigScmIpRestrictionOutputReference;
}
export interface DataAzurermFunctionAppSiteConfig {
}
export declare function dataAzurermFunctionAppSiteConfigToTerraform(struct?: DataAzurermFunctionAppSiteConfig): any;
export declare class DataAzurermFunctionAppSiteConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermFunctionAppSiteConfig | undefined;
    set internalValue(value: DataAzurermFunctionAppSiteConfig | undefined);
    get alwaysOn(): cdktf.IResolvable;
    get appScaleLimit(): number;
    get autoSwapSlotName(): string;
    private _cors;
    get cors(): DataAzurermFunctionAppSiteConfigCorsList;
    get dotnetFrameworkVersion(): string;
    get elasticInstanceMinimum(): number;
    get ftpsState(): string;
    get healthCheckPath(): string;
    get http2Enabled(): cdktf.IResolvable;
    private _ipRestriction;
    get ipRestriction(): DataAzurermFunctionAppSiteConfigIpRestrictionList;
    get javaVersion(): string;
    get linuxFxVersion(): string;
    get minTlsVersion(): string;
    get preWarmedInstanceCount(): number;
    get runtimeScaleMonitoringEnabled(): cdktf.IResolvable;
    private _scmIpRestriction;
    get scmIpRestriction(): DataAzurermFunctionAppSiteConfigScmIpRestrictionList;
    get scmType(): string;
    get scmUseMainIpRestriction(): cdktf.IResolvable;
    get use32BitWorkerProcess(): cdktf.IResolvable;
    get vnetRouteAllEnabled(): cdktf.IResolvable;
    get websocketsEnabled(): cdktf.IResolvable;
}
export declare class DataAzurermFunctionAppSiteConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermFunctionAppSiteConfigOutputReference;
}
export interface DataAzurermFunctionAppSiteCredential {
}
export declare function dataAzurermFunctionAppSiteCredentialToTerraform(struct?: DataAzurermFunctionAppSiteCredential): any;
export declare class DataAzurermFunctionAppSiteCredentialOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermFunctionAppSiteCredential | undefined;
    set internalValue(value: DataAzurermFunctionAppSiteCredential | undefined);
    get password(): string;
    get username(): string;
}
export declare class DataAzurermFunctionAppSiteCredentialList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermFunctionAppSiteCredentialOutputReference;
}
export interface DataAzurermFunctionAppSourceControl {
}
export declare function dataAzurermFunctionAppSourceControlToTerraform(struct?: DataAzurermFunctionAppSourceControl): any;
export declare class DataAzurermFunctionAppSourceControlOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermFunctionAppSourceControl | undefined;
    set internalValue(value: DataAzurermFunctionAppSourceControl | undefined);
    get branch(): string;
    get manualIntegration(): cdktf.IResolvable;
    get repoUrl(): string;
    get rollbackEnabled(): cdktf.IResolvable;
    get useMercurial(): cdktf.IResolvable;
}
export declare class DataAzurermFunctionAppSourceControlList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermFunctionAppSourceControlOutputReference;
}
export interface DataAzurermFunctionAppTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/data-sources/function_app#read DataAzurermFunctionApp#read}
    */
    readonly read?: string;
}
export declare function dataAzurermFunctionAppTimeoutsToTerraform(struct?: DataAzurermFunctionAppTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermFunctionAppTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermFunctionAppTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermFunctionAppTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/data-sources/function_app azurerm_function_app}
*/
export declare class DataAzurermFunctionApp extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_function_app";
    /**
    * Generates CDKTF code for importing a DataAzurermFunctionApp resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermFunctionApp to import
    * @param importFromId The id of the existing DataAzurermFunctionApp that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/data-sources/function_app#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermFunctionApp to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/data-sources/function_app azurerm_function_app} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermFunctionAppConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermFunctionAppConfig);
    get appServicePlanId(): string;
    private _appSettings;
    get appSettings(): cdktf.StringMap;
    get clientCertMode(): string;
    private _connectionString;
    get connectionString(): DataAzurermFunctionAppConnectionStringList;
    get customDomainVerificationId(): string;
    get defaultHostname(): string;
    get enabled(): cdktf.IResolvable;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _identity;
    get identity(): DataAzurermFunctionAppIdentityList;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get osType(): string;
    get outboundIpAddresses(): string;
    get possibleOutboundIpAddresses(): string;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _siteConfig;
    get siteConfig(): DataAzurermFunctionAppSiteConfigList;
    private _siteCredential;
    get siteCredential(): DataAzurermFunctionAppSiteCredentialList;
    private _sourceControl;
    get sourceControl(): DataAzurermFunctionAppSourceControlList;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _timeouts;
    get timeouts(): DataAzurermFunctionAppTimeoutsOutputReference;
    putTimeouts(value: DataAzurermFunctionAppTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermFunctionAppTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
