/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermHealthcareDicomServiceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/data-sources/healthcare_dicom_service#id DataAzurermHealthcareDicomService#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/data-sources/healthcare_dicom_service#name DataAzurermHealthcareDicomService#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/data-sources/healthcare_dicom_service#workspace_id DataAzurermHealthcareDicomService#workspace_id}
    */
    readonly workspaceId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/data-sources/healthcare_dicom_service#timeouts DataAzurermHealthcareDicomService#timeouts}
    */
    readonly timeouts?: DataAzurermHealthcareDicomServiceTimeouts;
}
export interface DataAzurermHealthcareDicomServiceAuthentication {
}
export declare function dataAzurermHealthcareDicomServiceAuthenticationToTerraform(struct?: DataAzurermHealthcareDicomServiceAuthentication): any;
export declare class DataAzurermHealthcareDicomServiceAuthenticationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermHealthcareDicomServiceAuthentication | undefined;
    set internalValue(value: DataAzurermHealthcareDicomServiceAuthentication | undefined);
    get audience(): string[];
    get authority(): string;
}
export declare class DataAzurermHealthcareDicomServiceAuthenticationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermHealthcareDicomServiceAuthenticationOutputReference;
}
export interface DataAzurermHealthcareDicomServiceIdentity {
}
export declare function dataAzurermHealthcareDicomServiceIdentityToTerraform(struct?: DataAzurermHealthcareDicomServiceIdentity): any;
export declare class DataAzurermHealthcareDicomServiceIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermHealthcareDicomServiceIdentity | undefined;
    set internalValue(value: DataAzurermHealthcareDicomServiceIdentity | undefined);
    get identityIds(): string[];
    get principalId(): string;
    get tenantId(): string;
    get type(): string;
}
export declare class DataAzurermHealthcareDicomServiceIdentityList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermHealthcareDicomServiceIdentityOutputReference;
}
export interface DataAzurermHealthcareDicomServicePrivateEndpoint {
}
export declare function dataAzurermHealthcareDicomServicePrivateEndpointToTerraform(struct?: DataAzurermHealthcareDicomServicePrivateEndpoint): any;
export declare class DataAzurermHealthcareDicomServicePrivateEndpointOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermHealthcareDicomServicePrivateEndpoint | undefined;
    set internalValue(value: DataAzurermHealthcareDicomServicePrivateEndpoint | undefined);
    get id(): string;
    get name(): string;
}
export declare class DataAzurermHealthcareDicomServicePrivateEndpointList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermHealthcareDicomServicePrivateEndpointOutputReference;
}
export interface DataAzurermHealthcareDicomServiceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/data-sources/healthcare_dicom_service#read DataAzurermHealthcareDicomService#read}
    */
    readonly read?: string;
}
export declare function dataAzurermHealthcareDicomServiceTimeoutsToTerraform(struct?: DataAzurermHealthcareDicomServiceTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermHealthcareDicomServiceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermHealthcareDicomServiceTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermHealthcareDicomServiceTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/data-sources/healthcare_dicom_service azurerm_healthcare_dicom_service}
*/
export declare class DataAzurermHealthcareDicomService extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_healthcare_dicom_service";
    /**
    * Generates CDKTF code for importing a DataAzurermHealthcareDicomService resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermHealthcareDicomService to import
    * @param importFromId The id of the existing DataAzurermHealthcareDicomService that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/data-sources/healthcare_dicom_service#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermHealthcareDicomService to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/data-sources/healthcare_dicom_service azurerm_healthcare_dicom_service} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermHealthcareDicomServiceConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermHealthcareDicomServiceConfig);
    private _authentication;
    get authentication(): DataAzurermHealthcareDicomServiceAuthenticationList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _identity;
    get identity(): DataAzurermHealthcareDicomServiceIdentityList;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _privateEndpoint;
    get privateEndpoint(): DataAzurermHealthcareDicomServicePrivateEndpointList;
    get serviceUrl(): string;
    private _tags;
    get tags(): cdktf.StringMap;
    private _workspaceId?;
    get workspaceId(): string;
    set workspaceId(value: string);
    get workspaceIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): DataAzurermHealthcareDicomServiceTimeoutsOutputReference;
    putTimeouts(value: DataAzurermHealthcareDicomServiceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermHealthcareDicomServiceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
