/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermImageConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/data-sources/image#id DataAzurermImage#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/data-sources/image#name DataAzurermImage#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/data-sources/image#name_regex DataAzurermImage#name_regex}
    */
    readonly nameRegex?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/data-sources/image#resource_group_name DataAzurermImage#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/data-sources/image#sort_descending DataAzurermImage#sort_descending}
    */
    readonly sortDescending?: boolean | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/data-sources/image#timeouts DataAzurermImage#timeouts}
    */
    readonly timeouts?: DataAzurermImageTimeouts;
}
export interface DataAzurermImageDataDisk {
}
export declare function dataAzurermImageDataDiskToTerraform(struct?: DataAzurermImageDataDisk): any;
export declare class DataAzurermImageDataDiskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermImageDataDisk | undefined;
    set internalValue(value: DataAzurermImageDataDisk | undefined);
    get blobUri(): string;
    get caching(): string;
    get lun(): number;
    get managedDiskId(): string;
    get sizeGb(): number;
}
export declare class DataAzurermImageDataDiskList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermImageDataDiskOutputReference;
}
export interface DataAzurermImageOsDisk {
}
export declare function dataAzurermImageOsDiskToTerraform(struct?: DataAzurermImageOsDisk): any;
export declare class DataAzurermImageOsDiskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermImageOsDisk | undefined;
    set internalValue(value: DataAzurermImageOsDisk | undefined);
    get blobUri(): string;
    get caching(): string;
    get managedDiskId(): string;
    get osState(): string;
    get osType(): string;
    get sizeGb(): number;
}
export declare class DataAzurermImageOsDiskList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermImageOsDiskOutputReference;
}
export interface DataAzurermImageTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/data-sources/image#read DataAzurermImage#read}
    */
    readonly read?: string;
}
export declare function dataAzurermImageTimeoutsToTerraform(struct?: DataAzurermImageTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermImageTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermImageTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermImageTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/data-sources/image azurerm_image}
*/
export declare class DataAzurermImage extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_image";
    /**
    * Generates CDKTF code for importing a DataAzurermImage resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermImage to import
    * @param importFromId The id of the existing DataAzurermImage that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/data-sources/image#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermImage to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/data-sources/image azurerm_image} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermImageConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermImageConfig);
    private _dataDisk;
    get dataDisk(): DataAzurermImageDataDiskList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _nameRegex?;
    get nameRegex(): string;
    set nameRegex(value: string);
    resetNameRegex(): void;
    get nameRegexInput(): string | undefined;
    private _osDisk;
    get osDisk(): DataAzurermImageOsDiskList;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _sortDescending?;
    get sortDescending(): boolean | cdktf.IResolvable;
    set sortDescending(value: boolean | cdktf.IResolvable);
    resetSortDescending(): void;
    get sortDescendingInput(): boolean | cdktf.IResolvable | undefined;
    private _tags;
    get tags(): cdktf.StringMap;
    get zoneResilient(): cdktf.IResolvable;
    private _timeouts;
    get timeouts(): DataAzurermImageTimeoutsOutputReference;
    putTimeouts(value: DataAzurermImageTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermImageTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
