/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermNotificationHubConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/data-sources/notification_hub#id DataAzurermNotificationHub#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/data-sources/notification_hub#name DataAzurermNotificationHub#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/data-sources/notification_hub#namespace_name DataAzurermNotificationHub#namespace_name}
    */
    readonly namespaceName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/data-sources/notification_hub#resource_group_name DataAzurermNotificationHub#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/data-sources/notification_hub#timeouts DataAzurermNotificationHub#timeouts}
    */
    readonly timeouts?: DataAzurermNotificationHubTimeouts;
}
export interface DataAzurermNotificationHubApnsCredential {
}
export declare function dataAzurermNotificationHubApnsCredentialToTerraform(struct?: DataAzurermNotificationHubApnsCredential): any;
export declare class DataAzurermNotificationHubApnsCredentialOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermNotificationHubApnsCredential | undefined;
    set internalValue(value: DataAzurermNotificationHubApnsCredential | undefined);
    get applicationMode(): string;
    get bundleId(): string;
    get keyId(): string;
    get teamId(): string;
    get token(): string;
}
export declare class DataAzurermNotificationHubApnsCredentialList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermNotificationHubApnsCredentialOutputReference;
}
export interface DataAzurermNotificationHubGcmCredential {
}
export declare function dataAzurermNotificationHubGcmCredentialToTerraform(struct?: DataAzurermNotificationHubGcmCredential): any;
export declare class DataAzurermNotificationHubGcmCredentialOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermNotificationHubGcmCredential | undefined;
    set internalValue(value: DataAzurermNotificationHubGcmCredential | undefined);
    get apiKey(): string;
}
export declare class DataAzurermNotificationHubGcmCredentialList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermNotificationHubGcmCredentialOutputReference;
}
export interface DataAzurermNotificationHubTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/data-sources/notification_hub#read DataAzurermNotificationHub#read}
    */
    readonly read?: string;
}
export declare function dataAzurermNotificationHubTimeoutsToTerraform(struct?: DataAzurermNotificationHubTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermNotificationHubTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermNotificationHubTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermNotificationHubTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/data-sources/notification_hub azurerm_notification_hub}
*/
export declare class DataAzurermNotificationHub extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_notification_hub";
    /**
    * Generates CDKTF code for importing a DataAzurermNotificationHub resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermNotificationHub to import
    * @param importFromId The id of the existing DataAzurermNotificationHub that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/data-sources/notification_hub#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermNotificationHub to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/data-sources/notification_hub azurerm_notification_hub} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermNotificationHubConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermNotificationHubConfig);
    private _apnsCredential;
    get apnsCredential(): DataAzurermNotificationHubApnsCredentialList;
    private _gcmCredential;
    get gcmCredential(): DataAzurermNotificationHubGcmCredentialList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _namespaceName?;
    get namespaceName(): string;
    set namespaceName(value: string);
    get namespaceNameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tags;
    get tags(): cdktf.StringMap;
    private _timeouts;
    get timeouts(): DataAzurermNotificationHubTimeoutsOutputReference;
    putTimeouts(value: DataAzurermNotificationHubTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermNotificationHubTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
