/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermSentinelAlertRuleTemplateConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/data-sources/sentinel_alert_rule_template#display_name DataAzurermSentinelAlertRuleTemplate#display_name}
    */
    readonly displayName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/data-sources/sentinel_alert_rule_template#id DataAzurermSentinelAlertRuleTemplate#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/data-sources/sentinel_alert_rule_template#log_analytics_workspace_id DataAzurermSentinelAlertRuleTemplate#log_analytics_workspace_id}
    */
    readonly logAnalyticsWorkspaceId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/data-sources/sentinel_alert_rule_template#name DataAzurermSentinelAlertRuleTemplate#name}
    */
    readonly name?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/data-sources/sentinel_alert_rule_template#timeouts DataAzurermSentinelAlertRuleTemplate#timeouts}
    */
    readonly timeouts?: DataAzurermSentinelAlertRuleTemplateTimeouts;
}
export interface DataAzurermSentinelAlertRuleTemplateNrtTemplate {
}
export declare function dataAzurermSentinelAlertRuleTemplateNrtTemplateToTerraform(struct?: DataAzurermSentinelAlertRuleTemplateNrtTemplate): any;
export declare class DataAzurermSentinelAlertRuleTemplateNrtTemplateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermSentinelAlertRuleTemplateNrtTemplate | undefined;
    set internalValue(value: DataAzurermSentinelAlertRuleTemplateNrtTemplate | undefined);
    get description(): string;
    get query(): string;
    get severity(): string;
    get tactics(): string[];
}
export declare class DataAzurermSentinelAlertRuleTemplateNrtTemplateList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermSentinelAlertRuleTemplateNrtTemplateOutputReference;
}
export interface DataAzurermSentinelAlertRuleTemplateScheduledTemplate {
}
export declare function dataAzurermSentinelAlertRuleTemplateScheduledTemplateToTerraform(struct?: DataAzurermSentinelAlertRuleTemplateScheduledTemplate): any;
export declare class DataAzurermSentinelAlertRuleTemplateScheduledTemplateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermSentinelAlertRuleTemplateScheduledTemplate | undefined;
    set internalValue(value: DataAzurermSentinelAlertRuleTemplateScheduledTemplate | undefined);
    get description(): string;
    get query(): string;
    get queryFrequency(): string;
    get queryPeriod(): string;
    get severity(): string;
    get tactics(): string[];
    get triggerOperator(): string;
    get triggerThreshold(): number;
}
export declare class DataAzurermSentinelAlertRuleTemplateScheduledTemplateList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermSentinelAlertRuleTemplateScheduledTemplateOutputReference;
}
export interface DataAzurermSentinelAlertRuleTemplateSecurityIncidentTemplate {
}
export declare function dataAzurermSentinelAlertRuleTemplateSecurityIncidentTemplateToTerraform(struct?: DataAzurermSentinelAlertRuleTemplateSecurityIncidentTemplate): any;
export declare class DataAzurermSentinelAlertRuleTemplateSecurityIncidentTemplateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermSentinelAlertRuleTemplateSecurityIncidentTemplate | undefined;
    set internalValue(value: DataAzurermSentinelAlertRuleTemplateSecurityIncidentTemplate | undefined);
    get description(): string;
    get productFilter(): string;
}
export declare class DataAzurermSentinelAlertRuleTemplateSecurityIncidentTemplateList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermSentinelAlertRuleTemplateSecurityIncidentTemplateOutputReference;
}
export interface DataAzurermSentinelAlertRuleTemplateTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/data-sources/sentinel_alert_rule_template#read DataAzurermSentinelAlertRuleTemplate#read}
    */
    readonly read?: string;
}
export declare function dataAzurermSentinelAlertRuleTemplateTimeoutsToTerraform(struct?: DataAzurermSentinelAlertRuleTemplateTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermSentinelAlertRuleTemplateTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermSentinelAlertRuleTemplateTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermSentinelAlertRuleTemplateTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/data-sources/sentinel_alert_rule_template azurerm_sentinel_alert_rule_template}
*/
export declare class DataAzurermSentinelAlertRuleTemplate extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_sentinel_alert_rule_template";
    /**
    * Generates CDKTF code for importing a DataAzurermSentinelAlertRuleTemplate resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermSentinelAlertRuleTemplate to import
    * @param importFromId The id of the existing DataAzurermSentinelAlertRuleTemplate that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/data-sources/sentinel_alert_rule_template#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermSentinelAlertRuleTemplate to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/data-sources/sentinel_alert_rule_template azurerm_sentinel_alert_rule_template} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermSentinelAlertRuleTemplateConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermSentinelAlertRuleTemplateConfig);
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _logAnalyticsWorkspaceId?;
    get logAnalyticsWorkspaceId(): string;
    set logAnalyticsWorkspaceId(value: string);
    get logAnalyticsWorkspaceIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _nrtTemplate;
    get nrtTemplate(): DataAzurermSentinelAlertRuleTemplateNrtTemplateList;
    private _scheduledTemplate;
    get scheduledTemplate(): DataAzurermSentinelAlertRuleTemplateScheduledTemplateList;
    private _securityIncidentTemplate;
    get securityIncidentTemplate(): DataAzurermSentinelAlertRuleTemplateSecurityIncidentTemplateList;
    private _timeouts;
    get timeouts(): DataAzurermSentinelAlertRuleTemplateTimeoutsOutputReference;
    putTimeouts(value: DataAzurermSentinelAlertRuleTemplateTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermSentinelAlertRuleTemplateTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
