/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermSiteRecoveryReplicationPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/data-sources/site_recovery_replication_policy#id DataAzurermSiteRecoveryReplicationPolicy#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/data-sources/site_recovery_replication_policy#name DataAzurermSiteRecoveryReplicationPolicy#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/data-sources/site_recovery_replication_policy#recovery_vault_name DataAzurermSiteRecoveryReplicationPolicy#recovery_vault_name}
    */
    readonly recoveryVaultName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/data-sources/site_recovery_replication_policy#resource_group_name DataAzurermSiteRecoveryReplicationPolicy#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/data-sources/site_recovery_replication_policy#timeouts DataAzurermSiteRecoveryReplicationPolicy#timeouts}
    */
    readonly timeouts?: DataAzurermSiteRecoveryReplicationPolicyTimeouts;
}
export interface DataAzurermSiteRecoveryReplicationPolicyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/data-sources/site_recovery_replication_policy#read DataAzurermSiteRecoveryReplicationPolicy#read}
    */
    readonly read?: string;
}
export declare function dataAzurermSiteRecoveryReplicationPolicyTimeoutsToTerraform(struct?: DataAzurermSiteRecoveryReplicationPolicyTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermSiteRecoveryReplicationPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermSiteRecoveryReplicationPolicyTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermSiteRecoveryReplicationPolicyTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/data-sources/site_recovery_replication_policy azurerm_site_recovery_replication_policy}
*/
export declare class DataAzurermSiteRecoveryReplicationPolicy extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_site_recovery_replication_policy";
    /**
    * Generates CDKTF code for importing a DataAzurermSiteRecoveryReplicationPolicy resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermSiteRecoveryReplicationPolicy to import
    * @param importFromId The id of the existing DataAzurermSiteRecoveryReplicationPolicy that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/data-sources/site_recovery_replication_policy#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermSiteRecoveryReplicationPolicy to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/data-sources/site_recovery_replication_policy azurerm_site_recovery_replication_policy} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermSiteRecoveryReplicationPolicyConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermSiteRecoveryReplicationPolicyConfig);
    get applicationConsistentSnapshotFrequencyInMinutes(): number;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get recoveryPointRetentionInMinutes(): number;
    private _recoveryVaultName?;
    get recoveryVaultName(): string;
    set recoveryVaultName(value: string);
    get recoveryVaultNameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _timeouts;
    get timeouts(): DataAzurermSiteRecoveryReplicationPolicyTimeoutsOutputReference;
    putTimeouts(value: DataAzurermSiteRecoveryReplicationPolicyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermSiteRecoveryReplicationPolicyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
