/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DiskPoolIscsiTargetConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/disk_pool_iscsi_target#acl_mode DiskPoolIscsiTarget#acl_mode}
    */
    readonly aclMode: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/disk_pool_iscsi_target#disks_pool_id DiskPoolIscsiTarget#disks_pool_id}
    */
    readonly disksPoolId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/disk_pool_iscsi_target#id DiskPoolIscsiTarget#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/disk_pool_iscsi_target#name DiskPoolIscsiTarget#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/disk_pool_iscsi_target#target_iqn DiskPoolIscsiTarget#target_iqn}
    */
    readonly targetIqn?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/disk_pool_iscsi_target#timeouts DiskPoolIscsiTarget#timeouts}
    */
    readonly timeouts?: DiskPoolIscsiTargetTimeouts;
}
export interface DiskPoolIscsiTargetTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/disk_pool_iscsi_target#create DiskPoolIscsiTarget#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/disk_pool_iscsi_target#delete DiskPoolIscsiTarget#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/disk_pool_iscsi_target#read DiskPoolIscsiTarget#read}
    */
    readonly read?: string;
}
export declare function diskPoolIscsiTargetTimeoutsToTerraform(struct?: DiskPoolIscsiTargetTimeouts | cdktf.IResolvable): any;
export declare class DiskPoolIscsiTargetTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DiskPoolIscsiTargetTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DiskPoolIscsiTargetTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/disk_pool_iscsi_target azurerm_disk_pool_iscsi_target}
*/
export declare class DiskPoolIscsiTarget extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_disk_pool_iscsi_target";
    /**
    * Generates CDKTF code for importing a DiskPoolIscsiTarget resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DiskPoolIscsiTarget to import
    * @param importFromId The id of the existing DiskPoolIscsiTarget that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/disk_pool_iscsi_target#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DiskPoolIscsiTarget to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/disk_pool_iscsi_target azurerm_disk_pool_iscsi_target} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DiskPoolIscsiTargetConfig
    */
    constructor(scope: Construct, id: string, config: DiskPoolIscsiTargetConfig);
    private _aclMode?;
    get aclMode(): string;
    set aclMode(value: string);
    get aclModeInput(): string | undefined;
    private _disksPoolId?;
    get disksPoolId(): string;
    set disksPoolId(value: string);
    get disksPoolIdInput(): string | undefined;
    get endpoints(): string[];
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get port(): number;
    private _targetIqn?;
    get targetIqn(): string;
    set targetIqn(value: string);
    resetTargetIqn(): void;
    get targetIqnInput(): string | undefined;
    private _timeouts;
    get timeouts(): DiskPoolIscsiTargetTimeoutsOutputReference;
    putTimeouts(value: DiskPoolIscsiTargetTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DiskPoolIscsiTargetTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
