/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface HealthcareFhirServiceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/healthcare_fhir_service#access_policy_object_ids HealthcareFhirService#access_policy_object_ids}
    */
    readonly accessPolicyObjectIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/healthcare_fhir_service#configuration_export_storage_account_name HealthcareFhirService#configuration_export_storage_account_name}
    */
    readonly configurationExportStorageAccountName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/healthcare_fhir_service#container_registry_login_server_url HealthcareFhirService#container_registry_login_server_url}
    */
    readonly containerRegistryLoginServerUrl?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/healthcare_fhir_service#id HealthcareFhirService#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/healthcare_fhir_service#kind HealthcareFhirService#kind}
    */
    readonly kind?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/healthcare_fhir_service#location HealthcareFhirService#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/healthcare_fhir_service#name HealthcareFhirService#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/healthcare_fhir_service#resource_group_name HealthcareFhirService#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/healthcare_fhir_service#tags HealthcareFhirService#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/healthcare_fhir_service#workspace_id HealthcareFhirService#workspace_id}
    */
    readonly workspaceId: string;
    /**
    * authentication block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/healthcare_fhir_service#authentication HealthcareFhirService#authentication}
    */
    readonly authentication: HealthcareFhirServiceAuthentication;
    /**
    * cors block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/healthcare_fhir_service#cors HealthcareFhirService#cors}
    */
    readonly cors?: HealthcareFhirServiceCors;
    /**
    * identity block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/healthcare_fhir_service#identity HealthcareFhirService#identity}
    */
    readonly identity?: HealthcareFhirServiceIdentity;
    /**
    * oci_artifact block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/healthcare_fhir_service#oci_artifact HealthcareFhirService#oci_artifact}
    */
    readonly ociArtifact?: HealthcareFhirServiceOciArtifact[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/healthcare_fhir_service#timeouts HealthcareFhirService#timeouts}
    */
    readonly timeouts?: HealthcareFhirServiceTimeouts;
}
export interface HealthcareFhirServiceAuthentication {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/healthcare_fhir_service#audience HealthcareFhirService#audience}
    */
    readonly audience: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/healthcare_fhir_service#authority HealthcareFhirService#authority}
    */
    readonly authority: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/healthcare_fhir_service#smart_proxy_enabled HealthcareFhirService#smart_proxy_enabled}
    */
    readonly smartProxyEnabled?: boolean | cdktf.IResolvable;
}
export declare function healthcareFhirServiceAuthenticationToTerraform(struct?: HealthcareFhirServiceAuthenticationOutputReference | HealthcareFhirServiceAuthentication): any;
export declare class HealthcareFhirServiceAuthenticationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HealthcareFhirServiceAuthentication | undefined;
    set internalValue(value: HealthcareFhirServiceAuthentication | undefined);
    private _audience?;
    get audience(): string;
    set audience(value: string);
    get audienceInput(): string | undefined;
    private _authority?;
    get authority(): string;
    set authority(value: string);
    get authorityInput(): string | undefined;
    private _smartProxyEnabled?;
    get smartProxyEnabled(): boolean | cdktf.IResolvable;
    set smartProxyEnabled(value: boolean | cdktf.IResolvable);
    resetSmartProxyEnabled(): void;
    get smartProxyEnabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface HealthcareFhirServiceCors {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/healthcare_fhir_service#allowed_headers HealthcareFhirService#allowed_headers}
    */
    readonly allowedHeaders: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/healthcare_fhir_service#allowed_methods HealthcareFhirService#allowed_methods}
    */
    readonly allowedMethods: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/healthcare_fhir_service#allowed_origins HealthcareFhirService#allowed_origins}
    */
    readonly allowedOrigins: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/healthcare_fhir_service#credentials_allowed HealthcareFhirService#credentials_allowed}
    */
    readonly credentialsAllowed?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/healthcare_fhir_service#max_age_in_seconds HealthcareFhirService#max_age_in_seconds}
    */
    readonly maxAgeInSeconds?: number;
}
export declare function healthcareFhirServiceCorsToTerraform(struct?: HealthcareFhirServiceCorsOutputReference | HealthcareFhirServiceCors): any;
export declare class HealthcareFhirServiceCorsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HealthcareFhirServiceCors | undefined;
    set internalValue(value: HealthcareFhirServiceCors | undefined);
    private _allowedHeaders?;
    get allowedHeaders(): string[];
    set allowedHeaders(value: string[]);
    get allowedHeadersInput(): string[] | undefined;
    private _allowedMethods?;
    get allowedMethods(): string[];
    set allowedMethods(value: string[]);
    get allowedMethodsInput(): string[] | undefined;
    private _allowedOrigins?;
    get allowedOrigins(): string[];
    set allowedOrigins(value: string[]);
    get allowedOriginsInput(): string[] | undefined;
    private _credentialsAllowed?;
    get credentialsAllowed(): boolean | cdktf.IResolvable;
    set credentialsAllowed(value: boolean | cdktf.IResolvable);
    resetCredentialsAllowed(): void;
    get credentialsAllowedInput(): boolean | cdktf.IResolvable | undefined;
    private _maxAgeInSeconds?;
    get maxAgeInSeconds(): number;
    set maxAgeInSeconds(value: number);
    resetMaxAgeInSeconds(): void;
    get maxAgeInSecondsInput(): number | undefined;
}
export interface HealthcareFhirServiceIdentity {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/healthcare_fhir_service#identity_ids HealthcareFhirService#identity_ids}
    */
    readonly identityIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/healthcare_fhir_service#type HealthcareFhirService#type}
    */
    readonly type: string;
}
export declare function healthcareFhirServiceIdentityToTerraform(struct?: HealthcareFhirServiceIdentityOutputReference | HealthcareFhirServiceIdentity): any;
export declare class HealthcareFhirServiceIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HealthcareFhirServiceIdentity | undefined;
    set internalValue(value: HealthcareFhirServiceIdentity | undefined);
    private _identityIds?;
    get identityIds(): string[];
    set identityIds(value: string[]);
    resetIdentityIds(): void;
    get identityIdsInput(): string[] | undefined;
    get principalId(): string;
    get tenantId(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface HealthcareFhirServiceOciArtifact {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/healthcare_fhir_service#digest HealthcareFhirService#digest}
    */
    readonly digest?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/healthcare_fhir_service#image_name HealthcareFhirService#image_name}
    */
    readonly imageName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/healthcare_fhir_service#login_server HealthcareFhirService#login_server}
    */
    readonly loginServer: string;
}
export declare function healthcareFhirServiceOciArtifactToTerraform(struct?: HealthcareFhirServiceOciArtifact | cdktf.IResolvable): any;
export declare class HealthcareFhirServiceOciArtifactOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): HealthcareFhirServiceOciArtifact | cdktf.IResolvable | undefined;
    set internalValue(value: HealthcareFhirServiceOciArtifact | cdktf.IResolvable | undefined);
    private _digest?;
    get digest(): string;
    set digest(value: string);
    resetDigest(): void;
    get digestInput(): string | undefined;
    private _imageName?;
    get imageName(): string;
    set imageName(value: string);
    resetImageName(): void;
    get imageNameInput(): string | undefined;
    private _loginServer?;
    get loginServer(): string;
    set loginServer(value: string);
    get loginServerInput(): string | undefined;
}
export declare class HealthcareFhirServiceOciArtifactList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: HealthcareFhirServiceOciArtifact[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): HealthcareFhirServiceOciArtifactOutputReference;
}
export interface HealthcareFhirServiceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/healthcare_fhir_service#create HealthcareFhirService#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/healthcare_fhir_service#delete HealthcareFhirService#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/healthcare_fhir_service#read HealthcareFhirService#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/healthcare_fhir_service#update HealthcareFhirService#update}
    */
    readonly update?: string;
}
export declare function healthcareFhirServiceTimeoutsToTerraform(struct?: HealthcareFhirServiceTimeouts | cdktf.IResolvable): any;
export declare class HealthcareFhirServiceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HealthcareFhirServiceTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: HealthcareFhirServiceTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/healthcare_fhir_service azurerm_healthcare_fhir_service}
*/
export declare class HealthcareFhirService extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_healthcare_fhir_service";
    /**
    * Generates CDKTF code for importing a HealthcareFhirService resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the HealthcareFhirService to import
    * @param importFromId The id of the existing HealthcareFhirService that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/healthcare_fhir_service#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the HealthcareFhirService to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/healthcare_fhir_service azurerm_healthcare_fhir_service} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options HealthcareFhirServiceConfig
    */
    constructor(scope: Construct, id: string, config: HealthcareFhirServiceConfig);
    private _accessPolicyObjectIds?;
    get accessPolicyObjectIds(): string[];
    set accessPolicyObjectIds(value: string[]);
    resetAccessPolicyObjectIds(): void;
    get accessPolicyObjectIdsInput(): string[] | undefined;
    private _configurationExportStorageAccountName?;
    get configurationExportStorageAccountName(): string;
    set configurationExportStorageAccountName(value: string);
    resetConfigurationExportStorageAccountName(): void;
    get configurationExportStorageAccountNameInput(): string | undefined;
    private _containerRegistryLoginServerUrl?;
    get containerRegistryLoginServerUrl(): string[];
    set containerRegistryLoginServerUrl(value: string[]);
    resetContainerRegistryLoginServerUrl(): void;
    get containerRegistryLoginServerUrlInput(): string[] | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _kind?;
    get kind(): string;
    set kind(value: string);
    resetKind(): void;
    get kindInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get publicNetworkAccessEnabled(): cdktf.IResolvable;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _workspaceId?;
    get workspaceId(): string;
    set workspaceId(value: string);
    get workspaceIdInput(): string | undefined;
    private _authentication;
    get authentication(): HealthcareFhirServiceAuthenticationOutputReference;
    putAuthentication(value: HealthcareFhirServiceAuthentication): void;
    get authenticationInput(): HealthcareFhirServiceAuthentication | undefined;
    private _cors;
    get cors(): HealthcareFhirServiceCorsOutputReference;
    putCors(value: HealthcareFhirServiceCors): void;
    resetCors(): void;
    get corsInput(): HealthcareFhirServiceCors | undefined;
    private _identity;
    get identity(): HealthcareFhirServiceIdentityOutputReference;
    putIdentity(value: HealthcareFhirServiceIdentity): void;
    resetIdentity(): void;
    get identityInput(): HealthcareFhirServiceIdentity | undefined;
    private _ociArtifact;
    get ociArtifact(): HealthcareFhirServiceOciArtifactList;
    putOciArtifact(value: HealthcareFhirServiceOciArtifact[] | cdktf.IResolvable): void;
    resetOciArtifact(): void;
    get ociArtifactInput(): cdktf.IResolvable | HealthcareFhirServiceOciArtifact[] | undefined;
    private _timeouts;
    get timeouts(): HealthcareFhirServiceTimeoutsOutputReference;
    putTimeouts(value: HealthcareFhirServiceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | HealthcareFhirServiceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
