/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MonitorAadDiagnosticSettingConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/monitor_aad_diagnostic_setting#eventhub_authorization_rule_id MonitorAadDiagnosticSetting#eventhub_authorization_rule_id}
    */
    readonly eventhubAuthorizationRuleId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/monitor_aad_diagnostic_setting#eventhub_name MonitorAadDiagnosticSetting#eventhub_name}
    */
    readonly eventhubName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/monitor_aad_diagnostic_setting#id MonitorAadDiagnosticSetting#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/monitor_aad_diagnostic_setting#log_analytics_workspace_id MonitorAadDiagnosticSetting#log_analytics_workspace_id}
    */
    readonly logAnalyticsWorkspaceId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/monitor_aad_diagnostic_setting#name MonitorAadDiagnosticSetting#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/monitor_aad_diagnostic_setting#storage_account_id MonitorAadDiagnosticSetting#storage_account_id}
    */
    readonly storageAccountId?: string;
    /**
    * enabled_log block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/monitor_aad_diagnostic_setting#enabled_log MonitorAadDiagnosticSetting#enabled_log}
    */
    readonly enabledLog?: MonitorAadDiagnosticSettingEnabledLog[] | cdktf.IResolvable;
    /**
    * log block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/monitor_aad_diagnostic_setting#log MonitorAadDiagnosticSetting#log}
    */
    readonly log?: MonitorAadDiagnosticSettingLog[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/monitor_aad_diagnostic_setting#timeouts MonitorAadDiagnosticSetting#timeouts}
    */
    readonly timeouts?: MonitorAadDiagnosticSettingTimeouts;
}
export interface MonitorAadDiagnosticSettingEnabledLogRetentionPolicy {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/monitor_aad_diagnostic_setting#days MonitorAadDiagnosticSetting#days}
    */
    readonly days?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/monitor_aad_diagnostic_setting#enabled MonitorAadDiagnosticSetting#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
}
export declare function monitorAadDiagnosticSettingEnabledLogRetentionPolicyToTerraform(struct?: MonitorAadDiagnosticSettingEnabledLogRetentionPolicyOutputReference | MonitorAadDiagnosticSettingEnabledLogRetentionPolicy): any;
export declare class MonitorAadDiagnosticSettingEnabledLogRetentionPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitorAadDiagnosticSettingEnabledLogRetentionPolicy | undefined;
    set internalValue(value: MonitorAadDiagnosticSettingEnabledLogRetentionPolicy | undefined);
    private _days?;
    get days(): number;
    set days(value: number);
    resetDays(): void;
    get daysInput(): number | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface MonitorAadDiagnosticSettingEnabledLog {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/monitor_aad_diagnostic_setting#category MonitorAadDiagnosticSetting#category}
    */
    readonly category: string;
    /**
    * retention_policy block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/monitor_aad_diagnostic_setting#retention_policy MonitorAadDiagnosticSetting#retention_policy}
    */
    readonly retentionPolicy: MonitorAadDiagnosticSettingEnabledLogRetentionPolicy;
}
export declare function monitorAadDiagnosticSettingEnabledLogToTerraform(struct?: MonitorAadDiagnosticSettingEnabledLog | cdktf.IResolvable): any;
export declare class MonitorAadDiagnosticSettingEnabledLogOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MonitorAadDiagnosticSettingEnabledLog | cdktf.IResolvable | undefined;
    set internalValue(value: MonitorAadDiagnosticSettingEnabledLog | cdktf.IResolvable | undefined);
    private _category?;
    get category(): string;
    set category(value: string);
    get categoryInput(): string | undefined;
    private _retentionPolicy;
    get retentionPolicy(): MonitorAadDiagnosticSettingEnabledLogRetentionPolicyOutputReference;
    putRetentionPolicy(value: MonitorAadDiagnosticSettingEnabledLogRetentionPolicy): void;
    get retentionPolicyInput(): MonitorAadDiagnosticSettingEnabledLogRetentionPolicy | undefined;
}
export declare class MonitorAadDiagnosticSettingEnabledLogList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MonitorAadDiagnosticSettingEnabledLog[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MonitorAadDiagnosticSettingEnabledLogOutputReference;
}
export interface MonitorAadDiagnosticSettingLogRetentionPolicy {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/monitor_aad_diagnostic_setting#days MonitorAadDiagnosticSetting#days}
    */
    readonly days?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/monitor_aad_diagnostic_setting#enabled MonitorAadDiagnosticSetting#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
}
export declare function monitorAadDiagnosticSettingLogRetentionPolicyToTerraform(struct?: MonitorAadDiagnosticSettingLogRetentionPolicyOutputReference | MonitorAadDiagnosticSettingLogRetentionPolicy): any;
export declare class MonitorAadDiagnosticSettingLogRetentionPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitorAadDiagnosticSettingLogRetentionPolicy | undefined;
    set internalValue(value: MonitorAadDiagnosticSettingLogRetentionPolicy | undefined);
    private _days?;
    get days(): number;
    set days(value: number);
    resetDays(): void;
    get daysInput(): number | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface MonitorAadDiagnosticSettingLog {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/monitor_aad_diagnostic_setting#category MonitorAadDiagnosticSetting#category}
    */
    readonly category: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/monitor_aad_diagnostic_setting#enabled MonitorAadDiagnosticSetting#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * retention_policy block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/monitor_aad_diagnostic_setting#retention_policy MonitorAadDiagnosticSetting#retention_policy}
    */
    readonly retentionPolicy: MonitorAadDiagnosticSettingLogRetentionPolicy;
}
export declare function monitorAadDiagnosticSettingLogToTerraform(struct?: MonitorAadDiagnosticSettingLog | cdktf.IResolvable): any;
export declare class MonitorAadDiagnosticSettingLogOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MonitorAadDiagnosticSettingLog | cdktf.IResolvable | undefined;
    set internalValue(value: MonitorAadDiagnosticSettingLog | cdktf.IResolvable | undefined);
    private _category?;
    get category(): string;
    set category(value: string);
    get categoryInput(): string | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _retentionPolicy;
    get retentionPolicy(): MonitorAadDiagnosticSettingLogRetentionPolicyOutputReference;
    putRetentionPolicy(value: MonitorAadDiagnosticSettingLogRetentionPolicy): void;
    get retentionPolicyInput(): MonitorAadDiagnosticSettingLogRetentionPolicy | undefined;
}
export declare class MonitorAadDiagnosticSettingLogList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MonitorAadDiagnosticSettingLog[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MonitorAadDiagnosticSettingLogOutputReference;
}
export interface MonitorAadDiagnosticSettingTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/monitor_aad_diagnostic_setting#create MonitorAadDiagnosticSetting#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/monitor_aad_diagnostic_setting#delete MonitorAadDiagnosticSetting#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/monitor_aad_diagnostic_setting#read MonitorAadDiagnosticSetting#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/monitor_aad_diagnostic_setting#update MonitorAadDiagnosticSetting#update}
    */
    readonly update?: string;
}
export declare function monitorAadDiagnosticSettingTimeoutsToTerraform(struct?: MonitorAadDiagnosticSettingTimeouts | cdktf.IResolvable): any;
export declare class MonitorAadDiagnosticSettingTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitorAadDiagnosticSettingTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: MonitorAadDiagnosticSettingTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/monitor_aad_diagnostic_setting azurerm_monitor_aad_diagnostic_setting}
*/
export declare class MonitorAadDiagnosticSetting extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_monitor_aad_diagnostic_setting";
    /**
    * Generates CDKTF code for importing a MonitorAadDiagnosticSetting resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the MonitorAadDiagnosticSetting to import
    * @param importFromId The id of the existing MonitorAadDiagnosticSetting that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/monitor_aad_diagnostic_setting#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the MonitorAadDiagnosticSetting to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/monitor_aad_diagnostic_setting azurerm_monitor_aad_diagnostic_setting} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MonitorAadDiagnosticSettingConfig
    */
    constructor(scope: Construct, id: string, config: MonitorAadDiagnosticSettingConfig);
    private _eventhubAuthorizationRuleId?;
    get eventhubAuthorizationRuleId(): string;
    set eventhubAuthorizationRuleId(value: string);
    resetEventhubAuthorizationRuleId(): void;
    get eventhubAuthorizationRuleIdInput(): string | undefined;
    private _eventhubName?;
    get eventhubName(): string;
    set eventhubName(value: string);
    resetEventhubName(): void;
    get eventhubNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _logAnalyticsWorkspaceId?;
    get logAnalyticsWorkspaceId(): string;
    set logAnalyticsWorkspaceId(value: string);
    resetLogAnalyticsWorkspaceId(): void;
    get logAnalyticsWorkspaceIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _storageAccountId?;
    get storageAccountId(): string;
    set storageAccountId(value: string);
    resetStorageAccountId(): void;
    get storageAccountIdInput(): string | undefined;
    private _enabledLog;
    get enabledLog(): MonitorAadDiagnosticSettingEnabledLogList;
    putEnabledLog(value: MonitorAadDiagnosticSettingEnabledLog[] | cdktf.IResolvable): void;
    resetEnabledLog(): void;
    get enabledLogInput(): cdktf.IResolvable | MonitorAadDiagnosticSettingEnabledLog[] | undefined;
    private _log;
    get log(): MonitorAadDiagnosticSettingLogList;
    putLog(value: MonitorAadDiagnosticSettingLog[] | cdktf.IResolvable): void;
    resetLog(): void;
    get logInput(): cdktf.IResolvable | MonitorAadDiagnosticSettingLog[] | undefined;
    private _timeouts;
    get timeouts(): MonitorAadDiagnosticSettingTimeoutsOutputReference;
    putTimeouts(value: MonitorAadDiagnosticSettingTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | MonitorAadDiagnosticSettingTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
