/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MssqlDatabaseConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/mssql_database#auto_pause_delay_in_minutes MssqlDatabase#auto_pause_delay_in_minutes}
    */
    readonly autoPauseDelayInMinutes?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/mssql_database#collation MssqlDatabase#collation}
    */
    readonly collation?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/mssql_database#create_mode MssqlDatabase#create_mode}
    */
    readonly createMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/mssql_database#creation_source_database_id MssqlDatabase#creation_source_database_id}
    */
    readonly creationSourceDatabaseId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/mssql_database#elastic_pool_id MssqlDatabase#elastic_pool_id}
    */
    readonly elasticPoolId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/mssql_database#geo_backup_enabled MssqlDatabase#geo_backup_enabled}
    */
    readonly geoBackupEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/mssql_database#id MssqlDatabase#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/mssql_database#ledger_enabled MssqlDatabase#ledger_enabled}
    */
    readonly ledgerEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/mssql_database#license_type MssqlDatabase#license_type}
    */
    readonly licenseType?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/mssql_database#maintenance_configuration_name MssqlDatabase#maintenance_configuration_name}
    */
    readonly maintenanceConfigurationName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/mssql_database#max_size_gb MssqlDatabase#max_size_gb}
    */
    readonly maxSizeGb?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/mssql_database#min_capacity MssqlDatabase#min_capacity}
    */
    readonly minCapacity?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/mssql_database#name MssqlDatabase#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/mssql_database#read_replica_count MssqlDatabase#read_replica_count}
    */
    readonly readReplicaCount?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/mssql_database#read_scale MssqlDatabase#read_scale}
    */
    readonly readScale?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/mssql_database#recover_database_id MssqlDatabase#recover_database_id}
    */
    readonly recoverDatabaseId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/mssql_database#restore_dropped_database_id MssqlDatabase#restore_dropped_database_id}
    */
    readonly restoreDroppedDatabaseId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/mssql_database#restore_point_in_time MssqlDatabase#restore_point_in_time}
    */
    readonly restorePointInTime?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/mssql_database#sample_name MssqlDatabase#sample_name}
    */
    readonly sampleName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/mssql_database#server_id MssqlDatabase#server_id}
    */
    readonly serverId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/mssql_database#sku_name MssqlDatabase#sku_name}
    */
    readonly skuName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/mssql_database#storage_account_type MssqlDatabase#storage_account_type}
    */
    readonly storageAccountType?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/mssql_database#tags MssqlDatabase#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/mssql_database#transparent_data_encryption_enabled MssqlDatabase#transparent_data_encryption_enabled}
    */
    readonly transparentDataEncryptionEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/mssql_database#zone_redundant MssqlDatabase#zone_redundant}
    */
    readonly zoneRedundant?: boolean | cdktf.IResolvable;
    /**
    * import block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/mssql_database#import MssqlDatabase#import}
    */
    readonly import?: MssqlDatabaseImport;
    /**
    * long_term_retention_policy block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/mssql_database#long_term_retention_policy MssqlDatabase#long_term_retention_policy}
    */
    readonly longTermRetentionPolicy?: MssqlDatabaseLongTermRetentionPolicy;
    /**
    * short_term_retention_policy block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/mssql_database#short_term_retention_policy MssqlDatabase#short_term_retention_policy}
    */
    readonly shortTermRetentionPolicy?: MssqlDatabaseShortTermRetentionPolicy;
    /**
    * threat_detection_policy block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/mssql_database#threat_detection_policy MssqlDatabase#threat_detection_policy}
    */
    readonly threatDetectionPolicy?: MssqlDatabaseThreatDetectionPolicy;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/mssql_database#timeouts MssqlDatabase#timeouts}
    */
    readonly timeouts?: MssqlDatabaseTimeouts;
}
export interface MssqlDatabaseImport {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/mssql_database#administrator_login MssqlDatabase#administrator_login}
    */
    readonly administratorLogin: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/mssql_database#administrator_login_password MssqlDatabase#administrator_login_password}
    */
    readonly administratorLoginPassword: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/mssql_database#authentication_type MssqlDatabase#authentication_type}
    */
    readonly authenticationType: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/mssql_database#storage_account_id MssqlDatabase#storage_account_id}
    */
    readonly storageAccountId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/mssql_database#storage_key MssqlDatabase#storage_key}
    */
    readonly storageKey: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/mssql_database#storage_key_type MssqlDatabase#storage_key_type}
    */
    readonly storageKeyType: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/mssql_database#storage_uri MssqlDatabase#storage_uri}
    */
    readonly storageUri: string;
}
export declare function mssqlDatabaseImportToTerraform(struct?: MssqlDatabaseImportOutputReference | MssqlDatabaseImport): any;
export declare class MssqlDatabaseImportOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MssqlDatabaseImport | undefined;
    set internalValue(value: MssqlDatabaseImport | undefined);
    private _administratorLogin?;
    get administratorLogin(): string;
    set administratorLogin(value: string);
    get administratorLoginInput(): string | undefined;
    private _administratorLoginPassword?;
    get administratorLoginPassword(): string;
    set administratorLoginPassword(value: string);
    get administratorLoginPasswordInput(): string | undefined;
    private _authenticationType?;
    get authenticationType(): string;
    set authenticationType(value: string);
    get authenticationTypeInput(): string | undefined;
    private _storageAccountId?;
    get storageAccountId(): string;
    set storageAccountId(value: string);
    resetStorageAccountId(): void;
    get storageAccountIdInput(): string | undefined;
    private _storageKey?;
    get storageKey(): string;
    set storageKey(value: string);
    get storageKeyInput(): string | undefined;
    private _storageKeyType?;
    get storageKeyType(): string;
    set storageKeyType(value: string);
    get storageKeyTypeInput(): string | undefined;
    private _storageUri?;
    get storageUri(): string;
    set storageUri(value: string);
    get storageUriInput(): string | undefined;
}
export interface MssqlDatabaseLongTermRetentionPolicy {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/mssql_database#monthly_retention MssqlDatabase#monthly_retention}
    */
    readonly monthlyRetention?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/mssql_database#week_of_year MssqlDatabase#week_of_year}
    */
    readonly weekOfYear?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/mssql_database#weekly_retention MssqlDatabase#weekly_retention}
    */
    readonly weeklyRetention?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/mssql_database#yearly_retention MssqlDatabase#yearly_retention}
    */
    readonly yearlyRetention?: string;
}
export declare function mssqlDatabaseLongTermRetentionPolicyToTerraform(struct?: MssqlDatabaseLongTermRetentionPolicyOutputReference | MssqlDatabaseLongTermRetentionPolicy): any;
export declare class MssqlDatabaseLongTermRetentionPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MssqlDatabaseLongTermRetentionPolicy | undefined;
    set internalValue(value: MssqlDatabaseLongTermRetentionPolicy | undefined);
    private _monthlyRetention?;
    get monthlyRetention(): string;
    set monthlyRetention(value: string);
    resetMonthlyRetention(): void;
    get monthlyRetentionInput(): string | undefined;
    private _weekOfYear?;
    get weekOfYear(): number;
    set weekOfYear(value: number);
    resetWeekOfYear(): void;
    get weekOfYearInput(): number | undefined;
    private _weeklyRetention?;
    get weeklyRetention(): string;
    set weeklyRetention(value: string);
    resetWeeklyRetention(): void;
    get weeklyRetentionInput(): string | undefined;
    private _yearlyRetention?;
    get yearlyRetention(): string;
    set yearlyRetention(value: string);
    resetYearlyRetention(): void;
    get yearlyRetentionInput(): string | undefined;
}
export interface MssqlDatabaseShortTermRetentionPolicy {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/mssql_database#backup_interval_in_hours MssqlDatabase#backup_interval_in_hours}
    */
    readonly backupIntervalInHours?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/mssql_database#retention_days MssqlDatabase#retention_days}
    */
    readonly retentionDays: number;
}
export declare function mssqlDatabaseShortTermRetentionPolicyToTerraform(struct?: MssqlDatabaseShortTermRetentionPolicyOutputReference | MssqlDatabaseShortTermRetentionPolicy): any;
export declare class MssqlDatabaseShortTermRetentionPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MssqlDatabaseShortTermRetentionPolicy | undefined;
    set internalValue(value: MssqlDatabaseShortTermRetentionPolicy | undefined);
    private _backupIntervalInHours?;
    get backupIntervalInHours(): number;
    set backupIntervalInHours(value: number);
    resetBackupIntervalInHours(): void;
    get backupIntervalInHoursInput(): number | undefined;
    private _retentionDays?;
    get retentionDays(): number;
    set retentionDays(value: number);
    get retentionDaysInput(): number | undefined;
}
export interface MssqlDatabaseThreatDetectionPolicy {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/mssql_database#disabled_alerts MssqlDatabase#disabled_alerts}
    */
    readonly disabledAlerts?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/mssql_database#email_account_admins MssqlDatabase#email_account_admins}
    */
    readonly emailAccountAdmins?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/mssql_database#email_addresses MssqlDatabase#email_addresses}
    */
    readonly emailAddresses?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/mssql_database#retention_days MssqlDatabase#retention_days}
    */
    readonly retentionDays?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/mssql_database#state MssqlDatabase#state}
    */
    readonly state?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/mssql_database#storage_account_access_key MssqlDatabase#storage_account_access_key}
    */
    readonly storageAccountAccessKey?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/mssql_database#storage_endpoint MssqlDatabase#storage_endpoint}
    */
    readonly storageEndpoint?: string;
}
export declare function mssqlDatabaseThreatDetectionPolicyToTerraform(struct?: MssqlDatabaseThreatDetectionPolicyOutputReference | MssqlDatabaseThreatDetectionPolicy): any;
export declare class MssqlDatabaseThreatDetectionPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MssqlDatabaseThreatDetectionPolicy | undefined;
    set internalValue(value: MssqlDatabaseThreatDetectionPolicy | undefined);
    private _disabledAlerts?;
    get disabledAlerts(): string[];
    set disabledAlerts(value: string[]);
    resetDisabledAlerts(): void;
    get disabledAlertsInput(): string[] | undefined;
    private _emailAccountAdmins?;
    get emailAccountAdmins(): string;
    set emailAccountAdmins(value: string);
    resetEmailAccountAdmins(): void;
    get emailAccountAdminsInput(): string | undefined;
    private _emailAddresses?;
    get emailAddresses(): string[];
    set emailAddresses(value: string[]);
    resetEmailAddresses(): void;
    get emailAddressesInput(): string[] | undefined;
    private _retentionDays?;
    get retentionDays(): number;
    set retentionDays(value: number);
    resetRetentionDays(): void;
    get retentionDaysInput(): number | undefined;
    private _state?;
    get state(): string;
    set state(value: string);
    resetState(): void;
    get stateInput(): string | undefined;
    private _storageAccountAccessKey?;
    get storageAccountAccessKey(): string;
    set storageAccountAccessKey(value: string);
    resetStorageAccountAccessKey(): void;
    get storageAccountAccessKeyInput(): string | undefined;
    private _storageEndpoint?;
    get storageEndpoint(): string;
    set storageEndpoint(value: string);
    resetStorageEndpoint(): void;
    get storageEndpointInput(): string | undefined;
}
export interface MssqlDatabaseTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/mssql_database#create MssqlDatabase#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/mssql_database#delete MssqlDatabase#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/mssql_database#read MssqlDatabase#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/mssql_database#update MssqlDatabase#update}
    */
    readonly update?: string;
}
export declare function mssqlDatabaseTimeoutsToTerraform(struct?: MssqlDatabaseTimeouts | cdktf.IResolvable): any;
export declare class MssqlDatabaseTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MssqlDatabaseTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: MssqlDatabaseTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/mssql_database azurerm_mssql_database}
*/
export declare class MssqlDatabase extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_mssql_database";
    /**
    * Generates CDKTF code for importing a MssqlDatabase resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the MssqlDatabase to import
    * @param importFromId The id of the existing MssqlDatabase that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/mssql_database#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the MssqlDatabase to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/mssql_database azurerm_mssql_database} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MssqlDatabaseConfig
    */
    constructor(scope: Construct, id: string, config: MssqlDatabaseConfig);
    private _autoPauseDelayInMinutes?;
    get autoPauseDelayInMinutes(): number;
    set autoPauseDelayInMinutes(value: number);
    resetAutoPauseDelayInMinutes(): void;
    get autoPauseDelayInMinutesInput(): number | undefined;
    private _collation?;
    get collation(): string;
    set collation(value: string);
    resetCollation(): void;
    get collationInput(): string | undefined;
    private _createMode?;
    get createMode(): string;
    set createMode(value: string);
    resetCreateMode(): void;
    get createModeInput(): string | undefined;
    private _creationSourceDatabaseId?;
    get creationSourceDatabaseId(): string;
    set creationSourceDatabaseId(value: string);
    resetCreationSourceDatabaseId(): void;
    get creationSourceDatabaseIdInput(): string | undefined;
    private _elasticPoolId?;
    get elasticPoolId(): string;
    set elasticPoolId(value: string);
    resetElasticPoolId(): void;
    get elasticPoolIdInput(): string | undefined;
    private _geoBackupEnabled?;
    get geoBackupEnabled(): boolean | cdktf.IResolvable;
    set geoBackupEnabled(value: boolean | cdktf.IResolvable);
    resetGeoBackupEnabled(): void;
    get geoBackupEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _ledgerEnabled?;
    get ledgerEnabled(): boolean | cdktf.IResolvable;
    set ledgerEnabled(value: boolean | cdktf.IResolvable);
    resetLedgerEnabled(): void;
    get ledgerEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _licenseType?;
    get licenseType(): string;
    set licenseType(value: string);
    resetLicenseType(): void;
    get licenseTypeInput(): string | undefined;
    private _maintenanceConfigurationName?;
    get maintenanceConfigurationName(): string;
    set maintenanceConfigurationName(value: string);
    resetMaintenanceConfigurationName(): void;
    get maintenanceConfigurationNameInput(): string | undefined;
    private _maxSizeGb?;
    get maxSizeGb(): number;
    set maxSizeGb(value: number);
    resetMaxSizeGb(): void;
    get maxSizeGbInput(): number | undefined;
    private _minCapacity?;
    get minCapacity(): number;
    set minCapacity(value: number);
    resetMinCapacity(): void;
    get minCapacityInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _readReplicaCount?;
    get readReplicaCount(): number;
    set readReplicaCount(value: number);
    resetReadReplicaCount(): void;
    get readReplicaCountInput(): number | undefined;
    private _readScale?;
    get readScale(): boolean | cdktf.IResolvable;
    set readScale(value: boolean | cdktf.IResolvable);
    resetReadScale(): void;
    get readScaleInput(): boolean | cdktf.IResolvable | undefined;
    private _recoverDatabaseId?;
    get recoverDatabaseId(): string;
    set recoverDatabaseId(value: string);
    resetRecoverDatabaseId(): void;
    get recoverDatabaseIdInput(): string | undefined;
    private _restoreDroppedDatabaseId?;
    get restoreDroppedDatabaseId(): string;
    set restoreDroppedDatabaseId(value: string);
    resetRestoreDroppedDatabaseId(): void;
    get restoreDroppedDatabaseIdInput(): string | undefined;
    private _restorePointInTime?;
    get restorePointInTime(): string;
    set restorePointInTime(value: string);
    resetRestorePointInTime(): void;
    get restorePointInTimeInput(): string | undefined;
    private _sampleName?;
    get sampleName(): string;
    set sampleName(value: string);
    resetSampleName(): void;
    get sampleNameInput(): string | undefined;
    private _serverId?;
    get serverId(): string;
    set serverId(value: string);
    get serverIdInput(): string | undefined;
    private _skuName?;
    get skuName(): string;
    set skuName(value: string);
    resetSkuName(): void;
    get skuNameInput(): string | undefined;
    private _storageAccountType?;
    get storageAccountType(): string;
    set storageAccountType(value: string);
    resetStorageAccountType(): void;
    get storageAccountTypeInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _transparentDataEncryptionEnabled?;
    get transparentDataEncryptionEnabled(): boolean | cdktf.IResolvable;
    set transparentDataEncryptionEnabled(value: boolean | cdktf.IResolvable);
    resetTransparentDataEncryptionEnabled(): void;
    get transparentDataEncryptionEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _zoneRedundant?;
    get zoneRedundant(): boolean | cdktf.IResolvable;
    set zoneRedundant(value: boolean | cdktf.IResolvable);
    resetZoneRedundant(): void;
    get zoneRedundantInput(): boolean | cdktf.IResolvable | undefined;
    private _import;
    get import(): MssqlDatabaseImportOutputReference;
    putImport(value: MssqlDatabaseImport): void;
    resetImport(): void;
    get importInput(): MssqlDatabaseImport | undefined;
    private _longTermRetentionPolicy;
    get longTermRetentionPolicy(): MssqlDatabaseLongTermRetentionPolicyOutputReference;
    putLongTermRetentionPolicy(value: MssqlDatabaseLongTermRetentionPolicy): void;
    resetLongTermRetentionPolicy(): void;
    get longTermRetentionPolicyInput(): MssqlDatabaseLongTermRetentionPolicy | undefined;
    private _shortTermRetentionPolicy;
    get shortTermRetentionPolicy(): MssqlDatabaseShortTermRetentionPolicyOutputReference;
    putShortTermRetentionPolicy(value: MssqlDatabaseShortTermRetentionPolicy): void;
    resetShortTermRetentionPolicy(): void;
    get shortTermRetentionPolicyInput(): MssqlDatabaseShortTermRetentionPolicy | undefined;
    private _threatDetectionPolicy;
    get threatDetectionPolicy(): MssqlDatabaseThreatDetectionPolicyOutputReference;
    putThreatDetectionPolicy(value: MssqlDatabaseThreatDetectionPolicy): void;
    resetThreatDetectionPolicy(): void;
    get threatDetectionPolicyInput(): MssqlDatabaseThreatDetectionPolicy | undefined;
    private _timeouts;
    get timeouts(): MssqlDatabaseTimeoutsOutputReference;
    putTimeouts(value: MssqlDatabaseTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | MssqlDatabaseTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
