/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MysqlServerConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/mysql_server#administrator_login MysqlServer#administrator_login}
    */
    readonly administratorLogin?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/mysql_server#administrator_login_password MysqlServer#administrator_login_password}
    */
    readonly administratorLoginPassword?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/mysql_server#auto_grow_enabled MysqlServer#auto_grow_enabled}
    */
    readonly autoGrowEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/mysql_server#backup_retention_days MysqlServer#backup_retention_days}
    */
    readonly backupRetentionDays?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/mysql_server#create_mode MysqlServer#create_mode}
    */
    readonly createMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/mysql_server#creation_source_server_id MysqlServer#creation_source_server_id}
    */
    readonly creationSourceServerId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/mysql_server#geo_redundant_backup_enabled MysqlServer#geo_redundant_backup_enabled}
    */
    readonly geoRedundantBackupEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/mysql_server#id MysqlServer#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/mysql_server#infrastructure_encryption_enabled MysqlServer#infrastructure_encryption_enabled}
    */
    readonly infrastructureEncryptionEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/mysql_server#location MysqlServer#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/mysql_server#name MysqlServer#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/mysql_server#public_network_access_enabled MysqlServer#public_network_access_enabled}
    */
    readonly publicNetworkAccessEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/mysql_server#resource_group_name MysqlServer#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/mysql_server#restore_point_in_time MysqlServer#restore_point_in_time}
    */
    readonly restorePointInTime?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/mysql_server#sku_name MysqlServer#sku_name}
    */
    readonly skuName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/mysql_server#ssl_enforcement_enabled MysqlServer#ssl_enforcement_enabled}
    */
    readonly sslEnforcementEnabled: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/mysql_server#ssl_minimal_tls_version_enforced MysqlServer#ssl_minimal_tls_version_enforced}
    */
    readonly sslMinimalTlsVersionEnforced?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/mysql_server#storage_mb MysqlServer#storage_mb}
    */
    readonly storageMb?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/mysql_server#tags MysqlServer#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/mysql_server#version MysqlServer#version}
    */
    readonly version: string;
    /**
    * identity block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/mysql_server#identity MysqlServer#identity}
    */
    readonly identity?: MysqlServerIdentity;
    /**
    * threat_detection_policy block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/mysql_server#threat_detection_policy MysqlServer#threat_detection_policy}
    */
    readonly threatDetectionPolicy?: MysqlServerThreatDetectionPolicy;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/mysql_server#timeouts MysqlServer#timeouts}
    */
    readonly timeouts?: MysqlServerTimeouts;
}
export interface MysqlServerIdentity {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/mysql_server#type MysqlServer#type}
    */
    readonly type: string;
}
export declare function mysqlServerIdentityToTerraform(struct?: MysqlServerIdentityOutputReference | MysqlServerIdentity): any;
export declare class MysqlServerIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MysqlServerIdentity | undefined;
    set internalValue(value: MysqlServerIdentity | undefined);
    get principalId(): string;
    get tenantId(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface MysqlServerThreatDetectionPolicy {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/mysql_server#disabled_alerts MysqlServer#disabled_alerts}
    */
    readonly disabledAlerts?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/mysql_server#email_account_admins MysqlServer#email_account_admins}
    */
    readonly emailAccountAdmins?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/mysql_server#email_addresses MysqlServer#email_addresses}
    */
    readonly emailAddresses?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/mysql_server#enabled MysqlServer#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/mysql_server#retention_days MysqlServer#retention_days}
    */
    readonly retentionDays?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/mysql_server#storage_account_access_key MysqlServer#storage_account_access_key}
    */
    readonly storageAccountAccessKey?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/mysql_server#storage_endpoint MysqlServer#storage_endpoint}
    */
    readonly storageEndpoint?: string;
}
export declare function mysqlServerThreatDetectionPolicyToTerraform(struct?: MysqlServerThreatDetectionPolicyOutputReference | MysqlServerThreatDetectionPolicy): any;
export declare class MysqlServerThreatDetectionPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MysqlServerThreatDetectionPolicy | undefined;
    set internalValue(value: MysqlServerThreatDetectionPolicy | undefined);
    private _disabledAlerts?;
    get disabledAlerts(): string[];
    set disabledAlerts(value: string[]);
    resetDisabledAlerts(): void;
    get disabledAlertsInput(): string[] | undefined;
    private _emailAccountAdmins?;
    get emailAccountAdmins(): boolean | cdktf.IResolvable;
    set emailAccountAdmins(value: boolean | cdktf.IResolvable);
    resetEmailAccountAdmins(): void;
    get emailAccountAdminsInput(): boolean | cdktf.IResolvable | undefined;
    private _emailAddresses?;
    get emailAddresses(): string[];
    set emailAddresses(value: string[]);
    resetEmailAddresses(): void;
    get emailAddressesInput(): string[] | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _retentionDays?;
    get retentionDays(): number;
    set retentionDays(value: number);
    resetRetentionDays(): void;
    get retentionDaysInput(): number | undefined;
    private _storageAccountAccessKey?;
    get storageAccountAccessKey(): string;
    set storageAccountAccessKey(value: string);
    resetStorageAccountAccessKey(): void;
    get storageAccountAccessKeyInput(): string | undefined;
    private _storageEndpoint?;
    get storageEndpoint(): string;
    set storageEndpoint(value: string);
    resetStorageEndpoint(): void;
    get storageEndpointInput(): string | undefined;
}
export interface MysqlServerTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/mysql_server#create MysqlServer#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/mysql_server#delete MysqlServer#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/mysql_server#read MysqlServer#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/mysql_server#update MysqlServer#update}
    */
    readonly update?: string;
}
export declare function mysqlServerTimeoutsToTerraform(struct?: MysqlServerTimeouts | cdktf.IResolvable): any;
export declare class MysqlServerTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MysqlServerTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: MysqlServerTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/mysql_server azurerm_mysql_server}
*/
export declare class MysqlServer extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_mysql_server";
    /**
    * Generates CDKTF code for importing a MysqlServer resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the MysqlServer to import
    * @param importFromId The id of the existing MysqlServer that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/mysql_server#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the MysqlServer to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/mysql_server azurerm_mysql_server} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MysqlServerConfig
    */
    constructor(scope: Construct, id: string, config: MysqlServerConfig);
    private _administratorLogin?;
    get administratorLogin(): string;
    set administratorLogin(value: string);
    resetAdministratorLogin(): void;
    get administratorLoginInput(): string | undefined;
    private _administratorLoginPassword?;
    get administratorLoginPassword(): string;
    set administratorLoginPassword(value: string);
    resetAdministratorLoginPassword(): void;
    get administratorLoginPasswordInput(): string | undefined;
    private _autoGrowEnabled?;
    get autoGrowEnabled(): boolean | cdktf.IResolvable;
    set autoGrowEnabled(value: boolean | cdktf.IResolvable);
    resetAutoGrowEnabled(): void;
    get autoGrowEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _backupRetentionDays?;
    get backupRetentionDays(): number;
    set backupRetentionDays(value: number);
    resetBackupRetentionDays(): void;
    get backupRetentionDaysInput(): number | undefined;
    private _createMode?;
    get createMode(): string;
    set createMode(value: string);
    resetCreateMode(): void;
    get createModeInput(): string | undefined;
    private _creationSourceServerId?;
    get creationSourceServerId(): string;
    set creationSourceServerId(value: string);
    resetCreationSourceServerId(): void;
    get creationSourceServerIdInput(): string | undefined;
    get fqdn(): string;
    private _geoRedundantBackupEnabled?;
    get geoRedundantBackupEnabled(): boolean | cdktf.IResolvable;
    set geoRedundantBackupEnabled(value: boolean | cdktf.IResolvable);
    resetGeoRedundantBackupEnabled(): void;
    get geoRedundantBackupEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _infrastructureEncryptionEnabled?;
    get infrastructureEncryptionEnabled(): boolean | cdktf.IResolvable;
    set infrastructureEncryptionEnabled(value: boolean | cdktf.IResolvable);
    resetInfrastructureEncryptionEnabled(): void;
    get infrastructureEncryptionEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _publicNetworkAccessEnabled?;
    get publicNetworkAccessEnabled(): boolean | cdktf.IResolvable;
    set publicNetworkAccessEnabled(value: boolean | cdktf.IResolvable);
    resetPublicNetworkAccessEnabled(): void;
    get publicNetworkAccessEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _restorePointInTime?;
    get restorePointInTime(): string;
    set restorePointInTime(value: string);
    resetRestorePointInTime(): void;
    get restorePointInTimeInput(): string | undefined;
    private _skuName?;
    get skuName(): string;
    set skuName(value: string);
    get skuNameInput(): string | undefined;
    private _sslEnforcementEnabled?;
    get sslEnforcementEnabled(): boolean | cdktf.IResolvable;
    set sslEnforcementEnabled(value: boolean | cdktf.IResolvable);
    get sslEnforcementEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _sslMinimalTlsVersionEnforced?;
    get sslMinimalTlsVersionEnforced(): string;
    set sslMinimalTlsVersionEnforced(value: string);
    resetSslMinimalTlsVersionEnforced(): void;
    get sslMinimalTlsVersionEnforcedInput(): string | undefined;
    private _storageMb?;
    get storageMb(): number;
    set storageMb(value: number);
    resetStorageMb(): void;
    get storageMbInput(): number | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _version?;
    get version(): string;
    set version(value: string);
    get versionInput(): string | undefined;
    private _identity;
    get identity(): MysqlServerIdentityOutputReference;
    putIdentity(value: MysqlServerIdentity): void;
    resetIdentity(): void;
    get identityInput(): MysqlServerIdentity | undefined;
    private _threatDetectionPolicy;
    get threatDetectionPolicy(): MysqlServerThreatDetectionPolicyOutputReference;
    putThreatDetectionPolicy(value: MysqlServerThreatDetectionPolicy): void;
    resetThreatDetectionPolicy(): void;
    get threatDetectionPolicyInput(): MysqlServerThreatDetectionPolicy | undefined;
    private _timeouts;
    get timeouts(): MysqlServerTimeoutsOutputReference;
    putTimeouts(value: MysqlServerTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | MysqlServerTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
