/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface PaloAltoLocalRulestackRuleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/palo_alto_local_rulestack_rule#action PaloAltoLocalRulestackRule#action}
    */
    readonly action: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/palo_alto_local_rulestack_rule#applications PaloAltoLocalRulestackRule#applications}
    */
    readonly applications: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/palo_alto_local_rulestack_rule#audit_comment PaloAltoLocalRulestackRule#audit_comment}
    */
    readonly auditComment?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/palo_alto_local_rulestack_rule#decryption_rule_type PaloAltoLocalRulestackRule#decryption_rule_type}
    */
    readonly decryptionRuleType?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/palo_alto_local_rulestack_rule#description PaloAltoLocalRulestackRule#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/palo_alto_local_rulestack_rule#enabled PaloAltoLocalRulestackRule#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/palo_alto_local_rulestack_rule#id PaloAltoLocalRulestackRule#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/palo_alto_local_rulestack_rule#inspection_certificate_id PaloAltoLocalRulestackRule#inspection_certificate_id}
    */
    readonly inspectionCertificateId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/palo_alto_local_rulestack_rule#logging_enabled PaloAltoLocalRulestackRule#logging_enabled}
    */
    readonly loggingEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/palo_alto_local_rulestack_rule#name PaloAltoLocalRulestackRule#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/palo_alto_local_rulestack_rule#negate_destination PaloAltoLocalRulestackRule#negate_destination}
    */
    readonly negateDestination?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/palo_alto_local_rulestack_rule#negate_source PaloAltoLocalRulestackRule#negate_source}
    */
    readonly negateSource?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/palo_alto_local_rulestack_rule#priority PaloAltoLocalRulestackRule#priority}
    */
    readonly priority: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/palo_alto_local_rulestack_rule#protocol PaloAltoLocalRulestackRule#protocol}
    */
    readonly protocol?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/palo_alto_local_rulestack_rule#protocol_ports PaloAltoLocalRulestackRule#protocol_ports}
    */
    readonly protocolPorts?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/palo_alto_local_rulestack_rule#rulestack_id PaloAltoLocalRulestackRule#rulestack_id}
    */
    readonly rulestackId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/palo_alto_local_rulestack_rule#tags PaloAltoLocalRulestackRule#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * category block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/palo_alto_local_rulestack_rule#category PaloAltoLocalRulestackRule#category}
    */
    readonly category?: PaloAltoLocalRulestackRuleCategory;
    /**
    * destination block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/palo_alto_local_rulestack_rule#destination PaloAltoLocalRulestackRule#destination}
    */
    readonly destination: PaloAltoLocalRulestackRuleDestination;
    /**
    * source block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/palo_alto_local_rulestack_rule#source PaloAltoLocalRulestackRule#source}
    */
    readonly source: PaloAltoLocalRulestackRuleSource;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/palo_alto_local_rulestack_rule#timeouts PaloAltoLocalRulestackRule#timeouts}
    */
    readonly timeouts?: PaloAltoLocalRulestackRuleTimeouts;
}
export interface PaloAltoLocalRulestackRuleCategory {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/palo_alto_local_rulestack_rule#custom_urls PaloAltoLocalRulestackRule#custom_urls}
    */
    readonly customUrls: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/palo_alto_local_rulestack_rule#feeds PaloAltoLocalRulestackRule#feeds}
    */
    readonly feeds?: string[];
}
export declare function paloAltoLocalRulestackRuleCategoryToTerraform(struct?: PaloAltoLocalRulestackRuleCategoryOutputReference | PaloAltoLocalRulestackRuleCategory): any;
export declare class PaloAltoLocalRulestackRuleCategoryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PaloAltoLocalRulestackRuleCategory | undefined;
    set internalValue(value: PaloAltoLocalRulestackRuleCategory | undefined);
    private _customUrls?;
    get customUrls(): string[];
    set customUrls(value: string[]);
    get customUrlsInput(): string[] | undefined;
    private _feeds?;
    get feeds(): string[];
    set feeds(value: string[]);
    resetFeeds(): void;
    get feedsInput(): string[] | undefined;
}
export interface PaloAltoLocalRulestackRuleDestination {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/palo_alto_local_rulestack_rule#cidrs PaloAltoLocalRulestackRule#cidrs}
    */
    readonly cidrs?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/palo_alto_local_rulestack_rule#countries PaloAltoLocalRulestackRule#countries}
    */
    readonly countries?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/palo_alto_local_rulestack_rule#feeds PaloAltoLocalRulestackRule#feeds}
    */
    readonly feeds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/palo_alto_local_rulestack_rule#local_rulestack_fqdn_list_ids PaloAltoLocalRulestackRule#local_rulestack_fqdn_list_ids}
    */
    readonly localRulestackFqdnListIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/palo_alto_local_rulestack_rule#local_rulestack_prefix_list_ids PaloAltoLocalRulestackRule#local_rulestack_prefix_list_ids}
    */
    readonly localRulestackPrefixListIds?: string[];
}
export declare function paloAltoLocalRulestackRuleDestinationToTerraform(struct?: PaloAltoLocalRulestackRuleDestinationOutputReference | PaloAltoLocalRulestackRuleDestination): any;
export declare class PaloAltoLocalRulestackRuleDestinationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PaloAltoLocalRulestackRuleDestination | undefined;
    set internalValue(value: PaloAltoLocalRulestackRuleDestination | undefined);
    private _cidrs?;
    get cidrs(): string[];
    set cidrs(value: string[]);
    resetCidrs(): void;
    get cidrsInput(): string[] | undefined;
    private _countries?;
    get countries(): string[];
    set countries(value: string[]);
    resetCountries(): void;
    get countriesInput(): string[] | undefined;
    private _feeds?;
    get feeds(): string[];
    set feeds(value: string[]);
    resetFeeds(): void;
    get feedsInput(): string[] | undefined;
    private _localRulestackFqdnListIds?;
    get localRulestackFqdnListIds(): string[];
    set localRulestackFqdnListIds(value: string[]);
    resetLocalRulestackFqdnListIds(): void;
    get localRulestackFqdnListIdsInput(): string[] | undefined;
    private _localRulestackPrefixListIds?;
    get localRulestackPrefixListIds(): string[];
    set localRulestackPrefixListIds(value: string[]);
    resetLocalRulestackPrefixListIds(): void;
    get localRulestackPrefixListIdsInput(): string[] | undefined;
}
export interface PaloAltoLocalRulestackRuleSource {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/palo_alto_local_rulestack_rule#cidrs PaloAltoLocalRulestackRule#cidrs}
    */
    readonly cidrs?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/palo_alto_local_rulestack_rule#countries PaloAltoLocalRulestackRule#countries}
    */
    readonly countries?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/palo_alto_local_rulestack_rule#feeds PaloAltoLocalRulestackRule#feeds}
    */
    readonly feeds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/palo_alto_local_rulestack_rule#local_rulestack_prefix_list_ids PaloAltoLocalRulestackRule#local_rulestack_prefix_list_ids}
    */
    readonly localRulestackPrefixListIds?: string[];
}
export declare function paloAltoLocalRulestackRuleSourceToTerraform(struct?: PaloAltoLocalRulestackRuleSourceOutputReference | PaloAltoLocalRulestackRuleSource): any;
export declare class PaloAltoLocalRulestackRuleSourceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PaloAltoLocalRulestackRuleSource | undefined;
    set internalValue(value: PaloAltoLocalRulestackRuleSource | undefined);
    private _cidrs?;
    get cidrs(): string[];
    set cidrs(value: string[]);
    resetCidrs(): void;
    get cidrsInput(): string[] | undefined;
    private _countries?;
    get countries(): string[];
    set countries(value: string[]);
    resetCountries(): void;
    get countriesInput(): string[] | undefined;
    private _feeds?;
    get feeds(): string[];
    set feeds(value: string[]);
    resetFeeds(): void;
    get feedsInput(): string[] | undefined;
    private _localRulestackPrefixListIds?;
    get localRulestackPrefixListIds(): string[];
    set localRulestackPrefixListIds(value: string[]);
    resetLocalRulestackPrefixListIds(): void;
    get localRulestackPrefixListIdsInput(): string[] | undefined;
}
export interface PaloAltoLocalRulestackRuleTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/palo_alto_local_rulestack_rule#create PaloAltoLocalRulestackRule#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/palo_alto_local_rulestack_rule#delete PaloAltoLocalRulestackRule#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/palo_alto_local_rulestack_rule#read PaloAltoLocalRulestackRule#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/palo_alto_local_rulestack_rule#update PaloAltoLocalRulestackRule#update}
    */
    readonly update?: string;
}
export declare function paloAltoLocalRulestackRuleTimeoutsToTerraform(struct?: PaloAltoLocalRulestackRuleTimeouts | cdktf.IResolvable): any;
export declare class PaloAltoLocalRulestackRuleTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PaloAltoLocalRulestackRuleTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: PaloAltoLocalRulestackRuleTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/palo_alto_local_rulestack_rule azurerm_palo_alto_local_rulestack_rule}
*/
export declare class PaloAltoLocalRulestackRule extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_palo_alto_local_rulestack_rule";
    /**
    * Generates CDKTF code for importing a PaloAltoLocalRulestackRule resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the PaloAltoLocalRulestackRule to import
    * @param importFromId The id of the existing PaloAltoLocalRulestackRule that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/palo_alto_local_rulestack_rule#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the PaloAltoLocalRulestackRule to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/palo_alto_local_rulestack_rule azurerm_palo_alto_local_rulestack_rule} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options PaloAltoLocalRulestackRuleConfig
    */
    constructor(scope: Construct, id: string, config: PaloAltoLocalRulestackRuleConfig);
    private _action?;
    get action(): string;
    set action(value: string);
    get actionInput(): string | undefined;
    private _applications?;
    get applications(): string[];
    set applications(value: string[]);
    get applicationsInput(): string[] | undefined;
    private _auditComment?;
    get auditComment(): string;
    set auditComment(value: string);
    resetAuditComment(): void;
    get auditCommentInput(): string | undefined;
    private _decryptionRuleType?;
    get decryptionRuleType(): string;
    set decryptionRuleType(value: string);
    resetDecryptionRuleType(): void;
    get decryptionRuleTypeInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _inspectionCertificateId?;
    get inspectionCertificateId(): string;
    set inspectionCertificateId(value: string);
    resetInspectionCertificateId(): void;
    get inspectionCertificateIdInput(): string | undefined;
    private _loggingEnabled?;
    get loggingEnabled(): boolean | cdktf.IResolvable;
    set loggingEnabled(value: boolean | cdktf.IResolvable);
    resetLoggingEnabled(): void;
    get loggingEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _negateDestination?;
    get negateDestination(): boolean | cdktf.IResolvable;
    set negateDestination(value: boolean | cdktf.IResolvable);
    resetNegateDestination(): void;
    get negateDestinationInput(): boolean | cdktf.IResolvable | undefined;
    private _negateSource?;
    get negateSource(): boolean | cdktf.IResolvable;
    set negateSource(value: boolean | cdktf.IResolvable);
    resetNegateSource(): void;
    get negateSourceInput(): boolean | cdktf.IResolvable | undefined;
    private _priority?;
    get priority(): number;
    set priority(value: number);
    get priorityInput(): number | undefined;
    private _protocol?;
    get protocol(): string;
    set protocol(value: string);
    resetProtocol(): void;
    get protocolInput(): string | undefined;
    private _protocolPorts?;
    get protocolPorts(): string[];
    set protocolPorts(value: string[]);
    resetProtocolPorts(): void;
    get protocolPortsInput(): string[] | undefined;
    private _rulestackId?;
    get rulestackId(): string;
    set rulestackId(value: string);
    get rulestackIdInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _category;
    get category(): PaloAltoLocalRulestackRuleCategoryOutputReference;
    putCategory(value: PaloAltoLocalRulestackRuleCategory): void;
    resetCategory(): void;
    get categoryInput(): PaloAltoLocalRulestackRuleCategory | undefined;
    private _destination;
    get destination(): PaloAltoLocalRulestackRuleDestinationOutputReference;
    putDestination(value: PaloAltoLocalRulestackRuleDestination): void;
    get destinationInput(): PaloAltoLocalRulestackRuleDestination | undefined;
    private _source;
    get source(): PaloAltoLocalRulestackRuleSourceOutputReference;
    putSource(value: PaloAltoLocalRulestackRuleSource): void;
    get sourceInput(): PaloAltoLocalRulestackRuleSource | undefined;
    private _timeouts;
    get timeouts(): PaloAltoLocalRulestackRuleTimeoutsOutputReference;
    putTimeouts(value: PaloAltoLocalRulestackRuleTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | PaloAltoLocalRulestackRuleTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
