/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SentinelAlertRuleNrtConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/sentinel_alert_rule_nrt#alert_rule_template_guid SentinelAlertRuleNrt#alert_rule_template_guid}
    */
    readonly alertRuleTemplateGuid?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/sentinel_alert_rule_nrt#alert_rule_template_version SentinelAlertRuleNrt#alert_rule_template_version}
    */
    readonly alertRuleTemplateVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/sentinel_alert_rule_nrt#custom_details SentinelAlertRuleNrt#custom_details}
    */
    readonly customDetails?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/sentinel_alert_rule_nrt#description SentinelAlertRuleNrt#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/sentinel_alert_rule_nrt#display_name SentinelAlertRuleNrt#display_name}
    */
    readonly displayName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/sentinel_alert_rule_nrt#enabled SentinelAlertRuleNrt#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/sentinel_alert_rule_nrt#id SentinelAlertRuleNrt#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/sentinel_alert_rule_nrt#log_analytics_workspace_id SentinelAlertRuleNrt#log_analytics_workspace_id}
    */
    readonly logAnalyticsWorkspaceId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/sentinel_alert_rule_nrt#name SentinelAlertRuleNrt#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/sentinel_alert_rule_nrt#query SentinelAlertRuleNrt#query}
    */
    readonly query: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/sentinel_alert_rule_nrt#severity SentinelAlertRuleNrt#severity}
    */
    readonly severity: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/sentinel_alert_rule_nrt#suppression_duration SentinelAlertRuleNrt#suppression_duration}
    */
    readonly suppressionDuration?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/sentinel_alert_rule_nrt#suppression_enabled SentinelAlertRuleNrt#suppression_enabled}
    */
    readonly suppressionEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/sentinel_alert_rule_nrt#tactics SentinelAlertRuleNrt#tactics}
    */
    readonly tactics?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/sentinel_alert_rule_nrt#techniques SentinelAlertRuleNrt#techniques}
    */
    readonly techniques?: string[];
    /**
    * alert_details_override block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/sentinel_alert_rule_nrt#alert_details_override SentinelAlertRuleNrt#alert_details_override}
    */
    readonly alertDetailsOverride?: SentinelAlertRuleNrtAlertDetailsOverride[] | cdktf.IResolvable;
    /**
    * entity_mapping block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/sentinel_alert_rule_nrt#entity_mapping SentinelAlertRuleNrt#entity_mapping}
    */
    readonly entityMapping?: SentinelAlertRuleNrtEntityMapping[] | cdktf.IResolvable;
    /**
    * event_grouping block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/sentinel_alert_rule_nrt#event_grouping SentinelAlertRuleNrt#event_grouping}
    */
    readonly eventGrouping?: SentinelAlertRuleNrtEventGrouping;
    /**
    * incident block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/sentinel_alert_rule_nrt#incident SentinelAlertRuleNrt#incident}
    */
    readonly incident?: SentinelAlertRuleNrtIncident;
    /**
    * sentinel_entity_mapping block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/sentinel_alert_rule_nrt#sentinel_entity_mapping SentinelAlertRuleNrt#sentinel_entity_mapping}
    */
    readonly sentinelEntityMapping?: SentinelAlertRuleNrtSentinelEntityMapping[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/sentinel_alert_rule_nrt#timeouts SentinelAlertRuleNrt#timeouts}
    */
    readonly timeouts?: SentinelAlertRuleNrtTimeouts;
}
export interface SentinelAlertRuleNrtAlertDetailsOverrideDynamicProperty {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/sentinel_alert_rule_nrt#name SentinelAlertRuleNrt#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/sentinel_alert_rule_nrt#value SentinelAlertRuleNrt#value}
    */
    readonly value: string;
}
export declare function sentinelAlertRuleNrtAlertDetailsOverrideDynamicPropertyToTerraform(struct?: SentinelAlertRuleNrtAlertDetailsOverrideDynamicProperty | cdktf.IResolvable): any;
export declare class SentinelAlertRuleNrtAlertDetailsOverrideDynamicPropertyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SentinelAlertRuleNrtAlertDetailsOverrideDynamicProperty | cdktf.IResolvable | undefined;
    set internalValue(value: SentinelAlertRuleNrtAlertDetailsOverrideDynamicProperty | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class SentinelAlertRuleNrtAlertDetailsOverrideDynamicPropertyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: SentinelAlertRuleNrtAlertDetailsOverrideDynamicProperty[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SentinelAlertRuleNrtAlertDetailsOverrideDynamicPropertyOutputReference;
}
export interface SentinelAlertRuleNrtAlertDetailsOverride {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/sentinel_alert_rule_nrt#description_format SentinelAlertRuleNrt#description_format}
    */
    readonly descriptionFormat?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/sentinel_alert_rule_nrt#display_name_format SentinelAlertRuleNrt#display_name_format}
    */
    readonly displayNameFormat?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/sentinel_alert_rule_nrt#severity_column_name SentinelAlertRuleNrt#severity_column_name}
    */
    readonly severityColumnName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/sentinel_alert_rule_nrt#tactics_column_name SentinelAlertRuleNrt#tactics_column_name}
    */
    readonly tacticsColumnName?: string;
    /**
    * dynamic_property block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/sentinel_alert_rule_nrt#dynamic_property SentinelAlertRuleNrt#dynamic_property}
    */
    readonly dynamicProperty?: SentinelAlertRuleNrtAlertDetailsOverrideDynamicProperty[] | cdktf.IResolvable;
}
export declare function sentinelAlertRuleNrtAlertDetailsOverrideToTerraform(struct?: SentinelAlertRuleNrtAlertDetailsOverride | cdktf.IResolvable): any;
export declare class SentinelAlertRuleNrtAlertDetailsOverrideOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SentinelAlertRuleNrtAlertDetailsOverride | cdktf.IResolvable | undefined;
    set internalValue(value: SentinelAlertRuleNrtAlertDetailsOverride | cdktf.IResolvable | undefined);
    private _descriptionFormat?;
    get descriptionFormat(): string;
    set descriptionFormat(value: string);
    resetDescriptionFormat(): void;
    get descriptionFormatInput(): string | undefined;
    private _displayNameFormat?;
    get displayNameFormat(): string;
    set displayNameFormat(value: string);
    resetDisplayNameFormat(): void;
    get displayNameFormatInput(): string | undefined;
    private _severityColumnName?;
    get severityColumnName(): string;
    set severityColumnName(value: string);
    resetSeverityColumnName(): void;
    get severityColumnNameInput(): string | undefined;
    private _tacticsColumnName?;
    get tacticsColumnName(): string;
    set tacticsColumnName(value: string);
    resetTacticsColumnName(): void;
    get tacticsColumnNameInput(): string | undefined;
    private _dynamicProperty;
    get dynamicProperty(): SentinelAlertRuleNrtAlertDetailsOverrideDynamicPropertyList;
    putDynamicProperty(value: SentinelAlertRuleNrtAlertDetailsOverrideDynamicProperty[] | cdktf.IResolvable): void;
    resetDynamicProperty(): void;
    get dynamicPropertyInput(): cdktf.IResolvable | SentinelAlertRuleNrtAlertDetailsOverrideDynamicProperty[] | undefined;
}
export declare class SentinelAlertRuleNrtAlertDetailsOverrideList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: SentinelAlertRuleNrtAlertDetailsOverride[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SentinelAlertRuleNrtAlertDetailsOverrideOutputReference;
}
export interface SentinelAlertRuleNrtEntityMappingFieldMapping {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/sentinel_alert_rule_nrt#column_name SentinelAlertRuleNrt#column_name}
    */
    readonly columnName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/sentinel_alert_rule_nrt#identifier SentinelAlertRuleNrt#identifier}
    */
    readonly identifier: string;
}
export declare function sentinelAlertRuleNrtEntityMappingFieldMappingToTerraform(struct?: SentinelAlertRuleNrtEntityMappingFieldMapping | cdktf.IResolvable): any;
export declare class SentinelAlertRuleNrtEntityMappingFieldMappingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SentinelAlertRuleNrtEntityMappingFieldMapping | cdktf.IResolvable | undefined;
    set internalValue(value: SentinelAlertRuleNrtEntityMappingFieldMapping | cdktf.IResolvable | undefined);
    private _columnName?;
    get columnName(): string;
    set columnName(value: string);
    get columnNameInput(): string | undefined;
    private _identifier?;
    get identifier(): string;
    set identifier(value: string);
    get identifierInput(): string | undefined;
}
export declare class SentinelAlertRuleNrtEntityMappingFieldMappingList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: SentinelAlertRuleNrtEntityMappingFieldMapping[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SentinelAlertRuleNrtEntityMappingFieldMappingOutputReference;
}
export interface SentinelAlertRuleNrtEntityMapping {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/sentinel_alert_rule_nrt#entity_type SentinelAlertRuleNrt#entity_type}
    */
    readonly entityType: string;
    /**
    * field_mapping block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/sentinel_alert_rule_nrt#field_mapping SentinelAlertRuleNrt#field_mapping}
    */
    readonly fieldMapping: SentinelAlertRuleNrtEntityMappingFieldMapping[] | cdktf.IResolvable;
}
export declare function sentinelAlertRuleNrtEntityMappingToTerraform(struct?: SentinelAlertRuleNrtEntityMapping | cdktf.IResolvable): any;
export declare class SentinelAlertRuleNrtEntityMappingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SentinelAlertRuleNrtEntityMapping | cdktf.IResolvable | undefined;
    set internalValue(value: SentinelAlertRuleNrtEntityMapping | cdktf.IResolvable | undefined);
    private _entityType?;
    get entityType(): string;
    set entityType(value: string);
    get entityTypeInput(): string | undefined;
    private _fieldMapping;
    get fieldMapping(): SentinelAlertRuleNrtEntityMappingFieldMappingList;
    putFieldMapping(value: SentinelAlertRuleNrtEntityMappingFieldMapping[] | cdktf.IResolvable): void;
    get fieldMappingInput(): cdktf.IResolvable | SentinelAlertRuleNrtEntityMappingFieldMapping[] | undefined;
}
export declare class SentinelAlertRuleNrtEntityMappingList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: SentinelAlertRuleNrtEntityMapping[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SentinelAlertRuleNrtEntityMappingOutputReference;
}
export interface SentinelAlertRuleNrtEventGrouping {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/sentinel_alert_rule_nrt#aggregation_method SentinelAlertRuleNrt#aggregation_method}
    */
    readonly aggregationMethod: string;
}
export declare function sentinelAlertRuleNrtEventGroupingToTerraform(struct?: SentinelAlertRuleNrtEventGroupingOutputReference | SentinelAlertRuleNrtEventGrouping): any;
export declare class SentinelAlertRuleNrtEventGroupingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SentinelAlertRuleNrtEventGrouping | undefined;
    set internalValue(value: SentinelAlertRuleNrtEventGrouping | undefined);
    private _aggregationMethod?;
    get aggregationMethod(): string;
    set aggregationMethod(value: string);
    get aggregationMethodInput(): string | undefined;
}
export interface SentinelAlertRuleNrtIncidentGrouping {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/sentinel_alert_rule_nrt#by_alert_details SentinelAlertRuleNrt#by_alert_details}
    */
    readonly byAlertDetails?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/sentinel_alert_rule_nrt#by_custom_details SentinelAlertRuleNrt#by_custom_details}
    */
    readonly byCustomDetails?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/sentinel_alert_rule_nrt#by_entities SentinelAlertRuleNrt#by_entities}
    */
    readonly byEntities?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/sentinel_alert_rule_nrt#enabled SentinelAlertRuleNrt#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/sentinel_alert_rule_nrt#entity_matching_method SentinelAlertRuleNrt#entity_matching_method}
    */
    readonly entityMatchingMethod?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/sentinel_alert_rule_nrt#lookback_duration SentinelAlertRuleNrt#lookback_duration}
    */
    readonly lookbackDuration?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/sentinel_alert_rule_nrt#reopen_closed_incidents SentinelAlertRuleNrt#reopen_closed_incidents}
    */
    readonly reopenClosedIncidents?: boolean | cdktf.IResolvable;
}
export declare function sentinelAlertRuleNrtIncidentGroupingToTerraform(struct?: SentinelAlertRuleNrtIncidentGroupingOutputReference | SentinelAlertRuleNrtIncidentGrouping): any;
export declare class SentinelAlertRuleNrtIncidentGroupingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SentinelAlertRuleNrtIncidentGrouping | undefined;
    set internalValue(value: SentinelAlertRuleNrtIncidentGrouping | undefined);
    private _byAlertDetails?;
    get byAlertDetails(): string[];
    set byAlertDetails(value: string[]);
    resetByAlertDetails(): void;
    get byAlertDetailsInput(): string[] | undefined;
    private _byCustomDetails?;
    get byCustomDetails(): string[];
    set byCustomDetails(value: string[]);
    resetByCustomDetails(): void;
    get byCustomDetailsInput(): string[] | undefined;
    private _byEntities?;
    get byEntities(): string[];
    set byEntities(value: string[]);
    resetByEntities(): void;
    get byEntitiesInput(): string[] | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _entityMatchingMethod?;
    get entityMatchingMethod(): string;
    set entityMatchingMethod(value: string);
    resetEntityMatchingMethod(): void;
    get entityMatchingMethodInput(): string | undefined;
    private _lookbackDuration?;
    get lookbackDuration(): string;
    set lookbackDuration(value: string);
    resetLookbackDuration(): void;
    get lookbackDurationInput(): string | undefined;
    private _reopenClosedIncidents?;
    get reopenClosedIncidents(): boolean | cdktf.IResolvable;
    set reopenClosedIncidents(value: boolean | cdktf.IResolvable);
    resetReopenClosedIncidents(): void;
    get reopenClosedIncidentsInput(): boolean | cdktf.IResolvable | undefined;
}
export interface SentinelAlertRuleNrtIncident {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/sentinel_alert_rule_nrt#create_incident_enabled SentinelAlertRuleNrt#create_incident_enabled}
    */
    readonly createIncidentEnabled: boolean | cdktf.IResolvable;
    /**
    * grouping block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/sentinel_alert_rule_nrt#grouping SentinelAlertRuleNrt#grouping}
    */
    readonly grouping: SentinelAlertRuleNrtIncidentGrouping;
}
export declare function sentinelAlertRuleNrtIncidentToTerraform(struct?: SentinelAlertRuleNrtIncidentOutputReference | SentinelAlertRuleNrtIncident): any;
export declare class SentinelAlertRuleNrtIncidentOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SentinelAlertRuleNrtIncident | undefined;
    set internalValue(value: SentinelAlertRuleNrtIncident | undefined);
    private _createIncidentEnabled?;
    get createIncidentEnabled(): boolean | cdktf.IResolvable;
    set createIncidentEnabled(value: boolean | cdktf.IResolvable);
    get createIncidentEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _grouping;
    get grouping(): SentinelAlertRuleNrtIncidentGroupingOutputReference;
    putGrouping(value: SentinelAlertRuleNrtIncidentGrouping): void;
    get groupingInput(): SentinelAlertRuleNrtIncidentGrouping | undefined;
}
export interface SentinelAlertRuleNrtSentinelEntityMapping {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/sentinel_alert_rule_nrt#column_name SentinelAlertRuleNrt#column_name}
    */
    readonly columnName: string;
}
export declare function sentinelAlertRuleNrtSentinelEntityMappingToTerraform(struct?: SentinelAlertRuleNrtSentinelEntityMapping | cdktf.IResolvable): any;
export declare class SentinelAlertRuleNrtSentinelEntityMappingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SentinelAlertRuleNrtSentinelEntityMapping | cdktf.IResolvable | undefined;
    set internalValue(value: SentinelAlertRuleNrtSentinelEntityMapping | cdktf.IResolvable | undefined);
    private _columnName?;
    get columnName(): string;
    set columnName(value: string);
    get columnNameInput(): string | undefined;
}
export declare class SentinelAlertRuleNrtSentinelEntityMappingList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: SentinelAlertRuleNrtSentinelEntityMapping[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SentinelAlertRuleNrtSentinelEntityMappingOutputReference;
}
export interface SentinelAlertRuleNrtTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/sentinel_alert_rule_nrt#create SentinelAlertRuleNrt#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/sentinel_alert_rule_nrt#delete SentinelAlertRuleNrt#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/sentinel_alert_rule_nrt#read SentinelAlertRuleNrt#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/sentinel_alert_rule_nrt#update SentinelAlertRuleNrt#update}
    */
    readonly update?: string;
}
export declare function sentinelAlertRuleNrtTimeoutsToTerraform(struct?: SentinelAlertRuleNrtTimeouts | cdktf.IResolvable): any;
export declare class SentinelAlertRuleNrtTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SentinelAlertRuleNrtTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: SentinelAlertRuleNrtTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/sentinel_alert_rule_nrt azurerm_sentinel_alert_rule_nrt}
*/
export declare class SentinelAlertRuleNrt extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_sentinel_alert_rule_nrt";
    /**
    * Generates CDKTF code for importing a SentinelAlertRuleNrt resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the SentinelAlertRuleNrt to import
    * @param importFromId The id of the existing SentinelAlertRuleNrt that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/sentinel_alert_rule_nrt#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the SentinelAlertRuleNrt to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/sentinel_alert_rule_nrt azurerm_sentinel_alert_rule_nrt} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SentinelAlertRuleNrtConfig
    */
    constructor(scope: Construct, id: string, config: SentinelAlertRuleNrtConfig);
    private _alertRuleTemplateGuid?;
    get alertRuleTemplateGuid(): string;
    set alertRuleTemplateGuid(value: string);
    resetAlertRuleTemplateGuid(): void;
    get alertRuleTemplateGuidInput(): string | undefined;
    private _alertRuleTemplateVersion?;
    get alertRuleTemplateVersion(): string;
    set alertRuleTemplateVersion(value: string);
    resetAlertRuleTemplateVersion(): void;
    get alertRuleTemplateVersionInput(): string | undefined;
    private _customDetails?;
    get customDetails(): {
        [key: string]: string;
    };
    set customDetails(value: {
        [key: string]: string;
    });
    resetCustomDetails(): void;
    get customDetailsInput(): {
        [key: string]: string;
    } | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _logAnalyticsWorkspaceId?;
    get logAnalyticsWorkspaceId(): string;
    set logAnalyticsWorkspaceId(value: string);
    get logAnalyticsWorkspaceIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _query?;
    get query(): string;
    set query(value: string);
    get queryInput(): string | undefined;
    private _severity?;
    get severity(): string;
    set severity(value: string);
    get severityInput(): string | undefined;
    private _suppressionDuration?;
    get suppressionDuration(): string;
    set suppressionDuration(value: string);
    resetSuppressionDuration(): void;
    get suppressionDurationInput(): string | undefined;
    private _suppressionEnabled?;
    get suppressionEnabled(): boolean | cdktf.IResolvable;
    set suppressionEnabled(value: boolean | cdktf.IResolvable);
    resetSuppressionEnabled(): void;
    get suppressionEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _tactics?;
    get tactics(): string[];
    set tactics(value: string[]);
    resetTactics(): void;
    get tacticsInput(): string[] | undefined;
    private _techniques?;
    get techniques(): string[];
    set techniques(value: string[]);
    resetTechniques(): void;
    get techniquesInput(): string[] | undefined;
    private _alertDetailsOverride;
    get alertDetailsOverride(): SentinelAlertRuleNrtAlertDetailsOverrideList;
    putAlertDetailsOverride(value: SentinelAlertRuleNrtAlertDetailsOverride[] | cdktf.IResolvable): void;
    resetAlertDetailsOverride(): void;
    get alertDetailsOverrideInput(): cdktf.IResolvable | SentinelAlertRuleNrtAlertDetailsOverride[] | undefined;
    private _entityMapping;
    get entityMapping(): SentinelAlertRuleNrtEntityMappingList;
    putEntityMapping(value: SentinelAlertRuleNrtEntityMapping[] | cdktf.IResolvable): void;
    resetEntityMapping(): void;
    get entityMappingInput(): cdktf.IResolvable | SentinelAlertRuleNrtEntityMapping[] | undefined;
    private _eventGrouping;
    get eventGrouping(): SentinelAlertRuleNrtEventGroupingOutputReference;
    putEventGrouping(value: SentinelAlertRuleNrtEventGrouping): void;
    resetEventGrouping(): void;
    get eventGroupingInput(): SentinelAlertRuleNrtEventGrouping | undefined;
    private _incident;
    get incident(): SentinelAlertRuleNrtIncidentOutputReference;
    putIncident(value: SentinelAlertRuleNrtIncident): void;
    resetIncident(): void;
    get incidentInput(): SentinelAlertRuleNrtIncident | undefined;
    private _sentinelEntityMapping;
    get sentinelEntityMapping(): SentinelAlertRuleNrtSentinelEntityMappingList;
    putSentinelEntityMapping(value: SentinelAlertRuleNrtSentinelEntityMapping[] | cdktf.IResolvable): void;
    resetSentinelEntityMapping(): void;
    get sentinelEntityMappingInput(): cdktf.IResolvable | SentinelAlertRuleNrtSentinelEntityMapping[] | undefined;
    private _timeouts;
    get timeouts(): SentinelAlertRuleNrtTimeoutsOutputReference;
    putTimeouts(value: SentinelAlertRuleNrtTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | SentinelAlertRuleNrtTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
