/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SynapseSparkPoolConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/synapse_spark_pool#cache_size SynapseSparkPool#cache_size}
    */
    readonly cacheSize?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/synapse_spark_pool#compute_isolation_enabled SynapseSparkPool#compute_isolation_enabled}
    */
    readonly computeIsolationEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/synapse_spark_pool#dynamic_executor_allocation_enabled SynapseSparkPool#dynamic_executor_allocation_enabled}
    */
    readonly dynamicExecutorAllocationEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/synapse_spark_pool#id SynapseSparkPool#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/synapse_spark_pool#max_executors SynapseSparkPool#max_executors}
    */
    readonly maxExecutors?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/synapse_spark_pool#min_executors SynapseSparkPool#min_executors}
    */
    readonly minExecutors?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/synapse_spark_pool#name SynapseSparkPool#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/synapse_spark_pool#node_count SynapseSparkPool#node_count}
    */
    readonly nodeCount?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/synapse_spark_pool#node_size SynapseSparkPool#node_size}
    */
    readonly nodeSize: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/synapse_spark_pool#node_size_family SynapseSparkPool#node_size_family}
    */
    readonly nodeSizeFamily: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/synapse_spark_pool#session_level_packages_enabled SynapseSparkPool#session_level_packages_enabled}
    */
    readonly sessionLevelPackagesEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/synapse_spark_pool#spark_events_folder SynapseSparkPool#spark_events_folder}
    */
    readonly sparkEventsFolder?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/synapse_spark_pool#spark_log_folder SynapseSparkPool#spark_log_folder}
    */
    readonly sparkLogFolder?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/synapse_spark_pool#spark_version SynapseSparkPool#spark_version}
    */
    readonly sparkVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/synapse_spark_pool#synapse_workspace_id SynapseSparkPool#synapse_workspace_id}
    */
    readonly synapseWorkspaceId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/synapse_spark_pool#tags SynapseSparkPool#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * auto_pause block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/synapse_spark_pool#auto_pause SynapseSparkPool#auto_pause}
    */
    readonly autoPause?: SynapseSparkPoolAutoPause;
    /**
    * auto_scale block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/synapse_spark_pool#auto_scale SynapseSparkPool#auto_scale}
    */
    readonly autoScale?: SynapseSparkPoolAutoScale;
    /**
    * library_requirement block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/synapse_spark_pool#library_requirement SynapseSparkPool#library_requirement}
    */
    readonly libraryRequirement?: SynapseSparkPoolLibraryRequirement;
    /**
    * spark_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/synapse_spark_pool#spark_config SynapseSparkPool#spark_config}
    */
    readonly sparkConfig?: SynapseSparkPoolSparkConfig;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/synapse_spark_pool#timeouts SynapseSparkPool#timeouts}
    */
    readonly timeouts?: SynapseSparkPoolTimeouts;
}
export interface SynapseSparkPoolAutoPause {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/synapse_spark_pool#delay_in_minutes SynapseSparkPool#delay_in_minutes}
    */
    readonly delayInMinutes: number;
}
export declare function synapseSparkPoolAutoPauseToTerraform(struct?: SynapseSparkPoolAutoPauseOutputReference | SynapseSparkPoolAutoPause): any;
export declare class SynapseSparkPoolAutoPauseOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SynapseSparkPoolAutoPause | undefined;
    set internalValue(value: SynapseSparkPoolAutoPause | undefined);
    private _delayInMinutes?;
    get delayInMinutes(): number;
    set delayInMinutes(value: number);
    get delayInMinutesInput(): number | undefined;
}
export interface SynapseSparkPoolAutoScale {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/synapse_spark_pool#max_node_count SynapseSparkPool#max_node_count}
    */
    readonly maxNodeCount: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/synapse_spark_pool#min_node_count SynapseSparkPool#min_node_count}
    */
    readonly minNodeCount: number;
}
export declare function synapseSparkPoolAutoScaleToTerraform(struct?: SynapseSparkPoolAutoScaleOutputReference | SynapseSparkPoolAutoScale): any;
export declare class SynapseSparkPoolAutoScaleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SynapseSparkPoolAutoScale | undefined;
    set internalValue(value: SynapseSparkPoolAutoScale | undefined);
    private _maxNodeCount?;
    get maxNodeCount(): number;
    set maxNodeCount(value: number);
    get maxNodeCountInput(): number | undefined;
    private _minNodeCount?;
    get minNodeCount(): number;
    set minNodeCount(value: number);
    get minNodeCountInput(): number | undefined;
}
export interface SynapseSparkPoolLibraryRequirement {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/synapse_spark_pool#content SynapseSparkPool#content}
    */
    readonly content: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/synapse_spark_pool#filename SynapseSparkPool#filename}
    */
    readonly filename: string;
}
export declare function synapseSparkPoolLibraryRequirementToTerraform(struct?: SynapseSparkPoolLibraryRequirementOutputReference | SynapseSparkPoolLibraryRequirement): any;
export declare class SynapseSparkPoolLibraryRequirementOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SynapseSparkPoolLibraryRequirement | undefined;
    set internalValue(value: SynapseSparkPoolLibraryRequirement | undefined);
    private _content?;
    get content(): string;
    set content(value: string);
    get contentInput(): string | undefined;
    private _filename?;
    get filename(): string;
    set filename(value: string);
    get filenameInput(): string | undefined;
}
export interface SynapseSparkPoolSparkConfig {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/synapse_spark_pool#content SynapseSparkPool#content}
    */
    readonly content: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/synapse_spark_pool#filename SynapseSparkPool#filename}
    */
    readonly filename: string;
}
export declare function synapseSparkPoolSparkConfigToTerraform(struct?: SynapseSparkPoolSparkConfigOutputReference | SynapseSparkPoolSparkConfig): any;
export declare class SynapseSparkPoolSparkConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SynapseSparkPoolSparkConfig | undefined;
    set internalValue(value: SynapseSparkPoolSparkConfig | undefined);
    private _content?;
    get content(): string;
    set content(value: string);
    get contentInput(): string | undefined;
    private _filename?;
    get filename(): string;
    set filename(value: string);
    get filenameInput(): string | undefined;
}
export interface SynapseSparkPoolTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/synapse_spark_pool#create SynapseSparkPool#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/synapse_spark_pool#delete SynapseSparkPool#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/synapse_spark_pool#read SynapseSparkPool#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/synapse_spark_pool#update SynapseSparkPool#update}
    */
    readonly update?: string;
}
export declare function synapseSparkPoolTimeoutsToTerraform(struct?: SynapseSparkPoolTimeouts | cdktf.IResolvable): any;
export declare class SynapseSparkPoolTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SynapseSparkPoolTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: SynapseSparkPoolTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/synapse_spark_pool azurerm_synapse_spark_pool}
*/
export declare class SynapseSparkPool extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_synapse_spark_pool";
    /**
    * Generates CDKTF code for importing a SynapseSparkPool resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the SynapseSparkPool to import
    * @param importFromId The id of the existing SynapseSparkPool that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/synapse_spark_pool#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the SynapseSparkPool to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/synapse_spark_pool azurerm_synapse_spark_pool} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SynapseSparkPoolConfig
    */
    constructor(scope: Construct, id: string, config: SynapseSparkPoolConfig);
    private _cacheSize?;
    get cacheSize(): number;
    set cacheSize(value: number);
    resetCacheSize(): void;
    get cacheSizeInput(): number | undefined;
    private _computeIsolationEnabled?;
    get computeIsolationEnabled(): boolean | cdktf.IResolvable;
    set computeIsolationEnabled(value: boolean | cdktf.IResolvable);
    resetComputeIsolationEnabled(): void;
    get computeIsolationEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _dynamicExecutorAllocationEnabled?;
    get dynamicExecutorAllocationEnabled(): boolean | cdktf.IResolvable;
    set dynamicExecutorAllocationEnabled(value: boolean | cdktf.IResolvable);
    resetDynamicExecutorAllocationEnabled(): void;
    get dynamicExecutorAllocationEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _maxExecutors?;
    get maxExecutors(): number;
    set maxExecutors(value: number);
    resetMaxExecutors(): void;
    get maxExecutorsInput(): number | undefined;
    private _minExecutors?;
    get minExecutors(): number;
    set minExecutors(value: number);
    resetMinExecutors(): void;
    get minExecutorsInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _nodeCount?;
    get nodeCount(): number;
    set nodeCount(value: number);
    resetNodeCount(): void;
    get nodeCountInput(): number | undefined;
    private _nodeSize?;
    get nodeSize(): string;
    set nodeSize(value: string);
    get nodeSizeInput(): string | undefined;
    private _nodeSizeFamily?;
    get nodeSizeFamily(): string;
    set nodeSizeFamily(value: string);
    get nodeSizeFamilyInput(): string | undefined;
    private _sessionLevelPackagesEnabled?;
    get sessionLevelPackagesEnabled(): boolean | cdktf.IResolvable;
    set sessionLevelPackagesEnabled(value: boolean | cdktf.IResolvable);
    resetSessionLevelPackagesEnabled(): void;
    get sessionLevelPackagesEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _sparkEventsFolder?;
    get sparkEventsFolder(): string;
    set sparkEventsFolder(value: string);
    resetSparkEventsFolder(): void;
    get sparkEventsFolderInput(): string | undefined;
    private _sparkLogFolder?;
    get sparkLogFolder(): string;
    set sparkLogFolder(value: string);
    resetSparkLogFolder(): void;
    get sparkLogFolderInput(): string | undefined;
    private _sparkVersion?;
    get sparkVersion(): string;
    set sparkVersion(value: string);
    resetSparkVersion(): void;
    get sparkVersionInput(): string | undefined;
    private _synapseWorkspaceId?;
    get synapseWorkspaceId(): string;
    set synapseWorkspaceId(value: string);
    get synapseWorkspaceIdInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _autoPause;
    get autoPause(): SynapseSparkPoolAutoPauseOutputReference;
    putAutoPause(value: SynapseSparkPoolAutoPause): void;
    resetAutoPause(): void;
    get autoPauseInput(): SynapseSparkPoolAutoPause | undefined;
    private _autoScale;
    get autoScale(): SynapseSparkPoolAutoScaleOutputReference;
    putAutoScale(value: SynapseSparkPoolAutoScale): void;
    resetAutoScale(): void;
    get autoScaleInput(): SynapseSparkPoolAutoScale | undefined;
    private _libraryRequirement;
    get libraryRequirement(): SynapseSparkPoolLibraryRequirementOutputReference;
    putLibraryRequirement(value: SynapseSparkPoolLibraryRequirement): void;
    resetLibraryRequirement(): void;
    get libraryRequirementInput(): SynapseSparkPoolLibraryRequirement | undefined;
    private _sparkConfig;
    get sparkConfig(): SynapseSparkPoolSparkConfigOutputReference;
    putSparkConfig(value: SynapseSparkPoolSparkConfig): void;
    resetSparkConfig(): void;
    get sparkConfigInput(): SynapseSparkPoolSparkConfig | undefined;
    private _timeouts;
    get timeouts(): SynapseSparkPoolTimeoutsOutputReference;
    putTimeouts(value: SynapseSparkPoolTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | SynapseSparkPoolTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
