/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface VirtualNetworkGatewayConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/virtual_network_gateway#active_active VirtualNetworkGateway#active_active}
    */
    readonly activeActive?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/virtual_network_gateway#default_local_network_gateway_id VirtualNetworkGateway#default_local_network_gateway_id}
    */
    readonly defaultLocalNetworkGatewayId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/virtual_network_gateway#edge_zone VirtualNetworkGateway#edge_zone}
    */
    readonly edgeZone?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/virtual_network_gateway#enable_bgp VirtualNetworkGateway#enable_bgp}
    */
    readonly enableBgp?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/virtual_network_gateway#generation VirtualNetworkGateway#generation}
    */
    readonly generation?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/virtual_network_gateway#id VirtualNetworkGateway#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/virtual_network_gateway#location VirtualNetworkGateway#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/virtual_network_gateway#name VirtualNetworkGateway#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/virtual_network_gateway#private_ip_address_enabled VirtualNetworkGateway#private_ip_address_enabled}
    */
    readonly privateIpAddressEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/virtual_network_gateway#resource_group_name VirtualNetworkGateway#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/virtual_network_gateway#sku VirtualNetworkGateway#sku}
    */
    readonly sku: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/virtual_network_gateway#tags VirtualNetworkGateway#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/virtual_network_gateway#type VirtualNetworkGateway#type}
    */
    readonly type: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/virtual_network_gateway#vpn_type VirtualNetworkGateway#vpn_type}
    */
    readonly vpnType?: string;
    /**
    * bgp_settings block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/virtual_network_gateway#bgp_settings VirtualNetworkGateway#bgp_settings}
    */
    readonly bgpSettings?: VirtualNetworkGatewayBgpSettings;
    /**
    * custom_route block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/virtual_network_gateway#custom_route VirtualNetworkGateway#custom_route}
    */
    readonly customRoute?: VirtualNetworkGatewayCustomRoute;
    /**
    * ip_configuration block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/virtual_network_gateway#ip_configuration VirtualNetworkGateway#ip_configuration}
    */
    readonly ipConfiguration: VirtualNetworkGatewayIpConfiguration[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/virtual_network_gateway#timeouts VirtualNetworkGateway#timeouts}
    */
    readonly timeouts?: VirtualNetworkGatewayTimeouts;
    /**
    * vpn_client_configuration block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/virtual_network_gateway#vpn_client_configuration VirtualNetworkGateway#vpn_client_configuration}
    */
    readonly vpnClientConfiguration?: VirtualNetworkGatewayVpnClientConfiguration;
}
export interface VirtualNetworkGatewayBgpSettingsPeeringAddresses {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/virtual_network_gateway#apipa_addresses VirtualNetworkGateway#apipa_addresses}
    */
    readonly apipaAddresses?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/virtual_network_gateway#ip_configuration_name VirtualNetworkGateway#ip_configuration_name}
    */
    readonly ipConfigurationName?: string;
}
export declare function virtualNetworkGatewayBgpSettingsPeeringAddressesToTerraform(struct?: VirtualNetworkGatewayBgpSettingsPeeringAddresses | cdktf.IResolvable): any;
export declare class VirtualNetworkGatewayBgpSettingsPeeringAddressesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): VirtualNetworkGatewayBgpSettingsPeeringAddresses | cdktf.IResolvable | undefined;
    set internalValue(value: VirtualNetworkGatewayBgpSettingsPeeringAddresses | cdktf.IResolvable | undefined);
    private _apipaAddresses?;
    get apipaAddresses(): string[];
    set apipaAddresses(value: string[]);
    resetApipaAddresses(): void;
    get apipaAddressesInput(): string[] | undefined;
    get defaultAddresses(): string[];
    private _ipConfigurationName?;
    get ipConfigurationName(): string;
    set ipConfigurationName(value: string);
    resetIpConfigurationName(): void;
    get ipConfigurationNameInput(): string | undefined;
    get tunnelIpAddresses(): string[];
}
export declare class VirtualNetworkGatewayBgpSettingsPeeringAddressesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: VirtualNetworkGatewayBgpSettingsPeeringAddresses[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): VirtualNetworkGatewayBgpSettingsPeeringAddressesOutputReference;
}
export interface VirtualNetworkGatewayBgpSettings {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/virtual_network_gateway#asn VirtualNetworkGateway#asn}
    */
    readonly asn?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/virtual_network_gateway#peer_weight VirtualNetworkGateway#peer_weight}
    */
    readonly peerWeight?: number;
    /**
    * peering_addresses block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/virtual_network_gateway#peering_addresses VirtualNetworkGateway#peering_addresses}
    */
    readonly peeringAddresses?: VirtualNetworkGatewayBgpSettingsPeeringAddresses[] | cdktf.IResolvable;
}
export declare function virtualNetworkGatewayBgpSettingsToTerraform(struct?: VirtualNetworkGatewayBgpSettingsOutputReference | VirtualNetworkGatewayBgpSettings): any;
export declare class VirtualNetworkGatewayBgpSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): VirtualNetworkGatewayBgpSettings | undefined;
    set internalValue(value: VirtualNetworkGatewayBgpSettings | undefined);
    private _asn?;
    get asn(): number;
    set asn(value: number);
    resetAsn(): void;
    get asnInput(): number | undefined;
    private _peerWeight?;
    get peerWeight(): number;
    set peerWeight(value: number);
    resetPeerWeight(): void;
    get peerWeightInput(): number | undefined;
    private _peeringAddresses;
    get peeringAddresses(): VirtualNetworkGatewayBgpSettingsPeeringAddressesList;
    putPeeringAddresses(value: VirtualNetworkGatewayBgpSettingsPeeringAddresses[] | cdktf.IResolvable): void;
    resetPeeringAddresses(): void;
    get peeringAddressesInput(): cdktf.IResolvable | VirtualNetworkGatewayBgpSettingsPeeringAddresses[] | undefined;
}
export interface VirtualNetworkGatewayCustomRoute {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/virtual_network_gateway#address_prefixes VirtualNetworkGateway#address_prefixes}
    */
    readonly addressPrefixes?: string[];
}
export declare function virtualNetworkGatewayCustomRouteToTerraform(struct?: VirtualNetworkGatewayCustomRouteOutputReference | VirtualNetworkGatewayCustomRoute): any;
export declare class VirtualNetworkGatewayCustomRouteOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): VirtualNetworkGatewayCustomRoute | undefined;
    set internalValue(value: VirtualNetworkGatewayCustomRoute | undefined);
    private _addressPrefixes?;
    get addressPrefixes(): string[];
    set addressPrefixes(value: string[]);
    resetAddressPrefixes(): void;
    get addressPrefixesInput(): string[] | undefined;
}
export interface VirtualNetworkGatewayIpConfiguration {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/virtual_network_gateway#name VirtualNetworkGateway#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/virtual_network_gateway#private_ip_address_allocation VirtualNetworkGateway#private_ip_address_allocation}
    */
    readonly privateIpAddressAllocation?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/virtual_network_gateway#public_ip_address_id VirtualNetworkGateway#public_ip_address_id}
    */
    readonly publicIpAddressId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/virtual_network_gateway#subnet_id VirtualNetworkGateway#subnet_id}
    */
    readonly subnetId: string;
}
export declare function virtualNetworkGatewayIpConfigurationToTerraform(struct?: VirtualNetworkGatewayIpConfiguration | cdktf.IResolvable): any;
export declare class VirtualNetworkGatewayIpConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): VirtualNetworkGatewayIpConfiguration | cdktf.IResolvable | undefined;
    set internalValue(value: VirtualNetworkGatewayIpConfiguration | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _privateIpAddressAllocation?;
    get privateIpAddressAllocation(): string;
    set privateIpAddressAllocation(value: string);
    resetPrivateIpAddressAllocation(): void;
    get privateIpAddressAllocationInput(): string | undefined;
    private _publicIpAddressId?;
    get publicIpAddressId(): string;
    set publicIpAddressId(value: string);
    get publicIpAddressIdInput(): string | undefined;
    private _subnetId?;
    get subnetId(): string;
    set subnetId(value: string);
    get subnetIdInput(): string | undefined;
}
export declare class VirtualNetworkGatewayIpConfigurationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: VirtualNetworkGatewayIpConfiguration[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): VirtualNetworkGatewayIpConfigurationOutputReference;
}
export interface VirtualNetworkGatewayTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/virtual_network_gateway#create VirtualNetworkGateway#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/virtual_network_gateway#delete VirtualNetworkGateway#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/virtual_network_gateway#read VirtualNetworkGateway#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/virtual_network_gateway#update VirtualNetworkGateway#update}
    */
    readonly update?: string;
}
export declare function virtualNetworkGatewayTimeoutsToTerraform(struct?: VirtualNetworkGatewayTimeouts | cdktf.IResolvable): any;
export declare class VirtualNetworkGatewayTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): VirtualNetworkGatewayTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: VirtualNetworkGatewayTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface VirtualNetworkGatewayVpnClientConfigurationRevokedCertificate {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/virtual_network_gateway#name VirtualNetworkGateway#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/virtual_network_gateway#thumbprint VirtualNetworkGateway#thumbprint}
    */
    readonly thumbprint: string;
}
export declare function virtualNetworkGatewayVpnClientConfigurationRevokedCertificateToTerraform(struct?: VirtualNetworkGatewayVpnClientConfigurationRevokedCertificate | cdktf.IResolvable): any;
export declare class VirtualNetworkGatewayVpnClientConfigurationRevokedCertificateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): VirtualNetworkGatewayVpnClientConfigurationRevokedCertificate | cdktf.IResolvable | undefined;
    set internalValue(value: VirtualNetworkGatewayVpnClientConfigurationRevokedCertificate | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _thumbprint?;
    get thumbprint(): string;
    set thumbprint(value: string);
    get thumbprintInput(): string | undefined;
}
export declare class VirtualNetworkGatewayVpnClientConfigurationRevokedCertificateList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: VirtualNetworkGatewayVpnClientConfigurationRevokedCertificate[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): VirtualNetworkGatewayVpnClientConfigurationRevokedCertificateOutputReference;
}
export interface VirtualNetworkGatewayVpnClientConfigurationRootCertificate {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/virtual_network_gateway#name VirtualNetworkGateway#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/virtual_network_gateway#public_cert_data VirtualNetworkGateway#public_cert_data}
    */
    readonly publicCertData: string;
}
export declare function virtualNetworkGatewayVpnClientConfigurationRootCertificateToTerraform(struct?: VirtualNetworkGatewayVpnClientConfigurationRootCertificate | cdktf.IResolvable): any;
export declare class VirtualNetworkGatewayVpnClientConfigurationRootCertificateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): VirtualNetworkGatewayVpnClientConfigurationRootCertificate | cdktf.IResolvable | undefined;
    set internalValue(value: VirtualNetworkGatewayVpnClientConfigurationRootCertificate | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _publicCertData?;
    get publicCertData(): string;
    set publicCertData(value: string);
    get publicCertDataInput(): string | undefined;
}
export declare class VirtualNetworkGatewayVpnClientConfigurationRootCertificateList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: VirtualNetworkGatewayVpnClientConfigurationRootCertificate[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): VirtualNetworkGatewayVpnClientConfigurationRootCertificateOutputReference;
}
export interface VirtualNetworkGatewayVpnClientConfiguration {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/virtual_network_gateway#aad_audience VirtualNetworkGateway#aad_audience}
    */
    readonly aadAudience?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/virtual_network_gateway#aad_issuer VirtualNetworkGateway#aad_issuer}
    */
    readonly aadIssuer?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/virtual_network_gateway#aad_tenant VirtualNetworkGateway#aad_tenant}
    */
    readonly aadTenant?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/virtual_network_gateway#address_space VirtualNetworkGateway#address_space}
    */
    readonly addressSpace: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/virtual_network_gateway#radius_server_address VirtualNetworkGateway#radius_server_address}
    */
    readonly radiusServerAddress?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/virtual_network_gateway#radius_server_secret VirtualNetworkGateway#radius_server_secret}
    */
    readonly radiusServerSecret?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/virtual_network_gateway#vpn_auth_types VirtualNetworkGateway#vpn_auth_types}
    */
    readonly vpnAuthTypes?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/virtual_network_gateway#vpn_client_protocols VirtualNetworkGateway#vpn_client_protocols}
    */
    readonly vpnClientProtocols?: string[];
    /**
    * revoked_certificate block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/virtual_network_gateway#revoked_certificate VirtualNetworkGateway#revoked_certificate}
    */
    readonly revokedCertificate?: VirtualNetworkGatewayVpnClientConfigurationRevokedCertificate[] | cdktf.IResolvable;
    /**
    * root_certificate block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/virtual_network_gateway#root_certificate VirtualNetworkGateway#root_certificate}
    */
    readonly rootCertificate?: VirtualNetworkGatewayVpnClientConfigurationRootCertificate[] | cdktf.IResolvable;
}
export declare function virtualNetworkGatewayVpnClientConfigurationToTerraform(struct?: VirtualNetworkGatewayVpnClientConfigurationOutputReference | VirtualNetworkGatewayVpnClientConfiguration): any;
export declare class VirtualNetworkGatewayVpnClientConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): VirtualNetworkGatewayVpnClientConfiguration | undefined;
    set internalValue(value: VirtualNetworkGatewayVpnClientConfiguration | undefined);
    private _aadAudience?;
    get aadAudience(): string;
    set aadAudience(value: string);
    resetAadAudience(): void;
    get aadAudienceInput(): string | undefined;
    private _aadIssuer?;
    get aadIssuer(): string;
    set aadIssuer(value: string);
    resetAadIssuer(): void;
    get aadIssuerInput(): string | undefined;
    private _aadTenant?;
    get aadTenant(): string;
    set aadTenant(value: string);
    resetAadTenant(): void;
    get aadTenantInput(): string | undefined;
    private _addressSpace?;
    get addressSpace(): string[];
    set addressSpace(value: string[]);
    get addressSpaceInput(): string[] | undefined;
    private _radiusServerAddress?;
    get radiusServerAddress(): string;
    set radiusServerAddress(value: string);
    resetRadiusServerAddress(): void;
    get radiusServerAddressInput(): string | undefined;
    private _radiusServerSecret?;
    get radiusServerSecret(): string;
    set radiusServerSecret(value: string);
    resetRadiusServerSecret(): void;
    get radiusServerSecretInput(): string | undefined;
    private _vpnAuthTypes?;
    get vpnAuthTypes(): string[];
    set vpnAuthTypes(value: string[]);
    resetVpnAuthTypes(): void;
    get vpnAuthTypesInput(): string[] | undefined;
    private _vpnClientProtocols?;
    get vpnClientProtocols(): string[];
    set vpnClientProtocols(value: string[]);
    resetVpnClientProtocols(): void;
    get vpnClientProtocolsInput(): string[] | undefined;
    private _revokedCertificate;
    get revokedCertificate(): VirtualNetworkGatewayVpnClientConfigurationRevokedCertificateList;
    putRevokedCertificate(value: VirtualNetworkGatewayVpnClientConfigurationRevokedCertificate[] | cdktf.IResolvable): void;
    resetRevokedCertificate(): void;
    get revokedCertificateInput(): cdktf.IResolvable | VirtualNetworkGatewayVpnClientConfigurationRevokedCertificate[] | undefined;
    private _rootCertificate;
    get rootCertificate(): VirtualNetworkGatewayVpnClientConfigurationRootCertificateList;
    putRootCertificate(value: VirtualNetworkGatewayVpnClientConfigurationRootCertificate[] | cdktf.IResolvable): void;
    resetRootCertificate(): void;
    get rootCertificateInput(): cdktf.IResolvable | VirtualNetworkGatewayVpnClientConfigurationRootCertificate[] | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/virtual_network_gateway azurerm_virtual_network_gateway}
*/
export declare class VirtualNetworkGateway extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_virtual_network_gateway";
    /**
    * Generates CDKTF code for importing a VirtualNetworkGateway resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the VirtualNetworkGateway to import
    * @param importFromId The id of the existing VirtualNetworkGateway that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/virtual_network_gateway#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the VirtualNetworkGateway to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.82.0/docs/resources/virtual_network_gateway azurerm_virtual_network_gateway} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options VirtualNetworkGatewayConfig
    */
    constructor(scope: Construct, id: string, config: VirtualNetworkGatewayConfig);
    private _activeActive?;
    get activeActive(): boolean | cdktf.IResolvable;
    set activeActive(value: boolean | cdktf.IResolvable);
    resetActiveActive(): void;
    get activeActiveInput(): boolean | cdktf.IResolvable | undefined;
    private _defaultLocalNetworkGatewayId?;
    get defaultLocalNetworkGatewayId(): string;
    set defaultLocalNetworkGatewayId(value: string);
    resetDefaultLocalNetworkGatewayId(): void;
    get defaultLocalNetworkGatewayIdInput(): string | undefined;
    private _edgeZone?;
    get edgeZone(): string;
    set edgeZone(value: string);
    resetEdgeZone(): void;
    get edgeZoneInput(): string | undefined;
    private _enableBgp?;
    get enableBgp(): boolean | cdktf.IResolvable;
    set enableBgp(value: boolean | cdktf.IResolvable);
    resetEnableBgp(): void;
    get enableBgpInput(): boolean | cdktf.IResolvable | undefined;
    private _generation?;
    get generation(): string;
    set generation(value: string);
    resetGeneration(): void;
    get generationInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _privateIpAddressEnabled?;
    get privateIpAddressEnabled(): boolean | cdktf.IResolvable;
    set privateIpAddressEnabled(value: boolean | cdktf.IResolvable);
    resetPrivateIpAddressEnabled(): void;
    get privateIpAddressEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _sku?;
    get sku(): string;
    set sku(value: string);
    get skuInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _vpnType?;
    get vpnType(): string;
    set vpnType(value: string);
    resetVpnType(): void;
    get vpnTypeInput(): string | undefined;
    private _bgpSettings;
    get bgpSettings(): VirtualNetworkGatewayBgpSettingsOutputReference;
    putBgpSettings(value: VirtualNetworkGatewayBgpSettings): void;
    resetBgpSettings(): void;
    get bgpSettingsInput(): VirtualNetworkGatewayBgpSettings | undefined;
    private _customRoute;
    get customRoute(): VirtualNetworkGatewayCustomRouteOutputReference;
    putCustomRoute(value: VirtualNetworkGatewayCustomRoute): void;
    resetCustomRoute(): void;
    get customRouteInput(): VirtualNetworkGatewayCustomRoute | undefined;
    private _ipConfiguration;
    get ipConfiguration(): VirtualNetworkGatewayIpConfigurationList;
    putIpConfiguration(value: VirtualNetworkGatewayIpConfiguration[] | cdktf.IResolvable): void;
    get ipConfigurationInput(): cdktf.IResolvable | VirtualNetworkGatewayIpConfiguration[] | undefined;
    private _timeouts;
    get timeouts(): VirtualNetworkGatewayTimeoutsOutputReference;
    putTimeouts(value: VirtualNetworkGatewayTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | VirtualNetworkGatewayTimeouts | undefined;
    private _vpnClientConfiguration;
    get vpnClientConfiguration(): VirtualNetworkGatewayVpnClientConfigurationOutputReference;
    putVpnClientConfiguration(value: VirtualNetworkGatewayVpnClientConfiguration): void;
    resetVpnClientConfiguration(): void;
    get vpnClientConfigurationInput(): VirtualNetworkGatewayVpnClientConfiguration | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
