import numpy as np
import os
import pinocchio as pin
from . import core as jiminy
from .dynamics import TrajectoryDataType as TrajectoryDataType
from .log import build_robot_from_log as build_robot_from_log, read_log as read_log
from .plot import TabbedFigure as TabbedFigure
from .robot import BaseJiminyRobot as BaseJiminyRobot, generate_default_hardware_description_file as generate_default_hardware_description_file
from .viewer import CameraPoseType as CameraPoseType, Viewer as Viewer, extract_replay_data_from_log as extract_replay_data_from_log, get_default_backend as get_default_backend, interactive_mode as interactive_mode, play_trajectories as play_trajectories
from _typeshed import Incomplete
from typing import Any, Dict, Iterable, Optional, Sequence, Type, Union

LOGGER: Incomplete
DEFAULT_UPDATE_PERIOD: float
DEFAULT_GROUND_STIFFNESS: float
DEFAULT_GROUND_DAMPING: float

class Simulator:
    use_theoretical_model: Incomplete
    viewer_kwargs: Incomplete
    engine: Incomplete
    stepper_state: Incomplete
    is_simulation_running: Incomplete
    viewer: Incomplete
    def __init__(self, robot: jiminy.Robot, controller: Optional[jiminy.AbstractController] = None, engine_class: Type[jiminy.Engine] = ..., use_theoretical_model: bool = False, viewer_kwargs: Optional[Dict[str, Any]] = None, **kwargs: Any) -> None: ...
    @classmethod
    def build(cls, urdf_path: str, hardware_path: Optional[str] = None, mesh_path_dir: Optional[str] = None, has_freeflyer: bool = True, config_path: Optional[str] = None, avoid_instable_collisions: bool = True, debug: bool = False, **kwargs: Any) -> Simulator: ...
    def __del__(self) -> None: ...
    def __getattr__(self, name: str) -> Any: ...
    def __dir__(self) -> Iterable[str]: ...
    @property
    def pinocchio_model(self) -> pin.Model: ...
    @property
    def pinocchio_data(self) -> pin.Data: ...
    @property
    def is_viewer_available(self) -> bool: ...
    def seed(self, seed: Union[np.uint32, np.ndarray]) -> None: ...
    def reset(self, remove_all_forces: bool = False) -> None: ...
    def start(self, q_init: np.ndarray, v_init: np.ndarray, a_init: Optional[np.ndarray] = None, is_state_theoretical: bool = False) -> None: ...
    def step(self, step_dt: float = -1) -> None: ...
    def simulate(self, t_end: float, q_init: np.ndarray, v_init: np.ndarray, a_init: Optional[np.ndarray] = None, is_state_theoretical: bool = True, log_path: Optional[str] = None, show_progress_bar: bool = True) -> None: ...
    def render(self, return_rgb_array: bool = False, width: Optional[int] = None, height: Optional[int] = None, camera_pose: Optional[CameraPoseType] = None, update_ground_profile: Optional[bool] = None, **kwargs: Any) -> Optional[np.ndarray]: ...
    def replay(self, extra_logs_files: Sequence[Dict[str, np.ndarray]] = (), extra_trajectories: Sequence[TrajectoryDataType] = (), **kwargs: Any) -> None: ...
    def close(self) -> None: ...
    def plot(self, enable_flexiblity_data: bool = False, block: Optional[bool] = None, **kwargs: Any) -> TabbedFigure: ...
    def get_controller_options(self) -> dict: ...
    def set_controller_options(self, options: dict) -> None: ...
    def get_options(self) -> Dict[str, Dict[str, Dict[str, Any]]]: ...
    def set_options(self, options: Dict[str, Dict[str, Dict[str, Any]]]) -> None: ...
    def export_options(self, config_path: Optional[Union[str, os.PathLike]] = None) -> None: ...
    def import_options(self, config_path: Optional[Union[str, os.PathLike]] = None) -> None: ...
