from benchling_api_client.v2.beta.api.apps import (
    get_app_configuration_by_app_id,
    get_benchling_app_manifest,
    put_benchling_app_manifest,
)
from benchling_api_client.v2.beta.models.benchling_app_configuration import BenchlingAppConfiguration
from benchling_api_client.v2.beta.models.benchling_app_manifest import BenchlingAppManifest

from benchling_sdk.helpers.decorators import api_method
from benchling_sdk.helpers.logging_helpers import log_deprecation
from benchling_sdk.helpers.response_helpers import model_from_detailed
from benchling_sdk.services.v2.base_service import BaseService


class V2BetaAppService(BaseService):
    """
    V2-Beta Apps.

    Create and manage Apps on your tenant.

    https://benchling.com/api/v2-beta/reference?stability=not-available#/Apps
    """

    @api_method
    def get_configuration_by_app_id(self, app_id: str) -> BenchlingAppConfiguration:
        """
        Get an app's configuration by app id.

        See https://benchling.com/api/v2-beta/reference?stability=la#/Apps/getAppConfigurationByAppID

        Deprecated in favor of apps.list_app_configuration_items.
        """
        log_deprecation("v2.beta.apps.get_configuration_by_app_id", "apps.list_app_configuration_items")
        response = get_app_configuration_by_app_id.sync_detailed(client=self.client, app_id=app_id)
        return model_from_detailed(response)

    @api_method
    def get_manifest(self, app_id: str) -> BenchlingAppManifest:
        """
        Get app manifest.

        See https://benchling.com/api/v2-beta/reference#/Apps/getBenchlingAppManifest
        """
        response = get_benchling_app_manifest.sync_detailed(client=self.client, app_id=app_id)
        return model_from_detailed(response)

    @api_method
    def update_manifest(self, app_id: str, manifest: BenchlingAppManifest) -> BenchlingAppManifest:
        """
        Update an app manifest.

        See https://benchling.com/api/v2-beta/reference#/Apps/putBenchlingAppManifest
        """
        response = put_benchling_app_manifest.sync_detailed(
            client=self.client, app_id=app_id, yaml_body=manifest
        )
        return model_from_detailed(response)
