from pumpia.file_handling.dicom_tags import Tag, TagLink

class DicomTags():
    """Class containing all DICOM Tags as class attributes."""
    LengthToEnd = Tag('Length to End', "LengthToEnd", 0x0008, 0x0001)
    InventoriedStudiesSequence = Tag('Inventoried Studies Sequence', "InventoriedStudiesSequence", 0x0008, 0x0423)
    InventoriedSeriesSequence = Tag('Inventoried Series Sequence', "InventoriedSeriesSequence", 0x0008, 0x0424, [TagLink(InventoriedStudiesSequence),])
    InventoriedInstancesSequence = Tag('Inventoried Instances Sequence', "InventoriedInstancesSequence", 0x0008, 0x0425, [TagLink(InventoriedSeriesSequence),])
    ScopeOfInventorySequence = Tag('Scope of Inventory Sequence', "ScopeOfInventorySequence", 0x0008, 0x0400)
    SpecificCharacterSet = Tag('Specific Character Set', "SpecificCharacterSet", 0x0008, 0x0005, [TagLink(InventoriedStudiesSequence),TagLink(InventoriedSeriesSequence),TagLink(InventoriedInstancesSequence),TagLink(ScopeOfInventorySequence),])
    AlternateContentDescriptionSequence = Tag('Alternate Content Description Sequence', "AlternateContentDescriptionSequence", 0x0070, 0x0087)
    LanguageCodeSequence = Tag('Language Code Sequence', "LanguageCodeSequence", 0x0008, 0x0006, [TagLink(AlternateContentDescriptionSequence),])
    ImageType = Tag('Image Type', "ImageType", 0x0008, 0x0008)
    RecognitionCode = Tag('Recognition Code', "RecognitionCode", 0x0008, 0x0010)
    InstanceCreationDate = Tag('Instance Creation Date', "InstanceCreationDate", 0x0008, 0x0012)
    InstanceCreationTime = Tag('Instance Creation Time', "InstanceCreationTime", 0x0008, 0x0013)
    InstanceCreatorUID = Tag('Instance Creator UID', "InstanceCreatorUID", 0x0008, 0x0014)
    InstanceCoercionDateTime = Tag('Instance Coercion DateTime', "InstanceCoercionDateTime", 0x0008, 0x0015)
    AlternateRepresentationSequence = Tag('Alternate Representation Sequence', "AlternateRepresentationSequence", 0x0008, 0x3001, [TagLink(InventoriedInstancesSequence),])
    SOPClassUID = Tag('SOP Class UID', "SOPClassUID", 0x0008, 0x0016, [TagLink(InventoriedInstancesSequence),TagLink(AlternateRepresentationSequence),])
    AcquisitionUID = Tag('Acquisition UID', "AcquisitionUID", 0x0008, 0x0017)
    SOPInstanceUID = Tag('SOP Instance UID', "SOPInstanceUID", 0x0008, 0x0018, [TagLink(InventoriedInstancesSequence),TagLink(AlternateRepresentationSequence),])
    PyramidUID = Tag('Pyramid UID', "PyramidUID", 0x0008, 0x0019)
    RelatedGeneralSOPClassUID = Tag('Related General SOP Class UID', "RelatedGeneralSOPClassUID", 0x0008, 0x001A, [TagLink(InventoriedInstancesSequence),])
    OriginalSpecializedSOPClassUID = Tag('Original Specialized SOP Class UID', "OriginalSpecializedSOPClassUID", 0x0008, 0x001B)
    SyntheticData = Tag('Synthetic Data', "SyntheticData", 0x0008, 0x001C)
    StudyDate = Tag('Study Date', "StudyDate", 0x0008, 0x0020, [TagLink(InventoriedStudiesSequence),])
    SourceSeriesInformationSequence = Tag('Source Series Information Sequence', "SourceSeriesInformationSequence", 0x3006, 0x004C)
    SeriesDate = Tag('Series Date', "SeriesDate", 0x0008, 0x0021, [TagLink(SourceSeriesInformationSequence),TagLink(InventoriedSeriesSequence),])
    AcquisitionDate = Tag('Acquisition Date', "AcquisitionDate", 0x0008, 0x0022)
    ContentDate = Tag('Content Date', "ContentDate", 0x0008, 0x0023, [TagLink(InventoriedInstancesSequence),])
    OverlayDate = Tag('Overlay Date', "OverlayDate", 0x0008, 0x0024)
    CurveDate = Tag('Curve Date', "CurveDate", 0x0008, 0x0025)
    ContributingSourcesSequence = Tag('Contributing Sources Sequence', "ContributingSourcesSequence", 0x0018, 0x9506)
    AcquisitionDateTime = Tag('Acquisition DateTime', "AcquisitionDateTime", 0x0008, 0x002A, [TagLink(ContributingSourcesSequence),])
    StudyTime = Tag('Study Time', "StudyTime", 0x0008, 0x0030, [TagLink(InventoriedStudiesSequence),])
    SeriesTime = Tag('Series Time', "SeriesTime", 0x0008, 0x0031, [TagLink(SourceSeriesInformationSequence),TagLink(InventoriedSeriesSequence),])
    AcquisitionTime = Tag('Acquisition Time', "AcquisitionTime", 0x0008, 0x0032)
    ContentTime = Tag('Content Time', "ContentTime", 0x0008, 0x0033, [TagLink(InventoriedInstancesSequence),])
    OverlayTime = Tag('Overlay Time', "OverlayTime", 0x0008, 0x0034)
    CurveTime = Tag('Curve Time', "CurveTime", 0x0008, 0x0035)
    DataSetType = Tag('Data Set Type', "DataSetType", 0x0008, 0x0040)
    DataSetSubtype = Tag('Data Set Subtype', "DataSetSubtype", 0x0008, 0x0041)
    NuclearMedicineSeriesType = Tag('Nuclear Medicine Series Type', "NuclearMedicineSeriesType", 0x0008, 0x0042)
    RequestAttributesSequence = Tag('Request Attributes Sequence', "RequestAttributesSequence", 0x0040, 0x0275, [TagLink(InventoriedSeriesSequence),])
    ReferencedRequestSequence = Tag('Referenced Request Sequence', "ReferencedRequestSequence", 0x0040, 0xA370, [TagLink(InventoriedInstancesSequence),])
    AccessionNumber = Tag('Accession Number', "AccessionNumber", 0x0008, 0x0050, [TagLink(RequestAttributesSequence),TagLink(ReferencedRequestSequence),TagLink(InventoriedStudiesSequence),])
    IssuerOfAccessionNumberSequence = Tag('Issuer of Accession Number Sequence', "IssuerOfAccessionNumberSequence", 0x0008, 0x0051, [TagLink(RequestAttributesSequence),TagLink(ReferencedRequestSequence),TagLink(InventoriedStudiesSequence),])
    QueryRetrieveLevel = Tag('Query/Retrieve Level', "QueryRetrieveLevel", 0x0008, 0x0052, [TagLink(ScopeOfInventorySequence),])
    QueryRetrieveView = Tag('Query/Retrieve View', "QueryRetrieveView", 0x0008, 0x0053)
    ReferencedPatientPhotoSequence = Tag('Referenced Patient Photo Sequence', "ReferencedPatientPhotoSequence", 0x0010, 0x1100)
    DICOMRetrievalSequence = Tag('DICOM Retrieval Sequence', "DICOMRetrievalSequence", 0x0040, 0xE021, [TagLink(ReferencedPatientPhotoSequence),])
    RetrieveAETitle = Tag('Retrieve AE Title', "RetrieveAETitle", 0x0008, 0x0054, [TagLink(DICOMRetrievalSequence),TagLink(InventoriedStudiesSequence),])
    AssessmentRequesterSequence = Tag('Assessment Requester Sequence', "AssessmentRequesterSequence", 0x0082, 0x0017)
    AuthorIdentificationSequence = Tag('Author Identification Sequence', "AuthorIdentificationSequence", 0x3010, 0x0019)
    TreatmentSessionBeamSequence = Tag('Treatment Session Beam Sequence', "TreatmentSessionBeamSequence", 0x3008, 0x0020)
    ControlPointDeliverySequence = Tag('Control Point Delivery Sequence', "ControlPointDeliverySequence", 0x3008, 0x0040, [TagLink(TreatmentSessionBeamSequence),])
    TreatmentSessionApplicationSetupSequence = Tag('Treatment Session Application Setup Sequence', "TreatmentSessionApplicationSetupSequence", 0x3008, 0x0110)
    RecordedChannelSequence = Tag('Recorded Channel Sequence', "RecordedChannelSequence", 0x3008, 0x0130, [TagLink(TreatmentSessionApplicationSetupSequence),])
    BrachyControlPointDeliveredSequence = Tag('Brachy Control Point Delivered Sequence', "BrachyControlPointDeliveredSequence", 0x3008, 0x0160, [TagLink(RecordedChannelSequence),])
    PulseSpecificBrachyControlPointDeliveredSequence = Tag('Pulse Specific Brachy Control Point Delivered Sequence', "PulseSpecificBrachyControlPointDeliveredSequence", 0x3008, 0x0171, [TagLink(RecordedChannelSequence),])
    BrachyPulseControlPointDeliveredSequence = Tag('Brachy Pulse Control Point Delivered Sequence', "BrachyPulseControlPointDeliveredSequence", 0x3008, 0x0173, [TagLink(PulseSpecificBrachyControlPointDeliveredSequence),])
    TreatmentSessionIonBeamSequence = Tag('Treatment Session Ion Beam Sequence', "TreatmentSessionIonBeamSequence", 0x3008, 0x0021)
    IonControlPointDeliverySequence = Tag('Ion Control Point Delivery Sequence', "IonControlPointDeliverySequence", 0x3008, 0x0041, [TagLink(TreatmentSessionIonBeamSequence),])
    TreatmentToleranceViolationSequence = Tag('Treatment Tolerance Violation Sequence', "TreatmentToleranceViolationSequence", 0x300A, 0x0731)
    OverrideSequence = Tag('Override Sequence', "OverrideSequence", 0x3008, 0x0060, [TagLink(ControlPointDeliverySequence),TagLink(BrachyControlPointDeliveredSequence),TagLink(BrachyPulseControlPointDeliveredSequence),TagLink(IonControlPointDeliverySequence),TagLink(TreatmentToleranceViolationSequence),])
    ContributingEquipmentSequence = Tag('Contributing Equipment Sequence', "ContributingEquipmentSequence", 0x0018, 0xA001)
    OperatorIdentificationSequence = Tag('Operator Identification Sequence', "OperatorIdentificationSequence", 0x0008, 0x1072, [TagLink(OverrideSequence),TagLink(ContributingSourcesSequence),TagLink(ContributingEquipmentSequence),])
    ApprovalSequence = Tag('Approval Sequence', "ApprovalSequence", 0x0044, 0x0100)
    ConfirmationSequence = Tag('Confirmation Sequence', "ConfirmationSequence", 0x300A, 0x073F)
    OmittedRadiationSequence = Tag('Omitted Radiation Sequence', "OmittedRadiationSequence", 0x300A, 0x0787)
    AsserterIdentificationSequence = Tag('Asserter Identification Sequence', "AsserterIdentificationSequence", 0x0044, 0x0103, [TagLink(ApprovalSequence),TagLink(ConfirmationSequence),TagLink(OmittedRadiationSequence),])
    StationAETitle = Tag('Station AE Title', "StationAETitle", 0x0008, 0x0055, [TagLink(AssessmentRequesterSequence),TagLink(AuthorIdentificationSequence),TagLink(OperatorIdentificationSequence),TagLink(AsserterIdentificationSequence),])
    InstanceAvailability = Tag('Instance Availability', "InstanceAvailability", 0x0008, 0x0056, [TagLink(InventoriedStudiesSequence),TagLink(InventoriedSeriesSequence),TagLink(InventoriedInstancesSequence),])
    FailedSOPInstanceUIDList = Tag('Failed SOP Instance UID List', "FailedSOPInstanceUIDList", 0x0008, 0x0058)
    HangingProtocolDefinitionSequence = Tag('Hanging Protocol Definition Sequence', "HangingProtocolDefinitionSequence", 0x0072, 0x000C)
    Modality = Tag('Modality', "Modality", 0x0008, 0x0060, [TagLink(SourceSeriesInformationSequence),TagLink(HangingProtocolDefinitionSequence),TagLink(InventoriedSeriesSequence),])
    ModalitiesInStudy = Tag('Modalities in Study', "ModalitiesInStudy", 0x0008, 0x0061, [TagLink(InventoriedStudiesSequence),])
    SOPClassesInStudy = Tag('SOP Classes in Study', "SOPClassesInStudy", 0x0008, 0x0062)
    AnatomicRegionsInStudyCodeSequence = Tag('Anatomic Regions in Study Code Sequence', "AnatomicRegionsInStudyCodeSequence", 0x0008, 0x0063, [TagLink(InventoriedStudiesSequence),])
    ConversionType = Tag('Conversion Type', "ConversionType", 0x0008, 0x0064)
    PresentationIntentType = Tag('Presentation Intent Type', "PresentationIntentType", 0x0008, 0x0068)
    DeviceSequence = Tag('Device Sequence', "DeviceSequence", 0x0050, 0x0010)
    ContainerComponentSequence = Tag('Container Component Sequence', "ContainerComponentSequence", 0x0040, 0x0520)
    PerFrameFunctionalGroupsSequence = Tag('Per-Frame Functional Groups Sequence', "PerFrameFunctionalGroupsSequence", 0x5200, 0x9230)
    RTImageFrameContextSequence = Tag('RT Image Frame Context Sequence', "RTImageFrameContextSequence", 0x3002, 0x0103, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    RTImageScopeSequence = Tag('RT Image Scope Sequence', "RTImageScopeSequence", 0x3002, 0x0104, [TagLink(RTImageFrameContextSequence),])
    RTPatientPositionScopeSequence = Tag('RT Patient Position Scope Sequence', "RTPatientPositionScopeSequence", 0x300A, 0x0784)
    AcquisitionTaskSequence = Tag('Acquisition Task Sequence', "AcquisitionTaskSequence", 0x3002, 0x0118)
    AcquisitionTaskApplicabilitySequence = Tag('Acquisition Task Applicability Sequence', "AcquisitionTaskApplicabilitySequence", 0x3002, 0x0124, [TagLink(AcquisitionTaskSequence),])
    ReferencedRTPlanSequence = Tag('Referenced RT Plan Sequence', "ReferencedRTPlanSequence", 0x300C, 0x0002, [TagLink(RTImageScopeSequence),TagLink(RTPatientPositionScopeSequence),TagLink(AcquisitionTaskApplicabilitySequence),])
    BeamSequence = Tag('Beam Sequence', "BeamSequence", 0x300A, 0x00B0, [TagLink(ReferencedRTPlanSequence),])
    TreatmentMachineSequence = Tag('Treatment Machine Sequence', "TreatmentMachineSequence", 0x300A, 0x0206)
    IonBeamSequence = Tag('Ion Beam Sequence', "IonBeamSequence", 0x300A, 0x03A2)
    ModelSpecificationSequence = Tag('Model Specification Sequence', "ModelSpecificationSequence", 0x0018, 0x9912)
    PatientSupportDevicesSequence = Tag('Patient Support Devices Sequence', "PatientSupportDevicesSequence", 0x300A, 0x0686)
    WedgeDefinitionSequence = Tag('Wedge Definition Sequence', "WedgeDefinitionSequence", 0x300A, 0x0651)
    CompensatorDefinitionSequence = Tag('Compensator Definition Sequence', "CompensatorDefinitionSequence", 0x300A, 0x0662)
    BlockDefinitionSequence = Tag('Block Definition Sequence', "BlockDefinitionSequence", 0x300A, 0x066A)
    RTAccessoryHolderDefinitionSequence = Tag('RT Accessory Holder Definition Sequence', "RTAccessoryHolderDefinitionSequence", 0x300A, 0x0614)
    GeneralAccessoryDefinitionSequence = Tag('General Accessory Definition Sequence', "GeneralAccessoryDefinitionSequence", 0x300A, 0x0671)
    BolusDefinitionSequence = Tag('Bolus Definition Sequence', "BolusDefinitionSequence", 0x300A, 0x0673)
    AcquisitionDeviceSequence = Tag('Acquisition Device Sequence', "AcquisitionDeviceSequence", 0x3002, 0x0117)
    PatientSetupSequence = Tag('Patient Setup Sequence', "PatientSetupSequence", 0x300A, 0x0180)
    PatientTreatmentPreparationSequence = Tag('Patient Treatment Preparation Sequence', "PatientTreatmentPreparationSequence", 0x300A, 0x079F, [TagLink(PatientSetupSequence),])
    PatientTreatmentPreparationProcedureSequence = Tag('Patient Treatment Preparation Procedure Sequence', "PatientTreatmentPreparationProcedureSequence", 0x300A, 0x0790, [TagLink(PatientTreatmentPreparationSequence),])
    PatientTreatmentPreparationDeviceSequence = Tag('Patient Treatment Preparation Device Sequence', "PatientTreatmentPreparationDeviceSequence", 0x300A, 0x078F, [TagLink(PatientTreatmentPreparationProcedureSequence),])
    RTSegmentAnnotationSequence = Tag('RT Segment Annotation Sequence', "RTSegmentAnnotationSequence", 0x3010, 0x002A)
    SegmentedRTAccessoryDeviceSequence = Tag('Segmented RT Accessory Device Sequence', "SegmentedRTAccessoryDeviceSequence", 0x3010, 0x0026, [TagLink(RTSegmentAnnotationSequence),])
    TreatmentDeviceIdentificationSequence = Tag('Treatment Device Identification Sequence', "TreatmentDeviceIdentificationSequence", 0x300A, 0x063A)
    Manufacturer = Tag('Manufacturer', "Manufacturer", 0x0008, 0x0070, [TagLink(DeviceSequence),TagLink(ContainerComponentSequence),TagLink(BeamSequence),TagLink(TreatmentMachineSequence),TagLink(IonBeamSequence),TagLink(ContributingSourcesSequence),TagLink(ContributingEquipmentSequence),TagLink(AssessmentRequesterSequence),TagLink(ModelSpecificationSequence),TagLink(PatientSupportDevicesSequence),TagLink(WedgeDefinitionSequence),TagLink(CompensatorDefinitionSequence),TagLink(BlockDefinitionSequence),TagLink(RTAccessoryHolderDefinitionSequence),TagLink(GeneralAccessoryDefinitionSequence),TagLink(BolusDefinitionSequence),TagLink(AcquisitionDeviceSequence),TagLink(PatientTreatmentPreparationDeviceSequence),TagLink(AuthorIdentificationSequence),TagLink(SegmentedRTAccessoryDeviceSequence),TagLink(TreatmentDeviceIdentificationSequence),TagLink(OperatorIdentificationSequence),TagLink(AsserterIdentificationSequence),])
    SegmentSequence = Tag('Segment Sequence', "SegmentSequence", 0x0062, 0x0002)
    ContentCreatorIdentificationCodeSequence = Tag("Content Creator's Identification Code Sequence", "ContentCreatorIdentificationCodeSequence", 0x0070, 0x0086, [TagLink(SegmentSequence),])
    ReferringPhysicianIdentificationSequence = Tag('Referring Physician Identification Sequence', "ReferringPhysicianIdentificationSequence", 0x0008, 0x0096, [TagLink(InventoriedStudiesSequence),])
    ConsultingPhysicianIdentificationSequence = Tag('Consulting Physician Identification Sequence', "ConsultingPhysicianIdentificationSequence", 0x0008, 0x009D, [TagLink(InventoriedStudiesSequence),])
    PhysiciansOfRecordIdentificationSequence = Tag('Physician(s) of Record Identification Sequence', "PhysiciansOfRecordIdentificationSequence", 0x0008, 0x1049, [TagLink(InventoriedStudiesSequence),])
    PhysiciansReadingStudyIdentificationSequence = Tag('Physician(s) Reading Study Identification Sequence', "PhysiciansReadingStudyIdentificationSequence", 0x0008, 0x1062, [TagLink(InventoriedStudiesSequence),])
    PerformingPhysicianIdentificationSequence = Tag('Performing Physician Identification Sequence', "PerformingPhysicianIdentificationSequence", 0x0008, 0x1052)
    CustodialOrganizationSequence = Tag('Custodial Organization Sequence', "CustodialOrganizationSequence", 0x0040, 0xA07C)
    InterlockSequence = Tag('Interlock Sequence', "InterlockSequence", 0x300A, 0x0740, [TagLink(TreatmentSessionBeamSequence),TagLink(TreatmentSessionIonBeamSequence),])
    InterlockResolutionUserSequence = Tag('Interlock Resolution User Sequence', "InterlockResolutionUserSequence", 0x300A, 0x0746, [TagLink(InterlockSequence),])
    InstitutionName = Tag('Institution Name', "InstitutionName", 0x0008, 0x0080, [TagLink(ContentCreatorIdentificationCodeSequence),TagLink(OperatorIdentificationSequence),TagLink(ReferringPhysicianIdentificationSequence),TagLink(ConsultingPhysicianIdentificationSequence),TagLink(PhysiciansOfRecordIdentificationSequence),TagLink(PhysiciansReadingStudyIdentificationSequence),TagLink(PerformingPhysicianIdentificationSequence),TagLink(BeamSequence),TagLink(TreatmentMachineSequence),TagLink(IonBeamSequence),TagLink(ContributingEquipmentSequence),TagLink(CustodialOrganizationSequence),TagLink(AssessmentRequesterSequence),TagLink(InterlockResolutionUserSequence),TagLink(AuthorIdentificationSequence),TagLink(TreatmentDeviceIdentificationSequence),TagLink(AsserterIdentificationSequence),])
    InstitutionAddress = Tag('Institution Address', "InstitutionAddress", 0x0008, 0x0081, [TagLink(ContentCreatorIdentificationCodeSequence),TagLink(OperatorIdentificationSequence),TagLink(ReferringPhysicianIdentificationSequence),TagLink(ConsultingPhysicianIdentificationSequence),TagLink(PhysiciansOfRecordIdentificationSequence),TagLink(PhysiciansReadingStudyIdentificationSequence),TagLink(PerformingPhysicianIdentificationSequence),TagLink(BeamSequence),TagLink(TreatmentMachineSequence),TagLink(IonBeamSequence),TagLink(ContributingEquipmentSequence),TagLink(InterlockResolutionUserSequence),TagLink(TreatmentDeviceIdentificationSequence),])
    InstitutionCodeSequence = Tag('Institution Code Sequence', "InstitutionCodeSequence", 0x0008, 0x0082, [TagLink(ContentCreatorIdentificationCodeSequence),TagLink(OperatorIdentificationSequence),TagLink(ReferringPhysicianIdentificationSequence),TagLink(ConsultingPhysicianIdentificationSequence),TagLink(PhysiciansOfRecordIdentificationSequence),TagLink(PhysiciansReadingStudyIdentificationSequence),TagLink(PerformingPhysicianIdentificationSequence),TagLink(CustodialOrganizationSequence),TagLink(AssessmentRequesterSequence),TagLink(ApprovalSequence),TagLink(InterlockResolutionUserSequence),TagLink(AuthorIdentificationSequence),TagLink(AsserterIdentificationSequence),])
    ReferringPhysicianName = Tag("Referring Physician's Name", "ReferringPhysicianName", 0x0008, 0x0090, [TagLink(InventoriedStudiesSequence),])
    ReferringPhysicianAddress = Tag("Referring Physician's Address", "ReferringPhysicianAddress", 0x0008, 0x0092)
    ReferringPhysicianTelephoneNumbers = Tag("Referring Physician's Telephone Numbers", "ReferringPhysicianTelephoneNumbers", 0x0008, 0x0094)
    ConsultingPhysicianName = Tag("Consulting Physician's Name", "ConsultingPhysicianName", 0x0008, 0x009C, [TagLink(InventoriedStudiesSequence),])
    PersonIdentificationCodeSequence = Tag('Person Identification Code Sequence', "PersonIdentificationCodeSequence", 0x0040, 0x1101, [TagLink(ContentCreatorIdentificationCodeSequence),TagLink(OperatorIdentificationSequence),TagLink(ReferringPhysicianIdentificationSequence),TagLink(ConsultingPhysicianIdentificationSequence),TagLink(PhysiciansOfRecordIdentificationSequence),TagLink(PhysiciansReadingStudyIdentificationSequence),TagLink(PerformingPhysicianIdentificationSequence),TagLink(AssessmentRequesterSequence),TagLink(InterlockResolutionUserSequence),TagLink(AuthorIdentificationSequence),TagLink(AsserterIdentificationSequence),])
    InstitutionalDepartmentTypeCodeSequence = Tag('Institutional Department Type Code Sequence', "InstitutionalDepartmentTypeCodeSequence", 0x0008, 0x1041, [TagLink(ContentCreatorIdentificationCodeSequence),TagLink(OperatorIdentificationSequence),TagLink(ReferringPhysicianIdentificationSequence),TagLink(ConsultingPhysicianIdentificationSequence),TagLink(PhysiciansOfRecordIdentificationSequence),TagLink(PhysiciansReadingStudyIdentificationSequence),TagLink(PerformingPhysicianIdentificationSequence),TagLink(BeamSequence),TagLink(TreatmentMachineSequence),TagLink(IonBeamSequence),TagLink(ContributingEquipmentSequence),TagLink(AssessmentRequesterSequence),TagLink(InterlockResolutionUserSequence),TagLink(AuthorIdentificationSequence),TagLink(AsserterIdentificationSequence),])
    ScheduledProtocolCodeSequence = Tag('Scheduled Protocol Code Sequence', "ScheduledProtocolCodeSequence", 0x0040, 0x0008, [TagLink(RequestAttributesSequence),])
    PerformedProtocolCodeSequence = Tag('Performed Protocol Code Sequence', "PerformedProtocolCodeSequence", 0x0040, 0x0260, [TagLink(ContributingSourcesSequence),])
    ProtocolContextSequence = Tag('Protocol Context Sequence', "ProtocolContextSequence", 0x0040, 0x0440, [TagLink(ScheduledProtocolCodeSequence),TagLink(PerformedProtocolCodeSequence),])
    AcquisitionContextSequence = Tag('Acquisition Context Sequence', "AcquisitionContextSequence", 0x0040, 0x0555)
    ReferencedImageRealWorldValueMappingSequence = Tag('Referenced Image Real World Value Mapping Sequence', "ReferencedImageRealWorldValueMappingSequence", 0x0040, 0x9094)
    RealWorldValueMappingSequence = Tag('Real World Value Mapping Sequence', "RealWorldValueMappingSequence", 0x0040, 0x9096, [TagLink(ReferencedImageRealWorldValueMappingSequence),TagLink(PerFrameFunctionalGroupsSequence, True),])
    QuantityDefinitionSequence = Tag('Quantity Definition Sequence', "QuantityDefinitionSequence", 0x0040, 0x9220, [TagLink(RealWorldValueMappingSequence),TagLink(PerFrameFunctionalGroupsSequence, True),])
    MultienergyCTCharacteristicsSequence = Tag('Multi-energy CT Characteristics Sequence', "MultienergyCTCharacteristicsSequence", 0x0018, 0x9364, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    PerformedProcessingParametersSequence = Tag('Performed Processing Parameters Sequence', "PerformedProcessingParametersSequence", 0x0074, 0x1212, [TagLink(MultienergyCTCharacteristicsSequence),])
    PatientTreatmentPreparationProcedureParameterSequence = Tag('Patient Treatment Preparation Procedure Parameter Sequence', "PatientTreatmentPreparationProcedureParameterSequence", 0x300A, 0x0793, [TagLink(PatientTreatmentPreparationProcedureSequence),])
    SegmentCharacteristicsSequence = Tag('Segment Characteristics Sequence', "SegmentCharacteristicsSequence", 0x3010, 0x0027, [TagLink(RTSegmentAnnotationSequence),])
    ContentItemModifierSequence = Tag('Content Item Modifier Sequence', "ContentItemModifierSequence", 0x0040, 0x0441, [TagLink(ProtocolContextSequence),TagLink(AcquisitionContextSequence),TagLink(QuantityDefinitionSequence),TagLink(PerformedProcessingParametersSequence),TagLink(PatientTreatmentPreparationProcedureParameterSequence),TagLink(SegmentCharacteristicsSequence),])
    RTRadiationTaskSequence = Tag('RT Radiation Task Sequence', "RTRadiationTaskSequence", 0x300A, 0x0797)
    RTDeliveryStartPatientPositionSequence = Tag('RT Delivery Start Patient Position Sequence', "RTDeliveryStartPatientPositionSequence", 0x300A, 0x0789, [TagLink(RTRadiationTaskSequence),])
    RTTreatmentPreparationPatientPositionSequence = Tag('RT Treatment Preparation Patient Position Sequence', "RTTreatmentPreparationPatientPositionSequence", 0x300A, 0x078A)
    RTAcquisitionPatientPositionSequence = Tag('RT Acquisition Patient Position Sequence', "RTAcquisitionPatientPositionSequence", 0x3002, 0x0108, [TagLink(AcquisitionTaskSequence),])
    RTPatientPositionDisplacementSequence = Tag('RT Patient Position Displacement Sequence', "RTPatientPositionDisplacementSequence", 0x300A, 0x0798, [TagLink(RTDeliveryStartPatientPositionSequence),TagLink(RTTreatmentPreparationPatientPositionSequence),TagLink(RTAcquisitionPatientPositionSequence),])
    PatientSupportDisplacementSequence = Tag('Patient Support Displacement Sequence', "PatientSupportDisplacementSequence", 0x300A, 0x079C, [TagLink(RTPatientPositionDisplacementSequence),])
    PatientSupportPositionDeviceParameterSequence = Tag('Patient Support Position Device Parameter Sequence', "PatientSupportPositionDeviceParameterSequence", 0x300A, 0x065D, [TagLink(PatientSupportDisplacementSequence),])
    PatientToEquipmentRelationshipSequence = Tag('Patient to Equipment Relationship Sequence', "PatientToEquipmentRelationshipSequence", 0x300A, 0x07A0)
    PatientSupportPositionParameterSequence = Tag('Patient Support Position Parameter Sequence', "PatientSupportPositionParameterSequence", 0x300A, 0x065B, [TagLink(PatientSupportPositionDeviceParameterSequence),TagLink(PatientToEquipmentRelationshipSequence),])
    SpecimenDescriptionSequence = Tag('Specimen Description Sequence', "SpecimenDescriptionSequence", 0x0040, 0x0560, [TagLink(InventoriedInstancesSequence),])
    SpecimenPreparationSequence = Tag('Specimen Preparation Sequence', "SpecimenPreparationSequence", 0x0040, 0x0610, [TagLink(SpecimenDescriptionSequence),])
    SpecimenPreparationStepContentItemSequence = Tag('Specimen Preparation Step Content Item Sequence', "SpecimenPreparationStepContentItemSequence", 0x0040, 0x0612, [TagLink(SpecimenPreparationSequence),])
    SpecimenLocalizationContentItemSequence = Tag('Specimen Localization Content Item Sequence', "SpecimenLocalizationContentItemSequence", 0x0040, 0x0620, [TagLink(SpecimenDescriptionSequence),])
    ReferencedFractionGroupSequence = Tag('Referenced Fraction Group Sequence', "ReferencedFractionGroupSequence", 0x300C, 0x0020, [TagLink(ReferencedRTPlanSequence),])
    ReferencedTreatmentRecordSequence = Tag('Referenced Treatment Record Sequence', "ReferencedTreatmentRecordSequence", 0x3008, 0x0030)
    FractionGroupSequence = Tag('Fraction Group Sequence', "FractionGroupSequence", 0x300A, 0x0070)
    ReferencedBeamSequence = Tag('Referenced Beam Sequence', "ReferencedBeamSequence", 0x300C, 0x0004, [TagLink(ReferencedFractionGroupSequence),TagLink(ReferencedTreatmentRecordSequence),TagLink(FractionGroupSequence),TagLink(ReferencedRTPlanSequence),])
    RTImageFrameRadiationAcquisitionSequence = Tag('RT Image Frame Radiation Acquisition Sequence', "RTImageFrameRadiationAcquisitionSequence", 0x3002, 0x010C, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    RTImageFrameMVRadiationAcquisitionSequence = Tag('RT Image Frame MV Radiation Acquisition Sequence', "RTImageFrameMVRadiationAcquisitionSequence", 0x3002, 0x010B, [TagLink(RTImageFrameRadiationAcquisitionSequence),])
    AcquisitionSubtaskSequence = Tag('Acquisition Subtask Sequence', "AcquisitionSubtaskSequence", 0x3002, 0x011A, [TagLink(AcquisitionTaskSequence),])
    MVImagingGenerationParametersSequence = Tag('MV Imaging Generation Parameters Sequence', "MVImagingGenerationParametersSequence", 0x3002, 0x0128, [TagLink(AcquisitionSubtaskSequence),])
    RadiationGenerationModeSequence = Tag('Radiation Generation Mode Sequence', "RadiationGenerationModeSequence", 0x300A, 0x067B, [TagLink(RTImageFrameMVRadiationAcquisitionSequence),TagLink(MVImagingGenerationParametersSequence),])
    RadiationDeviceConfigurationAndCommissioningKeySequence = Tag('Radiation Device Configuration and Commissioning Key Sequence', "RadiationDeviceConfigurationAndCommissioningKeySequence", 0x300A, 0x065A, [TagLink(ReferencedBeamSequence),TagLink(TreatmentSessionBeamSequence),TagLink(RadiationGenerationModeSequence),])
    WideFieldOphthalmicPhotographyQualityRatingSequence = Tag('Wide Field Ophthalmic Photography Quality Rating Sequence', "WideFieldOphthalmicPhotographyQualityRatingSequence", 0x0022, 0x1525)
    OphthalmicEnFaceImageQualityRatingSequence = Tag('Ophthalmic En Face Image Quality Rating Sequence', "OphthalmicEnFaceImageQualityRatingSequence", 0x0022, 0x1628)
    LensConstantSequence = Tag('Lens Constant Sequence', "LensConstantSequence", 0x0022, 0x1092)
    VisualFieldGlobalResultsIndexSequence = Tag('Visual Field Global Results Index Sequence', "VisualFieldGlobalResultsIndexSequence", 0x0024, 0x0320)
    DataObservationSequence = Tag('Data Observation Sequence', "DataObservationSequence", 0x0024, 0x0325, [TagLink(VisualFieldGlobalResultsIndexSequence),])
    OphthalmicThicknessMapQualityRatingSequence = Tag('Ophthalmic Thickness Map Quality Rating Sequence', "OphthalmicThicknessMapQualityRatingSequence", 0x0022, 0x1470)
    TrackSetSequence = Tag('Track Set Sequence', "TrackSetSequence", 0x0066, 0x0101)
    AnnotationGroupSequence = Tag('Annotation Group Sequence', "AnnotationGroupSequence", 0x006A, 0x0002)
    MeasurementsSequence = Tag('Measurements Sequence', "MeasurementsSequence", 0x0066, 0x0121, [TagLink(TrackSetSequence),TagLink(AnnotationGroupSequence),])
    TrackStatisticsSequence = Tag('Track Statistics Sequence', "TrackStatisticsSequence", 0x0066, 0x0130, [TagLink(TrackSetSequence),])
    WaveformAnnotationSequence = Tag('Waveform Annotation Sequence', "WaveformAnnotationSequence", 0x0040, 0xB020)
    ContentSequence = Tag('Content Sequence', "ContentSequence", 0x0040, 0xA730)
    TabulatedValuesSequence = Tag('Tabulated Values Sequence', "TabulatedValuesSequence", 0x0040, 0xA801, [TagLink(ContentSequence),])
    TableRowDefinitionSequence = Tag('Table Row Definition Sequence', "TableRowDefinitionSequence", 0x0040, 0xA806, [TagLink(TabulatedValuesSequence),])
    TableColumnDefinitionSequence = Tag('Table Column Definition Sequence', "TableColumnDefinitionSequence", 0x0040, 0xA807, [TagLink(TabulatedValuesSequence),])
    DosimetricObjectiveSequence = Tag('Dosimetric Objective Sequence', "DosimetricObjectiveSequence", 0x3010, 0x006C)
    DosimetricObjectiveParameterSequence = Tag('Dosimetric Objective Parameter Sequence', "DosimetricObjectiveParameterSequence", 0x3010, 0x0070, [TagLink(DosimetricObjectiveSequence),])
    PatientSupportPositionDeviceToleranceSequence = Tag('Patient Support Position Device Tolerance Sequence', "PatientSupportPositionDeviceToleranceSequence", 0x300A, 0x0660)
    PatientSupportPositionToleranceSequence = Tag('Patient Support Position Tolerance Sequence', "PatientSupportPositionToleranceSequence", 0x300A, 0x062D, [TagLink(PatientSupportPositionDeviceToleranceSequence),])
    CTImagingAcquisitionParameterSequence = Tag('CT Imaging Acquisition Parameter Sequence', "CTImagingAcquisitionParameterSequence", 0x3002, 0x0126, [TagLink(AcquisitionSubtaskSequence),])
    ScanStartPositionSequence = Tag('Scan Start Position Sequence', "ScanStartPositionSequence", 0x3002, 0x012B, [TagLink(CTImagingAcquisitionParameterSequence),])
    ScanStopPositionSequence = Tag('Scan Stop Position Sequence', "ScanStopPositionSequence", 0x3002, 0x012C, [TagLink(CTImagingAcquisitionParameterSequence),])
    RTImageFrameImagingDevicePositionSequence = Tag('RT Image Frame Imaging Device Position Sequence', "RTImageFrameImagingDevicePositionSequence", 0x3002, 0x0109, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    ImagingSourcePositionSequence = Tag('Imaging Source Position Sequence', "ImagingSourcePositionSequence", 0x3002, 0x010D, [TagLink(ScanStartPositionSequence),TagLink(ScanStopPositionSequence),TagLink(RTImageFrameImagingDevicePositionSequence),])
    ImageReceptorPositionSequence = Tag('Image Receptor Position Sequence', "ImageReceptorPositionSequence", 0x3002, 0x010E, [TagLink(ScanStartPositionSequence),TagLink(ScanStopPositionSequence),TagLink(RTImageFrameImagingDevicePositionSequence),])
    ImagingEquipmentToTreatmentDeliveryDeviceRelationshipSequence = Tag('Imaging Equipment to Treatment Delivery Device Relationship Sequence', "ImagingEquipmentToTreatmentDeliveryDeviceRelationshipSequence", 0x300A, 0x07A1)
    DevicePositionParameterSequence = Tag('Device Position Parameter Sequence', "DevicePositionParameterSequence", 0x3002, 0x0110, [TagLink(ImagingSourcePositionSequence),TagLink(ImageReceptorPositionSequence),TagLink(ImagingEquipmentToTreatmentDeliveryDeviceRelationshipSequence),])
    RTPrescriptionSequence = Tag('RT Prescription Sequence', "RTPrescriptionSequence", 0x3010, 0x006B)
    PrescriptionNotesSequence = Tag('Prescription Notes Sequence', "PrescriptionNotesSequence", 0x3010, 0x0081, [TagLink(RTPrescriptionSequence),])
    AlternateValueSequence = Tag('Alternate Value Sequence', "AlternateValueSequence", 0x300A, 0x073E, [TagLink(OverrideSequence),])
    AcquisitionInitiationSequence = Tag('Acquisition Initiation Sequence', "AcquisitionInitiationSequence", 0x3002, 0x0135, [TagLink(AcquisitionSubtaskSequence),])
    AdditionalRTAccessoryDeviceSequence = Tag('Additional RT Accessory Device Sequence', "AdditionalRTAccessoryDeviceSequence", 0x3002, 0x0130, [TagLink(AcquisitionSubtaskSequence),])
    DeviceSpecificAcquisitionParameterSequence = Tag('Device-Specific Acquisition Parameter Sequence', "DeviceSpecificAcquisitionParameterSequence", 0x3002, 0x0131, [TagLink(AcquisitionSubtaskSequence),TagLink(AdditionalRTAccessoryDeviceSequence),])
    ConceptNameCodeSequence = Tag('Concept Name Code Sequence', "ConceptNameCodeSequence", 0x0040, 0xA043, [TagLink(ContentItemModifierSequence),TagLink(ProtocolContextSequence),TagLink(AlternateContentDescriptionSequence),TagLink(PatientSupportPositionParameterSequence),TagLink(AcquisitionContextSequence),TagLink(QuantityDefinitionSequence),TagLink(SpecimenPreparationStepContentItemSequence),TagLink(SpecimenLocalizationContentItemSequence),TagLink(RadiationDeviceConfigurationAndCommissioningKeySequence),TagLink(PerformedProcessingParametersSequence),TagLink(WideFieldOphthalmicPhotographyQualityRatingSequence),TagLink(OphthalmicEnFaceImageQualityRatingSequence),TagLink(LensConstantSequence),TagLink(DataObservationSequence),TagLink(OphthalmicThicknessMapQualityRatingSequence),TagLink(MeasurementsSequence),TagLink(TrackStatisticsSequence),TagLink(WaveformAnnotationSequence),TagLink(ContentSequence),TagLink(TableRowDefinitionSequence),TagLink(TableColumnDefinitionSequence),TagLink(DosimetricObjectiveParameterSequence),TagLink(PatientSupportPositionToleranceSequence),TagLink(PatientTreatmentPreparationProcedureParameterSequence),TagLink(DevicePositionParameterSequence),TagLink(PrescriptionNotesSequence),TagLink(SegmentCharacteristicsSequence),TagLink(AlternateValueSequence),TagLink(AcquisitionInitiationSequence),TagLink(DeviceSpecificAcquisitionParameterSequence),TagLink(InventoriedInstancesSequence),])
    CellValuesSequence = Tag('Cell Values Sequence', "CellValuesSequence", 0x0040, 0xA808, [TagLink(TabulatedValuesSequence),])
    ConceptCodeSequence = Tag('Concept Code Sequence', "ConceptCodeSequence", 0x0040, 0xA168, [TagLink(ContentItemModifierSequence),TagLink(ProtocolContextSequence),TagLink(PatientSupportPositionParameterSequence),TagLink(AcquisitionContextSequence),TagLink(QuantityDefinitionSequence),TagLink(SpecimenPreparationStepContentItemSequence),TagLink(SpecimenLocalizationContentItemSequence),TagLink(RadiationDeviceConfigurationAndCommissioningKeySequence),TagLink(PerformedProcessingParametersSequence),TagLink(DataObservationSequence),TagLink(WaveformAnnotationSequence),TagLink(CellValuesSequence),TagLink(ContentSequence),TagLink(DosimetricObjectiveParameterSequence),TagLink(PatientSupportPositionToleranceSequence),TagLink(PatientTreatmentPreparationProcedureParameterSequence),TagLink(DevicePositionParameterSequence),TagLink(PrescriptionNotesSequence),TagLink(SegmentCharacteristicsSequence),TagLink(AlternateValueSequence),TagLink(AcquisitionInitiationSequence),TagLink(DeviceSpecificAcquisitionParameterSequence),])
    MeasuredValueSequence = Tag('Measured Value Sequence', "MeasuredValueSequence", 0x0040, 0xA300, [TagLink(ContentSequence),])
    AssessmentObservationsSequence = Tag('Assessment Observations Sequence', "AssessmentObservationsSequence", 0x0082, 0x0007)
    StructuredConstraintObservationSequence = Tag('Structured Constraint Observation Sequence', "StructuredConstraintObservationSequence", 0x0082, 0x000C, [TagLink(AssessmentObservationsSequence),])
    PatientSpecificationSequence = Tag('Patient Specification Sequence', "PatientSpecificationSequence", 0x0018, 0x9911)
    AcquisitionProtocolElementSpecificationSequence = Tag('Acquisition Protocol Element Specification Sequence', "AcquisitionProtocolElementSpecificationSequence", 0x0018, 0x991F)
    ReconstructionProtocolElementSpecificationSequence = Tag('Reconstruction Protocol Element Specification Sequence', "ReconstructionProtocolElementSpecificationSequence", 0x0018, 0x9933)
    StorageProtocolElementSpecificationSequence = Tag('Storage Protocol Element Specification Sequence', "StorageProtocolElementSpecificationSequence", 0x0018, 0x9935)
    ParametersSpecificationSequence = Tag('Parameters Specification Sequence', "ParametersSpecificationSequence", 0x0018, 0x9913, [TagLink(AcquisitionProtocolElementSpecificationSequence),TagLink(ReconstructionProtocolElementSpecificationSequence),TagLink(StorageProtocolElementSpecificationSequence),TagLink(CTImagingAcquisitionParameterSequence),])
    MeasurementUnitsCodeSequence = Tag('Measurement Units Code Sequence', "MeasurementUnitsCodeSequence", 0x0040, 0x08EA, [TagLink(ContentItemModifierSequence),TagLink(ProtocolContextSequence),TagLink(PatientSupportPositionParameterSequence),TagLink(AcquisitionContextSequence),TagLink(QuantityDefinitionSequence),TagLink(SpecimenPreparationStepContentItemSequence),TagLink(SpecimenLocalizationContentItemSequence),TagLink(RealWorldValueMappingSequence),TagLink(RadiationDeviceConfigurationAndCommissioningKeySequence),TagLink(PerformedProcessingParametersSequence),TagLink(WideFieldOphthalmicPhotographyQualityRatingSequence),TagLink(OphthalmicEnFaceImageQualityRatingSequence),TagLink(DataObservationSequence),TagLink(OphthalmicThicknessMapQualityRatingSequence),TagLink(MeasurementsSequence),TagLink(TrackStatisticsSequence),TagLink(WaveformAnnotationSequence),TagLink(MeasuredValueSequence),TagLink(TableRowDefinitionSequence),TagLink(TableColumnDefinitionSequence),TagLink(CellValuesSequence),TagLink(StructuredConstraintObservationSequence),TagLink(PatientSpecificationSequence),TagLink(ParametersSpecificationSequence),TagLink(DosimetricObjectiveParameterSequence),TagLink(PatientSupportPositionToleranceSequence),TagLink(PatientTreatmentPreparationProcedureParameterSequence),TagLink(DevicePositionParameterSequence),TagLink(PrescriptionNotesSequence),TagLink(SegmentCharacteristicsSequence),TagLink(AlternateValueSequence),TagLink(AcquisitionInitiationSequence),TagLink(DeviceSpecificAcquisitionParameterSequence),TagLink(PerFrameFunctionalGroupsSequence, True),])
    FrameAnatomySequence = Tag('Frame Anatomy Sequence', "FrameAnatomySequence", 0x0020, 0x9071, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    RTROIObservationsSequence = Tag('RT ROI Observations Sequence', "RTROIObservationsSequence", 0x3006, 0x0080)
    MRArterialSpinLabelingSequence = Tag('MR Arterial Spin Labeling Sequence', "MRArterialSpinLabelingSequence", 0x0018, 0x9251, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    ASLSlabSequence = Tag('ASL Slab Sequence', "ASLSlabSequence", 0x0018, 0x9260, [TagLink(MRArterialSpinLabelingSequence),])
    ImplantTargetAnatomySequence = Tag('Implant Target Anatomy Sequence', "ImplantTargetAnatomySequence", 0x0068, 0x6230)
    ImplantAssemblyTemplateTargetAnatomySequence = Tag('Implant Assembly Template Target Anatomy Sequence', "ImplantAssemblyTemplateTargetAnatomySequence", 0x0076, 0x0010)
    ImplantTemplateGroupTargetAnatomySequence = Tag('Implant Template Group Target Anatomy Sequence', "ImplantTemplateGroupTargetAnatomySequence", 0x0078, 0x0028)
    AnatomicRegionSequence = Tag('Anatomic Region Sequence', "AnatomicRegionSequence", 0x0008, 0x2218, [TagLink(FrameAnatomySequence),TagLink(RTROIObservationsSequence),TagLink(ASLSlabSequence),TagLink(SegmentSequence),TagLink(HangingProtocolDefinitionSequence),TagLink(ImplantTargetAnatomySequence),TagLink(ImplantAssemblyTemplateTargetAnatomySequence),TagLink(ImplantTemplateGroupTargetAnatomySequence),TagLink(AnnotationGroupSequence),])
    AnatomicRegionModifierSequence = Tag('Anatomic Region Modifier Sequence', "AnatomicRegionModifierSequence", 0x0008, 0x2220, [TagLink(AnatomicRegionSequence),])
    PrimaryAnatomicStructureSequence = Tag('Primary Anatomic Structure Sequence', "PrimaryAnatomicStructureSequence", 0x0008, 0x2228, [TagLink(FrameAnatomySequence),TagLink(SpecimenDescriptionSequence),TagLink(RTROIObservationsSequence),TagLink(ASLSlabSequence),TagLink(SegmentSequence),TagLink(AnnotationGroupSequence),])
    PrimaryAnatomicStructureModifierSequence = Tag('Primary Anatomic Structure Modifier Sequence', "PrimaryAnatomicStructureModifierSequence", 0x0008, 0x2230, [TagLink(PrimaryAnatomicStructureSequence),])
    RequestedProcedureCodeSequence = Tag('Requested Procedure Code Sequence', "RequestedProcedureCodeSequence", 0x0032, 0x1064, [TagLink(RequestAttributesSequence),TagLink(ReferencedRequestSequence),])
    ReasonForRequestedProcedureCodeSequence = Tag('Reason for Requested Procedure Code Sequence', "ReasonForRequestedProcedureCodeSequence", 0x0040, 0x100A, [TagLink(RequestAttributesSequence),TagLink(ReferencedRequestSequence),TagLink(HangingProtocolDefinitionSequence),])
    PatientTreatmentOrientationSequence = Tag('Patient Treatment Orientation Sequence', "PatientTreatmentOrientationSequence", 0x3010, 0x0032, [TagLink(RTPrescriptionSequence),])
    PatientOrientationCodeSequence = Tag('Patient Orientation Code Sequence', "PatientOrientationCodeSequence", 0x0054, 0x0410, [TagLink(PatientTreatmentOrientationSequence),TagLink(RTDeliveryStartPatientPositionSequence),TagLink(RTTreatmentPreparationPatientPositionSequence),TagLink(RTAcquisitionPatientPositionSequence),])
    PatientOrientationModifierCodeSequence = Tag('Patient Orientation Modifier Code Sequence', "PatientOrientationModifierCodeSequence", 0x0054, 0x0412, [TagLink(PatientOrientationCodeSequence),])
    PatientGantryRelationshipCodeSequence = Tag('Patient Gantry Relationship Code Sequence', "PatientGantryRelationshipCodeSequence", 0x0054, 0x0414)
    PatientEquipmentRelationshipCodeSequence = Tag('Patient Equipment Relationship Code Sequence', "PatientEquipmentRelationshipCodeSequence", 0x3010, 0x0030, [TagLink(PatientTreatmentOrientationSequence),TagLink(RTDeliveryStartPatientPositionSequence),TagLink(RTTreatmentPreparationPatientPositionSequence),TagLink(RTAcquisitionPatientPositionSequence),])
    OtherPatientIDsSequence = Tag('Other Patient IDs Sequence', "OtherPatientIDsSequence", 0x0010, 0x1002, [TagLink(InventoriedStudiesSequence),])
    SourcePatientGroupIdentificationSequence = Tag('Source Patient Group Identification Sequence', "SourcePatientGroupIdentificationSequence", 0x0010, 0x0026)
    GroupOfPatientsIdentificationSequence = Tag('Group of Patients Identification Sequence', "GroupOfPatientsIdentificationSequence", 0x0010, 0x0027)
    IssuerOfPatientIDQualifiersSequence = Tag('Issuer of Patient ID Qualifiers Sequence', "IssuerOfPatientIDQualifiersSequence", 0x0010, 0x0024, [TagLink(OtherPatientIDsSequence),TagLink(SourcePatientGroupIdentificationSequence),TagLink(GroupOfPatientsIdentificationSequence),TagLink(InventoriedStudiesSequence),])
    AssigningJurisdictionCodeSequence = Tag('Assigning Jurisdiction Code Sequence', "AssigningJurisdictionCodeSequence", 0x0040, 0x0039, [TagLink(IssuerOfPatientIDQualifiersSequence),])
    AssigningAgencyOrDepartmentCodeSequence = Tag('Assigning Agency or Department Code Sequence', "AssigningAgencyOrDepartmentCodeSequence", 0x0040, 0x003A, [TagLink(IssuerOfPatientIDQualifiersSequence),])
    StructureSetROISequence = Tag('Structure Set ROI Sequence', "StructureSetROISequence", 0x3006, 0x0020)
    ConceptualVolumeIdentificationSequence = Tag('Conceptual Volume Identification Sequence', "ConceptualVolumeIdentificationSequence", 0x3010, 0x00A0, [TagLink(StructureSetROISequence),])
    RTAnatomicPrescriptionSequence = Tag('RT Anatomic Prescription Sequence', "RTAnatomicPrescriptionSequence", 0x3010, 0x0060, [TagLink(RTPrescriptionSequence),])
    RadiationDoseIdentificationSequence = Tag('Radiation Dose Identification Sequence', "RadiationDoseIdentificationSequence", 0x300A, 0x0618)
    ConceptualVolumeSequence = Tag('Conceptual Volume Sequence', "ConceptualVolumeSequence", 0x3010, 0x0025, [TagLink(PatientSupportDevicesSequence),TagLink(BolusDefinitionSequence),TagLink(RTPatientPositionDisplacementSequence),TagLink(RTAnatomicPrescriptionSequence),TagLink(RadiationDoseIdentificationSequence),])
    SegmentReferenceSequence = Tag('Segment Reference Sequence', "SegmentReferenceSequence", 0x3010, 0x0021)
    DirectSegmentReferenceSequence = Tag('Direct Segment Reference Sequence', "DirectSegmentReferenceSequence", 0x3010, 0x0023, [TagLink(SegmentReferenceSequence),])
    CombinationSegmentReferenceSequence = Tag('Combination Segment Reference Sequence', "CombinationSegmentReferenceSequence", 0x3010, 0x0024, [TagLink(SegmentReferenceSequence),])
    DerivationConceptualVolumeSequence = Tag('Derivation Conceptual Volume Sequence', "DerivationConceptualVolumeSequence", 0x3010, 0x0014, [TagLink(ConceptualVolumeIdentificationSequence),TagLink(ConceptualVolumeSequence),TagLink(DirectSegmentReferenceSequence),TagLink(CombinationSegmentReferenceSequence),])
    ConceptualVolumeDerivationAlgorithmSequence = Tag('Conceptual Volume Derivation Algorithm Sequence', "ConceptualVolumeDerivationAlgorithmSequence", 0x3010, 0x0016, [TagLink(DerivationConceptualVolumeSequence),])
    ROIDerivationAlgorithmIdentificationSequence = Tag('ROI Derivation Algorithm Identification Sequence', "ROIDerivationAlgorithmIdentificationSequence", 0x3006, 0x0037, [TagLink(StructureSetROISequence),])
    DerivationAlgorithmSequence = Tag('Derivation Algorithm Sequence', "DerivationAlgorithmSequence", 0x0022, 0x1612, [TagLink(MultienergyCTCharacteristicsSequence),])
    MultienergyCTProcessingSequence = Tag('Multi-energy CT Processing Sequence', "MultienergyCTProcessingSequence", 0x0018, 0x9363, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    DecompositionAlgorithmIdentificationSequence = Tag('Decomposition Algorithm Identification Sequence', "DecompositionAlgorithmIdentificationSequence", 0x0018, 0x9380, [TagLink(MultienergyCTProcessingSequence),])
    TransformationAlgorithmSequence = Tag('Transformation Algorithm Sequence', "TransformationAlgorithmSequence", 0x0022, 0x1513)
    AcquisitionMethodAlgorithmSequence = Tag('Acquisition Method Algorithm Sequence', "AcquisitionMethodAlgorithmSequence", 0x0022, 0x1423)
    SegmentationAlgorithmIdentificationSequence = Tag('Segmentation Algorithm Identification Sequence', "SegmentationAlgorithmIdentificationSequence", 0x0062, 0x0007, [TagLink(SegmentSequence),])
    ReferencedSurfaceSequence = Tag('Referenced Surface Sequence', "ReferencedSurfaceSequence", 0x0066, 0x002B, [TagLink(SegmentSequence),])
    SegmentSurfaceGenerationAlgorithmIdentificationSequence = Tag('Segment Surface Generation Algorithm Identification Sequence', "SegmentSurfaceGenerationAlgorithmIdentificationSequence", 0x0066, 0x002D, [TagLink(ReferencedSurfaceSequence),])
    IndexProbabilitySequence = Tag('Index Probability Sequence', "IndexProbabilitySequence", 0x0024, 0x0344, [TagLink(VisualFieldGlobalResultsIndexSequence),])
    AgeCorrectedSensitivityDeviationAlgorithmSequence = Tag('Age Corrected Sensitivity Deviation Algorithm Sequence', "AgeCorrectedSensitivityDeviationAlgorithmSequence", 0x0024, 0x0065)
    GeneralizedDefectSensitivityDeviationAlgorithmSequence = Tag('Generalized Defect Sensitivity Deviation Algorithm Sequence', "GeneralizedDefectSensitivityDeviationAlgorithmSequence", 0x0024, 0x0067)
    ResultsNormalsSequence = Tag('Results Normals Sequence', "ResultsNormalsSequence", 0x0024, 0x0064)
    GlobalDeviationProbabilitySequence = Tag('Global Deviation Probability Sequence', "GlobalDeviationProbabilitySequence", 0x0024, 0x0083, [TagLink(ResultsNormalsSequence),])
    LocalizedDeviationProbabilitySequence = Tag('Localized Deviation Probability Sequence', "LocalizedDeviationProbabilitySequence", 0x0024, 0x0085, [TagLink(ResultsNormalsSequence),])
    OphthalmicThicknessMapQualityThresholdSequence = Tag('Ophthalmic Thickness Map Quality Threshold Sequence', "OphthalmicThicknessMapQualityThresholdSequence", 0x0022, 0x1458, [TagLink(OphthalmicThicknessMapQualityRatingSequence),])
    TrackingAlgorithmIdentificationSequence = Tag('Tracking Algorithm Identification Sequence', "TrackingAlgorithmIdentificationSequence", 0x0066, 0x0104, [TagLink(TrackSetSequence),])
    ReconstructionProtocolElementSequence = Tag('Reconstruction Protocol Element Sequence', "ReconstructionProtocolElementSequence", 0x0018, 0x9934)
    ReconstructionAlgorithmSequence = Tag('Reconstruction Algorithm Sequence', "ReconstructionAlgorithmSequence", 0x0018, 0x993D, [TagLink(ReconstructionProtocolElementSequence),TagLink(PerFrameFunctionalGroupsSequence, True),])
    SurfaceSequence = Tag('Surface Sequence', "SurfaceSequence", 0x0066, 0x0002)
    SurfaceProcessingAlgorithmIdentificationSequence = Tag('Surface Processing Algorithm Identification Sequence', "SurfaceProcessingAlgorithmIdentificationSequence", 0x0066, 0x0035, [TagLink(SurfaceSequence),])
    AnnotationGroupAlgorithmIdentificationSequence = Tag('Annotation Group Algorithm Identification Sequence', "AnnotationGroupAlgorithmIdentificationSequence", 0x006A, 0x0008, [TagLink(AnnotationGroupSequence),])
    AlgorithmFamilyCodeSequence = Tag('Algorithm Family Code Sequence', "AlgorithmFamilyCodeSequence", 0x0066, 0x002F, [TagLink(ConceptualVolumeDerivationAlgorithmSequence),TagLink(ROIDerivationAlgorithmIdentificationSequence),TagLink(DerivationAlgorithmSequence),TagLink(DecompositionAlgorithmIdentificationSequence),TagLink(TransformationAlgorithmSequence),TagLink(WideFieldOphthalmicPhotographyQualityRatingSequence),TagLink(OphthalmicEnFaceImageQualityRatingSequence),TagLink(AcquisitionMethodAlgorithmSequence),TagLink(SegmentationAlgorithmIdentificationSequence),TagLink(SegmentSurfaceGenerationAlgorithmIdentificationSequence),TagLink(IndexProbabilitySequence),TagLink(AgeCorrectedSensitivityDeviationAlgorithmSequence),TagLink(GeneralizedDefectSensitivityDeviationAlgorithmSequence),TagLink(GlobalDeviationProbabilitySequence),TagLink(LocalizedDeviationProbabilitySequence),TagLink(OphthalmicThicknessMapQualityThresholdSequence),TagLink(TrackingAlgorithmIdentificationSequence),TagLink(ReconstructionAlgorithmSequence),TagLink(SurfaceProcessingAlgorithmIdentificationSequence),TagLink(AnnotationGroupAlgorithmIdentificationSequence),])
    AlgorithmNameCodeSequence = Tag('Algorithm Name Code Sequence', "AlgorithmNameCodeSequence", 0x0066, 0x0030, [TagLink(ConceptualVolumeDerivationAlgorithmSequence),TagLink(ROIDerivationAlgorithmIdentificationSequence),TagLink(DerivationAlgorithmSequence),TagLink(DecompositionAlgorithmIdentificationSequence),TagLink(TransformationAlgorithmSequence),TagLink(WideFieldOphthalmicPhotographyQualityRatingSequence),TagLink(OphthalmicEnFaceImageQualityRatingSequence),TagLink(AcquisitionMethodAlgorithmSequence),TagLink(SegmentationAlgorithmIdentificationSequence),TagLink(SegmentSurfaceGenerationAlgorithmIdentificationSequence),TagLink(IndexProbabilitySequence),TagLink(AgeCorrectedSensitivityDeviationAlgorithmSequence),TagLink(GeneralizedDefectSensitivityDeviationAlgorithmSequence),TagLink(GlobalDeviationProbabilitySequence),TagLink(LocalizedDeviationProbabilitySequence),TagLink(OphthalmicThicknessMapQualityThresholdSequence),TagLink(TrackingAlgorithmIdentificationSequence),TagLink(ReconstructionAlgorithmSequence),TagLink(SurfaceProcessingAlgorithmIdentificationSequence),TagLink(AnnotationGroupAlgorithmIdentificationSequence),])
    DetectorInformationSequence = Tag('Detector Information Sequence', "DetectorInformationSequence", 0x0054, 0x0022)
    ViewCodeSequence = Tag('View Code Sequence', "ViewCodeSequence", 0x0054, 0x0220, [TagLink(DetectorInformationSequence),])
    ViewModifierCodeSequence = Tag('View Modifier Code Sequence', "ViewModifierCodeSequence", 0x0054, 0x0222, [TagLink(ViewCodeSequence),])
    BeamTaskSequence = Tag('Beam Task Sequence', "BeamTaskSequence", 0x0074, 0x1020)
    DeviceMotionControlSequence = Tag('Device Motion Control Sequence', "DeviceMotionControlSequence", 0x300A, 0x0450, [TagLink(BeamTaskSequence),TagLink(RTRadiationTaskSequence),])
    DeviceMotionParameterCodeSequence = Tag('Device Motion Parameter Code Sequence', "DeviceMotionParameterCodeSequence", 0x300A, 0x0453, [TagLink(DeviceMotionControlSequence),])
    AssessedAttributeValueSequence = Tag('Assessed Attribute Value Sequence', "AssessedAttributeValueSequence", 0x0082, 0x0010, [TagLink(StructuredConstraintObservationSequence),])
    SelectorCodeSequenceValue = Tag('Selector Code Sequence Value', "SelectorCodeSequenceValue", 0x0072, 0x0080, [TagLink(AssessedAttributeValueSequence),])
    PositioningLandmarkSequence = Tag('Positioning Landmark Sequence', "PositioningLandmarkSequence", 0x0018, 0x991D)
    AcquisitionProtocolElementSequence = Tag('Acquisition Protocol Element Sequence', "AcquisitionProtocolElementSequence", 0x0018, 0x9920)
    AcquisitionStartLocationSequence = Tag('Acquisition Start Location Sequence', "AcquisitionStartLocationSequence", 0x0018, 0x9931, [TagLink(AcquisitionProtocolElementSequence),])
    AcquisitionEndLocationSequence = Tag('Acquisition End Location Sequence', "AcquisitionEndLocationSequence", 0x0018, 0x9932, [TagLink(AcquisitionProtocolElementSequence),])
    ReconstructionStartLocationSequence = Tag('Reconstruction Start Location Sequence', "ReconstructionStartLocationSequence", 0x0018, 0x993B, [TagLink(ReconstructionProtocolElementSequence),])
    ReconstructionEndLocationSequence = Tag('Reconstruction End Location Sequence', "ReconstructionEndLocationSequence", 0x0018, 0x993C, [TagLink(ReconstructionProtocolElementSequence),])
    ReconstructionTargetCenterLocationSequence = Tag('Reconstruction Target Center Location Sequence', "ReconstructionTargetCenterLocationSequence", 0x0018, 0x993E, [TagLink(ReconstructionProtocolElementSequence),])
    ReferenceBasisCodeSequence = Tag('Reference Basis Code Sequence', "ReferenceBasisCodeSequence", 0x0018, 0x9902, [TagLink(PositioningLandmarkSequence),TagLink(AcquisitionStartLocationSequence),TagLink(AcquisitionEndLocationSequence),TagLink(ReconstructionStartLocationSequence),TagLink(ReconstructionEndLocationSequence),TagLink(ReconstructionTargetCenterLocationSequence),])
    ReferenceGeometryCodeSequence = Tag('Reference Geometry Code Sequence', "ReferenceGeometryCodeSequence", 0x0018, 0x9903, [TagLink(PositioningLandmarkSequence),TagLink(AcquisitionStartLocationSequence),TagLink(AcquisitionEndLocationSequence),TagLink(ReconstructionStartLocationSequence),TagLink(ReconstructionEndLocationSequence),TagLink(ReconstructionTargetCenterLocationSequence),])
    AssertionCodeSequence = Tag('Assertion Code Sequence', "AssertionCodeSequence", 0x0044, 0x0101, [TagLink(ApprovalSequence),TagLink(ConfirmationSequence),])
    TransducerIdentificationSequence = Tag('Transducer Identification Sequence', "TransducerIdentificationSequence", 0x0018, 0x5011)
    GatingBeamHoldTransitionSequence = Tag('Gating Beam Hold Transition Sequence', "GatingBeamHoldTransitionSequence", 0x300C, 0x0125, [TagLink(TreatmentSessionBeamSequence),])
    BeamHoldOriginatingDeviceSequence = Tag('Beam Hold Originating Device Sequence', "BeamHoldOriginatingDeviceSequence", 0x300C, 0x0128, [TagLink(GatingBeamHoldTransitionSequence),])
    InterlockOriginatingDeviceSequence = Tag('Interlock Originating Device Sequence', "InterlockOriginatingDeviceSequence", 0x300A, 0x0743, [TagLink(InterlockSequence),])
    RTImageFramekVRadiationAcquisitionSequence = Tag('RT Image Frame kV Radiation Acquisition Sequence', "RTImageFramekVRadiationAcquisitionSequence", 0x3002, 0x010A, [TagLink(RTImageFrameRadiationAcquisitionSequence),])
    KVImagingGenerationParametersSequence = Tag('KV Imaging Generation Parameters Sequence', "KVImagingGenerationParametersSequence", 0x3002, 0x0127, [TagLink(AcquisitionSubtaskSequence),])
    XRayFilterSequence = Tag('X-Ray Filter Sequence', "XRayFilterSequence", 0x0018, 0x9556, [TagLink(RTImageFramekVRadiationAcquisitionSequence),TagLink(KVImagingGenerationParametersSequence),TagLink(PerFrameFunctionalGroupsSequence, True),])
    DeviceTypeCodeSequence = Tag('Device Type Code Sequence', "DeviceTypeCodeSequence", 0x3010, 0x002E, [TagLink(TransducerIdentificationSequence),TagLink(BeamHoldOriginatingDeviceSequence),TagLink(PatientSupportDevicesSequence),TagLink(WedgeDefinitionSequence),TagLink(CompensatorDefinitionSequence),TagLink(BlockDefinitionSequence),TagLink(RTAccessoryHolderDefinitionSequence),TagLink(GeneralAccessoryDefinitionSequence),TagLink(BolusDefinitionSequence),TagLink(InterlockOriginatingDeviceSequence),TagLink(AcquisitionDeviceSequence),TagLink(PatientTreatmentPreparationDeviceSequence),TagLink(XRayFilterSequence),TagLink(SegmentedRTAccessoryDeviceSequence),TagLink(TreatmentDeviceIdentificationSequence),])
    RelatedSeriesSequence = Tag('Related Series Sequence', "RelatedSeriesSequence", 0x0008, 0x1250)
    ContributingSOPInstancesReferenceSequence = Tag('Contributing SOP Instances Reference Sequence', "ContributingSOPInstancesReferenceSequence", 0x0020, 0x9529, [TagLink(ContributingSourcesSequence),])
    RTPhysicianIntentSequence = Tag('RT Physician Intent Sequence', "RTPhysicianIntentSequence", 0x3010, 0x0057)
    RTPhysicianIntentInputInstanceSequence = Tag('RT Physician Intent Input Instance Sequence', "RTPhysicianIntentInputInstanceSequence", 0x3010, 0x005F, [TagLink(RTPhysicianIntentSequence),])
    PlanningInputInformationSequence = Tag('Planning Input Information Sequence', "PlanningInputInformationSequence", 0x3010, 0x0076, [TagLink(RTPrescriptionSequence),])
    ReferencedPositionReferenceInstanceSequence = Tag('Referenced Position Reference Instance Sequence', "ReferencedPositionReferenceInstanceSequence", 0x3002, 0x0132, [TagLink(AcquisitionSubtaskSequence),])
    ReferencedStudySequence = Tag('Referenced Study Sequence', "ReferencedStudySequence", 0x0008, 0x1110, [TagLink(RequestAttributesSequence),TagLink(ReferencedRequestSequence),TagLink(RTPhysicianIntentInputInstanceSequence),TagLink(PlanningInputInformationSequence),TagLink(ReferencedPositionReferenceInstanceSequence),])
    BlendingSequence = Tag('Blending Sequence', "BlendingSequence", 0x0070, 0x0402)
    StudiesContainingOtherReferencedInstancesSequence = Tag('Studies Containing Other Referenced Instances Sequence', "StudiesContainingOtherReferencedInstancesSequence", 0x0008, 0x1200)
    CurrentRequestedProcedureEvidenceSequence = Tag('Current Requested Procedure Evidence Sequence', "CurrentRequestedProcedureEvidenceSequence", 0x0040, 0xA375)
    IdenticalDocumentsSequence = Tag('Identical Documents Sequence', "IdenticalDocumentsSequence", 0x0040, 0xA525)
    PredecessorDocumentsSequence = Tag('Predecessor Documents Sequence', "PredecessorDocumentsSequence", 0x0040, 0xA360)
    ReferencedSeriesSequence = Tag('Referenced Series Sequence', "ReferencedSeriesSequence", 0x0008, 0x1115, [TagLink(ContributingSOPInstancesReferenceSequence),TagLink(ReferencedStudySequence),TagLink(BlendingSequence),TagLink(StudiesContainingOtherReferencedInstancesSequence),TagLink(CurrentRequestedProcedureEvidenceSequence),TagLink(IdenticalDocumentsSequence),TagLink(PredecessorDocumentsSequence),])
    PlanOverviewSequence = Tag('Plan Overview Sequence', "PlanOverviewSequence", 0x300C, 0x0116)
    SoundSpeedCorrectionMechanismCodeSequence = Tag('Sound Speed Correction Mechanism Code Sequence', "SoundSpeedCorrectionMechanismCodeSequence", 0x0018, 0x9832)
    DisplayedAreaSelectionSequence = Tag('Displayed Area Selection Sequence', "DisplayedAreaSelectionSequence", 0x0070, 0x005A)
    GraphicAnnotationSequence = Tag('Graphic Annotation Sequence', "GraphicAnnotationSequence", 0x0070, 0x0001)
    AdvancedBlendingSequence = Tag('Advanced Blending Sequence', "AdvancedBlendingSequence", 0x0070, 0x1B01)
    SoftcopyVOILUTSequence = Tag('Softcopy VOI LUT Sequence', "SoftcopyVOILUTSequence", 0x0028, 0x3110, [TagLink(BlendingSequence),TagLink(AdvancedBlendingSequence),])
    StructuredDisplayImageBoxSequence = Tag('Structured Display Image Box Sequence', "StructuredDisplayImageBoxSequence", 0x0072, 0x0422)
    MaskSubtractionSequence = Tag('Mask Subtraction Sequence', "MaskSubtractionSequence", 0x0028, 0x6100)
    FrameDisplayShutterSequence = Tag('Frame Display Shutter Sequence', "FrameDisplayShutterSequence", 0x0018, 0x9472, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    MultiFramePresentationSequence = Tag('Multi-frame Presentation Sequence', "MultiFramePresentationSequence", 0x0028, 0x9505)
    VolumetricPresentationInputSetSequence = Tag('Volumetric Presentation Input Set Sequence', "VolumetricPresentationInputSetSequence", 0x0070, 0x120A)
    VolumeCroppingSequence = Tag('Volume Cropping Sequence', "VolumeCroppingSequence", 0x0070, 0x1301)
    VariableModalityLUTSequence = Tag('Variable Modality LUT Sequence', "VariableModalityLUTSequence", 0x0028, 0x3001)
    RegistrationSequence = Tag('Registration Sequence', "RegistrationSequence", 0x0070, 0x0308)
    DeformableRegistrationSequence = Tag('Deformable Registration Sequence', "DeformableRegistrationSequence", 0x0064, 0x0002)
    FiducialSetSequence = Tag('Fiducial Set Sequence', "FiducialSetSequence", 0x0070, 0x031C)
    FiducialSequence = Tag('Fiducial Sequence', "FiducialSequence", 0x0070, 0x031E, [TagLink(FiducialSetSequence),])
    GraphicCoordinatesDataSequence = Tag('Graphic Coordinates Data Sequence', "GraphicCoordinatesDataSequence", 0x0070, 0x0318, [TagLink(FiducialSequence),])
    ReferencedImageSequence = Tag('Referenced Image Sequence', "ReferencedImageSequence", 0x0008, 0x1140, [TagLink(ReferencedSeriesSequence),TagLink(PlanOverviewSequence),TagLink(SoundSpeedCorrectionMechanismCodeSequence),TagLink(DisplayedAreaSelectionSequence),TagLink(GraphicAnnotationSequence),TagLink(SoftcopyVOILUTSequence),TagLink(StructuredDisplayImageBoxSequence),TagLink(MaskSubtractionSequence),TagLink(FrameDisplayShutterSequence),TagLink(MultiFramePresentationSequence),TagLink(VolumetricPresentationInputSetSequence),TagLink(VolumeCroppingSequence),TagLink(AdvancedBlendingSequence),TagLink(VariableModalityLUTSequence),TagLink(RegistrationSequence),TagLink(DeformableRegistrationSequence),TagLink(FiducialSetSequence),TagLink(GraphicCoordinatesDataSequence),TagLink(ReferencedImageRealWorldValueMappingSequence),TagLink(PerFrameFunctionalGroupsSequence, True),])
    DerivationImageSequence = Tag('Derivation Image Sequence', "DerivationImageSequence", 0x0008, 0x9124, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    XRay3DAcquisitionSequence = Tag('X-Ray 3D Acquisition Sequence', "XRay3DAcquisitionSequence", 0x0018, 0x9507)
    SourceImageSequence = Tag('Source Image Sequence', "SourceImageSequence", 0x0008, 0x2112, [TagLink(DerivationImageSequence),TagLink(XRay3DAcquisitionSequence),])
    ReferencedInstanceSequence = Tag('Referenced Instance Sequence', "ReferencedInstanceSequence", 0x0008, 0x114A, [TagLink(ReferencedSeriesSequence),TagLink(StructuredDisplayImageBoxSequence),])
    OphthalmicFrameLocationSequence = Tag('Ophthalmic Frame Location Sequence', "OphthalmicFrameLocationSequence", 0x0022, 0x0031, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    SourceInstanceSequence = Tag('Source Instance Sequence', "SourceInstanceSequence", 0x0042, 0x0013)
    CornealSizeSequence = Tag('Corneal Size Sequence', "CornealSizeSequence", 0x0046, 0x0047)
    LensThicknessSequence = Tag('Lens Thickness Sequence', "LensThicknessSequence", 0x0022, 0x1127)
    AnteriorChamberDepthSequence = Tag('Anterior Chamber Depth Sequence', "AnteriorChamberDepthSequence", 0x0022, 0x1128)
    RefractiveStateSequence = Tag('Refractive State Sequence', "RefractiveStateSequence", 0x0022, 0x001B)
    SourceOfRefractiveMeasurementsSequence = Tag('Source of Refractive Measurements Sequence', "SourceOfRefractiveMeasurementsSequence", 0x0022, 0x1134, [TagLink(RefractiveStateSequence),])
    CorneaMeasurementsSequence = Tag('Cornea Measurements Sequence', "CorneaMeasurementsSequence", 0x0046, 0x0110)
    OphthalmicAxialLengthSequence = Tag('Ophthalmic Axial Length Sequence', "OphthalmicAxialLengthSequence", 0x0022, 0x1012)
    ReferencedSOPSequence = Tag('Referenced SOP Sequence', "ReferencedSOPSequence", 0x0008, 0x1199, [TagLink(ContentItemModifierSequence),TagLink(ProtocolContextSequence),TagLink(PatientSupportPositionParameterSequence),TagLink(ReferencedPatientPhotoSequence),TagLink(AcquisitionContextSequence),TagLink(QuantityDefinitionSequence),TagLink(SpecimenPreparationStepContentItemSequence),TagLink(SpecimenLocalizationContentItemSequence),TagLink(RadiationDeviceConfigurationAndCommissioningKeySequence),TagLink(PerformedProcessingParametersSequence),TagLink(CornealSizeSequence),TagLink(LensThicknessSequence),TagLink(AnteriorChamberDepthSequence),TagLink(SourceOfRefractiveMeasurementsSequence),TagLink(CorneaMeasurementsSequence),TagLink(OphthalmicAxialLengthSequence),TagLink(DataObservationSequence),TagLink(ContentSequence),TagLink(DosimetricObjectiveParameterSequence),TagLink(PatientSupportPositionToleranceSequence),TagLink(PatientTreatmentPreparationProcedureParameterSequence),TagLink(DevicePositionParameterSequence),TagLink(PrescriptionNotesSequence),TagLink(SegmentCharacteristicsSequence),TagLink(DirectSegmentReferenceSequence),TagLink(AlternateValueSequence),TagLink(AcquisitionInitiationSequence),TagLink(DeviceSpecificAcquisitionParameterSequence),])
    PurposeOfReferenceCodeSequence = Tag('Purpose of Reference Code Sequence', "PurposeOfReferenceCodeSequence", 0x0040, 0xA170, [TagLink(RelatedSeriesSequence),TagLink(ReferencedImageSequence),TagLink(SourceImageSequence),TagLink(ReferencedInstanceSequence),TagLink(OphthalmicFrameLocationSequence),TagLink(ContributingEquipmentSequence),TagLink(SourceInstanceSequence),TagLink(ReferencedSOPSequence),TagLink(RTPhysicianIntentInputInstanceSequence),TagLink(PlanningInputInformationSequence),TagLink(ReferencedPositionReferenceInstanceSequence),TagLink(AlternateRepresentationSequence),])
    TreatmentPositionSequence = Tag('Treatment Position Sequence', "TreatmentPositionSequence", 0x300A, 0x063F)
    RTPatientPositionSequence = Tag('RT Patient Position Sequence', "RTPatientPositionSequence", 0x300A, 0x0799, [TagLink(RTDeliveryStartPatientPositionSequence),TagLink(RTTreatmentPreparationPatientPositionSequence),TagLink(RTAcquisitionPatientPositionSequence),])
    PatientLocationCoordinatesSequence = Tag('Patient Location Coordinates Sequence', "PatientLocationCoordinatesSequence", 0x3006, 0x00C9, [TagLink(TreatmentPositionSequence),TagLink(RTPatientPositionSequence),])
    PatientLocationCoordinatesCodeSequence = Tag('Patient Location Coordinates Code Sequence', "PatientLocationCoordinatesCodeSequence", 0x3006, 0x00CA, [TagLink(PatientLocationCoordinatesSequence),])
    EthnicGroupCodeSequence = Tag('Ethnic Group Code Sequence', "EthnicGroupCodeSequence", 0x0010, 0x2161)
    PatientSpeciesCodeSequence = Tag('Patient Species Code Sequence', "PatientSpeciesCodeSequence", 0x0010, 0x2202)
    PatientBreedCodeSequence = Tag('Patient Breed Code Sequence', "PatientBreedCodeSequence", 0x0010, 0x2293)
    BreedRegistrationSequence = Tag('Breed Registration Sequence', "BreedRegistrationSequence", 0x0010, 0x2294)
    BreedRegistryCodeSequence = Tag('Breed Registry Code Sequence', "BreedRegistryCodeSequence", 0x0010, 0x2296, [TagLink(BreedRegistrationSequence),])
    StrainCodeSequence = Tag('Strain Code Sequence', "StrainCodeSequence", 0x0010, 0x0219)
    StrainStockSequence = Tag('Strain Stock Sequence', "StrainStockSequence", 0x0010, 0x0216)
    StrainSourceRegistryCodeSequence = Tag('Strain Source Registry Code Sequence', "StrainSourceRegistryCodeSequence", 0x0010, 0x0215, [TagLink(StrainStockSequence),])
    GeneticModificationsSequence = Tag('Genetic Modifications Sequence', "GeneticModificationsSequence", 0x0010, 0x0221)
    GeneticModificationsCodeSequence = Tag('Genetic Modifications Code Sequence', "GeneticModificationsCodeSequence", 0x0010, 0x0229, [TagLink(GeneticModificationsSequence),])
    DeidentificationMethodCodeSequence = Tag('De-identification Method Code Sequence', "DeidentificationMethodCodeSequence", 0x0012, 0x0064)
    RequestingServiceCodeSequence = Tag('Requesting Service Code Sequence', "RequestingServiceCodeSequence", 0x0032, 0x1034)
    ProcedureCodeSequence = Tag('Procedure Code Sequence', "ProcedureCodeSequence", 0x0008, 0x1032, [TagLink(HangingProtocolDefinitionSequence),TagLink(InventoriedStudiesSequence),])
    ReasonForPerformedProcedureCodeSequence = Tag('Reason For Performed Procedure Code Sequence', "ReasonForPerformedProcedureCodeSequence", 0x0040, 0x1012)
    AdmittingDiagnosesCodeSequence = Tag('Admitting Diagnoses Code Sequence', "AdmittingDiagnosesCodeSequence", 0x0008, 0x1084)
    PrincipalDiagnosisCodeSequence = Tag('Principal Diagnosis Code Sequence', "PrincipalDiagnosisCodeSequence", 0x0008, 0x1301)
    PrimaryDiagnosisCodeSequence = Tag('Primary Diagnosis Code Sequence', "PrimaryDiagnosisCodeSequence", 0x0008, 0x1302)
    SecondaryDiagnosesCodeSequence = Tag('Secondary Diagnoses Code Sequence', "SecondaryDiagnosesCodeSequence", 0x0008, 0x1303)
    HistologicalDiagnosesCodeSequence = Tag('Histological Diagnoses Code Sequence', "HistologicalDiagnosesCodeSequence", 0x0008, 0x1304)
    PatientSizeCodeSequence = Tag("Patient's Size Code Sequence", "PatientSizeCodeSequence", 0x0010, 0x1021)
    ReasonForVisitCodeSequence = Tag('Reason for Visit Code Sequence', "ReasonForVisitCodeSequence", 0x0032, 0x1067)
    ClinicalTrialTimePointTypeCodeSequence = Tag('Clinical Trial Time Point Type Code Sequence', "ClinicalTrialTimePointTypeCodeSequence", 0x0012, 0x0054)
    SeriesDescriptionCodeSequence = Tag('Series Description Code Sequence', "SeriesDescriptionCodeSequence", 0x0008, 0x103F)
    ContrastBolusAgentSequence = Tag('Contrast/Bolus Agent Sequence', "ContrastBolusAgentSequence", 0x0018, 0x0012, [TagLink(XRay3DAcquisitionSequence),])
    ContrastBolusAdministrationRouteSequence = Tag('Contrast/Bolus Administration Route Sequence', "ContrastBolusAdministrationRouteSequence", 0x0018, 0x0014, [TagLink(ContrastBolusAgentSequence),])
    AdditionalDrugSequence = Tag('Additional Drug Sequence', "AdditionalDrugSequence", 0x0018, 0x002A, [TagLink(ContrastBolusAdministrationRouteSequence),])
    ContrastBolusIngredientCodeSequence = Tag('Contrast/Bolus Ingredient Code Sequence', "ContrastBolusIngredientCodeSequence", 0x0018, 0x9338, [TagLink(ContrastBolusAgentSequence),])
    MultiplexedAudioChannelsDescriptionCodeSequence = Tag('Multiplexed Audio Channels Description Code Sequence', "MultiplexedAudioChannelsDescriptionCodeSequence", 0x003A, 0x0300)
    WaveformSequence = Tag('Waveform Sequence', "WaveformSequence", 0x5400, 0x0100)
    ChannelDefinitionSequence = Tag('Channel Definition Sequence', "ChannelDefinitionSequence", 0x003A, 0x0200, [TagLink(WaveformSequence),])
    ContributingChannelSourcesSequence = Tag('Contributing Channel Sources Sequence', "ContributingChannelSourcesSequence", 0x0040, 0xB041)
    ChannelSourceSequence = Tag('Channel Source Sequence', "ChannelSourceSequence", 0x003A, 0x0208, [TagLink(MultiplexedAudioChannelsDescriptionCodeSequence),TagLink(ChannelDefinitionSequence),TagLink(ContributingChannelSourcesSequence),])
    InterventionSequence = Tag('Intervention Sequence', "InterventionSequence", 0x0018, 0x0036)
    InterventionDrugInformationSequence = Tag('Intervention Drug Information Sequence', "InterventionDrugInformationSequence", 0x0018, 0x0026)
    InterventionDrugCodeSequence = Tag('Intervention Drug Code Sequence', "InterventionDrugCodeSequence", 0x0018, 0x0029, [TagLink(InterventionSequence),TagLink(InterventionDrugInformationSequence),])
    RadiopharmaceuticalInformationSequence = Tag('Radiopharmaceutical Information Sequence', "RadiopharmaceuticalInformationSequence", 0x0054, 0x0016)
    AdministrationRouteCodeSequence = Tag('Administration Route Code Sequence', "AdministrationRouteCodeSequence", 0x0054, 0x0302, [TagLink(InterventionSequence),TagLink(RadiopharmaceuticalInformationSequence),TagLink(InterventionDrugInformationSequence),])
    XAXRFFrameCharacteristicsSequence = Tag('XA/XRF Frame Characteristics Sequence', "XAXRFFrameCharacteristicsSequence", 0x0018, 0x9412, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    DerivationCodeSequence = Tag('Derivation Code Sequence', "DerivationCodeSequence", 0x0008, 0x9215, [TagLink(DerivationImageSequence),TagLink(StructureSetROISequence),TagLink(XAXRFFrameCharacteristicsSequence),TagLink(ReconstructionProtocolElementSequence),])
    PatientPhysiologicalStateSequence = Tag('Patient Physiological State Sequence', "PatientPhysiologicalStateSequence", 0x0018, 0x9771, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    PatientPhysiologicalStateCodeSequence = Tag('Patient Physiological State Code Sequence', "PatientPhysiologicalStateCodeSequence", 0x0018, 0x9772, [TagLink(PatientPhysiologicalStateSequence),])
    ContainerTypeCodeSequence = Tag('Container Type Code Sequence', "ContainerTypeCodeSequence", 0x0040, 0x0518)
    ContainerComponentTypeCodeSequence = Tag('Container Component Type Code Sequence', "ContainerComponentTypeCodeSequence", 0x0050, 0x0012, [TagLink(ContainerComponentSequence),])
    SpecimenTypeCodeSequence = Tag('Specimen Type Code Sequence', "SpecimenTypeCodeSequence", 0x0040, 0x059A, [TagLink(SpecimenDescriptionSequence),])
    CTExposureSequence = Tag('CT Exposure Sequence', "CTExposureSequence", 0x0018, 0x9321, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    CTDIPhantomTypeCodeSequence = Tag('CTDI Phantom Type Code Sequence', "CTDIPhantomTypeCodeSequence", 0x0018, 0x9346, [TagLink(CTExposureSequence),TagLink(AcquisitionProtocolElementSequence),])
    WaterEquivalentDiameterCalculationMethodCodeSequence = Tag('Water Equivalent Diameter Calculation Method Code Sequence', "WaterEquivalentDiameterCalculationMethodCodeSequence", 0x0018, 0x1272, [TagLink(CTExposureSequence),])
    RadionuclideCodeSequence = Tag('Radionuclide Code Sequence', "RadionuclideCodeSequence", 0x0054, 0x0300, [TagLink(RadiopharmaceuticalInformationSequence),])
    RadiopharmaceuticalCodeSequence = Tag('Radiopharmaceutical Code Sequence', "RadiopharmaceuticalCodeSequence", 0x0054, 0x0304, [TagLink(RadiopharmaceuticalInformationSequence),])
    SequenceOfUltrasoundRegions = Tag('Sequence of Ultrasound Regions', "SequenceOfUltrasoundRegions", 0x0018, 0x6011)
    PixelValueMappingToCodedConceptSequence = Tag('Pixel Value Mapping to Coded Concept Sequence', "PixelValueMappingToCodedConceptSequence", 0x0022, 0x1450)
    PixelValueMappingCodeSequence = Tag('Pixel Value Mapping Code Sequence', "PixelValueMappingCodeSequence", 0x0040, 0x9098, [TagLink(SequenceOfUltrasoundRegions),TagLink(PixelValueMappingToCodedConceptSequence),])
    StageCodeSequence = Tag('Stage Code Sequence', "StageCodeSequence", 0x0040, 0x000A)
    DocumentClassCodeSequence = Tag('Document Class Code Sequence', "DocumentClassCodeSequence", 0x0040, 0xE008)
    TreatmentSiteCodeSequence = Tag('Treatment Site Code Sequence', "TreatmentSiteCodeSequence", 0x3010, 0x0078, [TagLink(PlanOverviewSequence),TagLink(RTPhysicianIntentSequence),])
    TreatmentSiteModifierCodeSequence = Tag('Treatment Site Modifier Code Sequence', "TreatmentSiteModifierCodeSequence", 0x3010, 0x0089, [TagLink(TreatmentSiteCodeSequence),])
    RTProtocolCodeSequence = Tag('RT Protocol Code Sequence', "RTProtocolCodeSequence", 0x3010, 0x005B, [TagLink(StructureSetROISequence),TagLink(RTPhysicianIntentSequence),])
    ROIObservationContextCodeSequence = Tag('ROI Observation Context Code Sequence', "ROIObservationContextCodeSequence", 0x3006, 0x004F, [TagLink(RTROIObservationsSequence),])
    SurfacePointsSequence = Tag('Surface Points Sequence', "SurfacePointsSequence", 0x0066, 0x0011, [TagLink(SurfaceSequence),])
    SegmentedPropertyCategoryCodeSequence = Tag('Segmented Property Category Code Sequence', "SegmentedPropertyCategoryCodeSequence", 0x0062, 0x0003, [TagLink(RTROIObservationsSequence),TagLink(SegmentSequence),TagLink(SurfaceSequence),TagLink(SurfacePointsSequence),TagLink(CombinationSegmentReferenceSequence),])
    RTROIIdentificationCodeSequence = Tag('RT ROI Identification Code Sequence', "RTROIIdentificationCodeSequence", 0x3006, 0x0086, [TagLink(RTROIObservationsSequence),])
    OphthalmicEnFaceVolumeDescriptorSequence = Tag('Ophthalmic En Face Volume Descriptor Sequence', "OphthalmicEnFaceVolumeDescriptorSequence", 0x0022, 0x1627)
    ReferencedSegmentationSequence = Tag('Referenced Segmentation Sequence', "ReferencedSegmentationSequence", 0x0008, 0x114C, [TagLink(OphthalmicEnFaceVolumeDescriptorSequence),])
    SegmentedPropertyTypeCodeSequence = Tag('Segmented Property Type Code Sequence', "SegmentedPropertyTypeCodeSequence", 0x0062, 0x000F, [TagLink(ReferencedSegmentationSequence),TagLink(SegmentSequence),TagLink(SurfaceSequence),TagLink(SurfacePointsSequence),TagLink(CombinationSegmentReferenceSequence),])
    SegmentedPropertyTypeModifierCodeSequence = Tag('Segmented Property Type Modifier Code Sequence', "SegmentedPropertyTypeModifierCodeSequence", 0x0062, 0x0011, [TagLink(RTROIIdentificationCodeSequence),TagLink(SegmentedPropertyTypeCodeSequence),])
    TherapeuticRoleCategoryCodeSequence = Tag('Therapeutic Role Category Code Sequence', "TherapeuticRoleCategoryCodeSequence", 0x3010, 0x0064, [TagLink(RTROIObservationsSequence),TagLink(RTAnatomicPrescriptionSequence),])
    TherapeuticRoleTypeCodeSequence = Tag('Therapeutic Role Type Code Sequence', "TherapeuticRoleTypeCodeSequence", 0x3010, 0x0065, [TagLink(RTROIObservationsSequence),TagLink(RTAnatomicPrescriptionSequence),])
    RTTreatmentTechniqueCodeSequence = Tag('RT Treatment Technique Code Sequence', "RTTreatmentTechniqueCodeSequence", 0x3010, 0x0080, [TagLink(BeamSequence),TagLink(RTPrescriptionSequence),])
    RTTreatmentTerminationReasonCodeSequence = Tag('RT Treatment Termination Reason Code Sequence', "RTTreatmentTerminationReasonCodeSequence", 0x300A, 0x0715, [TagLink(TreatmentSessionBeamSequence),TagLink(TreatmentSessionApplicationSetupSequence),TagLink(TreatmentSessionIonBeamSequence),])
    MachineSpecificTreatmentTerminationCodeSequence = Tag('Machine-Specific Treatment Termination Code Sequence', "MachineSpecificTreatmentTerminationCodeSequence", 0x300A, 0x0716, [TagLink(TreatmentSessionBeamSequence),TagLink(TreatmentSessionApplicationSetupSequence),TagLink(TreatmentSessionIonBeamSequence),])
    ProjectionEponymousNameCodeSequence = Tag('Projection Eponymous Name Code Sequence', "ProjectionEponymousNameCodeSequence", 0x0018, 0x5104)
    PartialViewCodeSequence = Tag('Partial View Code Sequence', "PartialViewCodeSequence", 0x0028, 0x1352)
    OpticalPathSequence = Tag('Optical Path Sequence', "OpticalPathSequence", 0x0048, 0x0105)
    ChannelDescriptionCodeSequence = Tag('Channel Description Code Sequence', "ChannelDescriptionCodeSequence", 0x0022, 0x001A, [TagLink(OpticalPathSequence),])
    IlluminatorTypeCodeSequence = Tag('Illuminator Type Code Sequence', "IlluminatorTypeCodeSequence", 0x0048, 0x0100, [TagLink(OpticalPathSequence),])
    IlluminationColorCodeSequence = Tag('Illumination Color Code Sequence', "IlluminationColorCodeSequence", 0x0048, 0x0108, [TagLink(OpticalPathSequence),])
    IlluminationTypeCodeSequence = Tag('Illumination Type Code Sequence', "IlluminationTypeCodeSequence", 0x0022, 0x0016, [TagLink(OpticalPathSequence),])
    LightPathFilterTypeStackCodeSequence = Tag('Light Path Filter Type Stack Code Sequence', "LightPathFilterTypeStackCodeSequence", 0x0022, 0x0017, [TagLink(OpticalPathSequence),])
    ImagePathFilterTypeStackCodeSequence = Tag('Image Path Filter Type Stack Code Sequence', "ImagePathFilterTypeStackCodeSequence", 0x0022, 0x0018, [TagLink(OpticalPathSequence),])
    LensesCodeSequence = Tag('Lenses Code Sequence', "LensesCodeSequence", 0x0022, 0x0019, [TagLink(OpticalPathSequence),])
    MRMetaboliteMapSequence = Tag('MR Metabolite Map Sequence', "MRMetaboliteMapSequence", 0x0018, 0x9152, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    MetaboliteMapCodeSequence = Tag('Metabolite Map Code Sequence', "MetaboliteMapCodeSequence", 0x0018, 0x9083, [TagLink(MRMetaboliteMapSequence),])
    DecompositionMaterialSequence = Tag('Decomposition Material Sequence', "DecompositionMaterialSequence", 0x0018, 0x9381, [TagLink(MultienergyCTProcessingSequence),])
    MaterialCodeSequence = Tag('Material Code Sequence', "MaterialCodeSequence", 0x0018, 0x937D, [TagLink(DecompositionMaterialSequence),])
    AcquisitionDeviceTypeCodeSequence = Tag('Acquisition Device Type Code Sequence', "AcquisitionDeviceTypeCodeSequence", 0x0022, 0x0015)
    PatientEyeMovementCommandCodeSequence = Tag('Patient Eye Movement Command Code Sequence', "PatientEyeMovementCommandCodeSequence", 0x0022, 0x0006)
    RelativeImagePositionCodeSequence = Tag('Relative Image Position Code Sequence', "RelativeImagePositionCodeSequence", 0x0022, 0x001D)
    MydriaticAgentSequence = Tag('Mydriatic Agent Sequence', "MydriaticAgentSequence", 0x0022, 0x0058)
    MydriaticAgentCodeSequence = Tag('Mydriatic Agent Code Sequence', "MydriaticAgentCodeSequence", 0x0022, 0x001C, [TagLink(MydriaticAgentSequence),])
    MydriaticAgentConcentrationUnitsSequence = Tag('Mydriatic Agent Concentration Units Sequence', "MydriaticAgentConcentrationUnitsSequence", 0x0022, 0x0042, [TagLink(MydriaticAgentSequence),])
    OCTBscanAnalysisAcquisitionParametersSequence = Tag('OCT B-scan Analysis Acquisition Parameters Sequence', "OCTBscanAnalysisAcquisitionParametersSequence", 0x0022, 0x1640)
    ScanPatternTypeCodeSequence = Tag('Scan Pattern Type Code Sequence', "ScanPatternTypeCodeSequence", 0x0022, 0x1618, [TagLink(OCTBscanAnalysisAcquisitionParametersSequence),])
    TransformationMethodCodeSequence = Tag('Transformation Method Code Sequence', "TransformationMethodCodeSequence", 0x0022, 0x1512)
    OphthalmicImageTypeCodeSequence = Tag('Ophthalmic Image Type Code Sequence', "OphthalmicImageTypeCodeSequence", 0x0022, 0x1615)
    EventTimerSequence = Tag('Event Timer Sequence', "EventTimerSequence", 0x0008, 0x2133)
    EventCodeSequence = Tag('Event Code Sequence', "EventCodeSequence", 0x0008, 0x2135, [TagLink(EventTimerSequence),])
    TransducerScanPatternCodeSequence = Tag('Transducer Scan Pattern Code Sequence', "TransducerScanPatternCodeSequence", 0x0018, 0x9809)
    TransducerGeometryCodeSequence = Tag('Transducer Geometry Code Sequence', "TransducerGeometryCodeSequence", 0x0018, 0x980D)
    TransducerBeamSteeringCodeSequence = Tag('Transducer Beam Steering Code Sequence', "TransducerBeamSteeringCodeSequence", 0x0018, 0x980E)
    TransducerApplicationCodeSequence = Tag('Transducer Application Code Sequence', "TransducerApplicationCodeSequence", 0x0018, 0x980F)
    VisualAcuityTypeCodeSequence = Tag('Visual Acuity Type Code Sequence', "VisualAcuityTypeCodeSequence", 0x0046, 0x0121)
    OphthalmicUltrasoundMethodCodeSequence = Tag('Ophthalmic Ultrasound Method Code Sequence', "OphthalmicUltrasoundMethodCodeSequence", 0x0022, 0x1044, [TagLink(OphthalmicAxialLengthSequence),])
    AnteriorChamberDepthDefinitionCodeSequence = Tag('Anterior Chamber Depth Definition Code Sequence', "AnteriorChamberDepthDefinitionCodeSequence", 0x0022, 0x1125)
    LensStatusCodeSequence = Tag('Lens Status Code Sequence', "LensStatusCodeSequence", 0x0022, 0x1024)
    VitreousStatusCodeSequence = Tag('Vitreous Status Code Sequence', "VitreousStatusCodeSequence", 0x0022, 0x1025)
    UltrasoundSelectedOphthalmicAxialLengthSequence = Tag('Ultrasound Selected Ophthalmic Axial Length Sequence', "UltrasoundSelectedOphthalmicAxialLengthSequence", 0x0022, 0x1230)
    OpticalSelectedOphthalmicAxialLengthSequence = Tag('Optical Selected Ophthalmic Axial Length Sequence', "OpticalSelectedOphthalmicAxialLengthSequence", 0x0022, 0x1255)
    SelectedSegmentalOphthalmicAxialLengthSequence = Tag('Selected Segmental Ophthalmic Axial Length Sequence', "SelectedSegmentalOphthalmicAxialLengthSequence", 0x0022, 0x1257, [TagLink(UltrasoundSelectedOphthalmicAxialLengthSequence),TagLink(OpticalSelectedOphthalmicAxialLengthSequence),])
    OphthalmicAxialLengthMeasurementsSegmentNameCodeSequence = Tag('Ophthalmic Axial Length Measurements Segment Name Code Sequence', "OphthalmicAxialLengthMeasurementsSegmentNameCodeSequence", 0x0022, 0x1101, [TagLink(SelectedSegmentalOphthalmicAxialLengthSequence),])
    UltrasoundOphthalmicAxialLengthMeasurementsSequence = Tag('Ultrasound Ophthalmic Axial Length Measurements Sequence', "UltrasoundOphthalmicAxialLengthMeasurementsSequence", 0x0022, 0x1220)
    OpticalOphthalmicAxialLengthMeasurementsSequence = Tag('Optical Ophthalmic Axial Length Measurements Sequence', "OpticalOphthalmicAxialLengthMeasurementsSequence", 0x0022, 0x1225)
    OphthalmicAxialLengthDataSourceCodeSequence = Tag('Ophthalmic Axial Length Data Source Code Sequence', "OphthalmicAxialLengthDataSourceCodeSequence", 0x0022, 0x1150, [TagLink(UltrasoundOphthalmicAxialLengthMeasurementsSequence),TagLink(OpticalOphthalmicAxialLengthMeasurementsSequence),])
    OphthalmicAxialLengthSelectionMethodCodeSequence = Tag('Ophthalmic Axial Length Selection Method Code Sequence', "OphthalmicAxialLengthSelectionMethodCodeSequence", 0x0022, 0x1250, [TagLink(UltrasoundSelectedOphthalmicAxialLengthSequence),TagLink(OphthalmicAxialLengthSequence),])
    RefractiveSurgeryTypeCodeSequence = Tag('Refractive Surgery Type Code Sequence', "RefractiveSurgeryTypeCodeSequence", 0x0022, 0x1040)
    RefractiveErrorBeforeRefractiveSurgeryCodeSequence = Tag('Refractive Error Before Refractive Surgery Code Sequence', "RefractiveErrorBeforeRefractiveSurgeryCodeSequence", 0x0022, 0x1103)
    SourceOfCornealSizeDataCodeSequence = Tag('Source of Corneal Size Data Code Sequence', "SourceOfCornealSizeDataCodeSequence", 0x0022, 0x1036, [TagLink(CornealSizeSequence),])
    SourceOfLensThicknessDataCodeSequence = Tag('Source of Lens Thickness Data Code Sequence', "SourceOfLensThicknessDataCodeSequence", 0x0022, 0x1132, [TagLink(LensThicknessSequence),])
    SourceOfAnteriorChamberDepthDataCodeSequence = Tag('Source of Anterior Chamber Depth Data Code Sequence', "SourceOfAnteriorChamberDepthDataCodeSequence", 0x0022, 0x1133, [TagLink(AnteriorChamberDepthSequence),])
    SourceOfRefractiveMeasurementsCodeSequence = Tag('Source of Refractive Measurements Code Sequence', "SourceOfRefractiveMeasurementsCodeSequence", 0x0022, 0x1135, [TagLink(SourceOfRefractiveMeasurementsSequence),])
    SourceOfCorneaMeasurementDataCodeSequence = Tag('Source of Cornea Measurement Data Code Sequence', "SourceOfCorneaMeasurementDataCodeSequence", 0x0046, 0x0111, [TagLink(CorneaMeasurementsSequence),])
    IOLFormulaCodeSequence = Tag('IOL Formula Code Sequence', "IOLFormulaCodeSequence", 0x0022, 0x1028)
    KeratometryMeasurementTypeCodeSequence = Tag('Keratometry Measurement Type Code Sequence', "KeratometryMeasurementTypeCodeSequence", 0x0022, 0x1096)
    SourceOfOphthalmicAxialLengthCodeSequence = Tag('Source of Ophthalmic Axial Length Code Sequence', "SourceOfOphthalmicAxialLengthCodeSequence", 0x0022, 0x1035, [TagLink(OphthalmicAxialLengthSequence),])
    CorneaMeasurementMethodCodeSequence = Tag('Cornea Measurement Method Code Sequence', "CorneaMeasurementMethodCodeSequence", 0x0046, 0x0116)
    ScreeningTestModeCodeSequence = Tag('Screening Test Mode Code Sequence', "ScreeningTestModeCodeSequence", 0x0024, 0x0016)
    StimulusColorCodeSequence = Tag('Stimulus Color Code Sequence', "StimulusColorCodeSequence", 0x0024, 0x0021)
    BackgroundIlluminationColorCodeSequence = Tag('Background Illumination Color Code Sequence', "BackgroundIlluminationColorCodeSequence", 0x0024, 0x0024)
    FixationSequence = Tag('Fixation Sequence', "FixationSequence", 0x0024, 0x0032)
    FixationMonitoringCodeSequence = Tag('Fixation Monitoring Code Sequence', "FixationMonitoringCodeSequence", 0x0024, 0x0033, [TagLink(FixationSequence),])
    ModeOfPercutaneousAccessSequence = Tag('Mode of Percutaneous Access Sequence', "ModeOfPercutaneousAccessSequence", 0x0052, 0x0016)
    AcquisitionMethodCodeSequence = Tag('Acquisition Method Code Sequence', "AcquisitionMethodCodeSequence", 0x0022, 0x1420)
    OphthalmicThicknessMapTypeCodeSequence = Tag('Ophthalmic Thickness Map Type Code Sequence', "OphthalmicThicknessMapTypeCodeSequence", 0x0022, 0x1436)
    RetinalThicknessDefinitionCodeSequence = Tag('Retinal Thickness Definition Code Sequence', "RetinalThicknessDefinitionCodeSequence", 0x0022, 0x1445)
    SurfaceScanAcquisitionTypeCodeSequence = Tag('Surface Scan Acquisition Type Code Sequence', "SurfaceScanAcquisitionTypeCodeSequence", 0x0080, 0x0001)
    SurfaceScanModeCodeSequence = Tag('Surface Scan Mode Code Sequence', "SurfaceScanModeCodeSequence", 0x0080, 0x0002)
    RegistrationMethodCodeSequence = Tag('Registration Method Code Sequence', "RegistrationMethodCodeSequence", 0x0080, 0x0003)
    CornealTopographyMapTypeCodeSequence = Tag('Corneal Topography Map Type Code Sequence', "CornealTopographyMapTypeCodeSequence", 0x0046, 0x0207)
    TrackSetAnatomicalTypeCodeSequence = Tag('Track Set Anatomical Type Code Sequence', "TrackSetAnatomicalTypeCodeSequence", 0x0066, 0x0108, [TagLink(TrackSetSequence),])
    ModifierCodeSequence = Tag('Modifier Code Sequence', "ModifierCodeSequence", 0x0040, 0xA195, [TagLink(TrackSetAnatomicalTypeCodeSequence),TagLink(TrackStatisticsSequence),TagLink(ConceptNameCodeSequence),TagLink(ConceptCodeSequence),])
    DiffusionAcquisitionCodeSequence = Tag('Diffusion Acquisition Code Sequence', "DiffusionAcquisitionCodeSequence", 0x0066, 0x0133, [TagLink(TrackSetSequence),])
    DiffusionModelCodeSequence = Tag('Diffusion Model Code Sequence', "DiffusionModelCodeSequence", 0x0066, 0x0134, [TagLink(TrackSetSequence),])
    AcousticCouplingMediumCodeSequence = Tag('Acoustic Coupling Medium Code Sequence', "AcousticCouplingMediumCodeSequence", 0x0018, 0x982A)
    TransducerTechnologySequence = Tag('Transducer Technology Sequence', "TransducerTechnologySequence", 0x0018, 0x9831)
    ImageDataTypeSequence = Tag('Image Data Type Sequence', "ImageDataTypeSequence", 0x0018, 0x9807, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    ImageDataTypeCodeSequence = Tag('Image Data Type Code Sequence', "ImageDataTypeCodeSequence", 0x0018, 0x9836, [TagLink(ImageDataTypeSequence),])
    ChannelSourceModifiersSequence = Tag('Channel Source Modifiers Sequence', "ChannelSourceModifiersSequence", 0x003A, 0x0209, [TagLink(ChannelDefinitionSequence),])
    ChannelSensitivityUnitsSequence = Tag('Channel Sensitivity Units Sequence', "ChannelSensitivityUnitsSequence", 0x003A, 0x0211, [TagLink(ChannelDefinitionSequence),])
    FilterLowFrequencyCharacteristicsSequence = Tag('Filter Low Frequency Characteristics Sequence', "FilterLowFrequencyCharacteristicsSequence", 0x003A, 0x0318, [TagLink(ChannelDefinitionSequence),])
    FilterHighFrequencyCharacteristicsSequence = Tag('Filter High Frequency Characteristics Sequence', "FilterHighFrequencyCharacteristicsSequence", 0x003A, 0x0319, [TagLink(ChannelDefinitionSequence),])
    NotchFilterCharacteristicsSequence = Tag('Notch Filter Characteristics Sequence', "NotchFilterCharacteristicsSequence", 0x003A, 0x0321, [TagLink(ChannelDefinitionSequence),])
    AnalogFilterCharacteristicsSequence = Tag('Analog Filter Characteristics Sequence', "AnalogFilterCharacteristicsSequence", 0x003A, 0x0323, [TagLink(FilterLowFrequencyCharacteristicsSequence),TagLink(FilterHighFrequencyCharacteristicsSequence),TagLink(NotchFilterCharacteristicsSequence),])
    AnalogFilterTypeCodeSequence = Tag('Analog Filter Type Code Sequence', "AnalogFilterTypeCodeSequence", 0x003A, 0x0325, [TagLink(AnalogFilterCharacteristicsSequence),])
    DigitalFilterCharacteristicsSequence = Tag('Digital Filter Characteristics Sequence', "DigitalFilterCharacteristicsSequence", 0x003A, 0x0326, [TagLink(FilterLowFrequencyCharacteristicsSequence),TagLink(FilterHighFrequencyCharacteristicsSequence),TagLink(NotchFilterCharacteristicsSequence),])
    DigitalFilterTypeCodeSequence = Tag('Digital Filter Type Code Sequence', "DigitalFilterTypeCodeSequence", 0x003A, 0x0328, [TagLink(DigitalFilterCharacteristicsSequence),])
    FrequencyEncodingCodeSequence = Tag('Frequency Encoding Code Sequence', "FrequencyEncodingCodeSequence", 0x003A, 0x032C)
    MagnitudeEncodingCodeSequence = Tag('Magnitude Encoding Code Sequence', "MagnitudeEncodingCodeSequence", 0x003A, 0x032D)
    DigitalSignaturesSequence = Tag('Digital Signatures Sequence', "DigitalSignaturesSequence", 0xFFFA, 0xFFFA)
    DigitalSignaturePurposeCodeSequence = Tag('Digital Signature Purpose Code Sequence', "DigitalSignaturePurposeCodeSequence", 0x0400, 0x0401, [TagLink(DigitalSignaturesSequence),])
    VerifyingObserverSequence = Tag('Verifying Observer Sequence', "VerifyingObserverSequence", 0x0040, 0xA073)
    VerifyingObserverIdentificationCodeSequence = Tag('Verifying Observer Identification Code Sequence', "VerifyingObserverIdentificationCodeSequence", 0x0040, 0xA088, [TagLink(VerifyingObserverSequence),])
    ResponsibleGroupCodeSequence = Tag('Responsible Group Code Sequence', "ResponsibleGroupCodeSequence", 0x0008, 0x0220, [TagLink(CustodialOrganizationSequence),])
    PerformedProcedureCodeSequence = Tag('Performed Procedure Code Sequence', "PerformedProcedureCodeSequence", 0x0040, 0xA372)
    OrganizationalRoleCodeSequence = Tag('Organizational Role Code Sequence', "OrganizationalRoleCodeSequence", 0x0044, 0x010A, [TagLink(AssessmentRequesterSequence),TagLink(AuthorIdentificationSequence),TagLink(OperatorIdentificationSequence),TagLink(AsserterIdentificationSequence),])
    NumericValueQualifierCodeSequence = Tag('Numeric Value Qualifier Code Sequence', "NumericValueQualifierCodeSequence", 0x0040, 0xA301, [TagLink(CellValuesSequence),TagLink(ContentSequence),])
    MatrixRegistrationSequence = Tag('Matrix Registration Sequence', "MatrixRegistrationSequence", 0x0070, 0x0309, [TagLink(RegistrationSequence),])
    RegistrationTypeCodeSequence = Tag('Registration Type Code Sequence', "RegistrationTypeCodeSequence", 0x0070, 0x030D, [TagLink(MatrixRegistrationSequence),TagLink(DeformableRegistrationSequence),])
    FiducialsPropertyCategoryCodeSequence = Tag('Fiducials Property Category Code Sequence', "FiducialsPropertyCategoryCodeSequence", 0x0070, 0x031F, [TagLink(FiducialSequence),])
    FiducialIdentifierCodeSequence = Tag('Fiducial Identifier Code Sequence', "FiducialIdentifierCodeSequence", 0x0070, 0x0311, [TagLink(FiducialSequence),])
    ImageSetsSequence = Tag('Image Sets Sequence', "ImageSetsSequence", 0x0072, 0x0020)
    TimeBasedImageSetsSequence = Tag('Time Based Image Sets Sequence', "TimeBasedImageSetsSequence", 0x0072, 0x0030, [TagLink(ImageSetsSequence),])
    AbstractPriorCodeSequence = Tag('Abstract Prior Code Sequence', "AbstractPriorCodeSequence", 0x0072, 0x003E, [TagLink(TimeBasedImageSetsSequence),])
    HangingProtocolUserIdentificationCodeSequence = Tag('Hanging Protocol User Identification Code Sequence', "HangingProtocolUserIdentificationCodeSequence", 0x0072, 0x000E)
    ImplantRegulatoryDisapprovalCodeSequence = Tag('Implant Regulatory Disapproval Code Sequence', "ImplantRegulatoryDisapprovalCodeSequence", 0x0068, 0x62A0)
    MaterialsCodeSequence = Tag('Materials Code Sequence', "MaterialsCodeSequence", 0x0068, 0x63A0)
    CoatingMaterialsCodeSequence = Tag('Coating Materials Code Sequence', "CoatingMaterialsCodeSequence", 0x0068, 0x63A4)
    ImplantTypeCodeSequence = Tag('Implant Type Code Sequence', "ImplantTypeCodeSequence", 0x0068, 0x63A8)
    FixationMethodCodeSequence = Tag('Fixation Method Code Sequence', "FixationMethodCodeSequence", 0x0068, 0x63AC)
    HPGLDocumentSequence = Tag('HPGL Document Sequence', "HPGLDocumentSequence", 0x0068, 0x62C0)
    ViewOrientationCodeSequence = Tag('View Orientation Code Sequence', "ViewOrientationCodeSequence", 0x0068, 0x62E0, [TagLink(HPGLDocumentSequence),])
    ViewOrientationModifierCodeSequence = Tag('View Orientation Modifier Code Sequence', "ViewOrientationModifierCodeSequence", 0x0068, 0x62F0, [TagLink(HPGLDocumentSequence),])
    PlanningLandmarkPointSequence = Tag('Planning Landmark Point Sequence', "PlanningLandmarkPointSequence", 0x0068, 0x6500)
    PlanningLandmarkLineSequence = Tag('Planning Landmark Line Sequence', "PlanningLandmarkLineSequence", 0x0068, 0x6510)
    PlanningLandmarkPlaneSequence = Tag('Planning Landmark Plane Sequence', "PlanningLandmarkPlaneSequence", 0x0068, 0x6520)
    PlanningLandmarkIdentificationCodeSequence = Tag('Planning Landmark Identification Code Sequence', "PlanningLandmarkIdentificationCodeSequence", 0x0068, 0x6545, [TagLink(PlanningLandmarkPointSequence),TagLink(PlanningLandmarkLineSequence),TagLink(PlanningLandmarkPlaneSequence),])
    ProcedureTypeCodeSequence = Tag('Procedure Type Code Sequence', "ProcedureTypeCodeSequence", 0x0076, 0x0020)
    ComponentTypesSequence = Tag('Component Types Sequence', "ComponentTypesSequence", 0x0076, 0x0032)
    ComponentTypeCodeSequence = Tag('Component Type Code Sequence', "ComponentTypeCodeSequence", 0x0076, 0x0034, [TagLink(ComponentTypesSequence),])
    AssessmentTypeCodeSequence = Tag('Assessment Type Code Sequence', "AssessmentTypeCodeSequence", 0x0082, 0x0021)
    ObservationBasisCodeSequence = Tag('Observation Basis Code Sequence', "ObservationBasisCodeSequence", 0x0082, 0x0022, [TagLink(AssessmentObservationsSequence),])
    PotentialScheduledProtocolCodeSequence = Tag('Potential Scheduled Protocol Code Sequence', "PotentialScheduledProtocolCodeSequence", 0x0018, 0x9906)
    PotentialRequestedProcedureCodeSequence = Tag('Potential Requested Procedure Code Sequence', "PotentialRequestedProcedureCodeSequence", 0x0018, 0x9907)
    PotentialReasonsForProcedureCodeSequence = Tag('Potential Reasons for Procedure Code Sequence', "PotentialReasonsForProcedureCodeSequence", 0x0018, 0x9909)
    ContraindicationsCodeSequence = Tag('Contraindications Code Sequence', "ContraindicationsCodeSequence", 0x0018, 0x990B)
    PositioningMethodCodeSequence = Tag('Positioning Method Code Sequence', "PositioningMethodCodeSequence", 0x0018, 0x991C)
    RequestedSeriesDescriptionCodeSequence = Tag('Requested Series Description Code Sequence', "RequestedSeriesDescriptionCodeSequence", 0x0018, 0x11C1, [TagLink(AcquisitionProtocolElementSequence),TagLink(ReconstructionProtocolElementSequence),])
    ModelUsageCodeSequence = Tag('Model Usage Code Sequence', "ModelUsageCodeSequence", 0x0068, 0x7003)
    DosimetricObjectiveTypeCodeSequence = Tag('Dosimetric Objective Type Code Sequence', "DosimetricObjectiveTypeCodeSequence", 0x3010, 0x006D, [TagLink(DosimetricObjectiveSequence),])
    RadiationDoseSequence = Tag('Radiation Dose Sequence', "RadiationDoseSequence", 0x300A, 0x0617)
    RadiationDoseValuesParametersSequence = Tag('Radiation Dose Values Parameters Sequence', "RadiationDoseValuesParametersSequence", 0x300A, 0x061F, [TagLink(RadiationDoseSequence),])
    DoseValuesSequence = Tag('Dose Values Sequence', "DoseValuesSequence", 0x300A, 0x061C, [TagLink(RadiationDoseValuesParametersSequence),])
    EffectiveDoseCalculationMethodCategoryCodeSequence = Tag('Effective Dose Calculation Method Category Code Sequence', "EffectiveDoseCalculationMethodCategoryCodeSequence", 0x3010, 0x0003, [TagLink(DoseValuesSequence),TagLink(RadiationDoseValuesParametersSequence),])
    EffectiveDoseCalculationMethodCodeSequence = Tag('Effective Dose Calculation Method Code Sequence', "EffectiveDoseCalculationMethodCodeSequence", 0x3010, 0x0004, [TagLink(EffectiveDoseCalculationMethodCategoryCodeSequence),])
    TreatmentMachineSpecialModeCodeSequence = Tag('Treatment Machine Special Mode Code Sequence', "TreatmentMachineSpecialModeCodeSequence", 0x300A, 0x0635)
    CArmPhotonElectronControlPointSequence = Tag('C-Arm Photon-Electron Control Point Sequence', "CArmPhotonElectronControlPointSequence", 0x300A, 0x062F)
    TomotherapeuticControlPointSequence = Tag('Tomotherapeutic Control Point Sequence', "TomotherapeuticControlPointSequence", 0x3010, 0x0098)
    RoboticPathControlPointSequence = Tag('Robotic Path Control Point Sequence', "RoboticPathControlPointSequence", 0x3010, 0x0097)
    DeliveryRateUnitSequence = Tag('Delivery Rate Unit Sequence', "DeliveryRateUnitSequence", 0x300A, 0x063E, [TagLink(RTImageFrameMVRadiationAcquisitionSequence),TagLink(CArmPhotonElectronControlPointSequence),TagLink(TomotherapeuticControlPointSequence),TagLink(RoboticPathControlPointSequence),TagLink(MVImagingGenerationParametersSequence),])
    RadiationGenerationModeMachineCodeSequence = Tag('Radiation Generation Mode Machine Code Sequence', "RadiationGenerationModeMachineCodeSequence", 0x300A, 0x067E, [TagLink(RadiationGenerationModeSequence),])
    RadiationTypeCodeSequence = Tag('Radiation Type Code Sequence', "RadiationTypeCodeSequence", 0x300A, 0x067F, [TagLink(RadiationGenerationModeSequence),])
    EnergyUnitCodeSequence = Tag('Energy Unit Code Sequence', "EnergyUnitCodeSequence", 0x300A, 0x0684, [TagLink(RadiationGenerationModeSequence),])
    RadiationFluenceModifierCodeSequence = Tag('Radiation Fluence Modifier Code Sequence', "RadiationFluenceModifierCodeSequence", 0x300A, 0x0683, [TagLink(RadiationGenerationModeSequence),])
    CompensatorShapeSequence = Tag('Compensator Shape Sequence', "CompensatorShapeSequence", 0x300A, 0x0668, [TagLink(CompensatorDefinitionSequence),])
    CompensatorShapeFabricationCodeSequence = Tag('Compensator Shape Fabrication Code Sequence', "CompensatorShapeFabricationCodeSequence", 0x300A, 0x0667, [TagLink(CompensatorShapeSequence),])
    InterlockCodeSequence = Tag('Interlock Code Sequence', "InterlockCodeSequence", 0x300A, 0x0744, [TagLink(InterlockSequence),])
    InterlockResolutionCodeSequence = Tag('Interlock Resolution Code Sequence', "InterlockResolutionCodeSequence", 0x300A, 0x0745, [TagLink(InterlockSequence),])
    ParallelRTBeamDelimiterDeviceSequence = Tag('Parallel RT Beam Delimiter Device Sequence', "ParallelRTBeamDelimiterDeviceSequence", 0x300A, 0x0647)
    ParallelRTBeamDelimiterDeviceOrientationLabelCodeSequence = Tag('Parallel RT Beam Delimiter Device Orientation Label Code Sequence', "ParallelRTBeamDelimiterDeviceOrientationLabelCodeSequence", 0x300A, 0x0644, [TagLink(ParallelRTBeamDelimiterDeviceSequence),])
    DisplacementReferenceLocationCodeSequence = Tag('Displacement Reference Location Code Sequence', "DisplacementReferenceLocationCodeSequence", 0x300A, 0x079D, [TagLink(RTPatientPositionDisplacementSequence),])
    PatientTreatmentPreparationMethodCodeSequence = Tag('Patient Treatment Preparation Method Code Sequence', "PatientTreatmentPreparationMethodCodeSequence", 0x300A, 0x078D, [TagLink(PatientTreatmentPreparationSequence),])
    PatientTreatmentPreparationProcedureCodeSequence = Tag('Patient Treatment Preparation Procedure Code Sequence', "PatientTreatmentPreparationProcedureCodeSequence", 0x300A, 0x0791, [TagLink(PatientTreatmentPreparationProcedureSequence),])
    EnergyDerivationCodeSequence = Tag('Energy Derivation Code Sequence', "EnergyDerivationCodeSequence", 0x3002, 0x0133, [TagLink(RTImageFramekVRadiationAcquisitionSequence),TagLink(RTImageFrameMVRadiationAcquisitionSequence),TagLink(KVImagingGenerationParametersSequence),TagLink(MVImagingGenerationParametersSequence),])
    RadiationDosimeterUnitSequence = Tag('Radiation Dosimeter Unit Sequence', "RadiationDosimeterUnitSequence", 0x300A, 0x0658, [TagLink(RTImageFrameMVRadiationAcquisitionSequence),TagLink(MVImagingGenerationParametersSequence),])
    RTDiagnosisCodeSequence = Tag('RT Diagnosis Code Sequence', "RTDiagnosisCodeSequence", 0x3010, 0x005D, [TagLink(RTPhysicianIntentSequence),])
    ConceptualVolumeCategoryCodeSequence = Tag('Conceptual Volume Category Code Sequence', "ConceptualVolumeCategoryCodeSequence", 0x3010, 0x0067, [TagLink(RTAnatomicPrescriptionSequence),])
    ConceptualVolumeTypeCodeSequence = Tag('Conceptual Volume Type Code Sequence', "ConceptualVolumeTypeCodeSequence", 0x3010, 0x0069, [TagLink(RTAnatomicPrescriptionSequence),])
    ConceptualVolumeTypeModifierCodeSequence = Tag('Conceptual Volume Type Modifier Code Sequence', "ConceptualVolumeTypeModifierCodeSequence", 0x3010, 0x006A, [TagLink(RTAnatomicPrescriptionSequence),])
    DeliveryTimeStructureCodeSequence = Tag('Delivery Time Structure Code Sequence', "DeliveryTimeStructureCodeSequence", 0x3010, 0x0088, [TagLink(RTPrescriptionSequence),])
    SegmentAnnotationCategoryCodeSequence = Tag('Segment Annotation Category Code Sequence', "SegmentAnnotationCategoryCodeSequence", 0x3010, 0x002B, [TagLink(RTSegmentAnnotationSequence),])
    SegmentAnnotationTypeCodeSequence = Tag('Segment Annotation Type Code Sequence', "SegmentAnnotationTypeCodeSequence", 0x3010, 0x002C, [TagLink(RTSegmentAnnotationSequence),])
    SegmentAnnotationTypeModifierCodeSequence = Tag('Segment Annotation Type Modifier Code Sequence', "SegmentAnnotationTypeModifierCodeSequence", 0x3010, 0x002F, [TagLink(SegmentAnnotationTypeCodeSequence),])
    RTDeviceDistanceReferenceLocationCodeSequence = Tag('RT Device Distance Reference Location Code Sequence', "RTDeviceDistanceReferenceLocationCodeSequence", 0x300A, 0x0659, [TagLink(AcquisitionSubtaskSequence),])
    EquipmentReferencePointCoordinatesSequence = Tag('Equipment Reference Point Coordinates Sequence', "EquipmentReferencePointCoordinatesSequence", 0x300A, 0x0677)
    EquipmentReferencePointCodeSequence = Tag('Equipment Reference Point Code Sequence', "EquipmentReferencePointCodeSequence", 0x300A, 0x0678, [TagLink(EquipmentReferencePointCoordinatesSequence),])
    RoboticPathNodeSetCodeSequence = Tag('Robotic Path Node Set Code Sequence', "RoboticPathNodeSetCodeSequence", 0x3010, 0x0091)
    MeasuredMetersetToDoseMappingSequence = Tag('Measured Meterset to Dose Mapping Sequence', "MeasuredMetersetToDoseMappingSequence", 0x300A, 0x0772, [TagLink(RadiationDoseSequence),])
    DoseMeasurementDeviceCodeSequence = Tag('Dose Measurement Device Code Sequence', "DoseMeasurementDeviceCodeSequence", 0x300A, 0x0774, [TagLink(MeasuredMetersetToDoseMappingSequence),])
    TreatmentToleranceViolationTypeCodeSequence = Tag('Treatment Tolerance Violation Type Code Sequence', "TreatmentToleranceViolationTypeCodeSequence", 0x300A, 0x0761, [TagLink(TreatmentToleranceViolationSequence),])
    TreatmentToleranceViolationCauseCodeSequence = Tag('Treatment Tolerance Violation Cause Code Sequence', "TreatmentToleranceViolationCauseCodeSequence", 0x300A, 0x0762, [TagLink(TreatmentToleranceViolationSequence),])
    ReasonForOmissionCodeSequence = Tag('Reason for Omission Code Sequence', "ReasonForOmissionCodeSequence", 0x300A, 0x0788, [TagLink(OmittedRadiationSequence),])
    AcquisitionTaskWorkitemCodeSequence = Tag('Acquisition Task Workitem Code Sequence', "AcquisitionTaskWorkitemCodeSequence", 0x3002, 0x0119, [TagLink(AcquisitionTaskSequence),])
    SubtaskWorkitemCodeSequence = Tag('Subtask Workitem Code Sequence', "SubtaskWorkitemCodeSequence", 0x3002, 0x011B, [TagLink(AcquisitionSubtaskSequence),])
    PositionAcquisitionTemplateIdentificationSequence = Tag('Position Acquisition Template Identification Sequence', "PositionAcquisitionTemplateIdentificationSequence", 0x3002, 0x011F, [TagLink(AcquisitionSubtaskSequence),])
    PositionAcquisitionTemplateCodeSequence = Tag('Position Acquisition Template Code Sequence', "PositionAcquisitionTemplateCodeSequence", 0x3002, 0x0122, [TagLink(PositionAcquisitionTemplateIdentificationSequence),])
    AnnotationPropertyCategoryCodeSequence = Tag('Annotation Property Category Code Sequence', "AnnotationPropertyCategoryCodeSequence", 0x006A, 0x0009, [TagLink(AnnotationGroupSequence),])
    AnnotationPropertyTypeCodeSequence = Tag('Annotation Property Type Code Sequence', "AnnotationPropertyTypeCodeSequence", 0x006A, 0x000A, [TagLink(AnnotationGroupSequence),])
    AnnotationPropertyTypeModifierCodeSequence = Tag('Annotation Property Type Modifier Code Sequence', "AnnotationPropertyTypeModifierCodeSequence", 0x006A, 0x000B, [TagLink(AnnotationPropertyTypeCodeSequence),])
    ReasonForRemovalCodeSequence = Tag('Reason for Removal Code Sequence', "ReasonForRemovalCodeSequence", 0x0008, 0x0406, [TagLink(InventoriedStudiesSequence),TagLink(InventoriedSeriesSequence),TagLink(InventoriedInstancesSequence),])
    MontageChannelSourceCodeSequence = Tag('Montage Channel Source Code Sequence', "MontageChannelSourceCodeSequence", 0x0040, 0xB040)
    EquivalentCodeSequence = Tag('Equivalent Code Sequence', "EquivalentCodeSequence", 0x0008, 0x0121, [TagLink(PersonIdentificationCodeSequence),TagLink(InstitutionCodeSequence),TagLink(InstitutionalDepartmentTypeCodeSequence),TagLink(ConceptNameCodeSequence),TagLink(ConceptCodeSequence),TagLink(MeasurementUnitsCodeSequence),TagLink(AnatomicRegionSequence),TagLink(AnatomicRegionModifierSequence),TagLink(PrimaryAnatomicStructureSequence),TagLink(PrimaryAnatomicStructureModifierSequence),TagLink(RequestedProcedureCodeSequence),TagLink(ReasonForRequestedProcedureCodeSequence),TagLink(ScheduledProtocolCodeSequence),TagLink(LanguageCodeSequence),TagLink(PerformedProtocolCodeSequence),TagLink(PatientOrientationCodeSequence),TagLink(PatientOrientationModifierCodeSequence),TagLink(PatientGantryRelationshipCodeSequence),TagLink(PatientEquipmentRelationshipCodeSequence),TagLink(AssigningJurisdictionCodeSequence),TagLink(AssigningAgencyOrDepartmentCodeSequence),TagLink(AlgorithmFamilyCodeSequence),TagLink(AlgorithmNameCodeSequence),TagLink(ViewCodeSequence),TagLink(ViewModifierCodeSequence),TagLink(DeviceMotionParameterCodeSequence),TagLink(SelectorCodeSequenceValue),TagLink(ReferenceBasisCodeSequence),TagLink(ReferenceGeometryCodeSequence),TagLink(AssertionCodeSequence),TagLink(DeviceTypeCodeSequence),TagLink(PurposeOfReferenceCodeSequence),TagLink(PatientLocationCoordinatesCodeSequence),TagLink(EthnicGroupCodeSequence),TagLink(PatientSpeciesCodeSequence),TagLink(PatientBreedCodeSequence),TagLink(BreedRegistryCodeSequence),TagLink(StrainCodeSequence),TagLink(StrainSourceRegistryCodeSequence),TagLink(GeneticModificationsCodeSequence),TagLink(DeidentificationMethodCodeSequence),TagLink(RequestingServiceCodeSequence),TagLink(ProcedureCodeSequence),TagLink(ReasonForPerformedProcedureCodeSequence),TagLink(AdmittingDiagnosesCodeSequence),TagLink(PrincipalDiagnosisCodeSequence),TagLink(PrimaryDiagnosisCodeSequence),TagLink(SecondaryDiagnosesCodeSequence),TagLink(HistologicalDiagnosesCodeSequence),TagLink(PatientSizeCodeSequence),TagLink(ReasonForVisitCodeSequence),TagLink(ClinicalTrialTimePointTypeCodeSequence),TagLink(SeriesDescriptionCodeSequence),TagLink(ContrastBolusAgentSequence),TagLink(ContrastBolusAdministrationRouteSequence),TagLink(AdditionalDrugSequence),TagLink(ContrastBolusIngredientCodeSequence),TagLink(ChannelSourceSequence),TagLink(DeviceSequence),TagLink(InterventionSequence),TagLink(InterventionDrugCodeSequence),TagLink(AdministrationRouteCodeSequence),TagLink(DerivationCodeSequence),TagLink(PatientPhysiologicalStateCodeSequence),TagLink(ContainerTypeCodeSequence),TagLink(ContainerComponentTypeCodeSequence),TagLink(SpecimenTypeCodeSequence),TagLink(CTDIPhantomTypeCodeSequence),TagLink(WaterEquivalentDiameterCalculationMethodCodeSequence),TagLink(RadionuclideCodeSequence),TagLink(RadiopharmaceuticalCodeSequence),TagLink(PixelValueMappingCodeSequence),TagLink(StageCodeSequence),TagLink(DocumentClassCodeSequence),TagLink(TreatmentSiteCodeSequence),TagLink(TreatmentSiteModifierCodeSequence),TagLink(RTProtocolCodeSequence),TagLink(ROIObservationContextCodeSequence),TagLink(SegmentedPropertyCategoryCodeSequence),TagLink(RTROIIdentificationCodeSequence),TagLink(SegmentedPropertyTypeModifierCodeSequence),TagLink(TherapeuticRoleCategoryCodeSequence),TagLink(TherapeuticRoleTypeCodeSequence),TagLink(RTTreatmentTechniqueCodeSequence),TagLink(RTTreatmentTerminationReasonCodeSequence),TagLink(MachineSpecificTreatmentTerminationCodeSequence),TagLink(ProjectionEponymousNameCodeSequence),TagLink(PartialViewCodeSequence),TagLink(ChannelDescriptionCodeSequence),TagLink(IlluminatorTypeCodeSequence),TagLink(IlluminationColorCodeSequence),TagLink(IlluminationTypeCodeSequence),TagLink(LightPathFilterTypeStackCodeSequence),TagLink(ImagePathFilterTypeStackCodeSequence),TagLink(LensesCodeSequence),TagLink(MetaboliteMapCodeSequence),TagLink(MaterialCodeSequence),TagLink(AcquisitionDeviceTypeCodeSequence),TagLink(PatientEyeMovementCommandCodeSequence),TagLink(RelativeImagePositionCodeSequence),TagLink(MydriaticAgentCodeSequence),TagLink(MydriaticAgentConcentrationUnitsSequence),TagLink(ScanPatternTypeCodeSequence),TagLink(TransformationMethodCodeSequence),TagLink(OphthalmicImageTypeCodeSequence),TagLink(SegmentedPropertyTypeCodeSequence),TagLink(EventCodeSequence),TagLink(TransducerScanPatternCodeSequence),TagLink(TransducerGeometryCodeSequence),TagLink(TransducerBeamSteeringCodeSequence),TagLink(TransducerApplicationCodeSequence),TagLink(VisualAcuityTypeCodeSequence),TagLink(OphthalmicUltrasoundMethodCodeSequence),TagLink(AnteriorChamberDepthDefinitionCodeSequence),TagLink(LensStatusCodeSequence),TagLink(VitreousStatusCodeSequence),TagLink(OphthalmicAxialLengthMeasurementsSegmentNameCodeSequence),TagLink(OphthalmicAxialLengthDataSourceCodeSequence),TagLink(OphthalmicAxialLengthSelectionMethodCodeSequence),TagLink(RefractiveSurgeryTypeCodeSequence),TagLink(RefractiveErrorBeforeRefractiveSurgeryCodeSequence),TagLink(SourceOfCornealSizeDataCodeSequence),TagLink(SourceOfLensThicknessDataCodeSequence),TagLink(SourceOfAnteriorChamberDepthDataCodeSequence),TagLink(SourceOfRefractiveMeasurementsCodeSequence),TagLink(SourceOfCorneaMeasurementDataCodeSequence),TagLink(IOLFormulaCodeSequence),TagLink(KeratometryMeasurementTypeCodeSequence),TagLink(SourceOfOphthalmicAxialLengthCodeSequence),TagLink(CorneaMeasurementMethodCodeSequence),TagLink(ScreeningTestModeCodeSequence),TagLink(StimulusColorCodeSequence),TagLink(BackgroundIlluminationColorCodeSequence),TagLink(FixationMonitoringCodeSequence),TagLink(ModeOfPercutaneousAccessSequence),TagLink(AcquisitionMethodCodeSequence),TagLink(OphthalmicThicknessMapTypeCodeSequence),TagLink(RetinalThicknessDefinitionCodeSequence),TagLink(SurfaceScanAcquisitionTypeCodeSequence),TagLink(SurfaceScanModeCodeSequence),TagLink(RegistrationMethodCodeSequence),TagLink(CornealTopographyMapTypeCodeSequence),TagLink(TrackSetAnatomicalTypeCodeSequence),TagLink(ModifierCodeSequence),TagLink(DiffusionAcquisitionCodeSequence),TagLink(DiffusionModelCodeSequence),TagLink(AcousticCouplingMediumCodeSequence),TagLink(TransducerTechnologySequence),TagLink(SoundSpeedCorrectionMechanismCodeSequence),TagLink(ImageDataTypeCodeSequence),TagLink(ChannelSourceModifiersSequence),TagLink(ChannelSensitivityUnitsSequence),TagLink(AnalogFilterTypeCodeSequence),TagLink(DigitalFilterTypeCodeSequence),TagLink(FrequencyEncodingCodeSequence),TagLink(MagnitudeEncodingCodeSequence),TagLink(DigitalSignaturePurposeCodeSequence),TagLink(VerifyingObserverIdentificationCodeSequence),TagLink(ResponsibleGroupCodeSequence),TagLink(PerformedProcedureCodeSequence),TagLink(OrganizationalRoleCodeSequence),TagLink(NumericValueQualifierCodeSequence),TagLink(RegistrationTypeCodeSequence),TagLink(FiducialsPropertyCategoryCodeSequence),TagLink(FiducialIdentifierCodeSequence),TagLink(AbstractPriorCodeSequence),TagLink(HangingProtocolUserIdentificationCodeSequence),TagLink(ImplantRegulatoryDisapprovalCodeSequence),TagLink(MaterialsCodeSequence),TagLink(CoatingMaterialsCodeSequence),TagLink(ImplantTypeCodeSequence),TagLink(FixationMethodCodeSequence),TagLink(ViewOrientationCodeSequence),TagLink(ViewOrientationModifierCodeSequence),TagLink(PlanningLandmarkIdentificationCodeSequence),TagLink(ProcedureTypeCodeSequence),TagLink(ComponentTypeCodeSequence),TagLink(AssessmentTypeCodeSequence),TagLink(ObservationBasisCodeSequence),TagLink(PotentialScheduledProtocolCodeSequence),TagLink(PotentialRequestedProcedureCodeSequence),TagLink(PotentialReasonsForProcedureCodeSequence),TagLink(ContraindicationsCodeSequence),TagLink(PositioningMethodCodeSequence),TagLink(RequestedSeriesDescriptionCodeSequence),TagLink(ModelUsageCodeSequence),TagLink(DosimetricObjectiveTypeCodeSequence),TagLink(EffectiveDoseCalculationMethodCategoryCodeSequence),TagLink(EffectiveDoseCalculationMethodCodeSequence),TagLink(TreatmentMachineSpecialModeCodeSequence),TagLink(DeliveryRateUnitSequence),TagLink(RadiationGenerationModeMachineCodeSequence),TagLink(RadiationTypeCodeSequence),TagLink(EnergyUnitCodeSequence),TagLink(RadiationFluenceModifierCodeSequence),TagLink(CompensatorShapeFabricationCodeSequence),TagLink(InterlockCodeSequence),TagLink(InterlockResolutionCodeSequence),TagLink(ParallelRTBeamDelimiterDeviceOrientationLabelCodeSequence),TagLink(DisplacementReferenceLocationCodeSequence),TagLink(PatientTreatmentPreparationMethodCodeSequence),TagLink(PatientTreatmentPreparationProcedureCodeSequence),TagLink(EnergyDerivationCodeSequence),TagLink(RadiationDosimeterUnitSequence),TagLink(RTDiagnosisCodeSequence),TagLink(ConceptualVolumeCategoryCodeSequence),TagLink(ConceptualVolumeTypeCodeSequence),TagLink(ConceptualVolumeTypeModifierCodeSequence),TagLink(DeliveryTimeStructureCodeSequence),TagLink(SegmentAnnotationCategoryCodeSequence),TagLink(SegmentAnnotationTypeCodeSequence),TagLink(SegmentAnnotationTypeModifierCodeSequence),TagLink(RTDeviceDistanceReferenceLocationCodeSequence),TagLink(EquipmentReferencePointCodeSequence),TagLink(RoboticPathNodeSetCodeSequence),TagLink(DoseMeasurementDeviceCodeSequence),TagLink(TreatmentToleranceViolationTypeCodeSequence),TagLink(TreatmentToleranceViolationCauseCodeSequence),TagLink(ReasonForOmissionCodeSequence),TagLink(AcquisitionTaskWorkitemCodeSequence),TagLink(SubtaskWorkitemCodeSequence),TagLink(PositionAcquisitionTemplateCodeSequence),TagLink(AnnotationPropertyCategoryCodeSequence),TagLink(AnnotationPropertyTypeCodeSequence),TagLink(AnnotationPropertyTypeModifierCodeSequence),TagLink(ReasonForRemovalCodeSequence),TagLink(AnatomicRegionsInStudyCodeSequence),TagLink(MontageChannelSourceCodeSequence),])
    CodeValue = Tag('Code Value', "CodeValue", 0x0008, 0x0100, [TagLink(EquivalentCodeSequence),TagLink(PersonIdentificationCodeSequence),TagLink(InstitutionCodeSequence),TagLink(InstitutionalDepartmentTypeCodeSequence),TagLink(ConceptNameCodeSequence),TagLink(ConceptCodeSequence),TagLink(MeasurementUnitsCodeSequence),TagLink(AnatomicRegionSequence),TagLink(AnatomicRegionModifierSequence),TagLink(PrimaryAnatomicStructureSequence),TagLink(PrimaryAnatomicStructureModifierSequence),TagLink(RequestedProcedureCodeSequence),TagLink(ReasonForRequestedProcedureCodeSequence),TagLink(ScheduledProtocolCodeSequence),TagLink(LanguageCodeSequence),TagLink(PerformedProtocolCodeSequence),TagLink(PatientOrientationCodeSequence),TagLink(PatientOrientationModifierCodeSequence),TagLink(PatientGantryRelationshipCodeSequence),TagLink(PatientEquipmentRelationshipCodeSequence),TagLink(AssigningJurisdictionCodeSequence),TagLink(AssigningAgencyOrDepartmentCodeSequence),TagLink(AlgorithmFamilyCodeSequence),TagLink(AlgorithmNameCodeSequence),TagLink(ViewCodeSequence),TagLink(ViewModifierCodeSequence),TagLink(DeviceMotionParameterCodeSequence),TagLink(SelectorCodeSequenceValue),TagLink(ReferenceBasisCodeSequence),TagLink(ReferenceGeometryCodeSequence),TagLink(AssertionCodeSequence),TagLink(DeviceTypeCodeSequence),TagLink(PurposeOfReferenceCodeSequence),TagLink(PatientLocationCoordinatesCodeSequence),TagLink(EthnicGroupCodeSequence),TagLink(PatientSpeciesCodeSequence),TagLink(PatientBreedCodeSequence),TagLink(BreedRegistryCodeSequence),TagLink(StrainCodeSequence),TagLink(StrainSourceRegistryCodeSequence),TagLink(GeneticModificationsCodeSequence),TagLink(DeidentificationMethodCodeSequence),TagLink(RequestingServiceCodeSequence),TagLink(ProcedureCodeSequence),TagLink(ReasonForPerformedProcedureCodeSequence),TagLink(AdmittingDiagnosesCodeSequence),TagLink(PrincipalDiagnosisCodeSequence),TagLink(PrimaryDiagnosisCodeSequence),TagLink(SecondaryDiagnosesCodeSequence),TagLink(HistologicalDiagnosesCodeSequence),TagLink(PatientSizeCodeSequence),TagLink(ReasonForVisitCodeSequence),TagLink(ClinicalTrialTimePointTypeCodeSequence),TagLink(SeriesDescriptionCodeSequence),TagLink(ContrastBolusAgentSequence),TagLink(ContrastBolusAdministrationRouteSequence),TagLink(AdditionalDrugSequence),TagLink(ContrastBolusIngredientCodeSequence),TagLink(ChannelSourceSequence),TagLink(DeviceSequence),TagLink(InterventionSequence),TagLink(InterventionDrugCodeSequence),TagLink(AdministrationRouteCodeSequence),TagLink(DerivationCodeSequence),TagLink(PatientPhysiologicalStateCodeSequence),TagLink(ContainerTypeCodeSequence),TagLink(ContainerComponentTypeCodeSequence),TagLink(SpecimenTypeCodeSequence),TagLink(CTDIPhantomTypeCodeSequence),TagLink(WaterEquivalentDiameterCalculationMethodCodeSequence),TagLink(RadionuclideCodeSequence),TagLink(RadiopharmaceuticalCodeSequence),TagLink(PixelValueMappingCodeSequence),TagLink(StageCodeSequence),TagLink(DocumentClassCodeSequence),TagLink(TreatmentSiteCodeSequence),TagLink(TreatmentSiteModifierCodeSequence),TagLink(RTProtocolCodeSequence),TagLink(ROIObservationContextCodeSequence),TagLink(SegmentedPropertyCategoryCodeSequence),TagLink(RTROIIdentificationCodeSequence),TagLink(SegmentedPropertyTypeModifierCodeSequence),TagLink(TherapeuticRoleCategoryCodeSequence),TagLink(TherapeuticRoleTypeCodeSequence),TagLink(RTTreatmentTechniqueCodeSequence),TagLink(RTTreatmentTerminationReasonCodeSequence),TagLink(MachineSpecificTreatmentTerminationCodeSequence),TagLink(ProjectionEponymousNameCodeSequence),TagLink(PartialViewCodeSequence),TagLink(ChannelDescriptionCodeSequence),TagLink(IlluminatorTypeCodeSequence),TagLink(IlluminationColorCodeSequence),TagLink(IlluminationTypeCodeSequence),TagLink(LightPathFilterTypeStackCodeSequence),TagLink(ImagePathFilterTypeStackCodeSequence),TagLink(LensesCodeSequence),TagLink(MetaboliteMapCodeSequence),TagLink(MaterialCodeSequence),TagLink(AcquisitionDeviceTypeCodeSequence),TagLink(PatientEyeMovementCommandCodeSequence),TagLink(RelativeImagePositionCodeSequence),TagLink(MydriaticAgentCodeSequence),TagLink(MydriaticAgentConcentrationUnitsSequence),TagLink(ScanPatternTypeCodeSequence),TagLink(TransformationMethodCodeSequence),TagLink(OphthalmicImageTypeCodeSequence),TagLink(SegmentedPropertyTypeCodeSequence),TagLink(EventCodeSequence),TagLink(TransducerScanPatternCodeSequence),TagLink(TransducerGeometryCodeSequence),TagLink(TransducerBeamSteeringCodeSequence),TagLink(TransducerApplicationCodeSequence),TagLink(VisualAcuityTypeCodeSequence),TagLink(OphthalmicUltrasoundMethodCodeSequence),TagLink(AnteriorChamberDepthDefinitionCodeSequence),TagLink(LensStatusCodeSequence),TagLink(VitreousStatusCodeSequence),TagLink(OphthalmicAxialLengthMeasurementsSegmentNameCodeSequence),TagLink(OphthalmicAxialLengthDataSourceCodeSequence),TagLink(OphthalmicAxialLengthSelectionMethodCodeSequence),TagLink(RefractiveSurgeryTypeCodeSequence),TagLink(RefractiveErrorBeforeRefractiveSurgeryCodeSequence),TagLink(SourceOfCornealSizeDataCodeSequence),TagLink(SourceOfLensThicknessDataCodeSequence),TagLink(SourceOfAnteriorChamberDepthDataCodeSequence),TagLink(SourceOfRefractiveMeasurementsCodeSequence),TagLink(SourceOfCorneaMeasurementDataCodeSequence),TagLink(IOLFormulaCodeSequence),TagLink(KeratometryMeasurementTypeCodeSequence),TagLink(SourceOfOphthalmicAxialLengthCodeSequence),TagLink(CorneaMeasurementMethodCodeSequence),TagLink(ScreeningTestModeCodeSequence),TagLink(StimulusColorCodeSequence),TagLink(BackgroundIlluminationColorCodeSequence),TagLink(FixationMonitoringCodeSequence),TagLink(ModeOfPercutaneousAccessSequence),TagLink(AcquisitionMethodCodeSequence),TagLink(OphthalmicThicknessMapTypeCodeSequence),TagLink(RetinalThicknessDefinitionCodeSequence),TagLink(SurfaceScanAcquisitionTypeCodeSequence),TagLink(SurfaceScanModeCodeSequence),TagLink(RegistrationMethodCodeSequence),TagLink(CornealTopographyMapTypeCodeSequence),TagLink(TrackSetAnatomicalTypeCodeSequence),TagLink(ModifierCodeSequence),TagLink(DiffusionAcquisitionCodeSequence),TagLink(DiffusionModelCodeSequence),TagLink(AcousticCouplingMediumCodeSequence),TagLink(TransducerTechnologySequence),TagLink(SoundSpeedCorrectionMechanismCodeSequence),TagLink(ImageDataTypeCodeSequence),TagLink(ChannelSourceModifiersSequence),TagLink(ChannelSensitivityUnitsSequence),TagLink(AnalogFilterTypeCodeSequence),TagLink(DigitalFilterTypeCodeSequence),TagLink(FrequencyEncodingCodeSequence),TagLink(MagnitudeEncodingCodeSequence),TagLink(DigitalSignaturePurposeCodeSequence),TagLink(VerifyingObserverIdentificationCodeSequence),TagLink(ResponsibleGroupCodeSequence),TagLink(PerformedProcedureCodeSequence),TagLink(OrganizationalRoleCodeSequence),TagLink(NumericValueQualifierCodeSequence),TagLink(RegistrationTypeCodeSequence),TagLink(FiducialsPropertyCategoryCodeSequence),TagLink(FiducialIdentifierCodeSequence),TagLink(AbstractPriorCodeSequence),TagLink(HangingProtocolUserIdentificationCodeSequence),TagLink(ImplantRegulatoryDisapprovalCodeSequence),TagLink(MaterialsCodeSequence),TagLink(CoatingMaterialsCodeSequence),TagLink(ImplantTypeCodeSequence),TagLink(FixationMethodCodeSequence),TagLink(ViewOrientationCodeSequence),TagLink(ViewOrientationModifierCodeSequence),TagLink(PlanningLandmarkIdentificationCodeSequence),TagLink(ProcedureTypeCodeSequence),TagLink(ComponentTypeCodeSequence),TagLink(AssessmentTypeCodeSequence),TagLink(ObservationBasisCodeSequence),TagLink(PotentialScheduledProtocolCodeSequence),TagLink(PotentialRequestedProcedureCodeSequence),TagLink(PotentialReasonsForProcedureCodeSequence),TagLink(ContraindicationsCodeSequence),TagLink(PositioningMethodCodeSequence),TagLink(RequestedSeriesDescriptionCodeSequence),TagLink(ModelUsageCodeSequence),TagLink(DosimetricObjectiveTypeCodeSequence),TagLink(EffectiveDoseCalculationMethodCategoryCodeSequence),TagLink(EffectiveDoseCalculationMethodCodeSequence),TagLink(TreatmentMachineSpecialModeCodeSequence),TagLink(DeliveryRateUnitSequence),TagLink(RadiationGenerationModeMachineCodeSequence),TagLink(RadiationTypeCodeSequence),TagLink(EnergyUnitCodeSequence),TagLink(RadiationFluenceModifierCodeSequence),TagLink(CompensatorShapeFabricationCodeSequence),TagLink(InterlockCodeSequence),TagLink(InterlockResolutionCodeSequence),TagLink(ParallelRTBeamDelimiterDeviceOrientationLabelCodeSequence),TagLink(DisplacementReferenceLocationCodeSequence),TagLink(PatientTreatmentPreparationMethodCodeSequence),TagLink(PatientTreatmentPreparationProcedureCodeSequence),TagLink(EnergyDerivationCodeSequence),TagLink(RadiationDosimeterUnitSequence),TagLink(RTDiagnosisCodeSequence),TagLink(ConceptualVolumeCategoryCodeSequence),TagLink(ConceptualVolumeTypeCodeSequence),TagLink(ConceptualVolumeTypeModifierCodeSequence),TagLink(DeliveryTimeStructureCodeSequence),TagLink(SegmentAnnotationCategoryCodeSequence),TagLink(SegmentAnnotationTypeCodeSequence),TagLink(SegmentAnnotationTypeModifierCodeSequence),TagLink(RTDeviceDistanceReferenceLocationCodeSequence),TagLink(EquipmentReferencePointCodeSequence),TagLink(RoboticPathNodeSetCodeSequence),TagLink(DoseMeasurementDeviceCodeSequence),TagLink(TreatmentToleranceViolationTypeCodeSequence),TagLink(TreatmentToleranceViolationCauseCodeSequence),TagLink(ReasonForOmissionCodeSequence),TagLink(AcquisitionTaskWorkitemCodeSequence),TagLink(SubtaskWorkitemCodeSequence),TagLink(PositionAcquisitionTemplateCodeSequence),TagLink(AnnotationPropertyCategoryCodeSequence),TagLink(AnnotationPropertyTypeCodeSequence),TagLink(AnnotationPropertyTypeModifierCodeSequence),TagLink(ReasonForRemovalCodeSequence),TagLink(AnatomicRegionsInStudyCodeSequence),TagLink(MontageChannelSourceCodeSequence),])
    ExtendedCodeValue = Tag('Extended Code Value', "ExtendedCodeValue", 0x0008, 0x0101)
    CodingSchemeIdentificationSequence = Tag('Coding Scheme Identification Sequence', "CodingSchemeIdentificationSequence", 0x0008, 0x0110)
    CodingSchemeDesignator = Tag('Coding Scheme Designator', "CodingSchemeDesignator", 0x0008, 0x0102, [TagLink(EquivalentCodeSequence),TagLink(PersonIdentificationCodeSequence),TagLink(InstitutionCodeSequence),TagLink(InstitutionalDepartmentTypeCodeSequence),TagLink(ConceptNameCodeSequence),TagLink(ConceptCodeSequence),TagLink(MeasurementUnitsCodeSequence),TagLink(AnatomicRegionSequence),TagLink(AnatomicRegionModifierSequence),TagLink(PrimaryAnatomicStructureSequence),TagLink(PrimaryAnatomicStructureModifierSequence),TagLink(RequestedProcedureCodeSequence),TagLink(ReasonForRequestedProcedureCodeSequence),TagLink(ScheduledProtocolCodeSequence),TagLink(LanguageCodeSequence),TagLink(PerformedProtocolCodeSequence),TagLink(PatientOrientationCodeSequence),TagLink(PatientOrientationModifierCodeSequence),TagLink(PatientGantryRelationshipCodeSequence),TagLink(PatientEquipmentRelationshipCodeSequence),TagLink(AssigningJurisdictionCodeSequence),TagLink(AssigningAgencyOrDepartmentCodeSequence),TagLink(AlgorithmFamilyCodeSequence),TagLink(AlgorithmNameCodeSequence),TagLink(ViewCodeSequence),TagLink(ViewModifierCodeSequence),TagLink(DeviceMotionParameterCodeSequence),TagLink(SelectorCodeSequenceValue),TagLink(ReferenceBasisCodeSequence),TagLink(ReferenceGeometryCodeSequence),TagLink(AssertionCodeSequence),TagLink(DeviceTypeCodeSequence),TagLink(PurposeOfReferenceCodeSequence),TagLink(PatientLocationCoordinatesCodeSequence),TagLink(EthnicGroupCodeSequence),TagLink(PatientSpeciesCodeSequence),TagLink(PatientBreedCodeSequence),TagLink(BreedRegistryCodeSequence),TagLink(StrainCodeSequence),TagLink(StrainSourceRegistryCodeSequence),TagLink(GeneticModificationsCodeSequence),TagLink(DeidentificationMethodCodeSequence),TagLink(RequestingServiceCodeSequence),TagLink(ProcedureCodeSequence),TagLink(ReasonForPerformedProcedureCodeSequence),TagLink(AdmittingDiagnosesCodeSequence),TagLink(PrincipalDiagnosisCodeSequence),TagLink(PrimaryDiagnosisCodeSequence),TagLink(SecondaryDiagnosesCodeSequence),TagLink(HistologicalDiagnosesCodeSequence),TagLink(PatientSizeCodeSequence),TagLink(ReasonForVisitCodeSequence),TagLink(ClinicalTrialTimePointTypeCodeSequence),TagLink(SeriesDescriptionCodeSequence),TagLink(ContrastBolusAgentSequence),TagLink(ContrastBolusAdministrationRouteSequence),TagLink(AdditionalDrugSequence),TagLink(ContrastBolusIngredientCodeSequence),TagLink(ChannelSourceSequence),TagLink(DeviceSequence),TagLink(InterventionSequence),TagLink(InterventionDrugCodeSequence),TagLink(AdministrationRouteCodeSequence),TagLink(DerivationCodeSequence),TagLink(PatientPhysiologicalStateCodeSequence),TagLink(ContainerTypeCodeSequence),TagLink(ContainerComponentTypeCodeSequence),TagLink(SpecimenTypeCodeSequence),TagLink(CTDIPhantomTypeCodeSequence),TagLink(WaterEquivalentDiameterCalculationMethodCodeSequence),TagLink(RadionuclideCodeSequence),TagLink(RadiopharmaceuticalCodeSequence),TagLink(PixelValueMappingCodeSequence),TagLink(StageCodeSequence),TagLink(DocumentClassCodeSequence),TagLink(TreatmentSiteCodeSequence),TagLink(TreatmentSiteModifierCodeSequence),TagLink(RTProtocolCodeSequence),TagLink(ROIObservationContextCodeSequence),TagLink(SegmentedPropertyCategoryCodeSequence),TagLink(RTROIIdentificationCodeSequence),TagLink(SegmentedPropertyTypeModifierCodeSequence),TagLink(TherapeuticRoleCategoryCodeSequence),TagLink(TherapeuticRoleTypeCodeSequence),TagLink(RTTreatmentTechniqueCodeSequence),TagLink(RTTreatmentTerminationReasonCodeSequence),TagLink(MachineSpecificTreatmentTerminationCodeSequence),TagLink(ProjectionEponymousNameCodeSequence),TagLink(PartialViewCodeSequence),TagLink(ChannelDescriptionCodeSequence),TagLink(IlluminatorTypeCodeSequence),TagLink(IlluminationColorCodeSequence),TagLink(IlluminationTypeCodeSequence),TagLink(LightPathFilterTypeStackCodeSequence),TagLink(ImagePathFilterTypeStackCodeSequence),TagLink(LensesCodeSequence),TagLink(MetaboliteMapCodeSequence),TagLink(MaterialCodeSequence),TagLink(AcquisitionDeviceTypeCodeSequence),TagLink(PatientEyeMovementCommandCodeSequence),TagLink(RelativeImagePositionCodeSequence),TagLink(MydriaticAgentCodeSequence),TagLink(MydriaticAgentConcentrationUnitsSequence),TagLink(ScanPatternTypeCodeSequence),TagLink(TransformationMethodCodeSequence),TagLink(OphthalmicImageTypeCodeSequence),TagLink(SegmentedPropertyTypeCodeSequence),TagLink(EventCodeSequence),TagLink(TransducerScanPatternCodeSequence),TagLink(TransducerGeometryCodeSequence),TagLink(TransducerBeamSteeringCodeSequence),TagLink(TransducerApplicationCodeSequence),TagLink(VisualAcuityTypeCodeSequence),TagLink(OphthalmicUltrasoundMethodCodeSequence),TagLink(AnteriorChamberDepthDefinitionCodeSequence),TagLink(LensStatusCodeSequence),TagLink(VitreousStatusCodeSequence),TagLink(OphthalmicAxialLengthMeasurementsSegmentNameCodeSequence),TagLink(OphthalmicAxialLengthDataSourceCodeSequence),TagLink(OphthalmicAxialLengthSelectionMethodCodeSequence),TagLink(RefractiveSurgeryTypeCodeSequence),TagLink(RefractiveErrorBeforeRefractiveSurgeryCodeSequence),TagLink(SourceOfCornealSizeDataCodeSequence),TagLink(SourceOfLensThicknessDataCodeSequence),TagLink(SourceOfAnteriorChamberDepthDataCodeSequence),TagLink(SourceOfRefractiveMeasurementsCodeSequence),TagLink(SourceOfCorneaMeasurementDataCodeSequence),TagLink(IOLFormulaCodeSequence),TagLink(KeratometryMeasurementTypeCodeSequence),TagLink(SourceOfOphthalmicAxialLengthCodeSequence),TagLink(CorneaMeasurementMethodCodeSequence),TagLink(ScreeningTestModeCodeSequence),TagLink(StimulusColorCodeSequence),TagLink(BackgroundIlluminationColorCodeSequence),TagLink(FixationMonitoringCodeSequence),TagLink(ModeOfPercutaneousAccessSequence),TagLink(AcquisitionMethodCodeSequence),TagLink(OphthalmicThicknessMapTypeCodeSequence),TagLink(RetinalThicknessDefinitionCodeSequence),TagLink(SurfaceScanAcquisitionTypeCodeSequence),TagLink(SurfaceScanModeCodeSequence),TagLink(RegistrationMethodCodeSequence),TagLink(CornealTopographyMapTypeCodeSequence),TagLink(TrackSetAnatomicalTypeCodeSequence),TagLink(ModifierCodeSequence),TagLink(DiffusionAcquisitionCodeSequence),TagLink(DiffusionModelCodeSequence),TagLink(AcousticCouplingMediumCodeSequence),TagLink(TransducerTechnologySequence),TagLink(SoundSpeedCorrectionMechanismCodeSequence),TagLink(ImageDataTypeCodeSequence),TagLink(ChannelSourceModifiersSequence),TagLink(ChannelSensitivityUnitsSequence),TagLink(AnalogFilterTypeCodeSequence),TagLink(DigitalFilterTypeCodeSequence),TagLink(FrequencyEncodingCodeSequence),TagLink(MagnitudeEncodingCodeSequence),TagLink(CodingSchemeIdentificationSequence),TagLink(DigitalSignaturePurposeCodeSequence),TagLink(VerifyingObserverIdentificationCodeSequence),TagLink(ResponsibleGroupCodeSequence),TagLink(PerformedProcedureCodeSequence),TagLink(OrganizationalRoleCodeSequence),TagLink(NumericValueQualifierCodeSequence),TagLink(RegistrationTypeCodeSequence),TagLink(FiducialsPropertyCategoryCodeSequence),TagLink(FiducialIdentifierCodeSequence),TagLink(AbstractPriorCodeSequence),TagLink(HangingProtocolUserIdentificationCodeSequence),TagLink(ImplantRegulatoryDisapprovalCodeSequence),TagLink(MaterialsCodeSequence),TagLink(CoatingMaterialsCodeSequence),TagLink(ImplantTypeCodeSequence),TagLink(FixationMethodCodeSequence),TagLink(ViewOrientationCodeSequence),TagLink(ViewOrientationModifierCodeSequence),TagLink(PlanningLandmarkIdentificationCodeSequence),TagLink(ProcedureTypeCodeSequence),TagLink(ComponentTypeCodeSequence),TagLink(AssessmentTypeCodeSequence),TagLink(ObservationBasisCodeSequence),TagLink(PotentialScheduledProtocolCodeSequence),TagLink(PotentialRequestedProcedureCodeSequence),TagLink(PotentialReasonsForProcedureCodeSequence),TagLink(ContraindicationsCodeSequence),TagLink(PositioningMethodCodeSequence),TagLink(RequestedSeriesDescriptionCodeSequence),TagLink(ModelUsageCodeSequence),TagLink(DosimetricObjectiveTypeCodeSequence),TagLink(EffectiveDoseCalculationMethodCategoryCodeSequence),TagLink(EffectiveDoseCalculationMethodCodeSequence),TagLink(TreatmentMachineSpecialModeCodeSequence),TagLink(DeliveryRateUnitSequence),TagLink(RadiationGenerationModeMachineCodeSequence),TagLink(RadiationTypeCodeSequence),TagLink(EnergyUnitCodeSequence),TagLink(RadiationFluenceModifierCodeSequence),TagLink(CompensatorShapeFabricationCodeSequence),TagLink(InterlockCodeSequence),TagLink(InterlockResolutionCodeSequence),TagLink(ParallelRTBeamDelimiterDeviceOrientationLabelCodeSequence),TagLink(DisplacementReferenceLocationCodeSequence),TagLink(PatientTreatmentPreparationMethodCodeSequence),TagLink(PatientTreatmentPreparationProcedureCodeSequence),TagLink(EnergyDerivationCodeSequence),TagLink(RadiationDosimeterUnitSequence),TagLink(RTDiagnosisCodeSequence),TagLink(ConceptualVolumeCategoryCodeSequence),TagLink(ConceptualVolumeTypeCodeSequence),TagLink(ConceptualVolumeTypeModifierCodeSequence),TagLink(DeliveryTimeStructureCodeSequence),TagLink(SegmentAnnotationCategoryCodeSequence),TagLink(SegmentAnnotationTypeCodeSequence),TagLink(SegmentAnnotationTypeModifierCodeSequence),TagLink(RTDeviceDistanceReferenceLocationCodeSequence),TagLink(EquipmentReferencePointCodeSequence),TagLink(RoboticPathNodeSetCodeSequence),TagLink(DoseMeasurementDeviceCodeSequence),TagLink(TreatmentToleranceViolationTypeCodeSequence),TagLink(TreatmentToleranceViolationCauseCodeSequence),TagLink(ReasonForOmissionCodeSequence),TagLink(AcquisitionTaskWorkitemCodeSequence),TagLink(SubtaskWorkitemCodeSequence),TagLink(PositionAcquisitionTemplateCodeSequence),TagLink(AnnotationPropertyCategoryCodeSequence),TagLink(AnnotationPropertyTypeCodeSequence),TagLink(AnnotationPropertyTypeModifierCodeSequence),TagLink(ReasonForRemovalCodeSequence),TagLink(AnatomicRegionsInStudyCodeSequence),TagLink(MontageChannelSourceCodeSequence),])
    CodingSchemeVersion = Tag('Coding Scheme Version', "CodingSchemeVersion", 0x0008, 0x0103, [TagLink(EquivalentCodeSequence),TagLink(PersonIdentificationCodeSequence),TagLink(InstitutionCodeSequence),TagLink(InstitutionalDepartmentTypeCodeSequence),TagLink(ConceptNameCodeSequence),TagLink(ConceptCodeSequence),TagLink(MeasurementUnitsCodeSequence),TagLink(AnatomicRegionSequence),TagLink(AnatomicRegionModifierSequence),TagLink(PrimaryAnatomicStructureSequence),TagLink(PrimaryAnatomicStructureModifierSequence),TagLink(RequestedProcedureCodeSequence),TagLink(ReasonForRequestedProcedureCodeSequence),TagLink(ScheduledProtocolCodeSequence),TagLink(LanguageCodeSequence),TagLink(PerformedProtocolCodeSequence),TagLink(PatientOrientationCodeSequence),TagLink(PatientOrientationModifierCodeSequence),TagLink(PatientGantryRelationshipCodeSequence),TagLink(PatientEquipmentRelationshipCodeSequence),TagLink(AssigningJurisdictionCodeSequence),TagLink(AssigningAgencyOrDepartmentCodeSequence),TagLink(AlgorithmFamilyCodeSequence),TagLink(AlgorithmNameCodeSequence),TagLink(ViewCodeSequence),TagLink(ViewModifierCodeSequence),TagLink(DeviceMotionParameterCodeSequence),TagLink(SelectorCodeSequenceValue),TagLink(ReferenceBasisCodeSequence),TagLink(ReferenceGeometryCodeSequence),TagLink(AssertionCodeSequence),TagLink(DeviceTypeCodeSequence),TagLink(PurposeOfReferenceCodeSequence),TagLink(PatientLocationCoordinatesCodeSequence),TagLink(EthnicGroupCodeSequence),TagLink(PatientSpeciesCodeSequence),TagLink(PatientBreedCodeSequence),TagLink(BreedRegistryCodeSequence),TagLink(StrainCodeSequence),TagLink(StrainSourceRegistryCodeSequence),TagLink(GeneticModificationsCodeSequence),TagLink(DeidentificationMethodCodeSequence),TagLink(RequestingServiceCodeSequence),TagLink(ProcedureCodeSequence),TagLink(ReasonForPerformedProcedureCodeSequence),TagLink(AdmittingDiagnosesCodeSequence),TagLink(PrincipalDiagnosisCodeSequence),TagLink(PrimaryDiagnosisCodeSequence),TagLink(SecondaryDiagnosesCodeSequence),TagLink(HistologicalDiagnosesCodeSequence),TagLink(PatientSizeCodeSequence),TagLink(ReasonForVisitCodeSequence),TagLink(ClinicalTrialTimePointTypeCodeSequence),TagLink(SeriesDescriptionCodeSequence),TagLink(ContrastBolusAgentSequence),TagLink(ContrastBolusAdministrationRouteSequence),TagLink(AdditionalDrugSequence),TagLink(ContrastBolusIngredientCodeSequence),TagLink(ChannelSourceSequence),TagLink(DeviceSequence),TagLink(InterventionSequence),TagLink(InterventionDrugCodeSequence),TagLink(AdministrationRouteCodeSequence),TagLink(DerivationCodeSequence),TagLink(PatientPhysiologicalStateCodeSequence),TagLink(ContainerTypeCodeSequence),TagLink(ContainerComponentTypeCodeSequence),TagLink(SpecimenTypeCodeSequence),TagLink(CTDIPhantomTypeCodeSequence),TagLink(WaterEquivalentDiameterCalculationMethodCodeSequence),TagLink(RadionuclideCodeSequence),TagLink(RadiopharmaceuticalCodeSequence),TagLink(PixelValueMappingCodeSequence),TagLink(StageCodeSequence),TagLink(DocumentClassCodeSequence),TagLink(TreatmentSiteCodeSequence),TagLink(TreatmentSiteModifierCodeSequence),TagLink(RTProtocolCodeSequence),TagLink(ROIObservationContextCodeSequence),TagLink(SegmentedPropertyCategoryCodeSequence),TagLink(RTROIIdentificationCodeSequence),TagLink(SegmentedPropertyTypeModifierCodeSequence),TagLink(TherapeuticRoleCategoryCodeSequence),TagLink(TherapeuticRoleTypeCodeSequence),TagLink(RTTreatmentTechniqueCodeSequence),TagLink(RTTreatmentTerminationReasonCodeSequence),TagLink(MachineSpecificTreatmentTerminationCodeSequence),TagLink(ProjectionEponymousNameCodeSequence),TagLink(PartialViewCodeSequence),TagLink(ChannelDescriptionCodeSequence),TagLink(IlluminatorTypeCodeSequence),TagLink(IlluminationColorCodeSequence),TagLink(IlluminationTypeCodeSequence),TagLink(LightPathFilterTypeStackCodeSequence),TagLink(ImagePathFilterTypeStackCodeSequence),TagLink(LensesCodeSequence),TagLink(MetaboliteMapCodeSequence),TagLink(MaterialCodeSequence),TagLink(AcquisitionDeviceTypeCodeSequence),TagLink(PatientEyeMovementCommandCodeSequence),TagLink(RelativeImagePositionCodeSequence),TagLink(MydriaticAgentCodeSequence),TagLink(MydriaticAgentConcentrationUnitsSequence),TagLink(ScanPatternTypeCodeSequence),TagLink(TransformationMethodCodeSequence),TagLink(OphthalmicImageTypeCodeSequence),TagLink(SegmentedPropertyTypeCodeSequence),TagLink(EventCodeSequence),TagLink(TransducerScanPatternCodeSequence),TagLink(TransducerGeometryCodeSequence),TagLink(TransducerBeamSteeringCodeSequence),TagLink(TransducerApplicationCodeSequence),TagLink(VisualAcuityTypeCodeSequence),TagLink(OphthalmicUltrasoundMethodCodeSequence),TagLink(AnteriorChamberDepthDefinitionCodeSequence),TagLink(LensStatusCodeSequence),TagLink(VitreousStatusCodeSequence),TagLink(OphthalmicAxialLengthMeasurementsSegmentNameCodeSequence),TagLink(OphthalmicAxialLengthDataSourceCodeSequence),TagLink(OphthalmicAxialLengthSelectionMethodCodeSequence),TagLink(RefractiveSurgeryTypeCodeSequence),TagLink(RefractiveErrorBeforeRefractiveSurgeryCodeSequence),TagLink(SourceOfCornealSizeDataCodeSequence),TagLink(SourceOfLensThicknessDataCodeSequence),TagLink(SourceOfAnteriorChamberDepthDataCodeSequence),TagLink(SourceOfRefractiveMeasurementsCodeSequence),TagLink(SourceOfCorneaMeasurementDataCodeSequence),TagLink(IOLFormulaCodeSequence),TagLink(KeratometryMeasurementTypeCodeSequence),TagLink(SourceOfOphthalmicAxialLengthCodeSequence),TagLink(CorneaMeasurementMethodCodeSequence),TagLink(ScreeningTestModeCodeSequence),TagLink(StimulusColorCodeSequence),TagLink(BackgroundIlluminationColorCodeSequence),TagLink(FixationMonitoringCodeSequence),TagLink(ModeOfPercutaneousAccessSequence),TagLink(AcquisitionMethodCodeSequence),TagLink(OphthalmicThicknessMapTypeCodeSequence),TagLink(RetinalThicknessDefinitionCodeSequence),TagLink(SurfaceScanAcquisitionTypeCodeSequence),TagLink(SurfaceScanModeCodeSequence),TagLink(RegistrationMethodCodeSequence),TagLink(CornealTopographyMapTypeCodeSequence),TagLink(TrackSetAnatomicalTypeCodeSequence),TagLink(ModifierCodeSequence),TagLink(DiffusionAcquisitionCodeSequence),TagLink(DiffusionModelCodeSequence),TagLink(AcousticCouplingMediumCodeSequence),TagLink(TransducerTechnologySequence),TagLink(SoundSpeedCorrectionMechanismCodeSequence),TagLink(ImageDataTypeCodeSequence),TagLink(ChannelSourceModifiersSequence),TagLink(ChannelSensitivityUnitsSequence),TagLink(AnalogFilterTypeCodeSequence),TagLink(DigitalFilterTypeCodeSequence),TagLink(FrequencyEncodingCodeSequence),TagLink(MagnitudeEncodingCodeSequence),TagLink(CodingSchemeIdentificationSequence),TagLink(DigitalSignaturePurposeCodeSequence),TagLink(VerifyingObserverIdentificationCodeSequence),TagLink(ResponsibleGroupCodeSequence),TagLink(PerformedProcedureCodeSequence),TagLink(OrganizationalRoleCodeSequence),TagLink(NumericValueQualifierCodeSequence),TagLink(RegistrationTypeCodeSequence),TagLink(FiducialsPropertyCategoryCodeSequence),TagLink(FiducialIdentifierCodeSequence),TagLink(AbstractPriorCodeSequence),TagLink(HangingProtocolUserIdentificationCodeSequence),TagLink(ImplantRegulatoryDisapprovalCodeSequence),TagLink(MaterialsCodeSequence),TagLink(CoatingMaterialsCodeSequence),TagLink(ImplantTypeCodeSequence),TagLink(FixationMethodCodeSequence),TagLink(ViewOrientationCodeSequence),TagLink(ViewOrientationModifierCodeSequence),TagLink(PlanningLandmarkIdentificationCodeSequence),TagLink(ProcedureTypeCodeSequence),TagLink(ComponentTypeCodeSequence),TagLink(AssessmentTypeCodeSequence),TagLink(ObservationBasisCodeSequence),TagLink(PotentialScheduledProtocolCodeSequence),TagLink(PotentialRequestedProcedureCodeSequence),TagLink(PotentialReasonsForProcedureCodeSequence),TagLink(ContraindicationsCodeSequence),TagLink(PositioningMethodCodeSequence),TagLink(RequestedSeriesDescriptionCodeSequence),TagLink(ModelUsageCodeSequence),TagLink(DosimetricObjectiveTypeCodeSequence),TagLink(EffectiveDoseCalculationMethodCategoryCodeSequence),TagLink(EffectiveDoseCalculationMethodCodeSequence),TagLink(TreatmentMachineSpecialModeCodeSequence),TagLink(DeliveryRateUnitSequence),TagLink(RadiationGenerationModeMachineCodeSequence),TagLink(RadiationTypeCodeSequence),TagLink(EnergyUnitCodeSequence),TagLink(RadiationFluenceModifierCodeSequence),TagLink(CompensatorShapeFabricationCodeSequence),TagLink(InterlockCodeSequence),TagLink(InterlockResolutionCodeSequence),TagLink(ParallelRTBeamDelimiterDeviceOrientationLabelCodeSequence),TagLink(DisplacementReferenceLocationCodeSequence),TagLink(PatientTreatmentPreparationMethodCodeSequence),TagLink(PatientTreatmentPreparationProcedureCodeSequence),TagLink(EnergyDerivationCodeSequence),TagLink(RadiationDosimeterUnitSequence),TagLink(RTDiagnosisCodeSequence),TagLink(ConceptualVolumeCategoryCodeSequence),TagLink(ConceptualVolumeTypeCodeSequence),TagLink(ConceptualVolumeTypeModifierCodeSequence),TagLink(DeliveryTimeStructureCodeSequence),TagLink(SegmentAnnotationCategoryCodeSequence),TagLink(SegmentAnnotationTypeCodeSequence),TagLink(SegmentAnnotationTypeModifierCodeSequence),TagLink(RTDeviceDistanceReferenceLocationCodeSequence),TagLink(EquipmentReferencePointCodeSequence),TagLink(RoboticPathNodeSetCodeSequence),TagLink(DoseMeasurementDeviceCodeSequence),TagLink(TreatmentToleranceViolationTypeCodeSequence),TagLink(TreatmentToleranceViolationCauseCodeSequence),TagLink(ReasonForOmissionCodeSequence),TagLink(AcquisitionTaskWorkitemCodeSequence),TagLink(SubtaskWorkitemCodeSequence),TagLink(PositionAcquisitionTemplateCodeSequence),TagLink(AnnotationPropertyCategoryCodeSequence),TagLink(AnnotationPropertyTypeCodeSequence),TagLink(AnnotationPropertyTypeModifierCodeSequence),TagLink(ReasonForRemovalCodeSequence),TagLink(AnatomicRegionsInStudyCodeSequence),TagLink(MontageChannelSourceCodeSequence),])
    CodeMeaning = Tag('Code Meaning', "CodeMeaning", 0x0008, 0x0104, [TagLink(EquivalentCodeSequence),TagLink(PersonIdentificationCodeSequence),TagLink(InstitutionCodeSequence),TagLink(InstitutionalDepartmentTypeCodeSequence),TagLink(ConceptNameCodeSequence),TagLink(ConceptCodeSequence),TagLink(MeasurementUnitsCodeSequence),TagLink(AnatomicRegionSequence),TagLink(AnatomicRegionModifierSequence),TagLink(PrimaryAnatomicStructureSequence),TagLink(PrimaryAnatomicStructureModifierSequence),TagLink(RequestedProcedureCodeSequence),TagLink(ReasonForRequestedProcedureCodeSequence),TagLink(ScheduledProtocolCodeSequence),TagLink(LanguageCodeSequence),TagLink(PerformedProtocolCodeSequence),TagLink(PatientOrientationCodeSequence),TagLink(PatientOrientationModifierCodeSequence),TagLink(PatientGantryRelationshipCodeSequence),TagLink(PatientEquipmentRelationshipCodeSequence),TagLink(AssigningJurisdictionCodeSequence),TagLink(AssigningAgencyOrDepartmentCodeSequence),TagLink(AlgorithmFamilyCodeSequence),TagLink(AlgorithmNameCodeSequence),TagLink(ViewCodeSequence),TagLink(ViewModifierCodeSequence),TagLink(DeviceMotionParameterCodeSequence),TagLink(SelectorCodeSequenceValue),TagLink(ReferenceBasisCodeSequence),TagLink(ReferenceGeometryCodeSequence),TagLink(AssertionCodeSequence),TagLink(DeviceTypeCodeSequence),TagLink(PurposeOfReferenceCodeSequence),TagLink(PatientLocationCoordinatesCodeSequence),TagLink(EthnicGroupCodeSequence),TagLink(PatientSpeciesCodeSequence),TagLink(PatientBreedCodeSequence),TagLink(BreedRegistryCodeSequence),TagLink(StrainCodeSequence),TagLink(StrainSourceRegistryCodeSequence),TagLink(GeneticModificationsCodeSequence),TagLink(DeidentificationMethodCodeSequence),TagLink(RequestingServiceCodeSequence),TagLink(ProcedureCodeSequence),TagLink(ReasonForPerformedProcedureCodeSequence),TagLink(AdmittingDiagnosesCodeSequence),TagLink(PrincipalDiagnosisCodeSequence),TagLink(PrimaryDiagnosisCodeSequence),TagLink(SecondaryDiagnosesCodeSequence),TagLink(HistologicalDiagnosesCodeSequence),TagLink(PatientSizeCodeSequence),TagLink(ReasonForVisitCodeSequence),TagLink(ClinicalTrialTimePointTypeCodeSequence),TagLink(SeriesDescriptionCodeSequence),TagLink(ContrastBolusAgentSequence),TagLink(ContrastBolusAdministrationRouteSequence),TagLink(AdditionalDrugSequence),TagLink(ContrastBolusIngredientCodeSequence),TagLink(ChannelSourceSequence),TagLink(DeviceSequence),TagLink(InterventionSequence),TagLink(InterventionDrugCodeSequence),TagLink(AdministrationRouteCodeSequence),TagLink(DerivationCodeSequence),TagLink(PatientPhysiologicalStateCodeSequence),TagLink(ContainerTypeCodeSequence),TagLink(ContainerComponentTypeCodeSequence),TagLink(SpecimenTypeCodeSequence),TagLink(CTDIPhantomTypeCodeSequence),TagLink(WaterEquivalentDiameterCalculationMethodCodeSequence),TagLink(RadionuclideCodeSequence),TagLink(RadiopharmaceuticalCodeSequence),TagLink(PixelValueMappingCodeSequence),TagLink(StageCodeSequence),TagLink(DocumentClassCodeSequence),TagLink(TreatmentSiteCodeSequence),TagLink(TreatmentSiteModifierCodeSequence),TagLink(RTProtocolCodeSequence),TagLink(ROIObservationContextCodeSequence),TagLink(SegmentedPropertyCategoryCodeSequence),TagLink(RTROIIdentificationCodeSequence),TagLink(SegmentedPropertyTypeModifierCodeSequence),TagLink(TherapeuticRoleCategoryCodeSequence),TagLink(TherapeuticRoleTypeCodeSequence),TagLink(RTTreatmentTechniqueCodeSequence),TagLink(RTTreatmentTerminationReasonCodeSequence),TagLink(MachineSpecificTreatmentTerminationCodeSequence),TagLink(ProjectionEponymousNameCodeSequence),TagLink(PartialViewCodeSequence),TagLink(ChannelDescriptionCodeSequence),TagLink(IlluminatorTypeCodeSequence),TagLink(IlluminationColorCodeSequence),TagLink(IlluminationTypeCodeSequence),TagLink(LightPathFilterTypeStackCodeSequence),TagLink(ImagePathFilterTypeStackCodeSequence),TagLink(LensesCodeSequence),TagLink(MetaboliteMapCodeSequence),TagLink(MaterialCodeSequence),TagLink(AcquisitionDeviceTypeCodeSequence),TagLink(PatientEyeMovementCommandCodeSequence),TagLink(RelativeImagePositionCodeSequence),TagLink(MydriaticAgentCodeSequence),TagLink(MydriaticAgentConcentrationUnitsSequence),TagLink(ScanPatternTypeCodeSequence),TagLink(TransformationMethodCodeSequence),TagLink(OphthalmicImageTypeCodeSequence),TagLink(SegmentedPropertyTypeCodeSequence),TagLink(EventCodeSequence),TagLink(TransducerScanPatternCodeSequence),TagLink(TransducerGeometryCodeSequence),TagLink(TransducerBeamSteeringCodeSequence),TagLink(TransducerApplicationCodeSequence),TagLink(VisualAcuityTypeCodeSequence),TagLink(OphthalmicUltrasoundMethodCodeSequence),TagLink(AnteriorChamberDepthDefinitionCodeSequence),TagLink(LensStatusCodeSequence),TagLink(VitreousStatusCodeSequence),TagLink(OphthalmicAxialLengthMeasurementsSegmentNameCodeSequence),TagLink(OphthalmicAxialLengthDataSourceCodeSequence),TagLink(OphthalmicAxialLengthSelectionMethodCodeSequence),TagLink(RefractiveSurgeryTypeCodeSequence),TagLink(RefractiveErrorBeforeRefractiveSurgeryCodeSequence),TagLink(SourceOfCornealSizeDataCodeSequence),TagLink(SourceOfLensThicknessDataCodeSequence),TagLink(SourceOfAnteriorChamberDepthDataCodeSequence),TagLink(SourceOfRefractiveMeasurementsCodeSequence),TagLink(SourceOfCorneaMeasurementDataCodeSequence),TagLink(IOLFormulaCodeSequence),TagLink(KeratometryMeasurementTypeCodeSequence),TagLink(SourceOfOphthalmicAxialLengthCodeSequence),TagLink(CorneaMeasurementMethodCodeSequence),TagLink(ScreeningTestModeCodeSequence),TagLink(StimulusColorCodeSequence),TagLink(BackgroundIlluminationColorCodeSequence),TagLink(FixationMonitoringCodeSequence),TagLink(ModeOfPercutaneousAccessSequence),TagLink(AcquisitionMethodCodeSequence),TagLink(OphthalmicThicknessMapTypeCodeSequence),TagLink(RetinalThicknessDefinitionCodeSequence),TagLink(SurfaceScanAcquisitionTypeCodeSequence),TagLink(SurfaceScanModeCodeSequence),TagLink(RegistrationMethodCodeSequence),TagLink(CornealTopographyMapTypeCodeSequence),TagLink(TrackSetAnatomicalTypeCodeSequence),TagLink(ModifierCodeSequence),TagLink(DiffusionAcquisitionCodeSequence),TagLink(DiffusionModelCodeSequence),TagLink(AcousticCouplingMediumCodeSequence),TagLink(TransducerTechnologySequence),TagLink(SoundSpeedCorrectionMechanismCodeSequence),TagLink(ImageDataTypeCodeSequence),TagLink(ChannelSourceModifiersSequence),TagLink(ChannelSensitivityUnitsSequence),TagLink(AnalogFilterTypeCodeSequence),TagLink(DigitalFilterTypeCodeSequence),TagLink(FrequencyEncodingCodeSequence),TagLink(MagnitudeEncodingCodeSequence),TagLink(DigitalSignaturePurposeCodeSequence),TagLink(VerifyingObserverIdentificationCodeSequence),TagLink(ResponsibleGroupCodeSequence),TagLink(PerformedProcedureCodeSequence),TagLink(OrganizationalRoleCodeSequence),TagLink(NumericValueQualifierCodeSequence),TagLink(RegistrationTypeCodeSequence),TagLink(FiducialsPropertyCategoryCodeSequence),TagLink(FiducialIdentifierCodeSequence),TagLink(AbstractPriorCodeSequence),TagLink(HangingProtocolUserIdentificationCodeSequence),TagLink(ImplantRegulatoryDisapprovalCodeSequence),TagLink(MaterialsCodeSequence),TagLink(CoatingMaterialsCodeSequence),TagLink(ImplantTypeCodeSequence),TagLink(FixationMethodCodeSequence),TagLink(ViewOrientationCodeSequence),TagLink(ViewOrientationModifierCodeSequence),TagLink(PlanningLandmarkIdentificationCodeSequence),TagLink(ProcedureTypeCodeSequence),TagLink(ComponentTypeCodeSequence),TagLink(AssessmentTypeCodeSequence),TagLink(ObservationBasisCodeSequence),TagLink(PotentialScheduledProtocolCodeSequence),TagLink(PotentialRequestedProcedureCodeSequence),TagLink(PotentialReasonsForProcedureCodeSequence),TagLink(ContraindicationsCodeSequence),TagLink(PositioningMethodCodeSequence),TagLink(RequestedSeriesDescriptionCodeSequence),TagLink(ModelUsageCodeSequence),TagLink(DosimetricObjectiveTypeCodeSequence),TagLink(EffectiveDoseCalculationMethodCategoryCodeSequence),TagLink(EffectiveDoseCalculationMethodCodeSequence),TagLink(TreatmentMachineSpecialModeCodeSequence),TagLink(DeliveryRateUnitSequence),TagLink(RadiationGenerationModeMachineCodeSequence),TagLink(RadiationTypeCodeSequence),TagLink(EnergyUnitCodeSequence),TagLink(RadiationFluenceModifierCodeSequence),TagLink(CompensatorShapeFabricationCodeSequence),TagLink(InterlockCodeSequence),TagLink(InterlockResolutionCodeSequence),TagLink(ParallelRTBeamDelimiterDeviceOrientationLabelCodeSequence),TagLink(DisplacementReferenceLocationCodeSequence),TagLink(PatientTreatmentPreparationMethodCodeSequence),TagLink(PatientTreatmentPreparationProcedureCodeSequence),TagLink(EnergyDerivationCodeSequence),TagLink(RadiationDosimeterUnitSequence),TagLink(RTDiagnosisCodeSequence),TagLink(ConceptualVolumeCategoryCodeSequence),TagLink(ConceptualVolumeTypeCodeSequence),TagLink(ConceptualVolumeTypeModifierCodeSequence),TagLink(DeliveryTimeStructureCodeSequence),TagLink(SegmentAnnotationCategoryCodeSequence),TagLink(SegmentAnnotationTypeCodeSequence),TagLink(SegmentAnnotationTypeModifierCodeSequence),TagLink(RTDeviceDistanceReferenceLocationCodeSequence),TagLink(EquipmentReferencePointCodeSequence),TagLink(RoboticPathNodeSetCodeSequence),TagLink(DoseMeasurementDeviceCodeSequence),TagLink(TreatmentToleranceViolationTypeCodeSequence),TagLink(TreatmentToleranceViolationCauseCodeSequence),TagLink(ReasonForOmissionCodeSequence),TagLink(AcquisitionTaskWorkitemCodeSequence),TagLink(SubtaskWorkitemCodeSequence),TagLink(PositionAcquisitionTemplateCodeSequence),TagLink(AnnotationPropertyCategoryCodeSequence),TagLink(AnnotationPropertyTypeCodeSequence),TagLink(AnnotationPropertyTypeModifierCodeSequence),TagLink(ReasonForRemovalCodeSequence),TagLink(AnatomicRegionsInStudyCodeSequence),TagLink(MontageChannelSourceCodeSequence),])
    ContextGroupIdentificationSequence = Tag('Context Group Identification Sequence', "ContextGroupIdentificationSequence", 0x0008, 0x0123)
    MappingResourceIdentificationSequence = Tag('Mapping Resource Identification Sequence', "MappingResourceIdentificationSequence", 0x0008, 0x0124)
    ContentTemplateSequence = Tag('Content Template Sequence', "ContentTemplateSequence", 0x0040, 0xA504, [TagLink(ContentSequence),TagLink(InventoriedInstancesSequence),])
    MappingResource = Tag('Mapping Resource', "MappingResource", 0x0008, 0x0105, [TagLink(EquivalentCodeSequence),TagLink(PersonIdentificationCodeSequence),TagLink(InstitutionCodeSequence),TagLink(InstitutionalDepartmentTypeCodeSequence),TagLink(ConceptNameCodeSequence),TagLink(ConceptCodeSequence),TagLink(MeasurementUnitsCodeSequence),TagLink(AnatomicRegionSequence),TagLink(AnatomicRegionModifierSequence),TagLink(PrimaryAnatomicStructureSequence),TagLink(PrimaryAnatomicStructureModifierSequence),TagLink(RequestedProcedureCodeSequence),TagLink(ReasonForRequestedProcedureCodeSequence),TagLink(ScheduledProtocolCodeSequence),TagLink(LanguageCodeSequence),TagLink(PerformedProtocolCodeSequence),TagLink(PatientOrientationCodeSequence),TagLink(PatientOrientationModifierCodeSequence),TagLink(PatientGantryRelationshipCodeSequence),TagLink(PatientEquipmentRelationshipCodeSequence),TagLink(AssigningJurisdictionCodeSequence),TagLink(AssigningAgencyOrDepartmentCodeSequence),TagLink(AlgorithmFamilyCodeSequence),TagLink(AlgorithmNameCodeSequence),TagLink(ViewCodeSequence),TagLink(ViewModifierCodeSequence),TagLink(DeviceMotionParameterCodeSequence),TagLink(SelectorCodeSequenceValue),TagLink(ReferenceBasisCodeSequence),TagLink(ReferenceGeometryCodeSequence),TagLink(AssertionCodeSequence),TagLink(DeviceTypeCodeSequence),TagLink(PurposeOfReferenceCodeSequence),TagLink(PatientLocationCoordinatesCodeSequence),TagLink(EthnicGroupCodeSequence),TagLink(PatientSpeciesCodeSequence),TagLink(PatientBreedCodeSequence),TagLink(BreedRegistryCodeSequence),TagLink(StrainCodeSequence),TagLink(StrainSourceRegistryCodeSequence),TagLink(GeneticModificationsCodeSequence),TagLink(DeidentificationMethodCodeSequence),TagLink(RequestingServiceCodeSequence),TagLink(ProcedureCodeSequence),TagLink(ReasonForPerformedProcedureCodeSequence),TagLink(AdmittingDiagnosesCodeSequence),TagLink(PrincipalDiagnosisCodeSequence),TagLink(PrimaryDiagnosisCodeSequence),TagLink(SecondaryDiagnosesCodeSequence),TagLink(HistologicalDiagnosesCodeSequence),TagLink(PatientSizeCodeSequence),TagLink(ReasonForVisitCodeSequence),TagLink(ClinicalTrialTimePointTypeCodeSequence),TagLink(SeriesDescriptionCodeSequence),TagLink(ContrastBolusAgentSequence),TagLink(ContrastBolusAdministrationRouteSequence),TagLink(AdditionalDrugSequence),TagLink(ContrastBolusIngredientCodeSequence),TagLink(ChannelSourceSequence),TagLink(DeviceSequence),TagLink(InterventionSequence),TagLink(InterventionDrugCodeSequence),TagLink(AdministrationRouteCodeSequence),TagLink(DerivationCodeSequence),TagLink(PatientPhysiologicalStateCodeSequence),TagLink(ContainerTypeCodeSequence),TagLink(ContainerComponentTypeCodeSequence),TagLink(SpecimenTypeCodeSequence),TagLink(CTDIPhantomTypeCodeSequence),TagLink(WaterEquivalentDiameterCalculationMethodCodeSequence),TagLink(RadionuclideCodeSequence),TagLink(RadiopharmaceuticalCodeSequence),TagLink(PixelValueMappingCodeSequence),TagLink(StageCodeSequence),TagLink(DocumentClassCodeSequence),TagLink(TreatmentSiteCodeSequence),TagLink(TreatmentSiteModifierCodeSequence),TagLink(RTProtocolCodeSequence),TagLink(ROIObservationContextCodeSequence),TagLink(SegmentedPropertyCategoryCodeSequence),TagLink(RTROIIdentificationCodeSequence),TagLink(SegmentedPropertyTypeModifierCodeSequence),TagLink(TherapeuticRoleCategoryCodeSequence),TagLink(TherapeuticRoleTypeCodeSequence),TagLink(RTTreatmentTechniqueCodeSequence),TagLink(RTTreatmentTerminationReasonCodeSequence),TagLink(MachineSpecificTreatmentTerminationCodeSequence),TagLink(ProjectionEponymousNameCodeSequence),TagLink(PartialViewCodeSequence),TagLink(ChannelDescriptionCodeSequence),TagLink(IlluminatorTypeCodeSequence),TagLink(IlluminationColorCodeSequence),TagLink(IlluminationTypeCodeSequence),TagLink(LightPathFilterTypeStackCodeSequence),TagLink(ImagePathFilterTypeStackCodeSequence),TagLink(LensesCodeSequence),TagLink(MetaboliteMapCodeSequence),TagLink(MaterialCodeSequence),TagLink(AcquisitionDeviceTypeCodeSequence),TagLink(PatientEyeMovementCommandCodeSequence),TagLink(RelativeImagePositionCodeSequence),TagLink(MydriaticAgentCodeSequence),TagLink(MydriaticAgentConcentrationUnitsSequence),TagLink(ScanPatternTypeCodeSequence),TagLink(TransformationMethodCodeSequence),TagLink(OphthalmicImageTypeCodeSequence),TagLink(SegmentedPropertyTypeCodeSequence),TagLink(EventCodeSequence),TagLink(TransducerScanPatternCodeSequence),TagLink(TransducerGeometryCodeSequence),TagLink(TransducerBeamSteeringCodeSequence),TagLink(TransducerApplicationCodeSequence),TagLink(VisualAcuityTypeCodeSequence),TagLink(OphthalmicUltrasoundMethodCodeSequence),TagLink(AnteriorChamberDepthDefinitionCodeSequence),TagLink(LensStatusCodeSequence),TagLink(VitreousStatusCodeSequence),TagLink(OphthalmicAxialLengthMeasurementsSegmentNameCodeSequence),TagLink(OphthalmicAxialLengthDataSourceCodeSequence),TagLink(OphthalmicAxialLengthSelectionMethodCodeSequence),TagLink(RefractiveSurgeryTypeCodeSequence),TagLink(RefractiveErrorBeforeRefractiveSurgeryCodeSequence),TagLink(SourceOfCornealSizeDataCodeSequence),TagLink(SourceOfLensThicknessDataCodeSequence),TagLink(SourceOfAnteriorChamberDepthDataCodeSequence),TagLink(SourceOfRefractiveMeasurementsCodeSequence),TagLink(SourceOfCorneaMeasurementDataCodeSequence),TagLink(IOLFormulaCodeSequence),TagLink(KeratometryMeasurementTypeCodeSequence),TagLink(SourceOfOphthalmicAxialLengthCodeSequence),TagLink(CorneaMeasurementMethodCodeSequence),TagLink(ScreeningTestModeCodeSequence),TagLink(StimulusColorCodeSequence),TagLink(BackgroundIlluminationColorCodeSequence),TagLink(FixationMonitoringCodeSequence),TagLink(ModeOfPercutaneousAccessSequence),TagLink(AcquisitionMethodCodeSequence),TagLink(OphthalmicThicknessMapTypeCodeSequence),TagLink(RetinalThicknessDefinitionCodeSequence),TagLink(SurfaceScanAcquisitionTypeCodeSequence),TagLink(SurfaceScanModeCodeSequence),TagLink(RegistrationMethodCodeSequence),TagLink(CornealTopographyMapTypeCodeSequence),TagLink(TrackSetAnatomicalTypeCodeSequence),TagLink(ModifierCodeSequence),TagLink(DiffusionAcquisitionCodeSequence),TagLink(DiffusionModelCodeSequence),TagLink(AcousticCouplingMediumCodeSequence),TagLink(TransducerTechnologySequence),TagLink(SoundSpeedCorrectionMechanismCodeSequence),TagLink(ImageDataTypeCodeSequence),TagLink(ChannelSourceModifiersSequence),TagLink(ChannelSensitivityUnitsSequence),TagLink(AnalogFilterTypeCodeSequence),TagLink(DigitalFilterTypeCodeSequence),TagLink(FrequencyEncodingCodeSequence),TagLink(MagnitudeEncodingCodeSequence),TagLink(ContextGroupIdentificationSequence),TagLink(MappingResourceIdentificationSequence),TagLink(DigitalSignaturePurposeCodeSequence),TagLink(VerifyingObserverIdentificationCodeSequence),TagLink(ResponsibleGroupCodeSequence),TagLink(PerformedProcedureCodeSequence),TagLink(OrganizationalRoleCodeSequence),TagLink(NumericValueQualifierCodeSequence),TagLink(ContentTemplateSequence),TagLink(RegistrationTypeCodeSequence),TagLink(FiducialsPropertyCategoryCodeSequence),TagLink(FiducialIdentifierCodeSequence),TagLink(AbstractPriorCodeSequence),TagLink(HangingProtocolUserIdentificationCodeSequence),TagLink(ImplantRegulatoryDisapprovalCodeSequence),TagLink(MaterialsCodeSequence),TagLink(CoatingMaterialsCodeSequence),TagLink(ImplantTypeCodeSequence),TagLink(FixationMethodCodeSequence),TagLink(ViewOrientationCodeSequence),TagLink(ViewOrientationModifierCodeSequence),TagLink(PlanningLandmarkIdentificationCodeSequence),TagLink(ProcedureTypeCodeSequence),TagLink(ComponentTypeCodeSequence),TagLink(AssessmentTypeCodeSequence),TagLink(ObservationBasisCodeSequence),TagLink(PotentialScheduledProtocolCodeSequence),TagLink(PotentialRequestedProcedureCodeSequence),TagLink(PotentialReasonsForProcedureCodeSequence),TagLink(ContraindicationsCodeSequence),TagLink(PositioningMethodCodeSequence),TagLink(RequestedSeriesDescriptionCodeSequence),TagLink(ModelUsageCodeSequence),TagLink(DosimetricObjectiveTypeCodeSequence),TagLink(EffectiveDoseCalculationMethodCategoryCodeSequence),TagLink(EffectiveDoseCalculationMethodCodeSequence),TagLink(TreatmentMachineSpecialModeCodeSequence),TagLink(DeliveryRateUnitSequence),TagLink(RadiationGenerationModeMachineCodeSequence),TagLink(RadiationTypeCodeSequence),TagLink(EnergyUnitCodeSequence),TagLink(RadiationFluenceModifierCodeSequence),TagLink(CompensatorShapeFabricationCodeSequence),TagLink(InterlockCodeSequence),TagLink(InterlockResolutionCodeSequence),TagLink(ParallelRTBeamDelimiterDeviceOrientationLabelCodeSequence),TagLink(DisplacementReferenceLocationCodeSequence),TagLink(PatientTreatmentPreparationMethodCodeSequence),TagLink(PatientTreatmentPreparationProcedureCodeSequence),TagLink(EnergyDerivationCodeSequence),TagLink(RadiationDosimeterUnitSequence),TagLink(RTDiagnosisCodeSequence),TagLink(ConceptualVolumeCategoryCodeSequence),TagLink(ConceptualVolumeTypeCodeSequence),TagLink(ConceptualVolumeTypeModifierCodeSequence),TagLink(DeliveryTimeStructureCodeSequence),TagLink(SegmentAnnotationCategoryCodeSequence),TagLink(SegmentAnnotationTypeCodeSequence),TagLink(SegmentAnnotationTypeModifierCodeSequence),TagLink(RTDeviceDistanceReferenceLocationCodeSequence),TagLink(EquipmentReferencePointCodeSequence),TagLink(RoboticPathNodeSetCodeSequence),TagLink(DoseMeasurementDeviceCodeSequence),TagLink(TreatmentToleranceViolationTypeCodeSequence),TagLink(TreatmentToleranceViolationCauseCodeSequence),TagLink(ReasonForOmissionCodeSequence),TagLink(AcquisitionTaskWorkitemCodeSequence),TagLink(SubtaskWorkitemCodeSequence),TagLink(PositionAcquisitionTemplateCodeSequence),TagLink(AnnotationPropertyCategoryCodeSequence),TagLink(AnnotationPropertyTypeCodeSequence),TagLink(AnnotationPropertyTypeModifierCodeSequence),TagLink(ReasonForRemovalCodeSequence),TagLink(AnatomicRegionsInStudyCodeSequence),TagLink(MontageChannelSourceCodeSequence),])
    ContextGroupVersion = Tag('Context Group Version', "ContextGroupVersion", 0x0008, 0x0106, [TagLink(EquivalentCodeSequence),TagLink(PersonIdentificationCodeSequence),TagLink(InstitutionCodeSequence),TagLink(InstitutionalDepartmentTypeCodeSequence),TagLink(ConceptNameCodeSequence),TagLink(ConceptCodeSequence),TagLink(MeasurementUnitsCodeSequence),TagLink(AnatomicRegionSequence),TagLink(AnatomicRegionModifierSequence),TagLink(PrimaryAnatomicStructureSequence),TagLink(PrimaryAnatomicStructureModifierSequence),TagLink(RequestedProcedureCodeSequence),TagLink(ReasonForRequestedProcedureCodeSequence),TagLink(ScheduledProtocolCodeSequence),TagLink(LanguageCodeSequence),TagLink(PerformedProtocolCodeSequence),TagLink(PatientOrientationCodeSequence),TagLink(PatientOrientationModifierCodeSequence),TagLink(PatientGantryRelationshipCodeSequence),TagLink(PatientEquipmentRelationshipCodeSequence),TagLink(AssigningJurisdictionCodeSequence),TagLink(AssigningAgencyOrDepartmentCodeSequence),TagLink(AlgorithmFamilyCodeSequence),TagLink(AlgorithmNameCodeSequence),TagLink(ViewCodeSequence),TagLink(ViewModifierCodeSequence),TagLink(DeviceMotionParameterCodeSequence),TagLink(SelectorCodeSequenceValue),TagLink(ReferenceBasisCodeSequence),TagLink(ReferenceGeometryCodeSequence),TagLink(AssertionCodeSequence),TagLink(DeviceTypeCodeSequence),TagLink(PurposeOfReferenceCodeSequence),TagLink(PatientLocationCoordinatesCodeSequence),TagLink(EthnicGroupCodeSequence),TagLink(PatientSpeciesCodeSequence),TagLink(PatientBreedCodeSequence),TagLink(BreedRegistryCodeSequence),TagLink(StrainCodeSequence),TagLink(StrainSourceRegistryCodeSequence),TagLink(GeneticModificationsCodeSequence),TagLink(DeidentificationMethodCodeSequence),TagLink(RequestingServiceCodeSequence),TagLink(ProcedureCodeSequence),TagLink(ReasonForPerformedProcedureCodeSequence),TagLink(AdmittingDiagnosesCodeSequence),TagLink(PrincipalDiagnosisCodeSequence),TagLink(PrimaryDiagnosisCodeSequence),TagLink(SecondaryDiagnosesCodeSequence),TagLink(HistologicalDiagnosesCodeSequence),TagLink(PatientSizeCodeSequence),TagLink(ReasonForVisitCodeSequence),TagLink(ClinicalTrialTimePointTypeCodeSequence),TagLink(SeriesDescriptionCodeSequence),TagLink(ContrastBolusAgentSequence),TagLink(ContrastBolusAdministrationRouteSequence),TagLink(AdditionalDrugSequence),TagLink(ContrastBolusIngredientCodeSequence),TagLink(ChannelSourceSequence),TagLink(DeviceSequence),TagLink(InterventionSequence),TagLink(InterventionDrugCodeSequence),TagLink(AdministrationRouteCodeSequence),TagLink(DerivationCodeSequence),TagLink(PatientPhysiologicalStateCodeSequence),TagLink(ContainerTypeCodeSequence),TagLink(ContainerComponentTypeCodeSequence),TagLink(SpecimenTypeCodeSequence),TagLink(CTDIPhantomTypeCodeSequence),TagLink(WaterEquivalentDiameterCalculationMethodCodeSequence),TagLink(RadionuclideCodeSequence),TagLink(RadiopharmaceuticalCodeSequence),TagLink(PixelValueMappingCodeSequence),TagLink(StageCodeSequence),TagLink(DocumentClassCodeSequence),TagLink(TreatmentSiteCodeSequence),TagLink(TreatmentSiteModifierCodeSequence),TagLink(RTProtocolCodeSequence),TagLink(ROIObservationContextCodeSequence),TagLink(SegmentedPropertyCategoryCodeSequence),TagLink(RTROIIdentificationCodeSequence),TagLink(SegmentedPropertyTypeModifierCodeSequence),TagLink(TherapeuticRoleCategoryCodeSequence),TagLink(TherapeuticRoleTypeCodeSequence),TagLink(RTTreatmentTechniqueCodeSequence),TagLink(RTTreatmentTerminationReasonCodeSequence),TagLink(MachineSpecificTreatmentTerminationCodeSequence),TagLink(ProjectionEponymousNameCodeSequence),TagLink(PartialViewCodeSequence),TagLink(ChannelDescriptionCodeSequence),TagLink(IlluminatorTypeCodeSequence),TagLink(IlluminationColorCodeSequence),TagLink(IlluminationTypeCodeSequence),TagLink(LightPathFilterTypeStackCodeSequence),TagLink(ImagePathFilterTypeStackCodeSequence),TagLink(LensesCodeSequence),TagLink(MetaboliteMapCodeSequence),TagLink(MaterialCodeSequence),TagLink(AcquisitionDeviceTypeCodeSequence),TagLink(PatientEyeMovementCommandCodeSequence),TagLink(RelativeImagePositionCodeSequence),TagLink(MydriaticAgentCodeSequence),TagLink(MydriaticAgentConcentrationUnitsSequence),TagLink(ScanPatternTypeCodeSequence),TagLink(TransformationMethodCodeSequence),TagLink(OphthalmicImageTypeCodeSequence),TagLink(SegmentedPropertyTypeCodeSequence),TagLink(EventCodeSequence),TagLink(TransducerScanPatternCodeSequence),TagLink(TransducerGeometryCodeSequence),TagLink(TransducerBeamSteeringCodeSequence),TagLink(TransducerApplicationCodeSequence),TagLink(VisualAcuityTypeCodeSequence),TagLink(OphthalmicUltrasoundMethodCodeSequence),TagLink(AnteriorChamberDepthDefinitionCodeSequence),TagLink(LensStatusCodeSequence),TagLink(VitreousStatusCodeSequence),TagLink(OphthalmicAxialLengthMeasurementsSegmentNameCodeSequence),TagLink(OphthalmicAxialLengthDataSourceCodeSequence),TagLink(OphthalmicAxialLengthSelectionMethodCodeSequence),TagLink(RefractiveSurgeryTypeCodeSequence),TagLink(RefractiveErrorBeforeRefractiveSurgeryCodeSequence),TagLink(SourceOfCornealSizeDataCodeSequence),TagLink(SourceOfLensThicknessDataCodeSequence),TagLink(SourceOfAnteriorChamberDepthDataCodeSequence),TagLink(SourceOfRefractiveMeasurementsCodeSequence),TagLink(SourceOfCorneaMeasurementDataCodeSequence),TagLink(IOLFormulaCodeSequence),TagLink(KeratometryMeasurementTypeCodeSequence),TagLink(SourceOfOphthalmicAxialLengthCodeSequence),TagLink(CorneaMeasurementMethodCodeSequence),TagLink(ScreeningTestModeCodeSequence),TagLink(StimulusColorCodeSequence),TagLink(BackgroundIlluminationColorCodeSequence),TagLink(FixationMonitoringCodeSequence),TagLink(ModeOfPercutaneousAccessSequence),TagLink(AcquisitionMethodCodeSequence),TagLink(OphthalmicThicknessMapTypeCodeSequence),TagLink(RetinalThicknessDefinitionCodeSequence),TagLink(SurfaceScanAcquisitionTypeCodeSequence),TagLink(SurfaceScanModeCodeSequence),TagLink(RegistrationMethodCodeSequence),TagLink(CornealTopographyMapTypeCodeSequence),TagLink(TrackSetAnatomicalTypeCodeSequence),TagLink(ModifierCodeSequence),TagLink(DiffusionAcquisitionCodeSequence),TagLink(DiffusionModelCodeSequence),TagLink(AcousticCouplingMediumCodeSequence),TagLink(TransducerTechnologySequence),TagLink(SoundSpeedCorrectionMechanismCodeSequence),TagLink(ImageDataTypeCodeSequence),TagLink(ChannelSourceModifiersSequence),TagLink(ChannelSensitivityUnitsSequence),TagLink(AnalogFilterTypeCodeSequence),TagLink(DigitalFilterTypeCodeSequence),TagLink(FrequencyEncodingCodeSequence),TagLink(MagnitudeEncodingCodeSequence),TagLink(ContextGroupIdentificationSequence),TagLink(DigitalSignaturePurposeCodeSequence),TagLink(VerifyingObserverIdentificationCodeSequence),TagLink(ResponsibleGroupCodeSequence),TagLink(PerformedProcedureCodeSequence),TagLink(OrganizationalRoleCodeSequence),TagLink(NumericValueQualifierCodeSequence),TagLink(RegistrationTypeCodeSequence),TagLink(FiducialsPropertyCategoryCodeSequence),TagLink(FiducialIdentifierCodeSequence),TagLink(AbstractPriorCodeSequence),TagLink(HangingProtocolUserIdentificationCodeSequence),TagLink(ImplantRegulatoryDisapprovalCodeSequence),TagLink(MaterialsCodeSequence),TagLink(CoatingMaterialsCodeSequence),TagLink(ImplantTypeCodeSequence),TagLink(FixationMethodCodeSequence),TagLink(ViewOrientationCodeSequence),TagLink(ViewOrientationModifierCodeSequence),TagLink(PlanningLandmarkIdentificationCodeSequence),TagLink(ProcedureTypeCodeSequence),TagLink(ComponentTypeCodeSequence),TagLink(AssessmentTypeCodeSequence),TagLink(ObservationBasisCodeSequence),TagLink(PotentialScheduledProtocolCodeSequence),TagLink(PotentialRequestedProcedureCodeSequence),TagLink(PotentialReasonsForProcedureCodeSequence),TagLink(ContraindicationsCodeSequence),TagLink(PositioningMethodCodeSequence),TagLink(RequestedSeriesDescriptionCodeSequence),TagLink(ModelUsageCodeSequence),TagLink(DosimetricObjectiveTypeCodeSequence),TagLink(EffectiveDoseCalculationMethodCategoryCodeSequence),TagLink(EffectiveDoseCalculationMethodCodeSequence),TagLink(TreatmentMachineSpecialModeCodeSequence),TagLink(DeliveryRateUnitSequence),TagLink(RadiationGenerationModeMachineCodeSequence),TagLink(RadiationTypeCodeSequence),TagLink(EnergyUnitCodeSequence),TagLink(RadiationFluenceModifierCodeSequence),TagLink(CompensatorShapeFabricationCodeSequence),TagLink(InterlockCodeSequence),TagLink(InterlockResolutionCodeSequence),TagLink(ParallelRTBeamDelimiterDeviceOrientationLabelCodeSequence),TagLink(DisplacementReferenceLocationCodeSequence),TagLink(PatientTreatmentPreparationMethodCodeSequence),TagLink(PatientTreatmentPreparationProcedureCodeSequence),TagLink(EnergyDerivationCodeSequence),TagLink(RadiationDosimeterUnitSequence),TagLink(RTDiagnosisCodeSequence),TagLink(ConceptualVolumeCategoryCodeSequence),TagLink(ConceptualVolumeTypeCodeSequence),TagLink(ConceptualVolumeTypeModifierCodeSequence),TagLink(DeliveryTimeStructureCodeSequence),TagLink(SegmentAnnotationCategoryCodeSequence),TagLink(SegmentAnnotationTypeCodeSequence),TagLink(SegmentAnnotationTypeModifierCodeSequence),TagLink(RTDeviceDistanceReferenceLocationCodeSequence),TagLink(EquipmentReferencePointCodeSequence),TagLink(RoboticPathNodeSetCodeSequence),TagLink(DoseMeasurementDeviceCodeSequence),TagLink(TreatmentToleranceViolationTypeCodeSequence),TagLink(TreatmentToleranceViolationCauseCodeSequence),TagLink(ReasonForOmissionCodeSequence),TagLink(AcquisitionTaskWorkitemCodeSequence),TagLink(SubtaskWorkitemCodeSequence),TagLink(PositionAcquisitionTemplateCodeSequence),TagLink(AnnotationPropertyCategoryCodeSequence),TagLink(AnnotationPropertyTypeCodeSequence),TagLink(AnnotationPropertyTypeModifierCodeSequence),TagLink(ReasonForRemovalCodeSequence),TagLink(AnatomicRegionsInStudyCodeSequence),TagLink(MontageChannelSourceCodeSequence),])
    ContextGroupLocalVersion = Tag('Context Group Local Version', "ContextGroupLocalVersion", 0x0008, 0x0107, [TagLink(EquivalentCodeSequence),TagLink(PersonIdentificationCodeSequence),TagLink(InstitutionCodeSequence),TagLink(InstitutionalDepartmentTypeCodeSequence),TagLink(ConceptNameCodeSequence),TagLink(ConceptCodeSequence),TagLink(MeasurementUnitsCodeSequence),TagLink(AnatomicRegionSequence),TagLink(AnatomicRegionModifierSequence),TagLink(PrimaryAnatomicStructureSequence),TagLink(PrimaryAnatomicStructureModifierSequence),TagLink(RequestedProcedureCodeSequence),TagLink(ReasonForRequestedProcedureCodeSequence),TagLink(ScheduledProtocolCodeSequence),TagLink(LanguageCodeSequence),TagLink(PerformedProtocolCodeSequence),TagLink(PatientOrientationCodeSequence),TagLink(PatientOrientationModifierCodeSequence),TagLink(PatientGantryRelationshipCodeSequence),TagLink(PatientEquipmentRelationshipCodeSequence),TagLink(AssigningJurisdictionCodeSequence),TagLink(AssigningAgencyOrDepartmentCodeSequence),TagLink(AlgorithmFamilyCodeSequence),TagLink(AlgorithmNameCodeSequence),TagLink(ViewCodeSequence),TagLink(ViewModifierCodeSequence),TagLink(DeviceMotionParameterCodeSequence),TagLink(SelectorCodeSequenceValue),TagLink(ReferenceBasisCodeSequence),TagLink(ReferenceGeometryCodeSequence),TagLink(AssertionCodeSequence),TagLink(DeviceTypeCodeSequence),TagLink(PurposeOfReferenceCodeSequence),TagLink(PatientLocationCoordinatesCodeSequence),TagLink(EthnicGroupCodeSequence),TagLink(PatientSpeciesCodeSequence),TagLink(PatientBreedCodeSequence),TagLink(BreedRegistryCodeSequence),TagLink(StrainCodeSequence),TagLink(StrainSourceRegistryCodeSequence),TagLink(GeneticModificationsCodeSequence),TagLink(DeidentificationMethodCodeSequence),TagLink(RequestingServiceCodeSequence),TagLink(ProcedureCodeSequence),TagLink(ReasonForPerformedProcedureCodeSequence),TagLink(AdmittingDiagnosesCodeSequence),TagLink(PrincipalDiagnosisCodeSequence),TagLink(PrimaryDiagnosisCodeSequence),TagLink(SecondaryDiagnosesCodeSequence),TagLink(HistologicalDiagnosesCodeSequence),TagLink(PatientSizeCodeSequence),TagLink(ReasonForVisitCodeSequence),TagLink(ClinicalTrialTimePointTypeCodeSequence),TagLink(SeriesDescriptionCodeSequence),TagLink(ContrastBolusAgentSequence),TagLink(ContrastBolusAdministrationRouteSequence),TagLink(AdditionalDrugSequence),TagLink(ContrastBolusIngredientCodeSequence),TagLink(ChannelSourceSequence),TagLink(DeviceSequence),TagLink(InterventionSequence),TagLink(InterventionDrugCodeSequence),TagLink(AdministrationRouteCodeSequence),TagLink(DerivationCodeSequence),TagLink(PatientPhysiologicalStateCodeSequence),TagLink(ContainerTypeCodeSequence),TagLink(ContainerComponentTypeCodeSequence),TagLink(SpecimenTypeCodeSequence),TagLink(CTDIPhantomTypeCodeSequence),TagLink(WaterEquivalentDiameterCalculationMethodCodeSequence),TagLink(RadionuclideCodeSequence),TagLink(RadiopharmaceuticalCodeSequence),TagLink(PixelValueMappingCodeSequence),TagLink(StageCodeSequence),TagLink(DocumentClassCodeSequence),TagLink(TreatmentSiteCodeSequence),TagLink(TreatmentSiteModifierCodeSequence),TagLink(RTProtocolCodeSequence),TagLink(ROIObservationContextCodeSequence),TagLink(SegmentedPropertyCategoryCodeSequence),TagLink(RTROIIdentificationCodeSequence),TagLink(SegmentedPropertyTypeModifierCodeSequence),TagLink(TherapeuticRoleCategoryCodeSequence),TagLink(TherapeuticRoleTypeCodeSequence),TagLink(RTTreatmentTechniqueCodeSequence),TagLink(RTTreatmentTerminationReasonCodeSequence),TagLink(MachineSpecificTreatmentTerminationCodeSequence),TagLink(ProjectionEponymousNameCodeSequence),TagLink(PartialViewCodeSequence),TagLink(ChannelDescriptionCodeSequence),TagLink(IlluminatorTypeCodeSequence),TagLink(IlluminationColorCodeSequence),TagLink(IlluminationTypeCodeSequence),TagLink(LightPathFilterTypeStackCodeSequence),TagLink(ImagePathFilterTypeStackCodeSequence),TagLink(LensesCodeSequence),TagLink(MetaboliteMapCodeSequence),TagLink(MaterialCodeSequence),TagLink(AcquisitionDeviceTypeCodeSequence),TagLink(PatientEyeMovementCommandCodeSequence),TagLink(RelativeImagePositionCodeSequence),TagLink(MydriaticAgentCodeSequence),TagLink(MydriaticAgentConcentrationUnitsSequence),TagLink(ScanPatternTypeCodeSequence),TagLink(TransformationMethodCodeSequence),TagLink(OphthalmicImageTypeCodeSequence),TagLink(SegmentedPropertyTypeCodeSequence),TagLink(EventCodeSequence),TagLink(TransducerScanPatternCodeSequence),TagLink(TransducerGeometryCodeSequence),TagLink(TransducerBeamSteeringCodeSequence),TagLink(TransducerApplicationCodeSequence),TagLink(VisualAcuityTypeCodeSequence),TagLink(OphthalmicUltrasoundMethodCodeSequence),TagLink(AnteriorChamberDepthDefinitionCodeSequence),TagLink(LensStatusCodeSequence),TagLink(VitreousStatusCodeSequence),TagLink(OphthalmicAxialLengthMeasurementsSegmentNameCodeSequence),TagLink(OphthalmicAxialLengthDataSourceCodeSequence),TagLink(OphthalmicAxialLengthSelectionMethodCodeSequence),TagLink(RefractiveSurgeryTypeCodeSequence),TagLink(RefractiveErrorBeforeRefractiveSurgeryCodeSequence),TagLink(SourceOfCornealSizeDataCodeSequence),TagLink(SourceOfLensThicknessDataCodeSequence),TagLink(SourceOfAnteriorChamberDepthDataCodeSequence),TagLink(SourceOfRefractiveMeasurementsCodeSequence),TagLink(SourceOfCorneaMeasurementDataCodeSequence),TagLink(IOLFormulaCodeSequence),TagLink(KeratometryMeasurementTypeCodeSequence),TagLink(SourceOfOphthalmicAxialLengthCodeSequence),TagLink(CorneaMeasurementMethodCodeSequence),TagLink(ScreeningTestModeCodeSequence),TagLink(StimulusColorCodeSequence),TagLink(BackgroundIlluminationColorCodeSequence),TagLink(FixationMonitoringCodeSequence),TagLink(ModeOfPercutaneousAccessSequence),TagLink(AcquisitionMethodCodeSequence),TagLink(OphthalmicThicknessMapTypeCodeSequence),TagLink(RetinalThicknessDefinitionCodeSequence),TagLink(SurfaceScanAcquisitionTypeCodeSequence),TagLink(SurfaceScanModeCodeSequence),TagLink(RegistrationMethodCodeSequence),TagLink(CornealTopographyMapTypeCodeSequence),TagLink(TrackSetAnatomicalTypeCodeSequence),TagLink(ModifierCodeSequence),TagLink(DiffusionAcquisitionCodeSequence),TagLink(DiffusionModelCodeSequence),TagLink(AcousticCouplingMediumCodeSequence),TagLink(TransducerTechnologySequence),TagLink(SoundSpeedCorrectionMechanismCodeSequence),TagLink(ImageDataTypeCodeSequence),TagLink(ChannelSourceModifiersSequence),TagLink(ChannelSensitivityUnitsSequence),TagLink(AnalogFilterTypeCodeSequence),TagLink(DigitalFilterTypeCodeSequence),TagLink(FrequencyEncodingCodeSequence),TagLink(MagnitudeEncodingCodeSequence),TagLink(DigitalSignaturePurposeCodeSequence),TagLink(VerifyingObserverIdentificationCodeSequence),TagLink(ResponsibleGroupCodeSequence),TagLink(PerformedProcedureCodeSequence),TagLink(OrganizationalRoleCodeSequence),TagLink(NumericValueQualifierCodeSequence),TagLink(RegistrationTypeCodeSequence),TagLink(FiducialsPropertyCategoryCodeSequence),TagLink(FiducialIdentifierCodeSequence),TagLink(AbstractPriorCodeSequence),TagLink(HangingProtocolUserIdentificationCodeSequence),TagLink(ImplantRegulatoryDisapprovalCodeSequence),TagLink(MaterialsCodeSequence),TagLink(CoatingMaterialsCodeSequence),TagLink(ImplantTypeCodeSequence),TagLink(FixationMethodCodeSequence),TagLink(ViewOrientationCodeSequence),TagLink(ViewOrientationModifierCodeSequence),TagLink(PlanningLandmarkIdentificationCodeSequence),TagLink(ProcedureTypeCodeSequence),TagLink(ComponentTypeCodeSequence),TagLink(AssessmentTypeCodeSequence),TagLink(ObservationBasisCodeSequence),TagLink(PotentialScheduledProtocolCodeSequence),TagLink(PotentialRequestedProcedureCodeSequence),TagLink(PotentialReasonsForProcedureCodeSequence),TagLink(ContraindicationsCodeSequence),TagLink(PositioningMethodCodeSequence),TagLink(RequestedSeriesDescriptionCodeSequence),TagLink(ModelUsageCodeSequence),TagLink(DosimetricObjectiveTypeCodeSequence),TagLink(EffectiveDoseCalculationMethodCategoryCodeSequence),TagLink(EffectiveDoseCalculationMethodCodeSequence),TagLink(TreatmentMachineSpecialModeCodeSequence),TagLink(DeliveryRateUnitSequence),TagLink(RadiationGenerationModeMachineCodeSequence),TagLink(RadiationTypeCodeSequence),TagLink(EnergyUnitCodeSequence),TagLink(RadiationFluenceModifierCodeSequence),TagLink(CompensatorShapeFabricationCodeSequence),TagLink(InterlockCodeSequence),TagLink(InterlockResolutionCodeSequence),TagLink(ParallelRTBeamDelimiterDeviceOrientationLabelCodeSequence),TagLink(DisplacementReferenceLocationCodeSequence),TagLink(PatientTreatmentPreparationMethodCodeSequence),TagLink(PatientTreatmentPreparationProcedureCodeSequence),TagLink(EnergyDerivationCodeSequence),TagLink(RadiationDosimeterUnitSequence),TagLink(RTDiagnosisCodeSequence),TagLink(ConceptualVolumeCategoryCodeSequence),TagLink(ConceptualVolumeTypeCodeSequence),TagLink(ConceptualVolumeTypeModifierCodeSequence),TagLink(DeliveryTimeStructureCodeSequence),TagLink(SegmentAnnotationCategoryCodeSequence),TagLink(SegmentAnnotationTypeCodeSequence),TagLink(SegmentAnnotationTypeModifierCodeSequence),TagLink(RTDeviceDistanceReferenceLocationCodeSequence),TagLink(EquipmentReferencePointCodeSequence),TagLink(RoboticPathNodeSetCodeSequence),TagLink(DoseMeasurementDeviceCodeSequence),TagLink(TreatmentToleranceViolationTypeCodeSequence),TagLink(TreatmentToleranceViolationCauseCodeSequence),TagLink(ReasonForOmissionCodeSequence),TagLink(AcquisitionTaskWorkitemCodeSequence),TagLink(SubtaskWorkitemCodeSequence),TagLink(PositionAcquisitionTemplateCodeSequence),TagLink(AnnotationPropertyCategoryCodeSequence),TagLink(AnnotationPropertyTypeCodeSequence),TagLink(AnnotationPropertyTypeModifierCodeSequence),TagLink(ReasonForRemovalCodeSequence),TagLink(AnatomicRegionsInStudyCodeSequence),TagLink(MontageChannelSourceCodeSequence),])
    ExtendedCodeMeaning = Tag('Extended Code Meaning', "ExtendedCodeMeaning", 0x0008, 0x0108)
    CodingSchemeResourcesSequence = Tag('Coding Scheme Resources Sequence', "CodingSchemeResourcesSequence", 0x0008, 0x0109, [TagLink(CodingSchemeIdentificationSequence),])
    CodingSchemeURLType = Tag('Coding Scheme URL Type', "CodingSchemeURLType", 0x0008, 0x010A, [TagLink(CodingSchemeResourcesSequence),])
    ContextGroupExtensionFlag = Tag('Context Group Extension Flag', "ContextGroupExtensionFlag", 0x0008, 0x010B, [TagLink(EquivalentCodeSequence),TagLink(PersonIdentificationCodeSequence),TagLink(InstitutionCodeSequence),TagLink(InstitutionalDepartmentTypeCodeSequence),TagLink(ConceptNameCodeSequence),TagLink(ConceptCodeSequence),TagLink(MeasurementUnitsCodeSequence),TagLink(AnatomicRegionSequence),TagLink(AnatomicRegionModifierSequence),TagLink(PrimaryAnatomicStructureSequence),TagLink(PrimaryAnatomicStructureModifierSequence),TagLink(RequestedProcedureCodeSequence),TagLink(ReasonForRequestedProcedureCodeSequence),TagLink(ScheduledProtocolCodeSequence),TagLink(LanguageCodeSequence),TagLink(PerformedProtocolCodeSequence),TagLink(PatientOrientationCodeSequence),TagLink(PatientOrientationModifierCodeSequence),TagLink(PatientGantryRelationshipCodeSequence),TagLink(PatientEquipmentRelationshipCodeSequence),TagLink(AssigningJurisdictionCodeSequence),TagLink(AssigningAgencyOrDepartmentCodeSequence),TagLink(AlgorithmFamilyCodeSequence),TagLink(AlgorithmNameCodeSequence),TagLink(ViewCodeSequence),TagLink(ViewModifierCodeSequence),TagLink(DeviceMotionParameterCodeSequence),TagLink(SelectorCodeSequenceValue),TagLink(ReferenceBasisCodeSequence),TagLink(ReferenceGeometryCodeSequence),TagLink(AssertionCodeSequence),TagLink(DeviceTypeCodeSequence),TagLink(PurposeOfReferenceCodeSequence),TagLink(PatientLocationCoordinatesCodeSequence),TagLink(EthnicGroupCodeSequence),TagLink(PatientSpeciesCodeSequence),TagLink(PatientBreedCodeSequence),TagLink(BreedRegistryCodeSequence),TagLink(StrainCodeSequence),TagLink(StrainSourceRegistryCodeSequence),TagLink(GeneticModificationsCodeSequence),TagLink(DeidentificationMethodCodeSequence),TagLink(RequestingServiceCodeSequence),TagLink(ProcedureCodeSequence),TagLink(ReasonForPerformedProcedureCodeSequence),TagLink(AdmittingDiagnosesCodeSequence),TagLink(PrincipalDiagnosisCodeSequence),TagLink(PrimaryDiagnosisCodeSequence),TagLink(SecondaryDiagnosesCodeSequence),TagLink(HistologicalDiagnosesCodeSequence),TagLink(PatientSizeCodeSequence),TagLink(ReasonForVisitCodeSequence),TagLink(ClinicalTrialTimePointTypeCodeSequence),TagLink(SeriesDescriptionCodeSequence),TagLink(ContrastBolusAgentSequence),TagLink(ContrastBolusAdministrationRouteSequence),TagLink(AdditionalDrugSequence),TagLink(ContrastBolusIngredientCodeSequence),TagLink(ChannelSourceSequence),TagLink(DeviceSequence),TagLink(InterventionSequence),TagLink(InterventionDrugCodeSequence),TagLink(AdministrationRouteCodeSequence),TagLink(DerivationCodeSequence),TagLink(PatientPhysiologicalStateCodeSequence),TagLink(ContainerTypeCodeSequence),TagLink(ContainerComponentTypeCodeSequence),TagLink(SpecimenTypeCodeSequence),TagLink(CTDIPhantomTypeCodeSequence),TagLink(WaterEquivalentDiameterCalculationMethodCodeSequence),TagLink(RadionuclideCodeSequence),TagLink(RadiopharmaceuticalCodeSequence),TagLink(PixelValueMappingCodeSequence),TagLink(StageCodeSequence),TagLink(DocumentClassCodeSequence),TagLink(TreatmentSiteCodeSequence),TagLink(TreatmentSiteModifierCodeSequence),TagLink(RTProtocolCodeSequence),TagLink(ROIObservationContextCodeSequence),TagLink(SegmentedPropertyCategoryCodeSequence),TagLink(RTROIIdentificationCodeSequence),TagLink(SegmentedPropertyTypeModifierCodeSequence),TagLink(TherapeuticRoleCategoryCodeSequence),TagLink(TherapeuticRoleTypeCodeSequence),TagLink(RTTreatmentTechniqueCodeSequence),TagLink(RTTreatmentTerminationReasonCodeSequence),TagLink(MachineSpecificTreatmentTerminationCodeSequence),TagLink(ProjectionEponymousNameCodeSequence),TagLink(PartialViewCodeSequence),TagLink(ChannelDescriptionCodeSequence),TagLink(IlluminatorTypeCodeSequence),TagLink(IlluminationColorCodeSequence),TagLink(IlluminationTypeCodeSequence),TagLink(LightPathFilterTypeStackCodeSequence),TagLink(ImagePathFilterTypeStackCodeSequence),TagLink(LensesCodeSequence),TagLink(MetaboliteMapCodeSequence),TagLink(MaterialCodeSequence),TagLink(AcquisitionDeviceTypeCodeSequence),TagLink(PatientEyeMovementCommandCodeSequence),TagLink(RelativeImagePositionCodeSequence),TagLink(MydriaticAgentCodeSequence),TagLink(MydriaticAgentConcentrationUnitsSequence),TagLink(ScanPatternTypeCodeSequence),TagLink(TransformationMethodCodeSequence),TagLink(OphthalmicImageTypeCodeSequence),TagLink(SegmentedPropertyTypeCodeSequence),TagLink(EventCodeSequence),TagLink(TransducerScanPatternCodeSequence),TagLink(TransducerGeometryCodeSequence),TagLink(TransducerBeamSteeringCodeSequence),TagLink(TransducerApplicationCodeSequence),TagLink(VisualAcuityTypeCodeSequence),TagLink(OphthalmicUltrasoundMethodCodeSequence),TagLink(AnteriorChamberDepthDefinitionCodeSequence),TagLink(LensStatusCodeSequence),TagLink(VitreousStatusCodeSequence),TagLink(OphthalmicAxialLengthMeasurementsSegmentNameCodeSequence),TagLink(OphthalmicAxialLengthDataSourceCodeSequence),TagLink(OphthalmicAxialLengthSelectionMethodCodeSequence),TagLink(RefractiveSurgeryTypeCodeSequence),TagLink(RefractiveErrorBeforeRefractiveSurgeryCodeSequence),TagLink(SourceOfCornealSizeDataCodeSequence),TagLink(SourceOfLensThicknessDataCodeSequence),TagLink(SourceOfAnteriorChamberDepthDataCodeSequence),TagLink(SourceOfRefractiveMeasurementsCodeSequence),TagLink(SourceOfCorneaMeasurementDataCodeSequence),TagLink(IOLFormulaCodeSequence),TagLink(KeratometryMeasurementTypeCodeSequence),TagLink(SourceOfOphthalmicAxialLengthCodeSequence),TagLink(CorneaMeasurementMethodCodeSequence),TagLink(ScreeningTestModeCodeSequence),TagLink(StimulusColorCodeSequence),TagLink(BackgroundIlluminationColorCodeSequence),TagLink(FixationMonitoringCodeSequence),TagLink(ModeOfPercutaneousAccessSequence),TagLink(AcquisitionMethodCodeSequence),TagLink(OphthalmicThicknessMapTypeCodeSequence),TagLink(RetinalThicknessDefinitionCodeSequence),TagLink(SurfaceScanAcquisitionTypeCodeSequence),TagLink(SurfaceScanModeCodeSequence),TagLink(RegistrationMethodCodeSequence),TagLink(CornealTopographyMapTypeCodeSequence),TagLink(TrackSetAnatomicalTypeCodeSequence),TagLink(ModifierCodeSequence),TagLink(DiffusionAcquisitionCodeSequence),TagLink(DiffusionModelCodeSequence),TagLink(AcousticCouplingMediumCodeSequence),TagLink(TransducerTechnologySequence),TagLink(SoundSpeedCorrectionMechanismCodeSequence),TagLink(ImageDataTypeCodeSequence),TagLink(ChannelSourceModifiersSequence),TagLink(ChannelSensitivityUnitsSequence),TagLink(AnalogFilterTypeCodeSequence),TagLink(DigitalFilterTypeCodeSequence),TagLink(FrequencyEncodingCodeSequence),TagLink(MagnitudeEncodingCodeSequence),TagLink(DigitalSignaturePurposeCodeSequence),TagLink(VerifyingObserverIdentificationCodeSequence),TagLink(ResponsibleGroupCodeSequence),TagLink(PerformedProcedureCodeSequence),TagLink(OrganizationalRoleCodeSequence),TagLink(NumericValueQualifierCodeSequence),TagLink(RegistrationTypeCodeSequence),TagLink(FiducialsPropertyCategoryCodeSequence),TagLink(FiducialIdentifierCodeSequence),TagLink(AbstractPriorCodeSequence),TagLink(HangingProtocolUserIdentificationCodeSequence),TagLink(ImplantRegulatoryDisapprovalCodeSequence),TagLink(MaterialsCodeSequence),TagLink(CoatingMaterialsCodeSequence),TagLink(ImplantTypeCodeSequence),TagLink(FixationMethodCodeSequence),TagLink(ViewOrientationCodeSequence),TagLink(ViewOrientationModifierCodeSequence),TagLink(PlanningLandmarkIdentificationCodeSequence),TagLink(ProcedureTypeCodeSequence),TagLink(ComponentTypeCodeSequence),TagLink(AssessmentTypeCodeSequence),TagLink(ObservationBasisCodeSequence),TagLink(PotentialScheduledProtocolCodeSequence),TagLink(PotentialRequestedProcedureCodeSequence),TagLink(PotentialReasonsForProcedureCodeSequence),TagLink(ContraindicationsCodeSequence),TagLink(PositioningMethodCodeSequence),TagLink(RequestedSeriesDescriptionCodeSequence),TagLink(ModelUsageCodeSequence),TagLink(DosimetricObjectiveTypeCodeSequence),TagLink(EffectiveDoseCalculationMethodCategoryCodeSequence),TagLink(EffectiveDoseCalculationMethodCodeSequence),TagLink(TreatmentMachineSpecialModeCodeSequence),TagLink(DeliveryRateUnitSequence),TagLink(RadiationGenerationModeMachineCodeSequence),TagLink(RadiationTypeCodeSequence),TagLink(EnergyUnitCodeSequence),TagLink(RadiationFluenceModifierCodeSequence),TagLink(CompensatorShapeFabricationCodeSequence),TagLink(InterlockCodeSequence),TagLink(InterlockResolutionCodeSequence),TagLink(ParallelRTBeamDelimiterDeviceOrientationLabelCodeSequence),TagLink(DisplacementReferenceLocationCodeSequence),TagLink(PatientTreatmentPreparationMethodCodeSequence),TagLink(PatientTreatmentPreparationProcedureCodeSequence),TagLink(EnergyDerivationCodeSequence),TagLink(RadiationDosimeterUnitSequence),TagLink(RTDiagnosisCodeSequence),TagLink(ConceptualVolumeCategoryCodeSequence),TagLink(ConceptualVolumeTypeCodeSequence),TagLink(ConceptualVolumeTypeModifierCodeSequence),TagLink(DeliveryTimeStructureCodeSequence),TagLink(SegmentAnnotationCategoryCodeSequence),TagLink(SegmentAnnotationTypeCodeSequence),TagLink(SegmentAnnotationTypeModifierCodeSequence),TagLink(RTDeviceDistanceReferenceLocationCodeSequence),TagLink(EquipmentReferencePointCodeSequence),TagLink(RoboticPathNodeSetCodeSequence),TagLink(DoseMeasurementDeviceCodeSequence),TagLink(TreatmentToleranceViolationTypeCodeSequence),TagLink(TreatmentToleranceViolationCauseCodeSequence),TagLink(ReasonForOmissionCodeSequence),TagLink(AcquisitionTaskWorkitemCodeSequence),TagLink(SubtaskWorkitemCodeSequence),TagLink(PositionAcquisitionTemplateCodeSequence),TagLink(AnnotationPropertyCategoryCodeSequence),TagLink(AnnotationPropertyTypeCodeSequence),TagLink(AnnotationPropertyTypeModifierCodeSequence),TagLink(ReasonForRemovalCodeSequence),TagLink(AnatomicRegionsInStudyCodeSequence),TagLink(MontageChannelSourceCodeSequence),])
    CodingSchemeUID = Tag('Coding Scheme UID', "CodingSchemeUID", 0x0008, 0x010C, [TagLink(CodingSchemeIdentificationSequence),])
    ContextGroupExtensionCreatorUID = Tag('Context Group Extension Creator UID', "ContextGroupExtensionCreatorUID", 0x0008, 0x010D, [TagLink(EquivalentCodeSequence),TagLink(PersonIdentificationCodeSequence),TagLink(InstitutionCodeSequence),TagLink(InstitutionalDepartmentTypeCodeSequence),TagLink(ConceptNameCodeSequence),TagLink(ConceptCodeSequence),TagLink(MeasurementUnitsCodeSequence),TagLink(AnatomicRegionSequence),TagLink(AnatomicRegionModifierSequence),TagLink(PrimaryAnatomicStructureSequence),TagLink(PrimaryAnatomicStructureModifierSequence),TagLink(RequestedProcedureCodeSequence),TagLink(ReasonForRequestedProcedureCodeSequence),TagLink(ScheduledProtocolCodeSequence),TagLink(LanguageCodeSequence),TagLink(PerformedProtocolCodeSequence),TagLink(PatientOrientationCodeSequence),TagLink(PatientOrientationModifierCodeSequence),TagLink(PatientGantryRelationshipCodeSequence),TagLink(PatientEquipmentRelationshipCodeSequence),TagLink(AssigningJurisdictionCodeSequence),TagLink(AssigningAgencyOrDepartmentCodeSequence),TagLink(AlgorithmFamilyCodeSequence),TagLink(AlgorithmNameCodeSequence),TagLink(ViewCodeSequence),TagLink(ViewModifierCodeSequence),TagLink(DeviceMotionParameterCodeSequence),TagLink(SelectorCodeSequenceValue),TagLink(ReferenceBasisCodeSequence),TagLink(ReferenceGeometryCodeSequence),TagLink(AssertionCodeSequence),TagLink(DeviceTypeCodeSequence),TagLink(PurposeOfReferenceCodeSequence),TagLink(PatientLocationCoordinatesCodeSequence),TagLink(EthnicGroupCodeSequence),TagLink(PatientSpeciesCodeSequence),TagLink(PatientBreedCodeSequence),TagLink(BreedRegistryCodeSequence),TagLink(StrainCodeSequence),TagLink(StrainSourceRegistryCodeSequence),TagLink(GeneticModificationsCodeSequence),TagLink(DeidentificationMethodCodeSequence),TagLink(RequestingServiceCodeSequence),TagLink(ProcedureCodeSequence),TagLink(ReasonForPerformedProcedureCodeSequence),TagLink(AdmittingDiagnosesCodeSequence),TagLink(PrincipalDiagnosisCodeSequence),TagLink(PrimaryDiagnosisCodeSequence),TagLink(SecondaryDiagnosesCodeSequence),TagLink(HistologicalDiagnosesCodeSequence),TagLink(PatientSizeCodeSequence),TagLink(ReasonForVisitCodeSequence),TagLink(ClinicalTrialTimePointTypeCodeSequence),TagLink(SeriesDescriptionCodeSequence),TagLink(ContrastBolusAgentSequence),TagLink(ContrastBolusAdministrationRouteSequence),TagLink(AdditionalDrugSequence),TagLink(ContrastBolusIngredientCodeSequence),TagLink(ChannelSourceSequence),TagLink(DeviceSequence),TagLink(InterventionSequence),TagLink(InterventionDrugCodeSequence),TagLink(AdministrationRouteCodeSequence),TagLink(DerivationCodeSequence),TagLink(PatientPhysiologicalStateCodeSequence),TagLink(ContainerTypeCodeSequence),TagLink(ContainerComponentTypeCodeSequence),TagLink(SpecimenTypeCodeSequence),TagLink(CTDIPhantomTypeCodeSequence),TagLink(WaterEquivalentDiameterCalculationMethodCodeSequence),TagLink(RadionuclideCodeSequence),TagLink(RadiopharmaceuticalCodeSequence),TagLink(PixelValueMappingCodeSequence),TagLink(StageCodeSequence),TagLink(DocumentClassCodeSequence),TagLink(TreatmentSiteCodeSequence),TagLink(TreatmentSiteModifierCodeSequence),TagLink(RTProtocolCodeSequence),TagLink(ROIObservationContextCodeSequence),TagLink(SegmentedPropertyCategoryCodeSequence),TagLink(RTROIIdentificationCodeSequence),TagLink(SegmentedPropertyTypeModifierCodeSequence),TagLink(TherapeuticRoleCategoryCodeSequence),TagLink(TherapeuticRoleTypeCodeSequence),TagLink(RTTreatmentTechniqueCodeSequence),TagLink(RTTreatmentTerminationReasonCodeSequence),TagLink(MachineSpecificTreatmentTerminationCodeSequence),TagLink(ProjectionEponymousNameCodeSequence),TagLink(PartialViewCodeSequence),TagLink(ChannelDescriptionCodeSequence),TagLink(IlluminatorTypeCodeSequence),TagLink(IlluminationColorCodeSequence),TagLink(IlluminationTypeCodeSequence),TagLink(LightPathFilterTypeStackCodeSequence),TagLink(ImagePathFilterTypeStackCodeSequence),TagLink(LensesCodeSequence),TagLink(MetaboliteMapCodeSequence),TagLink(MaterialCodeSequence),TagLink(AcquisitionDeviceTypeCodeSequence),TagLink(PatientEyeMovementCommandCodeSequence),TagLink(RelativeImagePositionCodeSequence),TagLink(MydriaticAgentCodeSequence),TagLink(MydriaticAgentConcentrationUnitsSequence),TagLink(ScanPatternTypeCodeSequence),TagLink(TransformationMethodCodeSequence),TagLink(OphthalmicImageTypeCodeSequence),TagLink(SegmentedPropertyTypeCodeSequence),TagLink(EventCodeSequence),TagLink(TransducerScanPatternCodeSequence),TagLink(TransducerGeometryCodeSequence),TagLink(TransducerBeamSteeringCodeSequence),TagLink(TransducerApplicationCodeSequence),TagLink(VisualAcuityTypeCodeSequence),TagLink(OphthalmicUltrasoundMethodCodeSequence),TagLink(AnteriorChamberDepthDefinitionCodeSequence),TagLink(LensStatusCodeSequence),TagLink(VitreousStatusCodeSequence),TagLink(OphthalmicAxialLengthMeasurementsSegmentNameCodeSequence),TagLink(OphthalmicAxialLengthDataSourceCodeSequence),TagLink(OphthalmicAxialLengthSelectionMethodCodeSequence),TagLink(RefractiveSurgeryTypeCodeSequence),TagLink(RefractiveErrorBeforeRefractiveSurgeryCodeSequence),TagLink(SourceOfCornealSizeDataCodeSequence),TagLink(SourceOfLensThicknessDataCodeSequence),TagLink(SourceOfAnteriorChamberDepthDataCodeSequence),TagLink(SourceOfRefractiveMeasurementsCodeSequence),TagLink(SourceOfCorneaMeasurementDataCodeSequence),TagLink(IOLFormulaCodeSequence),TagLink(KeratometryMeasurementTypeCodeSequence),TagLink(SourceOfOphthalmicAxialLengthCodeSequence),TagLink(CorneaMeasurementMethodCodeSequence),TagLink(ScreeningTestModeCodeSequence),TagLink(StimulusColorCodeSequence),TagLink(BackgroundIlluminationColorCodeSequence),TagLink(FixationMonitoringCodeSequence),TagLink(ModeOfPercutaneousAccessSequence),TagLink(AcquisitionMethodCodeSequence),TagLink(OphthalmicThicknessMapTypeCodeSequence),TagLink(RetinalThicknessDefinitionCodeSequence),TagLink(SurfaceScanAcquisitionTypeCodeSequence),TagLink(SurfaceScanModeCodeSequence),TagLink(RegistrationMethodCodeSequence),TagLink(CornealTopographyMapTypeCodeSequence),TagLink(TrackSetAnatomicalTypeCodeSequence),TagLink(ModifierCodeSequence),TagLink(DiffusionAcquisitionCodeSequence),TagLink(DiffusionModelCodeSequence),TagLink(AcousticCouplingMediumCodeSequence),TagLink(TransducerTechnologySequence),TagLink(SoundSpeedCorrectionMechanismCodeSequence),TagLink(ImageDataTypeCodeSequence),TagLink(ChannelSourceModifiersSequence),TagLink(ChannelSensitivityUnitsSequence),TagLink(AnalogFilterTypeCodeSequence),TagLink(DigitalFilterTypeCodeSequence),TagLink(FrequencyEncodingCodeSequence),TagLink(MagnitudeEncodingCodeSequence),TagLink(DigitalSignaturePurposeCodeSequence),TagLink(VerifyingObserverIdentificationCodeSequence),TagLink(ResponsibleGroupCodeSequence),TagLink(PerformedProcedureCodeSequence),TagLink(OrganizationalRoleCodeSequence),TagLink(NumericValueQualifierCodeSequence),TagLink(RegistrationTypeCodeSequence),TagLink(FiducialsPropertyCategoryCodeSequence),TagLink(FiducialIdentifierCodeSequence),TagLink(AbstractPriorCodeSequence),TagLink(HangingProtocolUserIdentificationCodeSequence),TagLink(ImplantRegulatoryDisapprovalCodeSequence),TagLink(MaterialsCodeSequence),TagLink(CoatingMaterialsCodeSequence),TagLink(ImplantTypeCodeSequence),TagLink(FixationMethodCodeSequence),TagLink(ViewOrientationCodeSequence),TagLink(ViewOrientationModifierCodeSequence),TagLink(PlanningLandmarkIdentificationCodeSequence),TagLink(ProcedureTypeCodeSequence),TagLink(ComponentTypeCodeSequence),TagLink(AssessmentTypeCodeSequence),TagLink(ObservationBasisCodeSequence),TagLink(PotentialScheduledProtocolCodeSequence),TagLink(PotentialRequestedProcedureCodeSequence),TagLink(PotentialReasonsForProcedureCodeSequence),TagLink(ContraindicationsCodeSequence),TagLink(PositioningMethodCodeSequence),TagLink(RequestedSeriesDescriptionCodeSequence),TagLink(ModelUsageCodeSequence),TagLink(DosimetricObjectiveTypeCodeSequence),TagLink(EffectiveDoseCalculationMethodCategoryCodeSequence),TagLink(EffectiveDoseCalculationMethodCodeSequence),TagLink(TreatmentMachineSpecialModeCodeSequence),TagLink(DeliveryRateUnitSequence),TagLink(RadiationGenerationModeMachineCodeSequence),TagLink(RadiationTypeCodeSequence),TagLink(EnergyUnitCodeSequence),TagLink(RadiationFluenceModifierCodeSequence),TagLink(CompensatorShapeFabricationCodeSequence),TagLink(InterlockCodeSequence),TagLink(InterlockResolutionCodeSequence),TagLink(ParallelRTBeamDelimiterDeviceOrientationLabelCodeSequence),TagLink(DisplacementReferenceLocationCodeSequence),TagLink(PatientTreatmentPreparationMethodCodeSequence),TagLink(PatientTreatmentPreparationProcedureCodeSequence),TagLink(EnergyDerivationCodeSequence),TagLink(RadiationDosimeterUnitSequence),TagLink(RTDiagnosisCodeSequence),TagLink(ConceptualVolumeCategoryCodeSequence),TagLink(ConceptualVolumeTypeCodeSequence),TagLink(ConceptualVolumeTypeModifierCodeSequence),TagLink(DeliveryTimeStructureCodeSequence),TagLink(SegmentAnnotationCategoryCodeSequence),TagLink(SegmentAnnotationTypeCodeSequence),TagLink(SegmentAnnotationTypeModifierCodeSequence),TagLink(RTDeviceDistanceReferenceLocationCodeSequence),TagLink(EquipmentReferencePointCodeSequence),TagLink(RoboticPathNodeSetCodeSequence),TagLink(DoseMeasurementDeviceCodeSequence),TagLink(TreatmentToleranceViolationTypeCodeSequence),TagLink(TreatmentToleranceViolationCauseCodeSequence),TagLink(ReasonForOmissionCodeSequence),TagLink(AcquisitionTaskWorkitemCodeSequence),TagLink(SubtaskWorkitemCodeSequence),TagLink(PositionAcquisitionTemplateCodeSequence),TagLink(AnnotationPropertyCategoryCodeSequence),TagLink(AnnotationPropertyTypeCodeSequence),TagLink(AnnotationPropertyTypeModifierCodeSequence),TagLink(ReasonForRemovalCodeSequence),TagLink(AnatomicRegionsInStudyCodeSequence),TagLink(MontageChannelSourceCodeSequence),])
    CodingSchemeURL = Tag('Coding Scheme URL', "CodingSchemeURL", 0x0008, 0x010E, [TagLink(CodingSchemeResourcesSequence),])
    ContextIdentifier = Tag('Context Identifier', "ContextIdentifier", 0x0008, 0x010F, [TagLink(EquivalentCodeSequence),TagLink(PersonIdentificationCodeSequence),TagLink(InstitutionCodeSequence),TagLink(InstitutionalDepartmentTypeCodeSequence),TagLink(ConceptNameCodeSequence),TagLink(ConceptCodeSequence),TagLink(MeasurementUnitsCodeSequence),TagLink(AnatomicRegionSequence),TagLink(AnatomicRegionModifierSequence),TagLink(PrimaryAnatomicStructureSequence),TagLink(PrimaryAnatomicStructureModifierSequence),TagLink(RequestedProcedureCodeSequence),TagLink(ReasonForRequestedProcedureCodeSequence),TagLink(ScheduledProtocolCodeSequence),TagLink(LanguageCodeSequence),TagLink(PerformedProtocolCodeSequence),TagLink(PatientOrientationCodeSequence),TagLink(PatientOrientationModifierCodeSequence),TagLink(PatientGantryRelationshipCodeSequence),TagLink(PatientEquipmentRelationshipCodeSequence),TagLink(AssigningJurisdictionCodeSequence),TagLink(AssigningAgencyOrDepartmentCodeSequence),TagLink(AlgorithmFamilyCodeSequence),TagLink(AlgorithmNameCodeSequence),TagLink(ViewCodeSequence),TagLink(ViewModifierCodeSequence),TagLink(DeviceMotionParameterCodeSequence),TagLink(SelectorCodeSequenceValue),TagLink(ReferenceBasisCodeSequence),TagLink(ReferenceGeometryCodeSequence),TagLink(AssertionCodeSequence),TagLink(DeviceTypeCodeSequence),TagLink(PurposeOfReferenceCodeSequence),TagLink(PatientLocationCoordinatesCodeSequence),TagLink(EthnicGroupCodeSequence),TagLink(PatientSpeciesCodeSequence),TagLink(PatientBreedCodeSequence),TagLink(BreedRegistryCodeSequence),TagLink(StrainCodeSequence),TagLink(StrainSourceRegistryCodeSequence),TagLink(GeneticModificationsCodeSequence),TagLink(DeidentificationMethodCodeSequence),TagLink(RequestingServiceCodeSequence),TagLink(ProcedureCodeSequence),TagLink(ReasonForPerformedProcedureCodeSequence),TagLink(AdmittingDiagnosesCodeSequence),TagLink(PrincipalDiagnosisCodeSequence),TagLink(PrimaryDiagnosisCodeSequence),TagLink(SecondaryDiagnosesCodeSequence),TagLink(HistologicalDiagnosesCodeSequence),TagLink(PatientSizeCodeSequence),TagLink(ReasonForVisitCodeSequence),TagLink(ClinicalTrialTimePointTypeCodeSequence),TagLink(SeriesDescriptionCodeSequence),TagLink(ContrastBolusAgentSequence),TagLink(ContrastBolusAdministrationRouteSequence),TagLink(AdditionalDrugSequence),TagLink(ContrastBolusIngredientCodeSequence),TagLink(ChannelSourceSequence),TagLink(DeviceSequence),TagLink(InterventionSequence),TagLink(InterventionDrugCodeSequence),TagLink(AdministrationRouteCodeSequence),TagLink(DerivationCodeSequence),TagLink(PatientPhysiologicalStateCodeSequence),TagLink(ContainerTypeCodeSequence),TagLink(ContainerComponentTypeCodeSequence),TagLink(SpecimenTypeCodeSequence),TagLink(CTDIPhantomTypeCodeSequence),TagLink(WaterEquivalentDiameterCalculationMethodCodeSequence),TagLink(RadionuclideCodeSequence),TagLink(RadiopharmaceuticalCodeSequence),TagLink(PixelValueMappingCodeSequence),TagLink(StageCodeSequence),TagLink(DocumentClassCodeSequence),TagLink(TreatmentSiteCodeSequence),TagLink(TreatmentSiteModifierCodeSequence),TagLink(RTProtocolCodeSequence),TagLink(ROIObservationContextCodeSequence),TagLink(SegmentedPropertyCategoryCodeSequence),TagLink(RTROIIdentificationCodeSequence),TagLink(SegmentedPropertyTypeModifierCodeSequence),TagLink(TherapeuticRoleCategoryCodeSequence),TagLink(TherapeuticRoleTypeCodeSequence),TagLink(RTTreatmentTechniqueCodeSequence),TagLink(RTTreatmentTerminationReasonCodeSequence),TagLink(MachineSpecificTreatmentTerminationCodeSequence),TagLink(ProjectionEponymousNameCodeSequence),TagLink(PartialViewCodeSequence),TagLink(ChannelDescriptionCodeSequence),TagLink(IlluminatorTypeCodeSequence),TagLink(IlluminationColorCodeSequence),TagLink(IlluminationTypeCodeSequence),TagLink(LightPathFilterTypeStackCodeSequence),TagLink(ImagePathFilterTypeStackCodeSequence),TagLink(LensesCodeSequence),TagLink(MetaboliteMapCodeSequence),TagLink(MaterialCodeSequence),TagLink(AcquisitionDeviceTypeCodeSequence),TagLink(PatientEyeMovementCommandCodeSequence),TagLink(RelativeImagePositionCodeSequence),TagLink(MydriaticAgentCodeSequence),TagLink(MydriaticAgentConcentrationUnitsSequence),TagLink(ScanPatternTypeCodeSequence),TagLink(TransformationMethodCodeSequence),TagLink(OphthalmicImageTypeCodeSequence),TagLink(SegmentedPropertyTypeCodeSequence),TagLink(EventCodeSequence),TagLink(TransducerScanPatternCodeSequence),TagLink(TransducerGeometryCodeSequence),TagLink(TransducerBeamSteeringCodeSequence),TagLink(TransducerApplicationCodeSequence),TagLink(VisualAcuityTypeCodeSequence),TagLink(OphthalmicUltrasoundMethodCodeSequence),TagLink(AnteriorChamberDepthDefinitionCodeSequence),TagLink(LensStatusCodeSequence),TagLink(VitreousStatusCodeSequence),TagLink(OphthalmicAxialLengthMeasurementsSegmentNameCodeSequence),TagLink(OphthalmicAxialLengthDataSourceCodeSequence),TagLink(OphthalmicAxialLengthSelectionMethodCodeSequence),TagLink(RefractiveSurgeryTypeCodeSequence),TagLink(RefractiveErrorBeforeRefractiveSurgeryCodeSequence),TagLink(SourceOfCornealSizeDataCodeSequence),TagLink(SourceOfLensThicknessDataCodeSequence),TagLink(SourceOfAnteriorChamberDepthDataCodeSequence),TagLink(SourceOfRefractiveMeasurementsCodeSequence),TagLink(SourceOfCorneaMeasurementDataCodeSequence),TagLink(IOLFormulaCodeSequence),TagLink(KeratometryMeasurementTypeCodeSequence),TagLink(SourceOfOphthalmicAxialLengthCodeSequence),TagLink(CorneaMeasurementMethodCodeSequence),TagLink(ScreeningTestModeCodeSequence),TagLink(StimulusColorCodeSequence),TagLink(BackgroundIlluminationColorCodeSequence),TagLink(FixationMonitoringCodeSequence),TagLink(ModeOfPercutaneousAccessSequence),TagLink(AcquisitionMethodCodeSequence),TagLink(OphthalmicThicknessMapTypeCodeSequence),TagLink(RetinalThicknessDefinitionCodeSequence),TagLink(SurfaceScanAcquisitionTypeCodeSequence),TagLink(SurfaceScanModeCodeSequence),TagLink(RegistrationMethodCodeSequence),TagLink(CornealTopographyMapTypeCodeSequence),TagLink(TrackSetAnatomicalTypeCodeSequence),TagLink(ModifierCodeSequence),TagLink(DiffusionAcquisitionCodeSequence),TagLink(DiffusionModelCodeSequence),TagLink(AcousticCouplingMediumCodeSequence),TagLink(TransducerTechnologySequence),TagLink(SoundSpeedCorrectionMechanismCodeSequence),TagLink(ImageDataTypeCodeSequence),TagLink(ChannelSourceModifiersSequence),TagLink(ChannelSensitivityUnitsSequence),TagLink(AnalogFilterTypeCodeSequence),TagLink(DigitalFilterTypeCodeSequence),TagLink(FrequencyEncodingCodeSequence),TagLink(MagnitudeEncodingCodeSequence),TagLink(ContextGroupIdentificationSequence),TagLink(DigitalSignaturePurposeCodeSequence),TagLink(VerifyingObserverIdentificationCodeSequence),TagLink(ResponsibleGroupCodeSequence),TagLink(PerformedProcedureCodeSequence),TagLink(OrganizationalRoleCodeSequence),TagLink(NumericValueQualifierCodeSequence),TagLink(RegistrationTypeCodeSequence),TagLink(FiducialsPropertyCategoryCodeSequence),TagLink(FiducialIdentifierCodeSequence),TagLink(AbstractPriorCodeSequence),TagLink(HangingProtocolUserIdentificationCodeSequence),TagLink(ImplantRegulatoryDisapprovalCodeSequence),TagLink(MaterialsCodeSequence),TagLink(CoatingMaterialsCodeSequence),TagLink(ImplantTypeCodeSequence),TagLink(FixationMethodCodeSequence),TagLink(ViewOrientationCodeSequence),TagLink(ViewOrientationModifierCodeSequence),TagLink(PlanningLandmarkIdentificationCodeSequence),TagLink(ProcedureTypeCodeSequence),TagLink(ComponentTypeCodeSequence),TagLink(AssessmentTypeCodeSequence),TagLink(ObservationBasisCodeSequence),TagLink(PotentialScheduledProtocolCodeSequence),TagLink(PotentialRequestedProcedureCodeSequence),TagLink(PotentialReasonsForProcedureCodeSequence),TagLink(ContraindicationsCodeSequence),TagLink(PositioningMethodCodeSequence),TagLink(RequestedSeriesDescriptionCodeSequence),TagLink(ModelUsageCodeSequence),TagLink(DosimetricObjectiveTypeCodeSequence),TagLink(EffectiveDoseCalculationMethodCategoryCodeSequence),TagLink(EffectiveDoseCalculationMethodCodeSequence),TagLink(TreatmentMachineSpecialModeCodeSequence),TagLink(DeliveryRateUnitSequence),TagLink(RadiationGenerationModeMachineCodeSequence),TagLink(RadiationTypeCodeSequence),TagLink(EnergyUnitCodeSequence),TagLink(RadiationFluenceModifierCodeSequence),TagLink(CompensatorShapeFabricationCodeSequence),TagLink(InterlockCodeSequence),TagLink(InterlockResolutionCodeSequence),TagLink(ParallelRTBeamDelimiterDeviceOrientationLabelCodeSequence),TagLink(DisplacementReferenceLocationCodeSequence),TagLink(PatientTreatmentPreparationMethodCodeSequence),TagLink(PatientTreatmentPreparationProcedureCodeSequence),TagLink(EnergyDerivationCodeSequence),TagLink(RadiationDosimeterUnitSequence),TagLink(RTDiagnosisCodeSequence),TagLink(ConceptualVolumeCategoryCodeSequence),TagLink(ConceptualVolumeTypeCodeSequence),TagLink(ConceptualVolumeTypeModifierCodeSequence),TagLink(DeliveryTimeStructureCodeSequence),TagLink(SegmentAnnotationCategoryCodeSequence),TagLink(SegmentAnnotationTypeCodeSequence),TagLink(SegmentAnnotationTypeModifierCodeSequence),TagLink(RTDeviceDistanceReferenceLocationCodeSequence),TagLink(EquipmentReferencePointCodeSequence),TagLink(RoboticPathNodeSetCodeSequence),TagLink(DoseMeasurementDeviceCodeSequence),TagLink(TreatmentToleranceViolationTypeCodeSequence),TagLink(TreatmentToleranceViolationCauseCodeSequence),TagLink(ReasonForOmissionCodeSequence),TagLink(AcquisitionTaskWorkitemCodeSequence),TagLink(SubtaskWorkitemCodeSequence),TagLink(PositionAcquisitionTemplateCodeSequence),TagLink(AnnotationPropertyCategoryCodeSequence),TagLink(AnnotationPropertyTypeCodeSequence),TagLink(AnnotationPropertyTypeModifierCodeSequence),TagLink(ReasonForRemovalCodeSequence),TagLink(AnatomicRegionsInStudyCodeSequence),TagLink(MontageChannelSourceCodeSequence),])
    CodingSchemeRegistry = Tag('Coding Scheme Registry', "CodingSchemeRegistry", 0x0008, 0x0112, [TagLink(CodingSchemeIdentificationSequence),])
    CodingSchemeExternalID = Tag('Coding Scheme External ID', "CodingSchemeExternalID", 0x0008, 0x0114, [TagLink(CodingSchemeIdentificationSequence),])
    CodingSchemeName = Tag('Coding Scheme Name', "CodingSchemeName", 0x0008, 0x0115, [TagLink(CodingSchemeIdentificationSequence),])
    CodingSchemeResponsibleOrganization = Tag('Coding Scheme Responsible Organization', "CodingSchemeResponsibleOrganization", 0x0008, 0x0116, [TagLink(CodingSchemeIdentificationSequence),])
    ContextUID = Tag('Context UID', "ContextUID", 0x0008, 0x0117, [TagLink(EquivalentCodeSequence),TagLink(PersonIdentificationCodeSequence),TagLink(InstitutionCodeSequence),TagLink(InstitutionalDepartmentTypeCodeSequence),TagLink(ConceptNameCodeSequence),TagLink(ConceptCodeSequence),TagLink(MeasurementUnitsCodeSequence),TagLink(AnatomicRegionSequence),TagLink(AnatomicRegionModifierSequence),TagLink(PrimaryAnatomicStructureSequence),TagLink(PrimaryAnatomicStructureModifierSequence),TagLink(RequestedProcedureCodeSequence),TagLink(ReasonForRequestedProcedureCodeSequence),TagLink(ScheduledProtocolCodeSequence),TagLink(LanguageCodeSequence),TagLink(PerformedProtocolCodeSequence),TagLink(PatientOrientationCodeSequence),TagLink(PatientOrientationModifierCodeSequence),TagLink(PatientGantryRelationshipCodeSequence),TagLink(PatientEquipmentRelationshipCodeSequence),TagLink(AssigningJurisdictionCodeSequence),TagLink(AssigningAgencyOrDepartmentCodeSequence),TagLink(AlgorithmFamilyCodeSequence),TagLink(AlgorithmNameCodeSequence),TagLink(ViewCodeSequence),TagLink(ViewModifierCodeSequence),TagLink(DeviceMotionParameterCodeSequence),TagLink(SelectorCodeSequenceValue),TagLink(ReferenceBasisCodeSequence),TagLink(ReferenceGeometryCodeSequence),TagLink(AssertionCodeSequence),TagLink(DeviceTypeCodeSequence),TagLink(PurposeOfReferenceCodeSequence),TagLink(PatientLocationCoordinatesCodeSequence),TagLink(EthnicGroupCodeSequence),TagLink(PatientSpeciesCodeSequence),TagLink(PatientBreedCodeSequence),TagLink(BreedRegistryCodeSequence),TagLink(StrainCodeSequence),TagLink(StrainSourceRegistryCodeSequence),TagLink(GeneticModificationsCodeSequence),TagLink(DeidentificationMethodCodeSequence),TagLink(RequestingServiceCodeSequence),TagLink(ProcedureCodeSequence),TagLink(ReasonForPerformedProcedureCodeSequence),TagLink(AdmittingDiagnosesCodeSequence),TagLink(PrincipalDiagnosisCodeSequence),TagLink(PrimaryDiagnosisCodeSequence),TagLink(SecondaryDiagnosesCodeSequence),TagLink(HistologicalDiagnosesCodeSequence),TagLink(PatientSizeCodeSequence),TagLink(ReasonForVisitCodeSequence),TagLink(ClinicalTrialTimePointTypeCodeSequence),TagLink(SeriesDescriptionCodeSequence),TagLink(ContrastBolusAgentSequence),TagLink(ContrastBolusAdministrationRouteSequence),TagLink(AdditionalDrugSequence),TagLink(ContrastBolusIngredientCodeSequence),TagLink(ChannelSourceSequence),TagLink(DeviceSequence),TagLink(InterventionSequence),TagLink(InterventionDrugCodeSequence),TagLink(AdministrationRouteCodeSequence),TagLink(DerivationCodeSequence),TagLink(PatientPhysiologicalStateCodeSequence),TagLink(ContainerTypeCodeSequence),TagLink(ContainerComponentTypeCodeSequence),TagLink(SpecimenTypeCodeSequence),TagLink(CTDIPhantomTypeCodeSequence),TagLink(WaterEquivalentDiameterCalculationMethodCodeSequence),TagLink(RadionuclideCodeSequence),TagLink(RadiopharmaceuticalCodeSequence),TagLink(PixelValueMappingCodeSequence),TagLink(StageCodeSequence),TagLink(DocumentClassCodeSequence),TagLink(TreatmentSiteCodeSequence),TagLink(TreatmentSiteModifierCodeSequence),TagLink(RTProtocolCodeSequence),TagLink(ROIObservationContextCodeSequence),TagLink(SegmentedPropertyCategoryCodeSequence),TagLink(RTROIIdentificationCodeSequence),TagLink(SegmentedPropertyTypeModifierCodeSequence),TagLink(TherapeuticRoleCategoryCodeSequence),TagLink(TherapeuticRoleTypeCodeSequence),TagLink(RTTreatmentTechniqueCodeSequence),TagLink(RTTreatmentTerminationReasonCodeSequence),TagLink(MachineSpecificTreatmentTerminationCodeSequence),TagLink(ProjectionEponymousNameCodeSequence),TagLink(PartialViewCodeSequence),TagLink(ChannelDescriptionCodeSequence),TagLink(IlluminatorTypeCodeSequence),TagLink(IlluminationColorCodeSequence),TagLink(IlluminationTypeCodeSequence),TagLink(LightPathFilterTypeStackCodeSequence),TagLink(ImagePathFilterTypeStackCodeSequence),TagLink(LensesCodeSequence),TagLink(MetaboliteMapCodeSequence),TagLink(MaterialCodeSequence),TagLink(AcquisitionDeviceTypeCodeSequence),TagLink(PatientEyeMovementCommandCodeSequence),TagLink(RelativeImagePositionCodeSequence),TagLink(MydriaticAgentCodeSequence),TagLink(MydriaticAgentConcentrationUnitsSequence),TagLink(ScanPatternTypeCodeSequence),TagLink(TransformationMethodCodeSequence),TagLink(OphthalmicImageTypeCodeSequence),TagLink(SegmentedPropertyTypeCodeSequence),TagLink(EventCodeSequence),TagLink(TransducerScanPatternCodeSequence),TagLink(TransducerGeometryCodeSequence),TagLink(TransducerBeamSteeringCodeSequence),TagLink(TransducerApplicationCodeSequence),TagLink(VisualAcuityTypeCodeSequence),TagLink(OphthalmicUltrasoundMethodCodeSequence),TagLink(AnteriorChamberDepthDefinitionCodeSequence),TagLink(LensStatusCodeSequence),TagLink(VitreousStatusCodeSequence),TagLink(OphthalmicAxialLengthMeasurementsSegmentNameCodeSequence),TagLink(OphthalmicAxialLengthDataSourceCodeSequence),TagLink(OphthalmicAxialLengthSelectionMethodCodeSequence),TagLink(RefractiveSurgeryTypeCodeSequence),TagLink(RefractiveErrorBeforeRefractiveSurgeryCodeSequence),TagLink(SourceOfCornealSizeDataCodeSequence),TagLink(SourceOfLensThicknessDataCodeSequence),TagLink(SourceOfAnteriorChamberDepthDataCodeSequence),TagLink(SourceOfRefractiveMeasurementsCodeSequence),TagLink(SourceOfCorneaMeasurementDataCodeSequence),TagLink(IOLFormulaCodeSequence),TagLink(KeratometryMeasurementTypeCodeSequence),TagLink(SourceOfOphthalmicAxialLengthCodeSequence),TagLink(CorneaMeasurementMethodCodeSequence),TagLink(ScreeningTestModeCodeSequence),TagLink(StimulusColorCodeSequence),TagLink(BackgroundIlluminationColorCodeSequence),TagLink(FixationMonitoringCodeSequence),TagLink(ModeOfPercutaneousAccessSequence),TagLink(AcquisitionMethodCodeSequence),TagLink(OphthalmicThicknessMapTypeCodeSequence),TagLink(RetinalThicknessDefinitionCodeSequence),TagLink(SurfaceScanAcquisitionTypeCodeSequence),TagLink(SurfaceScanModeCodeSequence),TagLink(RegistrationMethodCodeSequence),TagLink(CornealTopographyMapTypeCodeSequence),TagLink(TrackSetAnatomicalTypeCodeSequence),TagLink(ModifierCodeSequence),TagLink(DiffusionAcquisitionCodeSequence),TagLink(DiffusionModelCodeSequence),TagLink(AcousticCouplingMediumCodeSequence),TagLink(TransducerTechnologySequence),TagLink(SoundSpeedCorrectionMechanismCodeSequence),TagLink(ImageDataTypeCodeSequence),TagLink(ChannelSourceModifiersSequence),TagLink(ChannelSensitivityUnitsSequence),TagLink(AnalogFilterTypeCodeSequence),TagLink(DigitalFilterTypeCodeSequence),TagLink(FrequencyEncodingCodeSequence),TagLink(MagnitudeEncodingCodeSequence),TagLink(ContextGroupIdentificationSequence),TagLink(DigitalSignaturePurposeCodeSequence),TagLink(VerifyingObserverIdentificationCodeSequence),TagLink(ResponsibleGroupCodeSequence),TagLink(PerformedProcedureCodeSequence),TagLink(OrganizationalRoleCodeSequence),TagLink(NumericValueQualifierCodeSequence),TagLink(RegistrationTypeCodeSequence),TagLink(FiducialsPropertyCategoryCodeSequence),TagLink(FiducialIdentifierCodeSequence),TagLink(AbstractPriorCodeSequence),TagLink(HangingProtocolUserIdentificationCodeSequence),TagLink(ImplantRegulatoryDisapprovalCodeSequence),TagLink(MaterialsCodeSequence),TagLink(CoatingMaterialsCodeSequence),TagLink(ImplantTypeCodeSequence),TagLink(FixationMethodCodeSequence),TagLink(ViewOrientationCodeSequence),TagLink(ViewOrientationModifierCodeSequence),TagLink(PlanningLandmarkIdentificationCodeSequence),TagLink(ProcedureTypeCodeSequence),TagLink(ComponentTypeCodeSequence),TagLink(AssessmentTypeCodeSequence),TagLink(ObservationBasisCodeSequence),TagLink(PotentialScheduledProtocolCodeSequence),TagLink(PotentialRequestedProcedureCodeSequence),TagLink(PotentialReasonsForProcedureCodeSequence),TagLink(ContraindicationsCodeSequence),TagLink(PositioningMethodCodeSequence),TagLink(RequestedSeriesDescriptionCodeSequence),TagLink(ModelUsageCodeSequence),TagLink(DosimetricObjectiveTypeCodeSequence),TagLink(EffectiveDoseCalculationMethodCategoryCodeSequence),TagLink(EffectiveDoseCalculationMethodCodeSequence),TagLink(TreatmentMachineSpecialModeCodeSequence),TagLink(DeliveryRateUnitSequence),TagLink(RadiationGenerationModeMachineCodeSequence),TagLink(RadiationTypeCodeSequence),TagLink(EnergyUnitCodeSequence),TagLink(RadiationFluenceModifierCodeSequence),TagLink(CompensatorShapeFabricationCodeSequence),TagLink(InterlockCodeSequence),TagLink(InterlockResolutionCodeSequence),TagLink(ParallelRTBeamDelimiterDeviceOrientationLabelCodeSequence),TagLink(DisplacementReferenceLocationCodeSequence),TagLink(PatientTreatmentPreparationMethodCodeSequence),TagLink(PatientTreatmentPreparationProcedureCodeSequence),TagLink(EnergyDerivationCodeSequence),TagLink(RadiationDosimeterUnitSequence),TagLink(RTDiagnosisCodeSequence),TagLink(ConceptualVolumeCategoryCodeSequence),TagLink(ConceptualVolumeTypeCodeSequence),TagLink(ConceptualVolumeTypeModifierCodeSequence),TagLink(DeliveryTimeStructureCodeSequence),TagLink(SegmentAnnotationCategoryCodeSequence),TagLink(SegmentAnnotationTypeCodeSequence),TagLink(SegmentAnnotationTypeModifierCodeSequence),TagLink(RTDeviceDistanceReferenceLocationCodeSequence),TagLink(EquipmentReferencePointCodeSequence),TagLink(RoboticPathNodeSetCodeSequence),TagLink(DoseMeasurementDeviceCodeSequence),TagLink(TreatmentToleranceViolationTypeCodeSequence),TagLink(TreatmentToleranceViolationCauseCodeSequence),TagLink(ReasonForOmissionCodeSequence),TagLink(AcquisitionTaskWorkitemCodeSequence),TagLink(SubtaskWorkitemCodeSequence),TagLink(PositionAcquisitionTemplateCodeSequence),TagLink(AnnotationPropertyCategoryCodeSequence),TagLink(AnnotationPropertyTypeCodeSequence),TagLink(AnnotationPropertyTypeModifierCodeSequence),TagLink(ReasonForRemovalCodeSequence),TagLink(AnatomicRegionsInStudyCodeSequence),TagLink(MontageChannelSourceCodeSequence),])
    MappingResourceUID = Tag('Mapping Resource UID', "MappingResourceUID", 0x0008, 0x0118, [TagLink(EquivalentCodeSequence),TagLink(PersonIdentificationCodeSequence),TagLink(InstitutionCodeSequence),TagLink(InstitutionalDepartmentTypeCodeSequence),TagLink(ConceptNameCodeSequence),TagLink(ConceptCodeSequence),TagLink(MeasurementUnitsCodeSequence),TagLink(AnatomicRegionSequence),TagLink(AnatomicRegionModifierSequence),TagLink(PrimaryAnatomicStructureSequence),TagLink(PrimaryAnatomicStructureModifierSequence),TagLink(RequestedProcedureCodeSequence),TagLink(ReasonForRequestedProcedureCodeSequence),TagLink(ScheduledProtocolCodeSequence),TagLink(LanguageCodeSequence),TagLink(PerformedProtocolCodeSequence),TagLink(PatientOrientationCodeSequence),TagLink(PatientOrientationModifierCodeSequence),TagLink(PatientGantryRelationshipCodeSequence),TagLink(PatientEquipmentRelationshipCodeSequence),TagLink(AssigningJurisdictionCodeSequence),TagLink(AssigningAgencyOrDepartmentCodeSequence),TagLink(AlgorithmFamilyCodeSequence),TagLink(AlgorithmNameCodeSequence),TagLink(ViewCodeSequence),TagLink(ViewModifierCodeSequence),TagLink(DeviceMotionParameterCodeSequence),TagLink(SelectorCodeSequenceValue),TagLink(ReferenceBasisCodeSequence),TagLink(ReferenceGeometryCodeSequence),TagLink(AssertionCodeSequence),TagLink(DeviceTypeCodeSequence),TagLink(PurposeOfReferenceCodeSequence),TagLink(PatientLocationCoordinatesCodeSequence),TagLink(EthnicGroupCodeSequence),TagLink(PatientSpeciesCodeSequence),TagLink(PatientBreedCodeSequence),TagLink(BreedRegistryCodeSequence),TagLink(StrainCodeSequence),TagLink(StrainSourceRegistryCodeSequence),TagLink(GeneticModificationsCodeSequence),TagLink(DeidentificationMethodCodeSequence),TagLink(RequestingServiceCodeSequence),TagLink(ProcedureCodeSequence),TagLink(ReasonForPerformedProcedureCodeSequence),TagLink(AdmittingDiagnosesCodeSequence),TagLink(PrincipalDiagnosisCodeSequence),TagLink(PrimaryDiagnosisCodeSequence),TagLink(SecondaryDiagnosesCodeSequence),TagLink(HistologicalDiagnosesCodeSequence),TagLink(PatientSizeCodeSequence),TagLink(ReasonForVisitCodeSequence),TagLink(ClinicalTrialTimePointTypeCodeSequence),TagLink(SeriesDescriptionCodeSequence),TagLink(ContrastBolusAgentSequence),TagLink(ContrastBolusAdministrationRouteSequence),TagLink(AdditionalDrugSequence),TagLink(ContrastBolusIngredientCodeSequence),TagLink(ChannelSourceSequence),TagLink(DeviceSequence),TagLink(InterventionSequence),TagLink(InterventionDrugCodeSequence),TagLink(AdministrationRouteCodeSequence),TagLink(DerivationCodeSequence),TagLink(PatientPhysiologicalStateCodeSequence),TagLink(ContainerTypeCodeSequence),TagLink(ContainerComponentTypeCodeSequence),TagLink(SpecimenTypeCodeSequence),TagLink(CTDIPhantomTypeCodeSequence),TagLink(WaterEquivalentDiameterCalculationMethodCodeSequence),TagLink(RadionuclideCodeSequence),TagLink(RadiopharmaceuticalCodeSequence),TagLink(PixelValueMappingCodeSequence),TagLink(StageCodeSequence),TagLink(DocumentClassCodeSequence),TagLink(TreatmentSiteCodeSequence),TagLink(TreatmentSiteModifierCodeSequence),TagLink(RTProtocolCodeSequence),TagLink(ROIObservationContextCodeSequence),TagLink(SegmentedPropertyCategoryCodeSequence),TagLink(RTROIIdentificationCodeSequence),TagLink(SegmentedPropertyTypeModifierCodeSequence),TagLink(TherapeuticRoleCategoryCodeSequence),TagLink(TherapeuticRoleTypeCodeSequence),TagLink(RTTreatmentTechniqueCodeSequence),TagLink(RTTreatmentTerminationReasonCodeSequence),TagLink(MachineSpecificTreatmentTerminationCodeSequence),TagLink(ProjectionEponymousNameCodeSequence),TagLink(PartialViewCodeSequence),TagLink(ChannelDescriptionCodeSequence),TagLink(IlluminatorTypeCodeSequence),TagLink(IlluminationColorCodeSequence),TagLink(IlluminationTypeCodeSequence),TagLink(LightPathFilterTypeStackCodeSequence),TagLink(ImagePathFilterTypeStackCodeSequence),TagLink(LensesCodeSequence),TagLink(MetaboliteMapCodeSequence),TagLink(MaterialCodeSequence),TagLink(AcquisitionDeviceTypeCodeSequence),TagLink(PatientEyeMovementCommandCodeSequence),TagLink(RelativeImagePositionCodeSequence),TagLink(MydriaticAgentCodeSequence),TagLink(MydriaticAgentConcentrationUnitsSequence),TagLink(ScanPatternTypeCodeSequence),TagLink(TransformationMethodCodeSequence),TagLink(OphthalmicImageTypeCodeSequence),TagLink(SegmentedPropertyTypeCodeSequence),TagLink(EventCodeSequence),TagLink(TransducerScanPatternCodeSequence),TagLink(TransducerGeometryCodeSequence),TagLink(TransducerBeamSteeringCodeSequence),TagLink(TransducerApplicationCodeSequence),TagLink(VisualAcuityTypeCodeSequence),TagLink(OphthalmicUltrasoundMethodCodeSequence),TagLink(AnteriorChamberDepthDefinitionCodeSequence),TagLink(LensStatusCodeSequence),TagLink(VitreousStatusCodeSequence),TagLink(OphthalmicAxialLengthMeasurementsSegmentNameCodeSequence),TagLink(OphthalmicAxialLengthDataSourceCodeSequence),TagLink(OphthalmicAxialLengthSelectionMethodCodeSequence),TagLink(RefractiveSurgeryTypeCodeSequence),TagLink(RefractiveErrorBeforeRefractiveSurgeryCodeSequence),TagLink(SourceOfCornealSizeDataCodeSequence),TagLink(SourceOfLensThicknessDataCodeSequence),TagLink(SourceOfAnteriorChamberDepthDataCodeSequence),TagLink(SourceOfRefractiveMeasurementsCodeSequence),TagLink(SourceOfCorneaMeasurementDataCodeSequence),TagLink(IOLFormulaCodeSequence),TagLink(KeratometryMeasurementTypeCodeSequence),TagLink(SourceOfOphthalmicAxialLengthCodeSequence),TagLink(CorneaMeasurementMethodCodeSequence),TagLink(ScreeningTestModeCodeSequence),TagLink(StimulusColorCodeSequence),TagLink(BackgroundIlluminationColorCodeSequence),TagLink(FixationMonitoringCodeSequence),TagLink(ModeOfPercutaneousAccessSequence),TagLink(AcquisitionMethodCodeSequence),TagLink(OphthalmicThicknessMapTypeCodeSequence),TagLink(RetinalThicknessDefinitionCodeSequence),TagLink(SurfaceScanAcquisitionTypeCodeSequence),TagLink(SurfaceScanModeCodeSequence),TagLink(RegistrationMethodCodeSequence),TagLink(CornealTopographyMapTypeCodeSequence),TagLink(TrackSetAnatomicalTypeCodeSequence),TagLink(ModifierCodeSequence),TagLink(DiffusionAcquisitionCodeSequence),TagLink(DiffusionModelCodeSequence),TagLink(AcousticCouplingMediumCodeSequence),TagLink(TransducerTechnologySequence),TagLink(SoundSpeedCorrectionMechanismCodeSequence),TagLink(ImageDataTypeCodeSequence),TagLink(ChannelSourceModifiersSequence),TagLink(ChannelSensitivityUnitsSequence),TagLink(AnalogFilterTypeCodeSequence),TagLink(DigitalFilterTypeCodeSequence),TagLink(FrequencyEncodingCodeSequence),TagLink(MagnitudeEncodingCodeSequence),TagLink(MappingResourceIdentificationSequence),TagLink(DigitalSignaturePurposeCodeSequence),TagLink(VerifyingObserverIdentificationCodeSequence),TagLink(ResponsibleGroupCodeSequence),TagLink(PerformedProcedureCodeSequence),TagLink(OrganizationalRoleCodeSequence),TagLink(NumericValueQualifierCodeSequence),TagLink(ContentTemplateSequence),TagLink(RegistrationTypeCodeSequence),TagLink(FiducialsPropertyCategoryCodeSequence),TagLink(FiducialIdentifierCodeSequence),TagLink(AbstractPriorCodeSequence),TagLink(HangingProtocolUserIdentificationCodeSequence),TagLink(ImplantRegulatoryDisapprovalCodeSequence),TagLink(MaterialsCodeSequence),TagLink(CoatingMaterialsCodeSequence),TagLink(ImplantTypeCodeSequence),TagLink(FixationMethodCodeSequence),TagLink(ViewOrientationCodeSequence),TagLink(ViewOrientationModifierCodeSequence),TagLink(PlanningLandmarkIdentificationCodeSequence),TagLink(ProcedureTypeCodeSequence),TagLink(ComponentTypeCodeSequence),TagLink(AssessmentTypeCodeSequence),TagLink(ObservationBasisCodeSequence),TagLink(PotentialScheduledProtocolCodeSequence),TagLink(PotentialRequestedProcedureCodeSequence),TagLink(PotentialReasonsForProcedureCodeSequence),TagLink(ContraindicationsCodeSequence),TagLink(PositioningMethodCodeSequence),TagLink(RequestedSeriesDescriptionCodeSequence),TagLink(ModelUsageCodeSequence),TagLink(DosimetricObjectiveTypeCodeSequence),TagLink(EffectiveDoseCalculationMethodCategoryCodeSequence),TagLink(EffectiveDoseCalculationMethodCodeSequence),TagLink(TreatmentMachineSpecialModeCodeSequence),TagLink(DeliveryRateUnitSequence),TagLink(RadiationGenerationModeMachineCodeSequence),TagLink(RadiationTypeCodeSequence),TagLink(EnergyUnitCodeSequence),TagLink(RadiationFluenceModifierCodeSequence),TagLink(CompensatorShapeFabricationCodeSequence),TagLink(InterlockCodeSequence),TagLink(InterlockResolutionCodeSequence),TagLink(ParallelRTBeamDelimiterDeviceOrientationLabelCodeSequence),TagLink(DisplacementReferenceLocationCodeSequence),TagLink(PatientTreatmentPreparationMethodCodeSequence),TagLink(PatientTreatmentPreparationProcedureCodeSequence),TagLink(EnergyDerivationCodeSequence),TagLink(RadiationDosimeterUnitSequence),TagLink(RTDiagnosisCodeSequence),TagLink(ConceptualVolumeCategoryCodeSequence),TagLink(ConceptualVolumeTypeCodeSequence),TagLink(ConceptualVolumeTypeModifierCodeSequence),TagLink(DeliveryTimeStructureCodeSequence),TagLink(SegmentAnnotationCategoryCodeSequence),TagLink(SegmentAnnotationTypeCodeSequence),TagLink(SegmentAnnotationTypeModifierCodeSequence),TagLink(RTDeviceDistanceReferenceLocationCodeSequence),TagLink(EquipmentReferencePointCodeSequence),TagLink(RoboticPathNodeSetCodeSequence),TagLink(DoseMeasurementDeviceCodeSequence),TagLink(TreatmentToleranceViolationTypeCodeSequence),TagLink(TreatmentToleranceViolationCauseCodeSequence),TagLink(ReasonForOmissionCodeSequence),TagLink(AcquisitionTaskWorkitemCodeSequence),TagLink(SubtaskWorkitemCodeSequence),TagLink(PositionAcquisitionTemplateCodeSequence),TagLink(AnnotationPropertyCategoryCodeSequence),TagLink(AnnotationPropertyTypeCodeSequence),TagLink(AnnotationPropertyTypeModifierCodeSequence),TagLink(ReasonForRemovalCodeSequence),TagLink(AnatomicRegionsInStudyCodeSequence),TagLink(MontageChannelSourceCodeSequence),])
    LongCodeValue = Tag('Long Code Value', "LongCodeValue", 0x0008, 0x0119, [TagLink(EquivalentCodeSequence),TagLink(PersonIdentificationCodeSequence),TagLink(InstitutionCodeSequence),TagLink(InstitutionalDepartmentTypeCodeSequence),TagLink(ConceptNameCodeSequence),TagLink(ConceptCodeSequence),TagLink(MeasurementUnitsCodeSequence),TagLink(AnatomicRegionSequence),TagLink(AnatomicRegionModifierSequence),TagLink(PrimaryAnatomicStructureSequence),TagLink(PrimaryAnatomicStructureModifierSequence),TagLink(RequestedProcedureCodeSequence),TagLink(ReasonForRequestedProcedureCodeSequence),TagLink(ScheduledProtocolCodeSequence),TagLink(LanguageCodeSequence),TagLink(PerformedProtocolCodeSequence),TagLink(PatientOrientationCodeSequence),TagLink(PatientOrientationModifierCodeSequence),TagLink(PatientGantryRelationshipCodeSequence),TagLink(PatientEquipmentRelationshipCodeSequence),TagLink(AssigningJurisdictionCodeSequence),TagLink(AssigningAgencyOrDepartmentCodeSequence),TagLink(AlgorithmFamilyCodeSequence),TagLink(AlgorithmNameCodeSequence),TagLink(ViewCodeSequence),TagLink(ViewModifierCodeSequence),TagLink(DeviceMotionParameterCodeSequence),TagLink(SelectorCodeSequenceValue),TagLink(ReferenceBasisCodeSequence),TagLink(ReferenceGeometryCodeSequence),TagLink(AssertionCodeSequence),TagLink(DeviceTypeCodeSequence),TagLink(PurposeOfReferenceCodeSequence),TagLink(PatientLocationCoordinatesCodeSequence),TagLink(EthnicGroupCodeSequence),TagLink(PatientSpeciesCodeSequence),TagLink(PatientBreedCodeSequence),TagLink(BreedRegistryCodeSequence),TagLink(StrainCodeSequence),TagLink(StrainSourceRegistryCodeSequence),TagLink(GeneticModificationsCodeSequence),TagLink(DeidentificationMethodCodeSequence),TagLink(RequestingServiceCodeSequence),TagLink(ProcedureCodeSequence),TagLink(ReasonForPerformedProcedureCodeSequence),TagLink(AdmittingDiagnosesCodeSequence),TagLink(PrincipalDiagnosisCodeSequence),TagLink(PrimaryDiagnosisCodeSequence),TagLink(SecondaryDiagnosesCodeSequence),TagLink(HistologicalDiagnosesCodeSequence),TagLink(PatientSizeCodeSequence),TagLink(ReasonForVisitCodeSequence),TagLink(ClinicalTrialTimePointTypeCodeSequence),TagLink(SeriesDescriptionCodeSequence),TagLink(ContrastBolusAgentSequence),TagLink(ContrastBolusAdministrationRouteSequence),TagLink(AdditionalDrugSequence),TagLink(ContrastBolusIngredientCodeSequence),TagLink(ChannelSourceSequence),TagLink(DeviceSequence),TagLink(InterventionSequence),TagLink(InterventionDrugCodeSequence),TagLink(AdministrationRouteCodeSequence),TagLink(DerivationCodeSequence),TagLink(PatientPhysiologicalStateCodeSequence),TagLink(ContainerTypeCodeSequence),TagLink(ContainerComponentTypeCodeSequence),TagLink(SpecimenTypeCodeSequence),TagLink(CTDIPhantomTypeCodeSequence),TagLink(WaterEquivalentDiameterCalculationMethodCodeSequence),TagLink(RadionuclideCodeSequence),TagLink(RadiopharmaceuticalCodeSequence),TagLink(PixelValueMappingCodeSequence),TagLink(StageCodeSequence),TagLink(DocumentClassCodeSequence),TagLink(TreatmentSiteCodeSequence),TagLink(TreatmentSiteModifierCodeSequence),TagLink(RTProtocolCodeSequence),TagLink(ROIObservationContextCodeSequence),TagLink(SegmentedPropertyCategoryCodeSequence),TagLink(RTROIIdentificationCodeSequence),TagLink(SegmentedPropertyTypeModifierCodeSequence),TagLink(TherapeuticRoleCategoryCodeSequence),TagLink(TherapeuticRoleTypeCodeSequence),TagLink(RTTreatmentTechniqueCodeSequence),TagLink(RTTreatmentTerminationReasonCodeSequence),TagLink(MachineSpecificTreatmentTerminationCodeSequence),TagLink(ProjectionEponymousNameCodeSequence),TagLink(PartialViewCodeSequence),TagLink(ChannelDescriptionCodeSequence),TagLink(IlluminatorTypeCodeSequence),TagLink(IlluminationColorCodeSequence),TagLink(IlluminationTypeCodeSequence),TagLink(LightPathFilterTypeStackCodeSequence),TagLink(ImagePathFilterTypeStackCodeSequence),TagLink(LensesCodeSequence),TagLink(MetaboliteMapCodeSequence),TagLink(MaterialCodeSequence),TagLink(AcquisitionDeviceTypeCodeSequence),TagLink(PatientEyeMovementCommandCodeSequence),TagLink(RelativeImagePositionCodeSequence),TagLink(MydriaticAgentCodeSequence),TagLink(MydriaticAgentConcentrationUnitsSequence),TagLink(ScanPatternTypeCodeSequence),TagLink(TransformationMethodCodeSequence),TagLink(OphthalmicImageTypeCodeSequence),TagLink(SegmentedPropertyTypeCodeSequence),TagLink(EventCodeSequence),TagLink(TransducerScanPatternCodeSequence),TagLink(TransducerGeometryCodeSequence),TagLink(TransducerBeamSteeringCodeSequence),TagLink(TransducerApplicationCodeSequence),TagLink(VisualAcuityTypeCodeSequence),TagLink(OphthalmicUltrasoundMethodCodeSequence),TagLink(AnteriorChamberDepthDefinitionCodeSequence),TagLink(LensStatusCodeSequence),TagLink(VitreousStatusCodeSequence),TagLink(OphthalmicAxialLengthMeasurementsSegmentNameCodeSequence),TagLink(OphthalmicAxialLengthDataSourceCodeSequence),TagLink(OphthalmicAxialLengthSelectionMethodCodeSequence),TagLink(RefractiveSurgeryTypeCodeSequence),TagLink(RefractiveErrorBeforeRefractiveSurgeryCodeSequence),TagLink(SourceOfCornealSizeDataCodeSequence),TagLink(SourceOfLensThicknessDataCodeSequence),TagLink(SourceOfAnteriorChamberDepthDataCodeSequence),TagLink(SourceOfRefractiveMeasurementsCodeSequence),TagLink(SourceOfCorneaMeasurementDataCodeSequence),TagLink(IOLFormulaCodeSequence),TagLink(KeratometryMeasurementTypeCodeSequence),TagLink(SourceOfOphthalmicAxialLengthCodeSequence),TagLink(CorneaMeasurementMethodCodeSequence),TagLink(ScreeningTestModeCodeSequence),TagLink(StimulusColorCodeSequence),TagLink(BackgroundIlluminationColorCodeSequence),TagLink(FixationMonitoringCodeSequence),TagLink(ModeOfPercutaneousAccessSequence),TagLink(AcquisitionMethodCodeSequence),TagLink(OphthalmicThicknessMapTypeCodeSequence),TagLink(RetinalThicknessDefinitionCodeSequence),TagLink(SurfaceScanAcquisitionTypeCodeSequence),TagLink(SurfaceScanModeCodeSequence),TagLink(RegistrationMethodCodeSequence),TagLink(CornealTopographyMapTypeCodeSequence),TagLink(TrackSetAnatomicalTypeCodeSequence),TagLink(ModifierCodeSequence),TagLink(DiffusionAcquisitionCodeSequence),TagLink(DiffusionModelCodeSequence),TagLink(AcousticCouplingMediumCodeSequence),TagLink(TransducerTechnologySequence),TagLink(SoundSpeedCorrectionMechanismCodeSequence),TagLink(ImageDataTypeCodeSequence),TagLink(ChannelSourceModifiersSequence),TagLink(ChannelSensitivityUnitsSequence),TagLink(AnalogFilterTypeCodeSequence),TagLink(DigitalFilterTypeCodeSequence),TagLink(FrequencyEncodingCodeSequence),TagLink(MagnitudeEncodingCodeSequence),TagLink(DigitalSignaturePurposeCodeSequence),TagLink(VerifyingObserverIdentificationCodeSequence),TagLink(ResponsibleGroupCodeSequence),TagLink(PerformedProcedureCodeSequence),TagLink(OrganizationalRoleCodeSequence),TagLink(NumericValueQualifierCodeSequence),TagLink(RegistrationTypeCodeSequence),TagLink(FiducialsPropertyCategoryCodeSequence),TagLink(FiducialIdentifierCodeSequence),TagLink(AbstractPriorCodeSequence),TagLink(HangingProtocolUserIdentificationCodeSequence),TagLink(ImplantRegulatoryDisapprovalCodeSequence),TagLink(MaterialsCodeSequence),TagLink(CoatingMaterialsCodeSequence),TagLink(ImplantTypeCodeSequence),TagLink(FixationMethodCodeSequence),TagLink(ViewOrientationCodeSequence),TagLink(ViewOrientationModifierCodeSequence),TagLink(PlanningLandmarkIdentificationCodeSequence),TagLink(ProcedureTypeCodeSequence),TagLink(ComponentTypeCodeSequence),TagLink(AssessmentTypeCodeSequence),TagLink(ObservationBasisCodeSequence),TagLink(PotentialScheduledProtocolCodeSequence),TagLink(PotentialRequestedProcedureCodeSequence),TagLink(PotentialReasonsForProcedureCodeSequence),TagLink(ContraindicationsCodeSequence),TagLink(PositioningMethodCodeSequence),TagLink(RequestedSeriesDescriptionCodeSequence),TagLink(ModelUsageCodeSequence),TagLink(DosimetricObjectiveTypeCodeSequence),TagLink(EffectiveDoseCalculationMethodCategoryCodeSequence),TagLink(EffectiveDoseCalculationMethodCodeSequence),TagLink(TreatmentMachineSpecialModeCodeSequence),TagLink(DeliveryRateUnitSequence),TagLink(RadiationGenerationModeMachineCodeSequence),TagLink(RadiationTypeCodeSequence),TagLink(EnergyUnitCodeSequence),TagLink(RadiationFluenceModifierCodeSequence),TagLink(CompensatorShapeFabricationCodeSequence),TagLink(InterlockCodeSequence),TagLink(InterlockResolutionCodeSequence),TagLink(ParallelRTBeamDelimiterDeviceOrientationLabelCodeSequence),TagLink(DisplacementReferenceLocationCodeSequence),TagLink(PatientTreatmentPreparationMethodCodeSequence),TagLink(PatientTreatmentPreparationProcedureCodeSequence),TagLink(EnergyDerivationCodeSequence),TagLink(RadiationDosimeterUnitSequence),TagLink(RTDiagnosisCodeSequence),TagLink(ConceptualVolumeCategoryCodeSequence),TagLink(ConceptualVolumeTypeCodeSequence),TagLink(ConceptualVolumeTypeModifierCodeSequence),TagLink(DeliveryTimeStructureCodeSequence),TagLink(SegmentAnnotationCategoryCodeSequence),TagLink(SegmentAnnotationTypeCodeSequence),TagLink(SegmentAnnotationTypeModifierCodeSequence),TagLink(RTDeviceDistanceReferenceLocationCodeSequence),TagLink(EquipmentReferencePointCodeSequence),TagLink(RoboticPathNodeSetCodeSequence),TagLink(DoseMeasurementDeviceCodeSequence),TagLink(TreatmentToleranceViolationTypeCodeSequence),TagLink(TreatmentToleranceViolationCauseCodeSequence),TagLink(ReasonForOmissionCodeSequence),TagLink(AcquisitionTaskWorkitemCodeSequence),TagLink(SubtaskWorkitemCodeSequence),TagLink(PositionAcquisitionTemplateCodeSequence),TagLink(AnnotationPropertyCategoryCodeSequence),TagLink(AnnotationPropertyTypeCodeSequence),TagLink(AnnotationPropertyTypeModifierCodeSequence),TagLink(ReasonForRemovalCodeSequence),TagLink(AnatomicRegionsInStudyCodeSequence),TagLink(MontageChannelSourceCodeSequence),])
    URNCodeValue = Tag('URN Code Value', "URNCodeValue", 0x0008, 0x0120, [TagLink(EquivalentCodeSequence),TagLink(PersonIdentificationCodeSequence),TagLink(InstitutionCodeSequence),TagLink(InstitutionalDepartmentTypeCodeSequence),TagLink(ConceptNameCodeSequence),TagLink(ConceptCodeSequence),TagLink(MeasurementUnitsCodeSequence),TagLink(AnatomicRegionSequence),TagLink(AnatomicRegionModifierSequence),TagLink(PrimaryAnatomicStructureSequence),TagLink(PrimaryAnatomicStructureModifierSequence),TagLink(RequestedProcedureCodeSequence),TagLink(ReasonForRequestedProcedureCodeSequence),TagLink(ScheduledProtocolCodeSequence),TagLink(LanguageCodeSequence),TagLink(PerformedProtocolCodeSequence),TagLink(PatientOrientationCodeSequence),TagLink(PatientOrientationModifierCodeSequence),TagLink(PatientGantryRelationshipCodeSequence),TagLink(PatientEquipmentRelationshipCodeSequence),TagLink(AssigningJurisdictionCodeSequence),TagLink(AssigningAgencyOrDepartmentCodeSequence),TagLink(AlgorithmFamilyCodeSequence),TagLink(AlgorithmNameCodeSequence),TagLink(ViewCodeSequence),TagLink(ViewModifierCodeSequence),TagLink(DeviceMotionParameterCodeSequence),TagLink(SelectorCodeSequenceValue),TagLink(ReferenceBasisCodeSequence),TagLink(ReferenceGeometryCodeSequence),TagLink(AssertionCodeSequence),TagLink(DeviceTypeCodeSequence),TagLink(PurposeOfReferenceCodeSequence),TagLink(PatientLocationCoordinatesCodeSequence),TagLink(EthnicGroupCodeSequence),TagLink(PatientSpeciesCodeSequence),TagLink(PatientBreedCodeSequence),TagLink(BreedRegistryCodeSequence),TagLink(StrainCodeSequence),TagLink(StrainSourceRegistryCodeSequence),TagLink(GeneticModificationsCodeSequence),TagLink(DeidentificationMethodCodeSequence),TagLink(RequestingServiceCodeSequence),TagLink(ProcedureCodeSequence),TagLink(ReasonForPerformedProcedureCodeSequence),TagLink(AdmittingDiagnosesCodeSequence),TagLink(PrincipalDiagnosisCodeSequence),TagLink(PrimaryDiagnosisCodeSequence),TagLink(SecondaryDiagnosesCodeSequence),TagLink(HistologicalDiagnosesCodeSequence),TagLink(PatientSizeCodeSequence),TagLink(ReasonForVisitCodeSequence),TagLink(ClinicalTrialTimePointTypeCodeSequence),TagLink(SeriesDescriptionCodeSequence),TagLink(ContrastBolusAgentSequence),TagLink(ContrastBolusAdministrationRouteSequence),TagLink(AdditionalDrugSequence),TagLink(ContrastBolusIngredientCodeSequence),TagLink(ChannelSourceSequence),TagLink(DeviceSequence),TagLink(InterventionSequence),TagLink(InterventionDrugCodeSequence),TagLink(AdministrationRouteCodeSequence),TagLink(DerivationCodeSequence),TagLink(PatientPhysiologicalStateCodeSequence),TagLink(ContainerTypeCodeSequence),TagLink(ContainerComponentTypeCodeSequence),TagLink(SpecimenTypeCodeSequence),TagLink(CTDIPhantomTypeCodeSequence),TagLink(WaterEquivalentDiameterCalculationMethodCodeSequence),TagLink(RadionuclideCodeSequence),TagLink(RadiopharmaceuticalCodeSequence),TagLink(PixelValueMappingCodeSequence),TagLink(StageCodeSequence),TagLink(DocumentClassCodeSequence),TagLink(TreatmentSiteCodeSequence),TagLink(TreatmentSiteModifierCodeSequence),TagLink(RTProtocolCodeSequence),TagLink(ROIObservationContextCodeSequence),TagLink(SegmentedPropertyCategoryCodeSequence),TagLink(RTROIIdentificationCodeSequence),TagLink(SegmentedPropertyTypeModifierCodeSequence),TagLink(TherapeuticRoleCategoryCodeSequence),TagLink(TherapeuticRoleTypeCodeSequence),TagLink(RTTreatmentTechniqueCodeSequence),TagLink(RTTreatmentTerminationReasonCodeSequence),TagLink(MachineSpecificTreatmentTerminationCodeSequence),TagLink(ProjectionEponymousNameCodeSequence),TagLink(PartialViewCodeSequence),TagLink(ChannelDescriptionCodeSequence),TagLink(IlluminatorTypeCodeSequence),TagLink(IlluminationColorCodeSequence),TagLink(IlluminationTypeCodeSequence),TagLink(LightPathFilterTypeStackCodeSequence),TagLink(ImagePathFilterTypeStackCodeSequence),TagLink(LensesCodeSequence),TagLink(MetaboliteMapCodeSequence),TagLink(MaterialCodeSequence),TagLink(AcquisitionDeviceTypeCodeSequence),TagLink(PatientEyeMovementCommandCodeSequence),TagLink(RelativeImagePositionCodeSequence),TagLink(MydriaticAgentCodeSequence),TagLink(MydriaticAgentConcentrationUnitsSequence),TagLink(ScanPatternTypeCodeSequence),TagLink(TransformationMethodCodeSequence),TagLink(OphthalmicImageTypeCodeSequence),TagLink(SegmentedPropertyTypeCodeSequence),TagLink(EventCodeSequence),TagLink(TransducerScanPatternCodeSequence),TagLink(TransducerGeometryCodeSequence),TagLink(TransducerBeamSteeringCodeSequence),TagLink(TransducerApplicationCodeSequence),TagLink(VisualAcuityTypeCodeSequence),TagLink(OphthalmicUltrasoundMethodCodeSequence),TagLink(AnteriorChamberDepthDefinitionCodeSequence),TagLink(LensStatusCodeSequence),TagLink(VitreousStatusCodeSequence),TagLink(OphthalmicAxialLengthMeasurementsSegmentNameCodeSequence),TagLink(OphthalmicAxialLengthDataSourceCodeSequence),TagLink(OphthalmicAxialLengthSelectionMethodCodeSequence),TagLink(RefractiveSurgeryTypeCodeSequence),TagLink(RefractiveErrorBeforeRefractiveSurgeryCodeSequence),TagLink(SourceOfCornealSizeDataCodeSequence),TagLink(SourceOfLensThicknessDataCodeSequence),TagLink(SourceOfAnteriorChamberDepthDataCodeSequence),TagLink(SourceOfRefractiveMeasurementsCodeSequence),TagLink(SourceOfCorneaMeasurementDataCodeSequence),TagLink(IOLFormulaCodeSequence),TagLink(KeratometryMeasurementTypeCodeSequence),TagLink(SourceOfOphthalmicAxialLengthCodeSequence),TagLink(CorneaMeasurementMethodCodeSequence),TagLink(ScreeningTestModeCodeSequence),TagLink(StimulusColorCodeSequence),TagLink(BackgroundIlluminationColorCodeSequence),TagLink(FixationMonitoringCodeSequence),TagLink(ModeOfPercutaneousAccessSequence),TagLink(AcquisitionMethodCodeSequence),TagLink(OphthalmicThicknessMapTypeCodeSequence),TagLink(RetinalThicknessDefinitionCodeSequence),TagLink(SurfaceScanAcquisitionTypeCodeSequence),TagLink(SurfaceScanModeCodeSequence),TagLink(RegistrationMethodCodeSequence),TagLink(CornealTopographyMapTypeCodeSequence),TagLink(TrackSetAnatomicalTypeCodeSequence),TagLink(ModifierCodeSequence),TagLink(DiffusionAcquisitionCodeSequence),TagLink(DiffusionModelCodeSequence),TagLink(AcousticCouplingMediumCodeSequence),TagLink(TransducerTechnologySequence),TagLink(SoundSpeedCorrectionMechanismCodeSequence),TagLink(ImageDataTypeCodeSequence),TagLink(ChannelSourceModifiersSequence),TagLink(ChannelSensitivityUnitsSequence),TagLink(AnalogFilterTypeCodeSequence),TagLink(DigitalFilterTypeCodeSequence),TagLink(FrequencyEncodingCodeSequence),TagLink(MagnitudeEncodingCodeSequence),TagLink(DigitalSignaturePurposeCodeSequence),TagLink(VerifyingObserverIdentificationCodeSequence),TagLink(ResponsibleGroupCodeSequence),TagLink(PerformedProcedureCodeSequence),TagLink(OrganizationalRoleCodeSequence),TagLink(NumericValueQualifierCodeSequence),TagLink(RegistrationTypeCodeSequence),TagLink(FiducialsPropertyCategoryCodeSequence),TagLink(FiducialIdentifierCodeSequence),TagLink(AbstractPriorCodeSequence),TagLink(HangingProtocolUserIdentificationCodeSequence),TagLink(ImplantRegulatoryDisapprovalCodeSequence),TagLink(MaterialsCodeSequence),TagLink(CoatingMaterialsCodeSequence),TagLink(ImplantTypeCodeSequence),TagLink(FixationMethodCodeSequence),TagLink(ViewOrientationCodeSequence),TagLink(ViewOrientationModifierCodeSequence),TagLink(PlanningLandmarkIdentificationCodeSequence),TagLink(ProcedureTypeCodeSequence),TagLink(ComponentTypeCodeSequence),TagLink(AssessmentTypeCodeSequence),TagLink(ObservationBasisCodeSequence),TagLink(PotentialScheduledProtocolCodeSequence),TagLink(PotentialRequestedProcedureCodeSequence),TagLink(PotentialReasonsForProcedureCodeSequence),TagLink(ContraindicationsCodeSequence),TagLink(PositioningMethodCodeSequence),TagLink(RequestedSeriesDescriptionCodeSequence),TagLink(ModelUsageCodeSequence),TagLink(DosimetricObjectiveTypeCodeSequence),TagLink(EffectiveDoseCalculationMethodCategoryCodeSequence),TagLink(EffectiveDoseCalculationMethodCodeSequence),TagLink(TreatmentMachineSpecialModeCodeSequence),TagLink(DeliveryRateUnitSequence),TagLink(RadiationGenerationModeMachineCodeSequence),TagLink(RadiationTypeCodeSequence),TagLink(EnergyUnitCodeSequence),TagLink(RadiationFluenceModifierCodeSequence),TagLink(CompensatorShapeFabricationCodeSequence),TagLink(InterlockCodeSequence),TagLink(InterlockResolutionCodeSequence),TagLink(ParallelRTBeamDelimiterDeviceOrientationLabelCodeSequence),TagLink(DisplacementReferenceLocationCodeSequence),TagLink(PatientTreatmentPreparationMethodCodeSequence),TagLink(PatientTreatmentPreparationProcedureCodeSequence),TagLink(EnergyDerivationCodeSequence),TagLink(RadiationDosimeterUnitSequence),TagLink(RTDiagnosisCodeSequence),TagLink(ConceptualVolumeCategoryCodeSequence),TagLink(ConceptualVolumeTypeCodeSequence),TagLink(ConceptualVolumeTypeModifierCodeSequence),TagLink(DeliveryTimeStructureCodeSequence),TagLink(SegmentAnnotationCategoryCodeSequence),TagLink(SegmentAnnotationTypeCodeSequence),TagLink(SegmentAnnotationTypeModifierCodeSequence),TagLink(RTDeviceDistanceReferenceLocationCodeSequence),TagLink(EquipmentReferencePointCodeSequence),TagLink(RoboticPathNodeSetCodeSequence),TagLink(DoseMeasurementDeviceCodeSequence),TagLink(TreatmentToleranceViolationTypeCodeSequence),TagLink(TreatmentToleranceViolationCauseCodeSequence),TagLink(ReasonForOmissionCodeSequence),TagLink(AcquisitionTaskWorkitemCodeSequence),TagLink(SubtaskWorkitemCodeSequence),TagLink(PositionAcquisitionTemplateCodeSequence),TagLink(AnnotationPropertyCategoryCodeSequence),TagLink(AnnotationPropertyTypeCodeSequence),TagLink(AnnotationPropertyTypeModifierCodeSequence),TagLink(ReasonForRemovalCodeSequence),TagLink(AnatomicRegionsInStudyCodeSequence),TagLink(MontageChannelSourceCodeSequence),])
    MappingResourceName = Tag('Mapping Resource Name', "MappingResourceName", 0x0008, 0x0122, [TagLink(EquivalentCodeSequence),TagLink(PersonIdentificationCodeSequence),TagLink(InstitutionCodeSequence),TagLink(InstitutionalDepartmentTypeCodeSequence),TagLink(ConceptNameCodeSequence),TagLink(ConceptCodeSequence),TagLink(MeasurementUnitsCodeSequence),TagLink(AnatomicRegionSequence),TagLink(AnatomicRegionModifierSequence),TagLink(PrimaryAnatomicStructureSequence),TagLink(PrimaryAnatomicStructureModifierSequence),TagLink(RequestedProcedureCodeSequence),TagLink(ReasonForRequestedProcedureCodeSequence),TagLink(ScheduledProtocolCodeSequence),TagLink(LanguageCodeSequence),TagLink(PerformedProtocolCodeSequence),TagLink(PatientOrientationCodeSequence),TagLink(PatientOrientationModifierCodeSequence),TagLink(PatientGantryRelationshipCodeSequence),TagLink(PatientEquipmentRelationshipCodeSequence),TagLink(AssigningJurisdictionCodeSequence),TagLink(AssigningAgencyOrDepartmentCodeSequence),TagLink(AlgorithmFamilyCodeSequence),TagLink(AlgorithmNameCodeSequence),TagLink(ViewCodeSequence),TagLink(ViewModifierCodeSequence),TagLink(DeviceMotionParameterCodeSequence),TagLink(SelectorCodeSequenceValue),TagLink(ReferenceBasisCodeSequence),TagLink(ReferenceGeometryCodeSequence),TagLink(AssertionCodeSequence),TagLink(DeviceTypeCodeSequence),TagLink(PurposeOfReferenceCodeSequence),TagLink(PatientLocationCoordinatesCodeSequence),TagLink(EthnicGroupCodeSequence),TagLink(PatientSpeciesCodeSequence),TagLink(PatientBreedCodeSequence),TagLink(BreedRegistryCodeSequence),TagLink(StrainCodeSequence),TagLink(StrainSourceRegistryCodeSequence),TagLink(GeneticModificationsCodeSequence),TagLink(DeidentificationMethodCodeSequence),TagLink(RequestingServiceCodeSequence),TagLink(ProcedureCodeSequence),TagLink(ReasonForPerformedProcedureCodeSequence),TagLink(AdmittingDiagnosesCodeSequence),TagLink(PrincipalDiagnosisCodeSequence),TagLink(PrimaryDiagnosisCodeSequence),TagLink(SecondaryDiagnosesCodeSequence),TagLink(HistologicalDiagnosesCodeSequence),TagLink(PatientSizeCodeSequence),TagLink(ReasonForVisitCodeSequence),TagLink(ClinicalTrialTimePointTypeCodeSequence),TagLink(SeriesDescriptionCodeSequence),TagLink(ContrastBolusAgentSequence),TagLink(ContrastBolusAdministrationRouteSequence),TagLink(AdditionalDrugSequence),TagLink(ContrastBolusIngredientCodeSequence),TagLink(ChannelSourceSequence),TagLink(DeviceSequence),TagLink(InterventionSequence),TagLink(InterventionDrugCodeSequence),TagLink(AdministrationRouteCodeSequence),TagLink(DerivationCodeSequence),TagLink(PatientPhysiologicalStateCodeSequence),TagLink(ContainerTypeCodeSequence),TagLink(ContainerComponentTypeCodeSequence),TagLink(SpecimenTypeCodeSequence),TagLink(CTDIPhantomTypeCodeSequence),TagLink(WaterEquivalentDiameterCalculationMethodCodeSequence),TagLink(RadionuclideCodeSequence),TagLink(RadiopharmaceuticalCodeSequence),TagLink(PixelValueMappingCodeSequence),TagLink(StageCodeSequence),TagLink(DocumentClassCodeSequence),TagLink(TreatmentSiteCodeSequence),TagLink(TreatmentSiteModifierCodeSequence),TagLink(RTProtocolCodeSequence),TagLink(ROIObservationContextCodeSequence),TagLink(SegmentedPropertyCategoryCodeSequence),TagLink(RTROIIdentificationCodeSequence),TagLink(SegmentedPropertyTypeModifierCodeSequence),TagLink(TherapeuticRoleCategoryCodeSequence),TagLink(TherapeuticRoleTypeCodeSequence),TagLink(RTTreatmentTechniqueCodeSequence),TagLink(RTTreatmentTerminationReasonCodeSequence),TagLink(MachineSpecificTreatmentTerminationCodeSequence),TagLink(ProjectionEponymousNameCodeSequence),TagLink(PartialViewCodeSequence),TagLink(ChannelDescriptionCodeSequence),TagLink(IlluminatorTypeCodeSequence),TagLink(IlluminationColorCodeSequence),TagLink(IlluminationTypeCodeSequence),TagLink(LightPathFilterTypeStackCodeSequence),TagLink(ImagePathFilterTypeStackCodeSequence),TagLink(LensesCodeSequence),TagLink(MetaboliteMapCodeSequence),TagLink(MaterialCodeSequence),TagLink(AcquisitionDeviceTypeCodeSequence),TagLink(PatientEyeMovementCommandCodeSequence),TagLink(RelativeImagePositionCodeSequence),TagLink(MydriaticAgentCodeSequence),TagLink(MydriaticAgentConcentrationUnitsSequence),TagLink(ScanPatternTypeCodeSequence),TagLink(TransformationMethodCodeSequence),TagLink(OphthalmicImageTypeCodeSequence),TagLink(SegmentedPropertyTypeCodeSequence),TagLink(EventCodeSequence),TagLink(TransducerScanPatternCodeSequence),TagLink(TransducerGeometryCodeSequence),TagLink(TransducerBeamSteeringCodeSequence),TagLink(TransducerApplicationCodeSequence),TagLink(VisualAcuityTypeCodeSequence),TagLink(OphthalmicUltrasoundMethodCodeSequence),TagLink(AnteriorChamberDepthDefinitionCodeSequence),TagLink(LensStatusCodeSequence),TagLink(VitreousStatusCodeSequence),TagLink(OphthalmicAxialLengthMeasurementsSegmentNameCodeSequence),TagLink(OphthalmicAxialLengthDataSourceCodeSequence),TagLink(OphthalmicAxialLengthSelectionMethodCodeSequence),TagLink(RefractiveSurgeryTypeCodeSequence),TagLink(RefractiveErrorBeforeRefractiveSurgeryCodeSequence),TagLink(SourceOfCornealSizeDataCodeSequence),TagLink(SourceOfLensThicknessDataCodeSequence),TagLink(SourceOfAnteriorChamberDepthDataCodeSequence),TagLink(SourceOfRefractiveMeasurementsCodeSequence),TagLink(SourceOfCorneaMeasurementDataCodeSequence),TagLink(IOLFormulaCodeSequence),TagLink(KeratometryMeasurementTypeCodeSequence),TagLink(SourceOfOphthalmicAxialLengthCodeSequence),TagLink(CorneaMeasurementMethodCodeSequence),TagLink(ScreeningTestModeCodeSequence),TagLink(StimulusColorCodeSequence),TagLink(BackgroundIlluminationColorCodeSequence),TagLink(FixationMonitoringCodeSequence),TagLink(ModeOfPercutaneousAccessSequence),TagLink(AcquisitionMethodCodeSequence),TagLink(OphthalmicThicknessMapTypeCodeSequence),TagLink(RetinalThicknessDefinitionCodeSequence),TagLink(SurfaceScanAcquisitionTypeCodeSequence),TagLink(SurfaceScanModeCodeSequence),TagLink(RegistrationMethodCodeSequence),TagLink(CornealTopographyMapTypeCodeSequence),TagLink(TrackSetAnatomicalTypeCodeSequence),TagLink(ModifierCodeSequence),TagLink(DiffusionAcquisitionCodeSequence),TagLink(DiffusionModelCodeSequence),TagLink(AcousticCouplingMediumCodeSequence),TagLink(TransducerTechnologySequence),TagLink(SoundSpeedCorrectionMechanismCodeSequence),TagLink(ImageDataTypeCodeSequence),TagLink(ChannelSourceModifiersSequence),TagLink(ChannelSensitivityUnitsSequence),TagLink(AnalogFilterTypeCodeSequence),TagLink(DigitalFilterTypeCodeSequence),TagLink(FrequencyEncodingCodeSequence),TagLink(MagnitudeEncodingCodeSequence),TagLink(MappingResourceIdentificationSequence),TagLink(DigitalSignaturePurposeCodeSequence),TagLink(VerifyingObserverIdentificationCodeSequence),TagLink(ResponsibleGroupCodeSequence),TagLink(PerformedProcedureCodeSequence),TagLink(OrganizationalRoleCodeSequence),TagLink(NumericValueQualifierCodeSequence),TagLink(RegistrationTypeCodeSequence),TagLink(FiducialsPropertyCategoryCodeSequence),TagLink(FiducialIdentifierCodeSequence),TagLink(AbstractPriorCodeSequence),TagLink(HangingProtocolUserIdentificationCodeSequence),TagLink(ImplantRegulatoryDisapprovalCodeSequence),TagLink(MaterialsCodeSequence),TagLink(CoatingMaterialsCodeSequence),TagLink(ImplantTypeCodeSequence),TagLink(FixationMethodCodeSequence),TagLink(ViewOrientationCodeSequence),TagLink(ViewOrientationModifierCodeSequence),TagLink(PlanningLandmarkIdentificationCodeSequence),TagLink(ProcedureTypeCodeSequence),TagLink(ComponentTypeCodeSequence),TagLink(AssessmentTypeCodeSequence),TagLink(ObservationBasisCodeSequence),TagLink(PotentialScheduledProtocolCodeSequence),TagLink(PotentialRequestedProcedureCodeSequence),TagLink(PotentialReasonsForProcedureCodeSequence),TagLink(ContraindicationsCodeSequence),TagLink(PositioningMethodCodeSequence),TagLink(RequestedSeriesDescriptionCodeSequence),TagLink(ModelUsageCodeSequence),TagLink(DosimetricObjectiveTypeCodeSequence),TagLink(EffectiveDoseCalculationMethodCategoryCodeSequence),TagLink(EffectiveDoseCalculationMethodCodeSequence),TagLink(TreatmentMachineSpecialModeCodeSequence),TagLink(DeliveryRateUnitSequence),TagLink(RadiationGenerationModeMachineCodeSequence),TagLink(RadiationTypeCodeSequence),TagLink(EnergyUnitCodeSequence),TagLink(RadiationFluenceModifierCodeSequence),TagLink(CompensatorShapeFabricationCodeSequence),TagLink(InterlockCodeSequence),TagLink(InterlockResolutionCodeSequence),TagLink(ParallelRTBeamDelimiterDeviceOrientationLabelCodeSequence),TagLink(DisplacementReferenceLocationCodeSequence),TagLink(PatientTreatmentPreparationMethodCodeSequence),TagLink(PatientTreatmentPreparationProcedureCodeSequence),TagLink(EnergyDerivationCodeSequence),TagLink(RadiationDosimeterUnitSequence),TagLink(RTDiagnosisCodeSequence),TagLink(ConceptualVolumeCategoryCodeSequence),TagLink(ConceptualVolumeTypeCodeSequence),TagLink(ConceptualVolumeTypeModifierCodeSequence),TagLink(DeliveryTimeStructureCodeSequence),TagLink(SegmentAnnotationCategoryCodeSequence),TagLink(SegmentAnnotationTypeCodeSequence),TagLink(SegmentAnnotationTypeModifierCodeSequence),TagLink(RTDeviceDistanceReferenceLocationCodeSequence),TagLink(EquipmentReferencePointCodeSequence),TagLink(RoboticPathNodeSetCodeSequence),TagLink(DoseMeasurementDeviceCodeSequence),TagLink(TreatmentToleranceViolationTypeCodeSequence),TagLink(TreatmentToleranceViolationCauseCodeSequence),TagLink(ReasonForOmissionCodeSequence),TagLink(AcquisitionTaskWorkitemCodeSequence),TagLink(SubtaskWorkitemCodeSequence),TagLink(PositionAcquisitionTemplateCodeSequence),TagLink(AnnotationPropertyCategoryCodeSequence),TagLink(AnnotationPropertyTypeCodeSequence),TagLink(AnnotationPropertyTypeModifierCodeSequence),TagLink(ReasonForRemovalCodeSequence),TagLink(AnatomicRegionsInStudyCodeSequence),TagLink(MontageChannelSourceCodeSequence),])
    TimezoneOffsetFromUTC = Tag('Timezone Offset From UTC', "TimezoneOffsetFromUTC", 0x0008, 0x0201, [TagLink(InventoriedInstancesSequence),TagLink(ScopeOfInventorySequence),])
    EquipmentModality = Tag('Equipment Modality', "EquipmentModality", 0x0008, 0x0221)
    ManufacturerRelatedModelGroup = Tag("Manufacturer's Related Model Group", "ManufacturerRelatedModelGroup", 0x0008, 0x0222, [TagLink(ModelSpecificationSequence),])
    PrivateDataElementCharacteristicsSequence = Tag('Private Data Element Characteristics Sequence', "PrivateDataElementCharacteristicsSequence", 0x0008, 0x0300)
    PrivateGroupReference = Tag('Private Group Reference', "PrivateGroupReference", 0x0008, 0x0301, [TagLink(PrivateDataElementCharacteristicsSequence),])
    PrivateCreatorReference = Tag('Private Creator Reference', "PrivateCreatorReference", 0x0008, 0x0302, [TagLink(PrivateDataElementCharacteristicsSequence),])
    BlockIdentifyingInformationStatus = Tag('Block Identifying Information Status', "BlockIdentifyingInformationStatus", 0x0008, 0x0303, [TagLink(PrivateDataElementCharacteristicsSequence),])
    NonidentifyingPrivateElements = Tag('Nonidentifying Private Elements', "NonidentifyingPrivateElements", 0x0008, 0x0304, [TagLink(PrivateDataElementCharacteristicsSequence),])
    DeidentificationActionSequence = Tag('Deidentification Action Sequence', "DeidentificationActionSequence", 0x0008, 0x0305, [TagLink(PrivateDataElementCharacteristicsSequence),])
    IdentifyingPrivateElements = Tag('Identifying Private Elements', "IdentifyingPrivateElements", 0x0008, 0x0306, [TagLink(DeidentificationActionSequence),])
    DeidentificationAction = Tag('Deidentification Action', "DeidentificationAction", 0x0008, 0x0307, [TagLink(DeidentificationActionSequence),])
    PrivateDataElementDefinitionSequence = Tag('Private Data Element Definition Sequence', "PrivateDataElementDefinitionSequence", 0x0008, 0x0310, [TagLink(PrivateDataElementCharacteristicsSequence),])
    PrivateDataElement = Tag('Private Data Element', "PrivateDataElement", 0x0008, 0x0308, [TagLink(PrivateDataElementDefinitionSequence),])
    PrivateDataElementValueMultiplicity = Tag('Private Data Element Value Multiplicity', "PrivateDataElementValueMultiplicity", 0x0008, 0x0309, [TagLink(PrivateDataElementDefinitionSequence),])
    PrivateDataElementValueRepresentation = Tag('Private Data Element Value Representation', "PrivateDataElementValueRepresentation", 0x0008, 0x030A, [TagLink(PrivateDataElementDefinitionSequence),])
    PrivateDataElementNumberOfItems = Tag('Private Data Element Number of Items', "PrivateDataElementNumberOfItems", 0x0008, 0x030B, [TagLink(PrivateDataElementDefinitionSequence),])
    PrivateDataElementName = Tag('Private Data Element Name', "PrivateDataElementName", 0x0008, 0x030C, [TagLink(PrivateDataElementDefinitionSequence),])
    PrivateDataElementKeyword = Tag('Private Data Element Keyword', "PrivateDataElementKeyword", 0x0008, 0x030D, [TagLink(PrivateDataElementDefinitionSequence),])
    PrivateDataElementDescription = Tag('Private Data Element Description', "PrivateDataElementDescription", 0x0008, 0x030E, [TagLink(PrivateDataElementDefinitionSequence),])
    PrivateDataElementEncoding = Tag('Private Data Element Encoding', "PrivateDataElementEncoding", 0x0008, 0x030F, [TagLink(PrivateDataElementDefinitionSequence),])
    InventoryPurpose = Tag('Inventory Purpose', "InventoryPurpose", 0x0008, 0x0401)
    InventoryInstanceDescription = Tag('Inventory Instance Description', "InventoryInstanceDescription", 0x0008, 0x0402)
    InventoryLevel = Tag('Inventory Level', "InventoryLevel", 0x0008, 0x0403)
    ItemInventoryDateTime = Tag('Item Inventory DateTime', "ItemInventoryDateTime", 0x0008, 0x0404, [TagLink(InventoriedStudiesSequence),])
    RemovedFromOperationalUse = Tag('Removed from Operational Use', "RemovedFromOperationalUse", 0x0008, 0x0405, [TagLink(InventoriedStudiesSequence),TagLink(InventoriedSeriesSequence),TagLink(InventoriedInstancesSequence),])
    StoredInstanceBaseURI = Tag('Stored Instance Base URI', "StoredInstanceBaseURI", 0x0008, 0x0407, [TagLink(InventoriedStudiesSequence),TagLink(InventoriedSeriesSequence),])
    FileSetAccessSequence = Tag('File Set Access Sequence', "FileSetAccessSequence", 0x0008, 0x0419, [TagLink(InventoriedStudiesSequence),TagLink(InventoriedSeriesSequence),])
    FolderAccessURI = Tag('Folder Access URI', "FolderAccessURI", 0x0008, 0x0408, [TagLink(FileSetAccessSequence),])
    IncorporatedInventoryInstanceSequence = Tag('Incorporated Inventory Instance Sequence', "IncorporatedInventoryInstanceSequence", 0x0008, 0x0422)
    FileAccessURI = Tag('File Access URI', "FileAccessURI", 0x0008, 0x0409, [TagLink(FileSetAccessSequence),TagLink(IncorporatedInventoryInstanceSequence),])
    ContainerFileType = Tag('Container File Type', "ContainerFileType", 0x0008, 0x040A, [TagLink(FileSetAccessSequence),TagLink(IncorporatedInventoryInstanceSequence),])
    FilenameInContainer = Tag('Filename in Container', "FilenameInContainer", 0x0008, 0x040B, [TagLink(IncorporatedInventoryInstanceSequence),])
    FileOffsetInContainer = Tag('File Offset in Container', "FileOffsetInContainer", 0x0008, 0x040C, [TagLink(IncorporatedInventoryInstanceSequence),])
    FileLengthInContainer = Tag('File Length in Container', "FileLengthInContainer", 0x0008, 0x040D, [TagLink(IncorporatedInventoryInstanceSequence),])
    StoredInstanceTransferSyntaxUID = Tag('Stored Instance Transfer Syntax UID', "StoredInstanceTransferSyntaxUID", 0x0008, 0x040E, [TagLink(IncorporatedInventoryInstanceSequence),])
    ExtendedMatchingMechanisms = Tag('Extended Matching Mechanisms', "ExtendedMatchingMechanisms", 0x0008, 0x040F, [TagLink(ScopeOfInventorySequence),])
    RangeMatchingSequence = Tag('Range Matching Sequence', "RangeMatchingSequence", 0x0008, 0x0410, [TagLink(ScopeOfInventorySequence),])
    ListOfUIDMatchingSequence = Tag('List of UID Matching Sequence', "ListOfUIDMatchingSequence", 0x0008, 0x0411, [TagLink(ScopeOfInventorySequence),])
    EmptyValueMatchingSequence = Tag('Empty Value Matching Sequence', "EmptyValueMatchingSequence", 0x0008, 0x0412, [TagLink(ScopeOfInventorySequence),])
    GeneralMatchingSequence = Tag('General Matching Sequence', "GeneralMatchingSequence", 0x0008, 0x0413, [TagLink(ScopeOfInventorySequence),])
    RequestedStatusInterval = Tag('Requested Status Interval', "RequestedStatusInterval", 0x0008, 0x0414)
    RetainInstances = Tag('Retain Instances', "RetainInstances", 0x0008, 0x0415)
    FileAccessSequence = Tag('File Access Sequence', "FileAccessSequence", 0x0008, 0x041A, [TagLink(InventoriedInstancesSequence),])
    ExpirationDateTime = Tag('Expiration DateTime', "ExpirationDateTime", 0x0008, 0x0416, [TagLink(FileAccessSequence),])
    TransactionStatus = Tag('Transaction Status', "TransactionStatus", 0x0008, 0x0417)
    TransactionStatusComment = Tag('Transaction Status Comment', "TransactionStatusComment", 0x0008, 0x0418)
    RecordKey = Tag('Record Key', "RecordKey", 0x0008, 0x041B)
    PriorRecordKey = Tag('Prior Record Key', "PriorRecordKey", 0x0008, 0x041C)
    MetadataSequence = Tag('Metadata Sequence', "MetadataSequence", 0x0008, 0x041D)
    UpdatedMetadataSequence = Tag('Updated Metadata Sequence', "UpdatedMetadataSequence", 0x0008, 0x041E)
    StudyUpdateDateTime = Tag('Study Update DateTime', "StudyUpdateDateTime", 0x0008, 0x041F, [TagLink(InventoriedStudiesSequence),])
    InventoryAccessEndPointsSequence = Tag('Inventory Access End Points Sequence', "InventoryAccessEndPointsSequence", 0x0008, 0x0420, [TagLink(IncorporatedInventoryInstanceSequence),])
    StudyAccessEndPointsSequence = Tag('Study Access End Points Sequence', "StudyAccessEndPointsSequence", 0x0008, 0x0421)
    InventoryCompletionStatus = Tag('Inventory Completion Status', "InventoryCompletionStatus", 0x0008, 0x0426)
    NumberOfStudyRecordsInInstance = Tag('Number of Study Records in Instance', "NumberOfStudyRecordsInInstance", 0x0008, 0x0427)
    TotalNumberOfStudyRecords = Tag('Total Number of Study Records', "TotalNumberOfStudyRecords", 0x0008, 0x0428)
    MaximumNumberOfRecords = Tag('Maximum Number of Records', "MaximumNumberOfRecords", 0x0008, 0x0429)
    NetworkID = Tag('Network ID', "NetworkID", 0x0008, 0x1000)
    StationName = Tag('Station Name', "StationName", 0x0008, 0x1010, [TagLink(ContributingSourcesSequence),TagLink(ContributingEquipmentSequence),TagLink(AssessmentRequesterSequence),TagLink(AuthorIdentificationSequence),TagLink(OperatorIdentificationSequence),TagLink(AsserterIdentificationSequence),])
    StudyDescription = Tag('Study Description', "StudyDescription", 0x0008, 0x1030, [TagLink(InventoriedStudiesSequence),])
    SeriesDescription = Tag('Series Description', "SeriesDescription", 0x0008, 0x103E, [TagLink(SourceSeriesInformationSequence),TagLink(InventoriedSeriesSequence),])
    InstitutionalDepartmentName = Tag('Institutional Department Name', "InstitutionalDepartmentName", 0x0008, 0x1040, [TagLink(ContentCreatorIdentificationCodeSequence),TagLink(OperatorIdentificationSequence),TagLink(ReferringPhysicianIdentificationSequence),TagLink(ConsultingPhysicianIdentificationSequence),TagLink(PhysiciansOfRecordIdentificationSequence),TagLink(PhysiciansReadingStudyIdentificationSequence),TagLink(PerformingPhysicianIdentificationSequence),TagLink(BeamSequence),TagLink(TreatmentMachineSequence),TagLink(IonBeamSequence),TagLink(ContributingEquipmentSequence),TagLink(AssessmentRequesterSequence),TagLink(InterlockResolutionUserSequence),TagLink(AuthorIdentificationSequence),TagLink(TreatmentDeviceIdentificationSequence),TagLink(AsserterIdentificationSequence),])
    PhysiciansOfRecord = Tag('Physician(s) of Record', "PhysiciansOfRecord", 0x0008, 0x1048, [TagLink(InventoriedStudiesSequence),])
    PerformingPhysicianName = Tag("Performing Physician's Name", "PerformingPhysicianName", 0x0008, 0x1050)
    NameOfPhysiciansReadingStudy = Tag('Name of Physician(s) Reading Study', "NameOfPhysiciansReadingStudy", 0x0008, 0x1060, [TagLink(InventoriedStudiesSequence),])
    OperatorsName = Tag("Operators' Name", "OperatorsName", 0x0008, 0x1070, [TagLink(OverrideSequence),TagLink(ContributingSourcesSequence),TagLink(ContributingEquipmentSequence),])
    AdmittingDiagnosesDescription = Tag('Admitting Diagnoses Description', "AdmittingDiagnosesDescription", 0x0008, 0x1080)
    PyramidDescription = Tag('Pyramid Description', "PyramidDescription", 0x0008, 0x1088)
    ManufacturerModelName = Tag("Manufacturer's Model Name", "ManufacturerModelName", 0x0008, 0x1090, [TagLink(DeviceSequence),TagLink(ContainerComponentSequence),TagLink(BeamSequence),TagLink(TreatmentMachineSequence),TagLink(IonBeamSequence),TagLink(ContributingSourcesSequence),TagLink(ContributingEquipmentSequence),TagLink(AssessmentRequesterSequence),TagLink(ModelSpecificationSequence),TagLink(PatientSupportDevicesSequence),TagLink(WedgeDefinitionSequence),TagLink(CompensatorDefinitionSequence),TagLink(BlockDefinitionSequence),TagLink(RTAccessoryHolderDefinitionSequence),TagLink(GeneralAccessoryDefinitionSequence),TagLink(BolusDefinitionSequence),TagLink(AcquisitionDeviceSequence),TagLink(PatientTreatmentPreparationDeviceSequence),TagLink(AuthorIdentificationSequence),TagLink(SegmentedRTAccessoryDeviceSequence),TagLink(TreatmentDeviceIdentificationSequence),TagLink(OperatorIdentificationSequence),TagLink(AsserterIdentificationSequence),])
    ReferencedResultsSequence = Tag('Referenced Results Sequence', "ReferencedResultsSequence", 0x0008, 0x1100)
    ReferencedPerformedProcedureStepSequence = Tag('Referenced Performed Procedure Step Sequence', "ReferencedPerformedProcedureStepSequence", 0x0008, 0x1111)
    ReferencedInstancesBySOPClassSequence = Tag('Referenced Instances by SOP Class Sequence', "ReferencedInstancesBySOPClassSequence", 0x0008, 0x1112)
    ReferencedPatientSequence = Tag('Referenced Patient Sequence', "ReferencedPatientSequence", 0x0008, 0x1120)
    ReferencedVisitSequence = Tag('Referenced Visit Sequence', "ReferencedVisitSequence", 0x0008, 0x1125)
    ReferencedOverlaySequence = Tag('Referenced Overlay Sequence', "ReferencedOverlaySequence", 0x0008, 0x1130)
    ReferencedStereometricInstanceSequence = Tag('Referenced Stereometric Instance Sequence', "ReferencedStereometricInstanceSequence", 0x0008, 0x1134, [TagLink(StructuredDisplayImageBoxSequence),])
    WaveformTextualAnnotationSequence = Tag('Waveform Textual Annotation Sequence', "WaveformTextualAnnotationSequence", 0x0040, 0xB033)
    DisplayedWaveformSegmentSequence = Tag('Displayed Waveform Segment Sequence', "DisplayedWaveformSegmentSequence", 0x0040, 0xB035)
    ReferencedWaveformSequence = Tag('Referenced Waveform Sequence', "ReferencedWaveformSequence", 0x0008, 0x113A, [TagLink(ReferencedSeriesSequence),TagLink(WaveformTextualAnnotationSequence),TagLink(DisplayedWaveformSegmentSequence),])
    ReferencedCurveSequence = Tag('Referenced Curve Sequence', "ReferencedCurveSequence", 0x0008, 0x1145)
    ReferencedRealWorldValueMappingInstanceSequence = Tag('Referenced Real World Value Mapping Instance Sequence', "ReferencedRealWorldValueMappingInstanceSequence", 0x0008, 0x114B, [TagLink(ReferencedSOPSequence),])
    IonRangeCompensatorSequence = Tag('Ion Range Compensator Sequence', "IonRangeCompensatorSequence", 0x300A, 0x02EA, [TagLink(IonBeamSequence),])
    ReferencedSurfaceSegmentationSequence = Tag('Referenced Surface Segmentation Sequence', "ReferencedSurfaceSegmentationSequence", 0x0008, 0x114D, [TagLink(IonRangeCompensatorSequence),])
    PertinentDocumentsSequence = Tag('Pertinent Documents Sequence', "PertinentDocumentsSequence", 0x0038, 0x0100, [TagLink(ApprovalSequence),TagLink(ConfirmationSequence),])
    ConceptualVolumeConstituentSequence = Tag('Conceptual Volume Constituent Sequence', "ConceptualVolumeConstituentSequence", 0x3010, 0x0008, [TagLink(ConceptualVolumeSequence),TagLink(CombinationSegmentReferenceSequence),])
    OriginatingSOPInstanceReferenceSequence = Tag('Originating SOP Instance Reference Sequence', "OriginatingSOPInstanceReferenceSequence", 0x3010, 0x0007, [TagLink(ConceptualVolumeConstituentSequence),TagLink(ConceptualVolumeIdentificationSequence),TagLink(ConceptualVolumeSequence),TagLink(DosimetricObjectiveSequence),TagLink(DirectSegmentReferenceSequence),TagLink(CombinationSegmentReferenceSequence),])
    EquivalentConceptualVolumesSequence = Tag('Equivalent Conceptual Volumes Sequence', "EquivalentConceptualVolumesSequence", 0x3010, 0x000A, [TagLink(ConceptualVolumeIdentificationSequence),TagLink(ConceptualVolumeSequence),TagLink(DirectSegmentReferenceSequence),TagLink(CombinationSegmentReferenceSequence),])
    EquivalentConceptualVolumeInstanceReferenceSequence = Tag('Equivalent Conceptual Volume Instance Reference Sequence', "EquivalentConceptualVolumeInstanceReferenceSequence", 0x3010, 0x0009, [TagLink(EquivalentConceptualVolumesSequence),])
    SourceConceptualVolumeSequence = Tag('Source Conceptual Volume Sequence', "SourceConceptualVolumeSequence", 0x3010, 0x0018, [TagLink(DerivationConceptualVolumeSequence),])
    ConceptualVolumeConstituentSegmentationReferenceSequence = Tag('Conceptual Volume Constituent Segmentation Reference Sequence', "ConceptualVolumeConstituentSegmentationReferenceSequence", 0x3010, 0x0012, [TagLink(SourceConceptualVolumeSequence),TagLink(ConceptualVolumeConstituentSequence),])
    ConceptualVolumeSegmentationReferenceSequence = Tag('Conceptual Volume Segmentation Reference Sequence', "ConceptualVolumeSegmentationReferenceSequence", 0x3010, 0x0011, [TagLink(ConceptualVolumeSequence),TagLink(CombinationSegmentReferenceSequence),])
    ReferencedDirectSegmentInstanceSequence = Tag('Referenced Direct Segment Instance Sequence', "ReferencedDirectSegmentInstanceSequence", 0x3010, 0x004A, [TagLink(ConceptualVolumeConstituentSegmentationReferenceSequence),TagLink(ConceptualVolumeSegmentationReferenceSequence),])
    ReferencedDefinedProtocolSequence = Tag('Referenced Defined Protocol Sequence', "ReferencedDefinedProtocolSequence", 0x0018, 0x990C, [TagLink(AcquisitionProtocolElementSequence),TagLink(ReconstructionProtocolElementSequence),])
    ReferencedPerformedProtocolSequence = Tag('Referenced Performed Protocol Sequence', "ReferencedPerformedProtocolSequence", 0x0018, 0x990D, [TagLink(AcquisitionProtocolElementSequence),TagLink(ReconstructionProtocolElementSequence),])
    ConversionSourceAttributesSequence = Tag('Conversion Source Attributes Sequence', "ConversionSourceAttributesSequence", 0x0020, 0x9172, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    ReferencedSpatialRegistrationSequence = Tag('Referenced Spatial Registration Sequence', "ReferencedSpatialRegistrationSequence", 0x0070, 0x0404, [TagLink(VolumetricPresentationInputSetSequence),TagLink(AdvancedBlendingSequence),])
    ReferencedStructureSetSequence = Tag('Referenced Structure Set Sequence', "ReferencedStructureSetSequence", 0x300C, 0x0060, [TagLink(PlanOverviewSequence),])
    ReferencedFrameOfReferenceSequence = Tag('Referenced Frame of Reference Sequence', "ReferencedFrameOfReferenceSequence", 0x3006, 0x0010)
    RTReferencedStudySequence = Tag('RT Referenced Study Sequence', "RTReferencedStudySequence", 0x3006, 0x0012, [TagLink(ReferencedFrameOfReferenceSequence),])
    RTReferencedSeriesSequence = Tag('RT Referenced Series Sequence', "RTReferencedSeriesSequence", 0x3006, 0x0014, [TagLink(RTReferencedStudySequence),])
    ROIContourSequence = Tag('ROI Contour Sequence', "ROIContourSequence", 0x3006, 0x0039)
    ContourSequence = Tag('Contour Sequence', "ContourSequence", 0x3006, 0x0040, [TagLink(ROIContourSequence),])
    ContourImageSequence = Tag('Contour Image Sequence', "ContourImageSequence", 0x3006, 0x0016, [TagLink(RTReferencedSeriesSequence),TagLink(ContourSequence),])
    DefinitionSourceSequence = Tag('Definition Source Sequence', "DefinitionSourceSequence", 0x0008, 0x1156, [TagLink(StructureSetROISequence),TagLink(FractionGroupSequence),TagLink(BeamSequence),TagLink(TreatmentSessionBeamSequence),TagLink(SegmentSequence),TagLink(FiducialSequence),])
    PredecessorStructureSetSequence = Tag('Predecessor Structure Set Sequence', "PredecessorStructureSetSequence", 0x3006, 0x0018)
    ControlPointSequence = Tag('Control Point Sequence', "ControlPointSequence", 0x300A, 0x0111, [TagLink(BeamSequence),])
    ReferencedDoseSequence = Tag('Referenced Dose Sequence', "ReferencedDoseSequence", 0x300C, 0x0080, [TagLink(FractionGroupSequence),TagLink(BeamSequence),TagLink(ControlPointSequence),TagLink(IonBeamSequence),])
    ReferencedSetupImageSequence = Tag('Referenced Setup Image Sequence', "ReferencedSetupImageSequence", 0x300A, 0x0401, [TagLink(PatientSetupSequence),])
    ApplicationSetupSequence = Tag('Application Setup Sequence', "ApplicationSetupSequence", 0x300A, 0x0230)
    ReferencedReferenceImageSequence = Tag('Referenced Reference Image Sequence', "ReferencedReferenceImageSequence", 0x300C, 0x0042, [TagLink(BeamSequence),TagLink(ApplicationSetupSequence),TagLink(IonBeamSequence),])
    ReferencedVerificationImageSequence = Tag('Referenced Verification Image Sequence', "ReferencedVerificationImageSequence", 0x300C, 0x0040, [TagLink(TreatmentSessionBeamSequence),TagLink(TreatmentSessionApplicationSetupSequence),TagLink(TreatmentSessionIonBeamSequence),])
    DeliveryVerificationImageSequence = Tag('Delivery Verification Image Sequence', "DeliveryVerificationImageSequence", 0x0074, 0x1030, [TagLink(BeamTaskSequence),])
    RelatedReferenceRTImageSequence = Tag('Related Reference RT Image Sequence', "RelatedReferenceRTImageSequence", 0x0074, 0x1040, [TagLink(DeliveryVerificationImageSequence),])
    StereoPairsSequence = Tag('Stereo Pairs Sequence', "StereoPairsSequence", 0x0022, 0x0020)
    LeftImageSequence = Tag('Left Image Sequence', "LeftImageSequence", 0x0022, 0x0021, [TagLink(StereoPairsSequence),])
    RightImageSequence = Tag('Right Image Sequence', "RightImageSequence", 0x0022, 0x0022, [TagLink(StereoPairsSequence),])
    ReferencedOtherPlaneSequence = Tag('Referenced Other Plane Sequence', "ReferencedOtherPlaneSequence", 0x0008, 0x9410)
    SegmentSurfaceSourceInstanceSequence = Tag('Segment Surface Source Instance Sequence', "SegmentSurfaceSourceInstanceSequence", 0x0066, 0x002E, [TagLink(ReferencedSurfaceSequence),])
    ReferencedRefractiveMeasurementsSequence = Tag('Referenced Refractive Measurements Sequence', "ReferencedRefractiveMeasurementsSequence", 0x0046, 0x0145)
    ReferencedSurfaceDataSequence = Tag('Referenced Surface Data Sequence', "ReferencedSurfaceDataSequence", 0x0080, 0x0013)
    SourceWaveformSequence = Tag('Source Waveform Sequence', "SourceWaveformSequence", 0x003A, 0x020A, [TagLink(ChannelDefinitionSequence),TagLink(ContributingChannelSourcesSequence),])
    ReferencedFirstFrameSequence = Tag('Referenced First Frame Sequence', "ReferencedFirstFrameSequence", 0x0072, 0x0427, [TagLink(StructuredDisplayImageBoxSequence),])
    ReferencedPresentationStateSequence = Tag('Referenced Presentation State Sequence', "ReferencedPresentationStateSequence", 0x0008, 0x9237, [TagLink(ReferencedImageSequence),TagLink(StructuredDisplayImageBoxSequence),])
    RenderedImageReferenceSequence = Tag('Rendered Image Reference Sequence', "RenderedImageReferenceSequence", 0x0070, 0x1104)
    VolumetricAnnotationSequence = Tag('Volumetric Annotation Sequence', "VolumetricAnnotationSequence", 0x0070, 0x1901)
    VolumetricPresentationInputAnnotationSequence = Tag('Volumetric Presentation Input Annotation Sequence', "VolumetricPresentationInputAnnotationSequence", 0x0070, 0x1905)
    ReferencedStructuredContextSequence = Tag('Referenced Structured Context Sequence', "ReferencedStructuredContextSequence", 0x0070, 0x1903, [TagLink(VolumetricAnnotationSequence),TagLink(VolumetricPresentationInputAnnotationSequence),])
    HL7StructuredDocumentReferenceSequence = Tag('HL7 Structured Document Reference Sequence', "HL7StructuredDocumentReferenceSequence", 0x0040, 0xA390)
    UsedFiducialsSequence = Tag('Used Fiducials Sequence', "UsedFiducialsSequence", 0x0070, 0x0314, [TagLink(RegistrationSequence),TagLink(DeformableRegistrationSequence),])
    UsedSegmentsSequence = Tag('Used Segments Sequence', "UsedSegmentsSequence", 0x0062, 0x0012, [TagLink(RegistrationSequence),])
    UsedRTStructureSetROISequence = Tag('Used RT Structure Set ROI Sequence', "UsedRTStructureSetROISequence", 0x0070, 0x0315, [TagLink(RegistrationSequence),])
    SourceHangingProtocolSequence = Tag('Source Hanging Protocol Sequence', "SourceHangingProtocolSequence", 0x0072, 0x0012)
    DisplaySetsSequence = Tag('Display Sets Sequence', "DisplaySetsSequence", 0x0072, 0x0200)
    PseudoColorPaletteInstanceReferenceSequence = Tag('Pseudo-Color Palette Instance Reference Sequence', "PseudoColorPaletteInstanceReferenceSequence", 0x0072, 0x0705, [TagLink(DisplaySetsSequence),])
    UVMappingSequence = Tag('UV Mapping Sequence', "UVMappingSequence", 0x0080, 0x0008)
    ReferencedTextureSequence = Tag('Referenced Texture Sequence', "ReferencedTextureSequence", 0x0080, 0x0012, [TagLink(UVMappingSequence),])
    ReplacedImplantTemplateSequence = Tag('Replaced Implant Template Sequence', "ReplacedImplantTemplateSequence", 0x0068, 0x6222)
    OriginalImplantTemplateSequence = Tag('Original Implant Template Sequence', "OriginalImplantTemplateSequence", 0x0068, 0x6225)
    DerivationImplantTemplateSequence = Tag('Derivation Implant Template Sequence', "DerivationImplantTemplateSequence", 0x0068, 0x6224)
    ReplacedImplantAssemblyTemplateSequence = Tag('Replaced Implant Assembly Template Sequence', "ReplacedImplantAssemblyTemplateSequence", 0x0076, 0x0008)
    OriginalImplantAssemblyTemplateSequence = Tag('Original Implant Assembly Template Sequence', "OriginalImplantAssemblyTemplateSequence", 0x0076, 0x000C)
    DerivationImplantAssemblyTemplateSequence = Tag('Derivation Implant Assembly Template Sequence', "DerivationImplantAssemblyTemplateSequence", 0x0076, 0x000E)
    ComponentSequence = Tag('Component Sequence', "ComponentSequence", 0x0076, 0x0040, [TagLink(ComponentTypesSequence),])
    ReplacedImplantTemplateGroupSequence = Tag('Replaced Implant Template Group Sequence', "ReplacedImplantTemplateGroupSequence", 0x0078, 0x0026)
    ImplantTemplateGroupMembersSequence = Tag('Implant Template Group Members Sequence', "ImplantTemplateGroupMembersSequence", 0x0078, 0x002A)
    AssessedSOPInstanceSequence = Tag('Assessed SOP Instance Sequence', "AssessedSOPInstanceSequence", 0x0082, 0x0004)
    ReferencedComparisonSOPInstanceSequence = Tag('Referenced Comparison SOP Instance Sequence', "ReferencedComparisonSOPInstanceSequence", 0x0082, 0x0005, [TagLink(AssessedSOPInstanceSequence),])
    PredecessorProtocolSequence = Tag('Predecessor Protocol Sequence', "PredecessorProtocolSequence", 0x0018, 0x990E)
    StorageProtocolElementSequence = Tag('Storage Protocol Element Sequence', "StorageProtocolElementSequence", 0x0018, 0x9936)
    OutputInformationSequence = Tag('Output Information Sequence', "OutputInformationSequence", 0x0040, 0x4033, [TagLink(StorageProtocolElementSequence),])
    ApprovalSubjectSequence = Tag('Approval Subject Sequence', "ApprovalSubjectSequence", 0x0044, 0x0109)
    ReferencedRTRadiationSetSequence = Tag('Referenced RT Radiation Set Sequence', "ReferencedRTRadiationSetSequence", 0x300A, 0x0702, [TagLink(RTImageScopeSequence),TagLink(RTPatientPositionScopeSequence),TagLink(AcquisitionTaskApplicabilitySequence),])
    TreatmentPositionGroupSequence = Tag('Treatment Position Group Sequence', "TreatmentPositionGroupSequence", 0x300A, 0x060A, [TagLink(ReferencedRTRadiationSetSequence),])
    ReferencedRTRadiationSequence = Tag('Referenced RT Radiation Sequence', "ReferencedRTRadiationSequence", 0x300A, 0x0630, [TagLink(ReferencedRTRadiationSetSequence),TagLink(RTImageScopeSequence),TagLink(TreatmentPositionGroupSequence),TagLink(RadiationDoseSequence),TagLink(RTRadiationTaskSequence),TagLink(OmittedRadiationSequence),TagLink(RTPatientPositionScopeSequence),TagLink(AcquisitionTaskApplicabilitySequence),])
    ReferencedPatientSetupPhotoSequence = Tag('Referenced Patient Setup Photo Sequence', "ReferencedPatientSetupPhotoSequence", 0x300A, 0x078C, [TagLink(PatientTreatmentPreparationSequence),])
    InstanceLevelReferencedPerformedProcedureStepSequence = Tag('Instance-Level Referenced Performed Procedure Step Sequence', "InstanceLevelReferencedPerformedProcedureStepSequence", 0x3010, 0x0044)
    RTPhysicianIntentPredecessorSequence = Tag('RT Physician Intent Predecessor Sequence', "RTPhysicianIntentPredecessorSequence", 0x3010, 0x0055, [TagLink(RTPhysicianIntentSequence),])
    PriorTreatmentReferenceSequence = Tag('Prior Treatment Reference Sequence', "PriorTreatmentReferenceSequence", 0x3010, 0x0062, [TagLink(RTPrescriptionSequence),])
    ReferencedRTPhysicianIntentSequence = Tag('Referenced RT Physician Intent Sequence', "ReferencedRTPhysicianIntentSequence", 0x300A, 0x063B)
    RTRadiationSequence = Tag('RT Radiation Sequence', "RTRadiationSequence", 0x300A, 0x0616)
    ReferencedRTRadiationRecordSequence = Tag('Referenced RT Radiation Record Sequence', "ReferencedRTRadiationRecordSequence", 0x300A, 0x0703, [TagLink(RadiationDoseSequence),])
    ReferencedRTInstanceSequence = Tag('Referenced RT Instance Sequence', "ReferencedRTInstanceSequence", 0x300A, 0x0631)
    AdditionalParameterRecordingInstanceSequence = Tag('Additional Parameter Recording Instance Sequence', "AdditionalParameterRecordingInstanceSequence", 0x300A, 0x0780)
    ReferencedRTTreatmentPreparationSequence = Tag('Referenced RT Treatment Preparation Sequence', "ReferencedRTTreatmentPreparationSequence", 0x300A, 0x078B, [TagLink(RTRadiationTaskSequence),])
    ReferencedBaselineParametersRTRadiationInstanceSequence = Tag('Referenced Baseline Parameters RT Radiation Instance Sequence', "ReferencedBaselineParametersRTRadiationInstanceSequence", 0x3002, 0x011E, [TagLink(AcquisitionSubtaskSequence),])
    StructuredWaveformAnnotationSequence = Tag('Structured Waveform Annotation Sequence', "StructuredWaveformAnnotationSequence", 0x0040, 0xB030)
    ReferencedSOPClassUID = Tag('Referenced SOP Class UID', "ReferencedSOPClassUID", 0x0008, 0x1150, [TagLink(ReferencedSOPSequence),TagLink(ReferencedInstanceSequence),TagLink(PertinentDocumentsSequence),TagLink(OriginatingSOPInstanceReferenceSequence),TagLink(EquivalentConceptualVolumeInstanceReferenceSequence),TagLink(ReferencedDirectSegmentInstanceSequence),TagLink(ReferencedImageSequence),TagLink(ReferencedDefinedProtocolSequence),TagLink(ReferencedPerformedProtocolSequence),TagLink(ReferencedPatientSequence),TagLink(ReferencedStudySequence),TagLink(ReferencedPerformedProcedureStepSequence),TagLink(SourceImageSequence),TagLink(ConversionSourceAttributesSequence),TagLink(ReferencedRTPlanSequence),TagLink(ReferencedSpatialRegistrationSequence),TagLink(ReferencedTreatmentRecordSequence),TagLink(ReferencedStructureSetSequence),TagLink(RTReferencedStudySequence),TagLink(ContourImageSequence),TagLink(DefinitionSourceSequence),TagLink(PredecessorStructureSetSequence),TagLink(ReferencedDoseSequence),TagLink(ReferencedSetupImageSequence),TagLink(ReferencedReferenceImageSequence),TagLink(ReferencedVerificationImageSequence),TagLink(ReferencedSurfaceSegmentationSequence),TagLink(RelatedReferenceRTImageSequence),TagLink(OphthalmicFrameLocationSequence),TagLink(ReferencedSegmentationSequence),TagLink(LeftImageSequence),TagLink(RightImageSequence),TagLink(ReferencedOtherPlaneSequence),TagLink(SegmentSurfaceSourceInstanceSequence),TagLink(ReferencedRefractiveMeasurementsSequence),TagLink(ReferencedSurfaceDataSequence),TagLink(SourceWaveformSequence),TagLink(ReferencedFirstFrameSequence),TagLink(ReferencedPresentationStateSequence),TagLink(ReferencedStereometricInstanceSequence),TagLink(RenderedImageReferenceSequence),TagLink(ReferencedStructuredContextSequence),TagLink(HL7StructuredDocumentReferenceSequence),TagLink(SourceInstanceSequence),TagLink(ReferencedRealWorldValueMappingInstanceSequence),TagLink(UsedFiducialsSequence),TagLink(UsedSegmentsSequence),TagLink(UsedRTStructureSetROISequence),TagLink(SourceHangingProtocolSequence),TagLink(PseudoColorPaletteInstanceReferenceSequence),TagLink(ReferencedTextureSequence),TagLink(ReplacedImplantTemplateSequence),TagLink(OriginalImplantTemplateSequence),TagLink(DerivationImplantTemplateSequence),TagLink(ReplacedImplantAssemblyTemplateSequence),TagLink(OriginalImplantAssemblyTemplateSequence),TagLink(DerivationImplantAssemblyTemplateSequence),TagLink(ComponentSequence),TagLink(ReplacedImplantTemplateGroupSequence),TagLink(ImplantTemplateGroupMembersSequence),TagLink(AssessedSOPInstanceSequence),TagLink(ReferencedComparisonSOPInstanceSequence),TagLink(PredecessorProtocolSequence),TagLink(ReconstructionProtocolElementSequence),TagLink(StorageProtocolElementSequence),TagLink(OutputInformationSequence),TagLink(ApprovalSubjectSequence),TagLink(ReferencedRTRadiationSequence),TagLink(ReferencedRTRadiationSetSequence),TagLink(ReferencedPatientSetupPhotoSequence),TagLink(InstanceLevelReferencedPerformedProcedureStepSequence),TagLink(RTPhysicianIntentPredecessorSequence),TagLink(PriorTreatmentReferenceSequence),TagLink(ReferencedRTPhysicianIntentSequence),TagLink(RTRadiationSequence),TagLink(ReferencedRTRadiationRecordSequence),TagLink(ReferencedRTInstanceSequence),TagLink(AdditionalParameterRecordingInstanceSequence),TagLink(ReferencedRTTreatmentPreparationSequence),TagLink(ReferencedBaselineParametersRTRadiationInstanceSequence),TagLink(IncorporatedInventoryInstanceSequence),TagLink(ReferencedWaveformSequence),TagLink(StructuredWaveformAnnotationSequence),])
    ReferencedSOPInstanceUID = Tag('Referenced SOP Instance UID', "ReferencedSOPInstanceUID", 0x0008, 0x1155, [TagLink(ReferencedSOPSequence),TagLink(ReferencedInstanceSequence),TagLink(PertinentDocumentsSequence),TagLink(OriginatingSOPInstanceReferenceSequence),TagLink(EquivalentConceptualVolumeInstanceReferenceSequence),TagLink(ReferencedDirectSegmentInstanceSequence),TagLink(ReferencedImageSequence),TagLink(ReferencedDefinedProtocolSequence),TagLink(ReferencedPerformedProtocolSequence),TagLink(ReferencedPatientSequence),TagLink(ReferencedStudySequence),TagLink(ReferencedPerformedProcedureStepSequence),TagLink(SourceImageSequence),TagLink(ConversionSourceAttributesSequence),TagLink(ReferencedRTPlanSequence),TagLink(ReferencedSpatialRegistrationSequence),TagLink(ReferencedTreatmentRecordSequence),TagLink(ReferencedStructureSetSequence),TagLink(RTReferencedStudySequence),TagLink(ContourImageSequence),TagLink(DefinitionSourceSequence),TagLink(PredecessorStructureSetSequence),TagLink(ReferencedDoseSequence),TagLink(ReferencedSetupImageSequence),TagLink(ReferencedReferenceImageSequence),TagLink(ReferencedVerificationImageSequence),TagLink(ReferencedSurfaceSegmentationSequence),TagLink(RelatedReferenceRTImageSequence),TagLink(OphthalmicFrameLocationSequence),TagLink(ReferencedSegmentationSequence),TagLink(LeftImageSequence),TagLink(RightImageSequence),TagLink(ReferencedOtherPlaneSequence),TagLink(SegmentSurfaceSourceInstanceSequence),TagLink(ReferencedRefractiveMeasurementsSequence),TagLink(ReferencedSurfaceDataSequence),TagLink(SourceWaveformSequence),TagLink(ReferencedFirstFrameSequence),TagLink(ReferencedPresentationStateSequence),TagLink(ReferencedStereometricInstanceSequence),TagLink(RenderedImageReferenceSequence),TagLink(ReferencedStructuredContextSequence),TagLink(HL7StructuredDocumentReferenceSequence),TagLink(SourceInstanceSequence),TagLink(ReferencedRealWorldValueMappingInstanceSequence),TagLink(UsedFiducialsSequence),TagLink(UsedSegmentsSequence),TagLink(UsedRTStructureSetROISequence),TagLink(SourceHangingProtocolSequence),TagLink(PseudoColorPaletteInstanceReferenceSequence),TagLink(ReferencedTextureSequence),TagLink(ReplacedImplantTemplateSequence),TagLink(OriginalImplantTemplateSequence),TagLink(DerivationImplantTemplateSequence),TagLink(ReplacedImplantAssemblyTemplateSequence),TagLink(OriginalImplantAssemblyTemplateSequence),TagLink(DerivationImplantAssemblyTemplateSequence),TagLink(ComponentSequence),TagLink(ReplacedImplantTemplateGroupSequence),TagLink(ImplantTemplateGroupMembersSequence),TagLink(AssessedSOPInstanceSequence),TagLink(ReferencedComparisonSOPInstanceSequence),TagLink(PredecessorProtocolSequence),TagLink(ReconstructionProtocolElementSequence),TagLink(StorageProtocolElementSequence),TagLink(ApprovalSubjectSequence),TagLink(ReferencedRTRadiationSequence),TagLink(ReferencedRTRadiationSetSequence),TagLink(ReferencedPatientSetupPhotoSequence),TagLink(InstanceLevelReferencedPerformedProcedureStepSequence),TagLink(RTPhysicianIntentPredecessorSequence),TagLink(PriorTreatmentReferenceSequence),TagLink(ReferencedRTPhysicianIntentSequence),TagLink(RTRadiationSequence),TagLink(ReferencedRTRadiationRecordSequence),TagLink(ReferencedRTInstanceSequence),TagLink(AdditionalParameterRecordingInstanceSequence),TagLink(ReferencedRTTreatmentPreparationSequence),TagLink(ReferencedBaselineParametersRTRadiationInstanceSequence),TagLink(IncorporatedInventoryInstanceSequence),TagLink(ReferencedWaveformSequence),TagLink(StructuredWaveformAnnotationSequence),])
    SOPClassesSupported = Tag('SOP Classes Supported', "SOPClassesSupported", 0x0008, 0x115A)
    ExposureSequence = Tag('Exposure Sequence', "ExposureSequence", 0x3002, 0x0030)
    TwoDimensionalToThreeDimensionalMapSequence = Tag('Two Dimensional to Three Dimensional Map Sequence', "TwoDimensionalToThreeDimensionalMapSequence", 0x0022, 0x1518)
    ReferencedFrameNumber = Tag('Referenced Frame Number', "ReferencedFrameNumber", 0x0008, 0x1160, [TagLink(ReferencedSOPSequence),TagLink(ReferencedImageSequence),TagLink(SourceImageSequence),TagLink(ConversionSourceAttributesSequence),TagLink(ExposureSequence),TagLink(ContourImageSequence),TagLink(ReferencedSetupImageSequence),TagLink(ReferencedInstanceSequence),TagLink(OphthalmicFrameLocationSequence),TagLink(TwoDimensionalToThreeDimensionalMapSequence),TagLink(ReferencedSegmentationSequence),TagLink(LeftImageSequence),TagLink(RightImageSequence),TagLink(ReferencedOtherPlaneSequence),TagLink(SegmentSurfaceSourceInstanceSequence),TagLink(ReferencedFirstFrameSequence),TagLink(RenderedImageReferenceSequence),TagLink(ReferencedTextureSequence),])
    FrameExtractionSequence = Tag('Frame Extraction Sequence', "FrameExtractionSequence", 0x0008, 0x1164)
    SimpleFrameList = Tag('Simple Frame List', "SimpleFrameList", 0x0008, 0x1161, [TagLink(FrameExtractionSequence),])
    CalculatedFrameList = Tag('Calculated Frame List', "CalculatedFrameList", 0x0008, 0x1162, [TagLink(FrameExtractionSequence),])
    TimeRange = Tag('Time Range', "TimeRange", 0x0008, 0x1163, [TagLink(FrameExtractionSequence),])
    MultiFrameSourceSOPInstanceUID = Tag('Multi-frame Source SOP Instance UID', "MultiFrameSourceSOPInstanceUID", 0x0008, 0x1167, [TagLink(FrameExtractionSequence),])
    WADORSRetrievalSequence = Tag('WADO-RS Retrieval Sequence', "WADORSRetrievalSequence", 0x0040, 0xE025, [TagLink(ReferencedPatientPhotoSequence),])
    RetrieveURL = Tag('Retrieve URL', "RetrieveURL", 0x0008, 0x1190, [TagLink(WADORSRetrievalSequence),TagLink(InventoriedStudiesSequence),])
    TransactionUID = Tag('Transaction UID', "TransactionUID", 0x0008, 0x1195)
    WarningReason = Tag('Warning Reason', "WarningReason", 0x0008, 0x1196)
    FailureReason = Tag('Failure Reason', "FailureReason", 0x0008, 0x1197)
    FailedSOPSequence = Tag('Failed SOP Sequence', "FailedSOPSequence", 0x0008, 0x1198)
    OtherFailuresSequence = Tag('Other Failures Sequence', "OtherFailuresSequence", 0x0008, 0x119A)
    FailedStudySequence = Tag('Failed Study Sequence', "FailedStudySequence", 0x0008, 0x119B)
    LossyImageCompressionRetired = Tag('Lossy Image Compression (Retired)', "LossyImageCompressionRetired", 0x0008, 0x2110)
    DerivationDescription = Tag('Derivation Description', "DerivationDescription", 0x0008, 0x2111, [TagLink(DerivationConceptualVolumeSequence),TagLink(DerivationImageSequence),TagLink(XAXRFFrameCharacteristicsSequence),])
    StageName = Tag('Stage Name', "StageName", 0x0008, 0x2120)
    StageNumber = Tag('Stage Number', "StageNumber", 0x0008, 0x2122)
    NumberOfStages = Tag('Number of Stages', "NumberOfStages", 0x0008, 0x2124)
    ViewName = Tag('View Name', "ViewName", 0x0008, 0x2127)
    ViewNumber = Tag('View Number', "ViewNumber", 0x0008, 0x2128)
    NumberOfEventTimers = Tag('Number of Event Timers', "NumberOfEventTimers", 0x0008, 0x2129)
    NumberOfViewsInStage = Tag('Number of Views in Stage', "NumberOfViewsInStage", 0x0008, 0x212A)
    EventElapsedTimes = Tag('Event Elapsed Time(s)', "EventElapsedTimes", 0x0008, 0x2130)
    EventTimerNames = Tag('Event Timer Name(s)', "EventTimerNames", 0x0008, 0x2132, [TagLink(EventTimerSequence),])
    EventTimeOffset = Tag('Event Time Offset', "EventTimeOffset", 0x0008, 0x2134, [TagLink(EventTimerSequence),])
    FrameDisplaySequence = Tag('Frame Display Sequence', "FrameDisplaySequence", 0x0008, 0x9458, [TagLink(MultiFramePresentationSequence),])
    StartTrim = Tag('Start Trim', "StartTrim", 0x0008, 0x2142, [TagLink(FrameDisplaySequence),TagLink(StructuredDisplayImageBoxSequence),])
    StopTrim = Tag('Stop Trim', "StopTrim", 0x0008, 0x2143, [TagLink(FrameDisplaySequence),TagLink(StructuredDisplayImageBoxSequence),])
    ImageBoxesSequence = Tag('Image Boxes Sequence', "ImageBoxesSequence", 0x0072, 0x0300, [TagLink(DisplaySetsSequence),])
    RecommendedDisplayFrameRate = Tag('Recommended Display Frame Rate', "RecommendedDisplayFrameRate", 0x0008, 0x2144, [TagLink(StructuredDisplayImageBoxSequence),TagLink(ImageBoxesSequence),])
    TransducerPosition = Tag('Transducer Position', "TransducerPosition", 0x0008, 0x2200)
    TransducerOrientation = Tag('Transducer Orientation', "TransducerOrientation", 0x0008, 0x2204)
    AnatomicStructure = Tag('Anatomic Structure', "AnatomicStructure", 0x0008, 0x2208)
    AnatomicStructureSpaceOrRegionSequence = Tag('Anatomic Structure, Space or Region Sequence', "AnatomicStructureSpaceOrRegionSequence", 0x0008, 0x2229)
    TransducerPositionSequence = Tag('Transducer Position Sequence', "TransducerPositionSequence", 0x0008, 0x2240)
    TransducerPositionModifierSequence = Tag('Transducer Position Modifier Sequence', "TransducerPositionModifierSequence", 0x0008, 0x2242)
    TransducerOrientationSequence = Tag('Transducer Orientation Sequence', "TransducerOrientationSequence", 0x0008, 0x2244)
    TransducerOrientationModifierSequence = Tag('Transducer Orientation Modifier Sequence', "TransducerOrientationModifierSequence", 0x0008, 0x2246)
    AnatomicStructureSpaceOrRegionCodeSequenceTrial = Tag('Anatomic Structure Space Or Region Code Sequence (Trial)', "AnatomicStructureSpaceOrRegionCodeSequenceTrial", 0x0008, 0x2251)
    AnatomicPortalOfEntranceCodeSequenceTrial = Tag('Anatomic Portal Of Entrance Code Sequence (Trial)', "AnatomicPortalOfEntranceCodeSequenceTrial", 0x0008, 0x2253)
    AnatomicApproachDirectionCodeSequenceTrial = Tag('Anatomic Approach Direction Code Sequence (Trial)', "AnatomicApproachDirectionCodeSequenceTrial", 0x0008, 0x2255)
    AnatomicPerspectiveDescriptionTrial = Tag('Anatomic Perspective Description (Trial)', "AnatomicPerspectiveDescriptionTrial", 0x0008, 0x2256)
    AnatomicPerspectiveCodeSequenceTrial = Tag('Anatomic Perspective Code Sequence (Trial)', "AnatomicPerspectiveCodeSequenceTrial", 0x0008, 0x2257)
    AnatomicLocationOfExaminingInstrumentDescriptionTrial = Tag('Anatomic Location Of Examining Instrument Description (Trial)', "AnatomicLocationOfExaminingInstrumentDescriptionTrial", 0x0008, 0x2258)
    AnatomicLocationOfExaminingInstrumentCodeSequenceTrial = Tag('Anatomic Location Of Examining Instrument Code Sequence (Trial)', "AnatomicLocationOfExaminingInstrumentCodeSequenceTrial", 0x0008, 0x2259)
    AnatomicStructureSpaceOrRegionModifierCodeSequenceTrial = Tag('Anatomic Structure Space Or Region Modifier Code Sequence (Trial)', "AnatomicStructureSpaceOrRegionModifierCodeSequenceTrial", 0x0008, 0x225A)
    OnAxisBackgroundAnatomicStructureCodeSequenceTrial = Tag('On Axis Background Anatomic Structure Code Sequence (Trial)', "OnAxisBackgroundAnatomicStructureCodeSequenceTrial", 0x0008, 0x225C)
    AvailableTransferSyntaxUID = Tag('Available Transfer Syntax UID', "AvailableTransferSyntaxUID", 0x0008, 0x3002)
    IrradiationEventIdentificationSequence = Tag('Irradiation Event Identification Sequence', "IrradiationEventIdentificationSequence", 0x0018, 0x9477, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    SourceIrradiationEventSequence = Tag('Source Irradiation Event Sequence', "SourceIrradiationEventSequence", 0x0008, 0x3011)
    PerProjectionAcquisitionSequence = Tag('Per Projection Acquisition Sequence', "PerProjectionAcquisitionSequence", 0x0018, 0x9538, [TagLink(XRay3DAcquisitionSequence),])
    IrradiationEventUID = Tag('Irradiation Event UID', "IrradiationEventUID", 0x0008, 0x3010, [TagLink(IrradiationEventIdentificationSequence),TagLink(SourceIrradiationEventSequence),TagLink(PerProjectionAcquisitionSequence),])
    RadiopharmaceuticalAdministrationEventUID = Tag('Radiopharmaceutical Administration Event UID', "RadiopharmaceuticalAdministrationEventUID", 0x0008, 0x3012, [TagLink(RadiopharmaceuticalInformationSequence),])
    IdentifyingComments = Tag('Identifying Comments', "IdentifyingComments", 0x0008, 0x4000)
    WholeSlideMicroscopyImageFrameTypeSequence = Tag('Whole Slide Microscopy Image Frame Type Sequence', "WholeSlideMicroscopyImageFrameTypeSequence", 0x0040, 0x0710, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    MRImageFrameTypeSequence = Tag('MR Image Frame Type Sequence', "MRImageFrameTypeSequence", 0x0018, 0x9226, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    MRSpectroscopyFrameTypeSequence = Tag('MR Spectroscopy Frame Type Sequence', "MRSpectroscopyFrameTypeSequence", 0x0018, 0x9227, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    CTImageFrameTypeSequence = Tag('CT Image Frame Type Sequence', "CTImageFrameTypeSequence", 0x0018, 0x9329, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    FramePixelDataPropertiesSequence = Tag('Frame Pixel Data Properties Sequence', "FramePixelDataPropertiesSequence", 0x0028, 0x9443, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    XRay3DFrameTypeSequence = Tag('X-Ray 3D Frame Type Sequence', "XRay3DFrameTypeSequence", 0x0018, 0x9504, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    PETFrameTypeSequence = Tag('PET Frame Type Sequence', "PETFrameTypeSequence", 0x0018, 0x9751, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    USImageDescriptionSequence = Tag('US Image Description Sequence', "USImageDescriptionSequence", 0x0018, 0x9806, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    IntravascularOCTFrameTypeSequence = Tag('Intravascular OCT Frame Type Sequence', "IntravascularOCTFrameTypeSequence", 0x0052, 0x0025, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    ParametricMapFrameTypeSequence = Tag('Parametric Map Frame Type Sequence', "ParametricMapFrameTypeSequence", 0x0040, 0x9092, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    PhotoacousticImageFrameTypeSequence = Tag('Photoacoustic Image Frame Type Sequence', "PhotoacousticImageFrameTypeSequence", 0x0018, 0x9835, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    ConfocalMicroscopyImageFrameTypeSequence = Tag('Confocal Microscopy Image Frame Type Sequence', "ConfocalMicroscopyImageFrameTypeSequence", 0x0048, 0x0116, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    RTImageFrameGeneralContentSequence = Tag('RT Image Frame General Content Sequence', "RTImageFrameGeneralContentSequence", 0x3002, 0x0102, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    FrameType = Tag('Frame Type', "FrameType", 0x0008, 0x9007, [TagLink(WholeSlideMicroscopyImageFrameTypeSequence),TagLink(MRImageFrameTypeSequence),TagLink(MRSpectroscopyFrameTypeSequence),TagLink(CTImageFrameTypeSequence),TagLink(FramePixelDataPropertiesSequence),TagLink(XRay3DFrameTypeSequence),TagLink(PETFrameTypeSequence),TagLink(USImageDescriptionSequence),TagLink(IntravascularOCTFrameTypeSequence),TagLink(ParametricMapFrameTypeSequence),TagLink(PhotoacousticImageFrameTypeSequence),TagLink(ConfocalMicroscopyImageFrameTypeSequence),TagLink(RTImageFrameGeneralContentSequence),])
    ReferencedImageEvidenceSequence = Tag('Referenced Image Evidence Sequence', "ReferencedImageEvidenceSequence", 0x0008, 0x9092)
    ReferencedRawDataSequence = Tag('Referenced Raw Data Sequence', "ReferencedRawDataSequence", 0x0008, 0x9121)
    CreatorVersionUID = Tag('Creator-Version UID', "CreatorVersionUID", 0x0008, 0x9123, [TagLink(AdditionalParameterRecordingInstanceSequence),])
    SourceImageEvidenceSequence = Tag('Source Image Evidence Sequence', "SourceImageEvidenceSequence", 0x0008, 0x9154)
    PixelPresentation = Tag('Pixel Presentation', "PixelPresentation", 0x0008, 0x9205, [TagLink(XRay3DFrameTypeSequence),TagLink(PETFrameTypeSequence),TagLink(PhotoacousticImageFrameTypeSequence),])
    VolumetricProperties = Tag('Volumetric Properties', "VolumetricProperties", 0x0008, 0x9206, [TagLink(XRay3DFrameTypeSequence),TagLink(PETFrameTypeSequence),TagLink(USImageDescriptionSequence),TagLink(PhotoacousticImageFrameTypeSequence),])
    VolumeBasedCalculationTechnique = Tag('Volume Based Calculation Technique', "VolumeBasedCalculationTechnique", 0x0008, 0x9207, [TagLink(XRay3DFrameTypeSequence),TagLink(PETFrameTypeSequence),TagLink(USImageDescriptionSequence),TagLink(PhotoacousticImageFrameTypeSequence),])
    ComplexImageComponent = Tag('Complex Image Component', "ComplexImageComponent", 0x0008, 0x9208, [TagLink(MRImageFrameTypeSequence),])
    AcquisitionContrast = Tag('Acquisition Contrast', "AcquisitionContrast", 0x0008, 0x9209, [TagLink(MRImageFrameTypeSequence),])
    RecommendedDisplayFrameRateInFloat = Tag('Recommended Display Frame Rate in Float', "RecommendedDisplayFrameRateInFloat", 0x0008, 0x9459, [TagLink(FrameDisplaySequence),])
    SkipFrameRangeFlag = Tag('Skip Frame Range Flag', "SkipFrameRangeFlag", 0x0008, 0x9460, [TagLink(FrameDisplaySequence),])
    PatientName = Tag("Patient's Name", "PatientName", 0x0010, 0x0010, [TagLink(InventoriedStudiesSequence),])
    PatientID = Tag('Patient ID', "PatientID", 0x0010, 0x0020, [TagLink(OtherPatientIDsSequence),TagLink(SourcePatientGroupIdentificationSequence),TagLink(GroupOfPatientsIdentificationSequence),TagLink(InventoriedStudiesSequence),])
    IssuerOfPatientID = Tag('Issuer of Patient ID', "IssuerOfPatientID", 0x0010, 0x0021, [TagLink(OtherPatientIDsSequence),TagLink(SourcePatientGroupIdentificationSequence),TagLink(GroupOfPatientsIdentificationSequence),TagLink(InventoriedStudiesSequence),])
    TypeOfPatientID = Tag('Type of Patient ID', "TypeOfPatientID", 0x0010, 0x0022, [TagLink(OtherPatientIDsSequence),])
    SubjectRelativePositionInImage = Tag('Subject Relative Position in Image', "SubjectRelativePositionInImage", 0x0010, 0x0028, [TagLink(GroupOfPatientsIdentificationSequence),])
    PatientBirthDate = Tag("Patient's Birth Date", "PatientBirthDate", 0x0010, 0x0030, [TagLink(InventoriedStudiesSequence),])
    PatientBirthTime = Tag("Patient's Birth Time", "PatientBirthTime", 0x0010, 0x0032)
    PatientBirthDateInAlternativeCalendar = Tag("Patient's Birth Date in Alternative Calendar", "PatientBirthDateInAlternativeCalendar", 0x0010, 0x0033)
    PatientDeathDateInAlternativeCalendar = Tag("Patient's Death Date in Alternative Calendar", "PatientDeathDateInAlternativeCalendar", 0x0010, 0x0034)
    PatientAlternativeCalendar = Tag("Patient's Alternative Calendar", "PatientAlternativeCalendar", 0x0010, 0x0035)
    PatientSex = Tag("Patient's Sex", "PatientSex", 0x0010, 0x0040, [TagLink(InventoriedStudiesSequence),])
    PatientInsurancePlanCodeSequence = Tag("Patient's Insurance Plan Code Sequence", "PatientInsurancePlanCodeSequence", 0x0010, 0x0050)
    PatientPrimaryLanguageCodeSequence = Tag("Patient's Primary Language Code Sequence", "PatientPrimaryLanguageCodeSequence", 0x0010, 0x0101)
    PatientPrimaryLanguageModifierCodeSequence = Tag("Patient's Primary Language Modifier Code Sequence", "PatientPrimaryLanguageModifierCodeSequence", 0x0010, 0x0102)
    QualityControlSubject = Tag('Quality Control Subject', "QualityControlSubject", 0x0010, 0x0200)
    QualityControlSubjectTypeCodeSequence = Tag('Quality Control Subject Type Code Sequence', "QualityControlSubjectTypeCodeSequence", 0x0010, 0x0201)
    StrainDescription = Tag('Strain Description', "StrainDescription", 0x0010, 0x0212)
    StrainNomenclature = Tag('Strain Nomenclature', "StrainNomenclature", 0x0010, 0x0213)
    StrainStockNumber = Tag('Strain Stock Number', "StrainStockNumber", 0x0010, 0x0214, [TagLink(StrainStockSequence),])
    StrainSource = Tag('Strain Source', "StrainSource", 0x0010, 0x0217, [TagLink(StrainStockSequence),])
    StrainAdditionalInformation = Tag('Strain Additional Information', "StrainAdditionalInformation", 0x0010, 0x0218)
    GeneticModificationsDescription = Tag('Genetic Modifications Description', "GeneticModificationsDescription", 0x0010, 0x0222, [TagLink(GeneticModificationsSequence),])
    GeneticModificationsNomenclature = Tag('Genetic Modifications Nomenclature', "GeneticModificationsNomenclature", 0x0010, 0x0223, [TagLink(GeneticModificationsSequence),])
    OtherPatientIDs = Tag('Other Patient IDs', "OtherPatientIDs", 0x0010, 0x1000)
    OtherPatientNames = Tag('Other Patient Names', "OtherPatientNames", 0x0010, 0x1001, [TagLink(InventoriedStudiesSequence),])
    PatientBirthName = Tag("Patient's Birth Name", "PatientBirthName", 0x0010, 0x1005)
    PatientAge = Tag("Patient's Age", "PatientAge", 0x0010, 0x1010)
    PatientSize = Tag("Patient's Size", "PatientSize", 0x0010, 0x1020)
    PatientBodyMassIndex = Tag("Patient's Body Mass Index", "PatientBodyMassIndex", 0x0010, 0x1022)
    MeasuredAPDimension = Tag('Measured AP Dimension', "MeasuredAPDimension", 0x0010, 0x1023)
    MeasuredLateralDimension = Tag('Measured Lateral Dimension', "MeasuredLateralDimension", 0x0010, 0x1024)
    PatientWeight = Tag("Patient's Weight", "PatientWeight", 0x0010, 0x1030)
    PatientAddress = Tag("Patient's Address", "PatientAddress", 0x0010, 0x1040)
    InsurancePlanIdentification = Tag('Insurance Plan Identification', "InsurancePlanIdentification", 0x0010, 0x1050)
    PatientMotherBirthName = Tag("Patient's Mother's Birth Name", "PatientMotherBirthName", 0x0010, 0x1060)
    MilitaryRank = Tag('Military Rank', "MilitaryRank", 0x0010, 0x1080)
    BranchOfService = Tag('Branch of Service', "BranchOfService", 0x0010, 0x1081)
    MedicalRecordLocator = Tag('Medical Record Locator', "MedicalRecordLocator", 0x0010, 0x1090)
    MedicalAlerts = Tag('Medical Alerts', "MedicalAlerts", 0x0010, 0x2000)
    Allergies = Tag('Allergies', "Allergies", 0x0010, 0x2110)
    CountryOfResidence = Tag('Country of Residence', "CountryOfResidence", 0x0010, 0x2150)
    RegionOfResidence = Tag('Region of Residence', "RegionOfResidence", 0x0010, 0x2152)
    PatientTelephoneNumbers = Tag("Patient's Telephone Numbers", "PatientTelephoneNumbers", 0x0010, 0x2154)
    PatientTelecomInformation = Tag("Patient's Telecom Information", "PatientTelecomInformation", 0x0010, 0x2155)
    EthnicGroup = Tag('Ethnic Group', "EthnicGroup", 0x0010, 0x2160)
    Occupation = Tag('Occupation', "Occupation", 0x0010, 0x2180)
    SmokingStatus = Tag('Smoking Status', "SmokingStatus", 0x0010, 0x21A0)
    AdditionalPatientHistory = Tag('Additional Patient History', "AdditionalPatientHistory", 0x0010, 0x21B0)
    PregnancyStatus = Tag('Pregnancy Status', "PregnancyStatus", 0x0010, 0x21C0)
    LastMenstrualDate = Tag('Last Menstrual Date', "LastMenstrualDate", 0x0010, 0x21D0)
    PatientReligiousPreference = Tag("Patient's Religious Preference", "PatientReligiousPreference", 0x0010, 0x21F0)
    PatientSpeciesDescription = Tag('Patient Species Description', "PatientSpeciesDescription", 0x0010, 0x2201)
    PatientSexNeutered = Tag("Patient's Sex Neutered", "PatientSexNeutered", 0x0010, 0x2203)
    AnatomicalOrientationType = Tag('Anatomical Orientation Type', "AnatomicalOrientationType", 0x0010, 0x2210)
    PatientBreedDescription = Tag('Patient Breed Description', "PatientBreedDescription", 0x0010, 0x2292)
    BreedRegistrationNumber = Tag('Breed Registration Number', "BreedRegistrationNumber", 0x0010, 0x2295, [TagLink(BreedRegistrationSequence),])
    ResponsiblePerson = Tag('Responsible Person', "ResponsiblePerson", 0x0010, 0x2297)
    ResponsiblePersonRole = Tag('Responsible Person Role', "ResponsiblePersonRole", 0x0010, 0x2298)
    ResponsibleOrganization = Tag('Responsible Organization', "ResponsibleOrganization", 0x0010, 0x2299)
    PatientComments = Tag('Patient Comments', "PatientComments", 0x0010, 0x4000)
    ExaminedBodyThickness = Tag('Examined Body Thickness', "ExaminedBodyThickness", 0x0010, 0x9431)
    ClinicalTrialSponsorName = Tag('Clinical Trial Sponsor Name', "ClinicalTrialSponsorName", 0x0012, 0x0010)
    OtherClinicalTrialProtocolIDsSequence = Tag('Other Clinical Trial Protocol IDs Sequence', "OtherClinicalTrialProtocolIDsSequence", 0x0012, 0x0023)
    ConsentForClinicalTrialUseSequence = Tag('Consent for Clinical Trial Use Sequence', "ConsentForClinicalTrialUseSequence", 0x0012, 0x0083)
    ClinicalTrialProtocolID = Tag('Clinical Trial Protocol ID', "ClinicalTrialProtocolID", 0x0012, 0x0020, [TagLink(OtherClinicalTrialProtocolIDsSequence),TagLink(ConsentForClinicalTrialUseSequence),TagLink(ApprovalSequence),])
    ClinicalTrialProtocolName = Tag('Clinical Trial Protocol Name', "ClinicalTrialProtocolName", 0x0012, 0x0021)
    IssuerOfClinicalTrialProtocolID = Tag('Issuer of Clinical Trial Protocol ID', "IssuerOfClinicalTrialProtocolID", 0x0012, 0x0022, [TagLink(OtherClinicalTrialProtocolIDsSequence),TagLink(ConsentForClinicalTrialUseSequence),])
    ClinicalTrialSiteID = Tag('Clinical Trial Site ID', "ClinicalTrialSiteID", 0x0012, 0x0030)
    ClinicalTrialSiteName = Tag('Clinical Trial Site Name', "ClinicalTrialSiteName", 0x0012, 0x0031)
    IssuerOfClinicalTrialSiteID = Tag('Issuer of Clinical Trial Site ID', "IssuerOfClinicalTrialSiteID", 0x0012, 0x0032)
    ClinicalTrialSubjectID = Tag('Clinical Trial Subject ID', "ClinicalTrialSubjectID", 0x0012, 0x0040)
    IssuerOfClinicalTrialSubjectID = Tag('Issuer of Clinical Trial Subject ID', "IssuerOfClinicalTrialSubjectID", 0x0012, 0x0041)
    ClinicalTrialSubjectReadingID = Tag('Clinical Trial Subject Reading ID', "ClinicalTrialSubjectReadingID", 0x0012, 0x0042)
    IssuerOfClinicalTrialSubjectReadingID = Tag('Issuer of Clinical Trial Subject Reading ID', "IssuerOfClinicalTrialSubjectReadingID", 0x0012, 0x0043)
    ClinicalTrialTimePointID = Tag('Clinical Trial Time Point ID', "ClinicalTrialTimePointID", 0x0012, 0x0050)
    ClinicalTrialTimePointDescription = Tag('Clinical Trial Time Point Description', "ClinicalTrialTimePointDescription", 0x0012, 0x0051)
    LongitudinalTemporalOffsetFromEvent = Tag('Longitudinal Temporal Offset from Event', "LongitudinalTemporalOffsetFromEvent", 0x0012, 0x0052)
    LongitudinalTemporalEventType = Tag('Longitudinal Temporal Event Type', "LongitudinalTemporalEventType", 0x0012, 0x0053)
    IssuerOfClinicalTrialTimePointID = Tag('Issuer of Clinical Trial Time Point ID', "IssuerOfClinicalTrialTimePointID", 0x0012, 0x0055)
    ClinicalTrialCoordinatingCenterName = Tag('Clinical Trial Coordinating Center Name', "ClinicalTrialCoordinatingCenterName", 0x0012, 0x0060)
    PatientIdentityRemoved = Tag('Patient Identity Removed', "PatientIdentityRemoved", 0x0012, 0x0062)
    DeidentificationMethod = Tag('De-identification Method', "DeidentificationMethod", 0x0012, 0x0063)
    ClinicalTrialSeriesID = Tag('Clinical Trial Series ID', "ClinicalTrialSeriesID", 0x0012, 0x0071)
    ClinicalTrialSeriesDescription = Tag('Clinical Trial Series Description', "ClinicalTrialSeriesDescription", 0x0012, 0x0072)
    IssuerOfClinicalTrialSeriesID = Tag('Issuer of Clinical Trial Series ID', "IssuerOfClinicalTrialSeriesID", 0x0012, 0x0073)
    ClinicalTrialProtocolEthicsCommitteeName = Tag('Clinical Trial Protocol Ethics Committee Name', "ClinicalTrialProtocolEthicsCommitteeName", 0x0012, 0x0081)
    ClinicalTrialProtocolEthicsCommitteeApprovalNumber = Tag('Clinical Trial Protocol Ethics Committee Approval Number', "ClinicalTrialProtocolEthicsCommitteeApprovalNumber", 0x0012, 0x0082)
    DistributionType = Tag('Distribution Type', "DistributionType", 0x0012, 0x0084, [TagLink(ConsentForClinicalTrialUseSequence),])
    ConsentForDistributionFlag = Tag('Consent for Distribution Flag', "ConsentForDistributionFlag", 0x0012, 0x0085, [TagLink(ConsentForClinicalTrialUseSequence),])
    EthicsCommitteeApprovalEffectivenessStartDate = Tag('Ethics Committee Approval Effectiveness Start Date', "EthicsCommitteeApprovalEffectivenessStartDate", 0x0012, 0x0086)
    EthicsCommitteeApprovalEffectivenessEndDate = Tag('Ethics Committee Approval Effectiveness End Date', "EthicsCommitteeApprovalEffectivenessEndDate", 0x0012, 0x0087)
    CADFileFormat = Tag('CAD File Format', "CADFileFormat", 0x0014, 0x0023)
    ComponentReferenceSystem = Tag('Component Reference System', "ComponentReferenceSystem", 0x0014, 0x0024)
    ComponentManufacturingProcedure = Tag('Component Manufacturing Procedure', "ComponentManufacturingProcedure", 0x0014, 0x0025)
    ComponentManufacturer = Tag('Component Manufacturer', "ComponentManufacturer", 0x0014, 0x0028)
    MaterialThickness = Tag('Material Thickness', "MaterialThickness", 0x0014, 0x0030)
    MaterialPipeDiameter = Tag('Material Pipe Diameter', "MaterialPipeDiameter", 0x0014, 0x0032)
    MaterialIsolationDiameter = Tag('Material Isolation Diameter', "MaterialIsolationDiameter", 0x0014, 0x0034)
    MaterialGrade = Tag('Material Grade', "MaterialGrade", 0x0014, 0x0042)
    MaterialPropertiesDescription = Tag('Material Properties Description', "MaterialPropertiesDescription", 0x0014, 0x0044)
    MaterialPropertiesFileFormatRetired = Tag('Material Properties File Format (Retired)', "MaterialPropertiesFileFormatRetired", 0x0014, 0x0045)
    MaterialNotes = Tag('Material Notes', "MaterialNotes", 0x0014, 0x0046)
    ComponentShape = Tag('Component Shape', "ComponentShape", 0x0014, 0x0050)
    CurvatureType = Tag('Curvature Type', "CurvatureType", 0x0014, 0x0052)
    OuterDiameter = Tag('Outer Diameter', "OuterDiameter", 0x0014, 0x0054)
    InnerDiameter = Tag('Inner Diameter', "InnerDiameter", 0x0014, 0x0056)
    ComponentWelderIDs = Tag('Component Welder IDs', "ComponentWelderIDs", 0x0014, 0x0100)
    SecondaryApprovalStatus = Tag('Secondary Approval Status', "SecondaryApprovalStatus", 0x0014, 0x0101)
    SecondaryReviewDate = Tag('Secondary Review Date', "SecondaryReviewDate", 0x0014, 0x0102)
    SecondaryReviewTime = Tag('Secondary Review Time', "SecondaryReviewTime", 0x0014, 0x0103)
    SecondaryReviewerName = Tag('Secondary Reviewer Name', "SecondaryReviewerName", 0x0014, 0x0104)
    RepairID = Tag('Repair ID', "RepairID", 0x0014, 0x0105)
    MultipleComponentApprovalSequence = Tag('Multiple Component Approval Sequence', "MultipleComponentApprovalSequence", 0x0014, 0x0106)
    OtherApprovalStatus = Tag('Other Approval Status', "OtherApprovalStatus", 0x0014, 0x0107)
    OtherSecondaryApprovalStatus = Tag('Other Secondary Approval Status', "OtherSecondaryApprovalStatus", 0x0014, 0x0108)
    DataElementLabelSequence = Tag('Data Element Label Sequence', "DataElementLabelSequence", 0x0014, 0x0200)
    DataElementLabelItemSequence = Tag('Data Element Label Item Sequence', "DataElementLabelItemSequence", 0x0014, 0x0201)
    DataElement = Tag('Data Element', "DataElement", 0x0014, 0x0202)
    DataElementName = Tag('Data Element Name', "DataElementName", 0x0014, 0x0203)
    DataElementDescription = Tag('Data Element Description', "DataElementDescription", 0x0014, 0x0204)
    DataElementConditionality = Tag('Data Element Conditionality', "DataElementConditionality", 0x0014, 0x0205)
    DataElementMinimumCharacters = Tag('Data Element Minimum Characters', "DataElementMinimumCharacters", 0x0014, 0x0206)
    DataElementMaximumCharacters = Tag('Data Element Maximum Characters', "DataElementMaximumCharacters", 0x0014, 0x0207)
    ActualEnvironmentalConditions = Tag('Actual Environmental Conditions', "ActualEnvironmentalConditions", 0x0014, 0x1010)
    ExpiryDate = Tag('Expiry Date', "ExpiryDate", 0x0014, 0x1020)
    EnvironmentalConditions = Tag('Environmental Conditions', "EnvironmentalConditions", 0x0014, 0x1040)
    EvaluatorSequence = Tag('Evaluator Sequence', "EvaluatorSequence", 0x0014, 0x2002)
    EvaluatorNumber = Tag('Evaluator Number', "EvaluatorNumber", 0x0014, 0x2004)
    EvaluatorName = Tag('Evaluator Name', "EvaluatorName", 0x0014, 0x2006)
    EvaluationAttempt = Tag('Evaluation Attempt', "EvaluationAttempt", 0x0014, 0x2008)
    IndicationSequence = Tag('Indication Sequence', "IndicationSequence", 0x0014, 0x2012)
    IndicationNumber = Tag('Indication Number', "IndicationNumber", 0x0014, 0x2014)
    IndicationLabel = Tag('Indication Label', "IndicationLabel", 0x0014, 0x2016)
    IndicationDescription = Tag('Indication Description', "IndicationDescription", 0x0014, 0x2018)
    IndicationType = Tag('Indication Type', "IndicationType", 0x0014, 0x201A)
    IndicationDisposition = Tag('Indication Disposition', "IndicationDisposition", 0x0014, 0x201C)
    IndicationROISequence = Tag('Indication ROI Sequence', "IndicationROISequence", 0x0014, 0x201E)
    IndicationPhysicalPropertySequence = Tag('Indication Physical Property Sequence', "IndicationPhysicalPropertySequence", 0x0014, 0x2030)
    PropertyLabel = Tag('Property Label', "PropertyLabel", 0x0014, 0x2032)
    CoordinateSystemNumberOfAxes = Tag('Coordinate System Number of Axes', "CoordinateSystemNumberOfAxes", 0x0014, 0x2202)
    CoordinateSystemAxesSequence = Tag('Coordinate System Axes Sequence', "CoordinateSystemAxesSequence", 0x0014, 0x2204)
    CoordinateSystemAxisDescription = Tag('Coordinate System Axis Description', "CoordinateSystemAxisDescription", 0x0014, 0x2206)
    CoordinateSystemDataSetMapping = Tag('Coordinate System Data Set Mapping', "CoordinateSystemDataSetMapping", 0x0014, 0x2208)
    CoordinateSystemAxisNumber = Tag('Coordinate System Axis Number', "CoordinateSystemAxisNumber", 0x0014, 0x220A)
    CoordinateSystemAxisType = Tag('Coordinate System Axis Type', "CoordinateSystemAxisType", 0x0014, 0x220C)
    CoordinateSystemAxisUnits = Tag('Coordinate System Axis Units', "CoordinateSystemAxisUnits", 0x0014, 0x220E)
    CoordinateSystemAxisValues = Tag('Coordinate System Axis Values', "CoordinateSystemAxisValues", 0x0014, 0x2210)
    CoordinateSystemTransformSequence = Tag('Coordinate System Transform Sequence', "CoordinateSystemTransformSequence", 0x0014, 0x2220)
    TransformDescription = Tag('Transform Description', "TransformDescription", 0x0014, 0x2222)
    TransformNumberOfAxes = Tag('Transform Number of Axes', "TransformNumberOfAxes", 0x0014, 0x2224)
    TransformOrderOfAxes = Tag('Transform Order of Axes', "TransformOrderOfAxes", 0x0014, 0x2226)
    TransformedAxisUnits = Tag('Transformed Axis Units', "TransformedAxisUnits", 0x0014, 0x2228)
    CoordinateSystemTransformRotationAndScaleMatrix = Tag('Coordinate System Transform Rotation and Scale Matrix', "CoordinateSystemTransformRotationAndScaleMatrix", 0x0014, 0x222A)
    CoordinateSystemTransformTranslationMatrix = Tag('Coordinate System Transform Translation Matrix', "CoordinateSystemTransformTranslationMatrix", 0x0014, 0x222C)
    InternalDetectorFrameTime = Tag('Internal Detector Frame Time', "InternalDetectorFrameTime", 0x0014, 0x3011)
    NumberOfFramesIntegrated = Tag('Number of Frames Integrated', "NumberOfFramesIntegrated", 0x0014, 0x3012)
    DetectorTemperatureSequence = Tag('Detector Temperature Sequence', "DetectorTemperatureSequence", 0x0014, 0x3020)
    SensorName = Tag('Sensor Name', "SensorName", 0x0014, 0x3022)
    HorizontalOffsetOfSensor = Tag('Horizontal Offset of Sensor', "HorizontalOffsetOfSensor", 0x0014, 0x3024)
    VerticalOffsetOfSensor = Tag('Vertical Offset of Sensor', "VerticalOffsetOfSensor", 0x0014, 0x3026)
    SensorTemperature = Tag('Sensor Temperature', "SensorTemperature", 0x0014, 0x3028)
    DarkCurrentSequence = Tag('Dark Current Sequence', "DarkCurrentSequence", 0x0014, 0x3040)
    DarkCurrentCounts = Tag('Dark Current Counts', "DarkCurrentCounts", 0x0014, 0x3050)
    GainCorrectionReferenceSequence = Tag('Gain Correction Reference Sequence', "GainCorrectionReferenceSequence", 0x0014, 0x3060)
    AirCounts = Tag('Air Counts', "AirCounts", 0x0014, 0x3070)
    KVUsedInGainCalibration = Tag('KV Used in Gain Calibration', "KVUsedInGainCalibration", 0x0014, 0x3071)
    MAUsedInGainCalibration = Tag('MA Used in Gain Calibration', "MAUsedInGainCalibration", 0x0014, 0x3072)
    NumberOfFramesUsedForIntegration = Tag('Number of Frames Used for Integration', "NumberOfFramesUsedForIntegration", 0x0014, 0x3073)
    FilterMaterialUsedInGainCalibration = Tag('Filter Material Used in Gain Calibration', "FilterMaterialUsedInGainCalibration", 0x0014, 0x3074)
    FilterThicknessUsedInGainCalibration = Tag('Filter Thickness Used in Gain Calibration', "FilterThicknessUsedInGainCalibration", 0x0014, 0x3075)
    DateOfGainCalibration = Tag('Date of Gain Calibration', "DateOfGainCalibration", 0x0014, 0x3076)
    TimeOfGainCalibration = Tag('Time of Gain Calibration', "TimeOfGainCalibration", 0x0014, 0x3077)
    BadPixelImage = Tag('Bad Pixel Image', "BadPixelImage", 0x0014, 0x3080)
    CalibrationNotes = Tag('Calibration Notes', "CalibrationNotes", 0x0014, 0x3099)
    LinearityCorrectionTechnique = Tag('Linearity Correction Technique', "LinearityCorrectionTechnique", 0x0014, 0x3100)
    BeamHardeningCorrectionTechnique = Tag('Beam Hardening Correction Technique', "BeamHardeningCorrectionTechnique", 0x0014, 0x3101)
    PulserEquipmentSequence = Tag('Pulser Equipment Sequence', "PulserEquipmentSequence", 0x0014, 0x4002)
    PulserType = Tag('Pulser Type', "PulserType", 0x0014, 0x4004)
    PulserNotes = Tag('Pulser Notes', "PulserNotes", 0x0014, 0x4006)
    ReceiverEquipmentSequence = Tag('Receiver Equipment Sequence', "ReceiverEquipmentSequence", 0x0014, 0x4008)
    AmplifierType = Tag('Amplifier Type', "AmplifierType", 0x0014, 0x400A)
    ReceiverNotes = Tag('Receiver Notes', "ReceiverNotes", 0x0014, 0x400C)
    PreAmplifierEquipmentSequence = Tag('Pre-Amplifier Equipment Sequence', "PreAmplifierEquipmentSequence", 0x0014, 0x400E)
    PreAmplifierNotes = Tag('Pre-Amplifier Notes', "PreAmplifierNotes", 0x0014, 0x400F)
    TransmitTransducerSequence = Tag('Transmit Transducer Sequence', "TransmitTransducerSequence", 0x0014, 0x4010)
    ReceiveTransducerSequence = Tag('Receive Transducer Sequence', "ReceiveTransducerSequence", 0x0014, 0x4011)
    NumberOfElements = Tag('Number of Elements', "NumberOfElements", 0x0014, 0x4012)
    ElementShape = Tag('Element Shape', "ElementShape", 0x0014, 0x4013)
    ElementDimensionA = Tag('Element Dimension A', "ElementDimensionA", 0x0014, 0x4014)
    ElementDimensionB = Tag('Element Dimension B', "ElementDimensionB", 0x0014, 0x4015)
    ElementPitchA = Tag('Element Pitch A', "ElementPitchA", 0x0014, 0x4016)
    MeasuredBeamDimensionA = Tag('Measured Beam Dimension A', "MeasuredBeamDimensionA", 0x0014, 0x4017)
    MeasuredBeamDimensionB = Tag('Measured Beam Dimension B', "MeasuredBeamDimensionB", 0x0014, 0x4018)
    LocationOfMeasuredBeamDiameter = Tag('Location of Measured Beam Diameter', "LocationOfMeasuredBeamDiameter", 0x0014, 0x4019)
    NominalFrequency = Tag('Nominal Frequency', "NominalFrequency", 0x0014, 0x401A)
    MeasuredCenterFrequency = Tag('Measured Center Frequency', "MeasuredCenterFrequency", 0x0014, 0x401B)
    MeasuredBandwidth = Tag('Measured Bandwidth', "MeasuredBandwidth", 0x0014, 0x401C)
    ElementPitchB = Tag('Element Pitch B', "ElementPitchB", 0x0014, 0x401D)
    PulserSettingsSequence = Tag('Pulser Settings Sequence', "PulserSettingsSequence", 0x0014, 0x4020)
    PulseWidth = Tag('Pulse Width', "PulseWidth", 0x0014, 0x4022)
    ExcitationFrequency = Tag('Excitation Frequency', "ExcitationFrequency", 0x0014, 0x4024)
    ModulationType = Tag('Modulation Type', "ModulationType", 0x0014, 0x4026)
    Damping = Tag('Damping', "Damping", 0x0014, 0x4028)
    ReceiverSettingsSequence = Tag('Receiver Settings Sequence', "ReceiverSettingsSequence", 0x0014, 0x4030)
    AcquiredSoundpathLength = Tag('Acquired Soundpath Length', "AcquiredSoundpathLength", 0x0014, 0x4031)
    AcquisitionCompressionType = Tag('Acquisition Compression Type', "AcquisitionCompressionType", 0x0014, 0x4032)
    AcquisitionSampleSize = Tag('Acquisition Sample Size', "AcquisitionSampleSize", 0x0014, 0x4033)
    RectifierSmoothing = Tag('Rectifier Smoothing', "RectifierSmoothing", 0x0014, 0x4034)
    DACSequence = Tag('DAC Sequence', "DACSequence", 0x0014, 0x4035)
    DACType = Tag('DAC Type', "DACType", 0x0014, 0x4036)
    DACGainPoints = Tag('DAC Gain Points', "DACGainPoints", 0x0014, 0x4038)
    DACTimePoints = Tag('DAC Time Points', "DACTimePoints", 0x0014, 0x403A)
    DACAmplitude = Tag('DAC Amplitude', "DACAmplitude", 0x0014, 0x403C)
    PreAmplifierSettingsSequence = Tag('Pre-Amplifier Settings Sequence', "PreAmplifierSettingsSequence", 0x0014, 0x4040)
    TransmitTransducerSettingsSequence = Tag('Transmit Transducer Settings Sequence', "TransmitTransducerSettingsSequence", 0x0014, 0x4050)
    ReceiveTransducerSettingsSequence = Tag('Receive Transducer Settings Sequence', "ReceiveTransducerSettingsSequence", 0x0014, 0x4051)
    IncidentAngle = Tag('Incident Angle', "IncidentAngle", 0x0014, 0x4052)
    CouplingTechnique = Tag('Coupling Technique', "CouplingTechnique", 0x0014, 0x4054)
    CouplingMedium = Tag('Coupling Medium', "CouplingMedium", 0x0014, 0x4056)
    CouplingVelocity = Tag('Coupling Velocity', "CouplingVelocity", 0x0014, 0x4057)
    ProbeCenterLocationX = Tag('Probe Center Location X', "ProbeCenterLocationX", 0x0014, 0x4058)
    ProbeCenterLocationZ = Tag('Probe Center Location Z', "ProbeCenterLocationZ", 0x0014, 0x4059)
    SoundPathLength = Tag('Sound Path Length', "SoundPathLength", 0x0014, 0x405A)
    DelayLawIdentifier = Tag('Delay Law Identifier', "DelayLawIdentifier", 0x0014, 0x405C)
    GateSettingsSequence = Tag('Gate Settings Sequence', "GateSettingsSequence", 0x0014, 0x4060)
    GateThreshold = Tag('Gate Threshold', "GateThreshold", 0x0014, 0x4062)
    VelocityOfSound = Tag('Velocity of Sound', "VelocityOfSound", 0x0014, 0x4064)
    CalibrationSettingsSequence = Tag('Calibration Settings Sequence', "CalibrationSettingsSequence", 0x0014, 0x4070)
    CalibrationProcedure = Tag('Calibration Procedure', "CalibrationProcedure", 0x0014, 0x4072)
    ProcedureVersion = Tag('Procedure Version', "ProcedureVersion", 0x0014, 0x4074)
    ProcedureCreationDate = Tag('Procedure Creation Date', "ProcedureCreationDate", 0x0014, 0x4076)
    ProcedureExpirationDate = Tag('Procedure Expiration Date', "ProcedureExpirationDate", 0x0014, 0x4078)
    ProcedureLastModifiedDate = Tag('Procedure Last Modified Date', "ProcedureLastModifiedDate", 0x0014, 0x407A)
    CalibrationTime = Tag('Calibration Time', "CalibrationTime", 0x0014, 0x407C)
    CalibrationDate = Tag('Calibration Date', "CalibrationDate", 0x0014, 0x407E)
    ProbeDriveEquipmentSequence = Tag('Probe Drive Equipment Sequence', "ProbeDriveEquipmentSequence", 0x0014, 0x4080)
    DriveType = Tag('Drive Type', "DriveType", 0x0014, 0x4081)
    ProbeDriveNotes = Tag('Probe Drive Notes', "ProbeDriveNotes", 0x0014, 0x4082)
    DriveProbeSequence = Tag('Drive Probe Sequence', "DriveProbeSequence", 0x0014, 0x4083)
    ProbeInductance = Tag('Probe Inductance', "ProbeInductance", 0x0014, 0x4084)
    ProbeResistance = Tag('Probe Resistance', "ProbeResistance", 0x0014, 0x4085)
    ReceiveProbeSequence = Tag('Receive Probe Sequence', "ReceiveProbeSequence", 0x0014, 0x4086)
    ProbeDriveSettingsSequence = Tag('Probe Drive Settings Sequence', "ProbeDriveSettingsSequence", 0x0014, 0x4087)
    BridgeResistors = Tag('Bridge Resistors', "BridgeResistors", 0x0014, 0x4088)
    ProbeOrientationAngle = Tag('Probe Orientation Angle', "ProbeOrientationAngle", 0x0014, 0x4089)
    UserSelectedGainY = Tag('User Selected Gain Y', "UserSelectedGainY", 0x0014, 0x408B)
    UserSelectedPhase = Tag('User Selected Phase', "UserSelectedPhase", 0x0014, 0x408C)
    UserSelectedOffsetX = Tag('User Selected Offset X', "UserSelectedOffsetX", 0x0014, 0x408D)
    UserSelectedOffsetY = Tag('User Selected Offset Y', "UserSelectedOffsetY", 0x0014, 0x408E)
    ChannelSettingsSequence = Tag('Channel Settings Sequence', "ChannelSettingsSequence", 0x0014, 0x4091)
    ChannelThreshold = Tag('Channel Threshold', "ChannelThreshold", 0x0014, 0x4092)
    ScannerSettingsSequence = Tag('Scanner Settings Sequence', "ScannerSettingsSequence", 0x0014, 0x409A)
    ScanProcedure = Tag('Scan Procedure', "ScanProcedure", 0x0014, 0x409B)
    TranslationRateX = Tag('Translation Rate X', "TranslationRateX", 0x0014, 0x409C)
    TranslationRateY = Tag('Translation Rate Y', "TranslationRateY", 0x0014, 0x409D)
    ChannelOverlap = Tag('Channel Overlap', "ChannelOverlap", 0x0014, 0x409F)
    ImageQualityIndicatorType = Tag('Image Quality Indicator Type', "ImageQualityIndicatorType", 0x0014, 0x40A0)
    ImageQualityIndicatorMaterial = Tag('Image Quality Indicator Material', "ImageQualityIndicatorMaterial", 0x0014, 0x40A1)
    ImageQualityIndicatorSize = Tag('Image Quality Indicator Size', "ImageQualityIndicatorSize", 0x0014, 0x40A2)
    LINACEnergy = Tag('LINAC Energy', "LINACEnergy", 0x0014, 0x5002)
    LINACOutput = Tag('LINAC Output', "LINACOutput", 0x0014, 0x5004)
    ActiveAperture = Tag('Active Aperture', "ActiveAperture", 0x0014, 0x5100)
    TotalAperture = Tag('Total Aperture', "TotalAperture", 0x0014, 0x5101)
    ApertureElevation = Tag('Aperture Elevation', "ApertureElevation", 0x0014, 0x5102)
    MainLobeAngle = Tag('Main Lobe Angle', "MainLobeAngle", 0x0014, 0x5103)
    MainRoofAngle = Tag('Main Roof Angle', "MainRoofAngle", 0x0014, 0x5104)
    ConnectorType = Tag('Connector Type', "ConnectorType", 0x0014, 0x5105)
    WedgeModelNumber = Tag('Wedge Model Number', "WedgeModelNumber", 0x0014, 0x5106)
    WedgeAngleFloat = Tag('Wedge Angle Float', "WedgeAngleFloat", 0x0014, 0x5107)
    WedgeRoofAngle = Tag('Wedge Roof Angle', "WedgeRoofAngle", 0x0014, 0x5108)
    WedgeElement1Position = Tag('Wedge Element 1 Position', "WedgeElement1Position", 0x0014, 0x5109)
    WedgeMaterialVelocity = Tag('Wedge Material Velocity', "WedgeMaterialVelocity", 0x0014, 0x510A)
    WedgeMaterial = Tag('Wedge Material', "WedgeMaterial", 0x0014, 0x510B)
    WedgeOffsetZ = Tag('Wedge Offset Z', "WedgeOffsetZ", 0x0014, 0x510C)
    WedgeOriginOffsetX = Tag('Wedge Origin Offset X', "WedgeOriginOffsetX", 0x0014, 0x510D)
    WedgeTimeDelay = Tag('Wedge Time Delay', "WedgeTimeDelay", 0x0014, 0x510E)
    WedgeName = Tag('Wedge Name', "WedgeName", 0x0014, 0x510F)
    WedgeManufacturerName = Tag('Wedge Manufacturer Name', "WedgeManufacturerName", 0x0014, 0x5110)
    WedgeDescription = Tag('Wedge Description', "WedgeDescription", 0x0014, 0x5111)
    NominalBeamAngle = Tag('Nominal Beam Angle', "NominalBeamAngle", 0x0014, 0x5112)
    WedgeOffsetX = Tag('Wedge Offset X', "WedgeOffsetX", 0x0014, 0x5113)
    WedgeOffsetY = Tag('Wedge Offset Y', "WedgeOffsetY", 0x0014, 0x5114)
    WedgeTotalLength = Tag('Wedge Total Length', "WedgeTotalLength", 0x0014, 0x5115)
    WedgeInContactLength = Tag('Wedge In Contact Length', "WedgeInContactLength", 0x0014, 0x5116)
    WedgeFrontGap = Tag('Wedge Front Gap', "WedgeFrontGap", 0x0014, 0x5117)
    WedgeTotalHeight = Tag('Wedge Total Height', "WedgeTotalHeight", 0x0014, 0x5118)
    WedgeFrontHeight = Tag('Wedge Front Height', "WedgeFrontHeight", 0x0014, 0x5119)
    WedgeRearHeight = Tag('Wedge Rear Height', "WedgeRearHeight", 0x0014, 0x511A)
    WedgeTotalWidth = Tag('Wedge Total Width', "WedgeTotalWidth", 0x0014, 0x511B)
    WedgeInContactWidth = Tag('Wedge In Contact Width', "WedgeInContactWidth", 0x0014, 0x511C)
    WedgeChamferHeight = Tag('Wedge Chamfer Height', "WedgeChamferHeight", 0x0014, 0x511D)
    WedgeCurve = Tag('Wedge Curve', "WedgeCurve", 0x0014, 0x511E)
    RadiusAlongWedge = Tag('Radius Along the Wedge', "RadiusAlongWedge", 0x0014, 0x511F)
    ThermalCameraSettingsSequence = Tag('Thermal Camera Settings Sequence', "ThermalCameraSettingsSequence", 0x0014, 0x6001)
    AcquisitionFrameRate = Tag('Acquisition Frame Rate', "AcquisitionFrameRate", 0x0014, 0x6002)
    IntegrationTime = Tag('Integration Time', "IntegrationTime", 0x0014, 0x6003)
    NumberOfCalibrationFrames = Tag('Number of Calibration Frames', "NumberOfCalibrationFrames", 0x0014, 0x6004)
    NumberOfRowsInFullAcquisitionImage = Tag('Number of Rows in Full Acquisition Image', "NumberOfRowsInFullAcquisitionImage", 0x0014, 0x6005)
    NumberOfColumnsInFullAcquisitionImage = Tag('Number Of Columns in Full Acquisition Image', "NumberOfColumnsInFullAcquisitionImage", 0x0014, 0x6006)
    ThermalSourceSettingsSequence = Tag('Thermal Source Settings Sequence', "ThermalSourceSettingsSequence", 0x0014, 0x6007)
    SourceHorizontalPitch = Tag('Source Horizontal Pitch', "SourceHorizontalPitch", 0x0014, 0x6008)
    SourceVerticalPitch = Tag('Source Vertical Pitch', "SourceVerticalPitch", 0x0014, 0x6009)
    SourceHorizontalScanSpeed = Tag('Source Horizontal Scan Speed', "SourceHorizontalScanSpeed", 0x0014, 0x600A)
    ThermalSourceModulationFrequency = Tag('Thermal Source Modulation Frequency', "ThermalSourceModulationFrequency", 0x0014, 0x600B)
    InductionSourceSettingSequence = Tag('Induction Source Setting Sequence', "InductionSourceSettingSequence", 0x0014, 0x600C)
    CoilFrequency = Tag('Coil Frequency', "CoilFrequency", 0x0014, 0x600D)
    CurrentAmplitudeAcrossCoil = Tag('Current Amplitude Across Coil', "CurrentAmplitudeAcrossCoil", 0x0014, 0x600E)
    FlashSourceSettingSequence = Tag('Flash Source Setting Sequence', "FlashSourceSettingSequence", 0x0014, 0x600F)
    FlashDuration = Tag('Flash Duration', "FlashDuration", 0x0014, 0x6010)
    FlashFrameNumber = Tag('Flash Frame Number', "FlashFrameNumber", 0x0014, 0x6011)
    LaserSourceSettingSequence = Tag('Laser Source Setting Sequence', "LaserSourceSettingSequence", 0x0014, 0x6012)
    HorizontalLaserSpotDimension = Tag('Horizontal Laser Spot Dimension', "HorizontalLaserSpotDimension", 0x0014, 0x6013)
    VerticalLaserSpotDimension = Tag('Vertical Laser Spot Dimension', "VerticalLaserSpotDimension", 0x0014, 0x6014)
    LaserWavelength = Tag('Laser Wavelength', "LaserWavelength", 0x0014, 0x6015)
    LaserPower = Tag('Laser Power', "LaserPower", 0x0014, 0x6016)
    ForcedGasSettingSequence = Tag('Forced Gas Setting Sequence', "ForcedGasSettingSequence", 0x0014, 0x6017)
    VibrationSourceSettingSequence = Tag('Vibration Source Setting Sequence', "VibrationSourceSettingSequence", 0x0014, 0x6018)
    VibrationExcitationFrequency = Tag('Vibration Excitation Frequency', "VibrationExcitationFrequency", 0x0014, 0x6019)
    VibrationExcitationVoltage = Tag('Vibration Excitation Voltage', "VibrationExcitationVoltage", 0x0014, 0x601A)
    ThermographyDataCaptureMethod = Tag('Thermography Data Capture Method', "ThermographyDataCaptureMethod", 0x0014, 0x601B)
    ThermalTechnique = Tag('Thermal Technique', "ThermalTechnique", 0x0014, 0x601C)
    ThermalCameraCoreSequence = Tag('Thermal Camera Core Sequence', "ThermalCameraCoreSequence", 0x0014, 0x601D)
    DetectorWavelengthRange = Tag('Detector Wavelength Range', "DetectorWavelengthRange", 0x0014, 0x601E)
    ThermalCameraCalibrationType = Tag('Thermal Camera Calibration Type', "ThermalCameraCalibrationType", 0x0014, 0x601F)
    AcquisitionImageCounter = Tag('Acquisition Image Counter', "AcquisitionImageCounter", 0x0014, 0x6020)
    FrontPanelTemperature = Tag('Front Panel Temperature', "FrontPanelTemperature", 0x0014, 0x6021)
    AirGapTemperature = Tag('Air Gap Temperature', "AirGapTemperature", 0x0014, 0x6022)
    VerticalPixelSize = Tag('Vertical Pixel Size', "VerticalPixelSize", 0x0014, 0x6023)
    HorizontalPixelSize = Tag('Horizontal Pixel Size', "HorizontalPixelSize", 0x0014, 0x6024)
    DataStreamingProtocol = Tag('Data Streaming Protocol', "DataStreamingProtocol", 0x0014, 0x6025)
    LensSequence = Tag('Lens Sequence', "LensSequence", 0x0014, 0x6026)
    FieldOfView = Tag('Field of View', "FieldOfView", 0x0014, 0x6027)
    LensFilterManufacturer = Tag('Lens Filter Manufacturer', "LensFilterManufacturer", 0x0014, 0x6028)
    CutoffFilterType = Tag('Cutoff Filter Type', "CutoffFilterType", 0x0014, 0x6029)
    LensFilterCutOffWavelength = Tag('Lens Filter Cut-Off Wavelength', "LensFilterCutOffWavelength", 0x0014, 0x602A)
    ThermalSourceSequence = Tag('Thermal Source Sequence', "ThermalSourceSequence", 0x0014, 0x602B)
    ThermalSourceMotionState = Tag('Thermal Source Motion State', "ThermalSourceMotionState", 0x0014, 0x602C)
    ThermalSourceMotionType = Tag('Thermal Source Motion Type', "ThermalSourceMotionType", 0x0014, 0x602D)
    InductionHeatingSequence = Tag('Induction Heating Sequence', "InductionHeatingSequence", 0x0014, 0x602E)
    CoilConfigurationID = Tag('Coil Configuration ID', "CoilConfigurationID", 0x0014, 0x602F)
    NumberOfTurnsInCoil = Tag('Number of Turns in Coil', "NumberOfTurnsInCoil", 0x0014, 0x6030)
    ShapeOfIndividualTurn = Tag('Shape of Individual Turn', "ShapeOfIndividualTurn", 0x0014, 0x6031)
    SizeOfIndividualTurn = Tag('Size of Individual Turn', "SizeOfIndividualTurn", 0x0014, 0x6032)
    DistanceBetweenTurns = Tag('Distance Between Turns', "DistanceBetweenTurns", 0x0014, 0x6033)
    FlashHeatingSequence = Tag('Flash Heating Sequence', "FlashHeatingSequence", 0x0014, 0x6034)
    NumberOfLamps = Tag('Number of Lamps', "NumberOfLamps", 0x0014, 0x6035)
    FlashSynchronizationProtocol = Tag('Flash Synchronization Protocol', "FlashSynchronizationProtocol", 0x0014, 0x6036)
    FlashModificationStatus = Tag('Flash Modification Status', "FlashModificationStatus", 0x0014, 0x6037)
    LaserHeatingSequence = Tag('Laser Heating Sequence', "LaserHeatingSequence", 0x0014, 0x6038)
    LaserManufacturer = Tag('Laser Manufacturer', "LaserManufacturer", 0x0014, 0x6039)
    LaserModelNumber = Tag('Laser Model Number', "LaserModelNumber", 0x0014, 0x603A)
    LaserTypeDescription = Tag('Laser Type Description', "LaserTypeDescription", 0x0014, 0x603B)
    ForcedGasHeatingSequence = Tag('Forced Gas Heating Sequence', "ForcedGasHeatingSequence", 0x0014, 0x603C)
    GasUsedForHeatingCoolingPart = Tag('Gas Used for Heating/Cooling Part', "GasUsedForHeatingCoolingPart", 0x0014, 0x603D)
    VibrationSonicHeatingSequence = Tag('Vibration/Sonic Heating Sequence', "VibrationSonicHeatingSequence", 0x0014, 0x603E)
    ProbeManufacturer = Tag('Probe Manufacturer', "ProbeManufacturer", 0x0014, 0x603F)
    ProbeModelNumber = Tag('Probe Model Number', "ProbeModelNumber", 0x0014, 0x6040)
    ApertureSize = Tag('Aperture Size', "ApertureSize", 0x0014, 0x6041)
    ProbeResonantFrequency = Tag('Probe Resonant Frequency', "ProbeResonantFrequency", 0x0014, 0x6042)
    HeatSourceDescription = Tag('Heat Source Description', "HeatSourceDescription", 0x0014, 0x6043)
    SurfacePreparationWithOpticalCoating = Tag('Surface Preparation with Optical Coating', "SurfacePreparationWithOpticalCoating", 0x0014, 0x6044)
    OpticalCoatingType = Tag('Optical Coating Type', "OpticalCoatingType", 0x0014, 0x6045)
    ThermalConductivityOfExposedSurface = Tag('Thermal Conductivity of Exposed Surface', "ThermalConductivityOfExposedSurface", 0x0014, 0x6046)
    RangeShifterSequence = Tag('Range Shifter Sequence', "RangeShifterSequence", 0x300A, 0x0314, [TagLink(IonBeamSequence),])
    MaterialDensity = Tag('Material Density', "MaterialDensity", 0x0014, 0x6047, [TagLink(RangeShifterSequence),])
    SpecificHeatOfInspectionSurface = Tag('Specific Heat of Inspection Surface', "SpecificHeatOfInspectionSurface", 0x0014, 0x6048)
    EmissivityOfInspectionSurface = Tag('Emissivity of Inspection Surface', "EmissivityOfInspectionSurface", 0x0014, 0x6049)
    ElectromagneticClassificationOfInspectionSurface = Tag('Electromagnetic Classification of Inspection Surface', "ElectromagneticClassificationOfInspectionSurface", 0x0014, 0x604A)
    MovingWindowSize = Tag('Moving Window Size', "MovingWindowSize", 0x0014, 0x604C)
    MovingWindowType = Tag('Moving Window Type', "MovingWindowType", 0x0014, 0x604D)
    MovingWindowWeights = Tag('Moving Window Weights', "MovingWindowWeights", 0x0014, 0x604E)
    MovingWindowPitch = Tag('Moving Window Pitch', "MovingWindowPitch", 0x0014, 0x604F)
    MovingWindowPaddingScheme = Tag('Moving Window Padding Scheme', "MovingWindowPaddingScheme", 0x0014, 0x6050)
    MovingWindowPaddingLength = Tag('Moving Window Padding Sength', "MovingWindowPaddingLength", 0x0014, 0x6051)
    SpatialFilteringParametersSequence = Tag('Spatial Filtering Parameters Sequence', "SpatialFilteringParametersSequence", 0x0014, 0x6052)
    SpatialFilteringScheme = Tag('Spatial Filtering Scheme', "SpatialFilteringScheme", 0x0014, 0x6053)
    HorizontalMovingWindowSize = Tag('Horizontal Moving Window Size', "HorizontalMovingWindowSize", 0x0014, 0x6056)
    VerticalMovingWindowSize = Tag('Vertical Moving Window Size', "VerticalMovingWindowSize", 0x0014, 0x6057)
    PolynomialFittingSequence = Tag('Polynomial Fitting Sequence', "PolynomialFittingSequence", 0x0014, 0x6059)
    FittingDataType = Tag('Fitting Data Type', "FittingDataType", 0x0014, 0x605A)
    OperationOnTimeAxisBeforeFitting = Tag('Operation on Time Axis Before Fitting', "OperationOnTimeAxisBeforeFitting", 0x0014, 0x605B)
    OperationOnPixelIntensityBeforeFitting = Tag('Operation on Pixel Intensity Before Fitting', "OperationOnPixelIntensityBeforeFitting", 0x0014, 0x605C)
    OrderOfPolynomial = Tag('Order of Polynomial', "OrderOfPolynomial", 0x0014, 0x605D)
    IndependentVariableForPolynomialFit = Tag('Independent Variable for Polynomial Fit', "IndependentVariableForPolynomialFit", 0x0014, 0x605E)
    PolynomialCoefficients = Tag('Polynomial Coefficients', "PolynomialCoefficients", 0x0014, 0x605F)
    ThermographyPixelDataUnit = Tag('Thermography Pixel Data Unit', "ThermographyPixelDataUnit", 0x0014, 0x6060)
    WhitePoint = Tag('White Point', "WhitePoint", 0x0016, 0x0001)
    PrimaryChromaticities = Tag('Primary Chromaticities', "PrimaryChromaticities", 0x0016, 0x0002)
    BatteryLevel = Tag('Battery Level', "BatteryLevel", 0x0016, 0x0003)
    ExposureTimeInSeconds = Tag('Exposure Time in Seconds', "ExposureTimeInSeconds", 0x0016, 0x0004)
    FNumber = Tag('F-Number', "FNumber", 0x0016, 0x0005)
    OECFRows = Tag('OECF Rows', "OECFRows", 0x0016, 0x0006)
    OECFColumns = Tag('OECF Columns', "OECFColumns", 0x0016, 0x0007)
    OECFColumnNames = Tag('OECF Column Names', "OECFColumnNames", 0x0016, 0x0008)
    OECFValues = Tag('OECF Values', "OECFValues", 0x0016, 0x0009)
    SpatialFrequencyResponseRows = Tag('Spatial Frequency Response Rows', "SpatialFrequencyResponseRows", 0x0016, 0x000A)
    SpatialFrequencyResponseColumns = Tag('Spatial Frequency Response Columns', "SpatialFrequencyResponseColumns", 0x0016, 0x000B)
    SpatialFrequencyResponseColumnNames = Tag('Spatial Frequency Response Column Names', "SpatialFrequencyResponseColumnNames", 0x0016, 0x000C)
    SpatialFrequencyResponseValues = Tag('Spatial Frequency Response Values', "SpatialFrequencyResponseValues", 0x0016, 0x000D)
    ColorFilterArrayPatternRows = Tag('Color Filter Array Pattern Rows', "ColorFilterArrayPatternRows", 0x0016, 0x000E)
    ColorFilterArrayPatternColumns = Tag('Color Filter Array Pattern Columns', "ColorFilterArrayPatternColumns", 0x0016, 0x000F)
    ColorFilterArrayPatternValues = Tag('Color Filter Array Pattern Values', "ColorFilterArrayPatternValues", 0x0016, 0x0010)
    FlashFiringStatus = Tag('Flash Firing Status', "FlashFiringStatus", 0x0016, 0x0011)
    FlashReturnStatus = Tag('Flash Return Status', "FlashReturnStatus", 0x0016, 0x0012)
    FlashMode = Tag('Flash Mode', "FlashMode", 0x0016, 0x0013)
    FlashFunctionPresent = Tag('Flash Function Present', "FlashFunctionPresent", 0x0016, 0x0014)
    FlashRedEyeMode = Tag('Flash Red Eye Mode', "FlashRedEyeMode", 0x0016, 0x0015)
    ExposureProgram = Tag('Exposure Program', "ExposureProgram", 0x0016, 0x0016)
    SpectralSensitivity = Tag('Spectral Sensitivity', "SpectralSensitivity", 0x0016, 0x0017)
    PhotographicSensitivity = Tag('Photographic Sensitivity', "PhotographicSensitivity", 0x0016, 0x0018)
    SelfTimerMode = Tag('Self Timer Mode', "SelfTimerMode", 0x0016, 0x0019)
    SensitivityType = Tag('Sensitivity Type', "SensitivityType", 0x0016, 0x001A)
    StandardOutputSensitivity = Tag('Standard Output Sensitivity', "StandardOutputSensitivity", 0x0016, 0x001B)
    RecommendedExposureIndex = Tag('Recommended Exposure Index', "RecommendedExposureIndex", 0x0016, 0x001C)
    ISOSpeed = Tag('ISO Speed', "ISOSpeed", 0x0016, 0x001D)
    ISOSpeedLatitudeyyy = Tag('ISO Speed Latitude yyy', "ISOSpeedLatitudeyyy", 0x0016, 0x001E)
    ISOSpeedLatitudezzz = Tag('ISO Speed Latitude zzz', "ISOSpeedLatitudezzz", 0x0016, 0x001F)
    EXIFVersion = Tag('EXIF Version', "EXIFVersion", 0x0016, 0x0020)
    ShutterSpeedValue = Tag('Shutter Speed Value', "ShutterSpeedValue", 0x0016, 0x0021)
    ApertureValue = Tag('Aperture Value', "ApertureValue", 0x0016, 0x0022)
    BrightnessValue = Tag('Brightness Value', "BrightnessValue", 0x0016, 0x0023)
    ExposureBiasValue = Tag('Exposure Bias Value', "ExposureBiasValue", 0x0016, 0x0024)
    MaxApertureValue = Tag('Max Aperture Value', "MaxApertureValue", 0x0016, 0x0025)
    SubjectDistance = Tag('Subject Distance', "SubjectDistance", 0x0016, 0x0026)
    MeteringMode = Tag('Metering Mode', "MeteringMode", 0x0016, 0x0027)
    LightSource = Tag('Light Source', "LightSource", 0x0016, 0x0028)
    FocalLength = Tag('Focal Length', "FocalLength", 0x0016, 0x0029)
    SubjectArea = Tag('Subject Area', "SubjectArea", 0x0016, 0x002A)
    MakerNote = Tag('Maker Note', "MakerNote", 0x0016, 0x002B)
    Temperature = Tag('Temperature', "Temperature", 0x0016, 0x0030)
    Humidity = Tag('Humidity', "Humidity", 0x0016, 0x0031)
    Pressure = Tag('Pressure', "Pressure", 0x0016, 0x0032)
    WaterDepth = Tag('Water Depth', "WaterDepth", 0x0016, 0x0033)
    Acceleration = Tag('Acceleration', "Acceleration", 0x0016, 0x0034)
    CameraElevationAngle = Tag('Camera Elevation Angle', "CameraElevationAngle", 0x0016, 0x0035)
    FlashEnergy = Tag('Flash Energy', "FlashEnergy", 0x0016, 0x0036)
    SubjectLocation = Tag('Subject Location', "SubjectLocation", 0x0016, 0x0037)
    PhotographicExposureIndex = Tag('Photographic Exposure Index', "PhotographicExposureIndex", 0x0016, 0x0038)
    SensingMethod = Tag('Sensing Method', "SensingMethod", 0x0016, 0x0039)
    FileSource = Tag('File Source', "FileSource", 0x0016, 0x003A)
    SceneType = Tag('Scene Type', "SceneType", 0x0016, 0x003B)
    CustomRendered = Tag('Custom Rendered', "CustomRendered", 0x0016, 0x0041)
    ExposureMode = Tag('Exposure Mode', "ExposureMode", 0x0016, 0x0042)
    WhiteBalance = Tag('White Balance', "WhiteBalance", 0x0016, 0x0043)
    DigitalZoomRatio = Tag('Digital Zoom Ratio', "DigitalZoomRatio", 0x0016, 0x0044)
    FocalLengthIn35mmFilm = Tag('Focal Length In 35mm Film', "FocalLengthIn35mmFilm", 0x0016, 0x0045)
    SceneCaptureType = Tag('Scene Capture Type', "SceneCaptureType", 0x0016, 0x0046)
    GainControl = Tag('Gain Control', "GainControl", 0x0016, 0x0047)
    Contrast = Tag('Contrast', "Contrast", 0x0016, 0x0048)
    Saturation = Tag('Saturation', "Saturation", 0x0016, 0x0049)
    Sharpness = Tag('Sharpness', "Sharpness", 0x0016, 0x004A)
    DeviceSettingDescription = Tag('Device Setting Description', "DeviceSettingDescription", 0x0016, 0x004B)
    SubjectDistanceRange = Tag('Subject Distance Range', "SubjectDistanceRange", 0x0016, 0x004C)
    CameraOwnerName = Tag('Camera Owner Name', "CameraOwnerName", 0x0016, 0x004D)
    LensSpecification = Tag('Lens Specification', "LensSpecification", 0x0016, 0x004E)
    LensMake = Tag('Lens Make', "LensMake", 0x0016, 0x004F)
    LensModel = Tag('Lens Model', "LensModel", 0x0016, 0x0050)
    LensSerialNumber = Tag('Lens Serial Number', "LensSerialNumber", 0x0016, 0x0051)
    InteroperabilityIndex = Tag('Interoperability Index', "InteroperabilityIndex", 0x0016, 0x0061)
    InteroperabilityVersion = Tag('Interoperability Version', "InteroperabilityVersion", 0x0016, 0x0062)
    GPSVersionID = Tag('GPS Version ID', "GPSVersionID", 0x0016, 0x0070)
    GPSLatitudeRef = Tag('GPS Latitude Ref', "GPSLatitudeRef", 0x0016, 0x0071)
    GPSLatitude = Tag('GPS Latitude', "GPSLatitude", 0x0016, 0x0072)
    GPSLongitudeRef = Tag('GPS Longitude Ref', "GPSLongitudeRef", 0x0016, 0x0073)
    GPSLongitude = Tag('GPS Longitude', "GPSLongitude", 0x0016, 0x0074)
    GPSAltitudeRef = Tag('GPS Altitude Ref', "GPSAltitudeRef", 0x0016, 0x0075)
    GPSAltitude = Tag('GPS Altitude', "GPSAltitude", 0x0016, 0x0076)
    GPSTimeStamp = Tag('GPS Time Stamp', "GPSTimeStamp", 0x0016, 0x0077)
    GPSSatellites = Tag('GPS Satellites', "GPSSatellites", 0x0016, 0x0078)
    GPSStatus = Tag('GPS Status', "GPSStatus", 0x0016, 0x0079)
    GPSMeasureMode = Tag('GPS Measure Mode', "GPSMeasureMode", 0x0016, 0x007A)
    GPSDOP = Tag('GPS DOP', "GPSDOP", 0x0016, 0x007B)
    GPSSpeedRef = Tag('GPS Speed Ref', "GPSSpeedRef", 0x0016, 0x007C)
    GPSSpeed = Tag('GPS Speed', "GPSSpeed", 0x0016, 0x007D)
    GPSTrackRef = Tag('GPS Track Ref', "GPSTrackRef", 0x0016, 0x007E)
    GPSTrack = Tag('GPS Track', "GPSTrack", 0x0016, 0x007F)
    GPSImgDirectionRef = Tag('GPS Img Direction Ref', "GPSImgDirectionRef", 0x0016, 0x0080)
    GPSImgDirection = Tag('GPS Img Direction', "GPSImgDirection", 0x0016, 0x0081)
    GPSMapDatum = Tag('GPS Map Datum', "GPSMapDatum", 0x0016, 0x0082)
    GPSDestLatitudeRef = Tag('GPS Dest Latitude Ref', "GPSDestLatitudeRef", 0x0016, 0x0083)
    GPSDestLatitude = Tag('GPS Dest Latitude', "GPSDestLatitude", 0x0016, 0x0084)
    GPSDestLongitudeRef = Tag('GPS Dest Longitude Ref', "GPSDestLongitudeRef", 0x0016, 0x0085)
    GPSDestLongitude = Tag('GPS Dest Longitude', "GPSDestLongitude", 0x0016, 0x0086)
    GPSDestBearingRef = Tag('GPS Dest Bearing Ref', "GPSDestBearingRef", 0x0016, 0x0087)
    GPSDestBearing = Tag('GPS Dest Bearing', "GPSDestBearing", 0x0016, 0x0088)
    GPSDestDistanceRef = Tag('GPS Dest Distance Ref', "GPSDestDistanceRef", 0x0016, 0x0089)
    GPSDestDistance = Tag('GPS Dest Distance', "GPSDestDistance", 0x0016, 0x008A)
    GPSProcessingMethod = Tag('GPS Processing Method', "GPSProcessingMethod", 0x0016, 0x008B)
    GPSAreaInformation = Tag('GPS Area Information', "GPSAreaInformation", 0x0016, 0x008C)
    GPSDateStamp = Tag('GPS Date Stamp', "GPSDateStamp", 0x0016, 0x008D)
    GPSDifferential = Tag('GPS Differential', "GPSDifferential", 0x0016, 0x008E)
    LightSourcePolarization = Tag('Light Source Polarization', "LightSourcePolarization", 0x0016, 0x1001)
    EmitterColorTemperature = Tag('Emitter Color Temperature', "EmitterColorTemperature", 0x0016, 0x1002)
    ContactMethod = Tag('Contact Method', "ContactMethod", 0x0016, 0x1003)
    ImmersionMedia = Tag('Immersion Media', "ImmersionMedia", 0x0016, 0x1004)
    OpticalMagnificationFactor = Tag('Optical Magnification Factor', "OpticalMagnificationFactor", 0x0016, 0x1005)
    ContrastBolusAgent = Tag('Contrast/Bolus Agent', "ContrastBolusAgent", 0x0018, 0x0010, [TagLink(XRay3DAcquisitionSequence),])
    ContrastBolusT1Relaxivity = Tag('Contrast/Bolus T1 Relaxivity', "ContrastBolusT1Relaxivity", 0x0018, 0x0013, [TagLink(ContrastBolusAgentSequence),])
    BodyPartExamined = Tag('Body Part Examined', "BodyPartExamined", 0x0018, 0x0015, [TagLink(InventoriedSeriesSequence),])
    ScanningSequence = Tag('Scanning Sequence', "ScanningSequence", 0x0018, 0x0020)
    SequenceVariant = Tag('Sequence Variant', "SequenceVariant", 0x0018, 0x0021)
    ScanOptions = Tag('Scan Options', "ScanOptions", 0x0018, 0x0022, [TagLink(AcquisitionProtocolElementSequence),])
    MRAcquisitionType = Tag('MR Acquisition Type', "MRAcquisitionType", 0x0018, 0x0023)
    SequenceName = Tag('Sequence Name', "SequenceName", 0x0018, 0x0024)
    AngioFlag = Tag('Angio Flag', "AngioFlag", 0x0018, 0x0025)
    InterventionDrugStopTime = Tag('Intervention Drug Stop Time', "InterventionDrugStopTime", 0x0018, 0x0027, [TagLink(InterventionSequence),TagLink(InterventionDrugInformationSequence),])
    InterventionDrugDose = Tag('Intervention Drug Dose', "InterventionDrugDose", 0x0018, 0x0028, [TagLink(InterventionDrugInformationSequence),])
    Radionuclide = Tag('Radionuclide', "Radionuclide", 0x0018, 0x0030)
    Radiopharmaceutical = Tag('Radiopharmaceutical', "Radiopharmaceutical", 0x0018, 0x0031, [TagLink(RadiopharmaceuticalInformationSequence),])
    EnergyWindowCenterline = Tag('Energy Window Centerline', "EnergyWindowCenterline", 0x0018, 0x0032)
    EnergyWindowTotalWidth = Tag('Energy Window Total Width', "EnergyWindowTotalWidth", 0x0018, 0x0033)
    InterventionDrugName = Tag('Intervention Drug Name', "InterventionDrugName", 0x0018, 0x0034, [TagLink(InterventionDrugInformationSequence),])
    InterventionDrugStartTime = Tag('Intervention Drug Start Time', "InterventionDrugStartTime", 0x0018, 0x0035, [TagLink(InterventionSequence),TagLink(InterventionDrugInformationSequence),])
    TherapyType = Tag('Therapy Type', "TherapyType", 0x0018, 0x0037)
    InterventionStatus = Tag('Intervention Status', "InterventionStatus", 0x0018, 0x0038, [TagLink(InterventionSequence),])
    TherapyDescription = Tag('Therapy Description', "TherapyDescription", 0x0018, 0x0039)
    InterventionDescription = Tag('Intervention Description', "InterventionDescription", 0x0018, 0x003A, [TagLink(InterventionSequence),])
    CineRate = Tag('Cine Rate', "CineRate", 0x0018, 0x0040)
    InitialCineRunState = Tag('Initial Cine Run State', "InitialCineRunState", 0x0018, 0x0042, [TagLink(StructuredDisplayImageBoxSequence),])
    PixelMeasuresSequence = Tag('Pixel Measures Sequence', "PixelMeasuresSequence", 0x0028, 0x9110, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    SliceThickness = Tag('Slice Thickness', "SliceThickness", 0x0018, 0x0050, [TagLink(PixelMeasuresSequence),TagLink(ReconstructionProtocolElementSequence),])
    CTAdditionalXRaySourceSequence = Tag('CT Additional X-Ray Source Sequence', "CTAdditionalXRaySourceSequence", 0x0018, 0x9360, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    IonControlPointSequence = Tag('Ion Control Point Sequence', "IonControlPointSequence", 0x300A, 0x03A8, [TagLink(IonBeamSequence),])
    CTXRayDetailsSequence = Tag('CT X-Ray Details Sequence', "CTXRayDetailsSequence", 0x0018, 0x9325, [TagLink(AcquisitionProtocolElementSequence),TagLink(PerFrameFunctionalGroupsSequence, True),])
    FrameAcquisitionSequence = Tag('Frame Acquisition Sequence', "FrameAcquisitionSequence", 0x0018, 0x9417, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    XAPlaneDetailsSequence = Tag('XA Plane Details Sequence', "XAPlaneDetailsSequence", 0x0018, 0x11BA, [TagLink(AcquisitionProtocolElementSequence),])
    KVP = Tag('KVP', "KVP", 0x0018, 0x0060, [TagLink(CTAdditionalXRaySourceSequence),TagLink(ExposureSequence),TagLink(IonControlPointSequence),TagLink(IonControlPointDeliverySequence),TagLink(CTXRayDetailsSequence),TagLink(FrameAcquisitionSequence),TagLink(XRay3DAcquisitionSequence),TagLink(PerProjectionAcquisitionSequence),TagLink(XAPlaneDetailsSequence),TagLink(RTImageFramekVRadiationAcquisitionSequence),TagLink(KVImagingGenerationParametersSequence),])
    CountsAccumulated = Tag('Counts Accumulated', "CountsAccumulated", 0x0018, 0x0070)
    AcquisitionTerminationCondition = Tag('Acquisition Termination Condition', "AcquisitionTerminationCondition", 0x0018, 0x0071)
    EffectiveDuration = Tag('Effective Duration', "EffectiveDuration", 0x0018, 0x0072)
    AcquisitionStartCondition = Tag('Acquisition Start Condition', "AcquisitionStartCondition", 0x0018, 0x0073)
    AcquisitionStartConditionData = Tag('Acquisition Start Condition Data', "AcquisitionStartConditionData", 0x0018, 0x0074)
    AcquisitionTerminationConditionData = Tag('Acquisition Termination Condition Data', "AcquisitionTerminationConditionData", 0x0018, 0x0075)
    MRTimingAndRelatedParametersSequence = Tag('MR Timing and Related Parameters Sequence', "MRTimingAndRelatedParametersSequence", 0x0018, 0x9112, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    RepetitionTime = Tag('Repetition Time', "RepetitionTime", 0x0018, 0x0080, [TagLink(MRTimingAndRelatedParametersSequence),])
    EchoTime = Tag('Echo Time', "EchoTime", 0x0018, 0x0081)
    InversionTime = Tag('Inversion Time', "InversionTime", 0x0018, 0x0082)
    MRAveragesSequence = Tag('MR Averages Sequence', "MRAveragesSequence", 0x0018, 0x9119, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    NumberOfAverages = Tag('Number of Averages', "NumberOfAverages", 0x0018, 0x0083, [TagLink(MRAveragesSequence),])
    ImagingFrequency = Tag('Imaging Frequency', "ImagingFrequency", 0x0018, 0x0084)
    ImagedNucleus = Tag('Imaged Nucleus', "ImagedNucleus", 0x0018, 0x0085)
    EchoNumbers = Tag('Echo Number(s)', "EchoNumbers", 0x0018, 0x0086)
    MagneticFieldStrength = Tag('Magnetic Field Strength', "MagneticFieldStrength", 0x0018, 0x0087)
    SourcePixelPlanesCharacteristicsSequence = Tag('Source Pixel Planes Characteristics Sequence', "SourcePixelPlanesCharacteristicsSequence", 0x3006, 0x004A, [TagLink(ROIContourSequence),])
    SpacingBetweenSlices = Tag('Spacing Between Slices', "SpacingBetweenSlices", 0x0018, 0x0088, [TagLink(PixelMeasuresSequence),TagLink(SourcePixelPlanesCharacteristicsSequence),TagLink(ReconstructionProtocolElementSequence),])
    NumberOfPhaseEncodingSteps = Tag('Number of Phase Encoding Steps', "NumberOfPhaseEncodingSteps", 0x0018, 0x0089)
    CTAcquisitionDetailsSequence = Tag('CT Acquisition Details Sequence', "CTAcquisitionDetailsSequence", 0x0018, 0x9304, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    PETFrameAcquisitionSequence = Tag('PET Frame Acquisition Sequence', "PETFrameAcquisitionSequence", 0x0018, 0x9732, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    DataCollectionDiameter = Tag('Data Collection Diameter', "DataCollectionDiameter", 0x0018, 0x0090, [TagLink(CTAdditionalXRaySourceSequence),TagLink(CTAcquisitionDetailsSequence),TagLink(PETFrameAcquisitionSequence),TagLink(CTXRayDetailsSequence),])
    EchoTrainLength = Tag('Echo Train Length', "EchoTrainLength", 0x0018, 0x0091, [TagLink(MRTimingAndRelatedParametersSequence),])
    MRFOVGeometrySequence = Tag('MR FOV/Geometry Sequence', "MRFOVGeometrySequence", 0x0018, 0x9125, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    MRSpectroscopyFOVGeometrySequence = Tag('MR Spectroscopy FOV/Geometry Sequence', "MRSpectroscopyFOVGeometrySequence", 0x0018, 0x9103, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    PercentSampling = Tag('Percent Sampling', "PercentSampling", 0x0018, 0x0093, [TagLink(MRFOVGeometrySequence),TagLink(MRSpectroscopyFOVGeometrySequence),])
    PercentPhaseFieldOfView = Tag('Percent Phase Field of View', "PercentPhaseFieldOfView", 0x0018, 0x0094, [TagLink(MRFOVGeometrySequence),TagLink(MRSpectroscopyFOVGeometrySequence),])
    MRImagingModifierSequence = Tag('MR Imaging Modifier Sequence', "MRImagingModifierSequence", 0x0018, 0x9006, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    PixelBandwidth = Tag('Pixel Bandwidth', "PixelBandwidth", 0x0018, 0x0095, [TagLink(MRImagingModifierSequence),])
    DeviceSerialNumber = Tag('Device Serial Number', "DeviceSerialNumber", 0x0018, 0x1000, [TagLink(DeviceSequence),TagLink(TransducerIdentificationSequence),TagLink(BeamSequence),TagLink(TreatmentMachineSequence),TagLink(BeamHoldOriginatingDeviceSequence),TagLink(IonBeamSequence),TagLink(ContributingSourcesSequence),TagLink(ContributingEquipmentSequence),TagLink(AssessmentRequesterSequence),TagLink(ModelSpecificationSequence),TagLink(PatientSupportDevicesSequence),TagLink(WedgeDefinitionSequence),TagLink(CompensatorDefinitionSequence),TagLink(BlockDefinitionSequence),TagLink(RTAccessoryHolderDefinitionSequence),TagLink(GeneralAccessoryDefinitionSequence),TagLink(BolusDefinitionSequence),TagLink(InterlockOriginatingDeviceSequence),TagLink(AcquisitionDeviceSequence),TagLink(PatientTreatmentPreparationDeviceSequence),TagLink(XRayFilterSequence),TagLink(AuthorIdentificationSequence),TagLink(SegmentedRTAccessoryDeviceSequence),TagLink(TreatmentDeviceIdentificationSequence),TagLink(OperatorIdentificationSequence),TagLink(AsserterIdentificationSequence),])
    DeviceUID = Tag('Device UID', "DeviceUID", 0x0018, 0x1002, [TagLink(ContributingEquipmentSequence),TagLink(AssessmentRequesterSequence),TagLink(AuthorIdentificationSequence),TagLink(OperatorIdentificationSequence),TagLink(AsserterIdentificationSequence),])
    DeviceID = Tag('Device ID', "DeviceID", 0x0018, 0x1003, [TagLink(DeviceSequence),])
    PlateID = Tag('Plate ID', "PlateID", 0x0018, 0x1004)
    GeneratorID = Tag('Generator ID', "GeneratorID", 0x0018, 0x1005)
    GridID = Tag('Grid ID', "GridID", 0x0018, 0x1006, [TagLink(XRay3DAcquisitionSequence),TagLink(PerFrameFunctionalGroupsSequence, True),])
    CassetteID = Tag('Cassette ID', "CassetteID", 0x0018, 0x1007)
    GantryID = Tag('Gantry ID', "GantryID", 0x0018, 0x1008)
    UDISequence = Tag('UDI Sequence', "UDISequence", 0x0018, 0x100A, [TagLink(TransducerIdentificationSequence),TagLink(BeamHoldOriginatingDeviceSequence),TagLink(ContributingEquipmentSequence),TagLink(PatientSupportDevicesSequence),TagLink(WedgeDefinitionSequence),TagLink(CompensatorDefinitionSequence),TagLink(BlockDefinitionSequence),TagLink(RTAccessoryHolderDefinitionSequence),TagLink(GeneralAccessoryDefinitionSequence),TagLink(BolusDefinitionSequence),TagLink(InterlockOriginatingDeviceSequence),TagLink(AcquisitionDeviceSequence),TagLink(PatientTreatmentPreparationDeviceSequence),TagLink(XRayFilterSequence),TagLink(SegmentedRTAccessoryDeviceSequence),TagLink(TreatmentDeviceIdentificationSequence),])
    UniqueDeviceIdentifier = Tag('Unique Device Identifier', "UniqueDeviceIdentifier", 0x0018, 0x1009, [TagLink(UDISequence),])
    ManufacturerDeviceClassUID = Tag("Manufacturer's Device Class UID", "ManufacturerDeviceClassUID", 0x0018, 0x100B, [TagLink(TreatmentDeviceIdentificationSequence),])
    SecondaryCaptureDeviceID = Tag('Secondary Capture Device ID', "SecondaryCaptureDeviceID", 0x0018, 0x1010)
    HardcopyCreationDeviceID = Tag('Hardcopy Creation Device ID', "HardcopyCreationDeviceID", 0x0018, 0x1011)
    DateOfSecondaryCapture = Tag('Date of Secondary Capture', "DateOfSecondaryCapture", 0x0018, 0x1012)
    TimeOfSecondaryCapture = Tag('Time of Secondary Capture', "TimeOfSecondaryCapture", 0x0018, 0x1014)
    SecondaryCaptureDeviceManufacturer = Tag('Secondary Capture Device Manufacturer', "SecondaryCaptureDeviceManufacturer", 0x0018, 0x1016)
    HardcopyDeviceManufacturer = Tag('Hardcopy Device Manufacturer', "HardcopyDeviceManufacturer", 0x0018, 0x1017)
    SecondaryCaptureDeviceManufacturerModelName = Tag("Secondary Capture Device Manufacturer's Model Name", "SecondaryCaptureDeviceManufacturerModelName", 0x0018, 0x1018)
    SecondaryCaptureDeviceSoftwareVersions = Tag('Secondary Capture Device Software Versions', "SecondaryCaptureDeviceSoftwareVersions", 0x0018, 0x1019)
    HardcopyDeviceSoftwareVersion = Tag('Hardcopy Device Software Version', "HardcopyDeviceSoftwareVersion", 0x0018, 0x101A)
    HardcopyDeviceManufacturerModelName = Tag("Hardcopy Device Manufacturer's Model Name", "HardcopyDeviceManufacturerModelName", 0x0018, 0x101B)
    SoftwareVersions = Tag('Software Versions', "SoftwareVersions", 0x0018, 0x1020, [TagLink(TransducerIdentificationSequence),TagLink(BeamHoldOriginatingDeviceSequence),TagLink(ContributingSourcesSequence),TagLink(ContributingEquipmentSequence),TagLink(AssessmentRequesterSequence),TagLink(ModelSpecificationSequence),TagLink(PatientSupportDevicesSequence),TagLink(WedgeDefinitionSequence),TagLink(CompensatorDefinitionSequence),TagLink(BlockDefinitionSequence),TagLink(RTAccessoryHolderDefinitionSequence),TagLink(GeneralAccessoryDefinitionSequence),TagLink(BolusDefinitionSequence),TagLink(InterlockOriginatingDeviceSequence),TagLink(AcquisitionDeviceSequence),TagLink(PatientTreatmentPreparationDeviceSequence),TagLink(XRayFilterSequence),TagLink(AuthorIdentificationSequence),TagLink(SegmentedRTAccessoryDeviceSequence),TagLink(TreatmentDeviceIdentificationSequence),TagLink(OperatorIdentificationSequence),TagLink(AsserterIdentificationSequence),])
    VideoImageFormatAcquired = Tag('Video Image Format Acquired', "VideoImageFormatAcquired", 0x0018, 0x1022)
    DigitalImageFormatAcquired = Tag('Digital Image Format Acquired', "DigitalImageFormatAcquired", 0x0018, 0x1023)
    ProtocolName = Tag('Protocol Name', "ProtocolName", 0x0018, 0x1030, [TagLink(ContributingSourcesSequence),])
    ContrastBolusRoute = Tag('Contrast/Bolus Route', "ContrastBolusRoute", 0x0018, 0x1040)
    ContrastAdministrationProfileSequence = Tag('Contrast Administration Profile Sequence', "ContrastAdministrationProfileSequence", 0x0018, 0x9340, [TagLink(ContrastBolusAgentSequence),])
    ContrastBolusVolume = Tag('Contrast/Bolus Volume', "ContrastBolusVolume", 0x0018, 0x1041, [TagLink(ContrastBolusAgentSequence),TagLink(ContrastAdministrationProfileSequence),])
    ContrastBolusStartTime = Tag('Contrast/Bolus Start Time', "ContrastBolusStartTime", 0x0018, 0x1042, [TagLink(ContrastAdministrationProfileSequence),])
    ContrastBolusStopTime = Tag('Contrast/Bolus Stop Time', "ContrastBolusStopTime", 0x0018, 0x1043, [TagLink(ContrastAdministrationProfileSequence),])
    ContrastBolusTotalDose = Tag('Contrast/Bolus Total Dose', "ContrastBolusTotalDose", 0x0018, 0x1044)
    CalibrationDataSequence = Tag('Calibration Data Sequence', "CalibrationDataSequence", 0x0054, 0x0306, [TagLink(RadiopharmaceuticalInformationSequence),])
    SyringeCounts = Tag('Syringe Counts', "SyringeCounts", 0x0018, 0x1045, [TagLink(CalibrationDataSequence),])
    ContrastFlowRate = Tag('Contrast Flow Rate', "ContrastFlowRate", 0x0018, 0x1046, [TagLink(ContrastAdministrationProfileSequence),])
    ContrastFlowDuration = Tag('Contrast Flow Duration', "ContrastFlowDuration", 0x0018, 0x1047, [TagLink(ContrastAdministrationProfileSequence),])
    ContrastBolusIngredient = Tag('Contrast/Bolus Ingredient', "ContrastBolusIngredient", 0x0018, 0x1048)
    ContrastBolusIngredientConcentration = Tag('Contrast/Bolus Ingredient Concentration', "ContrastBolusIngredientConcentration", 0x0018, 0x1049, [TagLink(ContrastBolusAgentSequence),])
    SpatialResolution = Tag('Spatial Resolution', "SpatialResolution", 0x0018, 0x1050, [TagLink(ContributingEquipmentSequence),])
    GatedInformationSequence = Tag('Gated Information Sequence', "GatedInformationSequence", 0x0054, 0x0062)
    TriggerTime = Tag('Trigger Time', "TriggerTime", 0x0018, 0x1060, [TagLink(GatedInformationSequence),])
    TriggerSourceOrType = Tag('Trigger Source or Type', "TriggerSourceOrType", 0x0018, 0x1061)
    DataInformationSequence = Tag('Data Information Sequence', "DataInformationSequence", 0x0054, 0x0063, [TagLink(GatedInformationSequence),])
    NominalInterval = Tag('Nominal Interval', "NominalInterval", 0x0018, 0x1062, [TagLink(DataInformationSequence),])
    FrameTime = Tag('Frame Time', "FrameTime", 0x0018, 0x1063, [TagLink(DataInformationSequence),])
    CardiacFramingType = Tag('Cardiac Framing Type', "CardiacFramingType", 0x0018, 0x1064, [TagLink(GatedInformationSequence),TagLink(CTXRayDetailsSequence),])
    FrameTimeVector = Tag('Frame Time Vector', "FrameTimeVector", 0x0018, 0x1065)
    FrameDelay = Tag('Frame Delay', "FrameDelay", 0x0018, 0x1066)
    ImageTriggerDelay = Tag('Image Trigger Delay', "ImageTriggerDelay", 0x0018, 0x1067)
    MultiplexGroupTimeOffset = Tag('Multiplex Group Time Offset', "MultiplexGroupTimeOffset", 0x0018, 0x1068, [TagLink(WaveformSequence),])
    TriggerTimeOffset = Tag('Trigger Time Offset', "TriggerTimeOffset", 0x0018, 0x1069, [TagLink(WaveformSequence),])
    SynchronizationTrigger = Tag('Synchronization Trigger', "SynchronizationTrigger", 0x0018, 0x106A)
    SynchronizationChannel = Tag('Synchronization Channel', "SynchronizationChannel", 0x0018, 0x106C)
    TriggerSamplePosition = Tag('Trigger Sample Position', "TriggerSamplePosition", 0x0018, 0x106E, [TagLink(WaveformSequence),])
    RadiopharmaceuticalRoute = Tag('Radiopharmaceutical Route', "RadiopharmaceuticalRoute", 0x0018, 0x1070, [TagLink(RadiopharmaceuticalInformationSequence),])
    RadiopharmaceuticalVolume = Tag('Radiopharmaceutical Volume', "RadiopharmaceuticalVolume", 0x0018, 0x1071, [TagLink(RadiopharmaceuticalInformationSequence),])
    RadiopharmaceuticalStartTime = Tag('Radiopharmaceutical Start Time', "RadiopharmaceuticalStartTime", 0x0018, 0x1072, [TagLink(RadiopharmaceuticalInformationSequence),])
    RadiopharmaceuticalStopTime = Tag('Radiopharmaceutical Stop Time', "RadiopharmaceuticalStopTime", 0x0018, 0x1073, [TagLink(RadiopharmaceuticalInformationSequence),])
    RadionuclideTotalDose = Tag('Radionuclide Total Dose', "RadionuclideTotalDose", 0x0018, 0x1074, [TagLink(RadiopharmaceuticalInformationSequence),])
    RadionuclideHalfLife = Tag('Radionuclide Half Life', "RadionuclideHalfLife", 0x0018, 0x1075, [TagLink(RadiopharmaceuticalInformationSequence),])
    RadionuclidePositronFraction = Tag('Radionuclide Positron Fraction', "RadionuclidePositronFraction", 0x0018, 0x1076, [TagLink(RadiopharmaceuticalInformationSequence),])
    RadiopharmaceuticalSpecificActivity = Tag('Radiopharmaceutical Specific Activity', "RadiopharmaceuticalSpecificActivity", 0x0018, 0x1077, [TagLink(RadiopharmaceuticalInformationSequence),])
    RadiopharmaceuticalStartDateTime = Tag('Radiopharmaceutical Start DateTime', "RadiopharmaceuticalStartDateTime", 0x0018, 0x1078, [TagLink(RadiopharmaceuticalInformationSequence),])
    RadiopharmaceuticalStopDateTime = Tag('Radiopharmaceutical Stop DateTime', "RadiopharmaceuticalStopDateTime", 0x0018, 0x1079, [TagLink(RadiopharmaceuticalInformationSequence),])
    BeatRejectionFlag = Tag('Beat Rejection Flag', "BeatRejectionFlag", 0x0018, 0x1080)
    CardiacSynchronizationSequence = Tag('Cardiac Synchronization Sequence', "CardiacSynchronizationSequence", 0x0018, 0x9118, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    LowRRValue = Tag('Low R-R Value', "LowRRValue", 0x0018, 0x1081, [TagLink(CardiacSynchronizationSequence),TagLink(DataInformationSequence),TagLink(CTXRayDetailsSequence),])
    HighRRValue = Tag('High R-R Value', "HighRRValue", 0x0018, 0x1082, [TagLink(CardiacSynchronizationSequence),TagLink(DataInformationSequence),TagLink(CTXRayDetailsSequence),])
    IntervalsAcquired = Tag('Intervals Acquired', "IntervalsAcquired", 0x0018, 0x1083, [TagLink(CardiacSynchronizationSequence),TagLink(DataInformationSequence),])
    IntervalsRejected = Tag('Intervals Rejected', "IntervalsRejected", 0x0018, 0x1084, [TagLink(CardiacSynchronizationSequence),TagLink(DataInformationSequence),])
    PVCRejection = Tag('PVC Rejection', "PVCRejection", 0x0018, 0x1085)
    SkipBeats = Tag('Skip Beats', "SkipBeats", 0x0018, 0x1086, [TagLink(CTXRayDetailsSequence),])
    HeartRate = Tag('Heart Rate', "HeartRate", 0x0018, 0x1088, [TagLink(CardiacSynchronizationSequence),])
    CardiacNumberOfImages = Tag('Cardiac Number of Images', "CardiacNumberOfImages", 0x0018, 0x1090)
    TriggerWindow = Tag('Trigger Window', "TriggerWindow", 0x0018, 0x1094)
    CTReconstructionSequence = Tag('CT Reconstruction Sequence', "CTReconstructionSequence", 0x0018, 0x9314, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    PETReconstructionSequence = Tag('PET Reconstruction Sequence', "PETReconstructionSequence", 0x0018, 0x9749, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    ReconstructionDiameter = Tag('Reconstruction Diameter', "ReconstructionDiameter", 0x0018, 0x1100, [TagLink(CTReconstructionSequence),TagLink(PETReconstructionSequence),TagLink(ReconstructionProtocolElementSequence),])
    RotationInformationSequence = Tag('Rotation Information Sequence', "RotationInformationSequence", 0x0054, 0x0052)
    CTGeometrySequence = Tag('CT Geometry Sequence', "CTGeometrySequence", 0x0018, 0x9312, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    XRayGeometrySequence = Tag('X-Ray Geometry Sequence', "XRayGeometrySequence", 0x0018, 0x9476, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    DistanceSourceToDetector = Tag('Distance Source to Detector', "DistanceSourceToDetector", 0x0018, 0x1110, [TagLink(DetectorInformationSequence),TagLink(RotationInformationSequence),TagLink(CTGeometrySequence),TagLink(XRayGeometrySequence),TagLink(XRay3DAcquisitionSequence),TagLink(XAPlaneDetailsSequence),])
    DistanceSourceToPatient = Tag('Distance Source to Patient', "DistanceSourceToPatient", 0x0018, 0x1111, [TagLink(XRay3DAcquisitionSequence),TagLink(XRayGeometrySequence),])
    EstimatedRadiographicMagnificationFactor = Tag('Estimated Radiographic Magnification Factor', "EstimatedRadiographicMagnificationFactor", 0x0018, 0x1114, [TagLink(XRay3DAcquisitionSequence),TagLink(XRayGeometrySequence),])
    GantryDetectorTilt = Tag('Gantry/Detector Tilt', "GantryDetectorTilt", 0x0018, 0x1120, [TagLink(DetectorInformationSequence),TagLink(CTAcquisitionDetailsSequence),TagLink(PETFrameAcquisitionSequence),TagLink(AcquisitionProtocolElementSequence),])
    GantryDetectorSlew = Tag('Gantry/Detector Slew', "GantryDetectorSlew", 0x0018, 0x1121, [TagLink(PETFrameAcquisitionSequence),])
    ProjectionPixelCalibrationSequence = Tag('Projection Pixel Calibration Sequence', "ProjectionPixelCalibrationSequence", 0x0018, 0x9401, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    TableHeight = Tag('Table Height', "TableHeight", 0x0018, 0x1130, [TagLink(RotationInformationSequence),TagLink(CTAcquisitionDetailsSequence),TagLink(ProjectionPixelCalibrationSequence),TagLink(PETFrameAcquisitionSequence),TagLink(AcquisitionProtocolElementSequence),])
    TableTraverse = Tag('Table Traverse', "TableTraverse", 0x0018, 0x1131, [TagLink(RotationInformationSequence),])
    TableMotion = Tag('Table Motion', "TableMotion", 0x0018, 0x1134)
    TableVerticalIncrement = Tag('Table Vertical Increment', "TableVerticalIncrement", 0x0018, 0x1135)
    TableLateralIncrement = Tag('Table Lateral Increment', "TableLateralIncrement", 0x0018, 0x1136)
    TableLongitudinalIncrement = Tag('Table Longitudinal Increment', "TableLongitudinalIncrement", 0x0018, 0x1137)
    TableAngle = Tag('Table Angle', "TableAngle", 0x0018, 0x1138)
    TableType = Tag('Table Type', "TableType", 0x0018, 0x113A)
    PETDetectorMotionDetailsSequence = Tag('PET Detector Motion Details Sequence', "PETDetectorMotionDetailsSequence", 0x0018, 0x9733, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    RotationDirection = Tag('Rotation Direction', "RotationDirection", 0x0018, 0x1140, [TagLink(RotationInformationSequence),TagLink(CTAcquisitionDetailsSequence),TagLink(PETDetectorMotionDetailsSequence),])
    AngularPosition = Tag('Angular Position', "AngularPosition", 0x0018, 0x1141)
    RadialPosition = Tag('Radial Position', "RadialPosition", 0x0018, 0x1142, [TagLink(DetectorInformationSequence),TagLink(RotationInformationSequence),])
    ScanArc = Tag('Scan Arc', "ScanArc", 0x0018, 0x1143, [TagLink(RotationInformationSequence),])
    AngularStep = Tag('Angular Step', "AngularStep", 0x0018, 0x1144, [TagLink(RotationInformationSequence),])
    CenterOfRotationOffset = Tag('Center of Rotation Offset', "CenterOfRotationOffset", 0x0018, 0x1145, [TagLink(DetectorInformationSequence),])
    RotationOffset = Tag('Rotation Offset', "RotationOffset", 0x0018, 0x1146)
    FieldOfViewSequence = Tag('Field of View Sequence', "FieldOfViewSequence", 0x0018, 0x9432, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    FieldOfViewShape = Tag('Field of View Shape', "FieldOfViewShape", 0x0018, 0x1147, [TagLink(DetectorInformationSequence),TagLink(FieldOfViewSequence),TagLink(XRay3DAcquisitionSequence),])
    FieldOfViewDimensions = Tag('Field of View Dimension(s)', "FieldOfViewDimensions", 0x0018, 0x1149, [TagLink(DetectorInformationSequence),])
    ExposureTime = Tag('Exposure Time', "ExposureTime", 0x0018, 0x1150, [TagLink(ExposureSequence),])
    XRayTubeCurrent = Tag('X-Ray Tube Current', "XRayTubeCurrent", 0x0018, 0x1151, [TagLink(ExposureSequence),])
    Exposure = Tag('Exposure', "Exposure", 0x0018, 0x1152)
    ExposureInuAs = Tag('Exposure in \xb5As', "ExposureInuAs", 0x0018, 0x1153)
    AveragePulseWidth = Tag('Average Pulse Width', "AveragePulseWidth", 0x0018, 0x1154, [TagLink(XAPlaneDetailsSequence),TagLink(RTImageFramekVRadiationAcquisitionSequence),TagLink(KVImagingGenerationParametersSequence),])
    RadiationSetting = Tag('Radiation Setting', "RadiationSetting", 0x0018, 0x1155, [TagLink(AcquisitionProtocolElementSequence),])
    RectificationType = Tag('Rectification Type', "RectificationType", 0x0018, 0x1156)
    RadiationMode = Tag('Radiation Mode', "RadiationMode", 0x0018, 0x115A, [TagLink(RTImageFramekVRadiationAcquisitionSequence),TagLink(KVImagingGenerationParametersSequence),])
    ImageAndFluoroscopyAreaDoseProduct = Tag('Image and Fluoroscopy Area Dose Product', "ImageAndFluoroscopyAreaDoseProduct", 0x0018, 0x115E, [TagLink(CTExposureSequence),])
    XRayFilterDetailsSequence = Tag('X-Ray Filter Details Sequence', "XRayFilterDetailsSequence", 0x0018, 0x11BC, [TagLink(XAPlaneDetailsSequence),])
    FilterType = Tag('Filter Type', "FilterType", 0x0018, 0x1160, [TagLink(CTAdditionalXRaySourceSequence),TagLink(CTXRayDetailsSequence),TagLink(XRay3DAcquisitionSequence),TagLink(XRayFilterSequence),TagLink(XRayFilterDetailsSequence),])
    TypeOfFilters = Tag('Type of Filters', "TypeOfFilters", 0x0018, 0x1161)
    IntensifierSize = Tag('Intensifier Size', "IntensifierSize", 0x0018, 0x1162)
    ImagerPixelSpacing = Tag('Imager Pixel Spacing', "ImagerPixelSpacing", 0x0018, 0x1164, [TagLink(FramePixelDataPropertiesSequence),TagLink(ContributingSourcesSequence),])
    XRayGridSequence = Tag('X-Ray Grid Sequence', "XRayGridSequence", 0x0018, 0x9555, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    Grid = Tag('Grid', "Grid", 0x0018, 0x1166, [TagLink(XRay3DAcquisitionSequence),TagLink(XRayGridSequence),])
    MultienergyCTXRaySourceSequence = Tag('Multi-energy CT X-Ray Source Sequence', "MultienergyCTXRaySourceSequence", 0x0018, 0x9365)
    GeneratorPower = Tag('Generator Power', "GeneratorPower", 0x0018, 0x1170, [TagLink(MultienergyCTXRaySourceSequence),])
    CollimatorGridName = Tag('Collimator/grid Name', "CollimatorGridName", 0x0018, 0x1180, [TagLink(DetectorInformationSequence),])
    CollimatorType = Tag('Collimator Type', "CollimatorType", 0x0018, 0x1181, [TagLink(DetectorInformationSequence),])
    FocalDistance = Tag('Focal Distance', "FocalDistance", 0x0018, 0x1182, [TagLink(DetectorInformationSequence),])
    XFocusCenter = Tag('X Focus Center', "XFocusCenter", 0x0018, 0x1183, [TagLink(DetectorInformationSequence),])
    YFocusCenter = Tag('Y Focus Center', "YFocusCenter", 0x0018, 0x1184, [TagLink(DetectorInformationSequence),])
    FocalSpots = Tag('Focal Spot(s)', "FocalSpots", 0x0018, 0x1190, [TagLink(CTAdditionalXRaySourceSequence),TagLink(CTXRayDetailsSequence),TagLink(XRay3DAcquisitionSequence),TagLink(XAPlaneDetailsSequence),])
    AnodeTargetMaterial = Tag('Anode Target Material', "AnodeTargetMaterial", 0x0018, 0x1191, [TagLink(XRay3DAcquisitionSequence),])
    BodyPartThickness = Tag('Body Part Thickness', "BodyPartThickness", 0x0018, 0x11A0, [TagLink(XRay3DAcquisitionSequence),])
    CompressionForce = Tag('Compression Force', "CompressionForce", 0x0018, 0x11A2, [TagLink(XRay3DAcquisitionSequence),])
    CompressionPressure = Tag('Compression Pressure', "CompressionPressure", 0x0018, 0x11A3, [TagLink(XRay3DAcquisitionSequence),])
    PaddleDescription = Tag('Paddle Description', "PaddleDescription", 0x0018, 0x11A4, [TagLink(XRay3DAcquisitionSequence),])
    CompressionContactArea = Tag('Compression Contact Area', "CompressionContactArea", 0x0018, 0x11A5, [TagLink(XRay3DAcquisitionSequence),])
    AcquisitionMode = Tag('Acquisition Mode', "AcquisitionMode", 0x0018, 0x11B0, [TagLink(AcquisitionProtocolElementSequence),])
    DoseModeName = Tag('Dose Mode Name', "DoseModeName", 0x0018, 0x11B1, [TagLink(AcquisitionProtocolElementSequence),])
    AcquiredSubtractionMaskFlag = Tag('Acquired Subtraction Mask Flag', "AcquiredSubtractionMaskFlag", 0x0018, 0x11B2, [TagLink(AcquisitionProtocolElementSequence),])
    FluoroscopyPersistenceFlag = Tag('Fluoroscopy Persistence Flag', "FluoroscopyPersistenceFlag", 0x0018, 0x11B3, [TagLink(AcquisitionProtocolElementSequence),])
    FluoroscopyLastImageHoldPersistenceFlag = Tag('Fluoroscopy Last Image Hold Persistence Flag', "FluoroscopyLastImageHoldPersistenceFlag", 0x0018, 0x11B4, [TagLink(AcquisitionProtocolElementSequence),])
    UpperLimitNumberOfPersistentFluoroscopyFrames = Tag('Upper Limit Number Of Persistent Fluoroscopy Frames', "UpperLimitNumberOfPersistentFluoroscopyFrames", 0x0018, 0x11B5, [TagLink(AcquisitionProtocolElementSequence),])
    ContrastBolusAutoInjectionTriggerFlag = Tag('Contrast/Bolus Auto Injection Trigger Flag', "ContrastBolusAutoInjectionTriggerFlag", 0x0018, 0x11B6, [TagLink(AcquisitionProtocolElementSequence),])
    ContrastBolusInjectionDelay = Tag('Contrast/Bolus Injection Delay', "ContrastBolusInjectionDelay", 0x0018, 0x11B7, [TagLink(AcquisitionProtocolElementSequence),])
    XAAcquisitionPhaseDetailsSequence = Tag('XA Acquisition Phase Details Sequence', "XAAcquisitionPhaseDetailsSequence", 0x0018, 0x11B8, [TagLink(AcquisitionProtocolElementSequence),])
    XAAcquisitionFrameRate = Tag('XA Acquisition Frame Rate', "XAAcquisitionFrameRate", 0x0018, 0x11B9, [TagLink(XAAcquisitionPhaseDetailsSequence),])
    AcquisitionFieldOfViewLabel = Tag('Acquisition Field of View Label', "AcquisitionFieldOfViewLabel", 0x0018, 0x11BB, [TagLink(XAPlaneDetailsSequence),])
    XAAcquisitionDuration = Tag('XA Acquisition Duration', "XAAcquisitionDuration", 0x0018, 0x11BD, [TagLink(XAAcquisitionPhaseDetailsSequence),])
    ReconstructionPipelineType = Tag('Reconstruction Pipeline Type', "ReconstructionPipelineType", 0x0018, 0x11BE, [TagLink(ReconstructionProtocolElementSequence),])
    ImageFilterDetailsSequence = Tag('Image Filter Details Sequence', "ImageFilterDetailsSequence", 0x0018, 0x11BF, [TagLink(ReconstructionProtocolElementSequence),])
    AppliedMaskSubtractionFlag = Tag('Applied Mask Subtraction Flag', "AppliedMaskSubtractionFlag", 0x0018, 0x11C0, [TagLink(ReconstructionProtocolElementSequence),])
    DateOfLastCalibration = Tag('Date of Last Calibration', "DateOfLastCalibration", 0x0018, 0x1200, [TagLink(ContributingEquipmentSequence),])
    TimeOfLastCalibration = Tag('Time of Last Calibration', "TimeOfLastCalibration", 0x0018, 0x1201, [TagLink(ContributingEquipmentSequence),])
    DateTimeOfLastCalibration = Tag('DateTime of Last Calibration', "DateTimeOfLastCalibration", 0x0018, 0x1202)
    DoseCalibrationConditionsSequence = Tag('Dose Calibration Conditions Sequence', "DoseCalibrationConditionsSequence", 0x300C, 0x0120, [TagLink(ReferencedBeamSequence),TagLink(TreatmentSessionBeamSequence),])
    CalibrationDateTime = Tag('Calibration DateTime', "CalibrationDateTime", 0x0018, 0x1203, [TagLink(DoseCalibrationConditionsSequence),])
    DateOfManufacture = Tag('Date of Manufacture', "DateOfManufacture", 0x0018, 0x1204, [TagLink(DeviceSequence),TagLink(TransducerIdentificationSequence),TagLink(BeamSequence),TagLink(TreatmentMachineSequence),TagLink(BeamHoldOriginatingDeviceSequence),TagLink(IonBeamSequence),TagLink(ContributingSourcesSequence),TagLink(ContributingEquipmentSequence),TagLink(AssessmentRequesterSequence),TagLink(ModelSpecificationSequence),TagLink(PatientSupportDevicesSequence),TagLink(WedgeDefinitionSequence),TagLink(CompensatorDefinitionSequence),TagLink(BlockDefinitionSequence),TagLink(RTAccessoryHolderDefinitionSequence),TagLink(GeneralAccessoryDefinitionSequence),TagLink(BolusDefinitionSequence),TagLink(InterlockOriginatingDeviceSequence),TagLink(AcquisitionDeviceSequence),TagLink(PatientTreatmentPreparationDeviceSequence),TagLink(XRayFilterSequence),TagLink(AuthorIdentificationSequence),TagLink(SegmentedRTAccessoryDeviceSequence),TagLink(TreatmentDeviceIdentificationSequence),TagLink(OperatorIdentificationSequence),TagLink(AsserterIdentificationSequence),])
    DateOfInstallation = Tag('Date of Installation', "DateOfInstallation", 0x0018, 0x1205, [TagLink(TransducerIdentificationSequence),TagLink(BeamSequence),TagLink(TreatmentMachineSequence),TagLink(BeamHoldOriginatingDeviceSequence),TagLink(IonBeamSequence),TagLink(ContributingSourcesSequence),TagLink(ContributingEquipmentSequence),TagLink(AssessmentRequesterSequence),TagLink(ModelSpecificationSequence),TagLink(PatientSupportDevicesSequence),TagLink(WedgeDefinitionSequence),TagLink(CompensatorDefinitionSequence),TagLink(BlockDefinitionSequence),TagLink(RTAccessoryHolderDefinitionSequence),TagLink(GeneralAccessoryDefinitionSequence),TagLink(BolusDefinitionSequence),TagLink(InterlockOriginatingDeviceSequence),TagLink(AcquisitionDeviceSequence),TagLink(PatientTreatmentPreparationDeviceSequence),TagLink(XRayFilterSequence),TagLink(AuthorIdentificationSequence),TagLink(SegmentedRTAccessoryDeviceSequence),TagLink(TreatmentDeviceIdentificationSequence),TagLink(OperatorIdentificationSequence),TagLink(AsserterIdentificationSequence),])
    ConvolutionKernel = Tag('Convolution Kernel', "ConvolutionKernel", 0x0018, 0x1210, [TagLink(CTReconstructionSequence),TagLink(ReconstructionProtocolElementSequence),])
    UpperLowerPixelValues = Tag('Upper/Lower Pixel Values', "UpperLowerPixelValues", 0x0018, 0x1240)
    PhaseInformationSequence = Tag('Phase Information Sequence', "PhaseInformationSequence", 0x0054, 0x0032)
    ActualFrameDuration = Tag('Actual Frame Duration', "ActualFrameDuration", 0x0018, 0x1242, [TagLink(RotationInformationSequence),TagLink(PhaseInformationSequence),])
    CountRate = Tag('Count Rate', "CountRate", 0x0018, 0x1243)
    PreferredPlaybackSequencing = Tag('Preferred Playback Sequencing', "PreferredPlaybackSequencing", 0x0018, 0x1244, [TagLink(StructuredDisplayImageBoxSequence),TagLink(MultiFramePresentationSequence),TagLink(ImageBoxesSequence),])
    MRReceiveCoilSequence = Tag('MR Receive Coil Sequence', "MRReceiveCoilSequence", 0x0018, 0x9042, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    ReceiveCoilName = Tag('Receive Coil Name', "ReceiveCoilName", 0x0018, 0x1250, [TagLink(MRReceiveCoilSequence),])
    MRTransmitCoilSequence = Tag('MR Transmit Coil Sequence', "MRTransmitCoilSequence", 0x0018, 0x9049, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    TransmitCoilName = Tag('Transmit Coil Name', "TransmitCoilName", 0x0018, 0x1251, [TagLink(MRTransmitCoilSequence),])
    PlateType = Tag('Plate Type', "PlateType", 0x0018, 0x1260)
    PhosphorType = Tag('Phosphor Type', "PhosphorType", 0x0018, 0x1261)
    WaterEquivalentDiameter = Tag('Water Equivalent Diameter', "WaterEquivalentDiameter", 0x0018, 0x1271, [TagLink(CTExposureSequence),])
    ScanVelocity = Tag('Scan Velocity', "ScanVelocity", 0x0018, 0x1300)
    WholeBodyTechnique = Tag('Whole Body Technique', "WholeBodyTechnique", 0x0018, 0x1301)
    ScanLength = Tag('Scan Length', "ScanLength", 0x0018, 0x1302)
    AcquisitionMatrix = Tag('Acquisition Matrix', "AcquisitionMatrix", 0x0018, 0x1310)
    InPlanePhaseEncodingDirection = Tag('In-plane Phase Encoding Direction', "InPlanePhaseEncodingDirection", 0x0018, 0x1312, [TagLink(MRFOVGeometrySequence),])
    FlipAngle = Tag('Flip Angle', "FlipAngle", 0x0018, 0x1314, [TagLink(MRTimingAndRelatedParametersSequence),])
    VariableFlipAngleFlag = Tag('Variable Flip Angle Flag', "VariableFlipAngleFlag", 0x0018, 0x1315)
    SAR = Tag('SAR', "SAR", 0x0018, 0x1316)
    dBdt = Tag('dB/dt', "dBdt", 0x0018, 0x1318)
    B1rms = Tag('B1rms', "B1rms", 0x0018, 0x1320)
    AcquisitionDeviceProcessingDescription = Tag('Acquisition Device Processing Description', "AcquisitionDeviceProcessingDescription", 0x0018, 0x1400, [TagLink(XAXRFFrameCharacteristicsSequence),TagLink(ContributingSourcesSequence),])
    AcquisitionDeviceProcessingCode = Tag('Acquisition Device Processing Code', "AcquisitionDeviceProcessingCode", 0x0018, 0x1401, [TagLink(XAXRFFrameCharacteristicsSequence),TagLink(ContributingSourcesSequence),])
    CassetteOrientation = Tag('Cassette Orientation', "CassetteOrientation", 0x0018, 0x1402)
    CassetteSize = Tag('Cassette Size', "CassetteSize", 0x0018, 0x1403)
    ExposuresOnPlate = Tag('Exposures on Plate', "ExposuresOnPlate", 0x0018, 0x1404)
    XRayAcquisitionDoseSequence = Tag('X-Ray Acquisition Dose Sequence', "XRayAcquisitionDoseSequence", 0x0018, 0x9542, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    RelativeXRayExposure = Tag('Relative X-Ray Exposure', "RelativeXRayExposure", 0x0018, 0x1405, [TagLink(PerProjectionAcquisitionSequence),TagLink(XRayAcquisitionDoseSequence),])
    ExposureIndex = Tag('Exposure Index', "ExposureIndex", 0x0018, 0x1411, [TagLink(XRay3DAcquisitionSequence),TagLink(PerProjectionAcquisitionSequence),])
    TargetExposureIndex = Tag('Target Exposure Index', "TargetExposureIndex", 0x0018, 0x1412, [TagLink(XRay3DAcquisitionSequence),TagLink(PerProjectionAcquisitionSequence),])
    DeviationIndex = Tag('Deviation Index', "DeviationIndex", 0x0018, 0x1413, [TagLink(XRay3DAcquisitionSequence),TagLink(PerProjectionAcquisitionSequence),])
    ColumnAngulation = Tag('Column Angulation', "ColumnAngulation", 0x0018, 0x1450)
    TomoLayerHeight = Tag('Tomo Layer Height', "TomoLayerHeight", 0x0018, 0x1460)
    TomoAngle = Tag('Tomo Angle', "TomoAngle", 0x0018, 0x1470)
    TomoTime = Tag('Tomo Time', "TomoTime", 0x0018, 0x1480)
    TomoType = Tag('Tomo Type', "TomoType", 0x0018, 0x1490)
    TomoClass = Tag('Tomo Class', "TomoClass", 0x0018, 0x1491)
    NumberOfTomosynthesisSourceImages = Tag('Number of Tomosynthesis Source Images', "NumberOfTomosynthesisSourceImages", 0x0018, 0x1495)
    PositionerMotion = Tag('Positioner Motion', "PositionerMotion", 0x0018, 0x1500)
    PositionerType = Tag('Positioner Type', "PositionerType", 0x0018, 0x1508)
    PositionerPositionSequence = Tag('Positioner Position Sequence', "PositionerPositionSequence", 0x0018, 0x9405, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    PositionerPrimaryAngle = Tag('Positioner Primary Angle', "PositionerPrimaryAngle", 0x0018, 0x1510, [TagLink(PositionerPositionSequence),TagLink(PerProjectionAcquisitionSequence),])
    PositionerSecondaryAngle = Tag('Positioner Secondary Angle', "PositionerSecondaryAngle", 0x0018, 0x1511, [TagLink(PositionerPositionSequence),TagLink(PerProjectionAcquisitionSequence),])
    PositionerPrimaryAngleIncrement = Tag('Positioner Primary Angle Increment', "PositionerPrimaryAngleIncrement", 0x0018, 0x1520)
    PositionerSecondaryAngleIncrement = Tag('Positioner Secondary Angle Increment', "PositionerSecondaryAngleIncrement", 0x0018, 0x1521)
    DetectorPositionSequence = Tag('Detector Position Sequence', "DetectorPositionSequence", 0x0018, 0x9541, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    DetectorPrimaryAngle = Tag('Detector Primary Angle', "DetectorPrimaryAngle", 0x0018, 0x1530, [TagLink(DetectorPositionSequence),])
    DetectorSecondaryAngle = Tag('Detector Secondary Angle', "DetectorSecondaryAngle", 0x0018, 0x1531, [TagLink(DetectorPositionSequence),])
    ShutterShape = Tag('Shutter Shape', "ShutterShape", 0x0018, 0x1600, [TagLink(FrameDisplayShutterSequence),])
    ShutterLeftVerticalEdge = Tag('Shutter Left Vertical Edge', "ShutterLeftVerticalEdge", 0x0018, 0x1602, [TagLink(FrameDisplayShutterSequence),])
    ShutterRightVerticalEdge = Tag('Shutter Right Vertical Edge', "ShutterRightVerticalEdge", 0x0018, 0x1604, [TagLink(FrameDisplayShutterSequence),])
    ShutterUpperHorizontalEdge = Tag('Shutter Upper Horizontal Edge', "ShutterUpperHorizontalEdge", 0x0018, 0x1606, [TagLink(FrameDisplayShutterSequence),])
    ShutterLowerHorizontalEdge = Tag('Shutter Lower Horizontal Edge', "ShutterLowerHorizontalEdge", 0x0018, 0x1608, [TagLink(FrameDisplayShutterSequence),])
    CenterOfCircularShutter = Tag('Center of Circular Shutter', "CenterOfCircularShutter", 0x0018, 0x1610, [TagLink(FrameDisplayShutterSequence),])
    RadiusOfCircularShutter = Tag('Radius of Circular Shutter', "RadiusOfCircularShutter", 0x0018, 0x1612, [TagLink(FrameDisplayShutterSequence),])
    VerticesOfThePolygonalShutter = Tag('Vertices of the Polygonal Shutter', "VerticesOfThePolygonalShutter", 0x0018, 0x1620, [TagLink(FrameDisplayShutterSequence),])
    ShutterPresentationValue = Tag('Shutter Presentation Value', "ShutterPresentationValue", 0x0018, 0x1622, [TagLink(FrameDisplayShutterSequence),])
    ShutterOverlayGroup = Tag('Shutter Overlay Group', "ShutterOverlayGroup", 0x0018, 0x1623)
    ShutterPresentationColorCIELabValue = Tag('Shutter Presentation Color CIELab Value', "ShutterPresentationColorCIELabValue", 0x0018, 0x1624, [TagLink(FrameDisplayShutterSequence),])
    BeamAreaLimitSequence = Tag('Beam Area Limit Sequence', "BeamAreaLimitSequence", 0x300A, 0x0689, [TagLink(CArmPhotonElectronControlPointSequence),TagLink(TomotherapeuticControlPointSequence),TagLink(RoboticPathControlPointSequence),])
    FixedRTBeamDelimiterDeviceSequence = Tag('Fixed RT Beam Delimiter Device Sequence', "FixedRTBeamDelimiterDeviceSequence", 0x300A, 0x0646)
    ProjectionImagingAcquisitionParameterSequence = Tag('Projection Imaging Acquisition Parameter Sequence', "ProjectionImagingAcquisitionParameterSequence", 0x3002, 0x0125, [TagLink(AcquisitionSubtaskSequence),])
    ImagingApertureSequence = Tag('Imaging Aperture Sequence', "ImagingApertureSequence", 0x3002, 0x0114, [TagLink(ProjectionImagingAcquisitionParameterSequence),])
    RTBeamLimitingDeviceOpeningSequence = Tag('RT Beam Limiting Device Opening Sequence', "RTBeamLimitingDeviceOpeningSequence", 0x300A, 0x0656, [TagLink(ImagingApertureSequence),TagLink(CArmPhotonElectronControlPointSequence),TagLink(TomotherapeuticControlPointSequence),TagLink(RoboticPathControlPointSequence),TagLink(PerFrameFunctionalGroupsSequence, True),])
    RTBeamDelimiterGeometrySequence = Tag('RT Beam Delimiter Geometry Sequence', "RTBeamDelimiterGeometrySequence", 0x300A, 0x064C, [TagLink(RTBeamLimitingDeviceOpeningSequence),])
    OutlineShapeType = Tag('Outline Shape Type', "OutlineShapeType", 0x0018, 0x1630, [TagLink(BeamAreaLimitSequence),TagLink(FixedRTBeamDelimiterDeviceSequence),TagLink(RTBeamDelimiterGeometrySequence),])
    OutlineLeftVerticalEdge = Tag('Outline Left Vertical Edge', "OutlineLeftVerticalEdge", 0x0018, 0x1631, [TagLink(BeamAreaLimitSequence),TagLink(FixedRTBeamDelimiterDeviceSequence),TagLink(RTBeamDelimiterGeometrySequence),])
    OutlineRightVerticalEdge = Tag('Outline Right Vertical Edge', "OutlineRightVerticalEdge", 0x0018, 0x1632, [TagLink(BeamAreaLimitSequence),TagLink(FixedRTBeamDelimiterDeviceSequence),TagLink(RTBeamDelimiterGeometrySequence),])
    OutlineUpperHorizontalEdge = Tag('Outline Upper Horizontal Edge', "OutlineUpperHorizontalEdge", 0x0018, 0x1633, [TagLink(BeamAreaLimitSequence),TagLink(FixedRTBeamDelimiterDeviceSequence),TagLink(RTBeamDelimiterGeometrySequence),])
    OutlineLowerHorizontalEdge = Tag('Outline Lower Horizontal Edge', "OutlineLowerHorizontalEdge", 0x0018, 0x1634, [TagLink(BeamAreaLimitSequence),TagLink(FixedRTBeamDelimiterDeviceSequence),TagLink(RTBeamDelimiterGeometrySequence),])
    CenterOfCircularOutline = Tag('Center of Circular Outline', "CenterOfCircularOutline", 0x0018, 0x1635, [TagLink(BeamAreaLimitSequence),TagLink(FixedRTBeamDelimiterDeviceSequence),TagLink(RTBeamDelimiterGeometrySequence),])
    DiameterOfCircularOutline = Tag('Diameter of Circular Outline', "DiameterOfCircularOutline", 0x0018, 0x1636, [TagLink(BeamAreaLimitSequence),TagLink(FixedRTBeamDelimiterDeviceSequence),TagLink(RTBeamDelimiterGeometrySequence),])
    NumberOfPolygonalVertices = Tag('Number of Polygonal Vertices', "NumberOfPolygonalVertices", 0x0018, 0x1637, [TagLink(BeamAreaLimitSequence),TagLink(FixedRTBeamDelimiterDeviceSequence),TagLink(RTBeamDelimiterGeometrySequence),])
    VerticesOfThePolygonalOutline = Tag('Vertices of the Polygonal Outline', "VerticesOfThePolygonalOutline", 0x0018, 0x1638, [TagLink(BeamAreaLimitSequence),TagLink(FixedRTBeamDelimiterDeviceSequence),TagLink(RTBeamDelimiterGeometrySequence),])
    CollimatorShapeSequence = Tag('Collimator Shape Sequence', "CollimatorShapeSequence", 0x0018, 0x9407, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    CollimatorShape = Tag('Collimator Shape', "CollimatorShape", 0x0018, 0x1700, [TagLink(CollimatorShapeSequence),TagLink(PerProjectionAcquisitionSequence),])
    CollimatorLeftVerticalEdge = Tag('Collimator Left Vertical Edge', "CollimatorLeftVerticalEdge", 0x0018, 0x1702, [TagLink(CollimatorShapeSequence),TagLink(PerProjectionAcquisitionSequence),])
    CollimatorRightVerticalEdge = Tag('Collimator Right Vertical Edge', "CollimatorRightVerticalEdge", 0x0018, 0x1704, [TagLink(CollimatorShapeSequence),TagLink(PerProjectionAcquisitionSequence),])
    CollimatorUpperHorizontalEdge = Tag('Collimator Upper Horizontal Edge', "CollimatorUpperHorizontalEdge", 0x0018, 0x1706, [TagLink(CollimatorShapeSequence),TagLink(PerProjectionAcquisitionSequence),])
    CollimatorLowerHorizontalEdge = Tag('Collimator Lower Horizontal Edge', "CollimatorLowerHorizontalEdge", 0x0018, 0x1708, [TagLink(CollimatorShapeSequence),TagLink(PerProjectionAcquisitionSequence),])
    CenterOfCircularCollimator = Tag('Center of Circular Collimator', "CenterOfCircularCollimator", 0x0018, 0x1710, [TagLink(CollimatorShapeSequence),TagLink(PerProjectionAcquisitionSequence),])
    RadiusOfCircularCollimator = Tag('Radius of Circular Collimator', "RadiusOfCircularCollimator", 0x0018, 0x1712, [TagLink(CollimatorShapeSequence),TagLink(PerProjectionAcquisitionSequence),])
    VerticesOfThePolygonalCollimator = Tag('Vertices of the Polygonal Collimator', "VerticesOfThePolygonalCollimator", 0x0018, 0x1720, [TagLink(CollimatorShapeSequence),TagLink(PerProjectionAcquisitionSequence),])
    AcquisitionTimeSynchronized = Tag('Acquisition Time Synchronized', "AcquisitionTimeSynchronized", 0x0018, 0x1800)
    TimeSource = Tag('Time Source', "TimeSource", 0x0018, 0x1801)
    TimeDistributionProtocol = Tag('Time Distribution Protocol', "TimeDistributionProtocol", 0x0018, 0x1802)
    NTPSourceAddress = Tag('NTP Source Address', "NTPSourceAddress", 0x0018, 0x1803)
    PageNumberVector = Tag('Page Number Vector', "PageNumberVector", 0x0018, 0x2001)
    FrameLabelVector = Tag('Frame Label Vector', "FrameLabelVector", 0x0018, 0x2002)
    FramePrimaryAngleVector = Tag('Frame Primary Angle Vector', "FramePrimaryAngleVector", 0x0018, 0x2003)
    FrameSecondaryAngleVector = Tag('Frame Secondary Angle Vector', "FrameSecondaryAngleVector", 0x0018, 0x2004)
    SliceLocationVector = Tag('Slice Location Vector', "SliceLocationVector", 0x0018, 0x2005)
    DisplayWindowLabelVector = Tag('Display Window Label Vector', "DisplayWindowLabelVector", 0x0018, 0x2006)
    NominalScannedPixelSpacing = Tag('Nominal Scanned Pixel Spacing', "NominalScannedPixelSpacing", 0x0018, 0x2010)
    DigitizingDeviceTransportDirection = Tag('Digitizing Device Transport Direction', "DigitizingDeviceTransportDirection", 0x0018, 0x2020)
    RotationOfScannedFilm = Tag('Rotation of Scanned Film', "RotationOfScannedFilm", 0x0018, 0x2030)
    BiopsyTargetSequence = Tag('Biopsy Target Sequence', "BiopsyTargetSequence", 0x0018, 0x2041, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    TargetUID = Tag('Target UID', "TargetUID", 0x0018, 0x2042, [TagLink(BiopsyTargetSequence),])
    LocalizingCursorPosition = Tag('Localizing Cursor Position', "LocalizingCursorPosition", 0x0018, 0x2043, [TagLink(BiopsyTargetSequence),])
    CalculatedTargetPosition = Tag('Calculated Target Position', "CalculatedTargetPosition", 0x0018, 0x2044, [TagLink(BiopsyTargetSequence),])
    TargetLabel = Tag('Target Label', "TargetLabel", 0x0018, 0x2045, [TagLink(BiopsyTargetSequence),])
    DisplayedZValue = Tag('Displayed Z Value', "DisplayedZValue", 0x0018, 0x2046, [TagLink(BiopsyTargetSequence),])
    IVUSAcquisition = Tag('IVUS Acquisition', "IVUSAcquisition", 0x0018, 0x3100)
    IVUSPullbackRate = Tag('IVUS Pullback Rate', "IVUSPullbackRate", 0x0018, 0x3101)
    IVUSGatedRate = Tag('IVUS Gated Rate', "IVUSGatedRate", 0x0018, 0x3102)
    IVUSPullbackStartFrameNumber = Tag('IVUS Pullback Start Frame Number', "IVUSPullbackStartFrameNumber", 0x0018, 0x3103)
    IVUSPullbackStopFrameNumber = Tag('IVUS Pullback Stop Frame Number', "IVUSPullbackStopFrameNumber", 0x0018, 0x3104)
    LesionNumber = Tag('Lesion Number', "LesionNumber", 0x0018, 0x3105)
    AcquisitionComments = Tag('Acquisition Comments', "AcquisitionComments", 0x0018, 0x4000)
    OutputPower = Tag('Output Power', "OutputPower", 0x0018, 0x5000)
    TransducerData = Tag('Transducer Data', "TransducerData", 0x0018, 0x5010)
    FocusDepth = Tag('Focus Depth', "FocusDepth", 0x0018, 0x5012)
    ProcessingFunction = Tag('Processing Function', "ProcessingFunction", 0x0018, 0x5020)
    PostprocessingFunction = Tag('Postprocessing Function', "PostprocessingFunction", 0x0018, 0x5021)
    MechanicalIndex = Tag('Mechanical Index', "MechanicalIndex", 0x0018, 0x5022)
    BoneThermalIndex = Tag('Bone Thermal Index', "BoneThermalIndex", 0x0018, 0x5024)
    CranialThermalIndex = Tag('Cranial Thermal Index', "CranialThermalIndex", 0x0018, 0x5026)
    SoftTissueThermalIndex = Tag('Soft Tissue Thermal Index', "SoftTissueThermalIndex", 0x0018, 0x5027)
    SoftTissueFocusThermalIndex = Tag('Soft Tissue-focus Thermal Index', "SoftTissueFocusThermalIndex", 0x0018, 0x5028)
    SoftTissueSurfaceThermalIndex = Tag('Soft Tissue-surface Thermal Index', "SoftTissueSurfaceThermalIndex", 0x0018, 0x5029)
    DynamicRange = Tag('Dynamic Range', "DynamicRange", 0x0018, 0x5030)
    TotalGain = Tag('Total Gain', "TotalGain", 0x0018, 0x5040)
    DepthOfScanField = Tag('Depth of Scan Field', "DepthOfScanField", 0x0018, 0x5050)
    PatientPosition = Tag('Patient Position', "PatientPosition", 0x0018, 0x5100, [TagLink(GroupOfPatientsIdentificationSequence),TagLink(PatientSetupSequence),])
    ViewPosition = Tag('View Position', "ViewPosition", 0x0018, 0x5101)
    ImageTransformationMatrix = Tag('Image Transformation Matrix', "ImageTransformationMatrix", 0x0018, 0x5210)
    ImageTranslationVector = Tag('Image Translation Vector', "ImageTranslationVector", 0x0018, 0x5212)
    Sensitivity = Tag('Sensitivity', "Sensitivity", 0x0018, 0x6000, [TagLink(XRay3DAcquisitionSequence),])
    RegionSpatialFormat = Tag('Region Spatial Format', "RegionSpatialFormat", 0x0018, 0x6012, [TagLink(SequenceOfUltrasoundRegions),])
    RegionDataType = Tag('Region Data Type', "RegionDataType", 0x0018, 0x6014, [TagLink(SequenceOfUltrasoundRegions),])
    RegionFlags = Tag('Region Flags', "RegionFlags", 0x0018, 0x6016, [TagLink(SequenceOfUltrasoundRegions),])
    RegionLocationMinX0 = Tag('Region Location Min X0', "RegionLocationMinX0", 0x0018, 0x6018, [TagLink(SequenceOfUltrasoundRegions),])
    RegionLocationMinY0 = Tag('Region Location Min Y0', "RegionLocationMinY0", 0x0018, 0x601A, [TagLink(SequenceOfUltrasoundRegions),])
    RegionLocationMaxX1 = Tag('Region Location Max X1', "RegionLocationMaxX1", 0x0018, 0x601C, [TagLink(SequenceOfUltrasoundRegions),])
    RegionLocationMaxY1 = Tag('Region Location Max Y1', "RegionLocationMaxY1", 0x0018, 0x601E, [TagLink(SequenceOfUltrasoundRegions),])
    ReferencePixelX0 = Tag('Reference Pixel X0', "ReferencePixelX0", 0x0018, 0x6020, [TagLink(SequenceOfUltrasoundRegions),])
    ReferencePixelY0 = Tag('Reference Pixel Y0', "ReferencePixelY0", 0x0018, 0x6022, [TagLink(SequenceOfUltrasoundRegions),])
    PhysicalUnitsXDirection = Tag('Physical Units X Direction', "PhysicalUnitsXDirection", 0x0018, 0x6024, [TagLink(SequenceOfUltrasoundRegions),])
    PhysicalUnitsYDirection = Tag('Physical Units Y Direction', "PhysicalUnitsYDirection", 0x0018, 0x6026, [TagLink(SequenceOfUltrasoundRegions),])
    ReferencePixelPhysicalValueX = Tag('Reference Pixel Physical Value X', "ReferencePixelPhysicalValueX", 0x0018, 0x6028, [TagLink(SequenceOfUltrasoundRegions),])
    ReferencePixelPhysicalValueY = Tag('Reference Pixel Physical Value Y', "ReferencePixelPhysicalValueY", 0x0018, 0x602A, [TagLink(SequenceOfUltrasoundRegions),])
    PhysicalDeltaX = Tag('Physical Delta X', "PhysicalDeltaX", 0x0018, 0x602C, [TagLink(SequenceOfUltrasoundRegions),])
    PhysicalDeltaY = Tag('Physical Delta Y', "PhysicalDeltaY", 0x0018, 0x602E, [TagLink(SequenceOfUltrasoundRegions),])
    TransducerFrequency = Tag('Transducer Frequency', "TransducerFrequency", 0x0018, 0x6030, [TagLink(SequenceOfUltrasoundRegions),])
    TransducerType = Tag('Transducer Type', "TransducerType", 0x0018, 0x6031)
    PulseRepetitionFrequency = Tag('Pulse Repetition Frequency', "PulseRepetitionFrequency", 0x0018, 0x6032, [TagLink(SequenceOfUltrasoundRegions),])
    DopplerCorrectionAngle = Tag('Doppler Correction Angle', "DopplerCorrectionAngle", 0x0018, 0x6034, [TagLink(SequenceOfUltrasoundRegions),])
    SteeringAngle = Tag('Steering Angle', "SteeringAngle", 0x0018, 0x6036, [TagLink(SequenceOfUltrasoundRegions),])
    DopplerSampleVolumeXPositionRetired = Tag('Doppler Sample Volume X Position (Retired)', "DopplerSampleVolumeXPositionRetired", 0x0018, 0x6038)
    DopplerSampleVolumeXPosition = Tag('Doppler Sample Volume X Position', "DopplerSampleVolumeXPosition", 0x0018, 0x6039, [TagLink(SequenceOfUltrasoundRegions),])
    DopplerSampleVolumeYPositionRetired = Tag('Doppler Sample Volume Y Position (Retired)', "DopplerSampleVolumeYPositionRetired", 0x0018, 0x603A)
    DopplerSampleVolumeYPosition = Tag('Doppler Sample Volume Y Position', "DopplerSampleVolumeYPosition", 0x0018, 0x603B, [TagLink(SequenceOfUltrasoundRegions),])
    TMLinePositionX0Retired = Tag('TM-Line Position X0 (Retired)', "TMLinePositionX0Retired", 0x0018, 0x603C)
    TMLinePositionX0 = Tag('TM-Line Position X0', "TMLinePositionX0", 0x0018, 0x603D, [TagLink(SequenceOfUltrasoundRegions),])
    TMLinePositionY0Retired = Tag('TM-Line Position Y0 (Retired)', "TMLinePositionY0Retired", 0x0018, 0x603E)
    TMLinePositionY0 = Tag('TM-Line Position Y0', "TMLinePositionY0", 0x0018, 0x603F, [TagLink(SequenceOfUltrasoundRegions),])
    TMLinePositionX1Retired = Tag('TM-Line Position X1 (Retired)', "TMLinePositionX1Retired", 0x0018, 0x6040)
    TMLinePositionX1 = Tag('TM-Line Position X1', "TMLinePositionX1", 0x0018, 0x6041, [TagLink(SequenceOfUltrasoundRegions),])
    TMLinePositionY1Retired = Tag('TM-Line Position Y1 (Retired)', "TMLinePositionY1Retired", 0x0018, 0x6042)
    TMLinePositionY1 = Tag('TM-Line Position Y1', "TMLinePositionY1", 0x0018, 0x6043, [TagLink(SequenceOfUltrasoundRegions),])
    PixelComponentOrganization = Tag('Pixel Component Organization', "PixelComponentOrganization", 0x0018, 0x6044, [TagLink(SequenceOfUltrasoundRegions),])
    PixelComponentMask = Tag('Pixel Component Mask', "PixelComponentMask", 0x0018, 0x6046, [TagLink(SequenceOfUltrasoundRegions),])
    PixelComponentRangeStart = Tag('Pixel Component Range Start', "PixelComponentRangeStart", 0x0018, 0x6048, [TagLink(SequenceOfUltrasoundRegions),])
    PixelComponentRangeStop = Tag('Pixel Component Range Stop', "PixelComponentRangeStop", 0x0018, 0x604A, [TagLink(SequenceOfUltrasoundRegions),])
    PixelComponentPhysicalUnits = Tag('Pixel Component Physical Units', "PixelComponentPhysicalUnits", 0x0018, 0x604C, [TagLink(SequenceOfUltrasoundRegions),])
    PixelComponentDataType = Tag('Pixel Component Data Type', "PixelComponentDataType", 0x0018, 0x604E, [TagLink(SequenceOfUltrasoundRegions),])
    NumberOfTableBreakPoints = Tag('Number of Table Break Points', "NumberOfTableBreakPoints", 0x0018, 0x6050, [TagLink(SequenceOfUltrasoundRegions),])
    TableOfXBreakPoints = Tag('Table of X Break Points', "TableOfXBreakPoints", 0x0018, 0x6052, [TagLink(SequenceOfUltrasoundRegions),])
    TableOfYBreakPoints = Tag('Table of Y Break Points', "TableOfYBreakPoints", 0x0018, 0x6054, [TagLink(SequenceOfUltrasoundRegions),])
    NumberOfTableEntries = Tag('Number of Table Entries', "NumberOfTableEntries", 0x0018, 0x6056, [TagLink(SequenceOfUltrasoundRegions),])
    TableOfPixelValues = Tag('Table of Pixel Values', "TableOfPixelValues", 0x0018, 0x6058, [TagLink(SequenceOfUltrasoundRegions),])
    TableOfParameterValues = Tag('Table of Parameter Values', "TableOfParameterValues", 0x0018, 0x605A, [TagLink(SequenceOfUltrasoundRegions),])
    RWaveTimeVector = Tag('R Wave Time Vector', "RWaveTimeVector", 0x0018, 0x6060)
    ActiveImageAreaOverlayGroup = Tag('Active Image Area Overlay Group', "ActiveImageAreaOverlayGroup", 0x0018, 0x6070, [TagLink(SequenceOfUltrasoundRegions),])
    DetectorConditionsNominalFlag = Tag('Detector Conditions Nominal Flag', "DetectorConditionsNominalFlag", 0x0018, 0x7000, [TagLink(XRay3DAcquisitionSequence),])
    DetectorTemperature = Tag('Detector Temperature', "DetectorTemperature", 0x0018, 0x7001, [TagLink(XRay3DAcquisitionSequence),])
    DetectorType = Tag('Detector Type', "DetectorType", 0x0018, 0x7004, [TagLink(ContributingSourcesSequence),TagLink(XRay3DAcquisitionSequence),])
    DetectorConfiguration = Tag('Detector Configuration', "DetectorConfiguration", 0x0018, 0x7005, [TagLink(XRay3DAcquisitionSequence),])
    DetectorDescription = Tag('Detector Description', "DetectorDescription", 0x0018, 0x7006, [TagLink(XRay3DAcquisitionSequence),])
    DetectorMode = Tag('Detector Mode', "DetectorMode", 0x0018, 0x7008, [TagLink(XRay3DAcquisitionSequence),])
    DetectorID = Tag('Detector ID', "DetectorID", 0x0018, 0x700A, [TagLink(ContributingSourcesSequence),TagLink(XRay3DAcquisitionSequence),])
    DateOfLastDetectorCalibration = Tag('Date of Last Detector Calibration', "DateOfLastDetectorCalibration", 0x0018, 0x700C, [TagLink(ContributingSourcesSequence),TagLink(XRay3DAcquisitionSequence),])
    TimeOfLastDetectorCalibration = Tag('Time of Last Detector Calibration', "TimeOfLastDetectorCalibration", 0x0018, 0x700E, [TagLink(ContributingSourcesSequence),TagLink(XRay3DAcquisitionSequence),])
    ExposuresOnDetectorSinceLastCalibration = Tag('Exposures on Detector Since Last Calibration', "ExposuresOnDetectorSinceLastCalibration", 0x0018, 0x7010, [TagLink(XRay3DAcquisitionSequence),])
    ExposuresOnDetectorSinceManufactured = Tag('Exposures on Detector Since Manufactured', "ExposuresOnDetectorSinceManufactured", 0x0018, 0x7011, [TagLink(XRay3DAcquisitionSequence),])
    DetectorTimeSinceLastExposure = Tag('Detector Time Since Last Exposure', "DetectorTimeSinceLastExposure", 0x0018, 0x7012, [TagLink(XRay3DAcquisitionSequence),])
    FrameDetectorParametersSequence = Tag('Frame Detector Parameters Sequence', "FrameDetectorParametersSequence", 0x0018, 0x9451, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    DetectorActiveTime = Tag('Detector Active Time', "DetectorActiveTime", 0x0018, 0x7014, [TagLink(FrameDetectorParametersSequence),])
    DetectorActivationOffsetFromExposure = Tag('Detector Activation Offset From Exposure', "DetectorActivationOffsetFromExposure", 0x0018, 0x7016, [TagLink(FrameDetectorParametersSequence),])
    DetectorBinning = Tag('Detector Binning', "DetectorBinning", 0x0018, 0x701A, [TagLink(XRay3DAcquisitionSequence),TagLink(XAPlaneDetailsSequence),])
    DetectorElementPhysicalSize = Tag('Detector Element Physical Size', "DetectorElementPhysicalSize", 0x0018, 0x7020, [TagLink(XRay3DAcquisitionSequence),])
    DetectorElementSpacing = Tag('Detector Element Spacing', "DetectorElementSpacing", 0x0018, 0x7022, [TagLink(ContributingSourcesSequence),TagLink(XRay3DAcquisitionSequence),])
    DetectorActiveShape = Tag('Detector Active Shape', "DetectorActiveShape", 0x0018, 0x7024, [TagLink(XRay3DAcquisitionSequence),])
    DetectorActiveDimensions = Tag('Detector Active Dimension(s)', "DetectorActiveDimensions", 0x0018, 0x7026, [TagLink(XRay3DAcquisitionSequence),])
    DetectorActiveOrigin = Tag('Detector Active Origin', "DetectorActiveOrigin", 0x0018, 0x7028, [TagLink(XRay3DAcquisitionSequence),])
    DetectorManufacturerName = Tag('Detector Manufacturer Name', "DetectorManufacturerName", 0x0018, 0x702A, [TagLink(XRay3DAcquisitionSequence),])
    DetectorManufacturerModelName = Tag("Detector Manufacturer's Model Name", "DetectorManufacturerModelName", 0x0018, 0x702B, [TagLink(XRay3DAcquisitionSequence),])
    FieldOfViewOrigin = Tag('Field of View Origin', "FieldOfViewOrigin", 0x0018, 0x7030, [TagLink(FieldOfViewSequence),TagLink(XRay3DAcquisitionSequence),])
    FieldOfViewRotation = Tag('Field of View Rotation', "FieldOfViewRotation", 0x0018, 0x7032, [TagLink(FieldOfViewSequence),TagLink(XRay3DAcquisitionSequence),])
    FieldOfViewHorizontalFlip = Tag('Field of View Horizontal Flip', "FieldOfViewHorizontalFlip", 0x0018, 0x7034, [TagLink(FieldOfViewSequence),TagLink(XRay3DAcquisitionSequence),])
    PixelDataAreaOriginRelativeToFOV = Tag('Pixel Data Area Origin Relative To FOV', "PixelDataAreaOriginRelativeToFOV", 0x0018, 0x7036, [TagLink(FramePixelDataPropertiesSequence),])
    PixelDataAreaRotationAngleRelativeToFOV = Tag('Pixel Data Area Rotation Angle Relative To FOV', "PixelDataAreaRotationAngleRelativeToFOV", 0x0018, 0x7038, [TagLink(FramePixelDataPropertiesSequence),])
    GridAbsorbingMaterial = Tag('Grid Absorbing Material', "GridAbsorbingMaterial", 0x0018, 0x7040, [TagLink(XRay3DAcquisitionSequence),TagLink(PerFrameFunctionalGroupsSequence, True),])
    GridSpacingMaterial = Tag('Grid Spacing Material', "GridSpacingMaterial", 0x0018, 0x7041, [TagLink(XRay3DAcquisitionSequence),TagLink(PerFrameFunctionalGroupsSequence, True),])
    GridThickness = Tag('Grid Thickness', "GridThickness", 0x0018, 0x7042, [TagLink(XRay3DAcquisitionSequence),TagLink(PerFrameFunctionalGroupsSequence, True),])
    GridPitch = Tag('Grid Pitch', "GridPitch", 0x0018, 0x7044, [TagLink(XRay3DAcquisitionSequence),TagLink(PerFrameFunctionalGroupsSequence, True),])
    GridAspectRatio = Tag('Grid Aspect Ratio', "GridAspectRatio", 0x0018, 0x7046, [TagLink(XRay3DAcquisitionSequence),TagLink(PerFrameFunctionalGroupsSequence, True),])
    GridPeriod = Tag('Grid Period', "GridPeriod", 0x0018, 0x7048, [TagLink(XRay3DAcquisitionSequence),TagLink(PerFrameFunctionalGroupsSequence, True),])
    GridFocalDistance = Tag('Grid Focal Distance', "GridFocalDistance", 0x0018, 0x704C, [TagLink(XRay3DAcquisitionSequence),TagLink(PerFrameFunctionalGroupsSequence, True),])
    FilterMaterial = Tag('Filter Material', "FilterMaterial", 0x0018, 0x7050, [TagLink(CTAdditionalXRaySourceSequence),TagLink(CTXRayDetailsSequence),TagLink(XRay3DAcquisitionSequence),TagLink(XRayFilterSequence),TagLink(XRayFilterDetailsSequence),])
    FilterThicknessMinimum = Tag('Filter Thickness Minimum', "FilterThicknessMinimum", 0x0018, 0x7052, [TagLink(XRay3DAcquisitionSequence),TagLink(XRayFilterSequence),TagLink(XRayFilterDetailsSequence),])
    FilterThicknessMaximum = Tag('Filter Thickness Maximum', "FilterThicknessMaximum", 0x0018, 0x7054, [TagLink(XRay3DAcquisitionSequence),TagLink(XRayFilterSequence),TagLink(XRayFilterDetailsSequence),])
    FilterBeamPathLengthMinimum = Tag('Filter Beam Path Length Minimum', "FilterBeamPathLengthMinimum", 0x0018, 0x7056, [TagLink(XRay3DAcquisitionSequence),TagLink(XRayFilterSequence),])
    FilterBeamPathLengthMaximum = Tag('Filter Beam Path Length Maximum', "FilterBeamPathLengthMaximum", 0x0018, 0x7058, [TagLink(XRay3DAcquisitionSequence),TagLink(XRayFilterSequence),])
    ExposureControlMode = Tag('Exposure Control Mode', "ExposureControlMode", 0x0018, 0x7060, [TagLink(XRay3DAcquisitionSequence),])
    ExposureControlModeDescription = Tag('Exposure Control Mode Description', "ExposureControlModeDescription", 0x0018, 0x7062, [TagLink(XRay3DAcquisitionSequence),])
    ExposureStatus = Tag('Exposure Status', "ExposureStatus", 0x0018, 0x7064)
    PhototimerSetting = Tag('Phototimer Setting', "PhototimerSetting", 0x0018, 0x7065)
    ExposureTimeInuS = Tag('Exposure Time in \xb5S', "ExposureTimeInuS", 0x0018, 0x8150, [TagLink(RTImageFramekVRadiationAcquisitionSequence),TagLink(KVImagingGenerationParametersSequence),])
    XRayTubeCurrentInuA = Tag('X-Ray Tube Current in \xb5A', "XRayTubeCurrentInuA", 0x0018, 0x8151, [TagLink(RTImageFramekVRadiationAcquisitionSequence),TagLink(KVImagingGenerationParametersSequence),])
    ContentQualification = Tag('Content Qualification', "ContentQualification", 0x0018, 0x9004, [TagLink(AcquisitionProtocolElementSequence),TagLink(ReconstructionProtocolElementSequence),])
    PulseSequenceName = Tag('Pulse Sequence Name', "PulseSequenceName", 0x0018, 0x9005)
    EchoPulseSequence = Tag('Echo Pulse Sequence', "EchoPulseSequence", 0x0018, 0x9008)
    MRModifierSequence = Tag('MR Modifier Sequence', "MRModifierSequence", 0x0018, 0x9115, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    InversionRecovery = Tag('Inversion Recovery', "InversionRecovery", 0x0018, 0x9009, [TagLink(MRModifierSequence),])
    FlowCompensation = Tag('Flow Compensation', "FlowCompensation", 0x0018, 0x9010, [TagLink(MRModifierSequence),])
    MultipleSpinEcho = Tag('Multiple Spin Echo', "MultipleSpinEcho", 0x0018, 0x9011)
    MultiPlanarExcitation = Tag('Multi-planar Excitation', "MultiPlanarExcitation", 0x0018, 0x9012)
    PhaseContrast = Tag('Phase Contrast', "PhaseContrast", 0x0018, 0x9014)
    TimeOfFlightContrast = Tag('Time of Flight Contrast', "TimeOfFlightContrast", 0x0018, 0x9015)
    Spoiling = Tag('Spoiling', "Spoiling", 0x0018, 0x9016, [TagLink(MRModifierSequence),])
    SteadyStatePulseSequence = Tag('Steady State Pulse Sequence', "SteadyStatePulseSequence", 0x0018, 0x9017)
    EchoPlanarPulseSequence = Tag('Echo Planar Pulse Sequence', "EchoPlanarPulseSequence", 0x0018, 0x9018)
    TagAngleFirstAxis = Tag('Tag Angle First Axis', "TagAngleFirstAxis", 0x0018, 0x9019, [TagLink(MRImagingModifierSequence),])
    MagnetizationTransfer = Tag('Magnetization Transfer', "MagnetizationTransfer", 0x0018, 0x9020, [TagLink(MRImagingModifierSequence),])
    T2Preparation = Tag('T2 Preparation', "T2Preparation", 0x0018, 0x9021, [TagLink(MRModifierSequence),])
    BloodSignalNulling = Tag('Blood Signal Nulling', "BloodSignalNulling", 0x0018, 0x9022, [TagLink(MRImagingModifierSequence),])
    SaturationRecovery = Tag('Saturation Recovery', "SaturationRecovery", 0x0018, 0x9024)
    SpectrallySelectedSuppression = Tag('Spectrally Selected Suppression', "SpectrallySelectedSuppression", 0x0018, 0x9025)
    SpectrallySelectedExcitation = Tag('Spectrally Selected Excitation', "SpectrallySelectedExcitation", 0x0018, 0x9026, [TagLink(MRModifierSequence),])
    SpatialPresaturation = Tag('Spatial Pre-saturation', "SpatialPresaturation", 0x0018, 0x9027, [TagLink(MRModifierSequence),])
    Tagging = Tag('Tagging', "Tagging", 0x0018, 0x9028, [TagLink(MRImagingModifierSequence),])
    OversamplingPhase = Tag('Oversampling Phase', "OversamplingPhase", 0x0018, 0x9029)
    TagSpacingFirstDimension = Tag('Tag Spacing First Dimension', "TagSpacingFirstDimension", 0x0018, 0x9030, [TagLink(MRImagingModifierSequence),])
    GeometryOfKSpaceTraversal = Tag('Geometry of k-Space Traversal', "GeometryOfKSpaceTraversal", 0x0018, 0x9032)
    SegmentedKSpaceTraversal = Tag('Segmented k-Space Traversal', "SegmentedKSpaceTraversal", 0x0018, 0x9033)
    RectilinearPhaseEncodeReordering = Tag('Rectilinear Phase Encode Reordering', "RectilinearPhaseEncodeReordering", 0x0018, 0x9034)
    TagThickness = Tag('Tag Thickness', "TagThickness", 0x0018, 0x9035, [TagLink(MRImagingModifierSequence),])
    PartialFourierDirection = Tag('Partial Fourier Direction', "PartialFourierDirection", 0x0018, 0x9036, [TagLink(MRModifierSequence),])
    CardiacSynchronizationTechnique = Tag('Cardiac Synchronization Technique', "CardiacSynchronizationTechnique", 0x0018, 0x9037, [TagLink(CTXRayDetailsSequence),])
    ReceiveCoilManufacturerName = Tag('Receive Coil Manufacturer Name', "ReceiveCoilManufacturerName", 0x0018, 0x9041, [TagLink(MRReceiveCoilSequence),])
    ReceiveCoilType = Tag('Receive Coil Type', "ReceiveCoilType", 0x0018, 0x9043, [TagLink(MRReceiveCoilSequence),])
    QuadratureReceiveCoil = Tag('Quadrature Receive Coil', "QuadratureReceiveCoil", 0x0018, 0x9044, [TagLink(MRReceiveCoilSequence),])
    MultiCoilDefinitionSequence = Tag('Multi-Coil Definition Sequence', "MultiCoilDefinitionSequence", 0x0018, 0x9045, [TagLink(MRReceiveCoilSequence),])
    MultiCoilConfiguration = Tag('Multi-Coil Configuration', "MultiCoilConfiguration", 0x0018, 0x9046, [TagLink(MRReceiveCoilSequence),])
    MultiCoilElementName = Tag('Multi-Coil Element Name', "MultiCoilElementName", 0x0018, 0x9047, [TagLink(MultiCoilDefinitionSequence),])
    MultiCoilElementUsed = Tag('Multi-Coil Element Used', "MultiCoilElementUsed", 0x0018, 0x9048, [TagLink(MultiCoilDefinitionSequence),])
    TransmitCoilManufacturerName = Tag('Transmit Coil Manufacturer Name', "TransmitCoilManufacturerName", 0x0018, 0x9050, [TagLink(MRTransmitCoilSequence),])
    TransmitCoilType = Tag('Transmit Coil Type', "TransmitCoilType", 0x0018, 0x9051, [TagLink(MRTransmitCoilSequence),])
    SpectralWidth = Tag('Spectral Width', "SpectralWidth", 0x0018, 0x9052)
    ChemicalShiftReference = Tag('Chemical Shift Reference', "ChemicalShiftReference", 0x0018, 0x9053)
    VolumeLocalizationTechnique = Tag('Volume Localization Technique', "VolumeLocalizationTechnique", 0x0018, 0x9054)
    MRAcquisitionFrequencyEncodingSteps = Tag('MR Acquisition Frequency Encoding Steps', "MRAcquisitionFrequencyEncodingSteps", 0x0018, 0x9058, [TagLink(MRFOVGeometrySequence),])
    Decoupling = Tag('De-coupling', "Decoupling", 0x0018, 0x9059)
    DecoupledNucleus = Tag('De-coupled Nucleus', "DecoupledNucleus", 0x0018, 0x9060)
    DecouplingFrequency = Tag('De-coupling Frequency', "DecouplingFrequency", 0x0018, 0x9061)
    DecouplingMethod = Tag('De-coupling Method', "DecouplingMethod", 0x0018, 0x9062)
    DecouplingChemicalShiftReference = Tag('De-coupling Chemical Shift Reference', "DecouplingChemicalShiftReference", 0x0018, 0x9063)
    KSpaceFiltering = Tag('k-space Filtering', "KSpaceFiltering", 0x0018, 0x9064)
    TimeDomainFiltering = Tag('Time Domain Filtering', "TimeDomainFiltering", 0x0018, 0x9065)
    NumberOfZeroFills = Tag('Number of Zero Fills', "NumberOfZeroFills", 0x0018, 0x9066)
    BaselineCorrection = Tag('Baseline Correction', "BaselineCorrection", 0x0018, 0x9067)
    ParallelReductionFactorInPlane = Tag('Parallel Reduction Factor In-plane', "ParallelReductionFactorInPlane", 0x0018, 0x9069, [TagLink(MRModifierSequence),])
    CardiacRRIntervalSpecified = Tag('Cardiac R-R Interval Specified', "CardiacRRIntervalSpecified", 0x0018, 0x9070, [TagLink(CTXRayDetailsSequence),])
    AcquisitionDuration = Tag('Acquisition Duration', "AcquisitionDuration", 0x0018, 0x9073)
    FrameContentSequence = Tag('Frame Content Sequence', "FrameContentSequence", 0x0020, 0x9111, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    FrameAcquisitionDateTime = Tag('Frame Acquisition DateTime', "FrameAcquisitionDateTime", 0x0018, 0x9074, [TagLink(FrameContentSequence),])
    MRDiffusionSequence = Tag('MR Diffusion Sequence', "MRDiffusionSequence", 0x0018, 0x9117, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    DiffusionDirectionality = Tag('Diffusion Directionality', "DiffusionDirectionality", 0x0018, 0x9075, [TagLink(MRDiffusionSequence),])
    DiffusionGradientDirectionSequence = Tag('Diffusion Gradient Direction Sequence', "DiffusionGradientDirectionSequence", 0x0018, 0x9076, [TagLink(MRDiffusionSequence),])
    ParallelAcquisition = Tag('Parallel Acquisition', "ParallelAcquisition", 0x0018, 0x9077, [TagLink(MRModifierSequence),])
    ParallelAcquisitionTechnique = Tag('Parallel Acquisition Technique', "ParallelAcquisitionTechnique", 0x0018, 0x9078, [TagLink(MRModifierSequence),])
    InversionTimes = Tag('Inversion Times', "InversionTimes", 0x0018, 0x9079, [TagLink(MRModifierSequence),])
    MetaboliteMapDescription = Tag('Metabolite Map Description', "MetaboliteMapDescription", 0x0018, 0x9080, [TagLink(MRMetaboliteMapSequence),])
    PartialFourier = Tag('Partial Fourier', "PartialFourier", 0x0018, 0x9081, [TagLink(MRModifierSequence),])
    MREchoSequence = Tag('MR Echo Sequence', "MREchoSequence", 0x0018, 0x9114, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    EffectiveEchoTime = Tag('Effective Echo Time', "EffectiveEchoTime", 0x0018, 0x9082, [TagLink(MREchoSequence),])
    ChemicalShiftSequence = Tag('Chemical Shift Sequence', "ChemicalShiftSequence", 0x0018, 0x9084, [TagLink(MRMetaboliteMapSequence),])
    CardiacSignalSource = Tag('Cardiac Signal Source', "CardiacSignalSource", 0x0018, 0x9085, [TagLink(CTXRayDetailsSequence),])
    DiffusionBValue = Tag('Diffusion b-value', "DiffusionBValue", 0x0018, 0x9087, [TagLink(MRDiffusionSequence),])
    DiffusionGradientOrientation = Tag('Diffusion Gradient Orientation', "DiffusionGradientOrientation", 0x0018, 0x9089, [TagLink(DiffusionGradientDirectionSequence),])
    VelocityEncodingAcquisitionSequence = Tag('Velocity Encoding Acquisition Sequence', "VelocityEncodingAcquisitionSequence", 0x0018, 0x9092)
    MRVelocityEncodingSequence = Tag('MR Velocity Encoding Sequence', "MRVelocityEncodingSequence", 0x0018, 0x9197, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    VelocityEncodingDirection = Tag('Velocity Encoding Direction', "VelocityEncodingDirection", 0x0018, 0x9090, [TagLink(VelocityEncodingAcquisitionSequence),TagLink(MRVelocityEncodingSequence),])
    VelocityEncodingMinimumValue = Tag('Velocity Encoding Minimum Value', "VelocityEncodingMinimumValue", 0x0018, 0x9091, [TagLink(MRVelocityEncodingSequence),])
    NumberOfKSpaceTrajectories = Tag('Number of k-Space Trajectories', "NumberOfKSpaceTrajectories", 0x0018, 0x9093)
    CoverageOfKSpace = Tag('Coverage of k-Space', "CoverageOfKSpace", 0x0018, 0x9094)
    SpectroscopyAcquisitionPhaseRows = Tag('Spectroscopy Acquisition Phase Rows', "SpectroscopyAcquisitionPhaseRows", 0x0018, 0x9095, [TagLink(MRSpectroscopyFOVGeometrySequence),])
    ParallelReductionFactorInPlaneRetired = Tag('Parallel Reduction Factor In-plane (Retired)', "ParallelReductionFactorInPlaneRetired", 0x0018, 0x9096)
    TransmitterFrequency = Tag('Transmitter Frequency', "TransmitterFrequency", 0x0018, 0x9098, [TagLink(MRImagingModifierSequence),])
    ResonantNucleus = Tag('Resonant Nucleus', "ResonantNucleus", 0x0018, 0x9100)
    FrequencyCorrection = Tag('Frequency Correction', "FrequencyCorrection", 0x0018, 0x9101)
    MRSpatialSaturationSequence = Tag('MR Spatial Saturation Sequence', "MRSpatialSaturationSequence", 0x0018, 0x9107, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    VolumeLocalizationSequence = Tag('Volume Localization Sequence', "VolumeLocalizationSequence", 0x0018, 0x9126)
    SlabThickness = Tag('Slab Thickness', "SlabThickness", 0x0018, 0x9104, [TagLink(MRSpatialSaturationSequence),TagLink(VolumeLocalizationSequence),])
    SlabOrientation = Tag('Slab Orientation', "SlabOrientation", 0x0018, 0x9105, [TagLink(MRSpatialSaturationSequence),TagLink(VolumeLocalizationSequence),])
    MidSlabPosition = Tag('Mid Slab Position', "MidSlabPosition", 0x0018, 0x9106, [TagLink(MRSpatialSaturationSequence),TagLink(VolumeLocalizationSequence),])
    SpectroscopyAcquisitionDataColumns = Tag('Spectroscopy Acquisition Data Columns', "SpectroscopyAcquisitionDataColumns", 0x0018, 0x9127, [TagLink(MRSpectroscopyFOVGeometrySequence),])
    DiffusionAnisotropyType = Tag('Diffusion Anisotropy Type', "DiffusionAnisotropyType", 0x0018, 0x9147, [TagLink(MRDiffusionSequence),])
    FrameReferenceDateTime = Tag('Frame Reference DateTime', "FrameReferenceDateTime", 0x0018, 0x9151, [TagLink(FrameContentSequence),])
    ParallelReductionFactorOutOfPlane = Tag('Parallel Reduction Factor out-of-plane', "ParallelReductionFactorOutOfPlane", 0x0018, 0x9155, [TagLink(MRModifierSequence),])
    SpectroscopyAcquisitionOutOfPlanePhaseSteps = Tag('Spectroscopy Acquisition Out-of-plane Phase Steps', "SpectroscopyAcquisitionOutOfPlanePhaseSteps", 0x0018, 0x9159, [TagLink(MRSpectroscopyFOVGeometrySequence),])
    BulkMotionStatus = Tag('Bulk Motion Status', "BulkMotionStatus", 0x0018, 0x9166)
    ParallelReductionFactorSecondInPlane = Tag('Parallel Reduction Factor Second In-plane', "ParallelReductionFactorSecondInPlane", 0x0018, 0x9168, [TagLink(MRModifierSequence),])
    CardiacBeatRejectionTechnique = Tag('Cardiac Beat Rejection Technique', "CardiacBeatRejectionTechnique", 0x0018, 0x9169, [TagLink(CTXRayDetailsSequence),])
    MotionSynchronizationSequence = Tag('Motion Synchronization Sequence', "MotionSynchronizationSequence", 0x300A, 0x0410, [TagLink(PatientSetupSequence),])
    RespiratoryMotionCompensationTechnique = Tag('Respiratory Motion Compensation Technique', "RespiratoryMotionCompensationTechnique", 0x0018, 0x9170, [TagLink(MotionSynchronizationSequence),TagLink(CTXRayDetailsSequence),])
    RespiratorySignalSource = Tag('Respiratory Signal Source', "RespiratorySignalSource", 0x0018, 0x9171, [TagLink(MotionSynchronizationSequence),TagLink(CTXRayDetailsSequence),])
    BulkMotionCompensationTechnique = Tag('Bulk Motion Compensation Technique', "BulkMotionCompensationTechnique", 0x0018, 0x9172)
    BulkMotionSignalSource = Tag('Bulk Motion Signal Source', "BulkMotionSignalSource", 0x0018, 0x9173)
    ApplicableSafetyStandardAgency = Tag('Applicable Safety Standard Agency', "ApplicableSafetyStandardAgency", 0x0018, 0x9174)
    ApplicableSafetyStandardDescription = Tag('Applicable Safety Standard Description', "ApplicableSafetyStandardDescription", 0x0018, 0x9175)
    OperatingModeSequence = Tag('Operating Mode Sequence', "OperatingModeSequence", 0x0018, 0x9176, [TagLink(MRTimingAndRelatedParametersSequence),])
    OperatingModeType = Tag('Operating Mode Type', "OperatingModeType", 0x0018, 0x9177, [TagLink(OperatingModeSequence),])
    OperatingMode = Tag('Operating Mode', "OperatingMode", 0x0018, 0x9178, [TagLink(OperatingModeSequence),])
    SpecificAbsorptionRateSequence = Tag('Specific Absorption Rate Sequence', "SpecificAbsorptionRateSequence", 0x0018, 0x9239, [TagLink(MRTimingAndRelatedParametersSequence),])
    SpecificAbsorptionRateDefinition = Tag('Specific Absorption Rate Definition', "SpecificAbsorptionRateDefinition", 0x0018, 0x9179, [TagLink(SpecificAbsorptionRateSequence),])
    GradientOutputType = Tag('Gradient Output Type', "GradientOutputType", 0x0018, 0x9180, [TagLink(MRTimingAndRelatedParametersSequence),])
    SpecificAbsorptionRateValue = Tag('Specific Absorption Rate Value', "SpecificAbsorptionRateValue", 0x0018, 0x9181, [TagLink(SpecificAbsorptionRateSequence),])
    GradientOutput = Tag('Gradient Output', "GradientOutput", 0x0018, 0x9182, [TagLink(MRTimingAndRelatedParametersSequence),])
    FlowCompensationDirection = Tag('Flow Compensation Direction', "FlowCompensationDirection", 0x0018, 0x9183, [TagLink(MRModifierSequence),])
    TaggingDelay = Tag('Tagging Delay', "TaggingDelay", 0x0018, 0x9184, [TagLink(MRImagingModifierSequence),])
    RespiratoryMotionCompensationTechniqueDescription = Tag('Respiratory Motion Compensation Technique Description', "RespiratoryMotionCompensationTechniqueDescription", 0x0018, 0x9185, [TagLink(MotionSynchronizationSequence),])
    RespiratorySignalSourceID = Tag('Respiratory Signal Source ID', "RespiratorySignalSourceID", 0x0018, 0x9186, [TagLink(MotionSynchronizationSequence),])
    ChemicalShiftMinimumIntegrationLimitInHz = Tag('Chemical Shift Minimum Integration Limit in Hz', "ChemicalShiftMinimumIntegrationLimitInHz", 0x0018, 0x9195)
    ChemicalShiftMaximumIntegrationLimitInHz = Tag('Chemical Shift Maximum Integration Limit in Hz', "ChemicalShiftMaximumIntegrationLimitInHz", 0x0018, 0x9196)
    FirstOrderPhaseCorrection = Tag('First Order Phase Correction', "FirstOrderPhaseCorrection", 0x0018, 0x9198)
    WaterReferencedPhaseCorrection = Tag('Water Referenced Phase Correction', "WaterReferencedPhaseCorrection", 0x0018, 0x9199)
    MRSpectroscopyAcquisitionType = Tag('MR Spectroscopy Acquisition Type', "MRSpectroscopyAcquisitionType", 0x0018, 0x9200)
    RespiratoryCyclePosition = Tag('Respiratory Cycle Position', "RespiratoryCyclePosition", 0x0018, 0x9214, [TagLink(FrameContentSequence),])
    VelocityEncodingMaximumValue = Tag('Velocity Encoding Maximum Value', "VelocityEncodingMaximumValue", 0x0018, 0x9217, [TagLink(MRVelocityEncodingSequence),])
    TagSpacingSecondDimension = Tag('Tag Spacing Second Dimension', "TagSpacingSecondDimension", 0x0018, 0x9218, [TagLink(MRImagingModifierSequence),])
    TagAngleSecondAxis = Tag('Tag Angle Second Axis', "TagAngleSecondAxis", 0x0018, 0x9219, [TagLink(MRImagingModifierSequence),])
    FrameAcquisitionDuration = Tag('Frame Acquisition Duration', "FrameAcquisitionDuration", 0x0018, 0x9220, [TagLink(FrameContentSequence),TagLink(PerProjectionAcquisitionSequence),])
    MRAcquisitionPhaseEncodingStepsInPlane = Tag('MR Acquisition Phase Encoding Steps in-plane', "MRAcquisitionPhaseEncodingStepsInPlane", 0x0018, 0x9231, [TagLink(MRFOVGeometrySequence),])
    MRAcquisitionPhaseEncodingStepsOutOfPlane = Tag('MR Acquisition Phase Encoding Steps out-of-plane', "MRAcquisitionPhaseEncodingStepsOutOfPlane", 0x0018, 0x9232, [TagLink(MRFOVGeometrySequence),])
    SpectroscopyAcquisitionPhaseColumns = Tag('Spectroscopy Acquisition Phase Columns', "SpectroscopyAcquisitionPhaseColumns", 0x0018, 0x9234, [TagLink(MRSpectroscopyFOVGeometrySequence),])
    CardiacCyclePosition = Tag('Cardiac Cycle Position', "CardiacCyclePosition", 0x0018, 0x9236, [TagLink(FrameContentSequence),])
    RFEchoTrainLength = Tag('RF Echo Train Length', "RFEchoTrainLength", 0x0018, 0x9240, [TagLink(MRTimingAndRelatedParametersSequence),])
    GradientEchoTrainLength = Tag('Gradient Echo Train Length', "GradientEchoTrainLength", 0x0018, 0x9241, [TagLink(MRTimingAndRelatedParametersSequence),])
    ArterialSpinLabelingContrast = Tag('Arterial Spin Labeling Contrast', "ArterialSpinLabelingContrast", 0x0018, 0x9250)
    ASLTechniqueDescription = Tag('ASL Technique Description', "ASLTechniqueDescription", 0x0018, 0x9252, [TagLink(MRArterialSpinLabelingSequence),])
    ASLSlabNumber = Tag('ASL Slab Number', "ASLSlabNumber", 0x0018, 0x9253, [TagLink(ASLSlabSequence),])
    ASLSlabThickness = Tag('ASL Slab Thickness', "ASLSlabThickness", 0x0018, 0x9254, [TagLink(ASLSlabSequence),])
    ASLSlabOrientation = Tag('ASL Slab Orientation', "ASLSlabOrientation", 0x0018, 0x9255, [TagLink(ASLSlabSequence),])
    ASLMidSlabPosition = Tag('ASL Mid Slab Position', "ASLMidSlabPosition", 0x0018, 0x9256, [TagLink(ASLSlabSequence),])
    ASLContext = Tag('ASL Context', "ASLContext", 0x0018, 0x9257, [TagLink(MRArterialSpinLabelingSequence),])
    ASLPulseTrainDuration = Tag('ASL Pulse Train Duration', "ASLPulseTrainDuration", 0x0018, 0x9258, [TagLink(ASLSlabSequence),])
    ASLCrusherFlag = Tag('ASL Crusher Flag', "ASLCrusherFlag", 0x0018, 0x9259, [TagLink(MRArterialSpinLabelingSequence),])
    ASLCrusherFlowLimit = Tag('ASL Crusher Flow Limit', "ASLCrusherFlowLimit", 0x0018, 0x925A, [TagLink(MRArterialSpinLabelingSequence),])
    ASLCrusherDescription = Tag('ASL Crusher Description', "ASLCrusherDescription", 0x0018, 0x925B, [TagLink(MRArterialSpinLabelingSequence),])
    ASLBolusCutoffFlag = Tag('ASL Bolus Cut-off Flag', "ASLBolusCutoffFlag", 0x0018, 0x925C, [TagLink(MRArterialSpinLabelingSequence),])
    ASLBolusCutoffTimingSequence = Tag('ASL Bolus Cut-off Timing Sequence', "ASLBolusCutoffTimingSequence", 0x0018, 0x925D, [TagLink(MRArterialSpinLabelingSequence),])
    ASLBolusCutoffTechnique = Tag('ASL Bolus Cut-off Technique', "ASLBolusCutoffTechnique", 0x0018, 0x925E, [TagLink(ASLBolusCutoffTimingSequence),])
    ASLBolusCutoffDelayTime = Tag('ASL Bolus Cut-off Delay Time', "ASLBolusCutoffDelayTime", 0x0018, 0x925F, [TagLink(ASLBolusCutoffTimingSequence),])
    ChemicalShiftMinimumIntegrationLimitInppm = Tag('Chemical Shift Minimum Integration Limit in ppm', "ChemicalShiftMinimumIntegrationLimitInppm", 0x0018, 0x9295, [TagLink(ChemicalShiftSequence),])
    ChemicalShiftMaximumIntegrationLimitInppm = Tag('Chemical Shift Maximum Integration Limit in ppm', "ChemicalShiftMaximumIntegrationLimitInppm", 0x0018, 0x9296, [TagLink(ChemicalShiftSequence),])
    WaterReferenceAcquisition = Tag('Water Reference Acquisition', "WaterReferenceAcquisition", 0x0018, 0x9297)
    EchoPeakPosition = Tag('Echo Peak Position', "EchoPeakPosition", 0x0018, 0x9298)
    CTAcquisitionTypeSequence = Tag('CT Acquisition Type Sequence', "CTAcquisitionTypeSequence", 0x0018, 0x9301, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    AcquisitionType = Tag('Acquisition Type', "AcquisitionType", 0x0018, 0x9302, [TagLink(CTAcquisitionTypeSequence),TagLink(AcquisitionProtocolElementSequence),])
    TubeAngle = Tag('Tube Angle', "TubeAngle", 0x0018, 0x9303, [TagLink(CTAcquisitionTypeSequence),TagLink(AcquisitionProtocolElementSequence),])
    RevolutionTime = Tag('Revolution Time', "RevolutionTime", 0x0018, 0x9305, [TagLink(CTAcquisitionDetailsSequence),TagLink(PETDetectorMotionDetailsSequence),TagLink(AcquisitionProtocolElementSequence),])
    SingleCollimationWidth = Tag('Single Collimation Width', "SingleCollimationWidth", 0x0018, 0x9306, [TagLink(CTAcquisitionDetailsSequence),TagLink(AcquisitionProtocolElementSequence),])
    TotalCollimationWidth = Tag('Total Collimation Width', "TotalCollimationWidth", 0x0018, 0x9307, [TagLink(CTAcquisitionDetailsSequence),TagLink(AcquisitionProtocolElementSequence),])
    CTTableDynamicsSequence = Tag('CT Table Dynamics Sequence', "CTTableDynamicsSequence", 0x0018, 0x9308, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    PETTableDynamicsSequence = Tag('PET Table Dynamics Sequence', "PETTableDynamicsSequence", 0x0018, 0x9734, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    TableSpeed = Tag('Table Speed', "TableSpeed", 0x0018, 0x9309, [TagLink(CTTableDynamicsSequence),TagLink(PETTableDynamicsSequence),TagLink(AcquisitionProtocolElementSequence),])
    TableFeedPerRotation = Tag('Table Feed per Rotation', "TableFeedPerRotation", 0x0018, 0x9310, [TagLink(CTTableDynamicsSequence),TagLink(AcquisitionProtocolElementSequence),])
    SpiralPitchFactor = Tag('Spiral Pitch Factor', "SpiralPitchFactor", 0x0018, 0x9311, [TagLink(CTTableDynamicsSequence),TagLink(AcquisitionProtocolElementSequence),])
    CTPositionSequence = Tag('CT Position Sequence', "CTPositionSequence", 0x0018, 0x9326, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    PETPositionSequence = Tag('PET Position Sequence', "PETPositionSequence", 0x0018, 0x9735, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    DataCollectionCenterPatient = Tag('Data Collection Center (Patient)', "DataCollectionCenterPatient", 0x0018, 0x9313, [TagLink(CTPositionSequence),TagLink(PETPositionSequence),])
    ReconstructionAlgorithm = Tag('Reconstruction Algorithm', "ReconstructionAlgorithm", 0x0018, 0x9315, [TagLink(CTReconstructionSequence),TagLink(PETReconstructionSequence),])
    ConvolutionKernelGroup = Tag('Convolution Kernel Group', "ConvolutionKernelGroup", 0x0018, 0x9316, [TagLink(CTReconstructionSequence),TagLink(ReconstructionProtocolElementSequence),])
    ReconstructionFieldOfView = Tag('Reconstruction Field of View', "ReconstructionFieldOfView", 0x0018, 0x9317, [TagLink(CTReconstructionSequence),TagLink(PETReconstructionSequence),TagLink(ReconstructionProtocolElementSequence),])
    ReconstructionTargetCenterPatient = Tag('Reconstruction Target Center (Patient)', "ReconstructionTargetCenterPatient", 0x0018, 0x9318, [TagLink(CTPositionSequence),TagLink(PETPositionSequence),TagLink(ReconstructionProtocolElementSequence),])
    ReconstructionAngle = Tag('Reconstruction Angle', "ReconstructionAngle", 0x0018, 0x9319, [TagLink(CTReconstructionSequence),TagLink(ReconstructionProtocolElementSequence),])
    ImageFilter = Tag('Image Filter', "ImageFilter", 0x0018, 0x9320, [TagLink(CTReconstructionSequence),TagLink(ReconstructionProtocolElementSequence),TagLink(ImageFilterDetailsSequence),])
    ReconstructionPixelSpacing = Tag('Reconstruction Pixel Spacing', "ReconstructionPixelSpacing", 0x0018, 0x9322, [TagLink(CTReconstructionSequence),TagLink(ReconstructionProtocolElementSequence),])
    ExposureModulationType = Tag('Exposure Modulation Type', "ExposureModulationType", 0x0018, 0x9323, [TagLink(CTExposureSequence),TagLink(CTXRayDetailsSequence),])
    EstimatedDoseSaving = Tag('Estimated Dose Saving', "EstimatedDoseSaving", 0x0018, 0x9324)
    TablePosition = Tag('Table Position', "TablePosition", 0x0018, 0x9327, [TagLink(CTPositionSequence),TagLink(PETPositionSequence),])
    ExposureTimeInms = Tag('Exposure Time in ms', "ExposureTimeInms", 0x0018, 0x9328, [TagLink(ExposureSequence),TagLink(CTExposureSequence),TagLink(XRay3DAcquisitionSequence),TagLink(PerProjectionAcquisitionSequence),TagLink(XRayAcquisitionDoseSequence),TagLink(CTXRayDetailsSequence),TagLink(XAPlaneDetailsSequence),])
    XRayTubeCurrentInmA = Tag('X-Ray Tube Current in mA', "XRayTubeCurrentInmA", 0x0018, 0x9330, [TagLink(CTAdditionalXRaySourceSequence),TagLink(ExposureSequence),TagLink(CTExposureSequence),TagLink(FrameAcquisitionSequence),TagLink(XRay3DAcquisitionSequence),TagLink(PerProjectionAcquisitionSequence),TagLink(CTXRayDetailsSequence),TagLink(XAPlaneDetailsSequence),])
    ExposureInmAs = Tag('Exposure in mAs', "ExposureInmAs", 0x0018, 0x9332, [TagLink(CTAdditionalXRaySourceSequence),TagLink(CTExposureSequence),TagLink(XRay3DAcquisitionSequence),TagLink(PerProjectionAcquisitionSequence),TagLink(XRayAcquisitionDoseSequence),TagLink(CTXRayDetailsSequence),TagLink(XAPlaneDetailsSequence),])
    ConstantVolumeFlag = Tag('Constant Volume Flag', "ConstantVolumeFlag", 0x0018, 0x9333, [TagLink(CTAcquisitionTypeSequence),TagLink(AcquisitionProtocolElementSequence),])
    FluoroscopyFlag = Tag('Fluoroscopy Flag', "FluoroscopyFlag", 0x0018, 0x9334, [TagLink(CTAcquisitionTypeSequence),TagLink(AcquisitionProtocolElementSequence),])
    DistanceSourceToDataCollectionCenter = Tag('Distance Source to Data Collection Center', "DistanceSourceToDataCollectionCenter", 0x0018, 0x9335, [TagLink(CTGeometrySequence),])
    ContrastBolusUsageSequence = Tag('Contrast/Bolus Usage Sequence', "ContrastBolusUsageSequence", 0x0018, 0x9341, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    ContrastBolusAgentNumber = Tag('Contrast/Bolus Agent Number', "ContrastBolusAgentNumber", 0x0018, 0x9337, [TagLink(ContrastBolusAgentSequence),TagLink(ContrastBolusUsageSequence),])
    ContrastBolusAgentAdministered = Tag('Contrast/Bolus Agent Administered', "ContrastBolusAgentAdministered", 0x0018, 0x9342, [TagLink(ContrastBolusUsageSequence),])
    ContrastBolusAgentDetected = Tag('Contrast/Bolus Agent Detected', "ContrastBolusAgentDetected", 0x0018, 0x9343, [TagLink(ContrastBolusUsageSequence),])
    ContrastBolusAgentPhase = Tag('Contrast/Bolus Agent Phase', "ContrastBolusAgentPhase", 0x0018, 0x9344, [TagLink(ContrastBolusUsageSequence),])
    CTDIvol = Tag('CTDIvol', "CTDIvol", 0x0018, 0x9345, [TagLink(CTExposureSequence),TagLink(AcquisitionProtocolElementSequence),])
    CalciumScoringMassFactorPatient = Tag('Calcium Scoring Mass Factor Patient', "CalciumScoringMassFactorPatient", 0x0018, 0x9351, [TagLink(CTXRayDetailsSequence),])
    CalciumScoringMassFactorDevice = Tag('Calcium Scoring Mass Factor Device', "CalciumScoringMassFactorDevice", 0x0018, 0x9352, [TagLink(CTXRayDetailsSequence),])
    EnergyWeightingFactor = Tag('Energy Weighting Factor', "EnergyWeightingFactor", 0x0018, 0x9353, [TagLink(CTAdditionalXRaySourceSequence),TagLink(CTXRayDetailsSequence),])
    MultienergyCTAcquisition = Tag('Multi-energy CT Acquisition', "MultienergyCTAcquisition", 0x0018, 0x9361)
    MultienergyCTAcquisitionSequence = Tag('Multi-energy CT Acquisition Sequence', "MultienergyCTAcquisitionSequence", 0x0018, 0x9362)
    XRaySourceIndex = Tag('X-Ray Source Index', "XRaySourceIndex", 0x0018, 0x9366, [TagLink(MultienergyCTXRaySourceSequence),])
    XRaySourceID = Tag('X-Ray Source ID', "XRaySourceID", 0x0018, 0x9367, [TagLink(MultienergyCTXRaySourceSequence),])
    MultienergySourceTechnique = Tag('Multi-energy Source Technique', "MultienergySourceTechnique", 0x0018, 0x9368, [TagLink(MultienergyCTXRaySourceSequence),])
    SourceStartDateTime = Tag('Source Start DateTime', "SourceStartDateTime", 0x0018, 0x9369, [TagLink(MultienergyCTXRaySourceSequence),])
    SourceEndDateTime = Tag('Source End DateTime', "SourceEndDateTime", 0x0018, 0x936A, [TagLink(MultienergyCTXRaySourceSequence),])
    SwitchingPhaseNumber = Tag('Switching Phase Number', "SwitchingPhaseNumber", 0x0018, 0x936B, [TagLink(MultienergyCTXRaySourceSequence),])
    SwitchingPhaseNominalDuration = Tag('Switching Phase Nominal Duration', "SwitchingPhaseNominalDuration", 0x0018, 0x936C, [TagLink(MultienergyCTXRaySourceSequence),])
    SwitchingPhaseTransitionDuration = Tag('Switching Phase Transition Duration', "SwitchingPhaseTransitionDuration", 0x0018, 0x936D, [TagLink(MultienergyCTXRaySourceSequence),])
    MultienergyCTXRayDetectorSequence = Tag('Multi-energy CT X-Ray Detector Sequence', "MultienergyCTXRayDetectorSequence", 0x0018, 0x936F)
    EffectiveBinEnergy = Tag('Effective Bin Energy', "EffectiveBinEnergy", 0x0018, 0x936E, [TagLink(MultienergyCTXRayDetectorSequence),])
    XRayDetectorIndex = Tag('X-Ray Detector Index', "XRayDetectorIndex", 0x0018, 0x9370, [TagLink(MultienergyCTXRayDetectorSequence),])
    XRayDetectorID = Tag('X-Ray Detector ID', "XRayDetectorID", 0x0018, 0x9371, [TagLink(MultienergyCTXRayDetectorSequence),])
    MultienergyDetectorType = Tag('Multi-energy Detector Type', "MultienergyDetectorType", 0x0018, 0x9372, [TagLink(MultienergyCTXRayDetectorSequence),])
    XRayDetectorLabel = Tag('X-Ray Detector Label', "XRayDetectorLabel", 0x0018, 0x9373, [TagLink(MultienergyCTXRayDetectorSequence),])
    NominalMaxEnergy = Tag('Nominal Max Energy', "NominalMaxEnergy", 0x0018, 0x9374, [TagLink(MultienergyCTXRayDetectorSequence),])
    NominalMinEnergy = Tag('Nominal Min Energy', "NominalMinEnergy", 0x0018, 0x9375, [TagLink(MultienergyCTXRayDetectorSequence),])
    MultienergyCTPathSequence = Tag('Multi-energy CT Path Sequence', "MultienergyCTPathSequence", 0x0018, 0x9379)
    ReferencedXRayDetectorIndex = Tag('Referenced X-Ray Detector Index', "ReferencedXRayDetectorIndex", 0x0018, 0x9376, [TagLink(MultienergyCTPathSequence),])
    ReferencedXRaySourceIndex = Tag('Referenced X-Ray Source Index', "ReferencedXRaySourceIndex", 0x0018, 0x9377, [TagLink(MultienergyCTPathSequence),TagLink(CTExposureSequence),])
    ReferencedPathIndex = Tag('Referenced Path Index', "ReferencedPathIndex", 0x0018, 0x9378, [TagLink(CTAcquisitionDetailsSequence),TagLink(CTGeometrySequence),TagLink(CTXRayDetailsSequence),])
    MultienergyCTPathIndex = Tag('Multi-energy CT Path Index', "MultienergyCTPathIndex", 0x0018, 0x937A, [TagLink(MultienergyCTPathSequence),])
    MultienergyAcquisitionDescription = Tag('Multi-energy Acquisition Description', "MultienergyAcquisitionDescription", 0x0018, 0x937B, [TagLink(MultienergyCTAcquisitionSequence),])
    MonoenergeticEnergyEquivalent = Tag('Monoenergetic Energy Equivalent', "MonoenergeticEnergyEquivalent", 0x0018, 0x937C, [TagLink(MultienergyCTCharacteristicsSequence),])
    DecompositionMethod = Tag('Decomposition Method', "DecompositionMethod", 0x0018, 0x937E, [TagLink(MultienergyCTProcessingSequence),])
    DecompositionDescription = Tag('Decomposition Description', "DecompositionDescription", 0x0018, 0x937F, [TagLink(MultienergyCTProcessingSequence),])
    MaterialAttenuationSequence = Tag('Material Attenuation Sequence', "MaterialAttenuationSequence", 0x0018, 0x9382, [TagLink(DecompositionMaterialSequence),])
    PhotonEnergy = Tag('Photon Energy', "PhotonEnergy", 0x0018, 0x9383, [TagLink(MaterialAttenuationSequence),])
    XRayMassAttenuationCoefficient = Tag('X-Ray Mass Attenuation Coefficient', "XRayMassAttenuationCoefficient", 0x0018, 0x9384, [TagLink(MaterialAttenuationSequence),])
    DistanceSourceToIsocenter = Tag('Distance Source to Isocenter', "DistanceSourceToIsocenter", 0x0018, 0x9402, [TagLink(XRayGeometrySequence),TagLink(XRay3DAcquisitionSequence),])
    DistanceObjectToTableTop = Tag('Distance Object to Table Top', "DistanceObjectToTableTop", 0x0018, 0x9403, [TagLink(ProjectionPixelCalibrationSequence),])
    ObjectPixelSpacingInCenterOfBeam = Tag('Object Pixel Spacing in Center of Beam', "ObjectPixelSpacingInCenterOfBeam", 0x0018, 0x9404, [TagLink(ProjectionPixelCalibrationSequence),])
    TablePositionSequence = Tag('Table Position Sequence', "TablePositionSequence", 0x0018, 0x9406, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    PlanesInAcquisition = Tag('Planes in Acquisition', "PlanesInAcquisition", 0x0018, 0x9410, [TagLink(AcquisitionProtocolElementSequence),])
    XRayReceptorType = Tag('X-Ray Receptor Type', "XRayReceptorType", 0x0018, 0x9420, [TagLink(XRay3DAcquisitionSequence),])
    AcquisitionProtocolName = Tag('Acquisition Protocol Name', "AcquisitionProtocolName", 0x0018, 0x9423, [TagLink(ContributingSourcesSequence),])
    AcquisitionProtocolDescription = Tag('Acquisition Protocol Description', "AcquisitionProtocolDescription", 0x0018, 0x9424)
    ContrastBolusIngredientOpaque = Tag('Contrast/Bolus Ingredient Opaque', "ContrastBolusIngredientOpaque", 0x0018, 0x9425, [TagLink(ContrastBolusAgentSequence),TagLink(AcquisitionProtocolElementSequence),])
    DistanceReceptorPlaneToDetectorHousing = Tag('Distance Receptor Plane to Detector Housing', "DistanceReceptorPlaneToDetectorHousing", 0x0018, 0x9426)
    IntensifierActiveShape = Tag('Intensifier Active Shape', "IntensifierActiveShape", 0x0018, 0x9427)
    IntensifierActiveDimensions = Tag('Intensifier Active Dimension(s)', "IntensifierActiveDimensions", 0x0018, 0x9428)
    PhysicalDetectorSize = Tag('Physical Detector Size', "PhysicalDetectorSize", 0x0018, 0x9429, [TagLink(XRay3DAcquisitionSequence),])
    PositionOfIsocenterProjection = Tag('Position of Isocenter Projection', "PositionOfIsocenterProjection", 0x0018, 0x9430, [TagLink(XRay3DAcquisitionSequence),])
    FieldOfViewDescription = Tag('Field of View Description', "FieldOfViewDescription", 0x0018, 0x9433, [TagLink(FieldOfViewSequence),])
    ExposureControlSensingRegionsSequence = Tag('Exposure Control Sensing Regions Sequence', "ExposureControlSensingRegionsSequence", 0x0018, 0x9434, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    ExposureControlSensingRegionShape = Tag('Exposure Control Sensing Region Shape', "ExposureControlSensingRegionShape", 0x0018, 0x9435, [TagLink(ExposureControlSensingRegionsSequence),])
    ExposureControlSensingRegionLeftVerticalEdge = Tag('Exposure Control Sensing Region Left Vertical Edge', "ExposureControlSensingRegionLeftVerticalEdge", 0x0018, 0x9436, [TagLink(ExposureControlSensingRegionsSequence),])
    ExposureControlSensingRegionRightVerticalEdge = Tag('Exposure Control Sensing Region Right Vertical Edge', "ExposureControlSensingRegionRightVerticalEdge", 0x0018, 0x9437, [TagLink(ExposureControlSensingRegionsSequence),])
    ExposureControlSensingRegionUpperHorizontalEdge = Tag('Exposure Control Sensing Region Upper Horizontal Edge', "ExposureControlSensingRegionUpperHorizontalEdge", 0x0018, 0x9438, [TagLink(ExposureControlSensingRegionsSequence),])
    ExposureControlSensingRegionLowerHorizontalEdge = Tag('Exposure Control Sensing Region Lower Horizontal Edge', "ExposureControlSensingRegionLowerHorizontalEdge", 0x0018, 0x9439, [TagLink(ExposureControlSensingRegionsSequence),])
    CenterOfCircularExposureControlSensingRegion = Tag('Center of Circular Exposure Control Sensing Region', "CenterOfCircularExposureControlSensingRegion", 0x0018, 0x9440, [TagLink(ExposureControlSensingRegionsSequence),])
    RadiusOfCircularExposureControlSensingRegion = Tag('Radius of Circular Exposure Control Sensing Region', "RadiusOfCircularExposureControlSensingRegion", 0x0018, 0x9441, [TagLink(ExposureControlSensingRegionsSequence),])
    VerticesOfThePolygonalExposureControlSensingRegion = Tag('Vertices of the Polygonal Exposure Control Sensing Region', "VerticesOfThePolygonalExposureControlSensingRegion", 0x0018, 0x9442, [TagLink(ExposureControlSensingRegionsSequence),])
    ColumnAngulationPatient = Tag('Column Angulation (Patient)', "ColumnAngulationPatient", 0x0018, 0x9447, [TagLink(PositionerPositionSequence),])
    BeamAngle = Tag('Beam Angle', "BeamAngle", 0x0018, 0x9449, [TagLink(ProjectionPixelCalibrationSequence),])
    ObjectThicknessSequence = Tag('Object Thickness Sequence', "ObjectThicknessSequence", 0x0018, 0x9456, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    CalculatedAnatomyThickness = Tag('Calculated Anatomy Thickness', "CalculatedAnatomyThickness", 0x0018, 0x9452, [TagLink(ObjectThicknessSequence),])
    CalibrationSequence = Tag('Calibration Sequence', "CalibrationSequence", 0x0018, 0x9455, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    PlaneIdentification = Tag('Plane Identification', "PlaneIdentification", 0x0018, 0x9457, [TagLink(ContributingSourcesSequence),TagLink(XAPlaneDetailsSequence),])
    FieldOfViewDimensionsInFloat = Tag('Field of View Dimension(s) in Float', "FieldOfViewDimensionsInFloat", 0x0018, 0x9461, [TagLink(FieldOfViewSequence),TagLink(XRay3DAcquisitionSequence),TagLink(XAPlaneDetailsSequence),])
    IsocenterReferenceSystemSequence = Tag('Isocenter Reference System Sequence', "IsocenterReferenceSystemSequence", 0x0018, 0x9462, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    PositionerIsocenterPrimaryAngle = Tag('Positioner Isocenter Primary Angle', "PositionerIsocenterPrimaryAngle", 0x0018, 0x9463, [TagLink(IsocenterReferenceSystemSequence),TagLink(PerProjectionAcquisitionSequence),])
    PositionerIsocenterSecondaryAngle = Tag('Positioner Isocenter Secondary Angle', "PositionerIsocenterSecondaryAngle", 0x0018, 0x9464, [TagLink(IsocenterReferenceSystemSequence),TagLink(PerProjectionAcquisitionSequence),])
    PositionerIsocenterDetectorRotationAngle = Tag('Positioner Isocenter Detector Rotation Angle', "PositionerIsocenterDetectorRotationAngle", 0x0018, 0x9465, [TagLink(IsocenterReferenceSystemSequence),TagLink(PerProjectionAcquisitionSequence),])
    TableXPositionToIsocenter = Tag('Table X Position to Isocenter', "TableXPositionToIsocenter", 0x0018, 0x9466, [TagLink(IsocenterReferenceSystemSequence),TagLink(XRay3DAcquisitionSequence),])
    TableYPositionToIsocenter = Tag('Table Y Position to Isocenter', "TableYPositionToIsocenter", 0x0018, 0x9467, [TagLink(IsocenterReferenceSystemSequence),TagLink(XRay3DAcquisitionSequence),])
    TableZPositionToIsocenter = Tag('Table Z Position to Isocenter', "TableZPositionToIsocenter", 0x0018, 0x9468, [TagLink(IsocenterReferenceSystemSequence),TagLink(XRay3DAcquisitionSequence),])
    TableHorizontalRotationAngle = Tag('Table Horizontal Rotation Angle', "TableHorizontalRotationAngle", 0x0018, 0x9469, [TagLink(TablePositionSequence),TagLink(IsocenterReferenceSystemSequence),TagLink(XRay3DAcquisitionSequence),])
    TableHeadTiltAngle = Tag('Table Head Tilt Angle', "TableHeadTiltAngle", 0x0018, 0x9470, [TagLink(TablePositionSequence),TagLink(IsocenterReferenceSystemSequence),TagLink(XRay3DAcquisitionSequence),])
    TableCradleTiltAngle = Tag('Table Cradle Tilt Angle', "TableCradleTiltAngle", 0x0018, 0x9471, [TagLink(TablePositionSequence),TagLink(IsocenterReferenceSystemSequence),TagLink(XRay3DAcquisitionSequence),])
    AcquiredImageAreaDoseProduct = Tag('Acquired Image Area Dose Product', "AcquiredImageAreaDoseProduct", 0x0018, 0x9473)
    CArmPositionerTabletopRelationship = Tag('C-arm Positioner Tabletop Relationship', "CArmPositionerTabletopRelationship", 0x0018, 0x9474)
    PrimaryPositionerScanArc = Tag('Primary Positioner Scan Arc', "PrimaryPositionerScanArc", 0x0018, 0x9508, [TagLink(XRay3DAcquisitionSequence),TagLink(XAPlaneDetailsSequence),])
    SecondaryPositionerScanArc = Tag('Secondary Positioner Scan Arc', "SecondaryPositionerScanArc", 0x0018, 0x9509, [TagLink(XRay3DAcquisitionSequence),TagLink(XAPlaneDetailsSequence),])
    PrimaryPositionerScanStartAngle = Tag('Primary Positioner Scan Start Angle', "PrimaryPositionerScanStartAngle", 0x0018, 0x9510, [TagLink(XRay3DAcquisitionSequence),TagLink(XAPlaneDetailsSequence),])
    SecondaryPositionerScanStartAngle = Tag('Secondary Positioner Scan Start Angle', "SecondaryPositionerScanStartAngle", 0x0018, 0x9511, [TagLink(XRay3DAcquisitionSequence),TagLink(XAPlaneDetailsSequence),])
    PrimaryPositionerIncrement = Tag('Primary Positioner Increment', "PrimaryPositionerIncrement", 0x0018, 0x9514, [TagLink(XRay3DAcquisitionSequence),TagLink(XAPlaneDetailsSequence),])
    SecondaryPositionerIncrement = Tag('Secondary Positioner Increment', "SecondaryPositionerIncrement", 0x0018, 0x9515, [TagLink(XRay3DAcquisitionSequence),TagLink(XAPlaneDetailsSequence),])
    StartAcquisitionDateTime = Tag('Start Acquisition DateTime', "StartAcquisitionDateTime", 0x0018, 0x9516, [TagLink(XRay3DAcquisitionSequence),])
    EndAcquisitionDateTime = Tag('End Acquisition DateTime', "EndAcquisitionDateTime", 0x0018, 0x9517, [TagLink(XRay3DAcquisitionSequence),])
    PrimaryPositionerIncrementSign = Tag('Primary Positioner Increment Sign', "PrimaryPositionerIncrementSign", 0x0018, 0x9518, [TagLink(XRay3DAcquisitionSequence),])
    SecondaryPositionerIncrementSign = Tag('Secondary Positioner Increment Sign', "SecondaryPositionerIncrementSign", 0x0018, 0x9519, [TagLink(XRay3DAcquisitionSequence),])
    XRay3DReconstructionSequence = Tag('X-Ray 3D Reconstruction Sequence', "XRay3DReconstructionSequence", 0x0018, 0x9530)
    ApplicationName = Tag('Application Name', "ApplicationName", 0x0018, 0x9524, [TagLink(XRay3DReconstructionSequence),])
    ApplicationVersion = Tag('Application Version', "ApplicationVersion", 0x0018, 0x9525, [TagLink(XRay3DReconstructionSequence),])
    ApplicationManufacturer = Tag('Application Manufacturer', "ApplicationManufacturer", 0x0018, 0x9526, [TagLink(XRay3DReconstructionSequence),])
    AlgorithmType = Tag('Algorithm Type', "AlgorithmType", 0x0018, 0x9527, [TagLink(XRay3DReconstructionSequence),TagLink(ReconstructionProtocolElementSequence),])
    AlgorithmDescription = Tag('Algorithm Description', "AlgorithmDescription", 0x0018, 0x9528, [TagLink(XRay3DReconstructionSequence),])
    ReconstructionDescription = Tag('Reconstruction Description', "ReconstructionDescription", 0x0018, 0x9531, [TagLink(XRay3DReconstructionSequence),])
    XRaySourceIsocenterPrimaryAngle = Tag('X-Ray Source Isocenter Primary Angle', "XRaySourceIsocenterPrimaryAngle", 0x0018, 0x9543, [TagLink(IsocenterReferenceSystemSequence),])
    XRaySourceIsocenterSecondaryAngle = Tag('X-Ray Source Isocenter Secondary Angle', "XRaySourceIsocenterSecondaryAngle", 0x0018, 0x9544, [TagLink(IsocenterReferenceSystemSequence),])
    BreastSupportIsocenterPrimaryAngle = Tag('Breast Support Isocenter Primary Angle', "BreastSupportIsocenterPrimaryAngle", 0x0018, 0x9545, [TagLink(IsocenterReferenceSystemSequence),])
    BreastSupportIsocenterSecondaryAngle = Tag('Breast Support Isocenter Secondary Angle', "BreastSupportIsocenterSecondaryAngle", 0x0018, 0x9546, [TagLink(IsocenterReferenceSystemSequence),])
    BreastSupportXPositionToIsocenter = Tag('Breast Support X Position to Isocenter', "BreastSupportXPositionToIsocenter", 0x0018, 0x9547, [TagLink(IsocenterReferenceSystemSequence),])
    BreastSupportYPositionToIsocenter = Tag('Breast Support Y Position to Isocenter', "BreastSupportYPositionToIsocenter", 0x0018, 0x9548, [TagLink(IsocenterReferenceSystemSequence),])
    BreastSupportZPositionToIsocenter = Tag('Breast Support Z Position to Isocenter', "BreastSupportZPositionToIsocenter", 0x0018, 0x9549, [TagLink(IsocenterReferenceSystemSequence),])
    DetectorIsocenterPrimaryAngle = Tag('Detector Isocenter Primary Angle', "DetectorIsocenterPrimaryAngle", 0x0018, 0x9550, [TagLink(IsocenterReferenceSystemSequence),])
    DetectorIsocenterSecondaryAngle = Tag('Detector Isocenter Secondary Angle', "DetectorIsocenterSecondaryAngle", 0x0018, 0x9551, [TagLink(IsocenterReferenceSystemSequence),])
    DetectorXPositionToIsocenter = Tag('Detector X Position to Isocenter', "DetectorXPositionToIsocenter", 0x0018, 0x9552, [TagLink(IsocenterReferenceSystemSequence),])
    DetectorYPositionToIsocenter = Tag('Detector Y Position to Isocenter', "DetectorYPositionToIsocenter", 0x0018, 0x9553, [TagLink(IsocenterReferenceSystemSequence),])
    DetectorZPositionToIsocenter = Tag('Detector Z Position to Isocenter', "DetectorZPositionToIsocenter", 0x0018, 0x9554, [TagLink(IsocenterReferenceSystemSequence),])
    DetectorActiveAreaTLHCPosition = Tag('Detector Active Area TLHC Position', "DetectorActiveAreaTLHCPosition", 0x0018, 0x9557, [TagLink(IsocenterReferenceSystemSequence),])
    DetectorActiveAreaOrientation = Tag('Detector Active Area Orientation', "DetectorActiveAreaOrientation", 0x0018, 0x9558, [TagLink(IsocenterReferenceSystemSequence),])
    PositionerPrimaryAngleDirection = Tag('Positioner Primary Angle Direction', "PositionerPrimaryAngleDirection", 0x0018, 0x9559, [TagLink(PerProjectionAcquisitionSequence),TagLink(PositionerPositionSequence),])
    DiffusionBMatrixSequence = Tag('Diffusion b-matrix Sequence', "DiffusionBMatrixSequence", 0x0018, 0x9601, [TagLink(MRDiffusionSequence),])
    DiffusionBValueXX = Tag('Diffusion b-value XX', "DiffusionBValueXX", 0x0018, 0x9602, [TagLink(DiffusionBMatrixSequence),])
    DiffusionBValueXY = Tag('Diffusion b-value XY', "DiffusionBValueXY", 0x0018, 0x9603, [TagLink(DiffusionBMatrixSequence),])
    DiffusionBValueXZ = Tag('Diffusion b-value XZ', "DiffusionBValueXZ", 0x0018, 0x9604, [TagLink(DiffusionBMatrixSequence),])
    DiffusionBValueYY = Tag('Diffusion b-value YY', "DiffusionBValueYY", 0x0018, 0x9605, [TagLink(DiffusionBMatrixSequence),])
    DiffusionBValueYZ = Tag('Diffusion b-value YZ', "DiffusionBValueYZ", 0x0018, 0x9606, [TagLink(DiffusionBMatrixSequence),])
    DiffusionBValueZZ = Tag('Diffusion b-value ZZ', "DiffusionBValueZZ", 0x0018, 0x9607, [TagLink(DiffusionBMatrixSequence),])
    FunctionalMRSequence = Tag('Functional MR Sequence', "FunctionalMRSequence", 0x0018, 0x9621, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    FunctionalSettlingPhaseFramesPresent = Tag('Functional Settling Phase Frames Present', "FunctionalSettlingPhaseFramesPresent", 0x0018, 0x9622, [TagLink(MRImageFrameTypeSequence),])
    FunctionalSyncPulse = Tag('Functional Sync Pulse', "FunctionalSyncPulse", 0x0018, 0x9623, [TagLink(FunctionalMRSequence),])
    SettlingPhaseFrame = Tag('Settling Phase Frame', "SettlingPhaseFrame", 0x0018, 0x9624, [TagLink(FunctionalMRSequence),])
    DecayCorrectionDateTime = Tag('Decay Correction DateTime', "DecayCorrectionDateTime", 0x0018, 0x9701)
    StartDensityThreshold = Tag('Start Density Threshold', "StartDensityThreshold", 0x0018, 0x9715)
    StartRelativeDensityDifferenceThreshold = Tag('Start Relative Density Difference Threshold', "StartRelativeDensityDifferenceThreshold", 0x0018, 0x9716)
    StartCardiacTriggerCountThreshold = Tag('Start Cardiac Trigger Count Threshold', "StartCardiacTriggerCountThreshold", 0x0018, 0x9717)
    StartRespiratoryTriggerCountThreshold = Tag('Start Respiratory Trigger Count Threshold', "StartRespiratoryTriggerCountThreshold", 0x0018, 0x9718)
    TerminationCountsThreshold = Tag('Termination Counts Threshold', "TerminationCountsThreshold", 0x0018, 0x9719)
    TerminationDensityThreshold = Tag('Termination Density Threshold', "TerminationDensityThreshold", 0x0018, 0x9720)
    TerminationRelativeDensityThreshold = Tag('Termination Relative Density Threshold', "TerminationRelativeDensityThreshold", 0x0018, 0x9721)
    TerminationTimeThreshold = Tag('Termination Time Threshold', "TerminationTimeThreshold", 0x0018, 0x9722)
    TerminationCardiacTriggerCountThreshold = Tag('Termination Cardiac Trigger Count Threshold', "TerminationCardiacTriggerCountThreshold", 0x0018, 0x9723)
    TerminationRespiratoryTriggerCountThreshold = Tag('Termination Respiratory Trigger Count Threshold', "TerminationRespiratoryTriggerCountThreshold", 0x0018, 0x9724)
    DetectorGeometry = Tag('Detector Geometry', "DetectorGeometry", 0x0018, 0x9725)
    TransverseDetectorSeparation = Tag('Transverse Detector Separation', "TransverseDetectorSeparation", 0x0018, 0x9726)
    AxialDetectorDimension = Tag('Axial Detector Dimension', "AxialDetectorDimension", 0x0018, 0x9727)
    RadiopharmaceuticalUsageSequence = Tag('Radiopharmaceutical Usage Sequence', "RadiopharmaceuticalUsageSequence", 0x0018, 0x9737, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    RadiopharmaceuticalAgentNumber = Tag('Radiopharmaceutical Agent Number', "RadiopharmaceuticalAgentNumber", 0x0018, 0x9729, [TagLink(RadiopharmaceuticalUsageSequence),TagLink(RadiopharmaceuticalInformationSequence),])
    PETFrameCorrectionFactorsSequence = Tag('PET Frame Correction Factors Sequence', "PETFrameCorrectionFactorsSequence", 0x0018, 0x9736, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    AttenuationCorrectionSource = Tag('Attenuation Correction Source', "AttenuationCorrectionSource", 0x0018, 0x9738)
    NumberOfIterations = Tag('Number of Iterations', "NumberOfIterations", 0x0018, 0x9739, [TagLink(PETReconstructionSequence),])
    NumberOfSubsets = Tag('Number of Subsets', "NumberOfSubsets", 0x0018, 0x9740, [TagLink(PETReconstructionSequence),])
    TimeOfFlightInformationUsed = Tag('Time of Flight Information Used', "TimeOfFlightInformationUsed", 0x0018, 0x9755)
    ReconstructionType = Tag('Reconstruction Type', "ReconstructionType", 0x0018, 0x9756, [TagLink(PETReconstructionSequence),])
    DecayCorrected = Tag('Decay Corrected', "DecayCorrected", 0x0018, 0x9758)
    AttenuationCorrected = Tag('Attenuation Corrected', "AttenuationCorrected", 0x0018, 0x9759)
    ScatterCorrected = Tag('Scatter Corrected', "ScatterCorrected", 0x0018, 0x9760)
    DeadTimeCorrected = Tag('Dead Time Corrected', "DeadTimeCorrected", 0x0018, 0x9761)
    GantryMotionCorrected = Tag('Gantry Motion Corrected', "GantryMotionCorrected", 0x0018, 0x9762)
    PatientMotionCorrected = Tag('Patient Motion Corrected', "PatientMotionCorrected", 0x0018, 0x9763)
    CountLossNormalizationCorrected = Tag('Count Loss Normalization Corrected', "CountLossNormalizationCorrected", 0x0018, 0x9764)
    RandomsCorrected = Tag('Randoms Corrected', "RandomsCorrected", 0x0018, 0x9765)
    NonUniformRadialSamplingCorrected = Tag('Non-uniform Radial Sampling Corrected', "NonUniformRadialSamplingCorrected", 0x0018, 0x9766)
    SensitivityCalibrated = Tag('Sensitivity Calibrated', "SensitivityCalibrated", 0x0018, 0x9767)
    DetectorNormalizationCorrection = Tag('Detector Normalization Correction', "DetectorNormalizationCorrection", 0x0018, 0x9768)
    IterativeReconstructionMethod = Tag('Iterative Reconstruction Method', "IterativeReconstructionMethod", 0x0018, 0x9769, [TagLink(PETReconstructionSequence),])
    AttenuationCorrectionTemporalRelationship = Tag('Attenuation Correction Temporal Relationship', "AttenuationCorrectionTemporalRelationship", 0x0018, 0x9770)
    DepthsOfFocus = Tag('Depth(s) of Focus', "DepthsOfFocus", 0x0018, 0x9801)
    ExcludedIntervalsSequence = Tag('Excluded Intervals Sequence', "ExcludedIntervalsSequence", 0x0018, 0x9803)
    ExclusionStartDateTime = Tag('Exclusion Start DateTime', "ExclusionStartDateTime", 0x0018, 0x9804, [TagLink(ExcludedIntervalsSequence),])
    ExclusionDuration = Tag('Exclusion Duration', "ExclusionDuration", 0x0018, 0x9805, [TagLink(ExcludedIntervalsSequence),])
    DataFrameAssignmentSequence = Tag('Data Frame Assignment Sequence', "DataFrameAssignmentSequence", 0x0028, 0x1401)
    DataType = Tag('Data Type', "DataType", 0x0018, 0x9808, [TagLink(ImageDataTypeSequence),TagLink(DataFrameAssignmentSequence),])
    AliasedDataType = Tag('Aliased Data Type', "AliasedDataType", 0x0018, 0x980B, [TagLink(ImageDataTypeSequence),])
    PositionMeasuringDeviceUsed = Tag('Position Measuring Device Used', "PositionMeasuringDeviceUsed", 0x0018, 0x980C)
    ZeroVelocityPixelValue = Tag('Zero Velocity Pixel Value', "ZeroVelocityPixelValue", 0x0018, 0x9810, [TagLink(ImageDataTypeSequence),])
    PhotoacousticExcitationCharacteristicsSequence = Tag('Photoacoustic Excitation Characteristics Sequence', "PhotoacousticExcitationCharacteristicsSequence", 0x0018, 0x9821, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    ExcitationSpectralWidth = Tag('Excitation Spectral Width', "ExcitationSpectralWidth", 0x0018, 0x9822, [TagLink(PhotoacousticExcitationCharacteristicsSequence),])
    ExcitationEnergy = Tag('Excitation Energy', "ExcitationEnergy", 0x0018, 0x9823, [TagLink(PhotoacousticExcitationCharacteristicsSequence),])
    ExcitationPulseDuration = Tag('Excitation Pulse Duration', "ExcitationPulseDuration", 0x0018, 0x9824, [TagLink(PhotoacousticExcitationCharacteristicsSequence),])
    ExcitationWavelengthSequence = Tag('Excitation Wavelength Sequence', "ExcitationWavelengthSequence", 0x0018, 0x9825)
    ExcitationWavelength = Tag('Excitation Wavelength', "ExcitationWavelength", 0x0018, 0x9826, [TagLink(ExcitationWavelengthSequence),TagLink(PhotoacousticExcitationCharacteristicsSequence),])
    IlluminationTranslationFlag = Tag('Illumination Translation Flag', "IlluminationTranslationFlag", 0x0018, 0x9828)
    AcousticCouplingMediumFlag = Tag('Acoustic Coupling Medium Flag', "AcousticCouplingMediumFlag", 0x0018, 0x9829)
    AcousticCouplingMediumTemperature = Tag('Acoustic Coupling Medium Temperature', "AcousticCouplingMediumTemperature", 0x0018, 0x982B)
    TransducerResponseSequence = Tag('Transducer Response Sequence', "TransducerResponseSequence", 0x0018, 0x982C)
    CenterFrequency = Tag('Center Frequency', "CenterFrequency", 0x0018, 0x982D, [TagLink(TransducerResponseSequence),])
    FractionalBandwidth = Tag('Fractional Bandwidth', "FractionalBandwidth", 0x0018, 0x982E, [TagLink(TransducerResponseSequence),])
    LowerCutoffFrequency = Tag('Lower Cutoff Frequency', "LowerCutoffFrequency", 0x0018, 0x982F, [TagLink(TransducerResponseSequence),])
    UpperCutoffFrequency = Tag('Upper Cutoff Frequency', "UpperCutoffFrequency", 0x0018, 0x9830, [TagLink(TransducerResponseSequence),])
    ObjectSoundSpeed = Tag('Object Sound Speed', "ObjectSoundSpeed", 0x0018, 0x9833, [TagLink(SoundSpeedCorrectionMechanismCodeSequence),])
    AcousticCouplingMediumSoundSpeed = Tag('Acoustic Coupling Medium Sound Speed', "AcousticCouplingMediumSoundSpeed", 0x0018, 0x9834, [TagLink(SoundSpeedCorrectionMechanismCodeSequence),])
    ReferenceLocationLabel = Tag('Reference Location Label', "ReferenceLocationLabel", 0x0018, 0x9900, [TagLink(PositioningLandmarkSequence),TagLink(AcquisitionStartLocationSequence),TagLink(AcquisitionEndLocationSequence),TagLink(ReconstructionStartLocationSequence),TagLink(ReconstructionEndLocationSequence),TagLink(ReconstructionTargetCenterLocationSequence),])
    ReferenceLocationDescription = Tag('Reference Location Description', "ReferenceLocationDescription", 0x0018, 0x9901, [TagLink(PositioningLandmarkSequence),TagLink(AcquisitionStartLocationSequence),TagLink(AcquisitionEndLocationSequence),TagLink(ReconstructionStartLocationSequence),TagLink(ReconstructionEndLocationSequence),TagLink(ReconstructionTargetCenterLocationSequence),])
    OffsetDistance = Tag('Offset Distance', "OffsetDistance", 0x0018, 0x9904, [TagLink(PositioningLandmarkSequence),TagLink(AcquisitionStartLocationSequence),TagLink(AcquisitionEndLocationSequence),TagLink(ReconstructionStartLocationSequence),TagLink(ReconstructionEndLocationSequence),TagLink(ReconstructionTargetCenterLocationSequence),])
    OffsetDirection = Tag('Offset Direction', "OffsetDirection", 0x0018, 0x9905, [TagLink(PositioningLandmarkSequence),TagLink(AcquisitionStartLocationSequence),TagLink(AcquisitionEndLocationSequence),TagLink(ReconstructionStartLocationSequence),TagLink(ReconstructionEndLocationSequence),TagLink(ReconstructionTargetCenterLocationSequence),])
    PotentialReasonsForProcedure = Tag('Potential Reasons for Procedure', "PotentialReasonsForProcedure", 0x0018, 0x9908)
    PotentialDiagnosticTasks = Tag('Potential Diagnostic Tasks', "PotentialDiagnosticTasks", 0x0018, 0x990A)
    ProtocolPlanningInformation = Tag('Protocol Planning Information', "ProtocolPlanningInformation", 0x0018, 0x990F)
    ProtocolDesignRationale = Tag('Protocol Design Rationale', "ProtocolDesignRationale", 0x0018, 0x9910)
    InstructionSequence = Tag('Instruction Sequence', "InstructionSequence", 0x0018, 0x9914)
    PatientPositioningInstructionSequence = Tag('Patient Positioning Instruction Sequence', "PatientPositioningInstructionSequence", 0x0018, 0x991B)
    InstructionIndex = Tag('Instruction Index', "InstructionIndex", 0x0018, 0x9915, [TagLink(InstructionSequence),TagLink(PatientPositioningInstructionSequence),])
    InstructionText = Tag('Instruction Text', "InstructionText", 0x0018, 0x9916, [TagLink(InstructionSequence),TagLink(PatientPositioningInstructionSequence),])
    InstructionDescription = Tag('Instruction Description', "InstructionDescription", 0x0018, 0x9917, [TagLink(InstructionSequence),TagLink(PatientPositioningInstructionSequence),])
    InstructionPerformedFlag = Tag('Instruction Performed Flag', "InstructionPerformedFlag", 0x0018, 0x9918, [TagLink(InstructionSequence),TagLink(PatientPositioningInstructionSequence),])
    InstructionPerformedDateTime = Tag('Instruction Performed DateTime', "InstructionPerformedDateTime", 0x0018, 0x9919, [TagLink(InstructionSequence),TagLink(PatientPositioningInstructionSequence),])
    InstructionPerformanceComment = Tag('Instruction Performance Comment', "InstructionPerformanceComment", 0x0018, 0x991A, [TagLink(InstructionSequence),])
    TargetFrameOfReferenceUID = Tag('Target Frame of Reference UID', "TargetFrameOfReferenceUID", 0x0018, 0x991E)
    ProtocolElementNumber = Tag('Protocol Element Number', "ProtocolElementNumber", 0x0018, 0x9921, [TagLink(AcquisitionProtocolElementSpecificationSequence),TagLink(AcquisitionProtocolElementSequence),TagLink(ReconstructionProtocolElementSpecificationSequence),TagLink(ReconstructionProtocolElementSequence),TagLink(StorageProtocolElementSpecificationSequence),TagLink(StorageProtocolElementSequence),])
    ProtocolElementName = Tag('Protocol Element Name', "ProtocolElementName", 0x0018, 0x9922, [TagLink(AcquisitionProtocolElementSequence),TagLink(ReconstructionProtocolElementSequence),TagLink(StorageProtocolElementSequence),])
    ProtocolElementCharacteristicsSummary = Tag('Protocol Element Characteristics Summary', "ProtocolElementCharacteristicsSummary", 0x0018, 0x9923, [TagLink(AcquisitionProtocolElementSequence),TagLink(ReconstructionProtocolElementSequence),TagLink(StorageProtocolElementSequence),])
    ProtocolElementPurpose = Tag('Protocol Element Purpose', "ProtocolElementPurpose", 0x0018, 0x9924, [TagLink(AcquisitionProtocolElementSequence),TagLink(ReconstructionProtocolElementSequence),TagLink(StorageProtocolElementSequence),])
    AcquisitionMotion = Tag('Acquisition Motion', "AcquisitionMotion", 0x0018, 0x9930, [TagLink(AcquisitionProtocolElementSequence),])
    RequestedSeriesDescription = Tag('Requested Series Description', "RequestedSeriesDescription", 0x0018, 0x9937, [TagLink(AcquisitionProtocolElementSequence),TagLink(ReconstructionProtocolElementSequence),])
    SourceAcquisitionProtocolElementNumber = Tag('Source Acquisition Protocol Element Number', "SourceAcquisitionProtocolElementNumber", 0x0018, 0x9938, [TagLink(ReferencedDefinedProtocolSequence),TagLink(ReferencedPerformedProtocolSequence),TagLink(ReconstructionProtocolElementSequence),TagLink(StorageProtocolElementSequence),])
    SourceAcquisitionBeamNumber = Tag('Source Acquisition Beam Number', "SourceAcquisitionBeamNumber", 0x0018, 0x9939, [TagLink(ReconstructionProtocolElementSequence),TagLink(StorageProtocolElementSequence),])
    SourceReconstructionProtocolElementNumber = Tag('Source Reconstruction Protocol Element Number', "SourceReconstructionProtocolElementNumber", 0x0018, 0x993A, [TagLink(ReferencedDefinedProtocolSequence),TagLink(ReferencedPerformedProtocolSequence),TagLink(StorageProtocolElementSequence),])
    ImageFilterDescription = Tag('Image Filter Description', "ImageFilterDescription", 0x0018, 0x9941, [TagLink(ReconstructionProtocolElementSequence),TagLink(ImageFilterDetailsSequence),])
    CTDIvolNotificationTrigger = Tag('CTDIvol Notification Trigger', "CTDIvolNotificationTrigger", 0x0018, 0x9942, [TagLink(AcquisitionProtocolElementSequence),])
    DLPNotificationTrigger = Tag('DLP Notification Trigger', "DLPNotificationTrigger", 0x0018, 0x9943, [TagLink(AcquisitionProtocolElementSequence),])
    AutoKVPSelectionType = Tag('Auto KVP Selection Type', "AutoKVPSelectionType", 0x0018, 0x9944, [TagLink(CTXRayDetailsSequence),])
    AutoKVPUpperBound = Tag('Auto KVP Upper Bound', "AutoKVPUpperBound", 0x0018, 0x9945, [TagLink(CTXRayDetailsSequence),])
    AutoKVPLowerBound = Tag('Auto KVP Lower Bound', "AutoKVPLowerBound", 0x0018, 0x9946, [TagLink(CTXRayDetailsSequence),])
    ProtocolDefinedPatientPosition = Tag('Protocol Defined Patient Position', "ProtocolDefinedPatientPosition", 0x0018, 0x9947)
    ContributionDateTime = Tag('Contribution DateTime', "ContributionDateTime", 0x0018, 0xA002, [TagLink(ContributingEquipmentSequence),])
    ContributionDescription = Tag('Contribution Description', "ContributionDescription", 0x0018, 0xA003, [TagLink(ContributingEquipmentSequence),])
    StudyInstanceUID = Tag('Study Instance UID', "StudyInstanceUID", 0x0020, 0x000D, [TagLink(ContributingSOPInstancesReferenceSequence),TagLink(ReferencedStudySequence),TagLink(ReferencedPatientPhotoSequence),TagLink(RelatedSeriesSequence),TagLink(RequestAttributesSequence),TagLink(BlendingSequence),TagLink(AdvancedBlendingSequence),TagLink(StudiesContainingOtherReferencedInstancesSequence),TagLink(ReferencedRequestSequence),TagLink(CurrentRequestedProcedureEvidenceSequence),TagLink(IdenticalDocumentsSequence),TagLink(PredecessorDocumentsSequence),TagLink(InventoriedStudiesSequence),])
    SourceSeriesSequence = Tag('Source Series Sequence', "SourceSeriesSequence", 0x3006, 0x004B, [TagLink(ROIContourSequence),])
    SeriesInstanceUID = Tag('Series Instance UID', "SeriesInstanceUID", 0x0020, 0x000E, [TagLink(ReferencedSeriesSequence),TagLink(ReferencedPatientPhotoSequence),TagLink(RelatedSeriesSequence),TagLink(RTReferencedSeriesSequence),TagLink(SourceSeriesInformationSequence),TagLink(SourceSeriesSequence),TagLink(AdvancedBlendingSequence),TagLink(InventoriedSeriesSequence),TagLink(AlternateRepresentationSequence),])
    StudyID = Tag('Study ID', "StudyID", 0x0020, 0x0010, [TagLink(InventoriedStudiesSequence),])
    SeriesNumber = Tag('Series Number', "SeriesNumber", 0x0020, 0x0011, [TagLink(ReferencedSeriesSequence),TagLink(SourceSeriesInformationSequence),TagLink(InventoriedSeriesSequence),])
    AcquisitionNumber = Tag('Acquisition Number', "AcquisitionNumber", 0x0020, 0x0012)
    InstanceNumber = Tag('Instance Number', "InstanceNumber", 0x0020, 0x0013, [TagLink(ReferencedInstanceSequence),TagLink(InventoriedInstancesSequence),])
    IsotopeNumber = Tag('Isotope Number', "IsotopeNumber", 0x0020, 0x0014)
    PhaseNumber = Tag('Phase Number', "PhaseNumber", 0x0020, 0x0015)
    IntervalNumber = Tag('Interval Number', "IntervalNumber", 0x0020, 0x0016)
    TimeSlotNumber = Tag('Time Slot Number', "TimeSlotNumber", 0x0020, 0x0017)
    AngleNumber = Tag('Angle Number', "AngleNumber", 0x0020, 0x0018)
    ItemNumber = Tag('Item Number', "ItemNumber", 0x0020, 0x0019)
    PatientOrientationInFrameSequence = Tag('Patient Orientation in Frame Sequence', "PatientOrientationInFrameSequence", 0x0020, 0x9450, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    PatientOrientation = Tag('Patient Orientation', "PatientOrientation", 0x0020, 0x0020, [TagLink(SourceImageSequence),TagLink(PatientOrientationInFrameSequence),])
    OverlayNumber = Tag('Overlay Number', "OverlayNumber", 0x0020, 0x0022)
    CurveNumber = Tag('Curve Number', "CurveNumber", 0x0020, 0x0024)
    LUTNumber = Tag('LUT Number', "LUTNumber", 0x0020, 0x0026)
    PyramidLabel = Tag('Pyramid Label', "PyramidLabel", 0x0020, 0x0027)
    ImagePosition = Tag('Image Position', "ImagePosition", 0x0020, 0x0030)
    PlanePositionSequence = Tag('Plane Position Sequence', "PlanePositionSequence", 0x0020, 0x9113, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    DeformableRegistrationGridSequence = Tag('Deformable Registration Grid Sequence', "DeformableRegistrationGridSequence", 0x0064, 0x0005, [TagLink(DeformableRegistrationSequence),])
    ImagePositionPatient = Tag('Image Position (Patient)', "ImagePositionPatient", 0x0020, 0x0032, [TagLink(PlanePositionSequence),TagLink(DetectorInformationSequence),TagLink(SourcePixelPlanesCharacteristicsSequence),TagLink(DeformableRegistrationGridSequence),])
    ImageOrientation = Tag('Image Orientation', "ImageOrientation", 0x0020, 0x0035)
    PlaneOrientationSequence = Tag('Plane Orientation Sequence', "PlaneOrientationSequence", 0x0020, 0x9116, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    ImageOrientationPatient = Tag('Image Orientation (Patient)', "ImageOrientationPatient", 0x0020, 0x0037, [TagLink(PlaneOrientationSequence),TagLink(DetectorInformationSequence),TagLink(SourcePixelPlanesCharacteristicsSequence),TagLink(DeformableRegistrationGridSequence),])
    Location = Tag('Location', "Location", 0x0020, 0x0050)
    FrameOfReferenceUID = Tag('Frame of Reference UID', "FrameOfReferenceUID", 0x0020, 0x0052, [TagLink(ReferencedFrameOfReferenceSequence),TagLink(RegistrationSequence),TagLink(FiducialSetSequence),])
    Laterality = Tag('Laterality', "Laterality", 0x0020, 0x0060, [TagLink(HangingProtocolDefinitionSequence),TagLink(InventoriedSeriesSequence),])
    ImageLaterality = Tag('Image Laterality', "ImageLaterality", 0x0020, 0x0062)
    ImageGeometryType = Tag('Image Geometry Type', "ImageGeometryType", 0x0020, 0x0070)
    MaskingImage = Tag('Masking Image', "MaskingImage", 0x0020, 0x0080)
    ReportNumber = Tag('Report Number', "ReportNumber", 0x0020, 0x00AA)
    TemporalPositionIdentifier = Tag('Temporal Position Identifier', "TemporalPositionIdentifier", 0x0020, 0x0100)
    NumberOfTemporalPositions = Tag('Number of Temporal Positions', "NumberOfTemporalPositions", 0x0020, 0x0105)
    TemporalResolution = Tag('Temporal Resolution', "TemporalResolution", 0x0020, 0x0110)
    SynchronizationFrameOfReferenceUID = Tag('Synchronization Frame of Reference UID', "SynchronizationFrameOfReferenceUID", 0x0020, 0x0200)
    SOPInstanceUIDOfConcatenationSource = Tag('SOP Instance UID of Concatenation Source', "SOPInstanceUIDOfConcatenationSource", 0x0020, 0x0242)
    SeriesInStudy = Tag('Series in Study', "SeriesInStudy", 0x0020, 0x1000)
    AcquisitionsInSeries = Tag('Acquisitions in Series', "AcquisitionsInSeries", 0x0020, 0x1001)
    ImagesInAcquisition = Tag('Images in Acquisition', "ImagesInAcquisition", 0x0020, 0x1002)
    ImagesInSeries = Tag('Images in Series', "ImagesInSeries", 0x0020, 0x1003)
    AcquisitionsInStudy = Tag('Acquisitions in Study', "AcquisitionsInStudy", 0x0020, 0x1004)
    ImagesInStudy = Tag('Images in Study', "ImagesInStudy", 0x0020, 0x1005)
    Reference = Tag('Reference', "Reference", 0x0020, 0x1020)
    TargetPositionReferenceIndicator = Tag('Target Position Reference Indicator', "TargetPositionReferenceIndicator", 0x0020, 0x103F)
    PositionReferenceIndicator = Tag('Position Reference Indicator', "PositionReferenceIndicator", 0x0020, 0x1040)
    SliceLocation = Tag('Slice Location', "SliceLocation", 0x0020, 0x1041)
    OtherStudyNumbers = Tag('Other Study Numbers', "OtherStudyNumbers", 0x0020, 0x1070)
    NumberOfPatientRelatedStudies = Tag('Number of Patient Related Studies', "NumberOfPatientRelatedStudies", 0x0020, 0x1200)
    NumberOfPatientRelatedSeries = Tag('Number of Patient Related Series', "NumberOfPatientRelatedSeries", 0x0020, 0x1202)
    NumberOfPatientRelatedInstances = Tag('Number of Patient Related Instances', "NumberOfPatientRelatedInstances", 0x0020, 0x1204)
    NumberOfStudyRelatedSeries = Tag('Number of Study Related Series', "NumberOfStudyRelatedSeries", 0x0020, 0x1206, [TagLink(InventoriedStudiesSequence),])
    NumberOfStudyRelatedInstances = Tag('Number of Study Related Instances', "NumberOfStudyRelatedInstances", 0x0020, 0x1208, [TagLink(InventoriedStudiesSequence),])
    NumberOfSeriesRelatedInstances = Tag('Number of Series Related Instances', "NumberOfSeriesRelatedInstances", 0x0020, 0x1209)
    SourceImageIDs = Tag('Source Image IDs', "SourceImageIDs", 0x0020, 0x3100, [], [(0x0020, 0x3101),(0x0020, 0x3102),(0x0020, 0x3103),(0x0020, 0x3104),(0x0020, 0x3105),(0x0020, 0x3106),(0x0020, 0x3107),(0x0020, 0x3108),(0x0020, 0x3109),(0x0020, 0x310A),(0x0020, 0x310B),(0x0020, 0x310C),(0x0020, 0x310D),(0x0020, 0x310E),(0x0020, 0x310F),(0x0020, 0x3110),(0x0020, 0x3111),(0x0020, 0x3112),(0x0020, 0x3113),(0x0020, 0x3114),(0x0020, 0x3115),(0x0020, 0x3116),(0x0020, 0x3117),(0x0020, 0x3118),(0x0020, 0x3119),(0x0020, 0x311A),(0x0020, 0x311B),(0x0020, 0x311C),(0x0020, 0x311D),(0x0020, 0x311E),(0x0020, 0x311F),(0x0020, 0x3120),(0x0020, 0x3121),(0x0020, 0x3122),(0x0020, 0x3123),(0x0020, 0x3124),(0x0020, 0x3125),(0x0020, 0x3126),(0x0020, 0x3127),(0x0020, 0x3128),(0x0020, 0x3129),(0x0020, 0x312A),(0x0020, 0x312B),(0x0020, 0x312C),(0x0020, 0x312D),(0x0020, 0x312E),(0x0020, 0x312F),(0x0020, 0x3130),(0x0020, 0x3131),(0x0020, 0x3132),(0x0020, 0x3133),(0x0020, 0x3134),(0x0020, 0x3135),(0x0020, 0x3136),(0x0020, 0x3137),(0x0020, 0x3138),(0x0020, 0x3139),(0x0020, 0x313A),(0x0020, 0x313B),(0x0020, 0x313C),(0x0020, 0x313D),(0x0020, 0x313E),(0x0020, 0x313F),(0x0020, 0x3140),(0x0020, 0x3141),(0x0020, 0x3142),(0x0020, 0x3143),(0x0020, 0x3144),(0x0020, 0x3145),(0x0020, 0x3146),(0x0020, 0x3147),(0x0020, 0x3148),(0x0020, 0x3149),(0x0020, 0x314A),(0x0020, 0x314B),(0x0020, 0x314C),(0x0020, 0x314D),(0x0020, 0x314E),(0x0020, 0x314F),(0x0020, 0x3150),(0x0020, 0x3151),(0x0020, 0x3152),(0x0020, 0x3153),(0x0020, 0x3154),(0x0020, 0x3155),(0x0020, 0x3156),(0x0020, 0x3157),(0x0020, 0x3158),(0x0020, 0x3159),(0x0020, 0x315A),(0x0020, 0x315B),(0x0020, 0x315C),(0x0020, 0x315D),(0x0020, 0x315E),(0x0020, 0x315F),(0x0020, 0x3160),(0x0020, 0x3161),(0x0020, 0x3162),(0x0020, 0x3163),(0x0020, 0x3164),(0x0020, 0x3165),(0x0020, 0x3166),(0x0020, 0x3167),(0x0020, 0x3168),(0x0020, 0x3169),(0x0020, 0x316A),(0x0020, 0x316B),(0x0020, 0x316C),(0x0020, 0x316D),(0x0020, 0x316E),(0x0020, 0x316F),(0x0020, 0x3170),(0x0020, 0x3171),(0x0020, 0x3172),(0x0020, 0x3173),(0x0020, 0x3174),(0x0020, 0x3175),(0x0020, 0x3176),(0x0020, 0x3177),(0x0020, 0x3178),(0x0020, 0x3179),(0x0020, 0x317A),(0x0020, 0x317B),(0x0020, 0x317C),(0x0020, 0x317D),(0x0020, 0x317E),(0x0020, 0x317F),(0x0020, 0x3180),(0x0020, 0x3181),(0x0020, 0x3182),(0x0020, 0x3183),(0x0020, 0x3184),(0x0020, 0x3185),(0x0020, 0x3186),(0x0020, 0x3187),(0x0020, 0x3188),(0x0020, 0x3189),(0x0020, 0x318A),(0x0020, 0x318B),(0x0020, 0x318C),(0x0020, 0x318D),(0x0020, 0x318E),(0x0020, 0x318F),(0x0020, 0x3190),(0x0020, 0x3191),(0x0020, 0x3192),(0x0020, 0x3193),(0x0020, 0x3194),(0x0020, 0x3195),(0x0020, 0x3196),(0x0020, 0x3197),(0x0020, 0x3198),(0x0020, 0x3199),(0x0020, 0x319A),(0x0020, 0x319B),(0x0020, 0x319C),(0x0020, 0x319D),(0x0020, 0x319E),(0x0020, 0x319F),(0x0020, 0x31A0),(0x0020, 0x31A1),(0x0020, 0x31A2),(0x0020, 0x31A3),(0x0020, 0x31A4),(0x0020, 0x31A5),(0x0020, 0x31A6),(0x0020, 0x31A7),(0x0020, 0x31A8),(0x0020, 0x31A9),(0x0020, 0x31AA),(0x0020, 0x31AB),(0x0020, 0x31AC),(0x0020, 0x31AD),(0x0020, 0x31AE),(0x0020, 0x31AF),(0x0020, 0x31B0),(0x0020, 0x31B1),(0x0020, 0x31B2),(0x0020, 0x31B3),(0x0020, 0x31B4),(0x0020, 0x31B5),(0x0020, 0x31B6),(0x0020, 0x31B7),(0x0020, 0x31B8),(0x0020, 0x31B9),(0x0020, 0x31BA),(0x0020, 0x31BB),(0x0020, 0x31BC),(0x0020, 0x31BD),(0x0020, 0x31BE),(0x0020, 0x31BF),(0x0020, 0x31C0),(0x0020, 0x31C1),(0x0020, 0x31C2),(0x0020, 0x31C3),(0x0020, 0x31C4),(0x0020, 0x31C5),(0x0020, 0x31C6),(0x0020, 0x31C7),(0x0020, 0x31C8),(0x0020, 0x31C9),(0x0020, 0x31CA),(0x0020, 0x31CB),(0x0020, 0x31CC),(0x0020, 0x31CD),(0x0020, 0x31CE),(0x0020, 0x31CF),(0x0020, 0x31D0),(0x0020, 0x31D1),(0x0020, 0x31D2),(0x0020, 0x31D3),(0x0020, 0x31D4),(0x0020, 0x31D5),(0x0020, 0x31D6),(0x0020, 0x31D7),(0x0020, 0x31D8),(0x0020, 0x31D9),(0x0020, 0x31DA),(0x0020, 0x31DB),(0x0020, 0x31DC),(0x0020, 0x31DD),(0x0020, 0x31DE),(0x0020, 0x31DF),(0x0020, 0x31E0),(0x0020, 0x31E1),(0x0020, 0x31E2),(0x0020, 0x31E3),(0x0020, 0x31E4),(0x0020, 0x31E5),(0x0020, 0x31E6),(0x0020, 0x31E7),(0x0020, 0x31E8),(0x0020, 0x31E9),(0x0020, 0x31EA),(0x0020, 0x31EB),(0x0020, 0x31EC),(0x0020, 0x31ED),(0x0020, 0x31EE),(0x0020, 0x31EF),(0x0020, 0x31F0),(0x0020, 0x31F1),(0x0020, 0x31F2),(0x0020, 0x31F3),(0x0020, 0x31F4),(0x0020, 0x31F5),(0x0020, 0x31F6),(0x0020, 0x31F7),(0x0020, 0x31F8),(0x0020, 0x31F9),(0x0020, 0x31FA),(0x0020, 0x31FB),(0x0020, 0x31FC),(0x0020, 0x31FD),(0x0020, 0x31FE),(0x0020, 0x31FF),])
    ModifyingDeviceID = Tag('Modifying Device ID', "ModifyingDeviceID", 0x0020, 0x3401)
    ModifiedImageID = Tag('Modified Image ID', "ModifiedImageID", 0x0020, 0x3402)
    ModifiedImageDate = Tag('Modified Image Date', "ModifiedImageDate", 0x0020, 0x3403)
    ModifyingDeviceManufacturer = Tag('Modifying Device Manufacturer', "ModifyingDeviceManufacturer", 0x0020, 0x3404)
    ModifiedImageTime = Tag('Modified Image Time', "ModifiedImageTime", 0x0020, 0x3405)
    ModifiedImageDescription = Tag('Modified Image Description', "ModifiedImageDescription", 0x0020, 0x3406)
    ImageComments = Tag('Image Comments', "ImageComments", 0x0020, 0x4000)
    OriginalImageIdentification = Tag('Original Image Identification', "OriginalImageIdentification", 0x0020, 0x5000)
    OriginalImageIdentificationNomenclature = Tag('Original Image Identification Nomenclature', "OriginalImageIdentificationNomenclature", 0x0020, 0x5002)
    StackID = Tag('Stack ID', "StackID", 0x0020, 0x9056, [TagLink(FrameContentSequence),])
    InStackPositionNumber = Tag('In-Stack Position Number', "InStackPositionNumber", 0x0020, 0x9057, [TagLink(FrameContentSequence),])
    FrameLaterality = Tag('Frame Laterality', "FrameLaterality", 0x0020, 0x9072, [TagLink(FrameAnatomySequence),])
    TemporalPositionIndex = Tag('Temporal Position Index', "TemporalPositionIndex", 0x0020, 0x9128, [TagLink(FrameContentSequence),])
    NominalCardiacTriggerDelayTime = Tag('Nominal Cardiac Trigger Delay Time', "NominalCardiacTriggerDelayTime", 0x0020, 0x9153, [TagLink(CardiacSynchronizationSequence),])
    NominalCardiacTriggerTimePriorToRPeak = Tag('Nominal Cardiac Trigger Time Prior To R-Peak', "NominalCardiacTriggerTimePriorToRPeak", 0x0020, 0x9154, [TagLink(CardiacSynchronizationSequence),])
    ActualCardiacTriggerTimePriorToRPeak = Tag('Actual Cardiac Trigger Time Prior To R-Peak', "ActualCardiacTriggerTimePriorToRPeak", 0x0020, 0x9155, [TagLink(CardiacSynchronizationSequence),])
    FrameAcquisitionNumber = Tag('Frame Acquisition Number', "FrameAcquisitionNumber", 0x0020, 0x9156, [TagLink(FrameContentSequence),])
    DimensionIndexValues = Tag('Dimension Index Values', "DimensionIndexValues", 0x0020, 0x9157, [TagLink(FrameContentSequence),])
    FrameComments = Tag('Frame Comments', "FrameComments", 0x0020, 0x9158, [TagLink(FrameContentSequence),])
    ConcatenationUID = Tag('Concatenation UID', "ConcatenationUID", 0x0020, 0x9161)
    InConcatenationNumber = Tag('In-concatenation Number', "InConcatenationNumber", 0x0020, 0x9162)
    InConcatenationTotalNumber = Tag('In-concatenation Total Number', "InConcatenationTotalNumber", 0x0020, 0x9163)
    DimensionOrganizationSequence = Tag('Dimension Organization Sequence', "DimensionOrganizationSequence", 0x0020, 0x9221)
    DimensionIndexSequence = Tag('Dimension Index Sequence', "DimensionIndexSequence", 0x0020, 0x9222)
    DimensionOrganizationUID = Tag('Dimension Organization UID', "DimensionOrganizationUID", 0x0020, 0x9164, [TagLink(DimensionOrganizationSequence),TagLink(DimensionIndexSequence),])
    DimensionIndexPointer = Tag('Dimension Index Pointer', "DimensionIndexPointer", 0x0020, 0x9165, [TagLink(DimensionIndexSequence),])
    FunctionalGroupPointer = Tag('Functional Group Pointer', "FunctionalGroupPointer", 0x0020, 0x9167, [TagLink(DimensionIndexSequence),])
    UnassignedSharedConvertedAttributesSequence = Tag('Unassigned Shared Converted Attributes Sequence', "UnassignedSharedConvertedAttributesSequence", 0x0020, 0x9170, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    UnassignedPerFrameConvertedAttributesSequence = Tag('Unassigned Per-Frame Converted Attributes Sequence', "UnassignedPerFrameConvertedAttributesSequence", 0x0020, 0x9171, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    DimensionIndexPrivateCreator = Tag('Dimension Index Private Creator', "DimensionIndexPrivateCreator", 0x0020, 0x9213, [TagLink(DimensionIndexSequence),])
    ConcatenationFrameOffsetNumber = Tag('Concatenation Frame Offset Number', "ConcatenationFrameOffsetNumber", 0x0020, 0x9228)
    FunctionalGroupPrivateCreator = Tag('Functional Group Private Creator', "FunctionalGroupPrivateCreator", 0x0020, 0x9238, [TagLink(DimensionIndexSequence),])
    NominalPercentageOfCardiacPhase = Tag('Nominal Percentage of Cardiac Phase', "NominalPercentageOfCardiacPhase", 0x0020, 0x9241, [TagLink(CardiacSynchronizationSequence),])
    RespiratorySynchronizationSequence = Tag('Respiratory Synchronization Sequence', "RespiratorySynchronizationSequence", 0x0020, 0x9253, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    NominalPercentageOfRespiratoryPhase = Tag('Nominal Percentage of Respiratory Phase', "NominalPercentageOfRespiratoryPhase", 0x0020, 0x9245, [TagLink(RespiratorySynchronizationSequence),])
    StartingRespiratoryAmplitude = Tag('Starting Respiratory Amplitude', "StartingRespiratoryAmplitude", 0x0020, 0x9246, [TagLink(RespiratorySynchronizationSequence),])
    StartingRespiratoryPhase = Tag('Starting Respiratory Phase', "StartingRespiratoryPhase", 0x0020, 0x9247, [TagLink(RespiratorySynchronizationSequence),])
    EndingRespiratoryAmplitude = Tag('Ending Respiratory Amplitude', "EndingRespiratoryAmplitude", 0x0020, 0x9248, [TagLink(RespiratorySynchronizationSequence),])
    EndingRespiratoryPhase = Tag('Ending Respiratory Phase', "EndingRespiratoryPhase", 0x0020, 0x9249, [TagLink(RespiratorySynchronizationSequence),])
    RespiratoryTriggerType = Tag('Respiratory Trigger Type', "RespiratoryTriggerType", 0x0020, 0x9250, [TagLink(CTXRayDetailsSequence),])
    RRIntervalTimeNominal = Tag('R-R Interval Time Nominal', "RRIntervalTimeNominal", 0x0020, 0x9251, [TagLink(CardiacSynchronizationSequence),])
    ActualCardiacTriggerDelayTime = Tag('Actual Cardiac Trigger Delay Time', "ActualCardiacTriggerDelayTime", 0x0020, 0x9252, [TagLink(CardiacSynchronizationSequence),])
    RespiratoryIntervalTime = Tag('Respiratory Interval Time', "RespiratoryIntervalTime", 0x0020, 0x9254, [TagLink(RespiratorySynchronizationSequence),])
    NominalRespiratoryTriggerDelayTime = Tag('Nominal Respiratory Trigger Delay Time', "NominalRespiratoryTriggerDelayTime", 0x0020, 0x9255, [TagLink(RespiratorySynchronizationSequence),])
    RespiratoryTriggerDelayThreshold = Tag('Respiratory Trigger Delay Threshold', "RespiratoryTriggerDelayThreshold", 0x0020, 0x9256, [TagLink(CTXRayDetailsSequence),])
    ActualRespiratoryTriggerDelayTime = Tag('Actual Respiratory Trigger Delay Time', "ActualRespiratoryTriggerDelayTime", 0x0020, 0x9257, [TagLink(RespiratorySynchronizationSequence),])
    PlanePositionVolumeSequence = Tag('Plane Position (Volume) Sequence', "PlanePositionVolumeSequence", 0x0020, 0x930E, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    ImagePositionVolume = Tag('Image Position (Volume)', "ImagePositionVolume", 0x0020, 0x9301, [TagLink(PlanePositionVolumeSequence),])
    PlaneOrientationVolumeSequence = Tag('Plane Orientation (Volume) Sequence', "PlaneOrientationVolumeSequence", 0x0020, 0x930F, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    ImageOrientationVolume = Tag('Image Orientation (Volume)', "ImageOrientationVolume", 0x0020, 0x9302, [TagLink(PlaneOrientationVolumeSequence),])
    UltrasoundAcquisitionGeometry = Tag('Ultrasound Acquisition Geometry', "UltrasoundAcquisitionGeometry", 0x0020, 0x9307)
    ApexPosition = Tag('Apex Position', "ApexPosition", 0x0020, 0x9308)
    VolumeToTransducerMappingMatrix = Tag('Volume to Transducer Mapping Matrix', "VolumeToTransducerMappingMatrix", 0x0020, 0x9309)
    VolumeToTableMappingMatrix = Tag('Volume to Table Mapping Matrix', "VolumeToTableMappingMatrix", 0x0020, 0x930A)
    VolumeToTransducerRelationship = Tag('Volume to Transducer Relationship', "VolumeToTransducerRelationship", 0x0020, 0x930B)
    PatientFrameOfReferenceSource = Tag('Patient Frame of Reference Source', "PatientFrameOfReferenceSource", 0x0020, 0x930C)
    TemporalPositionSequence = Tag('Temporal Position Sequence', "TemporalPositionSequence", 0x0020, 0x9310, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    TemporalPositionTimeOffset = Tag('Temporal Position Time Offset', "TemporalPositionTimeOffset", 0x0020, 0x930D, [TagLink(TemporalPositionSequence),])
    DimensionOrganizationType = Tag('Dimension Organization Type', "DimensionOrganizationType", 0x0020, 0x9311)
    VolumeFrameOfReferenceUID = Tag('Volume Frame of Reference UID', "VolumeFrameOfReferenceUID", 0x0020, 0x9312)
    TableFrameOfReferenceUID = Tag('Table Frame of Reference UID', "TableFrameOfReferenceUID", 0x0020, 0x9313)
    DimensionDescriptionLabel = Tag('Dimension Description Label', "DimensionDescriptionLabel", 0x0020, 0x9421, [TagLink(DimensionIndexSequence),])
    FrameLabel = Tag('Frame Label', "FrameLabel", 0x0020, 0x9453, [TagLink(FrameContentSequence),])
    AcquisitionIndex = Tag('Acquisition Index', "AcquisitionIndex", 0x0020, 0x9518, [TagLink(XRay3DReconstructionSequence),])
    ReconstructionIndex = Tag('Reconstruction Index', "ReconstructionIndex", 0x0020, 0x9536, [TagLink(XRay3DFrameTypeSequence),])
    LightPathFilterPassThroughWavelength = Tag('Light Path Filter Pass-Through Wavelength', "LightPathFilterPassThroughWavelength", 0x0022, 0x0001, [TagLink(OpticalPathSequence),TagLink(LightPathFilterTypeStackCodeSequence),])
    LightPathFilterPassBand = Tag('Light Path Filter Pass Band', "LightPathFilterPassBand", 0x0022, 0x0002, [TagLink(OpticalPathSequence),TagLink(LightPathFilterTypeStackCodeSequence),])
    ImagePathFilterPassThroughWavelength = Tag('Image Path Filter Pass-Through Wavelength', "ImagePathFilterPassThroughWavelength", 0x0022, 0x0003, [TagLink(OpticalPathSequence),])
    ImagePathFilterPassBand = Tag('Image Path Filter Pass Band', "ImagePathFilterPassBand", 0x0022, 0x0004, [TagLink(OpticalPathSequence),])
    PatientEyeMovementCommanded = Tag('Patient Eye Movement Commanded', "PatientEyeMovementCommanded", 0x0022, 0x0005)
    RefractiveParametersUsedOnPatientSequence = Tag('Refractive Parameters Used on Patient Sequence', "RefractiveParametersUsedOnPatientSequence", 0x0024, 0x0112)
    SphericalLensPower = Tag('Spherical Lens Power', "SphericalLensPower", 0x0022, 0x0007, [TagLink(RefractiveStateSequence),TagLink(RefractiveParametersUsedOnPatientSequence),])
    CylinderLensPower = Tag('Cylinder Lens Power', "CylinderLensPower", 0x0022, 0x0008, [TagLink(RefractiveStateSequence),TagLink(RefractiveParametersUsedOnPatientSequence),])
    AutorefractionRightEyeSequence = Tag('Autorefraction Right Eye Sequence', "AutorefractionRightEyeSequence", 0x0046, 0x0050)
    AutorefractionLeftEyeSequence = Tag('Autorefraction Left Eye Sequence', "AutorefractionLeftEyeSequence", 0x0046, 0x0052)
    CylinderSequence = Tag('Cylinder Sequence', "CylinderSequence", 0x0046, 0x0018, [TagLink(AutorefractionRightEyeSequence),TagLink(AutorefractionLeftEyeSequence),])
    SurgicallyInducedAstigmatismSequence = Tag('Surgically Induced Astigmatism Sequence', "SurgicallyInducedAstigmatismSequence", 0x0022, 0x1045)
    CylinderAxis = Tag('Cylinder Axis', "CylinderAxis", 0x0022, 0x0009, [TagLink(RefractiveStateSequence),TagLink(CylinderSequence),TagLink(SurgicallyInducedAstigmatismSequence),TagLink(RefractiveParametersUsedOnPatientSequence),])
    EmmetropicMagnification = Tag('Emmetropic Magnification', "EmmetropicMagnification", 0x0022, 0x000A)
    IntraOcularPressure = Tag('Intra Ocular Pressure', "IntraOcularPressure", 0x0022, 0x000B)
    HorizontalFieldOfView = Tag('Horizontal Field of View', "HorizontalFieldOfView", 0x0022, 0x000C)
    PupilDilated = Tag('Pupil Dilated', "PupilDilated", 0x0022, 0x000D)
    DegreeOfDilation = Tag('Degree of Dilation', "DegreeOfDilation", 0x0022, 0x000E)
    VertexDistance = Tag('Vertex Distance', "VertexDistance", 0x0022, 0x000F, [TagLink(RefractiveStateSequence),TagLink(AutorefractionRightEyeSequence),TagLink(AutorefractionLeftEyeSequence),TagLink(RefractiveParametersUsedOnPatientSequence),])
    StereoBaselineAngle = Tag('Stereo Baseline Angle', "StereoBaselineAngle", 0x0022, 0x0010, [TagLink(StereoPairsSequence),])
    StereoBaselineDisplacement = Tag('Stereo Baseline Displacement', "StereoBaselineDisplacement", 0x0022, 0x0011, [TagLink(StereoPairsSequence),])
    StereoHorizontalPixelOffset = Tag('Stereo Horizontal Pixel Offset', "StereoHorizontalPixelOffset", 0x0022, 0x0012, [TagLink(StereoPairsSequence),])
    StereoVerticalPixelOffset = Tag('Stereo Vertical Pixel Offset', "StereoVerticalPixelOffset", 0x0022, 0x0013, [TagLink(StereoPairsSequence),])
    StereoRotation = Tag('Stereo Rotation', "StereoRotation", 0x0022, 0x0014, [TagLink(StereoPairsSequence),])
    CameraAngleOfView = Tag('Camera Angle of View', "CameraAngleOfView", 0x0022, 0x001E)
    StereoPairsPresent = Tag('Stereo Pairs Present', "StereoPairsPresent", 0x0022, 0x0028)
    AxialLengthOfTheEye = Tag('Axial Length of the Eye', "AxialLengthOfTheEye", 0x0022, 0x0030)
    ReferenceCoordinates = Tag('Reference Coordinates', "ReferenceCoordinates", 0x0022, 0x0032, [TagLink(OphthalmicFrameLocationSequence),])
    RelevantOPTAttributesSequence = Tag('Relevant OPT Attributes Sequence', "RelevantOPTAttributesSequence", 0x0022, 0x1472)
    DepthSpatialResolution = Tag('Depth Spatial Resolution', "DepthSpatialResolution", 0x0022, 0x0035, [TagLink(RelevantOPTAttributesSequence),])
    MaximumDepthDistortion = Tag('Maximum Depth Distortion', "MaximumDepthDistortion", 0x0022, 0x0036, [TagLink(RelevantOPTAttributesSequence),])
    AlongScanSpatialResolution = Tag('Along-scan Spatial Resolution', "AlongScanSpatialResolution", 0x0022, 0x0037)
    MaximumAlongScanDistortion = Tag('Maximum Along-scan Distortion', "MaximumAlongScanDistortion", 0x0022, 0x0038)
    OphthalmicImageOrientation = Tag('Ophthalmic Image Orientation', "OphthalmicImageOrientation", 0x0022, 0x0039, [TagLink(OphthalmicFrameLocationSequence),])
    DepthOfTransverseImage = Tag('Depth of Transverse Image', "DepthOfTransverseImage", 0x0022, 0x0041, [TagLink(OphthalmicFrameLocationSequence),])
    AcrossScanSpatialResolution = Tag('Across-scan Spatial Resolution', "AcrossScanSpatialResolution", 0x0022, 0x0048)
    MaximumAcrossScanDistortion = Tag('Maximum Across-scan Distortion', "MaximumAcrossScanDistortion", 0x0022, 0x0049)
    MydriaticAgentConcentration = Tag('Mydriatic Agent Concentration', "MydriaticAgentConcentration", 0x0022, 0x004E, [TagLink(MydriaticAgentSequence),])
    IlluminationWaveLength = Tag('Illumination Wave Length', "IlluminationWaveLength", 0x0022, 0x0055, [TagLink(OpticalPathSequence),])
    IlluminationPower = Tag('Illumination Power', "IlluminationPower", 0x0022, 0x0056)
    IlluminationBandwidth = Tag('Illumination Bandwidth', "IlluminationBandwidth", 0x0022, 0x0057)
    OphthalmicAxialMeasurementsRightEyeSequence = Tag('Ophthalmic Axial Measurements Right Eye Sequence', "OphthalmicAxialMeasurementsRightEyeSequence", 0x0022, 0x1007)
    OphthalmicAxialMeasurementsLeftEyeSequence = Tag('Ophthalmic Axial Measurements Left Eye Sequence', "OphthalmicAxialMeasurementsLeftEyeSequence", 0x0022, 0x1008)
    OphthalmicAxialMeasurementsDeviceType = Tag('Ophthalmic Axial Measurements Device Type', "OphthalmicAxialMeasurementsDeviceType", 0x0022, 0x1009)
    OphthalmicAxialLengthMeasurementsSequence = Tag('Ophthalmic Axial Length Measurements Sequence', "OphthalmicAxialLengthMeasurementsSequence", 0x0022, 0x1050)
    OphthalmicAxialLengthMeasurementsType = Tag('Ophthalmic Axial Length Measurements Type', "OphthalmicAxialLengthMeasurementsType", 0x0022, 0x1010, [TagLink(OphthalmicAxialLengthMeasurementsSequence),TagLink(UltrasoundSelectedOphthalmicAxialLengthSequence),TagLink(OpticalSelectedOphthalmicAxialLengthSequence),])
    OphthalmicAxialLengthMeasurementsTotalLengthSequence = Tag('Ophthalmic Axial Length Measurements Total Length Sequence', "OphthalmicAxialLengthMeasurementsTotalLengthSequence", 0x0022, 0x1210, [TagLink(OphthalmicAxialLengthMeasurementsSequence),])
    OphthalmicAxialLengthMeasurementsLengthSummationSequence = Tag('Ophthalmic Axial Length Measurements Length Summation Sequence', "OphthalmicAxialLengthMeasurementsLengthSummationSequence", 0x0022, 0x1212, [TagLink(OphthalmicAxialLengthMeasurementsSequence),])
    SelectedTotalOphthalmicAxialLengthSequence = Tag('Selected Total Ophthalmic Axial Length Sequence', "SelectedTotalOphthalmicAxialLengthSequence", 0x0022, 0x1260, [TagLink(OpticalSelectedOphthalmicAxialLengthSequence),])
    OphthalmicAxialLength = Tag('Ophthalmic Axial Length', "OphthalmicAxialLength", 0x0022, 0x1019, [TagLink(OphthalmicAxialLengthMeasurementsTotalLengthSequence),TagLink(OphthalmicAxialLengthMeasurementsLengthSummationSequence),TagLink(UltrasoundSelectedOphthalmicAxialLengthSequence),TagLink(SelectedSegmentalOphthalmicAxialLengthSequence),TagLink(SelectedTotalOphthalmicAxialLengthSequence),TagLink(OphthalmicAxialLengthSequence),])
    IOLFormulaDetail = Tag('IOL Formula Detail', "IOLFormulaDetail", 0x0022, 0x1029)
    KeratometerIndex = Tag('Keratometer Index', "KeratometerIndex", 0x0022, 0x1033)
    TargetRefraction = Tag('Target Refraction', "TargetRefraction", 0x0022, 0x1037)
    RefractiveProcedureOccurred = Tag('Refractive Procedure Occurred', "RefractiveProcedureOccurred", 0x0022, 0x1039)
    TypeOfOpticalCorrection = Tag('Type of Optical Correction', "TypeOfOpticalCorrection", 0x0022, 0x1046)
    IOLPowerSequence = Tag('IOL Power Sequence', "IOLPowerSequence", 0x0022, 0x1090)
    ToricIOLPowerSequence = Tag('Toric IOL Power Sequence', "ToricIOLPowerSequence", 0x0022, 0x1047, [TagLink(IOLPowerSequence),])
    PredictedToricErrorSequence = Tag('Predicted Toric Error Sequence', "PredictedToricErrorSequence", 0x0022, 0x1048, [TagLink(IOLPowerSequence),])
    PreSelectedForImplantation = Tag('Pre-Selected for Implantation', "PreSelectedForImplantation", 0x0022, 0x1049, [TagLink(IOLPowerSequence),])
    ToricIOLPowerForExactEmmetropiaSequence = Tag('Toric IOL Power for Exact Emmetropia Sequence', "ToricIOLPowerForExactEmmetropiaSequence", 0x0022, 0x104A)
    ToricIOLPowerForExactTargetRefractionSequence = Tag('Toric IOL Power for Exact Target Refraction Sequence', "ToricIOLPowerForExactTargetRefractionSequence", 0x0022, 0x104B)
    IOLPower = Tag('IOL Power', "IOLPower", 0x0022, 0x1053, [TagLink(IOLPowerSequence),])
    PredictedRefractiveError = Tag('Predicted Refractive Error', "PredictedRefractiveError", 0x0022, 0x1054, [TagLink(IOLPowerSequence),])
    OphthalmicAxialLengthVelocity = Tag('Ophthalmic Axial Length Velocity', "OphthalmicAxialLengthVelocity", 0x0022, 0x1059, [TagLink(UltrasoundOphthalmicAxialLengthMeasurementsSequence),])
    LensStatusDescription = Tag('Lens Status Description', "LensStatusDescription", 0x0022, 0x1065)
    VitreousStatusDescription = Tag('Vitreous Status Description', "VitreousStatusDescription", 0x0022, 0x1066)
    IOLManufacturer = Tag('IOL Manufacturer', "IOLManufacturer", 0x0022, 0x1093)
    LensConstantDescription = Tag('Lens Constant Description', "LensConstantDescription", 0x0022, 0x1094)
    ImplantName = Tag('Implant Name', "ImplantName", 0x0022, 0x1095)
    ImplantPartNumber = Tag('Implant Part Number', "ImplantPartNumber", 0x0022, 0x1097, [TagLink(IOLPowerSequence),])
    ReferencedOphthalmicAxialMeasurementsSequence = Tag('Referenced Ophthalmic Axial Measurements Sequence', "ReferencedOphthalmicAxialMeasurementsSequence", 0x0022, 0x1100)
    IOLPowerForExactEmmetropia = Tag('IOL Power For Exact Emmetropia', "IOLPowerForExactEmmetropia", 0x0022, 0x1121)
    IOLPowerForExactTargetRefraction = Tag('IOL Power For Exact Target Refraction', "IOLPowerForExactTargetRefraction", 0x0022, 0x1122)
    CalculationCommentSequence = Tag('Calculation Comment Sequence', "CalculationCommentSequence", 0x0022, 0x112A)
    CalculationCommentType = Tag('Calculation Comment Type', "CalculationCommentType", 0x0022, 0x112B, [TagLink(CalculationCommentSequence),])
    CalculationComment = Tag('Calculation Comment', "CalculationComment", 0x0022, 0x112C, [TagLink(CalculationCommentSequence),])
    LensThickness = Tag('Lens Thickness', "LensThickness", 0x0022, 0x1130, [TagLink(LensThicknessSequence),])
    AnteriorChamberDepth = Tag('Anterior Chamber Depth', "AnteriorChamberDepth", 0x0022, 0x1131, [TagLink(AnteriorChamberDepthSequence),])
    OphthalmicAxialLengthMeasurementModified = Tag('Ophthalmic Axial Length Measurement Modified', "OphthalmicAxialLengthMeasurementModified", 0x0022, 0x1140, [TagLink(OphthalmicAxialLengthMeasurementsTotalLengthSequence),TagLink(OphthalmicAxialLengthMeasurementsLengthSummationSequence),])
    OphthalmicAxialLengthAcquisitionMethodCodeSequence = Tag('Ophthalmic Axial Length Acquisition Method Code Sequence', "OphthalmicAxialLengthAcquisitionMethodCodeSequence", 0x0022, 0x1153)
    SignalToNoiseRatio = Tag('Signal to Noise Ratio', "SignalToNoiseRatio", 0x0022, 0x1155, [TagLink(OpticalOphthalmicAxialLengthMeasurementsSequence),])
    OphthalmicAxialLengthDataSourceDescription = Tag('Ophthalmic Axial Length Data Source Description', "OphthalmicAxialLengthDataSourceDescription", 0x0022, 0x1159, [TagLink(UltrasoundOphthalmicAxialLengthMeasurementsSequence),TagLink(OpticalOphthalmicAxialLengthMeasurementsSequence),])
    OphthalmicAxialLengthMeasurementsSegmentalLengthSequence = Tag('Ophthalmic Axial Length Measurements Segmental Length Sequence', "OphthalmicAxialLengthMeasurementsSegmentalLengthSequence", 0x0022, 0x1211, [TagLink(OphthalmicAxialLengthMeasurementsLengthSummationSequence),TagLink(OphthalmicAxialLengthMeasurementsSequence),])
    OphthalmicAxialLengthQualityMetricSequence = Tag('Ophthalmic Axial Length Quality Metric Sequence', "OphthalmicAxialLengthQualityMetricSequence", 0x0022, 0x1262, [TagLink(UltrasoundSelectedOphthalmicAxialLengthSequence),TagLink(SelectedTotalOphthalmicAxialLengthSequence),TagLink(SelectedSegmentalOphthalmicAxialLengthSequence),])
    OphthalmicAxialLengthQualityMetricTypeCodeSequence = Tag('Ophthalmic Axial Length Quality Metric Type Code Sequence', "OphthalmicAxialLengthQualityMetricTypeCodeSequence", 0x0022, 0x1265)
    OphthalmicAxialLengthQualityMetricTypeDescription = Tag('Ophthalmic Axial Length Quality Metric Type Description', "OphthalmicAxialLengthQualityMetricTypeDescription", 0x0022, 0x1273)
    IntraocularLensCalculationsRightEyeSequence = Tag('Intraocular Lens Calculations Right Eye Sequence', "IntraocularLensCalculationsRightEyeSequence", 0x0022, 0x1300)
    IntraocularLensCalculationsLeftEyeSequence = Tag('Intraocular Lens Calculations Left Eye Sequence', "IntraocularLensCalculationsLeftEyeSequence", 0x0022, 0x1310)
    ReferencedOphthalmicAxialLengthMeasurementQCImageSequence = Tag('Referenced Ophthalmic Axial Length Measurement QC Image Sequence', "ReferencedOphthalmicAxialLengthMeasurementQCImageSequence", 0x0022, 0x1330, [TagLink(OphthalmicAxialLengthMeasurementsTotalLengthSequence),TagLink(OphthalmicAxialLengthMeasurementsLengthSummationSequence),TagLink(UltrasoundSelectedOphthalmicAxialLengthSequence),TagLink(SelectedTotalOphthalmicAxialLengthSequence),TagLink(SelectedSegmentalOphthalmicAxialLengthSequence),])
    OphthalmicMappingDeviceType = Tag('Ophthalmic Mapping Device Type', "OphthalmicMappingDeviceType", 0x0022, 0x1415)
    OphthalmicThicknessMappingNormalsSequence = Tag('Ophthalmic Thickness Mapping Normals Sequence', "OphthalmicThicknessMappingNormalsSequence", 0x0022, 0x1443)
    MappedPixelValue = Tag('Mapped Pixel Value', "MappedPixelValue", 0x0022, 0x1452, [TagLink(PixelValueMappingToCodedConceptSequence),])
    PixelValueMappingExplanation = Tag('Pixel Value Mapping Explanation', "PixelValueMappingExplanation", 0x0022, 0x1454, [TagLink(PixelValueMappingToCodedConceptSequence),])
    OphthalmicThicknessMapThresholdQualityRating = Tag('Ophthalmic Thickness Map Threshold Quality Rating', "OphthalmicThicknessMapThresholdQualityRating", 0x0022, 0x1460, [TagLink(OphthalmicThicknessMapQualityThresholdSequence),])
    AnatomicStructureReferencePoint = Tag('Anatomic Structure Reference Point', "AnatomicStructureReferencePoint", 0x0022, 0x1463)
    RegistrationToLocalizerSequence = Tag('Registration to Localizer Sequence', "RegistrationToLocalizerSequence", 0x0022, 0x1465)
    RegisteredLocalizerUnits = Tag('Registered Localizer Units', "RegisteredLocalizerUnits", 0x0022, 0x1466, [TagLink(RegistrationToLocalizerSequence),])
    RegisteredLocalizerTopLeftHandCorner = Tag('Registered Localizer Top Left Hand Corner', "RegisteredLocalizerTopLeftHandCorner", 0x0022, 0x1467, [TagLink(RegistrationToLocalizerSequence),])
    RegisteredLocalizerBottomRightHandCorner = Tag('Registered Localizer Bottom Right Hand Corner', "RegisteredLocalizerBottomRightHandCorner", 0x0022, 0x1468, [TagLink(RegistrationToLocalizerSequence),])
    OphthalmicAxialLengthMethod = Tag('Ophthalmic Axial Length Method', "OphthalmicAxialLengthMethod", 0x0022, 0x1515)
    OphthalmicFOV = Tag('Ophthalmic FOV', "OphthalmicFOV", 0x0022, 0x1517)
    WideFieldOphthalmicPhotographyQualityThresholdSequence = Tag('Wide Field Ophthalmic Photography Quality Threshold Sequence', "WideFieldOphthalmicPhotographyQualityThresholdSequence", 0x0022, 0x1526, [TagLink(WideFieldOphthalmicPhotographyQualityRatingSequence),])
    WideFieldOphthalmicPhotographyThresholdQualityRating = Tag('Wide Field Ophthalmic Photography Threshold Quality Rating', "WideFieldOphthalmicPhotographyThresholdQualityRating", 0x0022, 0x1527, [TagLink(WideFieldOphthalmicPhotographyQualityThresholdSequence),])
    XCoordinatesCenterPixelViewAngle = Tag('X Coordinates Center Pixel View Angle', "XCoordinatesCenterPixelViewAngle", 0x0022, 0x1528)
    YCoordinatesCenterPixelViewAngle = Tag('Y Coordinates Center Pixel View Angle', "YCoordinatesCenterPixelViewAngle", 0x0022, 0x1529)
    NumberOfMapPoints = Tag('Number of Map Points', "NumberOfMapPoints", 0x0022, 0x1530, [TagLink(TwoDimensionalToThreeDimensionalMapSequence),])
    TwoDimensionalToThreeDimensionalMapData = Tag('Two Dimensional to Three Dimensional Map Data', "TwoDimensionalToThreeDimensionalMapData", 0x0022, 0x1531, [TagLink(TwoDimensionalToThreeDimensionalMapSequence),])
    OphthalmicImageTypeDescription = Tag('Ophthalmic Image Type Description', "OphthalmicImageTypeDescription", 0x0022, 0x1616)
    ReferencedSurfaceMeshIdentificationSequence = Tag('Referenced Surface Mesh Identification Sequence', "ReferencedSurfaceMeshIdentificationSequence", 0x0022, 0x1620)
    OphthalmicVolumetricPropertiesFlag = Tag('Ophthalmic Volumetric Properties Flag', "OphthalmicVolumetricPropertiesFlag", 0x0022, 0x1622)
    OphthalmicAnatomicReferencePointSequence = Tag('Ophthalmic Anatomic Reference Point Sequence', "OphthalmicAnatomicReferencePointSequence", 0x0022, 0x1632)
    OphthalmicAnatomicReferencePointFrameCoordinate = Tag('Ophthalmic Anatomic Reference Point Frame Coordinate', "OphthalmicAnatomicReferencePointFrameCoordinate", 0x0022, 0x1623, [TagLink(OphthalmicAnatomicReferencePointSequence),])
    OphthalmicAnatomicReferencePointXCoordinate = Tag('Ophthalmic Anatomic Reference Point X-Coordinate', "OphthalmicAnatomicReferencePointXCoordinate", 0x0022, 0x1624, [TagLink(OphthalmicAnatomicReferencePointSequence),])
    OphthalmicAnatomicReferencePointYCoordinate = Tag('Ophthalmic Anatomic Reference Point Y-Coordinate', "OphthalmicAnatomicReferencePointYCoordinate", 0x0022, 0x1626, [TagLink(OphthalmicAnatomicReferencePointSequence),])
    OphthalmicEnFaceVolumeDescriptorScope = Tag('Ophthalmic En Face Volume Descriptor Scope', "OphthalmicEnFaceVolumeDescriptorScope", 0x0022, 0x1629, [TagLink(OphthalmicEnFaceVolumeDescriptorSequence),])
    QualityThreshold = Tag('Quality Threshold', "QualityThreshold", 0x0022, 0x1630, [TagLink(OphthalmicEnFaceImageQualityRatingSequence),])
    OphthalmicAnatomicReferencePointLocalizationType = Tag('Ophthalmic Anatomic Reference Point Localization Type', "OphthalmicAnatomicReferencePointLocalizationType", 0x0022, 0x1633, [TagLink(OphthalmicAnatomicReferencePointSequence),])
    PrimaryAnatomicStructureItemIndex = Tag('Primary Anatomic Structure Item Index', "PrimaryAnatomicStructureItemIndex", 0x0022, 0x1634, [TagLink(OphthalmicAnatomicReferencePointSequence),])
    NumberOfBscansPerFrame = Tag('Number of B-scans Per Frame', "NumberOfBscansPerFrame", 0x0022, 0x1642, [TagLink(OCTBscanAnalysisAcquisitionParametersSequence),])
    BscanSlabThickness = Tag('B-scan Slab Thickness', "BscanSlabThickness", 0x0022, 0x1643, [TagLink(OCTBscanAnalysisAcquisitionParametersSequence),])
    DistanceBetweenBscanSlabs = Tag('Distance Between B-scan Slabs', "DistanceBetweenBscanSlabs", 0x0022, 0x1644, [TagLink(OCTBscanAnalysisAcquisitionParametersSequence),])
    BscanCycleTime = Tag('B-scan Cycle Time', "BscanCycleTime", 0x0022, 0x1645, [TagLink(OCTBscanAnalysisAcquisitionParametersSequence),])
    BscanCycleTimeVector = Tag('B-scan Cycle Time Vector', "BscanCycleTimeVector", 0x0022, 0x1646, [TagLink(OCTBscanAnalysisAcquisitionParametersSequence),])
    AscanRate = Tag('A-scan Rate', "AscanRate", 0x0022, 0x1649, [TagLink(OCTBscanAnalysisAcquisitionParametersSequence),])
    BscanRate = Tag('B-scan Rate', "BscanRate", 0x0022, 0x1650, [TagLink(OCTBscanAnalysisAcquisitionParametersSequence),])
    SurfaceMeshZPixelOffset = Tag('Surface Mesh Z-Pixel Offset', "SurfaceMeshZPixelOffset", 0x0022, 0x1658)
    VisualFieldHorizontalExtent = Tag('Visual Field Horizontal Extent', "VisualFieldHorizontalExtent", 0x0024, 0x0010)
    VisualFieldVerticalExtent = Tag('Visual Field Vertical Extent', "VisualFieldVerticalExtent", 0x0024, 0x0011)
    VisualFieldShape = Tag('Visual Field Shape', "VisualFieldShape", 0x0024, 0x0012)
    MaximumStimulusLuminance = Tag('Maximum Stimulus Luminance', "MaximumStimulusLuminance", 0x0024, 0x0018)
    BackgroundLuminance = Tag('Background Luminance', "BackgroundLuminance", 0x0024, 0x0020)
    StimulusArea = Tag('Stimulus Area', "StimulusArea", 0x0024, 0x0025)
    StimulusPresentationTime = Tag('Stimulus Presentation Time', "StimulusPresentationTime", 0x0024, 0x0028)
    VisualFieldCatchTrialSequence = Tag('Visual Field Catch Trial Sequence', "VisualFieldCatchTrialSequence", 0x0024, 0x0034)
    FixationCheckedQuantity = Tag('Fixation Checked Quantity', "FixationCheckedQuantity", 0x0024, 0x0035, [TagLink(FixationSequence),])
    PatientNotProperlyFixatedQuantity = Tag('Patient Not Properly Fixated Quantity', "PatientNotProperlyFixatedQuantity", 0x0024, 0x0036, [TagLink(FixationSequence),])
    PresentedVisualStimuliDataFlag = Tag('Presented Visual Stimuli Data Flag', "PresentedVisualStimuliDataFlag", 0x0024, 0x0037)
    NumberOfVisualStimuli = Tag('Number of Visual Stimuli', "NumberOfVisualStimuli", 0x0024, 0x0038)
    ExcessiveFixationLossesDataFlag = Tag('Excessive Fixation Losses Data Flag', "ExcessiveFixationLossesDataFlag", 0x0024, 0x0039, [TagLink(FixationSequence),])
    ExcessiveFixationLosses = Tag('Excessive Fixation Losses', "ExcessiveFixationLosses", 0x0024, 0x0040, [TagLink(FixationSequence),])
    StimuliRetestingQuantity = Tag('Stimuli Retesting Quantity', "StimuliRetestingQuantity", 0x0024, 0x0042)
    CommentsOnPatientPerformanceOfVisualField = Tag("Comments on Patient's Performance of Visual Field", "CommentsOnPatientPerformanceOfVisualField", 0x0024, 0x0044)
    FalseNegativesEstimateFlag = Tag('False Negatives Estimate Flag', "FalseNegativesEstimateFlag", 0x0024, 0x0045, [TagLink(VisualFieldCatchTrialSequence),])
    FalseNegativesEstimate = Tag('False Negatives Estimate', "FalseNegativesEstimate", 0x0024, 0x0046, [TagLink(VisualFieldCatchTrialSequence),])
    NegativeCatchTrialsQuantity = Tag('Negative Catch Trials Quantity', "NegativeCatchTrialsQuantity", 0x0024, 0x0048, [TagLink(VisualFieldCatchTrialSequence),])
    FalseNegativesQuantity = Tag('False Negatives Quantity', "FalseNegativesQuantity", 0x0024, 0x0050, [TagLink(VisualFieldCatchTrialSequence),])
    ExcessiveFalseNegativesDataFlag = Tag('Excessive False Negatives Data Flag', "ExcessiveFalseNegativesDataFlag", 0x0024, 0x0051, [TagLink(VisualFieldCatchTrialSequence),])
    ExcessiveFalseNegatives = Tag('Excessive False Negatives', "ExcessiveFalseNegatives", 0x0024, 0x0052, [TagLink(VisualFieldCatchTrialSequence),])
    FalsePositivesEstimateFlag = Tag('False Positives Estimate Flag', "FalsePositivesEstimateFlag", 0x0024, 0x0053, [TagLink(VisualFieldCatchTrialSequence),])
    FalsePositivesEstimate = Tag('False Positives Estimate', "FalsePositivesEstimate", 0x0024, 0x0054, [TagLink(VisualFieldCatchTrialSequence),])
    CatchTrialsDataFlag = Tag('Catch Trials Data Flag', "CatchTrialsDataFlag", 0x0024, 0x0055, [TagLink(VisualFieldCatchTrialSequence),])
    PositiveCatchTrialsQuantity = Tag('Positive Catch Trials Quantity', "PositiveCatchTrialsQuantity", 0x0024, 0x0056, [TagLink(VisualFieldCatchTrialSequence),])
    TestPointNormalsDataFlag = Tag('Test Point Normals Data Flag', "TestPointNormalsDataFlag", 0x0024, 0x0057)
    TestPointNormalsSequence = Tag('Test Point Normals Sequence', "TestPointNormalsSequence", 0x0024, 0x0058)
    GlobalDeviationProbabilityNormalsFlag = Tag('Global Deviation Probability Normals Flag', "GlobalDeviationProbabilityNormalsFlag", 0x0024, 0x0059, [TagLink(ResultsNormalsSequence),])
    FalsePositivesQuantity = Tag('False Positives Quantity', "FalsePositivesQuantity", 0x0024, 0x0060, [TagLink(VisualFieldCatchTrialSequence),])
    ExcessiveFalsePositivesDataFlag = Tag('Excessive False Positives Data Flag', "ExcessiveFalsePositivesDataFlag", 0x0024, 0x0061, [TagLink(VisualFieldCatchTrialSequence),])
    ExcessiveFalsePositives = Tag('Excessive False Positives', "ExcessiveFalsePositives", 0x0024, 0x0062, [TagLink(VisualFieldCatchTrialSequence),])
    VisualFieldTestNormalsFlag = Tag('Visual Field Test Normals Flag', "VisualFieldTestNormalsFlag", 0x0024, 0x0063)
    GlobalDeviationFromNormal = Tag('Global Deviation From Normal', "GlobalDeviationFromNormal", 0x0024, 0x0066, [TagLink(ResultsNormalsSequence),])
    LocalizedDeviationFromNormal = Tag('Localized Deviation From Normal', "LocalizedDeviationFromNormal", 0x0024, 0x0068, [TagLink(ResultsNormalsSequence),])
    PatientReliabilityIndicator = Tag('Patient Reliability Indicator', "PatientReliabilityIndicator", 0x0024, 0x0069)
    VisualFieldMeanSensitivity = Tag('Visual Field Mean Sensitivity', "VisualFieldMeanSensitivity", 0x0024, 0x0070)
    GlobalDeviationProbability = Tag('Global Deviation Probability', "GlobalDeviationProbability", 0x0024, 0x0071, [TagLink(GlobalDeviationProbabilitySequence),])
    LocalDeviationProbabilityNormalsFlag = Tag('Local Deviation Probability Normals Flag', "LocalDeviationProbabilityNormalsFlag", 0x0024, 0x0072, [TagLink(ResultsNormalsSequence),])
    LocalizedDeviationProbability = Tag('Localized Deviation Probability', "LocalizedDeviationProbability", 0x0024, 0x0073, [TagLink(LocalizedDeviationProbabilitySequence),])
    ShortTermFluctuationCalculated = Tag('Short Term Fluctuation Calculated', "ShortTermFluctuationCalculated", 0x0024, 0x0074)
    ShortTermFluctuation = Tag('Short Term Fluctuation', "ShortTermFluctuation", 0x0024, 0x0075)
    ShortTermFluctuationProbabilityCalculated = Tag('Short Term Fluctuation Probability Calculated', "ShortTermFluctuationProbabilityCalculated", 0x0024, 0x0076)
    ShortTermFluctuationProbability = Tag('Short Term Fluctuation Probability', "ShortTermFluctuationProbability", 0x0024, 0x0077)
    CorrectedLocalizedDeviationFromNormalCalculated = Tag('Corrected Localized Deviation From Normal Calculated', "CorrectedLocalizedDeviationFromNormalCalculated", 0x0024, 0x0078)
    CorrectedLocalizedDeviationFromNormal = Tag('Corrected Localized Deviation From Normal', "CorrectedLocalizedDeviationFromNormal", 0x0024, 0x0079)
    CorrectedLocalizedDeviationFromNormalProbabilityCalculated = Tag('Corrected Localized Deviation From Normal Probability Calculated', "CorrectedLocalizedDeviationFromNormalProbabilityCalculated", 0x0024, 0x0080)
    CorrectedLocalizedDeviationFromNormalProbability = Tag('Corrected Localized Deviation From Normal Probability', "CorrectedLocalizedDeviationFromNormalProbability", 0x0024, 0x0081)
    FovealSensitivityMeasured = Tag('Foveal Sensitivity Measured', "FovealSensitivityMeasured", 0x0024, 0x0086)
    FovealSensitivity = Tag('Foveal Sensitivity', "FovealSensitivity", 0x0024, 0x0087)
    VisualFieldTestDuration = Tag('Visual Field Test Duration', "VisualFieldTestDuration", 0x0024, 0x0088)
    VisualFieldTestPointSequence = Tag('Visual Field Test Point Sequence', "VisualFieldTestPointSequence", 0x0024, 0x0089)
    VisualFieldTestPointXCoordinate = Tag('Visual Field Test Point X-Coordinate', "VisualFieldTestPointXCoordinate", 0x0024, 0x0090, [TagLink(VisualFieldTestPointSequence),])
    VisualFieldTestPointYCoordinate = Tag('Visual Field Test Point Y-Coordinate', "VisualFieldTestPointYCoordinate", 0x0024, 0x0091, [TagLink(VisualFieldTestPointSequence),])
    VisualFieldTestPointNormalsSequence = Tag('Visual Field Test Point Normals Sequence', "VisualFieldTestPointNormalsSequence", 0x0024, 0x0097, [TagLink(VisualFieldTestPointSequence),])
    AgeCorrectedSensitivityDeviationValue = Tag('Age Corrected Sensitivity Deviation Value', "AgeCorrectedSensitivityDeviationValue", 0x0024, 0x0092, [TagLink(VisualFieldTestPointNormalsSequence),])
    StimulusResults = Tag('Stimulus Results', "StimulusResults", 0x0024, 0x0093, [TagLink(VisualFieldTestPointSequence),])
    SensitivityValue = Tag('Sensitivity Value', "SensitivityValue", 0x0024, 0x0094, [TagLink(VisualFieldTestPointSequence),])
    RetestStimulusSeen = Tag('Retest Stimulus Seen', "RetestStimulusSeen", 0x0024, 0x0095, [TagLink(VisualFieldTestPointSequence),])
    RetestSensitivityValue = Tag('Retest Sensitivity Value', "RetestSensitivityValue", 0x0024, 0x0096, [TagLink(VisualFieldTestPointSequence),])
    QuantifiedDefect = Tag('Quantified Defect', "QuantifiedDefect", 0x0024, 0x0098, [TagLink(VisualFieldTestPointSequence),])
    AgeCorrectedSensitivityDeviationProbabilityValue = Tag('Age Corrected Sensitivity Deviation Probability Value', "AgeCorrectedSensitivityDeviationProbabilityValue", 0x0024, 0x0100, [TagLink(VisualFieldTestPointNormalsSequence),])
    GeneralizedDefectCorrectedSensitivityDeviationFlag = Tag('Generalized Defect Corrected Sensitivity Deviation Flag', "GeneralizedDefectCorrectedSensitivityDeviationFlag", 0x0024, 0x0102, [TagLink(VisualFieldTestPointNormalsSequence),])
    GeneralizedDefectCorrectedSensitivityDeviationValue = Tag('Generalized Defect Corrected Sensitivity Deviation Value', "GeneralizedDefectCorrectedSensitivityDeviationValue", 0x0024, 0x0103, [TagLink(VisualFieldTestPointNormalsSequence),])
    GeneralizedDefectCorrectedSensitivityDeviationProbabilityValue = Tag('Generalized Defect Corrected Sensitivity Deviation Probability Value', "GeneralizedDefectCorrectedSensitivityDeviationProbabilityValue", 0x0024, 0x0104, [TagLink(VisualFieldTestPointNormalsSequence),])
    MinimumSensitivityValue = Tag('Minimum Sensitivity Value', "MinimumSensitivityValue", 0x0024, 0x0105)
    BlindSpotLocalized = Tag('Blind Spot Localized', "BlindSpotLocalized", 0x0024, 0x0106)
    BlindSpotXCoordinate = Tag('Blind Spot X-Coordinate', "BlindSpotXCoordinate", 0x0024, 0x0107)
    BlindSpotYCoordinate = Tag('Blind Spot Y-Coordinate', "BlindSpotYCoordinate", 0x0024, 0x0108)
    VisualAcuityMeasurementSequence = Tag('Visual Acuity Measurement Sequence', "VisualAcuityMeasurementSequence", 0x0024, 0x0110)
    MeasurementLaterality = Tag('Measurement Laterality', "MeasurementLaterality", 0x0024, 0x0113)
    OphthalmicPatientClinicalInformationLeftEyeSequence = Tag('Ophthalmic Patient Clinical Information Left Eye Sequence', "OphthalmicPatientClinicalInformationLeftEyeSequence", 0x0024, 0x0114)
    OphthalmicPatientClinicalInformationRightEyeSequence = Tag('Ophthalmic Patient Clinical Information Right Eye Sequence', "OphthalmicPatientClinicalInformationRightEyeSequence", 0x0024, 0x0115)
    FovealPointNormativeDataFlag = Tag('Foveal Point Normative Data Flag', "FovealPointNormativeDataFlag", 0x0024, 0x0117)
    FovealPointProbabilityValue = Tag('Foveal Point Probability Value', "FovealPointProbabilityValue", 0x0024, 0x0118)
    ScreeningBaselineMeasured = Tag('Screening Baseline Measured', "ScreeningBaselineMeasured", 0x0024, 0x0120)
    ScreeningBaselineMeasuredSequence = Tag('Screening Baseline Measured Sequence', "ScreeningBaselineMeasuredSequence", 0x0024, 0x0122)
    ScreeningBaselineType = Tag('Screening Baseline Type', "ScreeningBaselineType", 0x0024, 0x0124, [TagLink(ScreeningBaselineMeasuredSequence),])
    ScreeningBaselineValue = Tag('Screening Baseline Value', "ScreeningBaselineValue", 0x0024, 0x0126, [TagLink(ScreeningBaselineMeasuredSequence),])
    AlgorithmSource = Tag('Algorithm Source', "AlgorithmSource", 0x0024, 0x0202, [TagLink(ConceptualVolumeDerivationAlgorithmSequence),TagLink(ROIDerivationAlgorithmIdentificationSequence),TagLink(DerivationAlgorithmSequence),TagLink(DecompositionAlgorithmIdentificationSequence),TagLink(TransformationAlgorithmSequence),TagLink(WideFieldOphthalmicPhotographyQualityRatingSequence),TagLink(OphthalmicEnFaceImageQualityRatingSequence),TagLink(AcquisitionMethodAlgorithmSequence),TagLink(SegmentationAlgorithmIdentificationSequence),TagLink(SegmentSurfaceGenerationAlgorithmIdentificationSequence),TagLink(IndexProbabilitySequence),TagLink(AgeCorrectedSensitivityDeviationAlgorithmSequence),TagLink(GeneralizedDefectSensitivityDeviationAlgorithmSequence),TagLink(GlobalDeviationProbabilitySequence),TagLink(LocalizedDeviationProbabilitySequence),TagLink(OphthalmicThicknessMapQualityThresholdSequence),TagLink(TrackingAlgorithmIdentificationSequence),TagLink(ReconstructionAlgorithmSequence),TagLink(SurfaceProcessingAlgorithmIdentificationSequence),TagLink(AnnotationGroupAlgorithmIdentificationSequence),])
    CornealTopographyMappingNormalsSequence = Tag('Corneal Topography Mapping Normals Sequence', "CornealTopographyMappingNormalsSequence", 0x0046, 0x0210)
    DataSetName = Tag('Data Set Name', "DataSetName", 0x0024, 0x0306, [TagLink(TestPointNormalsSequence),TagLink(ResultsNormalsSequence),TagLink(OphthalmicThicknessMappingNormalsSequence),TagLink(CornealTopographyMappingNormalsSequence),])
    DataSetVersion = Tag('Data Set Version', "DataSetVersion", 0x0024, 0x0307, [TagLink(TestPointNormalsSequence),TagLink(ResultsNormalsSequence),TagLink(OphthalmicThicknessMappingNormalsSequence),TagLink(CornealTopographyMappingNormalsSequence),])
    DataSetSource = Tag('Data Set Source', "DataSetSource", 0x0024, 0x0308, [TagLink(TestPointNormalsSequence),TagLink(ResultsNormalsSequence),TagLink(OphthalmicThicknessMappingNormalsSequence),TagLink(CornealTopographyMappingNormalsSequence),])
    DataSetDescription = Tag('Data Set Description', "DataSetDescription", 0x0024, 0x0309, [TagLink(TestPointNormalsSequence),TagLink(ResultsNormalsSequence),TagLink(OphthalmicThicknessMappingNormalsSequence),TagLink(CornealTopographyMappingNormalsSequence),])
    VisualFieldTestReliabilityGlobalIndexSequence = Tag('Visual Field Test Reliability Global Index Sequence', "VisualFieldTestReliabilityGlobalIndexSequence", 0x0024, 0x0317)
    IndexNormalsFlag = Tag('Index Normals Flag', "IndexNormalsFlag", 0x0024, 0x0338, [TagLink(VisualFieldGlobalResultsIndexSequence),])
    IndexProbability = Tag('Index Probability', "IndexProbability", 0x0024, 0x0341, [TagLink(IndexProbabilitySequence),])
    IconImageSequence = Tag('Icon Image Sequence', "IconImageSequence", 0x0088, 0x0200, [TagLink(ReferencedSOPSequence),])
    SamplesPerPixel = Tag('Samples per Pixel', "SamplesPerPixel", 0x0028, 0x0002, [TagLink(IconImageSequence),])
    SamplesPerPixelUsed = Tag('Samples per Pixel Used', "SamplesPerPixelUsed", 0x0028, 0x0003)
    PhotometricInterpretation = Tag('Photometric Interpretation', "PhotometricInterpretation", 0x0028, 0x0004, [TagLink(IconImageSequence),])
    ImageDimensions = Tag('Image Dimensions', "ImageDimensions", 0x0028, 0x0005)
    PlanarConfiguration = Tag('Planar Configuration', "PlanarConfiguration", 0x0028, 0x0006, [TagLink(IconImageSequence),])
    NumberOfFrames = Tag('Number of Frames', "NumberOfFrames", 0x0028, 0x0008, [TagLink(SourcePixelPlanesCharacteristicsSequence),TagLink(InventoriedInstancesSequence),])
    FrameIncrementPointer = Tag('Frame Increment Pointer', "FrameIncrementPointer", 0x0028, 0x0009)
    FrameDimensionPointer = Tag('Frame Dimension Pointer', "FrameDimensionPointer", 0x0028, 0x000A)
    Rows = Tag('Rows', "Rows", 0x0028, 0x0010, [TagLink(SourcePixelPlanesCharacteristicsSequence),TagLink(IconImageSequence),TagLink(ContributingSourcesSequence),TagLink(ReconstructionProtocolElementSequence),TagLink(XAPlaneDetailsSequence),TagLink(InventoriedInstancesSequence),])
    Columns = Tag('Columns', "Columns", 0x0028, 0x0011, [TagLink(SourcePixelPlanesCharacteristicsSequence),TagLink(IconImageSequence),TagLink(ContributingSourcesSequence),TagLink(ReconstructionProtocolElementSequence),TagLink(XAPlaneDetailsSequence),TagLink(InventoriedInstancesSequence),])
    Planes = Tag('Planes', "Planes", 0x0028, 0x0012)
    UltrasoundColorDataPresent = Tag('Ultrasound Color Data Present', "UltrasoundColorDataPresent", 0x0028, 0x0014)
    PixelSpacing = Tag('Pixel Spacing', "PixelSpacing", 0x0028, 0x0030, [TagLink(PixelMeasuresSequence),TagLink(SourcePixelPlanesCharacteristicsSequence),])
    ZoomFactor = Tag('Zoom Factor', "ZoomFactor", 0x0028, 0x0031, [TagLink(DetectorInformationSequence),])
    ZoomCenter = Tag('Zoom Center', "ZoomCenter", 0x0028, 0x0032, [TagLink(DetectorInformationSequence),])
    PixelAspectRatio = Tag('Pixel Aspect Ratio', "PixelAspectRatio", 0x0028, 0x0034, [TagLink(IconImageSequence),])
    ImageFormat = Tag('Image Format', "ImageFormat", 0x0028, 0x0040)
    ManipulatedImage = Tag('Manipulated Image', "ManipulatedImage", 0x0028, 0x0050)
    CorrectedImage = Tag('Corrected Image', "CorrectedImage", 0x0028, 0x0051)
    CompressionRecognitionCode = Tag('Compression Recognition Code', "CompressionRecognitionCode", 0x0028, 0x005F)
    CompressionCode = Tag('Compression Code', "CompressionCode", 0x0028, 0x0060)
    CompressionOriginator = Tag('Compression Originator', "CompressionOriginator", 0x0028, 0x0061)
    CompressionLabel = Tag('Compression Label', "CompressionLabel", 0x0028, 0x0062)
    CompressionDescription = Tag('Compression Description', "CompressionDescription", 0x0028, 0x0063)
    CompressionSequence = Tag('Compression Sequence', "CompressionSequence", 0x0028, 0x0065)
    CompressionStepPointers = Tag('Compression Step Pointers', "CompressionStepPointers", 0x0028, 0x0066)
    RepeatInterval = Tag('Repeat Interval', "RepeatInterval", 0x0028, 0x0068)
    BitsGrouped = Tag('Bits Grouped', "BitsGrouped", 0x0028, 0x0069)
    PerimeterTable = Tag('Perimeter Table', "PerimeterTable", 0x0028, 0x0070)
    PerimeterValue = Tag('Perimeter Value', "PerimeterValue", 0x0028, 0x0071)
    PredictorRows = Tag('Predictor Rows', "PredictorRows", 0x0028, 0x0080)
    PredictorColumns = Tag('Predictor Columns', "PredictorColumns", 0x0028, 0x0081)
    PredictorConstants = Tag('Predictor Constants', "PredictorConstants", 0x0028, 0x0082)
    BlockedPixels = Tag('Blocked Pixels', "BlockedPixels", 0x0028, 0x0090)
    BlockRows = Tag('Block Rows', "BlockRows", 0x0028, 0x0091)
    BlockColumns = Tag('Block Columns', "BlockColumns", 0x0028, 0x0092)
    RowOverlap = Tag('Row Overlap', "RowOverlap", 0x0028, 0x0093)
    ColumnOverlap = Tag('Column Overlap', "ColumnOverlap", 0x0028, 0x0094)
    BitsAllocated = Tag('Bits Allocated', "BitsAllocated", 0x0028, 0x0100, [TagLink(IconImageSequence),TagLink(InventoriedInstancesSequence),])
    BitsStored = Tag('Bits Stored', "BitsStored", 0x0028, 0x0101, [TagLink(IconImageSequence),TagLink(ContributingSourcesSequence),TagLink(XAPlaneDetailsSequence),])
    HighBit = Tag('High Bit', "HighBit", 0x0028, 0x0102, [TagLink(IconImageSequence),])
    PixelRepresentation = Tag('Pixel Representation', "PixelRepresentation", 0x0028, 0x0103, [TagLink(IconImageSequence),])
    SmallestValidPixelValue = Tag('Smallest Valid Pixel Value', "SmallestValidPixelValue", 0x0028, 0x0104)
    LargestValidPixelValue = Tag('Largest Valid Pixel Value', "LargestValidPixelValue", 0x0028, 0x0105)
    SmallestImagePixelValue = Tag('Smallest Image Pixel Value', "SmallestImagePixelValue", 0x0028, 0x0106, [TagLink(IconImageSequence),])
    LargestImagePixelValue = Tag('Largest Image Pixel Value', "LargestImagePixelValue", 0x0028, 0x0107, [TagLink(IconImageSequence),])
    SmallestPixelValueInSeries = Tag('Smallest Pixel Value in Series', "SmallestPixelValueInSeries", 0x0028, 0x0108)
    LargestPixelValueInSeries = Tag('Largest Pixel Value in Series', "LargestPixelValueInSeries", 0x0028, 0x0109)
    SmallestImagePixelValueInPlane = Tag('Smallest Image Pixel Value in Plane', "SmallestImagePixelValueInPlane", 0x0028, 0x0110)
    LargestImagePixelValueInPlane = Tag('Largest Image Pixel Value in Plane', "LargestImagePixelValueInPlane", 0x0028, 0x0111)
    PixelPaddingValue = Tag('Pixel Padding Value', "PixelPaddingValue", 0x0028, 0x0120)
    PixelPaddingRangeLimit = Tag('Pixel Padding Range Limit', "PixelPaddingRangeLimit", 0x0028, 0x0121)
    FloatPixelPaddingValue = Tag('Float Pixel Padding Value', "FloatPixelPaddingValue", 0x0028, 0x0122)
    DoubleFloatPixelPaddingValue = Tag('Double Float Pixel Padding Value', "DoubleFloatPixelPaddingValue", 0x0028, 0x0123)
    FloatPixelPaddingRangeLimit = Tag('Float Pixel Padding Range Limit', "FloatPixelPaddingRangeLimit", 0x0028, 0x0124)
    DoubleFloatPixelPaddingRangeLimit = Tag('Double Float Pixel Padding Range Limit', "DoubleFloatPixelPaddingRangeLimit", 0x0028, 0x0125)
    ImageLocation = Tag('Image Location', "ImageLocation", 0x0028, 0x0200)
    QualityControlImage = Tag('Quality Control Image', "QualityControlImage", 0x0028, 0x0300)
    BurnedInAnnotation = Tag('Burned In Annotation', "BurnedInAnnotation", 0x0028, 0x0301)
    RecognizableVisualFeatures = Tag('Recognizable Visual Features', "RecognizableVisualFeatures", 0x0028, 0x0302)
    LongitudinalTemporalInformationModified = Tag('Longitudinal Temporal Information Modified', "LongitudinalTemporalInformationModified", 0x0028, 0x0303)
    ReferencedColorPaletteInstanceUID = Tag('Referenced Color Palette Instance UID', "ReferencedColorPaletteInstanceUID", 0x0028, 0x0304)
    TransformLabel = Tag('Transform Label', "TransformLabel", 0x0028, 0x0400)
    TransformVersionNumber = Tag('Transform Version Number', "TransformVersionNumber", 0x0028, 0x0401)
    NumberOfTransformSteps = Tag('Number of Transform Steps', "NumberOfTransformSteps", 0x0028, 0x0402)
    SequenceOfCompressedData = Tag('Sequence of Compressed Data', "SequenceOfCompressedData", 0x0028, 0x0403)
    DetailsOfCoefficients = Tag('Details of Coefficients', "DetailsOfCoefficients", 0x0028, 0x0404)
    RowsForNthOrderCoefficients = Tag('Rows For Nth Order Coefficients', "RowsForNthOrderCoefficients", 0x0028, 0x0410, [], [(0x0028, 0x0420),(0x0028, 0x0430),(0x0028, 0x0440),(0x0028, 0x0450),(0x0028, 0x0460),(0x0028, 0x0470),(0x0028, 0x0480),(0x0028, 0x0490),(0x0028, 0x04A0),(0x0028, 0x04B0),(0x0028, 0x04C0),(0x0028, 0x04D0),(0x0028, 0x04E0),(0x0028, 0x04F0),])
    ColumnsForNthOrderCoefficients = Tag('Columns For Nth Order Coefficients', "ColumnsForNthOrderCoefficients", 0x0028, 0x0411, [], [(0x0028, 0x0421),(0x0028, 0x0431),(0x0028, 0x0441),(0x0028, 0x0451),(0x0028, 0x0461),(0x0028, 0x0471),(0x0028, 0x0481),(0x0028, 0x0491),(0x0028, 0x04A1),(0x0028, 0x04B1),(0x0028, 0x04C1),(0x0028, 0x04D1),(0x0028, 0x04E1),(0x0028, 0x04F1),])
    CoefficientCoding = Tag('Coefficient Coding', "CoefficientCoding", 0x0028, 0x0412, [], [(0x0028, 0x0422),(0x0028, 0x0432),(0x0028, 0x0442),(0x0028, 0x0452),(0x0028, 0x0462),(0x0028, 0x0472),(0x0028, 0x0482),(0x0028, 0x0492),(0x0028, 0x04A2),(0x0028, 0x04B2),(0x0028, 0x04C2),(0x0028, 0x04D2),(0x0028, 0x04E2),(0x0028, 0x04F2),])
    CoefficientCodingPointers = Tag('Coefficient Coding Pointers', "CoefficientCodingPointers", 0x0028, 0x0413, [], [(0x0028, 0x0423),(0x0028, 0x0433),(0x0028, 0x0443),(0x0028, 0x0453),(0x0028, 0x0463),(0x0028, 0x0473),(0x0028, 0x0483),(0x0028, 0x0493),(0x0028, 0x04A3),(0x0028, 0x04B3),(0x0028, 0x04C3),(0x0028, 0x04D3),(0x0028, 0x04E3),(0x0028, 0x04F3),])
    DCTLabel = Tag('DCT Label', "DCTLabel", 0x0028, 0x0700)
    DataBlockDescription = Tag('Data Block Description', "DataBlockDescription", 0x0028, 0x0701)
    DataBlock = Tag('Data Block', "DataBlock", 0x0028, 0x0702)
    NormalizationFactorFormat = Tag('Normalization Factor Format', "NormalizationFactorFormat", 0x0028, 0x0710)
    ZonalMapNumberFormat = Tag('Zonal Map Number Format', "ZonalMapNumberFormat", 0x0028, 0x0720)
    ZonalMapLocation = Tag('Zonal Map Location', "ZonalMapLocation", 0x0028, 0x0721)
    ZonalMapFormat = Tag('Zonal Map Format', "ZonalMapFormat", 0x0028, 0x0722)
    AdaptiveMapFormat = Tag('Adaptive Map Format', "AdaptiveMapFormat", 0x0028, 0x0730)
    CodeNumberFormat = Tag('Code Number Format', "CodeNumberFormat", 0x0028, 0x0740)
    CodeLabel = Tag('Code Label', "CodeLabel", 0x0028, 0x0800, [], [(0x0028, 0x0810),(0x0028, 0x0820),(0x0028, 0x0830),(0x0028, 0x0840),(0x0028, 0x0850),(0x0028, 0x0860),(0x0028, 0x0870),(0x0028, 0x0880),(0x0028, 0x0890),(0x0028, 0x08A0),(0x0028, 0x08B0),(0x0028, 0x08C0),(0x0028, 0x08D0),(0x0028, 0x08E0),(0x0028, 0x08F0),])
    NumberOfTables = Tag('Number of Tables', "NumberOfTables", 0x0028, 0x0802, [], [(0x0028, 0x0812),(0x0028, 0x0822),(0x0028, 0x0832),(0x0028, 0x0842),(0x0028, 0x0852),(0x0028, 0x0862),(0x0028, 0x0872),(0x0028, 0x0882),(0x0028, 0x0892),(0x0028, 0x08A2),(0x0028, 0x08B2),(0x0028, 0x08C2),(0x0028, 0x08D2),(0x0028, 0x08E2),(0x0028, 0x08F2),])
    CodeTableLocation = Tag('Code Table Location', "CodeTableLocation", 0x0028, 0x0803, [], [(0x0028, 0x0813),(0x0028, 0x0823),(0x0028, 0x0833),(0x0028, 0x0843),(0x0028, 0x0853),(0x0028, 0x0863),(0x0028, 0x0873),(0x0028, 0x0883),(0x0028, 0x0893),(0x0028, 0x08A3),(0x0028, 0x08B3),(0x0028, 0x08C3),(0x0028, 0x08D3),(0x0028, 0x08E3),(0x0028, 0x08F3),])
    BitsForCodeWord = Tag('Bits For Code Word', "BitsForCodeWord", 0x0028, 0x0804, [], [(0x0028, 0x0814),(0x0028, 0x0824),(0x0028, 0x0834),(0x0028, 0x0844),(0x0028, 0x0854),(0x0028, 0x0864),(0x0028, 0x0874),(0x0028, 0x0884),(0x0028, 0x0894),(0x0028, 0x08A4),(0x0028, 0x08B4),(0x0028, 0x08C4),(0x0028, 0x08D4),(0x0028, 0x08E4),(0x0028, 0x08F4),])
    ImageDataLocation = Tag('Image Data Location', "ImageDataLocation", 0x0028, 0x0808, [], [(0x0028, 0x0818),(0x0028, 0x0828),(0x0028, 0x0838),(0x0028, 0x0848),(0x0028, 0x0858),(0x0028, 0x0868),(0x0028, 0x0878),(0x0028, 0x0888),(0x0028, 0x0898),(0x0028, 0x08A8),(0x0028, 0x08B8),(0x0028, 0x08C8),(0x0028, 0x08D8),(0x0028, 0x08E8),(0x0028, 0x08F8),])
    PixelSpacingCalibrationType = Tag('Pixel Spacing Calibration Type', "PixelSpacingCalibrationType", 0x0028, 0x0A02)
    PixelSpacingCalibrationDescription = Tag('Pixel Spacing Calibration Description', "PixelSpacingCalibrationDescription", 0x0028, 0x0A04)
    PixelIntensityRelationship = Tag('Pixel Intensity Relationship', "PixelIntensityRelationship", 0x0028, 0x1040, [TagLink(FramePixelDataPropertiesSequence),])
    PixelIntensityRelationshipSign = Tag('Pixel Intensity Relationship Sign', "PixelIntensityRelationshipSign", 0x0028, 0x1041, [TagLink(FramePixelDataPropertiesSequence),])
    FrameVOILUTSequence = Tag('Frame VOI LUT Sequence', "FrameVOILUTSequence", 0x0028, 0x9132, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    VolumetricPresentationStateInputSequence = Tag('Volumetric Presentation State Input Sequence', "VolumetricPresentationStateInputSequence", 0x0070, 0x1201)
    WindowCenter = Tag('Window Center', "WindowCenter", 0x0028, 0x1050, [TagLink(FrameVOILUTSequence),TagLink(SoftcopyVOILUTSequence),TagLink(VolumetricPresentationStateInputSequence),TagLink(ReconstructionProtocolElementSequence),])
    WindowWidth = Tag('Window Width', "WindowWidth", 0x0028, 0x1051, [TagLink(FrameVOILUTSequence),TagLink(SoftcopyVOILUTSequence),TagLink(VolumetricPresentationStateInputSequence),TagLink(ReconstructionProtocolElementSequence),])
    PixelValueTransformationSequence = Tag('Pixel Value Transformation Sequence', "PixelValueTransformationSequence", 0x0028, 0x9145, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    RescaleIntercept = Tag('Rescale Intercept', "RescaleIntercept", 0x0028, 0x1052, [TagLink(PixelValueTransformationSequence),TagLink(BlendingSequence),TagLink(VariableModalityLUTSequence),])
    RescaleSlope = Tag('Rescale Slope', "RescaleSlope", 0x0028, 0x1053, [TagLink(PixelValueTransformationSequence),TagLink(BlendingSequence),TagLink(VariableModalityLUTSequence),])
    RescaleType = Tag('Rescale Type', "RescaleType", 0x0028, 0x1054, [TagLink(PixelValueTransformationSequence),TagLink(BlendingSequence),TagLink(VariableModalityLUTSequence),])
    WindowCenterWidthExplanation = Tag('Window Center & Width Explanation', "WindowCenterWidthExplanation", 0x0028, 0x1055, [TagLink(FrameVOILUTSequence),TagLink(SoftcopyVOILUTSequence),TagLink(VolumetricPresentationStateInputSequence),])
    VOILUTFunction = Tag('VOI LUT Function', "VOILUTFunction", 0x0028, 0x1056, [TagLink(FrameVOILUTSequence),TagLink(SoftcopyVOILUTSequence),TagLink(VolumetricPresentationStateInputSequence),])
    GrayScale = Tag('Gray Scale', "GrayScale", 0x0028, 0x1080)
    RecommendedViewingMode = Tag('Recommended Viewing Mode', "RecommendedViewingMode", 0x0028, 0x1090, [TagLink(FrameDisplaySequence),])
    GrayLookupTableDescriptor = Tag('Gray Lookup Table Descriptor', "GrayLookupTableDescriptor", 0x0028, 0x1100)
    EnhancedPaletteColorLookupTableSequence = Tag('Enhanced Palette Color Lookup Table Sequence', "EnhancedPaletteColorLookupTableSequence", 0x0028, 0x140B)
    PaletteColorLookupTableSequence = Tag('Palette Color Lookup Table Sequence', "PaletteColorLookupTableSequence", 0x0048, 0x0120, [TagLink(OpticalPathSequence),TagLink(AdvancedBlendingSequence),])
    VolumeStreamSequence = Tag('Volume Stream Sequence', "VolumeStreamSequence", 0x0070, 0x1A08)
    PresentationStateClassificationComponentSequence = Tag('Presentation State Classification Component Sequence', "PresentationStateClassificationComponentSequence", 0x0070, 0x1801, [TagLink(VolumeStreamSequence),])
    RedPaletteColorLookupTableDescriptor = Tag('Red Palette Color Lookup Table Descriptor', "RedPaletteColorLookupTableDescriptor", 0x0028, 0x1101, [TagLink(EnhancedPaletteColorLookupTableSequence),TagLink(PaletteColorLookupTableSequence),TagLink(IconImageSequence),TagLink(PresentationStateClassificationComponentSequence),])
    GreenPaletteColorLookupTableDescriptor = Tag('Green Palette Color Lookup Table Descriptor', "GreenPaletteColorLookupTableDescriptor", 0x0028, 0x1102, [TagLink(EnhancedPaletteColorLookupTableSequence),TagLink(PaletteColorLookupTableSequence),TagLink(IconImageSequence),TagLink(PresentationStateClassificationComponentSequence),])
    BluePaletteColorLookupTableDescriptor = Tag('Blue Palette Color Lookup Table Descriptor', "BluePaletteColorLookupTableDescriptor", 0x0028, 0x1103, [TagLink(EnhancedPaletteColorLookupTableSequence),TagLink(PaletteColorLookupTableSequence),TagLink(IconImageSequence),TagLink(PresentationStateClassificationComponentSequence),])
    AlphaPaletteColorLookupTableDescriptor = Tag('Alpha Palette Color Lookup Table Descriptor', "AlphaPaletteColorLookupTableDescriptor", 0x0028, 0x1104, [TagLink(EnhancedPaletteColorLookupTableSequence),TagLink(PresentationStateClassificationComponentSequence),])
    LargeRedPaletteColorLookupTableDescriptor = Tag('Large Red Palette Color Lookup Table Descriptor', "LargeRedPaletteColorLookupTableDescriptor", 0x0028, 0x1111)
    LargeGreenPaletteColorLookupTableDescriptor = Tag('Large Green Palette Color Lookup Table Descriptor', "LargeGreenPaletteColorLookupTableDescriptor", 0x0028, 0x1112)
    LargeBluePaletteColorLookupTableDescriptor = Tag('Large Blue Palette Color Lookup Table Descriptor', "LargeBluePaletteColorLookupTableDescriptor", 0x0028, 0x1113)
    PaletteColorLookupTableUID = Tag('Palette Color Lookup Table UID', "PaletteColorLookupTableUID", 0x0028, 0x1199, [TagLink(PaletteColorLookupTableSequence),TagLink(PresentationStateClassificationComponentSequence),])
    GrayLookupTableData = Tag('Gray Lookup Table Data', "GrayLookupTableData", 0x0028, 0x1200)
    RedPaletteColorLookupTableData = Tag('Red Palette Color Lookup Table Data', "RedPaletteColorLookupTableData", 0x0028, 0x1201, [TagLink(EnhancedPaletteColorLookupTableSequence),TagLink(PaletteColorLookupTableSequence),TagLink(IconImageSequence),TagLink(PresentationStateClassificationComponentSequence),])
    GreenPaletteColorLookupTableData = Tag('Green Palette Color Lookup Table Data', "GreenPaletteColorLookupTableData", 0x0028, 0x1202, [TagLink(EnhancedPaletteColorLookupTableSequence),TagLink(PaletteColorLookupTableSequence),TagLink(IconImageSequence),TagLink(PresentationStateClassificationComponentSequence),])
    BluePaletteColorLookupTableData = Tag('Blue Palette Color Lookup Table Data', "BluePaletteColorLookupTableData", 0x0028, 0x1203, [TagLink(EnhancedPaletteColorLookupTableSequence),TagLink(PaletteColorLookupTableSequence),TagLink(IconImageSequence),TagLink(PresentationStateClassificationComponentSequence),])
    AlphaPaletteColorLookupTableData = Tag('Alpha Palette Color Lookup Table Data', "AlphaPaletteColorLookupTableData", 0x0028, 0x1204, [TagLink(EnhancedPaletteColorLookupTableSequence),TagLink(PresentationStateClassificationComponentSequence),])
    LargeRedPaletteColorLookupTableData = Tag('Large Red Palette Color Lookup Table Data', "LargeRedPaletteColorLookupTableData", 0x0028, 0x1211)
    LargeGreenPaletteColorLookupTableData = Tag('Large Green Palette Color Lookup Table Data', "LargeGreenPaletteColorLookupTableData", 0x0028, 0x1212)
    LargeBluePaletteColorLookupTableData = Tag('Large Blue Palette Color Lookup Table Data', "LargeBluePaletteColorLookupTableData", 0x0028, 0x1213)
    LargePaletteColorLookupTableUID = Tag('Large Palette Color Lookup Table UID', "LargePaletteColorLookupTableUID", 0x0028, 0x1214)
    SegmentedRedPaletteColorLookupTableData = Tag('Segmented Red Palette Color Lookup Table Data', "SegmentedRedPaletteColorLookupTableData", 0x0028, 0x1221, [TagLink(PaletteColorLookupTableSequence),TagLink(PresentationStateClassificationComponentSequence),])
    SegmentedGreenPaletteColorLookupTableData = Tag('Segmented Green Palette Color Lookup Table Data', "SegmentedGreenPaletteColorLookupTableData", 0x0028, 0x1222, [TagLink(PaletteColorLookupTableSequence),TagLink(PresentationStateClassificationComponentSequence),])
    SegmentedBluePaletteColorLookupTableData = Tag('Segmented Blue Palette Color Lookup Table Data', "SegmentedBluePaletteColorLookupTableData", 0x0028, 0x1223, [TagLink(PaletteColorLookupTableSequence),TagLink(PresentationStateClassificationComponentSequence),])
    SegmentedAlphaPaletteColorLookupTableData = Tag('Segmented Alpha Palette Color Lookup Table Data', "SegmentedAlphaPaletteColorLookupTableData", 0x0028, 0x1224, [TagLink(PresentationStateClassificationComponentSequence),])
    StoredValueColorRangeSequence = Tag('Stored Value Color Range Sequence', "StoredValueColorRangeSequence", 0x0028, 0x1230, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    MinimumStoredValueMapped = Tag('Minimum Stored Value Mapped', "MinimumStoredValueMapped", 0x0028, 0x1231, [TagLink(StoredValueColorRangeSequence),])
    MaximumStoredValueMapped = Tag('Maximum Stored Value Mapped', "MaximumStoredValueMapped", 0x0028, 0x1232, [TagLink(StoredValueColorRangeSequence),])
    BreastImplantPresent = Tag('Breast Implant Present', "BreastImplantPresent", 0x0028, 0x1300)
    PartialView = Tag('Partial View', "PartialView", 0x0028, 0x1350)
    PartialViewDescription = Tag('Partial View Description', "PartialViewDescription", 0x0028, 0x1351)
    SpatialLocationsPreserved = Tag('Spatial Locations Preserved', "SpatialLocationsPreserved", 0x0028, 0x135A, [TagLink(SourceImageSequence),])
    DataPathAssignment = Tag('Data Path Assignment', "DataPathAssignment", 0x0028, 0x1402, [TagLink(DataFrameAssignmentSequence),])
    ComponentInputSequence = Tag('Component Input Sequence', "ComponentInputSequence", 0x0070, 0x1803, [TagLink(PresentationStateClassificationComponentSequence),])
    BitsMappedToColorLookupTable = Tag('Bits Mapped to Color Lookup Table', "BitsMappedToColorLookupTable", 0x0028, 0x1403, [TagLink(DataFrameAssignmentSequence),TagLink(ComponentInputSequence),])
    BlendingLUT1Sequence = Tag('Blending LUT 1 Sequence', "BlendingLUT1Sequence", 0x0028, 0x1404)
    BlendingLUT1TransferFunction = Tag('Blending LUT 1 Transfer Function', "BlendingLUT1TransferFunction", 0x0028, 0x1405, [TagLink(BlendingLUT1Sequence),])
    BlendingLUT2Sequence = Tag('Blending LUT 2 Sequence', "BlendingLUT2Sequence", 0x0028, 0x140C)
    BlendingWeightConstant = Tag('Blending Weight Constant', "BlendingWeightConstant", 0x0028, 0x1406, [TagLink(BlendingLUT1Sequence),TagLink(BlendingLUT2Sequence),])
    BlendingLookupTableDescriptor = Tag('Blending Lookup Table Descriptor', "BlendingLookupTableDescriptor", 0x0028, 0x1407, [TagLink(BlendingLUT1Sequence),TagLink(BlendingLUT2Sequence),])
    BlendingLookupTableData = Tag('Blending Lookup Table Data', "BlendingLookupTableData", 0x0028, 0x1408, [TagLink(BlendingLUT1Sequence),TagLink(BlendingLUT2Sequence),])
    BlendingLUT2TransferFunction = Tag('Blending LUT 2 Transfer Function', "BlendingLUT2TransferFunction", 0x0028, 0x140D, [TagLink(BlendingLUT2Sequence),])
    DataPathID = Tag('Data Path ID', "DataPathID", 0x0028, 0x140E, [TagLink(EnhancedPaletteColorLookupTableSequence),])
    RGBLUTTransferFunction = Tag('RGB LUT Transfer Function', "RGBLUTTransferFunction", 0x0028, 0x140F, [TagLink(EnhancedPaletteColorLookupTableSequence),TagLink(PresentationStateClassificationComponentSequence),])
    AlphaLUTTransferFunction = Tag('Alpha LUT Transfer Function', "AlphaLUTTransferFunction", 0x0028, 0x1410, [TagLink(EnhancedPaletteColorLookupTableSequence),TagLink(PresentationStateClassificationComponentSequence),])
    ICCProfile = Tag('ICC Profile', "ICCProfile", 0x0028, 0x2000, [TagLink(OpticalPathSequence),TagLink(IconImageSequence),])
    ColorSpace = Tag('Color Space', "ColorSpace", 0x0028, 0x2002, [TagLink(OpticalPathSequence),TagLink(IconImageSequence),])
    LossyImageCompression = Tag('Lossy Image Compression', "LossyImageCompression", 0x0028, 0x2110, [TagLink(ContributingSourcesSequence),])
    LossyImageCompressionRatio = Tag('Lossy Image Compression Ratio', "LossyImageCompressionRatio", 0x0028, 0x2112, [TagLink(ContributingSourcesSequence),TagLink(IncorporatedInventoryInstanceSequence),])
    LossyImageCompressionMethod = Tag('Lossy Image Compression Method', "LossyImageCompressionMethod", 0x0028, 0x2114, [TagLink(ContributingSourcesSequence),])
    ModalityLUTSequence = Tag('Modality LUT Sequence', "ModalityLUTSequence", 0x0028, 0x3000, [TagLink(BlendingSequence),TagLink(VariableModalityLUTSequence),])
    PixelIntensityRelationshipLUTSequence = Tag('Pixel Intensity Relationship LUT Sequence', "PixelIntensityRelationshipLUTSequence", 0x0028, 0x9422, [TagLink(MaskSubtractionSequence),TagLink(PerFrameFunctionalGroupsSequence, True),])
    VOILUTSequence = Tag('VOI LUT Sequence', "VOILUTSequence", 0x0028, 0x3010, [TagLink(SoftcopyVOILUTSequence),TagLink(VolumetricPresentationStateInputSequence),])
    PresentationLUTSequence = Tag('Presentation LUT Sequence', "PresentationLUTSequence", 0x2050, 0x0010)
    PresentationStateCompositorComponentSequence = Tag('Presentation State Compositor Component Sequence', "PresentationStateCompositorComponentSequence", 0x0070, 0x1805)
    WeightingTransferFunctionSequence = Tag('Weighting Transfer Function Sequence', "WeightingTransferFunctionSequence", 0x0070, 0x1806, [TagLink(PresentationStateCompositorComponentSequence),])
    LUTDescriptor = Tag('LUT Descriptor', "LUTDescriptor", 0x0028, 0x3002, [TagLink(PixelIntensityRelationshipLUTSequence),TagLink(VOILUTSequence),TagLink(ModalityLUTSequence),TagLink(PresentationLUTSequence),TagLink(WeightingTransferFunctionSequence),])
    LUTExplanation = Tag('LUT Explanation', "LUTExplanation", 0x0028, 0x3003, [TagLink(RealWorldValueMappingSequence),TagLink(VOILUTSequence),TagLink(ModalityLUTSequence),TagLink(PresentationLUTSequence),TagLink(PerFrameFunctionalGroupsSequence, True),])
    ModalityLUTType = Tag('Modality LUT Type', "ModalityLUTType", 0x0028, 0x3004, [TagLink(ModalityLUTSequence),])
    LUTData = Tag('LUT Data', "LUTData", 0x0028, 0x3006, [TagLink(PixelIntensityRelationshipLUTSequence),TagLink(VOILUTSequence),TagLink(ModalityLUTSequence),TagLink(PresentationLUTSequence),TagLink(WeightingTransferFunctionSequence),])
    ImagePresentationComments = Tag('Image Presentation Comments', "ImagePresentationComments", 0x0028, 0x4000)
    BiPlaneAcquisitionSequence = Tag('Bi-Plane Acquisition Sequence', "BiPlaneAcquisitionSequence", 0x0028, 0x5000)
    RepresentativeFrameNumber = Tag('Representative Frame Number', "RepresentativeFrameNumber", 0x0028, 0x6010)
    FrameNumbersOfInterest = Tag('Frame Numbers of Interest (FOI)', "FrameNumbersOfInterest", 0x0028, 0x6020)
    FrameOfInterestDescription = Tag('Frame of Interest Description', "FrameOfInterestDescription", 0x0028, 0x6022)
    FrameOfInterestType = Tag('Frame of Interest Type', "FrameOfInterestType", 0x0028, 0x6023)
    MaskPointers = Tag('Mask Pointer(s)', "MaskPointers", 0x0028, 0x6030)
    RWavePointer = Tag('R Wave Pointer', "RWavePointer", 0x0028, 0x6040)
    MaskOperation = Tag('Mask Operation', "MaskOperation", 0x0028, 0x6101, [TagLink(MaskSubtractionSequence),])
    ApplicableFrameRange = Tag('Applicable Frame Range', "ApplicableFrameRange", 0x0028, 0x6102, [TagLink(MaskSubtractionSequence),])
    MaskFrameNumbers = Tag('Mask Frame Numbers', "MaskFrameNumbers", 0x0028, 0x6110, [TagLink(MaskSubtractionSequence),])
    ContrastFrameAveraging = Tag('Contrast Frame Averaging', "ContrastFrameAveraging", 0x0028, 0x6112, [TagLink(MaskSubtractionSequence),])
    FramePixelShiftSequence = Tag('Frame Pixel Shift Sequence', "FramePixelShiftSequence", 0x0028, 0x9415, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    PixelShiftSequence = Tag('Pixel Shift Sequence', "PixelShiftSequence", 0x0028, 0x9501, [TagLink(MaskSubtractionSequence),])
    RegionPixelShiftSequence = Tag('Region Pixel Shift Sequence', "RegionPixelShiftSequence", 0x0028, 0x9502, [TagLink(PixelShiftSequence),])
    MaskSubPixelShift = Tag('Mask Sub-pixel Shift', "MaskSubPixelShift", 0x0028, 0x6114, [TagLink(MaskSubtractionSequence),TagLink(FramePixelShiftSequence),TagLink(RegionPixelShiftSequence),])
    TIDOffset = Tag('TID Offset', "TIDOffset", 0x0028, 0x6120, [TagLink(MaskSubtractionSequence),])
    MaskOperationExplanation = Tag('Mask Operation Explanation', "MaskOperationExplanation", 0x0028, 0x6190, [TagLink(MaskSubtractionSequence),])
    EquipmentAdministratorSequence = Tag('Equipment Administrator Sequence', "EquipmentAdministratorSequence", 0x0028, 0x7000)
    NumberOfDisplaySubsystems = Tag('Number of Display Subsystems', "NumberOfDisplaySubsystems", 0x0028, 0x7001)
    CurrentConfigurationID = Tag('Current Configuration ID', "CurrentConfigurationID", 0x0028, 0x7002)
    DisplaySubsystemID = Tag('Display Subsystem ID', "DisplaySubsystemID", 0x0028, 0x7003)
    DisplaySubsystemName = Tag('Display Subsystem Name', "DisplaySubsystemName", 0x0028, 0x7004)
    DisplaySubsystemDescription = Tag('Display Subsystem Description', "DisplaySubsystemDescription", 0x0028, 0x7005)
    SystemStatus = Tag('System Status', "SystemStatus", 0x0028, 0x7006)
    SystemStatusComment = Tag('System Status Comment', "SystemStatusComment", 0x0028, 0x7007)
    TargetLuminanceCharacteristicsSequence = Tag('Target Luminance Characteristics Sequence', "TargetLuminanceCharacteristicsSequence", 0x0028, 0x7008)
    LuminanceCharacteristicsID = Tag('Luminance Characteristics ID', "LuminanceCharacteristicsID", 0x0028, 0x7009)
    DisplaySubsystemConfigurationSequence = Tag('Display Subsystem Configuration Sequence', "DisplaySubsystemConfigurationSequence", 0x0028, 0x700A)
    ConfigurationID = Tag('Configuration ID', "ConfigurationID", 0x0028, 0x700B)
    ConfigurationName = Tag('Configuration Name', "ConfigurationName", 0x0028, 0x700C)
    ConfigurationDescription = Tag('Configuration Description', "ConfigurationDescription", 0x0028, 0x700D)
    ReferencedTargetLuminanceCharacteristicsID = Tag('Referenced Target Luminance Characteristics ID', "ReferencedTargetLuminanceCharacteristicsID", 0x0028, 0x700E)
    QAResultsSequence = Tag('QA Results Sequence', "QAResultsSequence", 0x0028, 0x700F)
    DisplaySubsystemQAResultsSequence = Tag('Display Subsystem QA Results Sequence', "DisplaySubsystemQAResultsSequence", 0x0028, 0x7010)
    ConfigurationQAResultsSequence = Tag('Configuration QA Results Sequence', "ConfigurationQAResultsSequence", 0x0028, 0x7011)
    MeasurementEquipmentSequence = Tag('Measurement Equipment Sequence', "MeasurementEquipmentSequence", 0x0028, 0x7012)
    MeasurementFunctions = Tag('Measurement Functions', "MeasurementFunctions", 0x0028, 0x7013)
    MeasurementEquipmentType = Tag('Measurement Equipment Type', "MeasurementEquipmentType", 0x0028, 0x7014)
    VisualEvaluationResultSequence = Tag('Visual Evaluation Result Sequence', "VisualEvaluationResultSequence", 0x0028, 0x7015)
    DisplayCalibrationResultSequence = Tag('Display Calibration Result Sequence', "DisplayCalibrationResultSequence", 0x0028, 0x7016)
    DDLValue = Tag('DDL Value', "DDLValue", 0x0028, 0x7017)
    CIExyWhitePoint = Tag('CIExy White Point', "CIExyWhitePoint", 0x0028, 0x7018)
    DisplayFunctionType = Tag('Display Function Type', "DisplayFunctionType", 0x0028, 0x7019)
    GammaValue = Tag('Gamma Value', "GammaValue", 0x0028, 0x701A)
    NumberOfLuminancePoints = Tag('Number of Luminance Points', "NumberOfLuminancePoints", 0x0028, 0x701B)
    LuminanceResponseSequence = Tag('Luminance Response Sequence', "LuminanceResponseSequence", 0x0028, 0x701C)
    TargetMinimumLuminance = Tag('Target Minimum Luminance', "TargetMinimumLuminance", 0x0028, 0x701D)
    TargetMaximumLuminance = Tag('Target Maximum Luminance', "TargetMaximumLuminance", 0x0028, 0x701E)
    LuminanceValue = Tag('Luminance Value', "LuminanceValue", 0x0028, 0x701F)
    LuminanceResponseDescription = Tag('Luminance Response Description', "LuminanceResponseDescription", 0x0028, 0x7020)
    WhitePointFlag = Tag('White Point Flag', "WhitePointFlag", 0x0028, 0x7021)
    DisplayDeviceTypeCodeSequence = Tag('Display Device Type Code Sequence', "DisplayDeviceTypeCodeSequence", 0x0028, 0x7022)
    DisplaySubsystemSequence = Tag('Display Subsystem Sequence', "DisplaySubsystemSequence", 0x0028, 0x7023)
    LuminanceResultSequence = Tag('Luminance Result Sequence', "LuminanceResultSequence", 0x0028, 0x7024)
    AmbientLightValueSource = Tag('Ambient Light Value Source', "AmbientLightValueSource", 0x0028, 0x7025)
    MeasuredCharacteristics = Tag('Measured Characteristics', "MeasuredCharacteristics", 0x0028, 0x7026)
    LuminanceUniformityResultSequence = Tag('Luminance Uniformity Result Sequence', "LuminanceUniformityResultSequence", 0x0028, 0x7027)
    VisualEvaluationTestSequence = Tag('Visual Evaluation Test Sequence', "VisualEvaluationTestSequence", 0x0028, 0x7028)
    TestResult = Tag('Test Result', "TestResult", 0x0028, 0x7029)
    TestResultComment = Tag('Test Result Comment', "TestResultComment", 0x0028, 0x702A)
    TestImageValidation = Tag('Test Image Validation', "TestImageValidation", 0x0028, 0x702B)
    TestPatternCodeSequence = Tag('Test Pattern Code Sequence', "TestPatternCodeSequence", 0x0028, 0x702C)
    MeasurementPatternCodeSequence = Tag('Measurement Pattern Code Sequence', "MeasurementPatternCodeSequence", 0x0028, 0x702D)
    VisualEvaluationMethodCodeSequence = Tag('Visual Evaluation Method Code Sequence', "VisualEvaluationMethodCodeSequence", 0x0028, 0x702E)
    PixelDataProviderURL = Tag('Pixel Data Provider URL', "PixelDataProviderURL", 0x0028, 0x7FE0)
    DataPointRows = Tag('Data Point Rows', "DataPointRows", 0x0028, 0x9001)
    DataPointColumns = Tag('Data Point Columns', "DataPointColumns", 0x0028, 0x9002)
    SignalDomainColumns = Tag('Signal Domain Columns', "SignalDomainColumns", 0x0028, 0x9003)
    LargestMonochromePixelValue = Tag('Largest Monochrome Pixel Value', "LargestMonochromePixelValue", 0x0028, 0x9099)
    DataRepresentation = Tag('Data Representation', "DataRepresentation", 0x0028, 0x9108)
    SignalDomainRows = Tag('Signal Domain Rows', "SignalDomainRows", 0x0028, 0x9235)
    DisplayFilterPercentage = Tag('Display Filter Percentage', "DisplayFilterPercentage", 0x0028, 0x9411, [TagLink(FrameDisplaySequence),])
    SubtractionItemID = Tag('Subtraction Item ID', "SubtractionItemID", 0x0028, 0x9416, [TagLink(MaskSubtractionSequence),TagLink(FramePixelShiftSequence),])
    GeometricalProperties = Tag('Geometrical Properties', "GeometricalProperties", 0x0028, 0x9444, [TagLink(FramePixelDataPropertiesSequence),])
    GeometricMaximumDistortion = Tag('Geometric Maximum Distortion', "GeometricMaximumDistortion", 0x0028, 0x9445, [TagLink(FramePixelDataPropertiesSequence),])
    ImageProcessingApplied = Tag('Image Processing Applied', "ImageProcessingApplied", 0x0028, 0x9446, [TagLink(FramePixelDataPropertiesSequence),])
    MaskSelectionMode = Tag('Mask Selection Mode', "MaskSelectionMode", 0x0028, 0x9454, [TagLink(MaskSubtractionSequence),])
    LUTFunction = Tag('LUT Function', "LUTFunction", 0x0028, 0x9474, [TagLink(PixelIntensityRelationshipLUTSequence),])
    MaskVisibilityPercentage = Tag('Mask Visibility Percentage', "MaskVisibilityPercentage", 0x0028, 0x9478, [TagLink(FrameDisplaySequence),TagLink(ReconstructionProtocolElementSequence),])
    VerticesOfTheRegion = Tag('Vertices of the Region', "VerticesOfTheRegion", 0x0028, 0x9503, [TagLink(RegionPixelShiftSequence),])
    PixelShiftFrameRange = Tag('Pixel Shift Frame Range', "PixelShiftFrameRange", 0x0028, 0x9506, [TagLink(PixelShiftSequence),])
    LUTFrameRange = Tag('LUT Frame Range', "LUTFrameRange", 0x0028, 0x9507, [TagLink(PixelIntensityRelationshipLUTSequence),])
    ImageToEquipmentMappingMatrix = Tag('Image to Equipment Mapping Matrix', "ImageToEquipmentMappingMatrix", 0x0028, 0x9520, [TagLink(TreatmentPositionSequence),TagLink(RTPatientPositionSequence),TagLink(PatientToEquipmentRelationshipSequence),])
    EquipmentCoordinateSystemIdentification = Tag('Equipment Coordinate System Identification', "EquipmentCoordinateSystemIdentification", 0x0028, 0x9537)
    StudyStatusID = Tag('Study Status ID', "StudyStatusID", 0x0032, 0x000A)
    StudyPriorityID = Tag('Study Priority ID', "StudyPriorityID", 0x0032, 0x000C)
    StudyIDIssuer = Tag('Study ID Issuer', "StudyIDIssuer", 0x0032, 0x0012)
    StudyVerifiedDate = Tag('Study Verified Date', "StudyVerifiedDate", 0x0032, 0x0032)
    StudyVerifiedTime = Tag('Study Verified Time', "StudyVerifiedTime", 0x0032, 0x0033)
    StudyReadDate = Tag('Study Read Date', "StudyReadDate", 0x0032, 0x0034)
    StudyReadTime = Tag('Study Read Time', "StudyReadTime", 0x0032, 0x0035)
    ScheduledStudyStartDate = Tag('Scheduled Study Start Date', "ScheduledStudyStartDate", 0x0032, 0x1000)
    ScheduledStudyStartTime = Tag('Scheduled Study Start Time', "ScheduledStudyStartTime", 0x0032, 0x1001)
    ScheduledStudyStopDate = Tag('Scheduled Study Stop Date', "ScheduledStudyStopDate", 0x0032, 0x1010)
    ScheduledStudyStopTime = Tag('Scheduled Study Stop Time', "ScheduledStudyStopTime", 0x0032, 0x1011)
    ScheduledStudyLocation = Tag('Scheduled Study Location', "ScheduledStudyLocation", 0x0032, 0x1020)
    ScheduledStudyLocationAETitle = Tag('Scheduled Study Location AE Title', "ScheduledStudyLocationAETitle", 0x0032, 0x1021)
    ReasonForStudy = Tag('Reason for Study', "ReasonForStudy", 0x0032, 0x1030)
    RequestingPhysicianIdentificationSequence = Tag('Requesting Physician Identification Sequence', "RequestingPhysicianIdentificationSequence", 0x0032, 0x1031)
    RequestingPhysician = Tag('Requesting Physician', "RequestingPhysician", 0x0032, 0x1032)
    RequestingService = Tag('Requesting Service', "RequestingService", 0x0032, 0x1033)
    StudyArrivalDate = Tag('Study Arrival Date', "StudyArrivalDate", 0x0032, 0x1040)
    StudyArrivalTime = Tag('Study Arrival Time', "StudyArrivalTime", 0x0032, 0x1041)
    StudyCompletionDate = Tag('Study Completion Date', "StudyCompletionDate", 0x0032, 0x1050)
    StudyCompletionTime = Tag('Study Completion Time', "StudyCompletionTime", 0x0032, 0x1051)
    StudyComponentStatusID = Tag('Study Component Status ID', "StudyComponentStatusID", 0x0032, 0x1055)
    RequestedProcedureDescription = Tag('Requested Procedure Description', "RequestedProcedureDescription", 0x0032, 0x1060, [TagLink(RequestAttributesSequence),TagLink(ReferencedRequestSequence),])
    RequestedLateralityCodeSequence = Tag('Requested Laterality Code Sequence', "RequestedLateralityCodeSequence", 0x0032, 0x1065)
    ReasonForVisit = Tag('Reason for Visit', "ReasonForVisit", 0x0032, 0x1066)
    RequestedContrastAgent = Tag('Requested Contrast Agent', "RequestedContrastAgent", 0x0032, 0x1070)
    StudyComments = Tag('Study Comments', "StudyComments", 0x0032, 0x4000)
    RealTimeBulkDataFlowSequence = Tag('Real-Time Bulk Data Flow Sequence', "RealTimeBulkDataFlowSequence", 0x0034, 0x000A)
    FlowIdentifierSequence = Tag('Flow Identifier Sequence', "FlowIdentifierSequence", 0x0034, 0x0001, [TagLink(RealTimeBulkDataFlowSequence),])
    FlowIdentifier = Tag('Flow Identifier', "FlowIdentifier", 0x0034, 0x0002, [TagLink(FlowIdentifierSequence),])
    FlowTransferSyntaxUID = Tag('Flow Transfer Syntax UID', "FlowTransferSyntaxUID", 0x0034, 0x0003, [TagLink(FlowIdentifierSequence),])
    FlowRTPSamplingRate = Tag('Flow RTP Sampling Rate', "FlowRTPSamplingRate", 0x0034, 0x0004, [TagLink(FlowIdentifierSequence),])
    SourceIdentifier = Tag('Source Identifier', "SourceIdentifier", 0x0034, 0x0005, [TagLink(RealTimeBulkDataFlowSequence),])
    TimeOfFrameGroupSequence = Tag('Time of Frame Group Sequence', "TimeOfFrameGroupSequence", 0x0034, 0x000D, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    FrameOriginTimestamp = Tag('Frame Origin Timestamp', "FrameOriginTimestamp", 0x0034, 0x0007, [TagLink(TimeOfFrameGroupSequence),])
    IncludesImagingSubject = Tag('Includes Imaging Subject', "IncludesImagingSubject", 0x0034, 0x0008)
    FrameUsefulnessGroupSequence = Tag('Frame Usefulness Group Sequence', "FrameUsefulnessGroupSequence", 0x0034, 0x0009, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    CameraPositionGroupSequence = Tag('Camera Position Group Sequence', "CameraPositionGroupSequence", 0x0034, 0x000B, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    IncludesInformation = Tag('Includes Information', "IncludesInformation", 0x0034, 0x000C)
    ReferencedPatientAliasSequence = Tag('Referenced Patient Alias Sequence', "ReferencedPatientAliasSequence", 0x0038, 0x0004)
    VisitStatusID = Tag('Visit Status ID', "VisitStatusID", 0x0038, 0x0008)
    AdmissionID = Tag('Admission ID', "AdmissionID", 0x0038, 0x0010)
    IssuerOfAdmissionID = Tag('Issuer of Admission ID', "IssuerOfAdmissionID", 0x0038, 0x0011)
    IssuerOfAdmissionIDSequence = Tag('Issuer of Admission ID Sequence', "IssuerOfAdmissionIDSequence", 0x0038, 0x0014)
    RouteOfAdmissions = Tag('Route of Admissions', "RouteOfAdmissions", 0x0038, 0x0016)
    ScheduledAdmissionDate = Tag('Scheduled Admission Date', "ScheduledAdmissionDate", 0x0038, 0x001A)
    ScheduledAdmissionTime = Tag('Scheduled Admission Time', "ScheduledAdmissionTime", 0x0038, 0x001B)
    ScheduledDischargeDate = Tag('Scheduled Discharge Date', "ScheduledDischargeDate", 0x0038, 0x001C)
    ScheduledDischargeTime = Tag('Scheduled Discharge Time', "ScheduledDischargeTime", 0x0038, 0x001D)
    ScheduledPatientInstitutionResidence = Tag('Scheduled Patient Institution Residence', "ScheduledPatientInstitutionResidence", 0x0038, 0x001E)
    AdmittingDate = Tag('Admitting Date', "AdmittingDate", 0x0038, 0x0020)
    AdmittingTime = Tag('Admitting Time', "AdmittingTime", 0x0038, 0x0021)
    DischargeDate = Tag('Discharge Date', "DischargeDate", 0x0038, 0x0030)
    DischargeTime = Tag('Discharge Time', "DischargeTime", 0x0038, 0x0032)
    DischargeDiagnosisDescription = Tag('Discharge Diagnosis Description', "DischargeDiagnosisDescription", 0x0038, 0x0040)
    DischargeDiagnosisCodeSequence = Tag('Discharge Diagnosis Code Sequence', "DischargeDiagnosisCodeSequence", 0x0038, 0x0044)
    SpecialNeeds = Tag('Special Needs', "SpecialNeeds", 0x0038, 0x0050)
    ServiceEpisodeID = Tag('Service Episode ID', "ServiceEpisodeID", 0x0038, 0x0060)
    IssuerOfServiceEpisodeID = Tag('Issuer of Service Episode ID', "IssuerOfServiceEpisodeID", 0x0038, 0x0061)
    ServiceEpisodeDescription = Tag('Service Episode Description', "ServiceEpisodeDescription", 0x0038, 0x0062)
    IssuerOfServiceEpisodeIDSequence = Tag('Issuer of Service Episode ID Sequence', "IssuerOfServiceEpisodeIDSequence", 0x0038, 0x0064)
    PertinentResourcesSequence = Tag('Pertinent Resources Sequence', "PertinentResourcesSequence", 0x0038, 0x0101)
    ResourceDescription = Tag('Resource Description', "ResourceDescription", 0x0038, 0x0102, [TagLink(PertinentResourcesSequence),])
    CurrentPatientLocation = Tag('Current Patient Location', "CurrentPatientLocation", 0x0038, 0x0300)
    PatientInstitutionResidence = Tag("Patient's Institution Residence", "PatientInstitutionResidence", 0x0038, 0x0400)
    PatientState = Tag('Patient State', "PatientState", 0x0038, 0x0500)
    PatientClinicalTrialParticipationSequence = Tag('Patient Clinical Trial Participation Sequence', "PatientClinicalTrialParticipationSequence", 0x0038, 0x0502)
    VisitComments = Tag('Visit Comments', "VisitComments", 0x0038, 0x4000)
    WaveformOriginality = Tag('Waveform Originality', "WaveformOriginality", 0x003A, 0x0004, [TagLink(WaveformSequence),])
    NumberOfWaveformChannels = Tag('Number of Waveform Channels', "NumberOfWaveformChannels", 0x003A, 0x0005, [TagLink(WaveformSequence),])
    NumberOfWaveformSamples = Tag('Number of Waveform Samples', "NumberOfWaveformSamples", 0x003A, 0x0010, [TagLink(WaveformSequence),])
    SamplingFrequency = Tag('Sampling Frequency', "SamplingFrequency", 0x003A, 0x001A, [TagLink(WaveformSequence),])
    MultiplexGroupLabel = Tag('Multiplex Group Label', "MultiplexGroupLabel", 0x003A, 0x0020, [TagLink(WaveformSequence),])
    WaveformChannelNumber = Tag('Waveform Channel Number', "WaveformChannelNumber", 0x003A, 0x0202, [TagLink(ChannelDefinitionSequence),])
    ChannelLabel = Tag('Channel Label', "ChannelLabel", 0x003A, 0x0203, [TagLink(ChannelDefinitionSequence),])
    ChannelStatus = Tag('Channel Status', "ChannelStatus", 0x003A, 0x0205, [TagLink(ChannelDefinitionSequence),])
    ChannelDerivationDescription = Tag('Channel Derivation Description', "ChannelDerivationDescription", 0x003A, 0x020C, [TagLink(ChannelDefinitionSequence),])
    ChannelSensitivity = Tag('Channel Sensitivity', "ChannelSensitivity", 0x003A, 0x0210, [TagLink(ChannelDefinitionSequence),])
    ChannelSensitivityCorrectionFactor = Tag('Channel Sensitivity Correction Factor', "ChannelSensitivityCorrectionFactor", 0x003A, 0x0212, [TagLink(ChannelDefinitionSequence),])
    ChannelBaseline = Tag('Channel Baseline', "ChannelBaseline", 0x003A, 0x0213, [TagLink(ChannelDefinitionSequence),])
    ChannelTimeSkew = Tag('Channel Time Skew', "ChannelTimeSkew", 0x003A, 0x0214, [TagLink(ChannelDefinitionSequence),])
    ChannelSampleSkew = Tag('Channel Sample Skew', "ChannelSampleSkew", 0x003A, 0x0215, [TagLink(ChannelDefinitionSequence),])
    WaveformMontageSequence = Tag('Waveform Montage Sequence', "WaveformMontageSequence", 0x0040, 0xB039)
    WaveformPresentationGroupSequence = Tag('Waveform Presentation Group Sequence', "WaveformPresentationGroupSequence", 0x003A, 0x0240, [TagLink(WaveformMontageSequence),])
    ChannelDisplaySequence = Tag('Channel Display Sequence', "ChannelDisplaySequence", 0x003A, 0x0242, [TagLink(WaveformPresentationGroupSequence),])
    ChannelOffset = Tag('Channel Offset', "ChannelOffset", 0x003A, 0x0218, [TagLink(ChannelDefinitionSequence),TagLink(ChannelDisplaySequence),])
    WaveformBitsStored = Tag('Waveform Bits Stored', "WaveformBitsStored", 0x003A, 0x021A, [TagLink(ChannelDefinitionSequence),])
    FilterLowFrequency = Tag('Filter Low Frequency', "FilterLowFrequency", 0x003A, 0x0220, [TagLink(ChannelDefinitionSequence),TagLink(FilterLowFrequencyCharacteristicsSequence),TagLink(FilterHighFrequencyCharacteristicsSequence),TagLink(NotchFilterCharacteristicsSequence),])
    FilterHighFrequency = Tag('Filter High Frequency', "FilterHighFrequency", 0x003A, 0x0221, [TagLink(ChannelDefinitionSequence),TagLink(FilterLowFrequencyCharacteristicsSequence),TagLink(FilterHighFrequencyCharacteristicsSequence),TagLink(NotchFilterCharacteristicsSequence),])
    NotchFilterFrequency = Tag('Notch Filter Frequency', "NotchFilterFrequency", 0x003A, 0x0222, [TagLink(ChannelDefinitionSequence),TagLink(FilterLowFrequencyCharacteristicsSequence),TagLink(FilterHighFrequencyCharacteristicsSequence),TagLink(NotchFilterCharacteristicsSequence),])
    NotchFilterBandwidth = Tag('Notch Filter Bandwidth', "NotchFilterBandwidth", 0x003A, 0x0223, [TagLink(ChannelDefinitionSequence),TagLink(FilterLowFrequencyCharacteristicsSequence),TagLink(FilterHighFrequencyCharacteristicsSequence),TagLink(NotchFilterCharacteristicsSequence),])
    WaveformDataDisplayScale = Tag('Waveform Data Display Scale', "WaveformDataDisplayScale", 0x003A, 0x0230, [TagLink(WaveformMontageSequence),])
    WaveformDisplayBackgroundCIELabValue = Tag('Waveform Display Background CIELab Value', "WaveformDisplayBackgroundCIELabValue", 0x003A, 0x0231, [TagLink(DisplayedWaveformSegmentSequence),TagLink(WaveformMontageSequence),])
    PresentationGroupNumber = Tag('Presentation Group Number', "PresentationGroupNumber", 0x003A, 0x0241, [TagLink(WaveformPresentationGroupSequence),])
    ChannelRecommendedDisplayCIELabValue = Tag('Channel Recommended Display CIELab Value', "ChannelRecommendedDisplayCIELabValue", 0x003A, 0x0244, [TagLink(ChannelDisplaySequence),TagLink(DisplayedWaveformSegmentSequence),])
    ChannelPosition = Tag('Channel Position', "ChannelPosition", 0x003A, 0x0245, [TagLink(ChannelDisplaySequence),])
    DisplayShadingFlag = Tag('Display Shading Flag', "DisplayShadingFlag", 0x003A, 0x0246, [TagLink(ChannelDisplaySequence),])
    FractionalChannelDisplayScale = Tag('Fractional Channel Display Scale', "FractionalChannelDisplayScale", 0x003A, 0x0247, [TagLink(ChannelDisplaySequence),])
    AbsoluteChannelDisplayScale = Tag('Absolute Channel Display Scale', "AbsoluteChannelDisplayScale", 0x003A, 0x0248, [TagLink(ChannelDisplaySequence),])
    ChannelIdentificationCode = Tag('Channel Identification Code', "ChannelIdentificationCode", 0x003A, 0x0301, [TagLink(MultiplexedAudioChannelsDescriptionCodeSequence),])
    ChannelMode = Tag('Channel Mode', "ChannelMode", 0x003A, 0x0302, [TagLink(MultiplexedAudioChannelsDescriptionCodeSequence),])
    MultiplexGroupUID = Tag('Multiplex Group UID', "MultiplexGroupUID", 0x003A, 0x0310, [TagLink(WaveformSequence),])
    PowerlineFrequency = Tag('Powerline Frequency', "PowerlineFrequency", 0x003A, 0x0311, [TagLink(WaveformSequence),])
    ChannelImpedanceSequence = Tag('Channel Impedance Sequence', "ChannelImpedanceSequence", 0x003A, 0x0312, [TagLink(ChannelDefinitionSequence),])
    ImpedanceValue = Tag('Impedance Value', "ImpedanceValue", 0x003A, 0x0313, [TagLink(ChannelImpedanceSequence),])
    ImpedanceMeasurementDateTime = Tag('Impedance Measurement DateTime', "ImpedanceMeasurementDateTime", 0x003A, 0x0314, [TagLink(ChannelImpedanceSequence),])
    ImpedanceMeasurementFrequency = Tag('Impedance Measurement Frequency', "ImpedanceMeasurementFrequency", 0x003A, 0x0315, [TagLink(ChannelImpedanceSequence),])
    ImpedanceMeasurementCurrentType = Tag('Impedance Measurement Current Type', "ImpedanceMeasurementCurrentType", 0x003A, 0x0316, [TagLink(ChannelImpedanceSequence),])
    WaveformAmplifierType = Tag('Waveform Amplifier Type', "WaveformAmplifierType", 0x003A, 0x0317, [TagLink(ChannelDefinitionSequence),])
    SummarizedFilterLookupTableSequence = Tag('Summarized Filter Lookup Table Sequence', "SummarizedFilterLookupTableSequence", 0x003A, 0x0320, [TagLink(ChannelDefinitionSequence),])
    WaveformFilterType = Tag('Waveform Filter Type', "WaveformFilterType", 0x003A, 0x0322, [TagLink(FilterLowFrequencyCharacteristicsSequence),TagLink(FilterHighFrequencyCharacteristicsSequence),TagLink(NotchFilterCharacteristicsSequence),])
    AnalogFilterRollOff = Tag('Analog Filter Roll Off', "AnalogFilterRollOff", 0x003A, 0x0324, [TagLink(AnalogFilterCharacteristicsSequence),])
    DigitalFilterOrder = Tag('Digital Filter Order', "DigitalFilterOrder", 0x003A, 0x0327, [TagLink(DigitalFilterCharacteristicsSequence),])
    WaveformFilterDescription = Tag('Waveform Filter Description', "WaveformFilterDescription", 0x003A, 0x0329, [TagLink(FilterLowFrequencyCharacteristicsSequence),TagLink(FilterHighFrequencyCharacteristicsSequence),TagLink(NotchFilterCharacteristicsSequence),])
    FilterLookupTableSequence = Tag('Filter Lookup Table Sequence', "FilterLookupTableSequence", 0x003A, 0x032A, [TagLink(FilterLowFrequencyCharacteristicsSequence),TagLink(FilterHighFrequencyCharacteristicsSequence),TagLink(NotchFilterCharacteristicsSequence),])
    FilterLookupTableDescription = Tag('Filter Lookup Table Description', "FilterLookupTableDescription", 0x003A, 0x032B)
    FilterLookupTableData = Tag('Filter Lookup Table Data', "FilterLookupTableData", 0x003A, 0x032E)
    ScheduledStationAETitle = Tag('Scheduled Station AE Title', "ScheduledStationAETitle", 0x0040, 0x0001)
    ScheduledProcedureStepStartDate = Tag('Scheduled Procedure Step Start Date', "ScheduledProcedureStepStartDate", 0x0040, 0x0002)
    ScheduledProcedureStepStartTime = Tag('Scheduled Procedure Step Start Time', "ScheduledProcedureStepStartTime", 0x0040, 0x0003)
    ScheduledProcedureStepEndDate = Tag('Scheduled Procedure Step End Date', "ScheduledProcedureStepEndDate", 0x0040, 0x0004)
    ScheduledProcedureStepEndTime = Tag('Scheduled Procedure Step End Time', "ScheduledProcedureStepEndTime", 0x0040, 0x0005)
    ScheduledPerformingPhysicianName = Tag("Scheduled Performing Physician's Name", "ScheduledPerformingPhysicianName", 0x0040, 0x0006)
    ScheduledProcedureStepDescription = Tag('Scheduled Procedure Step Description', "ScheduledProcedureStepDescription", 0x0040, 0x0007, [TagLink(RequestAttributesSequence),])
    ScheduledProcedureStepID = Tag('Scheduled Procedure Step ID', "ScheduledProcedureStepID", 0x0040, 0x0009, [TagLink(RequestAttributesSequence),])
    ScheduledPerformingPhysicianIdentificationSequence = Tag('Scheduled Performing Physician Identification Sequence', "ScheduledPerformingPhysicianIdentificationSequence", 0x0040, 0x000B)
    ScheduledStationName = Tag('Scheduled Station Name', "ScheduledStationName", 0x0040, 0x0010)
    ScheduledProcedureStepLocation = Tag('Scheduled Procedure Step Location', "ScheduledProcedureStepLocation", 0x0040, 0x0011)
    PreMedication = Tag('Pre-Medication', "PreMedication", 0x0040, 0x0012)
    ScheduledProcedureStepStatus = Tag('Scheduled Procedure Step Status', "ScheduledProcedureStepStatus", 0x0040, 0x0020)
    OrderPlacerIdentifierSequence = Tag('Order Placer Identifier Sequence', "OrderPlacerIdentifierSequence", 0x0040, 0x0026, [TagLink(ReferencedRequestSequence),])
    OrderFillerIdentifierSequence = Tag('Order Filler Identifier Sequence', "OrderFillerIdentifierSequence", 0x0040, 0x0027, [TagLink(ReferencedRequestSequence),])
    AssigningFacilitySequence = Tag('Assigning Facility Sequence', "AssigningFacilitySequence", 0x0040, 0x0036, [TagLink(IssuerOfPatientIDQualifiersSequence),])
    AlternateContainerIdentifierSequence = Tag('Alternate Container Identifier Sequence', "AlternateContainerIdentifierSequence", 0x0040, 0x0515)
    IssuerOfTheContainerIdentifierSequence = Tag('Issuer of the Container Identifier Sequence', "IssuerOfTheContainerIdentifierSequence", 0x0040, 0x0513, [TagLink(AlternateContainerIdentifierSequence),])
    IssuerOfTheSpecimenIdentifierSequence = Tag('Issuer of the Specimen Identifier Sequence', "IssuerOfTheSpecimenIdentifierSequence", 0x0040, 0x0562, [TagLink(SpecimenDescriptionSequence),])
    LocalNamespaceEntityID = Tag('Local Namespace Entity ID', "LocalNamespaceEntityID", 0x0040, 0x0031, [TagLink(AssigningFacilitySequence),TagLink(IssuerOfAccessionNumberSequence),TagLink(IssuerOfAdmissionIDSequence),TagLink(IssuerOfServiceEpisodeIDSequence),TagLink(IssuerOfTheContainerIdentifierSequence),TagLink(IssuerOfTheSpecimenIdentifierSequence),TagLink(OrderPlacerIdentifierSequence),TagLink(OrderFillerIdentifierSequence),])
    UniversalEntityID = Tag('Universal Entity ID', "UniversalEntityID", 0x0040, 0x0032, [TagLink(IssuerOfPatientIDQualifiersSequence),TagLink(AssigningFacilitySequence),TagLink(IssuerOfAccessionNumberSequence),TagLink(IssuerOfAdmissionIDSequence),TagLink(IssuerOfServiceEpisodeIDSequence),TagLink(IssuerOfTheContainerIdentifierSequence),TagLink(IssuerOfTheSpecimenIdentifierSequence),TagLink(OrderPlacerIdentifierSequence),TagLink(OrderFillerIdentifierSequence),])
    UniversalEntityIDType = Tag('Universal Entity ID Type', "UniversalEntityIDType", 0x0040, 0x0033, [TagLink(IssuerOfPatientIDQualifiersSequence),TagLink(AssigningFacilitySequence),TagLink(IssuerOfAccessionNumberSequence),TagLink(IssuerOfAdmissionIDSequence),TagLink(IssuerOfServiceEpisodeIDSequence),TagLink(IssuerOfTheContainerIdentifierSequence),TagLink(IssuerOfTheSpecimenIdentifierSequence),TagLink(OrderPlacerIdentifierSequence),TagLink(OrderFillerIdentifierSequence),])
    IdentifierTypeCode = Tag('Identifier Type Code', "IdentifierTypeCode", 0x0040, 0x0035, [TagLink(IssuerOfPatientIDQualifiersSequence),])
    ScheduledProcedureStepSequence = Tag('Scheduled Procedure Step Sequence', "ScheduledProcedureStepSequence", 0x0040, 0x0100)
    ReferencedNonImageCompositeSOPInstanceSequence = Tag('Referenced Non-Image Composite SOP Instance Sequence', "ReferencedNonImageCompositeSOPInstanceSequence", 0x0040, 0x0220)
    PerformedStationAETitle = Tag('Performed Station AE Title', "PerformedStationAETitle", 0x0040, 0x0241)
    PerformedStationName = Tag('Performed Station Name', "PerformedStationName", 0x0040, 0x0242)
    PerformedLocation = Tag('Performed Location', "PerformedLocation", 0x0040, 0x0243)
    PerformedProcedureStepStartDate = Tag('Performed Procedure Step Start Date', "PerformedProcedureStepStartDate", 0x0040, 0x0244)
    PerformedProcedureStepStartTime = Tag('Performed Procedure Step Start Time', "PerformedProcedureStepStartTime", 0x0040, 0x0245)
    PerformedProcedureStepEndDate = Tag('Performed Procedure Step End Date', "PerformedProcedureStepEndDate", 0x0040, 0x0250)
    PerformedProcedureStepEndTime = Tag('Performed Procedure Step End Time', "PerformedProcedureStepEndTime", 0x0040, 0x0251)
    PerformedProcedureStepStatus = Tag('Performed Procedure Step Status', "PerformedProcedureStepStatus", 0x0040, 0x0252)
    PerformedProcedureStepID = Tag('Performed Procedure Step ID', "PerformedProcedureStepID", 0x0040, 0x0253)
    PerformedProcedureStepDescription = Tag('Performed Procedure Step Description', "PerformedProcedureStepDescription", 0x0040, 0x0254)
    PerformedProcedureTypeDescription = Tag('Performed Procedure Type Description', "PerformedProcedureTypeDescription", 0x0040, 0x0255)
    PerformedProtocolType = Tag('Performed Protocol Type', "PerformedProtocolType", 0x0040, 0x0261)
    ScheduledStepAttributesSequence = Tag('Scheduled Step Attributes Sequence', "ScheduledStepAttributesSequence", 0x0040, 0x0270)
    CommentsOnThePerformedProcedureStep = Tag('Comments on the Performed Procedure Step', "CommentsOnThePerformedProcedureStep", 0x0040, 0x0280)
    PerformedProcedureStepDiscontinuationReasonCodeSequence = Tag('Performed Procedure Step Discontinuation Reason Code Sequence', "PerformedProcedureStepDiscontinuationReasonCodeSequence", 0x0040, 0x0281)
    QuantitySequence = Tag('Quantity Sequence', "QuantitySequence", 0x0040, 0x0293)
    Quantity = Tag('Quantity', "Quantity", 0x0040, 0x0294)
    MeasuringUnitsSequence = Tag('Measuring Units Sequence', "MeasuringUnitsSequence", 0x0040, 0x0295)
    BillingItemSequence = Tag('Billing Item Sequence', "BillingItemSequence", 0x0040, 0x0296)
    TotalTimeOfFluoroscopy = Tag('Total Time of Fluoroscopy', "TotalTimeOfFluoroscopy", 0x0040, 0x0300)
    TotalNumberOfExposures = Tag('Total Number of Exposures', "TotalNumberOfExposures", 0x0040, 0x0301)
    EntranceDose = Tag('Entrance Dose', "EntranceDose", 0x0040, 0x0302)
    ExposedArea = Tag('Exposed Area', "ExposedArea", 0x0040, 0x0303)
    DistanceSourceToEntrance = Tag('Distance Source to Entrance', "DistanceSourceToEntrance", 0x0040, 0x0306, [TagLink(XRayGeometrySequence),])
    DistanceSourceToSupport = Tag('Distance Source to Support', "DistanceSourceToSupport", 0x0040, 0x0307)
    ExposureDoseSequence = Tag('Exposure Dose Sequence', "ExposureDoseSequence", 0x0040, 0x030E)
    CommentsOnRadiationDose = Tag('Comments on Radiation Dose', "CommentsOnRadiationDose", 0x0040, 0x0310)
    XRayOutput = Tag('X-Ray Output', "XRayOutput", 0x0040, 0x0312)
    HalfValueLayer = Tag('Half Value Layer', "HalfValueLayer", 0x0040, 0x0314, [TagLink(XRay3DAcquisitionSequence),TagLink(XRayAcquisitionDoseSequence),])
    OrganDose = Tag('Organ Dose', "OrganDose", 0x0040, 0x0316, [TagLink(XRay3DAcquisitionSequence),TagLink(PerProjectionAcquisitionSequence),TagLink(XRayAcquisitionDoseSequence),])
    OrganExposed = Tag('Organ Exposed', "OrganExposed", 0x0040, 0x0318)
    BillingProcedureStepSequence = Tag('Billing Procedure Step Sequence', "BillingProcedureStepSequence", 0x0040, 0x0320)
    FilmConsumptionSequence = Tag('Film Consumption Sequence', "FilmConsumptionSequence", 0x0040, 0x0321)
    BillingSuppliesAndDevicesSequence = Tag('Billing Supplies and Devices Sequence', "BillingSuppliesAndDevicesSequence", 0x0040, 0x0324)
    ReferencedProcedureStepSequence = Tag('Referenced Procedure Step Sequence', "ReferencedProcedureStepSequence", 0x0040, 0x0330)
    PerformedSeriesSequence = Tag('Performed Series Sequence', "PerformedSeriesSequence", 0x0040, 0x0340)
    CommentsOnTheScheduledProcedureStep = Tag('Comments on the Scheduled Procedure Step', "CommentsOnTheScheduledProcedureStep", 0x0040, 0x0400)
    ScheduledSpecimenSequence = Tag('Scheduled Specimen Sequence', "ScheduledSpecimenSequence", 0x0040, 0x0500)
    SpecimenAccessionNumber = Tag('Specimen Accession Number', "SpecimenAccessionNumber", 0x0040, 0x050A)
    ContainerIdentifier = Tag('Container Identifier', "ContainerIdentifier", 0x0040, 0x0512, [TagLink(AlternateContainerIdentifierSequence),TagLink(InventoriedInstancesSequence),])
    ContainerDescription = Tag('Container Description', "ContainerDescription", 0x0040, 0x051A)
    SpecimenSequence = Tag('Specimen Sequence', "SpecimenSequence", 0x0040, 0x0550)
    SpecimenIdentifier = Tag('Specimen Identifier', "SpecimenIdentifier", 0x0040, 0x0551, [TagLink(SpecimenDescriptionSequence),])
    SpecimenDescriptionSequenceTrial = Tag('Specimen Description Sequence (Trial)', "SpecimenDescriptionSequenceTrial", 0x0040, 0x0552)
    SpecimenDescriptionTrial = Tag('Specimen Description (Trial)', "SpecimenDescriptionTrial", 0x0040, 0x0553)
    SpecimenReferenceSequence = Tag('Specimen Reference Sequence', "SpecimenReferenceSequence", 0x0048, 0x0110, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    SpecimenUID = Tag('Specimen UID', "SpecimenUID", 0x0040, 0x0554, [TagLink(SpecimenDescriptionSequence),TagLink(SpecimenReferenceSequence),])
    AcquisitionContextDescription = Tag('Acquisition Context Description', "AcquisitionContextDescription", 0x0040, 0x0556)
    SpecimenShortDescription = Tag('Specimen Short Description', "SpecimenShortDescription", 0x0040, 0x0600, [TagLink(SpecimenDescriptionSequence),])
    SpecimenDetailedDescription = Tag('Specimen Detailed Description', "SpecimenDetailedDescription", 0x0040, 0x0602, [TagLink(SpecimenDescriptionSequence),])
    SlideIdentifier = Tag('Slide Identifier', "SlideIdentifier", 0x0040, 0x06FA)
    ImageCenterPointCoordinatesSequence = Tag('Image Center Point Coordinates Sequence', "ImageCenterPointCoordinatesSequence", 0x0040, 0x071A)
    PlanePositionSlideSequence = Tag('Plane Position (Slide) Sequence', "PlanePositionSlideSequence", 0x0048, 0x021A, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    TotalPixelMatrixOriginSequence = Tag('Total Pixel Matrix Origin Sequence', "TotalPixelMatrixOriginSequence", 0x0048, 0x0008)
    XOffsetInSlideCoordinateSystem = Tag('X Offset in Slide Coordinate System', "XOffsetInSlideCoordinateSystem", 0x0040, 0x072A, [TagLink(ImageCenterPointCoordinatesSequence),TagLink(PlanePositionSlideSequence),TagLink(TotalPixelMatrixOriginSequence),])
    YOffsetInSlideCoordinateSystem = Tag('Y Offset in Slide Coordinate System', "YOffsetInSlideCoordinateSystem", 0x0040, 0x073A, [TagLink(ImageCenterPointCoordinatesSequence),TagLink(PlanePositionSlideSequence),TagLink(TotalPixelMatrixOriginSequence),])
    ZOffsetInSlideCoordinateSystem = Tag('Z Offset in Slide Coordinate System', "ZOffsetInSlideCoordinateSystem", 0x0040, 0x074A, [TagLink(ImageCenterPointCoordinatesSequence),TagLink(PlanePositionSlideSequence),TagLink(TotalPixelMatrixOriginSequence),])
    PixelSpacingSequence = Tag('Pixel Spacing Sequence', "PixelSpacingSequence", 0x0040, 0x08D8)
    CoordinateSystemAxisCodeSequence = Tag('Coordinate System Axis Code Sequence', "CoordinateSystemAxisCodeSequence", 0x0040, 0x08DA)
    VitalStainCodeSequenceTrial = Tag('Vital Stain Code Sequence (Trial)', "VitalStainCodeSequenceTrial", 0x0040, 0x09F8)
    RequestedProcedureID = Tag('Requested Procedure ID', "RequestedProcedureID", 0x0040, 0x1001, [TagLink(RequestAttributesSequence),TagLink(ReferencedRequestSequence),])
    ReasonForTheRequestedProcedure = Tag('Reason for the Requested Procedure', "ReasonForTheRequestedProcedure", 0x0040, 0x1002, [TagLink(RequestAttributesSequence),TagLink(ReferencedRequestSequence),])
    RequestedProcedurePriority = Tag('Requested Procedure Priority', "RequestedProcedurePriority", 0x0040, 0x1003)
    PatientTransportArrangements = Tag('Patient Transport Arrangements', "PatientTransportArrangements", 0x0040, 0x1004)
    RequestedProcedureLocation = Tag('Requested Procedure Location', "RequestedProcedureLocation", 0x0040, 0x1005)
    PlacerOrderNumberProcedure = Tag('Placer Order Number / Procedure', "PlacerOrderNumberProcedure", 0x0040, 0x1006)
    FillerOrderNumberProcedure = Tag('Filler Order Number / Procedure', "FillerOrderNumberProcedure", 0x0040, 0x1007)
    ConfidentialityCode = Tag('Confidentiality Code', "ConfidentialityCode", 0x0040, 0x1008)
    ReportingPriority = Tag('Reporting Priority', "ReportingPriority", 0x0040, 0x1009)
    NamesOfIntendedRecipientsOfResults = Tag('Names of Intended Recipients of Results', "NamesOfIntendedRecipientsOfResults", 0x0040, 0x1010)
    IntendedRecipientsOfResultsIdentificationSequence = Tag('Intended Recipients of Results Identification Sequence', "IntendedRecipientsOfResultsIdentificationSequence", 0x0040, 0x1011)
    RequestedProcedureDescriptionTrial = Tag('Requested Procedure Description (Trial)', "RequestedProcedureDescriptionTrial", 0x0040, 0x1060)
    PersonAddress = Tag("Person's Address", "PersonAddress", 0x0040, 0x1102, [TagLink(ContentCreatorIdentificationCodeSequence),TagLink(OperatorIdentificationSequence),TagLink(ReferringPhysicianIdentificationSequence),TagLink(ConsultingPhysicianIdentificationSequence),TagLink(PhysiciansOfRecordIdentificationSequence),TagLink(PhysiciansReadingStudyIdentificationSequence),TagLink(PerformingPhysicianIdentificationSequence),TagLink(InterlockResolutionUserSequence),])
    PersonTelephoneNumbers = Tag("Person's Telephone Numbers", "PersonTelephoneNumbers", 0x0040, 0x1103, [TagLink(ContentCreatorIdentificationCodeSequence),TagLink(OperatorIdentificationSequence),TagLink(ReferringPhysicianIdentificationSequence),TagLink(ConsultingPhysicianIdentificationSequence),TagLink(PhysiciansOfRecordIdentificationSequence),TagLink(PhysiciansReadingStudyIdentificationSequence),TagLink(PerformingPhysicianIdentificationSequence),TagLink(InterlockResolutionUserSequence),])
    PersonTelecomInformation = Tag("Person's Telecom Information", "PersonTelecomInformation", 0x0040, 0x1104, [TagLink(ContentCreatorIdentificationCodeSequence),TagLink(OperatorIdentificationSequence),TagLink(ReferringPhysicianIdentificationSequence),TagLink(ConsultingPhysicianIdentificationSequence),TagLink(PhysiciansOfRecordIdentificationSequence),TagLink(PhysiciansReadingStudyIdentificationSequence),TagLink(PerformingPhysicianIdentificationSequence),TagLink(InterlockResolutionUserSequence),])
    RequestedProcedureComments = Tag('Requested Procedure Comments', "RequestedProcedureComments", 0x0040, 0x1400)
    ReasonForTheImagingServiceRequest = Tag('Reason for the Imaging Service Request', "ReasonForTheImagingServiceRequest", 0x0040, 0x2001)
    IssueDateOfImagingServiceRequest = Tag('Issue Date of Imaging Service Request', "IssueDateOfImagingServiceRequest", 0x0040, 0x2004)
    IssueTimeOfImagingServiceRequest = Tag('Issue Time of Imaging Service Request', "IssueTimeOfImagingServiceRequest", 0x0040, 0x2005)
    PlacerOrderNumberImagingServiceRequestRetired = Tag('Placer Order Number / Imaging Service Request (Retired)', "PlacerOrderNumberImagingServiceRequestRetired", 0x0040, 0x2006)
    FillerOrderNumberImagingServiceRequestRetired = Tag('Filler Order Number / Imaging Service Request (Retired)', "FillerOrderNumberImagingServiceRequestRetired", 0x0040, 0x2007)
    OrderEnteredBy = Tag('Order Entered By', "OrderEnteredBy", 0x0040, 0x2008)
    OrderEntererLocation = Tag("Order Enterer's Location", "OrderEntererLocation", 0x0040, 0x2009)
    OrderCallbackPhoneNumber = Tag('Order Callback Phone Number', "OrderCallbackPhoneNumber", 0x0040, 0x2010)
    OrderCallbackTelecomInformation = Tag('Order Callback Telecom Information', "OrderCallbackTelecomInformation", 0x0040, 0x2011)
    PlacerOrderNumberImagingServiceRequest = Tag('Placer Order Number / Imaging Service Request', "PlacerOrderNumberImagingServiceRequest", 0x0040, 0x2016, [TagLink(ReferencedRequestSequence),])
    FillerOrderNumberImagingServiceRequest = Tag('Filler Order Number / Imaging Service Request', "FillerOrderNumberImagingServiceRequest", 0x0040, 0x2017, [TagLink(ReferencedRequestSequence),])
    ImagingServiceRequestComments = Tag('Imaging Service Request Comments', "ImagingServiceRequestComments", 0x0040, 0x2400)
    ConfidentialityConstraintOnPatientDataDescription = Tag('Confidentiality Constraint on Patient Data Description', "ConfidentialityConstraintOnPatientDataDescription", 0x0040, 0x3001)
    GeneralPurposeScheduledProcedureStepStatus = Tag('General Purpose Scheduled Procedure Step Status', "GeneralPurposeScheduledProcedureStepStatus", 0x0040, 0x4001)
    GeneralPurposePerformedProcedureStepStatus = Tag('General Purpose Performed Procedure Step Status', "GeneralPurposePerformedProcedureStepStatus", 0x0040, 0x4002)
    GeneralPurposeScheduledProcedureStepPriority = Tag('General Purpose Scheduled Procedure Step Priority', "GeneralPurposeScheduledProcedureStepPriority", 0x0040, 0x4003)
    ScheduledProcessingApplicationsCodeSequence = Tag('Scheduled Processing Applications Code Sequence', "ScheduledProcessingApplicationsCodeSequence", 0x0040, 0x4004)
    ScheduledProcedureStepStartDateTime = Tag('Scheduled Procedure Step Start DateTime', "ScheduledProcedureStepStartDateTime", 0x0040, 0x4005)
    MultipleCopiesFlag = Tag('Multiple Copies Flag', "MultipleCopiesFlag", 0x0040, 0x4006)
    PerformedProcessingApplicationsCodeSequence = Tag('Performed Processing Applications Code Sequence', "PerformedProcessingApplicationsCodeSequence", 0x0040, 0x4007)
    ScheduledProcedureStepExpirationDateTime = Tag('Scheduled Procedure Step Expiration DateTime', "ScheduledProcedureStepExpirationDateTime", 0x0040, 0x4008)
    HumanPerformerCodeSequence = Tag('Human Performer Code Sequence', "HumanPerformerCodeSequence", 0x0040, 0x4009)
    ScheduledProcedureStepModificationDateTime = Tag('Scheduled Procedure Step Modification DateTime', "ScheduledProcedureStepModificationDateTime", 0x0040, 0x4010)
    ExpectedCompletionDateTime = Tag('Expected Completion DateTime', "ExpectedCompletionDateTime", 0x0040, 0x4011)
    ResultingGeneralPurposePerformedProcedureStepsSequence = Tag('Resulting General Purpose Performed Procedure Steps Sequence', "ResultingGeneralPurposePerformedProcedureStepsSequence", 0x0040, 0x4015)
    ReferencedGeneralPurposeScheduledProcedureStepSequence = Tag('Referenced General Purpose Scheduled Procedure Step Sequence', "ReferencedGeneralPurposeScheduledProcedureStepSequence", 0x0040, 0x4016)
    ScheduledWorkitemCodeSequence = Tag('Scheduled Workitem Code Sequence', "ScheduledWorkitemCodeSequence", 0x0040, 0x4018)
    PerformedWorkitemCodeSequence = Tag('Performed Workitem Code Sequence', "PerformedWorkitemCodeSequence", 0x0040, 0x4019)
    InputAvailabilityFlag = Tag('Input Availability Flag', "InputAvailabilityFlag", 0x0040, 0x4020)
    InputInformationSequence = Tag('Input Information Sequence', "InputInformationSequence", 0x0040, 0x4021)
    RelevantInformationSequence = Tag('Relevant Information Sequence', "RelevantInformationSequence", 0x0040, 0x4022)
    ReferencedGeneralPurposeScheduledProcedureStepTransactionUID = Tag('Referenced General Purpose Scheduled Procedure Step Transaction UID', "ReferencedGeneralPurposeScheduledProcedureStepTransactionUID", 0x0040, 0x4023)
    ScheduledStationNameCodeSequence = Tag('Scheduled Station Name Code Sequence', "ScheduledStationNameCodeSequence", 0x0040, 0x4025)
    ScheduledStationClassCodeSequence = Tag('Scheduled Station Class Code Sequence', "ScheduledStationClassCodeSequence", 0x0040, 0x4026)
    ScheduledStationGeographicLocationCodeSequence = Tag('Scheduled Station Geographic Location Code Sequence', "ScheduledStationGeographicLocationCodeSequence", 0x0040, 0x4027)
    PerformedStationNameCodeSequence = Tag('Performed Station Name Code Sequence', "PerformedStationNameCodeSequence", 0x0040, 0x4028)
    PerformedStationClassCodeSequence = Tag('Performed Station Class Code Sequence', "PerformedStationClassCodeSequence", 0x0040, 0x4029)
    PerformedStationGeographicLocationCodeSequence = Tag('Performed Station Geographic Location Code Sequence', "PerformedStationGeographicLocationCodeSequence", 0x0040, 0x4030)
    RequestedSubsequentWorkitemCodeSequence = Tag('Requested Subsequent Workitem Code Sequence', "RequestedSubsequentWorkitemCodeSequence", 0x0040, 0x4031)
    NonDICOMOutputCodeSequence = Tag('Non-DICOM Output Code Sequence', "NonDICOMOutputCodeSequence", 0x0040, 0x4032)
    ScheduledHumanPerformersSequence = Tag('Scheduled Human Performers Sequence', "ScheduledHumanPerformersSequence", 0x0040, 0x4034)
    ActualHumanPerformersSequence = Tag('Actual Human Performers Sequence', "ActualHumanPerformersSequence", 0x0040, 0x4035)
    HumanPerformerOrganization = Tag("Human Performer's Organization", "HumanPerformerOrganization", 0x0040, 0x4036)
    HumanPerformerName = Tag("Human Performer's Name", "HumanPerformerName", 0x0040, 0x4037)
    RawDataHandling = Tag('Raw Data Handling', "RawDataHandling", 0x0040, 0x4040)
    InputReadinessState = Tag('Input Readiness State', "InputReadinessState", 0x0040, 0x4041)
    PerformedProcedureStepStartDateTime = Tag('Performed Procedure Step Start DateTime', "PerformedProcedureStepStartDateTime", 0x0040, 0x4050)
    PerformedProcedureStepEndDateTime = Tag('Performed Procedure Step End DateTime', "PerformedProcedureStepEndDateTime", 0x0040, 0x4051)
    ProcedureStepCancellationDateTime = Tag('Procedure Step Cancellation DateTime', "ProcedureStepCancellationDateTime", 0x0040, 0x4052)
    OutputDestinationSequence = Tag('Output Destination Sequence', "OutputDestinationSequence", 0x0040, 0x4070)
    DICOMStorageSequence = Tag('DICOM Storage Sequence', "DICOMStorageSequence", 0x0040, 0x4071, [TagLink(OutputInformationSequence),])
    STOWRSStorageSequence = Tag('STOW-RS Storage Sequence', "STOWRSStorageSequence", 0x0040, 0x4072, [TagLink(OutputInformationSequence),])
    StorageURL = Tag('Storage URL', "StorageURL", 0x0040, 0x4073, [TagLink(STOWRSStorageSequence),])
    XDSStorageSequence = Tag('XDS Storage Sequence', "XDSStorageSequence", 0x0040, 0x4074, [TagLink(OutputInformationSequence),])
    EntranceDoseInmGy = Tag('Entrance Dose in mGy', "EntranceDoseInmGy", 0x0040, 0x8302, [TagLink(XRay3DAcquisitionSequence),TagLink(PerProjectionAcquisitionSequence),TagLink(XRayAcquisitionDoseSequence),])
    EntranceDoseDerivation = Tag('Entrance Dose Derivation', "EntranceDoseDerivation", 0x0040, 0x8303, [TagLink(XRay3DAcquisitionSequence),TagLink(PerProjectionAcquisitionSequence),TagLink(XRayAcquisitionDoseSequence),])
    LUTLabel = Tag('LUT Label', "LUTLabel", 0x0040, 0x9210, [TagLink(RealWorldValueMappingSequence),TagLink(PerFrameFunctionalGroupsSequence, True),])
    RealWorldValueLastValueMapped = Tag('Real World Value Last Value Mapped', "RealWorldValueLastValueMapped", 0x0040, 0x9211, [TagLink(RealWorldValueMappingSequence),TagLink(PerFrameFunctionalGroupsSequence, True),])
    RealWorldValueLUTData = Tag('Real World Value LUT Data', "RealWorldValueLUTData", 0x0040, 0x9212, [TagLink(RealWorldValueMappingSequence),TagLink(PerFrameFunctionalGroupsSequence, True),])
    DoubleFloatRealWorldValueLastValueMapped = Tag('Double Float Real World Value Last Value Mapped', "DoubleFloatRealWorldValueLastValueMapped", 0x0040, 0x9213, [TagLink(RealWorldValueMappingSequence),TagLink(PerFrameFunctionalGroupsSequence, True),])
    DoubleFloatRealWorldValueFirstValueMapped = Tag('Double Float Real World Value First Value Mapped', "DoubleFloatRealWorldValueFirstValueMapped", 0x0040, 0x9214, [TagLink(RealWorldValueMappingSequence),TagLink(PerFrameFunctionalGroupsSequence, True),])
    RealWorldValueFirstValueMapped = Tag('Real World Value First Value Mapped', "RealWorldValueFirstValueMapped", 0x0040, 0x9216, [TagLink(RealWorldValueMappingSequence),TagLink(PerFrameFunctionalGroupsSequence, True),])
    RealWorldValueIntercept = Tag('Real World Value Intercept', "RealWorldValueIntercept", 0x0040, 0x9224, [TagLink(RealWorldValueMappingSequence),TagLink(PerFrameFunctionalGroupsSequence, True),])
    RealWorldValueSlope = Tag('Real World Value Slope', "RealWorldValueSlope", 0x0040, 0x9225, [TagLink(RealWorldValueMappingSequence),TagLink(PerFrameFunctionalGroupsSequence, True),])
    FindingsFlagTrial = Tag('Findings Flag (Trial)', "FindingsFlagTrial", 0x0040, 0xA007)
    RelationshipType = Tag('Relationship Type', "RelationshipType", 0x0040, 0xA010, [TagLink(ContentSequence),])
    FindingsSequenceTrial = Tag('Findings Sequence (Trial)', "FindingsSequenceTrial", 0x0040, 0xA020)
    FindingsGroupUIDTrial = Tag('Findings Group UID (Trial)', "FindingsGroupUIDTrial", 0x0040, 0xA021)
    ReferencedFindingsGroupUIDTrial = Tag('Referenced Findings Group UID (Trial)', "ReferencedFindingsGroupUIDTrial", 0x0040, 0xA022)
    FindingsGroupRecordingDateTrial = Tag('Findings Group Recording Date (Trial)', "FindingsGroupRecordingDateTrial", 0x0040, 0xA023)
    FindingsGroupRecordingTimeTrial = Tag('Findings Group Recording Time (Trial)', "FindingsGroupRecordingTimeTrial", 0x0040, 0xA024)
    FindingsSourceCategoryCodeSequenceTrial = Tag('Findings Source Category Code Sequence (Trial)', "FindingsSourceCategoryCodeSequenceTrial", 0x0040, 0xA026)
    VerifyingOrganization = Tag('Verifying Organization', "VerifyingOrganization", 0x0040, 0xA027, [TagLink(VerifyingObserverSequence),])
    DocumentingOrganizationIdentifierCodeSequenceTrial = Tag('Documenting Organization Identifier Code Sequence (Trial)', "DocumentingOrganizationIdentifierCodeSequenceTrial", 0x0040, 0xA028)
    VerificationDateTime = Tag('Verification DateTime', "VerificationDateTime", 0x0040, 0xA030, [TagLink(VerifyingObserverSequence),])
    ObservationDateTime = Tag('Observation DateTime', "ObservationDateTime", 0x0040, 0xA032, [TagLink(ContentItemModifierSequence),TagLink(ProtocolContextSequence),TagLink(PatientSupportPositionParameterSequence),TagLink(AcquisitionContextSequence),TagLink(QuantityDefinitionSequence),TagLink(SpecimenPreparationStepContentItemSequence),TagLink(SpecimenLocalizationContentItemSequence),TagLink(RadiationDeviceConfigurationAndCommissioningKeySequence),TagLink(PerformedProcessingParametersSequence),TagLink(DataObservationSequence),TagLink(ContentSequence),TagLink(DosimetricObjectiveParameterSequence),TagLink(PatientSupportPositionToleranceSequence),TagLink(PatientTreatmentPreparationProcedureParameterSequence),TagLink(DevicePositionParameterSequence),TagLink(PrescriptionNotesSequence),TagLink(SegmentCharacteristicsSequence),TagLink(AlternateValueSequence),TagLink(AcquisitionInitiationSequence),TagLink(DeviceSpecificAcquisitionParameterSequence),TagLink(InventoriedInstancesSequence),])
    ObservationStartDateTime = Tag('Observation Start DateTime', "ObservationStartDateTime", 0x0040, 0xA033, [TagLink(ContentItemModifierSequence),TagLink(ProtocolContextSequence),TagLink(PatientSupportPositionParameterSequence),TagLink(AcquisitionContextSequence),TagLink(QuantityDefinitionSequence),TagLink(SpecimenPreparationStepContentItemSequence),TagLink(SpecimenLocalizationContentItemSequence),TagLink(RadiationDeviceConfigurationAndCommissioningKeySequence),TagLink(PerformedProcessingParametersSequence),TagLink(DataObservationSequence),TagLink(DosimetricObjectiveParameterSequence),TagLink(PatientSupportPositionToleranceSequence),TagLink(PatientTreatmentPreparationProcedureParameterSequence),TagLink(DevicePositionParameterSequence),TagLink(PrescriptionNotesSequence),TagLink(SegmentCharacteristicsSequence),TagLink(AlternateValueSequence),TagLink(AcquisitionInitiationSequence),TagLink(DeviceSpecificAcquisitionParameterSequence),])
    ValueType = Tag('Value Type', "ValueType", 0x0040, 0xA040, [TagLink(ContentItemModifierSequence),TagLink(ProtocolContextSequence),TagLink(PatientSupportPositionParameterSequence),TagLink(AcquisitionContextSequence),TagLink(QuantityDefinitionSequence),TagLink(SpecimenPreparationStepContentItemSequence),TagLink(SpecimenLocalizationContentItemSequence),TagLink(RadiationDeviceConfigurationAndCommissioningKeySequence),TagLink(PerformedProcessingParametersSequence),TagLink(DataObservationSequence),TagLink(ContentSequence),TagLink(DosimetricObjectiveParameterSequence),TagLink(PatientSupportPositionToleranceSequence),TagLink(PatientTreatmentPreparationProcedureParameterSequence),TagLink(DevicePositionParameterSequence),TagLink(PrescriptionNotesSequence),TagLink(SegmentCharacteristicsSequence),TagLink(AlternateValueSequence),TagLink(AcquisitionInitiationSequence),TagLink(DeviceSpecificAcquisitionParameterSequence),])
    MeasurementPrecisionDescriptionTrial = Tag('Measurement Precision Description (Trial)', "MeasurementPrecisionDescriptionTrial", 0x0040, 0xA047)
    ContinuityOfContent = Tag('Continuity Of Content', "ContinuityOfContent", 0x0040, 0xA050, [TagLink(ContentSequence),])
    UrgencyOrPriorityAlertsTrial = Tag('Urgency or Priority Alerts (Trial)', "UrgencyOrPriorityAlertsTrial", 0x0040, 0xA057)
    SequencingIndicatorTrial = Tag('Sequencing Indicator (Trial)', "SequencingIndicatorTrial", 0x0040, 0xA060)
    DocumentIdentifierCodeSequenceTrial = Tag('Document Identifier Code Sequence (Trial)', "DocumentIdentifierCodeSequenceTrial", 0x0040, 0xA066)
    DocumentAuthorTrial = Tag('Document Author (Trial)', "DocumentAuthorTrial", 0x0040, 0xA067)
    DocumentAuthorIdentifierCodeSequenceTrial = Tag('Document Author Identifier Code Sequence (Trial)', "DocumentAuthorIdentifierCodeSequenceTrial", 0x0040, 0xA068)
    IdentifierCodeSequenceTrial = Tag('Identifier Code Sequence (Trial)', "IdentifierCodeSequenceTrial", 0x0040, 0xA070)
    ObjectBinaryIdentifierTrial = Tag('Object Binary Identifier (Trial)', "ObjectBinaryIdentifierTrial", 0x0040, 0xA074)
    VerifyingObserverName = Tag('Verifying Observer Name', "VerifyingObserverName", 0x0040, 0xA075, [TagLink(VerifyingObserverSequence),])
    DocumentingObserverIdentifierCodeSequenceTrial = Tag('Documenting Observer Identifier Code Sequence (Trial)', "DocumentingObserverIdentifierCodeSequenceTrial", 0x0040, 0xA076)
    AuthorObserverSequence = Tag('Author Observer Sequence', "AuthorObserverSequence", 0x0040, 0xA078)
    ParticipantSequence = Tag('Participant Sequence', "ParticipantSequence", 0x0040, 0xA07A)
    ParticipationType = Tag('Participation Type', "ParticipationType", 0x0040, 0xA080, [TagLink(ParticipantSequence),])
    ParticipationDateTime = Tag('Participation DateTime', "ParticipationDateTime", 0x0040, 0xA082, [TagLink(ParticipantSequence),])
    ObserverType = Tag('Observer Type', "ObserverType", 0x0040, 0xA084, [TagLink(UltrasoundOphthalmicAxialLengthMeasurementsSequence),TagLink(AssessmentRequesterSequence),TagLink(AuthorIdentificationSequence),TagLink(OperatorIdentificationSequence),TagLink(AsserterIdentificationSequence),])
    ProcedureIdentifierCodeSequenceTrial = Tag('Procedure Identifier Code Sequence (Trial)', "ProcedureIdentifierCodeSequenceTrial", 0x0040, 0xA085)
    ObjectDirectoryBinaryIdentifierTrial = Tag('Object Directory Binary Identifier (Trial)', "ObjectDirectoryBinaryIdentifierTrial", 0x0040, 0xA089)
    EquivalentCDADocumentSequence = Tag('Equivalent CDA Document Sequence', "EquivalentCDADocumentSequence", 0x0040, 0xA090)
    ReferencedWaveformChannels = Tag('Referenced Waveform Channels', "ReferencedWaveformChannels", 0x0040, 0xA0B0, [TagLink(ReferencedSOPSequence),TagLink(SourceWaveformSequence),TagLink(ChannelDisplaySequence),TagLink(WaveformAnnotationSequence),TagLink(ReferencedWaveformSequence),])
    DateOfDocumentOrVerbalTransactionTrial = Tag('Date of Document or Verbal Transaction (Trial)', "DateOfDocumentOrVerbalTransactionTrial", 0x0040, 0xA110)
    TimeOfDocumentCreationOrVerbalTransactionTrial = Tag('Time of Document Creation or Verbal Transaction (Trial)', "TimeOfDocumentCreationOrVerbalTransactionTrial", 0x0040, 0xA112)
    DateTime = Tag('DateTime', "DateTime", 0x0040, 0xA120, [TagLink(ContentItemModifierSequence),TagLink(ProtocolContextSequence),TagLink(PatientSupportPositionParameterSequence),TagLink(AcquisitionContextSequence),TagLink(QuantityDefinitionSequence),TagLink(SpecimenPreparationStepContentItemSequence),TagLink(SpecimenLocalizationContentItemSequence),TagLink(RadiationDeviceConfigurationAndCommissioningKeySequence),TagLink(PerformedProcessingParametersSequence),TagLink(DataObservationSequence),TagLink(ContentSequence),TagLink(DosimetricObjectiveParameterSequence),TagLink(PatientSupportPositionToleranceSequence),TagLink(PatientTreatmentPreparationProcedureParameterSequence),TagLink(DevicePositionParameterSequence),TagLink(PrescriptionNotesSequence),TagLink(SegmentCharacteristicsSequence),TagLink(AlternateValueSequence),TagLink(AcquisitionInitiationSequence),TagLink(DeviceSpecificAcquisitionParameterSequence),])
    Date = Tag('Date', "Date", 0x0040, 0xA121, [TagLink(ContentItemModifierSequence),TagLink(ProtocolContextSequence),TagLink(PatientSupportPositionParameterSequence),TagLink(AcquisitionContextSequence),TagLink(QuantityDefinitionSequence),TagLink(SpecimenPreparationStepContentItemSequence),TagLink(SpecimenLocalizationContentItemSequence),TagLink(RadiationDeviceConfigurationAndCommissioningKeySequence),TagLink(PerformedProcessingParametersSequence),TagLink(DataObservationSequence),TagLink(ContentSequence),TagLink(DosimetricObjectiveParameterSequence),TagLink(PatientSupportPositionToleranceSequence),TagLink(PatientTreatmentPreparationProcedureParameterSequence),TagLink(DevicePositionParameterSequence),TagLink(PrescriptionNotesSequence),TagLink(SegmentCharacteristicsSequence),TagLink(AlternateValueSequence),TagLink(AcquisitionInitiationSequence),TagLink(DeviceSpecificAcquisitionParameterSequence),])
    Time = Tag('Time', "Time", 0x0040, 0xA122, [TagLink(ContentItemModifierSequence),TagLink(ProtocolContextSequence),TagLink(PatientSupportPositionParameterSequence),TagLink(AcquisitionContextSequence),TagLink(QuantityDefinitionSequence),TagLink(SpecimenPreparationStepContentItemSequence),TagLink(SpecimenLocalizationContentItemSequence),TagLink(RadiationDeviceConfigurationAndCommissioningKeySequence),TagLink(PerformedProcessingParametersSequence),TagLink(DataObservationSequence),TagLink(ContentSequence),TagLink(DosimetricObjectiveParameterSequence),TagLink(PatientSupportPositionToleranceSequence),TagLink(PatientTreatmentPreparationProcedureParameterSequence),TagLink(DevicePositionParameterSequence),TagLink(PrescriptionNotesSequence),TagLink(SegmentCharacteristicsSequence),TagLink(AlternateValueSequence),TagLink(AcquisitionInitiationSequence),TagLink(DeviceSpecificAcquisitionParameterSequence),])
    PersonName = Tag('Person Name', "PersonName", 0x0040, 0xA123, [TagLink(ContentItemModifierSequence),TagLink(ProtocolContextSequence),TagLink(PatientSupportPositionParameterSequence),TagLink(AcquisitionContextSequence),TagLink(QuantityDefinitionSequence),TagLink(SpecimenPreparationStepContentItemSequence),TagLink(SpecimenLocalizationContentItemSequence),TagLink(RadiationDeviceConfigurationAndCommissioningKeySequence),TagLink(PerformedProcessingParametersSequence),TagLink(DataObservationSequence),TagLink(ContentSequence),TagLink(AssessmentRequesterSequence),TagLink(DosimetricObjectiveParameterSequence),TagLink(PatientSupportPositionToleranceSequence),TagLink(PatientTreatmentPreparationProcedureParameterSequence),TagLink(DevicePositionParameterSequence),TagLink(AuthorIdentificationSequence),TagLink(PrescriptionNotesSequence),TagLink(SegmentCharacteristicsSequence),TagLink(OperatorIdentificationSequence),TagLink(AlternateValueSequence),TagLink(AsserterIdentificationSequence),TagLink(AcquisitionInitiationSequence),TagLink(DeviceSpecificAcquisitionParameterSequence),])
    UID = Tag('UID', "UID", 0x0040, 0xA124, [TagLink(ContentItemModifierSequence),TagLink(ProtocolContextSequence),TagLink(PatientSupportPositionParameterSequence),TagLink(AcquisitionContextSequence),TagLink(QuantityDefinitionSequence),TagLink(SpecimenPreparationStepContentItemSequence),TagLink(SpecimenLocalizationContentItemSequence),TagLink(RadiationDeviceConfigurationAndCommissioningKeySequence),TagLink(PerformedProcessingParametersSequence),TagLink(DataObservationSequence),TagLink(ContentSequence),TagLink(DosimetricObjectiveParameterSequence),TagLink(PatientSupportPositionToleranceSequence),TagLink(PatientTreatmentPreparationProcedureParameterSequence),TagLink(DevicePositionParameterSequence),TagLink(PrescriptionNotesSequence),TagLink(SegmentCharacteristicsSequence),TagLink(AlternateValueSequence),TagLink(AcquisitionInitiationSequence),TagLink(DeviceSpecificAcquisitionParameterSequence),])
    ReportStatusIDTrial = Tag('Report Status ID (Trial)', "ReportStatusIDTrial", 0x0040, 0xA125)
    TemporalRangeType = Tag('Temporal Range Type', "TemporalRangeType", 0x0040, 0xA130, [TagLink(WaveformAnnotationSequence),TagLink(ContentSequence),])
    ReferencedSamplePositions = Tag('Referenced Sample Positions', "ReferencedSamplePositions", 0x0040, 0xA132, [TagLink(WaveformAnnotationSequence),TagLink(ContentSequence),])
    ReferencedFrameNumbers = Tag('Referenced Frame Numbers', "ReferencedFrameNumbers", 0x0040, 0xA136)
    ReferencedTimeOffsets = Tag('Referenced Time Offsets', "ReferencedTimeOffsets", 0x0040, 0xA138, [TagLink(WaveformAnnotationSequence),TagLink(ContentSequence),])
    ReferencedDateTime = Tag('Referenced DateTime', "ReferencedDateTime", 0x0040, 0xA13A, [TagLink(WaveformAnnotationSequence),TagLink(ContentSequence),])
    TextValue = Tag('Text Value', "TextValue", 0x0040, 0xA160, [TagLink(ContentItemModifierSequence),TagLink(ProtocolContextSequence),TagLink(PatientSupportPositionParameterSequence),TagLink(AcquisitionContextSequence),TagLink(QuantityDefinitionSequence),TagLink(SpecimenPreparationStepContentItemSequence),TagLink(SpecimenLocalizationContentItemSequence),TagLink(RadiationDeviceConfigurationAndCommissioningKeySequence),TagLink(PerformedProcessingParametersSequence),TagLink(DataObservationSequence),TagLink(ContentSequence),TagLink(DosimetricObjectiveParameterSequence),TagLink(PatientSupportPositionToleranceSequence),TagLink(PatientTreatmentPreparationProcedureParameterSequence),TagLink(DevicePositionParameterSequence),TagLink(PrescriptionNotesSequence),TagLink(SegmentCharacteristicsSequence),TagLink(AlternateValueSequence),TagLink(AcquisitionInitiationSequence),TagLink(DeviceSpecificAcquisitionParameterSequence),])
    FloatingPointValue = Tag('Floating Point Value', "FloatingPointValue", 0x0040, 0xA161, [TagLink(ContentItemModifierSequence),TagLink(ProtocolContextSequence),TagLink(PatientSupportPositionParameterSequence),TagLink(AcquisitionContextSequence),TagLink(QuantityDefinitionSequence),TagLink(SpecimenPreparationStepContentItemSequence),TagLink(SpecimenLocalizationContentItemSequence),TagLink(RadiationDeviceConfigurationAndCommissioningKeySequence),TagLink(PerformedProcessingParametersSequence),TagLink(DataObservationSequence),TagLink(MeasuredValueSequence),TagLink(DosimetricObjectiveParameterSequence),TagLink(PatientSupportPositionToleranceSequence),TagLink(PatientTreatmentPreparationProcedureParameterSequence),TagLink(DevicePositionParameterSequence),TagLink(PrescriptionNotesSequence),TagLink(SegmentCharacteristicsSequence),TagLink(AlternateValueSequence),TagLink(AcquisitionInitiationSequence),TagLink(DeviceSpecificAcquisitionParameterSequence),])
    RationalNumeratorValue = Tag('Rational Numerator Value', "RationalNumeratorValue", 0x0040, 0xA162, [TagLink(ContentItemModifierSequence),TagLink(ProtocolContextSequence),TagLink(PatientSupportPositionParameterSequence),TagLink(AcquisitionContextSequence),TagLink(QuantityDefinitionSequence),TagLink(SpecimenPreparationStepContentItemSequence),TagLink(SpecimenLocalizationContentItemSequence),TagLink(RadiationDeviceConfigurationAndCommissioningKeySequence),TagLink(PerformedProcessingParametersSequence),TagLink(DataObservationSequence),TagLink(MeasuredValueSequence),TagLink(DosimetricObjectiveParameterSequence),TagLink(PatientSupportPositionToleranceSequence),TagLink(PatientTreatmentPreparationProcedureParameterSequence),TagLink(DevicePositionParameterSequence),TagLink(PrescriptionNotesSequence),TagLink(SegmentCharacteristicsSequence),TagLink(AlternateValueSequence),TagLink(AcquisitionInitiationSequence),TagLink(DeviceSpecificAcquisitionParameterSequence),])
    RationalDenominatorValue = Tag('Rational Denominator Value', "RationalDenominatorValue", 0x0040, 0xA163, [TagLink(ContentItemModifierSequence),TagLink(ProtocolContextSequence),TagLink(PatientSupportPositionParameterSequence),TagLink(AcquisitionContextSequence),TagLink(QuantityDefinitionSequence),TagLink(SpecimenPreparationStepContentItemSequence),TagLink(SpecimenLocalizationContentItemSequence),TagLink(RadiationDeviceConfigurationAndCommissioningKeySequence),TagLink(PerformedProcessingParametersSequence),TagLink(DataObservationSequence),TagLink(MeasuredValueSequence),TagLink(DosimetricObjectiveParameterSequence),TagLink(PatientSupportPositionToleranceSequence),TagLink(PatientTreatmentPreparationProcedureParameterSequence),TagLink(DevicePositionParameterSequence),TagLink(PrescriptionNotesSequence),TagLink(SegmentCharacteristicsSequence),TagLink(AlternateValueSequence),TagLink(AcquisitionInitiationSequence),TagLink(DeviceSpecificAcquisitionParameterSequence),])
    ObservationCategoryCodeSequenceTrial = Tag('Observation Category Code Sequence (Trial)', "ObservationCategoryCodeSequenceTrial", 0x0040, 0xA167)
    BibliographicCitationTrial = Tag('Bibliographic Citation (Trial)', "BibliographicCitationTrial", 0x0040, 0xA16A)
    ObservationUID = Tag('Observation UID', "ObservationUID", 0x0040, 0xA171, [TagLink(ContentSequence),])
    ReferencedObservationUIDTrial = Tag('Referenced Observation UID (Trial)', "ReferencedObservationUIDTrial", 0x0040, 0xA172)
    ReferencedObservationClassTrial = Tag('Referenced Observation Class (Trial)', "ReferencedObservationClassTrial", 0x0040, 0xA173)
    ReferencedObjectObservationClassTrial = Tag('Referenced Object Observation Class (Trial)', "ReferencedObjectObservationClassTrial", 0x0040, 0xA174)
    WaveformAnnotationDisplaySelectionSequence = Tag('Waveform Annotation Display Selection Sequence', "WaveformAnnotationDisplaySelectionSequence", 0x0040, 0xB031, [TagLink(StructuredWaveformAnnotationSequence),])
    AnnotationGroupNumber = Tag('Annotation Group Number', "AnnotationGroupNumber", 0x0040, 0xA180, [TagLink(WaveformAnnotationSequence),TagLink(AnnotationGroupSequence),TagLink(WaveformAnnotationDisplaySelectionSequence),])
    ObservationDateTrial = Tag('Observation Date (Trial)', "ObservationDateTrial", 0x0040, 0xA192)
    ObservationTimeTrial = Tag('Observation Time (Trial)', "ObservationTimeTrial", 0x0040, 0xA193)
    MeasurementAutomationTrial = Tag('Measurement Automation (Trial)', "MeasurementAutomationTrial", 0x0040, 0xA194)
    IdentificationDescriptionTrial = Tag('Identification Description (Trial)', "IdentificationDescriptionTrial", 0x0040, 0xA224)
    CoordinatesSetGeometricTypeTrial = Tag('Coordinates Set Geometric Type (Trial)', "CoordinatesSetGeometricTypeTrial", 0x0040, 0xA290)
    AlgorithmCodeSequenceTrial = Tag('Algorithm Code Sequence (Trial)', "AlgorithmCodeSequenceTrial", 0x0040, 0xA296)
    AlgorithmDescriptionTrial = Tag('Algorithm Description (Trial)', "AlgorithmDescriptionTrial", 0x0040, 0xA297)
    PixelCoordinatesSetTrial = Tag('Pixel Coordinates Set (Trial)', "PixelCoordinatesSetTrial", 0x0040, 0xA29A)
    CurrentObserverTrial = Tag('Current Observer (Trial)', "CurrentObserverTrial", 0x0040, 0xA307)
    NumericValue = Tag('Numeric Value', "NumericValue", 0x0040, 0xA30A, [TagLink(ContentItemModifierSequence),TagLink(ProtocolContextSequence),TagLink(PatientSupportPositionParameterSequence),TagLink(AcquisitionContextSequence),TagLink(QuantityDefinitionSequence),TagLink(SpecimenPreparationStepContentItemSequence),TagLink(SpecimenLocalizationContentItemSequence),TagLink(RadiationDeviceConfigurationAndCommissioningKeySequence),TagLink(PerformedProcessingParametersSequence),TagLink(WideFieldOphthalmicPhotographyQualityRatingSequence),TagLink(OphthalmicEnFaceImageQualityRatingSequence),TagLink(LensConstantSequence),TagLink(DataObservationSequence),TagLink(OphthalmicThicknessMapQualityRatingSequence),TagLink(WaveformAnnotationSequence),TagLink(MeasuredValueSequence),TagLink(DosimetricObjectiveParameterSequence),TagLink(PatientSupportPositionToleranceSequence),TagLink(PatientTreatmentPreparationProcedureParameterSequence),TagLink(DevicePositionParameterSequence),TagLink(PrescriptionNotesSequence),TagLink(SegmentCharacteristicsSequence),TagLink(AlternateValueSequence),TagLink(AcquisitionInitiationSequence),TagLink(DeviceSpecificAcquisitionParameterSequence),])
    ReferencedAccessionSequenceTrial = Tag('Referenced Accession Sequence (Trial)', "ReferencedAccessionSequenceTrial", 0x0040, 0xA313)
    ReportStatusCommentTrial = Tag('Report Status Comment (Trial)', "ReportStatusCommentTrial", 0x0040, 0xA33A)
    ProcedureContextSequenceTrial = Tag('Procedure Context Sequence (Trial)', "ProcedureContextSequenceTrial", 0x0040, 0xA340)
    VerbalSourceTrial = Tag('Verbal Source (Trial)', "VerbalSourceTrial", 0x0040, 0xA352)
    AddressTrial = Tag('Address (Trial)', "AddressTrial", 0x0040, 0xA353)
    TelephoneNumberTrial = Tag('Telephone Number (Trial)', "TelephoneNumberTrial", 0x0040, 0xA354)
    VerbalSourceIdentifierCodeSequenceTrial = Tag('Verbal Source Identifier Code Sequence (Trial)', "VerbalSourceIdentifierCodeSequenceTrial", 0x0040, 0xA358)
    ReportDetailSequenceTrial = Tag('Report Detail Sequence (Trial)', "ReportDetailSequenceTrial", 0x0040, 0xA380)
    PertinentOtherEvidenceSequence = Tag('Pertinent Other Evidence Sequence', "PertinentOtherEvidenceSequence", 0x0040, 0xA385)
    ObservationSubjectUIDTrial = Tag('Observation Subject UID (Trial)', "ObservationSubjectUIDTrial", 0x0040, 0xA402)
    ObservationSubjectClassTrial = Tag('Observation Subject Class (Trial)', "ObservationSubjectClassTrial", 0x0040, 0xA403)
    ObservationSubjectTypeCodeSequenceTrial = Tag('Observation Subject Type Code Sequence (Trial)', "ObservationSubjectTypeCodeSequenceTrial", 0x0040, 0xA404)
    CompletionFlag = Tag('Completion Flag', "CompletionFlag", 0x0040, 0xA491)
    CompletionFlagDescription = Tag('Completion Flag Description', "CompletionFlagDescription", 0x0040, 0xA492)
    VerificationFlag = Tag('Verification Flag', "VerificationFlag", 0x0040, 0xA493)
    ArchiveRequested = Tag('Archive Requested', "ArchiveRequested", 0x0040, 0xA494)
    PreliminaryFlag = Tag('Preliminary Flag', "PreliminaryFlag", 0x0040, 0xA496)
    ObservationSubjectContextFlagTrial = Tag('Observation Subject Context Flag (Trial)', "ObservationSubjectContextFlagTrial", 0x0040, 0xA600)
    ObserverContextFlagTrial = Tag('Observer Context Flag (Trial)', "ObserverContextFlagTrial", 0x0040, 0xA601)
    ProcedureContextFlagTrial = Tag('Procedure Context Flag (Trial)', "ProcedureContextFlagTrial", 0x0040, 0xA603)
    RelationshipSequenceTrial = Tag('Relationship Sequence (Trial)', "RelationshipSequenceTrial", 0x0040, 0xA731)
    RelationshipTypeCodeSequenceTrial = Tag('Relationship Type Code Sequence (Trial)', "RelationshipTypeCodeSequenceTrial", 0x0040, 0xA732)
    LanguageCodeSequenceTrial = Tag('Language Code Sequence (Trial)', "LanguageCodeSequenceTrial", 0x0040, 0xA744)
    NumberOfTableRows = Tag('Number of Table Rows', "NumberOfTableRows", 0x0040, 0xA802, [TagLink(TabulatedValuesSequence),])
    NumberOfTableColumns = Tag('Number of Table Columns', "NumberOfTableColumns", 0x0040, 0xA803, [TagLink(TabulatedValuesSequence),])
    TableRowNumber = Tag('Table Row Number', "TableRowNumber", 0x0040, 0xA804, [TagLink(TableRowDefinitionSequence),TagLink(CellValuesSequence),])
    TableColumnNumber = Tag('Table Column Number', "TableColumnNumber", 0x0040, 0xA805, [TagLink(TableColumnDefinitionSequence),TagLink(CellValuesSequence),])
    UniformResourceLocatorTrial = Tag('Uniform Resource Locator (Trial)', "UniformResourceLocatorTrial", 0x0040, 0xA992)
    MontageActivationSequence = Tag('Montage Activation Sequence', "MontageActivationSequence", 0x0040, 0xB037)
    ReferencedMontageIndex = Tag('Referenced Montage Index', "ReferencedMontageIndex", 0x0040, 0xB032, [TagLink(WaveformAnnotationDisplaySelectionSequence),TagLink(WaveformTextualAnnotationSequence),TagLink(MontageActivationSequence),])
    AnnotationDateTime = Tag('Annotation DateTime', "AnnotationDateTime", 0x0040, 0xB034, [TagLink(WaveformTextualAnnotationSequence),])
    SegmentDefinitionDateTime = Tag('Segment Definition DateTime', "SegmentDefinitionDateTime", 0x0040, 0xB036, [TagLink(DisplayedWaveformSegmentSequence),])
    MontageActivationTimeOffset = Tag('Montage Activation Time Offset', "MontageActivationTimeOffset", 0x0040, 0xB038, [TagLink(MontageActivationSequence),])
    ReferencedMontageChannelNumber = Tag('Referenced Montage Channel Number', "ReferencedMontageChannelNumber", 0x0040, 0xB03A, [TagLink(ChannelDisplaySequence),])
    MontageName = Tag('Montage Name', "MontageName", 0x0040, 0xB03B, [TagLink(WaveformMontageSequence),])
    MontageChannelSequence = Tag('Montage Channel Sequence', "MontageChannelSequence", 0x0040, 0xB03C, [TagLink(WaveformMontageSequence),])
    MontageIndex = Tag('Montage Index', "MontageIndex", 0x0040, 0xB03D, [TagLink(WaveformMontageSequence),])
    MontageChannelNumber = Tag('Montage Channel Number', "MontageChannelNumber", 0x0040, 0xB03E)
    MontageChannelLabel = Tag('Montage Channel Label', "MontageChannelLabel", 0x0040, 0xB03F)
    ChannelWeight = Tag('Channel Weight', "ChannelWeight", 0x0040, 0xB042, [TagLink(ContributingChannelSourcesSequence),])
    TemplateIdentifier = Tag('Template Identifier', "TemplateIdentifier", 0x0040, 0xDB00, [TagLink(ContentTemplateSequence),])
    TemplateVersion = Tag('Template Version', "TemplateVersion", 0x0040, 0xDB06)
    TemplateLocalVersion = Tag('Template Local Version', "TemplateLocalVersion", 0x0040, 0xDB07)
    TemplateExtensionFlag = Tag('Template Extension Flag', "TemplateExtensionFlag", 0x0040, 0xDB0B)
    TemplateExtensionOrganizationUID = Tag('Template Extension Organization UID', "TemplateExtensionOrganizationUID", 0x0040, 0xDB0C)
    TemplateExtensionCreatorUID = Tag('Template Extension Creator UID', "TemplateExtensionCreatorUID", 0x0040, 0xDB0D)
    ReferencedContentItemIdentifier = Tag('Referenced Content Item Identifier', "ReferencedContentItemIdentifier", 0x0040, 0xDB73, [TagLink(ContentSequence),TagLink(CellValuesSequence),])
    HL7InstanceIdentifier = Tag('HL7 Instance Identifier', "HL7InstanceIdentifier", 0x0040, 0xE001, [TagLink(ReferencedSOPSequence),TagLink(PertinentDocumentsSequence),TagLink(HL7StructuredDocumentReferenceSequence),])
    HL7DocumentEffectiveTime = Tag('HL7 Document Effective Time', "HL7DocumentEffectiveTime", 0x0040, 0xE004)
    HL7DocumentTypeCodeSequence = Tag('HL7 Document Type Code Sequence', "HL7DocumentTypeCodeSequence", 0x0040, 0xE006)
    WADORetrievalSequence = Tag('WADO Retrieval Sequence', "WADORetrievalSequence", 0x0040, 0xE023, [TagLink(ReferencedPatientPhotoSequence),])
    RetrieveURI = Tag('Retrieve URI', "RetrieveURI", 0x0040, 0xE010, [TagLink(WADORetrievalSequence),TagLink(PertinentDocumentsSequence),TagLink(HL7StructuredDocumentReferenceSequence),TagLink(PrivateDataElementDefinitionSequence),TagLink(PertinentResourcesSequence),])
    RetrieveLocationUID = Tag('Retrieve Location UID', "RetrieveLocationUID", 0x0040, 0xE011)
    TypeOfInstances = Tag('Type of Instances', "TypeOfInstances", 0x0040, 0xE020, [TagLink(ReferencedPatientPhotoSequence),])
    DICOMMediaRetrievalSequence = Tag('DICOM Media Retrieval Sequence', "DICOMMediaRetrievalSequence", 0x0040, 0xE022, [TagLink(ReferencedPatientPhotoSequence),])
    XDSRetrievalSequence = Tag('XDS Retrieval Sequence', "XDSRetrievalSequence", 0x0040, 0xE024, [TagLink(ReferencedPatientPhotoSequence),])
    RepositoryUniqueID = Tag('Repository Unique ID', "RepositoryUniqueID", 0x0040, 0xE030, [TagLink(XDSRetrievalSequence),TagLink(XDSStorageSequence),])
    HomeCommunityID = Tag('Home Community ID', "HomeCommunityID", 0x0040, 0xE031, [TagLink(XDSRetrievalSequence),TagLink(XDSStorageSequence),])
    DocumentTitle = Tag('Document Title', "DocumentTitle", 0x0042, 0x0010)
    NotificationFromManufacturerSequence = Tag('Notification From Manufacturer Sequence', "NotificationFromManufacturerSequence", 0x0068, 0x6265)
    InformationFromManufacturerSequence = Tag('Information From Manufacturer Sequence', "InformationFromManufacturerSequence", 0x0068, 0x6260)
    EncapsulatedDocument = Tag('Encapsulated Document', "EncapsulatedDocument", 0x0042, 0x0011, [TagLink(NotificationFromManufacturerSequence),TagLink(InformationFromManufacturerSequence),])
    MIMETypeOfEncapsulatedDocument = Tag('MIME Type of Encapsulated Document', "MIMETypeOfEncapsulatedDocument", 0x0042, 0x0012, [TagLink(NotificationFromManufacturerSequence),TagLink(InformationFromManufacturerSequence),])
    ListOfMIMETypes = Tag('List of MIME Types', "ListOfMIMETypes", 0x0042, 0x0014)
    EncapsulatedDocumentLength = Tag('Encapsulated Document Length', "EncapsulatedDocumentLength", 0x0042, 0x0015)
    ProductPackageIdentifier = Tag('Product Package Identifier', "ProductPackageIdentifier", 0x0044, 0x0001)
    SubstanceAdministrationApproval = Tag('Substance Administration Approval', "SubstanceAdministrationApproval", 0x0044, 0x0002)
    ApprovalStatusFurtherDescription = Tag('Approval Status Further Description', "ApprovalStatusFurtherDescription", 0x0044, 0x0003)
    ApprovalStatusDateTime = Tag('Approval Status DateTime', "ApprovalStatusDateTime", 0x0044, 0x0004)
    ProductTypeCodeSequence = Tag('Product Type Code Sequence', "ProductTypeCodeSequence", 0x0044, 0x0007)
    ProductName = Tag('Product Name', "ProductName", 0x0044, 0x0008)
    ProductDescription = Tag('Product Description', "ProductDescription", 0x0044, 0x0009)
    ProductLotIdentifier = Tag('Product Lot Identifier', "ProductLotIdentifier", 0x0044, 0x000A)
    ProductExpirationDateTime = Tag('Product Expiration DateTime', "ProductExpirationDateTime", 0x0044, 0x000B)
    SubstanceAdministrationDateTime = Tag('Substance Administration DateTime', "SubstanceAdministrationDateTime", 0x0044, 0x0010)
    SubstanceAdministrationNotes = Tag('Substance Administration Notes', "SubstanceAdministrationNotes", 0x0044, 0x0011)
    SubstanceAdministrationDeviceID = Tag('Substance Administration Device ID', "SubstanceAdministrationDeviceID", 0x0044, 0x0012)
    ProductParameterSequence = Tag('Product Parameter Sequence', "ProductParameterSequence", 0x0044, 0x0013)
    SubstanceAdministrationParameterSequence = Tag('Substance Administration Parameter Sequence', "SubstanceAdministrationParameterSequence", 0x0044, 0x0019)
    AssertionUID = Tag('Assertion UID', "AssertionUID", 0x0044, 0x0102, [TagLink(ApprovalSequence),TagLink(ConfirmationSequence),])
    AssertionDateTime = Tag('Assertion DateTime', "AssertionDateTime", 0x0044, 0x0104, [TagLink(ApprovalSequence),TagLink(ConfirmationSequence),])
    AssertionExpirationDateTime = Tag('Assertion Expiration DateTime', "AssertionExpirationDateTime", 0x0044, 0x0105, [TagLink(ApprovalSequence),TagLink(ConfirmationSequence),])
    AssertionComments = Tag('Assertion Comments', "AssertionComments", 0x0044, 0x0106, [TagLink(ApprovalSequence),TagLink(ConfirmationSequence),])
    RelatedAssertionSequence = Tag('Related Assertion Sequence', "RelatedAssertionSequence", 0x0044, 0x0107, [TagLink(ApprovalSequence),TagLink(ConfirmationSequence),])
    ReferencedAssertionUID = Tag('Referenced Assertion UID', "ReferencedAssertionUID", 0x0044, 0x0108, [TagLink(RelatedAssertionSequence),])
    LensDescription = Tag('Lens Description', "LensDescription", 0x0046, 0x0012)
    RightLensSequence = Tag('Right Lens Sequence', "RightLensSequence", 0x0046, 0x0014)
    LeftLensSequence = Tag('Left Lens Sequence', "LeftLensSequence", 0x0046, 0x0015)
    UnspecifiedLateralityLensSequence = Tag('Unspecified Laterality Lens Sequence', "UnspecifiedLateralityLensSequence", 0x0046, 0x0016)
    PrismSequence = Tag('Prism Sequence', "PrismSequence", 0x0046, 0x0028)
    HorizontalPrismPower = Tag('Horizontal Prism Power', "HorizontalPrismPower", 0x0046, 0x0030, [TagLink(PrismSequence),])
    HorizontalPrismBase = Tag('Horizontal Prism Base', "HorizontalPrismBase", 0x0046, 0x0032, [TagLink(PrismSequence),])
    VerticalPrismPower = Tag('Vertical Prism Power', "VerticalPrismPower", 0x0046, 0x0034, [TagLink(PrismSequence),])
    VerticalPrismBase = Tag('Vertical Prism Base', "VerticalPrismBase", 0x0046, 0x0036, [TagLink(PrismSequence),])
    LensSegmentType = Tag('Lens Segment Type', "LensSegmentType", 0x0046, 0x0038)
    OpticalTransmittance = Tag('Optical Transmittance', "OpticalTransmittance", 0x0046, 0x0040)
    ChannelWidth = Tag('Channel Width', "ChannelWidth", 0x0046, 0x0042)
    PupilSize = Tag('Pupil Size', "PupilSize", 0x0046, 0x0044, [TagLink(AutorefractionRightEyeSequence),TagLink(AutorefractionLeftEyeSequence),])
    CornealSize = Tag('Corneal Size', "CornealSize", 0x0046, 0x0046, [TagLink(AutorefractionRightEyeSequence),TagLink(AutorefractionLeftEyeSequence),TagLink(CornealSizeSequence),])
    DistancePupillaryDistance = Tag('Distance Pupillary Distance', "DistancePupillaryDistance", 0x0046, 0x0060)
    NearPupillaryDistance = Tag('Near Pupillary Distance', "NearPupillaryDistance", 0x0046, 0x0062)
    IntermediatePupillaryDistance = Tag('Intermediate Pupillary Distance', "IntermediatePupillaryDistance", 0x0046, 0x0063)
    OtherPupillaryDistance = Tag('Other Pupillary Distance', "OtherPupillaryDistance", 0x0046, 0x0064)
    KeratometryRightEyeSequence = Tag('Keratometry Right Eye Sequence', "KeratometryRightEyeSequence", 0x0046, 0x0070)
    KeratometryLeftEyeSequence = Tag('Keratometry Left Eye Sequence', "KeratometryLeftEyeSequence", 0x0046, 0x0071)
    SteepKeratometricAxisSequence = Tag('Steep Keratometric Axis Sequence', "SteepKeratometricAxisSequence", 0x0046, 0x0074)
    FlatKeratometricAxisSequence = Tag('Flat Keratometric Axis Sequence', "FlatKeratometricAxisSequence", 0x0046, 0x0080)
    SteepCornealAxisSequence = Tag('Steep Corneal Axis Sequence', "SteepCornealAxisSequence", 0x0046, 0x0112)
    FlatCornealAxisSequence = Tag('Flat Corneal Axis Sequence', "FlatCornealAxisSequence", 0x0046, 0x0113)
    MinimumKeratometricSequence = Tag('Minimum Keratometric Sequence', "MinimumKeratometricSequence", 0x0046, 0x0215)
    RadiusOfCurvature = Tag('Radius of Curvature', "RadiusOfCurvature", 0x0046, 0x0075, [TagLink(SteepKeratometricAxisSequence),TagLink(FlatKeratometricAxisSequence),TagLink(SteepCornealAxisSequence),TagLink(FlatCornealAxisSequence),TagLink(MinimumKeratometricSequence),])
    SimulatedKeratometricCylinderSequence = Tag('Simulated Keratometric Cylinder Sequence', "SimulatedKeratometricCylinderSequence", 0x0046, 0x0218)
    KeratometricPower = Tag('Keratometric Power', "KeratometricPower", 0x0046, 0x0076, [TagLink(SteepKeratometricAxisSequence),TagLink(FlatKeratometricAxisSequence),TagLink(MinimumKeratometricSequence),TagLink(SimulatedKeratometricCylinderSequence),])
    KeratometricAxis = Tag('Keratometric Axis', "KeratometricAxis", 0x0046, 0x0077, [TagLink(SteepKeratometricAxisSequence),TagLink(FlatKeratometricAxisSequence),TagLink(MinimumKeratometricSequence),TagLink(SimulatedKeratometricCylinderSequence),])
    BackgroundColor = Tag('Background Color', "BackgroundColor", 0x0046, 0x0092)
    Optotype = Tag('Optotype', "Optotype", 0x0046, 0x0094)
    OptotypePresentation = Tag('Optotype Presentation', "OptotypePresentation", 0x0046, 0x0095)
    SubjectiveRefractionRightEyeSequence = Tag('Subjective Refraction Right Eye Sequence', "SubjectiveRefractionRightEyeSequence", 0x0046, 0x0097)
    SubjectiveRefractionLeftEyeSequence = Tag('Subjective Refraction Left Eye Sequence', "SubjectiveRefractionLeftEyeSequence", 0x0046, 0x0098)
    AddNearSequence = Tag('Add Near Sequence', "AddNearSequence", 0x0046, 0x0100)
    AddIntermediateSequence = Tag('Add Intermediate Sequence', "AddIntermediateSequence", 0x0046, 0x0101)
    AddOtherSequence = Tag('Add Other Sequence', "AddOtherSequence", 0x0046, 0x0102)
    AddPower = Tag('Add Power', "AddPower", 0x0046, 0x0104, [TagLink(AddNearSequence),TagLink(AddIntermediateSequence),TagLink(AddOtherSequence),])
    ViewingDistance = Tag('Viewing Distance', "ViewingDistance", 0x0046, 0x0106, [TagLink(AddNearSequence),TagLink(AddIntermediateSequence),TagLink(AddOtherSequence),])
    CornealPower = Tag('Corneal Power', "CornealPower", 0x0046, 0x0114, [TagLink(SteepCornealAxisSequence),TagLink(FlatCornealAxisSequence),])
    CornealAxis = Tag('Corneal Axis', "CornealAxis", 0x0046, 0x0115, [TagLink(SteepCornealAxisSequence),TagLink(FlatCornealAxisSequence),])
    RefractiveIndexOfCornea = Tag('Refractive Index of Cornea', "RefractiveIndexOfCornea", 0x0046, 0x0117)
    RefractiveIndexOfAqueousHumor = Tag('Refractive Index of Aqueous Humor', "RefractiveIndexOfAqueousHumor", 0x0046, 0x0118)
    VisualAcuityRightEyeSequence = Tag('Visual Acuity Right Eye Sequence', "VisualAcuityRightEyeSequence", 0x0046, 0x0122)
    VisualAcuityLeftEyeSequence = Tag('Visual Acuity Left Eye Sequence', "VisualAcuityLeftEyeSequence", 0x0046, 0x0123)
    VisualAcuityBothEyesOpenSequence = Tag('Visual Acuity Both Eyes Open Sequence', "VisualAcuityBothEyesOpenSequence", 0x0046, 0x0124)
    ViewingDistanceType = Tag('Viewing Distance Type', "ViewingDistanceType", 0x0046, 0x0125)
    VisualAcuityModifiers = Tag('Visual Acuity Modifiers', "VisualAcuityModifiers", 0x0046, 0x0135, [TagLink(VisualAcuityMeasurementSequence),])
    DecimalVisualAcuity = Tag('Decimal Visual Acuity', "DecimalVisualAcuity", 0x0046, 0x0137, [TagLink(VisualAcuityMeasurementSequence),])
    OptotypeDetailedDefinition = Tag('Optotype Detailed Definition', "OptotypeDetailedDefinition", 0x0046, 0x0139)
    SpherePower = Tag('Sphere Power', "SpherePower", 0x0046, 0x0146, [TagLink(AutorefractionRightEyeSequence),TagLink(AutorefractionLeftEyeSequence),])
    CylinderPower = Tag('Cylinder Power', "CylinderPower", 0x0046, 0x0147, [TagLink(CylinderSequence),TagLink(SurgicallyInducedAstigmatismSequence),])
    CornealTopographySurface = Tag('Corneal Topography Surface', "CornealTopographySurface", 0x0046, 0x0201)
    CornealVertexLocation = Tag('Corneal Vertex Location', "CornealVertexLocation", 0x0046, 0x0202)
    PupilCentroidXCoordinate = Tag('Pupil Centroid X-Coordinate', "PupilCentroidXCoordinate", 0x0046, 0x0203)
    PupilCentroidYCoordinate = Tag('Pupil Centroid Y-Coordinate', "PupilCentroidYCoordinate", 0x0046, 0x0204)
    EquivalentPupilRadius = Tag('Equivalent Pupil Radius', "EquivalentPupilRadius", 0x0046, 0x0205)
    VerticesOfTheOutlineOfPupil = Tag('Vertices of the Outline of Pupil', "VerticesOfTheOutlineOfPupil", 0x0046, 0x0208)
    MaximumCornealCurvatureSequence = Tag('Maximum Corneal Curvature Sequence', "MaximumCornealCurvatureSequence", 0x0046, 0x0211)
    MaximumCornealCurvature = Tag('Maximum Corneal Curvature', "MaximumCornealCurvature", 0x0046, 0x0212, [TagLink(MaximumCornealCurvatureSequence),])
    MaximumCornealCurvatureLocation = Tag('Maximum Corneal Curvature Location', "MaximumCornealCurvatureLocation", 0x0046, 0x0213, [TagLink(MaximumCornealCurvatureSequence),])
    AverageCornealPower = Tag('Average Corneal Power', "AverageCornealPower", 0x0046, 0x0220)
    CornealISValue = Tag('Corneal I-S Value', "CornealISValue", 0x0046, 0x0224)
    AnalyzedArea = Tag('Analyzed Area', "AnalyzedArea", 0x0046, 0x0227)
    SurfaceRegularityIndex = Tag('Surface Regularity Index', "SurfaceRegularityIndex", 0x0046, 0x0230)
    SurfaceAsymmetryIndex = Tag('Surface Asymmetry Index', "SurfaceAsymmetryIndex", 0x0046, 0x0232)
    CornealEccentricityIndex = Tag('Corneal Eccentricity Index', "CornealEccentricityIndex", 0x0046, 0x0234)
    KeratoconusPredictionIndex = Tag('Keratoconus Prediction Index', "KeratoconusPredictionIndex", 0x0046, 0x0236)
    DecimalPotentialVisualAcuity = Tag('Decimal Potential Visual Acuity', "DecimalPotentialVisualAcuity", 0x0046, 0x0238)
    CornealTopographyMapQualityEvaluation = Tag('Corneal Topography Map Quality Evaluation', "CornealTopographyMapQualityEvaluation", 0x0046, 0x0242)
    SourceImageCornealProcessedDataSequence = Tag('Source Image Corneal Processed Data Sequence', "SourceImageCornealProcessedDataSequence", 0x0046, 0x0244)
    CornealPointLocation = Tag('Corneal Point Location', "CornealPointLocation", 0x0046, 0x0247, [TagLink(SourceImageCornealProcessedDataSequence),])
    CornealPointEstimated = Tag('Corneal Point Estimated', "CornealPointEstimated", 0x0046, 0x0248, [TagLink(SourceImageCornealProcessedDataSequence),])
    AxialPower = Tag('Axial Power', "AxialPower", 0x0046, 0x0249, [TagLink(SourceImageCornealProcessedDataSequence),])
    TangentialPower = Tag('Tangential Power', "TangentialPower", 0x0046, 0x0250, [TagLink(SourceImageCornealProcessedDataSequence),])
    RefractivePower = Tag('Refractive Power', "RefractivePower", 0x0046, 0x0251, [TagLink(SourceImageCornealProcessedDataSequence),])
    RelativeElevation = Tag('Relative Elevation', "RelativeElevation", 0x0046, 0x0252, [TagLink(SourceImageCornealProcessedDataSequence),])
    CornealWavefront = Tag('Corneal Wavefront', "CornealWavefront", 0x0046, 0x0253, [TagLink(SourceImageCornealProcessedDataSequence),])
    ImagedVolumeWidth = Tag('Imaged Volume Width', "ImagedVolumeWidth", 0x0048, 0x0001)
    ImagedVolumeHeight = Tag('Imaged Volume Height', "ImagedVolumeHeight", 0x0048, 0x0002)
    ImagedVolumeDepth = Tag('Imaged Volume Depth', "ImagedVolumeDepth", 0x0048, 0x0003)
    TotalPixelMatrixColumns = Tag('Total Pixel Matrix Columns', "TotalPixelMatrixColumns", 0x0048, 0x0006)
    TotalPixelMatrixRows = Tag('Total Pixel Matrix Rows', "TotalPixelMatrixRows", 0x0048, 0x0007)
    SpecimenLabelInImage = Tag('Specimen Label in Image', "SpecimenLabelInImage", 0x0048, 0x0010)
    FocusMethod = Tag('Focus Method', "FocusMethod", 0x0048, 0x0011)
    ExtendedDepthOfField = Tag('Extended Depth of Field', "ExtendedDepthOfField", 0x0048, 0x0012)
    NumberOfFocalPlanes = Tag('Number of Focal Planes', "NumberOfFocalPlanes", 0x0048, 0x0013)
    DistanceBetweenFocalPlanes = Tag('Distance Between Focal Planes', "DistanceBetweenFocalPlanes", 0x0048, 0x0014)
    RecommendedAbsentPixelCIELabValue = Tag('Recommended Absent Pixel CIELab Value', "RecommendedAbsentPixelCIELabValue", 0x0048, 0x0015)
    ImageOrientationSlide = Tag('Image Orientation (Slide)', "ImageOrientationSlide", 0x0048, 0x0102)
    OpticalPathIdentificationSequence = Tag('Optical Path Identification Sequence', "OpticalPathIdentificationSequence", 0x0048, 0x0207, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    OpticalPathIdentifier = Tag('Optical Path Identifier', "OpticalPathIdentifier", 0x0048, 0x0106, [TagLink(OpticalPathSequence),TagLink(OpticalPathIdentificationSequence),])
    OpticalPathDescription = Tag('Optical Path Description', "OpticalPathDescription", 0x0048, 0x0107, [TagLink(OpticalPathSequence),])
    CondenserLensPower = Tag('Condenser Lens Power', "CondenserLensPower", 0x0048, 0x0111, [TagLink(OpticalPathSequence),])
    ObjectiveLensPower = Tag('Objective Lens Power', "ObjectiveLensPower", 0x0048, 0x0112, [TagLink(OpticalPathSequence),])
    ObjectiveLensNumericalAperture = Tag('Objective Lens Numerical Aperture', "ObjectiveLensNumericalAperture", 0x0048, 0x0113, [TagLink(OpticalPathSequence),])
    ConfocalMode = Tag('Confocal Mode', "ConfocalMode", 0x0048, 0x0114)
    TissueLocation = Tag('Tissue Location', "TissueLocation", 0x0048, 0x0115)
    ImageAcquisitionDepth = Tag('Image Acquisition Depth', "ImageAcquisitionDepth", 0x0048, 0x0117)
    ReferencedImageNavigationSequence = Tag('Referenced Image Navigation Sequence', "ReferencedImageNavigationSequence", 0x0048, 0x0200)
    TopLeftHandCornerOfLocalizerArea = Tag('Top Left Hand Corner of Localizer Area', "TopLeftHandCornerOfLocalizerArea", 0x0048, 0x0201)
    BottomRightHandCornerOfLocalizerArea = Tag('Bottom Right Hand Corner of Localizer Area', "BottomRightHandCornerOfLocalizerArea", 0x0048, 0x0202)
    ColumnPositionInTotalImagePixelMatrix = Tag('Column Position In Total Image Pixel Matrix', "ColumnPositionInTotalImagePixelMatrix", 0x0048, 0x021E, [TagLink(PlanePositionSlideSequence),])
    RowPositionInTotalImagePixelMatrix = Tag('Row Position In Total Image Pixel Matrix', "RowPositionInTotalImagePixelMatrix", 0x0048, 0x021F, [TagLink(PlanePositionSlideSequence),])
    PixelOriginInterpretation = Tag('Pixel Origin Interpretation', "PixelOriginInterpretation", 0x0048, 0x0301, [TagLink(DisplayedAreaSelectionSequence),TagLink(ContentSequence),])
    NumberOfOpticalPaths = Tag('Number of Optical Paths', "NumberOfOpticalPaths", 0x0048, 0x0302)
    TotalPixelMatrixFocalPlanes = Tag('Total Pixel Matrix Focal Planes', "TotalPixelMatrixFocalPlanes", 0x0048, 0x0303)
    TilesOverlap = Tag('Tiles Overlap', "TilesOverlap", 0x0048, 0x0304)
    CalibrationImage = Tag('Calibration Image', "CalibrationImage", 0x0050, 0x0004, [TagLink(CalibrationSequence),])
    ContainerComponentThickness = Tag('Container Component Thickness', "ContainerComponentThickness", 0x0050, 0x0013, [TagLink(ContainerComponentSequence),])
    DeviceLength = Tag('Device Length', "DeviceLength", 0x0050, 0x0014, [TagLink(DeviceSequence),])
    ContainerComponentWidth = Tag('Container Component Width', "ContainerComponentWidth", 0x0050, 0x0015, [TagLink(ContainerComponentSequence),])
    DeviceDiameter = Tag('Device Diameter', "DeviceDiameter", 0x0050, 0x0016, [TagLink(DeviceSequence),])
    DeviceDiameterUnits = Tag('Device Diameter Units', "DeviceDiameterUnits", 0x0050, 0x0017, [TagLink(DeviceSequence),])
    DeviceVolume = Tag('Device Volume', "DeviceVolume", 0x0050, 0x0018, [TagLink(DeviceSequence),])
    InterMarkerDistance = Tag('Inter-Marker Distance', "InterMarkerDistance", 0x0050, 0x0019, [TagLink(DeviceSequence),])
    ContainerComponentMaterial = Tag('Container Component Material', "ContainerComponentMaterial", 0x0050, 0x001A, [TagLink(ContainerComponentSequence),])
    ContainerComponentID = Tag('Container Component ID', "ContainerComponentID", 0x0050, 0x001B, [TagLink(ContainerComponentSequence),])
    ContainerComponentLength = Tag('Container Component Length', "ContainerComponentLength", 0x0050, 0x001C, [TagLink(ContainerComponentSequence),])
    ContainerComponentDiameter = Tag('Container Component Diameter', "ContainerComponentDiameter", 0x0050, 0x001D, [TagLink(ContainerComponentSequence),])
    ContainerComponentDescription = Tag('Container Component Description', "ContainerComponentDescription", 0x0050, 0x001E, [TagLink(ContainerComponentSequence),])
    DeviceDescription = Tag('Device Description', "DeviceDescription", 0x0050, 0x0020, [TagLink(UDISequence),TagLink(DeviceSequence),])
    LongDeviceDescription = Tag('Long Device Description', "LongDeviceDescription", 0x0050, 0x0021, [TagLink(TransducerIdentificationSequence),TagLink(BeamHoldOriginatingDeviceSequence),TagLink(PatientSupportDevicesSequence),TagLink(WedgeDefinitionSequence),TagLink(CompensatorDefinitionSequence),TagLink(BlockDefinitionSequence),TagLink(RTAccessoryHolderDefinitionSequence),TagLink(GeneralAccessoryDefinitionSequence),TagLink(BolusDefinitionSequence),TagLink(InterlockOriginatingDeviceSequence),TagLink(AcquisitionDeviceSequence),TagLink(PatientTreatmentPreparationDeviceSequence),TagLink(XRayFilterSequence),TagLink(SegmentedRTAccessoryDeviceSequence),TagLink(TreatmentDeviceIdentificationSequence),])
    ContrastBolusIngredientPercentByVolume = Tag('Contrast/Bolus Ingredient Percent by Volume', "ContrastBolusIngredientPercentByVolume", 0x0052, 0x0001, [TagLink(ContrastBolusAgentSequence),])
    OCTFocalDistance = Tag('OCT Focal Distance', "OCTFocalDistance", 0x0052, 0x0002)
    BeamSpotSize = Tag('Beam Spot Size', "BeamSpotSize", 0x0052, 0x0003)
    EffectiveRefractiveIndex = Tag('Effective Refractive Index', "EffectiveRefractiveIndex", 0x0052, 0x0004)
    OCTAcquisitionDomain = Tag('OCT Acquisition Domain', "OCTAcquisitionDomain", 0x0052, 0x0006)
    OCTOpticalCenterWavelength = Tag('OCT Optical Center Wavelength', "OCTOpticalCenterWavelength", 0x0052, 0x0007)
    AxialResolution = Tag('Axial Resolution', "AxialResolution", 0x0052, 0x0008)
    RangingDepth = Tag('Ranging Depth', "RangingDepth", 0x0052, 0x0009)
    ALineRate = Tag('A-line Rate', "ALineRate", 0x0052, 0x0011)
    ALinesPerFrame = Tag('A-lines Per Frame', "ALinesPerFrame", 0x0052, 0x0012)
    CatheterRotationalRate = Tag('Catheter Rotational Rate', "CatheterRotationalRate", 0x0052, 0x0013)
    ALinePixelSpacing = Tag('A-line Pixel Spacing', "ALinePixelSpacing", 0x0052, 0x0014)
    OCTZOffsetApplied = Tag('OCT Z Offset Applied', "OCTZOffsetApplied", 0x0052, 0x0026)
    IntravascularFrameContentSequence = Tag('Intravascular Frame Content Sequence', "IntravascularFrameContentSequence", 0x0052, 0x0027, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    IntravascularLongitudinalDistance = Tag('Intravascular Longitudinal Distance', "IntravascularLongitudinalDistance", 0x0052, 0x0028, [TagLink(IntravascularFrameContentSequence),])
    IntravascularOCTFrameContentSequence = Tag('Intravascular OCT Frame Content Sequence', "IntravascularOCTFrameContentSequence", 0x0052, 0x0029, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    OCTZOffsetCorrection = Tag('OCT Z Offset Correction', "OCTZOffsetCorrection", 0x0052, 0x0030, [TagLink(IntravascularOCTFrameContentSequence),])
    CatheterDirectionOfRotation = Tag('Catheter Direction of Rotation', "CatheterDirectionOfRotation", 0x0052, 0x0031)
    SeamLineLocation = Tag('Seam Line Location', "SeamLineLocation", 0x0052, 0x0033, [TagLink(IntravascularFrameContentSequence),])
    FirstALineLocation = Tag('First A-line Location', "FirstALineLocation", 0x0052, 0x0034)
    SeamLineIndex = Tag('Seam Line Index', "SeamLineIndex", 0x0052, 0x0036, [TagLink(IntravascularOCTFrameContentSequence),])
    NumberOfPaddedALines = Tag('Number of Padded A-lines', "NumberOfPaddedALines", 0x0052, 0x0038, [TagLink(IntravascularOCTFrameContentSequence),])
    InterpolationType = Tag('Interpolation Type', "InterpolationType", 0x0052, 0x0039)
    RefractiveIndexApplied = Tag('Refractive Index Applied', "RefractiveIndexApplied", 0x0052, 0x003A)
    EnergyWindowVector = Tag('Energy Window Vector', "EnergyWindowVector", 0x0054, 0x0010)
    NumberOfEnergyWindows = Tag('Number of Energy Windows', "NumberOfEnergyWindows", 0x0054, 0x0011)
    EnergyWindowInformationSequence = Tag('Energy Window Information Sequence', "EnergyWindowInformationSequence", 0x0054, 0x0012)
    EnergyWindowRangeSequence = Tag('Energy Window Range Sequence', "EnergyWindowRangeSequence", 0x0054, 0x0013, [TagLink(EnergyWindowInformationSequence),])
    EnergyWindowLowerLimit = Tag('Energy Window Lower Limit', "EnergyWindowLowerLimit", 0x0054, 0x0014, [TagLink(EnergyWindowRangeSequence),])
    EnergyWindowUpperLimit = Tag('Energy Window Upper Limit', "EnergyWindowUpperLimit", 0x0054, 0x0015, [TagLink(EnergyWindowRangeSequence),])
    ResidualSyringeCounts = Tag('Residual Syringe Counts', "ResidualSyringeCounts", 0x0054, 0x0017, [TagLink(CalibrationDataSequence),])
    EnergyWindowName = Tag('Energy Window Name', "EnergyWindowName", 0x0054, 0x0018, [TagLink(EnergyWindowInformationSequence),])
    DetectorVector = Tag('Detector Vector', "DetectorVector", 0x0054, 0x0020)
    NumberOfDetectors = Tag('Number of Detectors', "NumberOfDetectors", 0x0054, 0x0021)
    PhaseVector = Tag('Phase Vector', "PhaseVector", 0x0054, 0x0030)
    NumberOfPhases = Tag('Number of Phases', "NumberOfPhases", 0x0054, 0x0031)
    NumberOfFramesInPhase = Tag('Number of Frames in Phase', "NumberOfFramesInPhase", 0x0054, 0x0033, [TagLink(PhaseInformationSequence),])
    PhaseDelay = Tag('Phase Delay', "PhaseDelay", 0x0054, 0x0036, [TagLink(PhaseInformationSequence),])
    PauseBetweenFrames = Tag('Pause Between Frames', "PauseBetweenFrames", 0x0054, 0x0038, [TagLink(PhaseInformationSequence),])
    PhaseDescription = Tag('Phase Description', "PhaseDescription", 0x0054, 0x0039, [TagLink(PhaseInformationSequence),])
    RotationVector = Tag('Rotation Vector', "RotationVector", 0x0054, 0x0050)
    NumberOfRotations = Tag('Number of Rotations', "NumberOfRotations", 0x0054, 0x0051)
    NumberOfFramesInRotation = Tag('Number of Frames in Rotation', "NumberOfFramesInRotation", 0x0054, 0x0053, [TagLink(RotationInformationSequence),])
    RRIntervalVector = Tag('R-R Interval Vector', "RRIntervalVector", 0x0054, 0x0060)
    NumberOfRRIntervals = Tag('Number of R-R Intervals', "NumberOfRRIntervals", 0x0054, 0x0061)
    TimeSlotVector = Tag('Time Slot Vector', "TimeSlotVector", 0x0054, 0x0070)
    NumberOfTimeSlots = Tag('Number of Time Slots', "NumberOfTimeSlots", 0x0054, 0x0071)
    TimeSlotInformationSequence = Tag('Time Slot Information Sequence', "TimeSlotInformationSequence", 0x0054, 0x0072, [TagLink(DataInformationSequence),])
    TimeSlotTime = Tag('Time Slot Time', "TimeSlotTime", 0x0054, 0x0073, [TagLink(TimeSlotInformationSequence),])
    SliceVector = Tag('Slice Vector', "SliceVector", 0x0054, 0x0080)
    NumberOfSlices = Tag('Number of Slices', "NumberOfSlices", 0x0054, 0x0081, [TagLink(ReconstructionProtocolElementSequence),])
    AngularViewVector = Tag('Angular View Vector', "AngularViewVector", 0x0054, 0x0090)
    TimeSliceVector = Tag('Time Slice Vector', "TimeSliceVector", 0x0054, 0x0100)
    NumberOfTimeSlices = Tag('Number of Time Slices', "NumberOfTimeSlices", 0x0054, 0x0101)
    StartAngle = Tag('Start Angle', "StartAngle", 0x0054, 0x0200, [TagLink(DetectorInformationSequence),TagLink(RotationInformationSequence),])
    TypeOfDetectorMotion = Tag('Type of Detector Motion', "TypeOfDetectorMotion", 0x0054, 0x0202)
    TriggerVector = Tag('Trigger Vector', "TriggerVector", 0x0054, 0x0210, [TagLink(PhaseInformationSequence),])
    NumberOfTriggersInPhase = Tag('Number of Triggers in Phase', "NumberOfTriggersInPhase", 0x0054, 0x0211, [TagLink(PhaseInformationSequence),])
    EnergyWindowNumber = Tag('Energy Window Number', "EnergyWindowNumber", 0x0054, 0x0308, [TagLink(CalibrationDataSequence),])
    ImageID = Tag('Image ID', "ImageID", 0x0054, 0x0400)
    SliceProgressionDirection = Tag('Slice Progression Direction', "SliceProgressionDirection", 0x0054, 0x0500)
    ScanProgressionDirection = Tag('Scan Progression Direction', "ScanProgressionDirection", 0x0054, 0x0501)
    SeriesType = Tag('Series Type', "SeriesType", 0x0054, 0x1000)
    Units = Tag('Units', "Units", 0x0054, 0x1001)
    CountsSource = Tag('Counts Source', "CountsSource", 0x0054, 0x1002)
    ReprojectionMethod = Tag('Reprojection Method', "ReprojectionMethod", 0x0054, 0x1004)
    SUVType = Tag('SUV Type', "SUVType", 0x0054, 0x1006)
    RandomsCorrectionMethod = Tag('Randoms Correction Method', "RandomsCorrectionMethod", 0x0054, 0x1100)
    AttenuationCorrectionMethod = Tag('Attenuation Correction Method', "AttenuationCorrectionMethod", 0x0054, 0x1101)
    DecayCorrection = Tag('Decay Correction', "DecayCorrection", 0x0054, 0x1102)
    ReconstructionMethod = Tag('Reconstruction Method', "ReconstructionMethod", 0x0054, 0x1103)
    DetectorLinesOfResponseUsed = Tag('Detector Lines of Response Used', "DetectorLinesOfResponseUsed", 0x0054, 0x1104)
    ScatterCorrectionMethod = Tag('Scatter Correction Method', "ScatterCorrectionMethod", 0x0054, 0x1105)
    AxialAcceptance = Tag('Axial Acceptance', "AxialAcceptance", 0x0054, 0x1200)
    AxialMash = Tag('Axial Mash', "AxialMash", 0x0054, 0x1201)
    TransverseMash = Tag('Transverse Mash', "TransverseMash", 0x0054, 0x1202)
    DetectorElementSize = Tag('Detector Element Size', "DetectorElementSize", 0x0054, 0x1203)
    CoincidenceWindowWidth = Tag('Coincidence Window Width', "CoincidenceWindowWidth", 0x0054, 0x1210)
    SecondaryCountsType = Tag('Secondary Counts Type', "SecondaryCountsType", 0x0054, 0x1220)
    FrameReferenceTime = Tag('Frame Reference Time', "FrameReferenceTime", 0x0054, 0x1300)
    PrimaryPromptsCountsAccumulated = Tag('Primary (Prompts) Counts Accumulated', "PrimaryPromptsCountsAccumulated", 0x0054, 0x1310, [TagLink(PETFrameCorrectionFactorsSequence),])
    SecondaryCountsAccumulated = Tag('Secondary Counts Accumulated', "SecondaryCountsAccumulated", 0x0054, 0x1311)
    SliceSensitivityFactor = Tag('Slice Sensitivity Factor', "SliceSensitivityFactor", 0x0054, 0x1320, [TagLink(PETFrameCorrectionFactorsSequence),])
    DecayFactor = Tag('Decay Factor', "DecayFactor", 0x0054, 0x1321, [TagLink(PETFrameCorrectionFactorsSequence),])
    DoseCalibrationFactor = Tag('Dose Calibration Factor', "DoseCalibrationFactor", 0x0054, 0x1322)
    ScatterFractionFactor = Tag('Scatter Fraction Factor', "ScatterFractionFactor", 0x0054, 0x1323, [TagLink(PETFrameCorrectionFactorsSequence),])
    DeadTimeFactor = Tag('Dead Time Factor', "DeadTimeFactor", 0x0054, 0x1324, [TagLink(PETFrameCorrectionFactorsSequence),])
    ImageIndex = Tag('Image Index', "ImageIndex", 0x0054, 0x1330)
    CountsIncluded = Tag('Counts Included', "CountsIncluded", 0x0054, 0x1400)
    DeadTimeCorrectionFlag = Tag('Dead Time Correction Flag', "DeadTimeCorrectionFlag", 0x0054, 0x1401)
    HistogramSequence = Tag('Histogram Sequence', "HistogramSequence", 0x0060, 0x3000)
    HistogramNumberOfBins = Tag('Histogram Number of Bins', "HistogramNumberOfBins", 0x0060, 0x3002)
    HistogramFirstBinValue = Tag('Histogram First Bin Value', "HistogramFirstBinValue", 0x0060, 0x3004)
    HistogramLastBinValue = Tag('Histogram Last Bin Value', "HistogramLastBinValue", 0x0060, 0x3006)
    HistogramBinWidth = Tag('Histogram Bin Width', "HistogramBinWidth", 0x0060, 0x3008)
    HistogramExplanation = Tag('Histogram Explanation', "HistogramExplanation", 0x0060, 0x3010)
    HistogramData = Tag('Histogram Data', "HistogramData", 0x0060, 0x3020)
    SegmentationType = Tag('Segmentation Type', "SegmentationType", 0x0062, 0x0001)
    SegmentNumber = Tag('Segment Number', "SegmentNumber", 0x0062, 0x0004, [TagLink(SegmentSequence),])
    SegmentLabel = Tag('Segment Label', "SegmentLabel", 0x0062, 0x0005, [TagLink(SegmentSequence),])
    SegmentDescription = Tag('Segment Description', "SegmentDescription", 0x0062, 0x0006, [TagLink(SegmentSequence),])
    SegmentAlgorithmType = Tag('Segment Algorithm Type', "SegmentAlgorithmType", 0x0062, 0x0008, [TagLink(SegmentSequence),])
    SegmentAlgorithmName = Tag('Segment Algorithm Name', "SegmentAlgorithmName", 0x0062, 0x0009, [TagLink(SegmentSequence),])
    SegmentIdentificationSequence = Tag('Segment Identification Sequence', "SegmentIdentificationSequence", 0x0062, 0x000A, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    ReferencedSegmentNumber = Tag('Referenced Segment Number', "ReferencedSegmentNumber", 0x0062, 0x000B, [TagLink(ReferencedSOPSequence),TagLink(ReferencedImageSequence),TagLink(SourceImageSequence),TagLink(ConversionSourceAttributesSequence),TagLink(ContourImageSequence),TagLink(DefinitionSourceSequence),TagLink(ReferencedSetupImageSequence),TagLink(ReferencedInstanceSequence),TagLink(OphthalmicFrameLocationSequence),TagLink(ReferencedSegmentationSequence),TagLink(LeftImageSequence),TagLink(RightImageSequence),TagLink(ReferencedOtherPlaneSequence),TagLink(SegmentIdentificationSequence),TagLink(SegmentSurfaceSourceInstanceSequence),TagLink(ReferencedFirstFrameSequence),TagLink(RenderedImageReferenceSequence),TagLink(UsedSegmentsSequence),TagLink(ReferencedTextureSequence),TagLink(DirectSegmentReferenceSequence),])
    RecommendedDisplayGrayscaleValue = Tag('Recommended Display Grayscale Value', "RecommendedDisplayGrayscaleValue", 0x0062, 0x000C, [TagLink(ROIContourSequence),TagLink(SegmentSequence),TagLink(SurfaceSequence),TagLink(RTSegmentAnnotationSequence),])
    RecommendedIsodoseLevelSequence = Tag('Recommended Isodose Level Sequence', "RecommendedIsodoseLevelSequence", 0x3004, 0x0016)
    TrackSequence = Tag('Track Sequence', "TrackSequence", 0x0066, 0x0102, [TagLink(TrackSetSequence),])
    RecommendedDisplayCIELabValue = Tag('Recommended Display CIELab Value', "RecommendedDisplayCIELabValue", 0x0062, 0x000D, [TagLink(RecommendedIsodoseLevelSequence),TagLink(ROIContourSequence),TagLink(SegmentSequence),TagLink(TrackSequence),TagLink(TrackSetSequence),TagLink(SurfaceSequence),TagLink(RTAnatomicPrescriptionSequence),TagLink(RTSegmentAnnotationSequence),TagLink(AnnotationGroupSequence),])
    MaximumFractionalValue = Tag('Maximum Fractional Value', "MaximumFractionalValue", 0x0062, 0x000E)
    SegmentationFractionalType = Tag('Segmentation Fractional Type', "SegmentationFractionalType", 0x0062, 0x0010)
    SegmentsOverlap = Tag('Segments Overlap', "SegmentsOverlap", 0x0062, 0x0013)
    TextObjectSequence = Tag('Text Object Sequence', "TextObjectSequence", 0x0070, 0x0008, [TagLink(GraphicAnnotationSequence),TagLink(VolumetricAnnotationSequence),TagLink(VolumetricPresentationInputAnnotationSequence),])
    GraphicObjectSequence = Tag('Graphic Object Sequence', "GraphicObjectSequence", 0x0070, 0x0009, [TagLink(GraphicAnnotationSequence),])
    TrackingID = Tag('Tracking ID', "TrackingID", 0x0062, 0x0020, [TagLink(SegmentSequence),TagLink(TextObjectSequence),TagLink(GraphicObjectSequence),])
    TrackingUID = Tag('Tracking UID', "TrackingUID", 0x0062, 0x0021, [TagLink(SegmentSequence),TagLink(TextObjectSequence),TagLink(GraphicObjectSequence),])
    SourceFrameOfReferenceUID = Tag('Source Frame of Reference UID', "SourceFrameOfReferenceUID", 0x0064, 0x0003, [TagLink(DeformableRegistrationSequence),])
    GridDimensions = Tag('Grid Dimensions', "GridDimensions", 0x0064, 0x0007, [TagLink(DeformableRegistrationGridSequence),])
    GridResolution = Tag('Grid Resolution', "GridResolution", 0x0064, 0x0008, [TagLink(DeformableRegistrationGridSequence),])
    VectorGridData = Tag('Vector Grid Data', "VectorGridData", 0x0064, 0x0009, [TagLink(DeformableRegistrationGridSequence),])
    PreDeformationMatrixRegistrationSequence = Tag('Pre Deformation Matrix Registration Sequence', "PreDeformationMatrixRegistrationSequence", 0x0064, 0x000F, [TagLink(DeformableRegistrationSequence),])
    PostDeformationMatrixRegistrationSequence = Tag('Post Deformation Matrix Registration Sequence', "PostDeformationMatrixRegistrationSequence", 0x0064, 0x0010, [TagLink(DeformableRegistrationSequence),])
    NumberOfSurfaces = Tag('Number of Surfaces', "NumberOfSurfaces", 0x0066, 0x0001)
    SurfaceNumber = Tag('Surface Number', "SurfaceNumber", 0x0066, 0x0003, [TagLink(SurfaceSequence),])
    SurfaceComments = Tag('Surface Comments', "SurfaceComments", 0x0066, 0x0004, [TagLink(SurfaceSequence),])
    SurfaceOffset = Tag('Surface Offset', "SurfaceOffset", 0x0066, 0x0005, [TagLink(OphthalmicEnFaceVolumeDescriptorSequence),])
    SurfaceProcessing = Tag('Surface Processing', "SurfaceProcessing", 0x0066, 0x0009, [TagLink(SurfaceSequence),])
    SurfaceProcessingRatio = Tag('Surface Processing Ratio', "SurfaceProcessingRatio", 0x0066, 0x000A, [TagLink(SurfaceSequence),])
    SurfaceProcessingDescription = Tag('Surface Processing Description', "SurfaceProcessingDescription", 0x0066, 0x000B, [TagLink(OphthalmicEnFaceVolumeDescriptorSequence),TagLink(SurfaceSequence),])
    RecommendedPresentationOpacity = Tag('Recommended Presentation Opacity', "RecommendedPresentationOpacity", 0x0066, 0x000C, [TagLink(SurfaceSequence),TagLink(RTSegmentAnnotationSequence),])
    RecommendedPresentationType = Tag('Recommended Presentation Type', "RecommendedPresentationType", 0x0066, 0x000D, [TagLink(SurfaceSequence),TagLink(RTSegmentAnnotationSequence),])
    FiniteVolume = Tag('Finite Volume', "FiniteVolume", 0x0066, 0x000E, [TagLink(SurfaceSequence),])
    Manifold = Tag('Manifold', "Manifold", 0x0066, 0x0010, [TagLink(SurfaceSequence),])
    SurfacePointsNormalsSequence = Tag('Surface Points Normals Sequence', "SurfacePointsNormalsSequence", 0x0066, 0x0012, [TagLink(SurfaceSequence),])
    SurfaceMeshPrimitivesSequence = Tag('Surface Mesh Primitives Sequence', "SurfaceMeshPrimitivesSequence", 0x0066, 0x0013, [TagLink(SurfaceSequence),])
    NumberOfSurfacePoints = Tag('Number of Surface Points', "NumberOfSurfacePoints", 0x0066, 0x0015, [TagLink(SurfacePointsSequence),])
    PointCoordinatesData = Tag('Point Coordinates Data', "PointCoordinatesData", 0x0066, 0x0016, [TagLink(TrackSequence),TagLink(SurfacePointsSequence),TagLink(AnnotationGroupSequence),])
    PointPositionAccuracy = Tag('Point Position Accuracy', "PointPositionAccuracy", 0x0066, 0x0017, [TagLink(SurfacePointsSequence),])
    MeanPointDistance = Tag('Mean Point Distance', "MeanPointDistance", 0x0066, 0x0018, [TagLink(SurfacePointsSequence),])
    MaximumPointDistance = Tag('Maximum Point Distance', "MaximumPointDistance", 0x0066, 0x0019, [TagLink(SurfacePointsSequence),])
    PointsBoundingBoxCoordinates = Tag('Points Bounding Box Coordinates', "PointsBoundingBoxCoordinates", 0x0066, 0x001A, [TagLink(SurfacePointsSequence),])
    AxisOfRotation = Tag('Axis of Rotation', "AxisOfRotation", 0x0066, 0x001B, [TagLink(SurfacePointsSequence),])
    CenterOfRotation = Tag('Center of Rotation', "CenterOfRotation", 0x0066, 0x001C, [TagLink(SurfacePointsSequence),])
    NumberOfVectors = Tag('Number of Vectors', "NumberOfVectors", 0x0066, 0x001E)
    VectorDimensionality = Tag('Vector Dimensionality', "VectorDimensionality", 0x0066, 0x001F)
    VectorAccuracy = Tag('Vector Accuracy', "VectorAccuracy", 0x0066, 0x0020)
    VectorCoordinateData = Tag('Vector Coordinate Data', "VectorCoordinateData", 0x0066, 0x0021)
    DoublePointCoordinatesData = Tag('Double Point Coordinates Data', "DoublePointCoordinatesData", 0x0066, 0x0022, [TagLink(AnnotationGroupSequence),])
    TrianglePointIndexList = Tag('Triangle Point Index List', "TrianglePointIndexList", 0x0066, 0x0023)
    EdgePointIndexList = Tag('Edge Point Index List', "EdgePointIndexList", 0x0066, 0x0024)
    VertexPointIndexList = Tag('Vertex Point Index List', "VertexPointIndexList", 0x0066, 0x0025)
    TriangleStripSequence = Tag('Triangle Strip Sequence', "TriangleStripSequence", 0x0066, 0x0026)
    TriangleFanSequence = Tag('Triangle Fan Sequence', "TriangleFanSequence", 0x0066, 0x0027)
    LineSequence = Tag('Line Sequence', "LineSequence", 0x0066, 0x0028)
    PrimitivePointIndexList = Tag('Primitive Point Index List', "PrimitivePointIndexList", 0x0066, 0x0029)
    SurfaceCount = Tag('Surface Count', "SurfaceCount", 0x0066, 0x002A, [TagLink(SegmentSequence),])
    SurfaceModelDescriptionSequence = Tag('Surface Model Description Sequence', "SurfaceModelDescriptionSequence", 0x0068, 0x6360)
    ReferencedSurfaceNumber = Tag('Referenced Surface Number', "ReferencedSurfaceNumber", 0x0066, 0x002C, [TagLink(ReferencedSurfaceSequence),TagLink(UVMappingSequence),TagLink(SurfaceModelDescriptionSequence),TagLink(DirectSegmentReferenceSequence),])
    AlgorithmVersion = Tag('Algorithm Version', "AlgorithmVersion", 0x0066, 0x0031, [TagLink(ConceptualVolumeDerivationAlgorithmSequence),TagLink(ROIDerivationAlgorithmIdentificationSequence),TagLink(DerivationAlgorithmSequence),TagLink(DecompositionAlgorithmIdentificationSequence),TagLink(TransformationAlgorithmSequence),TagLink(WideFieldOphthalmicPhotographyQualityRatingSequence),TagLink(OphthalmicEnFaceImageQualityRatingSequence),TagLink(AcquisitionMethodAlgorithmSequence),TagLink(SegmentationAlgorithmIdentificationSequence),TagLink(SegmentSurfaceGenerationAlgorithmIdentificationSequence),TagLink(IndexProbabilitySequence),TagLink(AgeCorrectedSensitivityDeviationAlgorithmSequence),TagLink(GeneralizedDefectSensitivityDeviationAlgorithmSequence),TagLink(GlobalDeviationProbabilitySequence),TagLink(LocalizedDeviationProbabilitySequence),TagLink(OphthalmicThicknessMapQualityThresholdSequence),TagLink(TrackingAlgorithmIdentificationSequence),TagLink(ReconstructionAlgorithmSequence),TagLink(SurfaceProcessingAlgorithmIdentificationSequence),TagLink(AnnotationGroupAlgorithmIdentificationSequence),])
    AlgorithmParameters = Tag('Algorithm Parameters', "AlgorithmParameters", 0x0066, 0x0032, [TagLink(ConceptualVolumeDerivationAlgorithmSequence),TagLink(ROIDerivationAlgorithmIdentificationSequence),TagLink(DerivationAlgorithmSequence),TagLink(DecompositionAlgorithmIdentificationSequence),TagLink(TransformationAlgorithmSequence),TagLink(WideFieldOphthalmicPhotographyQualityRatingSequence),TagLink(OphthalmicEnFaceImageQualityRatingSequence),TagLink(AcquisitionMethodAlgorithmSequence),TagLink(SegmentationAlgorithmIdentificationSequence),TagLink(SegmentSurfaceGenerationAlgorithmIdentificationSequence),TagLink(IndexProbabilitySequence),TagLink(AgeCorrectedSensitivityDeviationAlgorithmSequence),TagLink(GeneralizedDefectSensitivityDeviationAlgorithmSequence),TagLink(GlobalDeviationProbabilitySequence),TagLink(LocalizedDeviationProbabilitySequence),TagLink(OphthalmicThicknessMapQualityThresholdSequence),TagLink(TrackingAlgorithmIdentificationSequence),TagLink(ReconstructionAlgorithmSequence),TagLink(SurfaceProcessingAlgorithmIdentificationSequence),TagLink(AnnotationGroupAlgorithmIdentificationSequence),])
    FacetSequence = Tag('Facet Sequence', "FacetSequence", 0x0066, 0x0034)
    AlgorithmName = Tag('Algorithm Name', "AlgorithmName", 0x0066, 0x0036, [TagLink(ConceptualVolumeDerivationAlgorithmSequence),TagLink(ROIDerivationAlgorithmIdentificationSequence),TagLink(DerivationAlgorithmSequence),TagLink(DecompositionAlgorithmIdentificationSequence),TagLink(TransformationAlgorithmSequence),TagLink(WideFieldOphthalmicPhotographyQualityRatingSequence),TagLink(OphthalmicEnFaceImageQualityRatingSequence),TagLink(AcquisitionMethodAlgorithmSequence),TagLink(SegmentationAlgorithmIdentificationSequence),TagLink(SegmentSurfaceGenerationAlgorithmIdentificationSequence),TagLink(IndexProbabilitySequence),TagLink(AgeCorrectedSensitivityDeviationAlgorithmSequence),TagLink(GeneralizedDefectSensitivityDeviationAlgorithmSequence),TagLink(GlobalDeviationProbabilitySequence),TagLink(LocalizedDeviationProbabilitySequence),TagLink(OphthalmicThicknessMapQualityThresholdSequence),TagLink(TrackingAlgorithmIdentificationSequence),TagLink(ReconstructionAlgorithmSequence),TagLink(SurfaceProcessingAlgorithmIdentificationSequence),TagLink(AnnotationGroupAlgorithmIdentificationSequence),])
    RecommendedPointRadius = Tag('Recommended Point Radius', "RecommendedPointRadius", 0x0066, 0x0037, [TagLink(SurfaceSequence),])
    RecommendedLineThickness = Tag('Recommended Line Thickness', "RecommendedLineThickness", 0x0066, 0x0038, [TagLink(TrackSetSequence),TagLink(SurfaceSequence),])
    LongPrimitivePointIndexList = Tag('Long Primitive Point Index List', "LongPrimitivePointIndexList", 0x0066, 0x0040, [TagLink(TriangleStripSequence),TagLink(TriangleFanSequence),TagLink(LineSequence),TagLink(FacetSequence),TagLink(AnnotationGroupSequence),])
    LongTrianglePointIndexList = Tag('Long Triangle Point Index List', "LongTrianglePointIndexList", 0x0066, 0x0041)
    LongEdgePointIndexList = Tag('Long Edge Point Index List', "LongEdgePointIndexList", 0x0066, 0x0042)
    LongVertexPointIndexList = Tag('Long Vertex Point Index List', "LongVertexPointIndexList", 0x0066, 0x0043)
    RecommendedDisplayCIELabValueList = Tag('Recommended Display CIELab Value List', "RecommendedDisplayCIELabValueList", 0x0066, 0x0103, [TagLink(TrackSequence),])
    TrackSetNumber = Tag('Track Set Number', "TrackSetNumber", 0x0066, 0x0105, [TagLink(TrackSetSequence),])
    TrackSetLabel = Tag('Track Set Label', "TrackSetLabel", 0x0066, 0x0106, [TagLink(TrackSetSequence),])
    TrackSetDescription = Tag('Track Set Description', "TrackSetDescription", 0x0066, 0x0107, [TagLink(TrackSetSequence),])
    TrackSetStatisticsSequence = Tag('Track Set Statistics Sequence', "TrackSetStatisticsSequence", 0x0066, 0x0124, [TagLink(TrackSetSequence),])
    MeasurementValuesSequence = Tag('Measurement Values Sequence', "MeasurementValuesSequence", 0x0066, 0x0132, [TagLink(MeasurementsSequence),])
    FloatingPointValues = Tag('Floating Point Values', "FloatingPointValues", 0x0066, 0x0125, [TagLink(MeasurementValuesSequence),TagLink(TrackStatisticsSequence),])
    TrackPointIndexList = Tag('Track Point Index List', "TrackPointIndexList", 0x0066, 0x0129, [TagLink(MeasurementValuesSequence),])
    ImplantSize = Tag('Implant Size', "ImplantSize", 0x0068, 0x6210)
    ImplantTemplateVersion = Tag('Implant Template Version', "ImplantTemplateVersion", 0x0068, 0x6221)
    ImplantType = Tag('Implant Type', "ImplantType", 0x0068, 0x6223)
    EffectiveDateTime = Tag('Effective DateTime', "EffectiveDateTime", 0x0068, 0x6226)
    InformationIssueDateTime = Tag('Information Issue DateTime', "InformationIssueDateTime", 0x0068, 0x6270, [TagLink(NotificationFromManufacturerSequence),TagLink(InformationFromManufacturerSequence),])
    InformationSummary = Tag('Information Summary', "InformationSummary", 0x0068, 0x6280, [TagLink(NotificationFromManufacturerSequence),TagLink(InformationFromManufacturerSequence),])
    OverallTemplateSpatialTolerance = Tag('Overall Template Spatial Tolerance', "OverallTemplateSpatialTolerance", 0x0068, 0x62A5)
    HPGLDocumentID = Tag('HPGL Document ID', "HPGLDocumentID", 0x0068, 0x62D0, [TagLink(HPGLDocumentSequence),])
    HPGLDocumentLabel = Tag('HPGL Document Label', "HPGLDocumentLabel", 0x0068, 0x62D5, [TagLink(HPGLDocumentSequence),])
    HPGLDocumentScaling = Tag('HPGL Document Scaling', "HPGLDocumentScaling", 0x0068, 0x62F2, [TagLink(HPGLDocumentSequence),])
    HPGLDocument = Tag('HPGL Document', "HPGLDocument", 0x0068, 0x6300, [TagLink(HPGLDocumentSequence),])
    HPGLContourPenNumber = Tag('HPGL Contour Pen Number', "HPGLContourPenNumber", 0x0068, 0x6310, [TagLink(HPGLDocumentSequence),])
    HPGLPenSequence = Tag('HPGL Pen Sequence', "HPGLPenSequence", 0x0068, 0x6320, [TagLink(HPGLDocumentSequence),])
    HPGLPenNumber = Tag('HPGL Pen Number', "HPGLPenNumber", 0x0068, 0x6330, [TagLink(HPGLPenSequence),])
    HPGLPenLabel = Tag('HPGL Pen Label', "HPGLPenLabel", 0x0068, 0x6340, [TagLink(HPGLPenSequence),])
    HPGLPenDescription = Tag('HPGL Pen Description', "HPGLPenDescription", 0x0068, 0x6345, [TagLink(HPGLPenSequence),])
    RecommendedRotationPoint = Tag('Recommended Rotation Point', "RecommendedRotationPoint", 0x0068, 0x6346, [TagLink(HPGLDocumentSequence),])
    BoundingRectangle = Tag('Bounding Rectangle', "BoundingRectangle", 0x0068, 0x6347, [TagLink(HPGLDocumentSequence),])
    ImplantTemplate3DModelSurfaceNumber = Tag('Implant Template 3D Model Surface Number', "ImplantTemplate3DModelSurfaceNumber", 0x0068, 0x6350)
    SurfaceModelLabel = Tag('Surface Model Label', "SurfaceModelLabel", 0x0068, 0x6380, [TagLink(SurfaceModelDescriptionSequence),])
    SurfaceModelScalingFactor = Tag('Surface Model Scaling Factor', "SurfaceModelScalingFactor", 0x0068, 0x6390)
    MatingFeatureSetsSequence = Tag('Mating Feature Sets Sequence', "MatingFeatureSetsSequence", 0x0068, 0x63B0)
    MatingFeatureSetID = Tag('Mating Feature Set ID', "MatingFeatureSetID", 0x0068, 0x63C0, [TagLink(MatingFeatureSetsSequence),])
    MatingFeatureSetLabel = Tag('Mating Feature Set Label', "MatingFeatureSetLabel", 0x0068, 0x63D0, [TagLink(MatingFeatureSetsSequence),])
    MatingFeatureSequence = Tag('Mating Feature Sequence', "MatingFeatureSequence", 0x0068, 0x63E0, [TagLink(MatingFeatureSetsSequence),])
    MatingFeatureID = Tag('Mating Feature ID', "MatingFeatureID", 0x0068, 0x63F0, [TagLink(MatingFeatureSequence),])
    MatingFeatureDegreeOfFreedomSequence = Tag('Mating Feature Degree of Freedom Sequence', "MatingFeatureDegreeOfFreedomSequence", 0x0068, 0x6400, [TagLink(MatingFeatureSequence),])
    DegreeOfFreedomID = Tag('Degree of Freedom ID', "DegreeOfFreedomID", 0x0068, 0x6410, [TagLink(MatingFeatureDegreeOfFreedomSequence),])
    DegreeOfFreedomType = Tag('Degree of Freedom Type', "DegreeOfFreedomType", 0x0068, 0x6420, [TagLink(MatingFeatureDegreeOfFreedomSequence),])
    TwoDMatingFeatureCoordinatesSequence = Tag('2D Mating Feature Coordinates Sequence', "TwoDMatingFeatureCoordinatesSequence", 0x0068, 0x6430, [TagLink(MatingFeatureSequence),])
    TwoDDegreeOfFreedomSequence = Tag('2D Degree of Freedom Sequence', "TwoDDegreeOfFreedomSequence", 0x0068, 0x6470, [TagLink(MatingFeatureDegreeOfFreedomSequence),])
    TwoDPointCoordinatesSequence = Tag('2D Point Coordinates Sequence', "TwoDPointCoordinatesSequence", 0x0068, 0x6550)
    TwoDLineCoordinatesSequence = Tag('2D Line Coordinates Sequence', "TwoDLineCoordinatesSequence", 0x0068, 0x65A0)
    TwoDPlaneCoordinatesSequence = Tag('2D Plane Coordinates Sequence', "TwoDPlaneCoordinatesSequence", 0x0068, 0x65E0)
    ImplantTemplateGroupMemberMatching2DCoordinatesSequence = Tag('Implant Template Group Member Matching 2D Coordinates Sequence', "ImplantTemplateGroupMemberMatching2DCoordinatesSequence", 0x0078, 0x0070, [TagLink(ImplantTemplateGroupMembersSequence),])
    ReferencedHPGLDocumentID = Tag('Referenced HPGL Document ID', "ReferencedHPGLDocumentID", 0x0068, 0x6440, [TagLink(TwoDMatingFeatureCoordinatesSequence),TagLink(TwoDDegreeOfFreedomSequence),TagLink(TwoDPointCoordinatesSequence),TagLink(TwoDLineCoordinatesSequence),TagLink(TwoDPlaneCoordinatesSequence),TagLink(ImplantTemplateGroupMemberMatching2DCoordinatesSequence),])
    TwoDMatingPoint = Tag('2D Mating Point', "TwoDMatingPoint", 0x0068, 0x6450, [TagLink(TwoDMatingFeatureCoordinatesSequence),])
    TwoDMatingAxes = Tag('2D Mating Axes', "TwoDMatingAxes", 0x0068, 0x6460, [TagLink(TwoDMatingFeatureCoordinatesSequence),])
    ThreeDDegreeOfFreedomAxis = Tag('3D Degree of Freedom Axis', "ThreeDDegreeOfFreedomAxis", 0x0068, 0x6490, [TagLink(MatingFeatureDegreeOfFreedomSequence),])
    RangeOfFreedom = Tag('Range of Freedom', "RangeOfFreedom", 0x0068, 0x64A0, [TagLink(TwoDDegreeOfFreedomSequence),TagLink(MatingFeatureDegreeOfFreedomSequence),])
    ThreeDMatingPoint = Tag('3D Mating Point', "ThreeDMatingPoint", 0x0068, 0x64C0, [TagLink(MatingFeatureSequence),])
    ThreeDMatingAxes = Tag('3D Mating Axes', "ThreeDMatingAxes", 0x0068, 0x64D0, [TagLink(MatingFeatureSequence),])
    TwoDDegreeOfFreedomAxis = Tag('2D Degree of Freedom Axis', "TwoDDegreeOfFreedomAxis", 0x0068, 0x64F0, [TagLink(TwoDDegreeOfFreedomSequence),])
    PlanningLandmarkID = Tag('Planning Landmark ID', "PlanningLandmarkID", 0x0068, 0x6530, [TagLink(PlanningLandmarkPointSequence),TagLink(PlanningLandmarkLineSequence),TagLink(PlanningLandmarkPlaneSequence),])
    PlanningLandmarkDescription = Tag('Planning Landmark Description', "PlanningLandmarkDescription", 0x0068, 0x6540, [TagLink(PlanningLandmarkPointSequence),TagLink(PlanningLandmarkLineSequence),TagLink(PlanningLandmarkPlaneSequence),])
    TwoDPointCoordinates = Tag('2D Point Coordinates', "TwoDPointCoordinates", 0x0068, 0x6560, [TagLink(TwoDPointCoordinatesSequence),])
    ThreeDPointCoordinates = Tag('3D Point Coordinates', "ThreeDPointCoordinates", 0x0068, 0x6590, [TagLink(PatientLocationCoordinatesSequence),TagLink(EquipmentReferencePointCoordinatesSequence),])
    TwoDLineCoordinates = Tag('2D Line Coordinates', "TwoDLineCoordinates", 0x0068, 0x65B0, [TagLink(TwoDLineCoordinatesSequence),])
    ThreeDLineCoordinates = Tag('3D Line Coordinates', "ThreeDLineCoordinates", 0x0068, 0x65D0)
    TwoDPlaneIntersection = Tag('2D Plane Intersection', "TwoDPlaneIntersection", 0x0068, 0x65F0, [TagLink(TwoDPlaneCoordinatesSequence),])
    ThreeDPlaneOrigin = Tag('3D Plane Origin', "ThreeDPlaneOrigin", 0x0068, 0x6610)
    ThreeDPlaneNormal = Tag('3D Plane Normal', "ThreeDPlaneNormal", 0x0068, 0x6620)
    ModelModification = Tag('Model Modification', "ModelModification", 0x0068, 0x7001)
    ModelMirroring = Tag('Model Mirroring', "ModelMirroring", 0x0068, 0x7002)
    ModelGroupUID = Tag('Model Group UID', "ModelGroupUID", 0x0068, 0x7004)
    RelativeURIReferenceWithinEncapsulatedDocument = Tag('Relative URI Reference Within Encapsulated Document', "RelativeURIReferenceWithinEncapsulatedDocument", 0x0068, 0x7005, [TagLink(ReferencedImageSequence),TagLink(ReferencedInstanceSequence),])
    AnnotationCoordinateType = Tag('Annotation Coordinate Type', "AnnotationCoordinateType", 0x006A, 0x0001)
    AnnotationGroupUID = Tag('Annotation Group UID', "AnnotationGroupUID", 0x006A, 0x0003, [TagLink(AnnotationGroupSequence),])
    AnnotationGroupLabel = Tag('Annotation Group Label', "AnnotationGroupLabel", 0x006A, 0x0005, [TagLink(AnnotationGroupSequence),])
    AnnotationGroupDescription = Tag('Annotation Group Description', "AnnotationGroupDescription", 0x006A, 0x0006, [TagLink(AnnotationGroupSequence),])
    AnnotationGroupGenerationType = Tag('Annotation Group Generation Type', "AnnotationGroupGenerationType", 0x006A, 0x0007, [TagLink(AnnotationGroupSequence),])
    NumberOfAnnotations = Tag('Number of Annotations', "NumberOfAnnotations", 0x006A, 0x000C, [TagLink(AnnotationGroupSequence),])
    AnnotationAppliesToAllOpticalPaths = Tag('Annotation Applies to All Optical Paths', "AnnotationAppliesToAllOpticalPaths", 0x006A, 0x000D, [TagLink(AnnotationGroupSequence),])
    ReferencedOpticalPathIdentifier = Tag('Referenced Optical Path Identifier', "ReferencedOpticalPathIdentifier", 0x006A, 0x000E, [TagLink(ReferencedImageSequence),TagLink(AnnotationGroupSequence),])
    AnnotationAppliesToAllZPlanes = Tag('Annotation Applies to All Z Planes', "AnnotationAppliesToAllZPlanes", 0x006A, 0x000F, [TagLink(AnnotationGroupSequence),])
    CommonZCoordinateValue = Tag('Common Z Coordinate Value', "CommonZCoordinateValue", 0x006A, 0x0010, [TagLink(AnnotationGroupSequence),])
    AnnotationIndexList = Tag('Annotation Index List', "AnnotationIndexList", 0x006A, 0x0011, [TagLink(MeasurementValuesSequence),])
    GraphicLayerSequence = Tag('Graphic Layer Sequence', "GraphicLayerSequence", 0x0070, 0x0060)
    GraphicLayer = Tag('Graphic Layer', "GraphicLayer", 0x0070, 0x0002, [TagLink(GraphicAnnotationSequence),TagLink(GraphicLayerSequence),TagLink(VolumetricAnnotationSequence),TagLink(VolumetricPresentationInputAnnotationSequence),])
    BoundingBoxAnnotationUnits = Tag('Bounding Box Annotation Units', "BoundingBoxAnnotationUnits", 0x0070, 0x0003, [TagLink(TextObjectSequence),])
    AnchorPointAnnotationUnits = Tag('Anchor Point Annotation Units', "AnchorPointAnnotationUnits", 0x0070, 0x0004, [TagLink(TextObjectSequence),])
    GraphicAnnotationUnits = Tag('Graphic Annotation Units', "GraphicAnnotationUnits", 0x0070, 0x0005, [TagLink(GraphicObjectSequence),])
    StructuredDisplayTextBoxSequence = Tag('Structured Display Text Box Sequence', "StructuredDisplayTextBoxSequence", 0x0072, 0x0424)
    UnformattedTextValue = Tag('Unformatted Text Value', "UnformattedTextValue", 0x0070, 0x0006, [TagLink(TextObjectSequence),TagLink(WaveformAnnotationSequence),TagLink(StructuredDisplayTextBoxSequence),TagLink(ReferencedMontageIndex),])
    BoundingBoxTopLeftHandCorner = Tag('Bounding Box Top Left Hand Corner', "BoundingBoxTopLeftHandCorner", 0x0070, 0x0010, [TagLink(TextObjectSequence),])
    BoundingBoxBottomRightHandCorner = Tag('Bounding Box Bottom Right Hand Corner', "BoundingBoxBottomRightHandCorner", 0x0070, 0x0011, [TagLink(TextObjectSequence),])
    BoundingBoxTextHorizontalJustification = Tag('Bounding Box Text Horizontal Justification', "BoundingBoxTextHorizontalJustification", 0x0070, 0x0012, [TagLink(TextObjectSequence),TagLink(StructuredDisplayTextBoxSequence),])
    AnchorPoint = Tag('Anchor Point', "AnchorPoint", 0x0070, 0x0014, [TagLink(TextObjectSequence),])
    AnchorPointVisibility = Tag('Anchor Point Visibility', "AnchorPointVisibility", 0x0070, 0x0015, [TagLink(TextObjectSequence),])
    CompoundGraphicSequence = Tag('Compound Graphic Sequence', "CompoundGraphicSequence", 0x0070, 0x0209, [TagLink(GraphicAnnotationSequence),])
    GraphicDimensions = Tag('Graphic Dimensions', "GraphicDimensions", 0x0070, 0x0020, [TagLink(GraphicObjectSequence),TagLink(CompoundGraphicSequence),])
    NumberOfGraphicPoints = Tag('Number of Graphic Points', "NumberOfGraphicPoints", 0x0070, 0x0021, [TagLink(GraphicObjectSequence),TagLink(CompoundGraphicSequence),])
    GraphicData = Tag('Graphic Data', "GraphicData", 0x0070, 0x0022, [TagLink(GraphicObjectSequence),TagLink(CompoundGraphicSequence),TagLink(VolumetricAnnotationSequence),TagLink(GraphicCoordinatesDataSequence),TagLink(ContentSequence),])
    GraphicType = Tag('Graphic Type', "GraphicType", 0x0070, 0x0023, [TagLink(GraphicObjectSequence),TagLink(VolumetricAnnotationSequence),TagLink(ContentSequence),TagLink(AnnotationGroupSequence),])
    GraphicFilled = Tag('Graphic Filled', "GraphicFilled", 0x0070, 0x0024, [TagLink(GraphicObjectSequence),TagLink(CompoundGraphicSequence),])
    ImageRotationRetired = Tag('Image Rotation (Retired)', "ImageRotationRetired", 0x0070, 0x0040)
    ImageHorizontalFlip = Tag('Image Horizontal Flip', "ImageHorizontalFlip", 0x0070, 0x0041, [TagLink(ReconstructionProtocolElementSequence),])
    ImageRotation = Tag('Image Rotation', "ImageRotation", 0x0070, 0x0042, [TagLink(ReconstructionProtocolElementSequence),])
    DisplayedAreaTopLeftHandCornerTrial = Tag('Displayed Area Top Left Hand Corner (Trial)', "DisplayedAreaTopLeftHandCornerTrial", 0x0070, 0x0050)
    DisplayedAreaBottomRightHandCornerTrial = Tag('Displayed Area Bottom Right Hand Corner (Trial)', "DisplayedAreaBottomRightHandCornerTrial", 0x0070, 0x0051)
    DisplayedAreaTopLeftHandCorner = Tag('Displayed Area Top Left Hand Corner', "DisplayedAreaTopLeftHandCorner", 0x0070, 0x0052, [TagLink(DisplayedAreaSelectionSequence),])
    DisplayedAreaBottomRightHandCorner = Tag('Displayed Area Bottom Right Hand Corner', "DisplayedAreaBottomRightHandCorner", 0x0070, 0x0053, [TagLink(DisplayedAreaSelectionSequence),])
    GraphicLayerOrder = Tag('Graphic Layer Order', "GraphicLayerOrder", 0x0070, 0x0062, [TagLink(GraphicLayerSequence),])
    GraphicLayerRecommendedDisplayGrayscaleValue = Tag('Graphic Layer Recommended Display Grayscale Value', "GraphicLayerRecommendedDisplayGrayscaleValue", 0x0070, 0x0066, [TagLink(GraphicLayerSequence),])
    GraphicLayerRecommendedDisplayRGBValue = Tag('Graphic Layer Recommended Display RGB Value', "GraphicLayerRecommendedDisplayRGBValue", 0x0070, 0x0067)
    GraphicLayerDescription = Tag('Graphic Layer Description', "GraphicLayerDescription", 0x0070, 0x0068, [TagLink(GraphicLayerSequence),])
    ContentLabel = Tag('Content Label', "ContentLabel", 0x0070, 0x0080, [TagLink(InventoriedInstancesSequence),])
    ContentDescription = Tag('Content Description', "ContentDescription", 0x0070, 0x0081, [TagLink(AlternateContentDescriptionSequence),TagLink(InventoriedInstancesSequence),])
    PresentationCreationDate = Tag('Presentation Creation Date', "PresentationCreationDate", 0x0070, 0x0082, [TagLink(InventoriedInstancesSequence),])
    PresentationCreationTime = Tag('Presentation Creation Time', "PresentationCreationTime", 0x0070, 0x0083, [TagLink(InventoriedInstancesSequence),])
    ContentCreatorName = Tag("Content Creator's Name", "ContentCreatorName", 0x0070, 0x0084, [TagLink(SegmentSequence),TagLink(InventoriedInstancesSequence),])
    PresentationSizeMode = Tag('Presentation Size Mode', "PresentationSizeMode", 0x0070, 0x0100, [TagLink(DisplayedAreaSelectionSequence),])
    PresentationPixelSpacing = Tag('Presentation Pixel Spacing', "PresentationPixelSpacing", 0x0070, 0x0101, [TagLink(DisplayedAreaSelectionSequence),])
    PresentationPixelAspectRatio = Tag('Presentation Pixel Aspect Ratio', "PresentationPixelAspectRatio", 0x0070, 0x0102, [TagLink(DisplayedAreaSelectionSequence),])
    PresentationPixelMagnificationRatio = Tag('Presentation Pixel Magnification Ratio', "PresentationPixelMagnificationRatio", 0x0070, 0x0103, [TagLink(DisplayedAreaSelectionSequence),])
    GraphicGroupSequence = Tag('Graphic Group Sequence', "GraphicGroupSequence", 0x0070, 0x0234)
    GraphicGroupLabel = Tag('Graphic Group Label', "GraphicGroupLabel", 0x0070, 0x0207, [TagLink(GraphicGroupSequence),])
    GraphicGroupDescription = Tag('Graphic Group Description', "GraphicGroupDescription", 0x0070, 0x0208, [TagLink(GraphicGroupSequence),])
    CompoundGraphicInstanceID = Tag('Compound Graphic Instance ID', "CompoundGraphicInstanceID", 0x0070, 0x0226, [TagLink(TextObjectSequence),TagLink(GraphicObjectSequence),TagLink(CompoundGraphicSequence),])
    TextStyleSequence = Tag('Text Style Sequence', "TextStyleSequence", 0x0070, 0x0231)
    FontName = Tag('Font Name', "FontName", 0x0070, 0x0227, [TagLink(TextStyleSequence),])
    FontNameType = Tag('Font Name Type', "FontNameType", 0x0070, 0x0228, [TagLink(TextStyleSequence),])
    CSSFontName = Tag('CSS Font Name', "CSSFontName", 0x0070, 0x0229, [TagLink(TextStyleSequence),])
    RotationAngle = Tag('Rotation Angle', "RotationAngle", 0x0070, 0x0230, [TagLink(CompoundGraphicSequence),])
    LineStyleSequence = Tag('Line Style Sequence', "LineStyleSequence", 0x0070, 0x0232)
    FillStyleSequence = Tag('Fill Style Sequence', "FillStyleSequence", 0x0070, 0x0233)
    TextColorCIELabValue = Tag('Text Color CIELab Value', "TextColorCIELabValue", 0x0070, 0x0241, [TagLink(TextStyleSequence),TagLink(WaveformAnnotationDisplaySelectionSequence),TagLink(ReferencedMontageIndex),])
    HorizontalAlignment = Tag('Horizontal Alignment', "HorizontalAlignment", 0x0070, 0x0242, [TagLink(TextStyleSequence),])
    VerticalAlignment = Tag('Vertical Alignment', "VerticalAlignment", 0x0070, 0x0243, [TagLink(TextStyleSequence),])
    ShadowStyle = Tag('Shadow Style', "ShadowStyle", 0x0070, 0x0244, [TagLink(TextStyleSequence),TagLink(LineStyleSequence),])
    ShadowOffsetX = Tag('Shadow Offset X', "ShadowOffsetX", 0x0070, 0x0245, [TagLink(TextStyleSequence),TagLink(LineStyleSequence),])
    ShadowOffsetY = Tag('Shadow Offset Y', "ShadowOffsetY", 0x0070, 0x0246, [TagLink(TextStyleSequence),TagLink(LineStyleSequence),])
    ShadowColorCIELabValue = Tag('Shadow Color CIELab Value', "ShadowColorCIELabValue", 0x0070, 0x0247, [TagLink(TextStyleSequence),TagLink(LineStyleSequence),])
    Underlined = Tag('Underlined', "Underlined", 0x0070, 0x0248, [TagLink(TextStyleSequence),])
    Bold = Tag('Bold', "Bold", 0x0070, 0x0249, [TagLink(TextStyleSequence),])
    Italic = Tag('Italic', "Italic", 0x0070, 0x0250, [TagLink(TextStyleSequence),])
    PatternOnColorCIELabValue = Tag('Pattern On Color CIELab Value', "PatternOnColorCIELabValue", 0x0070, 0x0251, [TagLink(LineStyleSequence),TagLink(FillStyleSequence),])
    PatternOffColorCIELabValue = Tag('Pattern Off Color CIELab Value', "PatternOffColorCIELabValue", 0x0070, 0x0252, [TagLink(LineStyleSequence),TagLink(FillStyleSequence),])
    LineThickness = Tag('Line Thickness', "LineThickness", 0x0070, 0x0253, [TagLink(LineStyleSequence),])
    LineDashingStyle = Tag('Line Dashing Style', "LineDashingStyle", 0x0070, 0x0254, [TagLink(LineStyleSequence),])
    LinePattern = Tag('Line Pattern', "LinePattern", 0x0070, 0x0255, [TagLink(LineStyleSequence),])
    FillPattern = Tag('Fill Pattern', "FillPattern", 0x0070, 0x0256, [TagLink(FillStyleSequence),])
    FillMode = Tag('Fill Mode', "FillMode", 0x0070, 0x0257, [TagLink(FillStyleSequence),])
    ShadowOpacity = Tag('Shadow Opacity', "ShadowOpacity", 0x0070, 0x0258, [TagLink(TextStyleSequence),TagLink(LineStyleSequence),])
    GapLength = Tag('Gap Length', "GapLength", 0x0070, 0x0261, [TagLink(CompoundGraphicSequence),])
    DiameterOfVisibility = Tag('Diameter of Visibility', "DiameterOfVisibility", 0x0070, 0x0262, [TagLink(CompoundGraphicSequence),])
    RotationPoint = Tag('Rotation Point', "RotationPoint", 0x0070, 0x0273, [TagLink(CompoundGraphicSequence),])
    TickAlignment = Tag('Tick Alignment', "TickAlignment", 0x0070, 0x0274, [TagLink(CompoundGraphicSequence),])
    ShowTickLabel = Tag('Show Tick Label', "ShowTickLabel", 0x0070, 0x0278, [TagLink(CompoundGraphicSequence),])
    TickLabelAlignment = Tag('Tick Label Alignment', "TickLabelAlignment", 0x0070, 0x0279, [TagLink(CompoundGraphicSequence),])
    CompoundGraphicUnits = Tag('Compound Graphic Units', "CompoundGraphicUnits", 0x0070, 0x0282, [TagLink(CompoundGraphicSequence),])
    PatternOnOpacity = Tag('Pattern On Opacity', "PatternOnOpacity", 0x0070, 0x0284, [TagLink(LineStyleSequence),TagLink(FillStyleSequence),])
    PatternOffOpacity = Tag('Pattern Off Opacity', "PatternOffOpacity", 0x0070, 0x0285, [TagLink(LineStyleSequence),TagLink(FillStyleSequence),])
    MajorTicksSequence = Tag('Major Ticks Sequence', "MajorTicksSequence", 0x0070, 0x0287, [TagLink(CompoundGraphicSequence),])
    TickPosition = Tag('Tick Position', "TickPosition", 0x0070, 0x0288, [TagLink(MajorTicksSequence),])
    TickLabel = Tag('Tick Label', "TickLabel", 0x0070, 0x0289, [TagLink(MajorTicksSequence),])
    CompoundGraphicType = Tag('Compound Graphic Type', "CompoundGraphicType", 0x0070, 0x0294, [TagLink(CompoundGraphicSequence),])
    GraphicGroupID = Tag('Graphic Group ID', "GraphicGroupID", 0x0070, 0x0295, [TagLink(TextObjectSequence),TagLink(GraphicObjectSequence),TagLink(CompoundGraphicSequence),TagLink(GraphicGroupSequence),])
    ShapeType = Tag('Shape Type', "ShapeType", 0x0070, 0x0306, [TagLink(FiducialSequence),])
    MatrixSequence = Tag('Matrix Sequence', "MatrixSequence", 0x0070, 0x030A, [TagLink(MatrixRegistrationSequence),])
    FrameOfReferenceToDisplayedCoordinateSystemTransformationMatrix = Tag('Frame of Reference to Displayed Coordinate System Transformation Matrix', "FrameOfReferenceToDisplayedCoordinateSystemTransformationMatrix", 0x0070, 0x030B)
    FrameOfReferenceTransformationMatrixType = Tag('Frame of Reference Transformation Matrix Type', "FrameOfReferenceTransformationMatrixType", 0x0070, 0x030C, [TagLink(MatrixSequence),TagLink(PreDeformationMatrixRegistrationSequence),TagLink(PostDeformationMatrixRegistrationSequence),])
    FiducialDescription = Tag('Fiducial Description', "FiducialDescription", 0x0070, 0x030F, [TagLink(FiducialSequence),])
    FiducialIdentifier = Tag('Fiducial Identifier', "FiducialIdentifier", 0x0070, 0x0310, [TagLink(FiducialSequence),])
    ContourUncertaintyRadius = Tag('Contour Uncertainty Radius', "ContourUncertaintyRadius", 0x0070, 0x0312, [TagLink(FiducialSequence),])
    FiducialUID = Tag('Fiducial UID', "FiducialUID", 0x0070, 0x031A, [TagLink(UsedFiducialsSequence),TagLink(FiducialSequence),TagLink(ContentSequence),])
    ReferencedFiducialUID = Tag('Referenced Fiducial UID', "ReferencedFiducialUID", 0x0070, 0x031B, [TagLink(DefinitionSourceSequence),])
    GraphicLayerRecommendedDisplayCIELabValue = Tag('Graphic Layer Recommended Display CIELab Value', "GraphicLayerRecommendedDisplayCIELabValue", 0x0070, 0x0401, [TagLink(GraphicLayerSequence),TagLink(StructuredDisplayTextBoxSequence),])
    BlendingDisplaySequence = Tag('Blending Display Sequence', "BlendingDisplaySequence", 0x0070, 0x1B04)
    RelativeOpacity = Tag('Relative Opacity', "RelativeOpacity", 0x0070, 0x0403, [TagLink(BlendingDisplaySequence),])
    BlendingPosition = Tag('Blending Position', "BlendingPosition", 0x0070, 0x0405, [TagLink(BlendingSequence),])
    PresentationDisplayCollectionUID = Tag('Presentation Display Collection UID', "PresentationDisplayCollectionUID", 0x0070, 0x1101)
    PresentationSequenceCollectionUID = Tag('Presentation Sequence Collection UID', "PresentationSequenceCollectionUID", 0x0070, 0x1102)
    PresentationSequencePositionIndex = Tag('Presentation Sequence Position Index', "PresentationSequencePositionIndex", 0x0070, 0x1103)
    PresentationInputType = Tag('Presentation Input Type', "PresentationInputType", 0x0070, 0x1202, [TagLink(VolumetricPresentationInputSetSequence),])
    InputSequencePositionIndex = Tag('Input Sequence Position Index', "InputSequencePositionIndex", 0x0070, 0x1203, [TagLink(VolumetricPresentationStateInputSequence),])
    Crop = Tag('Crop', "Crop", 0x0070, 0x1204, [TagLink(VolumetricPresentationStateInputSequence),])
    CroppingSpecificationIndex = Tag('Cropping Specification Index', "CroppingSpecificationIndex", 0x0070, 0x1205, [TagLink(VolumetricPresentationStateInputSequence),])
    CompositingMethod = Tag('Compositing Method', "CompositingMethod", 0x0070, 0x1206)
    VolumetricPresentationInputNumber = Tag('Volumetric Presentation Input Number', "VolumetricPresentationInputNumber", 0x0070, 0x1207, [TagLink(VolumetricPresentationStateInputSequence),])
    ImageVolumeGeometry = Tag('Image Volume Geometry', "ImageVolumeGeometry", 0x0070, 0x1208)
    VolumetricPresentationInputSetUID = Tag('Volumetric Presentation Input Set UID', "VolumetricPresentationInputSetUID", 0x0070, 0x1209, [TagLink(VolumetricPresentationInputSetSequence),TagLink(VolumetricPresentationStateInputSequence),TagLink(VolumeStreamSequence),])
    GlobalCrop = Tag('Global Crop', "GlobalCrop", 0x0070, 0x120B)
    GlobalCroppingSpecificationIndex = Tag('Global Cropping Specification Index', "GlobalCroppingSpecificationIndex", 0x0070, 0x120C)
    RenderingMethod = Tag('Rendering Method', "RenderingMethod", 0x0070, 0x120D, [TagLink(VolumetricPresentationStateInputSequence),])
    VolumeCroppingMethod = Tag('Volume Cropping Method', "VolumeCroppingMethod", 0x0070, 0x1302, [TagLink(VolumeCroppingSequence),])
    BoundingBoxCrop = Tag('Bounding Box Crop', "BoundingBoxCrop", 0x0070, 0x1303, [TagLink(VolumeCroppingSequence),])
    ObliqueCroppingPlaneSequence = Tag('Oblique Cropping Plane Sequence', "ObliqueCroppingPlaneSequence", 0x0070, 0x1304, [TagLink(VolumeCroppingSequence),])
    Plane = Tag('Plane', "Plane", 0x0070, 0x1305, [TagLink(ObliqueCroppingPlaneSequence),])
    PlaneNormal = Tag('Plane Normal', "PlaneNormal", 0x0070, 0x1306, [TagLink(ObliqueCroppingPlaneSequence),])
    CroppingSpecificationNumber = Tag('Cropping Specification Number', "CroppingSpecificationNumber", 0x0070, 0x1309, [TagLink(VolumeCroppingSequence),])
    MultiPlanarReconstructionStyle = Tag('Multi-Planar Reconstruction Style', "MultiPlanarReconstructionStyle", 0x0070, 0x1501)
    MPRThicknessType = Tag('MPR Thickness Type', "MPRThicknessType", 0x0070, 0x1502)
    MPRSlabThickness = Tag('MPR Slab Thickness', "MPRSlabThickness", 0x0070, 0x1503)
    MPRTopLeftHandCorner = Tag('MPR Top Left Hand Corner', "MPRTopLeftHandCorner", 0x0070, 0x1505)
    MPRViewWidthDirection = Tag('MPR View Width Direction', "MPRViewWidthDirection", 0x0070, 0x1507)
    MPRViewWidth = Tag('MPR View Width', "MPRViewWidth", 0x0070, 0x1508)
    AnimationCurveSequence = Tag('Animation Curve Sequence', "AnimationCurveSequence", 0x0070, 0x1A04)
    NumberOfVolumetricCurvePoints = Tag('Number of Volumetric Curve Points', "NumberOfVolumetricCurvePoints", 0x0070, 0x150C, [TagLink(AnimationCurveSequence),])
    VolumetricCurvePoints = Tag('Volumetric Curve Points', "VolumetricCurvePoints", 0x0070, 0x150D, [TagLink(AnimationCurveSequence),])
    MPRViewHeightDirection = Tag('MPR View Height Direction', "MPRViewHeightDirection", 0x0070, 0x1511)
    MPRViewHeight = Tag('MPR View Height', "MPRViewHeight", 0x0070, 0x1512)
    RenderProjection = Tag('Render Projection', "RenderProjection", 0x0070, 0x1602, [TagLink(CameraPositionGroupSequence),])
    ViewpointPosition = Tag('Viewpoint Position', "ViewpointPosition", 0x0070, 0x1603, [TagLink(CameraPositionGroupSequence),])
    ViewpointLookAtPoint = Tag('Viewpoint LookAt Point', "ViewpointLookAtPoint", 0x0070, 0x1604, [TagLink(CameraPositionGroupSequence),])
    ViewpointUpDirection = Tag('Viewpoint Up Direction', "ViewpointUpDirection", 0x0070, 0x1605, [TagLink(CameraPositionGroupSequence),])
    RenderFieldOfView = Tag('Render Field of View', "RenderFieldOfView", 0x0070, 0x1606, [TagLink(CameraPositionGroupSequence),])
    SamplingStepSize = Tag('Sampling Step Size', "SamplingStepSize", 0x0070, 0x1607)
    ShadingStyle = Tag('Shading Style', "ShadingStyle", 0x0070, 0x1701)
    AmbientReflectionIntensity = Tag('Ambient Reflection Intensity', "AmbientReflectionIntensity", 0x0070, 0x1702)
    LightDirection = Tag('Light Direction', "LightDirection", 0x0070, 0x1703)
    DiffuseReflectionIntensity = Tag('Diffuse Reflection Intensity', "DiffuseReflectionIntensity", 0x0070, 0x1704)
    SpecularReflectionIntensity = Tag('Specular Reflection Intensity', "SpecularReflectionIntensity", 0x0070, 0x1705)
    Shininess = Tag('Shininess', "Shininess", 0x0070, 0x1706)
    ComponentType = Tag('Component Type', "ComponentType", 0x0070, 0x1802, [TagLink(PresentationStateClassificationComponentSequence),])
    VolumetricPresentationInputIndex = Tag('Volumetric Presentation Input Index', "VolumetricPresentationInputIndex", 0x0070, 0x1804, [TagLink(ComponentInputSequence),TagLink(VolumetricPresentationInputAnnotationSequence),])
    WeightingLookupTableDescriptor = Tag('Weighting Lookup Table Descriptor', "WeightingLookupTableDescriptor", 0x0070, 0x1807)
    WeightingLookupTableData = Tag('Weighting Lookup Table Data', "WeightingLookupTableData", 0x0070, 0x1808)
    ReferencedContentItem = Tag('Referenced Content Item', "ReferencedContentItem", 0x0070, 0x1904, [TagLink(ReferencedStructuredContextSequence),])
    AnnotationClipping = Tag('Annotation Clipping', "AnnotationClipping", 0x0070, 0x1907, [TagLink(VolumetricAnnotationSequence),])
    PresentationAnimationStyle = Tag('Presentation Animation Style', "PresentationAnimationStyle", 0x0070, 0x1A01)
    RecommendedAnimationRate = Tag('Recommended Animation Rate', "RecommendedAnimationRate", 0x0070, 0x1A03)
    AnimationStepSize = Tag('Animation Step Size', "AnimationStepSize", 0x0070, 0x1A05)
    SwivelRange = Tag('Swivel Range', "SwivelRange", 0x0070, 0x1A06)
    VolumetricCurveUpDirections = Tag('Volumetric Curve Up Directions', "VolumetricCurveUpDirections", 0x0070, 0x1A07, [TagLink(AnimationCurveSequence),])
    RGBATransferFunctionDescription = Tag('RGBA Transfer Function Description', "RGBATransferFunctionDescription", 0x0070, 0x1A09, [TagLink(PresentationStateClassificationComponentSequence),])
    BlendingDisplayInputSequence = Tag('Blending Display Input Sequence', "BlendingDisplayInputSequence", 0x0070, 0x1B03, [TagLink(BlendingDisplaySequence),])
    BlendingInputNumber = Tag('Blending Input Number', "BlendingInputNumber", 0x0070, 0x1B02, [TagLink(AdvancedBlendingSequence),TagLink(BlendingDisplayInputSequence),TagLink(BlendingDisplaySequence),])
    BlendingMode = Tag('Blending Mode', "BlendingMode", 0x0070, 0x1B06, [TagLink(BlendingDisplaySequence),])
    TimeSeriesBlending = Tag('Time Series Blending', "TimeSeriesBlending", 0x0070, 0x1B07, [TagLink(AdvancedBlendingSequence),])
    GeometryForDisplay = Tag('Geometry for Display', "GeometryForDisplay", 0x0070, 0x1B08, [TagLink(AdvancedBlendingSequence),])
    ThresholdSequence = Tag('Threshold Sequence', "ThresholdSequence", 0x0070, 0x1B11)
    ThresholdValueSequence = Tag('Threshold Value Sequence', "ThresholdValueSequence", 0x0070, 0x1B12, [TagLink(ThresholdSequence),])
    ThresholdType = Tag('Threshold Type', "ThresholdType", 0x0070, 0x1B13, [TagLink(ThresholdSequence),])
    ThresholdValue = Tag('Threshold Value', "ThresholdValue", 0x0070, 0x1B14, [TagLink(ThresholdValueSequence),])
    HangingProtocolName = Tag('Hanging Protocol Name', "HangingProtocolName", 0x0072, 0x0002)
    HangingProtocolDescription = Tag('Hanging Protocol Description', "HangingProtocolDescription", 0x0072, 0x0004)
    HangingProtocolLevel = Tag('Hanging Protocol Level', "HangingProtocolLevel", 0x0072, 0x0006)
    HangingProtocolCreator = Tag('Hanging Protocol Creator', "HangingProtocolCreator", 0x0072, 0x0008)
    HangingProtocolCreationDateTime = Tag('Hanging Protocol Creation Date Time', "HangingProtocolCreationDateTime", 0x0072, 0x000A)
    HangingProtocolUserGroupName = Tag('Hanging Protocol User Group Name', "HangingProtocolUserGroupName", 0x0072, 0x0010)
    NumberOfPriorsReferenced = Tag('Number of Priors Referenced', "NumberOfPriorsReferenced", 0x0072, 0x0014)
    ImageSetSelectorSequence = Tag('Image Set Selector Sequence', "ImageSetSelectorSequence", 0x0072, 0x0022, [TagLink(ImageSetsSequence),])
    FilterOperationsSequence = Tag('Filter Operations Sequence', "FilterOperationsSequence", 0x0072, 0x0400, [TagLink(DisplaySetsSequence),])
    ImageSetSelectorUsageFlag = Tag('Image Set Selector Usage Flag', "ImageSetSelectorUsageFlag", 0x0072, 0x0024, [TagLink(ImageSetSelectorSequence),TagLink(FilterOperationsSequence),])
    OriginalAttributesSequence = Tag('Original Attributes Sequence', "OriginalAttributesSequence", 0x0400, 0x0561, [TagLink(InventoriedStudiesSequence),TagLink(InventoriedSeriesSequence),TagLink(InventoriedInstancesSequence),])
    NonconformingModifiedAttributesSequence = Tag('Nonconforming Modified Attributes Sequence', "NonconformingModifiedAttributesSequence", 0x0400, 0x0551, [TagLink(OriginalAttributesSequence),])
    SortingOperationsSequence = Tag('Sorting Operations Sequence', "SortingOperationsSequence", 0x0072, 0x0600, [TagLink(DisplaySetsSequence),])
    AttributeToleranceValuesSequence = Tag('Attribute Tolerance Values Sequence', "AttributeToleranceValuesSequence", 0x300A, 0x062B)
    TreatmentToleranceViolationAttributeSequence = Tag('Treatment Tolerance Violation Attribute Sequence', "TreatmentToleranceViolationAttributeSequence", 0x300A, 0x0733, [TagLink(TreatmentToleranceViolationSequence),])
    SelectorAttribute = Tag('Selector Attribute', "SelectorAttribute", 0x0072, 0x0026, [TagLink(NonconformingModifiedAttributesSequence),TagLink(ImageSetSelectorSequence),TagLink(FilterOperationsSequence),TagLink(SortingOperationsSequence),TagLink(StructuredConstraintObservationSequence),TagLink(PatientSpecificationSequence),TagLink(ParametersSpecificationSequence),TagLink(AttributeToleranceValuesSequence),TagLink(TreatmentToleranceViolationAttributeSequence),])
    SelectorValueNumber = Tag('Selector Value Number', "SelectorValueNumber", 0x0072, 0x0028, [TagLink(NonconformingModifiedAttributesSequence),TagLink(ImageSetSelectorSequence),TagLink(FilterOperationsSequence),TagLink(SortingOperationsSequence),TagLink(StructuredConstraintObservationSequence),TagLink(PatientSpecificationSequence),TagLink(ParametersSpecificationSequence),TagLink(AttributeToleranceValuesSequence),TagLink(TreatmentToleranceViolationAttributeSequence),])
    ImageSetNumber = Tag('Image Set Number', "ImageSetNumber", 0x0072, 0x0032, [TagLink(TimeBasedImageSetsSequence),TagLink(DisplaySetsSequence),])
    ImageSetSelectorCategory = Tag('Image Set Selector Category', "ImageSetSelectorCategory", 0x0072, 0x0034, [TagLink(TimeBasedImageSetsSequence),])
    RelativeTime = Tag('Relative Time', "RelativeTime", 0x0072, 0x0038, [TagLink(TimeBasedImageSetsSequence),])
    RelativeTimeUnits = Tag('Relative Time Units', "RelativeTimeUnits", 0x0072, 0x003A, [TagLink(TimeBasedImageSetsSequence),])
    AbstractPriorValue = Tag('Abstract Prior Value', "AbstractPriorValue", 0x0072, 0x003C, [TagLink(TimeBasedImageSetsSequence),])
    ImageSetLabel = Tag('Image Set Label', "ImageSetLabel", 0x0072, 0x0040, [TagLink(TimeBasedImageSetsSequence),])
    SelectorAttributeVR = Tag('Selector Attribute VR', "SelectorAttributeVR", 0x0072, 0x0050, [TagLink(CellValuesSequence),TagLink(ImageSetSelectorSequence),TagLink(FilterOperationsSequence),TagLink(StructuredConstraintObservationSequence),TagLink(PatientSpecificationSequence),TagLink(ParametersSpecificationSequence),TagLink(TreatmentToleranceViolationAttributeSequence),])
    SelectorSequencePointer = Tag('Selector Sequence Pointer', "SelectorSequencePointer", 0x0072, 0x0052, [TagLink(NonconformingModifiedAttributesSequence),TagLink(StructuredConstraintObservationSequence),TagLink(PatientSpecificationSequence),TagLink(ParametersSpecificationSequence),TagLink(AttributeToleranceValuesSequence),TagLink(TreatmentToleranceViolationAttributeSequence),])
    SelectorSequencePointerPrivateCreator = Tag('Selector Sequence Pointer Private Creator', "SelectorSequencePointerPrivateCreator", 0x0072, 0x0054, [TagLink(NonconformingModifiedAttributesSequence),TagLink(StructuredConstraintObservationSequence),TagLink(PatientSpecificationSequence),TagLink(ParametersSpecificationSequence),TagLink(AttributeToleranceValuesSequence),TagLink(TreatmentToleranceViolationAttributeSequence),])
    SelectorAttributePrivateCreator = Tag('Selector Attribute Private Creator', "SelectorAttributePrivateCreator", 0x0072, 0x0056, [TagLink(NonconformingModifiedAttributesSequence),TagLink(StructuredConstraintObservationSequence),TagLink(PatientSpecificationSequence),TagLink(ParametersSpecificationSequence),TagLink(AttributeToleranceValuesSequence),TagLink(TreatmentToleranceViolationAttributeSequence),])
    SelectorAEValue = Tag('Selector AE Value', "SelectorAEValue", 0x0072, 0x005E, [TagLink(AssessedAttributeValueSequence),])
    SelectorASValue = Tag('Selector AS Value', "SelectorASValue", 0x0072, 0x005F, [TagLink(AssessedAttributeValueSequence),])
    SelectorATValue = Tag('Selector AT Value', "SelectorATValue", 0x0072, 0x0060, [TagLink(AssessedAttributeValueSequence),])
    SelectorDAValue = Tag('Selector DA Value', "SelectorDAValue", 0x0072, 0x0061, [TagLink(AssessedAttributeValueSequence),])
    SelectorCSValue = Tag('Selector CS Value', "SelectorCSValue", 0x0072, 0x0062, [TagLink(AssessedAttributeValueSequence),])
    SelectorDTValue = Tag('Selector DT Value', "SelectorDTValue", 0x0072, 0x0063, [TagLink(CellValuesSequence),TagLink(AssessedAttributeValueSequence),])
    SelectorISValue = Tag('Selector IS Value', "SelectorISValue", 0x0072, 0x0064, [TagLink(CellValuesSequence),TagLink(AssessedAttributeValueSequence),])
    SelectorOBValue = Tag('Selector OB Value', "SelectorOBValue", 0x0072, 0x0065, [TagLink(AssessedAttributeValueSequence),])
    SelectorLOValue = Tag('Selector LO Value', "SelectorLOValue", 0x0072, 0x0066, [TagLink(AssessedAttributeValueSequence),])
    SelectorOFValue = Tag('Selector OF Value', "SelectorOFValue", 0x0072, 0x0067, [TagLink(AssessedAttributeValueSequence),])
    SelectorLTValue = Tag('Selector LT Value', "SelectorLTValue", 0x0072, 0x0068, [TagLink(AssessedAttributeValueSequence),])
    SelectorOWValue = Tag('Selector OW Value', "SelectorOWValue", 0x0072, 0x0069, [TagLink(AssessedAttributeValueSequence),])
    SelectorPNValue = Tag('Selector PN Value', "SelectorPNValue", 0x0072, 0x006A, [TagLink(AssessedAttributeValueSequence),])
    SelectorTMValue = Tag('Selector TM Value', "SelectorTMValue", 0x0072, 0x006B, [TagLink(AssessedAttributeValueSequence),])
    SelectorSHValue = Tag('Selector SH Value', "SelectorSHValue", 0x0072, 0x006C, [TagLink(AssessedAttributeValueSequence),])
    SelectorUNValue = Tag('Selector UN Value', "SelectorUNValue", 0x0072, 0x006D, [TagLink(AssessedAttributeValueSequence),])
    SelectorSTValue = Tag('Selector ST Value', "SelectorSTValue", 0x0072, 0x006E, [TagLink(AssessedAttributeValueSequence),])
    SelectorUCValue = Tag('Selector UC Value', "SelectorUCValue", 0x0072, 0x006F, [TagLink(CellValuesSequence),TagLink(AssessedAttributeValueSequence),])
    SelectorUTValue = Tag('Selector UT Value', "SelectorUTValue", 0x0072, 0x0070, [TagLink(AssessedAttributeValueSequence),])
    SelectorURValue = Tag('Selector UR Value', "SelectorURValue", 0x0072, 0x0071, [TagLink(AssessedAttributeValueSequence),])
    SelectorDSValue = Tag('Selector DS Value', "SelectorDSValue", 0x0072, 0x0072, [TagLink(CellValuesSequence),TagLink(AssessedAttributeValueSequence),])
    SelectorODValue = Tag('Selector OD Value', "SelectorODValue", 0x0072, 0x0073, [TagLink(AssessedAttributeValueSequence),])
    SelectorFDValue = Tag('Selector FD Value', "SelectorFDValue", 0x0072, 0x0074, [TagLink(CellValuesSequence),TagLink(AssessedAttributeValueSequence),])
    SelectorOLValue = Tag('Selector OL Value', "SelectorOLValue", 0x0072, 0x0075, [TagLink(AssessedAttributeValueSequence),])
    SelectorFLValue = Tag('Selector FL Value', "SelectorFLValue", 0x0072, 0x0076, [TagLink(CellValuesSequence),TagLink(AssessedAttributeValueSequence),])
    SelectorULValue = Tag('Selector UL Value', "SelectorULValue", 0x0072, 0x0078, [TagLink(CellValuesSequence),TagLink(AssessedAttributeValueSequence),])
    SelectorUSValue = Tag('Selector US Value', "SelectorUSValue", 0x0072, 0x007A, [TagLink(CellValuesSequence),TagLink(AssessedAttributeValueSequence),])
    SelectorSLValue = Tag('Selector SL Value', "SelectorSLValue", 0x0072, 0x007C, [TagLink(CellValuesSequence),TagLink(AssessedAttributeValueSequence),])
    SelectorSSValue = Tag('Selector SS Value', "SelectorSSValue", 0x0072, 0x007E, [TagLink(CellValuesSequence),TagLink(AssessedAttributeValueSequence),])
    SelectorUIValue = Tag('Selector UI Value', "SelectorUIValue", 0x0072, 0x007F, [TagLink(AssessedAttributeValueSequence),])
    SelectorOVValue = Tag('Selector OV Value', "SelectorOVValue", 0x0072, 0x0081, [TagLink(AssessedAttributeValueSequence),])
    SelectorSVValue = Tag('Selector SV Value', "SelectorSVValue", 0x0072, 0x0082, [TagLink(CellValuesSequence),TagLink(AssessedAttributeValueSequence),])
    SelectorUVValue = Tag('Selector UV Value', "SelectorUVValue", 0x0072, 0x0083, [TagLink(CellValuesSequence),TagLink(AssessedAttributeValueSequence),])
    NumberOfScreens = Tag('Number of Screens', "NumberOfScreens", 0x0072, 0x0100)
    NominalScreenDefinitionSequence = Tag('Nominal Screen Definition Sequence', "NominalScreenDefinitionSequence", 0x0072, 0x0102)
    NumberOfVerticalPixels = Tag('Number of Vertical Pixels', "NumberOfVerticalPixels", 0x0072, 0x0104)
    NumberOfHorizontalPixels = Tag('Number of Horizontal Pixels', "NumberOfHorizontalPixels", 0x0072, 0x0106)
    DisplayEnvironmentSpatialPosition = Tag('Display Environment Spatial Position', "DisplayEnvironmentSpatialPosition", 0x0072, 0x0108, [TagLink(StructuredDisplayImageBoxSequence),TagLink(StructuredDisplayTextBoxSequence),TagLink(ImageBoxesSequence),])
    ScreenMinimumGrayscaleBitDepth = Tag('Screen Minimum Grayscale Bit Depth', "ScreenMinimumGrayscaleBitDepth", 0x0072, 0x010A)
    ScreenMinimumColorBitDepth = Tag('Screen Minimum Color Bit Depth', "ScreenMinimumColorBitDepth", 0x0072, 0x010C)
    ApplicationMaximumRepaintTime = Tag('Application Maximum Repaint Time', "ApplicationMaximumRepaintTime", 0x0072, 0x010E)
    DisplaySetNumber = Tag('Display Set Number', "DisplaySetNumber", 0x0072, 0x0202, [TagLink(DisplaySetsSequence),])
    DisplaySetLabel = Tag('Display Set Label', "DisplaySetLabel", 0x0072, 0x0203, [TagLink(DisplaySetsSequence),])
    DisplaySetPresentationGroup = Tag('Display Set Presentation Group', "DisplaySetPresentationGroup", 0x0072, 0x0204, [TagLink(DisplaySetsSequence),])
    DisplaySetPresentationGroupDescription = Tag('Display Set Presentation Group Description', "DisplaySetPresentationGroupDescription", 0x0072, 0x0206, [TagLink(DisplaySetsSequence),])
    PartialDataDisplayHandling = Tag('Partial Data Display Handling', "PartialDataDisplayHandling", 0x0072, 0x0208)
    SynchronizedScrollingSequence = Tag('Synchronized Scrolling Sequence', "SynchronizedScrollingSequence", 0x0072, 0x0210)
    DisplaySetScrollingGroup = Tag('Display Set Scrolling Group', "DisplaySetScrollingGroup", 0x0072, 0x0212, [TagLink(SynchronizedScrollingSequence),])
    NavigationIndicatorSequence = Tag('Navigation Indicator Sequence', "NavigationIndicatorSequence", 0x0072, 0x0214)
    NavigationDisplaySet = Tag('Navigation Display Set', "NavigationDisplaySet", 0x0072, 0x0216, [TagLink(NavigationIndicatorSequence),])
    ReferenceDisplaySets = Tag('Reference Display Sets', "ReferenceDisplaySets", 0x0072, 0x0218, [TagLink(NavigationIndicatorSequence),])
    ImageBoxNumber = Tag('Image Box Number', "ImageBoxNumber", 0x0072, 0x0302, [TagLink(StructuredDisplayImageBoxSequence),TagLink(ImageBoxesSequence),])
    ImageBoxLayoutType = Tag('Image Box Layout Type', "ImageBoxLayoutType", 0x0072, 0x0304, [TagLink(StructuredDisplayImageBoxSequence),TagLink(ImageBoxesSequence),])
    ImageBoxTileHorizontalDimension = Tag('Image Box Tile Horizontal Dimension', "ImageBoxTileHorizontalDimension", 0x0072, 0x0306, [TagLink(StructuredDisplayImageBoxSequence),TagLink(ImageBoxesSequence),])
    ImageBoxTileVerticalDimension = Tag('Image Box Tile Vertical Dimension', "ImageBoxTileVerticalDimension", 0x0072, 0x0308, [TagLink(StructuredDisplayImageBoxSequence),TagLink(ImageBoxesSequence),])
    ImageBoxScrollDirection = Tag('Image Box Scroll Direction', "ImageBoxScrollDirection", 0x0072, 0x0310, [TagLink(ImageBoxesSequence),])
    ImageBoxSmallScrollType = Tag('Image Box Small Scroll Type', "ImageBoxSmallScrollType", 0x0072, 0x0312, [TagLink(ImageBoxesSequence),])
    ImageBoxSmallScrollAmount = Tag('Image Box Small Scroll Amount', "ImageBoxSmallScrollAmount", 0x0072, 0x0314, [TagLink(ImageBoxesSequence),])
    ImageBoxLargeScrollType = Tag('Image Box Large Scroll Type', "ImageBoxLargeScrollType", 0x0072, 0x0316, [TagLink(ImageBoxesSequence),])
    ImageBoxLargeScrollAmount = Tag('Image Box Large Scroll Amount', "ImageBoxLargeScrollAmount", 0x0072, 0x0318, [TagLink(ImageBoxesSequence),])
    ImageBoxOverlapPriority = Tag('Image Box Overlap Priority', "ImageBoxOverlapPriority", 0x0072, 0x0320, [TagLink(StructuredDisplayImageBoxSequence),TagLink(ImageBoxesSequence),])
    CineRelativeToRealTime = Tag('Cine Relative to Real-Time', "CineRelativeToRealTime", 0x0072, 0x0330, [TagLink(StructuredDisplayImageBoxSequence),TagLink(ImageBoxesSequence),])
    FilterByCategory = Tag('Filter-by Category', "FilterByCategory", 0x0072, 0x0402, [TagLink(FilterOperationsSequence),])
    FilterByAttributePresence = Tag('Filter-by Attribute Presence', "FilterByAttributePresence", 0x0072, 0x0404, [TagLink(FilterOperationsSequence),])
    FilterByOperator = Tag('Filter-by Operator', "FilterByOperator", 0x0072, 0x0406, [TagLink(FilterOperationsSequence),])
    StructuredDisplayBackgroundCIELabValue = Tag('Structured Display Background CIELab Value', "StructuredDisplayBackgroundCIELabValue", 0x0072, 0x0420)
    EmptyImageBoxCIELabValue = Tag('Empty Image Box CIELab Value', "EmptyImageBoxCIELabValue", 0x0072, 0x0421)
    ImageBoxSynchronizationSequence = Tag('Image Box Synchronization Sequence', "ImageBoxSynchronizationSequence", 0x0072, 0x0430)
    SynchronizedImageBoxList = Tag('Synchronized Image Box List', "SynchronizedImageBoxList", 0x0072, 0x0432, [TagLink(ImageBoxSynchronizationSequence),])
    TypeOfSynchronization = Tag('Type of Synchronization', "TypeOfSynchronization", 0x0072, 0x0434, [TagLink(ImageBoxSynchronizationSequence),])
    BlendingOperationType = Tag('Blending Operation Type', "BlendingOperationType", 0x0072, 0x0500, [TagLink(DisplaySetsSequence),])
    ReformattingOperationType = Tag('Reformatting Operation Type', "ReformattingOperationType", 0x0072, 0x0510, [TagLink(DisplaySetsSequence),])
    ReformattingThickness = Tag('Reformatting Thickness', "ReformattingThickness", 0x0072, 0x0512, [TagLink(DisplaySetsSequence),])
    ReformattingInterval = Tag('Reformatting Interval', "ReformattingInterval", 0x0072, 0x0514, [TagLink(DisplaySetsSequence),])
    ReformattingOperationInitialViewDirection = Tag('Reformatting Operation Initial View Direction', "ReformattingOperationInitialViewDirection", 0x0072, 0x0516, [TagLink(DisplaySetsSequence),])
    ThreeDRenderingType = Tag('3D Rendering Type', "ThreeDRenderingType", 0x0072, 0x0520, [TagLink(DisplaySetsSequence),])
    SortByCategory = Tag('Sort-by Category', "SortByCategory", 0x0072, 0x0602, [TagLink(SortingOperationsSequence),])
    SortingDirection = Tag('Sorting Direction', "SortingDirection", 0x0072, 0x0604, [TagLink(SortingOperationsSequence),])
    DisplaySetPatientOrientation = Tag('Display Set Patient Orientation', "DisplaySetPatientOrientation", 0x0072, 0x0700, [TagLink(DisplaySetsSequence),])
    VOIType = Tag('VOI Type', "VOIType", 0x0072, 0x0702, [TagLink(DisplaySetsSequence),])
    PseudoColorType = Tag('Pseudo-Color Type', "PseudoColorType", 0x0072, 0x0704, [TagLink(DisplaySetsSequence),])
    ShowGrayscaleInverted = Tag('Show Grayscale Inverted', "ShowGrayscaleInverted", 0x0072, 0x0706, [TagLink(DisplaySetsSequence),])
    ShowImageTrueSizeFlag = Tag('Show Image True Size Flag', "ShowImageTrueSizeFlag", 0x0072, 0x0710, [TagLink(DisplaySetsSequence),])
    ShowGraphicAnnotationFlag = Tag('Show Graphic Annotation Flag', "ShowGraphicAnnotationFlag", 0x0072, 0x0712, [TagLink(DisplaySetsSequence),])
    ShowPatientDemographicsFlag = Tag('Show Patient Demographics Flag', "ShowPatientDemographicsFlag", 0x0072, 0x0714, [TagLink(DisplaySetsSequence),])
    ShowAcquisitionTechniquesFlag = Tag('Show Acquisition Techniques Flag', "ShowAcquisitionTechniquesFlag", 0x0072, 0x0716, [TagLink(DisplaySetsSequence),])
    DisplaySetHorizontalJustification = Tag('Display Set Horizontal Justification', "DisplaySetHorizontalJustification", 0x0072, 0x0717, [TagLink(StructuredDisplayImageBoxSequence),TagLink(DisplaySetsSequence),])
    DisplaySetVerticalJustification = Tag('Display Set Vertical Justification', "DisplaySetVerticalJustification", 0x0072, 0x0718, [TagLink(StructuredDisplayImageBoxSequence),TagLink(DisplaySetsSequence),])
    ContinuationStartMeterset = Tag('Continuation Start Meterset', "ContinuationStartMeterset", 0x0074, 0x0120, [TagLink(BeamTaskSequence),TagLink(RTRadiationTaskSequence),])
    ContinuationEndMeterset = Tag('Continuation End Meterset', "ContinuationEndMeterset", 0x0074, 0x0121, [TagLink(BeamTaskSequence),TagLink(RTRadiationTaskSequence),])
    ProcedureStepState = Tag('Procedure Step State', "ProcedureStepState", 0x0074, 0x1000)
    ProcedureStepProgressInformationSequence = Tag('Procedure Step Progress Information Sequence', "ProcedureStepProgressInformationSequence", 0x0074, 0x1002)
    ProcedureStepProgress = Tag('Procedure Step Progress', "ProcedureStepProgress", 0x0074, 0x1004)
    ProcedureStepProgressDescription = Tag('Procedure Step Progress Description', "ProcedureStepProgressDescription", 0x0074, 0x1006)
    ProcedureStepProgressParametersSequence = Tag('Procedure Step Progress Parameters Sequence', "ProcedureStepProgressParametersSequence", 0x0074, 0x1007)
    ProcedureStepCommunicationsURISequence = Tag('Procedure Step Communications URI Sequence', "ProcedureStepCommunicationsURISequence", 0x0074, 0x1008)
    ContactURI = Tag('Contact URI', "ContactURI", 0x0074, 0x100A)
    ContactDisplayName = Tag('Contact Display Name', "ContactDisplayName", 0x0074, 0x100C)
    ProcedureStepDiscontinuationReasonCodeSequence = Tag('Procedure Step Discontinuation Reason Code Sequence', "ProcedureStepDiscontinuationReasonCodeSequence", 0x0074, 0x100E)
    BeamTaskType = Tag('Beam Task Type', "BeamTaskType", 0x0074, 0x1022, [TagLink(BeamTaskSequence),])
    BeamOrderIndexTrial = Tag('Beam Order Index (Trial)', "BeamOrderIndexTrial", 0x0074, 0x1024)
    AutosequenceFlag = Tag('Autosequence Flag', "AutosequenceFlag", 0x0074, 0x1025, [TagLink(BeamTaskSequence),])
    TableTopVerticalAdjustedPosition = Tag('Table Top Vertical Adjusted Position', "TableTopVerticalAdjustedPosition", 0x0074, 0x1026, [TagLink(BeamTaskSequence),])
    TableTopLongitudinalAdjustedPosition = Tag('Table Top Longitudinal Adjusted Position', "TableTopLongitudinalAdjustedPosition", 0x0074, 0x1027, [TagLink(BeamTaskSequence),])
    TableTopLateralAdjustedPosition = Tag('Table Top Lateral Adjusted Position', "TableTopLateralAdjustedPosition", 0x0074, 0x1028, [TagLink(BeamTaskSequence),])
    PatientSupportAdjustedAngle = Tag('Patient Support Adjusted Angle', "PatientSupportAdjustedAngle", 0x0074, 0x102A, [TagLink(BeamTaskSequence),])
    TableTopEccentricAdjustedAngle = Tag('Table Top Eccentric Adjusted Angle', "TableTopEccentricAdjustedAngle", 0x0074, 0x102B, [TagLink(BeamTaskSequence),])
    TableTopPitchAdjustedAngle = Tag('Table Top Pitch Adjusted Angle', "TableTopPitchAdjustedAngle", 0x0074, 0x102C, [TagLink(BeamTaskSequence),])
    TableTopRollAdjustedAngle = Tag('Table Top Roll Adjusted Angle', "TableTopRollAdjustedAngle", 0x0074, 0x102D, [TagLink(BeamTaskSequence),])
    VerificationImageTiming = Tag('Verification Image Timing', "VerificationImageTiming", 0x0074, 0x1032, [TagLink(DeliveryVerificationImageSequence),])
    DoubleExposureFlag = Tag('Double Exposure Flag', "DoubleExposureFlag", 0x0074, 0x1034, [TagLink(DeliveryVerificationImageSequence),])
    DoubleExposureOrdering = Tag('Double Exposure Ordering', "DoubleExposureOrdering", 0x0074, 0x1036, [TagLink(DeliveryVerificationImageSequence),])
    DoubleExposureMetersetTrial = Tag('Double Exposure Meterset (Trial)', "DoubleExposureMetersetTrial", 0x0074, 0x1038)
    DoubleExposureFieldDeltaTrial = Tag('Double Exposure Field Delta (Trial)', "DoubleExposureFieldDeltaTrial", 0x0074, 0x103A)
    GeneralMachineVerificationSequence = Tag('General Machine Verification Sequence', "GeneralMachineVerificationSequence", 0x0074, 0x1042)
    ConventionalMachineVerificationSequence = Tag('Conventional Machine Verification Sequence', "ConventionalMachineVerificationSequence", 0x0074, 0x1044)
    IonMachineVerificationSequence = Tag('Ion Machine Verification Sequence', "IonMachineVerificationSequence", 0x0074, 0x1046)
    FailedAttributesSequence = Tag('Failed Attributes Sequence', "FailedAttributesSequence", 0x0074, 0x1048)
    OverriddenAttributesSequence = Tag('Overridden Attributes Sequence', "OverriddenAttributesSequence", 0x0074, 0x104A)
    ConventionalControlPointVerificationSequence = Tag('Conventional Control Point Verification Sequence', "ConventionalControlPointVerificationSequence", 0x0074, 0x104C)
    IonControlPointVerificationSequence = Tag('Ion Control Point Verification Sequence', "IonControlPointVerificationSequence", 0x0074, 0x104E)
    AttributeOccurrenceSequence = Tag('Attribute Occurrence Sequence', "AttributeOccurrenceSequence", 0x0074, 0x1050)
    AttributeOccurrencePointer = Tag('Attribute Occurrence Pointer', "AttributeOccurrencePointer", 0x0074, 0x1052)
    AttributeItemSelector = Tag('Attribute Item Selector', "AttributeItemSelector", 0x0074, 0x1054)
    AttributeOccurrencePrivateCreator = Tag('Attribute Occurrence Private Creator', "AttributeOccurrencePrivateCreator", 0x0074, 0x1056)
    SelectorSequencePointerItems = Tag('Selector Sequence Pointer Items', "SelectorSequencePointerItems", 0x0074, 0x1057, [TagLink(NonconformingModifiedAttributesSequence),TagLink(StructuredConstraintObservationSequence),TagLink(PatientSpecificationSequence),TagLink(ParametersSpecificationSequence),TagLink(AttributeToleranceValuesSequence),TagLink(TreatmentToleranceViolationAttributeSequence),])
    ScheduledProcedureStepPriority = Tag('Scheduled Procedure Step Priority', "ScheduledProcedureStepPriority", 0x0074, 0x1200)
    WorklistLabel = Tag('Worklist Label', "WorklistLabel", 0x0074, 0x1202)
    ProcedureStepLabel = Tag('Procedure Step Label', "ProcedureStepLabel", 0x0074, 0x1204)
    ScheduledProcessingParametersSequence = Tag('Scheduled Processing Parameters Sequence', "ScheduledProcessingParametersSequence", 0x0074, 0x1210)
    UnifiedProcedureStepPerformedProcedureSequence = Tag('Unified Procedure Step Performed Procedure Sequence', "UnifiedProcedureStepPerformedProcedureSequence", 0x0074, 0x1216)
    RelatedProcedureStepSequence = Tag('Related Procedure Step Sequence', "RelatedProcedureStepSequence", 0x0074, 0x1220)
    ProcedureStepRelationshipType = Tag('Procedure Step Relationship Type', "ProcedureStepRelationshipType", 0x0074, 0x1222)
    ReplacedProcedureStepSequence = Tag('Replaced Procedure Step Sequence', "ReplacedProcedureStepSequence", 0x0074, 0x1224)
    DeletionLock = Tag('Deletion Lock', "DeletionLock", 0x0074, 0x1230)
    ReceivingAE = Tag('Receiving AE', "ReceivingAE", 0x0074, 0x1234)
    RequestingAE = Tag('Requesting AE', "RequestingAE", 0x0074, 0x1236)
    ReasonForCancellation = Tag('Reason for Cancellation', "ReasonForCancellation", 0x0074, 0x1238)
    SCPStatus = Tag('SCP Status', "SCPStatus", 0x0074, 0x1242)
    SubscriptionListStatus = Tag('Subscription List Status', "SubscriptionListStatus", 0x0074, 0x1244)
    UnifiedProcedureStepListStatus = Tag('Unified Procedure Step List Status', "UnifiedProcedureStepListStatus", 0x0074, 0x1246)
    BeamOrderIndex = Tag('Beam Order Index', "BeamOrderIndex", 0x0074, 0x1324, [TagLink(BeamTaskSequence),])
    DoubleExposureMeterset = Tag('Double Exposure Meterset', "DoubleExposureMeterset", 0x0074, 0x1338, [TagLink(DeliveryVerificationImageSequence),])
    DoubleExposureFieldDelta = Tag('Double Exposure Field Delta', "DoubleExposureFieldDelta", 0x0074, 0x133A, [TagLink(DeliveryVerificationImageSequence),])
    BrachyTaskSequence = Tag('Brachy Task Sequence', "BrachyTaskSequence", 0x0074, 0x1401)
    ContinuationStartTotalReferenceAirKerma = Tag('Continuation Start Total Reference Air Kerma', "ContinuationStartTotalReferenceAirKerma", 0x0074, 0x1402, [TagLink(BrachyTaskSequence),])
    ContinuationEndTotalReferenceAirKerma = Tag('Continuation End Total Reference Air Kerma', "ContinuationEndTotalReferenceAirKerma", 0x0074, 0x1403, [TagLink(BrachyTaskSequence),])
    ContinuationPulseNumber = Tag('Continuation Pulse Number', "ContinuationPulseNumber", 0x0074, 0x1404)
    ChannelDeliveryOrderSequence = Tag('Channel Delivery Order Sequence', "ChannelDeliveryOrderSequence", 0x0074, 0x1405, [TagLink(BrachyTaskSequence),])
    ChannelDeliveryContinuationSequence = Tag('Channel Delivery Continuation Sequence', "ChannelDeliveryContinuationSequence", 0x0074, 0x140D, [TagLink(BrachyTaskSequence),])
    OmittedApplicationSetupSequence = Tag('Omitted Application Setup Sequence', "OmittedApplicationSetupSequence", 0x0074, 0x140E)
    OmittedChannelSequence = Tag('Omitted Channel Sequence', "OmittedChannelSequence", 0x0074, 0x1409, [TagLink(OmittedApplicationSetupSequence),])
    ReferencedChannelNumber = Tag('Referenced Channel Number', "ReferencedChannelNumber", 0x0074, 0x1406, [TagLink(RecordedChannelSequence),TagLink(ChannelDeliveryOrderSequence),TagLink(ChannelDeliveryContinuationSequence),TagLink(OmittedChannelSequence),])
    StartCumulativeTimeWeight = Tag('Start Cumulative Time Weight', "StartCumulativeTimeWeight", 0x0074, 0x1407, [TagLink(ChannelDeliveryContinuationSequence),])
    EndCumulativeTimeWeight = Tag('End Cumulative Time Weight', "EndCumulativeTimeWeight", 0x0074, 0x1408, [TagLink(ChannelDeliveryContinuationSequence),])
    ReasonForChannelOmission = Tag('Reason for Channel Omission', "ReasonForChannelOmission", 0x0074, 0x140A, [TagLink(OmittedChannelSequence),])
    ReasonForChannelOmissionDescription = Tag('Reason for Channel Omission Description', "ReasonForChannelOmissionDescription", 0x0074, 0x140B, [TagLink(OmittedChannelSequence),])
    ChannelDeliveryOrderIndex = Tag('Channel Delivery Order Index', "ChannelDeliveryOrderIndex", 0x0074, 0x140C, [TagLink(ChannelDeliveryOrderSequence),])
    ImplantAssemblyTemplateName = Tag('Implant Assembly Template Name', "ImplantAssemblyTemplateName", 0x0076, 0x0001)
    ImplantAssemblyTemplateIssuer = Tag('Implant Assembly Template Issuer', "ImplantAssemblyTemplateIssuer", 0x0076, 0x0003)
    ImplantAssemblyTemplateVersion = Tag('Implant Assembly Template Version', "ImplantAssemblyTemplateVersion", 0x0076, 0x0006)
    ImplantAssemblyTemplateType = Tag('Implant Assembly Template Type', "ImplantAssemblyTemplateType", 0x0076, 0x000A)
    SurgicalTechnique = Tag('Surgical Technique', "SurgicalTechnique", 0x0076, 0x0030)
    ExclusiveComponentType = Tag('Exclusive Component Type', "ExclusiveComponentType", 0x0076, 0x0036, [TagLink(ComponentTypesSequence),])
    MandatoryComponentType = Tag('Mandatory Component Type', "MandatoryComponentType", 0x0076, 0x0038, [TagLink(ComponentTypesSequence),])
    ComponentID = Tag('Component ID', "ComponentID", 0x0076, 0x0055, [TagLink(ComponentSequence),])
    ComponentAssemblySequence = Tag('Component Assembly Sequence', "ComponentAssemblySequence", 0x0076, 0x0060)
    Component1ReferencedID = Tag('Component 1 Referenced ID', "Component1ReferencedID", 0x0076, 0x0070, [TagLink(ComponentAssemblySequence),])
    Component1ReferencedMatingFeatureSetID = Tag('Component 1 Referenced Mating Feature Set ID', "Component1ReferencedMatingFeatureSetID", 0x0076, 0x0080, [TagLink(ComponentAssemblySequence),])
    Component1ReferencedMatingFeatureID = Tag('Component 1 Referenced Mating Feature ID', "Component1ReferencedMatingFeatureID", 0x0076, 0x0090, [TagLink(ComponentAssemblySequence),])
    Component2ReferencedID = Tag('Component 2 Referenced ID', "Component2ReferencedID", 0x0076, 0x00A0, [TagLink(ComponentAssemblySequence),])
    Component2ReferencedMatingFeatureSetID = Tag('Component 2 Referenced Mating Feature Set ID', "Component2ReferencedMatingFeatureSetID", 0x0076, 0x00B0, [TagLink(ComponentAssemblySequence),])
    Component2ReferencedMatingFeatureID = Tag('Component 2 Referenced Mating Feature ID', "Component2ReferencedMatingFeatureID", 0x0076, 0x00C0, [TagLink(ComponentAssemblySequence),])
    ImplantTemplateGroupName = Tag('Implant Template Group Name', "ImplantTemplateGroupName", 0x0078, 0x0001)
    ImplantTemplateGroupDescription = Tag('Implant Template Group Description', "ImplantTemplateGroupDescription", 0x0078, 0x0010)
    ImplantTemplateGroupIssuer = Tag('Implant Template Group Issuer', "ImplantTemplateGroupIssuer", 0x0078, 0x0020)
    ImplantTemplateGroupVersion = Tag('Implant Template Group Version', "ImplantTemplateGroupVersion", 0x0078, 0x0024)
    ImplantTemplateGroupMemberID = Tag('Implant Template Group Member ID', "ImplantTemplateGroupMemberID", 0x0078, 0x002E, [TagLink(ImplantTemplateGroupMembersSequence),])
    ThreeDImplantTemplateGroupMemberMatchingPoint = Tag('3D Implant Template Group Member Matching Point', "ThreeDImplantTemplateGroupMemberMatchingPoint", 0x0078, 0x0050, [TagLink(ImplantTemplateGroupMembersSequence),])
    ThreeDImplantTemplateGroupMemberMatchingAxes = Tag('3D Implant Template Group Member Matching Axes', "ThreeDImplantTemplateGroupMemberMatchingAxes", 0x0078, 0x0060, [TagLink(ImplantTemplateGroupMembersSequence),])
    TwoDImplantTemplateGroupMemberMatchingPoint = Tag('2D Implant Template Group Member Matching Point', "TwoDImplantTemplateGroupMemberMatchingPoint", 0x0078, 0x0090, [TagLink(ImplantTemplateGroupMemberMatching2DCoordinatesSequence),])
    TwoDImplantTemplateGroupMemberMatchingAxes = Tag('2D Implant Template Group Member Matching Axes', "TwoDImplantTemplateGroupMemberMatchingAxes", 0x0078, 0x00A0, [TagLink(ImplantTemplateGroupMemberMatching2DCoordinatesSequence),])
    ImplantTemplateGroupVariationDimensionSequence = Tag('Implant Template Group Variation Dimension Sequence', "ImplantTemplateGroupVariationDimensionSequence", 0x0078, 0x00B0)
    ImplantTemplateGroupVariationDimensionName = Tag('Implant Template Group Variation Dimension Name', "ImplantTemplateGroupVariationDimensionName", 0x0078, 0x00B2, [TagLink(ImplantTemplateGroupVariationDimensionSequence),])
    ImplantTemplateGroupVariationDimensionRankSequence = Tag('Implant Template Group Variation Dimension Rank Sequence', "ImplantTemplateGroupVariationDimensionRankSequence", 0x0078, 0x00B4, [TagLink(ImplantTemplateGroupVariationDimensionSequence),])
    ReferencedImplantTemplateGroupMemberID = Tag('Referenced Implant Template Group Member ID', "ReferencedImplantTemplateGroupMemberID", 0x0078, 0x00B6, [TagLink(ImplantTemplateGroupVariationDimensionRankSequence),])
    ImplantTemplateGroupVariationDimensionRank = Tag('Implant Template Group Variation Dimension Rank', "ImplantTemplateGroupVariationDimensionRank", 0x0078, 0x00B8, [TagLink(ImplantTemplateGroupVariationDimensionRankSequence),])
    ShotDurationTime = Tag('Shot Duration Time', "ShotDurationTime", 0x0080, 0x0004)
    ShotOffsetTime = Tag('Shot Offset Time', "ShotOffsetTime", 0x0080, 0x0005)
    SurfacePointPresentationValueData = Tag('Surface Point Presentation Value Data', "SurfacePointPresentationValueData", 0x0080, 0x0006)
    SurfacePointColorCIELabValueData = Tag('Surface Point Color CIELab Value Data', "SurfacePointColorCIELabValueData", 0x0080, 0x0007)
    TextureLabel = Tag('Texture Label', "TextureLabel", 0x0080, 0x0009, [TagLink(UVMappingSequence),])
    UValueData = Tag('U Value Data', "UValueData", 0x0080, 0x0010, [TagLink(UVMappingSequence),])
    VValueData = Tag('V Value Data', "VValueData", 0x0080, 0x0011, [TagLink(UVMappingSequence),])
    AssessmentSummary = Tag('Assessment Summary', "AssessmentSummary", 0x0082, 0x0001)
    AssessmentSummaryDescription = Tag('Assessment Summary Description', "AssessmentSummaryDescription", 0x0082, 0x0003)
    NumberOfAssessmentObservations = Tag('Number of Assessment Observations', "NumberOfAssessmentObservations", 0x0082, 0x0006)
    ObservationSignificance = Tag('Observation Significance', "ObservationSignificance", 0x0082, 0x0008, [TagLink(AssessmentObservationsSequence),])
    ObservationDescription = Tag('Observation Description', "ObservationDescription", 0x0082, 0x000A, [TagLink(AssessmentObservationsSequence),])
    AssessmentSetID = Tag('Assessment Set ID', "AssessmentSetID", 0x0082, 0x0016)
    SelectorAttributeName = Tag('Selector Attribute Name', "SelectorAttributeName", 0x0082, 0x0018, [TagLink(StructuredConstraintObservationSequence),TagLink(PatientSpecificationSequence),TagLink(ParametersSpecificationSequence),TagLink(TreatmentToleranceViolationAttributeSequence),])
    SelectorAttributeKeyword = Tag('Selector Attribute Keyword', "SelectorAttributeKeyword", 0x0082, 0x0019, [TagLink(StructuredConstraintObservationSequence),TagLink(PatientSpecificationSequence),TagLink(ParametersSpecificationSequence),TagLink(TreatmentToleranceViolationAttributeSequence),])
    AssessmentLabel = Tag('Assessment Label', "AssessmentLabel", 0x0082, 0x0023)
    ConstraintType = Tag('Constraint Type', "ConstraintType", 0x0082, 0x0032, [TagLink(StructuredConstraintObservationSequence),TagLink(PatientSpecificationSequence),TagLink(ParametersSpecificationSequence),])
    SpecificationSelectionGuidance = Tag('Specification Selection Guidance', "SpecificationSelectionGuidance", 0x0082, 0x0033, [TagLink(StructuredConstraintObservationSequence),TagLink(PatientSpecificationSequence),TagLink(ParametersSpecificationSequence),])
    ConstraintValueSequence = Tag('Constraint Value Sequence', "ConstraintValueSequence", 0x0082, 0x0034, [TagLink(StructuredConstraintObservationSequence),TagLink(PatientSpecificationSequence),TagLink(ParametersSpecificationSequence),])
    RecommendedDefaultValueSequence = Tag('Recommended Default Value Sequence', "RecommendedDefaultValueSequence", 0x0082, 0x0035, [TagLink(StructuredConstraintObservationSequence),TagLink(PatientSpecificationSequence),TagLink(ParametersSpecificationSequence),])
    ConstraintViolationSignificance = Tag('Constraint Violation Significance', "ConstraintViolationSignificance", 0x0082, 0x0036, [TagLink(StructuredConstraintObservationSequence),TagLink(PatientSpecificationSequence),TagLink(ParametersSpecificationSequence),])
    ConstraintViolationCondition = Tag('Constraint Violation Condition', "ConstraintViolationCondition", 0x0082, 0x0037, [TagLink(StructuredConstraintObservationSequence),TagLink(PatientSpecificationSequence),TagLink(ParametersSpecificationSequence),])
    ModifiableConstraintFlag = Tag('Modifiable Constraint Flag', "ModifiableConstraintFlag", 0x0082, 0x0038, [TagLink(ParametersSpecificationSequence),])
    StorageMediaFileSetID = Tag('Storage Media File-set ID', "StorageMediaFileSetID", 0x0088, 0x0130, [TagLink(DICOMMediaRetrievalSequence),TagLink(InventoriedStudiesSequence),TagLink(InventoriedSeriesSequence),TagLink(InventoriedInstancesSequence),])
    StorageMediaFileSetUID = Tag('Storage Media File-set UID', "StorageMediaFileSetUID", 0x0088, 0x0140, [TagLink(DICOMMediaRetrievalSequence),])
    TopicTitle = Tag('Topic Title', "TopicTitle", 0x0088, 0x0904)
    TopicSubject = Tag('Topic Subject', "TopicSubject", 0x0088, 0x0906)
    TopicAuthor = Tag('Topic Author', "TopicAuthor", 0x0088, 0x0910)
    TopicKeywords = Tag('Topic Keywords', "TopicKeywords", 0x0088, 0x0912)
    SOPInstanceStatus = Tag('SOP Instance Status', "SOPInstanceStatus", 0x0100, 0x0410)
    SOPAuthorizationDateTime = Tag('SOP Authorization DateTime', "SOPAuthorizationDateTime", 0x0100, 0x0420)
    SOPAuthorizationComment = Tag('SOP Authorization Comment', "SOPAuthorizationComment", 0x0100, 0x0424)
    AuthorizationEquipmentCertificationNumber = Tag('Authorization Equipment Certification Number', "AuthorizationEquipmentCertificationNumber", 0x0100, 0x0426)
    MACParametersSequence = Tag('MAC Parameters Sequence', "MACParametersSequence", 0x4FFE, 0x0001)
    MACIDNumber = Tag('MAC ID Number', "MACIDNumber", 0x0400, 0x0005, [TagLink(MACParametersSequence),TagLink(DigitalSignaturesSequence),])
    ReferencedSOPInstanceMACSequence = Tag('Referenced SOP Instance MAC Sequence', "ReferencedSOPInstanceMACSequence", 0x0400, 0x0403, [TagLink(ReferencedSOPSequence),])
    MACCalculationTransferSyntaxUID = Tag('MAC Calculation Transfer Syntax UID', "MACCalculationTransferSyntaxUID", 0x0400, 0x0010, [TagLink(MACParametersSequence),TagLink(ReferencedSOPInstanceMACSequence),])
    MACAlgorithm = Tag('MAC Algorithm', "MACAlgorithm", 0x0400, 0x0015, [TagLink(MACParametersSequence),TagLink(ReferencedSOPInstanceMACSequence),TagLink(IncorporatedInventoryInstanceSequence),])
    DataElementsSigned = Tag('Data Elements Signed', "DataElementsSigned", 0x0400, 0x0020, [TagLink(MACParametersSequence),TagLink(ReferencedSOPInstanceMACSequence),])
    ReferencedDigitalSignatureSequence = Tag('Referenced Digital Signature Sequence', "ReferencedDigitalSignatureSequence", 0x0400, 0x0402, [TagLink(ReferencedSOPSequence),])
    DigitalSignatureUID = Tag('Digital Signature UID', "DigitalSignatureUID", 0x0400, 0x0100, [TagLink(DigitalSignaturesSequence),TagLink(ReferencedDigitalSignatureSequence),])
    DigitalSignatureDateTime = Tag('Digital Signature DateTime', "DigitalSignatureDateTime", 0x0400, 0x0105, [TagLink(DigitalSignaturesSequence),])
    CertificateType = Tag('Certificate Type', "CertificateType", 0x0400, 0x0110, [TagLink(DigitalSignaturesSequence),])
    CertificateOfSigner = Tag('Certificate of Signer', "CertificateOfSigner", 0x0400, 0x0115, [TagLink(DigitalSignaturesSequence),])
    Signature = Tag('Signature', "Signature", 0x0400, 0x0120, [TagLink(DigitalSignaturesSequence),TagLink(ReferencedDigitalSignatureSequence),])
    CertifiedTimestampType = Tag('Certified Timestamp Type', "CertifiedTimestampType", 0x0400, 0x0305, [TagLink(DigitalSignaturesSequence),])
    CertifiedTimestamp = Tag('Certified Timestamp', "CertifiedTimestamp", 0x0400, 0x0310, [TagLink(DigitalSignaturesSequence),])
    MAC = Tag('MAC', "MAC", 0x0400, 0x0404, [TagLink(ReferencedSOPInstanceMACSequence),TagLink(IncorporatedInventoryInstanceSequence),])
    EncryptedAttributesSequence = Tag('Encrypted Attributes Sequence', "EncryptedAttributesSequence", 0x0400, 0x0500)
    EncryptedContentTransferSyntaxUID = Tag('Encrypted Content Transfer Syntax UID', "EncryptedContentTransferSyntaxUID", 0x0400, 0x0510, [TagLink(EncryptedAttributesSequence),])
    EncryptedContent = Tag('Encrypted Content', "EncryptedContent", 0x0400, 0x0520, [TagLink(EncryptedAttributesSequence),])
    ModifiedAttributesSequence = Tag('Modified Attributes Sequence', "ModifiedAttributesSequence", 0x0400, 0x0550, [TagLink(OriginalAttributesSequence),])
    NonconformingDataElementValue = Tag('Nonconforming Data Element Value', "NonconformingDataElementValue", 0x0400, 0x0552, [TagLink(NonconformingModifiedAttributesSequence),])
    AttributeModificationDateTime = Tag('Attribute Modification DateTime', "AttributeModificationDateTime", 0x0400, 0x0562, [TagLink(OriginalAttributesSequence),])
    ModifyingSystem = Tag('Modifying System', "ModifyingSystem", 0x0400, 0x0563, [TagLink(OriginalAttributesSequence),])
    SourceOfPreviousValues = Tag('Source of Previous Values', "SourceOfPreviousValues", 0x0400, 0x0564, [TagLink(OriginalAttributesSequence),])
    ReasonForTheAttributeModification = Tag('Reason for the Attribute Modification', "ReasonForTheAttributeModification", 0x0400, 0x0565, [TagLink(OriginalAttributesSequence),])
    InstanceOriginStatus = Tag('Instance Origin Status', "InstanceOriginStatus", 0x0400, 0x0600)
    EscapeTriplet = Tag('Escape Triplet', "EscapeTriplet", 0x1000, 0x0000, [], [(0x1000, 0x0010),(0x1000, 0x0020),(0x1000, 0x0030),(0x1000, 0x0040),(0x1000, 0x0050),(0x1000, 0x0060),(0x1000, 0x0070),(0x1000, 0x0080),(0x1000, 0x0090),(0x1000, 0x00A0),(0x1000, 0x00B0),(0x1000, 0x00C0),(0x1000, 0x00D0),(0x1000, 0x00E0),(0x1000, 0x00F0),(0x1000, 0x0100),(0x1000, 0x0110),(0x1000, 0x0120),(0x1000, 0x0130),(0x1000, 0x0140),(0x1000, 0x0150),(0x1000, 0x0160),(0x1000, 0x0170),(0x1000, 0x0180),(0x1000, 0x0190),(0x1000, 0x01A0),(0x1000, 0x01B0),(0x1000, 0x01C0),(0x1000, 0x01D0),(0x1000, 0x01E0),(0x1000, 0x01F0),(0x1000, 0x0200),(0x1000, 0x0210),(0x1000, 0x0220),(0x1000, 0x0230),(0x1000, 0x0240),(0x1000, 0x0250),(0x1000, 0x0260),(0x1000, 0x0270),(0x1000, 0x0280),(0x1000, 0x0290),(0x1000, 0x02A0),(0x1000, 0x02B0),(0x1000, 0x02C0),(0x1000, 0x02D0),(0x1000, 0x02E0),(0x1000, 0x02F0),(0x1000, 0x0300),(0x1000, 0x0310),(0x1000, 0x0320),(0x1000, 0x0330),(0x1000, 0x0340),(0x1000, 0x0350),(0x1000, 0x0360),(0x1000, 0x0370),(0x1000, 0x0380),(0x1000, 0x0390),(0x1000, 0x03A0),(0x1000, 0x03B0),(0x1000, 0x03C0),(0x1000, 0x03D0),(0x1000, 0x03E0),(0x1000, 0x03F0),(0x1000, 0x0400),(0x1000, 0x0410),(0x1000, 0x0420),(0x1000, 0x0430),(0x1000, 0x0440),(0x1000, 0x0450),(0x1000, 0x0460),(0x1000, 0x0470),(0x1000, 0x0480),(0x1000, 0x0490),(0x1000, 0x04A0),(0x1000, 0x04B0),(0x1000, 0x04C0),(0x1000, 0x04D0),(0x1000, 0x04E0),(0x1000, 0x04F0),(0x1000, 0x0500),(0x1000, 0x0510),(0x1000, 0x0520),(0x1000, 0x0530),(0x1000, 0x0540),(0x1000, 0x0550),(0x1000, 0x0560),(0x1000, 0x0570),(0x1000, 0x0580),(0x1000, 0x0590),(0x1000, 0x05A0),(0x1000, 0x05B0),(0x1000, 0x05C0),(0x1000, 0x05D0),(0x1000, 0x05E0),(0x1000, 0x05F0),(0x1000, 0x0600),(0x1000, 0x0610),(0x1000, 0x0620),(0x1000, 0x0630),(0x1000, 0x0640),(0x1000, 0x0650),(0x1000, 0x0660),(0x1000, 0x0670),(0x1000, 0x0680),(0x1000, 0x0690),(0x1000, 0x06A0),(0x1000, 0x06B0),(0x1000, 0x06C0),(0x1000, 0x06D0),(0x1000, 0x06E0),(0x1000, 0x06F0),(0x1000, 0x0700),(0x1000, 0x0710),(0x1000, 0x0720),(0x1000, 0x0730),(0x1000, 0x0740),(0x1000, 0x0750),(0x1000, 0x0760),(0x1000, 0x0770),(0x1000, 0x0780),(0x1000, 0x0790),(0x1000, 0x07A0),(0x1000, 0x07B0),(0x1000, 0x07C0),(0x1000, 0x07D0),(0x1000, 0x07E0),(0x1000, 0x07F0),(0x1000, 0x0800),(0x1000, 0x0810),(0x1000, 0x0820),(0x1000, 0x0830),(0x1000, 0x0840),(0x1000, 0x0850),(0x1000, 0x0860),(0x1000, 0x0870),(0x1000, 0x0880),(0x1000, 0x0890),(0x1000, 0x08A0),(0x1000, 0x08B0),(0x1000, 0x08C0),(0x1000, 0x08D0),(0x1000, 0x08E0),(0x1000, 0x08F0),(0x1000, 0x0900),(0x1000, 0x0910),(0x1000, 0x0920),(0x1000, 0x0930),(0x1000, 0x0940),(0x1000, 0x0950),(0x1000, 0x0960),(0x1000, 0x0970),(0x1000, 0x0980),(0x1000, 0x0990),(0x1000, 0x09A0),(0x1000, 0x09B0),(0x1000, 0x09C0),(0x1000, 0x09D0),(0x1000, 0x09E0),(0x1000, 0x09F0),(0x1000, 0x0A00),(0x1000, 0x0A10),(0x1000, 0x0A20),(0x1000, 0x0A30),(0x1000, 0x0A40),(0x1000, 0x0A50),(0x1000, 0x0A60),(0x1000, 0x0A70),(0x1000, 0x0A80),(0x1000, 0x0A90),(0x1000, 0x0AA0),(0x1000, 0x0AB0),(0x1000, 0x0AC0),(0x1000, 0x0AD0),(0x1000, 0x0AE0),(0x1000, 0x0AF0),(0x1000, 0x0B00),(0x1000, 0x0B10),(0x1000, 0x0B20),(0x1000, 0x0B30),(0x1000, 0x0B40),(0x1000, 0x0B50),(0x1000, 0x0B60),(0x1000, 0x0B70),(0x1000, 0x0B80),(0x1000, 0x0B90),(0x1000, 0x0BA0),(0x1000, 0x0BB0),(0x1000, 0x0BC0),(0x1000, 0x0BD0),(0x1000, 0x0BE0),(0x1000, 0x0BF0),(0x1000, 0x0C00),(0x1000, 0x0C10),(0x1000, 0x0C20),(0x1000, 0x0C30),(0x1000, 0x0C40),(0x1000, 0x0C50),(0x1000, 0x0C60),(0x1000, 0x0C70),(0x1000, 0x0C80),(0x1000, 0x0C90),(0x1000, 0x0CA0),(0x1000, 0x0CB0),(0x1000, 0x0CC0),(0x1000, 0x0CD0),(0x1000, 0x0CE0),(0x1000, 0x0CF0),(0x1000, 0x0D00),(0x1000, 0x0D10),(0x1000, 0x0D20),(0x1000, 0x0D30),(0x1000, 0x0D40),(0x1000, 0x0D50),(0x1000, 0x0D60),(0x1000, 0x0D70),(0x1000, 0x0D80),(0x1000, 0x0D90),(0x1000, 0x0DA0),(0x1000, 0x0DB0),(0x1000, 0x0DC0),(0x1000, 0x0DD0),(0x1000, 0x0DE0),(0x1000, 0x0DF0),(0x1000, 0x0E00),(0x1000, 0x0E10),(0x1000, 0x0E20),(0x1000, 0x0E30),(0x1000, 0x0E40),(0x1000, 0x0E50),(0x1000, 0x0E60),(0x1000, 0x0E70),(0x1000, 0x0E80),(0x1000, 0x0E90),(0x1000, 0x0EA0),(0x1000, 0x0EB0),(0x1000, 0x0EC0),(0x1000, 0x0ED0),(0x1000, 0x0EE0),(0x1000, 0x0EF0),(0x1000, 0x0F00),(0x1000, 0x0F10),(0x1000, 0x0F20),(0x1000, 0x0F30),(0x1000, 0x0F40),(0x1000, 0x0F50),(0x1000, 0x0F60),(0x1000, 0x0F70),(0x1000, 0x0F80),(0x1000, 0x0F90),(0x1000, 0x0FA0),(0x1000, 0x0FB0),(0x1000, 0x0FC0),(0x1000, 0x0FD0),(0x1000, 0x0FE0),(0x1000, 0x0FF0),(0x1000, 0x1000),(0x1000, 0x1010),(0x1000, 0x1020),(0x1000, 0x1030),(0x1000, 0x1040),(0x1000, 0x1050),(0x1000, 0x1060),(0x1000, 0x1070),(0x1000, 0x1080),(0x1000, 0x1090),(0x1000, 0x10A0),(0x1000, 0x10B0),(0x1000, 0x10C0),(0x1000, 0x10D0),(0x1000, 0x10E0),(0x1000, 0x10F0),(0x1000, 0x1100),(0x1000, 0x1110),(0x1000, 0x1120),(0x1000, 0x1130),(0x1000, 0x1140),(0x1000, 0x1150),(0x1000, 0x1160),(0x1000, 0x1170),(0x1000, 0x1180),(0x1000, 0x1190),(0x1000, 0x11A0),(0x1000, 0x11B0),(0x1000, 0x11C0),(0x1000, 0x11D0),(0x1000, 0x11E0),(0x1000, 0x11F0),(0x1000, 0x1200),(0x1000, 0x1210),(0x1000, 0x1220),(0x1000, 0x1230),(0x1000, 0x1240),(0x1000, 0x1250),(0x1000, 0x1260),(0x1000, 0x1270),(0x1000, 0x1280),(0x1000, 0x1290),(0x1000, 0x12A0),(0x1000, 0x12B0),(0x1000, 0x12C0),(0x1000, 0x12D0),(0x1000, 0x12E0),(0x1000, 0x12F0),(0x1000, 0x1300),(0x1000, 0x1310),(0x1000, 0x1320),(0x1000, 0x1330),(0x1000, 0x1340),(0x1000, 0x1350),(0x1000, 0x1360),(0x1000, 0x1370),(0x1000, 0x1380),(0x1000, 0x1390),(0x1000, 0x13A0),(0x1000, 0x13B0),(0x1000, 0x13C0),(0x1000, 0x13D0),(0x1000, 0x13E0),(0x1000, 0x13F0),(0x1000, 0x1400),(0x1000, 0x1410),(0x1000, 0x1420),(0x1000, 0x1430),(0x1000, 0x1440),(0x1000, 0x1450),(0x1000, 0x1460),(0x1000, 0x1470),(0x1000, 0x1480),(0x1000, 0x1490),(0x1000, 0x14A0),(0x1000, 0x14B0),(0x1000, 0x14C0),(0x1000, 0x14D0),(0x1000, 0x14E0),(0x1000, 0x14F0),(0x1000, 0x1500),(0x1000, 0x1510),(0x1000, 0x1520),(0x1000, 0x1530),(0x1000, 0x1540),(0x1000, 0x1550),(0x1000, 0x1560),(0x1000, 0x1570),(0x1000, 0x1580),(0x1000, 0x1590),(0x1000, 0x15A0),(0x1000, 0x15B0),(0x1000, 0x15C0),(0x1000, 0x15D0),(0x1000, 0x15E0),(0x1000, 0x15F0),(0x1000, 0x1600),(0x1000, 0x1610),(0x1000, 0x1620),(0x1000, 0x1630),(0x1000, 0x1640),(0x1000, 0x1650),(0x1000, 0x1660),(0x1000, 0x1670),(0x1000, 0x1680),(0x1000, 0x1690),(0x1000, 0x16A0),(0x1000, 0x16B0),(0x1000, 0x16C0),(0x1000, 0x16D0),(0x1000, 0x16E0),(0x1000, 0x16F0),(0x1000, 0x1700),(0x1000, 0x1710),(0x1000, 0x1720),(0x1000, 0x1730),(0x1000, 0x1740),(0x1000, 0x1750),(0x1000, 0x1760),(0x1000, 0x1770),(0x1000, 0x1780),(0x1000, 0x1790),(0x1000, 0x17A0),(0x1000, 0x17B0),(0x1000, 0x17C0),(0x1000, 0x17D0),(0x1000, 0x17E0),(0x1000, 0x17F0),(0x1000, 0x1800),(0x1000, 0x1810),(0x1000, 0x1820),(0x1000, 0x1830),(0x1000, 0x1840),(0x1000, 0x1850),(0x1000, 0x1860),(0x1000, 0x1870),(0x1000, 0x1880),(0x1000, 0x1890),(0x1000, 0x18A0),(0x1000, 0x18B0),(0x1000, 0x18C0),(0x1000, 0x18D0),(0x1000, 0x18E0),(0x1000, 0x18F0),(0x1000, 0x1900),(0x1000, 0x1910),(0x1000, 0x1920),(0x1000, 0x1930),(0x1000, 0x1940),(0x1000, 0x1950),(0x1000, 0x1960),(0x1000, 0x1970),(0x1000, 0x1980),(0x1000, 0x1990),(0x1000, 0x19A0),(0x1000, 0x19B0),(0x1000, 0x19C0),(0x1000, 0x19D0),(0x1000, 0x19E0),(0x1000, 0x19F0),(0x1000, 0x1A00),(0x1000, 0x1A10),(0x1000, 0x1A20),(0x1000, 0x1A30),(0x1000, 0x1A40),(0x1000, 0x1A50),(0x1000, 0x1A60),(0x1000, 0x1A70),(0x1000, 0x1A80),(0x1000, 0x1A90),(0x1000, 0x1AA0),(0x1000, 0x1AB0),(0x1000, 0x1AC0),(0x1000, 0x1AD0),(0x1000, 0x1AE0),(0x1000, 0x1AF0),(0x1000, 0x1B00),(0x1000, 0x1B10),(0x1000, 0x1B20),(0x1000, 0x1B30),(0x1000, 0x1B40),(0x1000, 0x1B50),(0x1000, 0x1B60),(0x1000, 0x1B70),(0x1000, 0x1B80),(0x1000, 0x1B90),(0x1000, 0x1BA0),(0x1000, 0x1BB0),(0x1000, 0x1BC0),(0x1000, 0x1BD0),(0x1000, 0x1BE0),(0x1000, 0x1BF0),(0x1000, 0x1C00),(0x1000, 0x1C10),(0x1000, 0x1C20),(0x1000, 0x1C30),(0x1000, 0x1C40),(0x1000, 0x1C50),(0x1000, 0x1C60),(0x1000, 0x1C70),(0x1000, 0x1C80),(0x1000, 0x1C90),(0x1000, 0x1CA0),(0x1000, 0x1CB0),(0x1000, 0x1CC0),(0x1000, 0x1CD0),(0x1000, 0x1CE0),(0x1000, 0x1CF0),(0x1000, 0x1D00),(0x1000, 0x1D10),(0x1000, 0x1D20),(0x1000, 0x1D30),(0x1000, 0x1D40),(0x1000, 0x1D50),(0x1000, 0x1D60),(0x1000, 0x1D70),(0x1000, 0x1D80),(0x1000, 0x1D90),(0x1000, 0x1DA0),(0x1000, 0x1DB0),(0x1000, 0x1DC0),(0x1000, 0x1DD0),(0x1000, 0x1DE0),(0x1000, 0x1DF0),(0x1000, 0x1E00),(0x1000, 0x1E10),(0x1000, 0x1E20),(0x1000, 0x1E30),(0x1000, 0x1E40),(0x1000, 0x1E50),(0x1000, 0x1E60),(0x1000, 0x1E70),(0x1000, 0x1E80),(0x1000, 0x1E90),(0x1000, 0x1EA0),(0x1000, 0x1EB0),(0x1000, 0x1EC0),(0x1000, 0x1ED0),(0x1000, 0x1EE0),(0x1000, 0x1EF0),(0x1000, 0x1F00),(0x1000, 0x1F10),(0x1000, 0x1F20),(0x1000, 0x1F30),(0x1000, 0x1F40),(0x1000, 0x1F50),(0x1000, 0x1F60),(0x1000, 0x1F70),(0x1000, 0x1F80),(0x1000, 0x1F90),(0x1000, 0x1FA0),(0x1000, 0x1FB0),(0x1000, 0x1FC0),(0x1000, 0x1FD0),(0x1000, 0x1FE0),(0x1000, 0x1FF0),(0x1000, 0x2000),(0x1000, 0x2010),(0x1000, 0x2020),(0x1000, 0x2030),(0x1000, 0x2040),(0x1000, 0x2050),(0x1000, 0x2060),(0x1000, 0x2070),(0x1000, 0x2080),(0x1000, 0x2090),(0x1000, 0x20A0),(0x1000, 0x20B0),(0x1000, 0x20C0),(0x1000, 0x20D0),(0x1000, 0x20E0),(0x1000, 0x20F0),(0x1000, 0x2100),(0x1000, 0x2110),(0x1000, 0x2120),(0x1000, 0x2130),(0x1000, 0x2140),(0x1000, 0x2150),(0x1000, 0x2160),(0x1000, 0x2170),(0x1000, 0x2180),(0x1000, 0x2190),(0x1000, 0x21A0),(0x1000, 0x21B0),(0x1000, 0x21C0),(0x1000, 0x21D0),(0x1000, 0x21E0),(0x1000, 0x21F0),(0x1000, 0x2200),(0x1000, 0x2210),(0x1000, 0x2220),(0x1000, 0x2230),(0x1000, 0x2240),(0x1000, 0x2250),(0x1000, 0x2260),(0x1000, 0x2270),(0x1000, 0x2280),(0x1000, 0x2290),(0x1000, 0x22A0),(0x1000, 0x22B0),(0x1000, 0x22C0),(0x1000, 0x22D0),(0x1000, 0x22E0),(0x1000, 0x22F0),(0x1000, 0x2300),(0x1000, 0x2310),(0x1000, 0x2320),(0x1000, 0x2330),(0x1000, 0x2340),(0x1000, 0x2350),(0x1000, 0x2360),(0x1000, 0x2370),(0x1000, 0x2380),(0x1000, 0x2390),(0x1000, 0x23A0),(0x1000, 0x23B0),(0x1000, 0x23C0),(0x1000, 0x23D0),(0x1000, 0x23E0),(0x1000, 0x23F0),(0x1000, 0x2400),(0x1000, 0x2410),(0x1000, 0x2420),(0x1000, 0x2430),(0x1000, 0x2440),(0x1000, 0x2450),(0x1000, 0x2460),(0x1000, 0x2470),(0x1000, 0x2480),(0x1000, 0x2490),(0x1000, 0x24A0),(0x1000, 0x24B0),(0x1000, 0x24C0),(0x1000, 0x24D0),(0x1000, 0x24E0),(0x1000, 0x24F0),(0x1000, 0x2500),(0x1000, 0x2510),(0x1000, 0x2520),(0x1000, 0x2530),(0x1000, 0x2540),(0x1000, 0x2550),(0x1000, 0x2560),(0x1000, 0x2570),(0x1000, 0x2580),(0x1000, 0x2590),(0x1000, 0x25A0),(0x1000, 0x25B0),(0x1000, 0x25C0),(0x1000, 0x25D0),(0x1000, 0x25E0),(0x1000, 0x25F0),(0x1000, 0x2600),(0x1000, 0x2610),(0x1000, 0x2620),(0x1000, 0x2630),(0x1000, 0x2640),(0x1000, 0x2650),(0x1000, 0x2660),(0x1000, 0x2670),(0x1000, 0x2680),(0x1000, 0x2690),(0x1000, 0x26A0),(0x1000, 0x26B0),(0x1000, 0x26C0),(0x1000, 0x26D0),(0x1000, 0x26E0),(0x1000, 0x26F0),(0x1000, 0x2700),(0x1000, 0x2710),(0x1000, 0x2720),(0x1000, 0x2730),(0x1000, 0x2740),(0x1000, 0x2750),(0x1000, 0x2760),(0x1000, 0x2770),(0x1000, 0x2780),(0x1000, 0x2790),(0x1000, 0x27A0),(0x1000, 0x27B0),(0x1000, 0x27C0),(0x1000, 0x27D0),(0x1000, 0x27E0),(0x1000, 0x27F0),(0x1000, 0x2800),(0x1000, 0x2810),(0x1000, 0x2820),(0x1000, 0x2830),(0x1000, 0x2840),(0x1000, 0x2850),(0x1000, 0x2860),(0x1000, 0x2870),(0x1000, 0x2880),(0x1000, 0x2890),(0x1000, 0x28A0),(0x1000, 0x28B0),(0x1000, 0x28C0),(0x1000, 0x28D0),(0x1000, 0x28E0),(0x1000, 0x28F0),(0x1000, 0x2900),(0x1000, 0x2910),(0x1000, 0x2920),(0x1000, 0x2930),(0x1000, 0x2940),(0x1000, 0x2950),(0x1000, 0x2960),(0x1000, 0x2970),(0x1000, 0x2980),(0x1000, 0x2990),(0x1000, 0x29A0),(0x1000, 0x29B0),(0x1000, 0x29C0),(0x1000, 0x29D0),(0x1000, 0x29E0),(0x1000, 0x29F0),(0x1000, 0x2A00),(0x1000, 0x2A10),(0x1000, 0x2A20),(0x1000, 0x2A30),(0x1000, 0x2A40),(0x1000, 0x2A50),(0x1000, 0x2A60),(0x1000, 0x2A70),(0x1000, 0x2A80),(0x1000, 0x2A90),(0x1000, 0x2AA0),(0x1000, 0x2AB0),(0x1000, 0x2AC0),(0x1000, 0x2AD0),(0x1000, 0x2AE0),(0x1000, 0x2AF0),(0x1000, 0x2B00),(0x1000, 0x2B10),(0x1000, 0x2B20),(0x1000, 0x2B30),(0x1000, 0x2B40),(0x1000, 0x2B50),(0x1000, 0x2B60),(0x1000, 0x2B70),(0x1000, 0x2B80),(0x1000, 0x2B90),(0x1000, 0x2BA0),(0x1000, 0x2BB0),(0x1000, 0x2BC0),(0x1000, 0x2BD0),(0x1000, 0x2BE0),(0x1000, 0x2BF0),(0x1000, 0x2C00),(0x1000, 0x2C10),(0x1000, 0x2C20),(0x1000, 0x2C30),(0x1000, 0x2C40),(0x1000, 0x2C50),(0x1000, 0x2C60),(0x1000, 0x2C70),(0x1000, 0x2C80),(0x1000, 0x2C90),(0x1000, 0x2CA0),(0x1000, 0x2CB0),(0x1000, 0x2CC0),(0x1000, 0x2CD0),(0x1000, 0x2CE0),(0x1000, 0x2CF0),(0x1000, 0x2D00),(0x1000, 0x2D10),(0x1000, 0x2D20),(0x1000, 0x2D30),(0x1000, 0x2D40),(0x1000, 0x2D50),(0x1000, 0x2D60),(0x1000, 0x2D70),(0x1000, 0x2D80),(0x1000, 0x2D90),(0x1000, 0x2DA0),(0x1000, 0x2DB0),(0x1000, 0x2DC0),(0x1000, 0x2DD0),(0x1000, 0x2DE0),(0x1000, 0x2DF0),(0x1000, 0x2E00),(0x1000, 0x2E10),(0x1000, 0x2E20),(0x1000, 0x2E30),(0x1000, 0x2E40),(0x1000, 0x2E50),(0x1000, 0x2E60),(0x1000, 0x2E70),(0x1000, 0x2E80),(0x1000, 0x2E90),(0x1000, 0x2EA0),(0x1000, 0x2EB0),(0x1000, 0x2EC0),(0x1000, 0x2ED0),(0x1000, 0x2EE0),(0x1000, 0x2EF0),(0x1000, 0x2F00),(0x1000, 0x2F10),(0x1000, 0x2F20),(0x1000, 0x2F30),(0x1000, 0x2F40),(0x1000, 0x2F50),(0x1000, 0x2F60),(0x1000, 0x2F70),(0x1000, 0x2F80),(0x1000, 0x2F90),(0x1000, 0x2FA0),(0x1000, 0x2FB0),(0x1000, 0x2FC0),(0x1000, 0x2FD0),(0x1000, 0x2FE0),(0x1000, 0x2FF0),(0x1000, 0x3000),(0x1000, 0x3010),(0x1000, 0x3020),(0x1000, 0x3030),(0x1000, 0x3040),(0x1000, 0x3050),(0x1000, 0x3060),(0x1000, 0x3070),(0x1000, 0x3080),(0x1000, 0x3090),(0x1000, 0x30A0),(0x1000, 0x30B0),(0x1000, 0x30C0),(0x1000, 0x30D0),(0x1000, 0x30E0),(0x1000, 0x30F0),(0x1000, 0x3100),(0x1000, 0x3110),(0x1000, 0x3120),(0x1000, 0x3130),(0x1000, 0x3140),(0x1000, 0x3150),(0x1000, 0x3160),(0x1000, 0x3170),(0x1000, 0x3180),(0x1000, 0x3190),(0x1000, 0x31A0),(0x1000, 0x31B0),(0x1000, 0x31C0),(0x1000, 0x31D0),(0x1000, 0x31E0),(0x1000, 0x31F0),(0x1000, 0x3200),(0x1000, 0x3210),(0x1000, 0x3220),(0x1000, 0x3230),(0x1000, 0x3240),(0x1000, 0x3250),(0x1000, 0x3260),(0x1000, 0x3270),(0x1000, 0x3280),(0x1000, 0x3290),(0x1000, 0x32A0),(0x1000, 0x32B0),(0x1000, 0x32C0),(0x1000, 0x32D0),(0x1000, 0x32E0),(0x1000, 0x32F0),(0x1000, 0x3300),(0x1000, 0x3310),(0x1000, 0x3320),(0x1000, 0x3330),(0x1000, 0x3340),(0x1000, 0x3350),(0x1000, 0x3360),(0x1000, 0x3370),(0x1000, 0x3380),(0x1000, 0x3390),(0x1000, 0x33A0),(0x1000, 0x33B0),(0x1000, 0x33C0),(0x1000, 0x33D0),(0x1000, 0x33E0),(0x1000, 0x33F0),(0x1000, 0x3400),(0x1000, 0x3410),(0x1000, 0x3420),(0x1000, 0x3430),(0x1000, 0x3440),(0x1000, 0x3450),(0x1000, 0x3460),(0x1000, 0x3470),(0x1000, 0x3480),(0x1000, 0x3490),(0x1000, 0x34A0),(0x1000, 0x34B0),(0x1000, 0x34C0),(0x1000, 0x34D0),(0x1000, 0x34E0),(0x1000, 0x34F0),(0x1000, 0x3500),(0x1000, 0x3510),(0x1000, 0x3520),(0x1000, 0x3530),(0x1000, 0x3540),(0x1000, 0x3550),(0x1000, 0x3560),(0x1000, 0x3570),(0x1000, 0x3580),(0x1000, 0x3590),(0x1000, 0x35A0),(0x1000, 0x35B0),(0x1000, 0x35C0),(0x1000, 0x35D0),(0x1000, 0x35E0),(0x1000, 0x35F0),(0x1000, 0x3600),(0x1000, 0x3610),(0x1000, 0x3620),(0x1000, 0x3630),(0x1000, 0x3640),(0x1000, 0x3650),(0x1000, 0x3660),(0x1000, 0x3670),(0x1000, 0x3680),(0x1000, 0x3690),(0x1000, 0x36A0),(0x1000, 0x36B0),(0x1000, 0x36C0),(0x1000, 0x36D0),(0x1000, 0x36E0),(0x1000, 0x36F0),(0x1000, 0x3700),(0x1000, 0x3710),(0x1000, 0x3720),(0x1000, 0x3730),(0x1000, 0x3740),(0x1000, 0x3750),(0x1000, 0x3760),(0x1000, 0x3770),(0x1000, 0x3780),(0x1000, 0x3790),(0x1000, 0x37A0),(0x1000, 0x37B0),(0x1000, 0x37C0),(0x1000, 0x37D0),(0x1000, 0x37E0),(0x1000, 0x37F0),(0x1000, 0x3800),(0x1000, 0x3810),(0x1000, 0x3820),(0x1000, 0x3830),(0x1000, 0x3840),(0x1000, 0x3850),(0x1000, 0x3860),(0x1000, 0x3870),(0x1000, 0x3880),(0x1000, 0x3890),(0x1000, 0x38A0),(0x1000, 0x38B0),(0x1000, 0x38C0),(0x1000, 0x38D0),(0x1000, 0x38E0),(0x1000, 0x38F0),(0x1000, 0x3900),(0x1000, 0x3910),(0x1000, 0x3920),(0x1000, 0x3930),(0x1000, 0x3940),(0x1000, 0x3950),(0x1000, 0x3960),(0x1000, 0x3970),(0x1000, 0x3980),(0x1000, 0x3990),(0x1000, 0x39A0),(0x1000, 0x39B0),(0x1000, 0x39C0),(0x1000, 0x39D0),(0x1000, 0x39E0),(0x1000, 0x39F0),(0x1000, 0x3A00),(0x1000, 0x3A10),(0x1000, 0x3A20),(0x1000, 0x3A30),(0x1000, 0x3A40),(0x1000, 0x3A50),(0x1000, 0x3A60),(0x1000, 0x3A70),(0x1000, 0x3A80),(0x1000, 0x3A90),(0x1000, 0x3AA0),(0x1000, 0x3AB0),(0x1000, 0x3AC0),(0x1000, 0x3AD0),(0x1000, 0x3AE0),(0x1000, 0x3AF0),(0x1000, 0x3B00),(0x1000, 0x3B10),(0x1000, 0x3B20),(0x1000, 0x3B30),(0x1000, 0x3B40),(0x1000, 0x3B50),(0x1000, 0x3B60),(0x1000, 0x3B70),(0x1000, 0x3B80),(0x1000, 0x3B90),(0x1000, 0x3BA0),(0x1000, 0x3BB0),(0x1000, 0x3BC0),(0x1000, 0x3BD0),(0x1000, 0x3BE0),(0x1000, 0x3BF0),(0x1000, 0x3C00),(0x1000, 0x3C10),(0x1000, 0x3C20),(0x1000, 0x3C30),(0x1000, 0x3C40),(0x1000, 0x3C50),(0x1000, 0x3C60),(0x1000, 0x3C70),(0x1000, 0x3C80),(0x1000, 0x3C90),(0x1000, 0x3CA0),(0x1000, 0x3CB0),(0x1000, 0x3CC0),(0x1000, 0x3CD0),(0x1000, 0x3CE0),(0x1000, 0x3CF0),(0x1000, 0x3D00),(0x1000, 0x3D10),(0x1000, 0x3D20),(0x1000, 0x3D30),(0x1000, 0x3D40),(0x1000, 0x3D50),(0x1000, 0x3D60),(0x1000, 0x3D70),(0x1000, 0x3D80),(0x1000, 0x3D90),(0x1000, 0x3DA0),(0x1000, 0x3DB0),(0x1000, 0x3DC0),(0x1000, 0x3DD0),(0x1000, 0x3DE0),(0x1000, 0x3DF0),(0x1000, 0x3E00),(0x1000, 0x3E10),(0x1000, 0x3E20),(0x1000, 0x3E30),(0x1000, 0x3E40),(0x1000, 0x3E50),(0x1000, 0x3E60),(0x1000, 0x3E70),(0x1000, 0x3E80),(0x1000, 0x3E90),(0x1000, 0x3EA0),(0x1000, 0x3EB0),(0x1000, 0x3EC0),(0x1000, 0x3ED0),(0x1000, 0x3EE0),(0x1000, 0x3EF0),(0x1000, 0x3F00),(0x1000, 0x3F10),(0x1000, 0x3F20),(0x1000, 0x3F30),(0x1000, 0x3F40),(0x1000, 0x3F50),(0x1000, 0x3F60),(0x1000, 0x3F70),(0x1000, 0x3F80),(0x1000, 0x3F90),(0x1000, 0x3FA0),(0x1000, 0x3FB0),(0x1000, 0x3FC0),(0x1000, 0x3FD0),(0x1000, 0x3FE0),(0x1000, 0x3FF0),(0x1000, 0x4000),(0x1000, 0x4010),(0x1000, 0x4020),(0x1000, 0x4030),(0x1000, 0x4040),(0x1000, 0x4050),(0x1000, 0x4060),(0x1000, 0x4070),(0x1000, 0x4080),(0x1000, 0x4090),(0x1000, 0x40A0),(0x1000, 0x40B0),(0x1000, 0x40C0),(0x1000, 0x40D0),(0x1000, 0x40E0),(0x1000, 0x40F0),(0x1000, 0x4100),(0x1000, 0x4110),(0x1000, 0x4120),(0x1000, 0x4130),(0x1000, 0x4140),(0x1000, 0x4150),(0x1000, 0x4160),(0x1000, 0x4170),(0x1000, 0x4180),(0x1000, 0x4190),(0x1000, 0x41A0),(0x1000, 0x41B0),(0x1000, 0x41C0),(0x1000, 0x41D0),(0x1000, 0x41E0),(0x1000, 0x41F0),(0x1000, 0x4200),(0x1000, 0x4210),(0x1000, 0x4220),(0x1000, 0x4230),(0x1000, 0x4240),(0x1000, 0x4250),(0x1000, 0x4260),(0x1000, 0x4270),(0x1000, 0x4280),(0x1000, 0x4290),(0x1000, 0x42A0),(0x1000, 0x42B0),(0x1000, 0x42C0),(0x1000, 0x42D0),(0x1000, 0x42E0),(0x1000, 0x42F0),(0x1000, 0x4300),(0x1000, 0x4310),(0x1000, 0x4320),(0x1000, 0x4330),(0x1000, 0x4340),(0x1000, 0x4350),(0x1000, 0x4360),(0x1000, 0x4370),(0x1000, 0x4380),(0x1000, 0x4390),(0x1000, 0x43A0),(0x1000, 0x43B0),(0x1000, 0x43C0),(0x1000, 0x43D0),(0x1000, 0x43E0),(0x1000, 0x43F0),(0x1000, 0x4400),(0x1000, 0x4410),(0x1000, 0x4420),(0x1000, 0x4430),(0x1000, 0x4440),(0x1000, 0x4450),(0x1000, 0x4460),(0x1000, 0x4470),(0x1000, 0x4480),(0x1000, 0x4490),(0x1000, 0x44A0),(0x1000, 0x44B0),(0x1000, 0x44C0),(0x1000, 0x44D0),(0x1000, 0x44E0),(0x1000, 0x44F0),(0x1000, 0x4500),(0x1000, 0x4510),(0x1000, 0x4520),(0x1000, 0x4530),(0x1000, 0x4540),(0x1000, 0x4550),(0x1000, 0x4560),(0x1000, 0x4570),(0x1000, 0x4580),(0x1000, 0x4590),(0x1000, 0x45A0),(0x1000, 0x45B0),(0x1000, 0x45C0),(0x1000, 0x45D0),(0x1000, 0x45E0),(0x1000, 0x45F0),(0x1000, 0x4600),(0x1000, 0x4610),(0x1000, 0x4620),(0x1000, 0x4630),(0x1000, 0x4640),(0x1000, 0x4650),(0x1000, 0x4660),(0x1000, 0x4670),(0x1000, 0x4680),(0x1000, 0x4690),(0x1000, 0x46A0),(0x1000, 0x46B0),(0x1000, 0x46C0),(0x1000, 0x46D0),(0x1000, 0x46E0),(0x1000, 0x46F0),(0x1000, 0x4700),(0x1000, 0x4710),(0x1000, 0x4720),(0x1000, 0x4730),(0x1000, 0x4740),(0x1000, 0x4750),(0x1000, 0x4760),(0x1000, 0x4770),(0x1000, 0x4780),(0x1000, 0x4790),(0x1000, 0x47A0),(0x1000, 0x47B0),(0x1000, 0x47C0),(0x1000, 0x47D0),(0x1000, 0x47E0),(0x1000, 0x47F0),(0x1000, 0x4800),(0x1000, 0x4810),(0x1000, 0x4820),(0x1000, 0x4830),(0x1000, 0x4840),(0x1000, 0x4850),(0x1000, 0x4860),(0x1000, 0x4870),(0x1000, 0x4880),(0x1000, 0x4890),(0x1000, 0x48A0),(0x1000, 0x48B0),(0x1000, 0x48C0),(0x1000, 0x48D0),(0x1000, 0x48E0),(0x1000, 0x48F0),(0x1000, 0x4900),(0x1000, 0x4910),(0x1000, 0x4920),(0x1000, 0x4930),(0x1000, 0x4940),(0x1000, 0x4950),(0x1000, 0x4960),(0x1000, 0x4970),(0x1000, 0x4980),(0x1000, 0x4990),(0x1000, 0x49A0),(0x1000, 0x49B0),(0x1000, 0x49C0),(0x1000, 0x49D0),(0x1000, 0x49E0),(0x1000, 0x49F0),(0x1000, 0x4A00),(0x1000, 0x4A10),(0x1000, 0x4A20),(0x1000, 0x4A30),(0x1000, 0x4A40),(0x1000, 0x4A50),(0x1000, 0x4A60),(0x1000, 0x4A70),(0x1000, 0x4A80),(0x1000, 0x4A90),(0x1000, 0x4AA0),(0x1000, 0x4AB0),(0x1000, 0x4AC0),(0x1000, 0x4AD0),(0x1000, 0x4AE0),(0x1000, 0x4AF0),(0x1000, 0x4B00),(0x1000, 0x4B10),(0x1000, 0x4B20),(0x1000, 0x4B30),(0x1000, 0x4B40),(0x1000, 0x4B50),(0x1000, 0x4B60),(0x1000, 0x4B70),(0x1000, 0x4B80),(0x1000, 0x4B90),(0x1000, 0x4BA0),(0x1000, 0x4BB0),(0x1000, 0x4BC0),(0x1000, 0x4BD0),(0x1000, 0x4BE0),(0x1000, 0x4BF0),(0x1000, 0x4C00),(0x1000, 0x4C10),(0x1000, 0x4C20),(0x1000, 0x4C30),(0x1000, 0x4C40),(0x1000, 0x4C50),(0x1000, 0x4C60),(0x1000, 0x4C70),(0x1000, 0x4C80),(0x1000, 0x4C90),(0x1000, 0x4CA0),(0x1000, 0x4CB0),(0x1000, 0x4CC0),(0x1000, 0x4CD0),(0x1000, 0x4CE0),(0x1000, 0x4CF0),(0x1000, 0x4D00),(0x1000, 0x4D10),(0x1000, 0x4D20),(0x1000, 0x4D30),(0x1000, 0x4D40),(0x1000, 0x4D50),(0x1000, 0x4D60),(0x1000, 0x4D70),(0x1000, 0x4D80),(0x1000, 0x4D90),(0x1000, 0x4DA0),(0x1000, 0x4DB0),(0x1000, 0x4DC0),(0x1000, 0x4DD0),(0x1000, 0x4DE0),(0x1000, 0x4DF0),(0x1000, 0x4E00),(0x1000, 0x4E10),(0x1000, 0x4E20),(0x1000, 0x4E30),(0x1000, 0x4E40),(0x1000, 0x4E50),(0x1000, 0x4E60),(0x1000, 0x4E70),(0x1000, 0x4E80),(0x1000, 0x4E90),(0x1000, 0x4EA0),(0x1000, 0x4EB0),(0x1000, 0x4EC0),(0x1000, 0x4ED0),(0x1000, 0x4EE0),(0x1000, 0x4EF0),(0x1000, 0x4F00),(0x1000, 0x4F10),(0x1000, 0x4F20),(0x1000, 0x4F30),(0x1000, 0x4F40),(0x1000, 0x4F50),(0x1000, 0x4F60),(0x1000, 0x4F70),(0x1000, 0x4F80),(0x1000, 0x4F90),(0x1000, 0x4FA0),(0x1000, 0x4FB0),(0x1000, 0x4FC0),(0x1000, 0x4FD0),(0x1000, 0x4FE0),(0x1000, 0x4FF0),(0x1000, 0x5000),(0x1000, 0x5010),(0x1000, 0x5020),(0x1000, 0x5030),(0x1000, 0x5040),(0x1000, 0x5050),(0x1000, 0x5060),(0x1000, 0x5070),(0x1000, 0x5080),(0x1000, 0x5090),(0x1000, 0x50A0),(0x1000, 0x50B0),(0x1000, 0x50C0),(0x1000, 0x50D0),(0x1000, 0x50E0),(0x1000, 0x50F0),(0x1000, 0x5100),(0x1000, 0x5110),(0x1000, 0x5120),(0x1000, 0x5130),(0x1000, 0x5140),(0x1000, 0x5150),(0x1000, 0x5160),(0x1000, 0x5170),(0x1000, 0x5180),(0x1000, 0x5190),(0x1000, 0x51A0),(0x1000, 0x51B0),(0x1000, 0x51C0),(0x1000, 0x51D0),(0x1000, 0x51E0),(0x1000, 0x51F0),(0x1000, 0x5200),(0x1000, 0x5210),(0x1000, 0x5220),(0x1000, 0x5230),(0x1000, 0x5240),(0x1000, 0x5250),(0x1000, 0x5260),(0x1000, 0x5270),(0x1000, 0x5280),(0x1000, 0x5290),(0x1000, 0x52A0),(0x1000, 0x52B0),(0x1000, 0x52C0),(0x1000, 0x52D0),(0x1000, 0x52E0),(0x1000, 0x52F0),(0x1000, 0x5300),(0x1000, 0x5310),(0x1000, 0x5320),(0x1000, 0x5330),(0x1000, 0x5340),(0x1000, 0x5350),(0x1000, 0x5360),(0x1000, 0x5370),(0x1000, 0x5380),(0x1000, 0x5390),(0x1000, 0x53A0),(0x1000, 0x53B0),(0x1000, 0x53C0),(0x1000, 0x53D0),(0x1000, 0x53E0),(0x1000, 0x53F0),(0x1000, 0x5400),(0x1000, 0x5410),(0x1000, 0x5420),(0x1000, 0x5430),(0x1000, 0x5440),(0x1000, 0x5450),(0x1000, 0x5460),(0x1000, 0x5470),(0x1000, 0x5480),(0x1000, 0x5490),(0x1000, 0x54A0),(0x1000, 0x54B0),(0x1000, 0x54C0),(0x1000, 0x54D0),(0x1000, 0x54E0),(0x1000, 0x54F0),(0x1000, 0x5500),(0x1000, 0x5510),(0x1000, 0x5520),(0x1000, 0x5530),(0x1000, 0x5540),(0x1000, 0x5550),(0x1000, 0x5560),(0x1000, 0x5570),(0x1000, 0x5580),(0x1000, 0x5590),(0x1000, 0x55A0),(0x1000, 0x55B0),(0x1000, 0x55C0),(0x1000, 0x55D0),(0x1000, 0x55E0),(0x1000, 0x55F0),(0x1000, 0x5600),(0x1000, 0x5610),(0x1000, 0x5620),(0x1000, 0x5630),(0x1000, 0x5640),(0x1000, 0x5650),(0x1000, 0x5660),(0x1000, 0x5670),(0x1000, 0x5680),(0x1000, 0x5690),(0x1000, 0x56A0),(0x1000, 0x56B0),(0x1000, 0x56C0),(0x1000, 0x56D0),(0x1000, 0x56E0),(0x1000, 0x56F0),(0x1000, 0x5700),(0x1000, 0x5710),(0x1000, 0x5720),(0x1000, 0x5730),(0x1000, 0x5740),(0x1000, 0x5750),(0x1000, 0x5760),(0x1000, 0x5770),(0x1000, 0x5780),(0x1000, 0x5790),(0x1000, 0x57A0),(0x1000, 0x57B0),(0x1000, 0x57C0),(0x1000, 0x57D0),(0x1000, 0x57E0),(0x1000, 0x57F0),(0x1000, 0x5800),(0x1000, 0x5810),(0x1000, 0x5820),(0x1000, 0x5830),(0x1000, 0x5840),(0x1000, 0x5850),(0x1000, 0x5860),(0x1000, 0x5870),(0x1000, 0x5880),(0x1000, 0x5890),(0x1000, 0x58A0),(0x1000, 0x58B0),(0x1000, 0x58C0),(0x1000, 0x58D0),(0x1000, 0x58E0),(0x1000, 0x58F0),(0x1000, 0x5900),(0x1000, 0x5910),(0x1000, 0x5920),(0x1000, 0x5930),(0x1000, 0x5940),(0x1000, 0x5950),(0x1000, 0x5960),(0x1000, 0x5970),(0x1000, 0x5980),(0x1000, 0x5990),(0x1000, 0x59A0),(0x1000, 0x59B0),(0x1000, 0x59C0),(0x1000, 0x59D0),(0x1000, 0x59E0),(0x1000, 0x59F0),(0x1000, 0x5A00),(0x1000, 0x5A10),(0x1000, 0x5A20),(0x1000, 0x5A30),(0x1000, 0x5A40),(0x1000, 0x5A50),(0x1000, 0x5A60),(0x1000, 0x5A70),(0x1000, 0x5A80),(0x1000, 0x5A90),(0x1000, 0x5AA0),(0x1000, 0x5AB0),(0x1000, 0x5AC0),(0x1000, 0x5AD0),(0x1000, 0x5AE0),(0x1000, 0x5AF0),(0x1000, 0x5B00),(0x1000, 0x5B10),(0x1000, 0x5B20),(0x1000, 0x5B30),(0x1000, 0x5B40),(0x1000, 0x5B50),(0x1000, 0x5B60),(0x1000, 0x5B70),(0x1000, 0x5B80),(0x1000, 0x5B90),(0x1000, 0x5BA0),(0x1000, 0x5BB0),(0x1000, 0x5BC0),(0x1000, 0x5BD0),(0x1000, 0x5BE0),(0x1000, 0x5BF0),(0x1000, 0x5C00),(0x1000, 0x5C10),(0x1000, 0x5C20),(0x1000, 0x5C30),(0x1000, 0x5C40),(0x1000, 0x5C50),(0x1000, 0x5C60),(0x1000, 0x5C70),(0x1000, 0x5C80),(0x1000, 0x5C90),(0x1000, 0x5CA0),(0x1000, 0x5CB0),(0x1000, 0x5CC0),(0x1000, 0x5CD0),(0x1000, 0x5CE0),(0x1000, 0x5CF0),(0x1000, 0x5D00),(0x1000, 0x5D10),(0x1000, 0x5D20),(0x1000, 0x5D30),(0x1000, 0x5D40),(0x1000, 0x5D50),(0x1000, 0x5D60),(0x1000, 0x5D70),(0x1000, 0x5D80),(0x1000, 0x5D90),(0x1000, 0x5DA0),(0x1000, 0x5DB0),(0x1000, 0x5DC0),(0x1000, 0x5DD0),(0x1000, 0x5DE0),(0x1000, 0x5DF0),(0x1000, 0x5E00),(0x1000, 0x5E10),(0x1000, 0x5E20),(0x1000, 0x5E30),(0x1000, 0x5E40),(0x1000, 0x5E50),(0x1000, 0x5E60),(0x1000, 0x5E70),(0x1000, 0x5E80),(0x1000, 0x5E90),(0x1000, 0x5EA0),(0x1000, 0x5EB0),(0x1000, 0x5EC0),(0x1000, 0x5ED0),(0x1000, 0x5EE0),(0x1000, 0x5EF0),(0x1000, 0x5F00),(0x1000, 0x5F10),(0x1000, 0x5F20),(0x1000, 0x5F30),(0x1000, 0x5F40),(0x1000, 0x5F50),(0x1000, 0x5F60),(0x1000, 0x5F70),(0x1000, 0x5F80),(0x1000, 0x5F90),(0x1000, 0x5FA0),(0x1000, 0x5FB0),(0x1000, 0x5FC0),(0x1000, 0x5FD0),(0x1000, 0x5FE0),(0x1000, 0x5FF0),(0x1000, 0x6000),(0x1000, 0x6010),(0x1000, 0x6020),(0x1000, 0x6030),(0x1000, 0x6040),(0x1000, 0x6050),(0x1000, 0x6060),(0x1000, 0x6070),(0x1000, 0x6080),(0x1000, 0x6090),(0x1000, 0x60A0),(0x1000, 0x60B0),(0x1000, 0x60C0),(0x1000, 0x60D0),(0x1000, 0x60E0),(0x1000, 0x60F0),(0x1000, 0x6100),(0x1000, 0x6110),(0x1000, 0x6120),(0x1000, 0x6130),(0x1000, 0x6140),(0x1000, 0x6150),(0x1000, 0x6160),(0x1000, 0x6170),(0x1000, 0x6180),(0x1000, 0x6190),(0x1000, 0x61A0),(0x1000, 0x61B0),(0x1000, 0x61C0),(0x1000, 0x61D0),(0x1000, 0x61E0),(0x1000, 0x61F0),(0x1000, 0x6200),(0x1000, 0x6210),(0x1000, 0x6220),(0x1000, 0x6230),(0x1000, 0x6240),(0x1000, 0x6250),(0x1000, 0x6260),(0x1000, 0x6270),(0x1000, 0x6280),(0x1000, 0x6290),(0x1000, 0x62A0),(0x1000, 0x62B0),(0x1000, 0x62C0),(0x1000, 0x62D0),(0x1000, 0x62E0),(0x1000, 0x62F0),(0x1000, 0x6300),(0x1000, 0x6310),(0x1000, 0x6320),(0x1000, 0x6330),(0x1000, 0x6340),(0x1000, 0x6350),(0x1000, 0x6360),(0x1000, 0x6370),(0x1000, 0x6380),(0x1000, 0x6390),(0x1000, 0x63A0),(0x1000, 0x63B0),(0x1000, 0x63C0),(0x1000, 0x63D0),(0x1000, 0x63E0),(0x1000, 0x63F0),(0x1000, 0x6400),(0x1000, 0x6410),(0x1000, 0x6420),(0x1000, 0x6430),(0x1000, 0x6440),(0x1000, 0x6450),(0x1000, 0x6460),(0x1000, 0x6470),(0x1000, 0x6480),(0x1000, 0x6490),(0x1000, 0x64A0),(0x1000, 0x64B0),(0x1000, 0x64C0),(0x1000, 0x64D0),(0x1000, 0x64E0),(0x1000, 0x64F0),(0x1000, 0x6500),(0x1000, 0x6510),(0x1000, 0x6520),(0x1000, 0x6530),(0x1000, 0x6540),(0x1000, 0x6550),(0x1000, 0x6560),(0x1000, 0x6570),(0x1000, 0x6580),(0x1000, 0x6590),(0x1000, 0x65A0),(0x1000, 0x65B0),(0x1000, 0x65C0),(0x1000, 0x65D0),(0x1000, 0x65E0),(0x1000, 0x65F0),(0x1000, 0x6600),(0x1000, 0x6610),(0x1000, 0x6620),(0x1000, 0x6630),(0x1000, 0x6640),(0x1000, 0x6650),(0x1000, 0x6660),(0x1000, 0x6670),(0x1000, 0x6680),(0x1000, 0x6690),(0x1000, 0x66A0),(0x1000, 0x66B0),(0x1000, 0x66C0),(0x1000, 0x66D0),(0x1000, 0x66E0),(0x1000, 0x66F0),(0x1000, 0x6700),(0x1000, 0x6710),(0x1000, 0x6720),(0x1000, 0x6730),(0x1000, 0x6740),(0x1000, 0x6750),(0x1000, 0x6760),(0x1000, 0x6770),(0x1000, 0x6780),(0x1000, 0x6790),(0x1000, 0x67A0),(0x1000, 0x67B0),(0x1000, 0x67C0),(0x1000, 0x67D0),(0x1000, 0x67E0),(0x1000, 0x67F0),(0x1000, 0x6800),(0x1000, 0x6810),(0x1000, 0x6820),(0x1000, 0x6830),(0x1000, 0x6840),(0x1000, 0x6850),(0x1000, 0x6860),(0x1000, 0x6870),(0x1000, 0x6880),(0x1000, 0x6890),(0x1000, 0x68A0),(0x1000, 0x68B0),(0x1000, 0x68C0),(0x1000, 0x68D0),(0x1000, 0x68E0),(0x1000, 0x68F0),(0x1000, 0x6900),(0x1000, 0x6910),(0x1000, 0x6920),(0x1000, 0x6930),(0x1000, 0x6940),(0x1000, 0x6950),(0x1000, 0x6960),(0x1000, 0x6970),(0x1000, 0x6980),(0x1000, 0x6990),(0x1000, 0x69A0),(0x1000, 0x69B0),(0x1000, 0x69C0),(0x1000, 0x69D0),(0x1000, 0x69E0),(0x1000, 0x69F0),(0x1000, 0x6A00),(0x1000, 0x6A10),(0x1000, 0x6A20),(0x1000, 0x6A30),(0x1000, 0x6A40),(0x1000, 0x6A50),(0x1000, 0x6A60),(0x1000, 0x6A70),(0x1000, 0x6A80),(0x1000, 0x6A90),(0x1000, 0x6AA0),(0x1000, 0x6AB0),(0x1000, 0x6AC0),(0x1000, 0x6AD0),(0x1000, 0x6AE0),(0x1000, 0x6AF0),(0x1000, 0x6B00),(0x1000, 0x6B10),(0x1000, 0x6B20),(0x1000, 0x6B30),(0x1000, 0x6B40),(0x1000, 0x6B50),(0x1000, 0x6B60),(0x1000, 0x6B70),(0x1000, 0x6B80),(0x1000, 0x6B90),(0x1000, 0x6BA0),(0x1000, 0x6BB0),(0x1000, 0x6BC0),(0x1000, 0x6BD0),(0x1000, 0x6BE0),(0x1000, 0x6BF0),(0x1000, 0x6C00),(0x1000, 0x6C10),(0x1000, 0x6C20),(0x1000, 0x6C30),(0x1000, 0x6C40),(0x1000, 0x6C50),(0x1000, 0x6C60),(0x1000, 0x6C70),(0x1000, 0x6C80),(0x1000, 0x6C90),(0x1000, 0x6CA0),(0x1000, 0x6CB0),(0x1000, 0x6CC0),(0x1000, 0x6CD0),(0x1000, 0x6CE0),(0x1000, 0x6CF0),(0x1000, 0x6D00),(0x1000, 0x6D10),(0x1000, 0x6D20),(0x1000, 0x6D30),(0x1000, 0x6D40),(0x1000, 0x6D50),(0x1000, 0x6D60),(0x1000, 0x6D70),(0x1000, 0x6D80),(0x1000, 0x6D90),(0x1000, 0x6DA0),(0x1000, 0x6DB0),(0x1000, 0x6DC0),(0x1000, 0x6DD0),(0x1000, 0x6DE0),(0x1000, 0x6DF0),(0x1000, 0x6E00),(0x1000, 0x6E10),(0x1000, 0x6E20),(0x1000, 0x6E30),(0x1000, 0x6E40),(0x1000, 0x6E50),(0x1000, 0x6E60),(0x1000, 0x6E70),(0x1000, 0x6E80),(0x1000, 0x6E90),(0x1000, 0x6EA0),(0x1000, 0x6EB0),(0x1000, 0x6EC0),(0x1000, 0x6ED0),(0x1000, 0x6EE0),(0x1000, 0x6EF0),(0x1000, 0x6F00),(0x1000, 0x6F10),(0x1000, 0x6F20),(0x1000, 0x6F30),(0x1000, 0x6F40),(0x1000, 0x6F50),(0x1000, 0x6F60),(0x1000, 0x6F70),(0x1000, 0x6F80),(0x1000, 0x6F90),(0x1000, 0x6FA0),(0x1000, 0x6FB0),(0x1000, 0x6FC0),(0x1000, 0x6FD0),(0x1000, 0x6FE0),(0x1000, 0x6FF0),(0x1000, 0x7000),(0x1000, 0x7010),(0x1000, 0x7020),(0x1000, 0x7030),(0x1000, 0x7040),(0x1000, 0x7050),(0x1000, 0x7060),(0x1000, 0x7070),(0x1000, 0x7080),(0x1000, 0x7090),(0x1000, 0x70A0),(0x1000, 0x70B0),(0x1000, 0x70C0),(0x1000, 0x70D0),(0x1000, 0x70E0),(0x1000, 0x70F0),(0x1000, 0x7100),(0x1000, 0x7110),(0x1000, 0x7120),(0x1000, 0x7130),(0x1000, 0x7140),(0x1000, 0x7150),(0x1000, 0x7160),(0x1000, 0x7170),(0x1000, 0x7180),(0x1000, 0x7190),(0x1000, 0x71A0),(0x1000, 0x71B0),(0x1000, 0x71C0),(0x1000, 0x71D0),(0x1000, 0x71E0),(0x1000, 0x71F0),(0x1000, 0x7200),(0x1000, 0x7210),(0x1000, 0x7220),(0x1000, 0x7230),(0x1000, 0x7240),(0x1000, 0x7250),(0x1000, 0x7260),(0x1000, 0x7270),(0x1000, 0x7280),(0x1000, 0x7290),(0x1000, 0x72A0),(0x1000, 0x72B0),(0x1000, 0x72C0),(0x1000, 0x72D0),(0x1000, 0x72E0),(0x1000, 0x72F0),(0x1000, 0x7300),(0x1000, 0x7310),(0x1000, 0x7320),(0x1000, 0x7330),(0x1000, 0x7340),(0x1000, 0x7350),(0x1000, 0x7360),(0x1000, 0x7370),(0x1000, 0x7380),(0x1000, 0x7390),(0x1000, 0x73A0),(0x1000, 0x73B0),(0x1000, 0x73C0),(0x1000, 0x73D0),(0x1000, 0x73E0),(0x1000, 0x73F0),(0x1000, 0x7400),(0x1000, 0x7410),(0x1000, 0x7420),(0x1000, 0x7430),(0x1000, 0x7440),(0x1000, 0x7450),(0x1000, 0x7460),(0x1000, 0x7470),(0x1000, 0x7480),(0x1000, 0x7490),(0x1000, 0x74A0),(0x1000, 0x74B0),(0x1000, 0x74C0),(0x1000, 0x74D0),(0x1000, 0x74E0),(0x1000, 0x74F0),(0x1000, 0x7500),(0x1000, 0x7510),(0x1000, 0x7520),(0x1000, 0x7530),(0x1000, 0x7540),(0x1000, 0x7550),(0x1000, 0x7560),(0x1000, 0x7570),(0x1000, 0x7580),(0x1000, 0x7590),(0x1000, 0x75A0),(0x1000, 0x75B0),(0x1000, 0x75C0),(0x1000, 0x75D0),(0x1000, 0x75E0),(0x1000, 0x75F0),(0x1000, 0x7600),(0x1000, 0x7610),(0x1000, 0x7620),(0x1000, 0x7630),(0x1000, 0x7640),(0x1000, 0x7650),(0x1000, 0x7660),(0x1000, 0x7670),(0x1000, 0x7680),(0x1000, 0x7690),(0x1000, 0x76A0),(0x1000, 0x76B0),(0x1000, 0x76C0),(0x1000, 0x76D0),(0x1000, 0x76E0),(0x1000, 0x76F0),(0x1000, 0x7700),(0x1000, 0x7710),(0x1000, 0x7720),(0x1000, 0x7730),(0x1000, 0x7740),(0x1000, 0x7750),(0x1000, 0x7760),(0x1000, 0x7770),(0x1000, 0x7780),(0x1000, 0x7790),(0x1000, 0x77A0),(0x1000, 0x77B0),(0x1000, 0x77C0),(0x1000, 0x77D0),(0x1000, 0x77E0),(0x1000, 0x77F0),(0x1000, 0x7800),(0x1000, 0x7810),(0x1000, 0x7820),(0x1000, 0x7830),(0x1000, 0x7840),(0x1000, 0x7850),(0x1000, 0x7860),(0x1000, 0x7870),(0x1000, 0x7880),(0x1000, 0x7890),(0x1000, 0x78A0),(0x1000, 0x78B0),(0x1000, 0x78C0),(0x1000, 0x78D0),(0x1000, 0x78E0),(0x1000, 0x78F0),(0x1000, 0x7900),(0x1000, 0x7910),(0x1000, 0x7920),(0x1000, 0x7930),(0x1000, 0x7940),(0x1000, 0x7950),(0x1000, 0x7960),(0x1000, 0x7970),(0x1000, 0x7980),(0x1000, 0x7990),(0x1000, 0x79A0),(0x1000, 0x79B0),(0x1000, 0x79C0),(0x1000, 0x79D0),(0x1000, 0x79E0),(0x1000, 0x79F0),(0x1000, 0x7A00),(0x1000, 0x7A10),(0x1000, 0x7A20),(0x1000, 0x7A30),(0x1000, 0x7A40),(0x1000, 0x7A50),(0x1000, 0x7A60),(0x1000, 0x7A70),(0x1000, 0x7A80),(0x1000, 0x7A90),(0x1000, 0x7AA0),(0x1000, 0x7AB0),(0x1000, 0x7AC0),(0x1000, 0x7AD0),(0x1000, 0x7AE0),(0x1000, 0x7AF0),(0x1000, 0x7B00),(0x1000, 0x7B10),(0x1000, 0x7B20),(0x1000, 0x7B30),(0x1000, 0x7B40),(0x1000, 0x7B50),(0x1000, 0x7B60),(0x1000, 0x7B70),(0x1000, 0x7B80),(0x1000, 0x7B90),(0x1000, 0x7BA0),(0x1000, 0x7BB0),(0x1000, 0x7BC0),(0x1000, 0x7BD0),(0x1000, 0x7BE0),(0x1000, 0x7BF0),(0x1000, 0x7C00),(0x1000, 0x7C10),(0x1000, 0x7C20),(0x1000, 0x7C30),(0x1000, 0x7C40),(0x1000, 0x7C50),(0x1000, 0x7C60),(0x1000, 0x7C70),(0x1000, 0x7C80),(0x1000, 0x7C90),(0x1000, 0x7CA0),(0x1000, 0x7CB0),(0x1000, 0x7CC0),(0x1000, 0x7CD0),(0x1000, 0x7CE0),(0x1000, 0x7CF0),(0x1000, 0x7D00),(0x1000, 0x7D10),(0x1000, 0x7D20),(0x1000, 0x7D30),(0x1000, 0x7D40),(0x1000, 0x7D50),(0x1000, 0x7D60),(0x1000, 0x7D70),(0x1000, 0x7D80),(0x1000, 0x7D90),(0x1000, 0x7DA0),(0x1000, 0x7DB0),(0x1000, 0x7DC0),(0x1000, 0x7DD0),(0x1000, 0x7DE0),(0x1000, 0x7DF0),(0x1000, 0x7E00),(0x1000, 0x7E10),(0x1000, 0x7E20),(0x1000, 0x7E30),(0x1000, 0x7E40),(0x1000, 0x7E50),(0x1000, 0x7E60),(0x1000, 0x7E70),(0x1000, 0x7E80),(0x1000, 0x7E90),(0x1000, 0x7EA0),(0x1000, 0x7EB0),(0x1000, 0x7EC0),(0x1000, 0x7ED0),(0x1000, 0x7EE0),(0x1000, 0x7EF0),(0x1000, 0x7F00),(0x1000, 0x7F10),(0x1000, 0x7F20),(0x1000, 0x7F30),(0x1000, 0x7F40),(0x1000, 0x7F50),(0x1000, 0x7F60),(0x1000, 0x7F70),(0x1000, 0x7F80),(0x1000, 0x7F90),(0x1000, 0x7FA0),(0x1000, 0x7FB0),(0x1000, 0x7FC0),(0x1000, 0x7FD0),(0x1000, 0x7FE0),(0x1000, 0x7FF0),(0x1000, 0x8000),(0x1000, 0x8010),(0x1000, 0x8020),(0x1000, 0x8030),(0x1000, 0x8040),(0x1000, 0x8050),(0x1000, 0x8060),(0x1000, 0x8070),(0x1000, 0x8080),(0x1000, 0x8090),(0x1000, 0x80A0),(0x1000, 0x80B0),(0x1000, 0x80C0),(0x1000, 0x80D0),(0x1000, 0x80E0),(0x1000, 0x80F0),(0x1000, 0x8100),(0x1000, 0x8110),(0x1000, 0x8120),(0x1000, 0x8130),(0x1000, 0x8140),(0x1000, 0x8150),(0x1000, 0x8160),(0x1000, 0x8170),(0x1000, 0x8180),(0x1000, 0x8190),(0x1000, 0x81A0),(0x1000, 0x81B0),(0x1000, 0x81C0),(0x1000, 0x81D0),(0x1000, 0x81E0),(0x1000, 0x81F0),(0x1000, 0x8200),(0x1000, 0x8210),(0x1000, 0x8220),(0x1000, 0x8230),(0x1000, 0x8240),(0x1000, 0x8250),(0x1000, 0x8260),(0x1000, 0x8270),(0x1000, 0x8280),(0x1000, 0x8290),(0x1000, 0x82A0),(0x1000, 0x82B0),(0x1000, 0x82C0),(0x1000, 0x82D0),(0x1000, 0x82E0),(0x1000, 0x82F0),(0x1000, 0x8300),(0x1000, 0x8310),(0x1000, 0x8320),(0x1000, 0x8330),(0x1000, 0x8340),(0x1000, 0x8350),(0x1000, 0x8360),(0x1000, 0x8370),(0x1000, 0x8380),(0x1000, 0x8390),(0x1000, 0x83A0),(0x1000, 0x83B0),(0x1000, 0x83C0),(0x1000, 0x83D0),(0x1000, 0x83E0),(0x1000, 0x83F0),(0x1000, 0x8400),(0x1000, 0x8410),(0x1000, 0x8420),(0x1000, 0x8430),(0x1000, 0x8440),(0x1000, 0x8450),(0x1000, 0x8460),(0x1000, 0x8470),(0x1000, 0x8480),(0x1000, 0x8490),(0x1000, 0x84A0),(0x1000, 0x84B0),(0x1000, 0x84C0),(0x1000, 0x84D0),(0x1000, 0x84E0),(0x1000, 0x84F0),(0x1000, 0x8500),(0x1000, 0x8510),(0x1000, 0x8520),(0x1000, 0x8530),(0x1000, 0x8540),(0x1000, 0x8550),(0x1000, 0x8560),(0x1000, 0x8570),(0x1000, 0x8580),(0x1000, 0x8590),(0x1000, 0x85A0),(0x1000, 0x85B0),(0x1000, 0x85C0),(0x1000, 0x85D0),(0x1000, 0x85E0),(0x1000, 0x85F0),(0x1000, 0x8600),(0x1000, 0x8610),(0x1000, 0x8620),(0x1000, 0x8630),(0x1000, 0x8640),(0x1000, 0x8650),(0x1000, 0x8660),(0x1000, 0x8670),(0x1000, 0x8680),(0x1000, 0x8690),(0x1000, 0x86A0),(0x1000, 0x86B0),(0x1000, 0x86C0),(0x1000, 0x86D0),(0x1000, 0x86E0),(0x1000, 0x86F0),(0x1000, 0x8700),(0x1000, 0x8710),(0x1000, 0x8720),(0x1000, 0x8730),(0x1000, 0x8740),(0x1000, 0x8750),(0x1000, 0x8760),(0x1000, 0x8770),(0x1000, 0x8780),(0x1000, 0x8790),(0x1000, 0x87A0),(0x1000, 0x87B0),(0x1000, 0x87C0),(0x1000, 0x87D0),(0x1000, 0x87E0),(0x1000, 0x87F0),(0x1000, 0x8800),(0x1000, 0x8810),(0x1000, 0x8820),(0x1000, 0x8830),(0x1000, 0x8840),(0x1000, 0x8850),(0x1000, 0x8860),(0x1000, 0x8870),(0x1000, 0x8880),(0x1000, 0x8890),(0x1000, 0x88A0),(0x1000, 0x88B0),(0x1000, 0x88C0),(0x1000, 0x88D0),(0x1000, 0x88E0),(0x1000, 0x88F0),(0x1000, 0x8900),(0x1000, 0x8910),(0x1000, 0x8920),(0x1000, 0x8930),(0x1000, 0x8940),(0x1000, 0x8950),(0x1000, 0x8960),(0x1000, 0x8970),(0x1000, 0x8980),(0x1000, 0x8990),(0x1000, 0x89A0),(0x1000, 0x89B0),(0x1000, 0x89C0),(0x1000, 0x89D0),(0x1000, 0x89E0),(0x1000, 0x89F0),(0x1000, 0x8A00),(0x1000, 0x8A10),(0x1000, 0x8A20),(0x1000, 0x8A30),(0x1000, 0x8A40),(0x1000, 0x8A50),(0x1000, 0x8A60),(0x1000, 0x8A70),(0x1000, 0x8A80),(0x1000, 0x8A90),(0x1000, 0x8AA0),(0x1000, 0x8AB0),(0x1000, 0x8AC0),(0x1000, 0x8AD0),(0x1000, 0x8AE0),(0x1000, 0x8AF0),(0x1000, 0x8B00),(0x1000, 0x8B10),(0x1000, 0x8B20),(0x1000, 0x8B30),(0x1000, 0x8B40),(0x1000, 0x8B50),(0x1000, 0x8B60),(0x1000, 0x8B70),(0x1000, 0x8B80),(0x1000, 0x8B90),(0x1000, 0x8BA0),(0x1000, 0x8BB0),(0x1000, 0x8BC0),(0x1000, 0x8BD0),(0x1000, 0x8BE0),(0x1000, 0x8BF0),(0x1000, 0x8C00),(0x1000, 0x8C10),(0x1000, 0x8C20),(0x1000, 0x8C30),(0x1000, 0x8C40),(0x1000, 0x8C50),(0x1000, 0x8C60),(0x1000, 0x8C70),(0x1000, 0x8C80),(0x1000, 0x8C90),(0x1000, 0x8CA0),(0x1000, 0x8CB0),(0x1000, 0x8CC0),(0x1000, 0x8CD0),(0x1000, 0x8CE0),(0x1000, 0x8CF0),(0x1000, 0x8D00),(0x1000, 0x8D10),(0x1000, 0x8D20),(0x1000, 0x8D30),(0x1000, 0x8D40),(0x1000, 0x8D50),(0x1000, 0x8D60),(0x1000, 0x8D70),(0x1000, 0x8D80),(0x1000, 0x8D90),(0x1000, 0x8DA0),(0x1000, 0x8DB0),(0x1000, 0x8DC0),(0x1000, 0x8DD0),(0x1000, 0x8DE0),(0x1000, 0x8DF0),(0x1000, 0x8E00),(0x1000, 0x8E10),(0x1000, 0x8E20),(0x1000, 0x8E30),(0x1000, 0x8E40),(0x1000, 0x8E50),(0x1000, 0x8E60),(0x1000, 0x8E70),(0x1000, 0x8E80),(0x1000, 0x8E90),(0x1000, 0x8EA0),(0x1000, 0x8EB0),(0x1000, 0x8EC0),(0x1000, 0x8ED0),(0x1000, 0x8EE0),(0x1000, 0x8EF0),(0x1000, 0x8F00),(0x1000, 0x8F10),(0x1000, 0x8F20),(0x1000, 0x8F30),(0x1000, 0x8F40),(0x1000, 0x8F50),(0x1000, 0x8F60),(0x1000, 0x8F70),(0x1000, 0x8F80),(0x1000, 0x8F90),(0x1000, 0x8FA0),(0x1000, 0x8FB0),(0x1000, 0x8FC0),(0x1000, 0x8FD0),(0x1000, 0x8FE0),(0x1000, 0x8FF0),(0x1000, 0x9000),(0x1000, 0x9010),(0x1000, 0x9020),(0x1000, 0x9030),(0x1000, 0x9040),(0x1000, 0x9050),(0x1000, 0x9060),(0x1000, 0x9070),(0x1000, 0x9080),(0x1000, 0x9090),(0x1000, 0x90A0),(0x1000, 0x90B0),(0x1000, 0x90C0),(0x1000, 0x90D0),(0x1000, 0x90E0),(0x1000, 0x90F0),(0x1000, 0x9100),(0x1000, 0x9110),(0x1000, 0x9120),(0x1000, 0x9130),(0x1000, 0x9140),(0x1000, 0x9150),(0x1000, 0x9160),(0x1000, 0x9170),(0x1000, 0x9180),(0x1000, 0x9190),(0x1000, 0x91A0),(0x1000, 0x91B0),(0x1000, 0x91C0),(0x1000, 0x91D0),(0x1000, 0x91E0),(0x1000, 0x91F0),(0x1000, 0x9200),(0x1000, 0x9210),(0x1000, 0x9220),(0x1000, 0x9230),(0x1000, 0x9240),(0x1000, 0x9250),(0x1000, 0x9260),(0x1000, 0x9270),(0x1000, 0x9280),(0x1000, 0x9290),(0x1000, 0x92A0),(0x1000, 0x92B0),(0x1000, 0x92C0),(0x1000, 0x92D0),(0x1000, 0x92E0),(0x1000, 0x92F0),(0x1000, 0x9300),(0x1000, 0x9310),(0x1000, 0x9320),(0x1000, 0x9330),(0x1000, 0x9340),(0x1000, 0x9350),(0x1000, 0x9360),(0x1000, 0x9370),(0x1000, 0x9380),(0x1000, 0x9390),(0x1000, 0x93A0),(0x1000, 0x93B0),(0x1000, 0x93C0),(0x1000, 0x93D0),(0x1000, 0x93E0),(0x1000, 0x93F0),(0x1000, 0x9400),(0x1000, 0x9410),(0x1000, 0x9420),(0x1000, 0x9430),(0x1000, 0x9440),(0x1000, 0x9450),(0x1000, 0x9460),(0x1000, 0x9470),(0x1000, 0x9480),(0x1000, 0x9490),(0x1000, 0x94A0),(0x1000, 0x94B0),(0x1000, 0x94C0),(0x1000, 0x94D0),(0x1000, 0x94E0),(0x1000, 0x94F0),(0x1000, 0x9500),(0x1000, 0x9510),(0x1000, 0x9520),(0x1000, 0x9530),(0x1000, 0x9540),(0x1000, 0x9550),(0x1000, 0x9560),(0x1000, 0x9570),(0x1000, 0x9580),(0x1000, 0x9590),(0x1000, 0x95A0),(0x1000, 0x95B0),(0x1000, 0x95C0),(0x1000, 0x95D0),(0x1000, 0x95E0),(0x1000, 0x95F0),(0x1000, 0x9600),(0x1000, 0x9610),(0x1000, 0x9620),(0x1000, 0x9630),(0x1000, 0x9640),(0x1000, 0x9650),(0x1000, 0x9660),(0x1000, 0x9670),(0x1000, 0x9680),(0x1000, 0x9690),(0x1000, 0x96A0),(0x1000, 0x96B0),(0x1000, 0x96C0),(0x1000, 0x96D0),(0x1000, 0x96E0),(0x1000, 0x96F0),(0x1000, 0x9700),(0x1000, 0x9710),(0x1000, 0x9720),(0x1000, 0x9730),(0x1000, 0x9740),(0x1000, 0x9750),(0x1000, 0x9760),(0x1000, 0x9770),(0x1000, 0x9780),(0x1000, 0x9790),(0x1000, 0x97A0),(0x1000, 0x97B0),(0x1000, 0x97C0),(0x1000, 0x97D0),(0x1000, 0x97E0),(0x1000, 0x97F0),(0x1000, 0x9800),(0x1000, 0x9810),(0x1000, 0x9820),(0x1000, 0x9830),(0x1000, 0x9840),(0x1000, 0x9850),(0x1000, 0x9860),(0x1000, 0x9870),(0x1000, 0x9880),(0x1000, 0x9890),(0x1000, 0x98A0),(0x1000, 0x98B0),(0x1000, 0x98C0),(0x1000, 0x98D0),(0x1000, 0x98E0),(0x1000, 0x98F0),(0x1000, 0x9900),(0x1000, 0x9910),(0x1000, 0x9920),(0x1000, 0x9930),(0x1000, 0x9940),(0x1000, 0x9950),(0x1000, 0x9960),(0x1000, 0x9970),(0x1000, 0x9980),(0x1000, 0x9990),(0x1000, 0x99A0),(0x1000, 0x99B0),(0x1000, 0x99C0),(0x1000, 0x99D0),(0x1000, 0x99E0),(0x1000, 0x99F0),(0x1000, 0x9A00),(0x1000, 0x9A10),(0x1000, 0x9A20),(0x1000, 0x9A30),(0x1000, 0x9A40),(0x1000, 0x9A50),(0x1000, 0x9A60),(0x1000, 0x9A70),(0x1000, 0x9A80),(0x1000, 0x9A90),(0x1000, 0x9AA0),(0x1000, 0x9AB0),(0x1000, 0x9AC0),(0x1000, 0x9AD0),(0x1000, 0x9AE0),(0x1000, 0x9AF0),(0x1000, 0x9B00),(0x1000, 0x9B10),(0x1000, 0x9B20),(0x1000, 0x9B30),(0x1000, 0x9B40),(0x1000, 0x9B50),(0x1000, 0x9B60),(0x1000, 0x9B70),(0x1000, 0x9B80),(0x1000, 0x9B90),(0x1000, 0x9BA0),(0x1000, 0x9BB0),(0x1000, 0x9BC0),(0x1000, 0x9BD0),(0x1000, 0x9BE0),(0x1000, 0x9BF0),(0x1000, 0x9C00),(0x1000, 0x9C10),(0x1000, 0x9C20),(0x1000, 0x9C30),(0x1000, 0x9C40),(0x1000, 0x9C50),(0x1000, 0x9C60),(0x1000, 0x9C70),(0x1000, 0x9C80),(0x1000, 0x9C90),(0x1000, 0x9CA0),(0x1000, 0x9CB0),(0x1000, 0x9CC0),(0x1000, 0x9CD0),(0x1000, 0x9CE0),(0x1000, 0x9CF0),(0x1000, 0x9D00),(0x1000, 0x9D10),(0x1000, 0x9D20),(0x1000, 0x9D30),(0x1000, 0x9D40),(0x1000, 0x9D50),(0x1000, 0x9D60),(0x1000, 0x9D70),(0x1000, 0x9D80),(0x1000, 0x9D90),(0x1000, 0x9DA0),(0x1000, 0x9DB0),(0x1000, 0x9DC0),(0x1000, 0x9DD0),(0x1000, 0x9DE0),(0x1000, 0x9DF0),(0x1000, 0x9E00),(0x1000, 0x9E10),(0x1000, 0x9E20),(0x1000, 0x9E30),(0x1000, 0x9E40),(0x1000, 0x9E50),(0x1000, 0x9E60),(0x1000, 0x9E70),(0x1000, 0x9E80),(0x1000, 0x9E90),(0x1000, 0x9EA0),(0x1000, 0x9EB0),(0x1000, 0x9EC0),(0x1000, 0x9ED0),(0x1000, 0x9EE0),(0x1000, 0x9EF0),(0x1000, 0x9F00),(0x1000, 0x9F10),(0x1000, 0x9F20),(0x1000, 0x9F30),(0x1000, 0x9F40),(0x1000, 0x9F50),(0x1000, 0x9F60),(0x1000, 0x9F70),(0x1000, 0x9F80),(0x1000, 0x9F90),(0x1000, 0x9FA0),(0x1000, 0x9FB0),(0x1000, 0x9FC0),(0x1000, 0x9FD0),(0x1000, 0x9FE0),(0x1000, 0x9FF0),(0x1000, 0xA000),(0x1000, 0xA010),(0x1000, 0xA020),(0x1000, 0xA030),(0x1000, 0xA040),(0x1000, 0xA050),(0x1000, 0xA060),(0x1000, 0xA070),(0x1000, 0xA080),(0x1000, 0xA090),(0x1000, 0xA0A0),(0x1000, 0xA0B0),(0x1000, 0xA0C0),(0x1000, 0xA0D0),(0x1000, 0xA0E0),(0x1000, 0xA0F0),(0x1000, 0xA100),(0x1000, 0xA110),(0x1000, 0xA120),(0x1000, 0xA130),(0x1000, 0xA140),(0x1000, 0xA150),(0x1000, 0xA160),(0x1000, 0xA170),(0x1000, 0xA180),(0x1000, 0xA190),(0x1000, 0xA1A0),(0x1000, 0xA1B0),(0x1000, 0xA1C0),(0x1000, 0xA1D0),(0x1000, 0xA1E0),(0x1000, 0xA1F0),(0x1000, 0xA200),(0x1000, 0xA210),(0x1000, 0xA220),(0x1000, 0xA230),(0x1000, 0xA240),(0x1000, 0xA250),(0x1000, 0xA260),(0x1000, 0xA270),(0x1000, 0xA280),(0x1000, 0xA290),(0x1000, 0xA2A0),(0x1000, 0xA2B0),(0x1000, 0xA2C0),(0x1000, 0xA2D0),(0x1000, 0xA2E0),(0x1000, 0xA2F0),(0x1000, 0xA300),(0x1000, 0xA310),(0x1000, 0xA320),(0x1000, 0xA330),(0x1000, 0xA340),(0x1000, 0xA350),(0x1000, 0xA360),(0x1000, 0xA370),(0x1000, 0xA380),(0x1000, 0xA390),(0x1000, 0xA3A0),(0x1000, 0xA3B0),(0x1000, 0xA3C0),(0x1000, 0xA3D0),(0x1000, 0xA3E0),(0x1000, 0xA3F0),(0x1000, 0xA400),(0x1000, 0xA410),(0x1000, 0xA420),(0x1000, 0xA430),(0x1000, 0xA440),(0x1000, 0xA450),(0x1000, 0xA460),(0x1000, 0xA470),(0x1000, 0xA480),(0x1000, 0xA490),(0x1000, 0xA4A0),(0x1000, 0xA4B0),(0x1000, 0xA4C0),(0x1000, 0xA4D0),(0x1000, 0xA4E0),(0x1000, 0xA4F0),(0x1000, 0xA500),(0x1000, 0xA510),(0x1000, 0xA520),(0x1000, 0xA530),(0x1000, 0xA540),(0x1000, 0xA550),(0x1000, 0xA560),(0x1000, 0xA570),(0x1000, 0xA580),(0x1000, 0xA590),(0x1000, 0xA5A0),(0x1000, 0xA5B0),(0x1000, 0xA5C0),(0x1000, 0xA5D0),(0x1000, 0xA5E0),(0x1000, 0xA5F0),(0x1000, 0xA600),(0x1000, 0xA610),(0x1000, 0xA620),(0x1000, 0xA630),(0x1000, 0xA640),(0x1000, 0xA650),(0x1000, 0xA660),(0x1000, 0xA670),(0x1000, 0xA680),(0x1000, 0xA690),(0x1000, 0xA6A0),(0x1000, 0xA6B0),(0x1000, 0xA6C0),(0x1000, 0xA6D0),(0x1000, 0xA6E0),(0x1000, 0xA6F0),(0x1000, 0xA700),(0x1000, 0xA710),(0x1000, 0xA720),(0x1000, 0xA730),(0x1000, 0xA740),(0x1000, 0xA750),(0x1000, 0xA760),(0x1000, 0xA770),(0x1000, 0xA780),(0x1000, 0xA790),(0x1000, 0xA7A0),(0x1000, 0xA7B0),(0x1000, 0xA7C0),(0x1000, 0xA7D0),(0x1000, 0xA7E0),(0x1000, 0xA7F0),(0x1000, 0xA800),(0x1000, 0xA810),(0x1000, 0xA820),(0x1000, 0xA830),(0x1000, 0xA840),(0x1000, 0xA850),(0x1000, 0xA860),(0x1000, 0xA870),(0x1000, 0xA880),(0x1000, 0xA890),(0x1000, 0xA8A0),(0x1000, 0xA8B0),(0x1000, 0xA8C0),(0x1000, 0xA8D0),(0x1000, 0xA8E0),(0x1000, 0xA8F0),(0x1000, 0xA900),(0x1000, 0xA910),(0x1000, 0xA920),(0x1000, 0xA930),(0x1000, 0xA940),(0x1000, 0xA950),(0x1000, 0xA960),(0x1000, 0xA970),(0x1000, 0xA980),(0x1000, 0xA990),(0x1000, 0xA9A0),(0x1000, 0xA9B0),(0x1000, 0xA9C0),(0x1000, 0xA9D0),(0x1000, 0xA9E0),(0x1000, 0xA9F0),(0x1000, 0xAA00),(0x1000, 0xAA10),(0x1000, 0xAA20),(0x1000, 0xAA30),(0x1000, 0xAA40),(0x1000, 0xAA50),(0x1000, 0xAA60),(0x1000, 0xAA70),(0x1000, 0xAA80),(0x1000, 0xAA90),(0x1000, 0xAAA0),(0x1000, 0xAAB0),(0x1000, 0xAAC0),(0x1000, 0xAAD0),(0x1000, 0xAAE0),(0x1000, 0xAAF0),(0x1000, 0xAB00),(0x1000, 0xAB10),(0x1000, 0xAB20),(0x1000, 0xAB30),(0x1000, 0xAB40),(0x1000, 0xAB50),(0x1000, 0xAB60),(0x1000, 0xAB70),(0x1000, 0xAB80),(0x1000, 0xAB90),(0x1000, 0xABA0),(0x1000, 0xABB0),(0x1000, 0xABC0),(0x1000, 0xABD0),(0x1000, 0xABE0),(0x1000, 0xABF0),(0x1000, 0xAC00),(0x1000, 0xAC10),(0x1000, 0xAC20),(0x1000, 0xAC30),(0x1000, 0xAC40),(0x1000, 0xAC50),(0x1000, 0xAC60),(0x1000, 0xAC70),(0x1000, 0xAC80),(0x1000, 0xAC90),(0x1000, 0xACA0),(0x1000, 0xACB0),(0x1000, 0xACC0),(0x1000, 0xACD0),(0x1000, 0xACE0),(0x1000, 0xACF0),(0x1000, 0xAD00),(0x1000, 0xAD10),(0x1000, 0xAD20),(0x1000, 0xAD30),(0x1000, 0xAD40),(0x1000, 0xAD50),(0x1000, 0xAD60),(0x1000, 0xAD70),(0x1000, 0xAD80),(0x1000, 0xAD90),(0x1000, 0xADA0),(0x1000, 0xADB0),(0x1000, 0xADC0),(0x1000, 0xADD0),(0x1000, 0xADE0),(0x1000, 0xADF0),(0x1000, 0xAE00),(0x1000, 0xAE10),(0x1000, 0xAE20),(0x1000, 0xAE30),(0x1000, 0xAE40),(0x1000, 0xAE50),(0x1000, 0xAE60),(0x1000, 0xAE70),(0x1000, 0xAE80),(0x1000, 0xAE90),(0x1000, 0xAEA0),(0x1000, 0xAEB0),(0x1000, 0xAEC0),(0x1000, 0xAED0),(0x1000, 0xAEE0),(0x1000, 0xAEF0),(0x1000, 0xAF00),(0x1000, 0xAF10),(0x1000, 0xAF20),(0x1000, 0xAF30),(0x1000, 0xAF40),(0x1000, 0xAF50),(0x1000, 0xAF60),(0x1000, 0xAF70),(0x1000, 0xAF80),(0x1000, 0xAF90),(0x1000, 0xAFA0),(0x1000, 0xAFB0),(0x1000, 0xAFC0),(0x1000, 0xAFD0),(0x1000, 0xAFE0),(0x1000, 0xAFF0),(0x1000, 0xB000),(0x1000, 0xB010),(0x1000, 0xB020),(0x1000, 0xB030),(0x1000, 0xB040),(0x1000, 0xB050),(0x1000, 0xB060),(0x1000, 0xB070),(0x1000, 0xB080),(0x1000, 0xB090),(0x1000, 0xB0A0),(0x1000, 0xB0B0),(0x1000, 0xB0C0),(0x1000, 0xB0D0),(0x1000, 0xB0E0),(0x1000, 0xB0F0),(0x1000, 0xB100),(0x1000, 0xB110),(0x1000, 0xB120),(0x1000, 0xB130),(0x1000, 0xB140),(0x1000, 0xB150),(0x1000, 0xB160),(0x1000, 0xB170),(0x1000, 0xB180),(0x1000, 0xB190),(0x1000, 0xB1A0),(0x1000, 0xB1B0),(0x1000, 0xB1C0),(0x1000, 0xB1D0),(0x1000, 0xB1E0),(0x1000, 0xB1F0),(0x1000, 0xB200),(0x1000, 0xB210),(0x1000, 0xB220),(0x1000, 0xB230),(0x1000, 0xB240),(0x1000, 0xB250),(0x1000, 0xB260),(0x1000, 0xB270),(0x1000, 0xB280),(0x1000, 0xB290),(0x1000, 0xB2A0),(0x1000, 0xB2B0),(0x1000, 0xB2C0),(0x1000, 0xB2D0),(0x1000, 0xB2E0),(0x1000, 0xB2F0),(0x1000, 0xB300),(0x1000, 0xB310),(0x1000, 0xB320),(0x1000, 0xB330),(0x1000, 0xB340),(0x1000, 0xB350),(0x1000, 0xB360),(0x1000, 0xB370),(0x1000, 0xB380),(0x1000, 0xB390),(0x1000, 0xB3A0),(0x1000, 0xB3B0),(0x1000, 0xB3C0),(0x1000, 0xB3D0),(0x1000, 0xB3E0),(0x1000, 0xB3F0),(0x1000, 0xB400),(0x1000, 0xB410),(0x1000, 0xB420),(0x1000, 0xB430),(0x1000, 0xB440),(0x1000, 0xB450),(0x1000, 0xB460),(0x1000, 0xB470),(0x1000, 0xB480),(0x1000, 0xB490),(0x1000, 0xB4A0),(0x1000, 0xB4B0),(0x1000, 0xB4C0),(0x1000, 0xB4D0),(0x1000, 0xB4E0),(0x1000, 0xB4F0),(0x1000, 0xB500),(0x1000, 0xB510),(0x1000, 0xB520),(0x1000, 0xB530),(0x1000, 0xB540),(0x1000, 0xB550),(0x1000, 0xB560),(0x1000, 0xB570),(0x1000, 0xB580),(0x1000, 0xB590),(0x1000, 0xB5A0),(0x1000, 0xB5B0),(0x1000, 0xB5C0),(0x1000, 0xB5D0),(0x1000, 0xB5E0),(0x1000, 0xB5F0),(0x1000, 0xB600),(0x1000, 0xB610),(0x1000, 0xB620),(0x1000, 0xB630),(0x1000, 0xB640),(0x1000, 0xB650),(0x1000, 0xB660),(0x1000, 0xB670),(0x1000, 0xB680),(0x1000, 0xB690),(0x1000, 0xB6A0),(0x1000, 0xB6B0),(0x1000, 0xB6C0),(0x1000, 0xB6D0),(0x1000, 0xB6E0),(0x1000, 0xB6F0),(0x1000, 0xB700),(0x1000, 0xB710),(0x1000, 0xB720),(0x1000, 0xB730),(0x1000, 0xB740),(0x1000, 0xB750),(0x1000, 0xB760),(0x1000, 0xB770),(0x1000, 0xB780),(0x1000, 0xB790),(0x1000, 0xB7A0),(0x1000, 0xB7B0),(0x1000, 0xB7C0),(0x1000, 0xB7D0),(0x1000, 0xB7E0),(0x1000, 0xB7F0),(0x1000, 0xB800),(0x1000, 0xB810),(0x1000, 0xB820),(0x1000, 0xB830),(0x1000, 0xB840),(0x1000, 0xB850),(0x1000, 0xB860),(0x1000, 0xB870),(0x1000, 0xB880),(0x1000, 0xB890),(0x1000, 0xB8A0),(0x1000, 0xB8B0),(0x1000, 0xB8C0),(0x1000, 0xB8D0),(0x1000, 0xB8E0),(0x1000, 0xB8F0),(0x1000, 0xB900),(0x1000, 0xB910),(0x1000, 0xB920),(0x1000, 0xB930),(0x1000, 0xB940),(0x1000, 0xB950),(0x1000, 0xB960),(0x1000, 0xB970),(0x1000, 0xB980),(0x1000, 0xB990),(0x1000, 0xB9A0),(0x1000, 0xB9B0),(0x1000, 0xB9C0),(0x1000, 0xB9D0),(0x1000, 0xB9E0),(0x1000, 0xB9F0),(0x1000, 0xBA00),(0x1000, 0xBA10),(0x1000, 0xBA20),(0x1000, 0xBA30),(0x1000, 0xBA40),(0x1000, 0xBA50),(0x1000, 0xBA60),(0x1000, 0xBA70),(0x1000, 0xBA80),(0x1000, 0xBA90),(0x1000, 0xBAA0),(0x1000, 0xBAB0),(0x1000, 0xBAC0),(0x1000, 0xBAD0),(0x1000, 0xBAE0),(0x1000, 0xBAF0),(0x1000, 0xBB00),(0x1000, 0xBB10),(0x1000, 0xBB20),(0x1000, 0xBB30),(0x1000, 0xBB40),(0x1000, 0xBB50),(0x1000, 0xBB60),(0x1000, 0xBB70),(0x1000, 0xBB80),(0x1000, 0xBB90),(0x1000, 0xBBA0),(0x1000, 0xBBB0),(0x1000, 0xBBC0),(0x1000, 0xBBD0),(0x1000, 0xBBE0),(0x1000, 0xBBF0),(0x1000, 0xBC00),(0x1000, 0xBC10),(0x1000, 0xBC20),(0x1000, 0xBC30),(0x1000, 0xBC40),(0x1000, 0xBC50),(0x1000, 0xBC60),(0x1000, 0xBC70),(0x1000, 0xBC80),(0x1000, 0xBC90),(0x1000, 0xBCA0),(0x1000, 0xBCB0),(0x1000, 0xBCC0),(0x1000, 0xBCD0),(0x1000, 0xBCE0),(0x1000, 0xBCF0),(0x1000, 0xBD00),(0x1000, 0xBD10),(0x1000, 0xBD20),(0x1000, 0xBD30),(0x1000, 0xBD40),(0x1000, 0xBD50),(0x1000, 0xBD60),(0x1000, 0xBD70),(0x1000, 0xBD80),(0x1000, 0xBD90),(0x1000, 0xBDA0),(0x1000, 0xBDB0),(0x1000, 0xBDC0),(0x1000, 0xBDD0),(0x1000, 0xBDE0),(0x1000, 0xBDF0),(0x1000, 0xBE00),(0x1000, 0xBE10),(0x1000, 0xBE20),(0x1000, 0xBE30),(0x1000, 0xBE40),(0x1000, 0xBE50),(0x1000, 0xBE60),(0x1000, 0xBE70),(0x1000, 0xBE80),(0x1000, 0xBE90),(0x1000, 0xBEA0),(0x1000, 0xBEB0),(0x1000, 0xBEC0),(0x1000, 0xBED0),(0x1000, 0xBEE0),(0x1000, 0xBEF0),(0x1000, 0xBF00),(0x1000, 0xBF10),(0x1000, 0xBF20),(0x1000, 0xBF30),(0x1000, 0xBF40),(0x1000, 0xBF50),(0x1000, 0xBF60),(0x1000, 0xBF70),(0x1000, 0xBF80),(0x1000, 0xBF90),(0x1000, 0xBFA0),(0x1000, 0xBFB0),(0x1000, 0xBFC0),(0x1000, 0xBFD0),(0x1000, 0xBFE0),(0x1000, 0xBFF0),(0x1000, 0xC000),(0x1000, 0xC010),(0x1000, 0xC020),(0x1000, 0xC030),(0x1000, 0xC040),(0x1000, 0xC050),(0x1000, 0xC060),(0x1000, 0xC070),(0x1000, 0xC080),(0x1000, 0xC090),(0x1000, 0xC0A0),(0x1000, 0xC0B0),(0x1000, 0xC0C0),(0x1000, 0xC0D0),(0x1000, 0xC0E0),(0x1000, 0xC0F0),(0x1000, 0xC100),(0x1000, 0xC110),(0x1000, 0xC120),(0x1000, 0xC130),(0x1000, 0xC140),(0x1000, 0xC150),(0x1000, 0xC160),(0x1000, 0xC170),(0x1000, 0xC180),(0x1000, 0xC190),(0x1000, 0xC1A0),(0x1000, 0xC1B0),(0x1000, 0xC1C0),(0x1000, 0xC1D0),(0x1000, 0xC1E0),(0x1000, 0xC1F0),(0x1000, 0xC200),(0x1000, 0xC210),(0x1000, 0xC220),(0x1000, 0xC230),(0x1000, 0xC240),(0x1000, 0xC250),(0x1000, 0xC260),(0x1000, 0xC270),(0x1000, 0xC280),(0x1000, 0xC290),(0x1000, 0xC2A0),(0x1000, 0xC2B0),(0x1000, 0xC2C0),(0x1000, 0xC2D0),(0x1000, 0xC2E0),(0x1000, 0xC2F0),(0x1000, 0xC300),(0x1000, 0xC310),(0x1000, 0xC320),(0x1000, 0xC330),(0x1000, 0xC340),(0x1000, 0xC350),(0x1000, 0xC360),(0x1000, 0xC370),(0x1000, 0xC380),(0x1000, 0xC390),(0x1000, 0xC3A0),(0x1000, 0xC3B0),(0x1000, 0xC3C0),(0x1000, 0xC3D0),(0x1000, 0xC3E0),(0x1000, 0xC3F0),(0x1000, 0xC400),(0x1000, 0xC410),(0x1000, 0xC420),(0x1000, 0xC430),(0x1000, 0xC440),(0x1000, 0xC450),(0x1000, 0xC460),(0x1000, 0xC470),(0x1000, 0xC480),(0x1000, 0xC490),(0x1000, 0xC4A0),(0x1000, 0xC4B0),(0x1000, 0xC4C0),(0x1000, 0xC4D0),(0x1000, 0xC4E0),(0x1000, 0xC4F0),(0x1000, 0xC500),(0x1000, 0xC510),(0x1000, 0xC520),(0x1000, 0xC530),(0x1000, 0xC540),(0x1000, 0xC550),(0x1000, 0xC560),(0x1000, 0xC570),(0x1000, 0xC580),(0x1000, 0xC590),(0x1000, 0xC5A0),(0x1000, 0xC5B0),(0x1000, 0xC5C0),(0x1000, 0xC5D0),(0x1000, 0xC5E0),(0x1000, 0xC5F0),(0x1000, 0xC600),(0x1000, 0xC610),(0x1000, 0xC620),(0x1000, 0xC630),(0x1000, 0xC640),(0x1000, 0xC650),(0x1000, 0xC660),(0x1000, 0xC670),(0x1000, 0xC680),(0x1000, 0xC690),(0x1000, 0xC6A0),(0x1000, 0xC6B0),(0x1000, 0xC6C0),(0x1000, 0xC6D0),(0x1000, 0xC6E0),(0x1000, 0xC6F0),(0x1000, 0xC700),(0x1000, 0xC710),(0x1000, 0xC720),(0x1000, 0xC730),(0x1000, 0xC740),(0x1000, 0xC750),(0x1000, 0xC760),(0x1000, 0xC770),(0x1000, 0xC780),(0x1000, 0xC790),(0x1000, 0xC7A0),(0x1000, 0xC7B0),(0x1000, 0xC7C0),(0x1000, 0xC7D0),(0x1000, 0xC7E0),(0x1000, 0xC7F0),(0x1000, 0xC800),(0x1000, 0xC810),(0x1000, 0xC820),(0x1000, 0xC830),(0x1000, 0xC840),(0x1000, 0xC850),(0x1000, 0xC860),(0x1000, 0xC870),(0x1000, 0xC880),(0x1000, 0xC890),(0x1000, 0xC8A0),(0x1000, 0xC8B0),(0x1000, 0xC8C0),(0x1000, 0xC8D0),(0x1000, 0xC8E0),(0x1000, 0xC8F0),(0x1000, 0xC900),(0x1000, 0xC910),(0x1000, 0xC920),(0x1000, 0xC930),(0x1000, 0xC940),(0x1000, 0xC950),(0x1000, 0xC960),(0x1000, 0xC970),(0x1000, 0xC980),(0x1000, 0xC990),(0x1000, 0xC9A0),(0x1000, 0xC9B0),(0x1000, 0xC9C0),(0x1000, 0xC9D0),(0x1000, 0xC9E0),(0x1000, 0xC9F0),(0x1000, 0xCA00),(0x1000, 0xCA10),(0x1000, 0xCA20),(0x1000, 0xCA30),(0x1000, 0xCA40),(0x1000, 0xCA50),(0x1000, 0xCA60),(0x1000, 0xCA70),(0x1000, 0xCA80),(0x1000, 0xCA90),(0x1000, 0xCAA0),(0x1000, 0xCAB0),(0x1000, 0xCAC0),(0x1000, 0xCAD0),(0x1000, 0xCAE0),(0x1000, 0xCAF0),(0x1000, 0xCB00),(0x1000, 0xCB10),(0x1000, 0xCB20),(0x1000, 0xCB30),(0x1000, 0xCB40),(0x1000, 0xCB50),(0x1000, 0xCB60),(0x1000, 0xCB70),(0x1000, 0xCB80),(0x1000, 0xCB90),(0x1000, 0xCBA0),(0x1000, 0xCBB0),(0x1000, 0xCBC0),(0x1000, 0xCBD0),(0x1000, 0xCBE0),(0x1000, 0xCBF0),(0x1000, 0xCC00),(0x1000, 0xCC10),(0x1000, 0xCC20),(0x1000, 0xCC30),(0x1000, 0xCC40),(0x1000, 0xCC50),(0x1000, 0xCC60),(0x1000, 0xCC70),(0x1000, 0xCC80),(0x1000, 0xCC90),(0x1000, 0xCCA0),(0x1000, 0xCCB0),(0x1000, 0xCCC0),(0x1000, 0xCCD0),(0x1000, 0xCCE0),(0x1000, 0xCCF0),(0x1000, 0xCD00),(0x1000, 0xCD10),(0x1000, 0xCD20),(0x1000, 0xCD30),(0x1000, 0xCD40),(0x1000, 0xCD50),(0x1000, 0xCD60),(0x1000, 0xCD70),(0x1000, 0xCD80),(0x1000, 0xCD90),(0x1000, 0xCDA0),(0x1000, 0xCDB0),(0x1000, 0xCDC0),(0x1000, 0xCDD0),(0x1000, 0xCDE0),(0x1000, 0xCDF0),(0x1000, 0xCE00),(0x1000, 0xCE10),(0x1000, 0xCE20),(0x1000, 0xCE30),(0x1000, 0xCE40),(0x1000, 0xCE50),(0x1000, 0xCE60),(0x1000, 0xCE70),(0x1000, 0xCE80),(0x1000, 0xCE90),(0x1000, 0xCEA0),(0x1000, 0xCEB0),(0x1000, 0xCEC0),(0x1000, 0xCED0),(0x1000, 0xCEE0),(0x1000, 0xCEF0),(0x1000, 0xCF00),(0x1000, 0xCF10),(0x1000, 0xCF20),(0x1000, 0xCF30),(0x1000, 0xCF40),(0x1000, 0xCF50),(0x1000, 0xCF60),(0x1000, 0xCF70),(0x1000, 0xCF80),(0x1000, 0xCF90),(0x1000, 0xCFA0),(0x1000, 0xCFB0),(0x1000, 0xCFC0),(0x1000, 0xCFD0),(0x1000, 0xCFE0),(0x1000, 0xCFF0),(0x1000, 0xD000),(0x1000, 0xD010),(0x1000, 0xD020),(0x1000, 0xD030),(0x1000, 0xD040),(0x1000, 0xD050),(0x1000, 0xD060),(0x1000, 0xD070),(0x1000, 0xD080),(0x1000, 0xD090),(0x1000, 0xD0A0),(0x1000, 0xD0B0),(0x1000, 0xD0C0),(0x1000, 0xD0D0),(0x1000, 0xD0E0),(0x1000, 0xD0F0),(0x1000, 0xD100),(0x1000, 0xD110),(0x1000, 0xD120),(0x1000, 0xD130),(0x1000, 0xD140),(0x1000, 0xD150),(0x1000, 0xD160),(0x1000, 0xD170),(0x1000, 0xD180),(0x1000, 0xD190),(0x1000, 0xD1A0),(0x1000, 0xD1B0),(0x1000, 0xD1C0),(0x1000, 0xD1D0),(0x1000, 0xD1E0),(0x1000, 0xD1F0),(0x1000, 0xD200),(0x1000, 0xD210),(0x1000, 0xD220),(0x1000, 0xD230),(0x1000, 0xD240),(0x1000, 0xD250),(0x1000, 0xD260),(0x1000, 0xD270),(0x1000, 0xD280),(0x1000, 0xD290),(0x1000, 0xD2A0),(0x1000, 0xD2B0),(0x1000, 0xD2C0),(0x1000, 0xD2D0),(0x1000, 0xD2E0),(0x1000, 0xD2F0),(0x1000, 0xD300),(0x1000, 0xD310),(0x1000, 0xD320),(0x1000, 0xD330),(0x1000, 0xD340),(0x1000, 0xD350),(0x1000, 0xD360),(0x1000, 0xD370),(0x1000, 0xD380),(0x1000, 0xD390),(0x1000, 0xD3A0),(0x1000, 0xD3B0),(0x1000, 0xD3C0),(0x1000, 0xD3D0),(0x1000, 0xD3E0),(0x1000, 0xD3F0),(0x1000, 0xD400),(0x1000, 0xD410),(0x1000, 0xD420),(0x1000, 0xD430),(0x1000, 0xD440),(0x1000, 0xD450),(0x1000, 0xD460),(0x1000, 0xD470),(0x1000, 0xD480),(0x1000, 0xD490),(0x1000, 0xD4A0),(0x1000, 0xD4B0),(0x1000, 0xD4C0),(0x1000, 0xD4D0),(0x1000, 0xD4E0),(0x1000, 0xD4F0),(0x1000, 0xD500),(0x1000, 0xD510),(0x1000, 0xD520),(0x1000, 0xD530),(0x1000, 0xD540),(0x1000, 0xD550),(0x1000, 0xD560),(0x1000, 0xD570),(0x1000, 0xD580),(0x1000, 0xD590),(0x1000, 0xD5A0),(0x1000, 0xD5B0),(0x1000, 0xD5C0),(0x1000, 0xD5D0),(0x1000, 0xD5E0),(0x1000, 0xD5F0),(0x1000, 0xD600),(0x1000, 0xD610),(0x1000, 0xD620),(0x1000, 0xD630),(0x1000, 0xD640),(0x1000, 0xD650),(0x1000, 0xD660),(0x1000, 0xD670),(0x1000, 0xD680),(0x1000, 0xD690),(0x1000, 0xD6A0),(0x1000, 0xD6B0),(0x1000, 0xD6C0),(0x1000, 0xD6D0),(0x1000, 0xD6E0),(0x1000, 0xD6F0),(0x1000, 0xD700),(0x1000, 0xD710),(0x1000, 0xD720),(0x1000, 0xD730),(0x1000, 0xD740),(0x1000, 0xD750),(0x1000, 0xD760),(0x1000, 0xD770),(0x1000, 0xD780),(0x1000, 0xD790),(0x1000, 0xD7A0),(0x1000, 0xD7B0),(0x1000, 0xD7C0),(0x1000, 0xD7D0),(0x1000, 0xD7E0),(0x1000, 0xD7F0),(0x1000, 0xD800),(0x1000, 0xD810),(0x1000, 0xD820),(0x1000, 0xD830),(0x1000, 0xD840),(0x1000, 0xD850),(0x1000, 0xD860),(0x1000, 0xD870),(0x1000, 0xD880),(0x1000, 0xD890),(0x1000, 0xD8A0),(0x1000, 0xD8B0),(0x1000, 0xD8C0),(0x1000, 0xD8D0),(0x1000, 0xD8E0),(0x1000, 0xD8F0),(0x1000, 0xD900),(0x1000, 0xD910),(0x1000, 0xD920),(0x1000, 0xD930),(0x1000, 0xD940),(0x1000, 0xD950),(0x1000, 0xD960),(0x1000, 0xD970),(0x1000, 0xD980),(0x1000, 0xD990),(0x1000, 0xD9A0),(0x1000, 0xD9B0),(0x1000, 0xD9C0),(0x1000, 0xD9D0),(0x1000, 0xD9E0),(0x1000, 0xD9F0),(0x1000, 0xDA00),(0x1000, 0xDA10),(0x1000, 0xDA20),(0x1000, 0xDA30),(0x1000, 0xDA40),(0x1000, 0xDA50),(0x1000, 0xDA60),(0x1000, 0xDA70),(0x1000, 0xDA80),(0x1000, 0xDA90),(0x1000, 0xDAA0),(0x1000, 0xDAB0),(0x1000, 0xDAC0),(0x1000, 0xDAD0),(0x1000, 0xDAE0),(0x1000, 0xDAF0),(0x1000, 0xDB00),(0x1000, 0xDB10),(0x1000, 0xDB20),(0x1000, 0xDB30),(0x1000, 0xDB40),(0x1000, 0xDB50),(0x1000, 0xDB60),(0x1000, 0xDB70),(0x1000, 0xDB80),(0x1000, 0xDB90),(0x1000, 0xDBA0),(0x1000, 0xDBB0),(0x1000, 0xDBC0),(0x1000, 0xDBD0),(0x1000, 0xDBE0),(0x1000, 0xDBF0),(0x1000, 0xDC00),(0x1000, 0xDC10),(0x1000, 0xDC20),(0x1000, 0xDC30),(0x1000, 0xDC40),(0x1000, 0xDC50),(0x1000, 0xDC60),(0x1000, 0xDC70),(0x1000, 0xDC80),(0x1000, 0xDC90),(0x1000, 0xDCA0),(0x1000, 0xDCB0),(0x1000, 0xDCC0),(0x1000, 0xDCD0),(0x1000, 0xDCE0),(0x1000, 0xDCF0),(0x1000, 0xDD00),(0x1000, 0xDD10),(0x1000, 0xDD20),(0x1000, 0xDD30),(0x1000, 0xDD40),(0x1000, 0xDD50),(0x1000, 0xDD60),(0x1000, 0xDD70),(0x1000, 0xDD80),(0x1000, 0xDD90),(0x1000, 0xDDA0),(0x1000, 0xDDB0),(0x1000, 0xDDC0),(0x1000, 0xDDD0),(0x1000, 0xDDE0),(0x1000, 0xDDF0),(0x1000, 0xDE00),(0x1000, 0xDE10),(0x1000, 0xDE20),(0x1000, 0xDE30),(0x1000, 0xDE40),(0x1000, 0xDE50),(0x1000, 0xDE60),(0x1000, 0xDE70),(0x1000, 0xDE80),(0x1000, 0xDE90),(0x1000, 0xDEA0),(0x1000, 0xDEB0),(0x1000, 0xDEC0),(0x1000, 0xDED0),(0x1000, 0xDEE0),(0x1000, 0xDEF0),(0x1000, 0xDF00),(0x1000, 0xDF10),(0x1000, 0xDF20),(0x1000, 0xDF30),(0x1000, 0xDF40),(0x1000, 0xDF50),(0x1000, 0xDF60),(0x1000, 0xDF70),(0x1000, 0xDF80),(0x1000, 0xDF90),(0x1000, 0xDFA0),(0x1000, 0xDFB0),(0x1000, 0xDFC0),(0x1000, 0xDFD0),(0x1000, 0xDFE0),(0x1000, 0xDFF0),(0x1000, 0xE000),(0x1000, 0xE010),(0x1000, 0xE020),(0x1000, 0xE030),(0x1000, 0xE040),(0x1000, 0xE050),(0x1000, 0xE060),(0x1000, 0xE070),(0x1000, 0xE080),(0x1000, 0xE090),(0x1000, 0xE0A0),(0x1000, 0xE0B0),(0x1000, 0xE0C0),(0x1000, 0xE0D0),(0x1000, 0xE0E0),(0x1000, 0xE0F0),(0x1000, 0xE100),(0x1000, 0xE110),(0x1000, 0xE120),(0x1000, 0xE130),(0x1000, 0xE140),(0x1000, 0xE150),(0x1000, 0xE160),(0x1000, 0xE170),(0x1000, 0xE180),(0x1000, 0xE190),(0x1000, 0xE1A0),(0x1000, 0xE1B0),(0x1000, 0xE1C0),(0x1000, 0xE1D0),(0x1000, 0xE1E0),(0x1000, 0xE1F0),(0x1000, 0xE200),(0x1000, 0xE210),(0x1000, 0xE220),(0x1000, 0xE230),(0x1000, 0xE240),(0x1000, 0xE250),(0x1000, 0xE260),(0x1000, 0xE270),(0x1000, 0xE280),(0x1000, 0xE290),(0x1000, 0xE2A0),(0x1000, 0xE2B0),(0x1000, 0xE2C0),(0x1000, 0xE2D0),(0x1000, 0xE2E0),(0x1000, 0xE2F0),(0x1000, 0xE300),(0x1000, 0xE310),(0x1000, 0xE320),(0x1000, 0xE330),(0x1000, 0xE340),(0x1000, 0xE350),(0x1000, 0xE360),(0x1000, 0xE370),(0x1000, 0xE380),(0x1000, 0xE390),(0x1000, 0xE3A0),(0x1000, 0xE3B0),(0x1000, 0xE3C0),(0x1000, 0xE3D0),(0x1000, 0xE3E0),(0x1000, 0xE3F0),(0x1000, 0xE400),(0x1000, 0xE410),(0x1000, 0xE420),(0x1000, 0xE430),(0x1000, 0xE440),(0x1000, 0xE450),(0x1000, 0xE460),(0x1000, 0xE470),(0x1000, 0xE480),(0x1000, 0xE490),(0x1000, 0xE4A0),(0x1000, 0xE4B0),(0x1000, 0xE4C0),(0x1000, 0xE4D0),(0x1000, 0xE4E0),(0x1000, 0xE4F0),(0x1000, 0xE500),(0x1000, 0xE510),(0x1000, 0xE520),(0x1000, 0xE530),(0x1000, 0xE540),(0x1000, 0xE550),(0x1000, 0xE560),(0x1000, 0xE570),(0x1000, 0xE580),(0x1000, 0xE590),(0x1000, 0xE5A0),(0x1000, 0xE5B0),(0x1000, 0xE5C0),(0x1000, 0xE5D0),(0x1000, 0xE5E0),(0x1000, 0xE5F0),(0x1000, 0xE600),(0x1000, 0xE610),(0x1000, 0xE620),(0x1000, 0xE630),(0x1000, 0xE640),(0x1000, 0xE650),(0x1000, 0xE660),(0x1000, 0xE670),(0x1000, 0xE680),(0x1000, 0xE690),(0x1000, 0xE6A0),(0x1000, 0xE6B0),(0x1000, 0xE6C0),(0x1000, 0xE6D0),(0x1000, 0xE6E0),(0x1000, 0xE6F0),(0x1000, 0xE700),(0x1000, 0xE710),(0x1000, 0xE720),(0x1000, 0xE730),(0x1000, 0xE740),(0x1000, 0xE750),(0x1000, 0xE760),(0x1000, 0xE770),(0x1000, 0xE780),(0x1000, 0xE790),(0x1000, 0xE7A0),(0x1000, 0xE7B0),(0x1000, 0xE7C0),(0x1000, 0xE7D0),(0x1000, 0xE7E0),(0x1000, 0xE7F0),(0x1000, 0xE800),(0x1000, 0xE810),(0x1000, 0xE820),(0x1000, 0xE830),(0x1000, 0xE840),(0x1000, 0xE850),(0x1000, 0xE860),(0x1000, 0xE870),(0x1000, 0xE880),(0x1000, 0xE890),(0x1000, 0xE8A0),(0x1000, 0xE8B0),(0x1000, 0xE8C0),(0x1000, 0xE8D0),(0x1000, 0xE8E0),(0x1000, 0xE8F0),(0x1000, 0xE900),(0x1000, 0xE910),(0x1000, 0xE920),(0x1000, 0xE930),(0x1000, 0xE940),(0x1000, 0xE950),(0x1000, 0xE960),(0x1000, 0xE970),(0x1000, 0xE980),(0x1000, 0xE990),(0x1000, 0xE9A0),(0x1000, 0xE9B0),(0x1000, 0xE9C0),(0x1000, 0xE9D0),(0x1000, 0xE9E0),(0x1000, 0xE9F0),(0x1000, 0xEA00),(0x1000, 0xEA10),(0x1000, 0xEA20),(0x1000, 0xEA30),(0x1000, 0xEA40),(0x1000, 0xEA50),(0x1000, 0xEA60),(0x1000, 0xEA70),(0x1000, 0xEA80),(0x1000, 0xEA90),(0x1000, 0xEAA0),(0x1000, 0xEAB0),(0x1000, 0xEAC0),(0x1000, 0xEAD0),(0x1000, 0xEAE0),(0x1000, 0xEAF0),(0x1000, 0xEB00),(0x1000, 0xEB10),(0x1000, 0xEB20),(0x1000, 0xEB30),(0x1000, 0xEB40),(0x1000, 0xEB50),(0x1000, 0xEB60),(0x1000, 0xEB70),(0x1000, 0xEB80),(0x1000, 0xEB90),(0x1000, 0xEBA0),(0x1000, 0xEBB0),(0x1000, 0xEBC0),(0x1000, 0xEBD0),(0x1000, 0xEBE0),(0x1000, 0xEBF0),(0x1000, 0xEC00),(0x1000, 0xEC10),(0x1000, 0xEC20),(0x1000, 0xEC30),(0x1000, 0xEC40),(0x1000, 0xEC50),(0x1000, 0xEC60),(0x1000, 0xEC70),(0x1000, 0xEC80),(0x1000, 0xEC90),(0x1000, 0xECA0),(0x1000, 0xECB0),(0x1000, 0xECC0),(0x1000, 0xECD0),(0x1000, 0xECE0),(0x1000, 0xECF0),(0x1000, 0xED00),(0x1000, 0xED10),(0x1000, 0xED20),(0x1000, 0xED30),(0x1000, 0xED40),(0x1000, 0xED50),(0x1000, 0xED60),(0x1000, 0xED70),(0x1000, 0xED80),(0x1000, 0xED90),(0x1000, 0xEDA0),(0x1000, 0xEDB0),(0x1000, 0xEDC0),(0x1000, 0xEDD0),(0x1000, 0xEDE0),(0x1000, 0xEDF0),(0x1000, 0xEE00),(0x1000, 0xEE10),(0x1000, 0xEE20),(0x1000, 0xEE30),(0x1000, 0xEE40),(0x1000, 0xEE50),(0x1000, 0xEE60),(0x1000, 0xEE70),(0x1000, 0xEE80),(0x1000, 0xEE90),(0x1000, 0xEEA0),(0x1000, 0xEEB0),(0x1000, 0xEEC0),(0x1000, 0xEED0),(0x1000, 0xEEE0),(0x1000, 0xEEF0),(0x1000, 0xEF00),(0x1000, 0xEF10),(0x1000, 0xEF20),(0x1000, 0xEF30),(0x1000, 0xEF40),(0x1000, 0xEF50),(0x1000, 0xEF60),(0x1000, 0xEF70),(0x1000, 0xEF80),(0x1000, 0xEF90),(0x1000, 0xEFA0),(0x1000, 0xEFB0),(0x1000, 0xEFC0),(0x1000, 0xEFD0),(0x1000, 0xEFE0),(0x1000, 0xEFF0),(0x1000, 0xF000),(0x1000, 0xF010),(0x1000, 0xF020),(0x1000, 0xF030),(0x1000, 0xF040),(0x1000, 0xF050),(0x1000, 0xF060),(0x1000, 0xF070),(0x1000, 0xF080),(0x1000, 0xF090),(0x1000, 0xF0A0),(0x1000, 0xF0B0),(0x1000, 0xF0C0),(0x1000, 0xF0D0),(0x1000, 0xF0E0),(0x1000, 0xF0F0),(0x1000, 0xF100),(0x1000, 0xF110),(0x1000, 0xF120),(0x1000, 0xF130),(0x1000, 0xF140),(0x1000, 0xF150),(0x1000, 0xF160),(0x1000, 0xF170),(0x1000, 0xF180),(0x1000, 0xF190),(0x1000, 0xF1A0),(0x1000, 0xF1B0),(0x1000, 0xF1C0),(0x1000, 0xF1D0),(0x1000, 0xF1E0),(0x1000, 0xF1F0),(0x1000, 0xF200),(0x1000, 0xF210),(0x1000, 0xF220),(0x1000, 0xF230),(0x1000, 0xF240),(0x1000, 0xF250),(0x1000, 0xF260),(0x1000, 0xF270),(0x1000, 0xF280),(0x1000, 0xF290),(0x1000, 0xF2A0),(0x1000, 0xF2B0),(0x1000, 0xF2C0),(0x1000, 0xF2D0),(0x1000, 0xF2E0),(0x1000, 0xF2F0),(0x1000, 0xF300),(0x1000, 0xF310),(0x1000, 0xF320),(0x1000, 0xF330),(0x1000, 0xF340),(0x1000, 0xF350),(0x1000, 0xF360),(0x1000, 0xF370),(0x1000, 0xF380),(0x1000, 0xF390),(0x1000, 0xF3A0),(0x1000, 0xF3B0),(0x1000, 0xF3C0),(0x1000, 0xF3D0),(0x1000, 0xF3E0),(0x1000, 0xF3F0),(0x1000, 0xF400),(0x1000, 0xF410),(0x1000, 0xF420),(0x1000, 0xF430),(0x1000, 0xF440),(0x1000, 0xF450),(0x1000, 0xF460),(0x1000, 0xF470),(0x1000, 0xF480),(0x1000, 0xF490),(0x1000, 0xF4A0),(0x1000, 0xF4B0),(0x1000, 0xF4C0),(0x1000, 0xF4D0),(0x1000, 0xF4E0),(0x1000, 0xF4F0),(0x1000, 0xF500),(0x1000, 0xF510),(0x1000, 0xF520),(0x1000, 0xF530),(0x1000, 0xF540),(0x1000, 0xF550),(0x1000, 0xF560),(0x1000, 0xF570),(0x1000, 0xF580),(0x1000, 0xF590),(0x1000, 0xF5A0),(0x1000, 0xF5B0),(0x1000, 0xF5C0),(0x1000, 0xF5D0),(0x1000, 0xF5E0),(0x1000, 0xF5F0),(0x1000, 0xF600),(0x1000, 0xF610),(0x1000, 0xF620),(0x1000, 0xF630),(0x1000, 0xF640),(0x1000, 0xF650),(0x1000, 0xF660),(0x1000, 0xF670),(0x1000, 0xF680),(0x1000, 0xF690),(0x1000, 0xF6A0),(0x1000, 0xF6B0),(0x1000, 0xF6C0),(0x1000, 0xF6D0),(0x1000, 0xF6E0),(0x1000, 0xF6F0),(0x1000, 0xF700),(0x1000, 0xF710),(0x1000, 0xF720),(0x1000, 0xF730),(0x1000, 0xF740),(0x1000, 0xF750),(0x1000, 0xF760),(0x1000, 0xF770),(0x1000, 0xF780),(0x1000, 0xF790),(0x1000, 0xF7A0),(0x1000, 0xF7B0),(0x1000, 0xF7C0),(0x1000, 0xF7D0),(0x1000, 0xF7E0),(0x1000, 0xF7F0),(0x1000, 0xF800),(0x1000, 0xF810),(0x1000, 0xF820),(0x1000, 0xF830),(0x1000, 0xF840),(0x1000, 0xF850),(0x1000, 0xF860),(0x1000, 0xF870),(0x1000, 0xF880),(0x1000, 0xF890),(0x1000, 0xF8A0),(0x1000, 0xF8B0),(0x1000, 0xF8C0),(0x1000, 0xF8D0),(0x1000, 0xF8E0),(0x1000, 0xF8F0),(0x1000, 0xF900),(0x1000, 0xF910),(0x1000, 0xF920),(0x1000, 0xF930),(0x1000, 0xF940),(0x1000, 0xF950),(0x1000, 0xF960),(0x1000, 0xF970),(0x1000, 0xF980),(0x1000, 0xF990),(0x1000, 0xF9A0),(0x1000, 0xF9B0),(0x1000, 0xF9C0),(0x1000, 0xF9D0),(0x1000, 0xF9E0),(0x1000, 0xF9F0),(0x1000, 0xFA00),(0x1000, 0xFA10),(0x1000, 0xFA20),(0x1000, 0xFA30),(0x1000, 0xFA40),(0x1000, 0xFA50),(0x1000, 0xFA60),(0x1000, 0xFA70),(0x1000, 0xFA80),(0x1000, 0xFA90),(0x1000, 0xFAA0),(0x1000, 0xFAB0),(0x1000, 0xFAC0),(0x1000, 0xFAD0),(0x1000, 0xFAE0),(0x1000, 0xFAF0),(0x1000, 0xFB00),(0x1000, 0xFB10),(0x1000, 0xFB20),(0x1000, 0xFB30),(0x1000, 0xFB40),(0x1000, 0xFB50),(0x1000, 0xFB60),(0x1000, 0xFB70),(0x1000, 0xFB80),(0x1000, 0xFB90),(0x1000, 0xFBA0),(0x1000, 0xFBB0),(0x1000, 0xFBC0),(0x1000, 0xFBD0),(0x1000, 0xFBE0),(0x1000, 0xFBF0),(0x1000, 0xFC00),(0x1000, 0xFC10),(0x1000, 0xFC20),(0x1000, 0xFC30),(0x1000, 0xFC40),(0x1000, 0xFC50),(0x1000, 0xFC60),(0x1000, 0xFC70),(0x1000, 0xFC80),(0x1000, 0xFC90),(0x1000, 0xFCA0),(0x1000, 0xFCB0),(0x1000, 0xFCC0),(0x1000, 0xFCD0),(0x1000, 0xFCE0),(0x1000, 0xFCF0),(0x1000, 0xFD00),(0x1000, 0xFD10),(0x1000, 0xFD20),(0x1000, 0xFD30),(0x1000, 0xFD40),(0x1000, 0xFD50),(0x1000, 0xFD60),(0x1000, 0xFD70),(0x1000, 0xFD80),(0x1000, 0xFD90),(0x1000, 0xFDA0),(0x1000, 0xFDB0),(0x1000, 0xFDC0),(0x1000, 0xFDD0),(0x1000, 0xFDE0),(0x1000, 0xFDF0),(0x1000, 0xFE00),(0x1000, 0xFE10),(0x1000, 0xFE20),(0x1000, 0xFE30),(0x1000, 0xFE40),(0x1000, 0xFE50),(0x1000, 0xFE60),(0x1000, 0xFE70),(0x1000, 0xFE80),(0x1000, 0xFE90),(0x1000, 0xFEA0),(0x1000, 0xFEB0),(0x1000, 0xFEC0),(0x1000, 0xFED0),(0x1000, 0xFEE0),(0x1000, 0xFEF0),(0x1000, 0xFF00),(0x1000, 0xFF10),(0x1000, 0xFF20),(0x1000, 0xFF30),(0x1000, 0xFF40),(0x1000, 0xFF50),(0x1000, 0xFF60),(0x1000, 0xFF70),(0x1000, 0xFF80),(0x1000, 0xFF90),(0x1000, 0xFFA0),(0x1000, 0xFFB0),(0x1000, 0xFFC0),(0x1000, 0xFFD0),(0x1000, 0xFFE0),(0x1000, 0xFFF0),])
    RunLengthTriplet = Tag('Run Length Triplet', "RunLengthTriplet", 0x1000, 0x0001, [], [(0x1000, 0x0011),(0x1000, 0x0021),(0x1000, 0x0031),(0x1000, 0x0041),(0x1000, 0x0051),(0x1000, 0x0061),(0x1000, 0x0071),(0x1000, 0x0081),(0x1000, 0x0091),(0x1000, 0x00A1),(0x1000, 0x00B1),(0x1000, 0x00C1),(0x1000, 0x00D1),(0x1000, 0x00E1),(0x1000, 0x00F1),(0x1000, 0x0101),(0x1000, 0x0111),(0x1000, 0x0121),(0x1000, 0x0131),(0x1000, 0x0141),(0x1000, 0x0151),(0x1000, 0x0161),(0x1000, 0x0171),(0x1000, 0x0181),(0x1000, 0x0191),(0x1000, 0x01A1),(0x1000, 0x01B1),(0x1000, 0x01C1),(0x1000, 0x01D1),(0x1000, 0x01E1),(0x1000, 0x01F1),(0x1000, 0x0201),(0x1000, 0x0211),(0x1000, 0x0221),(0x1000, 0x0231),(0x1000, 0x0241),(0x1000, 0x0251),(0x1000, 0x0261),(0x1000, 0x0271),(0x1000, 0x0281),(0x1000, 0x0291),(0x1000, 0x02A1),(0x1000, 0x02B1),(0x1000, 0x02C1),(0x1000, 0x02D1),(0x1000, 0x02E1),(0x1000, 0x02F1),(0x1000, 0x0301),(0x1000, 0x0311),(0x1000, 0x0321),(0x1000, 0x0331),(0x1000, 0x0341),(0x1000, 0x0351),(0x1000, 0x0361),(0x1000, 0x0371),(0x1000, 0x0381),(0x1000, 0x0391),(0x1000, 0x03A1),(0x1000, 0x03B1),(0x1000, 0x03C1),(0x1000, 0x03D1),(0x1000, 0x03E1),(0x1000, 0x03F1),(0x1000, 0x0401),(0x1000, 0x0411),(0x1000, 0x0421),(0x1000, 0x0431),(0x1000, 0x0441),(0x1000, 0x0451),(0x1000, 0x0461),(0x1000, 0x0471),(0x1000, 0x0481),(0x1000, 0x0491),(0x1000, 0x04A1),(0x1000, 0x04B1),(0x1000, 0x04C1),(0x1000, 0x04D1),(0x1000, 0x04E1),(0x1000, 0x04F1),(0x1000, 0x0501),(0x1000, 0x0511),(0x1000, 0x0521),(0x1000, 0x0531),(0x1000, 0x0541),(0x1000, 0x0551),(0x1000, 0x0561),(0x1000, 0x0571),(0x1000, 0x0581),(0x1000, 0x0591),(0x1000, 0x05A1),(0x1000, 0x05B1),(0x1000, 0x05C1),(0x1000, 0x05D1),(0x1000, 0x05E1),(0x1000, 0x05F1),(0x1000, 0x0601),(0x1000, 0x0611),(0x1000, 0x0621),(0x1000, 0x0631),(0x1000, 0x0641),(0x1000, 0x0651),(0x1000, 0x0661),(0x1000, 0x0671),(0x1000, 0x0681),(0x1000, 0x0691),(0x1000, 0x06A1),(0x1000, 0x06B1),(0x1000, 0x06C1),(0x1000, 0x06D1),(0x1000, 0x06E1),(0x1000, 0x06F1),(0x1000, 0x0701),(0x1000, 0x0711),(0x1000, 0x0721),(0x1000, 0x0731),(0x1000, 0x0741),(0x1000, 0x0751),(0x1000, 0x0761),(0x1000, 0x0771),(0x1000, 0x0781),(0x1000, 0x0791),(0x1000, 0x07A1),(0x1000, 0x07B1),(0x1000, 0x07C1),(0x1000, 0x07D1),(0x1000, 0x07E1),(0x1000, 0x07F1),(0x1000, 0x0801),(0x1000, 0x0811),(0x1000, 0x0821),(0x1000, 0x0831),(0x1000, 0x0841),(0x1000, 0x0851),(0x1000, 0x0861),(0x1000, 0x0871),(0x1000, 0x0881),(0x1000, 0x0891),(0x1000, 0x08A1),(0x1000, 0x08B1),(0x1000, 0x08C1),(0x1000, 0x08D1),(0x1000, 0x08E1),(0x1000, 0x08F1),(0x1000, 0x0901),(0x1000, 0x0911),(0x1000, 0x0921),(0x1000, 0x0931),(0x1000, 0x0941),(0x1000, 0x0951),(0x1000, 0x0961),(0x1000, 0x0971),(0x1000, 0x0981),(0x1000, 0x0991),(0x1000, 0x09A1),(0x1000, 0x09B1),(0x1000, 0x09C1),(0x1000, 0x09D1),(0x1000, 0x09E1),(0x1000, 0x09F1),(0x1000, 0x0A01),(0x1000, 0x0A11),(0x1000, 0x0A21),(0x1000, 0x0A31),(0x1000, 0x0A41),(0x1000, 0x0A51),(0x1000, 0x0A61),(0x1000, 0x0A71),(0x1000, 0x0A81),(0x1000, 0x0A91),(0x1000, 0x0AA1),(0x1000, 0x0AB1),(0x1000, 0x0AC1),(0x1000, 0x0AD1),(0x1000, 0x0AE1),(0x1000, 0x0AF1),(0x1000, 0x0B01),(0x1000, 0x0B11),(0x1000, 0x0B21),(0x1000, 0x0B31),(0x1000, 0x0B41),(0x1000, 0x0B51),(0x1000, 0x0B61),(0x1000, 0x0B71),(0x1000, 0x0B81),(0x1000, 0x0B91),(0x1000, 0x0BA1),(0x1000, 0x0BB1),(0x1000, 0x0BC1),(0x1000, 0x0BD1),(0x1000, 0x0BE1),(0x1000, 0x0BF1),(0x1000, 0x0C01),(0x1000, 0x0C11),(0x1000, 0x0C21),(0x1000, 0x0C31),(0x1000, 0x0C41),(0x1000, 0x0C51),(0x1000, 0x0C61),(0x1000, 0x0C71),(0x1000, 0x0C81),(0x1000, 0x0C91),(0x1000, 0x0CA1),(0x1000, 0x0CB1),(0x1000, 0x0CC1),(0x1000, 0x0CD1),(0x1000, 0x0CE1),(0x1000, 0x0CF1),(0x1000, 0x0D01),(0x1000, 0x0D11),(0x1000, 0x0D21),(0x1000, 0x0D31),(0x1000, 0x0D41),(0x1000, 0x0D51),(0x1000, 0x0D61),(0x1000, 0x0D71),(0x1000, 0x0D81),(0x1000, 0x0D91),(0x1000, 0x0DA1),(0x1000, 0x0DB1),(0x1000, 0x0DC1),(0x1000, 0x0DD1),(0x1000, 0x0DE1),(0x1000, 0x0DF1),(0x1000, 0x0E01),(0x1000, 0x0E11),(0x1000, 0x0E21),(0x1000, 0x0E31),(0x1000, 0x0E41),(0x1000, 0x0E51),(0x1000, 0x0E61),(0x1000, 0x0E71),(0x1000, 0x0E81),(0x1000, 0x0E91),(0x1000, 0x0EA1),(0x1000, 0x0EB1),(0x1000, 0x0EC1),(0x1000, 0x0ED1),(0x1000, 0x0EE1),(0x1000, 0x0EF1),(0x1000, 0x0F01),(0x1000, 0x0F11),(0x1000, 0x0F21),(0x1000, 0x0F31),(0x1000, 0x0F41),(0x1000, 0x0F51),(0x1000, 0x0F61),(0x1000, 0x0F71),(0x1000, 0x0F81),(0x1000, 0x0F91),(0x1000, 0x0FA1),(0x1000, 0x0FB1),(0x1000, 0x0FC1),(0x1000, 0x0FD1),(0x1000, 0x0FE1),(0x1000, 0x0FF1),(0x1000, 0x1001),(0x1000, 0x1011),(0x1000, 0x1021),(0x1000, 0x1031),(0x1000, 0x1041),(0x1000, 0x1051),(0x1000, 0x1061),(0x1000, 0x1071),(0x1000, 0x1081),(0x1000, 0x1091),(0x1000, 0x10A1),(0x1000, 0x10B1),(0x1000, 0x10C1),(0x1000, 0x10D1),(0x1000, 0x10E1),(0x1000, 0x10F1),(0x1000, 0x1101),(0x1000, 0x1111),(0x1000, 0x1121),(0x1000, 0x1131),(0x1000, 0x1141),(0x1000, 0x1151),(0x1000, 0x1161),(0x1000, 0x1171),(0x1000, 0x1181),(0x1000, 0x1191),(0x1000, 0x11A1),(0x1000, 0x11B1),(0x1000, 0x11C1),(0x1000, 0x11D1),(0x1000, 0x11E1),(0x1000, 0x11F1),(0x1000, 0x1201),(0x1000, 0x1211),(0x1000, 0x1221),(0x1000, 0x1231),(0x1000, 0x1241),(0x1000, 0x1251),(0x1000, 0x1261),(0x1000, 0x1271),(0x1000, 0x1281),(0x1000, 0x1291),(0x1000, 0x12A1),(0x1000, 0x12B1),(0x1000, 0x12C1),(0x1000, 0x12D1),(0x1000, 0x12E1),(0x1000, 0x12F1),(0x1000, 0x1301),(0x1000, 0x1311),(0x1000, 0x1321),(0x1000, 0x1331),(0x1000, 0x1341),(0x1000, 0x1351),(0x1000, 0x1361),(0x1000, 0x1371),(0x1000, 0x1381),(0x1000, 0x1391),(0x1000, 0x13A1),(0x1000, 0x13B1),(0x1000, 0x13C1),(0x1000, 0x13D1),(0x1000, 0x13E1),(0x1000, 0x13F1),(0x1000, 0x1401),(0x1000, 0x1411),(0x1000, 0x1421),(0x1000, 0x1431),(0x1000, 0x1441),(0x1000, 0x1451),(0x1000, 0x1461),(0x1000, 0x1471),(0x1000, 0x1481),(0x1000, 0x1491),(0x1000, 0x14A1),(0x1000, 0x14B1),(0x1000, 0x14C1),(0x1000, 0x14D1),(0x1000, 0x14E1),(0x1000, 0x14F1),(0x1000, 0x1501),(0x1000, 0x1511),(0x1000, 0x1521),(0x1000, 0x1531),(0x1000, 0x1541),(0x1000, 0x1551),(0x1000, 0x1561),(0x1000, 0x1571),(0x1000, 0x1581),(0x1000, 0x1591),(0x1000, 0x15A1),(0x1000, 0x15B1),(0x1000, 0x15C1),(0x1000, 0x15D1),(0x1000, 0x15E1),(0x1000, 0x15F1),(0x1000, 0x1601),(0x1000, 0x1611),(0x1000, 0x1621),(0x1000, 0x1631),(0x1000, 0x1641),(0x1000, 0x1651),(0x1000, 0x1661),(0x1000, 0x1671),(0x1000, 0x1681),(0x1000, 0x1691),(0x1000, 0x16A1),(0x1000, 0x16B1),(0x1000, 0x16C1),(0x1000, 0x16D1),(0x1000, 0x16E1),(0x1000, 0x16F1),(0x1000, 0x1701),(0x1000, 0x1711),(0x1000, 0x1721),(0x1000, 0x1731),(0x1000, 0x1741),(0x1000, 0x1751),(0x1000, 0x1761),(0x1000, 0x1771),(0x1000, 0x1781),(0x1000, 0x1791),(0x1000, 0x17A1),(0x1000, 0x17B1),(0x1000, 0x17C1),(0x1000, 0x17D1),(0x1000, 0x17E1),(0x1000, 0x17F1),(0x1000, 0x1801),(0x1000, 0x1811),(0x1000, 0x1821),(0x1000, 0x1831),(0x1000, 0x1841),(0x1000, 0x1851),(0x1000, 0x1861),(0x1000, 0x1871),(0x1000, 0x1881),(0x1000, 0x1891),(0x1000, 0x18A1),(0x1000, 0x18B1),(0x1000, 0x18C1),(0x1000, 0x18D1),(0x1000, 0x18E1),(0x1000, 0x18F1),(0x1000, 0x1901),(0x1000, 0x1911),(0x1000, 0x1921),(0x1000, 0x1931),(0x1000, 0x1941),(0x1000, 0x1951),(0x1000, 0x1961),(0x1000, 0x1971),(0x1000, 0x1981),(0x1000, 0x1991),(0x1000, 0x19A1),(0x1000, 0x19B1),(0x1000, 0x19C1),(0x1000, 0x19D1),(0x1000, 0x19E1),(0x1000, 0x19F1),(0x1000, 0x1A01),(0x1000, 0x1A11),(0x1000, 0x1A21),(0x1000, 0x1A31),(0x1000, 0x1A41),(0x1000, 0x1A51),(0x1000, 0x1A61),(0x1000, 0x1A71),(0x1000, 0x1A81),(0x1000, 0x1A91),(0x1000, 0x1AA1),(0x1000, 0x1AB1),(0x1000, 0x1AC1),(0x1000, 0x1AD1),(0x1000, 0x1AE1),(0x1000, 0x1AF1),(0x1000, 0x1B01),(0x1000, 0x1B11),(0x1000, 0x1B21),(0x1000, 0x1B31),(0x1000, 0x1B41),(0x1000, 0x1B51),(0x1000, 0x1B61),(0x1000, 0x1B71),(0x1000, 0x1B81),(0x1000, 0x1B91),(0x1000, 0x1BA1),(0x1000, 0x1BB1),(0x1000, 0x1BC1),(0x1000, 0x1BD1),(0x1000, 0x1BE1),(0x1000, 0x1BF1),(0x1000, 0x1C01),(0x1000, 0x1C11),(0x1000, 0x1C21),(0x1000, 0x1C31),(0x1000, 0x1C41),(0x1000, 0x1C51),(0x1000, 0x1C61),(0x1000, 0x1C71),(0x1000, 0x1C81),(0x1000, 0x1C91),(0x1000, 0x1CA1),(0x1000, 0x1CB1),(0x1000, 0x1CC1),(0x1000, 0x1CD1),(0x1000, 0x1CE1),(0x1000, 0x1CF1),(0x1000, 0x1D01),(0x1000, 0x1D11),(0x1000, 0x1D21),(0x1000, 0x1D31),(0x1000, 0x1D41),(0x1000, 0x1D51),(0x1000, 0x1D61),(0x1000, 0x1D71),(0x1000, 0x1D81),(0x1000, 0x1D91),(0x1000, 0x1DA1),(0x1000, 0x1DB1),(0x1000, 0x1DC1),(0x1000, 0x1DD1),(0x1000, 0x1DE1),(0x1000, 0x1DF1),(0x1000, 0x1E01),(0x1000, 0x1E11),(0x1000, 0x1E21),(0x1000, 0x1E31),(0x1000, 0x1E41),(0x1000, 0x1E51),(0x1000, 0x1E61),(0x1000, 0x1E71),(0x1000, 0x1E81),(0x1000, 0x1E91),(0x1000, 0x1EA1),(0x1000, 0x1EB1),(0x1000, 0x1EC1),(0x1000, 0x1ED1),(0x1000, 0x1EE1),(0x1000, 0x1EF1),(0x1000, 0x1F01),(0x1000, 0x1F11),(0x1000, 0x1F21),(0x1000, 0x1F31),(0x1000, 0x1F41),(0x1000, 0x1F51),(0x1000, 0x1F61),(0x1000, 0x1F71),(0x1000, 0x1F81),(0x1000, 0x1F91),(0x1000, 0x1FA1),(0x1000, 0x1FB1),(0x1000, 0x1FC1),(0x1000, 0x1FD1),(0x1000, 0x1FE1),(0x1000, 0x1FF1),(0x1000, 0x2001),(0x1000, 0x2011),(0x1000, 0x2021),(0x1000, 0x2031),(0x1000, 0x2041),(0x1000, 0x2051),(0x1000, 0x2061),(0x1000, 0x2071),(0x1000, 0x2081),(0x1000, 0x2091),(0x1000, 0x20A1),(0x1000, 0x20B1),(0x1000, 0x20C1),(0x1000, 0x20D1),(0x1000, 0x20E1),(0x1000, 0x20F1),(0x1000, 0x2101),(0x1000, 0x2111),(0x1000, 0x2121),(0x1000, 0x2131),(0x1000, 0x2141),(0x1000, 0x2151),(0x1000, 0x2161),(0x1000, 0x2171),(0x1000, 0x2181),(0x1000, 0x2191),(0x1000, 0x21A1),(0x1000, 0x21B1),(0x1000, 0x21C1),(0x1000, 0x21D1),(0x1000, 0x21E1),(0x1000, 0x21F1),(0x1000, 0x2201),(0x1000, 0x2211),(0x1000, 0x2221),(0x1000, 0x2231),(0x1000, 0x2241),(0x1000, 0x2251),(0x1000, 0x2261),(0x1000, 0x2271),(0x1000, 0x2281),(0x1000, 0x2291),(0x1000, 0x22A1),(0x1000, 0x22B1),(0x1000, 0x22C1),(0x1000, 0x22D1),(0x1000, 0x22E1),(0x1000, 0x22F1),(0x1000, 0x2301),(0x1000, 0x2311),(0x1000, 0x2321),(0x1000, 0x2331),(0x1000, 0x2341),(0x1000, 0x2351),(0x1000, 0x2361),(0x1000, 0x2371),(0x1000, 0x2381),(0x1000, 0x2391),(0x1000, 0x23A1),(0x1000, 0x23B1),(0x1000, 0x23C1),(0x1000, 0x23D1),(0x1000, 0x23E1),(0x1000, 0x23F1),(0x1000, 0x2401),(0x1000, 0x2411),(0x1000, 0x2421),(0x1000, 0x2431),(0x1000, 0x2441),(0x1000, 0x2451),(0x1000, 0x2461),(0x1000, 0x2471),(0x1000, 0x2481),(0x1000, 0x2491),(0x1000, 0x24A1),(0x1000, 0x24B1),(0x1000, 0x24C1),(0x1000, 0x24D1),(0x1000, 0x24E1),(0x1000, 0x24F1),(0x1000, 0x2501),(0x1000, 0x2511),(0x1000, 0x2521),(0x1000, 0x2531),(0x1000, 0x2541),(0x1000, 0x2551),(0x1000, 0x2561),(0x1000, 0x2571),(0x1000, 0x2581),(0x1000, 0x2591),(0x1000, 0x25A1),(0x1000, 0x25B1),(0x1000, 0x25C1),(0x1000, 0x25D1),(0x1000, 0x25E1),(0x1000, 0x25F1),(0x1000, 0x2601),(0x1000, 0x2611),(0x1000, 0x2621),(0x1000, 0x2631),(0x1000, 0x2641),(0x1000, 0x2651),(0x1000, 0x2661),(0x1000, 0x2671),(0x1000, 0x2681),(0x1000, 0x2691),(0x1000, 0x26A1),(0x1000, 0x26B1),(0x1000, 0x26C1),(0x1000, 0x26D1),(0x1000, 0x26E1),(0x1000, 0x26F1),(0x1000, 0x2701),(0x1000, 0x2711),(0x1000, 0x2721),(0x1000, 0x2731),(0x1000, 0x2741),(0x1000, 0x2751),(0x1000, 0x2761),(0x1000, 0x2771),(0x1000, 0x2781),(0x1000, 0x2791),(0x1000, 0x27A1),(0x1000, 0x27B1),(0x1000, 0x27C1),(0x1000, 0x27D1),(0x1000, 0x27E1),(0x1000, 0x27F1),(0x1000, 0x2801),(0x1000, 0x2811),(0x1000, 0x2821),(0x1000, 0x2831),(0x1000, 0x2841),(0x1000, 0x2851),(0x1000, 0x2861),(0x1000, 0x2871),(0x1000, 0x2881),(0x1000, 0x2891),(0x1000, 0x28A1),(0x1000, 0x28B1),(0x1000, 0x28C1),(0x1000, 0x28D1),(0x1000, 0x28E1),(0x1000, 0x28F1),(0x1000, 0x2901),(0x1000, 0x2911),(0x1000, 0x2921),(0x1000, 0x2931),(0x1000, 0x2941),(0x1000, 0x2951),(0x1000, 0x2961),(0x1000, 0x2971),(0x1000, 0x2981),(0x1000, 0x2991),(0x1000, 0x29A1),(0x1000, 0x29B1),(0x1000, 0x29C1),(0x1000, 0x29D1),(0x1000, 0x29E1),(0x1000, 0x29F1),(0x1000, 0x2A01),(0x1000, 0x2A11),(0x1000, 0x2A21),(0x1000, 0x2A31),(0x1000, 0x2A41),(0x1000, 0x2A51),(0x1000, 0x2A61),(0x1000, 0x2A71),(0x1000, 0x2A81),(0x1000, 0x2A91),(0x1000, 0x2AA1),(0x1000, 0x2AB1),(0x1000, 0x2AC1),(0x1000, 0x2AD1),(0x1000, 0x2AE1),(0x1000, 0x2AF1),(0x1000, 0x2B01),(0x1000, 0x2B11),(0x1000, 0x2B21),(0x1000, 0x2B31),(0x1000, 0x2B41),(0x1000, 0x2B51),(0x1000, 0x2B61),(0x1000, 0x2B71),(0x1000, 0x2B81),(0x1000, 0x2B91),(0x1000, 0x2BA1),(0x1000, 0x2BB1),(0x1000, 0x2BC1),(0x1000, 0x2BD1),(0x1000, 0x2BE1),(0x1000, 0x2BF1),(0x1000, 0x2C01),(0x1000, 0x2C11),(0x1000, 0x2C21),(0x1000, 0x2C31),(0x1000, 0x2C41),(0x1000, 0x2C51),(0x1000, 0x2C61),(0x1000, 0x2C71),(0x1000, 0x2C81),(0x1000, 0x2C91),(0x1000, 0x2CA1),(0x1000, 0x2CB1),(0x1000, 0x2CC1),(0x1000, 0x2CD1),(0x1000, 0x2CE1),(0x1000, 0x2CF1),(0x1000, 0x2D01),(0x1000, 0x2D11),(0x1000, 0x2D21),(0x1000, 0x2D31),(0x1000, 0x2D41),(0x1000, 0x2D51),(0x1000, 0x2D61),(0x1000, 0x2D71),(0x1000, 0x2D81),(0x1000, 0x2D91),(0x1000, 0x2DA1),(0x1000, 0x2DB1),(0x1000, 0x2DC1),(0x1000, 0x2DD1),(0x1000, 0x2DE1),(0x1000, 0x2DF1),(0x1000, 0x2E01),(0x1000, 0x2E11),(0x1000, 0x2E21),(0x1000, 0x2E31),(0x1000, 0x2E41),(0x1000, 0x2E51),(0x1000, 0x2E61),(0x1000, 0x2E71),(0x1000, 0x2E81),(0x1000, 0x2E91),(0x1000, 0x2EA1),(0x1000, 0x2EB1),(0x1000, 0x2EC1),(0x1000, 0x2ED1),(0x1000, 0x2EE1),(0x1000, 0x2EF1),(0x1000, 0x2F01),(0x1000, 0x2F11),(0x1000, 0x2F21),(0x1000, 0x2F31),(0x1000, 0x2F41),(0x1000, 0x2F51),(0x1000, 0x2F61),(0x1000, 0x2F71),(0x1000, 0x2F81),(0x1000, 0x2F91),(0x1000, 0x2FA1),(0x1000, 0x2FB1),(0x1000, 0x2FC1),(0x1000, 0x2FD1),(0x1000, 0x2FE1),(0x1000, 0x2FF1),(0x1000, 0x3001),(0x1000, 0x3011),(0x1000, 0x3021),(0x1000, 0x3031),(0x1000, 0x3041),(0x1000, 0x3051),(0x1000, 0x3061),(0x1000, 0x3071),(0x1000, 0x3081),(0x1000, 0x3091),(0x1000, 0x30A1),(0x1000, 0x30B1),(0x1000, 0x30C1),(0x1000, 0x30D1),(0x1000, 0x30E1),(0x1000, 0x30F1),(0x1000, 0x3101),(0x1000, 0x3111),(0x1000, 0x3121),(0x1000, 0x3131),(0x1000, 0x3141),(0x1000, 0x3151),(0x1000, 0x3161),(0x1000, 0x3171),(0x1000, 0x3181),(0x1000, 0x3191),(0x1000, 0x31A1),(0x1000, 0x31B1),(0x1000, 0x31C1),(0x1000, 0x31D1),(0x1000, 0x31E1),(0x1000, 0x31F1),(0x1000, 0x3201),(0x1000, 0x3211),(0x1000, 0x3221),(0x1000, 0x3231),(0x1000, 0x3241),(0x1000, 0x3251),(0x1000, 0x3261),(0x1000, 0x3271),(0x1000, 0x3281),(0x1000, 0x3291),(0x1000, 0x32A1),(0x1000, 0x32B1),(0x1000, 0x32C1),(0x1000, 0x32D1),(0x1000, 0x32E1),(0x1000, 0x32F1),(0x1000, 0x3301),(0x1000, 0x3311),(0x1000, 0x3321),(0x1000, 0x3331),(0x1000, 0x3341),(0x1000, 0x3351),(0x1000, 0x3361),(0x1000, 0x3371),(0x1000, 0x3381),(0x1000, 0x3391),(0x1000, 0x33A1),(0x1000, 0x33B1),(0x1000, 0x33C1),(0x1000, 0x33D1),(0x1000, 0x33E1),(0x1000, 0x33F1),(0x1000, 0x3401),(0x1000, 0x3411),(0x1000, 0x3421),(0x1000, 0x3431),(0x1000, 0x3441),(0x1000, 0x3451),(0x1000, 0x3461),(0x1000, 0x3471),(0x1000, 0x3481),(0x1000, 0x3491),(0x1000, 0x34A1),(0x1000, 0x34B1),(0x1000, 0x34C1),(0x1000, 0x34D1),(0x1000, 0x34E1),(0x1000, 0x34F1),(0x1000, 0x3501),(0x1000, 0x3511),(0x1000, 0x3521),(0x1000, 0x3531),(0x1000, 0x3541),(0x1000, 0x3551),(0x1000, 0x3561),(0x1000, 0x3571),(0x1000, 0x3581),(0x1000, 0x3591),(0x1000, 0x35A1),(0x1000, 0x35B1),(0x1000, 0x35C1),(0x1000, 0x35D1),(0x1000, 0x35E1),(0x1000, 0x35F1),(0x1000, 0x3601),(0x1000, 0x3611),(0x1000, 0x3621),(0x1000, 0x3631),(0x1000, 0x3641),(0x1000, 0x3651),(0x1000, 0x3661),(0x1000, 0x3671),(0x1000, 0x3681),(0x1000, 0x3691),(0x1000, 0x36A1),(0x1000, 0x36B1),(0x1000, 0x36C1),(0x1000, 0x36D1),(0x1000, 0x36E1),(0x1000, 0x36F1),(0x1000, 0x3701),(0x1000, 0x3711),(0x1000, 0x3721),(0x1000, 0x3731),(0x1000, 0x3741),(0x1000, 0x3751),(0x1000, 0x3761),(0x1000, 0x3771),(0x1000, 0x3781),(0x1000, 0x3791),(0x1000, 0x37A1),(0x1000, 0x37B1),(0x1000, 0x37C1),(0x1000, 0x37D1),(0x1000, 0x37E1),(0x1000, 0x37F1),(0x1000, 0x3801),(0x1000, 0x3811),(0x1000, 0x3821),(0x1000, 0x3831),(0x1000, 0x3841),(0x1000, 0x3851),(0x1000, 0x3861),(0x1000, 0x3871),(0x1000, 0x3881),(0x1000, 0x3891),(0x1000, 0x38A1),(0x1000, 0x38B1),(0x1000, 0x38C1),(0x1000, 0x38D1),(0x1000, 0x38E1),(0x1000, 0x38F1),(0x1000, 0x3901),(0x1000, 0x3911),(0x1000, 0x3921),(0x1000, 0x3931),(0x1000, 0x3941),(0x1000, 0x3951),(0x1000, 0x3961),(0x1000, 0x3971),(0x1000, 0x3981),(0x1000, 0x3991),(0x1000, 0x39A1),(0x1000, 0x39B1),(0x1000, 0x39C1),(0x1000, 0x39D1),(0x1000, 0x39E1),(0x1000, 0x39F1),(0x1000, 0x3A01),(0x1000, 0x3A11),(0x1000, 0x3A21),(0x1000, 0x3A31),(0x1000, 0x3A41),(0x1000, 0x3A51),(0x1000, 0x3A61),(0x1000, 0x3A71),(0x1000, 0x3A81),(0x1000, 0x3A91),(0x1000, 0x3AA1),(0x1000, 0x3AB1),(0x1000, 0x3AC1),(0x1000, 0x3AD1),(0x1000, 0x3AE1),(0x1000, 0x3AF1),(0x1000, 0x3B01),(0x1000, 0x3B11),(0x1000, 0x3B21),(0x1000, 0x3B31),(0x1000, 0x3B41),(0x1000, 0x3B51),(0x1000, 0x3B61),(0x1000, 0x3B71),(0x1000, 0x3B81),(0x1000, 0x3B91),(0x1000, 0x3BA1),(0x1000, 0x3BB1),(0x1000, 0x3BC1),(0x1000, 0x3BD1),(0x1000, 0x3BE1),(0x1000, 0x3BF1),(0x1000, 0x3C01),(0x1000, 0x3C11),(0x1000, 0x3C21),(0x1000, 0x3C31),(0x1000, 0x3C41),(0x1000, 0x3C51),(0x1000, 0x3C61),(0x1000, 0x3C71),(0x1000, 0x3C81),(0x1000, 0x3C91),(0x1000, 0x3CA1),(0x1000, 0x3CB1),(0x1000, 0x3CC1),(0x1000, 0x3CD1),(0x1000, 0x3CE1),(0x1000, 0x3CF1),(0x1000, 0x3D01),(0x1000, 0x3D11),(0x1000, 0x3D21),(0x1000, 0x3D31),(0x1000, 0x3D41),(0x1000, 0x3D51),(0x1000, 0x3D61),(0x1000, 0x3D71),(0x1000, 0x3D81),(0x1000, 0x3D91),(0x1000, 0x3DA1),(0x1000, 0x3DB1),(0x1000, 0x3DC1),(0x1000, 0x3DD1),(0x1000, 0x3DE1),(0x1000, 0x3DF1),(0x1000, 0x3E01),(0x1000, 0x3E11),(0x1000, 0x3E21),(0x1000, 0x3E31),(0x1000, 0x3E41),(0x1000, 0x3E51),(0x1000, 0x3E61),(0x1000, 0x3E71),(0x1000, 0x3E81),(0x1000, 0x3E91),(0x1000, 0x3EA1),(0x1000, 0x3EB1),(0x1000, 0x3EC1),(0x1000, 0x3ED1),(0x1000, 0x3EE1),(0x1000, 0x3EF1),(0x1000, 0x3F01),(0x1000, 0x3F11),(0x1000, 0x3F21),(0x1000, 0x3F31),(0x1000, 0x3F41),(0x1000, 0x3F51),(0x1000, 0x3F61),(0x1000, 0x3F71),(0x1000, 0x3F81),(0x1000, 0x3F91),(0x1000, 0x3FA1),(0x1000, 0x3FB1),(0x1000, 0x3FC1),(0x1000, 0x3FD1),(0x1000, 0x3FE1),(0x1000, 0x3FF1),(0x1000, 0x4001),(0x1000, 0x4011),(0x1000, 0x4021),(0x1000, 0x4031),(0x1000, 0x4041),(0x1000, 0x4051),(0x1000, 0x4061),(0x1000, 0x4071),(0x1000, 0x4081),(0x1000, 0x4091),(0x1000, 0x40A1),(0x1000, 0x40B1),(0x1000, 0x40C1),(0x1000, 0x40D1),(0x1000, 0x40E1),(0x1000, 0x40F1),(0x1000, 0x4101),(0x1000, 0x4111),(0x1000, 0x4121),(0x1000, 0x4131),(0x1000, 0x4141),(0x1000, 0x4151),(0x1000, 0x4161),(0x1000, 0x4171),(0x1000, 0x4181),(0x1000, 0x4191),(0x1000, 0x41A1),(0x1000, 0x41B1),(0x1000, 0x41C1),(0x1000, 0x41D1),(0x1000, 0x41E1),(0x1000, 0x41F1),(0x1000, 0x4201),(0x1000, 0x4211),(0x1000, 0x4221),(0x1000, 0x4231),(0x1000, 0x4241),(0x1000, 0x4251),(0x1000, 0x4261),(0x1000, 0x4271),(0x1000, 0x4281),(0x1000, 0x4291),(0x1000, 0x42A1),(0x1000, 0x42B1),(0x1000, 0x42C1),(0x1000, 0x42D1),(0x1000, 0x42E1),(0x1000, 0x42F1),(0x1000, 0x4301),(0x1000, 0x4311),(0x1000, 0x4321),(0x1000, 0x4331),(0x1000, 0x4341),(0x1000, 0x4351),(0x1000, 0x4361),(0x1000, 0x4371),(0x1000, 0x4381),(0x1000, 0x4391),(0x1000, 0x43A1),(0x1000, 0x43B1),(0x1000, 0x43C1),(0x1000, 0x43D1),(0x1000, 0x43E1),(0x1000, 0x43F1),(0x1000, 0x4401),(0x1000, 0x4411),(0x1000, 0x4421),(0x1000, 0x4431),(0x1000, 0x4441),(0x1000, 0x4451),(0x1000, 0x4461),(0x1000, 0x4471),(0x1000, 0x4481),(0x1000, 0x4491),(0x1000, 0x44A1),(0x1000, 0x44B1),(0x1000, 0x44C1),(0x1000, 0x44D1),(0x1000, 0x44E1),(0x1000, 0x44F1),(0x1000, 0x4501),(0x1000, 0x4511),(0x1000, 0x4521),(0x1000, 0x4531),(0x1000, 0x4541),(0x1000, 0x4551),(0x1000, 0x4561),(0x1000, 0x4571),(0x1000, 0x4581),(0x1000, 0x4591),(0x1000, 0x45A1),(0x1000, 0x45B1),(0x1000, 0x45C1),(0x1000, 0x45D1),(0x1000, 0x45E1),(0x1000, 0x45F1),(0x1000, 0x4601),(0x1000, 0x4611),(0x1000, 0x4621),(0x1000, 0x4631),(0x1000, 0x4641),(0x1000, 0x4651),(0x1000, 0x4661),(0x1000, 0x4671),(0x1000, 0x4681),(0x1000, 0x4691),(0x1000, 0x46A1),(0x1000, 0x46B1),(0x1000, 0x46C1),(0x1000, 0x46D1),(0x1000, 0x46E1),(0x1000, 0x46F1),(0x1000, 0x4701),(0x1000, 0x4711),(0x1000, 0x4721),(0x1000, 0x4731),(0x1000, 0x4741),(0x1000, 0x4751),(0x1000, 0x4761),(0x1000, 0x4771),(0x1000, 0x4781),(0x1000, 0x4791),(0x1000, 0x47A1),(0x1000, 0x47B1),(0x1000, 0x47C1),(0x1000, 0x47D1),(0x1000, 0x47E1),(0x1000, 0x47F1),(0x1000, 0x4801),(0x1000, 0x4811),(0x1000, 0x4821),(0x1000, 0x4831),(0x1000, 0x4841),(0x1000, 0x4851),(0x1000, 0x4861),(0x1000, 0x4871),(0x1000, 0x4881),(0x1000, 0x4891),(0x1000, 0x48A1),(0x1000, 0x48B1),(0x1000, 0x48C1),(0x1000, 0x48D1),(0x1000, 0x48E1),(0x1000, 0x48F1),(0x1000, 0x4901),(0x1000, 0x4911),(0x1000, 0x4921),(0x1000, 0x4931),(0x1000, 0x4941),(0x1000, 0x4951),(0x1000, 0x4961),(0x1000, 0x4971),(0x1000, 0x4981),(0x1000, 0x4991),(0x1000, 0x49A1),(0x1000, 0x49B1),(0x1000, 0x49C1),(0x1000, 0x49D1),(0x1000, 0x49E1),(0x1000, 0x49F1),(0x1000, 0x4A01),(0x1000, 0x4A11),(0x1000, 0x4A21),(0x1000, 0x4A31),(0x1000, 0x4A41),(0x1000, 0x4A51),(0x1000, 0x4A61),(0x1000, 0x4A71),(0x1000, 0x4A81),(0x1000, 0x4A91),(0x1000, 0x4AA1),(0x1000, 0x4AB1),(0x1000, 0x4AC1),(0x1000, 0x4AD1),(0x1000, 0x4AE1),(0x1000, 0x4AF1),(0x1000, 0x4B01),(0x1000, 0x4B11),(0x1000, 0x4B21),(0x1000, 0x4B31),(0x1000, 0x4B41),(0x1000, 0x4B51),(0x1000, 0x4B61),(0x1000, 0x4B71),(0x1000, 0x4B81),(0x1000, 0x4B91),(0x1000, 0x4BA1),(0x1000, 0x4BB1),(0x1000, 0x4BC1),(0x1000, 0x4BD1),(0x1000, 0x4BE1),(0x1000, 0x4BF1),(0x1000, 0x4C01),(0x1000, 0x4C11),(0x1000, 0x4C21),(0x1000, 0x4C31),(0x1000, 0x4C41),(0x1000, 0x4C51),(0x1000, 0x4C61),(0x1000, 0x4C71),(0x1000, 0x4C81),(0x1000, 0x4C91),(0x1000, 0x4CA1),(0x1000, 0x4CB1),(0x1000, 0x4CC1),(0x1000, 0x4CD1),(0x1000, 0x4CE1),(0x1000, 0x4CF1),(0x1000, 0x4D01),(0x1000, 0x4D11),(0x1000, 0x4D21),(0x1000, 0x4D31),(0x1000, 0x4D41),(0x1000, 0x4D51),(0x1000, 0x4D61),(0x1000, 0x4D71),(0x1000, 0x4D81),(0x1000, 0x4D91),(0x1000, 0x4DA1),(0x1000, 0x4DB1),(0x1000, 0x4DC1),(0x1000, 0x4DD1),(0x1000, 0x4DE1),(0x1000, 0x4DF1),(0x1000, 0x4E01),(0x1000, 0x4E11),(0x1000, 0x4E21),(0x1000, 0x4E31),(0x1000, 0x4E41),(0x1000, 0x4E51),(0x1000, 0x4E61),(0x1000, 0x4E71),(0x1000, 0x4E81),(0x1000, 0x4E91),(0x1000, 0x4EA1),(0x1000, 0x4EB1),(0x1000, 0x4EC1),(0x1000, 0x4ED1),(0x1000, 0x4EE1),(0x1000, 0x4EF1),(0x1000, 0x4F01),(0x1000, 0x4F11),(0x1000, 0x4F21),(0x1000, 0x4F31),(0x1000, 0x4F41),(0x1000, 0x4F51),(0x1000, 0x4F61),(0x1000, 0x4F71),(0x1000, 0x4F81),(0x1000, 0x4F91),(0x1000, 0x4FA1),(0x1000, 0x4FB1),(0x1000, 0x4FC1),(0x1000, 0x4FD1),(0x1000, 0x4FE1),(0x1000, 0x4FF1),(0x1000, 0x5001),(0x1000, 0x5011),(0x1000, 0x5021),(0x1000, 0x5031),(0x1000, 0x5041),(0x1000, 0x5051),(0x1000, 0x5061),(0x1000, 0x5071),(0x1000, 0x5081),(0x1000, 0x5091),(0x1000, 0x50A1),(0x1000, 0x50B1),(0x1000, 0x50C1),(0x1000, 0x50D1),(0x1000, 0x50E1),(0x1000, 0x50F1),(0x1000, 0x5101),(0x1000, 0x5111),(0x1000, 0x5121),(0x1000, 0x5131),(0x1000, 0x5141),(0x1000, 0x5151),(0x1000, 0x5161),(0x1000, 0x5171),(0x1000, 0x5181),(0x1000, 0x5191),(0x1000, 0x51A1),(0x1000, 0x51B1),(0x1000, 0x51C1),(0x1000, 0x51D1),(0x1000, 0x51E1),(0x1000, 0x51F1),(0x1000, 0x5201),(0x1000, 0x5211),(0x1000, 0x5221),(0x1000, 0x5231),(0x1000, 0x5241),(0x1000, 0x5251),(0x1000, 0x5261),(0x1000, 0x5271),(0x1000, 0x5281),(0x1000, 0x5291),(0x1000, 0x52A1),(0x1000, 0x52B1),(0x1000, 0x52C1),(0x1000, 0x52D1),(0x1000, 0x52E1),(0x1000, 0x52F1),(0x1000, 0x5301),(0x1000, 0x5311),(0x1000, 0x5321),(0x1000, 0x5331),(0x1000, 0x5341),(0x1000, 0x5351),(0x1000, 0x5361),(0x1000, 0x5371),(0x1000, 0x5381),(0x1000, 0x5391),(0x1000, 0x53A1),(0x1000, 0x53B1),(0x1000, 0x53C1),(0x1000, 0x53D1),(0x1000, 0x53E1),(0x1000, 0x53F1),(0x1000, 0x5401),(0x1000, 0x5411),(0x1000, 0x5421),(0x1000, 0x5431),(0x1000, 0x5441),(0x1000, 0x5451),(0x1000, 0x5461),(0x1000, 0x5471),(0x1000, 0x5481),(0x1000, 0x5491),(0x1000, 0x54A1),(0x1000, 0x54B1),(0x1000, 0x54C1),(0x1000, 0x54D1),(0x1000, 0x54E1),(0x1000, 0x54F1),(0x1000, 0x5501),(0x1000, 0x5511),(0x1000, 0x5521),(0x1000, 0x5531),(0x1000, 0x5541),(0x1000, 0x5551),(0x1000, 0x5561),(0x1000, 0x5571),(0x1000, 0x5581),(0x1000, 0x5591),(0x1000, 0x55A1),(0x1000, 0x55B1),(0x1000, 0x55C1),(0x1000, 0x55D1),(0x1000, 0x55E1),(0x1000, 0x55F1),(0x1000, 0x5601),(0x1000, 0x5611),(0x1000, 0x5621),(0x1000, 0x5631),(0x1000, 0x5641),(0x1000, 0x5651),(0x1000, 0x5661),(0x1000, 0x5671),(0x1000, 0x5681),(0x1000, 0x5691),(0x1000, 0x56A1),(0x1000, 0x56B1),(0x1000, 0x56C1),(0x1000, 0x56D1),(0x1000, 0x56E1),(0x1000, 0x56F1),(0x1000, 0x5701),(0x1000, 0x5711),(0x1000, 0x5721),(0x1000, 0x5731),(0x1000, 0x5741),(0x1000, 0x5751),(0x1000, 0x5761),(0x1000, 0x5771),(0x1000, 0x5781),(0x1000, 0x5791),(0x1000, 0x57A1),(0x1000, 0x57B1),(0x1000, 0x57C1),(0x1000, 0x57D1),(0x1000, 0x57E1),(0x1000, 0x57F1),(0x1000, 0x5801),(0x1000, 0x5811),(0x1000, 0x5821),(0x1000, 0x5831),(0x1000, 0x5841),(0x1000, 0x5851),(0x1000, 0x5861),(0x1000, 0x5871),(0x1000, 0x5881),(0x1000, 0x5891),(0x1000, 0x58A1),(0x1000, 0x58B1),(0x1000, 0x58C1),(0x1000, 0x58D1),(0x1000, 0x58E1),(0x1000, 0x58F1),(0x1000, 0x5901),(0x1000, 0x5911),(0x1000, 0x5921),(0x1000, 0x5931),(0x1000, 0x5941),(0x1000, 0x5951),(0x1000, 0x5961),(0x1000, 0x5971),(0x1000, 0x5981),(0x1000, 0x5991),(0x1000, 0x59A1),(0x1000, 0x59B1),(0x1000, 0x59C1),(0x1000, 0x59D1),(0x1000, 0x59E1),(0x1000, 0x59F1),(0x1000, 0x5A01),(0x1000, 0x5A11),(0x1000, 0x5A21),(0x1000, 0x5A31),(0x1000, 0x5A41),(0x1000, 0x5A51),(0x1000, 0x5A61),(0x1000, 0x5A71),(0x1000, 0x5A81),(0x1000, 0x5A91),(0x1000, 0x5AA1),(0x1000, 0x5AB1),(0x1000, 0x5AC1),(0x1000, 0x5AD1),(0x1000, 0x5AE1),(0x1000, 0x5AF1),(0x1000, 0x5B01),(0x1000, 0x5B11),(0x1000, 0x5B21),(0x1000, 0x5B31),(0x1000, 0x5B41),(0x1000, 0x5B51),(0x1000, 0x5B61),(0x1000, 0x5B71),(0x1000, 0x5B81),(0x1000, 0x5B91),(0x1000, 0x5BA1),(0x1000, 0x5BB1),(0x1000, 0x5BC1),(0x1000, 0x5BD1),(0x1000, 0x5BE1),(0x1000, 0x5BF1),(0x1000, 0x5C01),(0x1000, 0x5C11),(0x1000, 0x5C21),(0x1000, 0x5C31),(0x1000, 0x5C41),(0x1000, 0x5C51),(0x1000, 0x5C61),(0x1000, 0x5C71),(0x1000, 0x5C81),(0x1000, 0x5C91),(0x1000, 0x5CA1),(0x1000, 0x5CB1),(0x1000, 0x5CC1),(0x1000, 0x5CD1),(0x1000, 0x5CE1),(0x1000, 0x5CF1),(0x1000, 0x5D01),(0x1000, 0x5D11),(0x1000, 0x5D21),(0x1000, 0x5D31),(0x1000, 0x5D41),(0x1000, 0x5D51),(0x1000, 0x5D61),(0x1000, 0x5D71),(0x1000, 0x5D81),(0x1000, 0x5D91),(0x1000, 0x5DA1),(0x1000, 0x5DB1),(0x1000, 0x5DC1),(0x1000, 0x5DD1),(0x1000, 0x5DE1),(0x1000, 0x5DF1),(0x1000, 0x5E01),(0x1000, 0x5E11),(0x1000, 0x5E21),(0x1000, 0x5E31),(0x1000, 0x5E41),(0x1000, 0x5E51),(0x1000, 0x5E61),(0x1000, 0x5E71),(0x1000, 0x5E81),(0x1000, 0x5E91),(0x1000, 0x5EA1),(0x1000, 0x5EB1),(0x1000, 0x5EC1),(0x1000, 0x5ED1),(0x1000, 0x5EE1),(0x1000, 0x5EF1),(0x1000, 0x5F01),(0x1000, 0x5F11),(0x1000, 0x5F21),(0x1000, 0x5F31),(0x1000, 0x5F41),(0x1000, 0x5F51),(0x1000, 0x5F61),(0x1000, 0x5F71),(0x1000, 0x5F81),(0x1000, 0x5F91),(0x1000, 0x5FA1),(0x1000, 0x5FB1),(0x1000, 0x5FC1),(0x1000, 0x5FD1),(0x1000, 0x5FE1),(0x1000, 0x5FF1),(0x1000, 0x6001),(0x1000, 0x6011),(0x1000, 0x6021),(0x1000, 0x6031),(0x1000, 0x6041),(0x1000, 0x6051),(0x1000, 0x6061),(0x1000, 0x6071),(0x1000, 0x6081),(0x1000, 0x6091),(0x1000, 0x60A1),(0x1000, 0x60B1),(0x1000, 0x60C1),(0x1000, 0x60D1),(0x1000, 0x60E1),(0x1000, 0x60F1),(0x1000, 0x6101),(0x1000, 0x6111),(0x1000, 0x6121),(0x1000, 0x6131),(0x1000, 0x6141),(0x1000, 0x6151),(0x1000, 0x6161),(0x1000, 0x6171),(0x1000, 0x6181),(0x1000, 0x6191),(0x1000, 0x61A1),(0x1000, 0x61B1),(0x1000, 0x61C1),(0x1000, 0x61D1),(0x1000, 0x61E1),(0x1000, 0x61F1),(0x1000, 0x6201),(0x1000, 0x6211),(0x1000, 0x6221),(0x1000, 0x6231),(0x1000, 0x6241),(0x1000, 0x6251),(0x1000, 0x6261),(0x1000, 0x6271),(0x1000, 0x6281),(0x1000, 0x6291),(0x1000, 0x62A1),(0x1000, 0x62B1),(0x1000, 0x62C1),(0x1000, 0x62D1),(0x1000, 0x62E1),(0x1000, 0x62F1),(0x1000, 0x6301),(0x1000, 0x6311),(0x1000, 0x6321),(0x1000, 0x6331),(0x1000, 0x6341),(0x1000, 0x6351),(0x1000, 0x6361),(0x1000, 0x6371),(0x1000, 0x6381),(0x1000, 0x6391),(0x1000, 0x63A1),(0x1000, 0x63B1),(0x1000, 0x63C1),(0x1000, 0x63D1),(0x1000, 0x63E1),(0x1000, 0x63F1),(0x1000, 0x6401),(0x1000, 0x6411),(0x1000, 0x6421),(0x1000, 0x6431),(0x1000, 0x6441),(0x1000, 0x6451),(0x1000, 0x6461),(0x1000, 0x6471),(0x1000, 0x6481),(0x1000, 0x6491),(0x1000, 0x64A1),(0x1000, 0x64B1),(0x1000, 0x64C1),(0x1000, 0x64D1),(0x1000, 0x64E1),(0x1000, 0x64F1),(0x1000, 0x6501),(0x1000, 0x6511),(0x1000, 0x6521),(0x1000, 0x6531),(0x1000, 0x6541),(0x1000, 0x6551),(0x1000, 0x6561),(0x1000, 0x6571),(0x1000, 0x6581),(0x1000, 0x6591),(0x1000, 0x65A1),(0x1000, 0x65B1),(0x1000, 0x65C1),(0x1000, 0x65D1),(0x1000, 0x65E1),(0x1000, 0x65F1),(0x1000, 0x6601),(0x1000, 0x6611),(0x1000, 0x6621),(0x1000, 0x6631),(0x1000, 0x6641),(0x1000, 0x6651),(0x1000, 0x6661),(0x1000, 0x6671),(0x1000, 0x6681),(0x1000, 0x6691),(0x1000, 0x66A1),(0x1000, 0x66B1),(0x1000, 0x66C1),(0x1000, 0x66D1),(0x1000, 0x66E1),(0x1000, 0x66F1),(0x1000, 0x6701),(0x1000, 0x6711),(0x1000, 0x6721),(0x1000, 0x6731),(0x1000, 0x6741),(0x1000, 0x6751),(0x1000, 0x6761),(0x1000, 0x6771),(0x1000, 0x6781),(0x1000, 0x6791),(0x1000, 0x67A1),(0x1000, 0x67B1),(0x1000, 0x67C1),(0x1000, 0x67D1),(0x1000, 0x67E1),(0x1000, 0x67F1),(0x1000, 0x6801),(0x1000, 0x6811),(0x1000, 0x6821),(0x1000, 0x6831),(0x1000, 0x6841),(0x1000, 0x6851),(0x1000, 0x6861),(0x1000, 0x6871),(0x1000, 0x6881),(0x1000, 0x6891),(0x1000, 0x68A1),(0x1000, 0x68B1),(0x1000, 0x68C1),(0x1000, 0x68D1),(0x1000, 0x68E1),(0x1000, 0x68F1),(0x1000, 0x6901),(0x1000, 0x6911),(0x1000, 0x6921),(0x1000, 0x6931),(0x1000, 0x6941),(0x1000, 0x6951),(0x1000, 0x6961),(0x1000, 0x6971),(0x1000, 0x6981),(0x1000, 0x6991),(0x1000, 0x69A1),(0x1000, 0x69B1),(0x1000, 0x69C1),(0x1000, 0x69D1),(0x1000, 0x69E1),(0x1000, 0x69F1),(0x1000, 0x6A01),(0x1000, 0x6A11),(0x1000, 0x6A21),(0x1000, 0x6A31),(0x1000, 0x6A41),(0x1000, 0x6A51),(0x1000, 0x6A61),(0x1000, 0x6A71),(0x1000, 0x6A81),(0x1000, 0x6A91),(0x1000, 0x6AA1),(0x1000, 0x6AB1),(0x1000, 0x6AC1),(0x1000, 0x6AD1),(0x1000, 0x6AE1),(0x1000, 0x6AF1),(0x1000, 0x6B01),(0x1000, 0x6B11),(0x1000, 0x6B21),(0x1000, 0x6B31),(0x1000, 0x6B41),(0x1000, 0x6B51),(0x1000, 0x6B61),(0x1000, 0x6B71),(0x1000, 0x6B81),(0x1000, 0x6B91),(0x1000, 0x6BA1),(0x1000, 0x6BB1),(0x1000, 0x6BC1),(0x1000, 0x6BD1),(0x1000, 0x6BE1),(0x1000, 0x6BF1),(0x1000, 0x6C01),(0x1000, 0x6C11),(0x1000, 0x6C21),(0x1000, 0x6C31),(0x1000, 0x6C41),(0x1000, 0x6C51),(0x1000, 0x6C61),(0x1000, 0x6C71),(0x1000, 0x6C81),(0x1000, 0x6C91),(0x1000, 0x6CA1),(0x1000, 0x6CB1),(0x1000, 0x6CC1),(0x1000, 0x6CD1),(0x1000, 0x6CE1),(0x1000, 0x6CF1),(0x1000, 0x6D01),(0x1000, 0x6D11),(0x1000, 0x6D21),(0x1000, 0x6D31),(0x1000, 0x6D41),(0x1000, 0x6D51),(0x1000, 0x6D61),(0x1000, 0x6D71),(0x1000, 0x6D81),(0x1000, 0x6D91),(0x1000, 0x6DA1),(0x1000, 0x6DB1),(0x1000, 0x6DC1),(0x1000, 0x6DD1),(0x1000, 0x6DE1),(0x1000, 0x6DF1),(0x1000, 0x6E01),(0x1000, 0x6E11),(0x1000, 0x6E21),(0x1000, 0x6E31),(0x1000, 0x6E41),(0x1000, 0x6E51),(0x1000, 0x6E61),(0x1000, 0x6E71),(0x1000, 0x6E81),(0x1000, 0x6E91),(0x1000, 0x6EA1),(0x1000, 0x6EB1),(0x1000, 0x6EC1),(0x1000, 0x6ED1),(0x1000, 0x6EE1),(0x1000, 0x6EF1),(0x1000, 0x6F01),(0x1000, 0x6F11),(0x1000, 0x6F21),(0x1000, 0x6F31),(0x1000, 0x6F41),(0x1000, 0x6F51),(0x1000, 0x6F61),(0x1000, 0x6F71),(0x1000, 0x6F81),(0x1000, 0x6F91),(0x1000, 0x6FA1),(0x1000, 0x6FB1),(0x1000, 0x6FC1),(0x1000, 0x6FD1),(0x1000, 0x6FE1),(0x1000, 0x6FF1),(0x1000, 0x7001),(0x1000, 0x7011),(0x1000, 0x7021),(0x1000, 0x7031),(0x1000, 0x7041),(0x1000, 0x7051),(0x1000, 0x7061),(0x1000, 0x7071),(0x1000, 0x7081),(0x1000, 0x7091),(0x1000, 0x70A1),(0x1000, 0x70B1),(0x1000, 0x70C1),(0x1000, 0x70D1),(0x1000, 0x70E1),(0x1000, 0x70F1),(0x1000, 0x7101),(0x1000, 0x7111),(0x1000, 0x7121),(0x1000, 0x7131),(0x1000, 0x7141),(0x1000, 0x7151),(0x1000, 0x7161),(0x1000, 0x7171),(0x1000, 0x7181),(0x1000, 0x7191),(0x1000, 0x71A1),(0x1000, 0x71B1),(0x1000, 0x71C1),(0x1000, 0x71D1),(0x1000, 0x71E1),(0x1000, 0x71F1),(0x1000, 0x7201),(0x1000, 0x7211),(0x1000, 0x7221),(0x1000, 0x7231),(0x1000, 0x7241),(0x1000, 0x7251),(0x1000, 0x7261),(0x1000, 0x7271),(0x1000, 0x7281),(0x1000, 0x7291),(0x1000, 0x72A1),(0x1000, 0x72B1),(0x1000, 0x72C1),(0x1000, 0x72D1),(0x1000, 0x72E1),(0x1000, 0x72F1),(0x1000, 0x7301),(0x1000, 0x7311),(0x1000, 0x7321),(0x1000, 0x7331),(0x1000, 0x7341),(0x1000, 0x7351),(0x1000, 0x7361),(0x1000, 0x7371),(0x1000, 0x7381),(0x1000, 0x7391),(0x1000, 0x73A1),(0x1000, 0x73B1),(0x1000, 0x73C1),(0x1000, 0x73D1),(0x1000, 0x73E1),(0x1000, 0x73F1),(0x1000, 0x7401),(0x1000, 0x7411),(0x1000, 0x7421),(0x1000, 0x7431),(0x1000, 0x7441),(0x1000, 0x7451),(0x1000, 0x7461),(0x1000, 0x7471),(0x1000, 0x7481),(0x1000, 0x7491),(0x1000, 0x74A1),(0x1000, 0x74B1),(0x1000, 0x74C1),(0x1000, 0x74D1),(0x1000, 0x74E1),(0x1000, 0x74F1),(0x1000, 0x7501),(0x1000, 0x7511),(0x1000, 0x7521),(0x1000, 0x7531),(0x1000, 0x7541),(0x1000, 0x7551),(0x1000, 0x7561),(0x1000, 0x7571),(0x1000, 0x7581),(0x1000, 0x7591),(0x1000, 0x75A1),(0x1000, 0x75B1),(0x1000, 0x75C1),(0x1000, 0x75D1),(0x1000, 0x75E1),(0x1000, 0x75F1),(0x1000, 0x7601),(0x1000, 0x7611),(0x1000, 0x7621),(0x1000, 0x7631),(0x1000, 0x7641),(0x1000, 0x7651),(0x1000, 0x7661),(0x1000, 0x7671),(0x1000, 0x7681),(0x1000, 0x7691),(0x1000, 0x76A1),(0x1000, 0x76B1),(0x1000, 0x76C1),(0x1000, 0x76D1),(0x1000, 0x76E1),(0x1000, 0x76F1),(0x1000, 0x7701),(0x1000, 0x7711),(0x1000, 0x7721),(0x1000, 0x7731),(0x1000, 0x7741),(0x1000, 0x7751),(0x1000, 0x7761),(0x1000, 0x7771),(0x1000, 0x7781),(0x1000, 0x7791),(0x1000, 0x77A1),(0x1000, 0x77B1),(0x1000, 0x77C1),(0x1000, 0x77D1),(0x1000, 0x77E1),(0x1000, 0x77F1),(0x1000, 0x7801),(0x1000, 0x7811),(0x1000, 0x7821),(0x1000, 0x7831),(0x1000, 0x7841),(0x1000, 0x7851),(0x1000, 0x7861),(0x1000, 0x7871),(0x1000, 0x7881),(0x1000, 0x7891),(0x1000, 0x78A1),(0x1000, 0x78B1),(0x1000, 0x78C1),(0x1000, 0x78D1),(0x1000, 0x78E1),(0x1000, 0x78F1),(0x1000, 0x7901),(0x1000, 0x7911),(0x1000, 0x7921),(0x1000, 0x7931),(0x1000, 0x7941),(0x1000, 0x7951),(0x1000, 0x7961),(0x1000, 0x7971),(0x1000, 0x7981),(0x1000, 0x7991),(0x1000, 0x79A1),(0x1000, 0x79B1),(0x1000, 0x79C1),(0x1000, 0x79D1),(0x1000, 0x79E1),(0x1000, 0x79F1),(0x1000, 0x7A01),(0x1000, 0x7A11),(0x1000, 0x7A21),(0x1000, 0x7A31),(0x1000, 0x7A41),(0x1000, 0x7A51),(0x1000, 0x7A61),(0x1000, 0x7A71),(0x1000, 0x7A81),(0x1000, 0x7A91),(0x1000, 0x7AA1),(0x1000, 0x7AB1),(0x1000, 0x7AC1),(0x1000, 0x7AD1),(0x1000, 0x7AE1),(0x1000, 0x7AF1),(0x1000, 0x7B01),(0x1000, 0x7B11),(0x1000, 0x7B21),(0x1000, 0x7B31),(0x1000, 0x7B41),(0x1000, 0x7B51),(0x1000, 0x7B61),(0x1000, 0x7B71),(0x1000, 0x7B81),(0x1000, 0x7B91),(0x1000, 0x7BA1),(0x1000, 0x7BB1),(0x1000, 0x7BC1),(0x1000, 0x7BD1),(0x1000, 0x7BE1),(0x1000, 0x7BF1),(0x1000, 0x7C01),(0x1000, 0x7C11),(0x1000, 0x7C21),(0x1000, 0x7C31),(0x1000, 0x7C41),(0x1000, 0x7C51),(0x1000, 0x7C61),(0x1000, 0x7C71),(0x1000, 0x7C81),(0x1000, 0x7C91),(0x1000, 0x7CA1),(0x1000, 0x7CB1),(0x1000, 0x7CC1),(0x1000, 0x7CD1),(0x1000, 0x7CE1),(0x1000, 0x7CF1),(0x1000, 0x7D01),(0x1000, 0x7D11),(0x1000, 0x7D21),(0x1000, 0x7D31),(0x1000, 0x7D41),(0x1000, 0x7D51),(0x1000, 0x7D61),(0x1000, 0x7D71),(0x1000, 0x7D81),(0x1000, 0x7D91),(0x1000, 0x7DA1),(0x1000, 0x7DB1),(0x1000, 0x7DC1),(0x1000, 0x7DD1),(0x1000, 0x7DE1),(0x1000, 0x7DF1),(0x1000, 0x7E01),(0x1000, 0x7E11),(0x1000, 0x7E21),(0x1000, 0x7E31),(0x1000, 0x7E41),(0x1000, 0x7E51),(0x1000, 0x7E61),(0x1000, 0x7E71),(0x1000, 0x7E81),(0x1000, 0x7E91),(0x1000, 0x7EA1),(0x1000, 0x7EB1),(0x1000, 0x7EC1),(0x1000, 0x7ED1),(0x1000, 0x7EE1),(0x1000, 0x7EF1),(0x1000, 0x7F01),(0x1000, 0x7F11),(0x1000, 0x7F21),(0x1000, 0x7F31),(0x1000, 0x7F41),(0x1000, 0x7F51),(0x1000, 0x7F61),(0x1000, 0x7F71),(0x1000, 0x7F81),(0x1000, 0x7F91),(0x1000, 0x7FA1),(0x1000, 0x7FB1),(0x1000, 0x7FC1),(0x1000, 0x7FD1),(0x1000, 0x7FE1),(0x1000, 0x7FF1),(0x1000, 0x8001),(0x1000, 0x8011),(0x1000, 0x8021),(0x1000, 0x8031),(0x1000, 0x8041),(0x1000, 0x8051),(0x1000, 0x8061),(0x1000, 0x8071),(0x1000, 0x8081),(0x1000, 0x8091),(0x1000, 0x80A1),(0x1000, 0x80B1),(0x1000, 0x80C1),(0x1000, 0x80D1),(0x1000, 0x80E1),(0x1000, 0x80F1),(0x1000, 0x8101),(0x1000, 0x8111),(0x1000, 0x8121),(0x1000, 0x8131),(0x1000, 0x8141),(0x1000, 0x8151),(0x1000, 0x8161),(0x1000, 0x8171),(0x1000, 0x8181),(0x1000, 0x8191),(0x1000, 0x81A1),(0x1000, 0x81B1),(0x1000, 0x81C1),(0x1000, 0x81D1),(0x1000, 0x81E1),(0x1000, 0x81F1),(0x1000, 0x8201),(0x1000, 0x8211),(0x1000, 0x8221),(0x1000, 0x8231),(0x1000, 0x8241),(0x1000, 0x8251),(0x1000, 0x8261),(0x1000, 0x8271),(0x1000, 0x8281),(0x1000, 0x8291),(0x1000, 0x82A1),(0x1000, 0x82B1),(0x1000, 0x82C1),(0x1000, 0x82D1),(0x1000, 0x82E1),(0x1000, 0x82F1),(0x1000, 0x8301),(0x1000, 0x8311),(0x1000, 0x8321),(0x1000, 0x8331),(0x1000, 0x8341),(0x1000, 0x8351),(0x1000, 0x8361),(0x1000, 0x8371),(0x1000, 0x8381),(0x1000, 0x8391),(0x1000, 0x83A1),(0x1000, 0x83B1),(0x1000, 0x83C1),(0x1000, 0x83D1),(0x1000, 0x83E1),(0x1000, 0x83F1),(0x1000, 0x8401),(0x1000, 0x8411),(0x1000, 0x8421),(0x1000, 0x8431),(0x1000, 0x8441),(0x1000, 0x8451),(0x1000, 0x8461),(0x1000, 0x8471),(0x1000, 0x8481),(0x1000, 0x8491),(0x1000, 0x84A1),(0x1000, 0x84B1),(0x1000, 0x84C1),(0x1000, 0x84D1),(0x1000, 0x84E1),(0x1000, 0x84F1),(0x1000, 0x8501),(0x1000, 0x8511),(0x1000, 0x8521),(0x1000, 0x8531),(0x1000, 0x8541),(0x1000, 0x8551),(0x1000, 0x8561),(0x1000, 0x8571),(0x1000, 0x8581),(0x1000, 0x8591),(0x1000, 0x85A1),(0x1000, 0x85B1),(0x1000, 0x85C1),(0x1000, 0x85D1),(0x1000, 0x85E1),(0x1000, 0x85F1),(0x1000, 0x8601),(0x1000, 0x8611),(0x1000, 0x8621),(0x1000, 0x8631),(0x1000, 0x8641),(0x1000, 0x8651),(0x1000, 0x8661),(0x1000, 0x8671),(0x1000, 0x8681),(0x1000, 0x8691),(0x1000, 0x86A1),(0x1000, 0x86B1),(0x1000, 0x86C1),(0x1000, 0x86D1),(0x1000, 0x86E1),(0x1000, 0x86F1),(0x1000, 0x8701),(0x1000, 0x8711),(0x1000, 0x8721),(0x1000, 0x8731),(0x1000, 0x8741),(0x1000, 0x8751),(0x1000, 0x8761),(0x1000, 0x8771),(0x1000, 0x8781),(0x1000, 0x8791),(0x1000, 0x87A1),(0x1000, 0x87B1),(0x1000, 0x87C1),(0x1000, 0x87D1),(0x1000, 0x87E1),(0x1000, 0x87F1),(0x1000, 0x8801),(0x1000, 0x8811),(0x1000, 0x8821),(0x1000, 0x8831),(0x1000, 0x8841),(0x1000, 0x8851),(0x1000, 0x8861),(0x1000, 0x8871),(0x1000, 0x8881),(0x1000, 0x8891),(0x1000, 0x88A1),(0x1000, 0x88B1),(0x1000, 0x88C1),(0x1000, 0x88D1),(0x1000, 0x88E1),(0x1000, 0x88F1),(0x1000, 0x8901),(0x1000, 0x8911),(0x1000, 0x8921),(0x1000, 0x8931),(0x1000, 0x8941),(0x1000, 0x8951),(0x1000, 0x8961),(0x1000, 0x8971),(0x1000, 0x8981),(0x1000, 0x8991),(0x1000, 0x89A1),(0x1000, 0x89B1),(0x1000, 0x89C1),(0x1000, 0x89D1),(0x1000, 0x89E1),(0x1000, 0x89F1),(0x1000, 0x8A01),(0x1000, 0x8A11),(0x1000, 0x8A21),(0x1000, 0x8A31),(0x1000, 0x8A41),(0x1000, 0x8A51),(0x1000, 0x8A61),(0x1000, 0x8A71),(0x1000, 0x8A81),(0x1000, 0x8A91),(0x1000, 0x8AA1),(0x1000, 0x8AB1),(0x1000, 0x8AC1),(0x1000, 0x8AD1),(0x1000, 0x8AE1),(0x1000, 0x8AF1),(0x1000, 0x8B01),(0x1000, 0x8B11),(0x1000, 0x8B21),(0x1000, 0x8B31),(0x1000, 0x8B41),(0x1000, 0x8B51),(0x1000, 0x8B61),(0x1000, 0x8B71),(0x1000, 0x8B81),(0x1000, 0x8B91),(0x1000, 0x8BA1),(0x1000, 0x8BB1),(0x1000, 0x8BC1),(0x1000, 0x8BD1),(0x1000, 0x8BE1),(0x1000, 0x8BF1),(0x1000, 0x8C01),(0x1000, 0x8C11),(0x1000, 0x8C21),(0x1000, 0x8C31),(0x1000, 0x8C41),(0x1000, 0x8C51),(0x1000, 0x8C61),(0x1000, 0x8C71),(0x1000, 0x8C81),(0x1000, 0x8C91),(0x1000, 0x8CA1),(0x1000, 0x8CB1),(0x1000, 0x8CC1),(0x1000, 0x8CD1),(0x1000, 0x8CE1),(0x1000, 0x8CF1),(0x1000, 0x8D01),(0x1000, 0x8D11),(0x1000, 0x8D21),(0x1000, 0x8D31),(0x1000, 0x8D41),(0x1000, 0x8D51),(0x1000, 0x8D61),(0x1000, 0x8D71),(0x1000, 0x8D81),(0x1000, 0x8D91),(0x1000, 0x8DA1),(0x1000, 0x8DB1),(0x1000, 0x8DC1),(0x1000, 0x8DD1),(0x1000, 0x8DE1),(0x1000, 0x8DF1),(0x1000, 0x8E01),(0x1000, 0x8E11),(0x1000, 0x8E21),(0x1000, 0x8E31),(0x1000, 0x8E41),(0x1000, 0x8E51),(0x1000, 0x8E61),(0x1000, 0x8E71),(0x1000, 0x8E81),(0x1000, 0x8E91),(0x1000, 0x8EA1),(0x1000, 0x8EB1),(0x1000, 0x8EC1),(0x1000, 0x8ED1),(0x1000, 0x8EE1),(0x1000, 0x8EF1),(0x1000, 0x8F01),(0x1000, 0x8F11),(0x1000, 0x8F21),(0x1000, 0x8F31),(0x1000, 0x8F41),(0x1000, 0x8F51),(0x1000, 0x8F61),(0x1000, 0x8F71),(0x1000, 0x8F81),(0x1000, 0x8F91),(0x1000, 0x8FA1),(0x1000, 0x8FB1),(0x1000, 0x8FC1),(0x1000, 0x8FD1),(0x1000, 0x8FE1),(0x1000, 0x8FF1),(0x1000, 0x9001),(0x1000, 0x9011),(0x1000, 0x9021),(0x1000, 0x9031),(0x1000, 0x9041),(0x1000, 0x9051),(0x1000, 0x9061),(0x1000, 0x9071),(0x1000, 0x9081),(0x1000, 0x9091),(0x1000, 0x90A1),(0x1000, 0x90B1),(0x1000, 0x90C1),(0x1000, 0x90D1),(0x1000, 0x90E1),(0x1000, 0x90F1),(0x1000, 0x9101),(0x1000, 0x9111),(0x1000, 0x9121),(0x1000, 0x9131),(0x1000, 0x9141),(0x1000, 0x9151),(0x1000, 0x9161),(0x1000, 0x9171),(0x1000, 0x9181),(0x1000, 0x9191),(0x1000, 0x91A1),(0x1000, 0x91B1),(0x1000, 0x91C1),(0x1000, 0x91D1),(0x1000, 0x91E1),(0x1000, 0x91F1),(0x1000, 0x9201),(0x1000, 0x9211),(0x1000, 0x9221),(0x1000, 0x9231),(0x1000, 0x9241),(0x1000, 0x9251),(0x1000, 0x9261),(0x1000, 0x9271),(0x1000, 0x9281),(0x1000, 0x9291),(0x1000, 0x92A1),(0x1000, 0x92B1),(0x1000, 0x92C1),(0x1000, 0x92D1),(0x1000, 0x92E1),(0x1000, 0x92F1),(0x1000, 0x9301),(0x1000, 0x9311),(0x1000, 0x9321),(0x1000, 0x9331),(0x1000, 0x9341),(0x1000, 0x9351),(0x1000, 0x9361),(0x1000, 0x9371),(0x1000, 0x9381),(0x1000, 0x9391),(0x1000, 0x93A1),(0x1000, 0x93B1),(0x1000, 0x93C1),(0x1000, 0x93D1),(0x1000, 0x93E1),(0x1000, 0x93F1),(0x1000, 0x9401),(0x1000, 0x9411),(0x1000, 0x9421),(0x1000, 0x9431),(0x1000, 0x9441),(0x1000, 0x9451),(0x1000, 0x9461),(0x1000, 0x9471),(0x1000, 0x9481),(0x1000, 0x9491),(0x1000, 0x94A1),(0x1000, 0x94B1),(0x1000, 0x94C1),(0x1000, 0x94D1),(0x1000, 0x94E1),(0x1000, 0x94F1),(0x1000, 0x9501),(0x1000, 0x9511),(0x1000, 0x9521),(0x1000, 0x9531),(0x1000, 0x9541),(0x1000, 0x9551),(0x1000, 0x9561),(0x1000, 0x9571),(0x1000, 0x9581),(0x1000, 0x9591),(0x1000, 0x95A1),(0x1000, 0x95B1),(0x1000, 0x95C1),(0x1000, 0x95D1),(0x1000, 0x95E1),(0x1000, 0x95F1),(0x1000, 0x9601),(0x1000, 0x9611),(0x1000, 0x9621),(0x1000, 0x9631),(0x1000, 0x9641),(0x1000, 0x9651),(0x1000, 0x9661),(0x1000, 0x9671),(0x1000, 0x9681),(0x1000, 0x9691),(0x1000, 0x96A1),(0x1000, 0x96B1),(0x1000, 0x96C1),(0x1000, 0x96D1),(0x1000, 0x96E1),(0x1000, 0x96F1),(0x1000, 0x9701),(0x1000, 0x9711),(0x1000, 0x9721),(0x1000, 0x9731),(0x1000, 0x9741),(0x1000, 0x9751),(0x1000, 0x9761),(0x1000, 0x9771),(0x1000, 0x9781),(0x1000, 0x9791),(0x1000, 0x97A1),(0x1000, 0x97B1),(0x1000, 0x97C1),(0x1000, 0x97D1),(0x1000, 0x97E1),(0x1000, 0x97F1),(0x1000, 0x9801),(0x1000, 0x9811),(0x1000, 0x9821),(0x1000, 0x9831),(0x1000, 0x9841),(0x1000, 0x9851),(0x1000, 0x9861),(0x1000, 0x9871),(0x1000, 0x9881),(0x1000, 0x9891),(0x1000, 0x98A1),(0x1000, 0x98B1),(0x1000, 0x98C1),(0x1000, 0x98D1),(0x1000, 0x98E1),(0x1000, 0x98F1),(0x1000, 0x9901),(0x1000, 0x9911),(0x1000, 0x9921),(0x1000, 0x9931),(0x1000, 0x9941),(0x1000, 0x9951),(0x1000, 0x9961),(0x1000, 0x9971),(0x1000, 0x9981),(0x1000, 0x9991),(0x1000, 0x99A1),(0x1000, 0x99B1),(0x1000, 0x99C1),(0x1000, 0x99D1),(0x1000, 0x99E1),(0x1000, 0x99F1),(0x1000, 0x9A01),(0x1000, 0x9A11),(0x1000, 0x9A21),(0x1000, 0x9A31),(0x1000, 0x9A41),(0x1000, 0x9A51),(0x1000, 0x9A61),(0x1000, 0x9A71),(0x1000, 0x9A81),(0x1000, 0x9A91),(0x1000, 0x9AA1),(0x1000, 0x9AB1),(0x1000, 0x9AC1),(0x1000, 0x9AD1),(0x1000, 0x9AE1),(0x1000, 0x9AF1),(0x1000, 0x9B01),(0x1000, 0x9B11),(0x1000, 0x9B21),(0x1000, 0x9B31),(0x1000, 0x9B41),(0x1000, 0x9B51),(0x1000, 0x9B61),(0x1000, 0x9B71),(0x1000, 0x9B81),(0x1000, 0x9B91),(0x1000, 0x9BA1),(0x1000, 0x9BB1),(0x1000, 0x9BC1),(0x1000, 0x9BD1),(0x1000, 0x9BE1),(0x1000, 0x9BF1),(0x1000, 0x9C01),(0x1000, 0x9C11),(0x1000, 0x9C21),(0x1000, 0x9C31),(0x1000, 0x9C41),(0x1000, 0x9C51),(0x1000, 0x9C61),(0x1000, 0x9C71),(0x1000, 0x9C81),(0x1000, 0x9C91),(0x1000, 0x9CA1),(0x1000, 0x9CB1),(0x1000, 0x9CC1),(0x1000, 0x9CD1),(0x1000, 0x9CE1),(0x1000, 0x9CF1),(0x1000, 0x9D01),(0x1000, 0x9D11),(0x1000, 0x9D21),(0x1000, 0x9D31),(0x1000, 0x9D41),(0x1000, 0x9D51),(0x1000, 0x9D61),(0x1000, 0x9D71),(0x1000, 0x9D81),(0x1000, 0x9D91),(0x1000, 0x9DA1),(0x1000, 0x9DB1),(0x1000, 0x9DC1),(0x1000, 0x9DD1),(0x1000, 0x9DE1),(0x1000, 0x9DF1),(0x1000, 0x9E01),(0x1000, 0x9E11),(0x1000, 0x9E21),(0x1000, 0x9E31),(0x1000, 0x9E41),(0x1000, 0x9E51),(0x1000, 0x9E61),(0x1000, 0x9E71),(0x1000, 0x9E81),(0x1000, 0x9E91),(0x1000, 0x9EA1),(0x1000, 0x9EB1),(0x1000, 0x9EC1),(0x1000, 0x9ED1),(0x1000, 0x9EE1),(0x1000, 0x9EF1),(0x1000, 0x9F01),(0x1000, 0x9F11),(0x1000, 0x9F21),(0x1000, 0x9F31),(0x1000, 0x9F41),(0x1000, 0x9F51),(0x1000, 0x9F61),(0x1000, 0x9F71),(0x1000, 0x9F81),(0x1000, 0x9F91),(0x1000, 0x9FA1),(0x1000, 0x9FB1),(0x1000, 0x9FC1),(0x1000, 0x9FD1),(0x1000, 0x9FE1),(0x1000, 0x9FF1),(0x1000, 0xA001),(0x1000, 0xA011),(0x1000, 0xA021),(0x1000, 0xA031),(0x1000, 0xA041),(0x1000, 0xA051),(0x1000, 0xA061),(0x1000, 0xA071),(0x1000, 0xA081),(0x1000, 0xA091),(0x1000, 0xA0A1),(0x1000, 0xA0B1),(0x1000, 0xA0C1),(0x1000, 0xA0D1),(0x1000, 0xA0E1),(0x1000, 0xA0F1),(0x1000, 0xA101),(0x1000, 0xA111),(0x1000, 0xA121),(0x1000, 0xA131),(0x1000, 0xA141),(0x1000, 0xA151),(0x1000, 0xA161),(0x1000, 0xA171),(0x1000, 0xA181),(0x1000, 0xA191),(0x1000, 0xA1A1),(0x1000, 0xA1B1),(0x1000, 0xA1C1),(0x1000, 0xA1D1),(0x1000, 0xA1E1),(0x1000, 0xA1F1),(0x1000, 0xA201),(0x1000, 0xA211),(0x1000, 0xA221),(0x1000, 0xA231),(0x1000, 0xA241),(0x1000, 0xA251),(0x1000, 0xA261),(0x1000, 0xA271),(0x1000, 0xA281),(0x1000, 0xA291),(0x1000, 0xA2A1),(0x1000, 0xA2B1),(0x1000, 0xA2C1),(0x1000, 0xA2D1),(0x1000, 0xA2E1),(0x1000, 0xA2F1),(0x1000, 0xA301),(0x1000, 0xA311),(0x1000, 0xA321),(0x1000, 0xA331),(0x1000, 0xA341),(0x1000, 0xA351),(0x1000, 0xA361),(0x1000, 0xA371),(0x1000, 0xA381),(0x1000, 0xA391),(0x1000, 0xA3A1),(0x1000, 0xA3B1),(0x1000, 0xA3C1),(0x1000, 0xA3D1),(0x1000, 0xA3E1),(0x1000, 0xA3F1),(0x1000, 0xA401),(0x1000, 0xA411),(0x1000, 0xA421),(0x1000, 0xA431),(0x1000, 0xA441),(0x1000, 0xA451),(0x1000, 0xA461),(0x1000, 0xA471),(0x1000, 0xA481),(0x1000, 0xA491),(0x1000, 0xA4A1),(0x1000, 0xA4B1),(0x1000, 0xA4C1),(0x1000, 0xA4D1),(0x1000, 0xA4E1),(0x1000, 0xA4F1),(0x1000, 0xA501),(0x1000, 0xA511),(0x1000, 0xA521),(0x1000, 0xA531),(0x1000, 0xA541),(0x1000, 0xA551),(0x1000, 0xA561),(0x1000, 0xA571),(0x1000, 0xA581),(0x1000, 0xA591),(0x1000, 0xA5A1),(0x1000, 0xA5B1),(0x1000, 0xA5C1),(0x1000, 0xA5D1),(0x1000, 0xA5E1),(0x1000, 0xA5F1),(0x1000, 0xA601),(0x1000, 0xA611),(0x1000, 0xA621),(0x1000, 0xA631),(0x1000, 0xA641),(0x1000, 0xA651),(0x1000, 0xA661),(0x1000, 0xA671),(0x1000, 0xA681),(0x1000, 0xA691),(0x1000, 0xA6A1),(0x1000, 0xA6B1),(0x1000, 0xA6C1),(0x1000, 0xA6D1),(0x1000, 0xA6E1),(0x1000, 0xA6F1),(0x1000, 0xA701),(0x1000, 0xA711),(0x1000, 0xA721),(0x1000, 0xA731),(0x1000, 0xA741),(0x1000, 0xA751),(0x1000, 0xA761),(0x1000, 0xA771),(0x1000, 0xA781),(0x1000, 0xA791),(0x1000, 0xA7A1),(0x1000, 0xA7B1),(0x1000, 0xA7C1),(0x1000, 0xA7D1),(0x1000, 0xA7E1),(0x1000, 0xA7F1),(0x1000, 0xA801),(0x1000, 0xA811),(0x1000, 0xA821),(0x1000, 0xA831),(0x1000, 0xA841),(0x1000, 0xA851),(0x1000, 0xA861),(0x1000, 0xA871),(0x1000, 0xA881),(0x1000, 0xA891),(0x1000, 0xA8A1),(0x1000, 0xA8B1),(0x1000, 0xA8C1),(0x1000, 0xA8D1),(0x1000, 0xA8E1),(0x1000, 0xA8F1),(0x1000, 0xA901),(0x1000, 0xA911),(0x1000, 0xA921),(0x1000, 0xA931),(0x1000, 0xA941),(0x1000, 0xA951),(0x1000, 0xA961),(0x1000, 0xA971),(0x1000, 0xA981),(0x1000, 0xA991),(0x1000, 0xA9A1),(0x1000, 0xA9B1),(0x1000, 0xA9C1),(0x1000, 0xA9D1),(0x1000, 0xA9E1),(0x1000, 0xA9F1),(0x1000, 0xAA01),(0x1000, 0xAA11),(0x1000, 0xAA21),(0x1000, 0xAA31),(0x1000, 0xAA41),(0x1000, 0xAA51),(0x1000, 0xAA61),(0x1000, 0xAA71),(0x1000, 0xAA81),(0x1000, 0xAA91),(0x1000, 0xAAA1),(0x1000, 0xAAB1),(0x1000, 0xAAC1),(0x1000, 0xAAD1),(0x1000, 0xAAE1),(0x1000, 0xAAF1),(0x1000, 0xAB01),(0x1000, 0xAB11),(0x1000, 0xAB21),(0x1000, 0xAB31),(0x1000, 0xAB41),(0x1000, 0xAB51),(0x1000, 0xAB61),(0x1000, 0xAB71),(0x1000, 0xAB81),(0x1000, 0xAB91),(0x1000, 0xABA1),(0x1000, 0xABB1),(0x1000, 0xABC1),(0x1000, 0xABD1),(0x1000, 0xABE1),(0x1000, 0xABF1),(0x1000, 0xAC01),(0x1000, 0xAC11),(0x1000, 0xAC21),(0x1000, 0xAC31),(0x1000, 0xAC41),(0x1000, 0xAC51),(0x1000, 0xAC61),(0x1000, 0xAC71),(0x1000, 0xAC81),(0x1000, 0xAC91),(0x1000, 0xACA1),(0x1000, 0xACB1),(0x1000, 0xACC1),(0x1000, 0xACD1),(0x1000, 0xACE1),(0x1000, 0xACF1),(0x1000, 0xAD01),(0x1000, 0xAD11),(0x1000, 0xAD21),(0x1000, 0xAD31),(0x1000, 0xAD41),(0x1000, 0xAD51),(0x1000, 0xAD61),(0x1000, 0xAD71),(0x1000, 0xAD81),(0x1000, 0xAD91),(0x1000, 0xADA1),(0x1000, 0xADB1),(0x1000, 0xADC1),(0x1000, 0xADD1),(0x1000, 0xADE1),(0x1000, 0xADF1),(0x1000, 0xAE01),(0x1000, 0xAE11),(0x1000, 0xAE21),(0x1000, 0xAE31),(0x1000, 0xAE41),(0x1000, 0xAE51),(0x1000, 0xAE61),(0x1000, 0xAE71),(0x1000, 0xAE81),(0x1000, 0xAE91),(0x1000, 0xAEA1),(0x1000, 0xAEB1),(0x1000, 0xAEC1),(0x1000, 0xAED1),(0x1000, 0xAEE1),(0x1000, 0xAEF1),(0x1000, 0xAF01),(0x1000, 0xAF11),(0x1000, 0xAF21),(0x1000, 0xAF31),(0x1000, 0xAF41),(0x1000, 0xAF51),(0x1000, 0xAF61),(0x1000, 0xAF71),(0x1000, 0xAF81),(0x1000, 0xAF91),(0x1000, 0xAFA1),(0x1000, 0xAFB1),(0x1000, 0xAFC1),(0x1000, 0xAFD1),(0x1000, 0xAFE1),(0x1000, 0xAFF1),(0x1000, 0xB001),(0x1000, 0xB011),(0x1000, 0xB021),(0x1000, 0xB031),(0x1000, 0xB041),(0x1000, 0xB051),(0x1000, 0xB061),(0x1000, 0xB071),(0x1000, 0xB081),(0x1000, 0xB091),(0x1000, 0xB0A1),(0x1000, 0xB0B1),(0x1000, 0xB0C1),(0x1000, 0xB0D1),(0x1000, 0xB0E1),(0x1000, 0xB0F1),(0x1000, 0xB101),(0x1000, 0xB111),(0x1000, 0xB121),(0x1000, 0xB131),(0x1000, 0xB141),(0x1000, 0xB151),(0x1000, 0xB161),(0x1000, 0xB171),(0x1000, 0xB181),(0x1000, 0xB191),(0x1000, 0xB1A1),(0x1000, 0xB1B1),(0x1000, 0xB1C1),(0x1000, 0xB1D1),(0x1000, 0xB1E1),(0x1000, 0xB1F1),(0x1000, 0xB201),(0x1000, 0xB211),(0x1000, 0xB221),(0x1000, 0xB231),(0x1000, 0xB241),(0x1000, 0xB251),(0x1000, 0xB261),(0x1000, 0xB271),(0x1000, 0xB281),(0x1000, 0xB291),(0x1000, 0xB2A1),(0x1000, 0xB2B1),(0x1000, 0xB2C1),(0x1000, 0xB2D1),(0x1000, 0xB2E1),(0x1000, 0xB2F1),(0x1000, 0xB301),(0x1000, 0xB311),(0x1000, 0xB321),(0x1000, 0xB331),(0x1000, 0xB341),(0x1000, 0xB351),(0x1000, 0xB361),(0x1000, 0xB371),(0x1000, 0xB381),(0x1000, 0xB391),(0x1000, 0xB3A1),(0x1000, 0xB3B1),(0x1000, 0xB3C1),(0x1000, 0xB3D1),(0x1000, 0xB3E1),(0x1000, 0xB3F1),(0x1000, 0xB401),(0x1000, 0xB411),(0x1000, 0xB421),(0x1000, 0xB431),(0x1000, 0xB441),(0x1000, 0xB451),(0x1000, 0xB461),(0x1000, 0xB471),(0x1000, 0xB481),(0x1000, 0xB491),(0x1000, 0xB4A1),(0x1000, 0xB4B1),(0x1000, 0xB4C1),(0x1000, 0xB4D1),(0x1000, 0xB4E1),(0x1000, 0xB4F1),(0x1000, 0xB501),(0x1000, 0xB511),(0x1000, 0xB521),(0x1000, 0xB531),(0x1000, 0xB541),(0x1000, 0xB551),(0x1000, 0xB561),(0x1000, 0xB571),(0x1000, 0xB581),(0x1000, 0xB591),(0x1000, 0xB5A1),(0x1000, 0xB5B1),(0x1000, 0xB5C1),(0x1000, 0xB5D1),(0x1000, 0xB5E1),(0x1000, 0xB5F1),(0x1000, 0xB601),(0x1000, 0xB611),(0x1000, 0xB621),(0x1000, 0xB631),(0x1000, 0xB641),(0x1000, 0xB651),(0x1000, 0xB661),(0x1000, 0xB671),(0x1000, 0xB681),(0x1000, 0xB691),(0x1000, 0xB6A1),(0x1000, 0xB6B1),(0x1000, 0xB6C1),(0x1000, 0xB6D1),(0x1000, 0xB6E1),(0x1000, 0xB6F1),(0x1000, 0xB701),(0x1000, 0xB711),(0x1000, 0xB721),(0x1000, 0xB731),(0x1000, 0xB741),(0x1000, 0xB751),(0x1000, 0xB761),(0x1000, 0xB771),(0x1000, 0xB781),(0x1000, 0xB791),(0x1000, 0xB7A1),(0x1000, 0xB7B1),(0x1000, 0xB7C1),(0x1000, 0xB7D1),(0x1000, 0xB7E1),(0x1000, 0xB7F1),(0x1000, 0xB801),(0x1000, 0xB811),(0x1000, 0xB821),(0x1000, 0xB831),(0x1000, 0xB841),(0x1000, 0xB851),(0x1000, 0xB861),(0x1000, 0xB871),(0x1000, 0xB881),(0x1000, 0xB891),(0x1000, 0xB8A1),(0x1000, 0xB8B1),(0x1000, 0xB8C1),(0x1000, 0xB8D1),(0x1000, 0xB8E1),(0x1000, 0xB8F1),(0x1000, 0xB901),(0x1000, 0xB911),(0x1000, 0xB921),(0x1000, 0xB931),(0x1000, 0xB941),(0x1000, 0xB951),(0x1000, 0xB961),(0x1000, 0xB971),(0x1000, 0xB981),(0x1000, 0xB991),(0x1000, 0xB9A1),(0x1000, 0xB9B1),(0x1000, 0xB9C1),(0x1000, 0xB9D1),(0x1000, 0xB9E1),(0x1000, 0xB9F1),(0x1000, 0xBA01),(0x1000, 0xBA11),(0x1000, 0xBA21),(0x1000, 0xBA31),(0x1000, 0xBA41),(0x1000, 0xBA51),(0x1000, 0xBA61),(0x1000, 0xBA71),(0x1000, 0xBA81),(0x1000, 0xBA91),(0x1000, 0xBAA1),(0x1000, 0xBAB1),(0x1000, 0xBAC1),(0x1000, 0xBAD1),(0x1000, 0xBAE1),(0x1000, 0xBAF1),(0x1000, 0xBB01),(0x1000, 0xBB11),(0x1000, 0xBB21),(0x1000, 0xBB31),(0x1000, 0xBB41),(0x1000, 0xBB51),(0x1000, 0xBB61),(0x1000, 0xBB71),(0x1000, 0xBB81),(0x1000, 0xBB91),(0x1000, 0xBBA1),(0x1000, 0xBBB1),(0x1000, 0xBBC1),(0x1000, 0xBBD1),(0x1000, 0xBBE1),(0x1000, 0xBBF1),(0x1000, 0xBC01),(0x1000, 0xBC11),(0x1000, 0xBC21),(0x1000, 0xBC31),(0x1000, 0xBC41),(0x1000, 0xBC51),(0x1000, 0xBC61),(0x1000, 0xBC71),(0x1000, 0xBC81),(0x1000, 0xBC91),(0x1000, 0xBCA1),(0x1000, 0xBCB1),(0x1000, 0xBCC1),(0x1000, 0xBCD1),(0x1000, 0xBCE1),(0x1000, 0xBCF1),(0x1000, 0xBD01),(0x1000, 0xBD11),(0x1000, 0xBD21),(0x1000, 0xBD31),(0x1000, 0xBD41),(0x1000, 0xBD51),(0x1000, 0xBD61),(0x1000, 0xBD71),(0x1000, 0xBD81),(0x1000, 0xBD91),(0x1000, 0xBDA1),(0x1000, 0xBDB1),(0x1000, 0xBDC1),(0x1000, 0xBDD1),(0x1000, 0xBDE1),(0x1000, 0xBDF1),(0x1000, 0xBE01),(0x1000, 0xBE11),(0x1000, 0xBE21),(0x1000, 0xBE31),(0x1000, 0xBE41),(0x1000, 0xBE51),(0x1000, 0xBE61),(0x1000, 0xBE71),(0x1000, 0xBE81),(0x1000, 0xBE91),(0x1000, 0xBEA1),(0x1000, 0xBEB1),(0x1000, 0xBEC1),(0x1000, 0xBED1),(0x1000, 0xBEE1),(0x1000, 0xBEF1),(0x1000, 0xBF01),(0x1000, 0xBF11),(0x1000, 0xBF21),(0x1000, 0xBF31),(0x1000, 0xBF41),(0x1000, 0xBF51),(0x1000, 0xBF61),(0x1000, 0xBF71),(0x1000, 0xBF81),(0x1000, 0xBF91),(0x1000, 0xBFA1),(0x1000, 0xBFB1),(0x1000, 0xBFC1),(0x1000, 0xBFD1),(0x1000, 0xBFE1),(0x1000, 0xBFF1),(0x1000, 0xC001),(0x1000, 0xC011),(0x1000, 0xC021),(0x1000, 0xC031),(0x1000, 0xC041),(0x1000, 0xC051),(0x1000, 0xC061),(0x1000, 0xC071),(0x1000, 0xC081),(0x1000, 0xC091),(0x1000, 0xC0A1),(0x1000, 0xC0B1),(0x1000, 0xC0C1),(0x1000, 0xC0D1),(0x1000, 0xC0E1),(0x1000, 0xC0F1),(0x1000, 0xC101),(0x1000, 0xC111),(0x1000, 0xC121),(0x1000, 0xC131),(0x1000, 0xC141),(0x1000, 0xC151),(0x1000, 0xC161),(0x1000, 0xC171),(0x1000, 0xC181),(0x1000, 0xC191),(0x1000, 0xC1A1),(0x1000, 0xC1B1),(0x1000, 0xC1C1),(0x1000, 0xC1D1),(0x1000, 0xC1E1),(0x1000, 0xC1F1),(0x1000, 0xC201),(0x1000, 0xC211),(0x1000, 0xC221),(0x1000, 0xC231),(0x1000, 0xC241),(0x1000, 0xC251),(0x1000, 0xC261),(0x1000, 0xC271),(0x1000, 0xC281),(0x1000, 0xC291),(0x1000, 0xC2A1),(0x1000, 0xC2B1),(0x1000, 0xC2C1),(0x1000, 0xC2D1),(0x1000, 0xC2E1),(0x1000, 0xC2F1),(0x1000, 0xC301),(0x1000, 0xC311),(0x1000, 0xC321),(0x1000, 0xC331),(0x1000, 0xC341),(0x1000, 0xC351),(0x1000, 0xC361),(0x1000, 0xC371),(0x1000, 0xC381),(0x1000, 0xC391),(0x1000, 0xC3A1),(0x1000, 0xC3B1),(0x1000, 0xC3C1),(0x1000, 0xC3D1),(0x1000, 0xC3E1),(0x1000, 0xC3F1),(0x1000, 0xC401),(0x1000, 0xC411),(0x1000, 0xC421),(0x1000, 0xC431),(0x1000, 0xC441),(0x1000, 0xC451),(0x1000, 0xC461),(0x1000, 0xC471),(0x1000, 0xC481),(0x1000, 0xC491),(0x1000, 0xC4A1),(0x1000, 0xC4B1),(0x1000, 0xC4C1),(0x1000, 0xC4D1),(0x1000, 0xC4E1),(0x1000, 0xC4F1),(0x1000, 0xC501),(0x1000, 0xC511),(0x1000, 0xC521),(0x1000, 0xC531),(0x1000, 0xC541),(0x1000, 0xC551),(0x1000, 0xC561),(0x1000, 0xC571),(0x1000, 0xC581),(0x1000, 0xC591),(0x1000, 0xC5A1),(0x1000, 0xC5B1),(0x1000, 0xC5C1),(0x1000, 0xC5D1),(0x1000, 0xC5E1),(0x1000, 0xC5F1),(0x1000, 0xC601),(0x1000, 0xC611),(0x1000, 0xC621),(0x1000, 0xC631),(0x1000, 0xC641),(0x1000, 0xC651),(0x1000, 0xC661),(0x1000, 0xC671),(0x1000, 0xC681),(0x1000, 0xC691),(0x1000, 0xC6A1),(0x1000, 0xC6B1),(0x1000, 0xC6C1),(0x1000, 0xC6D1),(0x1000, 0xC6E1),(0x1000, 0xC6F1),(0x1000, 0xC701),(0x1000, 0xC711),(0x1000, 0xC721),(0x1000, 0xC731),(0x1000, 0xC741),(0x1000, 0xC751),(0x1000, 0xC761),(0x1000, 0xC771),(0x1000, 0xC781),(0x1000, 0xC791),(0x1000, 0xC7A1),(0x1000, 0xC7B1),(0x1000, 0xC7C1),(0x1000, 0xC7D1),(0x1000, 0xC7E1),(0x1000, 0xC7F1),(0x1000, 0xC801),(0x1000, 0xC811),(0x1000, 0xC821),(0x1000, 0xC831),(0x1000, 0xC841),(0x1000, 0xC851),(0x1000, 0xC861),(0x1000, 0xC871),(0x1000, 0xC881),(0x1000, 0xC891),(0x1000, 0xC8A1),(0x1000, 0xC8B1),(0x1000, 0xC8C1),(0x1000, 0xC8D1),(0x1000, 0xC8E1),(0x1000, 0xC8F1),(0x1000, 0xC901),(0x1000, 0xC911),(0x1000, 0xC921),(0x1000, 0xC931),(0x1000, 0xC941),(0x1000, 0xC951),(0x1000, 0xC961),(0x1000, 0xC971),(0x1000, 0xC981),(0x1000, 0xC991),(0x1000, 0xC9A1),(0x1000, 0xC9B1),(0x1000, 0xC9C1),(0x1000, 0xC9D1),(0x1000, 0xC9E1),(0x1000, 0xC9F1),(0x1000, 0xCA01),(0x1000, 0xCA11),(0x1000, 0xCA21),(0x1000, 0xCA31),(0x1000, 0xCA41),(0x1000, 0xCA51),(0x1000, 0xCA61),(0x1000, 0xCA71),(0x1000, 0xCA81),(0x1000, 0xCA91),(0x1000, 0xCAA1),(0x1000, 0xCAB1),(0x1000, 0xCAC1),(0x1000, 0xCAD1),(0x1000, 0xCAE1),(0x1000, 0xCAF1),(0x1000, 0xCB01),(0x1000, 0xCB11),(0x1000, 0xCB21),(0x1000, 0xCB31),(0x1000, 0xCB41),(0x1000, 0xCB51),(0x1000, 0xCB61),(0x1000, 0xCB71),(0x1000, 0xCB81),(0x1000, 0xCB91),(0x1000, 0xCBA1),(0x1000, 0xCBB1),(0x1000, 0xCBC1),(0x1000, 0xCBD1),(0x1000, 0xCBE1),(0x1000, 0xCBF1),(0x1000, 0xCC01),(0x1000, 0xCC11),(0x1000, 0xCC21),(0x1000, 0xCC31),(0x1000, 0xCC41),(0x1000, 0xCC51),(0x1000, 0xCC61),(0x1000, 0xCC71),(0x1000, 0xCC81),(0x1000, 0xCC91),(0x1000, 0xCCA1),(0x1000, 0xCCB1),(0x1000, 0xCCC1),(0x1000, 0xCCD1),(0x1000, 0xCCE1),(0x1000, 0xCCF1),(0x1000, 0xCD01),(0x1000, 0xCD11),(0x1000, 0xCD21),(0x1000, 0xCD31),(0x1000, 0xCD41),(0x1000, 0xCD51),(0x1000, 0xCD61),(0x1000, 0xCD71),(0x1000, 0xCD81),(0x1000, 0xCD91),(0x1000, 0xCDA1),(0x1000, 0xCDB1),(0x1000, 0xCDC1),(0x1000, 0xCDD1),(0x1000, 0xCDE1),(0x1000, 0xCDF1),(0x1000, 0xCE01),(0x1000, 0xCE11),(0x1000, 0xCE21),(0x1000, 0xCE31),(0x1000, 0xCE41),(0x1000, 0xCE51),(0x1000, 0xCE61),(0x1000, 0xCE71),(0x1000, 0xCE81),(0x1000, 0xCE91),(0x1000, 0xCEA1),(0x1000, 0xCEB1),(0x1000, 0xCEC1),(0x1000, 0xCED1),(0x1000, 0xCEE1),(0x1000, 0xCEF1),(0x1000, 0xCF01),(0x1000, 0xCF11),(0x1000, 0xCF21),(0x1000, 0xCF31),(0x1000, 0xCF41),(0x1000, 0xCF51),(0x1000, 0xCF61),(0x1000, 0xCF71),(0x1000, 0xCF81),(0x1000, 0xCF91),(0x1000, 0xCFA1),(0x1000, 0xCFB1),(0x1000, 0xCFC1),(0x1000, 0xCFD1),(0x1000, 0xCFE1),(0x1000, 0xCFF1),(0x1000, 0xD001),(0x1000, 0xD011),(0x1000, 0xD021),(0x1000, 0xD031),(0x1000, 0xD041),(0x1000, 0xD051),(0x1000, 0xD061),(0x1000, 0xD071),(0x1000, 0xD081),(0x1000, 0xD091),(0x1000, 0xD0A1),(0x1000, 0xD0B1),(0x1000, 0xD0C1),(0x1000, 0xD0D1),(0x1000, 0xD0E1),(0x1000, 0xD0F1),(0x1000, 0xD101),(0x1000, 0xD111),(0x1000, 0xD121),(0x1000, 0xD131),(0x1000, 0xD141),(0x1000, 0xD151),(0x1000, 0xD161),(0x1000, 0xD171),(0x1000, 0xD181),(0x1000, 0xD191),(0x1000, 0xD1A1),(0x1000, 0xD1B1),(0x1000, 0xD1C1),(0x1000, 0xD1D1),(0x1000, 0xD1E1),(0x1000, 0xD1F1),(0x1000, 0xD201),(0x1000, 0xD211),(0x1000, 0xD221),(0x1000, 0xD231),(0x1000, 0xD241),(0x1000, 0xD251),(0x1000, 0xD261),(0x1000, 0xD271),(0x1000, 0xD281),(0x1000, 0xD291),(0x1000, 0xD2A1),(0x1000, 0xD2B1),(0x1000, 0xD2C1),(0x1000, 0xD2D1),(0x1000, 0xD2E1),(0x1000, 0xD2F1),(0x1000, 0xD301),(0x1000, 0xD311),(0x1000, 0xD321),(0x1000, 0xD331),(0x1000, 0xD341),(0x1000, 0xD351),(0x1000, 0xD361),(0x1000, 0xD371),(0x1000, 0xD381),(0x1000, 0xD391),(0x1000, 0xD3A1),(0x1000, 0xD3B1),(0x1000, 0xD3C1),(0x1000, 0xD3D1),(0x1000, 0xD3E1),(0x1000, 0xD3F1),(0x1000, 0xD401),(0x1000, 0xD411),(0x1000, 0xD421),(0x1000, 0xD431),(0x1000, 0xD441),(0x1000, 0xD451),(0x1000, 0xD461),(0x1000, 0xD471),(0x1000, 0xD481),(0x1000, 0xD491),(0x1000, 0xD4A1),(0x1000, 0xD4B1),(0x1000, 0xD4C1),(0x1000, 0xD4D1),(0x1000, 0xD4E1),(0x1000, 0xD4F1),(0x1000, 0xD501),(0x1000, 0xD511),(0x1000, 0xD521),(0x1000, 0xD531),(0x1000, 0xD541),(0x1000, 0xD551),(0x1000, 0xD561),(0x1000, 0xD571),(0x1000, 0xD581),(0x1000, 0xD591),(0x1000, 0xD5A1),(0x1000, 0xD5B1),(0x1000, 0xD5C1),(0x1000, 0xD5D1),(0x1000, 0xD5E1),(0x1000, 0xD5F1),(0x1000, 0xD601),(0x1000, 0xD611),(0x1000, 0xD621),(0x1000, 0xD631),(0x1000, 0xD641),(0x1000, 0xD651),(0x1000, 0xD661),(0x1000, 0xD671),(0x1000, 0xD681),(0x1000, 0xD691),(0x1000, 0xD6A1),(0x1000, 0xD6B1),(0x1000, 0xD6C1),(0x1000, 0xD6D1),(0x1000, 0xD6E1),(0x1000, 0xD6F1),(0x1000, 0xD701),(0x1000, 0xD711),(0x1000, 0xD721),(0x1000, 0xD731),(0x1000, 0xD741),(0x1000, 0xD751),(0x1000, 0xD761),(0x1000, 0xD771),(0x1000, 0xD781),(0x1000, 0xD791),(0x1000, 0xD7A1),(0x1000, 0xD7B1),(0x1000, 0xD7C1),(0x1000, 0xD7D1),(0x1000, 0xD7E1),(0x1000, 0xD7F1),(0x1000, 0xD801),(0x1000, 0xD811),(0x1000, 0xD821),(0x1000, 0xD831),(0x1000, 0xD841),(0x1000, 0xD851),(0x1000, 0xD861),(0x1000, 0xD871),(0x1000, 0xD881),(0x1000, 0xD891),(0x1000, 0xD8A1),(0x1000, 0xD8B1),(0x1000, 0xD8C1),(0x1000, 0xD8D1),(0x1000, 0xD8E1),(0x1000, 0xD8F1),(0x1000, 0xD901),(0x1000, 0xD911),(0x1000, 0xD921),(0x1000, 0xD931),(0x1000, 0xD941),(0x1000, 0xD951),(0x1000, 0xD961),(0x1000, 0xD971),(0x1000, 0xD981),(0x1000, 0xD991),(0x1000, 0xD9A1),(0x1000, 0xD9B1),(0x1000, 0xD9C1),(0x1000, 0xD9D1),(0x1000, 0xD9E1),(0x1000, 0xD9F1),(0x1000, 0xDA01),(0x1000, 0xDA11),(0x1000, 0xDA21),(0x1000, 0xDA31),(0x1000, 0xDA41),(0x1000, 0xDA51),(0x1000, 0xDA61),(0x1000, 0xDA71),(0x1000, 0xDA81),(0x1000, 0xDA91),(0x1000, 0xDAA1),(0x1000, 0xDAB1),(0x1000, 0xDAC1),(0x1000, 0xDAD1),(0x1000, 0xDAE1),(0x1000, 0xDAF1),(0x1000, 0xDB01),(0x1000, 0xDB11),(0x1000, 0xDB21),(0x1000, 0xDB31),(0x1000, 0xDB41),(0x1000, 0xDB51),(0x1000, 0xDB61),(0x1000, 0xDB71),(0x1000, 0xDB81),(0x1000, 0xDB91),(0x1000, 0xDBA1),(0x1000, 0xDBB1),(0x1000, 0xDBC1),(0x1000, 0xDBD1),(0x1000, 0xDBE1),(0x1000, 0xDBF1),(0x1000, 0xDC01),(0x1000, 0xDC11),(0x1000, 0xDC21),(0x1000, 0xDC31),(0x1000, 0xDC41),(0x1000, 0xDC51),(0x1000, 0xDC61),(0x1000, 0xDC71),(0x1000, 0xDC81),(0x1000, 0xDC91),(0x1000, 0xDCA1),(0x1000, 0xDCB1),(0x1000, 0xDCC1),(0x1000, 0xDCD1),(0x1000, 0xDCE1),(0x1000, 0xDCF1),(0x1000, 0xDD01),(0x1000, 0xDD11),(0x1000, 0xDD21),(0x1000, 0xDD31),(0x1000, 0xDD41),(0x1000, 0xDD51),(0x1000, 0xDD61),(0x1000, 0xDD71),(0x1000, 0xDD81),(0x1000, 0xDD91),(0x1000, 0xDDA1),(0x1000, 0xDDB1),(0x1000, 0xDDC1),(0x1000, 0xDDD1),(0x1000, 0xDDE1),(0x1000, 0xDDF1),(0x1000, 0xDE01),(0x1000, 0xDE11),(0x1000, 0xDE21),(0x1000, 0xDE31),(0x1000, 0xDE41),(0x1000, 0xDE51),(0x1000, 0xDE61),(0x1000, 0xDE71),(0x1000, 0xDE81),(0x1000, 0xDE91),(0x1000, 0xDEA1),(0x1000, 0xDEB1),(0x1000, 0xDEC1),(0x1000, 0xDED1),(0x1000, 0xDEE1),(0x1000, 0xDEF1),(0x1000, 0xDF01),(0x1000, 0xDF11),(0x1000, 0xDF21),(0x1000, 0xDF31),(0x1000, 0xDF41),(0x1000, 0xDF51),(0x1000, 0xDF61),(0x1000, 0xDF71),(0x1000, 0xDF81),(0x1000, 0xDF91),(0x1000, 0xDFA1),(0x1000, 0xDFB1),(0x1000, 0xDFC1),(0x1000, 0xDFD1),(0x1000, 0xDFE1),(0x1000, 0xDFF1),(0x1000, 0xE001),(0x1000, 0xE011),(0x1000, 0xE021),(0x1000, 0xE031),(0x1000, 0xE041),(0x1000, 0xE051),(0x1000, 0xE061),(0x1000, 0xE071),(0x1000, 0xE081),(0x1000, 0xE091),(0x1000, 0xE0A1),(0x1000, 0xE0B1),(0x1000, 0xE0C1),(0x1000, 0xE0D1),(0x1000, 0xE0E1),(0x1000, 0xE0F1),(0x1000, 0xE101),(0x1000, 0xE111),(0x1000, 0xE121),(0x1000, 0xE131),(0x1000, 0xE141),(0x1000, 0xE151),(0x1000, 0xE161),(0x1000, 0xE171),(0x1000, 0xE181),(0x1000, 0xE191),(0x1000, 0xE1A1),(0x1000, 0xE1B1),(0x1000, 0xE1C1),(0x1000, 0xE1D1),(0x1000, 0xE1E1),(0x1000, 0xE1F1),(0x1000, 0xE201),(0x1000, 0xE211),(0x1000, 0xE221),(0x1000, 0xE231),(0x1000, 0xE241),(0x1000, 0xE251),(0x1000, 0xE261),(0x1000, 0xE271),(0x1000, 0xE281),(0x1000, 0xE291),(0x1000, 0xE2A1),(0x1000, 0xE2B1),(0x1000, 0xE2C1),(0x1000, 0xE2D1),(0x1000, 0xE2E1),(0x1000, 0xE2F1),(0x1000, 0xE301),(0x1000, 0xE311),(0x1000, 0xE321),(0x1000, 0xE331),(0x1000, 0xE341),(0x1000, 0xE351),(0x1000, 0xE361),(0x1000, 0xE371),(0x1000, 0xE381),(0x1000, 0xE391),(0x1000, 0xE3A1),(0x1000, 0xE3B1),(0x1000, 0xE3C1),(0x1000, 0xE3D1),(0x1000, 0xE3E1),(0x1000, 0xE3F1),(0x1000, 0xE401),(0x1000, 0xE411),(0x1000, 0xE421),(0x1000, 0xE431),(0x1000, 0xE441),(0x1000, 0xE451),(0x1000, 0xE461),(0x1000, 0xE471),(0x1000, 0xE481),(0x1000, 0xE491),(0x1000, 0xE4A1),(0x1000, 0xE4B1),(0x1000, 0xE4C1),(0x1000, 0xE4D1),(0x1000, 0xE4E1),(0x1000, 0xE4F1),(0x1000, 0xE501),(0x1000, 0xE511),(0x1000, 0xE521),(0x1000, 0xE531),(0x1000, 0xE541),(0x1000, 0xE551),(0x1000, 0xE561),(0x1000, 0xE571),(0x1000, 0xE581),(0x1000, 0xE591),(0x1000, 0xE5A1),(0x1000, 0xE5B1),(0x1000, 0xE5C1),(0x1000, 0xE5D1),(0x1000, 0xE5E1),(0x1000, 0xE5F1),(0x1000, 0xE601),(0x1000, 0xE611),(0x1000, 0xE621),(0x1000, 0xE631),(0x1000, 0xE641),(0x1000, 0xE651),(0x1000, 0xE661),(0x1000, 0xE671),(0x1000, 0xE681),(0x1000, 0xE691),(0x1000, 0xE6A1),(0x1000, 0xE6B1),(0x1000, 0xE6C1),(0x1000, 0xE6D1),(0x1000, 0xE6E1),(0x1000, 0xE6F1),(0x1000, 0xE701),(0x1000, 0xE711),(0x1000, 0xE721),(0x1000, 0xE731),(0x1000, 0xE741),(0x1000, 0xE751),(0x1000, 0xE761),(0x1000, 0xE771),(0x1000, 0xE781),(0x1000, 0xE791),(0x1000, 0xE7A1),(0x1000, 0xE7B1),(0x1000, 0xE7C1),(0x1000, 0xE7D1),(0x1000, 0xE7E1),(0x1000, 0xE7F1),(0x1000, 0xE801),(0x1000, 0xE811),(0x1000, 0xE821),(0x1000, 0xE831),(0x1000, 0xE841),(0x1000, 0xE851),(0x1000, 0xE861),(0x1000, 0xE871),(0x1000, 0xE881),(0x1000, 0xE891),(0x1000, 0xE8A1),(0x1000, 0xE8B1),(0x1000, 0xE8C1),(0x1000, 0xE8D1),(0x1000, 0xE8E1),(0x1000, 0xE8F1),(0x1000, 0xE901),(0x1000, 0xE911),(0x1000, 0xE921),(0x1000, 0xE931),(0x1000, 0xE941),(0x1000, 0xE951),(0x1000, 0xE961),(0x1000, 0xE971),(0x1000, 0xE981),(0x1000, 0xE991),(0x1000, 0xE9A1),(0x1000, 0xE9B1),(0x1000, 0xE9C1),(0x1000, 0xE9D1),(0x1000, 0xE9E1),(0x1000, 0xE9F1),(0x1000, 0xEA01),(0x1000, 0xEA11),(0x1000, 0xEA21),(0x1000, 0xEA31),(0x1000, 0xEA41),(0x1000, 0xEA51),(0x1000, 0xEA61),(0x1000, 0xEA71),(0x1000, 0xEA81),(0x1000, 0xEA91),(0x1000, 0xEAA1),(0x1000, 0xEAB1),(0x1000, 0xEAC1),(0x1000, 0xEAD1),(0x1000, 0xEAE1),(0x1000, 0xEAF1),(0x1000, 0xEB01),(0x1000, 0xEB11),(0x1000, 0xEB21),(0x1000, 0xEB31),(0x1000, 0xEB41),(0x1000, 0xEB51),(0x1000, 0xEB61),(0x1000, 0xEB71),(0x1000, 0xEB81),(0x1000, 0xEB91),(0x1000, 0xEBA1),(0x1000, 0xEBB1),(0x1000, 0xEBC1),(0x1000, 0xEBD1),(0x1000, 0xEBE1),(0x1000, 0xEBF1),(0x1000, 0xEC01),(0x1000, 0xEC11),(0x1000, 0xEC21),(0x1000, 0xEC31),(0x1000, 0xEC41),(0x1000, 0xEC51),(0x1000, 0xEC61),(0x1000, 0xEC71),(0x1000, 0xEC81),(0x1000, 0xEC91),(0x1000, 0xECA1),(0x1000, 0xECB1),(0x1000, 0xECC1),(0x1000, 0xECD1),(0x1000, 0xECE1),(0x1000, 0xECF1),(0x1000, 0xED01),(0x1000, 0xED11),(0x1000, 0xED21),(0x1000, 0xED31),(0x1000, 0xED41),(0x1000, 0xED51),(0x1000, 0xED61),(0x1000, 0xED71),(0x1000, 0xED81),(0x1000, 0xED91),(0x1000, 0xEDA1),(0x1000, 0xEDB1),(0x1000, 0xEDC1),(0x1000, 0xEDD1),(0x1000, 0xEDE1),(0x1000, 0xEDF1),(0x1000, 0xEE01),(0x1000, 0xEE11),(0x1000, 0xEE21),(0x1000, 0xEE31),(0x1000, 0xEE41),(0x1000, 0xEE51),(0x1000, 0xEE61),(0x1000, 0xEE71),(0x1000, 0xEE81),(0x1000, 0xEE91),(0x1000, 0xEEA1),(0x1000, 0xEEB1),(0x1000, 0xEEC1),(0x1000, 0xEED1),(0x1000, 0xEEE1),(0x1000, 0xEEF1),(0x1000, 0xEF01),(0x1000, 0xEF11),(0x1000, 0xEF21),(0x1000, 0xEF31),(0x1000, 0xEF41),(0x1000, 0xEF51),(0x1000, 0xEF61),(0x1000, 0xEF71),(0x1000, 0xEF81),(0x1000, 0xEF91),(0x1000, 0xEFA1),(0x1000, 0xEFB1),(0x1000, 0xEFC1),(0x1000, 0xEFD1),(0x1000, 0xEFE1),(0x1000, 0xEFF1),(0x1000, 0xF001),(0x1000, 0xF011),(0x1000, 0xF021),(0x1000, 0xF031),(0x1000, 0xF041),(0x1000, 0xF051),(0x1000, 0xF061),(0x1000, 0xF071),(0x1000, 0xF081),(0x1000, 0xF091),(0x1000, 0xF0A1),(0x1000, 0xF0B1),(0x1000, 0xF0C1),(0x1000, 0xF0D1),(0x1000, 0xF0E1),(0x1000, 0xF0F1),(0x1000, 0xF101),(0x1000, 0xF111),(0x1000, 0xF121),(0x1000, 0xF131),(0x1000, 0xF141),(0x1000, 0xF151),(0x1000, 0xF161),(0x1000, 0xF171),(0x1000, 0xF181),(0x1000, 0xF191),(0x1000, 0xF1A1),(0x1000, 0xF1B1),(0x1000, 0xF1C1),(0x1000, 0xF1D1),(0x1000, 0xF1E1),(0x1000, 0xF1F1),(0x1000, 0xF201),(0x1000, 0xF211),(0x1000, 0xF221),(0x1000, 0xF231),(0x1000, 0xF241),(0x1000, 0xF251),(0x1000, 0xF261),(0x1000, 0xF271),(0x1000, 0xF281),(0x1000, 0xF291),(0x1000, 0xF2A1),(0x1000, 0xF2B1),(0x1000, 0xF2C1),(0x1000, 0xF2D1),(0x1000, 0xF2E1),(0x1000, 0xF2F1),(0x1000, 0xF301),(0x1000, 0xF311),(0x1000, 0xF321),(0x1000, 0xF331),(0x1000, 0xF341),(0x1000, 0xF351),(0x1000, 0xF361),(0x1000, 0xF371),(0x1000, 0xF381),(0x1000, 0xF391),(0x1000, 0xF3A1),(0x1000, 0xF3B1),(0x1000, 0xF3C1),(0x1000, 0xF3D1),(0x1000, 0xF3E1),(0x1000, 0xF3F1),(0x1000, 0xF401),(0x1000, 0xF411),(0x1000, 0xF421),(0x1000, 0xF431),(0x1000, 0xF441),(0x1000, 0xF451),(0x1000, 0xF461),(0x1000, 0xF471),(0x1000, 0xF481),(0x1000, 0xF491),(0x1000, 0xF4A1),(0x1000, 0xF4B1),(0x1000, 0xF4C1),(0x1000, 0xF4D1),(0x1000, 0xF4E1),(0x1000, 0xF4F1),(0x1000, 0xF501),(0x1000, 0xF511),(0x1000, 0xF521),(0x1000, 0xF531),(0x1000, 0xF541),(0x1000, 0xF551),(0x1000, 0xF561),(0x1000, 0xF571),(0x1000, 0xF581),(0x1000, 0xF591),(0x1000, 0xF5A1),(0x1000, 0xF5B1),(0x1000, 0xF5C1),(0x1000, 0xF5D1),(0x1000, 0xF5E1),(0x1000, 0xF5F1),(0x1000, 0xF601),(0x1000, 0xF611),(0x1000, 0xF621),(0x1000, 0xF631),(0x1000, 0xF641),(0x1000, 0xF651),(0x1000, 0xF661),(0x1000, 0xF671),(0x1000, 0xF681),(0x1000, 0xF691),(0x1000, 0xF6A1),(0x1000, 0xF6B1),(0x1000, 0xF6C1),(0x1000, 0xF6D1),(0x1000, 0xF6E1),(0x1000, 0xF6F1),(0x1000, 0xF701),(0x1000, 0xF711),(0x1000, 0xF721),(0x1000, 0xF731),(0x1000, 0xF741),(0x1000, 0xF751),(0x1000, 0xF761),(0x1000, 0xF771),(0x1000, 0xF781),(0x1000, 0xF791),(0x1000, 0xF7A1),(0x1000, 0xF7B1),(0x1000, 0xF7C1),(0x1000, 0xF7D1),(0x1000, 0xF7E1),(0x1000, 0xF7F1),(0x1000, 0xF801),(0x1000, 0xF811),(0x1000, 0xF821),(0x1000, 0xF831),(0x1000, 0xF841),(0x1000, 0xF851),(0x1000, 0xF861),(0x1000, 0xF871),(0x1000, 0xF881),(0x1000, 0xF891),(0x1000, 0xF8A1),(0x1000, 0xF8B1),(0x1000, 0xF8C1),(0x1000, 0xF8D1),(0x1000, 0xF8E1),(0x1000, 0xF8F1),(0x1000, 0xF901),(0x1000, 0xF911),(0x1000, 0xF921),(0x1000, 0xF931),(0x1000, 0xF941),(0x1000, 0xF951),(0x1000, 0xF961),(0x1000, 0xF971),(0x1000, 0xF981),(0x1000, 0xF991),(0x1000, 0xF9A1),(0x1000, 0xF9B1),(0x1000, 0xF9C1),(0x1000, 0xF9D1),(0x1000, 0xF9E1),(0x1000, 0xF9F1),(0x1000, 0xFA01),(0x1000, 0xFA11),(0x1000, 0xFA21),(0x1000, 0xFA31),(0x1000, 0xFA41),(0x1000, 0xFA51),(0x1000, 0xFA61),(0x1000, 0xFA71),(0x1000, 0xFA81),(0x1000, 0xFA91),(0x1000, 0xFAA1),(0x1000, 0xFAB1),(0x1000, 0xFAC1),(0x1000, 0xFAD1),(0x1000, 0xFAE1),(0x1000, 0xFAF1),(0x1000, 0xFB01),(0x1000, 0xFB11),(0x1000, 0xFB21),(0x1000, 0xFB31),(0x1000, 0xFB41),(0x1000, 0xFB51),(0x1000, 0xFB61),(0x1000, 0xFB71),(0x1000, 0xFB81),(0x1000, 0xFB91),(0x1000, 0xFBA1),(0x1000, 0xFBB1),(0x1000, 0xFBC1),(0x1000, 0xFBD1),(0x1000, 0xFBE1),(0x1000, 0xFBF1),(0x1000, 0xFC01),(0x1000, 0xFC11),(0x1000, 0xFC21),(0x1000, 0xFC31),(0x1000, 0xFC41),(0x1000, 0xFC51),(0x1000, 0xFC61),(0x1000, 0xFC71),(0x1000, 0xFC81),(0x1000, 0xFC91),(0x1000, 0xFCA1),(0x1000, 0xFCB1),(0x1000, 0xFCC1),(0x1000, 0xFCD1),(0x1000, 0xFCE1),(0x1000, 0xFCF1),(0x1000, 0xFD01),(0x1000, 0xFD11),(0x1000, 0xFD21),(0x1000, 0xFD31),(0x1000, 0xFD41),(0x1000, 0xFD51),(0x1000, 0xFD61),(0x1000, 0xFD71),(0x1000, 0xFD81),(0x1000, 0xFD91),(0x1000, 0xFDA1),(0x1000, 0xFDB1),(0x1000, 0xFDC1),(0x1000, 0xFDD1),(0x1000, 0xFDE1),(0x1000, 0xFDF1),(0x1000, 0xFE01),(0x1000, 0xFE11),(0x1000, 0xFE21),(0x1000, 0xFE31),(0x1000, 0xFE41),(0x1000, 0xFE51),(0x1000, 0xFE61),(0x1000, 0xFE71),(0x1000, 0xFE81),(0x1000, 0xFE91),(0x1000, 0xFEA1),(0x1000, 0xFEB1),(0x1000, 0xFEC1),(0x1000, 0xFED1),(0x1000, 0xFEE1),(0x1000, 0xFEF1),(0x1000, 0xFF01),(0x1000, 0xFF11),(0x1000, 0xFF21),(0x1000, 0xFF31),(0x1000, 0xFF41),(0x1000, 0xFF51),(0x1000, 0xFF61),(0x1000, 0xFF71),(0x1000, 0xFF81),(0x1000, 0xFF91),(0x1000, 0xFFA1),(0x1000, 0xFFB1),(0x1000, 0xFFC1),(0x1000, 0xFFD1),(0x1000, 0xFFE1),(0x1000, 0xFFF1),])
    HuffmanTableSize = Tag('Huffman Table Size', "HuffmanTableSize", 0x1000, 0x0002, [], [(0x1000, 0x0012),(0x1000, 0x0022),(0x1000, 0x0032),(0x1000, 0x0042),(0x1000, 0x0052),(0x1000, 0x0062),(0x1000, 0x0072),(0x1000, 0x0082),(0x1000, 0x0092),(0x1000, 0x00A2),(0x1000, 0x00B2),(0x1000, 0x00C2),(0x1000, 0x00D2),(0x1000, 0x00E2),(0x1000, 0x00F2),(0x1000, 0x0102),(0x1000, 0x0112),(0x1000, 0x0122),(0x1000, 0x0132),(0x1000, 0x0142),(0x1000, 0x0152),(0x1000, 0x0162),(0x1000, 0x0172),(0x1000, 0x0182),(0x1000, 0x0192),(0x1000, 0x01A2),(0x1000, 0x01B2),(0x1000, 0x01C2),(0x1000, 0x01D2),(0x1000, 0x01E2),(0x1000, 0x01F2),(0x1000, 0x0202),(0x1000, 0x0212),(0x1000, 0x0222),(0x1000, 0x0232),(0x1000, 0x0242),(0x1000, 0x0252),(0x1000, 0x0262),(0x1000, 0x0272),(0x1000, 0x0282),(0x1000, 0x0292),(0x1000, 0x02A2),(0x1000, 0x02B2),(0x1000, 0x02C2),(0x1000, 0x02D2),(0x1000, 0x02E2),(0x1000, 0x02F2),(0x1000, 0x0302),(0x1000, 0x0312),(0x1000, 0x0322),(0x1000, 0x0332),(0x1000, 0x0342),(0x1000, 0x0352),(0x1000, 0x0362),(0x1000, 0x0372),(0x1000, 0x0382),(0x1000, 0x0392),(0x1000, 0x03A2),(0x1000, 0x03B2),(0x1000, 0x03C2),(0x1000, 0x03D2),(0x1000, 0x03E2),(0x1000, 0x03F2),(0x1000, 0x0402),(0x1000, 0x0412),(0x1000, 0x0422),(0x1000, 0x0432),(0x1000, 0x0442),(0x1000, 0x0452),(0x1000, 0x0462),(0x1000, 0x0472),(0x1000, 0x0482),(0x1000, 0x0492),(0x1000, 0x04A2),(0x1000, 0x04B2),(0x1000, 0x04C2),(0x1000, 0x04D2),(0x1000, 0x04E2),(0x1000, 0x04F2),(0x1000, 0x0502),(0x1000, 0x0512),(0x1000, 0x0522),(0x1000, 0x0532),(0x1000, 0x0542),(0x1000, 0x0552),(0x1000, 0x0562),(0x1000, 0x0572),(0x1000, 0x0582),(0x1000, 0x0592),(0x1000, 0x05A2),(0x1000, 0x05B2),(0x1000, 0x05C2),(0x1000, 0x05D2),(0x1000, 0x05E2),(0x1000, 0x05F2),(0x1000, 0x0602),(0x1000, 0x0612),(0x1000, 0x0622),(0x1000, 0x0632),(0x1000, 0x0642),(0x1000, 0x0652),(0x1000, 0x0662),(0x1000, 0x0672),(0x1000, 0x0682),(0x1000, 0x0692),(0x1000, 0x06A2),(0x1000, 0x06B2),(0x1000, 0x06C2),(0x1000, 0x06D2),(0x1000, 0x06E2),(0x1000, 0x06F2),(0x1000, 0x0702),(0x1000, 0x0712),(0x1000, 0x0722),(0x1000, 0x0732),(0x1000, 0x0742),(0x1000, 0x0752),(0x1000, 0x0762),(0x1000, 0x0772),(0x1000, 0x0782),(0x1000, 0x0792),(0x1000, 0x07A2),(0x1000, 0x07B2),(0x1000, 0x07C2),(0x1000, 0x07D2),(0x1000, 0x07E2),(0x1000, 0x07F2),(0x1000, 0x0802),(0x1000, 0x0812),(0x1000, 0x0822),(0x1000, 0x0832),(0x1000, 0x0842),(0x1000, 0x0852),(0x1000, 0x0862),(0x1000, 0x0872),(0x1000, 0x0882),(0x1000, 0x0892),(0x1000, 0x08A2),(0x1000, 0x08B2),(0x1000, 0x08C2),(0x1000, 0x08D2),(0x1000, 0x08E2),(0x1000, 0x08F2),(0x1000, 0x0902),(0x1000, 0x0912),(0x1000, 0x0922),(0x1000, 0x0932),(0x1000, 0x0942),(0x1000, 0x0952),(0x1000, 0x0962),(0x1000, 0x0972),(0x1000, 0x0982),(0x1000, 0x0992),(0x1000, 0x09A2),(0x1000, 0x09B2),(0x1000, 0x09C2),(0x1000, 0x09D2),(0x1000, 0x09E2),(0x1000, 0x09F2),(0x1000, 0x0A02),(0x1000, 0x0A12),(0x1000, 0x0A22),(0x1000, 0x0A32),(0x1000, 0x0A42),(0x1000, 0x0A52),(0x1000, 0x0A62),(0x1000, 0x0A72),(0x1000, 0x0A82),(0x1000, 0x0A92),(0x1000, 0x0AA2),(0x1000, 0x0AB2),(0x1000, 0x0AC2),(0x1000, 0x0AD2),(0x1000, 0x0AE2),(0x1000, 0x0AF2),(0x1000, 0x0B02),(0x1000, 0x0B12),(0x1000, 0x0B22),(0x1000, 0x0B32),(0x1000, 0x0B42),(0x1000, 0x0B52),(0x1000, 0x0B62),(0x1000, 0x0B72),(0x1000, 0x0B82),(0x1000, 0x0B92),(0x1000, 0x0BA2),(0x1000, 0x0BB2),(0x1000, 0x0BC2),(0x1000, 0x0BD2),(0x1000, 0x0BE2),(0x1000, 0x0BF2),(0x1000, 0x0C02),(0x1000, 0x0C12),(0x1000, 0x0C22),(0x1000, 0x0C32),(0x1000, 0x0C42),(0x1000, 0x0C52),(0x1000, 0x0C62),(0x1000, 0x0C72),(0x1000, 0x0C82),(0x1000, 0x0C92),(0x1000, 0x0CA2),(0x1000, 0x0CB2),(0x1000, 0x0CC2),(0x1000, 0x0CD2),(0x1000, 0x0CE2),(0x1000, 0x0CF2),(0x1000, 0x0D02),(0x1000, 0x0D12),(0x1000, 0x0D22),(0x1000, 0x0D32),(0x1000, 0x0D42),(0x1000, 0x0D52),(0x1000, 0x0D62),(0x1000, 0x0D72),(0x1000, 0x0D82),(0x1000, 0x0D92),(0x1000, 0x0DA2),(0x1000, 0x0DB2),(0x1000, 0x0DC2),(0x1000, 0x0DD2),(0x1000, 0x0DE2),(0x1000, 0x0DF2),(0x1000, 0x0E02),(0x1000, 0x0E12),(0x1000, 0x0E22),(0x1000, 0x0E32),(0x1000, 0x0E42),(0x1000, 0x0E52),(0x1000, 0x0E62),(0x1000, 0x0E72),(0x1000, 0x0E82),(0x1000, 0x0E92),(0x1000, 0x0EA2),(0x1000, 0x0EB2),(0x1000, 0x0EC2),(0x1000, 0x0ED2),(0x1000, 0x0EE2),(0x1000, 0x0EF2),(0x1000, 0x0F02),(0x1000, 0x0F12),(0x1000, 0x0F22),(0x1000, 0x0F32),(0x1000, 0x0F42),(0x1000, 0x0F52),(0x1000, 0x0F62),(0x1000, 0x0F72),(0x1000, 0x0F82),(0x1000, 0x0F92),(0x1000, 0x0FA2),(0x1000, 0x0FB2),(0x1000, 0x0FC2),(0x1000, 0x0FD2),(0x1000, 0x0FE2),(0x1000, 0x0FF2),(0x1000, 0x1002),(0x1000, 0x1012),(0x1000, 0x1022),(0x1000, 0x1032),(0x1000, 0x1042),(0x1000, 0x1052),(0x1000, 0x1062),(0x1000, 0x1072),(0x1000, 0x1082),(0x1000, 0x1092),(0x1000, 0x10A2),(0x1000, 0x10B2),(0x1000, 0x10C2),(0x1000, 0x10D2),(0x1000, 0x10E2),(0x1000, 0x10F2),(0x1000, 0x1102),(0x1000, 0x1112),(0x1000, 0x1122),(0x1000, 0x1132),(0x1000, 0x1142),(0x1000, 0x1152),(0x1000, 0x1162),(0x1000, 0x1172),(0x1000, 0x1182),(0x1000, 0x1192),(0x1000, 0x11A2),(0x1000, 0x11B2),(0x1000, 0x11C2),(0x1000, 0x11D2),(0x1000, 0x11E2),(0x1000, 0x11F2),(0x1000, 0x1202),(0x1000, 0x1212),(0x1000, 0x1222),(0x1000, 0x1232),(0x1000, 0x1242),(0x1000, 0x1252),(0x1000, 0x1262),(0x1000, 0x1272),(0x1000, 0x1282),(0x1000, 0x1292),(0x1000, 0x12A2),(0x1000, 0x12B2),(0x1000, 0x12C2),(0x1000, 0x12D2),(0x1000, 0x12E2),(0x1000, 0x12F2),(0x1000, 0x1302),(0x1000, 0x1312),(0x1000, 0x1322),(0x1000, 0x1332),(0x1000, 0x1342),(0x1000, 0x1352),(0x1000, 0x1362),(0x1000, 0x1372),(0x1000, 0x1382),(0x1000, 0x1392),(0x1000, 0x13A2),(0x1000, 0x13B2),(0x1000, 0x13C2),(0x1000, 0x13D2),(0x1000, 0x13E2),(0x1000, 0x13F2),(0x1000, 0x1402),(0x1000, 0x1412),(0x1000, 0x1422),(0x1000, 0x1432),(0x1000, 0x1442),(0x1000, 0x1452),(0x1000, 0x1462),(0x1000, 0x1472),(0x1000, 0x1482),(0x1000, 0x1492),(0x1000, 0x14A2),(0x1000, 0x14B2),(0x1000, 0x14C2),(0x1000, 0x14D2),(0x1000, 0x14E2),(0x1000, 0x14F2),(0x1000, 0x1502),(0x1000, 0x1512),(0x1000, 0x1522),(0x1000, 0x1532),(0x1000, 0x1542),(0x1000, 0x1552),(0x1000, 0x1562),(0x1000, 0x1572),(0x1000, 0x1582),(0x1000, 0x1592),(0x1000, 0x15A2),(0x1000, 0x15B2),(0x1000, 0x15C2),(0x1000, 0x15D2),(0x1000, 0x15E2),(0x1000, 0x15F2),(0x1000, 0x1602),(0x1000, 0x1612),(0x1000, 0x1622),(0x1000, 0x1632),(0x1000, 0x1642),(0x1000, 0x1652),(0x1000, 0x1662),(0x1000, 0x1672),(0x1000, 0x1682),(0x1000, 0x1692),(0x1000, 0x16A2),(0x1000, 0x16B2),(0x1000, 0x16C2),(0x1000, 0x16D2),(0x1000, 0x16E2),(0x1000, 0x16F2),(0x1000, 0x1702),(0x1000, 0x1712),(0x1000, 0x1722),(0x1000, 0x1732),(0x1000, 0x1742),(0x1000, 0x1752),(0x1000, 0x1762),(0x1000, 0x1772),(0x1000, 0x1782),(0x1000, 0x1792),(0x1000, 0x17A2),(0x1000, 0x17B2),(0x1000, 0x17C2),(0x1000, 0x17D2),(0x1000, 0x17E2),(0x1000, 0x17F2),(0x1000, 0x1802),(0x1000, 0x1812),(0x1000, 0x1822),(0x1000, 0x1832),(0x1000, 0x1842),(0x1000, 0x1852),(0x1000, 0x1862),(0x1000, 0x1872),(0x1000, 0x1882),(0x1000, 0x1892),(0x1000, 0x18A2),(0x1000, 0x18B2),(0x1000, 0x18C2),(0x1000, 0x18D2),(0x1000, 0x18E2),(0x1000, 0x18F2),(0x1000, 0x1902),(0x1000, 0x1912),(0x1000, 0x1922),(0x1000, 0x1932),(0x1000, 0x1942),(0x1000, 0x1952),(0x1000, 0x1962),(0x1000, 0x1972),(0x1000, 0x1982),(0x1000, 0x1992),(0x1000, 0x19A2),(0x1000, 0x19B2),(0x1000, 0x19C2),(0x1000, 0x19D2),(0x1000, 0x19E2),(0x1000, 0x19F2),(0x1000, 0x1A02),(0x1000, 0x1A12),(0x1000, 0x1A22),(0x1000, 0x1A32),(0x1000, 0x1A42),(0x1000, 0x1A52),(0x1000, 0x1A62),(0x1000, 0x1A72),(0x1000, 0x1A82),(0x1000, 0x1A92),(0x1000, 0x1AA2),(0x1000, 0x1AB2),(0x1000, 0x1AC2),(0x1000, 0x1AD2),(0x1000, 0x1AE2),(0x1000, 0x1AF2),(0x1000, 0x1B02),(0x1000, 0x1B12),(0x1000, 0x1B22),(0x1000, 0x1B32),(0x1000, 0x1B42),(0x1000, 0x1B52),(0x1000, 0x1B62),(0x1000, 0x1B72),(0x1000, 0x1B82),(0x1000, 0x1B92),(0x1000, 0x1BA2),(0x1000, 0x1BB2),(0x1000, 0x1BC2),(0x1000, 0x1BD2),(0x1000, 0x1BE2),(0x1000, 0x1BF2),(0x1000, 0x1C02),(0x1000, 0x1C12),(0x1000, 0x1C22),(0x1000, 0x1C32),(0x1000, 0x1C42),(0x1000, 0x1C52),(0x1000, 0x1C62),(0x1000, 0x1C72),(0x1000, 0x1C82),(0x1000, 0x1C92),(0x1000, 0x1CA2),(0x1000, 0x1CB2),(0x1000, 0x1CC2),(0x1000, 0x1CD2),(0x1000, 0x1CE2),(0x1000, 0x1CF2),(0x1000, 0x1D02),(0x1000, 0x1D12),(0x1000, 0x1D22),(0x1000, 0x1D32),(0x1000, 0x1D42),(0x1000, 0x1D52),(0x1000, 0x1D62),(0x1000, 0x1D72),(0x1000, 0x1D82),(0x1000, 0x1D92),(0x1000, 0x1DA2),(0x1000, 0x1DB2),(0x1000, 0x1DC2),(0x1000, 0x1DD2),(0x1000, 0x1DE2),(0x1000, 0x1DF2),(0x1000, 0x1E02),(0x1000, 0x1E12),(0x1000, 0x1E22),(0x1000, 0x1E32),(0x1000, 0x1E42),(0x1000, 0x1E52),(0x1000, 0x1E62),(0x1000, 0x1E72),(0x1000, 0x1E82),(0x1000, 0x1E92),(0x1000, 0x1EA2),(0x1000, 0x1EB2),(0x1000, 0x1EC2),(0x1000, 0x1ED2),(0x1000, 0x1EE2),(0x1000, 0x1EF2),(0x1000, 0x1F02),(0x1000, 0x1F12),(0x1000, 0x1F22),(0x1000, 0x1F32),(0x1000, 0x1F42),(0x1000, 0x1F52),(0x1000, 0x1F62),(0x1000, 0x1F72),(0x1000, 0x1F82),(0x1000, 0x1F92),(0x1000, 0x1FA2),(0x1000, 0x1FB2),(0x1000, 0x1FC2),(0x1000, 0x1FD2),(0x1000, 0x1FE2),(0x1000, 0x1FF2),(0x1000, 0x2002),(0x1000, 0x2012),(0x1000, 0x2022),(0x1000, 0x2032),(0x1000, 0x2042),(0x1000, 0x2052),(0x1000, 0x2062),(0x1000, 0x2072),(0x1000, 0x2082),(0x1000, 0x2092),(0x1000, 0x20A2),(0x1000, 0x20B2),(0x1000, 0x20C2),(0x1000, 0x20D2),(0x1000, 0x20E2),(0x1000, 0x20F2),(0x1000, 0x2102),(0x1000, 0x2112),(0x1000, 0x2122),(0x1000, 0x2132),(0x1000, 0x2142),(0x1000, 0x2152),(0x1000, 0x2162),(0x1000, 0x2172),(0x1000, 0x2182),(0x1000, 0x2192),(0x1000, 0x21A2),(0x1000, 0x21B2),(0x1000, 0x21C2),(0x1000, 0x21D2),(0x1000, 0x21E2),(0x1000, 0x21F2),(0x1000, 0x2202),(0x1000, 0x2212),(0x1000, 0x2222),(0x1000, 0x2232),(0x1000, 0x2242),(0x1000, 0x2252),(0x1000, 0x2262),(0x1000, 0x2272),(0x1000, 0x2282),(0x1000, 0x2292),(0x1000, 0x22A2),(0x1000, 0x22B2),(0x1000, 0x22C2),(0x1000, 0x22D2),(0x1000, 0x22E2),(0x1000, 0x22F2),(0x1000, 0x2302),(0x1000, 0x2312),(0x1000, 0x2322),(0x1000, 0x2332),(0x1000, 0x2342),(0x1000, 0x2352),(0x1000, 0x2362),(0x1000, 0x2372),(0x1000, 0x2382),(0x1000, 0x2392),(0x1000, 0x23A2),(0x1000, 0x23B2),(0x1000, 0x23C2),(0x1000, 0x23D2),(0x1000, 0x23E2),(0x1000, 0x23F2),(0x1000, 0x2402),(0x1000, 0x2412),(0x1000, 0x2422),(0x1000, 0x2432),(0x1000, 0x2442),(0x1000, 0x2452),(0x1000, 0x2462),(0x1000, 0x2472),(0x1000, 0x2482),(0x1000, 0x2492),(0x1000, 0x24A2),(0x1000, 0x24B2),(0x1000, 0x24C2),(0x1000, 0x24D2),(0x1000, 0x24E2),(0x1000, 0x24F2),(0x1000, 0x2502),(0x1000, 0x2512),(0x1000, 0x2522),(0x1000, 0x2532),(0x1000, 0x2542),(0x1000, 0x2552),(0x1000, 0x2562),(0x1000, 0x2572),(0x1000, 0x2582),(0x1000, 0x2592),(0x1000, 0x25A2),(0x1000, 0x25B2),(0x1000, 0x25C2),(0x1000, 0x25D2),(0x1000, 0x25E2),(0x1000, 0x25F2),(0x1000, 0x2602),(0x1000, 0x2612),(0x1000, 0x2622),(0x1000, 0x2632),(0x1000, 0x2642),(0x1000, 0x2652),(0x1000, 0x2662),(0x1000, 0x2672),(0x1000, 0x2682),(0x1000, 0x2692),(0x1000, 0x26A2),(0x1000, 0x26B2),(0x1000, 0x26C2),(0x1000, 0x26D2),(0x1000, 0x26E2),(0x1000, 0x26F2),(0x1000, 0x2702),(0x1000, 0x2712),(0x1000, 0x2722),(0x1000, 0x2732),(0x1000, 0x2742),(0x1000, 0x2752),(0x1000, 0x2762),(0x1000, 0x2772),(0x1000, 0x2782),(0x1000, 0x2792),(0x1000, 0x27A2),(0x1000, 0x27B2),(0x1000, 0x27C2),(0x1000, 0x27D2),(0x1000, 0x27E2),(0x1000, 0x27F2),(0x1000, 0x2802),(0x1000, 0x2812),(0x1000, 0x2822),(0x1000, 0x2832),(0x1000, 0x2842),(0x1000, 0x2852),(0x1000, 0x2862),(0x1000, 0x2872),(0x1000, 0x2882),(0x1000, 0x2892),(0x1000, 0x28A2),(0x1000, 0x28B2),(0x1000, 0x28C2),(0x1000, 0x28D2),(0x1000, 0x28E2),(0x1000, 0x28F2),(0x1000, 0x2902),(0x1000, 0x2912),(0x1000, 0x2922),(0x1000, 0x2932),(0x1000, 0x2942),(0x1000, 0x2952),(0x1000, 0x2962),(0x1000, 0x2972),(0x1000, 0x2982),(0x1000, 0x2992),(0x1000, 0x29A2),(0x1000, 0x29B2),(0x1000, 0x29C2),(0x1000, 0x29D2),(0x1000, 0x29E2),(0x1000, 0x29F2),(0x1000, 0x2A02),(0x1000, 0x2A12),(0x1000, 0x2A22),(0x1000, 0x2A32),(0x1000, 0x2A42),(0x1000, 0x2A52),(0x1000, 0x2A62),(0x1000, 0x2A72),(0x1000, 0x2A82),(0x1000, 0x2A92),(0x1000, 0x2AA2),(0x1000, 0x2AB2),(0x1000, 0x2AC2),(0x1000, 0x2AD2),(0x1000, 0x2AE2),(0x1000, 0x2AF2),(0x1000, 0x2B02),(0x1000, 0x2B12),(0x1000, 0x2B22),(0x1000, 0x2B32),(0x1000, 0x2B42),(0x1000, 0x2B52),(0x1000, 0x2B62),(0x1000, 0x2B72),(0x1000, 0x2B82),(0x1000, 0x2B92),(0x1000, 0x2BA2),(0x1000, 0x2BB2),(0x1000, 0x2BC2),(0x1000, 0x2BD2),(0x1000, 0x2BE2),(0x1000, 0x2BF2),(0x1000, 0x2C02),(0x1000, 0x2C12),(0x1000, 0x2C22),(0x1000, 0x2C32),(0x1000, 0x2C42),(0x1000, 0x2C52),(0x1000, 0x2C62),(0x1000, 0x2C72),(0x1000, 0x2C82),(0x1000, 0x2C92),(0x1000, 0x2CA2),(0x1000, 0x2CB2),(0x1000, 0x2CC2),(0x1000, 0x2CD2),(0x1000, 0x2CE2),(0x1000, 0x2CF2),(0x1000, 0x2D02),(0x1000, 0x2D12),(0x1000, 0x2D22),(0x1000, 0x2D32),(0x1000, 0x2D42),(0x1000, 0x2D52),(0x1000, 0x2D62),(0x1000, 0x2D72),(0x1000, 0x2D82),(0x1000, 0x2D92),(0x1000, 0x2DA2),(0x1000, 0x2DB2),(0x1000, 0x2DC2),(0x1000, 0x2DD2),(0x1000, 0x2DE2),(0x1000, 0x2DF2),(0x1000, 0x2E02),(0x1000, 0x2E12),(0x1000, 0x2E22),(0x1000, 0x2E32),(0x1000, 0x2E42),(0x1000, 0x2E52),(0x1000, 0x2E62),(0x1000, 0x2E72),(0x1000, 0x2E82),(0x1000, 0x2E92),(0x1000, 0x2EA2),(0x1000, 0x2EB2),(0x1000, 0x2EC2),(0x1000, 0x2ED2),(0x1000, 0x2EE2),(0x1000, 0x2EF2),(0x1000, 0x2F02),(0x1000, 0x2F12),(0x1000, 0x2F22),(0x1000, 0x2F32),(0x1000, 0x2F42),(0x1000, 0x2F52),(0x1000, 0x2F62),(0x1000, 0x2F72),(0x1000, 0x2F82),(0x1000, 0x2F92),(0x1000, 0x2FA2),(0x1000, 0x2FB2),(0x1000, 0x2FC2),(0x1000, 0x2FD2),(0x1000, 0x2FE2),(0x1000, 0x2FF2),(0x1000, 0x3002),(0x1000, 0x3012),(0x1000, 0x3022),(0x1000, 0x3032),(0x1000, 0x3042),(0x1000, 0x3052),(0x1000, 0x3062),(0x1000, 0x3072),(0x1000, 0x3082),(0x1000, 0x3092),(0x1000, 0x30A2),(0x1000, 0x30B2),(0x1000, 0x30C2),(0x1000, 0x30D2),(0x1000, 0x30E2),(0x1000, 0x30F2),(0x1000, 0x3102),(0x1000, 0x3112),(0x1000, 0x3122),(0x1000, 0x3132),(0x1000, 0x3142),(0x1000, 0x3152),(0x1000, 0x3162),(0x1000, 0x3172),(0x1000, 0x3182),(0x1000, 0x3192),(0x1000, 0x31A2),(0x1000, 0x31B2),(0x1000, 0x31C2),(0x1000, 0x31D2),(0x1000, 0x31E2),(0x1000, 0x31F2),(0x1000, 0x3202),(0x1000, 0x3212),(0x1000, 0x3222),(0x1000, 0x3232),(0x1000, 0x3242),(0x1000, 0x3252),(0x1000, 0x3262),(0x1000, 0x3272),(0x1000, 0x3282),(0x1000, 0x3292),(0x1000, 0x32A2),(0x1000, 0x32B2),(0x1000, 0x32C2),(0x1000, 0x32D2),(0x1000, 0x32E2),(0x1000, 0x32F2),(0x1000, 0x3302),(0x1000, 0x3312),(0x1000, 0x3322),(0x1000, 0x3332),(0x1000, 0x3342),(0x1000, 0x3352),(0x1000, 0x3362),(0x1000, 0x3372),(0x1000, 0x3382),(0x1000, 0x3392),(0x1000, 0x33A2),(0x1000, 0x33B2),(0x1000, 0x33C2),(0x1000, 0x33D2),(0x1000, 0x33E2),(0x1000, 0x33F2),(0x1000, 0x3402),(0x1000, 0x3412),(0x1000, 0x3422),(0x1000, 0x3432),(0x1000, 0x3442),(0x1000, 0x3452),(0x1000, 0x3462),(0x1000, 0x3472),(0x1000, 0x3482),(0x1000, 0x3492),(0x1000, 0x34A2),(0x1000, 0x34B2),(0x1000, 0x34C2),(0x1000, 0x34D2),(0x1000, 0x34E2),(0x1000, 0x34F2),(0x1000, 0x3502),(0x1000, 0x3512),(0x1000, 0x3522),(0x1000, 0x3532),(0x1000, 0x3542),(0x1000, 0x3552),(0x1000, 0x3562),(0x1000, 0x3572),(0x1000, 0x3582),(0x1000, 0x3592),(0x1000, 0x35A2),(0x1000, 0x35B2),(0x1000, 0x35C2),(0x1000, 0x35D2),(0x1000, 0x35E2),(0x1000, 0x35F2),(0x1000, 0x3602),(0x1000, 0x3612),(0x1000, 0x3622),(0x1000, 0x3632),(0x1000, 0x3642),(0x1000, 0x3652),(0x1000, 0x3662),(0x1000, 0x3672),(0x1000, 0x3682),(0x1000, 0x3692),(0x1000, 0x36A2),(0x1000, 0x36B2),(0x1000, 0x36C2),(0x1000, 0x36D2),(0x1000, 0x36E2),(0x1000, 0x36F2),(0x1000, 0x3702),(0x1000, 0x3712),(0x1000, 0x3722),(0x1000, 0x3732),(0x1000, 0x3742),(0x1000, 0x3752),(0x1000, 0x3762),(0x1000, 0x3772),(0x1000, 0x3782),(0x1000, 0x3792),(0x1000, 0x37A2),(0x1000, 0x37B2),(0x1000, 0x37C2),(0x1000, 0x37D2),(0x1000, 0x37E2),(0x1000, 0x37F2),(0x1000, 0x3802),(0x1000, 0x3812),(0x1000, 0x3822),(0x1000, 0x3832),(0x1000, 0x3842),(0x1000, 0x3852),(0x1000, 0x3862),(0x1000, 0x3872),(0x1000, 0x3882),(0x1000, 0x3892),(0x1000, 0x38A2),(0x1000, 0x38B2),(0x1000, 0x38C2),(0x1000, 0x38D2),(0x1000, 0x38E2),(0x1000, 0x38F2),(0x1000, 0x3902),(0x1000, 0x3912),(0x1000, 0x3922),(0x1000, 0x3932),(0x1000, 0x3942),(0x1000, 0x3952),(0x1000, 0x3962),(0x1000, 0x3972),(0x1000, 0x3982),(0x1000, 0x3992),(0x1000, 0x39A2),(0x1000, 0x39B2),(0x1000, 0x39C2),(0x1000, 0x39D2),(0x1000, 0x39E2),(0x1000, 0x39F2),(0x1000, 0x3A02),(0x1000, 0x3A12),(0x1000, 0x3A22),(0x1000, 0x3A32),(0x1000, 0x3A42),(0x1000, 0x3A52),(0x1000, 0x3A62),(0x1000, 0x3A72),(0x1000, 0x3A82),(0x1000, 0x3A92),(0x1000, 0x3AA2),(0x1000, 0x3AB2),(0x1000, 0x3AC2),(0x1000, 0x3AD2),(0x1000, 0x3AE2),(0x1000, 0x3AF2),(0x1000, 0x3B02),(0x1000, 0x3B12),(0x1000, 0x3B22),(0x1000, 0x3B32),(0x1000, 0x3B42),(0x1000, 0x3B52),(0x1000, 0x3B62),(0x1000, 0x3B72),(0x1000, 0x3B82),(0x1000, 0x3B92),(0x1000, 0x3BA2),(0x1000, 0x3BB2),(0x1000, 0x3BC2),(0x1000, 0x3BD2),(0x1000, 0x3BE2),(0x1000, 0x3BF2),(0x1000, 0x3C02),(0x1000, 0x3C12),(0x1000, 0x3C22),(0x1000, 0x3C32),(0x1000, 0x3C42),(0x1000, 0x3C52),(0x1000, 0x3C62),(0x1000, 0x3C72),(0x1000, 0x3C82),(0x1000, 0x3C92),(0x1000, 0x3CA2),(0x1000, 0x3CB2),(0x1000, 0x3CC2),(0x1000, 0x3CD2),(0x1000, 0x3CE2),(0x1000, 0x3CF2),(0x1000, 0x3D02),(0x1000, 0x3D12),(0x1000, 0x3D22),(0x1000, 0x3D32),(0x1000, 0x3D42),(0x1000, 0x3D52),(0x1000, 0x3D62),(0x1000, 0x3D72),(0x1000, 0x3D82),(0x1000, 0x3D92),(0x1000, 0x3DA2),(0x1000, 0x3DB2),(0x1000, 0x3DC2),(0x1000, 0x3DD2),(0x1000, 0x3DE2),(0x1000, 0x3DF2),(0x1000, 0x3E02),(0x1000, 0x3E12),(0x1000, 0x3E22),(0x1000, 0x3E32),(0x1000, 0x3E42),(0x1000, 0x3E52),(0x1000, 0x3E62),(0x1000, 0x3E72),(0x1000, 0x3E82),(0x1000, 0x3E92),(0x1000, 0x3EA2),(0x1000, 0x3EB2),(0x1000, 0x3EC2),(0x1000, 0x3ED2),(0x1000, 0x3EE2),(0x1000, 0x3EF2),(0x1000, 0x3F02),(0x1000, 0x3F12),(0x1000, 0x3F22),(0x1000, 0x3F32),(0x1000, 0x3F42),(0x1000, 0x3F52),(0x1000, 0x3F62),(0x1000, 0x3F72),(0x1000, 0x3F82),(0x1000, 0x3F92),(0x1000, 0x3FA2),(0x1000, 0x3FB2),(0x1000, 0x3FC2),(0x1000, 0x3FD2),(0x1000, 0x3FE2),(0x1000, 0x3FF2),(0x1000, 0x4002),(0x1000, 0x4012),(0x1000, 0x4022),(0x1000, 0x4032),(0x1000, 0x4042),(0x1000, 0x4052),(0x1000, 0x4062),(0x1000, 0x4072),(0x1000, 0x4082),(0x1000, 0x4092),(0x1000, 0x40A2),(0x1000, 0x40B2),(0x1000, 0x40C2),(0x1000, 0x40D2),(0x1000, 0x40E2),(0x1000, 0x40F2),(0x1000, 0x4102),(0x1000, 0x4112),(0x1000, 0x4122),(0x1000, 0x4132),(0x1000, 0x4142),(0x1000, 0x4152),(0x1000, 0x4162),(0x1000, 0x4172),(0x1000, 0x4182),(0x1000, 0x4192),(0x1000, 0x41A2),(0x1000, 0x41B2),(0x1000, 0x41C2),(0x1000, 0x41D2),(0x1000, 0x41E2),(0x1000, 0x41F2),(0x1000, 0x4202),(0x1000, 0x4212),(0x1000, 0x4222),(0x1000, 0x4232),(0x1000, 0x4242),(0x1000, 0x4252),(0x1000, 0x4262),(0x1000, 0x4272),(0x1000, 0x4282),(0x1000, 0x4292),(0x1000, 0x42A2),(0x1000, 0x42B2),(0x1000, 0x42C2),(0x1000, 0x42D2),(0x1000, 0x42E2),(0x1000, 0x42F2),(0x1000, 0x4302),(0x1000, 0x4312),(0x1000, 0x4322),(0x1000, 0x4332),(0x1000, 0x4342),(0x1000, 0x4352),(0x1000, 0x4362),(0x1000, 0x4372),(0x1000, 0x4382),(0x1000, 0x4392),(0x1000, 0x43A2),(0x1000, 0x43B2),(0x1000, 0x43C2),(0x1000, 0x43D2),(0x1000, 0x43E2),(0x1000, 0x43F2),(0x1000, 0x4402),(0x1000, 0x4412),(0x1000, 0x4422),(0x1000, 0x4432),(0x1000, 0x4442),(0x1000, 0x4452),(0x1000, 0x4462),(0x1000, 0x4472),(0x1000, 0x4482),(0x1000, 0x4492),(0x1000, 0x44A2),(0x1000, 0x44B2),(0x1000, 0x44C2),(0x1000, 0x44D2),(0x1000, 0x44E2),(0x1000, 0x44F2),(0x1000, 0x4502),(0x1000, 0x4512),(0x1000, 0x4522),(0x1000, 0x4532),(0x1000, 0x4542),(0x1000, 0x4552),(0x1000, 0x4562),(0x1000, 0x4572),(0x1000, 0x4582),(0x1000, 0x4592),(0x1000, 0x45A2),(0x1000, 0x45B2),(0x1000, 0x45C2),(0x1000, 0x45D2),(0x1000, 0x45E2),(0x1000, 0x45F2),(0x1000, 0x4602),(0x1000, 0x4612),(0x1000, 0x4622),(0x1000, 0x4632),(0x1000, 0x4642),(0x1000, 0x4652),(0x1000, 0x4662),(0x1000, 0x4672),(0x1000, 0x4682),(0x1000, 0x4692),(0x1000, 0x46A2),(0x1000, 0x46B2),(0x1000, 0x46C2),(0x1000, 0x46D2),(0x1000, 0x46E2),(0x1000, 0x46F2),(0x1000, 0x4702),(0x1000, 0x4712),(0x1000, 0x4722),(0x1000, 0x4732),(0x1000, 0x4742),(0x1000, 0x4752),(0x1000, 0x4762),(0x1000, 0x4772),(0x1000, 0x4782),(0x1000, 0x4792),(0x1000, 0x47A2),(0x1000, 0x47B2),(0x1000, 0x47C2),(0x1000, 0x47D2),(0x1000, 0x47E2),(0x1000, 0x47F2),(0x1000, 0x4802),(0x1000, 0x4812),(0x1000, 0x4822),(0x1000, 0x4832),(0x1000, 0x4842),(0x1000, 0x4852),(0x1000, 0x4862),(0x1000, 0x4872),(0x1000, 0x4882),(0x1000, 0x4892),(0x1000, 0x48A2),(0x1000, 0x48B2),(0x1000, 0x48C2),(0x1000, 0x48D2),(0x1000, 0x48E2),(0x1000, 0x48F2),(0x1000, 0x4902),(0x1000, 0x4912),(0x1000, 0x4922),(0x1000, 0x4932),(0x1000, 0x4942),(0x1000, 0x4952),(0x1000, 0x4962),(0x1000, 0x4972),(0x1000, 0x4982),(0x1000, 0x4992),(0x1000, 0x49A2),(0x1000, 0x49B2),(0x1000, 0x49C2),(0x1000, 0x49D2),(0x1000, 0x49E2),(0x1000, 0x49F2),(0x1000, 0x4A02),(0x1000, 0x4A12),(0x1000, 0x4A22),(0x1000, 0x4A32),(0x1000, 0x4A42),(0x1000, 0x4A52),(0x1000, 0x4A62),(0x1000, 0x4A72),(0x1000, 0x4A82),(0x1000, 0x4A92),(0x1000, 0x4AA2),(0x1000, 0x4AB2),(0x1000, 0x4AC2),(0x1000, 0x4AD2),(0x1000, 0x4AE2),(0x1000, 0x4AF2),(0x1000, 0x4B02),(0x1000, 0x4B12),(0x1000, 0x4B22),(0x1000, 0x4B32),(0x1000, 0x4B42),(0x1000, 0x4B52),(0x1000, 0x4B62),(0x1000, 0x4B72),(0x1000, 0x4B82),(0x1000, 0x4B92),(0x1000, 0x4BA2),(0x1000, 0x4BB2),(0x1000, 0x4BC2),(0x1000, 0x4BD2),(0x1000, 0x4BE2),(0x1000, 0x4BF2),(0x1000, 0x4C02),(0x1000, 0x4C12),(0x1000, 0x4C22),(0x1000, 0x4C32),(0x1000, 0x4C42),(0x1000, 0x4C52),(0x1000, 0x4C62),(0x1000, 0x4C72),(0x1000, 0x4C82),(0x1000, 0x4C92),(0x1000, 0x4CA2),(0x1000, 0x4CB2),(0x1000, 0x4CC2),(0x1000, 0x4CD2),(0x1000, 0x4CE2),(0x1000, 0x4CF2),(0x1000, 0x4D02),(0x1000, 0x4D12),(0x1000, 0x4D22),(0x1000, 0x4D32),(0x1000, 0x4D42),(0x1000, 0x4D52),(0x1000, 0x4D62),(0x1000, 0x4D72),(0x1000, 0x4D82),(0x1000, 0x4D92),(0x1000, 0x4DA2),(0x1000, 0x4DB2),(0x1000, 0x4DC2),(0x1000, 0x4DD2),(0x1000, 0x4DE2),(0x1000, 0x4DF2),(0x1000, 0x4E02),(0x1000, 0x4E12),(0x1000, 0x4E22),(0x1000, 0x4E32),(0x1000, 0x4E42),(0x1000, 0x4E52),(0x1000, 0x4E62),(0x1000, 0x4E72),(0x1000, 0x4E82),(0x1000, 0x4E92),(0x1000, 0x4EA2),(0x1000, 0x4EB2),(0x1000, 0x4EC2),(0x1000, 0x4ED2),(0x1000, 0x4EE2),(0x1000, 0x4EF2),(0x1000, 0x4F02),(0x1000, 0x4F12),(0x1000, 0x4F22),(0x1000, 0x4F32),(0x1000, 0x4F42),(0x1000, 0x4F52),(0x1000, 0x4F62),(0x1000, 0x4F72),(0x1000, 0x4F82),(0x1000, 0x4F92),(0x1000, 0x4FA2),(0x1000, 0x4FB2),(0x1000, 0x4FC2),(0x1000, 0x4FD2),(0x1000, 0x4FE2),(0x1000, 0x4FF2),(0x1000, 0x5002),(0x1000, 0x5012),(0x1000, 0x5022),(0x1000, 0x5032),(0x1000, 0x5042),(0x1000, 0x5052),(0x1000, 0x5062),(0x1000, 0x5072),(0x1000, 0x5082),(0x1000, 0x5092),(0x1000, 0x50A2),(0x1000, 0x50B2),(0x1000, 0x50C2),(0x1000, 0x50D2),(0x1000, 0x50E2),(0x1000, 0x50F2),(0x1000, 0x5102),(0x1000, 0x5112),(0x1000, 0x5122),(0x1000, 0x5132),(0x1000, 0x5142),(0x1000, 0x5152),(0x1000, 0x5162),(0x1000, 0x5172),(0x1000, 0x5182),(0x1000, 0x5192),(0x1000, 0x51A2),(0x1000, 0x51B2),(0x1000, 0x51C2),(0x1000, 0x51D2),(0x1000, 0x51E2),(0x1000, 0x51F2),(0x1000, 0x5202),(0x1000, 0x5212),(0x1000, 0x5222),(0x1000, 0x5232),(0x1000, 0x5242),(0x1000, 0x5252),(0x1000, 0x5262),(0x1000, 0x5272),(0x1000, 0x5282),(0x1000, 0x5292),(0x1000, 0x52A2),(0x1000, 0x52B2),(0x1000, 0x52C2),(0x1000, 0x52D2),(0x1000, 0x52E2),(0x1000, 0x52F2),(0x1000, 0x5302),(0x1000, 0x5312),(0x1000, 0x5322),(0x1000, 0x5332),(0x1000, 0x5342),(0x1000, 0x5352),(0x1000, 0x5362),(0x1000, 0x5372),(0x1000, 0x5382),(0x1000, 0x5392),(0x1000, 0x53A2),(0x1000, 0x53B2),(0x1000, 0x53C2),(0x1000, 0x53D2),(0x1000, 0x53E2),(0x1000, 0x53F2),(0x1000, 0x5402),(0x1000, 0x5412),(0x1000, 0x5422),(0x1000, 0x5432),(0x1000, 0x5442),(0x1000, 0x5452),(0x1000, 0x5462),(0x1000, 0x5472),(0x1000, 0x5482),(0x1000, 0x5492),(0x1000, 0x54A2),(0x1000, 0x54B2),(0x1000, 0x54C2),(0x1000, 0x54D2),(0x1000, 0x54E2),(0x1000, 0x54F2),(0x1000, 0x5502),(0x1000, 0x5512),(0x1000, 0x5522),(0x1000, 0x5532),(0x1000, 0x5542),(0x1000, 0x5552),(0x1000, 0x5562),(0x1000, 0x5572),(0x1000, 0x5582),(0x1000, 0x5592),(0x1000, 0x55A2),(0x1000, 0x55B2),(0x1000, 0x55C2),(0x1000, 0x55D2),(0x1000, 0x55E2),(0x1000, 0x55F2),(0x1000, 0x5602),(0x1000, 0x5612),(0x1000, 0x5622),(0x1000, 0x5632),(0x1000, 0x5642),(0x1000, 0x5652),(0x1000, 0x5662),(0x1000, 0x5672),(0x1000, 0x5682),(0x1000, 0x5692),(0x1000, 0x56A2),(0x1000, 0x56B2),(0x1000, 0x56C2),(0x1000, 0x56D2),(0x1000, 0x56E2),(0x1000, 0x56F2),(0x1000, 0x5702),(0x1000, 0x5712),(0x1000, 0x5722),(0x1000, 0x5732),(0x1000, 0x5742),(0x1000, 0x5752),(0x1000, 0x5762),(0x1000, 0x5772),(0x1000, 0x5782),(0x1000, 0x5792),(0x1000, 0x57A2),(0x1000, 0x57B2),(0x1000, 0x57C2),(0x1000, 0x57D2),(0x1000, 0x57E2),(0x1000, 0x57F2),(0x1000, 0x5802),(0x1000, 0x5812),(0x1000, 0x5822),(0x1000, 0x5832),(0x1000, 0x5842),(0x1000, 0x5852),(0x1000, 0x5862),(0x1000, 0x5872),(0x1000, 0x5882),(0x1000, 0x5892),(0x1000, 0x58A2),(0x1000, 0x58B2),(0x1000, 0x58C2),(0x1000, 0x58D2),(0x1000, 0x58E2),(0x1000, 0x58F2),(0x1000, 0x5902),(0x1000, 0x5912),(0x1000, 0x5922),(0x1000, 0x5932),(0x1000, 0x5942),(0x1000, 0x5952),(0x1000, 0x5962),(0x1000, 0x5972),(0x1000, 0x5982),(0x1000, 0x5992),(0x1000, 0x59A2),(0x1000, 0x59B2),(0x1000, 0x59C2),(0x1000, 0x59D2),(0x1000, 0x59E2),(0x1000, 0x59F2),(0x1000, 0x5A02),(0x1000, 0x5A12),(0x1000, 0x5A22),(0x1000, 0x5A32),(0x1000, 0x5A42),(0x1000, 0x5A52),(0x1000, 0x5A62),(0x1000, 0x5A72),(0x1000, 0x5A82),(0x1000, 0x5A92),(0x1000, 0x5AA2),(0x1000, 0x5AB2),(0x1000, 0x5AC2),(0x1000, 0x5AD2),(0x1000, 0x5AE2),(0x1000, 0x5AF2),(0x1000, 0x5B02),(0x1000, 0x5B12),(0x1000, 0x5B22),(0x1000, 0x5B32),(0x1000, 0x5B42),(0x1000, 0x5B52),(0x1000, 0x5B62),(0x1000, 0x5B72),(0x1000, 0x5B82),(0x1000, 0x5B92),(0x1000, 0x5BA2),(0x1000, 0x5BB2),(0x1000, 0x5BC2),(0x1000, 0x5BD2),(0x1000, 0x5BE2),(0x1000, 0x5BF2),(0x1000, 0x5C02),(0x1000, 0x5C12),(0x1000, 0x5C22),(0x1000, 0x5C32),(0x1000, 0x5C42),(0x1000, 0x5C52),(0x1000, 0x5C62),(0x1000, 0x5C72),(0x1000, 0x5C82),(0x1000, 0x5C92),(0x1000, 0x5CA2),(0x1000, 0x5CB2),(0x1000, 0x5CC2),(0x1000, 0x5CD2),(0x1000, 0x5CE2),(0x1000, 0x5CF2),(0x1000, 0x5D02),(0x1000, 0x5D12),(0x1000, 0x5D22),(0x1000, 0x5D32),(0x1000, 0x5D42),(0x1000, 0x5D52),(0x1000, 0x5D62),(0x1000, 0x5D72),(0x1000, 0x5D82),(0x1000, 0x5D92),(0x1000, 0x5DA2),(0x1000, 0x5DB2),(0x1000, 0x5DC2),(0x1000, 0x5DD2),(0x1000, 0x5DE2),(0x1000, 0x5DF2),(0x1000, 0x5E02),(0x1000, 0x5E12),(0x1000, 0x5E22),(0x1000, 0x5E32),(0x1000, 0x5E42),(0x1000, 0x5E52),(0x1000, 0x5E62),(0x1000, 0x5E72),(0x1000, 0x5E82),(0x1000, 0x5E92),(0x1000, 0x5EA2),(0x1000, 0x5EB2),(0x1000, 0x5EC2),(0x1000, 0x5ED2),(0x1000, 0x5EE2),(0x1000, 0x5EF2),(0x1000, 0x5F02),(0x1000, 0x5F12),(0x1000, 0x5F22),(0x1000, 0x5F32),(0x1000, 0x5F42),(0x1000, 0x5F52),(0x1000, 0x5F62),(0x1000, 0x5F72),(0x1000, 0x5F82),(0x1000, 0x5F92),(0x1000, 0x5FA2),(0x1000, 0x5FB2),(0x1000, 0x5FC2),(0x1000, 0x5FD2),(0x1000, 0x5FE2),(0x1000, 0x5FF2),(0x1000, 0x6002),(0x1000, 0x6012),(0x1000, 0x6022),(0x1000, 0x6032),(0x1000, 0x6042),(0x1000, 0x6052),(0x1000, 0x6062),(0x1000, 0x6072),(0x1000, 0x6082),(0x1000, 0x6092),(0x1000, 0x60A2),(0x1000, 0x60B2),(0x1000, 0x60C2),(0x1000, 0x60D2),(0x1000, 0x60E2),(0x1000, 0x60F2),(0x1000, 0x6102),(0x1000, 0x6112),(0x1000, 0x6122),(0x1000, 0x6132),(0x1000, 0x6142),(0x1000, 0x6152),(0x1000, 0x6162),(0x1000, 0x6172),(0x1000, 0x6182),(0x1000, 0x6192),(0x1000, 0x61A2),(0x1000, 0x61B2),(0x1000, 0x61C2),(0x1000, 0x61D2),(0x1000, 0x61E2),(0x1000, 0x61F2),(0x1000, 0x6202),(0x1000, 0x6212),(0x1000, 0x6222),(0x1000, 0x6232),(0x1000, 0x6242),(0x1000, 0x6252),(0x1000, 0x6262),(0x1000, 0x6272),(0x1000, 0x6282),(0x1000, 0x6292),(0x1000, 0x62A2),(0x1000, 0x62B2),(0x1000, 0x62C2),(0x1000, 0x62D2),(0x1000, 0x62E2),(0x1000, 0x62F2),(0x1000, 0x6302),(0x1000, 0x6312),(0x1000, 0x6322),(0x1000, 0x6332),(0x1000, 0x6342),(0x1000, 0x6352),(0x1000, 0x6362),(0x1000, 0x6372),(0x1000, 0x6382),(0x1000, 0x6392),(0x1000, 0x63A2),(0x1000, 0x63B2),(0x1000, 0x63C2),(0x1000, 0x63D2),(0x1000, 0x63E2),(0x1000, 0x63F2),(0x1000, 0x6402),(0x1000, 0x6412),(0x1000, 0x6422),(0x1000, 0x6432),(0x1000, 0x6442),(0x1000, 0x6452),(0x1000, 0x6462),(0x1000, 0x6472),(0x1000, 0x6482),(0x1000, 0x6492),(0x1000, 0x64A2),(0x1000, 0x64B2),(0x1000, 0x64C2),(0x1000, 0x64D2),(0x1000, 0x64E2),(0x1000, 0x64F2),(0x1000, 0x6502),(0x1000, 0x6512),(0x1000, 0x6522),(0x1000, 0x6532),(0x1000, 0x6542),(0x1000, 0x6552),(0x1000, 0x6562),(0x1000, 0x6572),(0x1000, 0x6582),(0x1000, 0x6592),(0x1000, 0x65A2),(0x1000, 0x65B2),(0x1000, 0x65C2),(0x1000, 0x65D2),(0x1000, 0x65E2),(0x1000, 0x65F2),(0x1000, 0x6602),(0x1000, 0x6612),(0x1000, 0x6622),(0x1000, 0x6632),(0x1000, 0x6642),(0x1000, 0x6652),(0x1000, 0x6662),(0x1000, 0x6672),(0x1000, 0x6682),(0x1000, 0x6692),(0x1000, 0x66A2),(0x1000, 0x66B2),(0x1000, 0x66C2),(0x1000, 0x66D2),(0x1000, 0x66E2),(0x1000, 0x66F2),(0x1000, 0x6702),(0x1000, 0x6712),(0x1000, 0x6722),(0x1000, 0x6732),(0x1000, 0x6742),(0x1000, 0x6752),(0x1000, 0x6762),(0x1000, 0x6772),(0x1000, 0x6782),(0x1000, 0x6792),(0x1000, 0x67A2),(0x1000, 0x67B2),(0x1000, 0x67C2),(0x1000, 0x67D2),(0x1000, 0x67E2),(0x1000, 0x67F2),(0x1000, 0x6802),(0x1000, 0x6812),(0x1000, 0x6822),(0x1000, 0x6832),(0x1000, 0x6842),(0x1000, 0x6852),(0x1000, 0x6862),(0x1000, 0x6872),(0x1000, 0x6882),(0x1000, 0x6892),(0x1000, 0x68A2),(0x1000, 0x68B2),(0x1000, 0x68C2),(0x1000, 0x68D2),(0x1000, 0x68E2),(0x1000, 0x68F2),(0x1000, 0x6902),(0x1000, 0x6912),(0x1000, 0x6922),(0x1000, 0x6932),(0x1000, 0x6942),(0x1000, 0x6952),(0x1000, 0x6962),(0x1000, 0x6972),(0x1000, 0x6982),(0x1000, 0x6992),(0x1000, 0x69A2),(0x1000, 0x69B2),(0x1000, 0x69C2),(0x1000, 0x69D2),(0x1000, 0x69E2),(0x1000, 0x69F2),(0x1000, 0x6A02),(0x1000, 0x6A12),(0x1000, 0x6A22),(0x1000, 0x6A32),(0x1000, 0x6A42),(0x1000, 0x6A52),(0x1000, 0x6A62),(0x1000, 0x6A72),(0x1000, 0x6A82),(0x1000, 0x6A92),(0x1000, 0x6AA2),(0x1000, 0x6AB2),(0x1000, 0x6AC2),(0x1000, 0x6AD2),(0x1000, 0x6AE2),(0x1000, 0x6AF2),(0x1000, 0x6B02),(0x1000, 0x6B12),(0x1000, 0x6B22),(0x1000, 0x6B32),(0x1000, 0x6B42),(0x1000, 0x6B52),(0x1000, 0x6B62),(0x1000, 0x6B72),(0x1000, 0x6B82),(0x1000, 0x6B92),(0x1000, 0x6BA2),(0x1000, 0x6BB2),(0x1000, 0x6BC2),(0x1000, 0x6BD2),(0x1000, 0x6BE2),(0x1000, 0x6BF2),(0x1000, 0x6C02),(0x1000, 0x6C12),(0x1000, 0x6C22),(0x1000, 0x6C32),(0x1000, 0x6C42),(0x1000, 0x6C52),(0x1000, 0x6C62),(0x1000, 0x6C72),(0x1000, 0x6C82),(0x1000, 0x6C92),(0x1000, 0x6CA2),(0x1000, 0x6CB2),(0x1000, 0x6CC2),(0x1000, 0x6CD2),(0x1000, 0x6CE2),(0x1000, 0x6CF2),(0x1000, 0x6D02),(0x1000, 0x6D12),(0x1000, 0x6D22),(0x1000, 0x6D32),(0x1000, 0x6D42),(0x1000, 0x6D52),(0x1000, 0x6D62),(0x1000, 0x6D72),(0x1000, 0x6D82),(0x1000, 0x6D92),(0x1000, 0x6DA2),(0x1000, 0x6DB2),(0x1000, 0x6DC2),(0x1000, 0x6DD2),(0x1000, 0x6DE2),(0x1000, 0x6DF2),(0x1000, 0x6E02),(0x1000, 0x6E12),(0x1000, 0x6E22),(0x1000, 0x6E32),(0x1000, 0x6E42),(0x1000, 0x6E52),(0x1000, 0x6E62),(0x1000, 0x6E72),(0x1000, 0x6E82),(0x1000, 0x6E92),(0x1000, 0x6EA2),(0x1000, 0x6EB2),(0x1000, 0x6EC2),(0x1000, 0x6ED2),(0x1000, 0x6EE2),(0x1000, 0x6EF2),(0x1000, 0x6F02),(0x1000, 0x6F12),(0x1000, 0x6F22),(0x1000, 0x6F32),(0x1000, 0x6F42),(0x1000, 0x6F52),(0x1000, 0x6F62),(0x1000, 0x6F72),(0x1000, 0x6F82),(0x1000, 0x6F92),(0x1000, 0x6FA2),(0x1000, 0x6FB2),(0x1000, 0x6FC2),(0x1000, 0x6FD2),(0x1000, 0x6FE2),(0x1000, 0x6FF2),(0x1000, 0x7002),(0x1000, 0x7012),(0x1000, 0x7022),(0x1000, 0x7032),(0x1000, 0x7042),(0x1000, 0x7052),(0x1000, 0x7062),(0x1000, 0x7072),(0x1000, 0x7082),(0x1000, 0x7092),(0x1000, 0x70A2),(0x1000, 0x70B2),(0x1000, 0x70C2),(0x1000, 0x70D2),(0x1000, 0x70E2),(0x1000, 0x70F2),(0x1000, 0x7102),(0x1000, 0x7112),(0x1000, 0x7122),(0x1000, 0x7132),(0x1000, 0x7142),(0x1000, 0x7152),(0x1000, 0x7162),(0x1000, 0x7172),(0x1000, 0x7182),(0x1000, 0x7192),(0x1000, 0x71A2),(0x1000, 0x71B2),(0x1000, 0x71C2),(0x1000, 0x71D2),(0x1000, 0x71E2),(0x1000, 0x71F2),(0x1000, 0x7202),(0x1000, 0x7212),(0x1000, 0x7222),(0x1000, 0x7232),(0x1000, 0x7242),(0x1000, 0x7252),(0x1000, 0x7262),(0x1000, 0x7272),(0x1000, 0x7282),(0x1000, 0x7292),(0x1000, 0x72A2),(0x1000, 0x72B2),(0x1000, 0x72C2),(0x1000, 0x72D2),(0x1000, 0x72E2),(0x1000, 0x72F2),(0x1000, 0x7302),(0x1000, 0x7312),(0x1000, 0x7322),(0x1000, 0x7332),(0x1000, 0x7342),(0x1000, 0x7352),(0x1000, 0x7362),(0x1000, 0x7372),(0x1000, 0x7382),(0x1000, 0x7392),(0x1000, 0x73A2),(0x1000, 0x73B2),(0x1000, 0x73C2),(0x1000, 0x73D2),(0x1000, 0x73E2),(0x1000, 0x73F2),(0x1000, 0x7402),(0x1000, 0x7412),(0x1000, 0x7422),(0x1000, 0x7432),(0x1000, 0x7442),(0x1000, 0x7452),(0x1000, 0x7462),(0x1000, 0x7472),(0x1000, 0x7482),(0x1000, 0x7492),(0x1000, 0x74A2),(0x1000, 0x74B2),(0x1000, 0x74C2),(0x1000, 0x74D2),(0x1000, 0x74E2),(0x1000, 0x74F2),(0x1000, 0x7502),(0x1000, 0x7512),(0x1000, 0x7522),(0x1000, 0x7532),(0x1000, 0x7542),(0x1000, 0x7552),(0x1000, 0x7562),(0x1000, 0x7572),(0x1000, 0x7582),(0x1000, 0x7592),(0x1000, 0x75A2),(0x1000, 0x75B2),(0x1000, 0x75C2),(0x1000, 0x75D2),(0x1000, 0x75E2),(0x1000, 0x75F2),(0x1000, 0x7602),(0x1000, 0x7612),(0x1000, 0x7622),(0x1000, 0x7632),(0x1000, 0x7642),(0x1000, 0x7652),(0x1000, 0x7662),(0x1000, 0x7672),(0x1000, 0x7682),(0x1000, 0x7692),(0x1000, 0x76A2),(0x1000, 0x76B2),(0x1000, 0x76C2),(0x1000, 0x76D2),(0x1000, 0x76E2),(0x1000, 0x76F2),(0x1000, 0x7702),(0x1000, 0x7712),(0x1000, 0x7722),(0x1000, 0x7732),(0x1000, 0x7742),(0x1000, 0x7752),(0x1000, 0x7762),(0x1000, 0x7772),(0x1000, 0x7782),(0x1000, 0x7792),(0x1000, 0x77A2),(0x1000, 0x77B2),(0x1000, 0x77C2),(0x1000, 0x77D2),(0x1000, 0x77E2),(0x1000, 0x77F2),(0x1000, 0x7802),(0x1000, 0x7812),(0x1000, 0x7822),(0x1000, 0x7832),(0x1000, 0x7842),(0x1000, 0x7852),(0x1000, 0x7862),(0x1000, 0x7872),(0x1000, 0x7882),(0x1000, 0x7892),(0x1000, 0x78A2),(0x1000, 0x78B2),(0x1000, 0x78C2),(0x1000, 0x78D2),(0x1000, 0x78E2),(0x1000, 0x78F2),(0x1000, 0x7902),(0x1000, 0x7912),(0x1000, 0x7922),(0x1000, 0x7932),(0x1000, 0x7942),(0x1000, 0x7952),(0x1000, 0x7962),(0x1000, 0x7972),(0x1000, 0x7982),(0x1000, 0x7992),(0x1000, 0x79A2),(0x1000, 0x79B2),(0x1000, 0x79C2),(0x1000, 0x79D2),(0x1000, 0x79E2),(0x1000, 0x79F2),(0x1000, 0x7A02),(0x1000, 0x7A12),(0x1000, 0x7A22),(0x1000, 0x7A32),(0x1000, 0x7A42),(0x1000, 0x7A52),(0x1000, 0x7A62),(0x1000, 0x7A72),(0x1000, 0x7A82),(0x1000, 0x7A92),(0x1000, 0x7AA2),(0x1000, 0x7AB2),(0x1000, 0x7AC2),(0x1000, 0x7AD2),(0x1000, 0x7AE2),(0x1000, 0x7AF2),(0x1000, 0x7B02),(0x1000, 0x7B12),(0x1000, 0x7B22),(0x1000, 0x7B32),(0x1000, 0x7B42),(0x1000, 0x7B52),(0x1000, 0x7B62),(0x1000, 0x7B72),(0x1000, 0x7B82),(0x1000, 0x7B92),(0x1000, 0x7BA2),(0x1000, 0x7BB2),(0x1000, 0x7BC2),(0x1000, 0x7BD2),(0x1000, 0x7BE2),(0x1000, 0x7BF2),(0x1000, 0x7C02),(0x1000, 0x7C12),(0x1000, 0x7C22),(0x1000, 0x7C32),(0x1000, 0x7C42),(0x1000, 0x7C52),(0x1000, 0x7C62),(0x1000, 0x7C72),(0x1000, 0x7C82),(0x1000, 0x7C92),(0x1000, 0x7CA2),(0x1000, 0x7CB2),(0x1000, 0x7CC2),(0x1000, 0x7CD2),(0x1000, 0x7CE2),(0x1000, 0x7CF2),(0x1000, 0x7D02),(0x1000, 0x7D12),(0x1000, 0x7D22),(0x1000, 0x7D32),(0x1000, 0x7D42),(0x1000, 0x7D52),(0x1000, 0x7D62),(0x1000, 0x7D72),(0x1000, 0x7D82),(0x1000, 0x7D92),(0x1000, 0x7DA2),(0x1000, 0x7DB2),(0x1000, 0x7DC2),(0x1000, 0x7DD2),(0x1000, 0x7DE2),(0x1000, 0x7DF2),(0x1000, 0x7E02),(0x1000, 0x7E12),(0x1000, 0x7E22),(0x1000, 0x7E32),(0x1000, 0x7E42),(0x1000, 0x7E52),(0x1000, 0x7E62),(0x1000, 0x7E72),(0x1000, 0x7E82),(0x1000, 0x7E92),(0x1000, 0x7EA2),(0x1000, 0x7EB2),(0x1000, 0x7EC2),(0x1000, 0x7ED2),(0x1000, 0x7EE2),(0x1000, 0x7EF2),(0x1000, 0x7F02),(0x1000, 0x7F12),(0x1000, 0x7F22),(0x1000, 0x7F32),(0x1000, 0x7F42),(0x1000, 0x7F52),(0x1000, 0x7F62),(0x1000, 0x7F72),(0x1000, 0x7F82),(0x1000, 0x7F92),(0x1000, 0x7FA2),(0x1000, 0x7FB2),(0x1000, 0x7FC2),(0x1000, 0x7FD2),(0x1000, 0x7FE2),(0x1000, 0x7FF2),(0x1000, 0x8002),(0x1000, 0x8012),(0x1000, 0x8022),(0x1000, 0x8032),(0x1000, 0x8042),(0x1000, 0x8052),(0x1000, 0x8062),(0x1000, 0x8072),(0x1000, 0x8082),(0x1000, 0x8092),(0x1000, 0x80A2),(0x1000, 0x80B2),(0x1000, 0x80C2),(0x1000, 0x80D2),(0x1000, 0x80E2),(0x1000, 0x80F2),(0x1000, 0x8102),(0x1000, 0x8112),(0x1000, 0x8122),(0x1000, 0x8132),(0x1000, 0x8142),(0x1000, 0x8152),(0x1000, 0x8162),(0x1000, 0x8172),(0x1000, 0x8182),(0x1000, 0x8192),(0x1000, 0x81A2),(0x1000, 0x81B2),(0x1000, 0x81C2),(0x1000, 0x81D2),(0x1000, 0x81E2),(0x1000, 0x81F2),(0x1000, 0x8202),(0x1000, 0x8212),(0x1000, 0x8222),(0x1000, 0x8232),(0x1000, 0x8242),(0x1000, 0x8252),(0x1000, 0x8262),(0x1000, 0x8272),(0x1000, 0x8282),(0x1000, 0x8292),(0x1000, 0x82A2),(0x1000, 0x82B2),(0x1000, 0x82C2),(0x1000, 0x82D2),(0x1000, 0x82E2),(0x1000, 0x82F2),(0x1000, 0x8302),(0x1000, 0x8312),(0x1000, 0x8322),(0x1000, 0x8332),(0x1000, 0x8342),(0x1000, 0x8352),(0x1000, 0x8362),(0x1000, 0x8372),(0x1000, 0x8382),(0x1000, 0x8392),(0x1000, 0x83A2),(0x1000, 0x83B2),(0x1000, 0x83C2),(0x1000, 0x83D2),(0x1000, 0x83E2),(0x1000, 0x83F2),(0x1000, 0x8402),(0x1000, 0x8412),(0x1000, 0x8422),(0x1000, 0x8432),(0x1000, 0x8442),(0x1000, 0x8452),(0x1000, 0x8462),(0x1000, 0x8472),(0x1000, 0x8482),(0x1000, 0x8492),(0x1000, 0x84A2),(0x1000, 0x84B2),(0x1000, 0x84C2),(0x1000, 0x84D2),(0x1000, 0x84E2),(0x1000, 0x84F2),(0x1000, 0x8502),(0x1000, 0x8512),(0x1000, 0x8522),(0x1000, 0x8532),(0x1000, 0x8542),(0x1000, 0x8552),(0x1000, 0x8562),(0x1000, 0x8572),(0x1000, 0x8582),(0x1000, 0x8592),(0x1000, 0x85A2),(0x1000, 0x85B2),(0x1000, 0x85C2),(0x1000, 0x85D2),(0x1000, 0x85E2),(0x1000, 0x85F2),(0x1000, 0x8602),(0x1000, 0x8612),(0x1000, 0x8622),(0x1000, 0x8632),(0x1000, 0x8642),(0x1000, 0x8652),(0x1000, 0x8662),(0x1000, 0x8672),(0x1000, 0x8682),(0x1000, 0x8692),(0x1000, 0x86A2),(0x1000, 0x86B2),(0x1000, 0x86C2),(0x1000, 0x86D2),(0x1000, 0x86E2),(0x1000, 0x86F2),(0x1000, 0x8702),(0x1000, 0x8712),(0x1000, 0x8722),(0x1000, 0x8732),(0x1000, 0x8742),(0x1000, 0x8752),(0x1000, 0x8762),(0x1000, 0x8772),(0x1000, 0x8782),(0x1000, 0x8792),(0x1000, 0x87A2),(0x1000, 0x87B2),(0x1000, 0x87C2),(0x1000, 0x87D2),(0x1000, 0x87E2),(0x1000, 0x87F2),(0x1000, 0x8802),(0x1000, 0x8812),(0x1000, 0x8822),(0x1000, 0x8832),(0x1000, 0x8842),(0x1000, 0x8852),(0x1000, 0x8862),(0x1000, 0x8872),(0x1000, 0x8882),(0x1000, 0x8892),(0x1000, 0x88A2),(0x1000, 0x88B2),(0x1000, 0x88C2),(0x1000, 0x88D2),(0x1000, 0x88E2),(0x1000, 0x88F2),(0x1000, 0x8902),(0x1000, 0x8912),(0x1000, 0x8922),(0x1000, 0x8932),(0x1000, 0x8942),(0x1000, 0x8952),(0x1000, 0x8962),(0x1000, 0x8972),(0x1000, 0x8982),(0x1000, 0x8992),(0x1000, 0x89A2),(0x1000, 0x89B2),(0x1000, 0x89C2),(0x1000, 0x89D2),(0x1000, 0x89E2),(0x1000, 0x89F2),(0x1000, 0x8A02),(0x1000, 0x8A12),(0x1000, 0x8A22),(0x1000, 0x8A32),(0x1000, 0x8A42),(0x1000, 0x8A52),(0x1000, 0x8A62),(0x1000, 0x8A72),(0x1000, 0x8A82),(0x1000, 0x8A92),(0x1000, 0x8AA2),(0x1000, 0x8AB2),(0x1000, 0x8AC2),(0x1000, 0x8AD2),(0x1000, 0x8AE2),(0x1000, 0x8AF2),(0x1000, 0x8B02),(0x1000, 0x8B12),(0x1000, 0x8B22),(0x1000, 0x8B32),(0x1000, 0x8B42),(0x1000, 0x8B52),(0x1000, 0x8B62),(0x1000, 0x8B72),(0x1000, 0x8B82),(0x1000, 0x8B92),(0x1000, 0x8BA2),(0x1000, 0x8BB2),(0x1000, 0x8BC2),(0x1000, 0x8BD2),(0x1000, 0x8BE2),(0x1000, 0x8BF2),(0x1000, 0x8C02),(0x1000, 0x8C12),(0x1000, 0x8C22),(0x1000, 0x8C32),(0x1000, 0x8C42),(0x1000, 0x8C52),(0x1000, 0x8C62),(0x1000, 0x8C72),(0x1000, 0x8C82),(0x1000, 0x8C92),(0x1000, 0x8CA2),(0x1000, 0x8CB2),(0x1000, 0x8CC2),(0x1000, 0x8CD2),(0x1000, 0x8CE2),(0x1000, 0x8CF2),(0x1000, 0x8D02),(0x1000, 0x8D12),(0x1000, 0x8D22),(0x1000, 0x8D32),(0x1000, 0x8D42),(0x1000, 0x8D52),(0x1000, 0x8D62),(0x1000, 0x8D72),(0x1000, 0x8D82),(0x1000, 0x8D92),(0x1000, 0x8DA2),(0x1000, 0x8DB2),(0x1000, 0x8DC2),(0x1000, 0x8DD2),(0x1000, 0x8DE2),(0x1000, 0x8DF2),(0x1000, 0x8E02),(0x1000, 0x8E12),(0x1000, 0x8E22),(0x1000, 0x8E32),(0x1000, 0x8E42),(0x1000, 0x8E52),(0x1000, 0x8E62),(0x1000, 0x8E72),(0x1000, 0x8E82),(0x1000, 0x8E92),(0x1000, 0x8EA2),(0x1000, 0x8EB2),(0x1000, 0x8EC2),(0x1000, 0x8ED2),(0x1000, 0x8EE2),(0x1000, 0x8EF2),(0x1000, 0x8F02),(0x1000, 0x8F12),(0x1000, 0x8F22),(0x1000, 0x8F32),(0x1000, 0x8F42),(0x1000, 0x8F52),(0x1000, 0x8F62),(0x1000, 0x8F72),(0x1000, 0x8F82),(0x1000, 0x8F92),(0x1000, 0x8FA2),(0x1000, 0x8FB2),(0x1000, 0x8FC2),(0x1000, 0x8FD2),(0x1000, 0x8FE2),(0x1000, 0x8FF2),(0x1000, 0x9002),(0x1000, 0x9012),(0x1000, 0x9022),(0x1000, 0x9032),(0x1000, 0x9042),(0x1000, 0x9052),(0x1000, 0x9062),(0x1000, 0x9072),(0x1000, 0x9082),(0x1000, 0x9092),(0x1000, 0x90A2),(0x1000, 0x90B2),(0x1000, 0x90C2),(0x1000, 0x90D2),(0x1000, 0x90E2),(0x1000, 0x90F2),(0x1000, 0x9102),(0x1000, 0x9112),(0x1000, 0x9122),(0x1000, 0x9132),(0x1000, 0x9142),(0x1000, 0x9152),(0x1000, 0x9162),(0x1000, 0x9172),(0x1000, 0x9182),(0x1000, 0x9192),(0x1000, 0x91A2),(0x1000, 0x91B2),(0x1000, 0x91C2),(0x1000, 0x91D2),(0x1000, 0x91E2),(0x1000, 0x91F2),(0x1000, 0x9202),(0x1000, 0x9212),(0x1000, 0x9222),(0x1000, 0x9232),(0x1000, 0x9242),(0x1000, 0x9252),(0x1000, 0x9262),(0x1000, 0x9272),(0x1000, 0x9282),(0x1000, 0x9292),(0x1000, 0x92A2),(0x1000, 0x92B2),(0x1000, 0x92C2),(0x1000, 0x92D2),(0x1000, 0x92E2),(0x1000, 0x92F2),(0x1000, 0x9302),(0x1000, 0x9312),(0x1000, 0x9322),(0x1000, 0x9332),(0x1000, 0x9342),(0x1000, 0x9352),(0x1000, 0x9362),(0x1000, 0x9372),(0x1000, 0x9382),(0x1000, 0x9392),(0x1000, 0x93A2),(0x1000, 0x93B2),(0x1000, 0x93C2),(0x1000, 0x93D2),(0x1000, 0x93E2),(0x1000, 0x93F2),(0x1000, 0x9402),(0x1000, 0x9412),(0x1000, 0x9422),(0x1000, 0x9432),(0x1000, 0x9442),(0x1000, 0x9452),(0x1000, 0x9462),(0x1000, 0x9472),(0x1000, 0x9482),(0x1000, 0x9492),(0x1000, 0x94A2),(0x1000, 0x94B2),(0x1000, 0x94C2),(0x1000, 0x94D2),(0x1000, 0x94E2),(0x1000, 0x94F2),(0x1000, 0x9502),(0x1000, 0x9512),(0x1000, 0x9522),(0x1000, 0x9532),(0x1000, 0x9542),(0x1000, 0x9552),(0x1000, 0x9562),(0x1000, 0x9572),(0x1000, 0x9582),(0x1000, 0x9592),(0x1000, 0x95A2),(0x1000, 0x95B2),(0x1000, 0x95C2),(0x1000, 0x95D2),(0x1000, 0x95E2),(0x1000, 0x95F2),(0x1000, 0x9602),(0x1000, 0x9612),(0x1000, 0x9622),(0x1000, 0x9632),(0x1000, 0x9642),(0x1000, 0x9652),(0x1000, 0x9662),(0x1000, 0x9672),(0x1000, 0x9682),(0x1000, 0x9692),(0x1000, 0x96A2),(0x1000, 0x96B2),(0x1000, 0x96C2),(0x1000, 0x96D2),(0x1000, 0x96E2),(0x1000, 0x96F2),(0x1000, 0x9702),(0x1000, 0x9712),(0x1000, 0x9722),(0x1000, 0x9732),(0x1000, 0x9742),(0x1000, 0x9752),(0x1000, 0x9762),(0x1000, 0x9772),(0x1000, 0x9782),(0x1000, 0x9792),(0x1000, 0x97A2),(0x1000, 0x97B2),(0x1000, 0x97C2),(0x1000, 0x97D2),(0x1000, 0x97E2),(0x1000, 0x97F2),(0x1000, 0x9802),(0x1000, 0x9812),(0x1000, 0x9822),(0x1000, 0x9832),(0x1000, 0x9842),(0x1000, 0x9852),(0x1000, 0x9862),(0x1000, 0x9872),(0x1000, 0x9882),(0x1000, 0x9892),(0x1000, 0x98A2),(0x1000, 0x98B2),(0x1000, 0x98C2),(0x1000, 0x98D2),(0x1000, 0x98E2),(0x1000, 0x98F2),(0x1000, 0x9902),(0x1000, 0x9912),(0x1000, 0x9922),(0x1000, 0x9932),(0x1000, 0x9942),(0x1000, 0x9952),(0x1000, 0x9962),(0x1000, 0x9972),(0x1000, 0x9982),(0x1000, 0x9992),(0x1000, 0x99A2),(0x1000, 0x99B2),(0x1000, 0x99C2),(0x1000, 0x99D2),(0x1000, 0x99E2),(0x1000, 0x99F2),(0x1000, 0x9A02),(0x1000, 0x9A12),(0x1000, 0x9A22),(0x1000, 0x9A32),(0x1000, 0x9A42),(0x1000, 0x9A52),(0x1000, 0x9A62),(0x1000, 0x9A72),(0x1000, 0x9A82),(0x1000, 0x9A92),(0x1000, 0x9AA2),(0x1000, 0x9AB2),(0x1000, 0x9AC2),(0x1000, 0x9AD2),(0x1000, 0x9AE2),(0x1000, 0x9AF2),(0x1000, 0x9B02),(0x1000, 0x9B12),(0x1000, 0x9B22),(0x1000, 0x9B32),(0x1000, 0x9B42),(0x1000, 0x9B52),(0x1000, 0x9B62),(0x1000, 0x9B72),(0x1000, 0x9B82),(0x1000, 0x9B92),(0x1000, 0x9BA2),(0x1000, 0x9BB2),(0x1000, 0x9BC2),(0x1000, 0x9BD2),(0x1000, 0x9BE2),(0x1000, 0x9BF2),(0x1000, 0x9C02),(0x1000, 0x9C12),(0x1000, 0x9C22),(0x1000, 0x9C32),(0x1000, 0x9C42),(0x1000, 0x9C52),(0x1000, 0x9C62),(0x1000, 0x9C72),(0x1000, 0x9C82),(0x1000, 0x9C92),(0x1000, 0x9CA2),(0x1000, 0x9CB2),(0x1000, 0x9CC2),(0x1000, 0x9CD2),(0x1000, 0x9CE2),(0x1000, 0x9CF2),(0x1000, 0x9D02),(0x1000, 0x9D12),(0x1000, 0x9D22),(0x1000, 0x9D32),(0x1000, 0x9D42),(0x1000, 0x9D52),(0x1000, 0x9D62),(0x1000, 0x9D72),(0x1000, 0x9D82),(0x1000, 0x9D92),(0x1000, 0x9DA2),(0x1000, 0x9DB2),(0x1000, 0x9DC2),(0x1000, 0x9DD2),(0x1000, 0x9DE2),(0x1000, 0x9DF2),(0x1000, 0x9E02),(0x1000, 0x9E12),(0x1000, 0x9E22),(0x1000, 0x9E32),(0x1000, 0x9E42),(0x1000, 0x9E52),(0x1000, 0x9E62),(0x1000, 0x9E72),(0x1000, 0x9E82),(0x1000, 0x9E92),(0x1000, 0x9EA2),(0x1000, 0x9EB2),(0x1000, 0x9EC2),(0x1000, 0x9ED2),(0x1000, 0x9EE2),(0x1000, 0x9EF2),(0x1000, 0x9F02),(0x1000, 0x9F12),(0x1000, 0x9F22),(0x1000, 0x9F32),(0x1000, 0x9F42),(0x1000, 0x9F52),(0x1000, 0x9F62),(0x1000, 0x9F72),(0x1000, 0x9F82),(0x1000, 0x9F92),(0x1000, 0x9FA2),(0x1000, 0x9FB2),(0x1000, 0x9FC2),(0x1000, 0x9FD2),(0x1000, 0x9FE2),(0x1000, 0x9FF2),(0x1000, 0xA002),(0x1000, 0xA012),(0x1000, 0xA022),(0x1000, 0xA032),(0x1000, 0xA042),(0x1000, 0xA052),(0x1000, 0xA062),(0x1000, 0xA072),(0x1000, 0xA082),(0x1000, 0xA092),(0x1000, 0xA0A2),(0x1000, 0xA0B2),(0x1000, 0xA0C2),(0x1000, 0xA0D2),(0x1000, 0xA0E2),(0x1000, 0xA0F2),(0x1000, 0xA102),(0x1000, 0xA112),(0x1000, 0xA122),(0x1000, 0xA132),(0x1000, 0xA142),(0x1000, 0xA152),(0x1000, 0xA162),(0x1000, 0xA172),(0x1000, 0xA182),(0x1000, 0xA192),(0x1000, 0xA1A2),(0x1000, 0xA1B2),(0x1000, 0xA1C2),(0x1000, 0xA1D2),(0x1000, 0xA1E2),(0x1000, 0xA1F2),(0x1000, 0xA202),(0x1000, 0xA212),(0x1000, 0xA222),(0x1000, 0xA232),(0x1000, 0xA242),(0x1000, 0xA252),(0x1000, 0xA262),(0x1000, 0xA272),(0x1000, 0xA282),(0x1000, 0xA292),(0x1000, 0xA2A2),(0x1000, 0xA2B2),(0x1000, 0xA2C2),(0x1000, 0xA2D2),(0x1000, 0xA2E2),(0x1000, 0xA2F2),(0x1000, 0xA302),(0x1000, 0xA312),(0x1000, 0xA322),(0x1000, 0xA332),(0x1000, 0xA342),(0x1000, 0xA352),(0x1000, 0xA362),(0x1000, 0xA372),(0x1000, 0xA382),(0x1000, 0xA392),(0x1000, 0xA3A2),(0x1000, 0xA3B2),(0x1000, 0xA3C2),(0x1000, 0xA3D2),(0x1000, 0xA3E2),(0x1000, 0xA3F2),(0x1000, 0xA402),(0x1000, 0xA412),(0x1000, 0xA422),(0x1000, 0xA432),(0x1000, 0xA442),(0x1000, 0xA452),(0x1000, 0xA462),(0x1000, 0xA472),(0x1000, 0xA482),(0x1000, 0xA492),(0x1000, 0xA4A2),(0x1000, 0xA4B2),(0x1000, 0xA4C2),(0x1000, 0xA4D2),(0x1000, 0xA4E2),(0x1000, 0xA4F2),(0x1000, 0xA502),(0x1000, 0xA512),(0x1000, 0xA522),(0x1000, 0xA532),(0x1000, 0xA542),(0x1000, 0xA552),(0x1000, 0xA562),(0x1000, 0xA572),(0x1000, 0xA582),(0x1000, 0xA592),(0x1000, 0xA5A2),(0x1000, 0xA5B2),(0x1000, 0xA5C2),(0x1000, 0xA5D2),(0x1000, 0xA5E2),(0x1000, 0xA5F2),(0x1000, 0xA602),(0x1000, 0xA612),(0x1000, 0xA622),(0x1000, 0xA632),(0x1000, 0xA642),(0x1000, 0xA652),(0x1000, 0xA662),(0x1000, 0xA672),(0x1000, 0xA682),(0x1000, 0xA692),(0x1000, 0xA6A2),(0x1000, 0xA6B2),(0x1000, 0xA6C2),(0x1000, 0xA6D2),(0x1000, 0xA6E2),(0x1000, 0xA6F2),(0x1000, 0xA702),(0x1000, 0xA712),(0x1000, 0xA722),(0x1000, 0xA732),(0x1000, 0xA742),(0x1000, 0xA752),(0x1000, 0xA762),(0x1000, 0xA772),(0x1000, 0xA782),(0x1000, 0xA792),(0x1000, 0xA7A2),(0x1000, 0xA7B2),(0x1000, 0xA7C2),(0x1000, 0xA7D2),(0x1000, 0xA7E2),(0x1000, 0xA7F2),(0x1000, 0xA802),(0x1000, 0xA812),(0x1000, 0xA822),(0x1000, 0xA832),(0x1000, 0xA842),(0x1000, 0xA852),(0x1000, 0xA862),(0x1000, 0xA872),(0x1000, 0xA882),(0x1000, 0xA892),(0x1000, 0xA8A2),(0x1000, 0xA8B2),(0x1000, 0xA8C2),(0x1000, 0xA8D2),(0x1000, 0xA8E2),(0x1000, 0xA8F2),(0x1000, 0xA902),(0x1000, 0xA912),(0x1000, 0xA922),(0x1000, 0xA932),(0x1000, 0xA942),(0x1000, 0xA952),(0x1000, 0xA962),(0x1000, 0xA972),(0x1000, 0xA982),(0x1000, 0xA992),(0x1000, 0xA9A2),(0x1000, 0xA9B2),(0x1000, 0xA9C2),(0x1000, 0xA9D2),(0x1000, 0xA9E2),(0x1000, 0xA9F2),(0x1000, 0xAA02),(0x1000, 0xAA12),(0x1000, 0xAA22),(0x1000, 0xAA32),(0x1000, 0xAA42),(0x1000, 0xAA52),(0x1000, 0xAA62),(0x1000, 0xAA72),(0x1000, 0xAA82),(0x1000, 0xAA92),(0x1000, 0xAAA2),(0x1000, 0xAAB2),(0x1000, 0xAAC2),(0x1000, 0xAAD2),(0x1000, 0xAAE2),(0x1000, 0xAAF2),(0x1000, 0xAB02),(0x1000, 0xAB12),(0x1000, 0xAB22),(0x1000, 0xAB32),(0x1000, 0xAB42),(0x1000, 0xAB52),(0x1000, 0xAB62),(0x1000, 0xAB72),(0x1000, 0xAB82),(0x1000, 0xAB92),(0x1000, 0xABA2),(0x1000, 0xABB2),(0x1000, 0xABC2),(0x1000, 0xABD2),(0x1000, 0xABE2),(0x1000, 0xABF2),(0x1000, 0xAC02),(0x1000, 0xAC12),(0x1000, 0xAC22),(0x1000, 0xAC32),(0x1000, 0xAC42),(0x1000, 0xAC52),(0x1000, 0xAC62),(0x1000, 0xAC72),(0x1000, 0xAC82),(0x1000, 0xAC92),(0x1000, 0xACA2),(0x1000, 0xACB2),(0x1000, 0xACC2),(0x1000, 0xACD2),(0x1000, 0xACE2),(0x1000, 0xACF2),(0x1000, 0xAD02),(0x1000, 0xAD12),(0x1000, 0xAD22),(0x1000, 0xAD32),(0x1000, 0xAD42),(0x1000, 0xAD52),(0x1000, 0xAD62),(0x1000, 0xAD72),(0x1000, 0xAD82),(0x1000, 0xAD92),(0x1000, 0xADA2),(0x1000, 0xADB2),(0x1000, 0xADC2),(0x1000, 0xADD2),(0x1000, 0xADE2),(0x1000, 0xADF2),(0x1000, 0xAE02),(0x1000, 0xAE12),(0x1000, 0xAE22),(0x1000, 0xAE32),(0x1000, 0xAE42),(0x1000, 0xAE52),(0x1000, 0xAE62),(0x1000, 0xAE72),(0x1000, 0xAE82),(0x1000, 0xAE92),(0x1000, 0xAEA2),(0x1000, 0xAEB2),(0x1000, 0xAEC2),(0x1000, 0xAED2),(0x1000, 0xAEE2),(0x1000, 0xAEF2),(0x1000, 0xAF02),(0x1000, 0xAF12),(0x1000, 0xAF22),(0x1000, 0xAF32),(0x1000, 0xAF42),(0x1000, 0xAF52),(0x1000, 0xAF62),(0x1000, 0xAF72),(0x1000, 0xAF82),(0x1000, 0xAF92),(0x1000, 0xAFA2),(0x1000, 0xAFB2),(0x1000, 0xAFC2),(0x1000, 0xAFD2),(0x1000, 0xAFE2),(0x1000, 0xAFF2),(0x1000, 0xB002),(0x1000, 0xB012),(0x1000, 0xB022),(0x1000, 0xB032),(0x1000, 0xB042),(0x1000, 0xB052),(0x1000, 0xB062),(0x1000, 0xB072),(0x1000, 0xB082),(0x1000, 0xB092),(0x1000, 0xB0A2),(0x1000, 0xB0B2),(0x1000, 0xB0C2),(0x1000, 0xB0D2),(0x1000, 0xB0E2),(0x1000, 0xB0F2),(0x1000, 0xB102),(0x1000, 0xB112),(0x1000, 0xB122),(0x1000, 0xB132),(0x1000, 0xB142),(0x1000, 0xB152),(0x1000, 0xB162),(0x1000, 0xB172),(0x1000, 0xB182),(0x1000, 0xB192),(0x1000, 0xB1A2),(0x1000, 0xB1B2),(0x1000, 0xB1C2),(0x1000, 0xB1D2),(0x1000, 0xB1E2),(0x1000, 0xB1F2),(0x1000, 0xB202),(0x1000, 0xB212),(0x1000, 0xB222),(0x1000, 0xB232),(0x1000, 0xB242),(0x1000, 0xB252),(0x1000, 0xB262),(0x1000, 0xB272),(0x1000, 0xB282),(0x1000, 0xB292),(0x1000, 0xB2A2),(0x1000, 0xB2B2),(0x1000, 0xB2C2),(0x1000, 0xB2D2),(0x1000, 0xB2E2),(0x1000, 0xB2F2),(0x1000, 0xB302),(0x1000, 0xB312),(0x1000, 0xB322),(0x1000, 0xB332),(0x1000, 0xB342),(0x1000, 0xB352),(0x1000, 0xB362),(0x1000, 0xB372),(0x1000, 0xB382),(0x1000, 0xB392),(0x1000, 0xB3A2),(0x1000, 0xB3B2),(0x1000, 0xB3C2),(0x1000, 0xB3D2),(0x1000, 0xB3E2),(0x1000, 0xB3F2),(0x1000, 0xB402),(0x1000, 0xB412),(0x1000, 0xB422),(0x1000, 0xB432),(0x1000, 0xB442),(0x1000, 0xB452),(0x1000, 0xB462),(0x1000, 0xB472),(0x1000, 0xB482),(0x1000, 0xB492),(0x1000, 0xB4A2),(0x1000, 0xB4B2),(0x1000, 0xB4C2),(0x1000, 0xB4D2),(0x1000, 0xB4E2),(0x1000, 0xB4F2),(0x1000, 0xB502),(0x1000, 0xB512),(0x1000, 0xB522),(0x1000, 0xB532),(0x1000, 0xB542),(0x1000, 0xB552),(0x1000, 0xB562),(0x1000, 0xB572),(0x1000, 0xB582),(0x1000, 0xB592),(0x1000, 0xB5A2),(0x1000, 0xB5B2),(0x1000, 0xB5C2),(0x1000, 0xB5D2),(0x1000, 0xB5E2),(0x1000, 0xB5F2),(0x1000, 0xB602),(0x1000, 0xB612),(0x1000, 0xB622),(0x1000, 0xB632),(0x1000, 0xB642),(0x1000, 0xB652),(0x1000, 0xB662),(0x1000, 0xB672),(0x1000, 0xB682),(0x1000, 0xB692),(0x1000, 0xB6A2),(0x1000, 0xB6B2),(0x1000, 0xB6C2),(0x1000, 0xB6D2),(0x1000, 0xB6E2),(0x1000, 0xB6F2),(0x1000, 0xB702),(0x1000, 0xB712),(0x1000, 0xB722),(0x1000, 0xB732),(0x1000, 0xB742),(0x1000, 0xB752),(0x1000, 0xB762),(0x1000, 0xB772),(0x1000, 0xB782),(0x1000, 0xB792),(0x1000, 0xB7A2),(0x1000, 0xB7B2),(0x1000, 0xB7C2),(0x1000, 0xB7D2),(0x1000, 0xB7E2),(0x1000, 0xB7F2),(0x1000, 0xB802),(0x1000, 0xB812),(0x1000, 0xB822),(0x1000, 0xB832),(0x1000, 0xB842),(0x1000, 0xB852),(0x1000, 0xB862),(0x1000, 0xB872),(0x1000, 0xB882),(0x1000, 0xB892),(0x1000, 0xB8A2),(0x1000, 0xB8B2),(0x1000, 0xB8C2),(0x1000, 0xB8D2),(0x1000, 0xB8E2),(0x1000, 0xB8F2),(0x1000, 0xB902),(0x1000, 0xB912),(0x1000, 0xB922),(0x1000, 0xB932),(0x1000, 0xB942),(0x1000, 0xB952),(0x1000, 0xB962),(0x1000, 0xB972),(0x1000, 0xB982),(0x1000, 0xB992),(0x1000, 0xB9A2),(0x1000, 0xB9B2),(0x1000, 0xB9C2),(0x1000, 0xB9D2),(0x1000, 0xB9E2),(0x1000, 0xB9F2),(0x1000, 0xBA02),(0x1000, 0xBA12),(0x1000, 0xBA22),(0x1000, 0xBA32),(0x1000, 0xBA42),(0x1000, 0xBA52),(0x1000, 0xBA62),(0x1000, 0xBA72),(0x1000, 0xBA82),(0x1000, 0xBA92),(0x1000, 0xBAA2),(0x1000, 0xBAB2),(0x1000, 0xBAC2),(0x1000, 0xBAD2),(0x1000, 0xBAE2),(0x1000, 0xBAF2),(0x1000, 0xBB02),(0x1000, 0xBB12),(0x1000, 0xBB22),(0x1000, 0xBB32),(0x1000, 0xBB42),(0x1000, 0xBB52),(0x1000, 0xBB62),(0x1000, 0xBB72),(0x1000, 0xBB82),(0x1000, 0xBB92),(0x1000, 0xBBA2),(0x1000, 0xBBB2),(0x1000, 0xBBC2),(0x1000, 0xBBD2),(0x1000, 0xBBE2),(0x1000, 0xBBF2),(0x1000, 0xBC02),(0x1000, 0xBC12),(0x1000, 0xBC22),(0x1000, 0xBC32),(0x1000, 0xBC42),(0x1000, 0xBC52),(0x1000, 0xBC62),(0x1000, 0xBC72),(0x1000, 0xBC82),(0x1000, 0xBC92),(0x1000, 0xBCA2),(0x1000, 0xBCB2),(0x1000, 0xBCC2),(0x1000, 0xBCD2),(0x1000, 0xBCE2),(0x1000, 0xBCF2),(0x1000, 0xBD02),(0x1000, 0xBD12),(0x1000, 0xBD22),(0x1000, 0xBD32),(0x1000, 0xBD42),(0x1000, 0xBD52),(0x1000, 0xBD62),(0x1000, 0xBD72),(0x1000, 0xBD82),(0x1000, 0xBD92),(0x1000, 0xBDA2),(0x1000, 0xBDB2),(0x1000, 0xBDC2),(0x1000, 0xBDD2),(0x1000, 0xBDE2),(0x1000, 0xBDF2),(0x1000, 0xBE02),(0x1000, 0xBE12),(0x1000, 0xBE22),(0x1000, 0xBE32),(0x1000, 0xBE42),(0x1000, 0xBE52),(0x1000, 0xBE62),(0x1000, 0xBE72),(0x1000, 0xBE82),(0x1000, 0xBE92),(0x1000, 0xBEA2),(0x1000, 0xBEB2),(0x1000, 0xBEC2),(0x1000, 0xBED2),(0x1000, 0xBEE2),(0x1000, 0xBEF2),(0x1000, 0xBF02),(0x1000, 0xBF12),(0x1000, 0xBF22),(0x1000, 0xBF32),(0x1000, 0xBF42),(0x1000, 0xBF52),(0x1000, 0xBF62),(0x1000, 0xBF72),(0x1000, 0xBF82),(0x1000, 0xBF92),(0x1000, 0xBFA2),(0x1000, 0xBFB2),(0x1000, 0xBFC2),(0x1000, 0xBFD2),(0x1000, 0xBFE2),(0x1000, 0xBFF2),(0x1000, 0xC002),(0x1000, 0xC012),(0x1000, 0xC022),(0x1000, 0xC032),(0x1000, 0xC042),(0x1000, 0xC052),(0x1000, 0xC062),(0x1000, 0xC072),(0x1000, 0xC082),(0x1000, 0xC092),(0x1000, 0xC0A2),(0x1000, 0xC0B2),(0x1000, 0xC0C2),(0x1000, 0xC0D2),(0x1000, 0xC0E2),(0x1000, 0xC0F2),(0x1000, 0xC102),(0x1000, 0xC112),(0x1000, 0xC122),(0x1000, 0xC132),(0x1000, 0xC142),(0x1000, 0xC152),(0x1000, 0xC162),(0x1000, 0xC172),(0x1000, 0xC182),(0x1000, 0xC192),(0x1000, 0xC1A2),(0x1000, 0xC1B2),(0x1000, 0xC1C2),(0x1000, 0xC1D2),(0x1000, 0xC1E2),(0x1000, 0xC1F2),(0x1000, 0xC202),(0x1000, 0xC212),(0x1000, 0xC222),(0x1000, 0xC232),(0x1000, 0xC242),(0x1000, 0xC252),(0x1000, 0xC262),(0x1000, 0xC272),(0x1000, 0xC282),(0x1000, 0xC292),(0x1000, 0xC2A2),(0x1000, 0xC2B2),(0x1000, 0xC2C2),(0x1000, 0xC2D2),(0x1000, 0xC2E2),(0x1000, 0xC2F2),(0x1000, 0xC302),(0x1000, 0xC312),(0x1000, 0xC322),(0x1000, 0xC332),(0x1000, 0xC342),(0x1000, 0xC352),(0x1000, 0xC362),(0x1000, 0xC372),(0x1000, 0xC382),(0x1000, 0xC392),(0x1000, 0xC3A2),(0x1000, 0xC3B2),(0x1000, 0xC3C2),(0x1000, 0xC3D2),(0x1000, 0xC3E2),(0x1000, 0xC3F2),(0x1000, 0xC402),(0x1000, 0xC412),(0x1000, 0xC422),(0x1000, 0xC432),(0x1000, 0xC442),(0x1000, 0xC452),(0x1000, 0xC462),(0x1000, 0xC472),(0x1000, 0xC482),(0x1000, 0xC492),(0x1000, 0xC4A2),(0x1000, 0xC4B2),(0x1000, 0xC4C2),(0x1000, 0xC4D2),(0x1000, 0xC4E2),(0x1000, 0xC4F2),(0x1000, 0xC502),(0x1000, 0xC512),(0x1000, 0xC522),(0x1000, 0xC532),(0x1000, 0xC542),(0x1000, 0xC552),(0x1000, 0xC562),(0x1000, 0xC572),(0x1000, 0xC582),(0x1000, 0xC592),(0x1000, 0xC5A2),(0x1000, 0xC5B2),(0x1000, 0xC5C2),(0x1000, 0xC5D2),(0x1000, 0xC5E2),(0x1000, 0xC5F2),(0x1000, 0xC602),(0x1000, 0xC612),(0x1000, 0xC622),(0x1000, 0xC632),(0x1000, 0xC642),(0x1000, 0xC652),(0x1000, 0xC662),(0x1000, 0xC672),(0x1000, 0xC682),(0x1000, 0xC692),(0x1000, 0xC6A2),(0x1000, 0xC6B2),(0x1000, 0xC6C2),(0x1000, 0xC6D2),(0x1000, 0xC6E2),(0x1000, 0xC6F2),(0x1000, 0xC702),(0x1000, 0xC712),(0x1000, 0xC722),(0x1000, 0xC732),(0x1000, 0xC742),(0x1000, 0xC752),(0x1000, 0xC762),(0x1000, 0xC772),(0x1000, 0xC782),(0x1000, 0xC792),(0x1000, 0xC7A2),(0x1000, 0xC7B2),(0x1000, 0xC7C2),(0x1000, 0xC7D2),(0x1000, 0xC7E2),(0x1000, 0xC7F2),(0x1000, 0xC802),(0x1000, 0xC812),(0x1000, 0xC822),(0x1000, 0xC832),(0x1000, 0xC842),(0x1000, 0xC852),(0x1000, 0xC862),(0x1000, 0xC872),(0x1000, 0xC882),(0x1000, 0xC892),(0x1000, 0xC8A2),(0x1000, 0xC8B2),(0x1000, 0xC8C2),(0x1000, 0xC8D2),(0x1000, 0xC8E2),(0x1000, 0xC8F2),(0x1000, 0xC902),(0x1000, 0xC912),(0x1000, 0xC922),(0x1000, 0xC932),(0x1000, 0xC942),(0x1000, 0xC952),(0x1000, 0xC962),(0x1000, 0xC972),(0x1000, 0xC982),(0x1000, 0xC992),(0x1000, 0xC9A2),(0x1000, 0xC9B2),(0x1000, 0xC9C2),(0x1000, 0xC9D2),(0x1000, 0xC9E2),(0x1000, 0xC9F2),(0x1000, 0xCA02),(0x1000, 0xCA12),(0x1000, 0xCA22),(0x1000, 0xCA32),(0x1000, 0xCA42),(0x1000, 0xCA52),(0x1000, 0xCA62),(0x1000, 0xCA72),(0x1000, 0xCA82),(0x1000, 0xCA92),(0x1000, 0xCAA2),(0x1000, 0xCAB2),(0x1000, 0xCAC2),(0x1000, 0xCAD2),(0x1000, 0xCAE2),(0x1000, 0xCAF2),(0x1000, 0xCB02),(0x1000, 0xCB12),(0x1000, 0xCB22),(0x1000, 0xCB32),(0x1000, 0xCB42),(0x1000, 0xCB52),(0x1000, 0xCB62),(0x1000, 0xCB72),(0x1000, 0xCB82),(0x1000, 0xCB92),(0x1000, 0xCBA2),(0x1000, 0xCBB2),(0x1000, 0xCBC2),(0x1000, 0xCBD2),(0x1000, 0xCBE2),(0x1000, 0xCBF2),(0x1000, 0xCC02),(0x1000, 0xCC12),(0x1000, 0xCC22),(0x1000, 0xCC32),(0x1000, 0xCC42),(0x1000, 0xCC52),(0x1000, 0xCC62),(0x1000, 0xCC72),(0x1000, 0xCC82),(0x1000, 0xCC92),(0x1000, 0xCCA2),(0x1000, 0xCCB2),(0x1000, 0xCCC2),(0x1000, 0xCCD2),(0x1000, 0xCCE2),(0x1000, 0xCCF2),(0x1000, 0xCD02),(0x1000, 0xCD12),(0x1000, 0xCD22),(0x1000, 0xCD32),(0x1000, 0xCD42),(0x1000, 0xCD52),(0x1000, 0xCD62),(0x1000, 0xCD72),(0x1000, 0xCD82),(0x1000, 0xCD92),(0x1000, 0xCDA2),(0x1000, 0xCDB2),(0x1000, 0xCDC2),(0x1000, 0xCDD2),(0x1000, 0xCDE2),(0x1000, 0xCDF2),(0x1000, 0xCE02),(0x1000, 0xCE12),(0x1000, 0xCE22),(0x1000, 0xCE32),(0x1000, 0xCE42),(0x1000, 0xCE52),(0x1000, 0xCE62),(0x1000, 0xCE72),(0x1000, 0xCE82),(0x1000, 0xCE92),(0x1000, 0xCEA2),(0x1000, 0xCEB2),(0x1000, 0xCEC2),(0x1000, 0xCED2),(0x1000, 0xCEE2),(0x1000, 0xCEF2),(0x1000, 0xCF02),(0x1000, 0xCF12),(0x1000, 0xCF22),(0x1000, 0xCF32),(0x1000, 0xCF42),(0x1000, 0xCF52),(0x1000, 0xCF62),(0x1000, 0xCF72),(0x1000, 0xCF82),(0x1000, 0xCF92),(0x1000, 0xCFA2),(0x1000, 0xCFB2),(0x1000, 0xCFC2),(0x1000, 0xCFD2),(0x1000, 0xCFE2),(0x1000, 0xCFF2),(0x1000, 0xD002),(0x1000, 0xD012),(0x1000, 0xD022),(0x1000, 0xD032),(0x1000, 0xD042),(0x1000, 0xD052),(0x1000, 0xD062),(0x1000, 0xD072),(0x1000, 0xD082),(0x1000, 0xD092),(0x1000, 0xD0A2),(0x1000, 0xD0B2),(0x1000, 0xD0C2),(0x1000, 0xD0D2),(0x1000, 0xD0E2),(0x1000, 0xD0F2),(0x1000, 0xD102),(0x1000, 0xD112),(0x1000, 0xD122),(0x1000, 0xD132),(0x1000, 0xD142),(0x1000, 0xD152),(0x1000, 0xD162),(0x1000, 0xD172),(0x1000, 0xD182),(0x1000, 0xD192),(0x1000, 0xD1A2),(0x1000, 0xD1B2),(0x1000, 0xD1C2),(0x1000, 0xD1D2),(0x1000, 0xD1E2),(0x1000, 0xD1F2),(0x1000, 0xD202),(0x1000, 0xD212),(0x1000, 0xD222),(0x1000, 0xD232),(0x1000, 0xD242),(0x1000, 0xD252),(0x1000, 0xD262),(0x1000, 0xD272),(0x1000, 0xD282),(0x1000, 0xD292),(0x1000, 0xD2A2),(0x1000, 0xD2B2),(0x1000, 0xD2C2),(0x1000, 0xD2D2),(0x1000, 0xD2E2),(0x1000, 0xD2F2),(0x1000, 0xD302),(0x1000, 0xD312),(0x1000, 0xD322),(0x1000, 0xD332),(0x1000, 0xD342),(0x1000, 0xD352),(0x1000, 0xD362),(0x1000, 0xD372),(0x1000, 0xD382),(0x1000, 0xD392),(0x1000, 0xD3A2),(0x1000, 0xD3B2),(0x1000, 0xD3C2),(0x1000, 0xD3D2),(0x1000, 0xD3E2),(0x1000, 0xD3F2),(0x1000, 0xD402),(0x1000, 0xD412),(0x1000, 0xD422),(0x1000, 0xD432),(0x1000, 0xD442),(0x1000, 0xD452),(0x1000, 0xD462),(0x1000, 0xD472),(0x1000, 0xD482),(0x1000, 0xD492),(0x1000, 0xD4A2),(0x1000, 0xD4B2),(0x1000, 0xD4C2),(0x1000, 0xD4D2),(0x1000, 0xD4E2),(0x1000, 0xD4F2),(0x1000, 0xD502),(0x1000, 0xD512),(0x1000, 0xD522),(0x1000, 0xD532),(0x1000, 0xD542),(0x1000, 0xD552),(0x1000, 0xD562),(0x1000, 0xD572),(0x1000, 0xD582),(0x1000, 0xD592),(0x1000, 0xD5A2),(0x1000, 0xD5B2),(0x1000, 0xD5C2),(0x1000, 0xD5D2),(0x1000, 0xD5E2),(0x1000, 0xD5F2),(0x1000, 0xD602),(0x1000, 0xD612),(0x1000, 0xD622),(0x1000, 0xD632),(0x1000, 0xD642),(0x1000, 0xD652),(0x1000, 0xD662),(0x1000, 0xD672),(0x1000, 0xD682),(0x1000, 0xD692),(0x1000, 0xD6A2),(0x1000, 0xD6B2),(0x1000, 0xD6C2),(0x1000, 0xD6D2),(0x1000, 0xD6E2),(0x1000, 0xD6F2),(0x1000, 0xD702),(0x1000, 0xD712),(0x1000, 0xD722),(0x1000, 0xD732),(0x1000, 0xD742),(0x1000, 0xD752),(0x1000, 0xD762),(0x1000, 0xD772),(0x1000, 0xD782),(0x1000, 0xD792),(0x1000, 0xD7A2),(0x1000, 0xD7B2),(0x1000, 0xD7C2),(0x1000, 0xD7D2),(0x1000, 0xD7E2),(0x1000, 0xD7F2),(0x1000, 0xD802),(0x1000, 0xD812),(0x1000, 0xD822),(0x1000, 0xD832),(0x1000, 0xD842),(0x1000, 0xD852),(0x1000, 0xD862),(0x1000, 0xD872),(0x1000, 0xD882),(0x1000, 0xD892),(0x1000, 0xD8A2),(0x1000, 0xD8B2),(0x1000, 0xD8C2),(0x1000, 0xD8D2),(0x1000, 0xD8E2),(0x1000, 0xD8F2),(0x1000, 0xD902),(0x1000, 0xD912),(0x1000, 0xD922),(0x1000, 0xD932),(0x1000, 0xD942),(0x1000, 0xD952),(0x1000, 0xD962),(0x1000, 0xD972),(0x1000, 0xD982),(0x1000, 0xD992),(0x1000, 0xD9A2),(0x1000, 0xD9B2),(0x1000, 0xD9C2),(0x1000, 0xD9D2),(0x1000, 0xD9E2),(0x1000, 0xD9F2),(0x1000, 0xDA02),(0x1000, 0xDA12),(0x1000, 0xDA22),(0x1000, 0xDA32),(0x1000, 0xDA42),(0x1000, 0xDA52),(0x1000, 0xDA62),(0x1000, 0xDA72),(0x1000, 0xDA82),(0x1000, 0xDA92),(0x1000, 0xDAA2),(0x1000, 0xDAB2),(0x1000, 0xDAC2),(0x1000, 0xDAD2),(0x1000, 0xDAE2),(0x1000, 0xDAF2),(0x1000, 0xDB02),(0x1000, 0xDB12),(0x1000, 0xDB22),(0x1000, 0xDB32),(0x1000, 0xDB42),(0x1000, 0xDB52),(0x1000, 0xDB62),(0x1000, 0xDB72),(0x1000, 0xDB82),(0x1000, 0xDB92),(0x1000, 0xDBA2),(0x1000, 0xDBB2),(0x1000, 0xDBC2),(0x1000, 0xDBD2),(0x1000, 0xDBE2),(0x1000, 0xDBF2),(0x1000, 0xDC02),(0x1000, 0xDC12),(0x1000, 0xDC22),(0x1000, 0xDC32),(0x1000, 0xDC42),(0x1000, 0xDC52),(0x1000, 0xDC62),(0x1000, 0xDC72),(0x1000, 0xDC82),(0x1000, 0xDC92),(0x1000, 0xDCA2),(0x1000, 0xDCB2),(0x1000, 0xDCC2),(0x1000, 0xDCD2),(0x1000, 0xDCE2),(0x1000, 0xDCF2),(0x1000, 0xDD02),(0x1000, 0xDD12),(0x1000, 0xDD22),(0x1000, 0xDD32),(0x1000, 0xDD42),(0x1000, 0xDD52),(0x1000, 0xDD62),(0x1000, 0xDD72),(0x1000, 0xDD82),(0x1000, 0xDD92),(0x1000, 0xDDA2),(0x1000, 0xDDB2),(0x1000, 0xDDC2),(0x1000, 0xDDD2),(0x1000, 0xDDE2),(0x1000, 0xDDF2),(0x1000, 0xDE02),(0x1000, 0xDE12),(0x1000, 0xDE22),(0x1000, 0xDE32),(0x1000, 0xDE42),(0x1000, 0xDE52),(0x1000, 0xDE62),(0x1000, 0xDE72),(0x1000, 0xDE82),(0x1000, 0xDE92),(0x1000, 0xDEA2),(0x1000, 0xDEB2),(0x1000, 0xDEC2),(0x1000, 0xDED2),(0x1000, 0xDEE2),(0x1000, 0xDEF2),(0x1000, 0xDF02),(0x1000, 0xDF12),(0x1000, 0xDF22),(0x1000, 0xDF32),(0x1000, 0xDF42),(0x1000, 0xDF52),(0x1000, 0xDF62),(0x1000, 0xDF72),(0x1000, 0xDF82),(0x1000, 0xDF92),(0x1000, 0xDFA2),(0x1000, 0xDFB2),(0x1000, 0xDFC2),(0x1000, 0xDFD2),(0x1000, 0xDFE2),(0x1000, 0xDFF2),(0x1000, 0xE002),(0x1000, 0xE012),(0x1000, 0xE022),(0x1000, 0xE032),(0x1000, 0xE042),(0x1000, 0xE052),(0x1000, 0xE062),(0x1000, 0xE072),(0x1000, 0xE082),(0x1000, 0xE092),(0x1000, 0xE0A2),(0x1000, 0xE0B2),(0x1000, 0xE0C2),(0x1000, 0xE0D2),(0x1000, 0xE0E2),(0x1000, 0xE0F2),(0x1000, 0xE102),(0x1000, 0xE112),(0x1000, 0xE122),(0x1000, 0xE132),(0x1000, 0xE142),(0x1000, 0xE152),(0x1000, 0xE162),(0x1000, 0xE172),(0x1000, 0xE182),(0x1000, 0xE192),(0x1000, 0xE1A2),(0x1000, 0xE1B2),(0x1000, 0xE1C2),(0x1000, 0xE1D2),(0x1000, 0xE1E2),(0x1000, 0xE1F2),(0x1000, 0xE202),(0x1000, 0xE212),(0x1000, 0xE222),(0x1000, 0xE232),(0x1000, 0xE242),(0x1000, 0xE252),(0x1000, 0xE262),(0x1000, 0xE272),(0x1000, 0xE282),(0x1000, 0xE292),(0x1000, 0xE2A2),(0x1000, 0xE2B2),(0x1000, 0xE2C2),(0x1000, 0xE2D2),(0x1000, 0xE2E2),(0x1000, 0xE2F2),(0x1000, 0xE302),(0x1000, 0xE312),(0x1000, 0xE322),(0x1000, 0xE332),(0x1000, 0xE342),(0x1000, 0xE352),(0x1000, 0xE362),(0x1000, 0xE372),(0x1000, 0xE382),(0x1000, 0xE392),(0x1000, 0xE3A2),(0x1000, 0xE3B2),(0x1000, 0xE3C2),(0x1000, 0xE3D2),(0x1000, 0xE3E2),(0x1000, 0xE3F2),(0x1000, 0xE402),(0x1000, 0xE412),(0x1000, 0xE422),(0x1000, 0xE432),(0x1000, 0xE442),(0x1000, 0xE452),(0x1000, 0xE462),(0x1000, 0xE472),(0x1000, 0xE482),(0x1000, 0xE492),(0x1000, 0xE4A2),(0x1000, 0xE4B2),(0x1000, 0xE4C2),(0x1000, 0xE4D2),(0x1000, 0xE4E2),(0x1000, 0xE4F2),(0x1000, 0xE502),(0x1000, 0xE512),(0x1000, 0xE522),(0x1000, 0xE532),(0x1000, 0xE542),(0x1000, 0xE552),(0x1000, 0xE562),(0x1000, 0xE572),(0x1000, 0xE582),(0x1000, 0xE592),(0x1000, 0xE5A2),(0x1000, 0xE5B2),(0x1000, 0xE5C2),(0x1000, 0xE5D2),(0x1000, 0xE5E2),(0x1000, 0xE5F2),(0x1000, 0xE602),(0x1000, 0xE612),(0x1000, 0xE622),(0x1000, 0xE632),(0x1000, 0xE642),(0x1000, 0xE652),(0x1000, 0xE662),(0x1000, 0xE672),(0x1000, 0xE682),(0x1000, 0xE692),(0x1000, 0xE6A2),(0x1000, 0xE6B2),(0x1000, 0xE6C2),(0x1000, 0xE6D2),(0x1000, 0xE6E2),(0x1000, 0xE6F2),(0x1000, 0xE702),(0x1000, 0xE712),(0x1000, 0xE722),(0x1000, 0xE732),(0x1000, 0xE742),(0x1000, 0xE752),(0x1000, 0xE762),(0x1000, 0xE772),(0x1000, 0xE782),(0x1000, 0xE792),(0x1000, 0xE7A2),(0x1000, 0xE7B2),(0x1000, 0xE7C2),(0x1000, 0xE7D2),(0x1000, 0xE7E2),(0x1000, 0xE7F2),(0x1000, 0xE802),(0x1000, 0xE812),(0x1000, 0xE822),(0x1000, 0xE832),(0x1000, 0xE842),(0x1000, 0xE852),(0x1000, 0xE862),(0x1000, 0xE872),(0x1000, 0xE882),(0x1000, 0xE892),(0x1000, 0xE8A2),(0x1000, 0xE8B2),(0x1000, 0xE8C2),(0x1000, 0xE8D2),(0x1000, 0xE8E2),(0x1000, 0xE8F2),(0x1000, 0xE902),(0x1000, 0xE912),(0x1000, 0xE922),(0x1000, 0xE932),(0x1000, 0xE942),(0x1000, 0xE952),(0x1000, 0xE962),(0x1000, 0xE972),(0x1000, 0xE982),(0x1000, 0xE992),(0x1000, 0xE9A2),(0x1000, 0xE9B2),(0x1000, 0xE9C2),(0x1000, 0xE9D2),(0x1000, 0xE9E2),(0x1000, 0xE9F2),(0x1000, 0xEA02),(0x1000, 0xEA12),(0x1000, 0xEA22),(0x1000, 0xEA32),(0x1000, 0xEA42),(0x1000, 0xEA52),(0x1000, 0xEA62),(0x1000, 0xEA72),(0x1000, 0xEA82),(0x1000, 0xEA92),(0x1000, 0xEAA2),(0x1000, 0xEAB2),(0x1000, 0xEAC2),(0x1000, 0xEAD2),(0x1000, 0xEAE2),(0x1000, 0xEAF2),(0x1000, 0xEB02),(0x1000, 0xEB12),(0x1000, 0xEB22),(0x1000, 0xEB32),(0x1000, 0xEB42),(0x1000, 0xEB52),(0x1000, 0xEB62),(0x1000, 0xEB72),(0x1000, 0xEB82),(0x1000, 0xEB92),(0x1000, 0xEBA2),(0x1000, 0xEBB2),(0x1000, 0xEBC2),(0x1000, 0xEBD2),(0x1000, 0xEBE2),(0x1000, 0xEBF2),(0x1000, 0xEC02),(0x1000, 0xEC12),(0x1000, 0xEC22),(0x1000, 0xEC32),(0x1000, 0xEC42),(0x1000, 0xEC52),(0x1000, 0xEC62),(0x1000, 0xEC72),(0x1000, 0xEC82),(0x1000, 0xEC92),(0x1000, 0xECA2),(0x1000, 0xECB2),(0x1000, 0xECC2),(0x1000, 0xECD2),(0x1000, 0xECE2),(0x1000, 0xECF2),(0x1000, 0xED02),(0x1000, 0xED12),(0x1000, 0xED22),(0x1000, 0xED32),(0x1000, 0xED42),(0x1000, 0xED52),(0x1000, 0xED62),(0x1000, 0xED72),(0x1000, 0xED82),(0x1000, 0xED92),(0x1000, 0xEDA2),(0x1000, 0xEDB2),(0x1000, 0xEDC2),(0x1000, 0xEDD2),(0x1000, 0xEDE2),(0x1000, 0xEDF2),(0x1000, 0xEE02),(0x1000, 0xEE12),(0x1000, 0xEE22),(0x1000, 0xEE32),(0x1000, 0xEE42),(0x1000, 0xEE52),(0x1000, 0xEE62),(0x1000, 0xEE72),(0x1000, 0xEE82),(0x1000, 0xEE92),(0x1000, 0xEEA2),(0x1000, 0xEEB2),(0x1000, 0xEEC2),(0x1000, 0xEED2),(0x1000, 0xEEE2),(0x1000, 0xEEF2),(0x1000, 0xEF02),(0x1000, 0xEF12),(0x1000, 0xEF22),(0x1000, 0xEF32),(0x1000, 0xEF42),(0x1000, 0xEF52),(0x1000, 0xEF62),(0x1000, 0xEF72),(0x1000, 0xEF82),(0x1000, 0xEF92),(0x1000, 0xEFA2),(0x1000, 0xEFB2),(0x1000, 0xEFC2),(0x1000, 0xEFD2),(0x1000, 0xEFE2),(0x1000, 0xEFF2),(0x1000, 0xF002),(0x1000, 0xF012),(0x1000, 0xF022),(0x1000, 0xF032),(0x1000, 0xF042),(0x1000, 0xF052),(0x1000, 0xF062),(0x1000, 0xF072),(0x1000, 0xF082),(0x1000, 0xF092),(0x1000, 0xF0A2),(0x1000, 0xF0B2),(0x1000, 0xF0C2),(0x1000, 0xF0D2),(0x1000, 0xF0E2),(0x1000, 0xF0F2),(0x1000, 0xF102),(0x1000, 0xF112),(0x1000, 0xF122),(0x1000, 0xF132),(0x1000, 0xF142),(0x1000, 0xF152),(0x1000, 0xF162),(0x1000, 0xF172),(0x1000, 0xF182),(0x1000, 0xF192),(0x1000, 0xF1A2),(0x1000, 0xF1B2),(0x1000, 0xF1C2),(0x1000, 0xF1D2),(0x1000, 0xF1E2),(0x1000, 0xF1F2),(0x1000, 0xF202),(0x1000, 0xF212),(0x1000, 0xF222),(0x1000, 0xF232),(0x1000, 0xF242),(0x1000, 0xF252),(0x1000, 0xF262),(0x1000, 0xF272),(0x1000, 0xF282),(0x1000, 0xF292),(0x1000, 0xF2A2),(0x1000, 0xF2B2),(0x1000, 0xF2C2),(0x1000, 0xF2D2),(0x1000, 0xF2E2),(0x1000, 0xF2F2),(0x1000, 0xF302),(0x1000, 0xF312),(0x1000, 0xF322),(0x1000, 0xF332),(0x1000, 0xF342),(0x1000, 0xF352),(0x1000, 0xF362),(0x1000, 0xF372),(0x1000, 0xF382),(0x1000, 0xF392),(0x1000, 0xF3A2),(0x1000, 0xF3B2),(0x1000, 0xF3C2),(0x1000, 0xF3D2),(0x1000, 0xF3E2),(0x1000, 0xF3F2),(0x1000, 0xF402),(0x1000, 0xF412),(0x1000, 0xF422),(0x1000, 0xF432),(0x1000, 0xF442),(0x1000, 0xF452),(0x1000, 0xF462),(0x1000, 0xF472),(0x1000, 0xF482),(0x1000, 0xF492),(0x1000, 0xF4A2),(0x1000, 0xF4B2),(0x1000, 0xF4C2),(0x1000, 0xF4D2),(0x1000, 0xF4E2),(0x1000, 0xF4F2),(0x1000, 0xF502),(0x1000, 0xF512),(0x1000, 0xF522),(0x1000, 0xF532),(0x1000, 0xF542),(0x1000, 0xF552),(0x1000, 0xF562),(0x1000, 0xF572),(0x1000, 0xF582),(0x1000, 0xF592),(0x1000, 0xF5A2),(0x1000, 0xF5B2),(0x1000, 0xF5C2),(0x1000, 0xF5D2),(0x1000, 0xF5E2),(0x1000, 0xF5F2),(0x1000, 0xF602),(0x1000, 0xF612),(0x1000, 0xF622),(0x1000, 0xF632),(0x1000, 0xF642),(0x1000, 0xF652),(0x1000, 0xF662),(0x1000, 0xF672),(0x1000, 0xF682),(0x1000, 0xF692),(0x1000, 0xF6A2),(0x1000, 0xF6B2),(0x1000, 0xF6C2),(0x1000, 0xF6D2),(0x1000, 0xF6E2),(0x1000, 0xF6F2),(0x1000, 0xF702),(0x1000, 0xF712),(0x1000, 0xF722),(0x1000, 0xF732),(0x1000, 0xF742),(0x1000, 0xF752),(0x1000, 0xF762),(0x1000, 0xF772),(0x1000, 0xF782),(0x1000, 0xF792),(0x1000, 0xF7A2),(0x1000, 0xF7B2),(0x1000, 0xF7C2),(0x1000, 0xF7D2),(0x1000, 0xF7E2),(0x1000, 0xF7F2),(0x1000, 0xF802),(0x1000, 0xF812),(0x1000, 0xF822),(0x1000, 0xF832),(0x1000, 0xF842),(0x1000, 0xF852),(0x1000, 0xF862),(0x1000, 0xF872),(0x1000, 0xF882),(0x1000, 0xF892),(0x1000, 0xF8A2),(0x1000, 0xF8B2),(0x1000, 0xF8C2),(0x1000, 0xF8D2),(0x1000, 0xF8E2),(0x1000, 0xF8F2),(0x1000, 0xF902),(0x1000, 0xF912),(0x1000, 0xF922),(0x1000, 0xF932),(0x1000, 0xF942),(0x1000, 0xF952),(0x1000, 0xF962),(0x1000, 0xF972),(0x1000, 0xF982),(0x1000, 0xF992),(0x1000, 0xF9A2),(0x1000, 0xF9B2),(0x1000, 0xF9C2),(0x1000, 0xF9D2),(0x1000, 0xF9E2),(0x1000, 0xF9F2),(0x1000, 0xFA02),(0x1000, 0xFA12),(0x1000, 0xFA22),(0x1000, 0xFA32),(0x1000, 0xFA42),(0x1000, 0xFA52),(0x1000, 0xFA62),(0x1000, 0xFA72),(0x1000, 0xFA82),(0x1000, 0xFA92),(0x1000, 0xFAA2),(0x1000, 0xFAB2),(0x1000, 0xFAC2),(0x1000, 0xFAD2),(0x1000, 0xFAE2),(0x1000, 0xFAF2),(0x1000, 0xFB02),(0x1000, 0xFB12),(0x1000, 0xFB22),(0x1000, 0xFB32),(0x1000, 0xFB42),(0x1000, 0xFB52),(0x1000, 0xFB62),(0x1000, 0xFB72),(0x1000, 0xFB82),(0x1000, 0xFB92),(0x1000, 0xFBA2),(0x1000, 0xFBB2),(0x1000, 0xFBC2),(0x1000, 0xFBD2),(0x1000, 0xFBE2),(0x1000, 0xFBF2),(0x1000, 0xFC02),(0x1000, 0xFC12),(0x1000, 0xFC22),(0x1000, 0xFC32),(0x1000, 0xFC42),(0x1000, 0xFC52),(0x1000, 0xFC62),(0x1000, 0xFC72),(0x1000, 0xFC82),(0x1000, 0xFC92),(0x1000, 0xFCA2),(0x1000, 0xFCB2),(0x1000, 0xFCC2),(0x1000, 0xFCD2),(0x1000, 0xFCE2),(0x1000, 0xFCF2),(0x1000, 0xFD02),(0x1000, 0xFD12),(0x1000, 0xFD22),(0x1000, 0xFD32),(0x1000, 0xFD42),(0x1000, 0xFD52),(0x1000, 0xFD62),(0x1000, 0xFD72),(0x1000, 0xFD82),(0x1000, 0xFD92),(0x1000, 0xFDA2),(0x1000, 0xFDB2),(0x1000, 0xFDC2),(0x1000, 0xFDD2),(0x1000, 0xFDE2),(0x1000, 0xFDF2),(0x1000, 0xFE02),(0x1000, 0xFE12),(0x1000, 0xFE22),(0x1000, 0xFE32),(0x1000, 0xFE42),(0x1000, 0xFE52),(0x1000, 0xFE62),(0x1000, 0xFE72),(0x1000, 0xFE82),(0x1000, 0xFE92),(0x1000, 0xFEA2),(0x1000, 0xFEB2),(0x1000, 0xFEC2),(0x1000, 0xFED2),(0x1000, 0xFEE2),(0x1000, 0xFEF2),(0x1000, 0xFF02),(0x1000, 0xFF12),(0x1000, 0xFF22),(0x1000, 0xFF32),(0x1000, 0xFF42),(0x1000, 0xFF52),(0x1000, 0xFF62),(0x1000, 0xFF72),(0x1000, 0xFF82),(0x1000, 0xFF92),(0x1000, 0xFFA2),(0x1000, 0xFFB2),(0x1000, 0xFFC2),(0x1000, 0xFFD2),(0x1000, 0xFFE2),(0x1000, 0xFFF2),])
    HuffmanTableTriplet = Tag('Huffman Table Triplet', "HuffmanTableTriplet", 0x1000, 0x0003, [], [(0x1000, 0x0013),(0x1000, 0x0023),(0x1000, 0x0033),(0x1000, 0x0043),(0x1000, 0x0053),(0x1000, 0x0063),(0x1000, 0x0073),(0x1000, 0x0083),(0x1000, 0x0093),(0x1000, 0x00A3),(0x1000, 0x00B3),(0x1000, 0x00C3),(0x1000, 0x00D3),(0x1000, 0x00E3),(0x1000, 0x00F3),(0x1000, 0x0103),(0x1000, 0x0113),(0x1000, 0x0123),(0x1000, 0x0133),(0x1000, 0x0143),(0x1000, 0x0153),(0x1000, 0x0163),(0x1000, 0x0173),(0x1000, 0x0183),(0x1000, 0x0193),(0x1000, 0x01A3),(0x1000, 0x01B3),(0x1000, 0x01C3),(0x1000, 0x01D3),(0x1000, 0x01E3),(0x1000, 0x01F3),(0x1000, 0x0203),(0x1000, 0x0213),(0x1000, 0x0223),(0x1000, 0x0233),(0x1000, 0x0243),(0x1000, 0x0253),(0x1000, 0x0263),(0x1000, 0x0273),(0x1000, 0x0283),(0x1000, 0x0293),(0x1000, 0x02A3),(0x1000, 0x02B3),(0x1000, 0x02C3),(0x1000, 0x02D3),(0x1000, 0x02E3),(0x1000, 0x02F3),(0x1000, 0x0303),(0x1000, 0x0313),(0x1000, 0x0323),(0x1000, 0x0333),(0x1000, 0x0343),(0x1000, 0x0353),(0x1000, 0x0363),(0x1000, 0x0373),(0x1000, 0x0383),(0x1000, 0x0393),(0x1000, 0x03A3),(0x1000, 0x03B3),(0x1000, 0x03C3),(0x1000, 0x03D3),(0x1000, 0x03E3),(0x1000, 0x03F3),(0x1000, 0x0403),(0x1000, 0x0413),(0x1000, 0x0423),(0x1000, 0x0433),(0x1000, 0x0443),(0x1000, 0x0453),(0x1000, 0x0463),(0x1000, 0x0473),(0x1000, 0x0483),(0x1000, 0x0493),(0x1000, 0x04A3),(0x1000, 0x04B3),(0x1000, 0x04C3),(0x1000, 0x04D3),(0x1000, 0x04E3),(0x1000, 0x04F3),(0x1000, 0x0503),(0x1000, 0x0513),(0x1000, 0x0523),(0x1000, 0x0533),(0x1000, 0x0543),(0x1000, 0x0553),(0x1000, 0x0563),(0x1000, 0x0573),(0x1000, 0x0583),(0x1000, 0x0593),(0x1000, 0x05A3),(0x1000, 0x05B3),(0x1000, 0x05C3),(0x1000, 0x05D3),(0x1000, 0x05E3),(0x1000, 0x05F3),(0x1000, 0x0603),(0x1000, 0x0613),(0x1000, 0x0623),(0x1000, 0x0633),(0x1000, 0x0643),(0x1000, 0x0653),(0x1000, 0x0663),(0x1000, 0x0673),(0x1000, 0x0683),(0x1000, 0x0693),(0x1000, 0x06A3),(0x1000, 0x06B3),(0x1000, 0x06C3),(0x1000, 0x06D3),(0x1000, 0x06E3),(0x1000, 0x06F3),(0x1000, 0x0703),(0x1000, 0x0713),(0x1000, 0x0723),(0x1000, 0x0733),(0x1000, 0x0743),(0x1000, 0x0753),(0x1000, 0x0763),(0x1000, 0x0773),(0x1000, 0x0783),(0x1000, 0x0793),(0x1000, 0x07A3),(0x1000, 0x07B3),(0x1000, 0x07C3),(0x1000, 0x07D3),(0x1000, 0x07E3),(0x1000, 0x07F3),(0x1000, 0x0803),(0x1000, 0x0813),(0x1000, 0x0823),(0x1000, 0x0833),(0x1000, 0x0843),(0x1000, 0x0853),(0x1000, 0x0863),(0x1000, 0x0873),(0x1000, 0x0883),(0x1000, 0x0893),(0x1000, 0x08A3),(0x1000, 0x08B3),(0x1000, 0x08C3),(0x1000, 0x08D3),(0x1000, 0x08E3),(0x1000, 0x08F3),(0x1000, 0x0903),(0x1000, 0x0913),(0x1000, 0x0923),(0x1000, 0x0933),(0x1000, 0x0943),(0x1000, 0x0953),(0x1000, 0x0963),(0x1000, 0x0973),(0x1000, 0x0983),(0x1000, 0x0993),(0x1000, 0x09A3),(0x1000, 0x09B3),(0x1000, 0x09C3),(0x1000, 0x09D3),(0x1000, 0x09E3),(0x1000, 0x09F3),(0x1000, 0x0A03),(0x1000, 0x0A13),(0x1000, 0x0A23),(0x1000, 0x0A33),(0x1000, 0x0A43),(0x1000, 0x0A53),(0x1000, 0x0A63),(0x1000, 0x0A73),(0x1000, 0x0A83),(0x1000, 0x0A93),(0x1000, 0x0AA3),(0x1000, 0x0AB3),(0x1000, 0x0AC3),(0x1000, 0x0AD3),(0x1000, 0x0AE3),(0x1000, 0x0AF3),(0x1000, 0x0B03),(0x1000, 0x0B13),(0x1000, 0x0B23),(0x1000, 0x0B33),(0x1000, 0x0B43),(0x1000, 0x0B53),(0x1000, 0x0B63),(0x1000, 0x0B73),(0x1000, 0x0B83),(0x1000, 0x0B93),(0x1000, 0x0BA3),(0x1000, 0x0BB3),(0x1000, 0x0BC3),(0x1000, 0x0BD3),(0x1000, 0x0BE3),(0x1000, 0x0BF3),(0x1000, 0x0C03),(0x1000, 0x0C13),(0x1000, 0x0C23),(0x1000, 0x0C33),(0x1000, 0x0C43),(0x1000, 0x0C53),(0x1000, 0x0C63),(0x1000, 0x0C73),(0x1000, 0x0C83),(0x1000, 0x0C93),(0x1000, 0x0CA3),(0x1000, 0x0CB3),(0x1000, 0x0CC3),(0x1000, 0x0CD3),(0x1000, 0x0CE3),(0x1000, 0x0CF3),(0x1000, 0x0D03),(0x1000, 0x0D13),(0x1000, 0x0D23),(0x1000, 0x0D33),(0x1000, 0x0D43),(0x1000, 0x0D53),(0x1000, 0x0D63),(0x1000, 0x0D73),(0x1000, 0x0D83),(0x1000, 0x0D93),(0x1000, 0x0DA3),(0x1000, 0x0DB3),(0x1000, 0x0DC3),(0x1000, 0x0DD3),(0x1000, 0x0DE3),(0x1000, 0x0DF3),(0x1000, 0x0E03),(0x1000, 0x0E13),(0x1000, 0x0E23),(0x1000, 0x0E33),(0x1000, 0x0E43),(0x1000, 0x0E53),(0x1000, 0x0E63),(0x1000, 0x0E73),(0x1000, 0x0E83),(0x1000, 0x0E93),(0x1000, 0x0EA3),(0x1000, 0x0EB3),(0x1000, 0x0EC3),(0x1000, 0x0ED3),(0x1000, 0x0EE3),(0x1000, 0x0EF3),(0x1000, 0x0F03),(0x1000, 0x0F13),(0x1000, 0x0F23),(0x1000, 0x0F33),(0x1000, 0x0F43),(0x1000, 0x0F53),(0x1000, 0x0F63),(0x1000, 0x0F73),(0x1000, 0x0F83),(0x1000, 0x0F93),(0x1000, 0x0FA3),(0x1000, 0x0FB3),(0x1000, 0x0FC3),(0x1000, 0x0FD3),(0x1000, 0x0FE3),(0x1000, 0x0FF3),(0x1000, 0x1003),(0x1000, 0x1013),(0x1000, 0x1023),(0x1000, 0x1033),(0x1000, 0x1043),(0x1000, 0x1053),(0x1000, 0x1063),(0x1000, 0x1073),(0x1000, 0x1083),(0x1000, 0x1093),(0x1000, 0x10A3),(0x1000, 0x10B3),(0x1000, 0x10C3),(0x1000, 0x10D3),(0x1000, 0x10E3),(0x1000, 0x10F3),(0x1000, 0x1103),(0x1000, 0x1113),(0x1000, 0x1123),(0x1000, 0x1133),(0x1000, 0x1143),(0x1000, 0x1153),(0x1000, 0x1163),(0x1000, 0x1173),(0x1000, 0x1183),(0x1000, 0x1193),(0x1000, 0x11A3),(0x1000, 0x11B3),(0x1000, 0x11C3),(0x1000, 0x11D3),(0x1000, 0x11E3),(0x1000, 0x11F3),(0x1000, 0x1203),(0x1000, 0x1213),(0x1000, 0x1223),(0x1000, 0x1233),(0x1000, 0x1243),(0x1000, 0x1253),(0x1000, 0x1263),(0x1000, 0x1273),(0x1000, 0x1283),(0x1000, 0x1293),(0x1000, 0x12A3),(0x1000, 0x12B3),(0x1000, 0x12C3),(0x1000, 0x12D3),(0x1000, 0x12E3),(0x1000, 0x12F3),(0x1000, 0x1303),(0x1000, 0x1313),(0x1000, 0x1323),(0x1000, 0x1333),(0x1000, 0x1343),(0x1000, 0x1353),(0x1000, 0x1363),(0x1000, 0x1373),(0x1000, 0x1383),(0x1000, 0x1393),(0x1000, 0x13A3),(0x1000, 0x13B3),(0x1000, 0x13C3),(0x1000, 0x13D3),(0x1000, 0x13E3),(0x1000, 0x13F3),(0x1000, 0x1403),(0x1000, 0x1413),(0x1000, 0x1423),(0x1000, 0x1433),(0x1000, 0x1443),(0x1000, 0x1453),(0x1000, 0x1463),(0x1000, 0x1473),(0x1000, 0x1483),(0x1000, 0x1493),(0x1000, 0x14A3),(0x1000, 0x14B3),(0x1000, 0x14C3),(0x1000, 0x14D3),(0x1000, 0x14E3),(0x1000, 0x14F3),(0x1000, 0x1503),(0x1000, 0x1513),(0x1000, 0x1523),(0x1000, 0x1533),(0x1000, 0x1543),(0x1000, 0x1553),(0x1000, 0x1563),(0x1000, 0x1573),(0x1000, 0x1583),(0x1000, 0x1593),(0x1000, 0x15A3),(0x1000, 0x15B3),(0x1000, 0x15C3),(0x1000, 0x15D3),(0x1000, 0x15E3),(0x1000, 0x15F3),(0x1000, 0x1603),(0x1000, 0x1613),(0x1000, 0x1623),(0x1000, 0x1633),(0x1000, 0x1643),(0x1000, 0x1653),(0x1000, 0x1663),(0x1000, 0x1673),(0x1000, 0x1683),(0x1000, 0x1693),(0x1000, 0x16A3),(0x1000, 0x16B3),(0x1000, 0x16C3),(0x1000, 0x16D3),(0x1000, 0x16E3),(0x1000, 0x16F3),(0x1000, 0x1703),(0x1000, 0x1713),(0x1000, 0x1723),(0x1000, 0x1733),(0x1000, 0x1743),(0x1000, 0x1753),(0x1000, 0x1763),(0x1000, 0x1773),(0x1000, 0x1783),(0x1000, 0x1793),(0x1000, 0x17A3),(0x1000, 0x17B3),(0x1000, 0x17C3),(0x1000, 0x17D3),(0x1000, 0x17E3),(0x1000, 0x17F3),(0x1000, 0x1803),(0x1000, 0x1813),(0x1000, 0x1823),(0x1000, 0x1833),(0x1000, 0x1843),(0x1000, 0x1853),(0x1000, 0x1863),(0x1000, 0x1873),(0x1000, 0x1883),(0x1000, 0x1893),(0x1000, 0x18A3),(0x1000, 0x18B3),(0x1000, 0x18C3),(0x1000, 0x18D3),(0x1000, 0x18E3),(0x1000, 0x18F3),(0x1000, 0x1903),(0x1000, 0x1913),(0x1000, 0x1923),(0x1000, 0x1933),(0x1000, 0x1943),(0x1000, 0x1953),(0x1000, 0x1963),(0x1000, 0x1973),(0x1000, 0x1983),(0x1000, 0x1993),(0x1000, 0x19A3),(0x1000, 0x19B3),(0x1000, 0x19C3),(0x1000, 0x19D3),(0x1000, 0x19E3),(0x1000, 0x19F3),(0x1000, 0x1A03),(0x1000, 0x1A13),(0x1000, 0x1A23),(0x1000, 0x1A33),(0x1000, 0x1A43),(0x1000, 0x1A53),(0x1000, 0x1A63),(0x1000, 0x1A73),(0x1000, 0x1A83),(0x1000, 0x1A93),(0x1000, 0x1AA3),(0x1000, 0x1AB3),(0x1000, 0x1AC3),(0x1000, 0x1AD3),(0x1000, 0x1AE3),(0x1000, 0x1AF3),(0x1000, 0x1B03),(0x1000, 0x1B13),(0x1000, 0x1B23),(0x1000, 0x1B33),(0x1000, 0x1B43),(0x1000, 0x1B53),(0x1000, 0x1B63),(0x1000, 0x1B73),(0x1000, 0x1B83),(0x1000, 0x1B93),(0x1000, 0x1BA3),(0x1000, 0x1BB3),(0x1000, 0x1BC3),(0x1000, 0x1BD3),(0x1000, 0x1BE3),(0x1000, 0x1BF3),(0x1000, 0x1C03),(0x1000, 0x1C13),(0x1000, 0x1C23),(0x1000, 0x1C33),(0x1000, 0x1C43),(0x1000, 0x1C53),(0x1000, 0x1C63),(0x1000, 0x1C73),(0x1000, 0x1C83),(0x1000, 0x1C93),(0x1000, 0x1CA3),(0x1000, 0x1CB3),(0x1000, 0x1CC3),(0x1000, 0x1CD3),(0x1000, 0x1CE3),(0x1000, 0x1CF3),(0x1000, 0x1D03),(0x1000, 0x1D13),(0x1000, 0x1D23),(0x1000, 0x1D33),(0x1000, 0x1D43),(0x1000, 0x1D53),(0x1000, 0x1D63),(0x1000, 0x1D73),(0x1000, 0x1D83),(0x1000, 0x1D93),(0x1000, 0x1DA3),(0x1000, 0x1DB3),(0x1000, 0x1DC3),(0x1000, 0x1DD3),(0x1000, 0x1DE3),(0x1000, 0x1DF3),(0x1000, 0x1E03),(0x1000, 0x1E13),(0x1000, 0x1E23),(0x1000, 0x1E33),(0x1000, 0x1E43),(0x1000, 0x1E53),(0x1000, 0x1E63),(0x1000, 0x1E73),(0x1000, 0x1E83),(0x1000, 0x1E93),(0x1000, 0x1EA3),(0x1000, 0x1EB3),(0x1000, 0x1EC3),(0x1000, 0x1ED3),(0x1000, 0x1EE3),(0x1000, 0x1EF3),(0x1000, 0x1F03),(0x1000, 0x1F13),(0x1000, 0x1F23),(0x1000, 0x1F33),(0x1000, 0x1F43),(0x1000, 0x1F53),(0x1000, 0x1F63),(0x1000, 0x1F73),(0x1000, 0x1F83),(0x1000, 0x1F93),(0x1000, 0x1FA3),(0x1000, 0x1FB3),(0x1000, 0x1FC3),(0x1000, 0x1FD3),(0x1000, 0x1FE3),(0x1000, 0x1FF3),(0x1000, 0x2003),(0x1000, 0x2013),(0x1000, 0x2023),(0x1000, 0x2033),(0x1000, 0x2043),(0x1000, 0x2053),(0x1000, 0x2063),(0x1000, 0x2073),(0x1000, 0x2083),(0x1000, 0x2093),(0x1000, 0x20A3),(0x1000, 0x20B3),(0x1000, 0x20C3),(0x1000, 0x20D3),(0x1000, 0x20E3),(0x1000, 0x20F3),(0x1000, 0x2103),(0x1000, 0x2113),(0x1000, 0x2123),(0x1000, 0x2133),(0x1000, 0x2143),(0x1000, 0x2153),(0x1000, 0x2163),(0x1000, 0x2173),(0x1000, 0x2183),(0x1000, 0x2193),(0x1000, 0x21A3),(0x1000, 0x21B3),(0x1000, 0x21C3),(0x1000, 0x21D3),(0x1000, 0x21E3),(0x1000, 0x21F3),(0x1000, 0x2203),(0x1000, 0x2213),(0x1000, 0x2223),(0x1000, 0x2233),(0x1000, 0x2243),(0x1000, 0x2253),(0x1000, 0x2263),(0x1000, 0x2273),(0x1000, 0x2283),(0x1000, 0x2293),(0x1000, 0x22A3),(0x1000, 0x22B3),(0x1000, 0x22C3),(0x1000, 0x22D3),(0x1000, 0x22E3),(0x1000, 0x22F3),(0x1000, 0x2303),(0x1000, 0x2313),(0x1000, 0x2323),(0x1000, 0x2333),(0x1000, 0x2343),(0x1000, 0x2353),(0x1000, 0x2363),(0x1000, 0x2373),(0x1000, 0x2383),(0x1000, 0x2393),(0x1000, 0x23A3),(0x1000, 0x23B3),(0x1000, 0x23C3),(0x1000, 0x23D3),(0x1000, 0x23E3),(0x1000, 0x23F3),(0x1000, 0x2403),(0x1000, 0x2413),(0x1000, 0x2423),(0x1000, 0x2433),(0x1000, 0x2443),(0x1000, 0x2453),(0x1000, 0x2463),(0x1000, 0x2473),(0x1000, 0x2483),(0x1000, 0x2493),(0x1000, 0x24A3),(0x1000, 0x24B3),(0x1000, 0x24C3),(0x1000, 0x24D3),(0x1000, 0x24E3),(0x1000, 0x24F3),(0x1000, 0x2503),(0x1000, 0x2513),(0x1000, 0x2523),(0x1000, 0x2533),(0x1000, 0x2543),(0x1000, 0x2553),(0x1000, 0x2563),(0x1000, 0x2573),(0x1000, 0x2583),(0x1000, 0x2593),(0x1000, 0x25A3),(0x1000, 0x25B3),(0x1000, 0x25C3),(0x1000, 0x25D3),(0x1000, 0x25E3),(0x1000, 0x25F3),(0x1000, 0x2603),(0x1000, 0x2613),(0x1000, 0x2623),(0x1000, 0x2633),(0x1000, 0x2643),(0x1000, 0x2653),(0x1000, 0x2663),(0x1000, 0x2673),(0x1000, 0x2683),(0x1000, 0x2693),(0x1000, 0x26A3),(0x1000, 0x26B3),(0x1000, 0x26C3),(0x1000, 0x26D3),(0x1000, 0x26E3),(0x1000, 0x26F3),(0x1000, 0x2703),(0x1000, 0x2713),(0x1000, 0x2723),(0x1000, 0x2733),(0x1000, 0x2743),(0x1000, 0x2753),(0x1000, 0x2763),(0x1000, 0x2773),(0x1000, 0x2783),(0x1000, 0x2793),(0x1000, 0x27A3),(0x1000, 0x27B3),(0x1000, 0x27C3),(0x1000, 0x27D3),(0x1000, 0x27E3),(0x1000, 0x27F3),(0x1000, 0x2803),(0x1000, 0x2813),(0x1000, 0x2823),(0x1000, 0x2833),(0x1000, 0x2843),(0x1000, 0x2853),(0x1000, 0x2863),(0x1000, 0x2873),(0x1000, 0x2883),(0x1000, 0x2893),(0x1000, 0x28A3),(0x1000, 0x28B3),(0x1000, 0x28C3),(0x1000, 0x28D3),(0x1000, 0x28E3),(0x1000, 0x28F3),(0x1000, 0x2903),(0x1000, 0x2913),(0x1000, 0x2923),(0x1000, 0x2933),(0x1000, 0x2943),(0x1000, 0x2953),(0x1000, 0x2963),(0x1000, 0x2973),(0x1000, 0x2983),(0x1000, 0x2993),(0x1000, 0x29A3),(0x1000, 0x29B3),(0x1000, 0x29C3),(0x1000, 0x29D3),(0x1000, 0x29E3),(0x1000, 0x29F3),(0x1000, 0x2A03),(0x1000, 0x2A13),(0x1000, 0x2A23),(0x1000, 0x2A33),(0x1000, 0x2A43),(0x1000, 0x2A53),(0x1000, 0x2A63),(0x1000, 0x2A73),(0x1000, 0x2A83),(0x1000, 0x2A93),(0x1000, 0x2AA3),(0x1000, 0x2AB3),(0x1000, 0x2AC3),(0x1000, 0x2AD3),(0x1000, 0x2AE3),(0x1000, 0x2AF3),(0x1000, 0x2B03),(0x1000, 0x2B13),(0x1000, 0x2B23),(0x1000, 0x2B33),(0x1000, 0x2B43),(0x1000, 0x2B53),(0x1000, 0x2B63),(0x1000, 0x2B73),(0x1000, 0x2B83),(0x1000, 0x2B93),(0x1000, 0x2BA3),(0x1000, 0x2BB3),(0x1000, 0x2BC3),(0x1000, 0x2BD3),(0x1000, 0x2BE3),(0x1000, 0x2BF3),(0x1000, 0x2C03),(0x1000, 0x2C13),(0x1000, 0x2C23),(0x1000, 0x2C33),(0x1000, 0x2C43),(0x1000, 0x2C53),(0x1000, 0x2C63),(0x1000, 0x2C73),(0x1000, 0x2C83),(0x1000, 0x2C93),(0x1000, 0x2CA3),(0x1000, 0x2CB3),(0x1000, 0x2CC3),(0x1000, 0x2CD3),(0x1000, 0x2CE3),(0x1000, 0x2CF3),(0x1000, 0x2D03),(0x1000, 0x2D13),(0x1000, 0x2D23),(0x1000, 0x2D33),(0x1000, 0x2D43),(0x1000, 0x2D53),(0x1000, 0x2D63),(0x1000, 0x2D73),(0x1000, 0x2D83),(0x1000, 0x2D93),(0x1000, 0x2DA3),(0x1000, 0x2DB3),(0x1000, 0x2DC3),(0x1000, 0x2DD3),(0x1000, 0x2DE3),(0x1000, 0x2DF3),(0x1000, 0x2E03),(0x1000, 0x2E13),(0x1000, 0x2E23),(0x1000, 0x2E33),(0x1000, 0x2E43),(0x1000, 0x2E53),(0x1000, 0x2E63),(0x1000, 0x2E73),(0x1000, 0x2E83),(0x1000, 0x2E93),(0x1000, 0x2EA3),(0x1000, 0x2EB3),(0x1000, 0x2EC3),(0x1000, 0x2ED3),(0x1000, 0x2EE3),(0x1000, 0x2EF3),(0x1000, 0x2F03),(0x1000, 0x2F13),(0x1000, 0x2F23),(0x1000, 0x2F33),(0x1000, 0x2F43),(0x1000, 0x2F53),(0x1000, 0x2F63),(0x1000, 0x2F73),(0x1000, 0x2F83),(0x1000, 0x2F93),(0x1000, 0x2FA3),(0x1000, 0x2FB3),(0x1000, 0x2FC3),(0x1000, 0x2FD3),(0x1000, 0x2FE3),(0x1000, 0x2FF3),(0x1000, 0x3003),(0x1000, 0x3013),(0x1000, 0x3023),(0x1000, 0x3033),(0x1000, 0x3043),(0x1000, 0x3053),(0x1000, 0x3063),(0x1000, 0x3073),(0x1000, 0x3083),(0x1000, 0x3093),(0x1000, 0x30A3),(0x1000, 0x30B3),(0x1000, 0x30C3),(0x1000, 0x30D3),(0x1000, 0x30E3),(0x1000, 0x30F3),(0x1000, 0x3103),(0x1000, 0x3113),(0x1000, 0x3123),(0x1000, 0x3133),(0x1000, 0x3143),(0x1000, 0x3153),(0x1000, 0x3163),(0x1000, 0x3173),(0x1000, 0x3183),(0x1000, 0x3193),(0x1000, 0x31A3),(0x1000, 0x31B3),(0x1000, 0x31C3),(0x1000, 0x31D3),(0x1000, 0x31E3),(0x1000, 0x31F3),(0x1000, 0x3203),(0x1000, 0x3213),(0x1000, 0x3223),(0x1000, 0x3233),(0x1000, 0x3243),(0x1000, 0x3253),(0x1000, 0x3263),(0x1000, 0x3273),(0x1000, 0x3283),(0x1000, 0x3293),(0x1000, 0x32A3),(0x1000, 0x32B3),(0x1000, 0x32C3),(0x1000, 0x32D3),(0x1000, 0x32E3),(0x1000, 0x32F3),(0x1000, 0x3303),(0x1000, 0x3313),(0x1000, 0x3323),(0x1000, 0x3333),(0x1000, 0x3343),(0x1000, 0x3353),(0x1000, 0x3363),(0x1000, 0x3373),(0x1000, 0x3383),(0x1000, 0x3393),(0x1000, 0x33A3),(0x1000, 0x33B3),(0x1000, 0x33C3),(0x1000, 0x33D3),(0x1000, 0x33E3),(0x1000, 0x33F3),(0x1000, 0x3403),(0x1000, 0x3413),(0x1000, 0x3423),(0x1000, 0x3433),(0x1000, 0x3443),(0x1000, 0x3453),(0x1000, 0x3463),(0x1000, 0x3473),(0x1000, 0x3483),(0x1000, 0x3493),(0x1000, 0x34A3),(0x1000, 0x34B3),(0x1000, 0x34C3),(0x1000, 0x34D3),(0x1000, 0x34E3),(0x1000, 0x34F3),(0x1000, 0x3503),(0x1000, 0x3513),(0x1000, 0x3523),(0x1000, 0x3533),(0x1000, 0x3543),(0x1000, 0x3553),(0x1000, 0x3563),(0x1000, 0x3573),(0x1000, 0x3583),(0x1000, 0x3593),(0x1000, 0x35A3),(0x1000, 0x35B3),(0x1000, 0x35C3),(0x1000, 0x35D3),(0x1000, 0x35E3),(0x1000, 0x35F3),(0x1000, 0x3603),(0x1000, 0x3613),(0x1000, 0x3623),(0x1000, 0x3633),(0x1000, 0x3643),(0x1000, 0x3653),(0x1000, 0x3663),(0x1000, 0x3673),(0x1000, 0x3683),(0x1000, 0x3693),(0x1000, 0x36A3),(0x1000, 0x36B3),(0x1000, 0x36C3),(0x1000, 0x36D3),(0x1000, 0x36E3),(0x1000, 0x36F3),(0x1000, 0x3703),(0x1000, 0x3713),(0x1000, 0x3723),(0x1000, 0x3733),(0x1000, 0x3743),(0x1000, 0x3753),(0x1000, 0x3763),(0x1000, 0x3773),(0x1000, 0x3783),(0x1000, 0x3793),(0x1000, 0x37A3),(0x1000, 0x37B3),(0x1000, 0x37C3),(0x1000, 0x37D3),(0x1000, 0x37E3),(0x1000, 0x37F3),(0x1000, 0x3803),(0x1000, 0x3813),(0x1000, 0x3823),(0x1000, 0x3833),(0x1000, 0x3843),(0x1000, 0x3853),(0x1000, 0x3863),(0x1000, 0x3873),(0x1000, 0x3883),(0x1000, 0x3893),(0x1000, 0x38A3),(0x1000, 0x38B3),(0x1000, 0x38C3),(0x1000, 0x38D3),(0x1000, 0x38E3),(0x1000, 0x38F3),(0x1000, 0x3903),(0x1000, 0x3913),(0x1000, 0x3923),(0x1000, 0x3933),(0x1000, 0x3943),(0x1000, 0x3953),(0x1000, 0x3963),(0x1000, 0x3973),(0x1000, 0x3983),(0x1000, 0x3993),(0x1000, 0x39A3),(0x1000, 0x39B3),(0x1000, 0x39C3),(0x1000, 0x39D3),(0x1000, 0x39E3),(0x1000, 0x39F3),(0x1000, 0x3A03),(0x1000, 0x3A13),(0x1000, 0x3A23),(0x1000, 0x3A33),(0x1000, 0x3A43),(0x1000, 0x3A53),(0x1000, 0x3A63),(0x1000, 0x3A73),(0x1000, 0x3A83),(0x1000, 0x3A93),(0x1000, 0x3AA3),(0x1000, 0x3AB3),(0x1000, 0x3AC3),(0x1000, 0x3AD3),(0x1000, 0x3AE3),(0x1000, 0x3AF3),(0x1000, 0x3B03),(0x1000, 0x3B13),(0x1000, 0x3B23),(0x1000, 0x3B33),(0x1000, 0x3B43),(0x1000, 0x3B53),(0x1000, 0x3B63),(0x1000, 0x3B73),(0x1000, 0x3B83),(0x1000, 0x3B93),(0x1000, 0x3BA3),(0x1000, 0x3BB3),(0x1000, 0x3BC3),(0x1000, 0x3BD3),(0x1000, 0x3BE3),(0x1000, 0x3BF3),(0x1000, 0x3C03),(0x1000, 0x3C13),(0x1000, 0x3C23),(0x1000, 0x3C33),(0x1000, 0x3C43),(0x1000, 0x3C53),(0x1000, 0x3C63),(0x1000, 0x3C73),(0x1000, 0x3C83),(0x1000, 0x3C93),(0x1000, 0x3CA3),(0x1000, 0x3CB3),(0x1000, 0x3CC3),(0x1000, 0x3CD3),(0x1000, 0x3CE3),(0x1000, 0x3CF3),(0x1000, 0x3D03),(0x1000, 0x3D13),(0x1000, 0x3D23),(0x1000, 0x3D33),(0x1000, 0x3D43),(0x1000, 0x3D53),(0x1000, 0x3D63),(0x1000, 0x3D73),(0x1000, 0x3D83),(0x1000, 0x3D93),(0x1000, 0x3DA3),(0x1000, 0x3DB3),(0x1000, 0x3DC3),(0x1000, 0x3DD3),(0x1000, 0x3DE3),(0x1000, 0x3DF3),(0x1000, 0x3E03),(0x1000, 0x3E13),(0x1000, 0x3E23),(0x1000, 0x3E33),(0x1000, 0x3E43),(0x1000, 0x3E53),(0x1000, 0x3E63),(0x1000, 0x3E73),(0x1000, 0x3E83),(0x1000, 0x3E93),(0x1000, 0x3EA3),(0x1000, 0x3EB3),(0x1000, 0x3EC3),(0x1000, 0x3ED3),(0x1000, 0x3EE3),(0x1000, 0x3EF3),(0x1000, 0x3F03),(0x1000, 0x3F13),(0x1000, 0x3F23),(0x1000, 0x3F33),(0x1000, 0x3F43),(0x1000, 0x3F53),(0x1000, 0x3F63),(0x1000, 0x3F73),(0x1000, 0x3F83),(0x1000, 0x3F93),(0x1000, 0x3FA3),(0x1000, 0x3FB3),(0x1000, 0x3FC3),(0x1000, 0x3FD3),(0x1000, 0x3FE3),(0x1000, 0x3FF3),(0x1000, 0x4003),(0x1000, 0x4013),(0x1000, 0x4023),(0x1000, 0x4033),(0x1000, 0x4043),(0x1000, 0x4053),(0x1000, 0x4063),(0x1000, 0x4073),(0x1000, 0x4083),(0x1000, 0x4093),(0x1000, 0x40A3),(0x1000, 0x40B3),(0x1000, 0x40C3),(0x1000, 0x40D3),(0x1000, 0x40E3),(0x1000, 0x40F3),(0x1000, 0x4103),(0x1000, 0x4113),(0x1000, 0x4123),(0x1000, 0x4133),(0x1000, 0x4143),(0x1000, 0x4153),(0x1000, 0x4163),(0x1000, 0x4173),(0x1000, 0x4183),(0x1000, 0x4193),(0x1000, 0x41A3),(0x1000, 0x41B3),(0x1000, 0x41C3),(0x1000, 0x41D3),(0x1000, 0x41E3),(0x1000, 0x41F3),(0x1000, 0x4203),(0x1000, 0x4213),(0x1000, 0x4223),(0x1000, 0x4233),(0x1000, 0x4243),(0x1000, 0x4253),(0x1000, 0x4263),(0x1000, 0x4273),(0x1000, 0x4283),(0x1000, 0x4293),(0x1000, 0x42A3),(0x1000, 0x42B3),(0x1000, 0x42C3),(0x1000, 0x42D3),(0x1000, 0x42E3),(0x1000, 0x42F3),(0x1000, 0x4303),(0x1000, 0x4313),(0x1000, 0x4323),(0x1000, 0x4333),(0x1000, 0x4343),(0x1000, 0x4353),(0x1000, 0x4363),(0x1000, 0x4373),(0x1000, 0x4383),(0x1000, 0x4393),(0x1000, 0x43A3),(0x1000, 0x43B3),(0x1000, 0x43C3),(0x1000, 0x43D3),(0x1000, 0x43E3),(0x1000, 0x43F3),(0x1000, 0x4403),(0x1000, 0x4413),(0x1000, 0x4423),(0x1000, 0x4433),(0x1000, 0x4443),(0x1000, 0x4453),(0x1000, 0x4463),(0x1000, 0x4473),(0x1000, 0x4483),(0x1000, 0x4493),(0x1000, 0x44A3),(0x1000, 0x44B3),(0x1000, 0x44C3),(0x1000, 0x44D3),(0x1000, 0x44E3),(0x1000, 0x44F3),(0x1000, 0x4503),(0x1000, 0x4513),(0x1000, 0x4523),(0x1000, 0x4533),(0x1000, 0x4543),(0x1000, 0x4553),(0x1000, 0x4563),(0x1000, 0x4573),(0x1000, 0x4583),(0x1000, 0x4593),(0x1000, 0x45A3),(0x1000, 0x45B3),(0x1000, 0x45C3),(0x1000, 0x45D3),(0x1000, 0x45E3),(0x1000, 0x45F3),(0x1000, 0x4603),(0x1000, 0x4613),(0x1000, 0x4623),(0x1000, 0x4633),(0x1000, 0x4643),(0x1000, 0x4653),(0x1000, 0x4663),(0x1000, 0x4673),(0x1000, 0x4683),(0x1000, 0x4693),(0x1000, 0x46A3),(0x1000, 0x46B3),(0x1000, 0x46C3),(0x1000, 0x46D3),(0x1000, 0x46E3),(0x1000, 0x46F3),(0x1000, 0x4703),(0x1000, 0x4713),(0x1000, 0x4723),(0x1000, 0x4733),(0x1000, 0x4743),(0x1000, 0x4753),(0x1000, 0x4763),(0x1000, 0x4773),(0x1000, 0x4783),(0x1000, 0x4793),(0x1000, 0x47A3),(0x1000, 0x47B3),(0x1000, 0x47C3),(0x1000, 0x47D3),(0x1000, 0x47E3),(0x1000, 0x47F3),(0x1000, 0x4803),(0x1000, 0x4813),(0x1000, 0x4823),(0x1000, 0x4833),(0x1000, 0x4843),(0x1000, 0x4853),(0x1000, 0x4863),(0x1000, 0x4873),(0x1000, 0x4883),(0x1000, 0x4893),(0x1000, 0x48A3),(0x1000, 0x48B3),(0x1000, 0x48C3),(0x1000, 0x48D3),(0x1000, 0x48E3),(0x1000, 0x48F3),(0x1000, 0x4903),(0x1000, 0x4913),(0x1000, 0x4923),(0x1000, 0x4933),(0x1000, 0x4943),(0x1000, 0x4953),(0x1000, 0x4963),(0x1000, 0x4973),(0x1000, 0x4983),(0x1000, 0x4993),(0x1000, 0x49A3),(0x1000, 0x49B3),(0x1000, 0x49C3),(0x1000, 0x49D3),(0x1000, 0x49E3),(0x1000, 0x49F3),(0x1000, 0x4A03),(0x1000, 0x4A13),(0x1000, 0x4A23),(0x1000, 0x4A33),(0x1000, 0x4A43),(0x1000, 0x4A53),(0x1000, 0x4A63),(0x1000, 0x4A73),(0x1000, 0x4A83),(0x1000, 0x4A93),(0x1000, 0x4AA3),(0x1000, 0x4AB3),(0x1000, 0x4AC3),(0x1000, 0x4AD3),(0x1000, 0x4AE3),(0x1000, 0x4AF3),(0x1000, 0x4B03),(0x1000, 0x4B13),(0x1000, 0x4B23),(0x1000, 0x4B33),(0x1000, 0x4B43),(0x1000, 0x4B53),(0x1000, 0x4B63),(0x1000, 0x4B73),(0x1000, 0x4B83),(0x1000, 0x4B93),(0x1000, 0x4BA3),(0x1000, 0x4BB3),(0x1000, 0x4BC3),(0x1000, 0x4BD3),(0x1000, 0x4BE3),(0x1000, 0x4BF3),(0x1000, 0x4C03),(0x1000, 0x4C13),(0x1000, 0x4C23),(0x1000, 0x4C33),(0x1000, 0x4C43),(0x1000, 0x4C53),(0x1000, 0x4C63),(0x1000, 0x4C73),(0x1000, 0x4C83),(0x1000, 0x4C93),(0x1000, 0x4CA3),(0x1000, 0x4CB3),(0x1000, 0x4CC3),(0x1000, 0x4CD3),(0x1000, 0x4CE3),(0x1000, 0x4CF3),(0x1000, 0x4D03),(0x1000, 0x4D13),(0x1000, 0x4D23),(0x1000, 0x4D33),(0x1000, 0x4D43),(0x1000, 0x4D53),(0x1000, 0x4D63),(0x1000, 0x4D73),(0x1000, 0x4D83),(0x1000, 0x4D93),(0x1000, 0x4DA3),(0x1000, 0x4DB3),(0x1000, 0x4DC3),(0x1000, 0x4DD3),(0x1000, 0x4DE3),(0x1000, 0x4DF3),(0x1000, 0x4E03),(0x1000, 0x4E13),(0x1000, 0x4E23),(0x1000, 0x4E33),(0x1000, 0x4E43),(0x1000, 0x4E53),(0x1000, 0x4E63),(0x1000, 0x4E73),(0x1000, 0x4E83),(0x1000, 0x4E93),(0x1000, 0x4EA3),(0x1000, 0x4EB3),(0x1000, 0x4EC3),(0x1000, 0x4ED3),(0x1000, 0x4EE3),(0x1000, 0x4EF3),(0x1000, 0x4F03),(0x1000, 0x4F13),(0x1000, 0x4F23),(0x1000, 0x4F33),(0x1000, 0x4F43),(0x1000, 0x4F53),(0x1000, 0x4F63),(0x1000, 0x4F73),(0x1000, 0x4F83),(0x1000, 0x4F93),(0x1000, 0x4FA3),(0x1000, 0x4FB3),(0x1000, 0x4FC3),(0x1000, 0x4FD3),(0x1000, 0x4FE3),(0x1000, 0x4FF3),(0x1000, 0x5003),(0x1000, 0x5013),(0x1000, 0x5023),(0x1000, 0x5033),(0x1000, 0x5043),(0x1000, 0x5053),(0x1000, 0x5063),(0x1000, 0x5073),(0x1000, 0x5083),(0x1000, 0x5093),(0x1000, 0x50A3),(0x1000, 0x50B3),(0x1000, 0x50C3),(0x1000, 0x50D3),(0x1000, 0x50E3),(0x1000, 0x50F3),(0x1000, 0x5103),(0x1000, 0x5113),(0x1000, 0x5123),(0x1000, 0x5133),(0x1000, 0x5143),(0x1000, 0x5153),(0x1000, 0x5163),(0x1000, 0x5173),(0x1000, 0x5183),(0x1000, 0x5193),(0x1000, 0x51A3),(0x1000, 0x51B3),(0x1000, 0x51C3),(0x1000, 0x51D3),(0x1000, 0x51E3),(0x1000, 0x51F3),(0x1000, 0x5203),(0x1000, 0x5213),(0x1000, 0x5223),(0x1000, 0x5233),(0x1000, 0x5243),(0x1000, 0x5253),(0x1000, 0x5263),(0x1000, 0x5273),(0x1000, 0x5283),(0x1000, 0x5293),(0x1000, 0x52A3),(0x1000, 0x52B3),(0x1000, 0x52C3),(0x1000, 0x52D3),(0x1000, 0x52E3),(0x1000, 0x52F3),(0x1000, 0x5303),(0x1000, 0x5313),(0x1000, 0x5323),(0x1000, 0x5333),(0x1000, 0x5343),(0x1000, 0x5353),(0x1000, 0x5363),(0x1000, 0x5373),(0x1000, 0x5383),(0x1000, 0x5393),(0x1000, 0x53A3),(0x1000, 0x53B3),(0x1000, 0x53C3),(0x1000, 0x53D3),(0x1000, 0x53E3),(0x1000, 0x53F3),(0x1000, 0x5403),(0x1000, 0x5413),(0x1000, 0x5423),(0x1000, 0x5433),(0x1000, 0x5443),(0x1000, 0x5453),(0x1000, 0x5463),(0x1000, 0x5473),(0x1000, 0x5483),(0x1000, 0x5493),(0x1000, 0x54A3),(0x1000, 0x54B3),(0x1000, 0x54C3),(0x1000, 0x54D3),(0x1000, 0x54E3),(0x1000, 0x54F3),(0x1000, 0x5503),(0x1000, 0x5513),(0x1000, 0x5523),(0x1000, 0x5533),(0x1000, 0x5543),(0x1000, 0x5553),(0x1000, 0x5563),(0x1000, 0x5573),(0x1000, 0x5583),(0x1000, 0x5593),(0x1000, 0x55A3),(0x1000, 0x55B3),(0x1000, 0x55C3),(0x1000, 0x55D3),(0x1000, 0x55E3),(0x1000, 0x55F3),(0x1000, 0x5603),(0x1000, 0x5613),(0x1000, 0x5623),(0x1000, 0x5633),(0x1000, 0x5643),(0x1000, 0x5653),(0x1000, 0x5663),(0x1000, 0x5673),(0x1000, 0x5683),(0x1000, 0x5693),(0x1000, 0x56A3),(0x1000, 0x56B3),(0x1000, 0x56C3),(0x1000, 0x56D3),(0x1000, 0x56E3),(0x1000, 0x56F3),(0x1000, 0x5703),(0x1000, 0x5713),(0x1000, 0x5723),(0x1000, 0x5733),(0x1000, 0x5743),(0x1000, 0x5753),(0x1000, 0x5763),(0x1000, 0x5773),(0x1000, 0x5783),(0x1000, 0x5793),(0x1000, 0x57A3),(0x1000, 0x57B3),(0x1000, 0x57C3),(0x1000, 0x57D3),(0x1000, 0x57E3),(0x1000, 0x57F3),(0x1000, 0x5803),(0x1000, 0x5813),(0x1000, 0x5823),(0x1000, 0x5833),(0x1000, 0x5843),(0x1000, 0x5853),(0x1000, 0x5863),(0x1000, 0x5873),(0x1000, 0x5883),(0x1000, 0x5893),(0x1000, 0x58A3),(0x1000, 0x58B3),(0x1000, 0x58C3),(0x1000, 0x58D3),(0x1000, 0x58E3),(0x1000, 0x58F3),(0x1000, 0x5903),(0x1000, 0x5913),(0x1000, 0x5923),(0x1000, 0x5933),(0x1000, 0x5943),(0x1000, 0x5953),(0x1000, 0x5963),(0x1000, 0x5973),(0x1000, 0x5983),(0x1000, 0x5993),(0x1000, 0x59A3),(0x1000, 0x59B3),(0x1000, 0x59C3),(0x1000, 0x59D3),(0x1000, 0x59E3),(0x1000, 0x59F3),(0x1000, 0x5A03),(0x1000, 0x5A13),(0x1000, 0x5A23),(0x1000, 0x5A33),(0x1000, 0x5A43),(0x1000, 0x5A53),(0x1000, 0x5A63),(0x1000, 0x5A73),(0x1000, 0x5A83),(0x1000, 0x5A93),(0x1000, 0x5AA3),(0x1000, 0x5AB3),(0x1000, 0x5AC3),(0x1000, 0x5AD3),(0x1000, 0x5AE3),(0x1000, 0x5AF3),(0x1000, 0x5B03),(0x1000, 0x5B13),(0x1000, 0x5B23),(0x1000, 0x5B33),(0x1000, 0x5B43),(0x1000, 0x5B53),(0x1000, 0x5B63),(0x1000, 0x5B73),(0x1000, 0x5B83),(0x1000, 0x5B93),(0x1000, 0x5BA3),(0x1000, 0x5BB3),(0x1000, 0x5BC3),(0x1000, 0x5BD3),(0x1000, 0x5BE3),(0x1000, 0x5BF3),(0x1000, 0x5C03),(0x1000, 0x5C13),(0x1000, 0x5C23),(0x1000, 0x5C33),(0x1000, 0x5C43),(0x1000, 0x5C53),(0x1000, 0x5C63),(0x1000, 0x5C73),(0x1000, 0x5C83),(0x1000, 0x5C93),(0x1000, 0x5CA3),(0x1000, 0x5CB3),(0x1000, 0x5CC3),(0x1000, 0x5CD3),(0x1000, 0x5CE3),(0x1000, 0x5CF3),(0x1000, 0x5D03),(0x1000, 0x5D13),(0x1000, 0x5D23),(0x1000, 0x5D33),(0x1000, 0x5D43),(0x1000, 0x5D53),(0x1000, 0x5D63),(0x1000, 0x5D73),(0x1000, 0x5D83),(0x1000, 0x5D93),(0x1000, 0x5DA3),(0x1000, 0x5DB3),(0x1000, 0x5DC3),(0x1000, 0x5DD3),(0x1000, 0x5DE3),(0x1000, 0x5DF3),(0x1000, 0x5E03),(0x1000, 0x5E13),(0x1000, 0x5E23),(0x1000, 0x5E33),(0x1000, 0x5E43),(0x1000, 0x5E53),(0x1000, 0x5E63),(0x1000, 0x5E73),(0x1000, 0x5E83),(0x1000, 0x5E93),(0x1000, 0x5EA3),(0x1000, 0x5EB3),(0x1000, 0x5EC3),(0x1000, 0x5ED3),(0x1000, 0x5EE3),(0x1000, 0x5EF3),(0x1000, 0x5F03),(0x1000, 0x5F13),(0x1000, 0x5F23),(0x1000, 0x5F33),(0x1000, 0x5F43),(0x1000, 0x5F53),(0x1000, 0x5F63),(0x1000, 0x5F73),(0x1000, 0x5F83),(0x1000, 0x5F93),(0x1000, 0x5FA3),(0x1000, 0x5FB3),(0x1000, 0x5FC3),(0x1000, 0x5FD3),(0x1000, 0x5FE3),(0x1000, 0x5FF3),(0x1000, 0x6003),(0x1000, 0x6013),(0x1000, 0x6023),(0x1000, 0x6033),(0x1000, 0x6043),(0x1000, 0x6053),(0x1000, 0x6063),(0x1000, 0x6073),(0x1000, 0x6083),(0x1000, 0x6093),(0x1000, 0x60A3),(0x1000, 0x60B3),(0x1000, 0x60C3),(0x1000, 0x60D3),(0x1000, 0x60E3),(0x1000, 0x60F3),(0x1000, 0x6103),(0x1000, 0x6113),(0x1000, 0x6123),(0x1000, 0x6133),(0x1000, 0x6143),(0x1000, 0x6153),(0x1000, 0x6163),(0x1000, 0x6173),(0x1000, 0x6183),(0x1000, 0x6193),(0x1000, 0x61A3),(0x1000, 0x61B3),(0x1000, 0x61C3),(0x1000, 0x61D3),(0x1000, 0x61E3),(0x1000, 0x61F3),(0x1000, 0x6203),(0x1000, 0x6213),(0x1000, 0x6223),(0x1000, 0x6233),(0x1000, 0x6243),(0x1000, 0x6253),(0x1000, 0x6263),(0x1000, 0x6273),(0x1000, 0x6283),(0x1000, 0x6293),(0x1000, 0x62A3),(0x1000, 0x62B3),(0x1000, 0x62C3),(0x1000, 0x62D3),(0x1000, 0x62E3),(0x1000, 0x62F3),(0x1000, 0x63