"""File Parser - Simple and flexible file parser with DTO support"""

from .parser import FileParser
from .template.proxy_parser import ProxyParser, ProxyDTO
from .dto import FileDTO
from .exceptions import (
    FileParserError,
    FileNotFoundError,
    ParseError,
    ValidationError
)

__version__ = "0.1.0"

__all__ = [
    "FileParser",
    "ProxyParser",
    "FileDTO",
    "ProxyDTO",
    "FileParserError",
    "FileNotFoundError",
    "ParseError",
    "ValidationError",
]