"""Custom exceptions for file parser"""


class FileParserError(Exception):
    """Base exception for file parser"""
    pass


class FileNotFoundError(FileParserError):
    """Raised when file is not found"""
    pass


class ParseError(FileParserError):
    """Raised when parsing fails"""
    pass


class ValidationError(FileParserError):
    """Raised when validation fails"""
    pass