"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EventBridgeDestination = void 0;
const events = require("@aws-cdk/aws-events");
const core_1 = require("@aws-cdk/core");
/**
 * Use an Event Bridge event bus as a Lambda destination.
 *
 * If no event bus is specified, the default event bus is used.
 */
class EventBridgeDestination {
    /**
     * @default - use the default event bus
     */
    constructor(eventBus) {
        this.eventBus = eventBus;
    }
    /**
     * Returns a destination configuration
     */
    bind(_scope, fn, _options) {
        // deduplicated automatically
        events.EventBus.grantPutEvents(fn); // Cannot restrict to a specific resource
        return {
            destination: this.eventBus && this.eventBus.eventBusArn || core_1.Stack.of(fn).formatArn({
                service: 'events',
                resource: 'event-bus',
                resourceName: 'default',
            }),
        };
    }
}
exports.EventBridgeDestination = EventBridgeDestination;
//# sourceMappingURL=data:application/json;base64,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