import * as codebuild from '@aws-cdk/aws-codebuild';
import * as logs from '@aws-cdk/aws-logs';
import { IBucket } from '@aws-cdk/aws-s3';
import { Construct, Stack } from '@aws-cdk/core';
/**
 * @stability stable
 */
export interface ProwlerAuditProps {
    /**
     * Specifies the service name used within component naming.
     *
     * @default : prowler
     * @stability stable
     */
    readonly serviceName?: string;
    /**
     * Specifies the number of days you want to retain CodeBuild run log events in the specified log group.
     *
     * Junit reports are kept for 30 days, HTML reports in S3 are not deleted
     *
     * @default : 3
     * @stability stable
     */
    readonly logsRetentionInDays?: logs.RetentionDays;
    /**
     * Options to pass to Prowler command, make sure at least -M junit-xml is used for CodeBuild reports.
     *
     * Use -r for the region to send API queries, -f to filter only one region, -M output formats, -c for comma separated checks, for all checks do not use -c or -g, for more options see -h. For a complete assessment use  "-M text,junit-xml,html,csv,json", for SecurityHub integration use "-r region -f region -M text,junit-xml,html,csv,json,json-asff -S -q"
     *
     * @default '-M text,junit-xml,html,csv,json'
     * @stability stable
     */
    readonly prowlerOptions?: string;
    /**
     * enables the scheduler for running prowler periodically.
     *
     * Together with prowlerScheduler.
     *
     * @default false
     * @stability stable
     */
    readonly enableScheduler?: boolean;
    /**
     * The time when Prowler will run in cron format.
     *
     * Default is daily at 22:00h or 10PM 'cron(0 22 * * ? *)', for every 5 hours also works 'rate(5 hours)'. More info here https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html.
     *
     * @default 'cron(0 22 * * ? *)'
     * @stability stable
     */
    readonly prowlerScheduler?: string;
    /**
     * Specifies the concrete Prowler version.
     *
     * @default 2.5.0
     * @stability stable
     */
    readonly prowlerVersion?: string;
    /**
     * An optional S3 bucket to store the Prowler reports.
     *
     * @stability stable
     */
    readonly reportBucket?: IBucket;
    /**
     * An optional prefix for the report bucket objects.
     *
     * @stability stable
     */
    readonly reportBucketPrefix?: string;
    /**
     * An optional parameter to add to the S3 bucket copy command.
     *
     * @stability stable
     * @example
     *
     * --acl bucket-owner-full-control
     */
    readonly additionalS3CopyArgs?: string;
}
/**
 * Creates a CodeBuild project to audit an AWS account with Prowler and stores the html report in a S3 bucket.
 *
 * This will run onece at the beginning and on a schedule afterwards. Partial contribution from https://github.com/stevecjones
 *
 * @stability stable
 */
export declare class ProwlerAudit extends Construct {
    /**
     * @stability stable
     */
    serviceName: string;
    /**
     * @stability stable
     */
    logsRetentionInDays: logs.RetentionDays;
    /**
     * @stability stable
     */
    enableScheduler: boolean;
    /**
     * @stability stable
     */
    prowlerScheduler: string;
    /**
     * @stability stable
     */
    prowlerOptions: string;
    /**
     * @stability stable
     */
    prowlerVersion: string;
    /**
     * @stability stable
     */
    codebuildProject: codebuild.Project;
    /**
     * @stability stable
     */
    constructor(parent: Stack, id: string, props?: ProwlerAuditProps);
}
