# -------------------------------------------------------------------------------
# Copyright IBM Corp. 2017
# 
# Licensed under the Apache License, Version 2.0 (the 'License');
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# 
# http://www.apache.org/licenses/LICENSE-2.0
# 
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an 'AS IS' BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
# -------------------------------------------------------------------------------

__all__=['packageManager','display','services','utils']

import warnings
with warnings.catch_warnings():
    warnings.simplefilter("ignore")

    try:
        #Check if we have an python shell available, if not, use our ProxyShell
        get_ipython()
    except NameError:
        from .proxyShell import ProxyInteractiveShell
        ProxyInteractiveShell.instance()   

    #shortcut to logging
    import pixiedust_optimus.utils.pdLogging as pdLogging
    logger = pdLogging.getPixiedustLogger()
    getLogger = pdLogging.getLogger

    from pixiedust_optimus.utils.environment import Environment


    try:
        from py4j.protocol import Py4JJavaError
        #javaBridge and scalaBridge only work in the driver, not an executor
        from pixiedust_optimus.utils.javaBridge import *
        from pixiedust_optimus.utils.scalaBridge import *

        #shortcut to Spark job monitoring
        from pixiedust_optimus.utils.sparkJobProgressMonitor import enableSparkJobProgressMonitor
        enableJobMonitor = enableSparkJobProgressMonitor
    except (NameError, Py4JJavaError):
        #IPython not available we must be in a spark executor
        pass

    #automated import into the user namespace
    try:
        from IPython.core.getipython import get_ipython
        import pixiedust_optimus.display
        import pixiedust_optimus.services
        get_ipython().user_ns["display"]=display.display

        from pixiedust_optimus.utils.sampleData import sampleData
        from pixiedust_optimus.utils import checkVersion
        checkVersion()
    except (NameError):
        #IPython not available we must be in a spark executor
        pass
