# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetMonitoredInstanceResult',
    'AwaitableGetMonitoredInstanceResult',
    'get_monitored_instance',
    'get_monitored_instance_output',
]

@pulumi.output_type
class GetMonitoredInstanceResult:
    """
    A collection of values returned by getMonitoredInstance.
    """
    def __init__(__self__, compartment_id=None, display_name=None, id=None, instance_id=None, lifecycle_details=None, management_agent_id=None, monitored_instance_id=None, monitoring_state=None, state=None, time_created=None, time_updated=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instance_id and not isinstance(instance_id, str):
            raise TypeError("Expected argument 'instance_id' to be a str")
        pulumi.set(__self__, "instance_id", instance_id)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if management_agent_id and not isinstance(management_agent_id, str):
            raise TypeError("Expected argument 'management_agent_id' to be a str")
        pulumi.set(__self__, "management_agent_id", management_agent_id)
        if monitored_instance_id and not isinstance(monitored_instance_id, str):
            raise TypeError("Expected argument 'monitored_instance_id' to be a str")
        pulumi.set(__self__, "monitored_instance_id", monitored_instance_id)
        if monitoring_state and not isinstance(monitoring_state, str):
            raise TypeError("Expected argument 'monitoring_state' to be a str")
        pulumi.set(__self__, "monitoring_state", monitoring_state)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        Compartment Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A user-friendly name of the monitored instance. It is binded to [Compute Instance](https://docs.cloud.oracle.com/iaas/Content/Compute/Concepts/computeoverview.htm). DisplayName is fetched from [Core Service API](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/20160918/Instance/).
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of monitored instance.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="managementAgentId")
    def management_agent_id(self) -> str:
        """
        Management Agent Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm). Used to invoke manage operations on Management Agent Cloud Service.
        """
        return pulumi.get(self, "management_agent_id")

    @property
    @pulumi.getter(name="monitoredInstanceId")
    def monitored_instance_id(self) -> str:
        return pulumi.get(self, "monitored_instance_id")

    @property
    @pulumi.getter(name="monitoringState")
    def monitoring_state(self) -> str:
        """
        Monitoring status. Can be either enabled or disabled.
        """
        return pulumi.get(self, "monitoring_state")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the monitored instance.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time the MonitoredInstance was created. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The time the MonitoredInstance was updated. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetMonitoredInstanceResult(GetMonitoredInstanceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMonitoredInstanceResult(
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            id=self.id,
            instance_id=self.instance_id,
            lifecycle_details=self.lifecycle_details,
            management_agent_id=self.management_agent_id,
            monitored_instance_id=self.monitored_instance_id,
            monitoring_state=self.monitoring_state,
            state=self.state,
            time_created=self.time_created,
            time_updated=self.time_updated)


def get_monitored_instance(monitored_instance_id: Optional[str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMonitoredInstanceResult:
    """
    This data source provides details about a specific Monitored Instance resource in Oracle Cloud Infrastructure Appmgmt Control service.

    Gets a monitored instance by identifier

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_monitored_instance = oci.AppMgmtControl.get_monitored_instance(monitored_instance_id=test_monitored_instance_oci_appmgmt_control_monitored_instance["id"])
    ```


    :param str monitored_instance_id: OCID of monitored instance.
    """
    __args__ = dict()
    __args__['monitoredInstanceId'] = monitored_instance_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:AppMgmtControl/getMonitoredInstance:getMonitoredInstance', __args__, opts=opts, typ=GetMonitoredInstanceResult).value

    return AwaitableGetMonitoredInstanceResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        id=pulumi.get(__ret__, 'id'),
        instance_id=pulumi.get(__ret__, 'instance_id'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        management_agent_id=pulumi.get(__ret__, 'management_agent_id'),
        monitored_instance_id=pulumi.get(__ret__, 'monitored_instance_id'),
        monitoring_state=pulumi.get(__ret__, 'monitoring_state'),
        state=pulumi.get(__ret__, 'state'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'))
def get_monitored_instance_output(monitored_instance_id: Optional[pulumi.Input[str]] = None,
                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetMonitoredInstanceResult]:
    """
    This data source provides details about a specific Monitored Instance resource in Oracle Cloud Infrastructure Appmgmt Control service.

    Gets a monitored instance by identifier

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_monitored_instance = oci.AppMgmtControl.get_monitored_instance(monitored_instance_id=test_monitored_instance_oci_appmgmt_control_monitored_instance["id"])
    ```


    :param str monitored_instance_id: OCID of monitored instance.
    """
    __args__ = dict()
    __args__['monitoredInstanceId'] = monitored_instance_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:AppMgmtControl/getMonitoredInstance:getMonitoredInstance', __args__, opts=opts, typ=GetMonitoredInstanceResult)
    return __ret__.apply(lambda __response__: GetMonitoredInstanceResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        id=pulumi.get(__response__, 'id'),
        instance_id=pulumi.get(__response__, 'instance_id'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        management_agent_id=pulumi.get(__response__, 'management_agent_id'),
        monitored_instance_id=pulumi.get(__response__, 'monitored_instance_id'),
        monitoring_state=pulumi.get(__response__, 'monitoring_state'),
        state=pulumi.get(__response__, 'state'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated')))
