# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetSubscriptionResult',
    'AwaitableGetSubscriptionResult',
    'get_subscription',
    'get_subscription_output',
]

@pulumi.output_type
class GetSubscriptionResult:
    """
    A collection of values returned by getSubscription.
    """
    def __init__(__self__, account_type=None, bill_to_cust_account_id=None, billing_addresses=None, compartment_id=None, currency_code=None, email=None, gsi_org_code=None, id=None, is_intent_to_pay=None, language_code=None, organization_id=None, osp_home_region=None, payment_gateways=None, payment_options=None, plan_type=None, ship_to_cust_acct_role_id=None, ship_to_cust_acct_site_id=None, subscription_id=None, subscription_plan_number=None, subscriptions=None, tax_infos=None, time_personal_to_corporate_conv=None, time_plan_upgrade=None, time_start=None, upgrade_state=None, upgrade_state_details=None):
        if account_type and not isinstance(account_type, str):
            raise TypeError("Expected argument 'account_type' to be a str")
        pulumi.set(__self__, "account_type", account_type)
        if bill_to_cust_account_id and not isinstance(bill_to_cust_account_id, str):
            raise TypeError("Expected argument 'bill_to_cust_account_id' to be a str")
        pulumi.set(__self__, "bill_to_cust_account_id", bill_to_cust_account_id)
        if billing_addresses and not isinstance(billing_addresses, list):
            raise TypeError("Expected argument 'billing_addresses' to be a list")
        pulumi.set(__self__, "billing_addresses", billing_addresses)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if currency_code and not isinstance(currency_code, str):
            raise TypeError("Expected argument 'currency_code' to be a str")
        pulumi.set(__self__, "currency_code", currency_code)
        if email and not isinstance(email, str):
            raise TypeError("Expected argument 'email' to be a str")
        pulumi.set(__self__, "email", email)
        if gsi_org_code and not isinstance(gsi_org_code, str):
            raise TypeError("Expected argument 'gsi_org_code' to be a str")
        pulumi.set(__self__, "gsi_org_code", gsi_org_code)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_intent_to_pay and not isinstance(is_intent_to_pay, bool):
            raise TypeError("Expected argument 'is_intent_to_pay' to be a bool")
        pulumi.set(__self__, "is_intent_to_pay", is_intent_to_pay)
        if language_code and not isinstance(language_code, str):
            raise TypeError("Expected argument 'language_code' to be a str")
        pulumi.set(__self__, "language_code", language_code)
        if organization_id and not isinstance(organization_id, str):
            raise TypeError("Expected argument 'organization_id' to be a str")
        pulumi.set(__self__, "organization_id", organization_id)
        if osp_home_region and not isinstance(osp_home_region, str):
            raise TypeError("Expected argument 'osp_home_region' to be a str")
        pulumi.set(__self__, "osp_home_region", osp_home_region)
        if payment_gateways and not isinstance(payment_gateways, list):
            raise TypeError("Expected argument 'payment_gateways' to be a list")
        pulumi.set(__self__, "payment_gateways", payment_gateways)
        if payment_options and not isinstance(payment_options, list):
            raise TypeError("Expected argument 'payment_options' to be a list")
        pulumi.set(__self__, "payment_options", payment_options)
        if plan_type and not isinstance(plan_type, str):
            raise TypeError("Expected argument 'plan_type' to be a str")
        pulumi.set(__self__, "plan_type", plan_type)
        if ship_to_cust_acct_role_id and not isinstance(ship_to_cust_acct_role_id, str):
            raise TypeError("Expected argument 'ship_to_cust_acct_role_id' to be a str")
        pulumi.set(__self__, "ship_to_cust_acct_role_id", ship_to_cust_acct_role_id)
        if ship_to_cust_acct_site_id and not isinstance(ship_to_cust_acct_site_id, str):
            raise TypeError("Expected argument 'ship_to_cust_acct_site_id' to be a str")
        pulumi.set(__self__, "ship_to_cust_acct_site_id", ship_to_cust_acct_site_id)
        if subscription_id and not isinstance(subscription_id, str):
            raise TypeError("Expected argument 'subscription_id' to be a str")
        pulumi.set(__self__, "subscription_id", subscription_id)
        if subscription_plan_number and not isinstance(subscription_plan_number, str):
            raise TypeError("Expected argument 'subscription_plan_number' to be a str")
        pulumi.set(__self__, "subscription_plan_number", subscription_plan_number)
        if subscriptions and not isinstance(subscriptions, list):
            raise TypeError("Expected argument 'subscriptions' to be a list")
        pulumi.set(__self__, "subscriptions", subscriptions)
        if tax_infos and not isinstance(tax_infos, list):
            raise TypeError("Expected argument 'tax_infos' to be a list")
        pulumi.set(__self__, "tax_infos", tax_infos)
        if time_personal_to_corporate_conv and not isinstance(time_personal_to_corporate_conv, str):
            raise TypeError("Expected argument 'time_personal_to_corporate_conv' to be a str")
        pulumi.set(__self__, "time_personal_to_corporate_conv", time_personal_to_corporate_conv)
        if time_plan_upgrade and not isinstance(time_plan_upgrade, str):
            raise TypeError("Expected argument 'time_plan_upgrade' to be a str")
        pulumi.set(__self__, "time_plan_upgrade", time_plan_upgrade)
        if time_start and not isinstance(time_start, str):
            raise TypeError("Expected argument 'time_start' to be a str")
        pulumi.set(__self__, "time_start", time_start)
        if upgrade_state and not isinstance(upgrade_state, str):
            raise TypeError("Expected argument 'upgrade_state' to be a str")
        pulumi.set(__self__, "upgrade_state", upgrade_state)
        if upgrade_state_details and not isinstance(upgrade_state_details, str):
            raise TypeError("Expected argument 'upgrade_state_details' to be a str")
        pulumi.set(__self__, "upgrade_state_details", upgrade_state_details)

    @property
    @pulumi.getter(name="accountType")
    def account_type(self) -> str:
        """
        Account type.
        """
        return pulumi.get(self, "account_type")

    @property
    @pulumi.getter(name="billToCustAccountId")
    def bill_to_cust_account_id(self) -> str:
        """
        Bill to customer Account id.
        """
        return pulumi.get(self, "bill_to_cust_account_id")

    @property
    @pulumi.getter(name="billingAddresses")
    def billing_addresses(self) -> Sequence['outputs.GetSubscriptionBillingAddressResult']:
        """
        Address details model.
        """
        return pulumi.get(self, "billing_addresses")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="currencyCode")
    def currency_code(self) -> str:
        """
        Currency code
        """
        return pulumi.get(self, "currency_code")

    @property
    @pulumi.getter
    def email(self) -> str:
        return pulumi.get(self, "email")

    @property
    @pulumi.getter(name="gsiOrgCode")
    def gsi_org_code(self) -> str:
        """
        GSI Subscription external code.
        """
        return pulumi.get(self, "gsi_org_code")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Subscription id identifier (OCID).
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isIntentToPay")
    def is_intent_to_pay(self) -> bool:
        """
        Payment intension.
        """
        return pulumi.get(self, "is_intent_to_pay")

    @property
    @pulumi.getter(name="languageCode")
    def language_code(self) -> str:
        """
        Language short code (en, de, hu, etc)
        """
        return pulumi.get(self, "language_code")

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> str:
        """
        GSI organization external identifier.
        """
        return pulumi.get(self, "organization_id")

    @property
    @pulumi.getter(name="ospHomeRegion")
    def osp_home_region(self) -> str:
        return pulumi.get(self, "osp_home_region")

    @property
    @pulumi.getter(name="paymentGateways")
    def payment_gateways(self) -> Sequence['outputs.GetSubscriptionPaymentGatewayResult']:
        """
        Payment gateway details.
        """
        return pulumi.get(self, "payment_gateways")

    @property
    @pulumi.getter(name="paymentOptions")
    def payment_options(self) -> Sequence['outputs.GetSubscriptionPaymentOptionResult']:
        """
        Payment option list of a subscription.
        """
        return pulumi.get(self, "payment_options")

    @property
    @pulumi.getter(name="planType")
    def plan_type(self) -> str:
        """
        Subscription plan type.
        """
        return pulumi.get(self, "plan_type")

    @property
    @pulumi.getter(name="shipToCustAcctRoleId")
    def ship_to_cust_acct_role_id(self) -> str:
        """
        Ship to customer account role.
        """
        return pulumi.get(self, "ship_to_cust_acct_role_id")

    @property
    @pulumi.getter(name="shipToCustAcctSiteId")
    def ship_to_cust_acct_site_id(self) -> str:
        """
        Ship to customer account site address id.
        """
        return pulumi.get(self, "ship_to_cust_acct_site_id")

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> str:
        return pulumi.get(self, "subscription_id")

    @property
    @pulumi.getter(name="subscriptionPlanNumber")
    def subscription_plan_number(self) -> str:
        """
        Subscription plan number.
        """
        return pulumi.get(self, "subscription_plan_number")

    @property
    @pulumi.getter
    def subscriptions(self) -> Sequence['outputs.GetSubscriptionSubscriptionResult']:
        return pulumi.get(self, "subscriptions")

    @property
    @pulumi.getter(name="taxInfos")
    def tax_infos(self) -> Sequence['outputs.GetSubscriptionTaxInfoResult']:
        """
        Tax details.
        """
        return pulumi.get(self, "tax_infos")

    @property
    @pulumi.getter(name="timePersonalToCorporateConv")
    def time_personal_to_corporate_conv(self) -> str:
        """
        Date of upgrade/conversion when account type changed from PERSONAL to CORPORATE
        """
        return pulumi.get(self, "time_personal_to_corporate_conv")

    @property
    @pulumi.getter(name="timePlanUpgrade")
    def time_plan_upgrade(self) -> str:
        """
        Date of upgrade/conversion when planType changed from FREE_TIER to PAYG
        """
        return pulumi.get(self, "time_plan_upgrade")

    @property
    @pulumi.getter(name="timeStart")
    def time_start(self) -> str:
        """
        Start date of the subscription.
        """
        return pulumi.get(self, "time_start")

    @property
    @pulumi.getter(name="upgradeState")
    def upgrade_state(self) -> str:
        """
        Status of the upgrade.
        """
        return pulumi.get(self, "upgrade_state")

    @property
    @pulumi.getter(name="upgradeStateDetails")
    def upgrade_state_details(self) -> str:
        """
        This field is used to describe the Upgrade State in case of error (E.g. Upgrade failure caused by interfacing Tax details- TaxError)
        """
        return pulumi.get(self, "upgrade_state_details")


class AwaitableGetSubscriptionResult(GetSubscriptionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSubscriptionResult(
            account_type=self.account_type,
            bill_to_cust_account_id=self.bill_to_cust_account_id,
            billing_addresses=self.billing_addresses,
            compartment_id=self.compartment_id,
            currency_code=self.currency_code,
            email=self.email,
            gsi_org_code=self.gsi_org_code,
            id=self.id,
            is_intent_to_pay=self.is_intent_to_pay,
            language_code=self.language_code,
            organization_id=self.organization_id,
            osp_home_region=self.osp_home_region,
            payment_gateways=self.payment_gateways,
            payment_options=self.payment_options,
            plan_type=self.plan_type,
            ship_to_cust_acct_role_id=self.ship_to_cust_acct_role_id,
            ship_to_cust_acct_site_id=self.ship_to_cust_acct_site_id,
            subscription_id=self.subscription_id,
            subscription_plan_number=self.subscription_plan_number,
            subscriptions=self.subscriptions,
            tax_infos=self.tax_infos,
            time_personal_to_corporate_conv=self.time_personal_to_corporate_conv,
            time_plan_upgrade=self.time_plan_upgrade,
            time_start=self.time_start,
            upgrade_state=self.upgrade_state,
            upgrade_state_details=self.upgrade_state_details)


def get_subscription(compartment_id: Optional[str] = None,
                     osp_home_region: Optional[str] = None,
                     subscription_id: Optional[str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSubscriptionResult:
    """
    This data source provides details about a specific Subscription resource in Oracle Cloud Infrastructure Osp Gateway service.

    Get the subscription plan.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_subscription = oci.OspGateway.get_subscription(compartment_id=compartment_id,
        osp_home_region=subscription_osp_home_region,
        subscription_id=test_subscription_oci_osp_gateway_subscription["id"])
    ```


    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param str osp_home_region: The home region's public name of the logged in user.
    :param str subscription_id: Subscription id(OCID).
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['ospHomeRegion'] = osp_home_region
    __args__['subscriptionId'] = subscription_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:OspGateway/getSubscription:getSubscription', __args__, opts=opts, typ=GetSubscriptionResult).value

    return AwaitableGetSubscriptionResult(
        account_type=pulumi.get(__ret__, 'account_type'),
        bill_to_cust_account_id=pulumi.get(__ret__, 'bill_to_cust_account_id'),
        billing_addresses=pulumi.get(__ret__, 'billing_addresses'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        currency_code=pulumi.get(__ret__, 'currency_code'),
        email=pulumi.get(__ret__, 'email'),
        gsi_org_code=pulumi.get(__ret__, 'gsi_org_code'),
        id=pulumi.get(__ret__, 'id'),
        is_intent_to_pay=pulumi.get(__ret__, 'is_intent_to_pay'),
        language_code=pulumi.get(__ret__, 'language_code'),
        organization_id=pulumi.get(__ret__, 'organization_id'),
        osp_home_region=pulumi.get(__ret__, 'osp_home_region'),
        payment_gateways=pulumi.get(__ret__, 'payment_gateways'),
        payment_options=pulumi.get(__ret__, 'payment_options'),
        plan_type=pulumi.get(__ret__, 'plan_type'),
        ship_to_cust_acct_role_id=pulumi.get(__ret__, 'ship_to_cust_acct_role_id'),
        ship_to_cust_acct_site_id=pulumi.get(__ret__, 'ship_to_cust_acct_site_id'),
        subscription_id=pulumi.get(__ret__, 'subscription_id'),
        subscription_plan_number=pulumi.get(__ret__, 'subscription_plan_number'),
        subscriptions=pulumi.get(__ret__, 'subscriptions'),
        tax_infos=pulumi.get(__ret__, 'tax_infos'),
        time_personal_to_corporate_conv=pulumi.get(__ret__, 'time_personal_to_corporate_conv'),
        time_plan_upgrade=pulumi.get(__ret__, 'time_plan_upgrade'),
        time_start=pulumi.get(__ret__, 'time_start'),
        upgrade_state=pulumi.get(__ret__, 'upgrade_state'),
        upgrade_state_details=pulumi.get(__ret__, 'upgrade_state_details'))
def get_subscription_output(compartment_id: Optional[pulumi.Input[str]] = None,
                            osp_home_region: Optional[pulumi.Input[str]] = None,
                            subscription_id: Optional[pulumi.Input[str]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSubscriptionResult]:
    """
    This data source provides details about a specific Subscription resource in Oracle Cloud Infrastructure Osp Gateway service.

    Get the subscription plan.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_subscription = oci.OspGateway.get_subscription(compartment_id=compartment_id,
        osp_home_region=subscription_osp_home_region,
        subscription_id=test_subscription_oci_osp_gateway_subscription["id"])
    ```


    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param str osp_home_region: The home region's public name of the logged in user.
    :param str subscription_id: Subscription id(OCID).
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['ospHomeRegion'] = osp_home_region
    __args__['subscriptionId'] = subscription_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:OspGateway/getSubscription:getSubscription', __args__, opts=opts, typ=GetSubscriptionResult)
    return __ret__.apply(lambda __response__: GetSubscriptionResult(
        account_type=pulumi.get(__response__, 'account_type'),
        bill_to_cust_account_id=pulumi.get(__response__, 'bill_to_cust_account_id'),
        billing_addresses=pulumi.get(__response__, 'billing_addresses'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        currency_code=pulumi.get(__response__, 'currency_code'),
        email=pulumi.get(__response__, 'email'),
        gsi_org_code=pulumi.get(__response__, 'gsi_org_code'),
        id=pulumi.get(__response__, 'id'),
        is_intent_to_pay=pulumi.get(__response__, 'is_intent_to_pay'),
        language_code=pulumi.get(__response__, 'language_code'),
        organization_id=pulumi.get(__response__, 'organization_id'),
        osp_home_region=pulumi.get(__response__, 'osp_home_region'),
        payment_gateways=pulumi.get(__response__, 'payment_gateways'),
        payment_options=pulumi.get(__response__, 'payment_options'),
        plan_type=pulumi.get(__response__, 'plan_type'),
        ship_to_cust_acct_role_id=pulumi.get(__response__, 'ship_to_cust_acct_role_id'),
        ship_to_cust_acct_site_id=pulumi.get(__response__, 'ship_to_cust_acct_site_id'),
        subscription_id=pulumi.get(__response__, 'subscription_id'),
        subscription_plan_number=pulumi.get(__response__, 'subscription_plan_number'),
        subscriptions=pulumi.get(__response__, 'subscriptions'),
        tax_infos=pulumi.get(__response__, 'tax_infos'),
        time_personal_to_corporate_conv=pulumi.get(__response__, 'time_personal_to_corporate_conv'),
        time_plan_upgrade=pulumi.get(__response__, 'time_plan_upgrade'),
        time_start=pulumi.get(__response__, 'time_start'),
        upgrade_state=pulumi.get(__response__, 'upgrade_state'),
        upgrade_state_details=pulumi.get(__response__, 'upgrade_state_details')))
