# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['VtapArgs', 'Vtap']

@pulumi.input_type
class VtapArgs:
    def __init__(__self__, *,
                 capture_filter_id: pulumi.Input[str],
                 compartment_id: pulumi.Input[str],
                 source_id: pulumi.Input[str],
                 vcn_id: pulumi.Input[str],
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 encapsulation_protocol: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 is_vtap_enabled: Optional[pulumi.Input[bool]] = None,
                 max_packet_size: Optional[pulumi.Input[int]] = None,
                 source_private_endpoint_ip: Optional[pulumi.Input[str]] = None,
                 source_private_endpoint_subnet_id: Optional[pulumi.Input[str]] = None,
                 source_type: Optional[pulumi.Input[str]] = None,
                 target_id: Optional[pulumi.Input[str]] = None,
                 target_ip: Optional[pulumi.Input[str]] = None,
                 target_type: Optional[pulumi.Input[str]] = None,
                 traffic_mode: Optional[pulumi.Input[str]] = None,
                 vxlan_network_identifier: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Vtap resource.
        :param pulumi.Input[str] capture_filter_id: (Updatable) The capture filter's Oracle ID ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)).
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the `Vtap` resource.
        :param pulumi.Input[str] source_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the source point where packets are captured.
        :param pulumi.Input[str] vcn_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VCN containing the `Vtap` resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[str] encapsulation_protocol: (Updatable) Defines an encapsulation header type for the VTAP's mirrored traffic.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[bool] is_vtap_enabled: (Updatable) Used to start or stop a `Vtap` resource.
               * `TRUE` directs the VTAP to start mirroring traffic.
               * `FALSE` (Default) directs the VTAP to stop mirroring traffic.
        :param pulumi.Input[int] max_packet_size: (Updatable) The maximum size of the packets to be included in the filter.
        :param pulumi.Input[str] source_private_endpoint_ip: (Updatable) The IP Address of the source private endpoint.
        :param pulumi.Input[str] source_private_endpoint_subnet_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet that source private endpoint belongs to.
        :param pulumi.Input[str] source_type: (Updatable) The source type for the VTAP.
        :param pulumi.Input[str] target_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the destination resource where mirrored packets are sent.
        :param pulumi.Input[str] target_ip: (Updatable) The IP address of the destination resource where mirrored packets are sent.
        :param pulumi.Input[str] target_type: (Updatable) The target type for the VTAP.
        :param pulumi.Input[str] traffic_mode: (Updatable) Used to control the priority of traffic. It is an optional field. If it not passed, the value is DEFAULT
        :param pulumi.Input[str] vxlan_network_identifier: (Updatable) The virtual extensible LAN (VXLAN) network identifier (or VXLAN segment ID) that uniquely identifies the VXLAN. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "capture_filter_id", capture_filter_id)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "source_id", source_id)
        pulumi.set(__self__, "vcn_id", vcn_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if encapsulation_protocol is not None:
            pulumi.set(__self__, "encapsulation_protocol", encapsulation_protocol)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_vtap_enabled is not None:
            pulumi.set(__self__, "is_vtap_enabled", is_vtap_enabled)
        if max_packet_size is not None:
            pulumi.set(__self__, "max_packet_size", max_packet_size)
        if source_private_endpoint_ip is not None:
            pulumi.set(__self__, "source_private_endpoint_ip", source_private_endpoint_ip)
        if source_private_endpoint_subnet_id is not None:
            pulumi.set(__self__, "source_private_endpoint_subnet_id", source_private_endpoint_subnet_id)
        if source_type is not None:
            pulumi.set(__self__, "source_type", source_type)
        if target_id is not None:
            pulumi.set(__self__, "target_id", target_id)
        if target_ip is not None:
            pulumi.set(__self__, "target_ip", target_ip)
        if target_type is not None:
            pulumi.set(__self__, "target_type", target_type)
        if traffic_mode is not None:
            pulumi.set(__self__, "traffic_mode", traffic_mode)
        if vxlan_network_identifier is not None:
            pulumi.set(__self__, "vxlan_network_identifier", vxlan_network_identifier)

    @property
    @pulumi.getter(name="captureFilterId")
    def capture_filter_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The capture filter's Oracle ID ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)).
        """
        return pulumi.get(self, "capture_filter_id")

    @capture_filter_id.setter
    def capture_filter_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "capture_filter_id", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the `Vtap` resource.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="sourceId")
    def source_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the source point where packets are captured.
        """
        return pulumi.get(self, "source_id")

    @source_id.setter
    def source_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "source_id", value)

    @property
    @pulumi.getter(name="vcnId")
    def vcn_id(self) -> pulumi.Input[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VCN containing the `Vtap` resource.
        """
        return pulumi.get(self, "vcn_id")

    @vcn_id.setter
    def vcn_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "vcn_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="encapsulationProtocol")
    def encapsulation_protocol(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Defines an encapsulation header type for the VTAP's mirrored traffic.
        """
        return pulumi.get(self, "encapsulation_protocol")

    @encapsulation_protocol.setter
    def encapsulation_protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "encapsulation_protocol", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="isVtapEnabled")
    def is_vtap_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Used to start or stop a `Vtap` resource.
        * `TRUE` directs the VTAP to start mirroring traffic.
        * `FALSE` (Default) directs the VTAP to stop mirroring traffic.
        """
        return pulumi.get(self, "is_vtap_enabled")

    @is_vtap_enabled.setter
    def is_vtap_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_vtap_enabled", value)

    @property
    @pulumi.getter(name="maxPacketSize")
    def max_packet_size(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The maximum size of the packets to be included in the filter.
        """
        return pulumi.get(self, "max_packet_size")

    @max_packet_size.setter
    def max_packet_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_packet_size", value)

    @property
    @pulumi.getter(name="sourcePrivateEndpointIp")
    def source_private_endpoint_ip(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The IP Address of the source private endpoint.
        """
        return pulumi.get(self, "source_private_endpoint_ip")

    @source_private_endpoint_ip.setter
    def source_private_endpoint_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_private_endpoint_ip", value)

    @property
    @pulumi.getter(name="sourcePrivateEndpointSubnetId")
    def source_private_endpoint_subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet that source private endpoint belongs to.
        """
        return pulumi.get(self, "source_private_endpoint_subnet_id")

    @source_private_endpoint_subnet_id.setter
    def source_private_endpoint_subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_private_endpoint_subnet_id", value)

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The source type for the VTAP.
        """
        return pulumi.get(self, "source_type")

    @source_type.setter
    def source_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_type", value)

    @property
    @pulumi.getter(name="targetId")
    def target_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the destination resource where mirrored packets are sent.
        """
        return pulumi.get(self, "target_id")

    @target_id.setter
    def target_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_id", value)

    @property
    @pulumi.getter(name="targetIp")
    def target_ip(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The IP address of the destination resource where mirrored packets are sent.
        """
        return pulumi.get(self, "target_ip")

    @target_ip.setter
    def target_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_ip", value)

    @property
    @pulumi.getter(name="targetType")
    def target_type(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The target type for the VTAP.
        """
        return pulumi.get(self, "target_type")

    @target_type.setter
    def target_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_type", value)

    @property
    @pulumi.getter(name="trafficMode")
    def traffic_mode(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Used to control the priority of traffic. It is an optional field. If it not passed, the value is DEFAULT
        """
        return pulumi.get(self, "traffic_mode")

    @traffic_mode.setter
    def traffic_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "traffic_mode", value)

    @property
    @pulumi.getter(name="vxlanNetworkIdentifier")
    def vxlan_network_identifier(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The virtual extensible LAN (VXLAN) network identifier (or VXLAN segment ID) that uniquely identifies the VXLAN. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "vxlan_network_identifier")

    @vxlan_network_identifier.setter
    def vxlan_network_identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vxlan_network_identifier", value)


@pulumi.input_type
class _VtapState:
    def __init__(__self__, *,
                 capture_filter_id: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 encapsulation_protocol: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 is_vtap_enabled: Optional[pulumi.Input[bool]] = None,
                 lifecycle_state_details: Optional[pulumi.Input[str]] = None,
                 max_packet_size: Optional[pulumi.Input[int]] = None,
                 source_id: Optional[pulumi.Input[str]] = None,
                 source_private_endpoint_ip: Optional[pulumi.Input[str]] = None,
                 source_private_endpoint_subnet_id: Optional[pulumi.Input[str]] = None,
                 source_type: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 target_id: Optional[pulumi.Input[str]] = None,
                 target_ip: Optional[pulumi.Input[str]] = None,
                 target_type: Optional[pulumi.Input[str]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 traffic_mode: Optional[pulumi.Input[str]] = None,
                 vcn_id: Optional[pulumi.Input[str]] = None,
                 vxlan_network_identifier: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Vtap resources.
        :param pulumi.Input[str] capture_filter_id: (Updatable) The capture filter's Oracle ID ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)).
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the `Vtap` resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[str] encapsulation_protocol: (Updatable) Defines an encapsulation header type for the VTAP's mirrored traffic.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[bool] is_vtap_enabled: (Updatable) Used to start or stop a `Vtap` resource.
               * `TRUE` directs the VTAP to start mirroring traffic.
               * `FALSE` (Default) directs the VTAP to stop mirroring traffic.
        :param pulumi.Input[str] lifecycle_state_details: The VTAP's current running state.
        :param pulumi.Input[int] max_packet_size: (Updatable) The maximum size of the packets to be included in the filter.
        :param pulumi.Input[str] source_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the source point where packets are captured.
        :param pulumi.Input[str] source_private_endpoint_ip: (Updatable) The IP Address of the source private endpoint.
        :param pulumi.Input[str] source_private_endpoint_subnet_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet that source private endpoint belongs to.
        :param pulumi.Input[str] source_type: (Updatable) The source type for the VTAP.
        :param pulumi.Input[str] state: The VTAP's administrative lifecycle state.
        :param pulumi.Input[str] target_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the destination resource where mirrored packets are sent.
        :param pulumi.Input[str] target_ip: (Updatable) The IP address of the destination resource where mirrored packets are sent.
        :param pulumi.Input[str] target_type: (Updatable) The target type for the VTAP.
        :param pulumi.Input[str] time_created: The date and time the VTAP was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2020-08-25T21:10:29.600Z`
        :param pulumi.Input[str] traffic_mode: (Updatable) Used to control the priority of traffic. It is an optional field. If it not passed, the value is DEFAULT
        :param pulumi.Input[str] vcn_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VCN containing the `Vtap` resource.
        :param pulumi.Input[str] vxlan_network_identifier: (Updatable) The virtual extensible LAN (VXLAN) network identifier (or VXLAN segment ID) that uniquely identifies the VXLAN. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if capture_filter_id is not None:
            pulumi.set(__self__, "capture_filter_id", capture_filter_id)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if encapsulation_protocol is not None:
            pulumi.set(__self__, "encapsulation_protocol", encapsulation_protocol)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_vtap_enabled is not None:
            pulumi.set(__self__, "is_vtap_enabled", is_vtap_enabled)
        if lifecycle_state_details is not None:
            pulumi.set(__self__, "lifecycle_state_details", lifecycle_state_details)
        if max_packet_size is not None:
            pulumi.set(__self__, "max_packet_size", max_packet_size)
        if source_id is not None:
            pulumi.set(__self__, "source_id", source_id)
        if source_private_endpoint_ip is not None:
            pulumi.set(__self__, "source_private_endpoint_ip", source_private_endpoint_ip)
        if source_private_endpoint_subnet_id is not None:
            pulumi.set(__self__, "source_private_endpoint_subnet_id", source_private_endpoint_subnet_id)
        if source_type is not None:
            pulumi.set(__self__, "source_type", source_type)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if target_id is not None:
            pulumi.set(__self__, "target_id", target_id)
        if target_ip is not None:
            pulumi.set(__self__, "target_ip", target_ip)
        if target_type is not None:
            pulumi.set(__self__, "target_type", target_type)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if traffic_mode is not None:
            pulumi.set(__self__, "traffic_mode", traffic_mode)
        if vcn_id is not None:
            pulumi.set(__self__, "vcn_id", vcn_id)
        if vxlan_network_identifier is not None:
            pulumi.set(__self__, "vxlan_network_identifier", vxlan_network_identifier)

    @property
    @pulumi.getter(name="captureFilterId")
    def capture_filter_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The capture filter's Oracle ID ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)).
        """
        return pulumi.get(self, "capture_filter_id")

    @capture_filter_id.setter
    def capture_filter_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "capture_filter_id", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the `Vtap` resource.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="encapsulationProtocol")
    def encapsulation_protocol(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Defines an encapsulation header type for the VTAP's mirrored traffic.
        """
        return pulumi.get(self, "encapsulation_protocol")

    @encapsulation_protocol.setter
    def encapsulation_protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "encapsulation_protocol", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="isVtapEnabled")
    def is_vtap_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Used to start or stop a `Vtap` resource.
        * `TRUE` directs the VTAP to start mirroring traffic.
        * `FALSE` (Default) directs the VTAP to stop mirroring traffic.
        """
        return pulumi.get(self, "is_vtap_enabled")

    @is_vtap_enabled.setter
    def is_vtap_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_vtap_enabled", value)

    @property
    @pulumi.getter(name="lifecycleStateDetails")
    def lifecycle_state_details(self) -> Optional[pulumi.Input[str]]:
        """
        The VTAP's current running state.
        """
        return pulumi.get(self, "lifecycle_state_details")

    @lifecycle_state_details.setter
    def lifecycle_state_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lifecycle_state_details", value)

    @property
    @pulumi.getter(name="maxPacketSize")
    def max_packet_size(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The maximum size of the packets to be included in the filter.
        """
        return pulumi.get(self, "max_packet_size")

    @max_packet_size.setter
    def max_packet_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_packet_size", value)

    @property
    @pulumi.getter(name="sourceId")
    def source_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the source point where packets are captured.
        """
        return pulumi.get(self, "source_id")

    @source_id.setter
    def source_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_id", value)

    @property
    @pulumi.getter(name="sourcePrivateEndpointIp")
    def source_private_endpoint_ip(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The IP Address of the source private endpoint.
        """
        return pulumi.get(self, "source_private_endpoint_ip")

    @source_private_endpoint_ip.setter
    def source_private_endpoint_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_private_endpoint_ip", value)

    @property
    @pulumi.getter(name="sourcePrivateEndpointSubnetId")
    def source_private_endpoint_subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet that source private endpoint belongs to.
        """
        return pulumi.get(self, "source_private_endpoint_subnet_id")

    @source_private_endpoint_subnet_id.setter
    def source_private_endpoint_subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_private_endpoint_subnet_id", value)

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The source type for the VTAP.
        """
        return pulumi.get(self, "source_type")

    @source_type.setter
    def source_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_type", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The VTAP's administrative lifecycle state.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="targetId")
    def target_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the destination resource where mirrored packets are sent.
        """
        return pulumi.get(self, "target_id")

    @target_id.setter
    def target_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_id", value)

    @property
    @pulumi.getter(name="targetIp")
    def target_ip(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The IP address of the destination resource where mirrored packets are sent.
        """
        return pulumi.get(self, "target_ip")

    @target_ip.setter
    def target_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_ip", value)

    @property
    @pulumi.getter(name="targetType")
    def target_type(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The target type for the VTAP.
        """
        return pulumi.get(self, "target_type")

    @target_type.setter
    def target_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_type", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the VTAP was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2020-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="trafficMode")
    def traffic_mode(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Used to control the priority of traffic. It is an optional field. If it not passed, the value is DEFAULT
        """
        return pulumi.get(self, "traffic_mode")

    @traffic_mode.setter
    def traffic_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "traffic_mode", value)

    @property
    @pulumi.getter(name="vcnId")
    def vcn_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VCN containing the `Vtap` resource.
        """
        return pulumi.get(self, "vcn_id")

    @vcn_id.setter
    def vcn_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vcn_id", value)

    @property
    @pulumi.getter(name="vxlanNetworkIdentifier")
    def vxlan_network_identifier(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The virtual extensible LAN (VXLAN) network identifier (or VXLAN segment ID) that uniquely identifies the VXLAN. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "vxlan_network_identifier")

    @vxlan_network_identifier.setter
    def vxlan_network_identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vxlan_network_identifier", value)


class Vtap(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 capture_filter_id: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 encapsulation_protocol: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 is_vtap_enabled: Optional[pulumi.Input[bool]] = None,
                 max_packet_size: Optional[pulumi.Input[int]] = None,
                 source_id: Optional[pulumi.Input[str]] = None,
                 source_private_endpoint_ip: Optional[pulumi.Input[str]] = None,
                 source_private_endpoint_subnet_id: Optional[pulumi.Input[str]] = None,
                 source_type: Optional[pulumi.Input[str]] = None,
                 target_id: Optional[pulumi.Input[str]] = None,
                 target_ip: Optional[pulumi.Input[str]] = None,
                 target_type: Optional[pulumi.Input[str]] = None,
                 traffic_mode: Optional[pulumi.Input[str]] = None,
                 vcn_id: Optional[pulumi.Input[str]] = None,
                 vxlan_network_identifier: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Vtap resource in Oracle Cloud Infrastructure Core service.

        Creates a virtual test access point (VTAP) in the specified compartment.

        For the purposes of access control, you must provide the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the VTAP.
        For more information about compartments and access control, see
        [Overview of the IAM Service](https://docs.cloud.oracle.com/iaas/Content/Identity/Concepts/overview.htm).
        For information about OCIDs, see [Resource Identifiers](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).

        You may optionally specify a *display name* for the VTAP, otherwise a default is provided.
        It does not have to be unique, and you can change it.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_vtap = oci.core.Vtap("test_vtap",
            capture_filter_id=test_capture_filter["id"],
            compartment_id=compartment_id,
            source_id=test_source["id"],
            vcn_id=test_vcn["id"],
            defined_tags={
                "Operations.CostCenter": "42",
            },
            display_name=vtap_display_name,
            encapsulation_protocol=vtap_encapsulation_protocol,
            freeform_tags={
                "Department": "Finance",
            },
            is_vtap_enabled=vtap_is_vtap_enabled,
            max_packet_size=vtap_max_packet_size,
            source_private_endpoint_ip=vtap_source_private_endpoint_ip,
            source_private_endpoint_subnet_id=test_subnet["id"],
            source_type=vtap_source_type,
            target_id=test_target["id"],
            target_ip=vtap_target_ip,
            target_type=vtap_target_type,
            traffic_mode=vtap_traffic_mode,
            vxlan_network_identifier=vtap_vxlan_network_identifier)
        ```

        ## Import

        Vtaps can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Core/vtap:Vtap test_vtap "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] capture_filter_id: (Updatable) The capture filter's Oracle ID ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)).
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the `Vtap` resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[str] encapsulation_protocol: (Updatable) Defines an encapsulation header type for the VTAP's mirrored traffic.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[bool] is_vtap_enabled: (Updatable) Used to start or stop a `Vtap` resource.
               * `TRUE` directs the VTAP to start mirroring traffic.
               * `FALSE` (Default) directs the VTAP to stop mirroring traffic.
        :param pulumi.Input[int] max_packet_size: (Updatable) The maximum size of the packets to be included in the filter.
        :param pulumi.Input[str] source_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the source point where packets are captured.
        :param pulumi.Input[str] source_private_endpoint_ip: (Updatable) The IP Address of the source private endpoint.
        :param pulumi.Input[str] source_private_endpoint_subnet_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet that source private endpoint belongs to.
        :param pulumi.Input[str] source_type: (Updatable) The source type for the VTAP.
        :param pulumi.Input[str] target_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the destination resource where mirrored packets are sent.
        :param pulumi.Input[str] target_ip: (Updatable) The IP address of the destination resource where mirrored packets are sent.
        :param pulumi.Input[str] target_type: (Updatable) The target type for the VTAP.
        :param pulumi.Input[str] traffic_mode: (Updatable) Used to control the priority of traffic. It is an optional field. If it not passed, the value is DEFAULT
        :param pulumi.Input[str] vcn_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VCN containing the `Vtap` resource.
        :param pulumi.Input[str] vxlan_network_identifier: (Updatable) The virtual extensible LAN (VXLAN) network identifier (or VXLAN segment ID) that uniquely identifies the VXLAN. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VtapArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Vtap resource in Oracle Cloud Infrastructure Core service.

        Creates a virtual test access point (VTAP) in the specified compartment.

        For the purposes of access control, you must provide the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the VTAP.
        For more information about compartments and access control, see
        [Overview of the IAM Service](https://docs.cloud.oracle.com/iaas/Content/Identity/Concepts/overview.htm).
        For information about OCIDs, see [Resource Identifiers](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).

        You may optionally specify a *display name* for the VTAP, otherwise a default is provided.
        It does not have to be unique, and you can change it.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_vtap = oci.core.Vtap("test_vtap",
            capture_filter_id=test_capture_filter["id"],
            compartment_id=compartment_id,
            source_id=test_source["id"],
            vcn_id=test_vcn["id"],
            defined_tags={
                "Operations.CostCenter": "42",
            },
            display_name=vtap_display_name,
            encapsulation_protocol=vtap_encapsulation_protocol,
            freeform_tags={
                "Department": "Finance",
            },
            is_vtap_enabled=vtap_is_vtap_enabled,
            max_packet_size=vtap_max_packet_size,
            source_private_endpoint_ip=vtap_source_private_endpoint_ip,
            source_private_endpoint_subnet_id=test_subnet["id"],
            source_type=vtap_source_type,
            target_id=test_target["id"],
            target_ip=vtap_target_ip,
            target_type=vtap_target_type,
            traffic_mode=vtap_traffic_mode,
            vxlan_network_identifier=vtap_vxlan_network_identifier)
        ```

        ## Import

        Vtaps can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Core/vtap:Vtap test_vtap "id"
        ```

        :param str resource_name: The name of the resource.
        :param VtapArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VtapArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 capture_filter_id: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 encapsulation_protocol: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 is_vtap_enabled: Optional[pulumi.Input[bool]] = None,
                 max_packet_size: Optional[pulumi.Input[int]] = None,
                 source_id: Optional[pulumi.Input[str]] = None,
                 source_private_endpoint_ip: Optional[pulumi.Input[str]] = None,
                 source_private_endpoint_subnet_id: Optional[pulumi.Input[str]] = None,
                 source_type: Optional[pulumi.Input[str]] = None,
                 target_id: Optional[pulumi.Input[str]] = None,
                 target_ip: Optional[pulumi.Input[str]] = None,
                 target_type: Optional[pulumi.Input[str]] = None,
                 traffic_mode: Optional[pulumi.Input[str]] = None,
                 vcn_id: Optional[pulumi.Input[str]] = None,
                 vxlan_network_identifier: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VtapArgs.__new__(VtapArgs)

            if capture_filter_id is None and not opts.urn:
                raise TypeError("Missing required property 'capture_filter_id'")
            __props__.__dict__["capture_filter_id"] = capture_filter_id
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["encapsulation_protocol"] = encapsulation_protocol
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["is_vtap_enabled"] = is_vtap_enabled
            __props__.__dict__["max_packet_size"] = max_packet_size
            if source_id is None and not opts.urn:
                raise TypeError("Missing required property 'source_id'")
            __props__.__dict__["source_id"] = source_id
            __props__.__dict__["source_private_endpoint_ip"] = source_private_endpoint_ip
            __props__.__dict__["source_private_endpoint_subnet_id"] = source_private_endpoint_subnet_id
            __props__.__dict__["source_type"] = source_type
            __props__.__dict__["target_id"] = target_id
            __props__.__dict__["target_ip"] = target_ip
            __props__.__dict__["target_type"] = target_type
            __props__.__dict__["traffic_mode"] = traffic_mode
            if vcn_id is None and not opts.urn:
                raise TypeError("Missing required property 'vcn_id'")
            __props__.__dict__["vcn_id"] = vcn_id
            __props__.__dict__["vxlan_network_identifier"] = vxlan_network_identifier
            __props__.__dict__["lifecycle_state_details"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["time_created"] = None
        super(Vtap, __self__).__init__(
            'oci:Core/vtap:Vtap',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            capture_filter_id: Optional[pulumi.Input[str]] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            encapsulation_protocol: Optional[pulumi.Input[str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            is_vtap_enabled: Optional[pulumi.Input[bool]] = None,
            lifecycle_state_details: Optional[pulumi.Input[str]] = None,
            max_packet_size: Optional[pulumi.Input[int]] = None,
            source_id: Optional[pulumi.Input[str]] = None,
            source_private_endpoint_ip: Optional[pulumi.Input[str]] = None,
            source_private_endpoint_subnet_id: Optional[pulumi.Input[str]] = None,
            source_type: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            target_id: Optional[pulumi.Input[str]] = None,
            target_ip: Optional[pulumi.Input[str]] = None,
            target_type: Optional[pulumi.Input[str]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            traffic_mode: Optional[pulumi.Input[str]] = None,
            vcn_id: Optional[pulumi.Input[str]] = None,
            vxlan_network_identifier: Optional[pulumi.Input[str]] = None) -> 'Vtap':
        """
        Get an existing Vtap resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] capture_filter_id: (Updatable) The capture filter's Oracle ID ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)).
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the `Vtap` resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[str] encapsulation_protocol: (Updatable) Defines an encapsulation header type for the VTAP's mirrored traffic.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[bool] is_vtap_enabled: (Updatable) Used to start or stop a `Vtap` resource.
               * `TRUE` directs the VTAP to start mirroring traffic.
               * `FALSE` (Default) directs the VTAP to stop mirroring traffic.
        :param pulumi.Input[str] lifecycle_state_details: The VTAP's current running state.
        :param pulumi.Input[int] max_packet_size: (Updatable) The maximum size of the packets to be included in the filter.
        :param pulumi.Input[str] source_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the source point where packets are captured.
        :param pulumi.Input[str] source_private_endpoint_ip: (Updatable) The IP Address of the source private endpoint.
        :param pulumi.Input[str] source_private_endpoint_subnet_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet that source private endpoint belongs to.
        :param pulumi.Input[str] source_type: (Updatable) The source type for the VTAP.
        :param pulumi.Input[str] state: The VTAP's administrative lifecycle state.
        :param pulumi.Input[str] target_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the destination resource where mirrored packets are sent.
        :param pulumi.Input[str] target_ip: (Updatable) The IP address of the destination resource where mirrored packets are sent.
        :param pulumi.Input[str] target_type: (Updatable) The target type for the VTAP.
        :param pulumi.Input[str] time_created: The date and time the VTAP was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2020-08-25T21:10:29.600Z`
        :param pulumi.Input[str] traffic_mode: (Updatable) Used to control the priority of traffic. It is an optional field. If it not passed, the value is DEFAULT
        :param pulumi.Input[str] vcn_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VCN containing the `Vtap` resource.
        :param pulumi.Input[str] vxlan_network_identifier: (Updatable) The virtual extensible LAN (VXLAN) network identifier (or VXLAN segment ID) that uniquely identifies the VXLAN. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VtapState.__new__(_VtapState)

        __props__.__dict__["capture_filter_id"] = capture_filter_id
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["encapsulation_protocol"] = encapsulation_protocol
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["is_vtap_enabled"] = is_vtap_enabled
        __props__.__dict__["lifecycle_state_details"] = lifecycle_state_details
        __props__.__dict__["max_packet_size"] = max_packet_size
        __props__.__dict__["source_id"] = source_id
        __props__.__dict__["source_private_endpoint_ip"] = source_private_endpoint_ip
        __props__.__dict__["source_private_endpoint_subnet_id"] = source_private_endpoint_subnet_id
        __props__.__dict__["source_type"] = source_type
        __props__.__dict__["state"] = state
        __props__.__dict__["target_id"] = target_id
        __props__.__dict__["target_ip"] = target_ip
        __props__.__dict__["target_type"] = target_type
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["traffic_mode"] = traffic_mode
        __props__.__dict__["vcn_id"] = vcn_id
        __props__.__dict__["vxlan_network_identifier"] = vxlan_network_identifier
        return Vtap(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="captureFilterId")
    def capture_filter_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The capture filter's Oracle ID ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)).
        """
        return pulumi.get(self, "capture_filter_id")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the `Vtap` resource.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="encapsulationProtocol")
    def encapsulation_protocol(self) -> pulumi.Output[str]:
        """
        (Updatable) Defines an encapsulation header type for the VTAP's mirrored traffic.
        """
        return pulumi.get(self, "encapsulation_protocol")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, str]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="isVtapEnabled")
    def is_vtap_enabled(self) -> pulumi.Output[bool]:
        """
        (Updatable) Used to start or stop a `Vtap` resource.
        * `TRUE` directs the VTAP to start mirroring traffic.
        * `FALSE` (Default) directs the VTAP to stop mirroring traffic.
        """
        return pulumi.get(self, "is_vtap_enabled")

    @property
    @pulumi.getter(name="lifecycleStateDetails")
    def lifecycle_state_details(self) -> pulumi.Output[str]:
        """
        The VTAP's current running state.
        """
        return pulumi.get(self, "lifecycle_state_details")

    @property
    @pulumi.getter(name="maxPacketSize")
    def max_packet_size(self) -> pulumi.Output[int]:
        """
        (Updatable) The maximum size of the packets to be included in the filter.
        """
        return pulumi.get(self, "max_packet_size")

    @property
    @pulumi.getter(name="sourceId")
    def source_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the source point where packets are captured.
        """
        return pulumi.get(self, "source_id")

    @property
    @pulumi.getter(name="sourcePrivateEndpointIp")
    def source_private_endpoint_ip(self) -> pulumi.Output[str]:
        """
        (Updatable) The IP Address of the source private endpoint.
        """
        return pulumi.get(self, "source_private_endpoint_ip")

    @property
    @pulumi.getter(name="sourcePrivateEndpointSubnetId")
    def source_private_endpoint_subnet_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet that source private endpoint belongs to.
        """
        return pulumi.get(self, "source_private_endpoint_subnet_id")

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> pulumi.Output[str]:
        """
        (Updatable) The source type for the VTAP.
        """
        return pulumi.get(self, "source_type")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The VTAP's administrative lifecycle state.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="targetId")
    def target_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the destination resource where mirrored packets are sent.
        """
        return pulumi.get(self, "target_id")

    @property
    @pulumi.getter(name="targetIp")
    def target_ip(self) -> pulumi.Output[str]:
        """
        (Updatable) The IP address of the destination resource where mirrored packets are sent.
        """
        return pulumi.get(self, "target_ip")

    @property
    @pulumi.getter(name="targetType")
    def target_type(self) -> pulumi.Output[str]:
        """
        (Updatable) The target type for the VTAP.
        """
        return pulumi.get(self, "target_type")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The date and time the VTAP was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2020-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="trafficMode")
    def traffic_mode(self) -> pulumi.Output[str]:
        """
        (Updatable) Used to control the priority of traffic. It is an optional field. If it not passed, the value is DEFAULT
        """
        return pulumi.get(self, "traffic_mode")

    @property
    @pulumi.getter(name="vcnId")
    def vcn_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VCN containing the `Vtap` resource.
        """
        return pulumi.get(self, "vcn_id")

    @property
    @pulumi.getter(name="vxlanNetworkIdentifier")
    def vxlan_network_identifier(self) -> pulumi.Output[str]:
        """
        (Updatable) The virtual extensible LAN (VXLAN) network identifier (or VXLAN segment ID) that uniquely identifies the VXLAN. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "vxlan_network_identifier")

