# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetDesktopPoolResult',
    'AwaitableGetDesktopPoolResult',
    'get_desktop_pool',
    'get_desktop_pool_output',
]

@pulumi.output_type
class GetDesktopPoolResult:
    """
    A collection of values returned by getDesktopPool.
    """
    def __init__(__self__, active_desktops=None, are_privileged_users=None, are_volumes_preserved=None, availability_domain=None, availability_policies=None, compartment_id=None, contact_details=None, defined_tags=None, description=None, desktop_pool_id=None, device_policies=None, display_name=None, freeform_tags=None, id=None, images=None, is_storage_enabled=None, maximum_size=None, network_configurations=None, nsg_ids=None, private_access_details=None, session_lifecycle_actions=None, shape_configs=None, shape_name=None, standby_size=None, state=None, storage_backup_policy_id=None, storage_size_in_gbs=None, time_created=None, time_start_scheduled=None, time_stop_scheduled=None, use_dedicated_vm_host=None):
        if active_desktops and not isinstance(active_desktops, int):
            raise TypeError("Expected argument 'active_desktops' to be a int")
        pulumi.set(__self__, "active_desktops", active_desktops)
        if are_privileged_users and not isinstance(are_privileged_users, bool):
            raise TypeError("Expected argument 'are_privileged_users' to be a bool")
        pulumi.set(__self__, "are_privileged_users", are_privileged_users)
        if are_volumes_preserved and not isinstance(are_volumes_preserved, bool):
            raise TypeError("Expected argument 'are_volumes_preserved' to be a bool")
        pulumi.set(__self__, "are_volumes_preserved", are_volumes_preserved)
        if availability_domain and not isinstance(availability_domain, str):
            raise TypeError("Expected argument 'availability_domain' to be a str")
        pulumi.set(__self__, "availability_domain", availability_domain)
        if availability_policies and not isinstance(availability_policies, list):
            raise TypeError("Expected argument 'availability_policies' to be a list")
        pulumi.set(__self__, "availability_policies", availability_policies)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if contact_details and not isinstance(contact_details, str):
            raise TypeError("Expected argument 'contact_details' to be a str")
        pulumi.set(__self__, "contact_details", contact_details)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if desktop_pool_id and not isinstance(desktop_pool_id, str):
            raise TypeError("Expected argument 'desktop_pool_id' to be a str")
        pulumi.set(__self__, "desktop_pool_id", desktop_pool_id)
        if device_policies and not isinstance(device_policies, list):
            raise TypeError("Expected argument 'device_policies' to be a list")
        pulumi.set(__self__, "device_policies", device_policies)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if images and not isinstance(images, list):
            raise TypeError("Expected argument 'images' to be a list")
        pulumi.set(__self__, "images", images)
        if is_storage_enabled and not isinstance(is_storage_enabled, bool):
            raise TypeError("Expected argument 'is_storage_enabled' to be a bool")
        pulumi.set(__self__, "is_storage_enabled", is_storage_enabled)
        if maximum_size and not isinstance(maximum_size, int):
            raise TypeError("Expected argument 'maximum_size' to be a int")
        pulumi.set(__self__, "maximum_size", maximum_size)
        if network_configurations and not isinstance(network_configurations, list):
            raise TypeError("Expected argument 'network_configurations' to be a list")
        pulumi.set(__self__, "network_configurations", network_configurations)
        if nsg_ids and not isinstance(nsg_ids, list):
            raise TypeError("Expected argument 'nsg_ids' to be a list")
        pulumi.set(__self__, "nsg_ids", nsg_ids)
        if private_access_details and not isinstance(private_access_details, list):
            raise TypeError("Expected argument 'private_access_details' to be a list")
        pulumi.set(__self__, "private_access_details", private_access_details)
        if session_lifecycle_actions and not isinstance(session_lifecycle_actions, list):
            raise TypeError("Expected argument 'session_lifecycle_actions' to be a list")
        pulumi.set(__self__, "session_lifecycle_actions", session_lifecycle_actions)
        if shape_configs and not isinstance(shape_configs, list):
            raise TypeError("Expected argument 'shape_configs' to be a list")
        pulumi.set(__self__, "shape_configs", shape_configs)
        if shape_name and not isinstance(shape_name, str):
            raise TypeError("Expected argument 'shape_name' to be a str")
        pulumi.set(__self__, "shape_name", shape_name)
        if standby_size and not isinstance(standby_size, int):
            raise TypeError("Expected argument 'standby_size' to be a int")
        pulumi.set(__self__, "standby_size", standby_size)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if storage_backup_policy_id and not isinstance(storage_backup_policy_id, str):
            raise TypeError("Expected argument 'storage_backup_policy_id' to be a str")
        pulumi.set(__self__, "storage_backup_policy_id", storage_backup_policy_id)
        if storage_size_in_gbs and not isinstance(storage_size_in_gbs, int):
            raise TypeError("Expected argument 'storage_size_in_gbs' to be a int")
        pulumi.set(__self__, "storage_size_in_gbs", storage_size_in_gbs)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_start_scheduled and not isinstance(time_start_scheduled, str):
            raise TypeError("Expected argument 'time_start_scheduled' to be a str")
        pulumi.set(__self__, "time_start_scheduled", time_start_scheduled)
        if time_stop_scheduled and not isinstance(time_stop_scheduled, str):
            raise TypeError("Expected argument 'time_stop_scheduled' to be a str")
        pulumi.set(__self__, "time_stop_scheduled", time_stop_scheduled)
        if use_dedicated_vm_host and not isinstance(use_dedicated_vm_host, str):
            raise TypeError("Expected argument 'use_dedicated_vm_host' to be a str")
        pulumi.set(__self__, "use_dedicated_vm_host", use_dedicated_vm_host)

    @property
    @pulumi.getter(name="activeDesktops")
    def active_desktops(self) -> int:
        """
        The number of active desktops in the desktop pool.
        """
        return pulumi.get(self, "active_desktops")

    @property
    @pulumi.getter(name="arePrivilegedUsers")
    def are_privileged_users(self) -> bool:
        """
        Indicates whether desktop pool users have administrative privileges on their desktop.
        """
        return pulumi.get(self, "are_privileged_users")

    @property
    @pulumi.getter(name="areVolumesPreserved")
    def are_volumes_preserved(self) -> bool:
        return pulumi.get(self, "are_volumes_preserved")

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> str:
        """
        The availability domain of the desktop pool.
        """
        return pulumi.get(self, "availability_domain")

    @property
    @pulumi.getter(name="availabilityPolicies")
    def availability_policies(self) -> Sequence['outputs.GetDesktopPoolAvailabilityPolicyResult']:
        """
        Provides the start and stop schedule information for desktop availability of the desktop pool.
        """
        return pulumi.get(self, "availability_policies")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment of the desktop pool.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="contactDetails")
    def contact_details(self) -> str:
        """
        Contact information of the desktop pool administrator. Avoid entering confidential information.
        """
        return pulumi.get(self, "contact_details")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        A user friendly description providing additional information about the resource. Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="desktopPoolId")
    def desktop_pool_id(self) -> str:
        return pulumi.get(self, "desktop_pool_id")

    @property
    @pulumi.getter(name="devicePolicies")
    def device_policies(self) -> Sequence['outputs.GetDesktopPoolDevicePolicyResult']:
        """
        Provides the settings for desktop and client device options, such as audio in and out, client drive mapping, and clipboard access.
        """
        return pulumi.get(self, "device_policies")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A user friendly display name. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The OCID of the desktop pool.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def images(self) -> Sequence['outputs.GetDesktopPoolImageResult']:
        """
        Provides information about the desktop image.
        """
        return pulumi.get(self, "images")

    @property
    @pulumi.getter(name="isStorageEnabled")
    def is_storage_enabled(self) -> bool:
        """
        Indicates whether storage is enabled for the desktop pool.
        """
        return pulumi.get(self, "is_storage_enabled")

    @property
    @pulumi.getter(name="maximumSize")
    def maximum_size(self) -> int:
        """
        The maximum number of desktops permitted in the desktop pool.
        """
        return pulumi.get(self, "maximum_size")

    @property
    @pulumi.getter(name="networkConfigurations")
    def network_configurations(self) -> Sequence['outputs.GetDesktopPoolNetworkConfigurationResult']:
        """
        Provides information about the network configuration of the desktop pool.
        """
        return pulumi.get(self, "network_configurations")

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Sequence[str]:
        """
        A list of network security groups for the private access.
        """
        return pulumi.get(self, "nsg_ids")

    @property
    @pulumi.getter(name="privateAccessDetails")
    def private_access_details(self) -> Sequence['outputs.GetDesktopPoolPrivateAccessDetailResult']:
        """
        The details of the desktop's private access network connectivity that were used to create the pool.
        """
        return pulumi.get(self, "private_access_details")

    @property
    @pulumi.getter(name="sessionLifecycleActions")
    def session_lifecycle_actions(self) -> Sequence['outputs.GetDesktopPoolSessionLifecycleActionResult']:
        """
        Action to be triggered on inactivity or disconnect
        """
        return pulumi.get(self, "session_lifecycle_actions")

    @property
    @pulumi.getter(name="shapeConfigs")
    def shape_configs(self) -> Sequence['outputs.GetDesktopPoolShapeConfigResult']:
        """
        The shape configuration used for each desktop compute instance in the desktop pool.
        """
        return pulumi.get(self, "shape_configs")

    @property
    @pulumi.getter(name="shapeName")
    def shape_name(self) -> str:
        """
        The shape of the desktop pool.
        """
        return pulumi.get(self, "shape_name")

    @property
    @pulumi.getter(name="standbySize")
    def standby_size(self) -> int:
        """
        The maximum number of standby desktops available in the desktop pool.
        """
        return pulumi.get(self, "standby_size")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the desktop pool.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="storageBackupPolicyId")
    def storage_backup_policy_id(self) -> str:
        """
        The backup policy OCID of the storage.
        """
        return pulumi.get(self, "storage_backup_policy_id")

    @property
    @pulumi.getter(name="storageSizeInGbs")
    def storage_size_in_gbs(self) -> int:
        """
        The size in GBs of the storage for the desktop pool.
        """
        return pulumi.get(self, "storage_size_in_gbs")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the resource was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeStartScheduled")
    def time_start_scheduled(self) -> str:
        """
        The start time of the desktop pool.
        """
        return pulumi.get(self, "time_start_scheduled")

    @property
    @pulumi.getter(name="timeStopScheduled")
    def time_stop_scheduled(self) -> str:
        """
        The stop time of the desktop pool.
        """
        return pulumi.get(self, "time_stop_scheduled")

    @property
    @pulumi.getter(name="useDedicatedVmHost")
    def use_dedicated_vm_host(self) -> str:
        """
        Indicates whether the desktop pool uses dedicated virtual machine hosts.
        ---
        """
        return pulumi.get(self, "use_dedicated_vm_host")


class AwaitableGetDesktopPoolResult(GetDesktopPoolResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDesktopPoolResult(
            active_desktops=self.active_desktops,
            are_privileged_users=self.are_privileged_users,
            are_volumes_preserved=self.are_volumes_preserved,
            availability_domain=self.availability_domain,
            availability_policies=self.availability_policies,
            compartment_id=self.compartment_id,
            contact_details=self.contact_details,
            defined_tags=self.defined_tags,
            description=self.description,
            desktop_pool_id=self.desktop_pool_id,
            device_policies=self.device_policies,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            images=self.images,
            is_storage_enabled=self.is_storage_enabled,
            maximum_size=self.maximum_size,
            network_configurations=self.network_configurations,
            nsg_ids=self.nsg_ids,
            private_access_details=self.private_access_details,
            session_lifecycle_actions=self.session_lifecycle_actions,
            shape_configs=self.shape_configs,
            shape_name=self.shape_name,
            standby_size=self.standby_size,
            state=self.state,
            storage_backup_policy_id=self.storage_backup_policy_id,
            storage_size_in_gbs=self.storage_size_in_gbs,
            time_created=self.time_created,
            time_start_scheduled=self.time_start_scheduled,
            time_stop_scheduled=self.time_stop_scheduled,
            use_dedicated_vm_host=self.use_dedicated_vm_host)


def get_desktop_pool(desktop_pool_id: Optional[str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDesktopPoolResult:
    """
    This data source provides details about a specific Desktop Pool resource in Oracle Cloud Infrastructure Desktops service.

    Returns information about the desktop pool including all configuration parameters and the current state.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_desktop_pool = oci.Desktops.get_desktop_pool(desktop_pool_id=test_desktop_pool_oci_desktops_desktop_pool["id"])
    ```


    :param str desktop_pool_id: The OCID of the desktop pool.
    """
    __args__ = dict()
    __args__['desktopPoolId'] = desktop_pool_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Desktops/getDesktopPool:getDesktopPool', __args__, opts=opts, typ=GetDesktopPoolResult).value

    return AwaitableGetDesktopPoolResult(
        active_desktops=pulumi.get(__ret__, 'active_desktops'),
        are_privileged_users=pulumi.get(__ret__, 'are_privileged_users'),
        are_volumes_preserved=pulumi.get(__ret__, 'are_volumes_preserved'),
        availability_domain=pulumi.get(__ret__, 'availability_domain'),
        availability_policies=pulumi.get(__ret__, 'availability_policies'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        contact_details=pulumi.get(__ret__, 'contact_details'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        description=pulumi.get(__ret__, 'description'),
        desktop_pool_id=pulumi.get(__ret__, 'desktop_pool_id'),
        device_policies=pulumi.get(__ret__, 'device_policies'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        images=pulumi.get(__ret__, 'images'),
        is_storage_enabled=pulumi.get(__ret__, 'is_storage_enabled'),
        maximum_size=pulumi.get(__ret__, 'maximum_size'),
        network_configurations=pulumi.get(__ret__, 'network_configurations'),
        nsg_ids=pulumi.get(__ret__, 'nsg_ids'),
        private_access_details=pulumi.get(__ret__, 'private_access_details'),
        session_lifecycle_actions=pulumi.get(__ret__, 'session_lifecycle_actions'),
        shape_configs=pulumi.get(__ret__, 'shape_configs'),
        shape_name=pulumi.get(__ret__, 'shape_name'),
        standby_size=pulumi.get(__ret__, 'standby_size'),
        state=pulumi.get(__ret__, 'state'),
        storage_backup_policy_id=pulumi.get(__ret__, 'storage_backup_policy_id'),
        storage_size_in_gbs=pulumi.get(__ret__, 'storage_size_in_gbs'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_start_scheduled=pulumi.get(__ret__, 'time_start_scheduled'),
        time_stop_scheduled=pulumi.get(__ret__, 'time_stop_scheduled'),
        use_dedicated_vm_host=pulumi.get(__ret__, 'use_dedicated_vm_host'))
def get_desktop_pool_output(desktop_pool_id: Optional[pulumi.Input[str]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDesktopPoolResult]:
    """
    This data source provides details about a specific Desktop Pool resource in Oracle Cloud Infrastructure Desktops service.

    Returns information about the desktop pool including all configuration parameters and the current state.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_desktop_pool = oci.Desktops.get_desktop_pool(desktop_pool_id=test_desktop_pool_oci_desktops_desktop_pool["id"])
    ```


    :param str desktop_pool_id: The OCID of the desktop pool.
    """
    __args__ = dict()
    __args__['desktopPoolId'] = desktop_pool_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Desktops/getDesktopPool:getDesktopPool', __args__, opts=opts, typ=GetDesktopPoolResult)
    return __ret__.apply(lambda __response__: GetDesktopPoolResult(
        active_desktops=pulumi.get(__response__, 'active_desktops'),
        are_privileged_users=pulumi.get(__response__, 'are_privileged_users'),
        are_volumes_preserved=pulumi.get(__response__, 'are_volumes_preserved'),
        availability_domain=pulumi.get(__response__, 'availability_domain'),
        availability_policies=pulumi.get(__response__, 'availability_policies'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        contact_details=pulumi.get(__response__, 'contact_details'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        description=pulumi.get(__response__, 'description'),
        desktop_pool_id=pulumi.get(__response__, 'desktop_pool_id'),
        device_policies=pulumi.get(__response__, 'device_policies'),
        display_name=pulumi.get(__response__, 'display_name'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        images=pulumi.get(__response__, 'images'),
        is_storage_enabled=pulumi.get(__response__, 'is_storage_enabled'),
        maximum_size=pulumi.get(__response__, 'maximum_size'),
        network_configurations=pulumi.get(__response__, 'network_configurations'),
        nsg_ids=pulumi.get(__response__, 'nsg_ids'),
        private_access_details=pulumi.get(__response__, 'private_access_details'),
        session_lifecycle_actions=pulumi.get(__response__, 'session_lifecycle_actions'),
        shape_configs=pulumi.get(__response__, 'shape_configs'),
        shape_name=pulumi.get(__response__, 'shape_name'),
        standby_size=pulumi.get(__response__, 'standby_size'),
        state=pulumi.get(__response__, 'state'),
        storage_backup_policy_id=pulumi.get(__response__, 'storage_backup_policy_id'),
        storage_size_in_gbs=pulumi.get(__response__, 'storage_size_in_gbs'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_start_scheduled=pulumi.get(__response__, 'time_start_scheduled'),
        time_stop_scheduled=pulumi.get(__response__, 'time_stop_scheduled'),
        use_dedicated_vm_host=pulumi.get(__response__, 'use_dedicated_vm_host')))
