# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetResolversResult',
    'AwaitableGetResolversResult',
    'get_resolvers',
    'get_resolvers_output',
]

@pulumi.output_type
class GetResolversResult:
    """
    A collection of values returned by getResolvers.
    """
    def __init__(__self__, compartment_id=None, display_name=None, filters=None, id=None, resolvers=None, scope=None, state=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if resolvers and not isinstance(resolvers, list):
            raise TypeError("Expected argument 'resolvers' to be a list")
        pulumi.set(__self__, "resolvers", resolvers)
        if scope and not isinstance(scope, str):
            raise TypeError("Expected argument 'scope' to be a str")
        pulumi.set(__self__, "scope", scope)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the owning compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        The display name of the resolver.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetResolversFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The OCID of the resolver.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def resolvers(self) -> Sequence['outputs.GetResolversResolverResult']:
        """
        The list of resolvers.
        """
        return pulumi.get(self, "resolvers")

    @property
    @pulumi.getter
    def scope(self) -> str:
        return pulumi.get(self, "scope")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current state of the resource.
        """
        return pulumi.get(self, "state")


class AwaitableGetResolversResult(GetResolversResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetResolversResult(
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            resolvers=self.resolvers,
            scope=self.scope,
            state=self.state)


def get_resolvers(compartment_id: Optional[str] = None,
                  display_name: Optional[str] = None,
                  filters: Optional[Sequence[Union['GetResolversFilterArgs', 'GetResolversFilterArgsDict']]] = None,
                  id: Optional[str] = None,
                  scope: Optional[str] = None,
                  state: Optional[str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetResolversResult:
    """
    This data source provides the list of Resolvers in Oracle Cloud Infrastructure DNS service.

    Gets a list of all resolvers within a compartment.

    The collection can be filtered by display name, id, or lifecycle state. It can be sorted
    on creation time or displayName both in ASC or DESC order. Note that when no lifecycleState
    query parameter is provided, the collection does not include resolvers in the DELETED
    lifecycleState to be consistent with other operations of the API.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_resolvers = oci.Dns.get_resolvers(compartment_id=compartment_id,
        scope="PRIVATE",
        display_name=resolver_display_name,
        id=resolver_id,
        state=resolver_state)
    ```


    :param str compartment_id: The OCID of the compartment the resource belongs to.
    :param str display_name: The displayName of a resource.
    :param str id: The OCID of a resource.
    :param str scope: Value must be `PRIVATE` when listing private name resolvers.
    :param str state: The state of a resource.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['scope'] = scope
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Dns/getResolvers:getResolvers', __args__, opts=opts, typ=GetResolversResult).value

    return AwaitableGetResolversResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        resolvers=pulumi.get(__ret__, 'resolvers'),
        scope=pulumi.get(__ret__, 'scope'),
        state=pulumi.get(__ret__, 'state'))
def get_resolvers_output(compartment_id: Optional[pulumi.Input[str]] = None,
                         display_name: Optional[pulumi.Input[Optional[str]]] = None,
                         filters: Optional[pulumi.Input[Optional[Sequence[Union['GetResolversFilterArgs', 'GetResolversFilterArgsDict']]]]] = None,
                         id: Optional[pulumi.Input[Optional[str]]] = None,
                         scope: Optional[pulumi.Input[str]] = None,
                         state: Optional[pulumi.Input[Optional[str]]] = None,
                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetResolversResult]:
    """
    This data source provides the list of Resolvers in Oracle Cloud Infrastructure DNS service.

    Gets a list of all resolvers within a compartment.

    The collection can be filtered by display name, id, or lifecycle state. It can be sorted
    on creation time or displayName both in ASC or DESC order. Note that when no lifecycleState
    query parameter is provided, the collection does not include resolvers in the DELETED
    lifecycleState to be consistent with other operations of the API.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_resolvers = oci.Dns.get_resolvers(compartment_id=compartment_id,
        scope="PRIVATE",
        display_name=resolver_display_name,
        id=resolver_id,
        state=resolver_state)
    ```


    :param str compartment_id: The OCID of the compartment the resource belongs to.
    :param str display_name: The displayName of a resource.
    :param str id: The OCID of a resource.
    :param str scope: Value must be `PRIVATE` when listing private name resolvers.
    :param str state: The state of a resource.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['scope'] = scope
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Dns/getResolvers:getResolvers', __args__, opts=opts, typ=GetResolversResult)
    return __ret__.apply(lambda __response__: GetResolversResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        resolvers=pulumi.get(__response__, 'resolvers'),
        scope=pulumi.get(__response__, 'scope'),
        state=pulumi.get(__response__, 'state')))
