# Generated by Django 2.0.1 on 2018-03-14 20:48

import django.contrib.postgres.fields.jsonb
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ('geography', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='Point',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('lat', models.FloatField(help_text='Latitude coordinate in decimal degrees.')),
                ('lon', models.FloatField(help_text='Longitude coordinate in decimal degrees.')),
                ('attributes', django.contrib.postgres.fields.jsonb.JSONField(blank=True, help_text='Miscellaneous attributes on the point.', null=True)),
                ('threshold', models.PositiveSmallIntegerField(default=0, help_text='A threshold in pixels above which to display this point.')),
                ('label', models.CharField(max_length=250)),
                ('geometry', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='points', to='geography.Geometry')),
            ],
        ),
        migrations.CreateModel(
            name='PointLabelOffset',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('x', models.SmallIntegerField(default=0, help_text='Lateral offset in pixels.')),
                ('y', models.SmallIntegerField(default=0, help_text='Vertical offset in pixels.')),
                ('threshold', models.PositiveSmallIntegerField(default=0, help_text='A threshold in pixels above which to apply this offset.')),
                ('point', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='offsets', to='geography.Point')),
            ],
        ),
    ]
