# coding: utf-8

"""
    Bacalhau API

    This page is the reference of the Bacalhau REST API. Project docs are available at https://docs.bacalhau.org/. Find more information about Bacalhau at https://github.com/filecoin-project/bacalhau.  # noqa: E501

    OpenAPI spec version: 0.3.18.post4
    Contact: team@bacalhau.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from bacalhau_apiclient.configuration import Configuration


class JobShardState(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'execution_id': 'str',
        'node_id': 'str',
        'published_results': 'StorageSpec',
        'run_output': 'JobEventRunOutput',
        'shard_index': 'int',
        'state': 'JobShardStateState',
        'status': 'str',
        'verification_proposal': 'list[int]',
        'verification_result': 'VerificationResult'
    }

    attribute_map = {
        'execution_id': 'ExecutionId',
        'node_id': 'NodeId',
        'published_results': 'PublishedResults',
        'run_output': 'RunOutput',
        'shard_index': 'ShardIndex',
        'state': 'State',
        'status': 'Status',
        'verification_proposal': 'VerificationProposal',
        'verification_result': 'VerificationResult'
    }

    def __init__(self, execution_id=None, node_id=None, published_results=None, run_output=None, shard_index=None, state=None, status=None, verification_proposal=None, verification_result=None, _configuration=None):  # noqa: E501
        """JobShardState - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._execution_id = None
        self._node_id = None
        self._published_results = None
        self._run_output = None
        self._shard_index = None
        self._state = None
        self._status = None
        self._verification_proposal = None
        self._verification_result = None
        self.discriminator = None

        if execution_id is not None:
            self.execution_id = execution_id
        if node_id is not None:
            self.node_id = node_id
        if published_results is not None:
            self.published_results = published_results
        if run_output is not None:
            self.run_output = run_output
        if shard_index is not None:
            self.shard_index = shard_index
        if state is not None:
            self.state = state
        if status is not None:
            self.status = status
        if verification_proposal is not None:
            self.verification_proposal = verification_proposal
        if verification_result is not None:
            self.verification_result = verification_result

    @property
    def execution_id(self):
        """Gets the execution_id of this JobShardState.  # noqa: E501

        Compute node reference for this shard execution  # noqa: E501

        :return: The execution_id of this JobShardState.  # noqa: E501
        :rtype: str
        """
        return self._execution_id

    @execution_id.setter
    def execution_id(self, execution_id):
        """Sets the execution_id of this JobShardState.

        Compute node reference for this shard execution  # noqa: E501

        :param execution_id: The execution_id of this JobShardState.  # noqa: E501
        :type: str
        """

        self._execution_id = execution_id

    @property
    def node_id(self):
        """Gets the node_id of this JobShardState.  # noqa: E501

        which node is running this shard  # noqa: E501

        :return: The node_id of this JobShardState.  # noqa: E501
        :rtype: str
        """
        return self._node_id

    @node_id.setter
    def node_id(self, node_id):
        """Sets the node_id of this JobShardState.

        which node is running this shard  # noqa: E501

        :param node_id: The node_id of this JobShardState.  # noqa: E501
        :type: str
        """

        self._node_id = node_id

    @property
    def published_results(self):
        """Gets the published_results of this JobShardState.  # noqa: E501


        :return: The published_results of this JobShardState.  # noqa: E501
        :rtype: StorageSpec
        """
        return self._published_results

    @published_results.setter
    def published_results(self, published_results):
        """Sets the published_results of this JobShardState.


        :param published_results: The published_results of this JobShardState.  # noqa: E501
        :type: StorageSpec
        """

        self._published_results = published_results

    @property
    def run_output(self):
        """Gets the run_output of this JobShardState.  # noqa: E501


        :return: The run_output of this JobShardState.  # noqa: E501
        :rtype: JobEventRunOutput
        """
        return self._run_output

    @run_output.setter
    def run_output(self, run_output):
        """Sets the run_output of this JobShardState.


        :param run_output: The run_output of this JobShardState.  # noqa: E501
        :type: JobEventRunOutput
        """

        self._run_output = run_output

    @property
    def shard_index(self):
        """Gets the shard_index of this JobShardState.  # noqa: E501

        what shard is this we are running  # noqa: E501

        :return: The shard_index of this JobShardState.  # noqa: E501
        :rtype: int
        """
        return self._shard_index

    @shard_index.setter
    def shard_index(self, shard_index):
        """Sets the shard_index of this JobShardState.

        what shard is this we are running  # noqa: E501

        :param shard_index: The shard_index of this JobShardState.  # noqa: E501
        :type: int
        """

        self._shard_index = shard_index

    @property
    def state(self):
        """Gets the state of this JobShardState.  # noqa: E501


        :return: The state of this JobShardState.  # noqa: E501
        :rtype: JobShardStateState
        """
        return self._state

    @state.setter
    def state(self, state):
        """Sets the state of this JobShardState.


        :param state: The state of this JobShardState.  # noqa: E501
        :type: JobShardStateState
        """

        self._state = state

    @property
    def status(self):
        """Gets the status of this JobShardState.  # noqa: E501

        an arbitrary status message  # noqa: E501

        :return: The status of this JobShardState.  # noqa: E501
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this JobShardState.

        an arbitrary status message  # noqa: E501

        :param status: The status of this JobShardState.  # noqa: E501
        :type: str
        """

        self._status = status

    @property
    def verification_proposal(self):
        """Gets the verification_proposal of this JobShardState.  # noqa: E501

        the proposed results for this shard this will be resolved by the verifier somehow  # noqa: E501

        :return: The verification_proposal of this JobShardState.  # noqa: E501
        :rtype: list[int]
        """
        return self._verification_proposal

    @verification_proposal.setter
    def verification_proposal(self, verification_proposal):
        """Sets the verification_proposal of this JobShardState.

        the proposed results for this shard this will be resolved by the verifier somehow  # noqa: E501

        :param verification_proposal: The verification_proposal of this JobShardState.  # noqa: E501
        :type: list[int]
        """

        self._verification_proposal = verification_proposal

    @property
    def verification_result(self):
        """Gets the verification_result of this JobShardState.  # noqa: E501


        :return: The verification_result of this JobShardState.  # noqa: E501
        :rtype: VerificationResult
        """
        return self._verification_result

    @verification_result.setter
    def verification_result(self, verification_result):
        """Sets the verification_result of this JobShardState.


        :param verification_result: The verification_result of this JobShardState.  # noqa: E501
        :type: VerificationResult
        """

        self._verification_result = verification_result

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(JobShardState, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, JobShardState):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, JobShardState):
            return True

        return self.to_dict() != other.to_dict()
