# coding: utf-8

"""
    Demisto API

    This is the public REST API to integrate with the demisto server. HTTP request can be sent using any HTTP-client.  For an example dedicated client take a look at: https://github.com/demisto/demisto-py.  Requests must include API-key that can be generated in the Demisto web client under 'Settings' -> 'Integrations' -> 'API keys'   Optimistic Locking and Versioning\\:  When using Demisto REST API, you will need to make sure to work on the latest version of the item (incident, entry, etc.), otherwise, you will get a DB version error (which not allow you to override a newer item). In addition, you can pass 'version\\: -1' to force data override (make sure that other users data might be lost).  Assume that Alice and Bob both read the same data from Demisto server, then they both changed the data, and then both tried to write the new versions back to the server. Whose changes should be saved? Alice’s? Bob’s? To solve this, each data item in Demisto has a numeric incremental version. If Alice saved an item with version 4 and Bob trying to save the same item with version 3, Demisto will rollback Bob request and returns a DB version conflict error. Bob will need to get the latest item and work on it so Alice work will not get lost.  Example request using 'curl'\\:  ``` curl 'https://hostname:443/incidents/search' -H 'content-type: application/json' -H 'accept: application/json' -H 'Authorization: <API Key goes here>' --data-binary '{\"filter\":{\"query\":\"-status:closed -category:job\",\"period\":{\"by\":\"day\",\"fromValue\":7}}}' --compressed ```  # noqa: E501

    OpenAPI spec version: 2.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six
import demisto_client
import json

from demisto_client.demisto_api.api_client import ApiClient


class DefaultApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def add_ad_hoc_task(self, investigation_id, **kwargs):  # noqa: E501
        """Add ad-hoc task  # noqa: E501

        Add an ad-hoc task to a running playbook  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_ad_hoc_task(investigation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str investigation_id: investigation ID (required)
        :param InvPlaybookTaskData inv_playbook_task_data:
        :return: InvestigationPlaybook
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_ad_hoc_task_with_http_info(investigation_id, **kwargs)  # noqa: E501
        else:
            (data) = self.add_ad_hoc_task_with_http_info(investigation_id, **kwargs)  # noqa: E501
            return data

    def add_ad_hoc_task_with_http_info(self, investigation_id, **kwargs):  # noqa: E501
        """Add ad-hoc task  # noqa: E501

        Add an ad-hoc task to a running playbook  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_ad_hoc_task_with_http_info(investigation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str investigation_id: investigation ID (required)
        :param InvPlaybookTaskData inv_playbook_task_data:
        :return: InvestigationPlaybook
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['investigation_id', 'inv_playbook_task_data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_ad_hoc_task" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'investigation_id' is set
        if ('investigation_id' not in params or
                params['investigation_id'] is None):
            raise ValueError("Missing the required parameter `investigation_id` when calling `add_ad_hoc_task`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'investigation_id' in params:
            path_params['investigationId'] = params['investigation_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'inv_playbook_task_data' in params:
            body_params = params['inv_playbook_task_data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'csrf_token', 'x-xdr-auth-id']  # noqa: E501

        return self.api_client.call_api(
            '/inv-playbook/task/add/{investigationId}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InvestigationPlaybook',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def close_incidents_batch(self, **kwargs):  # noqa: E501
        """Batch close incidents  # noqa: E501

        Closes an incidents batch To update incident custom fields you should lowercase them and remove all spaces. For example: Scan IP -> scanip To get the actual key name you can also go to Demisto CLI and run /incident_add and look for the key that you would like to update  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.close_incidents_batch(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UpdateDataBatch update_data_batch:
        :return: IncidentSearchResponseWrapper
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.close_incidents_batch_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.close_incidents_batch_with_http_info(**kwargs)  # noqa: E501
            return data

    def close_incidents_batch_with_http_info(self, **kwargs):  # noqa: E501
        """Batch close incidents  # noqa: E501

        Closes an incidents batch To update incident custom fields you should lowercase them and remove all spaces. For example: Scan IP -> scanip To get the actual key name you can also go to Demisto CLI and run /incident_add and look for the key that you would like to update  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.close_incidents_batch_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UpdateDataBatch update_data_batch:
        :return: IncidentSearchResponseWrapper
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['update_data_batch']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method close_incidents_batch" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'update_data_batch' in params:
            body_params = params['update_data_batch']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'csrf_token', 'x-xdr-auth-id']  # noqa: E501

        return self.api_client.call_api(
            '/incident/batchClose', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='IncidentSearchResponseWrapper',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def complete_task(self, investigation_id, file_comment, task_id, task_input, version, file, **kwargs):  # noqa: E501
        """[Deprecated] Complete a task  # noqa: E501

        Complete a task with a file attachment Deprecated - use \"/v2/inv-playbook/task/complete\"  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.complete_task(investigation_id, file_comment, task_id, task_input, version, file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str investigation_id: investigation ID (required)
        :param str file_comment: file comment (required)
        :param str task_id: Task Id (required)
        :param str task_input: task input (required)
        :param str version: Version (required)
        :param file file: file (required)
        :param str file_name: file name
        :return: InvestigationPlaybook
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.complete_task_with_http_info(investigation_id, file_comment, task_id, task_input, version, file, **kwargs)  # noqa: E501
        else:
            (data) = self.complete_task_with_http_info(investigation_id, file_comment, task_id, task_input, version, file, **kwargs)  # noqa: E501
            return data

    def complete_task_with_http_info(self, investigation_id, file_comment, task_id, task_input, version, file, **kwargs):  # noqa: E501
        """[Deprecated] Complete a task  # noqa: E501

        Complete a task with a file attachment Deprecated - use \"/v2/inv-playbook/task/complete\"  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.complete_task_with_http_info(investigation_id, file_comment, task_id, task_input, version, file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str investigation_id: investigation ID (required)
        :param str file_comment: file comment (required)
        :param str task_id: Task Id (required)
        :param str task_input: task input (required)
        :param str version: Version (required)
        :param file file: file (required)
        :param str file_name: file name
        :return: InvestigationPlaybook
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['investigation_id', 'file_comment', 'task_id', 'task_input', 'version', 'file', 'file_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method complete_task" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'investigation_id' is set
        if ('investigation_id' not in params or
                params['investigation_id'] is None):
            raise ValueError("Missing the required parameter `investigation_id` when calling `complete_task`")  # noqa: E501
        # verify the required parameter 'file_comment' is set
        if ('file_comment' not in params or
                params['file_comment'] is None):
            raise ValueError("Missing the required parameter `file_comment` when calling `complete_task`")  # noqa: E501
        # verify the required parameter 'task_id' is set
        if ('task_id' not in params or
                params['task_id'] is None):
            raise ValueError("Missing the required parameter `task_id` when calling `complete_task`")  # noqa: E501
        # verify the required parameter 'task_input' is set
        if ('task_input' not in params or
                params['task_input'] is None):
            raise ValueError("Missing the required parameter `task_input` when calling `complete_task`")  # noqa: E501
        # verify the required parameter 'version' is set
        if ('version' not in params or
                params['version'] is None):
            raise ValueError("Missing the required parameter `version` when calling `complete_task`")  # noqa: E501
        # verify the required parameter 'file' is set
        if ('file' not in params or
                params['file'] is None):
            raise ValueError("Missing the required parameter `file` when calling `complete_task`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'investigation_id' in params:
            form_params.append(('investigationId', params['investigation_id']))  # noqa: E501
        if 'file_name' in params:
            form_params.append(('fileName', params['file_name']))  # noqa: E501
        if 'file_comment' in params:
            form_params.append(('fileComment', params['file_comment']))  # noqa: E501
        if 'task_id' in params:
            form_params.append(('taskId', params['task_id']))  # noqa: E501
        if 'task_input' in params:
            form_params.append(('taskInput', params['task_input']))  # noqa: E501
        if 'version' in params:
            form_params.append(('version', params['version']))  # noqa: E501
        if 'file' in params:
            local_var_files['file'] = params['file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'csrf_token', 'x-xdr-auth-id']  # noqa: E501

        return self.api_client.call_api(
            '/inv-playbook/task/complete', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InvestigationPlaybook',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def complete_task_v2(self, investigation_id, task_id, task_input, version, file, **kwargs):  # noqa: E501
        """Complete a task  # noqa: E501

        Complete a task with command and multiple file attachments  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.complete_task_v2(investigation_id, task_id, task_input, version, file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str investigation_id: investigation ID (required)
        :param str task_id: Task Id (required)
        :param str task_input: Task input (required)
        :param str version: Version (required)
        :param file file: Files to attach to the task (required)
        :param str task_comment: Task comment or command to run
        :param str file_names: file names separated by %###% (only if files provided)
        :param str file_comments: file comment separated by %###% (only if files provided)
        :return: InvestigationPlaybook
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.complete_task_v2_with_http_info(investigation_id, task_id, task_input, version, file, **kwargs)  # noqa: E501
        else:
            (data) = self.complete_task_v2_with_http_info(investigation_id, task_id, task_input, version, file, **kwargs)  # noqa: E501
            return data

    def complete_task_v2_with_http_info(self, investigation_id, task_id, task_input, version, file, **kwargs):  # noqa: E501
        """Complete a task  # noqa: E501

        Complete a task with command and multiple file attachments  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.complete_task_v2_with_http_info(investigation_id, task_id, task_input, version, file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str investigation_id: investigation ID (required)
        :param str task_id: Task Id (required)
        :param str task_input: Task input (required)
        :param str version: Version (required)
        :param file file: Files to attach to the task (required)
        :param str task_comment: Task comment or command to run
        :param str file_names: file names separated by %###% (only if files provided)
        :param str file_comments: file comment separated by %###% (only if files provided)
        :return: InvestigationPlaybook
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['investigation_id', 'task_id', 'task_input', 'version', 'file', 'task_comment', 'file_names', 'file_comments']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method complete_task_v2" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'investigation_id' is set
        if ('investigation_id' not in params or
                params['investigation_id'] is None):
            raise ValueError("Missing the required parameter `investigation_id` when calling `complete_task_v2`")  # noqa: E501
        # verify the required parameter 'task_id' is set
        if ('task_id' not in params or
                params['task_id'] is None):
            raise ValueError("Missing the required parameter `task_id` when calling `complete_task_v2`")  # noqa: E501
        # verify the required parameter 'task_input' is set
        if ('task_input' not in params or
                params['task_input'] is None):
            raise ValueError("Missing the required parameter `task_input` when calling `complete_task_v2`")  # noqa: E501
        # verify the required parameter 'version' is set
        if ('version' not in params or
                params['version'] is None):
            raise ValueError("Missing the required parameter `version` when calling `complete_task_v2`")  # noqa: E501
        # verify the required parameter 'file' is set
        if ('file' not in params or
                params['file'] is None):
            raise ValueError("Missing the required parameter `file` when calling `complete_task_v2`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'investigation_id' in params:
            form_params.append(('investigationId', params['investigation_id']))  # noqa: E501
        if 'task_id' in params:
            form_params.append(('taskId', params['task_id']))  # noqa: E501
        if 'task_comment' in params:
            form_params.append(('taskComment', params['task_comment']))  # noqa: E501
        if 'task_input' in params:
            form_params.append(('taskInput', params['task_input']))  # noqa: E501
        if 'version' in params:
            form_params.append(('version', params['version']))  # noqa: E501
        if 'file' in params:
            local_var_files['file'] = params['file']  # noqa: E501
        if 'file_names' in params:
            form_params.append(('fileNames', params['file_names']))  # noqa: E501
        if 'file_comments' in params:
            form_params.append(('fileComments', params['file_comments']))  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'csrf_token', 'x-xdr-auth-id']  # noqa: E501

        return self.api_client.call_api(
            '/v2/inv-playbook/task/complete', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InvestigationPlaybook',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def copy_script(self, **kwargs):  # noqa: E501
        """Copy automation  # noqa: E501

        Copy given automation  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.copy_script(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AutomationScriptFilterWrapper automation_script_filter_wrapper:
        :return: AutomationScriptResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.copy_script_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.copy_script_with_http_info(**kwargs)  # noqa: E501
            return data

    def copy_script_with_http_info(self, **kwargs):  # noqa: E501
        """Copy automation  # noqa: E501

        Copy given automation  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.copy_script_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AutomationScriptFilterWrapper automation_script_filter_wrapper:
        :return: AutomationScriptResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['automation_script_filter_wrapper']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method copy_script" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'automation_script_filter_wrapper' in params:
            body_params = params['automation_script_filter_wrapper']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'csrf_token', 'x-xdr-auth-id']  # noqa: E501

        return self.api_client.call_api(
            '/automation/copy', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AutomationScriptResult',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_docker_image(self, **kwargs):  # noqa: E501
        """Create Image  # noqa: E501

        Create an image with a given list of dependencies  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_docker_image(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param NewDockerImage new_docker_image:
        :return: NewDockerImageResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_docker_image_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.create_docker_image_with_http_info(**kwargs)  # noqa: E501
            return data

    def create_docker_image_with_http_info(self, **kwargs):  # noqa: E501
        """Create Image  # noqa: E501

        Create an image with a given list of dependencies  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_docker_image_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param NewDockerImage new_docker_image:
        :return: NewDockerImageResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['new_docker_image']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_docker_image" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'new_docker_image' in params:
            body_params = params['new_docker_image']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'csrf_token', 'x-xdr-auth-id']  # noqa: E501

        return self.api_client.call_api(
            '/settings/docker-images', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NewDockerImageResult',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_feed_indicators_json(self, feed_indicators_request, **kwargs):  # noqa: E501
        """Create feed indicators from JSON  # noqa: E501

        Create indicators from raw JSON (similar to ingesting from a feed). Builds indicators according to the specified feed classifier, or uses the default one if not specified. Indicator properties (all optional except for value): **value** (string, required) | **type** (string) | **score** (number, 0-3, default `0`, where `0` means None, `1` Good, `2` Suspicious, and `3` Bad) | **sourceBrand** (string, default `\"External\"`) | **sourceInstance** (string, default `\"External\"`) | **reliability** (string, one of `\"A - Completely reliable\"`, `\"B - Usually reliable\"`, `\"C - Fairly reliable\"`, `\"D - Not usually reliable\"`, `\"E - Unreliable\"`, `\"F - Reliability cannot be judged\"`) | **expirationPolicy** (string, one of `\"never\"`, `\"interval\"`, `\"indicatorType\"`) | **expirationInterval** (number, in minutes)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_feed_indicators_json(feed_indicators_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FeedIndicatorsRequest feed_indicators_request: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_feed_indicators_json_with_http_info(feed_indicators_request, **kwargs)  # noqa: E501
        else:
            (data) = self.create_feed_indicators_json_with_http_info(feed_indicators_request, **kwargs)  # noqa: E501
            return data

    def create_feed_indicators_json_with_http_info(self, feed_indicators_request, **kwargs):  # noqa: E501
        """Create feed indicators from JSON  # noqa: E501

        Create indicators from raw JSON (similar to ingesting from a feed). Builds indicators according to the specified feed classifier, or uses the default one if not specified. Indicator properties (all optional except for value): **value** (string, required) | **type** (string) | **score** (number, 0-3, default `0`, where `0` means None, `1` Good, `2` Suspicious, and `3` Bad) | **sourceBrand** (string, default `\"External\"`) | **sourceInstance** (string, default `\"External\"`) | **reliability** (string, one of `\"A - Completely reliable\"`, `\"B - Usually reliable\"`, `\"C - Fairly reliable\"`, `\"D - Not usually reliable\"`, `\"E - Unreliable\"`, `\"F - Reliability cannot be judged\"`) | **expirationPolicy** (string, one of `\"never\"`, `\"interval\"`, `\"indicatorType\"`) | **expirationInterval** (number, in minutes)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_feed_indicators_json_with_http_info(feed_indicators_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FeedIndicatorsRequest feed_indicators_request: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['feed_indicators_request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_feed_indicators_json" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'feed_indicators_request' is set
        if ('feed_indicators_request' not in params or
                params['feed_indicators_request'] is None):
            raise ValueError("Missing the required parameter `feed_indicators_request` when calling `create_feed_indicators_json`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'feed_indicators_request' in params:
            body_params = params['feed_indicators_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'csrf_token', 'x-xdr-auth-id']  # noqa: E501

        return self.api_client.call_api(
            '/indicators/feed/json', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_incident(self, **kwargs):  # noqa: E501
        """Create single incident  # noqa: E501

        Create or update incident according to JSON structure. To update incident custom fields you should lowercase them and remove all spaces. For example: Scan IP -> scanip To get the actual key name you can also go to Demisto CLI and run /incident_add and look for the key that you would like to update  Use the 'createInvestigation\\: True' to start the investigation process automatically. (by running a playbook based on incident type.)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_incident(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CreateIncidentRequest create_incident_request:
        :return: IncidentWrapper
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_incident_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.create_incident_with_http_info(**kwargs)  # noqa: E501
            return data

    def create_incident_with_http_info(self, **kwargs):  # noqa: E501
        """Create single incident  # noqa: E501

        Create or update incident according to JSON structure. To update incident custom fields you should lowercase them and remove all spaces. For example: Scan IP -> scanip To get the actual key name you can also go to Demisto CLI and run /incident_add and look for the key that you would like to update  Use the 'createInvestigation\\: True' to start the investigation process automatically. (by running a playbook based on incident type.)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_incident_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CreateIncidentRequest create_incident_request:
        :return: IncidentWrapper
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['create_incident_request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_incident" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'create_incident_request' in params:
            body_params = params['create_incident_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'csrf_token', 'x-xdr-auth-id']  # noqa: E501

        return self.api_client.call_api(
            '/incident', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='IncidentWrapper',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_incident_json(self, **kwargs):  # noqa: E501
        """Create incident from JSON  # noqa: E501

        Create single incident from raw JSON, builds incident according to default mapping  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_incident_json(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: IncidentWrapper
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_incident_json_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.create_incident_json_with_http_info(**kwargs)  # noqa: E501
            return data

    def create_incident_json_with_http_info(self, **kwargs):  # noqa: E501
        """Create incident from JSON  # noqa: E501

        Create single incident from raw JSON, builds incident according to default mapping  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_incident_json_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: IncidentWrapper
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_incident_json" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'csrf_token', 'x-xdr-auth-id']  # noqa: E501

        return self.api_client.call_api(
            '/incident/json', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='IncidentWrapper',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_incidents_batch(self, **kwargs):  # noqa: E501
        """Batch create incidents  # noqa: E501

        Create or update an incidents batch To update incident custom fields you should lowercase them and remove all spaces. For example: Scan IP -> scanip To get the actual key name you can also go to Demisto CLI and run /incident_add and look for the key that you would like to update  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_incidents_batch(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UpdateDataBatch update_data_batch:
        :return: IncidentSearchResponseWrapper
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_incidents_batch_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.create_incidents_batch_with_http_info(**kwargs)  # noqa: E501
            return data

    def create_incidents_batch_with_http_info(self, **kwargs):  # noqa: E501
        """Batch create incidents  # noqa: E501

        Create or update an incidents batch To update incident custom fields you should lowercase them and remove all spaces. For example: Scan IP -> scanip To get the actual key name you can also go to Demisto CLI and run /incident_add and look for the key that you would like to update  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_incidents_batch_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UpdateDataBatch update_data_batch:
        :return: IncidentSearchResponseWrapper
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['update_data_batch']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_incidents_batch" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'update_data_batch' in params:
            body_params = params['update_data_batch']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'csrf_token', 'x-xdr-auth-id']  # noqa: E501

        return self.api_client.call_api(
            '/incident/batch', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='IncidentSearchResponseWrapper',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_or_update_incident_type(self, **kwargs):  # noqa: E501
        """Create new Incident Type  # noqa: E501

        API to create new Incident Type  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_or_update_incident_type(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param IncidentType incident_type:
        :return: IncidentType
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_or_update_incident_type_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.create_or_update_incident_type_with_http_info(**kwargs)  # noqa: E501
            return data

    def create_or_update_incident_type_with_http_info(self, **kwargs):  # noqa: E501
        """Create new Incident Type  # noqa: E501

        API to create new Incident Type  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_or_update_incident_type_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param IncidentType incident_type:
        :return: IncidentType
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['incident_type']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_or_update_incident_type" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'incident_type' in params:
            body_params = params['incident_type']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'csrf_token', 'x-xdr-auth-id']  # noqa: E501

        return self.api_client.call_api(
            '/incidenttype', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='IncidentType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_ad_hoc_task(self, investigation_id, inv_pb_task_id, **kwargs):  # noqa: E501
        """Delete ad-hoc task  # noqa: E501

        Delete an ad-hoc task from a running playbook  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_ad_hoc_task(investigation_id, inv_pb_task_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str investigation_id: investigation ID (required)
        :param str inv_pb_task_id: ad-hoc task ID (required)
        :return: InvestigationPlaybook
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_ad_hoc_task_with_http_info(investigation_id, inv_pb_task_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_ad_hoc_task_with_http_info(investigation_id, inv_pb_task_id, **kwargs)  # noqa: E501
            return data

    def delete_ad_hoc_task_with_http_info(self, investigation_id, inv_pb_task_id, **kwargs):  # noqa: E501
        """Delete ad-hoc task  # noqa: E501

        Delete an ad-hoc task from a running playbook  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_ad_hoc_task_with_http_info(investigation_id, inv_pb_task_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str investigation_id: investigation ID (required)
        :param str inv_pb_task_id: ad-hoc task ID (required)
        :return: InvestigationPlaybook
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['investigation_id', 'inv_pb_task_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_ad_hoc_task" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'investigation_id' is set
        if ('investigation_id' not in params or
                params['investigation_id'] is None):
            raise ValueError("Missing the required parameter `investigation_id` when calling `delete_ad_hoc_task`")  # noqa: E501
        # verify the required parameter 'inv_pb_task_id' is set
        if ('inv_pb_task_id' not in params or
                params['inv_pb_task_id'] is None):
            raise ValueError("Missing the required parameter `inv_pb_task_id` when calling `delete_ad_hoc_task`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'investigation_id' in params:
            path_params['investigationId'] = params['investigation_id']  # noqa: E501
        if 'inv_pb_task_id' in params:
            path_params['invPBTaskId'] = params['inv_pb_task_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'csrf_token', 'x-xdr-auth-id']  # noqa: E501

        return self.api_client.call_api(
            '/inv-playbook/task/delete/{investigationId}/{invPBTaskId}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InvestigationPlaybook',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_automation_script(self, **kwargs):  # noqa: E501
        """Delete existing automation  # noqa: E501

        Delete a given automation from the system.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_automation_script(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AutomationScriptFilterWrapper automation_script_filter_wrapper:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_automation_script_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.delete_automation_script_with_http_info(**kwargs)  # noqa: E501
            return data

    def delete_automation_script_with_http_info(self, **kwargs):  # noqa: E501
        """Delete existing automation  # noqa: E501

        Delete a given automation from the system.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_automation_script_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AutomationScriptFilterWrapper automation_script_filter_wrapper:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['automation_script_filter_wrapper']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_automation_script" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'automation_script_filter_wrapper' in params:
            body_params = params['automation_script_filter_wrapper']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'csrf_token', 'x-xdr-auth-id']  # noqa: E501

        return self.api_client.call_api(
            '/automation/delete', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_evidence_op(self, **kwargs):  # noqa: E501
        """delete evidence  # noqa: E501

        Delete an evidence entity  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_evidence_op(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DeleteEvidence delete_evidence_id:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_evidence_op_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.delete_evidence_op_with_http_info(**kwargs)  # noqa: E501
            return data

    def delete_evidence_op_with_http_info(self, **kwargs):  # noqa: E501
        """delete evidence  # noqa: E501

        Delete an evidence entity  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_evidence_op_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DeleteEvidence delete_evidence_id:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['delete_evidence_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_evidence_op" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'delete_evidence_id' in params:
            body_params = params['delete_evidence_id']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'csrf_token', 'x-xdr-auth-id']  # noqa: E501

        return self.api_client.call_api(
            '/evidence/delete', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_incidents_batch(self, **kwargs):  # noqa: E501
        """Batch delete incidents  # noqa: E501

        Deletes an incidents batch  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_incidents_batch(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UpdateDataBatch update_data_batch:
        :return: IncidentSearchResponseWrapper
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_incidents_batch_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.delete_incidents_batch_with_http_info(**kwargs)  # noqa: E501
            return data

    def delete_incidents_batch_with_http_info(self, **kwargs):  # noqa: E501
        """Batch delete incidents  # noqa: E501

        Deletes an incidents batch  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_incidents_batch_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UpdateDataBatch update_data_batch:
        :return: IncidentSearchResponseWrapper
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['update_data_batch']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_incidents_batch" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'update_data_batch' in params:
            body_params = params['update_data_batch']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'csrf_token', 'x-xdr-auth-id']  # noqa: E501

        return self.api_client.call_api(
            '/incident/batchDelete', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='IncidentSearchResponseWrapper',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_indicators_batch(self, **kwargs):  # noqa: E501
        """Batch whitelist or delete indicators  # noqa: E501

        Batch whitelist or delete indicators entities In order to delete indicators and not whitelist, set doNotWhitelist boolean field to true  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_indicators_batch(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GenericIndicatorUpdateBatch generic_indicator_update_batch:
        :return: UpdateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_indicators_batch_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.delete_indicators_batch_with_http_info(**kwargs)  # noqa: E501
            return data

    def delete_indicators_batch_with_http_info(self, **kwargs):  # noqa: E501
        """Batch whitelist or delete indicators  # noqa: E501

        Batch whitelist or delete indicators entities In order to delete indicators and not whitelist, set doNotWhitelist boolean field to true  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_indicators_batch_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GenericIndicatorUpdateBatch generic_indicator_update_batch:
        :return: UpdateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['generic_indicator_update_batch']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_indicators_batch" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'generic_indicator_update_batch' in params:
            body_params = params['generic_indicator_update_batch']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'csrf_token', 'x-xdr-auth-id']  # noqa: E501

        return self.api_client.call_api(
            '/indicators/batchDelete', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='UpdateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_widget(self, id, **kwargs):  # noqa: E501
        """Remove existing widget  # noqa: E501

        Remove a given widget Id from the system.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_widget(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: Widget id to remove (returned from widget save or widgets get) (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_widget_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_widget_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def delete_widget_with_http_info(self, id, **kwargs):  # noqa: E501
        """Remove existing widget  # noqa: E501

        Remove a given widget Id from the system.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_widget_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: Widget id to remove (returned from widget save or widgets get) (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_widget" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_widget`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'csrf_token', 'x-xdr-auth-id']  # noqa: E501

        return self.api_client.call_api(
            '/widgets/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def download_file(self, entryid, **kwargs):  # noqa: E501
        """Download file  # noqa: E501

        Download file from Demisto by entry ID  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.download_file(entryid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str entryid: Entry ID (required)
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.download_file_with_http_info(entryid, **kwargs)  # noqa: E501
        else:
            (data) = self.download_file_with_http_info(entryid, **kwargs)  # noqa: E501
            return data

    def download_file_with_http_info(self, entryid, **kwargs):  # noqa: E501
        """Download file  # noqa: E501

        Download file from Demisto by entry ID  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.download_file_with_http_info(entryid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str entryid: Entry ID (required)
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['entryid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method download_file" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'entryid' is set
        if ('entryid' not in params or
                params['entryid'] is None):
            raise ValueError("Missing the required parameter `entryid` when calling `download_file`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'entryid' in params:
            path_params['entryid'] = params['entryid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/octet-stream'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'csrf_token', 'x-xdr-auth-id']  # noqa: E501

        return self.api_client.call_api(
            '/entry/download/{entryid}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='file',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def download_latest_report(self, id, **kwargs):  # noqa: E501
        """Get latest report by ID  # noqa: E501

        Get the latest report by its ID  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.download_latest_report(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: the ID of the report to get (required)
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.download_latest_report_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.download_latest_report_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def download_latest_report_with_http_info(self, id, **kwargs):  # noqa: E501
        """Get latest report by ID  # noqa: E501

        Get the latest report by its ID  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.download_latest_report_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: the ID of the report to get (required)
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method download_latest_report" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `download_latest_report`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/octet-stream'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'csrf_token', 'x-xdr-auth-id']  # noqa: E501

        return self.api_client.call_api(
            '/reports/{id}/latest', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='file',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def edit_ad_hoc_task(self, investigation_id, **kwargs):  # noqa: E501
        """Edit ad-hoc task  # noqa: E501

        Edit an ad-hoc task in a running playbook  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_ad_hoc_task(investigation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str investigation_id: investigation ID (required)
        :param InvPlaybookTaskData inv_playbook_task_data:
        :return: InvestigationPlaybook
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_ad_hoc_task_with_http_info(investigation_id, **kwargs)  # noqa: E501
        else:
            (data) = self.edit_ad_hoc_task_with_http_info(investigation_id, **kwargs)  # noqa: E501
            return data

    def edit_ad_hoc_task_with_http_info(self, investigation_id, **kwargs):  # noqa: E501
        """Edit ad-hoc task  # noqa: E501

        Edit an ad-hoc task in a running playbook  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_ad_hoc_task_with_http_info(investigation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str investigation_id: investigation ID (required)
        :param InvPlaybookTaskData inv_playbook_task_data:
        :return: InvestigationPlaybook
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['investigation_id', 'inv_playbook_task_data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_ad_hoc_task" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'investigation_id' is set
        if ('investigation_id' not in params or
                params['investigation_id'] is None):
            raise ValueError("Missing the required parameter `investigation_id` when calling `edit_ad_hoc_task`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'investigation_id' in params:
            path_params['investigationId'] = params['investigation_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'inv_playbook_task_data' in params:
            body_params = params['inv_playbook_task_data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'csrf_token', 'x-xdr-auth-id']  # noqa: E501

        return self.api_client.call_api(
            '/inv-playbook/task/edit/{investigationId}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InvestigationPlaybook',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def entry_export_artifact(self, **kwargs):  # noqa: E501
        """Export Artifact  # noqa: E501

        Export an entry artifact  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.entry_export_artifact(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DownloadEntry download_entry:
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.entry_export_artifact_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.entry_export_artifact_with_http_info(**kwargs)  # noqa: E501
            return data

    def entry_export_artifact_with_http_info(self, **kwargs):  # noqa: E501
        """Export Artifact  # noqa: E501

        Export an entry artifact  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.entry_export_artifact_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DownloadEntry download_entry:
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['download_entry']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method entry_export_artifact" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'download_entry' in params:
            body_params = params['download_entry']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'csrf_token', 'x-xdr-auth-id']  # noqa: E501

        return self.api_client.call_api(
            '/entry/exportArtifact', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def execute_report(self, id, request_id, **kwargs):  # noqa: E501
        """Execute report  # noqa: E501

        Execute a new report  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.execute_report(id, request_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: the ID of the report to get (required)
        :param str request_id: the ID to register the request under (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.execute_report_with_http_info(id, request_id, **kwargs)  # noqa: E501
        else:
            (data) = self.execute_report_with_http_info(id, request_id, **kwargs)  # noqa: E501
            return data

    def execute_report_with_http_info(self, id, request_id, **kwargs):  # noqa: E501
        """Execute report  # noqa: E501

        Execute a new report  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.execute_report_with_http_info(id, request_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: the ID of the report to get (required)
        :param str request_id: the ID to register the request under (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'request_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method execute_report" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `execute_report`")  # noqa: E501
        # verify the required parameter 'request_id' is set
        if ('request_id' not in params or
                params['request_id'] is None):
            raise ValueError("Missing the required parameter `request_id` when calling `execute_report`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501
        if 'request_id' in params:
            path_params['requestId'] = params['request_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'csrf_token', 'x-xdr-auth-id']  # noqa: E501

        return self.api_client.call_api(
            '/report/{id}/{requestId}/execute', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def export_incidents_to_csv_batch(self, **kwargs):  # noqa: E501
        """Batch export incidents to csv  # noqa: E501

        Exports an incidents batch to CSV file (returns file ID)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.export_incidents_to_csv_batch(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UpdateDataBatch update_data_batch:
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.export_incidents_to_csv_batch_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.export_incidents_to_csv_batch_with_http_info(**kwargs)  # noqa: E501
            return data

    def export_incidents_to_csv_batch_with_http_info(self, **kwargs):  # noqa: E501
        """Batch export incidents to csv  # noqa: E501

        Exports an incidents batch to CSV file (returns file ID)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.export_incidents_to_csv_batch_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UpdateDataBatch update_data_batch:
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['update_data_batch']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method export_incidents_to_csv_batch" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'update_data_batch' in params:
            body_params = params['update_data_batch']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'csrf_token', 'x-xdr-auth-id']  # noqa: E501

        return self.api_client.call_api(
            '/incident/batch/exportToCsv', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def export_indicators_to_csv_batch(self, **kwargs):  # noqa: E501
        """Batch export indicators to csv  # noqa: E501

        Exports an indicators batch to CSV file (returns file ID)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.export_indicators_to_csv_batch(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GenericIndicatorUpdateBatch generic_indicator_update_batch: Required parameters from `genericIndicatorUpdateBatch`: `columns`, `filter`. You should also include either `all` or `ids` 
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.export_indicators_to_csv_batch_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.export_indicators_to_csv_batch_with_http_info(**kwargs)  # noqa: E501
            return data

    def export_indicators_to_csv_batch_with_http_info(self, **kwargs):  # noqa: E501
        """Batch export indicators to csv  # noqa: E501

        Exports an indicators batch to CSV file (returns file ID)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.export_indicators_to_csv_batch_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GenericIndicatorUpdateBatch generic_indicator_update_batch: Required parameters from `genericIndicatorUpdateBatch`: `columns`, `filter`. You should also include either `all` or `ids` 
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['generic_indicator_update_batch']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method export_indicators_to_csv_batch" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'generic_indicator_update_batch' in params:
            body_params = params['generic_indicator_update_batch']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'csrf_token', 'x-xdr-auth-id']  # noqa: E501

        return self.api_client.call_api(
            '/indicators/batch/exportToCsv', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def export_indicators_to_stix_batch(self, **kwargs):  # noqa: E501
        """Batch export indicators to STIX  # noqa: E501

        Exports an indicators batch to STIX file (returns file ID)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.export_indicators_to_stix_batch(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GenericIndicatorUpdateBatch generic_indicator_update_batch:
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.export_indicators_to_stix_batch_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.export_indicators_to_stix_batch_with_http_info(**kwargs)  # noqa: E501
            return data

    def export_indicators_to_stix_batch_with_http_info(self, **kwargs):  # noqa: E501
        """Batch export indicators to STIX  # noqa: E501

        Exports an indicators batch to STIX file (returns file ID)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.export_indicators_to_stix_batch_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GenericIndicatorUpdateBatch generic_indicator_update_batch:
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['generic_indicator_update_batch']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method export_indicators_to_stix_batch" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'generic_indicator_update_batch' in params:
            body_params = params['generic_indicator_update_batch']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'csrf_token', 'x-xdr-auth-id']  # noqa: E501

        return self.api_client.call_api(
            '/indicators/batch/export/stix', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_all_reports(self, **kwargs):  # noqa: E501
        """Get all reports  # noqa: E501

        Get all of the reports  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_reports(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: list[Report]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_all_reports_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_all_reports_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_all_reports_with_http_info(self, **kwargs):  # noqa: E501
        """Get all reports  # noqa: E501

        Get all of the reports  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_reports_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: list[Report]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all_reports" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'csrf_token', 'x-xdr-auth-id']  # noqa: E501

        return self.api_client.call_api(
            '/reports', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Report]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_all_widgets(self, **kwargs):  # noqa: E501
        """get_all_widgets  # noqa: E501

        Get all widgets  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_widgets(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: list[Widget]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_all_widgets_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_all_widgets_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_all_widgets_with_http_info(self, **kwargs):  # noqa: E501
        """get_all_widgets  # noqa: E501

        Get all widgets  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_widgets_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: list[Widget]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all_widgets" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'csrf_token', 'x-xdr-auth-id']  # noqa: E501

        return self.api_client.call_api(
            '/widgets', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Widget]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_audits(self, **kwargs):  # noqa: E501
        """Get Audits  # noqa: E501

        Get audits by filter  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_audits(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GenericStringDateFilter filter:
        :return: AuditResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_audits_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_audits_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_audits_with_http_info(self, **kwargs):  # noqa: E501
        """Get Audits  # noqa: E501

        Get audits by filter  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_audits_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GenericStringDateFilter filter:
        :return: AuditResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['filter']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_audits" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'filter' in params:
            body_params = params['filter']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'csrf_token', 'x-xdr-auth-id']  # noqa: E501

        return self.api_client.call_api(
            '/settings/audits', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AuditResult',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_automation_scripts(self, **kwargs):  # noqa: E501
        """Search Automation (aka scripts)  # noqa: E501

        Search Automation by filter  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_automation_scripts(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AutomationScriptFilter automation_script_filter:
        :return: AutomationScriptResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_automation_scripts_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_automation_scripts_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_automation_scripts_with_http_info(self, **kwargs):  # noqa: E501
        """Search Automation (aka scripts)  # noqa: E501

        Search Automation by filter  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_automation_scripts_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AutomationScriptFilter automation_script_filter:
        :return: AutomationScriptResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['automation_script_filter']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_automation_scripts" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'automation_script_filter' in params:
            body_params = params['automation_script_filter']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'csrf_token', 'x-xdr-auth-id']  # noqa: E501

        return self.api_client.call_api(
            '/automation/search', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AutomationScriptResult',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_docker_images(self, **kwargs):  # noqa: E501
        """Get Docker Images  # noqa: E501

        Get list of all available docker image names  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_docker_images(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: DockerImagesResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_docker_images_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_docker_images_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_docker_images_with_http_info(self, **kwargs):  # noqa: E501
        """Get Docker Images  # noqa: E501

        Get list of all available docker image names  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_docker_images_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: DockerImagesResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_docker_images" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'csrf_token', 'x-xdr-auth-id']  # noqa: E501

        return self.api_client.call_api(
            '/settings/docker-images', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DockerImagesResult',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_entry_artifact(self, id, **kwargs):  # noqa: E501
        """Get entry artifact  # noqa: E501

        Get the entry artifact file  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_entry_artifact(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: file to fetch (returned from entry export artifact call) (required)
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_entry_artifact_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_entry_artifact_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_entry_artifact_with_http_info(self, id, **kwargs):  # noqa: E501
        """Get entry artifact  # noqa: E501

        Get the entry artifact file  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_entry_artifact_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: file to fetch (returned from entry export artifact call) (required)
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_entry_artifact" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_entry_artifact`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/octet-stream'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'csrf_token', 'x-xdr-auth-id']  # noqa: E501

        return self.api_client.call_api(
            '/entry/artifact/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='file',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_incident_as_csv(self, id, **kwargs):  # noqa: E501
        """Get incident as CSV  # noqa: E501

        Get an incident CSV file that was exported, by ID  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_incident_as_csv(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: CSV file to fetch (returned from batch export to csv call) (required)
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_incident_as_csv_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_incident_as_csv_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_incident_as_csv_with_http_info(self, id, **kwargs):  # noqa: E501
        """Get incident as CSV  # noqa: E501

        Get an incident CSV file that was exported, by ID  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_incident_as_csv_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: CSV file to fetch (returned from batch export to csv call) (required)
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_incident_as_csv" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_incident_as_csv`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/octet-stream'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'csrf_token', 'x-xdr-auth-id']  # noqa: E501

        return self.api_client.call_api(
            '/incident/csv/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='file',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_incidents_fields_by_incident_type(self, type, **kwargs):  # noqa: E501
        """Get all incident fields associated with incident type  # noqa: E501

        Get all incident fields associated with incident type  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_incidents_fields_by_incident_type(type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str type: the name (case sensitive) of the incident type (required)
        :return: list[IncidentField]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_incidents_fields_by_incident_type_with_http_info(type, **kwargs)  # noqa: E501
        else:
            (data) = self.get_incidents_fields_by_incident_type_with_http_info(type, **kwargs)  # noqa: E501
            return data

    def get_incidents_fields_by_incident_type_with_http_info(self, type, **kwargs):  # noqa: E501
        """Get all incident fields associated with incident type  # noqa: E501

        Get all incident fields associated with incident type  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_incidents_fields_by_incident_type_with_http_info(type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str type: the name (case sensitive) of the incident type (required)
        :return: list[IncidentField]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['type']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_incidents_fields_by_incident_type" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'type' is set
        if ('type' not in params or
                params['type'] is None):
            raise ValueError("Missing the required parameter `type` when calling `get_incidents_fields_by_incident_type`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'type' in params:
            path_params['type'] = params['type']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'csrf_token', 'x-xdr-auth-id']  # noqa: E501

        return self.api_client.call_api(
            '/incidentfields/associatedTypes/{type}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[IncidentField]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_indicators_as_csv(self, id, **kwargs):  # noqa: E501
        """Get indicators as CSV  # noqa: E501

        Get an indicators CSV file that was exported, by ID  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_indicators_as_csv(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: CSV file to fetch (returned from batch export to csv call) (required)
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_indicators_as_csv_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_indicators_as_csv_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_indicators_as_csv_with_http_info(self, id, **kwargs):  # noqa: E501
        """Get indicators as CSV  # noqa: E501

        Get an indicators CSV file that was exported, by ID  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_indicators_as_csv_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: CSV file to fetch (returned from batch export to csv call) (required)
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_indicators_as_csv" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_indicators_as_csv`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/octet-stream'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'csrf_token', 'x-xdr-auth-id']  # noqa: E501

        return self.api_client.call_api(
            '/indicators/csv/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='file',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_indicators_as_stix(self, id, **kwargs):  # noqa: E501
        """Get indicators as STIX V2  # noqa: E501

        Get an indicators STIX V2 file that was exported, by ID  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_indicators_as_stix(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: STIX V2 file to fetch (returned from batch export to STIX call) (required)
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_indicators_as_stix_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_indicators_as_stix_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_indicators_as_stix_with_http_info(self, id, **kwargs):  # noqa: E501
        """Get indicators as STIX V2  # noqa: E501

        Get an indicators STIX V2 file that was exported, by ID  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_indicators_as_stix_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: STIX V2 file to fetch (returned from batch export to STIX call) (required)
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_indicators_as_stix" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_indicators_as_stix`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/octet-stream'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'csrf_token', 'x-xdr-auth-id']  # noqa: E501

        return self.api_client.call_api(
            '/indicators/stix/v2/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='file',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_report_by_id(self, id, **kwargs):  # noqa: E501
        """Get report by ID  # noqa: E501

        Get a report by its ID  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_report_by_id(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: the ID of the report to get (required)
        :return: Report
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_report_by_id_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_report_by_id_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_report_by_id_with_http_info(self, id, **kwargs):  # noqa: E501
        """Get report by ID  # noqa: E501

        Get a report by its ID  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_report_by_id_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: the ID of the report to get (required)
        :return: Report
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_report_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_report_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'csrf_token', 'x-xdr-auth-id']  # noqa: E501

        return self.api_client.call_api(
            '/reports/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Report',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_stats_for_dashboard(self, **kwargs):  # noqa: E501
        """Get Dashboard Statistics  # noqa: E501

        Get a given dashboard statistics result.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_stats_for_dashboard(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: list[StatsQueryResponse]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_stats_for_dashboard_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_stats_for_dashboard_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_stats_for_dashboard_with_http_info(self, **kwargs):  # noqa: E501
        """Get Dashboard Statistics  # noqa: E501

        Get a given dashboard statistics result.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_stats_for_dashboard_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: list[StatsQueryResponse]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_stats_for_dashboard" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'csrf_token', 'x-xdr-auth-id']  # noqa: E501

        return self.api_client.call_api(
            '/statistics/dashboards/query', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[StatsQueryResponse]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_stats_for_widget(self, **kwargs):  # noqa: E501
        """Get Widget Statistics  # noqa: E501

        Get a given widget object statistics result. Note: This route has many return types based on the widget type and data. Each 200X represent a 200 OK request of specific widget type and data  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_stats_for_widget(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_stats_for_widget_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_stats_for_widget_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_stats_for_widget_with_http_info(self, **kwargs):  # noqa: E501
        """Get Widget Statistics  # noqa: E501

        Get a given widget object statistics result. Note: This route has many return types based on the widget type and data. Each 200X represent a 200 OK request of specific widget type and data  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_stats_for_widget_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_stats_for_widget" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'csrf_token', 'x-xdr-auth-id']  # noqa: E501

        return self.api_client.call_api(
            '/statistics/widgets/query', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_widget(self, id, **kwargs):  # noqa: E501
        """Get widget by ID  # noqa: E501

        Get a widget object by a given ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_widget(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: The ID of widget to get. (required)
        :return: Widget
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_widget_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_widget_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_widget_with_http_info(self, id, **kwargs):  # noqa: E501
        """Get widget by ID  # noqa: E501

        Get a widget object by a given ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_widget_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: The ID of widget to get. (required)
        :return: Widget
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_widget" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_widget`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'csrf_token', 'x-xdr-auth-id']  # noqa: E501

        return self.api_client.call_api(
            '/widgets/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Widget',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def import_classifier(self, file, **kwargs):  # noqa: E501
        """Import a classifier  # noqa: E501

        Import a classifier to Cortex XSOAR  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.import_classifier(file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file file: file (required)
        :return: InstanceClassifier
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        with open(file, 'r') as classifier_json_file:
            data = classifier_json_file.read()
        classifier_data_json = json.loads(data)
        classifier_id = classifier_data_json.get('id')
        if kwargs.get('async_req'):
            return self.import_classifier_with_http_info(file, classifier_id, **kwargs)  # noqa: E501
        else:
            (data) = self.import_classifier_with_http_info(file, classifier_id, **kwargs)  # noqa: E501
            return data

    def import_classifier_with_http_info(self, file, classifier_id, **kwargs):  # noqa: E501
        """Import a classifier  # noqa: E501

        Import a classifier to Cortex XSOAR  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.import_classifier_with_http_info(file, classifier_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file file: file (required)
        :param str classifier_id: associated typeID for the layout (required)
        :return: InstanceClassifier
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['file', 'classifier_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method import_classifier" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'file' is set
        if ('file' not in params or
                params['file'] is None):
            raise ValueError("Missing the required parameter `file` when calling `import_classifier`")  # noqa: E501
        # verify the required parameter 'classifier_id' is set
        if ('classifier_id' not in params or
                params['classifier_id'] is None):
            raise ValueError("Missing the required parameter `classifier_id` when calling `import_classifier`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'file' in params:
            local_var_files['file'] = params['file']  # noqa: E501
        if 'classifier_id' in params:
            form_params.append(('classifierId', params['classifier_id']))  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'csrf_token', 'x-xdr-auth-id']  # noqa: E501

        return self.api_client.call_api(
            '/classifier/import', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InstanceClassifier',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def import_dashboard(self, file, **kwargs):  # noqa: E501
        """Import a dashboard  # noqa: E501

        Import a dashboard to Cortex XSOAR  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.import_dashboard(file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file file: file (required)
        :return: Dashboard
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.import_dashboard_with_http_info(file, **kwargs)  # noqa: E501
        else:
            (data) = self.import_dashboard_with_http_info(file, **kwargs)  # noqa: E501
            return data

    def import_dashboard_with_http_info(self, file, **kwargs):  # noqa: E501
        """Import a dashboard  # noqa: E501

        Import a dashboard to Cortex XSOAR  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.import_dashboard_with_http_info(file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file file: file (required)
        :return: Dashboard
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['file']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method import_dashboard" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'file' is set
        if ('file' not in params or
                params['file'] is None):
            raise ValueError("Missing the required parameter `file` when calling `import_dashboard`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'file' in params:
            local_var_files['file'] = params['file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'csrf_token', 'x-xdr-auth-id']  # noqa: E501

        return self.api_client.call_api(
            '/dashboards/import', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Dashboard',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def import_incident_fields(self, file, **kwargs):  # noqa: E501
        """Import an incidents field  # noqa: E501

        Import an incidents field to Cortex XSOAR  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.import_incident_fields(file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file file: file (required)
        :return: IncidentField
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.import_incident_fields_with_http_info(file, **kwargs)  # noqa: E501
        else:
            (data) = self.import_incident_fields_with_http_info(file, **kwargs)  # noqa: E501
            return data

    def import_incident_fields_with_http_info(self, file, **kwargs):  # noqa: E501
        """Import an incidents field  # noqa: E501

        Import an incidents field to Cortex XSOAR  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.import_incident_fields_with_http_info(file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file file: file (required)
        :return: IncidentField
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['file']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method import_incident_fields" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'file' is set
        if ('file' not in params or
                params['file'] is None):
            raise ValueError("Missing the required parameter `file` when calling `import_incident_fields`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'file' in params:
            local_var_files['file'] = params['file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'csrf_token', 'x-xdr-auth-id']  # noqa: E501

        return self.api_client.call_api(
            '/incidentfields/import', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='IncidentField',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def import_incident_types_handler(self, file, **kwargs):  # noqa: E501
        """Import an incident type  # noqa: E501

        Import an incident type to Cortex XSOAR  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.import_incident_types_handler(file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file file: file (required)
        :return: IncidentType
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.import_incident_types_handler_with_http_info(file, **kwargs)  # noqa: E501
        else:
            (data) = self.import_incident_types_handler_with_http_info(file, **kwargs)  # noqa: E501
            return data

    def import_incident_types_handler_with_http_info(self, file, **kwargs):  # noqa: E501
        """Import an incident type  # noqa: E501

        Import an incident type to Cortex XSOAR  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.import_incident_types_handler_with_http_info(file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file file: file (required)
        :return: IncidentType
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['file']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method import_incident_types_handler" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'file' is set
        if ('file' not in params or
                params['file'] is None):
            raise ValueError("Missing the required parameter `file` when calling `import_incident_types_handler`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'file' in params:
            local_var_files['file'] = params['file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'csrf_token', 'x-xdr-auth-id']  # noqa: E501

        return self.api_client.call_api(
            '/incidenttypes/import', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='IncidentType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def import_layout(self, file, **kwargs):  # noqa: E501
        """Import a layout  # noqa: E501

        Import a layout to Cortex XSOAR  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.import_layout(file, type, kind, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file file: file (required)
        :param str type: associated typeID for the layout (required)
        :param str kind: layout kind details (required)
        :return: LayoutAPI
                 If the method is called asynchronously,
                 returns the request thread.
        """
        with open(file, 'r') as layout_json_file:
            data = layout_json_file.read()
        layout_data_json = json.loads(data)
        type = layout_data_json.get('typeId')
        kind = layout_data_json.get('kind')
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.import_layout_with_http_info(file, type, kind, **kwargs)  # noqa: E501
        else:
            (data) = self.import_layout_with_http_info(file, type, kind, **kwargs)  # noqa: E501
            return data

    def import_layout_with_http_info(self, file, type, kind, **kwargs):  # noqa: E501
        """Import a layout  # noqa: E501

        Import a layout to Cortex XSOAR  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.import_layout_with_http_info(file, type, kind, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file file: file (required)
        :param str type: associated typeID for the layout (required)
        :param str kind: layout kind details (required)
        :return: LayoutAPI
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['file', 'type', 'kind']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method import_layout" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'file' is set
        if ('file' not in params or
                params['file'] is None):
            raise ValueError("Missing the required parameter `file` when calling `import_layout`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if params.get('file', None):
            local_var_files['file'] = params['file']  # noqa: E501
        if params.get('type', None):
            form_params.append(('type', params['type']))  # noqa: E501
        if params.get('kind', None):
            form_params.append(('kind', params['kind']))  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'csrf_token', 'x-xdr-auth-id']  # noqa: E501

        return self.api_client.call_api(
            demisto_client.get_layouts_url_for_demisto_version(self.api_client, params), 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LayoutAPI',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def import_playbook(self, file, **kwargs):  # noqa: E501
        """Import and override playbook  # noqa: E501

        Import and override playbook in Cortex XSOAR  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.import_playbook(file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file file: file (required)
        :return: Playbook
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.import_playbook_with_http_info(file, **kwargs)  # noqa: E501
        else:
            (data) = self.import_playbook_with_http_info(file, **kwargs)  # noqa: E501
            return data

    def import_playbook_with_http_info(self, file, **kwargs):  # noqa: E501
        """Import and override playbook  # noqa: E501

        Import and override playbook in Cortex XSOAR  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.import_playbook_with_http_info(file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file file: file (required)
        :return: Playbook
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['file']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method import_playbook" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'file' is set
        if ('file' not in params or
                params['file'] is None):
            raise ValueError("Missing the required parameter `file` when calling `import_playbook`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'file' in params:
            local_var_files['file'] = params['file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'csrf_token', 'x-xdr-auth-id']  # noqa: E501

        return self.api_client.call_api(
            '/playbook/save/yaml', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Playbook',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def import_reputation_handler(self, file, **kwargs):  # noqa: E501
        """Import a reputation type  # noqa: E501

        Import a reputation type to XSOAR  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.import_reputation_handler(file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file file: file (required)
        :return: ReputationsWithErrors
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.import_reputation_handler_with_http_info(file, **kwargs)  # noqa: E501
        else:
            (data) = self.import_reputation_handler_with_http_info(file, **kwargs)  # noqa: E501
            return data

    def import_reputation_handler_with_http_info(self, file, **kwargs):  # noqa: E501
        """Import a reputation type  # noqa: E501

        Import a reputation type to XSOAR  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.import_reputation_handler_with_http_info(file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file file: file (required)
        :return: ReputationsWithErrors
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['file']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method import_reputation_handler" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'file' is set
        if ('file' not in params or
                params['file'] is None):
            raise ValueError("Missing the required parameter `file` when calling `import_reputation_handler`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'file' in params:
            local_var_files['file'] = params['file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'csrf_token', 'x-xdr-auth-id']  # noqa: E501

        return self.api_client.call_api(
            '/reputation/import', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ReputationsWithErrors',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def import_script(self, file, **kwargs):  # noqa: E501
        """Upload an automation  # noqa: E501

        Upload an automation to Cortex XSOAR  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.import_script(file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file file: file (required)
        :return: AutomationScript
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.import_script_with_http_info(file, **kwargs)  # noqa: E501
        else:
            (data) = self.import_script_with_http_info(file, **kwargs)  # noqa: E501
            return data

    def import_script_with_http_info(self, file, **kwargs):  # noqa: E501
        """Upload an automation  # noqa: E501

        Upload an automation to Cortex XSOAR  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.import_script_with_http_info(file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file file: file (required)
        :return: AutomationScript
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['file']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method import_script" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'file' is set
        if ('file' not in params or
                params['file'] is None):
            raise ValueError("Missing the required parameter `file` when calling `import_script`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'file' in params:
            local_var_files['file'] = params['file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'csrf_token', 'x-xdr-auth-id']  # noqa: E501

        return self.api_client.call_api(
            '/automation/import', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AutomationScript',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def import_widget(self, file, **kwargs):  # noqa: E501
        """Import a widget  # noqa: E501

        Import a widget to the system, ignoring ID or version, used to import new widgets.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.import_widget(file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file file: file (required)
        :return: Widget
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.import_widget_with_http_info(file, **kwargs)  # noqa: E501
        else:
            (data) = self.import_widget_with_http_info(file, **kwargs)  # noqa: E501
            return data

    def import_widget_with_http_info(self, file, **kwargs):  # noqa: E501
        """Import a widget  # noqa: E501

        Import a widget to the system, ignoring ID or version, used to import new widgets.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.import_widget_with_http_info(file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file file: file (required)
        :return: Widget
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['file']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method import_widget" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'file' is set
        if ('file' not in params or
                params['file'] is None):
            raise ValueError("Missing the required parameter `file` when calling `import_widget`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'file' in params:
            local_var_files['file'] = params['file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'csrf_token', 'x-xdr-auth-id']  # noqa: E501

        return self.api_client.call_api(
            '/widgets/import', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Widget',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def incident_file_upload(self, id, file, **kwargs):  # noqa: E501
        """incident_file_upload  # noqa: E501

        Add file attachement to an incidents  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.incident_file_upload(id, file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: Incident id to update (required)
        :param file file: file (required)
        :param str file_name: file name
        :param str file_comment: file comment
        :param str field: field name to hold the attachment details. If not specified, `attachment` will be used.
        :param bool show_media_file: show media file
        :param bool last: If set to true will create an investigation. Used for uploading after creating incident.
        :return: IncidentWrapper
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.incident_file_upload_with_http_info(id, file, **kwargs)  # noqa: E501
        else:
            (data) = self.incident_file_upload_with_http_info(id, file, **kwargs)  # noqa: E501
            return data

    def incident_file_upload_with_http_info(self, id, file, **kwargs):  # noqa: E501
        """incident_file_upload  # noqa: E501

        Add file attachement to an incidents  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.incident_file_upload_with_http_info(id, file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: Incident id to update (required)
        :param file file: file (required)
        :param str file_name: file name
        :param str file_comment: file comment
        :param str field: field name to hold the attachment details. If not specified, `attachment` will be used.
        :param bool show_media_file: show media file
        :param bool last: If set to true will create an investigation. Used for uploading after creating incident.
        :return: IncidentWrapper
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'file', 'file_name', 'file_comment', 'field', 'show_media_file', 'last']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method incident_file_upload" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `incident_file_upload`")  # noqa: E501
        # verify the required parameter 'file' is set
        if ('file' not in params or
                params['file'] is None):
            raise ValueError("Missing the required parameter `file` when calling `incident_file_upload`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'file_name' in params:
            form_params.append(('fileName', params['file_name']))  # noqa: E501
        if 'file_comment' in params:
            form_params.append(('fileComment', params['file_comment']))  # noqa: E501
        if 'field' in params:
            form_params.append(('field', params['field']))  # noqa: E501
        if 'show_media_file' in params:
            form_params.append(('showMediaFile', params['show_media_file']))  # noqa: E501
        if 'last' in params:
            form_params.append(('last', params['last']))  # noqa: E501
        if 'file' in params:
            local_var_files['file'] = params['file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'csrf_token', 'x-xdr-auth-id']  # noqa: E501

        return self.api_client.call_api(
            '/incident/upload/{id}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='IncidentWrapper',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def indicator_whitelist(self, **kwargs):  # noqa: E501
        """Whitelists or deletes Indicator  # noqa: E501

        Whitelists or deletes an indicator entity In order to delete an indicator and not whitelist, set doNotWhitelist boolean field to true  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.indicator_whitelist(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UpdateIndicatorReputationData update_indicator_reputation_data:
        :return: UpdateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.indicator_whitelist_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.indicator_whitelist_with_http_info(**kwargs)  # noqa: E501
            return data

    def indicator_whitelist_with_http_info(self, **kwargs):  # noqa: E501
        """Whitelists or deletes Indicator  # noqa: E501

        Whitelists or deletes an indicator entity In order to delete an indicator and not whitelist, set doNotWhitelist boolean field to true  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.indicator_whitelist_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UpdateIndicatorReputationData update_indicator_reputation_data:
        :return: UpdateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['update_indicator_reputation_data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method indicator_whitelist" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'update_indicator_reputation_data' in params:
            body_params = params['update_indicator_reputation_data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'csrf_token', 'x-xdr-auth-id']  # noqa: E501

        return self.api_client.call_api(
            '/indicator/whitelist', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='UpdateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def indicators_create(self, **kwargs):  # noqa: E501
        """Create Indicator  # noqa: E501

        Create an indicator entity To update indicator custom fields you should lowercase them and remove all spaces. For example: Scan IP -> scanip  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.indicators_create(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param IndicatorContext ioc_object:
        :return: IocObject
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.indicators_create_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.indicators_create_with_http_info(**kwargs)  # noqa: E501
            return data

    def indicators_create_with_http_info(self, **kwargs):  # noqa: E501
        """Create Indicator  # noqa: E501

        Create an indicator entity To update indicator custom fields you should lowercase them and remove all spaces. For example: Scan IP -> scanip  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.indicators_create_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param IndicatorContext ioc_object:
        :return: IocObject
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ioc_object']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method indicators_create" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'ioc_object' in params:
            body_params = params['ioc_object']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'csrf_token', 'x-xdr-auth-id']  # noqa: E501

        return self.api_client.call_api(
            '/indicator/create', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='IocObject',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def indicators_create_batch(self, file, **kwargs):  # noqa: E501
        """Create indicators  # noqa: E501

        Create indicators from a file  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.indicators_create_batch(file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file file: file (required)
        :param str file_name: file name
        :return: IocObjects
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.indicators_create_batch_with_http_info(file, **kwargs)  # noqa: E501
        else:
            (data) = self.indicators_create_batch_with_http_info(file, **kwargs)  # noqa: E501
            return data

    def indicators_create_batch_with_http_info(self, file, **kwargs):  # noqa: E501
        """Create indicators  # noqa: E501

        Create indicators from a file  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.indicators_create_batch_with_http_info(file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file file: file (required)
        :param str file_name: file name
        :return: IocObjects
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['file', 'file_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method indicators_create_batch" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'file' is set
        if ('file' not in params or
                params['file'] is None):
            raise ValueError("Missing the required parameter `file` when calling `indicators_create_batch`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'file_name' in params:
            form_params.append(('fileName', params['file_name']))  # noqa: E501
        if 'file' in params:
            local_var_files['file'] = params['file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'csrf_token', 'x-xdr-auth-id']  # noqa: E501

        return self.api_client.call_api(
            '/indicators/upload', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='IocObjects',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def indicators_edit(self, **kwargs):  # noqa: E501
        """Edit Indicator  # noqa: E501

        Edit an indicator entity To update indicator custom fields you should lowercase them and remove all spaces. For example: Scan IP -> scanip  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.indicators_edit(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param IocObject ioc_object:
        :return: IocObject
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.indicators_edit_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.indicators_edit_with_http_info(**kwargs)  # noqa: E501
            return data

    def indicators_edit_with_http_info(self, **kwargs):  # noqa: E501
        """Edit Indicator  # noqa: E501

        Edit an indicator entity To update indicator custom fields you should lowercase them and remove all spaces. For example: Scan IP -> scanip  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.indicators_edit_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param IocObject ioc_object:
        :return: IocObject
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ioc_object']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method indicators_edit" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'ioc_object' in params:
            body_params = params['ioc_object']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'csrf_token', 'x-xdr-auth-id']  # noqa: E501

        return self.api_client.call_api(
            '/indicator/edit', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='IocObject',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def indicators_search(self, **kwargs):  # noqa: E501
        """Search indicators  # noqa: E501

        Search indicators by filter  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.indicators_search(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param IndicatorFilter indicator_filter:
        :return: IndicatorResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.indicators_search_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.indicators_search_with_http_info(**kwargs)  # noqa: E501
            return data

    def indicators_search_with_http_info(self, **kwargs):  # noqa: E501
        """Search indicators  # noqa: E501

        Search indicators by filter  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.indicators_search_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param IndicatorFilter indicator_filter:
        :return: IndicatorResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['indicator_filter']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method indicators_search" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'indicator_filter' in params:
            body_params = params['indicator_filter']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'csrf_token', 'x-xdr-auth-id']  # noqa: E501

        return self.api_client.call_api(
            '/indicators/search', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='IndicatorResult',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def integration_upload(self, file, **kwargs):  # noqa: E501
        """Upload an integration  # noqa: E501

        Upload an integration to Demisto  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.integration_upload(file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file file: file (required)
        :return: ModuleConfiguration
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.integration_upload_with_http_info(file, **kwargs)  # noqa: E501
        else:
            (data) = self.integration_upload_with_http_info(file, **kwargs)  # noqa: E501
            return data

    def integration_upload_with_http_info(self, file, **kwargs):  # noqa: E501
        """Upload an integration  # noqa: E501

        Upload an integration to Demisto  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.integration_upload_with_http_info(file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file file: file (required)
        :return: ModuleConfiguration
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['file']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method integration_upload" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'file' is set
        if ('file' not in params or
                params['file'] is None):
            raise ValueError("Missing the required parameter `file` when calling `integration_upload`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'file' in params:
            local_var_files['file'] = params['file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'csrf_token', 'x-xdr-auth-id']  # noqa: E501

        return self.api_client.call_api(
            '/settings/integration-conf/upload', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ModuleConfiguration',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def investigation_add_entries_sync(self, **kwargs):  # noqa: E501
        """Create new entry in existing investigation  # noqa: E501

        API to create an entry (markdown format) in existing investigation Body example: {\"investigationId\":\"1234\",\"data\":\"entry content…\"}  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.investigation_add_entries_sync(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UpdateEntry update_entry:
        :return: list[Entry]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.investigation_add_entries_sync_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.investigation_add_entries_sync_with_http_info(**kwargs)  # noqa: E501
            return data

    def investigation_add_entries_sync_with_http_info(self, **kwargs):  # noqa: E501
        """Create new entry in existing investigation  # noqa: E501

        API to create an entry (markdown format) in existing investigation Body example: {\"investigationId\":\"1234\",\"data\":\"entry content…\"}  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.investigation_add_entries_sync_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UpdateEntry update_entry:
        :return: list[Entry]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['update_entry']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method investigation_add_entries_sync" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'update_entry' in params:
            body_params = params['update_entry']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'csrf_token', 'x-xdr-auth-id']  # noqa: E501

        return self.api_client.call_api(
            '/entry/execute/sync', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Entry]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def investigation_add_entry_handler(self, **kwargs):  # noqa: E501
        """Create new entry in existing investigation  # noqa: E501

        API to create an entry (markdown format) in existing investigation Body example: {\"investigationId\":\"1234\",\"data\":\"entry content…\"}  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.investigation_add_entry_handler(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UpdateEntry update_entry:
        :return: Entry
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.investigation_add_entry_handler_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.investigation_add_entry_handler_with_http_info(**kwargs)  # noqa: E501
            return data

    def investigation_add_entry_handler_with_http_info(self, **kwargs):  # noqa: E501
        """Create new entry in existing investigation  # noqa: E501

        API to create an entry (markdown format) in existing investigation Body example: {\"investigationId\":\"1234\",\"data\":\"entry content…\"}  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.investigation_add_entry_handler_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UpdateEntry update_entry:
        :return: Entry
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['update_entry']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method investigation_add_entry_handler" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'update_entry' in params:
            body_params = params['update_entry']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'csrf_token', 'x-xdr-auth-id']  # noqa: E501

        return self.api_client.call_api(
            '/entry', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Entry',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def investigation_add_formatted_entry_handler(self, **kwargs):  # noqa: E501
        """Create new formatted entry in existing investigation  # noqa: E501

        API to create a formatted entry (table/json/text/markdown/html) in existing investigation Body example: {\"investigationId\":\"1234\",\"format\":\"table/json/text/markdown/html\",\"contents\":\"entry content…\"}  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.investigation_add_formatted_entry_handler(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UploadedEntry uploaded_entry:
        :return: Entry
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.investigation_add_formatted_entry_handler_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.investigation_add_formatted_entry_handler_with_http_info(**kwargs)  # noqa: E501
            return data

    def investigation_add_formatted_entry_handler_with_http_info(self, **kwargs):  # noqa: E501
        """Create new formatted entry in existing investigation  # noqa: E501

        API to create a formatted entry (table/json/text/markdown/html) in existing investigation Body example: {\"investigationId\":\"1234\",\"format\":\"table/json/text/markdown/html\",\"contents\":\"entry content…\"}  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.investigation_add_formatted_entry_handler_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UploadedEntry uploaded_entry:
        :return: Entry
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['uploaded_entry']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method investigation_add_formatted_entry_handler" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'uploaded_entry' in params:
            body_params = params['uploaded_entry']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'csrf_token', 'x-xdr-auth-id']  # noqa: E501

        return self.api_client.call_api(
            '/entry/formatted', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Entry',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def revoke_user_api_key(self, username, **kwargs):  # noqa: E501
        """revoke_user_api_key  # noqa: E501

        Revoke API Key for user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.revoke_user_api_key(username, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str username: The username which the API keys assigned to (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.revoke_user_api_key_with_http_info(username, **kwargs)  # noqa: E501
        else:
            (data) = self.revoke_user_api_key_with_http_info(username, **kwargs)  # noqa: E501
            return data

    def revoke_user_api_key_with_http_info(self, username, **kwargs):  # noqa: E501
        """revoke_user_api_key  # noqa: E501

        Revoke API Key for user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.revoke_user_api_key_with_http_info(username, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str username: The username which the API keys assigned to (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['username']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method revoke_user_api_key" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'username' is set
        if ('username' not in params or
                params['username'] is None):
            raise ValueError("Missing the required parameter `username` when calling `revoke_user_api_key`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'username' in params:
            path_params['username'] = params['username']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/octet-stream'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'csrf_token', 'x-xdr-auth-id']  # noqa: E501

        return self.api_client.call_api(
            '/apikeys/revoke/user/{username}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def save_evidence(self, **kwargs):  # noqa: E501
        """Save evidence  # noqa: E501

        Save an evidence entity To update evidence custom fields you should lowercase them and remove all spaces. For example: Scan IP -> scanip  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.save_evidence(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Evidence evidence:
        :return: Evidence
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.save_evidence_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.save_evidence_with_http_info(**kwargs)  # noqa: E501
            return data

    def save_evidence_with_http_info(self, **kwargs):  # noqa: E501
        """Save evidence  # noqa: E501

        Save an evidence entity To update evidence custom fields you should lowercase them and remove all spaces. For example: Scan IP -> scanip  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.save_evidence_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Evidence evidence:
        :return: Evidence
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['evidence']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method save_evidence" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'evidence' in params:
            body_params = params['evidence']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'csrf_token', 'x-xdr-auth-id']  # noqa: E501

        return self.api_client.call_api(
            '/evidence', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Evidence',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def save_or_update_script(self, **kwargs):  # noqa: E501
        """Create or update automation  # noqa: E501

        Create or update a given automation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.save_or_update_script(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AutomationScriptFilterWrapper automation_script_filter_wrapper:
        :return: AutomationScriptResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.save_or_update_script_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.save_or_update_script_with_http_info(**kwargs)  # noqa: E501
            return data

    def save_or_update_script_with_http_info(self, **kwargs):  # noqa: E501
        """Create or update automation  # noqa: E501

        Create or update a given automation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.save_or_update_script_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AutomationScriptFilterWrapper automation_script_filter_wrapper:
        :return: AutomationScriptResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['automation_script_filter_wrapper']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method save_or_update_script" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'automation_script_filter_wrapper' in params:
            body_params = params['automation_script_filter_wrapper']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'csrf_token', 'x-xdr-auth-id']  # noqa: E501

        return self.api_client.call_api(
            '/automation', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AutomationScriptResult',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def save_widget(self, **kwargs):  # noqa: E501
        """Add or update a widget  # noqa: E501

        Add or update a given widget based on Id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.save_widget(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Widget widget:
        :return: Widget
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.save_widget_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.save_widget_with_http_info(**kwargs)  # noqa: E501
            return data

    def save_widget_with_http_info(self, **kwargs):  # noqa: E501
        """Add or update a widget  # noqa: E501

        Add or update a given widget based on Id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.save_widget_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Widget widget:
        :return: Widget
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['widget']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method save_widget" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'widget' in params:
            body_params = params['widget']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'csrf_token', 'x-xdr-auth-id']  # noqa: E501

        return self.api_client.call_api(
            '/widgets', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Widget',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_evidence(self, **kwargs):  # noqa: E501
        """Search evidence  # noqa: E501

        Search for an evidence entutiy by filter  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_evidence(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EvidencesFilterWrapper evidences_filter_wrapper:
        :return: EvidencesSearchResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_evidence_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.search_evidence_with_http_info(**kwargs)  # noqa: E501
            return data

    def search_evidence_with_http_info(self, **kwargs):  # noqa: E501
        """Search evidence  # noqa: E501

        Search for an evidence entutiy by filter  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_evidence_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EvidencesFilterWrapper evidences_filter_wrapper:
        :return: EvidencesSearchResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['evidences_filter_wrapper']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_evidence" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'evidences_filter_wrapper' in params:
            body_params = params['evidences_filter_wrapper']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'csrf_token', 'x-xdr-auth-id']  # noqa: E501

        return self.api_client.call_api(
            '/evidence/search', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EvidencesSearchResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_incidents(self, filter, **kwargs):  # noqa: E501
        """Search incidents by filter  # noqa: E501

        This will search incidents across all indices You can filter by multiple options  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_incidents(filter, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SearchIncidentsData filter: (required)
        :return: InlineResponse200
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_incidents_with_http_info(filter, **kwargs)  # noqa: E501
        else:
            (data) = self.search_incidents_with_http_info(filter, **kwargs)  # noqa: E501
            return data

    def search_incidents_with_http_info(self, filter, **kwargs):  # noqa: E501
        """Search incidents by filter  # noqa: E501

        This will search incidents across all indices You can filter by multiple options  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_incidents_with_http_info(filter, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SearchIncidentsData filter: (required)
        :return: InlineResponse200
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['filter']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_incidents" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'filter' is set
        if ('filter' not in params or
                params['filter'] is None):
            raise ValueError("Missing the required parameter `filter` when calling `search_incidents`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'filter' in params:
            body_params = params['filter']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'csrf_token', 'x-xdr-auth-id']  # noqa: E501

        return self.api_client.call_api(
            '/incidents/search', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse200',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_investigations(self, **kwargs):  # noqa: E501
        """Search investigations by filter  # noqa: E501

        This will search investigations across all indices You can filter by multiple options  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_investigations(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param InvestigationFilter filter:
        :return: InvestigationSearchResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_investigations_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.search_investigations_with_http_info(**kwargs)  # noqa: E501
            return data

    def search_investigations_with_http_info(self, **kwargs):  # noqa: E501
        """Search investigations by filter  # noqa: E501

        This will search investigations across all indices You can filter by multiple options  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_investigations_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param InvestigationFilter filter:
        :return: InvestigationSearchResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['filter']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_investigations" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'filter' in params:
            body_params = params['filter']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'csrf_token', 'x-xdr-auth-id']  # noqa: E501

        return self.api_client.call_api(
            '/investigations/search', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InvestigationSearchResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simple_complete_task(self, **kwargs):  # noqa: E501
        """Complete task simple (no file)  # noqa: E501

        Complete a task without a file attachment  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simple_complete_task(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param InvTaskInfo inv_task_info:
        :return: InvestigationPlaybook
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.simple_complete_task_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.simple_complete_task_with_http_info(**kwargs)  # noqa: E501
            return data

    def simple_complete_task_with_http_info(self, **kwargs):  # noqa: E501
        """Complete task simple (no file)  # noqa: E501

        Complete a task without a file attachment  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simple_complete_task_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param InvTaskInfo inv_task_info:
        :return: InvestigationPlaybook
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['inv_task_info']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simple_complete_task" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'inv_task_info' in params:
            body_params = params['inv_task_info']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'csrf_token', 'x-xdr-auth-id']  # noqa: E501

        return self.api_client.call_api(
            '/inv-playbook/task/complete/simple', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InvestigationPlaybook',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def submit_task_form(self, investigation_id, task_id, answers, **kwargs):  # noqa: E501
        """Complete a task  # noqa: E501

        Submit a data collection task with given answers and multiple file attachments  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.submit_task_form(investigation_id, task_id, answers, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str investigation_id: investigation ID (required)
        :param str task_id: Task Id (required)
        :param str answers: the answers to the task form. Answers are keyed by numerical question id (required)
        :param file file: Files to attach to the task
        :return: InvestigationPlaybook
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.submit_task_form_with_http_info(investigation_id, task_id, answers, **kwargs)  # noqa: E501
        else:
            (data) = self.submit_task_form_with_http_info(investigation_id, task_id, answers, **kwargs)  # noqa: E501
            return data

    def submit_task_form_with_http_info(self, investigation_id, task_id, answers, **kwargs):  # noqa: E501
        """Complete a task  # noqa: E501

        Submit a data collection task with given answers and multiple file attachments  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.submit_task_form_with_http_info(investigation_id, task_id, answers, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str investigation_id: investigation ID (required)
        :param str task_id: Task Id (required)
        :param str answers: the answers to the task form. Answers are keyed by numerical question id (required)
        :param file file: Files to attach to the task
        :return: InvestigationPlaybook
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['investigation_id', 'task_id', 'answers', 'file']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method submit_task_form" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'investigation_id' is set
        if ('investigation_id' not in params or
                params['investigation_id'] is None):
            raise ValueError("Missing the required parameter `investigation_id` when calling `submit_task_form`")  # noqa: E501
        # verify the required parameter 'task_id' is set
        if ('task_id' not in params or
                params['task_id'] is None):
            raise ValueError("Missing the required parameter `task_id` when calling `submit_task_form`")  # noqa: E501
        # verify the required parameter 'answers' is set
        if ('answers' not in params or
                params['answers'] is None):
            raise ValueError("Missing the required parameter `answers` when calling `submit_task_form`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'investigation_id' in params:
            form_params.append(('investigationId', params['investigation_id']))  # noqa: E501
        if 'task_id' in params:
            form_params.append(('taskId', params['task_id']))  # noqa: E501
        if 'answers' in params:
            form_params.append(('answers', params['answers']))  # noqa: E501
        if 'file' in params:
            local_var_files['file'] = params['file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'csrf_token', 'x-xdr-auth-id']  # noqa: E501

        return self.api_client.call_api(
            '/v2/inv-playbook/task/form/submit', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InvestigationPlaybook',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def task_add_comment(self, **kwargs):  # noqa: E501
        """Task add comment  # noqa: E501

        Add comment to a task  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.task_add_comment(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param InvTaskInfo inv_task_info:
        :return: InvestigationPlaybook
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.task_add_comment_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.task_add_comment_with_http_info(**kwargs)  # noqa: E501
            return data

    def task_add_comment_with_http_info(self, **kwargs):  # noqa: E501
        """Task add comment  # noqa: E501

        Add comment to a task  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.task_add_comment_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param InvTaskInfo inv_task_info:
        :return: InvestigationPlaybook
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['inv_task_info']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method task_add_comment" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'inv_task_info' in params:
            body_params = params['inv_task_info']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'csrf_token', 'x-xdr-auth-id']  # noqa: E501

        return self.api_client.call_api(
            '/inv-playbook/task/note/add', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InvestigationPlaybook',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def task_assign(self, **kwargs):  # noqa: E501
        """Assign task  # noqa: E501

        Assign a task to an owner  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.task_assign(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param InvPlaybookAssignee inv_playbook_assignee:
        :return: InvestigationPlaybook
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.task_assign_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.task_assign_with_http_info(**kwargs)  # noqa: E501
            return data

    def task_assign_with_http_info(self, **kwargs):  # noqa: E501
        """Assign task  # noqa: E501

        Assign a task to an owner  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.task_assign_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param InvPlaybookAssignee inv_playbook_assignee:
        :return: InvestigationPlaybook
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['inv_playbook_assignee']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method task_assign" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'inv_playbook_assignee' in params:
            body_params = params['inv_playbook_assignee']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'csrf_token', 'x-xdr-auth-id']  # noqa: E501

        return self.api_client.call_api(
            '/inv-playbook/task/assign', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InvestigationPlaybook',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def task_set_due(self, **kwargs):  # noqa: E501
        """Set task due date  # noqa: E501

        Set the task due date  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.task_set_due(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param InvPlaybookDue inv_playbook_due:
        :return: InvestigationPlaybook
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.task_set_due_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.task_set_due_with_http_info(**kwargs)  # noqa: E501
            return data

    def task_set_due_with_http_info(self, **kwargs):  # noqa: E501
        """Set task due date  # noqa: E501

        Set the task due date  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.task_set_due_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param InvPlaybookDue inv_playbook_due:
        :return: InvestigationPlaybook
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['inv_playbook_due']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method task_set_due" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'inv_playbook_due' in params:
            body_params = params['inv_playbook_due']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'csrf_token', 'x-xdr-auth-id']  # noqa: E501

        return self.api_client.call_api(
            '/inv-playbook/task/due', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InvestigationPlaybook',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def task_un_complete(self, **kwargs):  # noqa: E501
        """Un complete a task  # noqa: E501

        Reopen a closed task and change the status to uncomplete  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.task_un_complete(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param InvTaskInfo inv_task_info:
        :return: InvestigationPlaybook
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.task_un_complete_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.task_un_complete_with_http_info(**kwargs)  # noqa: E501
            return data

    def task_un_complete_with_http_info(self, **kwargs):  # noqa: E501
        """Un complete a task  # noqa: E501

        Reopen a closed task and change the status to uncomplete  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.task_un_complete_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param InvTaskInfo inv_task_info:
        :return: InvestigationPlaybook
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['inv_task_info']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method task_un_complete" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'inv_task_info' in params:
            body_params = params['inv_task_info']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'csrf_token', 'x-xdr-auth-id']  # noqa: E501

        return self.api_client.call_api(
            '/inv-playbook/task/uncomplete', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InvestigationPlaybook',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_entry_note(self, **kwargs):  # noqa: E501
        """Mark entry as note  # noqa: E501

        API to mark entry as note, can be used also to remove the note Body example: {\"id\":1\\@1234\",\"version\":\"-1\",\"investigationId\":\"1234\",\"data\":\"true/false\"}  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_entry_note(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UpdateEntry update_entry:
        :return: Entry
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_entry_note_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.update_entry_note_with_http_info(**kwargs)  # noqa: E501
            return data

    def update_entry_note_with_http_info(self, **kwargs):  # noqa: E501
        """Mark entry as note  # noqa: E501

        API to mark entry as note, can be used also to remove the note Body example: {\"id\":1\\@1234\",\"version\":\"-1\",\"investigationId\":\"1234\",\"data\":\"true/false\"}  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_entry_note_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UpdateEntry update_entry:
        :return: Entry
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['update_entry']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_entry_note" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'update_entry' in params:
            body_params = params['update_entry']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'csrf_token', 'x-xdr-auth-id']  # noqa: E501

        return self.api_client.call_api(
            '/entry/note', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Entry',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_entry_tags_op(self, **kwargs):  # noqa: E501
        """Set entry tags  # noqa: E501

        API to set entry tags Body example: {\"id\":\"1\\@1234\",\"version\":\"-1\",\"investigationId\":\"1234\",\"tags\":[\"tag1\",\"tag2\"]\"}  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_entry_tags_op(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UpdateEntryTags update_entry_tags:
        :return: Entry
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_entry_tags_op_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.update_entry_tags_op_with_http_info(**kwargs)  # noqa: E501
            return data

    def update_entry_tags_op_with_http_info(self, **kwargs):  # noqa: E501
        """Set entry tags  # noqa: E501

        API to set entry tags Body example: {\"id\":\"1\\@1234\",\"version\":\"-1\",\"investigationId\":\"1234\",\"tags\":[\"tag1\",\"tag2\"]\"}  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_entry_tags_op_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UpdateEntryTags update_entry_tags:
        :return: Entry
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['update_entry_tags']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_entry_tags_op" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'update_entry_tags' in params:
            body_params = params['update_entry_tags']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'csrf_token', 'x-xdr-auth-id']  # noqa: E501

        return self.api_client.call_api(
            '/entry/tags', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Entry',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def upload_content_packs(self, file, **kwargs):  # noqa: E501
        """Upload a Pack as zip file. The zip file maybe a single Pack or a zip containing multiple zipped Packs (a zip of zips)  # noqa: E501

        Upload a Pack to the marketplace in the Server. Can be used to upload a Pack for an offline scenario or a Pack that hasn't been released.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.upload_content_packs(file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file file: file (required)
        :param object skip_validation: if true will skip upload packs validation, use when migrating existing custom content to packs.
        :param object skip_verify: If true will skip pack signature verification. Use when uploading a custom or dev pack
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.upload_content_packs_with_http_info(file, **kwargs)  # noqa: E501
        else:
            (data) = self.upload_content_packs_with_http_info(file, **kwargs)  # noqa: E501
            return data

    def upload_content_packs_with_http_info(self, file, **kwargs):  # noqa: E501
        """Upload a Pack as zip file. The zip file maybe a single Pack or a zip containing multiple zipped Packs (a zip of zips)  # noqa: E501

        Upload a Pack to the marketplace in the Server. Can be used to upload a Pack for an offline scenario or a Pack that hasn't been released.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.upload_content_packs_with_http_info(file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file file: file (required)
        :param object skip_validation: if true will skip upload packs validation, use when migrating existing custom content to packs.
        :param object skip_verify: If true will skip pack signature verification. Use when uploading a custom or dev pack
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['file', 'skip_validation', 'skip_verify']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upload_content_packs" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'file' is set
        if ('file' not in params or
                params['file'] is None):
            raise ValueError("Missing the required parameter `file` when calling `upload_content_packs`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'file' in params:
            local_var_files['file'] = params['file']  # noqa: E501
        if 'skip_validation' in params:
            form_params.append(('skipValidation', params['skip_validation']))  # noqa: E501
        if 'skip_verify' in params:
            form_params.append(('skipVerify', params['skip_verify']))  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'csrf_token', 'x-xdr-auth-id']  # noqa: E501

        return self.api_client.call_api(
            '/contentpacks/installed/upload', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def upload_report(self, file, **kwargs):  # noqa: E501
        """Upload report file to Demisto  # noqa: E501

        Upload report file to Demisto  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.upload_report(file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file file: file (required)
        :return: list[Report]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.upload_report_with_http_info(file, **kwargs)  # noqa: E501
        else:
            (data) = self.upload_report_with_http_info(file, **kwargs)  # noqa: E501
            return data

    def upload_report_with_http_info(self, file, **kwargs):  # noqa: E501
        """Upload report file to Demisto  # noqa: E501

        Upload report file to Demisto  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.upload_report_with_http_info(file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file file: file (required)
        :return: list[Report]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['file']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upload_report" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'file' is set
        if ('file' not in params or
                params['file'] is None):
            raise ValueError("Missing the required parameter `file` when calling `upload_report`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'file' in params:
            local_var_files['file'] = params['file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'csrf_token', 'x-xdr-auth-id']  # noqa: E501

        return self.api_client.call_api(
            '/reports/upload', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Report]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def generic_request(self, path, method, body=None, **kwargs):  # noqa: E501
        return demisto_client.generic_request_func(self, path, method, body, **kwargs)
