# coding: utf-8

"""
    Demisto API

    This is the public REST API to integrate with the demisto server. HTTP request can be sent using any HTTP-client.  For an example dedicated client take a look at: https://github.com/demisto/demisto-py.  Requests must include API-key that can be generated in the Demisto web client under 'Settings' -> 'Integrations' -> 'API keys'   Optimistic Locking and Versioning\\:  When using Demisto REST API, you will need to make sure to work on the latest version of the item (incident, entry, etc.), otherwise, you will get a DB version error (which not allow you to override a newer item). In addition, you can pass 'version\\: -1' to force data override (make sure that other users data might be lost).  Assume that Alice and Bob both read the same data from Demisto server, then they both changed the data, and then both tried to write the new versions back to the server. Whose changes should be saved? Alice’s? Bob’s? To solve this, each data item in Demisto has a numeric incremental version. If Alice saved an item with version 4 and Bob trying to save the same item with version 3, Demisto will rollback Bob request and returns a DB version conflict error. Bob will need to get the latest item and work on it so Alice work will not get lost.  Example request using 'curl'\\:  ``` curl 'https://hostname:443/incidents/search' -H 'content-type: application/json' -H 'accept: application/json' -H 'Authorization: <API Key goes here>' --data-binary '{\"filter\":{\"query\":\"-status:closed -category:job\",\"period\":{\"by\":\"day\",\"fromValue\":7}}}' --compressed ```  # noqa: E501

    OpenAPI spec version: 2.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from demisto_client.demisto_api.models.filter_operator_id import FilterOperatorID  # noqa: F401,E501
from demisto_client.demisto_api.models.operator_argument import OperatorArgument  # noqa: F401,E501


class ArgAtomicFilter(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'ignore_case': 'bool',
        'left': 'OperatorArgument',
        'operator': 'FilterOperatorID',
        'right': 'OperatorArgument',
        'type': 'str'
    }

    attribute_map = {
        'ignore_case': 'ignoreCase',
        'left': 'left',
        'operator': 'operator',
        'right': 'right',
        'type': 'type'
    }

    def __init__(self, ignore_case=None, left=None, operator=None, right=None, type=None):  # noqa: E501
        """ArgAtomicFilter - a model defined in Swagger"""  # noqa: E501

        self._ignore_case = None
        self._left = None
        self._operator = None
        self._right = None
        self._type = None
        self.discriminator = None

        if ignore_case is not None:
            self.ignore_case = ignore_case
        if left is not None:
            self.left = left
        if operator is not None:
            self.operator = operator
        if right is not None:
            self.right = right
        if type is not None:
            self.type = type

    @property
    def ignore_case(self):
        """Gets the ignore_case of this ArgAtomicFilter.  # noqa: E501


        :return: The ignore_case of this ArgAtomicFilter.  # noqa: E501
        :rtype: bool
        """
        return self._ignore_case

    @ignore_case.setter
    def ignore_case(self, ignore_case):
        """Sets the ignore_case of this ArgAtomicFilter.


        :param ignore_case: The ignore_case of this ArgAtomicFilter.  # noqa: E501
        :type: bool
        """

        self._ignore_case = ignore_case

    @property
    def left(self):
        """Gets the left of this ArgAtomicFilter.  # noqa: E501


        :return: The left of this ArgAtomicFilter.  # noqa: E501
        :rtype: OperatorArgument
        """
        return self._left

    @left.setter
    def left(self, left):
        """Sets the left of this ArgAtomicFilter.


        :param left: The left of this ArgAtomicFilter.  # noqa: E501
        :type: OperatorArgument
        """

        self._left = left

    @property
    def operator(self):
        """Gets the operator of this ArgAtomicFilter.  # noqa: E501


        :return: The operator of this ArgAtomicFilter.  # noqa: E501
        :rtype: FilterOperatorID
        """
        return self._operator

    @operator.setter
    def operator(self, operator):
        """Sets the operator of this ArgAtomicFilter.


        :param operator: The operator of this ArgAtomicFilter.  # noqa: E501
        :type: FilterOperatorID
        """

        self._operator = operator

    @property
    def right(self):
        """Gets the right of this ArgAtomicFilter.  # noqa: E501


        :return: The right of this ArgAtomicFilter.  # noqa: E501
        :rtype: OperatorArgument
        """
        return self._right

    @right.setter
    def right(self, right):
        """Sets the right of this ArgAtomicFilter.


        :param right: The right of this ArgAtomicFilter.  # noqa: E501
        :type: OperatorArgument
        """

        self._right = right

    @property
    def type(self):
        """Gets the type of this ArgAtomicFilter.  # noqa: E501


        :return: The type of this ArgAtomicFilter.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this ArgAtomicFilter.


        :param type: The type of this ArgAtomicFilter.  # noqa: E501
        :type: str
        """

        self._type = type

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(ArgAtomicFilter, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ArgAtomicFilter):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
