# coding: utf-8

"""
    Demisto API

    This is the public REST API to integrate with the demisto server. HTTP request can be sent using any HTTP-client.  For an example dedicated client take a look at: https://github.com/demisto/demisto-py.  Requests must include API-key that can be generated in the Demisto web client under 'Settings' -> 'Integrations' -> 'API keys'   Optimistic Locking and Versioning\\:  When using Demisto REST API, you will need to make sure to work on the latest version of the item (incident, entry, etc.), otherwise, you will get a DB version error (which not allow you to override a newer item). In addition, you can pass 'version\\: -1' to force data override (make sure that other users data might be lost).  Assume that Alice and Bob both read the same data from Demisto server, then they both changed the data, and then both tried to write the new versions back to the server. Whose changes should be saved? Alice’s? Bob’s? To solve this, each data item in Demisto has a numeric incremental version. If Alice saved an item with version 4 and Bob trying to save the same item with version 3, Demisto will rollback Bob request and returns a DB version conflict error. Bob will need to get the latest item and work on it so Alice work will not get lost.  Example request using 'curl'\\:  ``` curl 'https://hostname:443/incidents/search' -H 'content-type: application/json' -H 'accept: application/json' -H 'Authorization: <API Key goes here>' --data-binary '{\"filter\":{\"query\":\"-status:closed -category:job\",\"period\":{\"by\":\"day\",\"fromValue\":7}}}' --compressed ```  # noqa: E501

    OpenAPI spec version: 2.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from demisto_client.demisto_api.models.layout_section import LayoutSection  # noqa: F401,E501
from demisto_client.demisto_api.models.version import Version  # noqa: F401,E501


class Layout(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'commit_message': 'str',
        'from_server_version': 'Version',
        'id': 'str',
        'item_version': 'Version',
        'kind': 'str',
        'modified': 'datetime',
        'name': 'str',
        'pack_id': 'str',
        'prev_kind': 'str',
        'prev_type_id': 'str',
        'primary_term': 'int',
        'propagation_labels': 'list[str]',
        'sections': 'list[LayoutSection]',
        'sequence_number': 'int',
        'should_commit': 'bool',
        'sort_values': 'list[str]',
        'system': 'bool',
        'to_server_version': 'Version',
        'type_id': 'str',
        'vc_should_ignore': 'bool',
        'version': 'int'
    }

    attribute_map = {
        'commit_message': 'commitMessage',
        'from_server_version': 'fromServerVersion',
        'id': 'id',
        'item_version': 'itemVersion',
        'kind': 'kind',
        'modified': 'modified',
        'name': 'name',
        'pack_id': 'packID',
        'prev_kind': 'prevKind',
        'prev_type_id': 'prevTypeId',
        'primary_term': 'primaryTerm',
        'propagation_labels': 'propagationLabels',
        'sections': 'sections',
        'sequence_number': 'sequenceNumber',
        'should_commit': 'shouldCommit',
        'sort_values': 'sortValues',
        'system': 'system',
        'to_server_version': 'toServerVersion',
        'type_id': 'typeId',
        'vc_should_ignore': 'vcShouldIgnore',
        'version': 'version'
    }

    def __init__(self, commit_message=None, from_server_version=None, id=None, item_version=None, kind=None, modified=None, name=None, pack_id=None, prev_kind=None, prev_type_id=None, primary_term=None, propagation_labels=None, sections=None, sequence_number=None, should_commit=None, sort_values=None, system=None, to_server_version=None, type_id=None, vc_should_ignore=None, version=None):  # noqa: E501
        """Layout - a model defined in Swagger"""  # noqa: E501

        self._commit_message = None
        self._from_server_version = None
        self._id = None
        self._item_version = None
        self._kind = None
        self._modified = None
        self._name = None
        self._pack_id = None
        self._prev_kind = None
        self._prev_type_id = None
        self._primary_term = None
        self._propagation_labels = None
        self._sections = None
        self._sequence_number = None
        self._should_commit = None
        self._sort_values = None
        self._system = None
        self._to_server_version = None
        self._type_id = None
        self._vc_should_ignore = None
        self._version = None
        self.discriminator = None

        if commit_message is not None:
            self.commit_message = commit_message
        if from_server_version is not None:
            self.from_server_version = from_server_version
        if id is not None:
            self.id = id
        if item_version is not None:
            self.item_version = item_version
        if kind is not None:
            self.kind = kind
        if modified is not None:
            self.modified = modified
        if name is not None:
            self.name = name
        if pack_id is not None:
            self.pack_id = pack_id
        if prev_kind is not None:
            self.prev_kind = prev_kind
        if prev_type_id is not None:
            self.prev_type_id = prev_type_id
        if primary_term is not None:
            self.primary_term = primary_term
        if propagation_labels is not None:
            self.propagation_labels = propagation_labels
        if sections is not None:
            self.sections = sections
        if sequence_number is not None:
            self.sequence_number = sequence_number
        if should_commit is not None:
            self.should_commit = should_commit
        if sort_values is not None:
            self.sort_values = sort_values
        if system is not None:
            self.system = system
        if to_server_version is not None:
            self.to_server_version = to_server_version
        if type_id is not None:
            self.type_id = type_id
        if vc_should_ignore is not None:
            self.vc_should_ignore = vc_should_ignore
        if version is not None:
            self.version = version

    @property
    def commit_message(self):
        """Gets the commit_message of this Layout.  # noqa: E501


        :return: The commit_message of this Layout.  # noqa: E501
        :rtype: str
        """
        return self._commit_message

    @commit_message.setter
    def commit_message(self, commit_message):
        """Sets the commit_message of this Layout.


        :param commit_message: The commit_message of this Layout.  # noqa: E501
        :type: str
        """

        self._commit_message = commit_message

    @property
    def from_server_version(self):
        """Gets the from_server_version of this Layout.  # noqa: E501


        :return: The from_server_version of this Layout.  # noqa: E501
        :rtype: Version
        """
        return self._from_server_version

    @from_server_version.setter
    def from_server_version(self, from_server_version):
        """Sets the from_server_version of this Layout.


        :param from_server_version: The from_server_version of this Layout.  # noqa: E501
        :type: Version
        """

        self._from_server_version = from_server_version

    @property
    def id(self):
        """Gets the id of this Layout.  # noqa: E501


        :return: The id of this Layout.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this Layout.


        :param id: The id of this Layout.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def item_version(self):
        """Gets the item_version of this Layout.  # noqa: E501


        :return: The item_version of this Layout.  # noqa: E501
        :rtype: Version
        """
        return self._item_version

    @item_version.setter
    def item_version(self, item_version):
        """Sets the item_version of this Layout.


        :param item_version: The item_version of this Layout.  # noqa: E501
        :type: Version
        """

        self._item_version = item_version

    @property
    def kind(self):
        """Gets the kind of this Layout.  # noqa: E501


        :return: The kind of this Layout.  # noqa: E501
        :rtype: str
        """
        return self._kind

    @kind.setter
    def kind(self, kind):
        """Sets the kind of this Layout.


        :param kind: The kind of this Layout.  # noqa: E501
        :type: str
        """

        self._kind = kind

    @property
    def modified(self):
        """Gets the modified of this Layout.  # noqa: E501


        :return: The modified of this Layout.  # noqa: E501
        :rtype: datetime
        """
        return self._modified

    @modified.setter
    def modified(self, modified):
        """Sets the modified of this Layout.


        :param modified: The modified of this Layout.  # noqa: E501
        :type: datetime
        """

        self._modified = modified

    @property
    def name(self):
        """Gets the name of this Layout.  # noqa: E501


        :return: The name of this Layout.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this Layout.


        :param name: The name of this Layout.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def pack_id(self):
        """Gets the pack_id of this Layout.  # noqa: E501


        :return: The pack_id of this Layout.  # noqa: E501
        :rtype: str
        """
        return self._pack_id

    @pack_id.setter
    def pack_id(self, pack_id):
        """Sets the pack_id of this Layout.


        :param pack_id: The pack_id of this Layout.  # noqa: E501
        :type: str
        """

        self._pack_id = pack_id

    @property
    def prev_kind(self):
        """Gets the prev_kind of this Layout.  # noqa: E501


        :return: The prev_kind of this Layout.  # noqa: E501
        :rtype: str
        """
        return self._prev_kind

    @prev_kind.setter
    def prev_kind(self, prev_kind):
        """Sets the prev_kind of this Layout.


        :param prev_kind: The prev_kind of this Layout.  # noqa: E501
        :type: str
        """

        self._prev_kind = prev_kind

    @property
    def prev_type_id(self):
        """Gets the prev_type_id of this Layout.  # noqa: E501


        :return: The prev_type_id of this Layout.  # noqa: E501
        :rtype: str
        """
        return self._prev_type_id

    @prev_type_id.setter
    def prev_type_id(self, prev_type_id):
        """Sets the prev_type_id of this Layout.


        :param prev_type_id: The prev_type_id of this Layout.  # noqa: E501
        :type: str
        """

        self._prev_type_id = prev_type_id

    @property
    def primary_term(self):
        """Gets the primary_term of this Layout.  # noqa: E501


        :return: The primary_term of this Layout.  # noqa: E501
        :rtype: int
        """
        return self._primary_term

    @primary_term.setter
    def primary_term(self, primary_term):
        """Sets the primary_term of this Layout.


        :param primary_term: The primary_term of this Layout.  # noqa: E501
        :type: int
        """

        self._primary_term = primary_term

    @property
    def propagation_labels(self):
        """Gets the propagation_labels of this Layout.  # noqa: E501


        :return: The propagation_labels of this Layout.  # noqa: E501
        :rtype: list[str]
        """
        return self._propagation_labels

    @propagation_labels.setter
    def propagation_labels(self, propagation_labels):
        """Sets the propagation_labels of this Layout.


        :param propagation_labels: The propagation_labels of this Layout.  # noqa: E501
        :type: list[str]
        """

        self._propagation_labels = propagation_labels

    @property
    def sections(self):
        """Gets the sections of this Layout.  # noqa: E501


        :return: The sections of this Layout.  # noqa: E501
        :rtype: list[LayoutSection]
        """
        return self._sections

    @sections.setter
    def sections(self, sections):
        """Sets the sections of this Layout.


        :param sections: The sections of this Layout.  # noqa: E501
        :type: list[LayoutSection]
        """

        self._sections = sections

    @property
    def sequence_number(self):
        """Gets the sequence_number of this Layout.  # noqa: E501


        :return: The sequence_number of this Layout.  # noqa: E501
        :rtype: int
        """
        return self._sequence_number

    @sequence_number.setter
    def sequence_number(self, sequence_number):
        """Sets the sequence_number of this Layout.


        :param sequence_number: The sequence_number of this Layout.  # noqa: E501
        :type: int
        """

        self._sequence_number = sequence_number

    @property
    def should_commit(self):
        """Gets the should_commit of this Layout.  # noqa: E501


        :return: The should_commit of this Layout.  # noqa: E501
        :rtype: bool
        """
        return self._should_commit

    @should_commit.setter
    def should_commit(self, should_commit):
        """Sets the should_commit of this Layout.


        :param should_commit: The should_commit of this Layout.  # noqa: E501
        :type: bool
        """

        self._should_commit = should_commit

    @property
    def sort_values(self):
        """Gets the sort_values of this Layout.  # noqa: E501


        :return: The sort_values of this Layout.  # noqa: E501
        :rtype: list[str]
        """
        return self._sort_values

    @sort_values.setter
    def sort_values(self, sort_values):
        """Sets the sort_values of this Layout.


        :param sort_values: The sort_values of this Layout.  # noqa: E501
        :type: list[str]
        """

        self._sort_values = sort_values

    @property
    def system(self):
        """Gets the system of this Layout.  # noqa: E501


        :return: The system of this Layout.  # noqa: E501
        :rtype: bool
        """
        return self._system

    @system.setter
    def system(self, system):
        """Sets the system of this Layout.


        :param system: The system of this Layout.  # noqa: E501
        :type: bool
        """

        self._system = system

    @property
    def to_server_version(self):
        """Gets the to_server_version of this Layout.  # noqa: E501


        :return: The to_server_version of this Layout.  # noqa: E501
        :rtype: Version
        """
        return self._to_server_version

    @to_server_version.setter
    def to_server_version(self, to_server_version):
        """Sets the to_server_version of this Layout.


        :param to_server_version: The to_server_version of this Layout.  # noqa: E501
        :type: Version
        """

        self._to_server_version = to_server_version

    @property
    def type_id(self):
        """Gets the type_id of this Layout.  # noqa: E501


        :return: The type_id of this Layout.  # noqa: E501
        :rtype: str
        """
        return self._type_id

    @type_id.setter
    def type_id(self, type_id):
        """Sets the type_id of this Layout.


        :param type_id: The type_id of this Layout.  # noqa: E501
        :type: str
        """

        self._type_id = type_id

    @property
    def vc_should_ignore(self):
        """Gets the vc_should_ignore of this Layout.  # noqa: E501


        :return: The vc_should_ignore of this Layout.  # noqa: E501
        :rtype: bool
        """
        return self._vc_should_ignore

    @vc_should_ignore.setter
    def vc_should_ignore(self, vc_should_ignore):
        """Sets the vc_should_ignore of this Layout.


        :param vc_should_ignore: The vc_should_ignore of this Layout.  # noqa: E501
        :type: bool
        """

        self._vc_should_ignore = vc_should_ignore

    @property
    def version(self):
        """Gets the version of this Layout.  # noqa: E501


        :return: The version of this Layout.  # noqa: E501
        :rtype: int
        """
        return self._version

    @version.setter
    def version(self, version):
        """Sets the version of this Layout.


        :param version: The version of this Layout.  # noqa: E501
        :type: int
        """

        self._version = version

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Layout, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Layout):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
