# coding: utf-8

"""
    Demisto API

    This is the public REST API to integrate with the demisto server. HTTP request can be sent using any HTTP-client.  For an example dedicated client take a look at: https://github.com/demisto/demisto-py.  Requests must include API-key that can be generated in the Demisto web client under 'Settings' -> 'Integrations' -> 'API keys'   Optimistic Locking and Versioning\\:  When using Demisto REST API, you will need to make sure to work on the latest version of the item (incident, entry, etc.), otherwise, you will get a DB version error (which not allow you to override a newer item). In addition, you can pass 'version\\: -1' to force data override (make sure that other users data might be lost).  Assume that Alice and Bob both read the same data from Demisto server, then they both changed the data, and then both tried to write the new versions back to the server. Whose changes should be saved? Alice’s? Bob’s? To solve this, each data item in Demisto has a numeric incremental version. If Alice saved an item with version 4 and Bob trying to save the same item with version 3, Demisto will rollback Bob request and returns a DB version conflict error. Bob will need to get the latest item and work on it so Alice work will not get lost.  Example request using 'curl'\\:  ``` curl 'https://hostname:443/incidents/search' -H 'content-type: application/json' -H 'accept: application/json' -H 'Authorization: <API Key goes here>' --data-binary '{\"filter\":{\"query\":\"-status:closed -category:job\",\"period\":{\"by\":\"day\",\"fromValue\":7}}}' --compressed ```  # noqa: E501

    OpenAPI spec version: 2.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from demisto_client.demisto_api.models.layout_field import LayoutField  # noqa: F401,E501


class LayoutSection(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'description': 'str',
        'fields': 'list[LayoutField]',
        'id': 'str',
        'is_visible': 'bool',
        'modified': 'datetime',
        'name': 'str',
        'primary_term': 'int',
        'query': 'object',
        'query_type': 'str',
        'read_only': 'bool',
        'sequence_number': 'int',
        'sort_values': 'list[str]',
        'type': 'str',
        'version': 'int'
    }

    attribute_map = {
        'description': 'description',
        'fields': 'fields',
        'id': 'id',
        'is_visible': 'isVisible',
        'modified': 'modified',
        'name': 'name',
        'primary_term': 'primaryTerm',
        'query': 'query',
        'query_type': 'queryType',
        'read_only': 'readOnly',
        'sequence_number': 'sequenceNumber',
        'sort_values': 'sortValues',
        'type': 'type',
        'version': 'version'
    }

    def __init__(self, description=None, fields=None, id=None, is_visible=None, modified=None, name=None, primary_term=None, query=None, query_type=None, read_only=None, sequence_number=None, sort_values=None, type=None, version=None):  # noqa: E501
        """LayoutSection - a model defined in Swagger"""  # noqa: E501

        self._description = None
        self._fields = None
        self._id = None
        self._is_visible = None
        self._modified = None
        self._name = None
        self._primary_term = None
        self._query = None
        self._query_type = None
        self._read_only = None
        self._sequence_number = None
        self._sort_values = None
        self._type = None
        self._version = None
        self.discriminator = None

        if description is not None:
            self.description = description
        if fields is not None:
            self.fields = fields
        if id is not None:
            self.id = id
        if is_visible is not None:
            self.is_visible = is_visible
        if modified is not None:
            self.modified = modified
        if name is not None:
            self.name = name
        if primary_term is not None:
            self.primary_term = primary_term
        if query is not None:
            self.query = query
        if query_type is not None:
            self.query_type = query_type
        if read_only is not None:
            self.read_only = read_only
        if sequence_number is not None:
            self.sequence_number = sequence_number
        if sort_values is not None:
            self.sort_values = sort_values
        if type is not None:
            self.type = type
        if version is not None:
            self.version = version

    @property
    def description(self):
        """Gets the description of this LayoutSection.  # noqa: E501


        :return: The description of this LayoutSection.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this LayoutSection.


        :param description: The description of this LayoutSection.  # noqa: E501
        :type: str
        """

        self._description = description

    @property
    def fields(self):
        """Gets the fields of this LayoutSection.  # noqa: E501


        :return: The fields of this LayoutSection.  # noqa: E501
        :rtype: list[LayoutField]
        """
        return self._fields

    @fields.setter
    def fields(self, fields):
        """Sets the fields of this LayoutSection.


        :param fields: The fields of this LayoutSection.  # noqa: E501
        :type: list[LayoutField]
        """

        self._fields = fields

    @property
    def id(self):
        """Gets the id of this LayoutSection.  # noqa: E501


        :return: The id of this LayoutSection.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this LayoutSection.


        :param id: The id of this LayoutSection.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def is_visible(self):
        """Gets the is_visible of this LayoutSection.  # noqa: E501


        :return: The is_visible of this LayoutSection.  # noqa: E501
        :rtype: bool
        """
        return self._is_visible

    @is_visible.setter
    def is_visible(self, is_visible):
        """Sets the is_visible of this LayoutSection.


        :param is_visible: The is_visible of this LayoutSection.  # noqa: E501
        :type: bool
        """

        self._is_visible = is_visible

    @property
    def modified(self):
        """Gets the modified of this LayoutSection.  # noqa: E501


        :return: The modified of this LayoutSection.  # noqa: E501
        :rtype: datetime
        """
        return self._modified

    @modified.setter
    def modified(self, modified):
        """Sets the modified of this LayoutSection.


        :param modified: The modified of this LayoutSection.  # noqa: E501
        :type: datetime
        """

        self._modified = modified

    @property
    def name(self):
        """Gets the name of this LayoutSection.  # noqa: E501


        :return: The name of this LayoutSection.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this LayoutSection.


        :param name: The name of this LayoutSection.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def primary_term(self):
        """Gets the primary_term of this LayoutSection.  # noqa: E501


        :return: The primary_term of this LayoutSection.  # noqa: E501
        :rtype: int
        """
        return self._primary_term

    @primary_term.setter
    def primary_term(self, primary_term):
        """Sets the primary_term of this LayoutSection.


        :param primary_term: The primary_term of this LayoutSection.  # noqa: E501
        :type: int
        """

        self._primary_term = primary_term

    @property
    def query(self):
        """Gets the query of this LayoutSection.  # noqa: E501


        :return: The query of this LayoutSection.  # noqa: E501
        :rtype: object
        """
        return self._query

    @query.setter
    def query(self, query):
        """Sets the query of this LayoutSection.


        :param query: The query of this LayoutSection.  # noqa: E501
        :type: object
        """

        self._query = query

    @property
    def query_type(self):
        """Gets the query_type of this LayoutSection.  # noqa: E501


        :return: The query_type of this LayoutSection.  # noqa: E501
        :rtype: str
        """
        return self._query_type

    @query_type.setter
    def query_type(self, query_type):
        """Sets the query_type of this LayoutSection.


        :param query_type: The query_type of this LayoutSection.  # noqa: E501
        :type: str
        """

        self._query_type = query_type

    @property
    def read_only(self):
        """Gets the read_only of this LayoutSection.  # noqa: E501


        :return: The read_only of this LayoutSection.  # noqa: E501
        :rtype: bool
        """
        return self._read_only

    @read_only.setter
    def read_only(self, read_only):
        """Sets the read_only of this LayoutSection.


        :param read_only: The read_only of this LayoutSection.  # noqa: E501
        :type: bool
        """

        self._read_only = read_only

    @property
    def sequence_number(self):
        """Gets the sequence_number of this LayoutSection.  # noqa: E501


        :return: The sequence_number of this LayoutSection.  # noqa: E501
        :rtype: int
        """
        return self._sequence_number

    @sequence_number.setter
    def sequence_number(self, sequence_number):
        """Sets the sequence_number of this LayoutSection.


        :param sequence_number: The sequence_number of this LayoutSection.  # noqa: E501
        :type: int
        """

        self._sequence_number = sequence_number

    @property
    def sort_values(self):
        """Gets the sort_values of this LayoutSection.  # noqa: E501


        :return: The sort_values of this LayoutSection.  # noqa: E501
        :rtype: list[str]
        """
        return self._sort_values

    @sort_values.setter
    def sort_values(self, sort_values):
        """Sets the sort_values of this LayoutSection.


        :param sort_values: The sort_values of this LayoutSection.  # noqa: E501
        :type: list[str]
        """

        self._sort_values = sort_values

    @property
    def type(self):
        """Gets the type of this LayoutSection.  # noqa: E501


        :return: The type of this LayoutSection.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this LayoutSection.


        :param type: The type of this LayoutSection.  # noqa: E501
        :type: str
        """

        self._type = type

    @property
    def version(self):
        """Gets the version of this LayoutSection.  # noqa: E501


        :return: The version of this LayoutSection.  # noqa: E501
        :rtype: int
        """
        return self._version

    @version.setter
    def version(self, version):
        """Sets the version of this LayoutSection.


        :param version: The version of this LayoutSection.  # noqa: E501
        :type: int
        """

        self._version = version

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(LayoutSection, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, LayoutSection):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
