# coding: utf-8

"""
    Demisto API

    This is the public REST API to integrate with the demisto server. HTTP request can be sent using any HTTP-client.  For an example dedicated client take a look at: https://github.com/demisto/demisto-py.  Requests must include API-key that can be generated in the Demisto web client under 'Settings' -> 'Integrations' -> 'API keys'   Optimistic Locking and Versioning\\:  When using Demisto REST API, you will need to make sure to work on the latest version of the item (incident, entry, etc.), otherwise, you will get a DB version error (which not allow you to override a newer item). In addition, you can pass 'version\\: -1' to force data override (make sure that other users data might be lost).  Assume that Alice and Bob both read the same data from Demisto server, then they both changed the data, and then both tried to write the new versions back to the server. Whose changes should be saved? Alice’s? Bob’s? To solve this, each data item in Demisto has a numeric incremental version. If Alice saved an item with version 4 and Bob trying to save the same item with version 3, Demisto will rollback Bob request and returns a DB version conflict error. Bob will need to get the latest item and work on it so Alice work will not get lost.  Example request using 'curl'\\:  ``` curl 'https://hostname:443/incidents/search' -H 'content-type: application/json' -H 'accept: application/json' -H 'Authorization: <API Key goes here>' --data-binary '{\"filter\":{\"query\":\"-status:closed -category:job\",\"period\":{\"by\":\"day\",\"fromValue\":7}}}' --compressed ```  # noqa: E501

    OpenAPI spec version: 2.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from demisto_client.demisto_api.models.config_field import ConfigField  # noqa: F401,E501
from demisto_client.demisto_api.models.integration_script import IntegrationScript  # noqa: F401,E501


class ModuleConfiguration(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'beta': 'bool',
        'brand': 'str',
        'can_get_samples': 'bool',
        'category': 'str',
        'cmdline': 'str',
        'commit_message': 'str',
        'configuration': 'list[ConfigField]',
        'deprecated': 'bool',
        'description': 'str',
        'detailed_description': 'str',
        'display': 'str',
        'executable': 'str',
        'hidden': 'bool',
        'hide_engines': 'bool',
        'icon': 'str',
        'id': 'str',
        'image': 'str',
        'integration_script': 'IntegrationScript',
        'is_password_protected': 'bool',
        'locked': 'bool',
        'modified': 'datetime',
        'name': 'str',
        'path': 'str',
        'prev_name': 'str',
        'propagation_labels': 'list[str]',
        'readonly': 'bool',
        'script_not_visible': 'bool',
        'should_commit': 'bool',
        'sort_values': 'list[str]',
        'source_module_id': 'str',
        'system': 'bool',
        'vc_should_ignore': 'bool',
        'version': 'int'
    }

    attribute_map = {
        'beta': 'beta',
        'brand': 'brand',
        'can_get_samples': 'canGetSamples',
        'category': 'category',
        'cmdline': 'cmdline',
        'commit_message': 'commitMessage',
        'configuration': 'configuration',
        'deprecated': 'deprecated',
        'description': 'description',
        'detailed_description': 'detailedDescription',
        'display': 'display',
        'executable': 'executable',
        'hidden': 'hidden',
        'hide_engines': 'hideEngines',
        'icon': 'icon',
        'id': 'id',
        'image': 'image',
        'integration_script': 'integrationScript',
        'is_password_protected': 'isPasswordProtected',
        'locked': 'locked',
        'modified': 'modified',
        'name': 'name',
        'path': 'path',
        'prev_name': 'prevName',
        'propagation_labels': 'propagationLabels',
        'readonly': 'readonly',
        'script_not_visible': 'scriptNotVisible',
        'should_commit': 'shouldCommit',
        'sort_values': 'sortValues',
        'source_module_id': 'sourceModuleID',
        'system': 'system',
        'vc_should_ignore': 'vcShouldIgnore',
        'version': 'version'
    }

    def __init__(self, beta=None, brand=None, can_get_samples=None, category=None, cmdline=None, commit_message=None, configuration=None, deprecated=None, description=None, detailed_description=None, display=None, executable=None, hidden=None, hide_engines=None, icon=None, id=None, image=None, integration_script=None, is_password_protected=None, locked=None, modified=None, name=None, path=None, prev_name=None, propagation_labels=None, readonly=None, script_not_visible=None, should_commit=None, sort_values=None, source_module_id=None, system=None, vc_should_ignore=None, version=None):  # noqa: E501
        """ModuleConfiguration - a model defined in Swagger"""  # noqa: E501

        self._beta = None
        self._brand = None
        self._can_get_samples = None
        self._category = None
        self._cmdline = None
        self._commit_message = None
        self._configuration = None
        self._deprecated = None
        self._description = None
        self._detailed_description = None
        self._display = None
        self._executable = None
        self._hidden = None
        self._hide_engines = None
        self._icon = None
        self._id = None
        self._image = None
        self._integration_script = None
        self._is_password_protected = None
        self._locked = None
        self._modified = None
        self._name = None
        self._path = None
        self._prev_name = None
        self._propagation_labels = None
        self._readonly = None
        self._script_not_visible = None
        self._should_commit = None
        self._sort_values = None
        self._source_module_id = None
        self._system = None
        self._vc_should_ignore = None
        self._version = None
        self.discriminator = None

        if beta is not None:
            self.beta = beta
        if brand is not None:
            self.brand = brand
        if can_get_samples is not None:
            self.can_get_samples = can_get_samples
        if category is not None:
            self.category = category
        if cmdline is not None:
            self.cmdline = cmdline
        if commit_message is not None:
            self.commit_message = commit_message
        if configuration is not None:
            self.configuration = configuration
        if deprecated is not None:
            self.deprecated = deprecated
        if description is not None:
            self.description = description
        if detailed_description is not None:
            self.detailed_description = detailed_description
        if display is not None:
            self.display = display
        if executable is not None:
            self.executable = executable
        if hidden is not None:
            self.hidden = hidden
        if hide_engines is not None:
            self.hide_engines = hide_engines
        if icon is not None:
            self.icon = icon
        if id is not None:
            self.id = id
        if image is not None:
            self.image = image
        if integration_script is not None:
            self.integration_script = integration_script
        if is_password_protected is not None:
            self.is_password_protected = is_password_protected
        if locked is not None:
            self.locked = locked
        if modified is not None:
            self.modified = modified
        if name is not None:
            self.name = name
        if path is not None:
            self.path = path
        if prev_name is not None:
            self.prev_name = prev_name
        if propagation_labels is not None:
            self.propagation_labels = propagation_labels
        if readonly is not None:
            self.readonly = readonly
        if script_not_visible is not None:
            self.script_not_visible = script_not_visible
        if should_commit is not None:
            self.should_commit = should_commit
        if sort_values is not None:
            self.sort_values = sort_values
        if source_module_id is not None:
            self.source_module_id = source_module_id
        if system is not None:
            self.system = system
        if vc_should_ignore is not None:
            self.vc_should_ignore = vc_should_ignore
        if version is not None:
            self.version = version

    @property
    def beta(self):
        """Gets the beta of this ModuleConfiguration.  # noqa: E501


        :return: The beta of this ModuleConfiguration.  # noqa: E501
        :rtype: bool
        """
        return self._beta

    @beta.setter
    def beta(self, beta):
        """Sets the beta of this ModuleConfiguration.


        :param beta: The beta of this ModuleConfiguration.  # noqa: E501
        :type: bool
        """

        self._beta = beta

    @property
    def brand(self):
        """Gets the brand of this ModuleConfiguration.  # noqa: E501


        :return: The brand of this ModuleConfiguration.  # noqa: E501
        :rtype: str
        """
        return self._brand

    @brand.setter
    def brand(self, brand):
        """Sets the brand of this ModuleConfiguration.


        :param brand: The brand of this ModuleConfiguration.  # noqa: E501
        :type: str
        """

        self._brand = brand

    @property
    def can_get_samples(self):
        """Gets the can_get_samples of this ModuleConfiguration.  # noqa: E501


        :return: The can_get_samples of this ModuleConfiguration.  # noqa: E501
        :rtype: bool
        """
        return self._can_get_samples

    @can_get_samples.setter
    def can_get_samples(self, can_get_samples):
        """Sets the can_get_samples of this ModuleConfiguration.


        :param can_get_samples: The can_get_samples of this ModuleConfiguration.  # noqa: E501
        :type: bool
        """

        self._can_get_samples = can_get_samples

    @property
    def category(self):
        """Gets the category of this ModuleConfiguration.  # noqa: E501


        :return: The category of this ModuleConfiguration.  # noqa: E501
        :rtype: str
        """
        return self._category

    @category.setter
    def category(self, category):
        """Sets the category of this ModuleConfiguration.


        :param category: The category of this ModuleConfiguration.  # noqa: E501
        :type: str
        """

        self._category = category

    @property
    def cmdline(self):
        """Gets the cmdline of this ModuleConfiguration.  # noqa: E501


        :return: The cmdline of this ModuleConfiguration.  # noqa: E501
        :rtype: str
        """
        return self._cmdline

    @cmdline.setter
    def cmdline(self, cmdline):
        """Sets the cmdline of this ModuleConfiguration.


        :param cmdline: The cmdline of this ModuleConfiguration.  # noqa: E501
        :type: str
        """

        self._cmdline = cmdline

    @property
    def commit_message(self):
        """Gets the commit_message of this ModuleConfiguration.  # noqa: E501


        :return: The commit_message of this ModuleConfiguration.  # noqa: E501
        :rtype: str
        """
        return self._commit_message

    @commit_message.setter
    def commit_message(self, commit_message):
        """Sets the commit_message of this ModuleConfiguration.


        :param commit_message: The commit_message of this ModuleConfiguration.  # noqa: E501
        :type: str
        """

        self._commit_message = commit_message

    @property
    def configuration(self):
        """Gets the configuration of this ModuleConfiguration.  # noqa: E501


        :return: The configuration of this ModuleConfiguration.  # noqa: E501
        :rtype: list[ConfigField]
        """
        return self._configuration

    @configuration.setter
    def configuration(self, configuration):
        """Sets the configuration of this ModuleConfiguration.


        :param configuration: The configuration of this ModuleConfiguration.  # noqa: E501
        :type: list[ConfigField]
        """

        self._configuration = configuration

    @property
    def deprecated(self):
        """Gets the deprecated of this ModuleConfiguration.  # noqa: E501


        :return: The deprecated of this ModuleConfiguration.  # noqa: E501
        :rtype: bool
        """
        return self._deprecated

    @deprecated.setter
    def deprecated(self, deprecated):
        """Sets the deprecated of this ModuleConfiguration.


        :param deprecated: The deprecated of this ModuleConfiguration.  # noqa: E501
        :type: bool
        """

        self._deprecated = deprecated

    @property
    def description(self):
        """Gets the description of this ModuleConfiguration.  # noqa: E501


        :return: The description of this ModuleConfiguration.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this ModuleConfiguration.


        :param description: The description of this ModuleConfiguration.  # noqa: E501
        :type: str
        """

        self._description = description

    @property
    def detailed_description(self):
        """Gets the detailed_description of this ModuleConfiguration.  # noqa: E501


        :return: The detailed_description of this ModuleConfiguration.  # noqa: E501
        :rtype: str
        """
        return self._detailed_description

    @detailed_description.setter
    def detailed_description(self, detailed_description):
        """Sets the detailed_description of this ModuleConfiguration.


        :param detailed_description: The detailed_description of this ModuleConfiguration.  # noqa: E501
        :type: str
        """

        self._detailed_description = detailed_description

    @property
    def display(self):
        """Gets the display of this ModuleConfiguration.  # noqa: E501


        :return: The display of this ModuleConfiguration.  # noqa: E501
        :rtype: str
        """
        return self._display

    @display.setter
    def display(self, display):
        """Sets the display of this ModuleConfiguration.


        :param display: The display of this ModuleConfiguration.  # noqa: E501
        :type: str
        """

        self._display = display

    @property
    def executable(self):
        """Gets the executable of this ModuleConfiguration.  # noqa: E501


        :return: The executable of this ModuleConfiguration.  # noqa: E501
        :rtype: str
        """
        return self._executable

    @executable.setter
    def executable(self, executable):
        """Sets the executable of this ModuleConfiguration.


        :param executable: The executable of this ModuleConfiguration.  # noqa: E501
        :type: str
        """

        self._executable = executable

    @property
    def hidden(self):
        """Gets the hidden of this ModuleConfiguration.  # noqa: E501


        :return: The hidden of this ModuleConfiguration.  # noqa: E501
        :rtype: bool
        """
        return self._hidden

    @hidden.setter
    def hidden(self, hidden):
        """Sets the hidden of this ModuleConfiguration.


        :param hidden: The hidden of this ModuleConfiguration.  # noqa: E501
        :type: bool
        """

        self._hidden = hidden

    @property
    def hide_engines(self):
        """Gets the hide_engines of this ModuleConfiguration.  # noqa: E501


        :return: The hide_engines of this ModuleConfiguration.  # noqa: E501
        :rtype: bool
        """
        return self._hide_engines

    @hide_engines.setter
    def hide_engines(self, hide_engines):
        """Sets the hide_engines of this ModuleConfiguration.


        :param hide_engines: The hide_engines of this ModuleConfiguration.  # noqa: E501
        :type: bool
        """

        self._hide_engines = hide_engines

    @property
    def icon(self):
        """Gets the icon of this ModuleConfiguration.  # noqa: E501


        :return: The icon of this ModuleConfiguration.  # noqa: E501
        :rtype: str
        """
        return self._icon

    @icon.setter
    def icon(self, icon):
        """Sets the icon of this ModuleConfiguration.


        :param icon: The icon of this ModuleConfiguration.  # noqa: E501
        :type: str
        """

        self._icon = icon

    @property
    def id(self):
        """Gets the id of this ModuleConfiguration.  # noqa: E501


        :return: The id of this ModuleConfiguration.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this ModuleConfiguration.


        :param id: The id of this ModuleConfiguration.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def image(self):
        """Gets the image of this ModuleConfiguration.  # noqa: E501


        :return: The image of this ModuleConfiguration.  # noqa: E501
        :rtype: str
        """
        return self._image

    @image.setter
    def image(self, image):
        """Sets the image of this ModuleConfiguration.


        :param image: The image of this ModuleConfiguration.  # noqa: E501
        :type: str
        """

        self._image = image

    @property
    def integration_script(self):
        """Gets the integration_script of this ModuleConfiguration.  # noqa: E501


        :return: The integration_script of this ModuleConfiguration.  # noqa: E501
        :rtype: IntegrationScript
        """
        return self._integration_script

    @integration_script.setter
    def integration_script(self, integration_script):
        """Sets the integration_script of this ModuleConfiguration.


        :param integration_script: The integration_script of this ModuleConfiguration.  # noqa: E501
        :type: IntegrationScript
        """

        self._integration_script = integration_script

    @property
    def is_password_protected(self):
        """Gets the is_password_protected of this ModuleConfiguration.  # noqa: E501


        :return: The is_password_protected of this ModuleConfiguration.  # noqa: E501
        :rtype: bool
        """
        return self._is_password_protected

    @is_password_protected.setter
    def is_password_protected(self, is_password_protected):
        """Sets the is_password_protected of this ModuleConfiguration.


        :param is_password_protected: The is_password_protected of this ModuleConfiguration.  # noqa: E501
        :type: bool
        """

        self._is_password_protected = is_password_protected

    @property
    def locked(self):
        """Gets the locked of this ModuleConfiguration.  # noqa: E501


        :return: The locked of this ModuleConfiguration.  # noqa: E501
        :rtype: bool
        """
        return self._locked

    @locked.setter
    def locked(self, locked):
        """Sets the locked of this ModuleConfiguration.


        :param locked: The locked of this ModuleConfiguration.  # noqa: E501
        :type: bool
        """

        self._locked = locked

    @property
    def modified(self):
        """Gets the modified of this ModuleConfiguration.  # noqa: E501


        :return: The modified of this ModuleConfiguration.  # noqa: E501
        :rtype: datetime
        """
        return self._modified

    @modified.setter
    def modified(self, modified):
        """Sets the modified of this ModuleConfiguration.


        :param modified: The modified of this ModuleConfiguration.  # noqa: E501
        :type: datetime
        """

        self._modified = modified

    @property
    def name(self):
        """Gets the name of this ModuleConfiguration.  # noqa: E501


        :return: The name of this ModuleConfiguration.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this ModuleConfiguration.


        :param name: The name of this ModuleConfiguration.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def path(self):
        """Gets the path of this ModuleConfiguration.  # noqa: E501


        :return: The path of this ModuleConfiguration.  # noqa: E501
        :rtype: str
        """
        return self._path

    @path.setter
    def path(self, path):
        """Sets the path of this ModuleConfiguration.


        :param path: The path of this ModuleConfiguration.  # noqa: E501
        :type: str
        """

        self._path = path

    @property
    def prev_name(self):
        """Gets the prev_name of this ModuleConfiguration.  # noqa: E501


        :return: The prev_name of this ModuleConfiguration.  # noqa: E501
        :rtype: str
        """
        return self._prev_name

    @prev_name.setter
    def prev_name(self, prev_name):
        """Sets the prev_name of this ModuleConfiguration.


        :param prev_name: The prev_name of this ModuleConfiguration.  # noqa: E501
        :type: str
        """

        self._prev_name = prev_name

    @property
    def propagation_labels(self):
        """Gets the propagation_labels of this ModuleConfiguration.  # noqa: E501


        :return: The propagation_labels of this ModuleConfiguration.  # noqa: E501
        :rtype: list[str]
        """
        return self._propagation_labels

    @propagation_labels.setter
    def propagation_labels(self, propagation_labels):
        """Sets the propagation_labels of this ModuleConfiguration.


        :param propagation_labels: The propagation_labels of this ModuleConfiguration.  # noqa: E501
        :type: list[str]
        """

        self._propagation_labels = propagation_labels

    @property
    def readonly(self):
        """Gets the readonly of this ModuleConfiguration.  # noqa: E501


        :return: The readonly of this ModuleConfiguration.  # noqa: E501
        :rtype: bool
        """
        return self._readonly

    @readonly.setter
    def readonly(self, readonly):
        """Sets the readonly of this ModuleConfiguration.


        :param readonly: The readonly of this ModuleConfiguration.  # noqa: E501
        :type: bool
        """

        self._readonly = readonly

    @property
    def script_not_visible(self):
        """Gets the script_not_visible of this ModuleConfiguration.  # noqa: E501


        :return: The script_not_visible of this ModuleConfiguration.  # noqa: E501
        :rtype: bool
        """
        return self._script_not_visible

    @script_not_visible.setter
    def script_not_visible(self, script_not_visible):
        """Sets the script_not_visible of this ModuleConfiguration.


        :param script_not_visible: The script_not_visible of this ModuleConfiguration.  # noqa: E501
        :type: bool
        """

        self._script_not_visible = script_not_visible

    @property
    def should_commit(self):
        """Gets the should_commit of this ModuleConfiguration.  # noqa: E501


        :return: The should_commit of this ModuleConfiguration.  # noqa: E501
        :rtype: bool
        """
        return self._should_commit

    @should_commit.setter
    def should_commit(self, should_commit):
        """Sets the should_commit of this ModuleConfiguration.


        :param should_commit: The should_commit of this ModuleConfiguration.  # noqa: E501
        :type: bool
        """

        self._should_commit = should_commit

    @property
    def sort_values(self):
        """Gets the sort_values of this ModuleConfiguration.  # noqa: E501


        :return: The sort_values of this ModuleConfiguration.  # noqa: E501
        :rtype: list[str]
        """
        return self._sort_values

    @sort_values.setter
    def sort_values(self, sort_values):
        """Sets the sort_values of this ModuleConfiguration.


        :param sort_values: The sort_values of this ModuleConfiguration.  # noqa: E501
        :type: list[str]
        """

        self._sort_values = sort_values

    @property
    def source_module_id(self):
        """Gets the source_module_id of this ModuleConfiguration.  # noqa: E501


        :return: The source_module_id of this ModuleConfiguration.  # noqa: E501
        :rtype: str
        """
        return self._source_module_id

    @source_module_id.setter
    def source_module_id(self, source_module_id):
        """Sets the source_module_id of this ModuleConfiguration.


        :param source_module_id: The source_module_id of this ModuleConfiguration.  # noqa: E501
        :type: str
        """

        self._source_module_id = source_module_id

    @property
    def system(self):
        """Gets the system of this ModuleConfiguration.  # noqa: E501


        :return: The system of this ModuleConfiguration.  # noqa: E501
        :rtype: bool
        """
        return self._system

    @system.setter
    def system(self, system):
        """Sets the system of this ModuleConfiguration.


        :param system: The system of this ModuleConfiguration.  # noqa: E501
        :type: bool
        """

        self._system = system

    @property
    def vc_should_ignore(self):
        """Gets the vc_should_ignore of this ModuleConfiguration.  # noqa: E501


        :return: The vc_should_ignore of this ModuleConfiguration.  # noqa: E501
        :rtype: bool
        """
        return self._vc_should_ignore

    @vc_should_ignore.setter
    def vc_should_ignore(self, vc_should_ignore):
        """Sets the vc_should_ignore of this ModuleConfiguration.


        :param vc_should_ignore: The vc_should_ignore of this ModuleConfiguration.  # noqa: E501
        :type: bool
        """

        self._vc_should_ignore = vc_should_ignore

    @property
    def version(self):
        """Gets the version of this ModuleConfiguration.  # noqa: E501


        :return: The version of this ModuleConfiguration.  # noqa: E501
        :rtype: int
        """
        return self._version

    @version.setter
    def version(self, version):
        """Sets the version of this ModuleConfiguration.


        :param version: The version of this ModuleConfiguration.  # noqa: E501
        :type: int
        """

        self._version = version

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(ModuleConfiguration, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ModuleConfiguration):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
