# coding: utf-8

"""
    Demisto API

    This is the public REST API to integrate with the demisto server. HTTP request can be sent using any HTTP-client.  For an example dedicated client take a look at: https://github.com/demisto/demisto-py.  Requests must include API-key that can be generated in the Demisto web client under 'Settings' -> 'Integrations' -> 'API keys'   Optimistic Locking and Versioning\\:  When using Demisto REST API, you will need to make sure to work on the latest version of the item (incident, entry, etc.), otherwise, you will get a DB version error (which not allow you to override a newer item). In addition, you can pass 'version\\: -1' to force data override (make sure that other users data might be lost).  Assume that Alice and Bob both read the same data from Demisto server, then they both changed the data, and then both tried to write the new versions back to the server. Whose changes should be saved? Alice’s? Bob’s? To solve this, each data item in Demisto has a numeric incremental version. If Alice saved an item with version 4 and Bob trying to save the same item with version 3, Demisto will rollback Bob request and returns a DB version conflict error. Bob will need to get the latest item and work on it so Alice work will not get lost.  Example request using 'curl'\\:  ``` curl 'https://hostname:443/incidents/search' -H 'content-type: application/json' -H 'accept: application/json' -H 'Authorization: <API Key goes here>' --data-binary '{\"filter\":{\"query\":\"-status:closed -category:job\",\"period\":{\"by\":\"day\",\"fromValue\":7}}}' --compressed ```  # noqa: E501

    OpenAPI spec version: 2.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from demisto_client.demisto_api.models.advance_arg import AdvanceArg  # noqa: F401,E501
from demisto_client.demisto_api.models.version import Version  # noqa: F401,E501


class Reputation(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'cache_versn': 'int',
        'commit_message': 'str',
        'context_path': 'str',
        'context_value': 'str',
        'default_mapping': 'dict(str, AdvanceArg)',
        'definition_id': 'str',
        'details': 'str',
        'disabled': 'bool',
        'enhancement_script_names': 'list[str]',
        'excluded_brands': 'list[str]',
        'expiration': 'int',
        'file': 'bool',
        'file_hashes_priority': 'list[str]',
        'format_script': 'str',
        'from_server_version': 'Version',
        'highlight': 'dict(str, list[str])',
        'id': 'str',
        'item_version': 'Version',
        'layout': 'str',
        'legacy_names': 'list[str]',
        'locked': 'bool',
        'manual_mapping': 'dict(str, AdvanceArg)',
        'merge_context': 'bool',
        'modified': 'datetime',
        'numeric_id': 'int',
        'pack_id': 'str',
        'pack_name': 'str',
        'pack_propagation_labels': 'list[str]',
        'prev_details': 'str',
        'primary_term': 'int',
        'propagation_labels': 'list[str]',
        'regex': 'str',
        'remote': 'bool',
        'reputation_command': 'str',
        'reputation_script_name': 'str',
        'sequence_number': 'int',
        'should_commit': 'bool',
        'should_share_comments': 'bool',
        'sort_values': 'list[str]',
        'sync_hash': 'str',
        'system': 'bool',
        'to_server_version': 'Version',
        'update_after': 'int',
        'vc_should_ignore': 'bool',
        'vc_should_keep_item_legacy_prod_machine': 'bool',
        'version': 'int'
    }

    attribute_map = {
        'cache_versn': 'cacheVersn',
        'commit_message': 'commitMessage',
        'context_path': 'contextPath',
        'context_value': 'contextValue',
        'default_mapping': 'defaultMapping',
        'definition_id': 'definitionId',
        'details': 'details',
        'disabled': 'disabled',
        'enhancement_script_names': 'enhancementScriptNames',
        'excluded_brands': 'excludedBrands',
        'expiration': 'expiration',
        'file': 'file',
        'file_hashes_priority': 'fileHashesPriority',
        'format_script': 'formatScript',
        'from_server_version': 'fromServerVersion',
        'highlight': 'highlight',
        'id': 'id',
        'item_version': 'itemVersion',
        'layout': 'layout',
        'legacy_names': 'legacyNames',
        'locked': 'locked',
        'manual_mapping': 'manualMapping',
        'merge_context': 'mergeContext',
        'modified': 'modified',
        'numeric_id': 'numericId',
        'pack_id': 'packID',
        'pack_name': 'packName',
        'pack_propagation_labels': 'packPropagationLabels',
        'prev_details': 'prevDetails',
        'primary_term': 'primaryTerm',
        'propagation_labels': 'propagationLabels',
        'regex': 'regex',
        'remote': 'remote',
        'reputation_command': 'reputationCommand',
        'reputation_script_name': 'reputationScriptName',
        'sequence_number': 'sequenceNumber',
        'should_commit': 'shouldCommit',
        'should_share_comments': 'shouldShareComments',
        'sort_values': 'sortValues',
        'sync_hash': 'syncHash',
        'system': 'system',
        'to_server_version': 'toServerVersion',
        'update_after': 'updateAfter',
        'vc_should_ignore': 'vcShouldIgnore',
        'vc_should_keep_item_legacy_prod_machine': 'vcShouldKeepItemLegacyProdMachine',
        'version': 'version'
    }

    def __init__(self, cache_versn=None, commit_message=None, context_path=None, context_value=None, default_mapping=None, definition_id=None, details=None, disabled=None, enhancement_script_names=None, excluded_brands=None, expiration=None, file=None, file_hashes_priority=None, format_script=None, from_server_version=None, highlight=None, id=None, item_version=None, layout=None, legacy_names=None, locked=None, manual_mapping=None, merge_context=None, modified=None, numeric_id=None, pack_id=None, pack_name=None, pack_propagation_labels=None, prev_details=None, primary_term=None, propagation_labels=None, regex=None, remote=None, reputation_command=None, reputation_script_name=None, sequence_number=None, should_commit=None, should_share_comments=None, sort_values=None, sync_hash=None, system=None, to_server_version=None, update_after=None, vc_should_ignore=None, vc_should_keep_item_legacy_prod_machine=None, version=None):  # noqa: E501
        """Reputation - a model defined in Swagger"""  # noqa: E501

        self._cache_versn = None
        self._commit_message = None
        self._context_path = None
        self._context_value = None
        self._default_mapping = None
        self._definition_id = None
        self._details = None
        self._disabled = None
        self._enhancement_script_names = None
        self._excluded_brands = None
        self._expiration = None
        self._file = None
        self._file_hashes_priority = None
        self._format_script = None
        self._from_server_version = None
        self._highlight = None
        self._id = None
        self._item_version = None
        self._layout = None
        self._legacy_names = None
        self._locked = None
        self._manual_mapping = None
        self._merge_context = None
        self._modified = None
        self._numeric_id = None
        self._pack_id = None
        self._pack_name = None
        self._pack_propagation_labels = None
        self._prev_details = None
        self._primary_term = None
        self._propagation_labels = None
        self._regex = None
        self._remote = None
        self._reputation_command = None
        self._reputation_script_name = None
        self._sequence_number = None
        self._should_commit = None
        self._should_share_comments = None
        self._sort_values = None
        self._sync_hash = None
        self._system = None
        self._to_server_version = None
        self._update_after = None
        self._vc_should_ignore = None
        self._vc_should_keep_item_legacy_prod_machine = None
        self._version = None
        self.discriminator = None

        if cache_versn is not None:
            self.cache_versn = cache_versn
        if commit_message is not None:
            self.commit_message = commit_message
        if context_path is not None:
            self.context_path = context_path
        if context_value is not None:
            self.context_value = context_value
        if default_mapping is not None:
            self.default_mapping = default_mapping
        if definition_id is not None:
            self.definition_id = definition_id
        if details is not None:
            self.details = details
        if disabled is not None:
            self.disabled = disabled
        if enhancement_script_names is not None:
            self.enhancement_script_names = enhancement_script_names
        if excluded_brands is not None:
            self.excluded_brands = excluded_brands
        if expiration is not None:
            self.expiration = expiration
        if file is not None:
            self.file = file
        if file_hashes_priority is not None:
            self.file_hashes_priority = file_hashes_priority
        if format_script is not None:
            self.format_script = format_script
        if from_server_version is not None:
            self.from_server_version = from_server_version
        if highlight is not None:
            self.highlight = highlight
        if id is not None:
            self.id = id
        if item_version is not None:
            self.item_version = item_version
        if layout is not None:
            self.layout = layout
        if legacy_names is not None:
            self.legacy_names = legacy_names
        if locked is not None:
            self.locked = locked
        if manual_mapping is not None:
            self.manual_mapping = manual_mapping
        if merge_context is not None:
            self.merge_context = merge_context
        if modified is not None:
            self.modified = modified
        if numeric_id is not None:
            self.numeric_id = numeric_id
        if pack_id is not None:
            self.pack_id = pack_id
        if pack_name is not None:
            self.pack_name = pack_name
        if pack_propagation_labels is not None:
            self.pack_propagation_labels = pack_propagation_labels
        if prev_details is not None:
            self.prev_details = prev_details
        if primary_term is not None:
            self.primary_term = primary_term
        if propagation_labels is not None:
            self.propagation_labels = propagation_labels
        if regex is not None:
            self.regex = regex
        if remote is not None:
            self.remote = remote
        if reputation_command is not None:
            self.reputation_command = reputation_command
        if reputation_script_name is not None:
            self.reputation_script_name = reputation_script_name
        if sequence_number is not None:
            self.sequence_number = sequence_number
        if should_commit is not None:
            self.should_commit = should_commit
        if should_share_comments is not None:
            self.should_share_comments = should_share_comments
        if sort_values is not None:
            self.sort_values = sort_values
        if sync_hash is not None:
            self.sync_hash = sync_hash
        if system is not None:
            self.system = system
        if to_server_version is not None:
            self.to_server_version = to_server_version
        if update_after is not None:
            self.update_after = update_after
        if vc_should_ignore is not None:
            self.vc_should_ignore = vc_should_ignore
        if vc_should_keep_item_legacy_prod_machine is not None:
            self.vc_should_keep_item_legacy_prod_machine = vc_should_keep_item_legacy_prod_machine
        if version is not None:
            self.version = version

    @property
    def cache_versn(self):
        """Gets the cache_versn of this Reputation.  # noqa: E501


        :return: The cache_versn of this Reputation.  # noqa: E501
        :rtype: int
        """
        return self._cache_versn

    @cache_versn.setter
    def cache_versn(self, cache_versn):
        """Sets the cache_versn of this Reputation.


        :param cache_versn: The cache_versn of this Reputation.  # noqa: E501
        :type: int
        """

        self._cache_versn = cache_versn

    @property
    def commit_message(self):
        """Gets the commit_message of this Reputation.  # noqa: E501


        :return: The commit_message of this Reputation.  # noqa: E501
        :rtype: str
        """
        return self._commit_message

    @commit_message.setter
    def commit_message(self, commit_message):
        """Sets the commit_message of this Reputation.


        :param commit_message: The commit_message of this Reputation.  # noqa: E501
        :type: str
        """

        self._commit_message = commit_message

    @property
    def context_path(self):
        """Gets the context_path of this Reputation.  # noqa: E501


        :return: The context_path of this Reputation.  # noqa: E501
        :rtype: str
        """
        return self._context_path

    @context_path.setter
    def context_path(self, context_path):
        """Sets the context_path of this Reputation.


        :param context_path: The context_path of this Reputation.  # noqa: E501
        :type: str
        """

        self._context_path = context_path

    @property
    def context_value(self):
        """Gets the context_value of this Reputation.  # noqa: E501


        :return: The context_value of this Reputation.  # noqa: E501
        :rtype: str
        """
        return self._context_value

    @context_value.setter
    def context_value(self, context_value):
        """Sets the context_value of this Reputation.


        :param context_value: The context_value of this Reputation.  # noqa: E501
        :type: str
        """

        self._context_value = context_value

    @property
    def default_mapping(self):
        """Gets the default_mapping of this Reputation.  # noqa: E501


        :return: The default_mapping of this Reputation.  # noqa: E501
        :rtype: dict(str, AdvanceArg)
        """
        return self._default_mapping

    @default_mapping.setter
    def default_mapping(self, default_mapping):
        """Sets the default_mapping of this Reputation.


        :param default_mapping: The default_mapping of this Reputation.  # noqa: E501
        :type: dict(str, AdvanceArg)
        """

        self._default_mapping = default_mapping

    @property
    def definition_id(self):
        """Gets the definition_id of this Reputation.  # noqa: E501


        :return: The definition_id of this Reputation.  # noqa: E501
        :rtype: str
        """
        return self._definition_id

    @definition_id.setter
    def definition_id(self, definition_id):
        """Sets the definition_id of this Reputation.


        :param definition_id: The definition_id of this Reputation.  # noqa: E501
        :type: str
        """

        self._definition_id = definition_id

    @property
    def details(self):
        """Gets the details of this Reputation.  # noqa: E501


        :return: The details of this Reputation.  # noqa: E501
        :rtype: str
        """
        return self._details

    @details.setter
    def details(self, details):
        """Sets the details of this Reputation.


        :param details: The details of this Reputation.  # noqa: E501
        :type: str
        """

        self._details = details

    @property
    def disabled(self):
        """Gets the disabled of this Reputation.  # noqa: E501


        :return: The disabled of this Reputation.  # noqa: E501
        :rtype: bool
        """
        return self._disabled

    @disabled.setter
    def disabled(self, disabled):
        """Sets the disabled of this Reputation.


        :param disabled: The disabled of this Reputation.  # noqa: E501
        :type: bool
        """

        self._disabled = disabled

    @property
    def enhancement_script_names(self):
        """Gets the enhancement_script_names of this Reputation.  # noqa: E501


        :return: The enhancement_script_names of this Reputation.  # noqa: E501
        :rtype: list[str]
        """
        return self._enhancement_script_names

    @enhancement_script_names.setter
    def enhancement_script_names(self, enhancement_script_names):
        """Sets the enhancement_script_names of this Reputation.


        :param enhancement_script_names: The enhancement_script_names of this Reputation.  # noqa: E501
        :type: list[str]
        """

        self._enhancement_script_names = enhancement_script_names

    @property
    def excluded_brands(self):
        """Gets the excluded_brands of this Reputation.  # noqa: E501


        :return: The excluded_brands of this Reputation.  # noqa: E501
        :rtype: list[str]
        """
        return self._excluded_brands

    @excluded_brands.setter
    def excluded_brands(self, excluded_brands):
        """Sets the excluded_brands of this Reputation.


        :param excluded_brands: The excluded_brands of this Reputation.  # noqa: E501
        :type: list[str]
        """

        self._excluded_brands = excluded_brands

    @property
    def expiration(self):
        """Gets the expiration of this Reputation.  # noqa: E501


        :return: The expiration of this Reputation.  # noqa: E501
        :rtype: int
        """
        return self._expiration

    @expiration.setter
    def expiration(self, expiration):
        """Sets the expiration of this Reputation.


        :param expiration: The expiration of this Reputation.  # noqa: E501
        :type: int
        """

        self._expiration = expiration

    @property
    def file(self):
        """Gets the file of this Reputation.  # noqa: E501


        :return: The file of this Reputation.  # noqa: E501
        :rtype: bool
        """
        return self._file

    @file.setter
    def file(self, file):
        """Sets the file of this Reputation.


        :param file: The file of this Reputation.  # noqa: E501
        :type: bool
        """

        self._file = file

    @property
    def file_hashes_priority(self):
        """Gets the file_hashes_priority of this Reputation.  # noqa: E501


        :return: The file_hashes_priority of this Reputation.  # noqa: E501
        :rtype: list[str]
        """
        return self._file_hashes_priority

    @file_hashes_priority.setter
    def file_hashes_priority(self, file_hashes_priority):
        """Sets the file_hashes_priority of this Reputation.


        :param file_hashes_priority: The file_hashes_priority of this Reputation.  # noqa: E501
        :type: list[str]
        """

        self._file_hashes_priority = file_hashes_priority

    @property
    def format_script(self):
        """Gets the format_script of this Reputation.  # noqa: E501


        :return: The format_script of this Reputation.  # noqa: E501
        :rtype: str
        """
        return self._format_script

    @format_script.setter
    def format_script(self, format_script):
        """Sets the format_script of this Reputation.


        :param format_script: The format_script of this Reputation.  # noqa: E501
        :type: str
        """

        self._format_script = format_script

    @property
    def from_server_version(self):
        """Gets the from_server_version of this Reputation.  # noqa: E501


        :return: The from_server_version of this Reputation.  # noqa: E501
        :rtype: Version
        """
        return self._from_server_version

    @from_server_version.setter
    def from_server_version(self, from_server_version):
        """Sets the from_server_version of this Reputation.


        :param from_server_version: The from_server_version of this Reputation.  # noqa: E501
        :type: Version
        """

        self._from_server_version = from_server_version

    @property
    def highlight(self):
        """Gets the highlight of this Reputation.  # noqa: E501


        :return: The highlight of this Reputation.  # noqa: E501
        :rtype: dict(str, list[str])
        """
        return self._highlight

    @highlight.setter
    def highlight(self, highlight):
        """Sets the highlight of this Reputation.


        :param highlight: The highlight of this Reputation.  # noqa: E501
        :type: dict(str, list[str])
        """

        self._highlight = highlight

    @property
    def id(self):
        """Gets the id of this Reputation.  # noqa: E501


        :return: The id of this Reputation.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this Reputation.


        :param id: The id of this Reputation.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def item_version(self):
        """Gets the item_version of this Reputation.  # noqa: E501


        :return: The item_version of this Reputation.  # noqa: E501
        :rtype: Version
        """
        return self._item_version

    @item_version.setter
    def item_version(self, item_version):
        """Sets the item_version of this Reputation.


        :param item_version: The item_version of this Reputation.  # noqa: E501
        :type: Version
        """

        self._item_version = item_version

    @property
    def layout(self):
        """Gets the layout of this Reputation.  # noqa: E501


        :return: The layout of this Reputation.  # noqa: E501
        :rtype: str
        """
        return self._layout

    @layout.setter
    def layout(self, layout):
        """Sets the layout of this Reputation.


        :param layout: The layout of this Reputation.  # noqa: E501
        :type: str
        """

        self._layout = layout

    @property
    def legacy_names(self):
        """Gets the legacy_names of this Reputation.  # noqa: E501


        :return: The legacy_names of this Reputation.  # noqa: E501
        :rtype: list[str]
        """
        return self._legacy_names

    @legacy_names.setter
    def legacy_names(self, legacy_names):
        """Sets the legacy_names of this Reputation.


        :param legacy_names: The legacy_names of this Reputation.  # noqa: E501
        :type: list[str]
        """

        self._legacy_names = legacy_names

    @property
    def locked(self):
        """Gets the locked of this Reputation.  # noqa: E501


        :return: The locked of this Reputation.  # noqa: E501
        :rtype: bool
        """
        return self._locked

    @locked.setter
    def locked(self, locked):
        """Sets the locked of this Reputation.


        :param locked: The locked of this Reputation.  # noqa: E501
        :type: bool
        """

        self._locked = locked

    @property
    def manual_mapping(self):
        """Gets the manual_mapping of this Reputation.  # noqa: E501


        :return: The manual_mapping of this Reputation.  # noqa: E501
        :rtype: dict(str, AdvanceArg)
        """
        return self._manual_mapping

    @manual_mapping.setter
    def manual_mapping(self, manual_mapping):
        """Sets the manual_mapping of this Reputation.


        :param manual_mapping: The manual_mapping of this Reputation.  # noqa: E501
        :type: dict(str, AdvanceArg)
        """

        self._manual_mapping = manual_mapping

    @property
    def merge_context(self):
        """Gets the merge_context of this Reputation.  # noqa: E501


        :return: The merge_context of this Reputation.  # noqa: E501
        :rtype: bool
        """
        return self._merge_context

    @merge_context.setter
    def merge_context(self, merge_context):
        """Sets the merge_context of this Reputation.


        :param merge_context: The merge_context of this Reputation.  # noqa: E501
        :type: bool
        """

        self._merge_context = merge_context

    @property
    def modified(self):
        """Gets the modified of this Reputation.  # noqa: E501


        :return: The modified of this Reputation.  # noqa: E501
        :rtype: datetime
        """
        return self._modified

    @modified.setter
    def modified(self, modified):
        """Sets the modified of this Reputation.


        :param modified: The modified of this Reputation.  # noqa: E501
        :type: datetime
        """

        self._modified = modified

    @property
    def numeric_id(self):
        """Gets the numeric_id of this Reputation.  # noqa: E501


        :return: The numeric_id of this Reputation.  # noqa: E501
        :rtype: int
        """
        return self._numeric_id

    @numeric_id.setter
    def numeric_id(self, numeric_id):
        """Sets the numeric_id of this Reputation.


        :param numeric_id: The numeric_id of this Reputation.  # noqa: E501
        :type: int
        """

        self._numeric_id = numeric_id

    @property
    def pack_id(self):
        """Gets the pack_id of this Reputation.  # noqa: E501


        :return: The pack_id of this Reputation.  # noqa: E501
        :rtype: str
        """
        return self._pack_id

    @pack_id.setter
    def pack_id(self, pack_id):
        """Sets the pack_id of this Reputation.


        :param pack_id: The pack_id of this Reputation.  # noqa: E501
        :type: str
        """

        self._pack_id = pack_id

    @property
    def pack_name(self):
        """Gets the pack_name of this Reputation.  # noqa: E501


        :return: The pack_name of this Reputation.  # noqa: E501
        :rtype: str
        """
        return self._pack_name

    @pack_name.setter
    def pack_name(self, pack_name):
        """Sets the pack_name of this Reputation.


        :param pack_name: The pack_name of this Reputation.  # noqa: E501
        :type: str
        """

        self._pack_name = pack_name

    @property
    def pack_propagation_labels(self):
        """Gets the pack_propagation_labels of this Reputation.  # noqa: E501


        :return: The pack_propagation_labels of this Reputation.  # noqa: E501
        :rtype: list[str]
        """
        return self._pack_propagation_labels

    @pack_propagation_labels.setter
    def pack_propagation_labels(self, pack_propagation_labels):
        """Sets the pack_propagation_labels of this Reputation.


        :param pack_propagation_labels: The pack_propagation_labels of this Reputation.  # noqa: E501
        :type: list[str]
        """

        self._pack_propagation_labels = pack_propagation_labels

    @property
    def prev_details(self):
        """Gets the prev_details of this Reputation.  # noqa: E501


        :return: The prev_details of this Reputation.  # noqa: E501
        :rtype: str
        """
        return self._prev_details

    @prev_details.setter
    def prev_details(self, prev_details):
        """Sets the prev_details of this Reputation.


        :param prev_details: The prev_details of this Reputation.  # noqa: E501
        :type: str
        """

        self._prev_details = prev_details

    @property
    def primary_term(self):
        """Gets the primary_term of this Reputation.  # noqa: E501


        :return: The primary_term of this Reputation.  # noqa: E501
        :rtype: int
        """
        return self._primary_term

    @primary_term.setter
    def primary_term(self, primary_term):
        """Sets the primary_term of this Reputation.


        :param primary_term: The primary_term of this Reputation.  # noqa: E501
        :type: int
        """

        self._primary_term = primary_term

    @property
    def propagation_labels(self):
        """Gets the propagation_labels of this Reputation.  # noqa: E501


        :return: The propagation_labels of this Reputation.  # noqa: E501
        :rtype: list[str]
        """
        return self._propagation_labels

    @propagation_labels.setter
    def propagation_labels(self, propagation_labels):
        """Sets the propagation_labels of this Reputation.


        :param propagation_labels: The propagation_labels of this Reputation.  # noqa: E501
        :type: list[str]
        """

        self._propagation_labels = propagation_labels

    @property
    def regex(self):
        """Gets the regex of this Reputation.  # noqa: E501


        :return: The regex of this Reputation.  # noqa: E501
        :rtype: str
        """
        return self._regex

    @regex.setter
    def regex(self, regex):
        """Sets the regex of this Reputation.


        :param regex: The regex of this Reputation.  # noqa: E501
        :type: str
        """

        self._regex = regex

    @property
    def remote(self):
        """Gets the remote of this Reputation.  # noqa: E501


        :return: The remote of this Reputation.  # noqa: E501
        :rtype: bool
        """
        return self._remote

    @remote.setter
    def remote(self, remote):
        """Sets the remote of this Reputation.


        :param remote: The remote of this Reputation.  # noqa: E501
        :type: bool
        """

        self._remote = remote

    @property
    def reputation_command(self):
        """Gets the reputation_command of this Reputation.  # noqa: E501


        :return: The reputation_command of this Reputation.  # noqa: E501
        :rtype: str
        """
        return self._reputation_command

    @reputation_command.setter
    def reputation_command(self, reputation_command):
        """Sets the reputation_command of this Reputation.


        :param reputation_command: The reputation_command of this Reputation.  # noqa: E501
        :type: str
        """

        self._reputation_command = reputation_command

    @property
    def reputation_script_name(self):
        """Gets the reputation_script_name of this Reputation.  # noqa: E501


        :return: The reputation_script_name of this Reputation.  # noqa: E501
        :rtype: str
        """
        return self._reputation_script_name

    @reputation_script_name.setter
    def reputation_script_name(self, reputation_script_name):
        """Sets the reputation_script_name of this Reputation.


        :param reputation_script_name: The reputation_script_name of this Reputation.  # noqa: E501
        :type: str
        """

        self._reputation_script_name = reputation_script_name

    @property
    def sequence_number(self):
        """Gets the sequence_number of this Reputation.  # noqa: E501


        :return: The sequence_number of this Reputation.  # noqa: E501
        :rtype: int
        """
        return self._sequence_number

    @sequence_number.setter
    def sequence_number(self, sequence_number):
        """Sets the sequence_number of this Reputation.


        :param sequence_number: The sequence_number of this Reputation.  # noqa: E501
        :type: int
        """

        self._sequence_number = sequence_number

    @property
    def should_commit(self):
        """Gets the should_commit of this Reputation.  # noqa: E501


        :return: The should_commit of this Reputation.  # noqa: E501
        :rtype: bool
        """
        return self._should_commit

    @should_commit.setter
    def should_commit(self, should_commit):
        """Sets the should_commit of this Reputation.


        :param should_commit: The should_commit of this Reputation.  # noqa: E501
        :type: bool
        """

        self._should_commit = should_commit

    @property
    def should_share_comments(self):
        """Gets the should_share_comments of this Reputation.  # noqa: E501


        :return: The should_share_comments of this Reputation.  # noqa: E501
        :rtype: bool
        """
        return self._should_share_comments

    @should_share_comments.setter
    def should_share_comments(self, should_share_comments):
        """Sets the should_share_comments of this Reputation.


        :param should_share_comments: The should_share_comments of this Reputation.  # noqa: E501
        :type: bool
        """

        self._should_share_comments = should_share_comments

    @property
    def sort_values(self):
        """Gets the sort_values of this Reputation.  # noqa: E501


        :return: The sort_values of this Reputation.  # noqa: E501
        :rtype: list[str]
        """
        return self._sort_values

    @sort_values.setter
    def sort_values(self, sort_values):
        """Sets the sort_values of this Reputation.


        :param sort_values: The sort_values of this Reputation.  # noqa: E501
        :type: list[str]
        """

        self._sort_values = sort_values

    @property
    def sync_hash(self):
        """Gets the sync_hash of this Reputation.  # noqa: E501


        :return: The sync_hash of this Reputation.  # noqa: E501
        :rtype: str
        """
        return self._sync_hash

    @sync_hash.setter
    def sync_hash(self, sync_hash):
        """Sets the sync_hash of this Reputation.


        :param sync_hash: The sync_hash of this Reputation.  # noqa: E501
        :type: str
        """

        self._sync_hash = sync_hash

    @property
    def system(self):
        """Gets the system of this Reputation.  # noqa: E501


        :return: The system of this Reputation.  # noqa: E501
        :rtype: bool
        """
        return self._system

    @system.setter
    def system(self, system):
        """Sets the system of this Reputation.


        :param system: The system of this Reputation.  # noqa: E501
        :type: bool
        """

        self._system = system

    @property
    def to_server_version(self):
        """Gets the to_server_version of this Reputation.  # noqa: E501


        :return: The to_server_version of this Reputation.  # noqa: E501
        :rtype: Version
        """
        return self._to_server_version

    @to_server_version.setter
    def to_server_version(self, to_server_version):
        """Sets the to_server_version of this Reputation.


        :param to_server_version: The to_server_version of this Reputation.  # noqa: E501
        :type: Version
        """

        self._to_server_version = to_server_version

    @property
    def update_after(self):
        """Gets the update_after of this Reputation.  # noqa: E501


        :return: The update_after of this Reputation.  # noqa: E501
        :rtype: int
        """
        return self._update_after

    @update_after.setter
    def update_after(self, update_after):
        """Sets the update_after of this Reputation.


        :param update_after: The update_after of this Reputation.  # noqa: E501
        :type: int
        """

        self._update_after = update_after

    @property
    def vc_should_ignore(self):
        """Gets the vc_should_ignore of this Reputation.  # noqa: E501


        :return: The vc_should_ignore of this Reputation.  # noqa: E501
        :rtype: bool
        """
        return self._vc_should_ignore

    @vc_should_ignore.setter
    def vc_should_ignore(self, vc_should_ignore):
        """Sets the vc_should_ignore of this Reputation.


        :param vc_should_ignore: The vc_should_ignore of this Reputation.  # noqa: E501
        :type: bool
        """

        self._vc_should_ignore = vc_should_ignore

    @property
    def vc_should_keep_item_legacy_prod_machine(self):
        """Gets the vc_should_keep_item_legacy_prod_machine of this Reputation.  # noqa: E501


        :return: The vc_should_keep_item_legacy_prod_machine of this Reputation.  # noqa: E501
        :rtype: bool
        """
        return self._vc_should_keep_item_legacy_prod_machine

    @vc_should_keep_item_legacy_prod_machine.setter
    def vc_should_keep_item_legacy_prod_machine(self, vc_should_keep_item_legacy_prod_machine):
        """Sets the vc_should_keep_item_legacy_prod_machine of this Reputation.


        :param vc_should_keep_item_legacy_prod_machine: The vc_should_keep_item_legacy_prod_machine of this Reputation.  # noqa: E501
        :type: bool
        """

        self._vc_should_keep_item_legacy_prod_machine = vc_should_keep_item_legacy_prod_machine

    @property
    def version(self):
        """Gets the version of this Reputation.  # noqa: E501


        :return: The version of this Reputation.  # noqa: E501
        :rtype: int
        """
        return self._version

    @version.setter
    def version(self, version):
        """Sets the version of this Reputation.


        :param version: The version of this Reputation.  # noqa: E501
        :type: int
        """

        self._version = version

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Reputation, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Reputation):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
