# coding: utf-8

"""
    Demisto API

    This is the public REST API to integrate with the demisto server. HTTP request can be sent using any HTTP-client.  For an example dedicated client take a look at: https://github.com/demisto/demisto-py.  Requests must include API-key that can be generated in the Demisto web client under 'Settings' -> 'Integrations' -> 'API keys'   Optimistic Locking and Versioning\\:  When using Demisto REST API, you will need to make sure to work on the latest version of the item (incident, entry, etc.), otherwise, you will get a DB version error (which not allow you to override a newer item). In addition, you can pass 'version\\: -1' to force data override (make sure that other users data might be lost).  Assume that Alice and Bob both read the same data from Demisto server, then they both changed the data, and then both tried to write the new versions back to the server. Whose changes should be saved? Alice’s? Bob’s? To solve this, each data item in Demisto has a numeric incremental version. If Alice saved an item with version 4 and Bob trying to save the same item with version 3, Demisto will rollback Bob request and returns a DB version conflict error. Bob will need to get the latest item and work on it so Alice work will not get lost.  Example request using 'curl'\\:  ``` curl 'https://hostname:443/incidents/search' -H 'content-type: application/json' -H 'accept: application/json' -H 'Authorization: <API Key goes here>' --data-binary '{\"filter\":{\"query\":\"-status:closed -category:job\",\"period\":{\"by\":\"day\",\"fromValue\":7}}}' --compressed ```  # noqa: E501

    OpenAPI spec version: 2.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class SectionItem(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'data': 'object',
        'display_type': 'str',
        'end_col': 'int',
        'field_id': 'str',
        'field_name': 'str',
        'field_type': 'str',
        'header_style': 'object',
        'index': 'int',
        'start_col': 'int'
    }

    attribute_map = {
        'data': 'data',
        'display_type': 'displayType',
        'end_col': 'endCol',
        'field_id': 'fieldId',
        'field_name': 'fieldName',
        'field_type': 'fieldType',
        'header_style': 'headerStyle',
        'index': 'index',
        'start_col': 'startCol'
    }

    def __init__(self, data=None, display_type=None, end_col=None, field_id=None, field_name=None, field_type=None, header_style=None, index=None, start_col=None):  # noqa: E501
        """SectionItem - a model defined in Swagger"""  # noqa: E501

        self._data = None
        self._display_type = None
        self._end_col = None
        self._field_id = None
        self._field_name = None
        self._field_type = None
        self._header_style = None
        self._index = None
        self._start_col = None
        self.discriminator = None

        if data is not None:
            self.data = data
        if display_type is not None:
            self.display_type = display_type
        if end_col is not None:
            self.end_col = end_col
        if field_id is not None:
            self.field_id = field_id
        if field_name is not None:
            self.field_name = field_name
        if field_type is not None:
            self.field_type = field_type
        if header_style is not None:
            self.header_style = header_style
        if index is not None:
            self.index = index
        if start_col is not None:
            self.start_col = start_col

    @property
    def data(self):
        """Gets the data of this SectionItem.  # noqa: E501


        :return: The data of this SectionItem.  # noqa: E501
        :rtype: object
        """
        return self._data

    @data.setter
    def data(self, data):
        """Sets the data of this SectionItem.


        :param data: The data of this SectionItem.  # noqa: E501
        :type: object
        """

        self._data = data

    @property
    def display_type(self):
        """Gets the display_type of this SectionItem.  # noqa: E501


        :return: The display_type of this SectionItem.  # noqa: E501
        :rtype: str
        """
        return self._display_type

    @display_type.setter
    def display_type(self, display_type):
        """Sets the display_type of this SectionItem.


        :param display_type: The display_type of this SectionItem.  # noqa: E501
        :type: str
        """

        self._display_type = display_type

    @property
    def end_col(self):
        """Gets the end_col of this SectionItem.  # noqa: E501


        :return: The end_col of this SectionItem.  # noqa: E501
        :rtype: int
        """
        return self._end_col

    @end_col.setter
    def end_col(self, end_col):
        """Sets the end_col of this SectionItem.


        :param end_col: The end_col of this SectionItem.  # noqa: E501
        :type: int
        """

        self._end_col = end_col

    @property
    def field_id(self):
        """Gets the field_id of this SectionItem.  # noqa: E501


        :return: The field_id of this SectionItem.  # noqa: E501
        :rtype: str
        """
        return self._field_id

    @field_id.setter
    def field_id(self, field_id):
        """Sets the field_id of this SectionItem.


        :param field_id: The field_id of this SectionItem.  # noqa: E501
        :type: str
        """

        self._field_id = field_id

    @property
    def field_name(self):
        """Gets the field_name of this SectionItem.  # noqa: E501


        :return: The field_name of this SectionItem.  # noqa: E501
        :rtype: str
        """
        return self._field_name

    @field_name.setter
    def field_name(self, field_name):
        """Sets the field_name of this SectionItem.


        :param field_name: The field_name of this SectionItem.  # noqa: E501
        :type: str
        """

        self._field_name = field_name

    @property
    def field_type(self):
        """Gets the field_type of this SectionItem.  # noqa: E501


        :return: The field_type of this SectionItem.  # noqa: E501
        :rtype: str
        """
        return self._field_type

    @field_type.setter
    def field_type(self, field_type):
        """Sets the field_type of this SectionItem.


        :param field_type: The field_type of this SectionItem.  # noqa: E501
        :type: str
        """

        self._field_type = field_type

    @property
    def header_style(self):
        """Gets the header_style of this SectionItem.  # noqa: E501


        :return: The header_style of this SectionItem.  # noqa: E501
        :rtype: object
        """
        return self._header_style

    @header_style.setter
    def header_style(self, header_style):
        """Sets the header_style of this SectionItem.


        :param header_style: The header_style of this SectionItem.  # noqa: E501
        :type: object
        """

        self._header_style = header_style

    @property
    def index(self):
        """Gets the index of this SectionItem.  # noqa: E501


        :return: The index of this SectionItem.  # noqa: E501
        :rtype: int
        """
        return self._index

    @index.setter
    def index(self, index):
        """Sets the index of this SectionItem.


        :param index: The index of this SectionItem.  # noqa: E501
        :type: int
        """

        self._index = index

    @property
    def start_col(self):
        """Gets the start_col of this SectionItem.  # noqa: E501


        :return: The start_col of this SectionItem.  # noqa: E501
        :rtype: int
        """
        return self._start_col

    @start_col.setter
    def start_col(self, start_col):
        """Sets the start_col of this SectionItem.


        :param start_col: The start_col of this SectionItem.  # noqa: E501
        :type: int
        """

        self._start_col = start_col

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(SectionItem, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SectionItem):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
