"""quarterly_analysis

Revision ID: 0cb6e9038375
Revises: 03025f750d7f
Create Date: 2025-04-05 09:52:09.959525

"""

from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision: str = "0cb6e9038375"
down_revision: Union[str, None] = "03025f750d7f"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("analysis", schema=None) as batch_op:
        batch_op.add_column(
            sa.Column("quarterly_positive_free_cash_flow", sa.Float(), nullable=True)
        )
        batch_op.add_column(
            sa.Column(
                "quarterly_growing_operating_cash_flow", sa.Float(), nullable=True
            )
        )
        batch_op.add_column(
            sa.Column(
                "quarterly_operating_cash_flow_is_higher_than_net_income",
                sa.Float(),
                nullable=True,
            )
        )
        batch_op.add_column(
            sa.Column("quarterly_mean_capex_ratio", sa.Float(), nullable=True)
        )
        batch_op.add_column(
            sa.Column("quarterly_max_capex_ratio", sa.Float(), nullable=True)
        )
        batch_op.add_column(
            sa.Column("quarterly_min_capex_ratio", sa.Float(), nullable=True)
        )
        batch_op.add_column(
            sa.Column("quarterly_mean_dividend_payout_ratio", sa.Float(), nullable=True)
        )
        batch_op.add_column(
            sa.Column("quarterly_max_dividend_payout_ratio", sa.Float(), nullable=True)
        )
        batch_op.add_column(
            sa.Column("quarterly_min_dividend_payout_ratio", sa.Float(), nullable=True)
        )
        batch_op.add_column(
            sa.Column("quarterly_positive_net_income", sa.Float(), nullable=True)
        )
        batch_op.add_column(
            sa.Column("quarterly_positive_operating_income", sa.Float(), nullable=True)
        )
        batch_op.add_column(
            sa.Column("quarterly_growing_net_income", sa.Float(), nullable=True)
        )
        batch_op.add_column(
            sa.Column("quarterly_growing_operating_income", sa.Float(), nullable=True)
        )
        batch_op.add_column(
            sa.Column("quarterly_positive_diluted_eps", sa.Float(), nullable=True)
        )
        batch_op.add_column(
            sa.Column("quarterly_positive_basic_eps", sa.Float(), nullable=True)
        )
        batch_op.add_column(
            sa.Column("quarterly_growing_basic_eps", sa.Float(), nullable=True)
        )
        batch_op.add_column(
            sa.Column("quarterly_growing_diluted_eps", sa.Float(), nullable=True)
        )
        batch_op.add_column(
            sa.Column("quarterly_positive_debt_to_equity", sa.Float(), nullable=True)
        )
        batch_op.add_column(
            sa.Column("quarterly_positive_return_on_assets", sa.Float(), nullable=True)
        )
        batch_op.add_column(
            sa.Column("quarterly_positive_return_on_equity", sa.Float(), nullable=True)
        )
        batch_op.add_column(
            sa.Column("quarterly_earning_per_share", sa.Float(), nullable=True)
        )

    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("analysis", schema=None) as batch_op:
        batch_op.drop_column("quarterly_earning_per_share")
        batch_op.drop_column("quarterly_positive_return_on_equity")
        batch_op.drop_column("quarterly_positive_return_on_assets")
        batch_op.drop_column("quarterly_positive_debt_to_equity")
        batch_op.drop_column("quarterly_growing_diluted_eps")
        batch_op.drop_column("quarterly_growing_basic_eps")
        batch_op.drop_column("quarterly_positive_basic_eps")
        batch_op.drop_column("quarterly_positive_diluted_eps")
        batch_op.drop_column("quarterly_growing_operating_income")
        batch_op.drop_column("quarterly_growing_net_income")
        batch_op.drop_column("quarterly_positive_operating_income")
        batch_op.drop_column("quarterly_positive_net_income")
        batch_op.drop_column("quarterly_min_dividend_payout_ratio")
        batch_op.drop_column("quarterly_max_dividend_payout_ratio")
        batch_op.drop_column("quarterly_mean_dividend_payout_ratio")
        batch_op.drop_column("quarterly_min_capex_ratio")
        batch_op.drop_column("quarterly_max_capex_ratio")
        batch_op.drop_column("quarterly_mean_capex_ratio")
        batch_op.drop_column("quarterly_operating_cash_flow_is_higher_than_net_income")
        batch_op.drop_column("quarterly_growing_operating_cash_flow")
        batch_op.drop_column("quarterly_positive_free_cash_flow")

    # ### end Alembic commands ###
