"""price growth

Revision ID: 2cd5a53f0181
Revises: bca09d7be748
Create Date: 2025-06-05 17:05:20.013415

"""

from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa
import sqlmodel

# revision identifiers, used by Alembic.
revision: str = "2cd5a53f0181"
down_revision: Union[str, None] = "bca09d7be748"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "financialstracker",
        sa.Column("exchange", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("source", sqlmodel.sql.sqltypes.AutoString(), nullable=False),
        sa.Column("symbol", sqlmodel.sql.sqltypes.AutoString(), nullable=False),
        sa.Column("date", sa.Date(), nullable=False),
        sa.Column("id", sa.Integer(), nullable=False),
        sa.PrimaryKeyConstraint("id"),
        sqlite_autoincrement=True,
    )
    with op.batch_alter_table("financialstracker", schema=None) as batch_op:
        batch_op.create_index(
            batch_op.f("ix_financialstracker_source"), ["source"], unique=False
        )
        batch_op.create_index(
            batch_op.f("ix_financialstracker_symbol"), ["symbol"], unique=False
        )

    op.create_table(
        "pricetracker",
        sa.Column("exchange", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("source", sqlmodel.sql.sqltypes.AutoString(), nullable=False),
        sa.Column("symbol", sqlmodel.sql.sqltypes.AutoString(), nullable=False),
        sa.Column("date", sa.Date(), nullable=False),
        sa.Column("id", sa.Integer(), nullable=False),
        sa.PrimaryKeyConstraint("id"),
        sqlite_autoincrement=True,
    )
    with op.batch_alter_table("pricetracker", schema=None) as batch_op:
        batch_op.create_index(
            batch_op.f("ix_pricetracker_source"), ["source"], unique=False
        )
        batch_op.create_index(
            batch_op.f("ix_pricetracker_symbol"), ["symbol"], unique=False
        )

    with op.batch_alter_table("tracker", schema=None) as batch_op:
        batch_op.drop_index(batch_op.f("ix_tracker_source"))
        batch_op.drop_index(batch_op.f("ix_tracker_symbol"))

    op.drop_table("tracker")
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "tracker",
        sa.Column("financials", sa.BOOLEAN(), nullable=False),
        sa.Column("price", sa.BOOLEAN(), nullable=False),
        sa.Column("exchange", sa.VARCHAR(), nullable=True),
        sa.Column("source", sa.VARCHAR(), nullable=False),
        sa.Column("symbol", sa.VARCHAR(), nullable=False),
        sa.Column("price_date", sa.DATE(), nullable=True),
        sa.Column("id", sa.INTEGER(), nullable=False),
        sa.PrimaryKeyConstraint("id"),
    )
    with op.batch_alter_table("tracker", schema=None) as batch_op:
        batch_op.create_index(batch_op.f("ix_tracker_symbol"), ["symbol"], unique=False)
        batch_op.create_index(batch_op.f("ix_tracker_source"), ["source"], unique=False)

    with op.batch_alter_table("pricetracker", schema=None) as batch_op:
        batch_op.drop_index(batch_op.f("ix_pricetracker_symbol"))
        batch_op.drop_index(batch_op.f("ix_pricetracker_source"))

    op.drop_table("pricetracker")
    with op.batch_alter_table("financialstracker", schema=None) as batch_op:
        batch_op.drop_index(batch_op.f("ix_financialstracker_symbol"))
        batch_op.drop_index(batch_op.f("ix_financialstracker_source"))

    op.drop_table("financialstracker")
    # ### end Alembic commands ###
