"""Add view

Revision ID: 732544581a65
Revises: 51d6e76a514e
Create Date: 2025-03-30 16:11:06.607416

"""

from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa
import sqlmodel


# revision identifiers, used by Alembic.
revision: str = "732544581a65"
down_revision: Union[str, None] = "51d6e76a514e"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "view",
        sa.Column("symbol", sqlmodel.sql.sqltypes.AutoString(), nullable=False),
        sa.Column("exchange", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("source", sqlmodel.sql.sqltypes.AutoString(), nullable=False),
        sa.Column("date", sa.Date(), nullable=False),
        sa.Column("created_at", sa.Date(), nullable=False),
        sa.Column("name", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("isin", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("view_name", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("id", sa.Integer(), nullable=False),
        sa.PrimaryKeyConstraint("id"),
        sqlite_autoincrement=True,
    )
    with op.batch_alter_table("view", schema=None) as batch_op:
        batch_op.create_index(batch_op.f("ix_view_source"), ["source"], unique=False)
        batch_op.create_index(batch_op.f("ix_view_symbol"), ["symbol"], unique=False)

    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("view", schema=None) as batch_op:
        batch_op.drop_index(batch_op.f("ix_view_symbol"))
        batch_op.drop_index(batch_op.f("ix_view_source"))

    op.drop_table("view")
    # ### end Alembic commands ###
